/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Object','jquery.sap.act','jquery.sap.script'],function(q,B){"use strict";var l=q.sap.log.getLogger("sap.ui.core.ResizeHandler",q.sap.log.Level.ERROR);function a(o,m){var F=sap.ui.require(m);return typeof F==='function'&&(o instanceof F);}var c=null;var R=B.extend("sap.ui.core.ResizeHandler",{constructor:function(C){B.apply(this);c=C;this.aResizeListeners=[];this.bRegistered=false;this.iIdCounter=0;this.fDestroyHandler=this.destroy.bind(this);q(window).bind("unload",this.fDestroyHandler);q.sap.act.attachActivate(d,this);}});function b(){if(this.bRegistered){this.bRegistered=false;sap.ui.getCore().detachIntervalTimer(this.checkSizes,this);}}function d(){if(!this.bRegistered&&this.aResizeListeners.length>0){this.bRegistered=true;sap.ui.getCore().attachIntervalTimer(this.checkSizes,this);}}R.prototype.destroy=function(e){q.sap.act.detachActivate(d,this);q(window).unbind("unload",this.fDestroyHandler);c=null;this.aResizeListeners=[];b.call(this);};R.prototype.attachListener=function(r,h){var i=a(r,'sap/ui/core/Control'),D=i?r.getDomRef():r,w=D?D.offsetWidth:0,H=D?D.offsetHeight:0,I="rs-"+Date.now()+"-"+this.iIdCounter++,e;if(i){e=("Control "+r.getId());}else if(r.id){e=r.id;}else{e=String(r);}this.aResizeListeners.push({sId:I,oDomRef:i?null:r,oControl:i?r:null,fHandler:h,iWidth:w,iHeight:H,dbg:e});l.debug("registered "+e);d.call(this);return I;};R.prototype.detachListener=function(I){var r=this.aResizeListeners;for(var i=0;i<r.length;i++){if(r[i].sId===I){r.splice(i,1);l.debug("deregistered "+I);break;}}if(r.length===0){b.call(this);}};R.prototype.checkSizes=function(){var D=l.isLoggable();if(D){l.debug("checkSizes:");}this.aResizeListeners.forEach(function(r){if(r){var C=!!r.oControl,o=C?r.oControl.getDomRef():r.oDomRef;if(o&&q.contains(document.documentElement,o)){var O=r.iWidth,i=r.iHeight,n=o.offsetWidth,N=o.offsetHeight;if(O!=n||i!=N){r.iWidth=n;r.iHeight=N;var e=q.Event("resize");e.target=o;e.currentTarget=o;e.size={width:n,height:N};e.oldSize={width:O,height:i};e.control=C?r.oControl:null;if(D){l.debug("resize detected for '"+r.dbg+"': "+e.oldSize.width+"x"+e.oldSize.height+" -> "+e.size.width+"x"+e.size.height);}r.fHandler(e);}}}});if(R._keepActive!=true&&R._keepActive!=false){R._keepActive=false;}if(!q.sap.act.isActive()&&!R._keepActive){b.call(this);}};R.register=function(r,h){if(!c||!c.oResizeHandler){return null;}return c.oResizeHandler.attachListener(r,h);};R.deregister=function(i){if(!c||!c.oResizeHandler){return;}c.oResizeHandler.detachListener(i);};R.deregisterAllForControl=function(C){if(!c||!c.oResizeHandler){return;}c.oResizeHandler.aResizeListeners.filter(function(r){return r&&r.oControl&&r.oControl.getId()===C;}).forEach(function(r){R.deregister(r.sId);});};return R;});
