/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorLocalStorage',["sap/ui/fl/FakeLrepLocalStorage","sap/ui/fl/FakeLrepConnector","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Utils"],function(F,a,L,C,b,U){"use strict";c._oBackendInstances={};
function c(s){this.mSettings=jQuery.extend({"isKeyUser":true,"isAtoAvailable":false,"isProductiveSystem":false},s);}
jQuery.extend(c.prototype,a.prototype);
c.prototype.create=function(v){var r;if(Array.isArray(v)){r=v.map(function(m){return this._saveChange(m);}.bind(this));}else{r=this._saveChange(v);}return Promise.resolve({response:r,status:'success'});};
c.prototype._saveChange=function(m){if(!m.creation){m.creation=new Date().toISOString();}F.saveChange(m.fileName,m);return m;};
c.prototype.update=function(m,s,d,i){return Promise.resolve({response:this._saveChange(m),status:'success'});};
c.prototype.deleteChange=function(o){F.deleteChange(o.sChangeName);return Promise.resolve({response:undefined,status:"nocontent"});};
c.prototype.deleteChanges=function(){F.deleteChanges();return Promise.resolve({response:undefined,status:"nocontent"});};
c.prototype.loadChanges=function(s){var d=F.getChanges();return new Promise(function(r,e){var R={};if(this.mSettings.sInitialComponentJsonPath){jQuery.getJSON(this.mSettings.sInitialComponentJsonPath).done(function(o){R={changes:o,componentClassName:s};r(R);}).fail(function(f){e(f);});}else{r(R);}}.bind(this)).then(function(r){var v=[];var e=[];var f=[];d.forEach(function(o){if(o.fileType==="ctrl_variant"&&o.variantManagementReference){v.push(o);}else if(o.fileType==="ctrl_variant_change"){e.push(o);}else{f.push(o);}});r=this._createChangesMap(r,v);r=this._sortChanges(r,f,e);r=this._assignVariantReferenceChanges(r);r.changes.contexts=[];r.changes.settings=this.mSettings;r.componentClassName=s;return r;}.bind(this));};
c.prototype._createChangesMap=function(r,v){if(!r||!r.changes){r={changes:{}};}if(!r.changes.changes){r.changes.changes=[];}if(!r.changes.variantSection){r.changes.variantSection={};}var f=function(e,n){return e.some(function(o){return o.content.fileName===n.fileName;});};var V={};v.forEach(function(o){V=r.changes.variantSection[o.variantManagementReference];if(!V){V={variants:[{content:o,changes:[],variantChanges:{setTitle:[]}}],defaultVariant:o.fileName};r.changes.variantSection[o.variantManagementReference]=V;}else{if(!f(V.variants,o)){V.variants.push({content:o,changes:[],variantChanges:{setTitle:[]}});}}});return r;};
c.prototype._assignVariantReferenceChanges=function(r){Object.keys(r.changes.variantSection).forEach(function(v){var V=r.changes.variantSection[v].variants;V.forEach(function(o){var s=o.content.variantReference;var e=o.changes;if(s){e=this._getReferencedChanges(r,o).concat(e);}o.changes=e;}.bind(this));}.bind(this));return r;};
c.prototype._getReferencedChanges=function(r,o){var R=[];r.changes.variantSection[o.content.variantManagementReference].variants.some(function(v){if(o.content.variantReference===v.content.fileName){R=v.changes.filter(function(d){return U.isLayerAboveCurrentLayer(d.layer)===-1;});if(v.content.variantReference){R=R.concat(this._getReferencedChanges(r,v));}return true;}}.bind(this));return R;};
c.prototype._sortChanges=function(r,d,e){var A=function(r,v,o){r.changes.variantSection[v].variants.some(function(V){if(V.content.fileName===o.variantReference){V.changes.push(o);return true;}});};var f=function(r,v,V){r.changes.variantSection[v].variants.some(function(o){if(o.content.fileName===V.variantReference){o.variantChanges[V.changeType].push(V);return true;}});};d.forEach(function(o){if(!o.variantReference){r.changes.changes.push(o);}else{Object.keys(r.changes.variantSection).forEach(function(v){A(r,v,o);});}});e.forEach(function(v){Object.keys(r.changes.variantSection).forEach(function(V){f(r,V,v);});});return r;};
c.prototype.loadSettings=function(){return new Promise(function(r,d){var s={};r(s);});};
c.enableFakeConnector=function(s,A,d){s=s||{};function r(){c.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!c._oFakeInstance){c._oFakeInstance=new c(s);}return c._oFakeInstance;};}if(A&&d){var o=b.getChangePersistenceForComponent(A,d);if(!(o._oConnector instanceof c)){C.clearEntry(A,d);if(!c._oBackendInstances[A]){c._oBackendInstances[A]={};}c._oBackendInstances[A][d]=o._oConnector;o._oConnector=new c(s);}r();return;}C.clearEntries();if(c.enableFakeConnector.original){return;}r();};
c.disableFakeConnector=function(A,s){function r(){if(c.enableFakeConnector.original){L.createConnector=c.enableFakeConnector.original;c.enableFakeConnector.original=undefined;c._oFakeInstance=undefined;}}if(A&&s){var o=b.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof L)){C.clearEntry(A,s);if(c._oBackendInstances[A]&&c._oBackendInstances[A][s]){o._oConnector=c._oBackendInstances[A][s];c._oBackendInstances[A][s]=undefined;}}r();return;}C.clearEntries();r();};
return c;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepLocalStorage',[],function(){"use strict";var F="sap.ui.fl.change";var a="sap.ui.fl.variant";var b={};
b.createChangeKey=function(i){if(i){return F+"."+i;}};
b.createVariantKey=function(i){if(i){return a+"."+i;}};
b.forEachLrepChangeInLocalStorage=function(p){for(var k in window.localStorage){if(k.indexOf(F)>-1||k.indexOf(a)>-1){p(k);}}};
b.getChange=function(i){if(i){var c=window.localStorage.getItem(this.createChangeKey(i));return JSON.parse(c);}};
b.getChanges=function(){var c=[],C;this.forEachLrepChangeInLocalStorage(function(k){C=JSON.parse(window.localStorage[k]);c.push(C);});return c;};
b.getNumChanges=function(){var c=0;this.forEachLrepChangeInLocalStorage(function(k){c++;});return c;};
b._aModifyCallbacks=[];
b.attachModifyCallback=function(c){this._aModifyCallbacks.push(c);};
b.detachModifyCallback=function(c){var i=this._aModifyCallbacks.indexOf(c);if(i!==-1){this._aModifyCallbacks.splice(i,1);}};
b._callModifyCallbacks=function(m){this._aModifyCallbacks.forEach(function(c){c(m);});};
b.deleteChange=function(i){if(i){window.localStorage.removeItem(this.createChangeKey(i));}this._callModifyCallbacks("delete");};
b.deleteChanges=function(){this.forEachLrepChangeInLocalStorage(function(k){window.localStorage.removeItem(k);});this._callModifyCallbacks("delete");};
b.saveChange=function(i,c){var C,s;if(i&&c){if(c.fileType==="ctrl_variant"&&c.variantManagementReference){C=this.createVariantKey(i);}else{C=this.createChangeKey(i);}s=JSON.stringify(c);window.localStorage.setItem(C,s);}this._callModifyCallbacks("save");};
return b;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantManagement.designtime',[],function(){"use strict";return{annotations:{},properties:{showExecuteOnSelection:{ignore:false},showShare:{ignore:false},showSetAsDefault:{ignore:false},showFavorites:{ignore:false},industrySolutionMode:{ignore:false},vendorLayer:{ignore:false},manualVariantKey:{ignore:false},showSave:{ignore:false},showSaveAs:{ignore:false},showManage:{ignore:false},showVariantListFooter:{ignore:false},inErrorState:{ignore:false}},customData:{}};},false);
sap.ui.predefine('sap/ui/fl/variants/VariantManagement',['jquery.sap.global','../transport/TransportSelection','sap/ui/model/Context','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/Device','sap/ui/core/TextAlign','sap/ui/core/InvisibleText','sap/ui/core/Control','sap/ui/core/Icon','sap/ui/core/ValueState','sap/ui/layout/HorizontalLayout','sap/ui/layout/Grid','sap/m/SearchField','sap/m/RadioButton','sap/m/ScreenSize','sap/m/PopinDisplay','sap/m/ColumnListItem','sap/m/Column','sap/m/Text','sap/m/Bar','sap/m/Table','sap/m/Page','sap/m/PlacementType','sap/m/ButtonType','sap/m/Toolbar','sap/m/ToolbarSpacer','sap/m/Button','sap/m/CheckBox','sap/m/Dialog','sap/m/Input','sap/m/Label','sap/m/Title','sap/m/ResponsivePopover','sap/m/SelectList','sap/m/ObjectIdentifier','sap/m/OverflowToolbar','sap/m/OverflowToolbarPriority','sap/m/OverflowToolbarLayoutData','sap/m/VBox','sap/ui/fl/Utils','../changeHandler/BaseTreeModifier'],function(q,T,C,J,F,D,a,I,b,c,V,H,G,S,R,d,P,e,f,g,B,h,i,j,k,l,m,n,o,p,r,L,s,t,u,O,v,w,x,y,z,A){"use strict";
var E=b.extend("sap.ui.fl.variants.VariantManagement",{
metadata:{library:"sap.ui.fl",designTime:true,properties:{showExecuteOnSelection:{type:"boolean",group:"Misc",defaultValue:false},showShare:{type:"boolean",group:"Misc",defaultValue:false},showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},showFavorites:{type:"boolean",group:"Misc",defaultValue:false},industrySolutionMode:{type:"boolean",group:"Misc",defaultValue:false},vendorLayer:{type:"boolean",group:"Misc",defaultValue:false},manualVariantKey:{type:"boolean",group:"Misc",defaultValue:false},showSave:{type:"boolean",group:"Misc",defaultValue:true},showSaveAs:{type:"boolean",group:"Misc",defaultValue:true},showManage:{type:"boolean",group:"Misc",defaultValue:true},showVariantListFooter:{type:"boolean",group:"Misc",defaultValue:true},inErrorState:{type:"boolean",group:"Misc",defaultValue:false}},associations:{"for":{type:"sap.ui.core.Control",multiple:true}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"},global:{type:"boolean"},lifecyclePackage:{type:"string"},lifecycleTransportId:{type:"string"}}},manage:{}}},
renderer:function(K,M){K.write("<div ");K.writeControlData(M);K.addClass("sapUiFlVarMngmt");K.writeClasses();var N={"labelledby":{value:M.oVariantInvisibleText.getId(),append:true}};K.writeAccessibilityState(M,N);var Q=M._oRb.getText("VARIANT_MANAGEMENT_TRIGGER_TT");K.write(" title='"+Q+"'");K.write(" tabindex='0'>");K.renderControl(M.oVariantLayout);K.write("</div>");}
});
E.MODEL_NAME="$FlexVariants";E.INNER_MODEL_NAME="$sapUiFlVariants";E.MAX_NAME_LEN=100;E.COLUMN_FAV_IDX=0;E.COLUMN_NAME_IDX=1;
E.prototype.init=function(){this.attachModelContextChange(this._setModel,this);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._createInnerModel();this.oVariantInvisibleText=new I({text:{parts:[{path:'currentVariant',model:E.MODEL_NAME},{path:"modified",model:E.MODEL_NAME}],formatter:function(N,Q){if(Q){N=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT_MOD",[N]);}else{N=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT",[N]);}}.bind(this)}});this.oVariantText=new s(this.getId()+"-text",{text:{path:'currentVariant',model:E.MODEL_NAME,formatter:function(N){var Q=this.getSelectedVariantText(N);return Q;}.bind(this)}});this.oVariantText.addStyleClass("sapUiFlVarMngmtClickable");this.oVariantText.addStyleClass("sapMTitleStyleH4");this.oVariantText.addStyleClass("sapUiFlVarMngmtTitle");if(D.system.phone){this.oVariantText.addStyleClass("sapUiFlVarMngmtTextMaxWidth");}var K=new L(this.getId()+"-modified",{text:"*",visible:{path:"modified",model:E.MODEL_NAME,formatter:function(N){return(N===null||N===undefined)?false:N;}}});K.setVisible(false);K.addStyleClass("sapUiFlVarMngmtModified");K.addStyleClass("sapUiFlVarMngmtClickable");K.addStyleClass("sapUiFlVarMngmtClickableHover");var M=new c(this.getId()+"-trigger",{src:"sap-icon://slim-arrow-down"});M.addStyleClass("sapUiFlVarMngmtTriggerBtn");this.oVariantLayout=new H({content:[this.oVariantText,K,M,this.oVariantInvisibleText]});this.oVariantLayout.addStyleClass("sapUiFlVarMngmtLayout");this.addDependent(this.oVariantLayout);};
E.prototype.getTitle=function(){return this.oVariantText;};
E.prototype._createInnerModel=function(){var M=new J({showManage:true,showSave:true,showSaveAs:true,showExecuteOnSelection:false,showShare:false,showSetAsDefault:true,showFavorites:false});this.setModel(M,E.INNER_MODEL_NAME);this._bindProperties();};
E.prototype._bindProperties=function(){this.bindProperty("showManage",{path:"/showManage",model:E.INNER_MODEL_NAME});this.bindProperty("showSave",{path:"/showSave",model:E.INNER_MODEL_NAME});this.bindProperty("showSaveAs",{path:"/showSaveAs",model:E.INNER_MODEL_NAME});this.bindProperty("showShare",{path:"/showShare",model:E.INNER_MODEL_NAME});this.bindProperty("showExecuteOnSelection",{path:"/showExecuteOnSelection",model:E.INNER_MODEL_NAME});this.bindProperty("showShare",{path:"/showShare",model:E.INNER_MODEL_NAME});this.bindProperty("showSetAsDefault",{path:"/showSetAsDefault",model:E.INNER_MODEL_NAME});this.bindProperty("showFavorites",{path:"/showFavorites",model:E.INNER_MODEL_NAME});this.bindProperty("showVariantListFooter",{path:"/showVariantListFooter",model:E.INNER_MODEL_NAME});};
E.prototype.setInitialDefaultVariantKey=function(K){this._sInitialDefaultVariantKey=K;};
E.prototype.getInitialDefaultVariantKey=function(){return this._sInitialDefaultVariantKey;};
E.prototype.setDefaultVariantKey=function(K){var M=this.getModel(E.MODEL_NAME);if(M&&this.oContext){M.setProperty(this.oContext+"/defaultVariant",K);}};
E.prototype.getDefaultVariantKey=function(){var M=this.getModel(E.MODEL_NAME);if(M&&this.oContext){return M.getProperty(this.oContext+"/defaultVariant");}return null;};
E.prototype.setSelectedVariantKey=function(K){var M,N=this.getModel(E.MODEL_NAME);if(N&&this.oContext){M=this._getLocalId();N.updateCurrentVariant(M,K);}return this;};
E.prototype.getSelectedVariantKey=function(){var M=this.getModel(E.MODEL_NAME);if(M&&this.oContext){return M.getProperty(this.oContext+"/currentVariant");}return null;};
E.prototype.getVariants=function(){return this._getItems();};
E.prototype.setModified=function(K){var M=this.getModel(E.MODEL_NAME);if(M&&this.oContext){M.setProperty(this.oContext+"/modified",K);}};
E.prototype.getModified=function(){var M=this.getModel(E.MODEL_NAME);if(M&&this.oContext){return M.getProperty(this.oContext+"/modified");}return false;};
E.prototype.getSelectedVariantText=function(K){var M=this._getItemByKey(K);if(M){return M.title;}return"";};
E.prototype.getStandardVariantKey=function(){var K=this._getItems();if(K&&K[0]){return K[0].key;}return null;};
E.prototype._getItems=function(){var K=[];if(this.oContext&&this.oContext.getObject()){K=this.oContext.getObject().variants;}return K;};
E.prototype._getItemByKey=function(K){var M=null,N=this._getItems();N.some(function(Q){if(Q.key===K){M=Q;}return(M!=null);});return M;};
E.prototype._setBindingContext=function(){var M,K;if(!this.oContext){M=this.getModel(E.MODEL_NAME);if(M){K=this._getLocalId();if(K){M.ensureStandardEntryExists(K);this.oContext=new C(M,"/"+K);this.setBindingContext(this.oContext,E.MODEL_NAME);}}}};
E.prototype._getLocalId=function(){return A.getSelector(this,z.getComponentForControl(this)).id;};
E.prototype._setModel=function(){this._setBindingContext();};
E.prototype.handleOpenCloseVariantPopover=function(){if(!this.bPopoverOpen){this._openVariantList();}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close();}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close();}};
E.prototype.onclick=function(K){this.handleOpenCloseVariantPopover();};
E.prototype.onkeydown=function(K){if(K.which===q.sap.KeyCodes.F4||K.which===q.sap.KeyCodes.SPACE||K.altKey===true&&K.which===q.sap.KeyCodes.ARROW_UP||K.altKey===true&&K.which===q.sap.KeyCodes.ARROW_DOWN){this._openVariantList();}};
E.prototype._openInErrorState=function(){var K;if(!this.oErrorVariantPopOver){if(this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close();return;}K=new y({fitContainer:true,alignItems:sap.m.FlexAlignItems.Center,items:[new c({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new s({titleStyle:sap.ui.core.TitleLevel.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new g({textAlign:sap.ui.core.TextAlign.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});K.addStyleClass("sapUiFlVarMngmtErrorPopover");this.oErrorVariantPopOver=new t(this.getId()+"-errorpopover",{title:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS"),contentWidth:"400px",placement:j.Bottom,content:[new i(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[K]})],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),100);}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.addStyleClass("sapUiFlVarMngmtPopover");}if(this.bPopoverOpen){return;}this.bPopoverOpen=true;this.oErrorVariantPopOver.openBy(this.oVariantLayout);};
E.prototype._createVariantList=function(){if(!this.oContext||this.oVariantPopOver){return;}var K=new n(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog();}.bind(this),layoutData:new x({priority:w.Low}),visible:{path:"/showManage",model:E.INNER_MODEL_NAME}});this.oVariantSaveBtn=new n(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave();}.bind(this),enabled:{path:"modified",model:E.MODEL_NAME,formatter:function(Q){return Q;}},layoutData:new x({priority:w.Low}),visible:{path:"/showSave",model:E.INNER_MODEL_NAME}});this.oVariantSaveAsBtn=new n(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog();}.bind(this),layoutData:new x({priority:w.Low}),visible:{path:"/showSaveAs",model:E.INNER_MODEL_NAME}});this._oVariantList=new u(this.getId()+"-list",{selectedKey:{path:"currentVariant",model:E.MODEL_NAME},itemPress:function(Q){var U=null;if(Q&&Q.getParameters()){var W=Q.getParameters().item;if(W){U=W.getKey();}}if(U){this.setSelectedVariantKey(U);this.oVariantPopOver.close();}}.bind(this)});this._oVariantList.setNoDataText(this._oRb.getText("VARIANT_MANAGEMENT_NODATA"));var M=new sap.ui.core.Item({key:'{'+E.MODEL_NAME+">key}",text:'{'+E.MODEL_NAME+">title}"});this._oVariantList.bindAggregation("items",{path:"variants",model:E.MODEL_NAME,template:M});if(this.getModified()){var N=this._getItemByKey(this.getSelectedVariantKey());if(N){if(!N.readOnly||(this._isIndustrySolutionModeAndVendorLayer()&&(this.getStandardVariantKey()===N.key))){this.oVariantSaveBtn.setEnabled(true);}}}this._oSearchField=new S(this.getId()+"-search");this._oSearchField.attachLiveChange(function(Q){this._triggerSearch(Q,this._oVariantList);}.bind(this));this.oVariantSelectionPage=new i(this.getId()+"-selpage",{subHeader:new l({content:[this._oSearchField]}),content:[this._oVariantList],footer:new v({content:[new m(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,K]}),showNavButton:false,showHeader:false,showFooter:{path:"/showVariantListFooter",model:E.INNER_MODEL_NAME}});this.oVariantPopOver=new t(this.getId()+"-popover",{title:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS"),contentWidth:"400px",placement:j.Bottom,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),100);}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapUiFlVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oVariantPopOver);};
E.prototype._openVariantList=function(){var K;if(this.getInErrorState()){this._openInErrorState();return;}if(this.bPopoverOpen){return;}if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close();return;}this.bPopoverOpen=true;this._createVariantList();this._oSearchField.setValue("");this._oVariantList.getBinding("items").filter(this._getFilters());this.oVariantSelectionPage.setShowSubHeader(this._oVariantList.getItems().length>9?true:false);this.oVariantSaveBtn.setEnabled(false);this.oVariantSaveAsBtn.setEnabled(true);if(this._isIndustrySolutionModeAndVendorLayer()&&this.getManualVariantKey()&&(this.getStandardVariantKey()===this.getCurrentVariantKey())){this.oVariantSaveBtn.setEnabled(false);this.oVariantSaveAsBtn.setEnabled(true);}if(this.getModified()){K=this._getItemByKey(this.getSelectedVariantKey());if(!K.readOnly||(this._isIndustrySolutionModeAndVendorLayer()&&(this.getStandardVariantKey()===K.key))){this.oVariantSaveBtn.setEnabled(true);}}this.oVariantPopOver.openBy(this.oVariantLayout);};
E.prototype._triggerSearch=function(K,M){if(!K){return;}var N=K.getParameters();if(!N){return;}var Q=N.newValue?N.newValue:"";var U=new F({path:"title",operator:sap.ui.model.FilterOperator.Contains,value1:Q});M.getBinding("items").filter(this._getFilters(U));};
E.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new r(this.getId()+"-name",{liveChange:function(N){this._checkVariantNameConstraints(this.oInputName,this.oSaveSave);}.bind(this)});var K=new L(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME"),required:true});K.setLabelFor(this.oInputName);this.oDefault=new o(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/showSetAsDefault",model:E.INNER_MODEL_NAME},width:"100%"});this.oExecuteOnSelect=new o(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/showExecuteOnSelection",model:E.INNER_MODEL_NAME},width:"100%"});this.oShare=new o(this.getId()+"-share",{text:this._oRb.getText("VARIANT_MANAGEMENT_SHARE"),visible:{path:"/showShare",model:E.INNER_MODEL_NAME},select:function(N){this._handleShareSelected(N);}.bind(this),width:"100%"});this.oInputManualKey=new r(this.getId()+"-key",{liveChange:function(N){this._checkVariantNameConstraints(this.oInputManualKey);}.bind(this)});this.oLabelKey=new L(this.getId()+"-keylabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_KEY"),required:true});this.oLabelKey.setLabelFor(this.oInputManualKey);this.oSaveSave=new n(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),press:function(){this._bSaveCanceled=false;this._handleVariantSaveAs(this.oInputName.getValue());}.bind(this),enabled:true});var M=new G({defaultSpan:"L6 M6 S12"});if(this.getShowSetAsDefault()){M.addContent(this.oDefault);}if(this.getShowShare()){M.addContent(this.oShare);}if(this.getShowExecuteOnSelection()){M.addContent(this.oExecuteOnSelect);}this.oSaveAsDialog=new p(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),beginButton:this.oSaveSave,endButton:new n(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._bSaveCanceled=true;this.oSaveAsDialog.close();}.bind(this)}),content:[K,this.oInputName,this.oLabelKey,this.oInputManualKey,M],stretch:D.system.phone});this.oSaveAsDialog.addStyleClass("sapUiPopupWithPadding");this.oSaveAsDialog.addStyleClass("sapUiFlVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oSaveAsDialog);}};
E.prototype._openSaveAsDialog=function(){this._createSaveAsDialog();this.oInputName.setValue(this.getSelectedVariantText(this.getSelectedVariantKey()));this.oSaveSave.setEnabled(false);this.oInputName.setEnabled(true);this.oInputName.setValueState(V.None);this.oInputName.setValueStateText(null);this.oDefault.setSelected(false);this.oShare.setSelected(false);this.oExecuteOnSelect.setSelected(false);if(this._isIndustrySolutionModeAndVendorLayer()&&this.getManualVariantKey()){this.oInputName.setValue(this._oRb.getText("VARIANT_MANAGEMENT_STANDARD"));this.oInputName.setEnabled(false);}if(this.oVariantPopOver){this.oVariantPopOver.close();}this.sTransport=null;this.sPackage=null;if(this.getManualVariantKey()){this.oInputManualKey.setVisible(true);this.oInputManualKey.setEnabled(true);this.oInputManualKey.setValueState(V.None);this.oInputManualKey.setValueStateText(null);this.oLabelKey.setVisible(true);}else{this.oInputManualKey.setVisible(false);this.oLabelKey.setVisible(false);}this.oSaveAsDialog.open();};
E.prototype._handleVariantSaveAs=function(N){var K=null,M=N.trim(),Q=this.oInputManualKey.getValue().trim(),U="",W="";if(M==""){this.oInputName.setValueState(V.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}if(this.getManualVariantKey()){if(Q==""){this.oInputManualKey.setValueState(V.Error);this.oInputManualKey.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}K=Q;}if(this.oSaveAsDialog){this.oSaveAsDialog.close();}if(this.oDefault.getSelected()){this.setDefaultVariantKey(K);}if(this.oShare.getSelected()){W=this.sPackage;U=this.sTransport;}this.setModified(false);this.fireSave({key:K,name:M,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected(),global:this.oShare.getSelected(),lifecyclePackage:W,lifecycleTransportId:U});};
E.prototype._handleVariantSave=function(){var K=this._getItemByKey(this.getSelectedVariantKey());var M=false;if(this.getDefaultVariantKey()===K.key){M=true;}if(K.global){var N=function(U,W){if(this.oVariantPopOver){this.oVariantPopOver.close();}this.sPackage=U;this.sTransport=W;this.fireSave({name:K.title,overwrite:true,key:K.key,def:M,global:this._isIndustrySolutionModeAndVendorLayer(),lifecyclePackage:this.sPackage,lifecycleTransportId:this.sTransport});}.bind(this);var Q=function(U){this.sTransport=null;this.sPackage=null;}.bind(this);this._assignTransport(K,N,Q);}else{if(this.oVariantPopOver){this.oVariantPopOver.close();}this.fireSave({name:K.title,overwrite:true,key:K.key,def:M});}this.setModified(false);};
E.prototype._handleShareSelected=function(K){this.sTransport=null;this.sPackage=null;if(K.getParameters().selected){var M=function(Q,U){this.sTransport=U;this.sPackage=Q;}.bind(this);var N=function(Q){this.oShare.setSelected(false);this.sTransport=null;this.sPackage=null;}.bind(this);this._assignTransport(null,M,N);}};
E.prototype.openManagementDialog=function(K){if(K&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined;}this._openManagementDialog();};
E.prototype._triggerSearchInManageDialog=function(K,M){if(!K){return;}var N=K.getParameters();if(!N){return;}var Q=N.newValue?N.newValue:"";var U=[this._getFilterNotDeleted(),new F({filters:[new F({path:"title",operator:sap.ui.model.FilterOperator.Contains,value1:Q}),new F({path:"author",operator:sap.ui.model.FilterOperator.Contains,value1:Q})],and:false})];M.getBinding("items").filter(U);this._bDeleteOccured=true;};
E.prototype._createManagementDialog=function(){if(!this.oManagementDialog){this.oManagementTable=new h(this.getId()+"-managementTable",{growing:true,columns:[new f({width:"3rem",visible:{path:"/showFavorites",model:E.INNER_MODEL_NAME}}),new f({header:new g({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"14rem"}),new f({header:new g({text:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTTYPE")}),width:"8rem",demandPopin:true,popinDisplay:P.Inline,minScreenWidth:d.Tablet,visible:{path:"/showShare",model:E.INNER_MODEL_NAME}}),new f({header:new g({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT")}),width:"4rem",demandPopin:true,popinDisplay:P.Inline,minScreenWidth:d.Tablet,visible:{path:"/showSetAsDefault",model:E.INNER_MODEL_NAME}}),new f({header:new g({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT")}),width:"5rem",hAlign:a.Center,demandPopin:true,popinDisplay:P.Inline,minScreenWidth:"800px",visible:{path:"/showExecuteOnSelection",model:E.INNER_MODEL_NAME}}),new f({header:new g({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR")}),width:"8rem",demandPopin:true,popinDisplay:P.Inline,minScreenWidth:"900px"}),new f({width:"2rem",hAlign:a.Center}),new f({visible:false})]});this.oManagementSave=new n(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),enabled:true,press:function(){this._handleManageSavePressed();}.bind(this)});this.oManagementCancel=new n(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this.oManagementDialog.close();this._handleManageCancelPressed();}.bind(this)});this.oManagementDialog=new p(this.getId()+"-managementdialog",{customHeader:new B(this.getId()+"-managementHeader",{contentMiddle:[new g(this.getId()+"-managementHeaderText",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG")})]}),beginButton:this.oManagementSave,endButton:this.oManagementCancel,content:[this.oManagementTable],stretch:D.system.phone});this._oSearchFieldOnMgmtDialog=new S();this._oSearchFieldOnMgmtDialog.attachLiveChange(function(M){this._triggerSearchInManageDialog(M,this.oManagementTable);}.bind(this));var K=new B(this.getId()+"-mgmHeaderSearch",{contentRight:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(K);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"variants",model:E.MODEL_NAME,factory:this._templateFactoryManagementDialog.bind(this)});this.oManagementTable.getBinding("items").filter(this._getFilterNotDeleted());this._bDeleteOccured=false;}};
E.prototype._setFavoriteIcon=function(K,M){if(K){K.setSrc(M?"sap-icon://favorite":"sap-icon://unfavorite");K.setTooltip(this._oRb.getText(M?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));}};
E.prototype._templateFactoryManagementDialog=function(K,M){var N=null,Q,U,W,X,Y=M.getObject();if(!Y){return undefined;}var Z=function(f1){this._checkVariantNameConstraints(f1.oSource,this.oManagementSave,f1.oSource.getBindingContext(E.MODEL_NAME).getObject().key);}.bind(this);var $=function(f1){this._handleManageTitleChanged(f1.oSource.getBindingContext(E.MODEL_NAME).getObject());}.bind(this);var _=function(f1){if(f1.getParameters().selected===true){this._handleManageDefaultVariantChange(f1.oSource,f1.oSource.getBindingContext(E.MODEL_NAME).getObject());}}.bind(this);var a1=function(f1){this._handleManageExecuteOnSelectionChanged(f1.oSource.getBindingContext(E.MODEL_NAME).getObject());}.bind(this);var b1=function(f1){this._handleManageDeletePressed(f1.oSource.getBindingContext(E.MODEL_NAME).getObject());}.bind(this);var c1=function(f1){this._handleManageFavoriteChanged(f1.oSource,f1.oSource.getBindingContext(E.MODEL_NAME).getObject());}.bind(this);if(Y.key!==this.getStandardVariantKey()){if(Y.readOnly){N=this._oRb.getText("VARIANT_MANAGEMENT_WRONG_LAYER");}else if(Y.textReadOnly){N=this._oRb.getText("VARIANT_MANAGEMENT_WRONG_LANGUAGE");}}if((Y.key===this.getStandardVariantKey())||Y.readOnly||Y.textReadOnly){X=new O({title:'{'+E.MODEL_NAME+">title}"});if(N){X.setTooltip(N);}}else{X=new r({liveChange:Z,change:$,value:'{'+E.MODEL_NAME+">title}"});}U=new n({icon:"sap-icon://sys-cancel",enabled:true,type:k.Transparent,press:b1,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:!Y.readOnly});this._assignColumnInfoForDeleteButton(U);Q=(Y.readOnly===false);W=this.oContext.getPath();var d1=new c({src:{path:"favorite",model:E.MODEL_NAME,formatter:function(f1){return f1?"sap-icon://favorite":"sap-icon://unfavorite";}},tooltip:{path:'favorite',model:E.MODEL_NAME,formatter:function(f1){return this._oRb.getText(f1?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP");}.bind(this)},press:c1});d1.addStyleClass("sapUiFlVarMngmtFavColor");var e1=new e({cells:[d1,X,new g({text:this._oRb.getText(Y.global?"VARIANT_MANAGEMENT_SHARED":"VARIANT_MANAGEMENT_PRIVATE"),wrapping:false}),new R({groupName:this.getId(),select:_,selected:{path:W+"/defaultVariant",model:E.MODEL_NAME,formatter:function(f1){return(Y.key===f1)?true:false;}}}),new o({enabled:Q,select:a1,selected:'{'+E.MODEL_NAME+">executeOnSelect}"}),new g({text:'{'+E.MODEL_NAME+">author}",textAlign:"Begin"}),U,new g({text:'{'+E.MODEL_NAME+">key}"})]});return e1;};
E.prototype._openManagementDialog=function(){this._createManagementDialog();this.setInitialDefaultVariantKey(this.getDefaultVariantKey());if(this.oVariantPopOver){this.oVariantPopOver.close();}this.oManagementSave.setEnabled(false);this._oSearchFieldOnMgmtDialog.setValue("");if(this._bDeleteOccured){this._bDeleteOccured=false;this.oManagementTable.bindAggregation("items",{path:"variants",model:E.MODEL_NAME,factory:this._templateFactoryManagementDialog.bind(this)});this.oManagementTable.getBinding("items").filter(this._getFilterNotDeleted());}this.oManagementDialog.open();};
E.prototype._assignColumnInfoForDeleteButton=function(K){if(!this._oInvisibleDeleteColumnName){this._oInvisibleDeleteColumnName=new I({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")});this.oManagementDialog.addContent(this._oInvisibleDeleteColumnName);}if(this._oInvisibleDeleteColumnName){K.addAriaLabelledBy(this._oInvisibleDeleteColumnName);}};
E.prototype._handleManageDefaultVariantChange=function(K,M){var N=M.key;if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if(!M.favorite&&K){M.favorite=!M.favorite;this._setFavoriteIcon(K.getParent().getCells()[E.COLUMN_FAV_IDX],M.favorite);}this.setDefaultVariantKey(N);};
E.prototype._handleManageCancelPressed=function(){var K,M=this._getItems(),N;M.forEach(function(Q){Q.toBeDeleted=false;Q.title=Q.originalTitle;Q.favorite=Q.originalFavorite;Q.executeOnSelection=Q.originalExecuteOnSelection;});K=this.getInitialDefaultVariantKey();if(K!==this.getDefaultVariantKey()){this.setDefaultVariantKey(K);}N=this.getModel(E.MODEL_NAME);if(N){N.checkUpdate();}};
E.prototype._handleManageFavoriteChanged=function(K,M){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if((this.getDefaultVariantKey()===M.key)&&M.favorite){return;}M.favorite=!M.favorite;this._setFavoriteIcon(K,M.favorite);if(M.global){var N=function(U,W){M.lifecyclePackage=U;M.lifecycleTransportId=W;};var Q=function(U){M.favorite=M.originalFavorite;this._setFavoriteIcon(K,M.favorite);}.bind(this);this._assignTransport(M,N,Q);}};
E.prototype._handleManageDeletePressed=function(K){var M,N=K.key;if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}K.toBeDeleted=true;if((N===this.getDefaultVariantKey())){this.setDefaultVariantKey(this.getStandardVariantKey());}if(K.global){var Q=function(W,X){K.lifecyclePackage=W;K.lifecycleTransportId=X;};var U=function(W){K.toBeDeleted=false;};this._assignTransport(K,Q,U);}M=this.getModel(E.MODEL_NAME);if(M){M.checkUpdate();}};
E.prototype._handleManageExecuteOnSelectionChanged=function(K){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if(K.global){var M=function(Q,U){K.lifecyclePackage=Q;K.lifecycleTransportId=U;};var N=function(Q){K.executeOnSelection=K.originalExecuteOnSelection;};this._assignTransport(K,M,N);}};
E.prototype._handleManageTitleChanged=function(K){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if(!K.title.localeCompare(K.originalTitle)){if(K.global){var M=function(Q,U){K.lifecyclePackage=Q;K.lifecycleTransportId=U;};var N=function(Q){K.title=K.originalTitle;};this._assignTransport(K,M,N);}}};
E.prototype._handleManageSavePressed=function(){var K=this._getItems();this.fireManage();this.oManagementDialog.close();K.some(function(M){if(M.toBeDeleted){this._bDeleteOccured=true;if(M.key===this.getSelectedVariantKey()){this.setModified(false);this.setSelectedVariantKey(this.getStandardVariantKey());return true;}}return false;}.bind(this));};
E.prototype._anyInErrorState=function(M){var K,N,Q=false;if(M){K=M.getItems();K.some(function(U){N=U.getCells()[E.COLUMN_NAME_IDX];if(N&&N.getValueState&&(N.getValueState()===V.Error)){Q=true;}return Q;});}return Q;};
E.prototype._getFilters=function(K){var M=[];if(K){M.push(K);}M.push(this._getFilterNotDeleted());if(this.getShowFavorites()){M.push(this._getFilterFavorites());}return M;};
E.prototype._getFilterNotDeleted=function(){return new F({path:"toBeDeleted",operator:sap.ui.model.FilterOperator.NE,value1:true});};
E.prototype._getFilterFavorites=function(){return new F({path:"favorite",operator:sap.ui.model.FilterOperator.EQ,value1:true});};
E.prototype._checkVariantNameConstraints=function(K,M,N){if(!K){return;}var Q=K.getValue();Q=Q.trim();if(!this._checkIsDuplicate(Q,N)){if(Q===""){K.setValueState(V.Error);K.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));}else if(Q.length>E.MAX_NAME_LEN){K.setValueState(V.Error);K.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[E.MAX_NAME_LEN]));}else{K.setValueState(V.None);K.setValueStateText(null);}}else{K.setValueState(V.Error);K.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"));}if(M){if(K.getValueState()===V.Error){M.setEnabled(false);}else{M.setEnabled(true);}}};
E.prototype._checkIsDuplicate=function(K,M){var N=false,Q=this._getItems(),U=K.toLowerCase();Q.some(function(W){if(W.title.toLowerCase()===U){if(M&&(M===W.key)){return false;}N=true;}return N;});return N;};
E.prototype._isIndustrySolutionModeAndVendorLayer=function(){if(this.getIndustrySolutionMode()&&this.getVendorLayer()){return true;}return false;};
E.prototype._selectTransport=function(K,M,N,Q){var U=new T();U.selectTransport(K,M,N,Q);};
E.prototype._assignTransport=function(K,M,N){var Q=null;var U={type:"variant",name:"",namespace:"","package":""};if(K){U["package"]=K.lifecyclePackage;U["name"]=K.key;U["namespace"]=K.namespace;Q=K.lifecycleTransportId;}var _=function(Y){M(Y.getParameters().selectedPackage,Y.getParameters().selectedTransport);};var W=function(Y){N(Y);};if(Q!=null&&Q.trim().length>0){M(U["package"],Q);}else{var X=false;if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){X=true;}this._selectTransport(U,_,W,X);}};
E.prototype.exit=function(){if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy();}this.oDefault=undefined;if(this.oShare&&!this.oShare._bIsBeingDestroyed){this.oShare.destroy();}this.oShare=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy();}this.oExecuteOnSelect=undefined;this._oRb=undefined;this.oContext=undefined;this._oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantInvisibleText=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;};
return E;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantModel',["jquery.sap.global","sap/ui/model/json/JSONModel","sap/ui/fl/Utils","sap/ui/fl/changeHandler/BaseTreeModifier","sap/ui/fl/Change","sap/ui/fl/changeHandler/Base"],function(q,J,U,B,C,a){"use strict";
var V=J.extend("sap.ui.fl.variants.VariantModel",{constructor:function(d,f,c,o){this.pSequentialImportCompleted=Promise.resolve();J.apply(this,arguments);this.bObserve=o;this.oFlexController=f;this.oComponent=c;this.bStandardVariantExists=true;this.oVariantController=undefined;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");if(f&&f._oChangePersistence){this.oVariantController=f._oChangePersistence._oVariantController;}if(d&&typeof d=="object"){Object.keys(d).forEach(function(k){d[k].modified=false;d[k].variants.forEach(function(v){if(!d[k].currentVariant&&(v.key===d[k].defaultVariant)){d[k].currentVariant=v.key;}v.toBeDeleted=false;v.originalTitle=v.title;});});this.setData(d);}}});
V.prototype.updateCurrentVariant=function(v,n){return this._switchToVariant(v,n).then(function(){this.oData[v].currentVariant=n;this.refresh(true);}.bind(this));};
V.prototype.getCurrentVariantReference=function(v){return this.oData[v].currentVariant;};
V.prototype.getVariantManagementReference=function(v){var s="";var i=-1;Object.keys(this.oData).some(function(k){return this.oData[k].variants.some(function(o,b){if(o.key===v){s=k;i=b;return true;}});}.bind(this));return{variantManagementReference:s,variantIndex:i};};
V.prototype.getVariant=function(v){var s=this.getVariantManagementReference(v).variantManagementReference;return this.oVariantController.getVariant(s,v);};
V.prototype.getVariantProperty=function(v,p){return this.getVariant(v).content[p];};
V.prototype._addChange=function(c){var v=c.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;return this.oVariantController.addChangeToVariant(c,s,v);};
V.prototype._removeChange=function(c){var v=c.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;return this.oVariantController.removeChangeFromVariant(c,s,v);};
V.prototype._duplicateVariant=function(p){var n=p.newVariantReference,s=p.sourceVariantReference,S=this.getVariant(s);var d={content:{},changes:JSON.parse(JSON.stringify(S.changes)),variantChanges:{setTitle:[]}};var c=U.isLayerAboveCurrentLayer(S.content.layer);Object.keys(S.content).forEach(function(k){if(k==="fileName"){d.content[k]=n;}else if(k==="variantReference"){if(c===0){d.content[k]=S.content["variantReference"];}else if(c===-1){d.content[k]=s;}}else if(k==="layer"){d.content[k]=p.layer;}else if(k==="title"){d.content[k]=S.content[k]+" Copy";}else{d.content[k]=S.content[k];}});var v=d.changes.slice();var D={};d.changes=v.reduce(function(b,o){if(U.isLayerAboveCurrentLayer(o.layer)===0){D=q.extend(true,{},o);D.fileName=U.createDefaultFileName(o.changeType);D.variantReference=d.content.fileName;if(!D.support){D.support={};}D.support.sourceChangeFileName=o.fileName;b.push(D);}return b;},[]);return d;};
V.prototype._copyVariant=function(p){var d=this._duplicateVariant(p);var v=B.getSelector(p.variantManagementControl,p.appComponent).id;var o={author:p.layer,key:d.content.fileName,layer:p.layer,originalTitle:d.content.title,readOnly:false,title:d.content.title,toBeDeleted:false};var b=this.oFlexController.createVariant(d,this.oComponent);[b].concat(b.getChanges()).forEach(function(c){this.oFlexController._oChangePersistence.addDirtyChange(c);}.bind(this));var i=this.oVariantController.addVariantToVariantManagement(d,v);this.oData[v].variants.splice(i,0,o);return this.updateCurrentVariant(v,b.getId()).then(function(){this.checkUpdate();return b;}.bind(this));};
V.prototype._removeVariant=function(v,s,b){var c=this.oFlexController._oChangePersistence.getDirtyChanges().filter(function(o){return(o.getVariantReference&&o.getVariantReference()===v.getId())||o.getId()===v.getId();});c.forEach(function(o){this.oFlexController._oChangePersistence.deleteChange(o);}.bind(this));var i=this.oVariantController.removeVariantFromVariantManagement(v,b);this.oData[b].variants.splice(i,1);return this.updateCurrentVariant(b,s).then(function(){this.checkUpdate();}.bind(this));};
V.prototype._setVariantProperties=function(v,p,A){var i=this.getVariantManagementReference(p.variantReference).variantIndex;var d=this.getData();var n={title:p.title,layer:p.layer};var c=null;var o=d[v].variants[i];o.title=p.title;var s=this.oVariantController._setVariantData(n,v,i);d[v].variants.splice(i,1);d[v].variants.splice(s,0,o);if(A){n.changeType="setTitle";n.fileType="ctrl_variant_change";n.fileName=U.createDefaultFileName();n.variantReference=p.variantReference;a.setTextInChange(n,"title",p.title,"XFLD");o.modified=true;c=this.oFlexController.createBaseChange(n,p.appComponent);this.oFlexController._oChangePersistence.addDirtyChange(c);}else{this.oFlexController._oChangePersistence.deleteChange(p.change);}this.setData(d);return c;};
V.prototype._switchToVariant=function(v,n){var c=this.oData[v].currentVariant;var m=this.oFlexController._oChangePersistence.loadSwitchChangesMapForComponent(v,c,n);var A=U.getAppComponentForControl(this.oComponent);return Promise.resolve().then(this.oFlexController.revertChangesOnControl.bind(this.oFlexController,m.aRevert,A)).then(this.oFlexController.applyVariantChanges.bind(this.oFlexController,m.aNew,this.oComponent));};
V.prototype.ensureStandardEntryExists=function(v){var d=this.getData();if(!d[v]){this.bStandardVariantExists=false;d[v]={modified:false,currentVariant:v,defaultVariant:v,variants:[{key:v,originalTitle:this._oResourceBundle.getText("STANDARD_VARIANT_ORIGINAL_TITLE"),readOnly:true,title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),toBeDeleted:false}]};this.setData(d);if(this.oVariantController){var o={changes:{variantSection:{}}};o.changes.variantSection[v]={defaultVariant:v,variants:[{content:{fileName:v,title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),fileType:"ctrl_variant",variantManagementReference:v,variantReference:""},changes:[]}]};this.oVariantController._setChangeFileContent(o);}}};
return V;},true);
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/Cache',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils"],function(L,U){"use strict";var C=function(){};C._isOn=true;C._entries={};C._switches={};C._oFlexDataPromise=undefined;
C.getSwitches=function(){return C._switches;};
C.isActive=function(){return C._isOn;};
C.setActive=function(a){C._isOn=a;};
C.getFlexDataPromise=function(){return C._oFlexDataPromise;};
C.getEntries=function(){return C._entries;};
C.clearEntries=function(){C._entries={};};
C.getEntry=function(c,a){if(!C._entries[c]){C._entries[c]={};}if(!C._entries[c][a]){C._entries[c][a]={file:{changes:{changes:[],contexts:[]}}};}return C._entries[c][a];};
C.clearEntry=function(c,a){C.getEntry(c,a);C._entries[c][a]={};};
C._deleteEntry=function(c,a){if(C._entries[c]&&C._entries[c][a]){delete C._entries[c][a];}if(jQuery.isEmptyObject(C._entries[c])){delete C._entries[c];}};
C.getChangesFillingCache=function(l,c,p){if(!this.isActive()){return l.loadChanges(c,p);}var s=c.name;var a=c.appVersion||U.DEFAULT_APP_VERSION;var o=C.getEntry(s,a);if(o.promise){return o.promise;}var b=C._getChangesFromBundle(p);if(p&&p.cacheKey==="<NO CHANGES>"){return b.then(function(f){return{changes:{changes:f,contexts:[]},componentClassName:s};});}var d=l.loadChanges(c,p).then(function(r){return r;},function(E){var f=jQuery.sap.formatMessage("flexibility service is not available:\nError message: {0}",E.status);jQuery.sap.log.error(f);return Promise.resolve({changes:{changes:[],contexts:[],variantSection:{},settings:{}}});});var e=Promise.all([b,d]).then(function(v){var f=v[0];var m=v[1];if(m&&m.changes){if(m.changes.settings&&m.changes.settings.switchedOnBusinessFunctions){m.changes.settings.switchedOnBusinessFunctions.forEach(function(V){C._switches[V]=true;});}m.changes.changes=f.concat(m.changes.changes);}o.file=m;return o.file;},function(f){C._deleteEntry(s,a);throw f;});o.promise=e;C._oFlexDataPromise=e;return e;};
C._getChangesFromBundle=function(p){var c=p&&p.appName;if(!c){return Promise.resolve([]);}var r=jQuery.sap.getResourceName(p.appName,"/changes/changes-bundle.json");var b=jQuery.sap.isResourceLoaded(r);if(b){return Promise.resolve(jQuery.sap.loadResource(r));}else{if(!sap.ui.getCore().getConfiguration().getDebug()){return Promise.resolve([]);}try{return Promise.resolve(jQuery.sap.loadResource(r));}catch(e){jQuery.sap.log.warning("flexibility did not find a changesBundle.json  for the application");return Promise.resolve([]);}}};
C.NOTAG="<NoTag>";
C.getCacheKey=function(c){if(!c||!c.name||!c.appVersion){jQuery.sap.log.warning("Not all parameters were passed to determine a flexibility cache key.");return Promise.resolve(C.NOTAG);}return this.getChangesFillingCache(new L(),c).then(function(w){if(w&&w.etag){return w.etag;}else{return C.NOTAG;}});};
C._getChangeArray=function(c){var s=c.name;var a=c.appVersion||U.DEFAULT_APP_VERSION;var e=C.getEntry(s,a);return e.file.changes.changes;};
C.addChange=function(c,o){var a=C._getChangeArray(c);if(!a){return;}a.push(o);};
C.updateChange=function(c,o){var a=C._getChangeArray(c);if(!a){return;}for(var i=0;i<a.length;i++){if(a[i].fileName===o.fileName){a.splice(i,1,o);break;}}};
C.deleteChange=function(c,o){var a=C._getChangeArray(c);if(!a){return;}for(var i=0;i<a.length;i++){if(a[i].fileName===o.fileName){a.splice(i,1);break;}}};
return C;},true);
sap.ui.predefine('sap/ui/fl/Change',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/fl/registry/Settings"],function(q,M,U,S){"use strict";
var C=M.extend("sap.ui.fl.Change",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){U.log.error("Constructor : sap.ui.fl.Change : oFile is not defined");}this._oDefinition=f;this._oOriginDefinition=q.extend(true,{},f);this._sRequest='';this._bUserDependent=(f.layer==="USER");this._vRevertData=null;this.setState(C.states.NEW);},
metadata:{properties:{state:{type:"string"}}}
});
C.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};C.events={markForDeletion:"markForDeletion"};
C.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
C.prototype._isValidState=function(s){var b=false;Object.keys(C.states).some(function(k){if(C.states[k]===s){b=true;}return b;});if(!b){return false;}if((this.getState()===C.states.NEW)&&(s===C.states.DIRTY)){return false;}return true;};
C.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.fileType){i=false;}if(!this._oDefinition.fileName){i=false;}if(!this._oDefinition.changeType){i=false;}if(!this._oDefinition.layer){i=false;}if(!this._oDefinition.originalLanguage){i=false;}return i;};
C.prototype.isVariant=function(){return this._oDefinition.fileType==="variant";};
C.prototype.getChangeType=function(){if(this._oDefinition){return this._oDefinition.changeType;}};
C.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.fileType;}};
C.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.originalLanguage){return this._oDefinition.originalLanguage;}return"";};
C.prototype.getContext=function(){if(this._oDefinition&&this._oDefinition.context){return this._oDefinition.context;}return"";};
C.prototype.getPackage=function(){return this._oDefinition.packageName;};
C.prototype.getNamespace=function(){return this._oDefinition.namespace;};
C.prototype.setNamespace=function(n){this._oDefinition.namespace=n;};
C.prototype.getId=function(){return this._oDefinition.fileName;};
C.prototype.getContent=function(){return this._oDefinition.content;};
C.prototype.setContent=function(c){this._oDefinition.content=c;this.setState(C.states.DIRTY);};
C.prototype.getVariantReference=function(){return this._oDefinition.variantReference||"";};
C.prototype.setVariantReference=function(v){this._oDefinition.variantReference=v;this.setState(C.states.DIRTY);};
C.prototype.getSelector=function(){return this._oDefinition.selector;};
C.prototype.getOwnerId=function(){return this._oDefinition.support?this._oDefinition.support.user:"";};
C.prototype.getText=function(t){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.getTexts : sTextId is not defined");}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){return this._oDefinition.texts[t].value;}}return"";};
C.prototype.setText=function(t,n){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.setTexts : sTextId is not defined");return;}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){this._oDefinition.texts[t].value=n;this.setState(C.states.DIRTY);}}};
C.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};
C.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
C.prototype.isLabelReadOnly=function(){if(this._isReadOnlyDueToLayer()){return true;}return this._isReadOnlyDueToOriginalLanguage();};
C.prototype._isReadOnlyDueToLayer=function(){var c;c=U.getCurrentLayer(this._bUserDependent);return(this._oDefinition.layer!==c);};
C.prototype._isReadOnlyDueToOriginalLanguage=function(){var c,o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
C.prototype.markForDeletion=function(){this.setState(C.states.DELETED);};
C.prototype.setRequest=function(r){if(typeof(r)!=="string"){U.log.error("sap.ui.fl.Change.setRequest : sRequest is not defined");}this._sRequest=r;};
C.prototype.getRequest=function(){return this._sRequest;};
C.prototype.getLayer=function(){return this._oDefinition.layer;};
C.prototype.getComponent=function(){return this._oDefinition.reference;};
C.prototype.setComponent=function(c){this._oDefinition.reference=c;};
C.prototype.getCreation=function(){return this._oDefinition.creation;};
C.prototype.isUserDependent=function(){return(this._bUserDependent);};
C.prototype.getPendingAction=function(){return this.getState();};
C.prototype.getDefinition=function(){return this._oDefinition;};
C.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this._oOriginDefinition=JSON.parse(R);this.setState(C.states.PERSISTED);}};
C.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().fileName;var F=this.getDefinition().fileType;return l+"/"+n+"/"+f+"."+F;};
C.prototype.addDependentControl=function(c,a,p,A){if(!c){throw new Error("Parameter vControl is mandatory");}if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}if(!this._oDefinition.dependentSelector){this._oDefinition.dependentSelector={};}if(this._oDefinition.dependentSelector[a]){throw new Error("Alias '"+a+"' already exists in the change.");}var m=p.modifier;var o=p.appComponent;if(Array.isArray(c)){var s=[];c.forEach(function(b){s.push(m.getSelector(b,o,A));});this._oDefinition.dependentSelector[a]=s;}else{this._oDefinition.dependentSelector[a]=m.getSelector(c,o,A);}delete this._aDependentIdList;};
C.prototype.getDependentControl=function(a,p){var d=[];var D;if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}var m=p.modifier;var A=p.appComponent;if(!this._oDefinition.dependentSelector){return undefined;}D=this._oDefinition.dependentSelector[a];if(Array.isArray(D)){D.forEach(function(s){d.push(m.bySelector(s,A,p.view));});return d;}else{return m.bySelector(D,A,p.view);}};
C.prototype.getDependentIdList=function(a){var t=this;var i;var d=[this.getSelector()];var D=[];if(!this._aDependentIdList){if(this._oDefinition.dependentSelector){d=Object.keys(this._oDefinition.dependentSelector).reduce(function(d,A){return d.concat(t._oDefinition.dependentSelector[A]);},d);}d.forEach(function(o){i=o.id;if(o.idIsLocal){i=a.createId(o.id);}if(i&&D.indexOf(i)===-1){D.push(i);}});this._aDependentIdList=D;}return this._aDependentIdList;};
C.prototype.getDependentControlIdList=function(a){var i;var d=this.getDependentIdList().concat();if(d.length>0){var s=this.getSelector();i=s.id;if(s.idIsLocal){i=a.createId(s.id);}var I=d.indexOf(i);if(I>-1){d.splice(I,1);}}return d;};
C.prototype.getRevertData=function(){return this._vRevertData;};
C.prototype.setRevertData=function(d){this._vRevertData=d;};
C.prototype.resetRevertData=function(){this.setRevertData(null);};
C.createInitialFileContent=function(p){if(!p){p={};}var f;if(p.fileType){f=p.fileType;}else{f=p.isVariant?"variant":"change";}var n={fileName:p.id||U.createDefaultFileName(p.changeType),fileType:f,changeType:p.changeType||"",reference:p.reference||"",packageName:p.packageName||"",content:p.content||{},selector:p.selector||{},layer:p.layer||U.getCurrentLayer(p.isUserDependent),texts:p.texts||{},namespace:p.namespace||U.createNamespace(p,"changes"),creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},context:p.context||"",support:{generator:"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version},dependentSelector:p.dependentSelector||{},validAppVersions:p.validAppVersions||{}};return n;};
return C;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistence',["sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/context/ContextManager","sap/ui/fl/registry/Settings","sap/ui/fl/variants/VariantController"],function(C,V,U,L,a,b,S,c){"use strict";var d=function(m){this._mComponent=m;this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};this._mChangesInitial={};if(!this._mComponent||!this._mComponent.name){U.log.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._oVariantController=new c(this._mComponent.name,this._mComponent.appVersion,{});this._oConnector=this._createLrepConnector();this._aDirtyChanges=[];this._oMessagebundle=undefined;};
d.prototype.getComponentName=function(){return this._mComponent.name;};
d.prototype._createLrepConnector=function(){return L.createConnector();};
d.prototype.getCacheKey=function(){return a.getCacheKey(this._mComponent);};
d.prototype._preconditionsFulfilled=function(A,i,o){function _(){if(i){return(o.fileType==="change")||(o.fileType==="variant");}return(o.fileType==="change")&&(o.changeType!=="defaultVariant");}function e(){if(i){if((o.fileType==="variant")||(o.changeType==="defaultVariant")){return o.selector&&o.selector.persistencyKey;}}return true;}function f(){return b.doesContextMatch(o,A);}if(_()&&e()&&f()){return true;}return false;};
d.prototype.getChangesForComponent=function(p){return a.getChangesFillingCache(this._oConnector,this._mComponent,p).then(function(w){var o=p&&p.oComponent;if(w.changes&&w.changes.settings){S._storeInstance(w.changes.settings);}if(!w.changes||!w.changes.changes){return[];}var f=w.changes.changes;if(!this._oMessagebundle&&w.messagebundle&&o){if(!o.getModel("i18nFlexVendor")){if(f.some(function(j){return j.layer==="VENDOR";})){this._oMessagebundle=w.messagebundle;var m=new sap.ui.model.json.JSONModel(this._oMessagebundle);o.setModel(m,"i18nFlexVendor");}}}if(w.changes.variantSection&&Object.keys(w.changes.variantSection).length!==0&&!this._oVariantController._getChangeFileContent()){this._oVariantController._setChangeFileContent(w);var v=this._oVariantController.loadDefaultChanges();f=f.concat(v);}var s=p&&p.currentLayer;if(s){var g=[];f.forEach(function(j){if(j.layer===s){g.push(j);}});f=g;}else if(U.isLayerFilteringRequired()&&!(p&&p.ignoreMaxLayerParameter)){var F=[];f.forEach(function(j){if(!U.isOverMaxLayer(j.layer)){F.push(j);}});f=F;}var i=p&&p.includeVariants;var h=w.changes.contexts||[];return new Promise(function(r){b.getActiveContexts(h).then(function(A){r(f.filter(this._preconditionsFulfilled.bind(this,A,i)).map(e));}.bind(this));}.bind(this));}.bind(this));function e(o){var f=new C(o);f.setState(C.states.PERSISTED);return f;}};
d.prototype._addChangeIntoMap=function(o,e){var s=e.getSelector();if(s&&s.id){var f=s.id;if(s.idIsLocal){f=o.createId(f);}this._addMapEntry(f,e);if(s.idIsLocal===undefined&&f.indexOf("---")!=-1){var g=f.split("---")[0];if(g!==o.getId()){f=f.split("---")[1];f=o.createId(f);this._addMapEntry(f,e);}}}return this._mChanges;};
d.prototype._addMapEntry=function(s,o){if(!this._mChanges.mChanges[s]){this._mChanges.mChanges[s]=[];}this._mChanges.mChanges[s].push(o);};
d.prototype._addDependency=function(D,o){if(!this._mChanges.mDependencies[D.getId()]){this._mChanges.mDependencies[D.getId()]={changeObject:D,dependencies:[]};}this._mChanges.mDependencies[D.getId()].dependencies.push(o.getId());if(!this._mChanges.mDependentChangesOnMe[o.getId()]){this._mChanges.mDependentChangesOnMe[o.getId()]=[];}this._mChanges.mDependentChangesOnMe[o.getId()].push(D.getId());};
d.prototype._addControlsDependencies=function(D,e){if(e.length>0){if(!this._mChanges.mDependencies[D.getId()]){this._mChanges.mDependencies[D.getId()]={changeObject:D,dependencies:[],controlsDependencies:[]};}this._mChanges.mDependencies[D.getId()].controlsDependencies=e;}};
d.prototype.loadChangesMapForComponent=function(o,p){p.oComponent=o;return this.getChangesForComponent(p).then(e.bind(this));function e(f){this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};f.forEach(this._addChangeAndUpdateDependencies.bind(this,o));if(U.isDebugEnabled()){this._mChangesInitial=jQuery.extend(true,{},this._mChanges);}return this.getChangesMapForComponent.bind(this);}};
d.prototype._addChangeAndUpdateDependencies=function(o,e,I,f){this._addChangeIntoMap(o,e);var A=U.getAppComponentForControl(o);var D=e.getDependentIdList(A);var g=e.getDependentControlIdList(A);this._addControlsDependencies(e,g);var p;var P;var h;var F;for(var i=I-1;i>=0;i--){p=f[i];P=f[i].getDependentIdList(A);F=false;for(var j=0;j<D.length&&!F;j++){h=P.indexOf(D[j]);if(h>-1){this._addDependency(e,p);F=true;}}}};
d.prototype.getChangesMapForComponent=function(){return this._mChanges;};
d.prototype.getChangesForView=function(v,p){var t=this;return this.getChangesForComponent(p).then(function(f){return f.filter(e.bind(t));});function e(o){var s=o.getSelector();if(!s){return false;}var f=s.id;if(!f||!p){return false;}var g=f.slice(0,f.lastIndexOf("--"));var v;if(o.getSelector().idIsLocal){var A=p.appComponent;if(A){v=A.getLocalId(p.viewId);}}else{v=p.viewId;}return g===v;}};
d.prototype.addChange=function(v,o){var e=this.addDirtyChange(v);if(e.getFileType()!=="ctrl_variant"){this._addChangeIntoMap(o,e);}this._addPropagationListener(o);return e;};
d.prototype.addDirtyChange=function(v){var n;if(v instanceof C||v instanceof V){n=v;}else{n=new C(v);}this._aDirtyChanges.push(n);return n;};
d.prototype._addPropagationListener=function(o){if(o){var f=function(p){return!p._bIsSapUiFlFlexControllerApplyChangesOnControl;};var n=o.getPropagationListeners().every(f);if(n){var m=o.getManifest();var v=U.getAppVersionFromManifest(m);var F=sap.ui.fl.FlexControllerFactory.create(this.getComponentName(),v);var p=F.getBoundApplyChangesOnControl(this.getChangesMapForComponent.bind(this),o);o.addPropagationListener(p);}}};
d.prototype.saveDirtyChanges=function(s){var D=this._aDirtyChanges.slice(0);var e=this._aDirtyChanges;var r=this._getRequests(D);var p=this._getPendingActions(D);if(p.length===1&&r.length===1&&p[0]==="NEW"){var R=r[0];var P=this._prepareDirtyChanges(e);return this._oConnector.create(P,R).then(this._massUpdateCacheAndDirtyState(e,D,s));}else{return D.reduce(function(f,o){var g=f.then(this._performSingleSaveAction(o).bind(this));g.then(this._updateCacheAndDirtyState(e,o,s));return g;}.bind(this),Promise.resolve(true));}};
d.prototype.saveAsDirtyChanges=function(r){return S.getInstance().then(function(s){var p={reference:r};var n=U.createNamespace(p,"changes");var D=this.getDirtyChanges();D.forEach(function(o){if(s.isAtoEnabled()){o.setRequest("ATO_NOTIFICATION");}o.setNamespace(n);o.setComponent(r);});return this.saveDirtyChanges(true);}.bind(this));};
d.prototype._performSingleSaveAction=function(D){return function(){if(D.getPendingAction()==="NEW"){return this._oConnector.create(D.getDefinition(),D.getRequest());}if(D.getPendingAction()==="DELETE"){return this._oConnector.deleteChange({sChangeName:D.getId(),sLayer:D.getLayer(),sNamespace:D.getNamespace(),sChangelist:D.getRequest()});}};};
d.prototype._updateCacheAndDirtyState=function(D,o,s){var t=this;return function(){if(!s){if(o.getPendingAction()==="NEW"){a.addChange(t._mComponent,o.getDefinition());}if(o.getPendingAction()==="DELETE"){a.deleteChange(t._mComponent,o.getDefinition());}}var i=D.indexOf(o);if(i>-1){D.splice(i,1);}};};
d.prototype._massUpdateCacheAndDirtyState=function(D,e,s){e.forEach(function(o){this._updateCacheAndDirtyState(D,o,s)();},this);};
d.prototype._getRequests=function(D){var r=[];D.forEach(function(o){var R=o.getRequest();if(r.indexOf(R)===-1){r.push(R);}});return r;};
d.prototype._getPendingActions=function(D){var p=[];D.forEach(function(o){var P=o.getPendingAction();if(p.indexOf(P)===-1){p.push(P);}});return p;};
d.prototype._prepareDirtyChanges=function(D){var e=[];D.forEach(function(o){e.push(o.getDefinition());});return e;};
d.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};
d.prototype.deleteChange=function(o){var n=this._aDirtyChanges.indexOf(o);if(n>-1){if(o.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(n,1);this._deleteChangeInMap(o);return;}o.markForDeletion();this.addDirtyChange(o);this._deleteChangeInMap(o);};
d.prototype._deleteChangeInMap=function(o){var s=o.getId();var m=this._mChanges.mChanges;var D=this._mChanges.mDependencies;var e=this._mChanges.mDependentChangesOnMe;Object.keys(m).some(function(k){var f=m[k];var n=f.map(function(E){return E.getId();}).indexOf(o.getId());if(n!==-1){f.splice(n,1);return true;}});Object.keys(D).forEach(function(k){if(k===s){delete D[k];}else if(D[k].dependencies&&jQuery.isArray(D[k].dependencies)&&D[k].dependencies.indexOf(s)!==-1){D[k].dependencies.splice(D[k].dependencies.indexOf(s),1);if(D[k].dependencies.length===0){delete D[k];}}});Object.keys(e).forEach(function(k){if(k===s){delete e[k];}else if(jQuery.isArray(e[k])&&e[k].indexOf(s)!==-1){e[k].splice(e[k].indexOf(s),1);if(e[k].length===0){delete e[k];}}});};
d.prototype.loadSwitchChangesMapForComponent=function(v,s,n){return this._oVariantController.getChangesForVariantSwitch(v,s,n,this._mChanges.mChanges);};
return d;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistenceFactory',["jquery.sap.global","sap/ui/core/Component","sap/ui/fl/ChangePersistence","sap/ui/fl/Utils"],function(q,C,a,U){"use strict";var b={};b._instanceCache={};
b.getChangePersistenceForComponent=function(c,A){var o;A=A||U.DEFAULT_APP_VERSION;if(!b._instanceCache[c]){b._instanceCache[c]={};}o=b._instanceCache[c][A];if(!o){var d={name:c,appVersion:A};o=new a(d);b._instanceCache[c][A]=o;}return o;};
b.getChangePersistenceForControl=function(c){var s;s=this._getComponentClassNameForControl(c);var A=U.getAppVersionFromManifest(U.getAppComponentForControl(c).getManifest());return b.getChangePersistenceForComponent(s,A);};
b._getComponentClassNameForControl=function(c){return U.getComponentClassName(c);};
b.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=this._onLoadComponent.bind(this);};
b._doLoadComponent=function(c,m){var o={oChangePersistence:{},oRequestOptions:{appName:c.name}};var s=U.getFlexReference(m);var A=U.getAppVersionFromManifest(m);var M,S,t;S=c&&c.componentData&&c.componentData.startupParameters||{};t=c&&c.componentData&&c.componentData.technicalParameters;if(S["sap-app-id"]&&S["sap-app-id"].length===1){s=S["sap-app-id"][0];}else{if(c){var d=c.asyncHints;if(d&&d.requests&&Array.isArray(d.requests)){var f=this._findFlAsyncHint(d.requests,s);if(f){o.oRequestOptions.cacheKey=f.cachebusterToken||"<NO CHANGES>";o.oRequestOptions.url=f.url;}}}}var e=t||S;if(e&&e["sap-ui-fl-max-layer"]&&e["sap-ui-fl-max-layer"].length===1){M=e["sap-ui-fl-max-layer"][0];}U.setMaxLayerParameter(M);o.oRequestOptions.siteId=U.getSiteIdByComponentData(c.componentData);o.oChangePersistence=this.getChangePersistenceForComponent(s,A);return o;};
b._onLoadComponent=function(c,m){if(!U.isApplication(m)){return;}var o=this._doLoadComponent(c,m);o.oChangePersistence.getChangesForComponent(o.oRequestOptions);};
b._getChangesForComponentAfterInstantiation=function(c,m,o){if(!U.isApplication(m)){return Promise.resolve(function(){return{mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};});}var d=this._doLoadComponent(c,m);return d.oChangePersistence.loadChangesMapForComponent(o,d.oRequestOptions);};
b._findFlAsyncHint=function(A,r){var t=this;var f;q.each(A,function(n,o){if(t._flAsyncHintMatches(o,r)){f=o;return false;}});return f;};
b._flAsyncHintMatches=function(A,r){return A.name==="sap.ui.fl.changes"&&A.reference===r;};
return b;},true);
sap.ui.predefine('sap/ui/fl/DefaultVariant',["jquery.sap.global","sap/ui/fl/Change"],function($,C){"use strict";var D=function(){};
D.prototype.getDefaultVariantId=function(c){var d=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(d){return d.getContent().defaultVariantName;}return"";};
D.prototype.getNewestDefaultVariantChangeDeleteTheRest=function(c){var d=this.getDefaultVariantChanges(c).sort(function(a,b){var e=new Date(a.getCreation());var f=new Date(b.getCreation());if(isNaN(e.getDate())){return-1;}if(isNaN(f.getDate())){return 1;}return f-e;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
D.prototype.getDefaultVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(d);function a(s){return c[s];}function d(o){return o.getChangeType()==='defaultVariant';}};
D.prototype.updateDefaultVariantId=function(c,n){var N=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(N){var o=N.getContent();o.defaultVariantName=n;N.setContent(o);}return N;};
D.prototype._createChangeFile=function(p){var f;p.namespace=p.component+'/changes/default';p.componentName=p.component;p.changeType='defaultVariant';f=C.createInitialFileContent(p);f.content.defaultVariantName=p.defaultVariantId;f.layer='USER';return f;};
D.prototype.createChangeObject=function(p){var f,c;f=this._createChangeFile(p);c=new C(f);return c;};
return new D();},true);
sap.ui.predefine('sap/ui/fl/EventHistory',function(){"use strict";var E=function(){};E._aEventIds=["ControlForPersonalizationRendered"];E._aUnsubscribedEventIds=[];E._oHistory={};
E.start=function(){E._aEventIds.forEach(function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){sap.ui.getCore().getEventBus().subscribe("sap.ui",e,E.saveEvent);E._oHistory[e]=[];}});};
E.saveEvent=function(c,e,p){var o={"channelId":c,"eventId":e,"parameters":p};if(E._oHistory[e]){E._oHistory[e].push(o);}};
E.getHistoryAndStop=function(e){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",e,E.saveEvent);E._addUnsubscribedEvent(e);return E._oHistory[e]||[];};
E._addUnsubscribedEvent=function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){E._aUnsubscribedEventIds.push(e);}};
return E;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnector',["jquery.sap.global","sap/ui/thirdparty/URI","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/ChangePersistenceFactory"],function(q,u,F,L,C,a){"use strict";var l=Object.create(L.prototype);b._oBackendInstances={};
function b(i){this.sInitialComponentJsonPath=i;}
for(var p in l){if(typeof l[p]==='function'){b.prototype[p]=(function(p){return function(){throw new Error('Method '+p+'() is not implemented in FakeLrepConnector.');};}(p));}}
b.prototype.loadChanges=function(s){var i=this.sInitialComponentJsonPath;return new Promise(function(r,e){q.getJSON(i).done(function(R){var f={changes:R,componentClassName:s};r(f);}).fail(function(f){e(f);});});};
b.prototype.create=function(e,f,i){if(!i){return Promise.resolve();}if(!e.creation){e.creation=new Date().toISOString();}return Promise.resolve({response:e,status:'success'});};
b.prototype.update=function(e,f,g,i){if(!i){return Promise.resolve();}return Promise.resolve({response:e,status:'success'});};
b.prototype.deleteChange=function(e,i){if(!i){return Promise.resolve();}return Promise.resolve({response:undefined,status:'nocontent'});};
b.prototype.send=function(U,m,D,o){return new Promise(function(r,e){d(U,m,D,o,r,e);c(U,m,D,o,r,e);h(U,m,D,o,r,e);});};
function h(U,m,D,o,r){if(U.match(/^\/sap\/bc\/ui2\/app_index\/ui5_app_mani_first_supported\//)&&m==='GET'){r({response:false,status:"success"});}}
function c(U,m,D,o,r){if(U.match(/^\/sap\/bc\/lrep\/actions\/make_changes_transportable\//)&&m==='POST'){r();}}
function d(U,m,D,o,r,e){if(U.match(/^\/sap\/bc\/lrep\/actions\/gettransports\//)){r({response:{"transports":[{"transportId":"U31K008488","description":"The Ultimate Transport","owner":"Fantasy Owner","locked":false}],"localonly":false,"errorCode":""}});}}
b.enableFakeConnector=function(i,A,s){function r(){b.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!b._oFakeInstance){b._oFakeInstance=new b(i);}return b._oFakeInstance;};}if(A&&s){var o=a.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof b)){C.clearEntry(A,s);if(!b._oBackendInstances[A]){b._oBackendInstances[A]={};}b._oBackendInstances[A][s]=o._oConnector;o._oConnector=new b(i);}r();return;}C.clearEntries();if(b.enableFakeConnector.original){return;}r();};
b.disableFakeConnector=function(A,s){function r(){if(b.enableFakeConnector.original){L.createConnector=b.enableFakeConnector.original;b.enableFakeConnector.original=undefined;b._oFakeInstance=undefined;}}if(A&&s){var o=a.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof L)){C.clearEntry(A,s);if(b._oBackendInstances[A]&&b._oBackendInstances[A][s]){o._oConnector=b._oBackendInstances[A][s];b._oBackendInstances[A][s]=undefined;}}r();return;}C.clearEntries();r();};
return b;},true);
sap.ui.predefine('sap/ui/fl/FlexController',["jquery.sap.global","sap/ui/fl/Persistence","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Cache","sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/View","sap/ui/fl/changeHandler/JsControlTreeModifier","sap/ui/fl/changeHandler/XmlTreeModifier","sap/ui/fl/context/ContextManager"],function(q,P,C,U,L,a,V,b,F,c,d,J,X,f){"use strict";var g=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};g.appliedChangesCustomDataKey="sap.ui.fl.appliedChanges";g.failedChangesCustomDataKeyJs="sap.ui.fl.failedChanges.js";g.failedChangesCustomDataKeyXml="sap.ui.fl.failedChanges.xml";g.PENDING="sap.ui.fl:PendingChange";g.PROCESSING="sap.ui.fl:ProcessingChange";
g.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};
g.prototype.getComponentName=function(){return this._sComponentName;};
g.prototype.getAppVersion=function(){return this._sAppVersion;};
g.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController._fillVariantModel();}return D;};
g.prototype.createBaseChange=function(o,A){var e,h;var i=f._getContextIdsFromUrl();if(i.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No Application Component found - to offer flexibility. Valid relation to its owning application component must be present.");}o.reference=this.getComponentName();o.packageName="$TMP";o.context=i.length===1?i[0]:"";var s=this.getAppVersion();var v={creation:s,from:s};if(s&&o.developerMode){v.to=s;}o.validAppVersions=v;e=a.createInitialFileContent(o);h=new a(e);if(o.variantReference){h.setVariantReference(o.variantReference);}return h;};
g.prototype.createChange=function(o,e){var h,i;if(!e){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=e.id||e.getId();if(!o.selector){o.selector={};}var A=e.appComponent||U.getAppComponentForControl(e);if(!A){throw new Error("No Application Component found - to offer flexibility the control with the id '"+s+"' has to have a valid relation to its owning application component.");}if(U.hasLocalIdSuffix(s,A)){var l=A.getLocalId(s);if(!l){throw new Error("Generated ID attribute found ('"+s+"'); provide a stable ID for the control as required by flexibility for assigning the changes.");}o.selector.id=l;o.selector.idIsLocal=true;}else{o.selector.id=s;o.selector.idIsLocal=false;}h=this.createBaseChange(o,A);var j=e.controlType||U.getControlType(e);if(!j){throw new Error("No control type found - the change handler can not be retrieved.");}i=this._getChangeHandler(h,j);if(i){i.completeChangeContent(h,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return h;};
g.prototype.createVariant=function(v,A){var o;var e=f._getContextIdsFromUrl();if(e.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No Application Component found - to offer flexibility the variant has to have a valid relation to its owning application component.");}v.reference=this.getComponentName();v.packageName="$TMP";v.context=e.length===1?e[0]:"";v.isVariant=true;var s=this.getAppVersion();var h={creation:s,from:s};if(s&&v.developerMode){h.to=s;}v.validAppVersions=h;v.content=V.createInitialFileContent(v.content);o=new V(v);return o;};
g.prototype.addChange=function(o,e){var h=this.createChange(o,e);var i=U.getAppComponentForControl(e);this.addPreparedChange(h,i);return h;};
g.prototype.addPreparedChange=function(o,A){if(o.getVariantReference()){var m=A.getModel("$FlexVariants");if(!m.bStandardVariantExists){var v=m.getVariant(o.getVariantReference());var e=this.createVariant(v,A);m.bStandardVariantExists=true;this._oChangePersistence.addChange(e,A);}m._addChange(o);}this._oChangePersistence.addChange(o,A);return o;};
g.prototype.deleteChange=function(o,A){this._oChangePersistence.deleteChange(o);if(o.getVariantReference()){A.getModel("$FlexVariants")._removeChange(o);}};
g.prototype.createAndApplyChange=function(o,e){var h=this.addChange(o,e);var p={modifier:J,appComponent:U.getAppComponentForControl(e)};return this.checkTargetAndApplyChange(h,e,p).catch(function(E){this._oChangePersistence.deleteChange(h);throw E;}.bind(this));};
g.prototype._checkDependencies=function(o,D,m,A,r){var R=this._checkChange(o,A);if(!R){return[];}r.push(o);var s=o.getId();var e=D[s]&&D[s].dependencies||[];for(var i=0,n=e.length;i<n;i++){var h=U.getChangeFromChangesMap(m,e[i]);R=this._checkDependencies(h,D,m,A,r);if(R.length===0){r=[];break;}delete D[s];}return r;};
g.prototype._checkChange=function(o,A){var s;var S=o.getSelector();if(S.idIsLocal){s=A.createId(S.id);}else{s=S.id;}var e=sap.ui.getCore().byId(s);if(!e){return false;}var h=this._getFailedCustomDataJs(o,e,J).customDataEntries;if(h.indexOf(o.getId())>-1){return false;}return true;};
g.prototype.waitForChangesToBeApplied=function(o){var m=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=q.extend({},m.mDependencies);var e=m.mChanges;var h=e[o.getId()]||[];var A=this._getAppliedCustomData(undefined,o,J).customDataEntries;var i=U.getAppComponentForControl(o);var n=h.filter(function(j){return A.indexOf(j.getId())===-1;});var r=[];n.forEach(function(j){var k=this._checkDependencies(j,D,m.mChanges,i,[]);r=r.concat(k);},this);r=r.filter(function(j,k,l){return l.indexOf(j)===k;});r.forEach(function(w){if(!w.aPromiseFn){w.aPromiseFn=[];}p.push(new Promise(function(j,k){w.aPromiseFn.push({resolve:j,reject:k});}).catch(function(j){var k=j.getId&&m.mDependentChangesOnMe[j.getId()]||[];k.forEach(function(s){var l=U.getChangeFromChangesMap(e,s);if(l.aPromiseFn){l.aPromiseFn.forEach(function(t){t.reject(l);});}});Promise.resolve();}));},this);return Promise.all(p);};
g.prototype.saveAll=function(){return this._oChangePersistence.saveDirtyChanges();};
g.prototype.saveAs=function(r){return this._oChangePersistence.saveAsDirtyChanges(r);};
g.prototype.processXmlView=function(v,p){var o=sap.ui.getCore().getComponent(p.componentId);var A=U.getAppComponentForControl(o);var m=o.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};
g.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};
g.prototype._resolveGetChangesForView=function(p,e){var h=[];if(!Array.isArray(e)){var E="No list of changes was passed for processing the flexibility on view: "+p.view+".";U.log.error(E,undefined,"sap.ui.fl.FlexController");return[];}e.forEach(function(o){try{var s=this._getSelectorOfChange(o);if(!s||!s.id){throw new Error("No selector in change found or no selector ID.");}var i=p.modifier.bySelector(s,p.appComponent,p.view);if(!i){throw new Error("A flexibility change tries to change a nonexistent control.");}h.push(function(){return this.checkTargetAndApplyChange(o,i,p).catch(function(j){this._logApplyChangeError(j,o);}.bind(this));}.bind(this));}catch(j){this._logApplyChangeError(j,o);}}.bind(this));return U.execPromiseQueueSequentially(h).then(function(){return p.view;});};
g.prototype._logApplyChangeError=function(e,o){var D=o.getDefinition();var s=D.changeType;var t=D.selector.id;var h=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(e.message){w+="\n   occurred error message: '"+e.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+h;w+="\n   id of targeted control: '"+t+"'.";U.log.warning(w,undefined,"sap.ui.fl.FlexController");};
g.prototype.checkTargetAndApplyChange=function(o,h,p){var m=p.modifier;var s=m.getControlType(h);var i=this._getChangeHandler(o,s);if(!i){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");return new U.FakePromise();}var A=this._getAppliedCustomData(o,h,m);var j=A.customDataValue;var k=A.customDataEntries;var l=A.customData;var n=o.getId();if(k.indexOf(n)===-1){o.PROCESSING=o.PROCESSING?o.PROCESSING:true;var r;var E;try{r=i.applyChange(o,h,p);}catch(e){E=e;}return new U.FakePromise(r,E).then(function(){var v=j?j+","+n:n;this._writeAppliedChangesCustomData(l,v,p,h);if(o.aPromiseFn){o.aPromiseFn.forEach(function(t){t.resolve(o);});}delete o.PROCESSING;return true;}.bind(this)).catch(function(t){var x=p.modifier.targets==="xmlTree";var u;this._setMergeError(true);var v="Change ''{0}'' could not be applied. Merge error detected while "+"processing the {1}.";if(x){u=this._getFailedCustomDataXml(o,h,m);v=q.sap.formatMessage(v,[o.getId(),"XML tree"]);q.sap.log.warning(v,t.stack||"");}else{u=this._getFailedCustomDataJs(o,h,m);v=q.sap.formatMessage(v,[o.getId(),"JS control tree"]);q.sap.log.error(v,t.stack||"");}var w=u.customData;u.customDataEntries.push(o.getId());var y=u.customDataEntries.join(",");if(x){this._writeFailedChangesCustomDataXml(w,y,p,h);}else{this._writeFailedChangesCustomDataJs(w,y,p,h);}if(o.aPromiseFn){o.aPromiseFn.forEach(function(z){z.reject(o);});}delete o.PROCESSING;return false;}.bind(this));}return new U.FakePromise(true);};
g.prototype._removeFromAppliedChangesAndMaybeRevert=function(o,e,p,r){var A,h,i;var m=p.modifier;var s=m.getControlType(e);var j=this._getChangeHandler(o,s);var R;if(r&&!j){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");return new U.FakePromise();}var k=o.getId();var l=this._getAppliedCustomData(o,e,m);A=l.customDataEntries;h=l.customData;i=A.indexOf(k);if(i===-1&&(o.PROCESSING||o.QUEUED)){R=new Promise(function(n,t){o.aPromiseFn=o.aPromiseFn||[];o.aPromiseFn.push({resolve:n,reject:t});}).then(function(v){return true;});}else{R=new U.FakePromise(false);}return R.then(function(n){if(r&&(n||(!n&&i>-1))){return j.revertChange(o,e,p);}}).then(function(){l=this._getAppliedCustomData(o,e,m);A=l.customDataEntries;h=l.customData;i=A.indexOf(k);if(i>-1&&h){A.splice(i,1);this._writeAppliedChangesCustomData(h,A.join(),p,e);}}.bind(this)).catch(function(E){U.log.error("Change could not be reverted:",E);});};
g.prototype._writeAppliedChangesCustomData=function(o,v,p,e){this._writeCustomData(o,v,p,e,g.appliedChangesCustomDataKey);};
g.prototype._writeFailedChangesCustomDataXml=function(o,v,p,e){this._writeCustomData(o,v,p,e,g.failedChangesCustomDataKeyXml);};
g.prototype._writeFailedChangesCustomDataJs=function(o,v,p,e){this._writeCustomData(o,v,p,e,g.failedChangesCustomDataKeyJs);};
g.prototype._writeCustomData=function(o,v,p,e,s){var m=p.modifier;if(o){m.setProperty(o,"value",v);}else{var A=p.appComponent;var h=p.view;o=m.createControl("sap.ui.core.CustomData",A,h);m.setProperty(o,"key",s);m.setProperty(o,"value",v);m.insertAggregation(e,"customData",o,0,h);}};
g.prototype._getAppliedCustomData=function(o,e,m){return this._getCustomData(o,e,m,g.appliedChangesCustomDataKey);};
g.prototype._getFailedCustomDataXml=function(o,e,m){return this._getCustomData(o,e,m,g.failedChangesCustomDataKeyXml);};
g.prototype._getFailedCustomDataJs=function(o,e,m){return this._getCustomData(o,e,m,g.failedChangesCustomDataKeyJs);};
g.prototype._getCustomData=function(o,e,m,s){var h=m.getAggregation(e,"customData")||[];var r={customDataEntries:[]};h.some(function(i){var k=m.getProperty(i,"key");if(k===s){r.customData=i;r.customDataValue=m.getProperty(i,"value");r.customDataEntries=r.customDataValue.split(",");return true;}});return r;};
g.prototype._handlePromiseChainError=function(v,e){U.log.error("Error processing view "+e+".");return v;};
g.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};
g.prototype._getChangeHandler=function(o,s){var e,h;e=this._getChangeTypeMetadata(o,s);if(!e){return undefined;}h=e.getChangeHandler();return h;};
g.prototype._getChangeTypeMetadata=function(o,s){var e,h;e=this._getChangeRegistryItem(o,s);if(!e||!e.getChangeTypeMetadata){return undefined;}h=e.getChangeTypeMetadata();return h;};
g.prototype._getChangeRegistryItem=function(o,s){var e,h,l;if(!o||!s){return undefined;}e=o.getChangeType();if(!e||!s){return undefined;}l=o.getLayer();h=this._getChangeRegistry().getRegistryItems({"changeTypeName":e,"controlType":s,"layer":l});if(h&&h[s]&&h[s][e]){return h[s][e];}else if(h&&h[s]){return h[s];}else{return h;}};
g.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};
g.prototype.getComponentChanges=function(p){return this._oChangePersistence.getChangesForComponent(p);};
g.prototype.isPersonalized=function(p){p=p||{};p.includeVariants=true;return this.getComponentChanges(p).then(function(e){var i=e.some(function(o){return o.isUserDependent();});return!!i;});};
g.prototype._createChangePersistence=function(){this._oChangePersistence=c.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};
g.prototype.discardChanges=function(e,D){var A=U.getCurrentLayer(!!D);var i=0;var l;var o;l=e.length;while(i<e.length){o=e[i];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(l===e.length){i++;}else{l=e.length;}}return this._oChangePersistence.saveDirtyChanges();};
g.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var e=o.mChanges[i]||[];return this.discardChanges(e,D);};
g.prototype._setMergeError=function(){return F.getInstance().then(function(s){s.setMergeErrorOccured(true);});};
g.prototype._applyChangesOnControl=function(G,A,o){var p=[];var m=G();var e=m.mChanges;var D=m.mDependencies;var h=m.mDependentChangesOnMe;var i=e[o.getId()]||[];i.forEach(function(j){if(!D[j.getId()]){j.QUEUED=true;p.push(function(){return this.checkTargetAndApplyChange(j,o,{modifier:J,appComponent:A}).then(function(u){if(u){this._updateDependencies(D,h,j.getId());}delete j.QUEUED;}.bind(this));}.bind(this));}else{D[j.getId()][g.PENDING]=this.checkTargetAndApplyChange.bind(this,j,o,{modifier:J,appComponent:A});}}.bind(this));return U.execPromiseQueueSequentially(p).then(function(){return this._processDependentQueue(D,h);}.bind(this));};
g.prototype.getBoundApplyChangesOnControl=function(G,o){var B=this._applyChangesOnControl.bind(this,G,o);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};
g.prototype.revertChangesOnControl=function(e,A){var p=[];e.forEach(function(o){p.push(function(){var m={modifier:J,appComponent:A};var s=this._getSelectorOfChange(o);var h=m.modifier.bySelector(s,m.appComponent);return this._removeFromAppliedChangesAndMaybeRevert(o,h,{modifier:J,appComponent:A},true).then(function(){this._oChangePersistence._deleteChangeInMap(o);}.bind(this));}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};
g.prototype.applyVariantChanges=function(e,o){var A=U.getAppComponentForControl(o);var p=[];e.forEach(function(h){var m=this._oChangePersistence.getChangesMapForComponent().mChanges;var i=Object.keys(m).reduce(function(e,s){return e.concat(m[s]);},[]);this._oChangePersistence._addChangeAndUpdateDependencies(o,h,i.length,i);p.push(function(){var j={modifier:J,appComponent:A};var s=this._getSelectorOfChange(h);var k=j.modifier.bySelector(s,j.appComponent);if(!k){U.log.error("A flexibility change tries to change a nonexistent control.");return new U.FakePromise();}return this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,k);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};
g.prototype.removeFromAppliedChangesOnControl=function(o,A,e){return this._removeFromAppliedChangesAndMaybeRevert(o,e,{modifier:J,appComponent:A},false);};
g.prototype._updateControlsDependencies=function(D){var o;Object.keys(D).forEach(function(s){var e=D[s];if(e.controlsDependencies&&e.controlsDependencies.length>0){var l=e.controlsDependencies.length;while(l--){var i=e.controlsDependencies[l];o=sap.ui.getCore().byId(i);if(o){e.controlsDependencies.splice(l,1);}}}});};
g.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o.dependencies.indexOf(s);if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};
g.prototype._iterateDependentQueue=function(D,m){var A=[],e=[],p=[];this._updateControlsDependencies(D);Object.keys(D).forEach(function(s){var o=D[s];if(o[g.PENDING]&&o.dependencies.length===0&&!(o.controlsDependencies&&o.controlsDependencies.length>0)&&!o[g.PROCESSING]){o[g.PROCESSING]=true;p.push(function(){return o[g.PENDING]().then(function(){e.push(s);A.push(o.changeObject.getId());});});}});return U.execPromiseQueueSequentially(p).then(function(){for(var j=0;j<e.length;j++){delete D[e[j]];}for(var k=0;k<A.length;k++){this._updateDependencies(D,m,A[k]);}return A;}.bind(this));};
g.prototype._processDependentQueue=function(D,m){return this._iterateDependentQueue(D,m).then(function(A){if(A.length>0){return this._processDependentQueue(D,m);}}.bind(this));};
return g;},true);
sap.ui.predefine('sap/ui/fl/FlexControllerFactory',["jquery.sap.global","sap/ui/fl/FlexController","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/variants/VariantModel"],function(q,F,U,C,V){"use strict";var a={};a._instanceCache={};
a.create=function(c,A){var A=A||U.DEFAULT_APP_VERSION;if(!a._instanceCache[c]){a._instanceCache[c]={};}var f=a._instanceCache[c][A];if(!f){f=new F(c,A);a._instanceCache[c][A]=f;}return f;};
a.createForControl=function(c,m){var s=U.getComponentClassName(c);var l=m||U.getAppComponentForControl(c).getManifest();var A=U.getAppVersionFromManifest(l);return a.create(s,A);};
a.getChangesAndPropagate=function(c,v){var m=c.getManifestObject();if(U.isApplication(m)){var f=a.createForControl(c,m);C._getChangesForComponentAfterInstantiation(v,m,c).then(function(g){c.addPropagationListener(f.getBoundApplyChangesOnControl(g,c));var d=f.getVariantModelData()||{};c.setModel(new V(d,f,c),"$FlexVariants");});}};
return a;},true);
sap.ui.predefine('sap/ui/fl/LrepConnector',["jquery.sap.global","sap/ui/thirdparty/URI","sap/ui/fl/Utils"],function(q,u,F){"use strict";var C=function(p){this._initClientParam();this._initLanguageParam();if(p){this._sXsrfToken=p.XsrfToken;}};
C.createConnector=function(p){return new C(p);};
C.prototype.DEFAULT_CONTENT_TYPE="application/json; charset=utf-8";C.prototype._sClient=undefined;C.prototype._sLanguage=undefined;C.prototype._aSentRequestListeners=[];C.prototype._sRequestUrlPrefix="";
C.attachSentRequest=function(c){if(typeof c==="function"&&C.prototype._aSentRequestListeners.indexOf(c)===-1){C.prototype._aSentRequestListeners.push(c);}};
C.detachSentRequest=function(c){var i=C.prototype._aSentRequestListeners.indexOf(c);if(i!==-1){C.prototype._aSentRequestListeners.splice(i,1);}};
C.prototype._initClientParam=function(){var c=F.getClient();if(c){this._sClient=c;}};
C.prototype._initLanguageParam=function(){var l;l=F.getUrlParameter("sap-language")||F.getUrlParameter("sap-ui-language");if(l){this._sLanguage=l;}};
C.prototype.setRequestUrlPrefix=function(r){this._sRequestUrlPrefix=r;};
C.prototype._resolveUrl=function(r){if(!q.sap.startsWith(r,"/")){r="/"+r;}r=this._sRequestUrlPrefix+r;var U=u(r).absoluteTo("");return U.toString();};
C.prototype._getDefaultHeader=function(){var h={headers:{"X-CSRF-Token":this._sXsrfToken||"fetch"}};return h;};
C.prototype._getDefaultOptions=function(m,c,d){var o;if(!c){c=this.DEFAULT_CONTENT_TYPE;}else if(c.indexOf("charset")===-1){c+="; charset=utf-8";}o=q.extend(true,this._getDefaultHeader(),{type:m,async:true,contentType:c,processData:false,headers:{"Content-Type":c}});if(d&&o.contentType.indexOf("application/json")===0){o.dataType="json";if(typeof d==="object"){o.data=JSON.stringify(d);}else{o.data=d;}}else if(d){o.data=d;}if(m==="DELETE"){delete o.data;delete o.contentType;}return o;};
C.prototype.send=function(U,m,d,o){m=m||"GET";m=m.toUpperCase();o=o||{};U=this._resolveUrl(U);if(o.success||o.error){var e="Success and error handler are not allowed in mOptions";throw new Error(e);}var c=o.contentType||this.DEFAULT_CONTENT_TYPE;o=q.extend(true,this._getDefaultOptions(m,c,d),o);return this._sendAjaxRequest(U,o);};
C.prototype._getMessagesFromXHR=function(x){var a,m,l,i;m=[];try{a=JSON.parse(x.responseText);if(a&&a.messages&&a.messages.length>0){l=a.messages.length;for(i=0;i<l;i++){m.push({severity:a.messages[i].severity,text:a.messages[i].text});}}}catch(e){}return m;};
C.prototype._sendAjaxRequest=function(U,o){var t=this;var f="/sap/bc/lrep/actions/getcsrftoken/";var m={headers:{"X-CSRF-Token":"fetch"},type:"HEAD"};if(this._sClient){m.headers["sap-client"]=this._sClient;}return new Promise(function(r,a){function h(d,s,x){var n=x.getResponseHeader("X-CSRF-Token");t._sXsrfToken=n||t._sXsrfToken;var e=x.getResponseHeader("etag");var g={status:s,etag:e,response:d};r(g);q.each(t._aSentRequestListeners,function(i,j){j(g);});}function b(d,s,x){t._sXsrfToken=x.getResponseHeader("X-CSRF-Token");o.headers=o.headers||{};o.headers["X-CSRF-Token"]=t._sXsrfToken;q.ajax(U,o).done(h).fail(function(x,s,e){var E=new Error(e);E.status="error";E.code=x.statusCode().status;E.messages=t._getMessagesFromXHR(x);a(E);});}function c(x,s,e){if(x.status===403){q.ajax(f,m).done(b).fail(function(x,s,e){a({status:"error"});});}else{if(o&&o.type==="DELETE"&&x.status===404){r();}else{var d;d={status:"error",code:x.statusCode().status,messages:t._getMessagesFromXHR(x)};a(d);}}}var R=true;if(o&&o.type){if(o.type==="GET"||o.type==="HEAD"){R=false;}}else{if(t._sXsrfToken&&t._sXsrfToken!=="fetch"){R=false;}}if(R){q.ajax(f,m).done(b).fail(function(x,s,e){a({status:"error"});});}else{q.ajax(U,o).done(h).fail(c);}});};
C.prototype.loadChanges=function(c,p){var o={};var s=c.name;var U="/sap/bc/lrep/flex/data/";p=p||{};if(!s){return Promise.reject(new Error("Component name not specified"));}if(p.url){U=p.url;}else{if(p.cacheKey){o.cache=true;U+="~"+p.cacheKey+"~/";}U+=s;}if(p.siteId){if(!o.headers){o.headers={};}o.headers={"X-LRep-Site-Id":p.siteId};}if(p.layer){U+="&upToLayerType="+p.layer;}if(p.appDescriptor){if(p.appDescriptor["sap.app"]){if(!o.headers){o.headers={};}o.headers={"X-LRep-AppDescriptor-Id":p.appDescriptor["sap.app"].id};}}if(this._sClient){U+="&sap-client="+this._sClient;}if(c.appVersion&&(c.appVersion!==F.DEFAULT_APP_VERSION)){U+="&appVersion="+c.appVersion;}U=U.replace("&","?");return this.send(U,undefined,undefined,o).then(function(r){return{changes:r.response,messagebundle:r.response.messagebundle,componentClassName:s,etag:r.etag};},function(e){throw(e);});};
C.prototype.loadSettings=function(){var U="/sap/bc/lrep/flex/settings";if(this._sClient){U+="?sap-client="+this._sClient;}return this.send(U,undefined,undefined,{}).then(function(r){return r.response;});};
C.prototype._buildParams=function(p){if(!p){p=[];}if(this._sClient){p.push({name:"sap-client",value:this._sClient});}if(this._sLanguage){p.push({name:"sap-language",value:this._sLanguage});}var r="";var l=p.length;for(var i=0;i<l;i++){if(i===0){r+="?";}else if(i>0&&i<l){r+="&";}r+=p[i].name+"="+p[i].value;}return r;};
C.prototype._getUrlPrefix=function(i){if(i){return"/sap/bc/lrep/variants/";}return"/sap/bc/lrep/changes/";};
C.prototype.create=function(p,c,i){var r=this._getUrlPrefix(i);var P=[];if(c){P.push({name:"changelist",value:c});}r+=this._buildParams(P);return this.send(r,"POST",p,null);};
C.prototype.update=function(p,c,s,i){var r=this._getUrlPrefix(i);r+=c;var P=[];if(s){P.push({name:"changelist",value:s});}r+=this._buildParams(P);return this.send(r,"PUT",p,null);};
C.prototype.deleteChange=function(p,i){var r=this._getUrlPrefix(i);r+=p.sChangeName;var P=[];if(p.sLayer){P.push({name:"layer",value:p.sLayer});}if(p.sNamespace){P.push({name:"namespace",value:p.sNamespace});}if(p.sChangelist){P.push({name:"changelist",value:p.sChangelist});}r+=this._buildParams(P);return this.send(r,"DELETE",{},null);};
C.prototype.getStaticResource=function(n,N,t,i){var a="/sap/bc/lrep/content/";var r=a;r+=n+"/"+N+"."+t;var p=[];if(!i){p.push({name:"dt",value:"true"});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
C.prototype.getFileAttributes=function(n,N,t,l){var a="/sap/bc/lrep/content/";var r=a;r+=n+"/"+N+"."+t;var p=[];p.push({name:"metadata",value:"true"});if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
C.prototype.upsert=function(n,N,t,l,c,s,a){var b=this;return Promise.resolve(b._fileAction("PUT",n,N,t,l,c,s,a));};
C.prototype.deleteFile=function(n,N,t,l,c){return this._fileAction("DELETE",n,N,t,l,null,null,c);};
C.prototype._fileAction=function(m,n,N,t,l,c,s,a){var A="/sap/bc/lrep/content/";var r=A;r+=n+"/"+N+"."+t;var p=[];p.push({name:"layer",value:l});if(a){p.push({name:"changelist",value:a});}r+=this._buildParams(p);var o={contentType:s||this.DEFAULT_CONTENT_TYPE};return this.send(r,m.toUpperCase(),c,o);};
C.prototype.publish=function(o,n,t,O,T,s,c){var a="/sap/bc/lrep/actions/publish/";var r=a;r+=o+"/"+n+"."+t;var p=[];if(O){p.push({name:"layer",value:O});}if(T){p.push({name:"target-layer",value:T});}if(s){p.push({name:"target-namespace",value:s});}if(c){p.push({name:"changelist",value:c});}r+=this._buildParams(p);return this.send(r,"POST",{},null);};
C.prototype.listContent=function(n,l){var r="/sap/bc/lrep/content/";r+=n;var p=[];if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
return C;},true);
sap.ui.predefine('sap/ui/fl/Persistence',["sap/ui/fl/Change","sap/ui/fl/DefaultVariant","sap/ui/fl/StandardVariant","sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/LrepConnector","sap/ui/fl/Cache"],function(C,d,s,U,$,L,a){"use strict";var P=function(c,S){this._oControl=c;this._bHasLoadedChangesFromBackEnd=false;this._sStableIdPropertyName=S||'id';this._sStableId=this._getStableId();this._sComponentName=U.getComponentClassName(c);if(!this._sComponentName){U.log.error("The Control does not belong to an SAPUI5 component. Variants and Changes for this control might not work as expected.");}this._oAppDescriptor=U.getAppDescriptor(c);this._sAppVersion=U.getAppVersionFromManifest(this._oAppDescriptor);this._sSiteId=U.getSiteId(c);this._oChanges={};this._oMessagebundle={};this._oConnector=this._createLrepConnector();};
P.prototype.getComponentName=function(){return this._sComponentName;};
P.prototype.setComponentName=function(c){this._sComponentName=c;};
P.prototype._createLrepConnector=function(){var x,p;x=U.getXSRFTokenFromControl(this._oControl);p={XsrfToken:x};return L.createConnector(p);};
P.prototype._getStableId=function(){if(!this._oControl){return undefined;}if((this._sStableIdPropertyName)&&(this._sStableIdPropertyName!=='id')){var S;try{S=this._oControl.getProperty(this._sStableIdPropertyName);}catch(e){S="";}return S;}if(typeof this._oControl.getId!=='function'){return undefined;}return this._oControl.getId();};
P.prototype._existVendorLayerChange=function(){var e=false;jQuery.each(this._oChanges,function(c,o){var O=o._oOriginDefinition;if(O.layer==="VENDOR"){e=true;return false;}});return e;};
P.prototype._getOwnerComponentOfControl=function(c){if(!c){return undefined;}var o=sap.ui.core.Component.getOwnerIdFor(c);if(o){var O=sap.ui.component(o);return O;}return this._getOwnerComponentOfControl(c.getParent());};
P.prototype._checkForMessagebundleBinding=function(){if(this._existVendorLayerChange()){var o=this._getOwnerComponentOfControl(this._oControl);if(o&&!o.getModel("i18nFlexVendor")){var m=new sap.ui.model.json.JSONModel(this._oMessagebundle);o.setModel(m,"i18nFlexVendor");}}};
P.prototype.getChanges=function(){var t=this;var p={appDescriptor:this._oAppDescriptor,siteId:this._sSiteId};if(this._bHasLoadedChangesFromBackEnd===true){if(this._oMessagebundle){this._checkForMessagebundleBinding();}return Promise.resolve(this._oChanges);}return a.getChangesFillingCache(this._oConnector,{name:this._sComponentName,appVersion:this._sAppVersion},p).then(t._resolveFillingCacheWithChanges.bind(t));};
P.prototype._resolveFillingCacheWithChanges=function(f){this._fillRelevantChanges(f);if(f&&f.changes&&f.changes.messagebundle){this._oMessagebundle=f.changes.messagebundle;this._checkForMessagebundleBinding();}this._bHasLoadedChangesFromBackEnd=true;return this._oChanges;};
P.prototype.getComponentChanges=function(){var t=this;var p={appDescriptor:this._oAppDescriptor,siteId:this._sSiteId};return a.getChangesFillingCache(this._oConnector,{name:this._sComponentName,appVersion:this._sAppVersion},p).then(function(f){var n=true;t._fillRelevantChanges(f,n);return t._oChanges;});};
P.prototype._fillRelevantChanges=function(f,n){var c,l,o,S,b,j,e;var t=this;var g=function(k,h){U.log.error("key : "+k+" and text : "+h.value);};var A=function(i,v){if(n===true&&o.fileType==='change'||t._sStableId===v){b=new C(o);b.attachEvent(C.events.markForDeletion,t._onDeleteChange.bind(t));b.setState(C.states.PERSISTED);e=b.getId();if(b.isValid()){if(t._oChanges[e]&&b.isVariant()){U.log.error("Id collision - two or more variant files having the same id detected: "+e);jQuery.each(b.getDefinition().texts,g);U.log.error("already exists in variant : ");jQuery.each(t._oChanges[e].getDefinition().texts,g);}t._oChanges[e]=b;}return false;}};if(f&&f.changes&&f.changes.changes){c=f.changes.changes;l=c.length;for(j=0;j<l;j++){if(!U.isOverMaxLayer(c[j].layer)){o=c[j];S=o.selector;if(S){jQuery.each(S,A);}}}}};
P.prototype.getChange=function(c){if(!c){U.log.error("sap.ui.fl.Persistence.getChange : sChangeId is not defined");return undefined;}return this._oChanges[c];};
P.prototype.addChange=function(p){var f,i,I,c;if(!p){return undefined;}if(!p.type){U.log.error("sap.ui.fl.Persistence.addChange : type is not defined");}var b=jQuery.type(p.content);if(b!=='object'&&b!=='array'){U.log.error("mParameters.content is not of expected type object or array, but is: "+b,"sap.ui.fl.Persistence#addChange");}I={};if(typeof(p.texts)==="object"){jQuery.each(p.texts,function(e,t){I[e]={value:t,type:"XFLD"};});}var v={creation:this._sAppVersion,from:this._sAppVersion};if(this._sAppVersion&&p.developerMode){v.to=this._sAppVersion;}i={changeType:p.type,service:p.ODataService,texts:I,content:p.content,reference:this._sComponentName,isVariant:p.isVariant,packageName:p.packageName,isUserDependent:p.isUserDependent,validAppVersions:v};i.selector=this._getSelector();f=C.createInitialFileContent(i);if(p.id){f.fileName=p.id;}c=this.addChangeFile(f);return c.getId();};
P.prototype.addChangeFile=function(c){var o,b;o=new C(c);o.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));b=o.getId();this._oChanges[b]=o;return o;};
P.prototype.removeChangeFromPersistence=function(c){if(c.getPendingAction()!=='NEW'){return;}var b=c.getId();delete this._oChanges[b];};
P.prototype.putChange=function(c){c.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));var b=c.getId();this._oChanges[b]=c;};
P.prototype._getSelector=function(){var S;S={};if(this._sStableIdPropertyName){S[this._sStableIdPropertyName]=this._sStableId;}return S;};
P.prototype.getExecuteOnSelect=function(){return this.getChanges().then(function(c){return s.getExecuteOnSelect(c);});};
P.prototype.getExecuteOnSelectSync=function(){return s.getExecuteOnSelect(this._oChanges);};
P.prototype.setExecuteOnSelectSync=function(e){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={executeOnSelect:e,reference:this._sComponentName,selector:b};c=s.updateExecuteOnSelect(this._oChanges,e);if(c){return c;}c=s.createChangeObject(p);c.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));var f=c.getId();this._oChanges[f]=c;return c;};
P.prototype.setExecuteOnSelect=function(e){var p,c;var t=this;return this.getChanges().then(function(o){var b={};b[t._sStableIdPropertyName]=t._sStableId;p={executeOnSelect:e,reference:t._sComponentName,selector:b};c=s.updateExecuteOnSelect(o,e);if(c){return c;}c=s.createChangeObject(p);c.attachEvent(C.events.markForDeletion,t._onDeleteChange.bind(t));o[c.getId()]=c;return c;});};
P.prototype.getDefaultVariantId=function(){return this.getChanges().then(function(c){return d.getDefaultVariantId(c);});};
P.prototype.getDefaultVariantIdSync=function(){return d.getDefaultVariantId(this._oChanges);};
P.prototype.setDefaultVariantIdSync=function(D){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={defaultVariantId:D,reference:this._sComponentName,selector:b};c=d.updateDefaultVariantId(this._oChanges,D);if(c){return c;}c=d.createChangeObject(p);c.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));var e=c.getId();this._oChanges[e]=c;return c;};
P.prototype.setDefaultVariantId=function(D){var p,c;var t=this;return this.getChanges().then(function(o){var b={};b[t._sStableIdPropertyName]=t._sStableId;p={defaultVariantId:D,reference:t._sComponentName,selector:b};c=d.updateDefaultVariantId(o,D);if(c){return c;}c=d.createChangeObject(p);c.attachEvent(C.events.markForDeletion,t._onDeleteChange.bind(t));o[c.getId()]=c;return c;});};
P.prototype.saveAll=function(){var p=[];var t=this;jQuery.each(this._oChanges,function(i,c){switch(c.getPendingAction()){case"NEW":p.push(t._oConnector.create(c.getDefinition(),c.getRequest(),c.isVariant()).then(function(r){c.setResponse(r.response);if(a.isActive()){a.addChange({name:t._sComponentName,appVersion:t._sAppVersion},r.response);}return r;}));break;case"UPDATE":p.push(t._oConnector.update(c.getDefinition(),c.getId(),c.getRequest(),c.isVariant()).then(function(r){c.setResponse(r.response);if(a.isActive()){a.updateChange({name:t._sComponentName,appVersion:t._sAppVersion},r.response);}return r;}));break;case"DELETE":p.push(t._oConnector.deleteChange({sChangeName:c.getId(),sLayer:c.getLayer(),sNamespace:c.getNamespace(),sChangelist:c.getRequest()},c.isVariant()).then(function(r){var b=c.getId();var m={id:b};c.fireEvent(C.events.markForDeletion,m);if(a.isActive()){a.deleteChange({name:t._sComponentName,appVersion:t._sAppVersion},c.getDefinition());}return r;}));break;default:break;}});return Promise.all(p);};
P.prototype._onDeleteChange=function(e){var c;c=e.getParameter("id");var o=this.getChange(c);if(o.getPendingAction()==="DELETE"){delete this._oChanges[c];}};
P.prototype.isVariantDownport=function(){var l,i;l=U.getCurrentLayer();i=U.isHotfixMode();return((l==='VENDOR')&&(i));};
return P;},true);
sap.ui.predefine('sap/ui/fl/Preprocessor',['jquery.sap.global','sap/ui/base/Object'],function(q,B){'use strict';return B.extend("sap.ui.fl.Preprocessor",{});},true);
sap.ui.predefine('sap/ui/fl/PreprocessorImpl',['jquery.sap.global','sap/ui/core/Component','sap/ui/fl/FlexControllerFactory','sap/ui/fl/Utils','sap/ui/fl/LrepConnector','sap/ui/fl/ChangePersistenceFactory'],function(jQuery,Component,FlexControllerFactory,Utils,LrepConnector,ChangePersistenceFactory){'use strict';var PreprocessorImpl=function(){};
PreprocessorImpl.prototype.getControllerExtensions=function(c,C,a){if(a){if(!C){jQuery.sap.log.warning("No component ID for determining the anchor of the code extensions was passed.");return[];}var o=sap.ui.component(C);var A=Utils.getAppComponentForControl(o);var f=Utils.getComponentClassName(A);var s=Utils.getAppVersionFromManifest(A.getManifest());var b=ChangePersistenceFactory.getChangePersistenceForComponent(f,s);return b.getChangesForComponent().then(function(d){var e=[];jQuery.each(d,function(i,g){var h=g.getDefinition();if(h.changeType==="codeExt"&&h.content&&c===h.selector.id){e.push(PreprocessorImpl.getExtensionProvider(h));}});return e;});}};
PreprocessorImpl.getExtensionProvider=function(oChange){var sConvertedAsciiCodeContent=oChange.content.code||{};var sConvertedCodeContent=Utils.asciiToString(sConvertedAsciiCodeContent);var oExtensionProvider;eval("oExtensionProvider = "+sConvertedCodeContent);return oExtensionProvider;};
return PreprocessorImpl;},true);
sap.ui.predefine('sap/ui/fl/RegistrationDelegator',["sap/ui/fl/FlexControllerFactory","sap/ui/core/Component","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/Controller","sap/ui/core/mvc/XMLView","sap/ui/fl/EventHistory"],function(F,C,a,b,M,X,E){"use strict";var R={};
R.registerChangesInComponent=function(){C._fnOnInstanceCreated=F.getChangesAndPropagate;};
R.registerChangeHandlers=function(){a.getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs();};
R.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=b._onLoadComponent.bind(b);};
R.registerExtensionProvider=function(){M.registerExtensionProvider("sap.ui.fl.PreprocessorImpl");};
R.registerXMLPreprocessor=function(){if(X.registerPreprocessor){X.registerPreprocessor("viewxml","sap.ui.fl.XmlPreprocessorImpl",true);}};
R.registerEventListener=function(){E.start();};
R.registerAll=function(){R.registerEventListener();R.registerChangeHandlers();R.registerLoadComponentEventHandler();R.registerExtensionProvider();R.registerChangesInComponent();R.registerXMLPreprocessor();};
return R;},true);
sap.ui.predefine('sap/ui/fl/StandardVariant',["jquery.sap.global","sap/ui/fl/Change"],function($,C){"use strict";var S=function(){};
S.prototype.getExecuteOnSelect=function(c){var a=this.getNewestStandardVariantChangeDeleteTheRest(c);if(a){return a.getContent().executeOnSelect;}return null;};
S.prototype.getNewestStandardVariantChangeDeleteTheRest=function(c){var d=this.getStandardVariantChanges(c).sort(function(a,b){var D=new Date(a.getCreation());var e=new Date(b.getCreation());if(isNaN(D.getDate())){return-1;}if(isNaN(e.getDate())){return 1;}return e-D;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
S.prototype.getStandardVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(b);function a(s){return c[s];}function b(o){return o.getChangeType()==='standardVariant';}};
S.prototype.updateExecuteOnSelect=function(c,n){var N=this.getNewestStandardVariantChangeDeleteTheRest(c);if(N){var o=N.getContent();o.executeOnSelect=n;N.setContent(o);}return N;};
S.prototype._createChangeFile=function(p){var f;p.namespace=p.component+'/changes/standard';p.componentName=p.component;p.changeType='standardVariant';f=C.createInitialFileContent(p);f.content.executeOnSelect=p.executeOnSelect;f.layer='USER';return f;};
S.prototype.createChangeObject=function(p){var f,c;f=this._createChangeFile(p);c=new C(f);return c;};
return new S();},true);
sap.ui.predefine('sap/ui/fl/Utils',["jquery.sap.global","sap/ui/core/Component"],function(q,C){"use strict";var l=["VENDOR","PARTNER","CUSTOMER_BASE","CUSTOMER","USER"];var L={};l.forEach(function(s,i){L[s]=i;});var U={_aLayers:l,_mLayersIndex:L,_sTopLayer:l[l.length-1],_sMaxLayer:l[l.length-1],DEFAULT_APP_VERSION:"DEFAULT_APP_VERSION",APP_ID_AT_DESIGN_TIME:"${pro"+"ject.art"+"ifactId}",log:{error:function(m,d,c){q.sap.log.error(m,d,c);},warning:function(m,d,c){q.sap.log.warning(m,d,c);},debug:function(m,d,c){q.sap.log.debug(m,d,c);}},getXSRFTokenFromControl:function(c){var m;if(!c){return"";}if(c&&typeof c.getModel==="function"){m=c.getModel();return U._getXSRFTokenFromModel(m);}return"";},_getXSRFTokenFromModel:function(m){var h;if(!m){return"";}if(typeof m.getHeaders==="function"){h=m.getHeaders();if(h){return h["x-csrf-token"];}}return"";},getComponentClassName:function(c){var a;if(c){a=this.getAppComponentForControl(c);if(a){var v=this._getComponentStartUpParameter(a,"sap-app-id");if(v){return v;}if(a.getManifestEntry("sap.ui5")&&a.getManifestEntry("sap.ui5").appVariantId){return a.getManifestEntry("sap.ui5").appVariantId;}}}return U.getComponentName(a);},isVariantByStartupParameter:function(c){if(c){var a=this.getAppComponentForControl(c);if(a){return!!this._getComponentStartUpParameter(a,"sap-app-id");}}return false;},getAppComponentClassNameForComponent:function(c){return U.getComponentClassName(c);},getAppDescriptor:function(c){var m=null,o=null,a=null;if(c){o=this.getAppComponentForControl(c);if(o&&o.getMetadata){a=o.getMetadata();if(a&&a.getManifest){m=a.getManifest();}}}return m;},getSiteId:function(c){var s=null,o=null;if(c){o=this.getAppComponentForControl(c);if(o){s=this._getComponentStartUpParameter(o,"hcpApplicationId");}}return s;},getSiteIdByComponentData:function(c){var s=null;s=this._getStartUpParameter(c,"hcpApplicationId");return s;},isAppVariantMode:function(c){return(U.isVendorLayer()&&U.isApplicationVariant(c));},isBinding:function(p){var i=false;if(p&&typeof p==="string"&&p.substring(0,1)==="{"&&p.slice(-1)==="}"){i=true;}return i;},isVendorLayer:function(){if(U.getCurrentLayer(false)==="VENDOR"){return true;}return false;},isApplicationVariant:function(c){var f=U.getComponentClassName(c);var a=U.getAppComponentForControl(c);var s=U.getComponentName(a);return f!==s;},setMaxLayerParameter:function(m){this._sMaxLayer=m||this._sTopLayer;},getLayerIndex:function(s){return this._mLayersIndex[s];},isOverMaxLayer:function(s){return(this.getLayerIndex(s)>this.getLayerIndex(this._sMaxLayer));},isLayerAboveCurrentLayer:function(s){var c=U.getCurrentLayer(false);if(this.getLayerIndex(c)>this.getLayerIndex(s)){return-1;}else if(this.getLayerIndex(c)===this.getLayerIndex(s)){return 0;}else{return 1;}},isLayerFilteringRequired:function(){return!(this._sTopLayer===this._sMaxLayer);},_getComponentStartUpParameter:function(c,p){var s=null;if(p){if(c&&c.getComponentData){s=this._getStartUpParameter(c.getComponentData(),p);}}return s;},_getStartUpParameter:function(c,p){if(c&&c.startupParameters&&p){if(q.isArray(c.startupParameters[p])){return c.startupParameters[p][0];}}},getComponentName:function(c){var s="";if(c){s=c.getMetadata().getName();}if(s.length>0&&s.indexOf(".Component")<0){s+=".Component";}return s;},_getComponent:function(c){var o;if(c){o=sap.ui.getCore().getComponent(c);}return o;},_getComponentIdForControl:function(c){var s="",i=0;do{i++;s=U._getOwnerIdForControl(c);if(s){return s;}if(c&&typeof c.getParent==="function"){c=c.getParent();}else{return"";}}while(c&&i<100);return"";},getComponentForControl:function(c){return U._getComponentForControl(c);},getAppComponentForControl:function(c){var o;if(c instanceof sap.ui.core.Component){o=c;}else{o=this._getComponentForControl(c);}return this._getAppComponentForComponent(o);},_getComponentForControl:function(c){var o=null;var s=null;if(c){s=U._getComponentIdForControl(c);if(s){o=U._getComponent(s);}}return o;},_getAppComponentForComponent:function(c){var s=null;if(c&&c.getAppComponent){return c.getAppComponent();}if(c&&c.oComponentData&&c.oComponentData.appComponent){return c.oComponentData.appComponent;}if(c&&c.getManifestEntry){s=c.getManifestEntry("sap.app");}else{return c;}if(s&&s.type&&s.type!=="application"){if(c instanceof sap.ui.core.Component){c=this._getComponentForControl(c);}return this.getAppComponentForControl(c);}return c;},getViewForControl:function(c){return U.getFirstAncestorOfControlWithControlType(c,sap.ui.core.mvc.View);},getFirstAncestorOfControlWithControlType:function(c,a){if(c instanceof a){return c;}if(c&&typeof c.getParent==="function"){c=c.getParent();return U.getFirstAncestorOfControlWithControlType(c,a);}},hasControlAncestorWithId:function(c,a){var o;if(c===a){return true;}o=sap.ui.getCore().byId(c);while(o){if(o.getId()===a){return true;}if(typeof o.getParent==="function"){o=o.getParent();}else{return false;}}return false;},_isView:function(c){return c instanceof sap.ui.core.mvc.View;},_getOwnerIdForControl:function(c){return C.getOwnerIdFor(c);},getCurrentLayer:function(i){var u,a;if(i){return"USER";}u=this._getUriParameters();a=u.mParams["sap-ui-layer"];if(a&&a.length>0){return a[0];}return"CUSTOMER";},doesSharedVariantRequirePackage:function(){var c;c=U.getCurrentLayer(false);if((c==="VENDOR")||(c==="PARTNER")||(c==="CUSTOMER_BASE")){return true;}return false;},getClient:function(){var u,c;u=this._getUriParameters();c=u.mParams["sap-client"];if(c&&c.length>0){return c[0];}return undefined;},_getUriParameters:function(){return q.sap.getUriParameters();},isHotfixMode:function(){var u,i,I;u=this._getUriParameters();i=u.mParams["hotfix"];if(i&&i.length>0){I=i[0];}return(I==="true");},convertBrowserLanguageToISO639_1:function(b){if(!b||typeof b!=="string"){return"";}var n=b.indexOf("-");if((n<0)&&(b.length<=2)){return b.toUpperCase();}if(n>0&&n<=2){return b.substring(0,n).toUpperCase();}return"";},getCurrentLanguage:function(){var s=sap.ui.getCore().getConfiguration().getLanguage();return U.convertBrowserLanguageToISO639_1(s);},getControlType:function(c){var m;if(c&&typeof c.getMetadata==="function"){m=c.getMetadata();if(m&&typeof m.getElementName==="function"){return m.getElementName();}}},asciiToString:function(a){var b=a.split(",");var p="";q.each(b,function(i,c){p+=String.fromCharCode(c);});return p;},stringToAscii:function(s){var a="";for(var i=0;i<s.length;i++){a+=s.charCodeAt(i)+",";}a=a.substring(0,a.length-1);return a;},_fnCheckElementIsNoClone:function(e){var E=true;if(e.getBindingContext&&e.getBindingContext()){var b=e.getBindingContext().getPath().split("/");var s=b[b.length-1];E=isNaN(s);}return E;},checkControlId:function(c,a,s){var b=c instanceof sap.ui.base.ManagedObject?c.getId():c;if(!a){c=c instanceof sap.ui.base.ManagedObject?c:sap.ui.getCore().byId(b);a=U.getAppComponentForControl(c);}var i=sap.ui.base.ManagedObjectMetadata.isGeneratedId(b);if(!i||this.hasLocalIdSuffix(c,a)){return true;}else{var h=b.indexOf("--")!==-1;if(!s&&!h&&this._fnCheckElementIsNoClone(c)){this.log.warning("Generated id attribute found, to offer flexibility a stable control id is needed "+"to assign the changes to, but for this control the id was generated by SAPUI5",b);}return false;}},hasLocalIdSuffix:function(c,a){var s=(c instanceof sap.ui.base.ManagedObject)?c.getId():c;if(!a){this.log.error("determination of a local id suffix failed due to missing app component for "+s);return false;}return!!a.getLocalId(s);},_getAllUrlParameters:function(){return window.location.search.substring(1);},isDebugEnabled:function(){if(sap.ui.getCore().getConfiguration().getDebug()){return true;}var d=window["sap-ui-debug"]||"";var D=d.split(",");return D.indexOf("sap.ui.fl")!==-1;},getUrlParameter:function(p){return q.sap.getUriParameters().get(p);},createDefaultFileName:function(n){var f=q.sap.uid().replace(/-/g,"_");if(n){f+='_'+n;}return f;},createNamespace:function(p,s){var r=p.reference.replace('.Component','');var n='apps/'+r+"/"+s+"/";return n;},isApplication:function(m){return(m&&m.getEntry("sap.app")&&m.getEntry("sap.app").type==="application");},getFlexReference:function(m){if(m){if(m.getEntry("sap.ui5")){if(m.getEntry("sap.ui5").appVariantId){return m.getEntry("sap.ui5").appVariantId;}if(m.getEntry("sap.ui5").componentName){return m.getEntry("sap.ui5").componentName+".Component";}}if(m.getEntry("sap.app")&&m.getEntry("sap.app").id){var a=m.getEntry("sap.app").id;if(a===U.APP_ID_AT_DESIGN_TIME&&m.getComponentName){a=m.getComponentName();}return a+".Component";}}this.log.warning("No Manifest received.");return"";},getAppVersionFromManifest:function(m){var v="";if(m){var s=(m.getEntry)?m.getEntry("sap.app"):m["sap.app"];if(s&&s.applicationVersion&&s.applicationVersion.version){v=s.applicationVersion.version;}}else{this.log.warning("No Manifest received.");}return v;},isCustomerDependentLayer:function(s){return(["CUSTOMER","CUSTOMER_BASE"].indexOf(s)>-1);},execPromiseQueueSequentially:function(p,a){if(p.length===0){if(a){return Promise.resolve();}return new U.FakePromise();}var P=p.shift();if(typeof P==="function"){var r=P();return r.then(function(){if(!a&&r instanceof Promise){a=true;}}).catch(function(e){this.log.error("Error during execPromiseQueueSequentially processing occured: "+(e&&e.message));}.bind(this)).then(function(){return this.execPromiseQueueSequentially(p,a);}.bind(this));}else{this.log.error("Changes could not be applied, promise not wrapped inside function.");return this.execPromiseQueueSequentially(p,a);}},FakePromise:function(i,e){this.vValue=i;this.vError=e;U.FakePromise.prototype.then=function(f){if(!this.vError){try{this.vValue=f(this.vValue,true);}catch(E){this.vError=E;this.vValue=null;return this;}if(this.vValue instanceof Promise){return this.vValue;}}return this;};U.FakePromise.prototype.catch=function(f){if(this.vError){this.vValue=f(this.vError,true);this.vError=null;if(this.vValue instanceof Promise){return this.vValue;}}return this;};if(this.vValue instanceof Promise){return this.vValue;}},getChangeFromChangesMap:function(c,s){var r;Object.keys(c).forEach(function(a){c[a].some(function(o){if(o.getId()===s){r=o;return true;}});});return r;}};return U;},true);
sap.ui.predefine('sap/ui/fl/Variant',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/fl/registry/Settings"],function(q,M,U,S){"use strict";
var V=M.extend("sap.ui.fl.Variant",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){U.log.error("Constructor : sap.ui.fl.Variant : oFile is not defined");}this._oDefinition=f;this._oOriginDefinition=q.extend(true,{},f);this._sRequest='';this._bUserDependent=(f.layer==="USER");this._vRevertData=null;this.setState(V.states.NEW);},
metadata:{properties:{state:{type:"string"}}}
});
V.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};V.events={markForDeletion:"markForDeletion"};
V.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
V.prototype._isValidState=function(s){var b=false;Object.keys(V.states).some(function(k){if(V.states[k]===s){b=true;}return b;});if(!b){return false;}if((this.getState()===V.states.NEW)&&(s===V.states.DIRTY)){return false;}return true;};
V.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.content.fileType||this._oDefinition.content.fileType!=="ctrl_variant"){i=false;}if(!this._oDefinition.content.fileName){i=false;}if(!this._oDefinition.content.title){i=false;}if(!this._oDefinition.content.variantManagementReference){i=false;}if(!this._oDefinition.content.layer){i=false;}if(!this._oDefinition.content.originalLanguage){i=false;}return i;};
V.prototype.isVariant=function(){return true;};
V.prototype.getTitle=function(){if(this._oDefinition){return this._oDefinition.content.title;}};
V.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.content.fileType;}};
V.prototype.getChanges=function(){return this._oDefinition.changes;};
V.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.content.originalLanguage){return this._oDefinition.content.originalLanguage;}return"";};
V.prototype.getPackage=function(){return this._oDefinition.content.packageName;};
V.prototype.getNamespace=function(){return this._oDefinition.content.namespace;};
V.prototype.getId=function(){return this._oDefinition.content.fileName;};
V.prototype.getContent=function(){return this._oDefinition.content;};
V.prototype.setContent=function(c){this._oDefinition.content=c;this.setState(V.states.DIRTY);};
V.prototype.getVariantManagementReference=function(){return this._oDefinition.content.variantManagementReference;};
V.prototype.getVariantReference=function(){return this._oDefinition.content.variantReference;};
V.prototype.getOwnerId=function(){return this._oDefinition.content.support?this._oDefinition.content.support.user:"";};
V.prototype.getText=function(t){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Variant.getTexts : sTextId is not defined");}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){return this._oDefinition.content.texts[t].value;}}return"";};
V.prototype.setText=function(t,n){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Variant.setTexts : sTextId is not defined");return;}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){this._oDefinition.content.texts[t].value=n;this.setState(V.states.DIRTY);}}};
V.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};
V.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
V.prototype._isReadOnlyDueToLayer=function(){var c;c=U.getCurrentLayer(this._bUserDependent);return(this._oDefinition.content.layer!==c);};
V.prototype._isReadOnlyDueToOriginalLanguage=function(){var c,o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
V.prototype.markForDeletion=function(){this.setState(V.states.DELETED);};
V.prototype.setRequest=function(r){if(typeof(r)!=="string"){U.log.error("sap.ui.fl.Variant.setRequest : sRequest is not defined");}this._sRequest=r;};
V.prototype.getRequest=function(){return this._sRequest;};
V.prototype.getLayer=function(){return this._oDefinition.content.layer;};
V.prototype.getComponent=function(){return this._oDefinition.content.reference;};
V.prototype.getCreation=function(){return this._oDefinition.content.creation;};
V.prototype.isUserDependent=function(){return(this._bUserDependent);};
V.prototype.getPendingAction=function(){return this.getState();};
V.prototype.getDefinition=function(){return this._oDefinition.content;};
V.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this._oOriginDefinition=JSON.parse(R);this.setState(V.states.PERSISTED);}};
V.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().content.fileName;var F=this.getDefinition().content.fileType;return l+"/"+n+"/"+f+"."+F;};
V.prototype.getRevertData=function(){return this._vRevertData;};
V.prototype.setRevertData=function(d){this._vRevertData=d;};
V.prototype.resetRevertData=function(){this.setRevertData(null);};
V.createInitialFileContent=function(p){if(!p){p={};}var f=p.fileName||U.createDefaultFileName();var n=p.namespace||U.createNamespace(p,"variants");var N={fileName:f,title:p.title||"",fileType:"ctrl_variant",reference:p.reference||"",variantManagementReference:p.variantManagementReference,variantReference:p.variantReference||"",packageName:p.packageName||"",self:n+f+"."+"ctrl_variant",content:p.content||{},layer:p.layer||U.getCurrentLayer(p.isUserDependent),texts:p.texts||{},namespace:n,creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},support:{generator:"Variant.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version},validAppVersions:p.validAppVersions||{}};return N;};
return V;},true);
sap.ui.predefine('sap/ui/fl/XmlPreprocessorImpl',["jquery.sap.global","sap/ui/core/Component","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence"],function(q,C,F,U,L,a,b){"use strict";var X=function(){};
X.process=function(v,p){try{if(!p||p.sync){q.sap.log.warning("Flexibility feature for applying changes on an XML view is only available for "+"asynchronous views; merge is be done later on the JS controls.");return(v);}p.viewId=p.id;var c=sap.ui.getCore().getComponent(p.componentId);if(!c){U.log.warning("View is generated without a component. Flexibility features are not possible.");return Promise.resolve(v);}var A=U.getAppComponentForControl(c);var f=U.getComponentClassName(A);var s=U.getAppVersionFromManifest(A.getManifest());var o=a.getChangePersistenceForComponent(f,s);return o.getCacheKey().then(function(d){if(!d||d===b.NOTAG){U.log.warning("No cache key could be determined for the view; flexibility XML view preprocessing is skipped. "+"The processing will be done later on the JS controls.");return Promise.resolve(v);}var g=F.create(f,s);return g.processXmlView(v,p).then(function(){U.log.debug("flex processing view "+p.id+" finished");return v;});},function(){U.log.warning("Error happens when getting flex cache key! flexibility XML view preprocessing is skipped. "+"The processing will be done later on the JS controls.");return Promise.resolve(v);});}catch(e){var E="view "+p.id+": "+e;q.sap.log.info(E);return Promise.resolve(v);}};
X.getCacheKey=function(p){var c=sap.ui.getCore().getComponent(p.componentId);var A=U.getAppComponentForControl(c);if(U.isVariantByStartupParameter(A)){return Promise.resolve();}var f=U.getComponentClassName(A);var s=U.getAppVersionFromManifest(A.getManifest());var o=a.getChangePersistenceForComponent(f,s);return o.getCacheKey();};
return X;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/Base',function(){"use strict";var B={};
B.setTextInChange=function(c,k,t,T){if(!c.texts){c.texts={};}if(!c.texts[k]){c.texts[k]={};}c.texts[k].value=t;c.texts[k].type=T;};
return B;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseRename',["./Base","sap/ui/fl/Utils"],function(B,U){"use strict";var a={createRenameChangeHandler:function(r){r.changePropertyName=r.changePropertyName||"newText";return{applyChange:function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;if(o.texts&&t&&typeof(v)==="string"){c.setRevertData(m.getProperty(C,P));if(U.isBinding(v)){m.setPropertyBinding(C,P,v);}else{m.setProperty(C,P,v);}return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}},revertChange:function(c,C,p){var o=c.getRevertData();if(o||o===""){var m=p.modifier;var P=r.propertyName;m.setProperty(C,P,o);c.resetRevertData();return true;}else{U.log.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");}},completeChangeContent:function(c,s,p){var C=c.getDefinition();var b=r.changePropertyName;var t=r.translationTextType;var o=p.modifier.bySelector(c.getSelector(),p.appComponent);C.content.originalControlType=p.modifier.getControlType(o);if(typeof(s.value)==="string"){B.setTextInChange(C,b,s.value,t);}else{throw new Error("oSpecificChangeInfo.value attribute required");}}};}};return a;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseTreeModifier',["sap/ui/fl/Utils","sap/ui/base/ManagedObject"],function(U,M){"use strict";return{bySelector:function(s,a,v){var c=this.getControlIdBySelector(s,a);return this._byId(c,v);},getControlIdBySelector:function(s,a){if(!s){return undefined;}if(typeof s==="string"){s={id:s};}var c=s.id;if(s.idIsLocal){if(a){c=a.createId(c);}else{throw new Error("App Component instance needed to get a control's id from selector");}}else{var p=/^application-[^-]*-[^-]*-component---/igm;var h=!!p.exec(s.id);if(h){c=c.replace(/^application-[^-]*-[^-]*-component---/g,"");if(a){c=a.createId(c);}else{throw new Error("App Component instance needed to get a control's id from selector");}}}return c;},getSelector:function(c,a,A){var C=c;if(c instanceof M){C=c.getId();}else{if(!a){throw new Error("App Component instance needed to get a selector from string id");}}if(A&&(A.id||A.idIsLocal)){throw new Error("A selector of control with the id '"+C+"' was requested, "+"but core properties were overwritten by the additionally passed information.");}var v=U.checkControlId(c,a);if(!v){throw new Error("Generated id attribute found - to offer flexibility a stable control id is needed to assign the changes to, but for this control the id was generated by SAPUI5 "+C);}var s=jQuery.extend(A||{},{id:"",idIsLocal:false},true);if(U.hasLocalIdSuffix(c,a)){var l=a.getLocalId(C);s.id=l;s.idIsLocal=true;}else{s.id=C;}return s;}};});
sap.ui.predefine('sap/ui/fl/changeHandler/ChangeHandlerMediator',["jquery.sap.global"],function(q){"use strict";var C={};C._aChangeHandlerSettings=[];["addODataField","addODataFieldWithLabel"].forEach(function(s){["2.0","1.0"].forEach(function(v){C._aChangeHandlerSettings.push({key:{"scenario":s,"oDataServiceVersion":v},content:{"requiredLibraries":{"sap.ui.comp":{"minVersion":"1.48","lazy":false}}},scenarioInitialized:false});});});
C.addChangeHandlerSettings=function(k,s){var n;if(!(k&&s)){throw new Error('New entry in ChangeHandlerMediator requires a key and settings');}n={key:k,content:s,scenarioInitialized:false};var e=this.getChangeHandlerSettings(k,true);var i=this._aChangeHandlerSettings.indexOf(e);if(i>-1){q.extend(this._aChangeHandlerSettings[i].content,n.content);this._aChangeHandlerSettings[i].scenarioInitialized=false;}else{this._aChangeHandlerSettings.push(n);this._createChangeHandlerSettingsGetter(n);}};
C.getChangeHandlerSettings=function(k,s){var K=Object.keys(k);var f;if(K.length>0){f=this._aChangeHandlerSettings.filter(function(e,i){var E=Object.keys(e.key);if(E.length===K.length){var m=K.filter(function(a){if(e.key[a]===k[a]){return true;}});if(m.length===K.length){return true;}}})[0];if(!s&&f&&!f.scenarioInitialized){f.scenarioInitialized=this._initializeScenario(f);}}if(s||(f&&f.scenarioInitialized)){return f;}};
C._initializeScenario=function(f){var l;if(f.content.requiredLibraries){try{var L=Object.keys(f.content.requiredLibraries);L.forEach(function(s){l=s;sap.ui.getCore().loadLibrary(s);});var i=this._aChangeHandlerSettings.indexOf(f);this._aChangeHandlerSettings[i].scenarioInitialized=true;return true;}catch(e){q.sap.log.warning("Required library not available: "+l+" - "+f.key.scenario+" could not be initialized");return false;}}};
C._createChangeHandlerSettingsGetter=function(c){var g='get'+q.sap.charToUpperCase(c.key.scenario)+'Settings';if(!C[g]){C[g]=function(o){var O;var f;try{O=o.getModel().getMetaModel().getProperty("/dataServices/dataServiceVersion");}catch(e){q.sap.log.warning("Data service version could not be retrieved");}f=this.getChangeHandlerSettings({"scenario":c.key.scenario,"oDataServiceVersion":O});if(f&&f.content&&f.content.createFunction){return f;}};}};
C._aChangeHandlerSettings.forEach(function(c){C._createChangeHandlerSettingsGetter(c);});return C;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/HideControl',["jquery.sap.global"],function(q){"use strict";var H={};
H.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getVisible(C)});p.modifier.setVisible(C,false);return true;};
H.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
H.completeChangeContent=function(c,s){};
return H;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/JsControlTreeModifier',["sap/ui/fl/changeHandler/BaseTreeModifier","sap/ui/fl/Utils"],function(B,U){"use strict";var J={targets:"jsControlTree",setVisible:function(c,v){if(c.setVisible){this.unbindProperty(c,"visible");c.setVisible(v);}else{throw new Error("Provided control instance has no setVisible method");}},getVisible:function(c){if(c.getVisible){return c.getVisible();}else{throw new Error("Provided control instance has no getVisible method");}},setStashed:function(c,s){if(c.setStashed){if(c.setVisible){c.setVisible(!s);}c.setStashed(s);}else{throw new Error("Provided control instance has no setStashed method");}},getStashed:function(c){if(c.getStashed){return c.getStashed();}else{throw new Error("Provided control instance has no getStashed method");}},bindProperty:function(c,p,b){c.bindProperty(p,b);},unbindProperty:function(c,p){if(c){c.unbindProperty(p,true);}},setProperty:function(c,p,P){var m=c.getMetadata().getPropertyLikeSetting(p);this.unbindProperty(c,p);if(m){var s=m._sMutator;c[s](P);}},getProperty:function(c,p){var m=c.getMetadata().getPropertyLikeSetting(p);if(m){var P=m._sGetter;return c[P]();}},setPropertyBinding:function(c,p,P){this.unbindProperty(c,p);var s={};s[p]=P;c.applySettings(s);},getPropertyBinding:function(c,p){return c.getBindingInfo(p);},createControl:function(c,a,v,s,S){if(this.bySelector(s,a)){throw new Error("Can't create a control with duplicated id "+s);}jQuery.sap.require(c);var C=jQuery.sap.getObject(c);var i=this.getControlIdBySelector(s,a);return new C(i,S);},byId:function(i){return this._byId(i);},_byId:function(i){return sap.ui.getCore().byId(i);},getId:function(c){return c.getId();},getParent:function(c){return c.getParent();},getControlType:function(c){return U.getControlType(c);},getAllAggregations:function(p){return p.getMetadata().getAllAggregations();},getAggregation:function(p,n){if(p){if(p.getMetadata){var m=p.getMetadata();var a=m.getAllAggregations();if(a){var A=a[n];if(A){return p[A._sGetter]();}}}}},insertAggregation:function(p,n,o,i){if(p){if(p.getMetadata){var m=p.getMetadata();var a=m.getAllAggregations();if(a){var A=a[n];if(A){if(A.multiple){var I=i||0;p[A._sInsertMutator](o,I);}else{p[A._sMutator](o);}}}}}},removeAggregation:function(c,n,o){if(c){if(c.getMetadata){var m=c.getMetadata();var a=m.getAllAggregations();if(a){var A=a[n];if(A){c[A._sRemoveMutator](o);}}}}},removeAllAggregation:function(c,n){if(c){if(c.getMetadata){var m=c.getMetadata();var a=m.getAllAggregations();if(a){var A=a[n];if(A){c[A._sRemoveAllMutator]();}}}}},getBindingTemplate:function(c,a){var b=c.getBindingInfo(a);return b&&b.template;},updateAggregation:function(c,a){if(c){if(c.getMetadata){var m=c.getMetadata();var A=m.getAllAggregations();if(A){var o=A[a];if(o){c[o._sDestructor]();c.updateAggregation(a);}}}}},findIndexInParentAggregation:function(c){var p=this.getParent(c),C;if(!p){return-1;}C=this.getAggregation(p,this.getParentAggregationName(c));if(Array.isArray(C)){return C.indexOf(c);}else{return 0;}},getParentAggregationName:function(c){return c.sParentAggregationName;}};return jQuery.sap.extend(true,{},B,J);},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveControls',["jquery.sap.global","./Base","sap/ui/fl/Utils"],function(q,B,F){"use strict";var M={};M.CHANGE_TYPE="moveControls";M.SOURCE_ALIAS="source";M.TARGET_ALIAS="target";M.MOVED_ELEMENTS_ALIAS="movedElements";
M._checkConditions=function(c,m,v,a){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!C.source||!C.source.selector){throw new Error("No source supplied for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.source.selector,a,v)){throw new Error("Move source parent not found");}if(!m.bySelector(C.target.selector,a,v)){throw new Error("Move target parent not found");}if(!C.source.selector.aggregation){throw new Error("No source aggregation supplied for move");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}};
M._getElementControlOrThrowError=function(m,o,a,v){if(!m.selector&&!m.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof m.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+m.selector.id+"' in movedElements supplied");}var c=o.bySelector(m.selector||m.id,a,v);if(!c){throw new Error("Control to move was not found. Id: '"+m.selector.id+"'");}return c;};
M._checkCompleteChangeContentConditions=function(s){if(!s.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required");}if(s.movedElements.length===0){throw new Error("MovedElements array is empty");}s.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute");}if(typeof(e.sourceIndex)!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number");}if(typeof(e.targetIndex)!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number");}});};
M._getSpecificChangeInfo=function(m,s,a){delete s.source.publicAggregation;delete s.target.publicAggregation;var S=s.source.parent||m.bySelector(s.source.id,a);var t=s.target.parent||m.bySelector(s.target.id,a);var b=s.source.aggregation;var T=s.target.aggregation;var A={aggregation:s.source.aggregation,type:m.getControlType(S)};var c={aggregation:s.target.aggregation,type:m.getControlType(t)};var d={source:{id:S.getId(),aggregation:b,type:A.type,selector:m.getSelector(s.source.id,a,A)},target:{id:t.getId(),aggregation:T,type:c.type,selector:m.getSelector(s.target.id,a,c)},movedElements:s.movedElements};return d;};
M.applyChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=p.sourceAggregation||C.source.selector.aggregation;var t=m.bySelector(C.target.selector,a,v);var T=p.targetAggregation||C.target.selector.aggregation;var R=[];C.movedElements.forEach(function(b,e){var o=this._getElementControlOrThrowError(b,m,a,v);var S=m.getParent(o);var i=b.targetIndex;var I=m.findIndexInParentAggregation(o);if(I>-1){s=p.sourceAggregation||m.getParentAggregationName(o,S);R.unshift({index:I,aggregation:s,sourceParent:S});}m.removeAggregation(S,s,o);m.insertAggregation(t,T,o,i,v);},this);c.setRevertData(R);return true;};
M.revertChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=m.bySelector(C.source.selector,a,v);var S=C.source.selector.aggregation;var t=m.bySelector(C.target.selector,a,v);var T=C.target.selector.aggregation;var R=c.getRevertData();c.getContent().movedElements.reverse();C.movedElements.forEach(function(b,e){var o=this._getElementControlOrThrowError(b,m,a,v);if(!o){F.log.warning("Element to move not found");return;}var i=b.sourceIndex;if(R){s=R[e].sourceParent;S=R[e].aggregation;i=R[e].index;}m.removeAggregation(t,T,o);m.insertAggregation(s,S,o,i,v);},this);c.resetRevertData();return true;};
M.completeChangeContent=function(c,s,p){this._checkCompleteChangeContentConditions(s);var m=p.modifier;var a=p.appComponent;var C=c.getDefinition();s=this._getSpecificChangeInfo(m,s,a);C.changeType=M.CHANGE_TYPE;C.content={movedElements:[],source:{selector:s.source.selector},target:{selector:s.target.selector}};s.movedElements.forEach(function(e){var E=e.element||m.bySelector(e.id,a);C.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});});c.addDependentControl(s.source.id,M.SOURCE_ALIAS,p);c.addDependentControl(s.target.id,M.TARGET_ALIAS,p);c.addDependentControl(s.movedElements.map(function(e){return e.id;}),M.MOVED_ELEMENTS_ALIAS,p);};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveElements',["jquery.sap.global","./Base","sap/ui/fl/Utils","sap/ui/fl/changeHandler/JsControlTreeModifier"],function(q,B,F,J){"use strict";var M={};M.CHANGE_TYPE="moveElements";
M.applyChange=function(c,s,p){function a(c,m,v,A){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!c.getSelector().aggregation){throw new Error("No source aggregation supplied via selector for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.target.selector,A,v)){throw new Error("Move target parent not found");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}}function g(b,m,A,v){if(!b.selector&&!b.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof b.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+b.selector.id+"' in movedElements supplied");}return m.bySelector(b.selector||b.id,A,v);}var m=p.modifier;var v=p.view;var A=p.appComponent;a(c,m,v,A);var C=c.getContent();var t=m.bySelector(C.target.selector,A,v);var S=c.getSelector().aggregation;var T=C.target.selector.aggregation;C.movedElements.forEach(function(b){var o=g(b,m,A,v);if(!o){F.log.warning("Element to move not found");return;}m.removeAggregation(s,S,o);m.insertAggregation(t,T,o,b.targetIndex,v);});return true;};
M.completeChangeContent=function(){throw new Error('Using deprecated change handler. Please consider of using \'MoveControls\' instead');};
M.getSpecificChangeInfo=function(m,s){var S=s.source.parent||m.bySelector(s.source.id);var t=s.target.parent||m.bySelector(s.target.id);var a=s.source.aggregation;var T=s.target.aggregation;var b={source:{id:S.getId(),aggregation:a,type:m.getControlType(S)},target:{id:t.getId(),aggregation:T,type:m.getControlType(t)},movedElements:s.movedElements};return b;};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyBindingChange',["jquery.sap.global","sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(q,B,F){"use strict";var P={};
P.applyChange=function(c,C,p){var d=c.getDefinition();var s=d.content.property;var v=d.content.newBinding;var m=p.modifier;c.setRevertData({originalValue:m.getPropertyBinding(C,s)});m.setPropertyBinding(C,s,v);};
P.revertChange=function(c,C,p){var r=c.getRevertData();if(r){var d=c.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;m.setPropertyBinding(C,s,v);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}else{throw new Error("oSpecificChangeInfo attribute required");}};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyChange',["jquery.sap.global","sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(q,B,F){"use strict";var P={};
function c(C,p,v,m){try{if(F.isBinding(v)||q.isPlainObject(v)){m.setPropertyBinding(C,p,v);}else{m.setProperty(C,p,v);}}catch(e){throw new Error("Applying property changes failed: "+e);}}
P.applyChange=function(C,o,p){var d=C.getDefinition();var s=d.content.property;var v=d.content.newValue;var m=p.modifier;C.setRevertData({originalValue:m.getPropertyBinding(o,s)||m.getProperty(o,s)});c(o,s,v,m);};
P.revertChange=function(C,o,p){var r=C.getRevertData();if(r){var d=C.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;c(o,s,v,m);C.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(C,s){var o=C.getDefinition();if(s.content){o.content=s.content;}else{throw new Error("oSpecificChangeInfo attribute required");}};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/StashControl',["jquery.sap.global"],function(q){"use strict";var S={};
S.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getStashed(C)});p.modifier.setStashed(C,true);return true;};
S.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setStashed(C,r.originalValue);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
S.completeChangeContent=function(c,s){};
return S;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnhideControl',["jquery.sap.global"],function(q){"use strict";var U={};
U.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getProperty(C,'visible')});p.modifier.setVisible(C,true);return true;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(c,s){};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnstashControl',["jquery.sap.global"],function(q){"use strict";var U={};
U.applyChange=function(c,C,p){var m=c.getContent();var M=p.modifier;c.setRevertData({originalValue:p.modifier.getStashed(C)});M.setStashed(C,false);if(m.parentAggregationName){var t=m.parentAggregationName;var T=M.getParent(C);M.removeAggregation(T,t,C);M.insertAggregation(T,t,C,m.index,p.view);}return true;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setStashed(C,r.originalValue);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/XmlTreeModifier',["sap/ui/fl/changeHandler/BaseTreeModifier","sap/ui/base/DataType"],function(B,D){"use strict";var X={targets:"xmlTree",setVisible:function(c,v){if(v){c.removeAttribute("visible");}else{this.setProperty(c,"visible",v);}},getVisible:function(c){return this.getProperty(c,"visible");},setStashed:function(c,s){if(!s){c.removeAttribute("stashed");}else{this.setProperty(c,"stashed",s);}this.setVisible(c,!s);},getStashed:function(c){return this.getProperty(c,"stashed");},bindProperty:function(c,p,b){c.setAttribute(p,"{"+b+"}");},setProperty:function(c,p,P){c.setAttribute(p,P);},getProperty:function(c,p){var P=this._getControlMetadata(c).getProperty(p);var v=c.getAttribute(p);if(P){var t=P.getType();if(v===null){v=P.getDefaultValue()||t.getDefaultValue();}else{v=t.parseValue(v);}}return v;},setPropertyBinding:function(c,p,P){c.setAttribute(p,P);},getPropertyBinding:function(c,p){return c.getAttribute(p);},createControl:function(c,a,v,s,S){var i,l;if(!this.bySelector(s,a,v)){var C=c.split('.');var n="";if(C.length>1){l=C.pop();n=C.join('.');}var N=v.ownerDocument.createElementNS(n,l);i=this.getControlIdBySelector(s,a);if(i){N.setAttribute("id",i);}if(S){var V;Object.keys(S).forEach(function(k){V=S[k];N.setAttribute(k,V);});}return N;}else{throw new Error("Can't create a control with duplicated id "+i);}},_byId:function(i,v){if(v){if(v.ownerDocument&&v.ownerDocument.getElementById&&v.ownerDocument.getElementById(i)){return v.ownerDocument.getElementById(i);}else{return v.querySelector("[id='"+i+"']");}var n=jQuery.sap.byId(i,v);if(n.length===1){return n[0];}}},getId:function(c){return c.getAttribute("id");},getParent:function(c){var p=c.parentNode;if(!this.getId(p)){p=p.parentNode;}return p;},_getLocalName:function(x){return x.localName||x.baseName||x.nodeName;},getControlType:function(c){var C=c.namespaceURI;C=(C?C+".":"");C+=this._getLocalName(c);return C;},getAllAggregations:function(c){var C=this._getControlMetadata(c);return C.getAllAggregations();},getAggregation:function(p,n){var a=this._findAggregationNode(p,n);var s=this._isSingleValueAggregation(p,n);if(!a){if(s&&this._isAltTypeAggregation(p,n)){return this.getProperty(p,n);}return s?undefined:[];}var c=this._getControlsInAggregation(p,a);if(s){return c[0];}return c;},insertAggregation:function(p,n,o,i,v){var a=this._findAggregationNode(p,n);if(!a){var N=p.namespaceURI;a=this.createControl(N+"."+n,undefined,v);p.appendChild(a);}if(i>=a.childElementCount){a.appendChild(o);}else{var r=this._getControlsInAggregation(p,a)[i];a.insertBefore(o,r);}},removeAggregation:function(p,n,o){var a=this._findAggregationNode(p,n);a.removeChild(o);},removeAllAggregation:function(c,n){var a=this._findAggregationNode(c,n);if(c===a){var C=this._getControlsInAggregation(c,c);C.forEach(function(o){c.removeChild(o);});}else{c.removeChild(a);}},_findAggregationNode:function(p,n){var a;var c=this._children(p);for(var i=0;i<c.length;i++){var N=c[i];if(N.localName===n){a=N;break;}}if(!a&&this._isDefaultAggregation(p,n)){a=p;}return a;},_isDefaultAggregation:function(p,a){var c=this._getControlMetadata(p);var d=c.getDefaultAggregation();return d&&a===d.name;},_isNotNamedAggregationNode:function(p,c){var a=this.getAllAggregations(p);var A=a[c.localName];return p.namespaceURI!==c.namespaceURI||!A;},_isSingleValueAggregation:function(p,a){var A=this.getAllAggregations(p);var o=A[a];return!o.multiple;},_isAltTypeAggregation:function(p,a){var c=this._getControlMetadata(p);var A=c.getAllAggregations()[a];return!!A.altTypes;},_getControlMetadata:function(c){var C=this.getControlType(c);jQuery.sap.require(C);var a=jQuery.sap.getObject(C);return a.getMetadata();},_getControlsInAggregation:function(p,a){var c=Array.prototype.slice.call(this._children(a));return c.filter(this._isNotNamedAggregationNode.bind(this,p));},_children:function(p){if(p.children){return p.children;}else{var c=[];for(var i=0;i<p.childNodes.length;i++){var n=p.childNodes[i];if(n.nodeType===n.ELEMENT_NODE){c.push(n);}}return c;}},getBindingTemplate:function(c,a){var A=this._findAggregationNode(c,a);if(A&&this._children(A).length===1){return this._children(A)[0];}},updateAggregation:function(c,a){},findIndexInParentAggregation:function(c){var p,a,C;p=this.getParent(c);if(!p){return-1;}a=this.getParentAggregationName(c,p);C=this.getAggregation(p,a);if(Array.isArray(C)){return C.indexOf(c);}else{return 0;}},getParentAggregationName:function(c,p){var n,a;if(!p.isSameNode(c.parentNode)){n=false;}else{n=this._isNotNamedAggregationNode(p,c);}if(n){a=this._getControlMetadata(p).getDefaultAggregationName();}else{a=this._getLocalName(c.parentNode);}return a;}};return jQuery.sap.extend(true,{},B,X);},true);
sap.ui.predefine('sap/ui/fl/codeExt/CodeExtManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/Change"],function(L,U,C){"use strict";var a;a={_oLrepConnector:new L(),createOrUpdateCodeExtChange:function(p,o){if(!p.content||!p.content.codeRef){throw new Error("no code reference passed for the code extension change");}if(!p.selector||!p.selector.id){throw new Error("no controller name passed for the code extension change");}if(!p.reference){throw new Error("no reference passed for the code extension change");}p.changeType=p.changeType||"codeExt";var c=C.createInitialFileContent(p);var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";u+="?layer="+c.layer;if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}var m="PUT";return this._oLrepConnector.send(u,m,c,{});},createCodeExtChanges:function(c,o){c=c||[];if(c.length===0){return Promise.resolve();}var p=[];c.forEach(function(b){b.changeType=b.changeType||"codeExt";b.packageName=o.packageName;b.content={codeRef:o.codeRef};p.push(C.createInitialFileContent(b));});return this._oLrepConnector.create(p,o.transportId);},deleteCodeExtChange:function(c,o){if(c.changeType!=="codeExt"||c.fileType!=="change"){throw new Error("the change is not of type 'code extension'");}if(!c.fileName){throw new Error("the extension does not contains a file name");}if(c.namespace===undefined){throw new Error("the extension does not contains a namespace");}var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";if(c.layer){u+="&layer="+c.layer;}if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}u=u.replace("&","?");var m="DELETE";return this._oLrepConnector.send(u,m,c,{});}};return a;},true);
sap.ui.predefine('sap/ui/fl/context/BaseContextProvider',['sap/ui/base/ManagedObject'],function(M){"use strict";
var B=M.extend("sap.ui.fl.context.BaseContextProvider",{metadata:{properties:{text:{type:"String"},description:{type:"String"}}}});
B.prototype.loadData=function(){return Promise.resolve({});};
B.prototype.getValue=function(r){return this.loadData().then(function(d){var R=r&&r.split(".")||[];var m=R.reduce(function(c,C){if(c&&c.hasOwnProperty(C)){return c[C];}return undefined;},d);return m;});};
B.prototype.getValueHelp=function(r){return Promise.resolve({});};
B.prototype.validate=function(k,v){return Promise.resolve(true);};
return B;},true);
sap.ui.predefine('sap/ui/fl/context/Context',['sap/ui/base/ManagedObject'],function(M){"use strict";
var C=M.extend("sap.ui.fl.context.Context",{metadata:{library:"sap.ui.fl",properties:{configuration:{type:"object"},content:{type:"object"}},aggregations:{contextProviders:{type:"object",multiple:true}},events:{}}});
C.prototype.getValue=function(R){return this._getProviderContent(R,"getValue");};
C.prototype.getValueHelp=function(R){return this._getProviderContent(R,"getValueHelp");};
var r=function(d,R){if(d.indexOf(R)!==-1){return undefined;}if(R.indexOf(d+".")!==-1){return R.substring(d.length+1);}throw new Error("Invalid request for sap.ui.fl.context - domain:"+d+"request:"+R);};
C.prototype._getProviderContent=function(R,p){var t=this;var P=[];var a=[];var h=function(s){var A=t._assureDomain(s);if(A){var o=t._loadProvider(A);P.push(o);a.push({domain:A,request:r(A,s)});}else{a.push({domain:undefined,request:s});}};var m=function(D){var c=t.getConfiguration();var b=false;for(var i=0;i<D.length;i++){var o=D[i];if(o){c[o.domain]=o.provider;b=true;}}if(b){t.setConfiguration(c);}};if(R instanceof Array){R.forEach(function(s){h(s);});}else if(R===undefined){for(var d in this.getConfiguration()){P.push(this._loadProvider(d));}a=Object.keys(this.getConfiguration()).map(function(d){return{domain:d,request:undefined};});}return Promise.all(P).then(m).then(function(){return t._mergeProviderContent(a,p,R);});};
C.prototype._assureDomain=function(d){var c=this.getConfiguration();if(c.hasOwnProperty(d)){return d;}else{var k=Object.keys(c);for(var i=0;i<k.length;i++){var K=k[i];if(d.indexOf(K)===0||K.indexOf(d)===0){return K;}}}return null;};
C.prototype._loadProvider=function(d,c){var a=this.getConfiguration()[d];if(typeof(a)==="string"){return new Promise(function(b,e){try{sap.ui.require([a],function(P){var p=new P();b({"domain":d,"provider":p});});}catch(E){jQuery.sap.log.error(E);b();return;}});}else{return Promise.resolve();}};
C.prototype._mergeProviderContent=function(R,p,a){var P=[];var c=this.getConfiguration();R.forEach(function(o){if(c.hasOwnProperty(o.domain)){var A=c[o.domain];if(A instanceof sap.ui.fl.context.BaseContextProvider){P.push(A[p].call(A,o.request).then(function(v){var s={};var b=o.domain;if(o.request){b=b+"."+o.request;}s[b]=v;return s;}));}}else{var s={};s[o.request]=undefined;P.push(Promise.resolve(s));}});return Promise.all(P).then(function(b){return b.reduce(function(m,d){var k=Object.keys(d)[0];m[k]=d[k];return m;},{});});};
return C;},true);
sap.ui.predefine('sap/ui/fl/context/ContextManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/context/Context"],function(L,U,C){"use strict";var a;a={_oContext:new C({configuration:{"device":"sap/ui/fl/context/DeviceContextProvider","switches":"sap/ui/fl/context/SwitchContextProvider"}}),_oLrepConnector:new L(),doesContextMatch:function(c,A){var s=c.context||"";if(!s){return true;}return jQuery.inArray(s,A)!==-1;},getActiveContexts:function(c){var d=this._getContextIdsFromUrl();if(d.length===0){return this._getContextParametersFromAPI(c).then(this._getActiveContextsByAPIParameters.bind(this,c));}else{return Promise.resolve(this._getActiveContextsByUrlParameters(c,d));}},_getContextParametersFromAPI:function(c){var r=[];c.forEach(function(o){o.parameters.forEach(function(b){var s=b.selector;if(r.indexOf(s)===-1){r.push(s);}});});return this._oContext.getValue(r);},_getActiveContextsByAPIParameters:function(c,r){var t=this;var A=[];c.forEach(function(o){if(t._isContextObjectActive(o,r)){A.push(o.id);}});return A;},_getActiveContextsByUrlParameters:function(c,d){var A=[];c.forEach(function(o){var b=jQuery.inArray(o.id,d)!==-1;if(b){A.push(o.id);}});return A;},_isContextObjectActive:function(c,r){var t=this;var b=true;var p=c.parameters;p.every(function(P){b=b&&t._checkContextParameter(P,r);return b;});return b;},_getContextIdsFromUrl:function(){var c=U.getUrlParameter("sap-ui-flexDesignTimeContext");if(!c){return[];}return c.split(",");},_checkContextParameter:function(p,r){var s=p.selector;var o=p.operator;var v=p.value;switch(o){case"EQ":return this._checkEquals(s,v,r);case"NE":return!this._checkEquals(s,v,r);default:jQuery.sap.log.info("A context within a flexibility change with the operator '"+o+"' could not be verified");return false;}},_checkEquals:function(s,v,r){return r[s]===v;},createOrUpdateContextObject:function(p){if(!p.reference){throw new Error("no reference passed for the context object");}if(!p.namespace){throw new Error("no namespace passed for the context object");}var i=p.id||U.createDefaultFileName();p={id:i,fileName:i,title:p.title||"",description:p.description||"",parameters:p.parameters||[],fileType:"context",reference:p.reference||"",packageName:p.packageName||"",layer:p.layer||U.getCurrentLayer(false),namespace:p.namespace,creation:p.creation||"",originalLanguage:p.originalLanguage||U.getCurrentLanguage(),support:p.support||{generator:"",service:"",user:""},validAppVersions:p.validAppVersions||{}};var u="/sap/bc/lrep/content/"+p.namespace+p.fileName+".context";u+="?layer="+p.layer;var m="PUT";return this._oLrepConnector.send(u,m,p,{});}};return a;},true);
sap.ui.predefine('sap/ui/fl/context/DeviceContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/Device"],function(B,D){"use strict";
var a=B.extend("sap.ui.fl.context.DeviceContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Device"},description:{type:"String",defaultValue:"Returns the values of sap.ui.Device"}}}});
a.prototype.loadData=function(){return Promise.resolve(D);};
a.prototype.getValueHelp=function(){return Promise.resolve({});};
a.prototype.validate=function(k,v){return Promise.resolve(true);};
return a;},true);
sap.ui.predefine('sap/ui/fl/context/SwitchContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/fl/Cache"],function(B,C){"use strict";
var S=B.extend("sap.ui.fl.context.SwitchContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Switch"},description:{type:"String",defaultValue:"Returns the values of switches recieved in the flexibility response from the back end"}}}});
S.prototype.loadData=function(){return Promise.resolve(C.getSwitches());};
S.prototype.getValueHelp=function(){return Promise.resolve({});};
S.prototype.validate=function(k,v){return Promise.resolve(true);};
return S;},true);
sap.ui.predefine('sap/ui/fl/core/EventDelegate',["jquery.sap.global","sap/ui/fl/Utils","sap/ui/base/EventProvider","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/core/FlexVisualizer"],function(q,U,E,C,F){"use strict";var a=function(c,s){if(!c){U.log.error("sap.ui.fl.core.EventDelegate: Control required");}if(!s){U.log.error("sap.ui.fl.core.EventDelegate: Supported registry items required");}E.apply(this);this._oControl=c;this._oSupportedRegistryItems=s;};a.prototype=q.sap.newObject(E.prototype);
a.registerControl=function(c){if(c){var i=0;if(c.aDelegates){for(i=0;i<c.aDelegates.length;i++){var t="";if(c.aDelegates[i].oDelegate&&c.aDelegates[i].oDelegate.getType){t=(c.aDelegates[i].oDelegate.getType());}if(t==="Flexibility"){return;}}}a.registerExplicitChanges(c);}};
a.registerExplicitChanges=function(c){var r=C.getInstance();var p={controlType:U.getControlType(c)};var s=r.getRegistryItems(p);if(Object.keys(s).length>0){c.addEventDelegate(new a(c,s));}};
a.unregisterControl=function(){};
a.prototype.onmouseover=function(e){e.stopPropagation();if(e.handled){return;}else{e.handled=true;}if(F.isPersonalizationMode()){if(this._oControl&&!q(this._oControl.getDomRef()).hasClass("sapuiflex-highlight")){F.showDialog(this._oControl);}}};
a.prototype.onmouseout=function(e){if(F.isPersonalizationMode()){if(this._oControl){F.closeDialog();}}};
return a;},true);
sap.ui.predefine('sap/ui/fl/core/FlexVisualizer',["jquery.sap.global"],function(q){"use strict";var F=function(){};
F.showDialog=function(a,i){};
F.closeDialog=function(){};
return F;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory',["sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence","sap/ui/fl/Change","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/registry/Settings","sap/ui/fl/Utils"],function(C,a,b,U,S,F){"use strict";var D=function(m,i,s){this._mChangeFile=m;this._mChangeFile.packageName='$TMP';this._oInlineChange=i;this._sTransportRequest=null;this._oSettings=s;};
D.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
D.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._mChangeFile.packageName=p;return Promise.resolve();};
D.prototype.submit=function(){this.store();var o=this._getChangePersistence(this._mChangeFile.reference);return o.saveDirtyChanges();};
D.prototype.store=function(){var s=this._mChangeFile.reference;var A=this._mChangeFile.validAppVersions.creation;var o=this._getChangePersistence(s,A);var d=this._getChangeToSubmit();o.addChange(d);return d;};
D.prototype._getChangePersistence=function(s,A){return C.getChangePersistenceForComponent(s,A);};
D.prototype._getChangeToSubmit=function(){var o=new b(this._getMap());if(this._sTransportRequest){o.setRequest(this._sTransportRequest);}else if(this._oSettings.isAtoEnabled()&&F.isCustomerDependentLayer(this._mChangeFile.layer)){o.setRequest('ATO_NOTIFICATION');}return o;};
D.prototype._getMap=function(){var i=this._oInlineChange.getMap();this._mChangeFile.content=i.content;this._mChangeFile.texts=i.texts;return this._mChangeFile;};
D.prototype.getJson=function(){return jQuery.extend(true,{},this._getMap());};
var c=function(){};
c.prototype.createNew=function(r,i,l,A){var s=function(_,I){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(I);}};s(i,r);var d;if(A){var m=A.getManifest();d=F.getAppVersionFromManifest(m);}var p={};p.changeType=i._getChangeType();p.componentName=r;p.reference=r;p.validAppVersions=d?{"creation":d,"from":d}:{};if(!l){p.layer='CUSTOMER';}else{if(l!='VENDOR'&&l!='PARTNER'&&!F.isCustomerDependentLayer(l)){throw new Error("Parameter \"layer\" needs to be 'VENDOR', 'PARTNER' or customer dependent");}p.layer=l;}var e=b.createInitialFileContent(p);return S.getInstance().then(function(o){return Promise.resolve(new D(e,i,o));});};
return c;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory',["sap/ui/fl/descriptorRelated/internal/Utils"],function(U){"use strict";var D=function(c,p,t){U.checkTexts(t);this._mParameters={};this._mParameters.changeType=c;this._mParameters.content=p;this._mParameters.texts=t;};
D.prototype._getChangeType=function(){return this._mParameters.changeType;};
D.prototype.getMap=function(){return this._mParameters;};
var a={};
a.getDescriptorChangeTypes=function(){return["appdescr_ovp_addNewCard","appdescr_ovp_removeCard","appdescr_app_addNewInbound","appdescr_app_changeInbound","appdescr_app_removeInbound","appdescr_app_removeAllInboundsExceptOne","appdescr_app_addNewOutbound","appdescr_app_changeOutbound","appdescr_app_removeOutbound","appdescr_app_addNewDataSource","appdescr_app_changeDataSource","appdescr_app_removeDataSource","appdescr_app_addAnnotationsToOData","appdescr_app_addTechnicalAttributes","appdescr_app_removeTechnicalAttributes","appdescr_app_setTitle","appdescr_app_setSubTitle","appdescr_app_setShortTitle","appdescr_app_setDescription","appdescr_app_setInfo","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_ui5_addNewModel","appdescr_ui5_replaceComponentUsage","appdescr_smb_addNamespace","appdescr_smb_changeNamespace","appdescr_ui_generic_app_setMainPage","appdescr_ui_setIcon","appdescr_ui5_addLibraries","appdescr_flp_setFccApp"];};
a.createNew=function(c,p,t){var d=new D(c,p,t);return new Promise(function(r,b){if(d){r(d);}else{var e={};b(e);}});};
a._createDescriptorInlineChange=function(d,p,t){var o=new D(d,p,t);return new Promise(function(r,b){if(o){r(o);}else{var e={};b(e);}});};
a.createDescriptorInlineChange=function(d,p,t){return this._createDescriptorInlineChange(d,p,t);};
a.create_ovp_addNewCard=function(p,t){U.checkParameterAndType(p,"card","object");return this._createDescriptorInlineChange('appdescr_ovp_addNewCard',p,t);};
a.create_ovp_removeCard=function(p){U.checkParameterAndType(p,"cardId","string");return this._createDescriptorInlineChange('appdescr_ovp_removeCard',p);};
a.create_app_addNewInbound=function(p,t){U.checkParameterAndType(p,"inbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewInbound',p,t);};
a.create_app_removeInbound=function(p){U.checkParameterAndType(p,"inboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeInbound',p);};
a.create_app_removeAllInboundsExceptOne=function(p){U.checkParameterAndType(p,"inboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeAllInboundsExceptOne',p);};
a.create_app_changeInbound=function(p,t){U.checkParameterAndType(p,"inboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeInbound',p,t);};
a.create_app_addNewOutbound=function(p){U.checkParameterAndType(p,"outbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewOutbound',p);};
a.create_app_removeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeOutbound',p);};
a.create_app_changeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeOutbound',p);};
a.create_app_addNewDataSource=function(p){U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addNewDataSource',p);};
a.create_app_removeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");return this._createDescriptorInlineChange('appdescr_app_removeDataSource',p);};
a.create_app_changeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeDataSource',p);};
a.create_app_addAnnotationsToOData=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkParameterAndType(p,"annotations","array");U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addAnnotationsToOData',p);};
a.create_app_setTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.title";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setSubTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setSubTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.subTitle";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setShortTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setShortTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.shortTitle";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setDescription=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setDescription',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.description";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setInfo=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setInfo',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.info";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setDestination=function(p){U.checkParameterAndType(p,"destination","object");return this._createDescriptorInlineChange('appdescr_app_setDestination',p);};
a.create_app_setKeywords=function(p,t){U.checkParameterAndType(p,"keywords","array");return this._createDescriptorInlineChange('appdescr_app_setKeywords',p,t);};
a.create_app_addTechnicalAttributes=function(p){U.checkParameterAndType(p,"technicalAttributes","array");return this._createDescriptorInlineChange('appdescr_app_addTechnicalAttributes',p);};
a.create_app_removeTechnicalAttributes=function(p){U.checkParameterAndType(p,"technicalAttributes","array");return this._createDescriptorInlineChange('appdescr_app_removeTechnicalAttributes',p);};
a.create_ui5_addNewModel=function(p){U.checkParameterAndType(p,"model","object");return this._createDescriptorInlineChange('appdescr_ui5_addNewModel',p);};
a.create_ui5_replaceComponentUsage=function(p){U.checkParameterAndType(p,"componentUsageId","string");U.checkParameterAndType(p,"componentUsage","object");return this._createDescriptorInlineChange('appdescr_ui5_replaceComponentUsage',p);};
a.create_ui5_addLibraries=function(p){U.checkParameterAndType(p,"libraries","object");return this._createDescriptorInlineChange('appdescr_ui5_addLibraries',p);};
a.create_smb_addNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_addNamespace',p);};
a.create_smb_changeNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_changeNamespace',p);};
a.create_ui_generic_app_setMainPage=function(p,t){U.checkParameterAndType(p,"page","object");return this._createDescriptorInlineChange('appdescr_ui_generic_app_setMainPage',p,t);};
a.create_ui_setIcon=function(p){U.checkParameterAndType(p,"icon","string");return this._createDescriptorInlineChange('appdescr_ui_setIcon',p);};
a.create_flp_setFccApp=function(p){U.checkParameterAndType(p,"fccApp","string");return this._createDescriptorInlineChange('appdescr_flp_setFccApp',p);};
return a;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory',["sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/registry/Settings"],function(D,F,L,U,S){"use strict";var a=function(p,f,d,s){if(p&&d){this._id=p.id;this._mode='DELETION';this._mMap=f;}else if(p){this._id=p.id;this._reference=p.reference;this._layer=p.layer;if(typeof p.isAppVariantRoot!=undefined){this._isAppVariantRoot=p.isAppVariantRoot;}if(typeof p.referenceVersion!=undefined){this._referenceVersion=p.referenceVersion;}this._mode='NEW';}else if(f){this._mMap=f;this._mode='FROM_EXISTING';}this._oSettings=s;this._sTransportRequest=null;this._content=[];};
a.prototype.addDescriptorInlineChange=function(d){var t=this;return new Promise(function(r){var s=function(_,i){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(i);}};switch(t._mode){case'NEW':s(d,t._id);t._content.push(d.getMap());break;case'FROM_EXISTING':s(d,t._mMap.id);t._mMap.content.push(d.getMap());break;default:}r(null);});};
a.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
a.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._package=p;return Promise.resolve();};
a.prototype.submit=function(){var r='/sap/bc/lrep/appdescr_variants/';var m;switch(this._mode){case'NEW':m='POST';break;case'FROM_EXISTING':m='PUT';r=r+this._getMap().id;break;case'DELETION':m='DELETE';r=r+this._id;break;default:}var M=this._getMap();if(this._sTransportRequest){r+='?changelist='+this._sTransportRequest;}else if(this._oSettings.isAtoEnabled()&&F.isCustomerDependentLayer(M.layer)){r+='?changelist=ATO_NOTIFICATION';}var l=L.createConnector();return l.send(r,m,M);};
a.prototype.getJson=function(){return jQuery.extend(true,{},this._getMap());};
a.prototype._getMap=function(){switch(this._mode){case'NEW':var r={"fileName":this._getNameAndNameSpace().fileName,"fileType":"appdescr_variant","namespace":this._getNameAndNameSpace().namespace,"layer":this._layer,"packageName":this._package?this._package:"$TMP","reference":this._reference,"id":this._id,"content":this._content};if(typeof this._isAppVariantRoot!=undefined){r.isAppVariantRoot=this._isAppVariantRoot;}if(typeof this._referenceVersion!=undefined){r.referenceVersion=this._referenceVersion;}return r;case'FROM_EXISTING':case'DELETION':{return this._mMap;}default:}};
a.prototype._getNameAndNameSpace=function(){return U.getNameAndNameSpace(this._id,this._reference);};
var b={};
b._getDescriptorVariant=function(i){var r='/sap/bc/lrep/appdescr_variants/'+i;var l=L.createConnector();return l.send(r,'GET');};
b.createNew=function(p){U.checkParameterAndType(p,"reference","string");U.checkParameterAndType(p,"id","string");if(!p.layer){p.layer='CUSTOMER';}else{U.checkParameterAndType(p,"layer","string");if(p.layer!='VENDOR'&&p.layer!='PARTNER'&&!F.isCustomerDependentLayer(p.layer)){throw new Error("Parameter \"layer\" needs to be 'VENDOR', 'PARTNER' or customer dependent");}}if(p.isAppVariantRoot){U.checkParameterAndType(p,"isAppVariantRoot","boolean");}return S.getInstance().then(function(s){return Promise.resolve(new a(p,null,false,s));});};
b.createForExisting=function(i){if(i===undefined||typeof i!=="string"){throw new Error("Parameter \"sId\" must be provided of type string");}var _;return b._getDescriptorVariant(i).then(function(r){_=r;return S.getInstance();}).then(function(s){var d=_.response;if(!jQuery.isPlainObject(d)){d=JSON.parse(d);}return Promise.resolve(new a(null,d,false,s));});};
b.createDeletion=function(i){if(i===undefined||typeof i!=="string"){throw new Error("Parameter \"sId\" must be provided of type string");}var p={};p.id=i;var _;return b._getDescriptorVariant(i).then(function(r){_=r;return S.getInstance();}).then(function(s){var d=JSON.parse(_.response);return Promise.resolve(new a(p,d,true,s));});};
return b;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/internal/Utils',function(){"use strict";var U=function(){};
U.prototype.getNameAndNameSpace=function(i,r){return{"fileName":"manifest","namespace":"apps/"+r+"/appVariants/"+i+"/"};};
U.prototype.checkEntityPropertyChange=function(p){this.checkParameterAndType(p,"entityPropertyChange","object");this.checkParameterAndType(p.entityPropertyChange,"propertyPath","string");this.checkParameterAndType(p.entityPropertyChange,"operation","string");if(jQuery.inArray(p.entityPropertyChange.operation,['INSERT','UPDATE','UPSERT','DELETE'])<0){throw new Error("Parameter \"entityPropertyChange.operation\" needs to be one of 'INSERT', 'UPDATE', 'UPSERT', 'DELETE'");}if(p.entityPropertyChange.propertyValue===undefined&&p.entityPropertyChange.operation!=='DELETE'){throw new Error("No parameter \"entityPropertyChange.propertyValue\" provided");}};
U.prototype.checkParameterAndType=function(p,P,t){if(t==="array"){if(p===undefined||p[P]===undefined||!Array.isArray(p[P])){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}else{if(p===undefined||p[P]===undefined||typeof p[P]!==t){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}};
U.prototype.checkTexts=function(t){if(t!==undefined&&typeof t!=="object"){throw new Error("Wrong format for provided \"texts\" parameter");}};
U.prototype.checkTransportRequest=function(t){if(!/^[A-Z0-9]{1,20}$/.test(t)&&t!=='ATO_NOTIFICATION'){throw new Error("Wrong format for provided \"sTransportRequest\" parameter");}};
U.prototype.checkPackage=function(p){if(!/^[A-Z0-9/_]{1,30}$/.test(p)){throw new Error("Wrong format for provided \"sPackage\" parameter");}};
return new U();},true);
sap.ui.predefine('sap/ui/fl/fieldExt/Access',["jquery.sap.storage"],function(S){"use strict";var A={};A._sStorageKey="sap.ui.fl.fieldExt.Access";A._iValidityPeriod=1*7*24*60*60*1000;
A.getBusinessContexts=function(s,e,E){var o=this._parseServiceUri(s);var b=this._buildBusinessContextRetrievalUri(o.serviceName,o.serviceVersion,e,E);var a=this._getAjaxSettings();var p=this._executeAjaxCall(b,a,o.serviceName,o.serviceVersion,e,E);return p;};
A.isServiceOutdated=function(s){if(!this._isSystemInfoAvailable()){return false;}var m=this._getServiceItem(this._createServiceItem(s));if(m){if(this._isServiceExpired(m)){this.setServiceValid(s);return false;}else{return true;}}else{return false;}};
A.setServiceValid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();delete d[this._createServiceItem(s).serviceKey];this._setDataToLocalStorage(d);}};
A.setServiceInvalid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();var i=this._createServiceItem(s);d[i.serviceKey]=i;this._setDataToLocalStorage(d);}};
A._parseServiceUri=function(s){var r=/.*sap\/opu\/odata\/([^\/]+)\/([^\/]+)/i;var R=/([^;]+);v=(\d{1,4})/i;var o="sap/opu/odata";var a;if(s.toLowerCase().indexOf(o)!==-1){var b=s.match(r);if(!b||b.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseService","Malformed service URI (Invalid service name)");}if(b[1].toLowerCase()!=="sap"){a="/"+b[1]+"/"+b[2];}else{a=b[2];}}else{if(s.length>0&&s.lastIndexOf("/")+1===s.length){s=s.substring(0,s.length-1);}a=s.substring(s.lastIndexOf("/")+1);}if(a.indexOf(";v=")!==-1){var v=a.match(R);if(!v||v.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseService","Malformed service URI (Invalid version)");}return{serviceName:v[1],serviceVersion:v[2]};}else{return{serviceName:a,serviceVersion:'0001'};}};
A._buildBusinessContextRetrievalUri=function(s,a,e,E){if(e==null){e="";}if(E==null){E="";}if(((E.length===0)&&(e.length===0))||(!(E.length===0)&&!(e.length===0))){throw new Error("sap.ui.fl.fieldExt.Access._buildBusinessContextRetrievalUri()"+"Inconsistent input parameters EntityName: "+e+" EntitySet: "+E);}var b="/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/GetBusinessContextsByEntityType?"+"EntitySetName=\'"+E+"\'"+"&EntityTypeName=\'"+e+"\'"+"&ServiceName=\'"+s+"\'"+"&ServiceVersion=\'"+a+"\'"+"&$format=json";return b;};
A._executeAjaxCall=function(b,r,s,a,e,E){var t=this;var d=jQuery.Deferred();jQuery.ajax(b,r).done(function(c,f,j){var B=[];if(c){B=t._extractBusinessContexts(c);}var R={BusinessContexts:B,ServiceName:s,ServiceVersion:a};d.resolve(R);}).fail(function(j,c,f){var g=t._getMessagesFromXHR(j);var o={errorOccured:true,errorMessages:g,serviceName:s,serviceVersion:a,entityType:e,entitySet:E};d.reject(o);});return d.promise();};
A._getAjaxSettings=function(){var s={type:"GET",async:true,dataType:"json"};return s;};
A._extractBusinessContexts=function(d){var r=null;var b=[];if(d&&d.d){r=d.d.results;}if(r!==null&&r.length>0){for(var i=0;i<r.length;i++){if(r[i].BusinessContext!==null){b.push(r[i].BusinessContext);}}}return b;};
A._getMessagesFromXHR=function(x){var m=[];try{var E=JSON.parse(x.responseText);if(E&&E.error&&E.error.message&&E.error.message.value&&E.error.message.value!==''){m.push({severity:"error",text:E.error.message.value});}else{m.push({severity:"error",text:x.responseText});}}catch(e){}return m;};
A._getCurrentTime=function(){return Date.now();};
A._isServiceExpired=function(s){return s.expirationDate<=this._getCurrentTime();};
A._getLocalStorage=function(){return jQuery.sap.storage(jQuery.sap.storage.Type.local);};
A.isLocalStorageAvailable=function(){return this._getLocalStorage()&&this._getLocalStorage().isSupported();};
A._getServiceItem=function(s){return this._getDataFromLocalStorage()[s.serviceKey]||null;};
A._createServiceItem=function(s){var e=this._getCurrentTime()+this._iValidityPeriod;var m=this._getSystemInfo();var p=this._extractServiceInfo(s);return{"serviceKey":m.getName()+m.getClient()+p.serviceName+p.serviceVersion,"expirationDate":e};};
A._extractServiceInfo=function(s){if(typeof s==="string"){return this._parseServiceUri(s);}else{return s;}};
A._isSystemInfoAvailable=function(){return sap&&sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getLogonSystem;};
A._getSystemInfo=function(){return sap.ushell.Container.getLogonSystem();};
A._setDataToLocalStorage=function(d){if(this.isLocalStorageAvailable()){this._getLocalStorage().put(A._sStorageKey,JSON.stringify(d));}};
A._getDataFromLocalStorage=function(){if(!this.isLocalStorageAvailable()){return{};}var s=this._getLocalStorage().get(A._sStorageKey);if(!s){return{};}else{return JSON.parse(s);}};
return A;},true);
sap.ui.predefine('sap/ui/fl/library',["sap/ui/fl/RegistrationDelegator"],function(R){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.fl",version:"1.52.12",dependencies:["sap.ui.core","sap.m"],extensions:{"sap.ui.support":{diagnosticPlugins:["sap/ui/fl/support/Flexibility"]}}});R.registerAll();return sap.ui.fl;},true);
sap.ui.predefine('sap/ui/fl/library.support',["sap/ui/support/library","sap/ui/fl/Utils","sap/ui/dt/DesignTime","sap/ui/core/Component"],function(S,U,D,C){"use strict";var a=S.Categories,A=S.Audiences,b=S.Severity;
function c(o){var p=o.sParentAggregationName,P=o.getParent();if(P&&p){var B=P.getBindingInfo(p);if(B&&o instanceof B.template.getMetadata().getClass()){return true;}else{return c(P);}}return false;}
var s={id:"stableId",audiences:[A.Application],categories:[a.Functionality],enabled:true,minversion:"1.28",title:"Stable control IDs are required for SAPUI5 flexibility services",description:"Checks whether the IDs of controls support SAPUI5 flexibility services",resolution:"Replace the generated control ID with a stable ID.\n"+"We strongly recommend that you use stable IDs for all controls in your app, not only for the ones that are currently enabled for SAPUI5 flexiblity services.\n"+"Reason: Only then you will be able to adapt the controls that will be enabled for flexibility services in future SAPUI5 versions",resolutionurls:[{text:"Documentation: Stable IDs: All You Need to Know",href:"https://sapui5.hana.ondemand.com/#docs/guide/f51dbb78e7d5448e838cdc04bdf65403.html"}],async:true,check:function(d,o,e,r){var E=e.getElements(),f,g;for(var i=0;i<E.length;i++){f=E[i];g=U.getAppComponentForControl(f);if(g){break;}}if(!g){return;}var h=new D({rootElements:[g]});h.attachEventOnce("synced",function(){var O=h.getElementOverlays();O.forEach(function(j){var f=j.getElementInstance();var k=f.getId();var H=k.indexOf("--")!==-1;if(!U.checkControlId(k,g,true)&&!c(f)){if(!H){d.addIssue({severity:b.High,details:"The ID '"+k+"' for the control was generated and flexibility features "+"cannot support controls with generated IDs.",context:{id:k}});}else{d.addIssue({severity:b.Low,details:"The ID '"+k+"' for the control was concatenated and has a generated onset.\n"+"To enable the control for flexibility features, you must specify an ID for the control providing the onset, which is marked as high issue.",context:{id:k}});}}});h.destroy();r();});}};return{name:"sap.ui.fl",niceName:"UI5 Flexibility Library",ruleset:[s]};},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeHandlerRegistration',["sap/ui/fl/registry/ChangeRegistry"],function(C){"use strict";var a={getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs:function(){var t=this;var c=sap.ui.getCore();var A=c.getLoadedLibraries();jQuery.each(A,function(l,L){if(L.extensions&&L.extensions.flChangeHandlers){t.registerFlexChangeHandlers(L.extensions.flChangeHandlers);}});c.attachLibraryChanged(this.handleLibraryRegistrationAfterFlexLibraryIsLoaded.bind(this));},registerFlexChangeHandlers:function(f){if(f){var c=C.getInstance();c.registerControlsForChanges(f);}},handleLibraryRegistrationAfterFlexLibraryIsLoaded:function(l){if(l.getParameter("operation")==="add"){var L=l.getParameter("metadata");if(L&&L.extensions&&L.extensions.flChangeHandlers){var f=L.extensions.flChangeHandlers;this.registerFlexChangeHandlers(f);}}}};return a;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistry',["sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/registry/ChangeRegistryItem","sap/ui/fl/registry/ChangeTypeMetadata","sap/ui/fl/registry/Settings","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl"],function(U,q,C,a,S,H,M,b,P,c,d,e,f){"use strict";var g=function(){this._registeredItems={};this.initSettings();this.initDeveloperModeChangeHandlers();};g._instance=undefined;g.prototype._oDefaultActiveChangeHandlers={};g.prototype._oDefaultChangeHandlers={"hideControl":H,"moveElements":M,"moveControls":b,"unhideControl":d,"stashControl":e,"unstashControl":f};g.prototype._mDeveloperModeChangeHandlers={"propertyChange":{changeHandler:P},"propertyBindingChange":{changeHandler:c}};
g.prototype.initDeveloperModeChangeHandlers=function(){Object.keys(this._mDeveloperModeChangeHandlers).forEach(function(s){var o=this._mDeveloperModeChangeHandlers[s].changeHandler;var l=this._oSettings.getDeveloperModeLayerPermissions();var h={changeType:s,changeHandler:o,layers:l};var i=this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls",h);this._oDefaultActiveChangeHandlers[s]=i;}.bind(this));};
g.getInstance=function(){if(!g._instance){g._instance=new g();}return g._instance;};
g.prototype.hasRegisteredChangeHandlersForControl=function(s){var h=Object.keys(this._registeredItems);return h.indexOf(s)!==-1;};
g.prototype.hasChangeHandlerForControlAndChange=function(s,h){if(!this.hasRegisteredChangeHandlersForControl(s)){return false;}var r=this._registeredItems[s];var i=Object.keys(r);return i.indexOf(h)!==-1;};
g.prototype.registerControlsForChanges=function(m){var t=this;q.each(m,function(s,h){if(Array.isArray(h)){var o={};h.forEach(function(i){o[i.changeType]=i.changeHandler;});t._registerChangeHandlersForControl(s,o);}else{t._registerChangeHandlersForControl(s,h);}});};
g.prototype._registerChangeHandlersForControl=function(s,o){var t=this;if(typeof o==="string"){try{o=sap.ui.requireSync(o+".flexibility");}catch(h){U.log.error("Flexibility change handler registration failed.\nControlType: "+s+"\n"+h.message);return;}}q.each(o,function(i,j){var k=t._getChangeHandler(i,j);var l={"changeType":i,"changeHandler":k.changeHandler,"layers":k.layers};t.registerControlForSimpleChange(s,l);});};
g.prototype._getChangeHandler=function(s,v){var r={};var D=Object.keys(this._mDeveloperModeChangeHandlers);if(!v.changeHandler){r.changeHandler=v;}else{r=v;}if(r.changeHandler==="default"){r.changeHandler=this._oDefaultChangeHandlers[s];}else if(D.indexOf(s)>-1){throw new Error("You can't use a custom change handler for the following Developer Mode change types: "+D.toString()+". Please use 'default' instead.");}return r;};
g.prototype.registerControlForSimpleChange=function(s,o){var h;if(!s){return;}if(!o||!o.changeType||!o.changeHandler){return;}h=this._createChangeRegistryItemForSimpleChange(s,o);if(h){this.addRegistryItem(h);}};
g.prototype._createChangeRegistryItemForSimpleChange=function(s,o){var p,h,i,l;l=q.extend({},this._oSettings.getDefaultLayerPermissions());var L=o.layers;if(L){Object.keys(L).forEach(function(j){if(l[j]===undefined){throw new Error("The Layer '"+j+"' is not supported. Please only use supported layers");}l[j]=L[j];});}p={name:o.changeType,changeHandler:o.changeHandler,layers:l};h=new a(p);p={changeTypeMetadata:h,controlType:s};i=new C(p);return i;};
g.prototype.addRegistryItem=function(r){var s,h;if(!r){return;}s=r.getChangeTypeName();h=r.getControlType();this._registeredItems[h]=this._registeredItems[h]||{};this._registeredItems[h][s]=r;};
g.prototype.removeRegistryItem=function(p){if(!p.changeTypeName&&!p.controlType){U.log.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");return;}if(p.controlType&&p.changeTypeName){if(this._registeredItems[p.controlType]){if(Object.keys(this._registeredItems[p.controlType]).length===1){delete this._registeredItems[p.controlType];}else{delete this._registeredItems[p.controlType][p.changeTypeName];}}}else if(p.controlType){if(this._registeredItems[p.controlType]){delete this._registeredItems[p.controlType];}}else if(p.changeTypeName){for(var h in this._registeredItems){var i=this._registeredItems[h];delete i[p.changeTypeName];}}};
g.prototype.getRegistryItems=function(p){if(!p){U.log.error("sap.ui.fl.registry.ChangeRegistry: no parameters passed for getRegistryItems");}var s=p.changeTypeName;var h=p.controlType;if(!s&&!h){U.log.error("sap.ui.fl.registry.ChangeRegistry: Change Type Name and/or Control Type required");}var r=null;if(h&&s){var o=this._getOrLoadChangeHandler(h,s);if(o){r={};r[h]={};r[h][s]=o;}}else if(h){r={};r[h]={};if(this._registeredItems[h]){var i=Object.keys(this._registeredItems[h]);i.forEach(function(s){r[h][s]=this._getOrLoadChangeHandler(h,s);}.bind(this));}for(var k in this._oDefaultActiveChangeHandlers){r[h][k]=this._oDefaultActiveChangeHandlers[k];}}else if(s){r={};for(h in this._registeredItems){if(this._registeredItems[h][s]){r[h]={};r[h][s]=this._getOrLoadChangeHandler(h,s);}}r["defaultActiveForAllControls"]={};for(var j in this._oDefaultActiveChangeHandlers){r["defaultActiveForAllControls"][j]=this._oDefaultActiveChangeHandlers[j];}}this._filterChangeTypes(r,p.layer);return r;};
g.prototype._getOrLoadChangeHandler=function(s,h){var o=this._registeredItems[s];if(o){var i=o[h];if(i){var j=i.getChangeTypeMetadata();var k=j.getChangeHandler();if(typeof k==="string"){q.sap.require(k);k=sap.ui.require(k);j._changeHandler=k;}return i;}}var D=this._oDefaultActiveChangeHandlers[h];if(D){return D;}return null;};
g.prototype.initSettings=function(){this._oSettings=S.getInstanceOrUndef();if(!this._oSettings){this._oSettings=new S({});}};
g.prototype._filterChangeTypes=function(r,l){if(this._oSettings&&l&&r){var i=false;q.each(r,function(s,o){q.each(o,function(h,R){var L=R.getChangeTypeMetadata().getLayers();i=L[l];if(!i){U.log.warning("Change type "+h+" not enabled for layer "+l);delete o[h];}});});}};
g.prototype.getDragInfo=function(s){var h=this._registeredItems[s];if(h){return h.getDragInfo();}return null;};
return g;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistryItem',["sap/ui/fl/Utils","jquery.sap.global"],function(U,q){"use strict";var C=function(p){if(!p.changeTypeMetadata){U.log.error("sap.ui.fl.registry.ChangeRegistryItem: ChangeTypeMetadata required");}if(!p.controlType){U.log.error("sap.ui.fl.registry.ChangeRegistryItem: ControlType required");}this._changeTypeMetadata=p.changeTypeMetadata;this._controlType=p.controlType;if(p.permittedRoles){this._permittedRoles=p.permittedRoles;}if(p.dragTargets){this._dragTargets=p.dragTargets;}};C.prototype._changeTypeMetadata=undefined;C.prototype._controlType=undefined;C.prototype._permittedRoles={};C.prototype._dragTargets=[];
C.prototype.getChangeTypeMetadata=function(){return this._changeTypeMetadata;};
C.prototype.getChangeTypeName=function(){return this._changeTypeMetadata.getName();};
C.prototype.getControlType=function(){return this._controlType;};
C.prototype.getPermittedRoles=function(){return this._permittedRoles;};
C.prototype.getDragTargets=function(){return this._dragTargets;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeTypeMetadata',["sap/ui/fl/Utils","jquery.sap.global"],function(U,q){"use strict";var C=function(p){if(!p.name){U.log.error("sap.ui.fl.registry.ChangeType: Name required");}if(!p.changeHandler){U.log.error("sap.ui.fl.registry.ChangeType: ChangeHandler required");}this._name=p.name;this._changeHandler=p.changeHandler;this._layers=p.layers;if(p.labelKey){this._labelKey=p.labelKey;}if(p.tooltipKey){this._tooltipKey=p.tooltipKey;}if(p.iconKey){this._iconKey=p.iconKey;}if(p.sortIndex){this._sortIndex=p.sortIndex;}};C.prototype._name="";C.prototype._changeHandler="";C.prototype._layers=[];C.prototype._sortIndex=0;C.prototype._labelKey="";C.prototype._tooltipKey="";C.prototype._iconKey="";
C.prototype.getName=function(){return this._name;};
C.prototype.getChangeHandler=function(){return this._changeHandler;};
C.prototype.getLayers=function(){return this._layers;};
C.prototype.getLabel=function(){return this._labelKey;};
C.prototype.getTooltip=function(){return this._tooltipKey;};
C.prototype.getIcon=function(){return this._iconKey;};
C.prototype.getSortIndex=function(){return this._sortIndex;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/Settings',["jquery.sap.global","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/Utils","sap/ui/base/EventProvider"],function(q,L,C,U,E){"use strict";var S=function(s){E.apply(this);if(!s){throw new Error("no flex settings provided");}if(!s.defaultLayerPermissions){s.defaultLayerPermissions={"VENDOR":true,"CUSTOMER_BASE":true,"CUSTOMER":true,"USER":false};}if(!s.developerModeLayerPermissions){s.developerModeLayerPermissions={"VENDOR":true,"CUSTOMER_BASE":true,"CUSTOMER":false,"USER":false};}this._oSettings=s;this._hasMergeErrorOccured=false;};S.prototype=q.sap.newObject(E.prototype);S.events={flexibilityAdaptationButtonAllowedChanged:"flexibilityAdaptationButtonAllowedChanged",changeModeUpdated:"changeModeUpdated"};S._instance=undefined;S._bFlexChangeMode=true;S._bFlexibilityAdaptationButtonAllowed=false;S._oEventProvider=new E();
S.fireEvent=function(e,p){S._oEventProvider.fireEvent(e,p);};
S.attachEvent=function(e,c){S._oEventProvider.attachEvent(e,c);};
S.detachEvent=function(e,c){S._oEventProvider.detachEvent(e,c);};
S.getInstance=function(){if(S._instance){return Promise.resolve(S._instance);}var p=C.getFlexDataPromise();if(p){return p.then(function(f){var s={};if(f.changes&&f.changes.settings){s=f.changes.settings;}return S._storeInstance(s);},function(){return S._loadSettings();});}return S._loadSettings();};
S._loadSettings=function(){return L.createConnector().loadSettings().then(function(s){return S._storeInstance(s);});};
S._storeInstance=function(s){if(!S._instance){S._instance=new S(s);}return S._instance;};
S.getInstanceOrUndef=function(){var s;if(S._instance){s=S._instance;}return s;};
S.isFlexChangeMode=function(){var f=this._isFlexChangeModeFromUrl();if(f!==undefined){return f;}return S._bFlexChangeMode;};
S._isFlexChangeModeFromUrl=function(){var f;var u=q.sap.getUriParameters();if(u&&u.mParams&&u.mParams['sap-ui-fl-changeMode']&&u.mParams['sap-ui-fl-changeMode'][0]){if(u.mParams['sap-ui-fl-changeMode'][0]==='true'){f=true;}else if(u.mParams['sap-ui-fl-changeMode'][0]==='false'){f=false;}}return f;};
S.activateFlexChangeMode=function(){var f=true;S._setFlexChangeMode(f);};
S.leaveFlexChangeMode=function(){var f=false;S._setFlexChangeMode(f);};
S._setFlexChangeMode=function(f){if(S._bFlexChangeMode===f){return;}S._bFlexChangeMode=f;var p={bFlexChangeMode:f};S.fireEvent(S.events.changeModeUpdated,p);};
S.isFlexibilityAdaptationButtonAllowed=function(){return S._bFlexibilityAdaptationButtonAllowed;};
S.allowFlexibilityAdaptationButton=function(){var f=true;S.setFlexibilityAdaptationButtonAllowed(f);};
S.disallowFlexibilityAdaptationButton=function(){var f=false;S.setFlexibilityAdaptationButtonAllowed(f);};
S.setFlexibilityAdaptationButtonAllowed=function(f){if(S._bFlexibilityAdaptationButtonAllowed===f){return;}S._bFlexibilityAdaptationButtonAllowed=f;var p={bFlexibilityAdaptationButtonAllowed:f};S.fireEvent(S.events.flexibilityAdaptationButtonAllowedChanged,p);};
S.prototype.isKeyUser=function(){var i=false;if(this._oSettings.isKeyUser){i=this._oSettings.isKeyUser;}return i;};
S.prototype.isModelS=function(){var i=false;if(this._oSettings.isAtoAvailable){i=this._oSettings.isAtoAvailable;}return i;};
S.prototype.isAtoEnabled=function(){var i=false;if(this._oSettings.isAtoEnabled){i=this._oSettings.isAtoEnabled;}return i;};
S.prototype.isAtoAvailable=function(){var i=false;if(this._oSettings.isAtoAvailable){i=this._oSettings.isAtoAvailable;}return i;};
S.prototype.isProductiveSystem=function(){var i=false;if(this._oSettings.isProductiveSystem){i=this._oSettings.isProductiveSystem;}return i;};
S.prototype.setMergeErrorOccured=function(e){this._hasMergeErrorOccoured=e;};
S.prototype.hasMergeErrorOccured=function(){return this._hasMergeErrorOccured;};
S.prototype.getDefaultLayerPermissions=function(){return this._oSettings.defaultLayerPermissions;};
S.prototype.getDeveloperModeLayerPermissions=function(){return this._oSettings.developerModeLayerPermissions;};
return S;},true);
sap.ui.predefine('sap/ui/fl/registry/SimpleChanges',["jquery.sap.global","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange"],function(q,H,U,S,a,M,b,P,c){"use strict";var d={hideControl:{changeType:"hideControl",changeHandler:H},unhideControl:{changeType:"unhideControl",changeHandler:U},stashControl:{changeType:"stashControl",changeHandler:S},unstashControl:{changeType:"unstashControl",changeHandler:a},moveElements:{changeType:"moveElements",changeHandler:M},moveControls:{changeType:"moveControls",changeHandler:b},propertyChange:{changeType:"propertyChange",changeHandler:P},propertyBindingChange:{changeType:"propertyBindingChange",changeHandler:c}};return d;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportDialog',['jquery.sap.global',"sap/m/List","sap/m/InputListItem",'sap/m/Button','sap/m/ComboBox','sap/m/Dialog','sap/m/DialogRenderer','sap/m/Input','sap/m/Label','sap/m/MessageToast','sap/ui/core/ListItem','sap/ui/fl/transport/Transports'],function(q,L,I,B,C,D,a,b,c,M,d,T){"use strict";
var e=D.extend("sap.ui.fl.transport.TransportDialog",{
metadata:{library:"sap.ui.fl",properties:{pkg:{type:"string",group:"Misc",defaultValue:null},transports:{type:"any",group:"Misc",defaultValue:null},lrepObject:{type:"any",group:"Misc",defaultValue:null},hidePackage:{type:"boolean",group:"Misc",defaultValue:null}},events:{ok:{},cancel:{}}},
renderer:a.render
});
e.prototype.init=function(){D.prototype.init.apply(this);this._oResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));this._oPackageLabel=null;this._oPackage=this._createPackageField();this._oTransport=this._createTransportCombo();this.addContent(this._createContentList());this._createButtons();};
e.prototype._createContentList=function(){this._oPackageListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),content:[this._oPackage]});this._oTransportListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),content:[this._oTransport]});return new L({items:[this._oPackageListItem,this._oTransportListItem]});};
e.prototype._createButtons=function(){var t=this;this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),press:function(){t._onLocal();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_OK"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_OK"),enabled:false,press:function(){t._onOkay();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),press:function(){t.fireCancel();t.close();t.destroy();}}));};
e.prototype._onLocal=function(){this.fireOk({selectedTransport:"",selectedPackage:this.getPkg()||"$TMP",dialog:true});this.close();this.destroy();};
e.prototype._onOkay=function(){var t=this._oTransport.getSelectedKey();if(this._checkOkay(t)){this.fireOk({selectedTransport:t,selectedPackage:this.getPkg()||this._oPackage.getValue(),dialog:true});this.close();this.destroy();}else{this.getButtons()[1].setEnabled(false);this._oTransport.setValueState(sap.ui.core.ValueState.Error);this._oTransport.setValueStateText(this.getTitle());}};
e.prototype._checkOkay=function(t){if(t){return true;}return false;};
e.prototype._createTransportCombo=function(){var t=this;return new C({showSecondaryValues:true,enabled:false,tooltip:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),width:"100%",selectionChange:function(){if(t._oPackageListItem.getVisible()&&!t._oPackage.getValue()){return;}t.getButtons()[1].setEnabled(true);t._oTransport.setValueState(sap.ui.core.ValueState.None);},change:function(E){var f=function(i){if((i&&E.mParameters.newValue!==i.getText())||!i){return true;}return false;};if(E&&E.mParameters&&E.mParameters.newValue){if(f(t._oTransport.getSelectedItem())){t.getButtons()[1].setEnabled(false);t._oTransport.setValueState(sap.ui.core.ValueState.Error);t._oTransport.setValueStateText(t._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"));}}}});};
e.prototype._createPackageField=function(){var t=this;return new b({tooltip:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),width:"100%",change:function(){var o,p,O;O=t._createObjectInfo();o=new sap.ui.fl.transport.Transports();p=o.getTransports(O);p.then(function(r){t._onPackageChangeSuccess(r);},function(r){t._onPackageChangeError(r);});},liveChange:function(E){if(E.mParameters.liveValue&&E.mParameters.liveValue.length>3){t._oTransport.setEnabled(true);}}});};
e.prototype._createObjectInfo=function(){var o,r={"package":this._oPackage.getValue()||""};o=this.getProperty("lrepObject");if(o){if(o.name){r.name=o.name;}if(o.type){r.type=o.type;}if(o.namespace){r.namespace=o.namespace;}}return r;};
e.prototype._onPackageChangeSuccess=function(t){if(t){if(t.localonly){this._oTransport.setEnabled(false);this.getButtons()[1].setEnabled(true);}else if(t.transports&&t.transports.length>0){this._oTransport.setEnabled(true);this._setTransports(t);}else if(t.errorCode){this.getButtons()[1].setEnabled(false);this._oPackage.setValueState(sap.ui.core.ValueState.Error);this._oPackage.setValueStateText(this._oResources.getText("TRANSPORT_DIALOG_"+t.errorCode));this._setTransports(t);}else{M.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"));}}};
e.prototype._setTransports=function(t){var l,f;l=this._hasLock(t.transports);if(l){f=[l];}else{f=t.transports;}this.setTransports(f);if(f&&f.length===1){this._oTransport.setValue(f[0].description,true);this.getButtons()[1].setEnabled(true);}if(!f||f.length===0){this._oTransport.setSelectedKey(null);this._oTransport.setValueState(sap.ui.core.ValueState.None);this.getButtons()[1].setEnabled(false);}};
e.prototype._onPackageChangeError=function(r){M.show(r);this.setTransports([]);};
e.prototype._hasLock=function(t){var o,l=t.length;while(l--){o=t[l];if(o.locked){return o;}}return null;};
e.prototype.setPkg=function(p){if(p&&!this.getProperty("pkg")){this.setProperty("pkg",p);this._oPackage.setValue(p);this._oPackage.setEnabled(false);this._oTransport.setEnabled(true);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));this.getButtons()[0].setVisible(false);}};
e.prototype.setTransports=function(s){var i,l=0,o;if(s){this.setProperty("transports",s);this._oTransport.removeAllItems();l=s.length;for(i=0;i<l;i++){o=s[i];this._oTransport.addItem(new d({key:o.transportId,text:o.transportId,additionalText:o.description}));}if(l===1){this._oTransport.setSelectedKey(s[0].transportId);this.getButtons()[1].setEnabled(true);}if(l>0){this._oTransport.setEnabled(true);}}};
e.prototype.setLrepObject=function(o){if(o&&!this.getProperty("lrepObject")){this.setProperty("lrepObject",o);}};
e.prototype.setHidePackage=function(h){this.setProperty("hidePackage",h);this._oPackageListItem.setVisible(!h);if(h){this.getButtons()[0].setEnabled(h);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));}};
return e;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportSelection',["jquery.sap.global","sap/ui/fl/Utils","sap/ui/fl/transport/Transports","sap/ui/fl/transport/TransportDialog","sap/ui/fl/registry/Settings"],function(q,U,T,a,F){"use strict";var b=function(){this.oTransports=new sap.ui.fl.transport.Transports();};
b.prototype.selectTransport=function(o,O,e,c,C,s){var t=this;if(o){var l=U.getCurrentLayer(false);if(l&&l==='CUSTOMER'){F.getInstance().then(function(S){if(S.isAtoEnabled()){var d={transportId:"ATO_NOTIFICATION"};O(t._createEventObject(o,d));}else{t._selectTransport(o,O,e,c,s);}});}else{t._selectTransport(o,O,e,c,s);}}};
b.prototype._selectTransport=function(o,O,e,c,s){var t=this;if(o){this.oTransports.getTransports(o).then(function(g){var d;if(t._checkDialog(g)){t._openDialog({hidePackage:!U.doesSharedVariantRequirePackage(),pkg:o.package,transports:g.transports,lrepObject:t._toLREPObject(o)},O,e,c,s);}else{d=t._getTransport(g);O(t._createEventObject(o,d));}},function(r){e(r);});}};
b.prototype._createEventObject=function(o,t){return{mParameters:{selectedTransport:t.transportId,selectedPackage:o["package"],dialog:false},getParameters:function(){return this.mParameters;},getParameter:function(n){return this.mParameters[n];}};};
b.prototype._toLREPObject=function(o){var O={};if(o.namespace){O.namespace=o.namespace;}if(o.name){O.name=o.name;}if(o.type){O.type=o.type;}return O;};
b.prototype._openDialog=function(c,o,e,C,s){var d=new a(c);d.attachOk(o);d.attachCancel(e);d.addStyleClass(s);if(C){d.addStyleClass("sapUiSizeCompact");}else{d.removeStyleClass("sapUiSizeCompact");}d.open();return d;};
b.prototype._getTransport=function(t){var o;if(!t.localonly){o=this._hasLock(t.transports);}else{o={transportId:""};}return o;};
b.prototype._checkDialog=function(t){if(t){if(t.localonly||this._hasLock(t.transports)){return false;}}return true;};
b.prototype._hasLock=function(t){var l=t.length;while(l--){var o=t[l];if(o.locked){return o;}}return false;};
b.prototype.setTransports=function(c,C){var i=c.length-1;var t=this;var s=function(c,i,C,d,f){if(i>=0){var o=c[i];if(f===true){if(o.getDefinition().packageName!=="$TMP"){o.setRequest(d);}i--;return s(c,i,C,d,f);}else{if(o.getDefinition().packageName!=="$TMP"){return t.openTransportSelection(o,C).then(function(e){o.setRequest(e.transport);if(e.fromDialog===true){d=e.transport;f=true;}i--;return s(c,i,C,d,f);},function(){return null;});}else{i--;return s(c,i,C,d,f);}}}else{return Promise.resolve();}};return s(c,i,C);};
b.prototype.openTransportSelection=function(c,C,s){var t=this;return new Promise(function(r,d){var o=function(R){if(R&&R.getParameters){var f=R.getParameters().selectedTransport;var p=R.getParameters().selectedPackage;var g=R.getParameters().dialog;var h={transport:f,packageName:p,fromDialog:g};r(h);}else{r({});}};var e=function(E){if(E.sId==='cancel'){r();}else{d(E);}};var O={};if(c){O["package"]=c.getPackage();O.namespace=c.getNamespace();O.name=c.getId();O.type=c.getDefinition().fileType;}t.selectTransport(O,o,e,false,C,s);});};
return b;},true);
sap.ui.predefine('sap/ui/fl/transport/Transports',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils"],function(L,F){"use strict";var T=function(){};
T.prototype.getTransports=function(p){var u,c,l,P;u='/sap/bc/lrep/actions/gettransports/';if(p['package']){u+='&package='+p['package'];}if(p.name){u+='&name='+p.name;}if(p.namespace){u+='&namespace='+p.namespace;}if(p.type){u+='&type='+p.type;}c=F.getClient();if(c){u+='&sap-client='+c;}u=u.replace('&','?');l=L.createConnector();P=l.send(u);return P.then(function(r){if(r.response){if(!r.response.localonly){r.response.localonly=false;}if(!r.response.errorCode){r.response.errorCode="";}return Promise.resolve(r.response);}else{return Promise.reject('response is empty');}});};
T.prototype.makeChangesTransportable=function(p){var u,c,l;u='/sap/bc/lrep/actions/make_changes_transportable/';c=F.getClient();if(c){u+='?sap-client='+c;}if(!p.transportId){return Promise.reject(new Error("no transportId provided as attribute of mParameters"));}if(!p.changeIds){return Promise.reject(new Error("no changeIds provided as attribute of mParameters"));}l=L.createConnector();return l.send(u,'POST',p);};
T.prototype._convertToChangeTransportData=function(l){var t=[];var a=l.length;for(var i=0;i<a;i++){var c=l[i];var d={};d.namespace=c.getNamespace();d.fileName=c.getId();d.fileType=c.getDefinition().fileType;t.push(d);}return t;};
return T;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantController',["jquery.sap.global","sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/fl/Variant"],function(q,U,C,V){"use strict";var a=function(c,A,o){this._sComponentName=c||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;this._setChangeFileContent(o);};
a.prototype.getComponentName=function(){return this._sComponentName;};
a.prototype.getAppVersion=function(){return this._sAppVersion;};
a.prototype._setChangeFileContent=function(c){if(c&&c.changes&&c.changes.variantSection){this._mVariantManagement={};Object.keys(c.changes.variantSection).forEach(function(v){this._mVariantManagement[v]={};var o=c.changes.variantSection[v];var b=o.variants.concat().sort(this.compareVariants);var i=-1;b.forEach(function(d,e){if(d.content.fileName===v){i=e;}});if(i>-1){var s=b.splice(i,1)[0];b.splice(0,0,s);}this._mVariantManagement[v].variants=b;this._mVariantManagement[v].defaultVariant=o.defaultVariant;}.bind(this));}};
a.prototype._getChangeFileContent=function(){return this._mVariantManagement;};
a.prototype.compareVariants=function(v,o){if(v.content.title.toLowerCase()<o.content.title.toLowerCase()){return-1;}else if(v.content.title.toLowerCase()>o.content.title.toLowerCase()){return 1;}else{return 0;}};
a.prototype.getVariants=function(v){var b=this._mVariantManagement[v]&&this._mVariantManagement[v].variants;return b?b:[];};
a.prototype.getVariant=function(v,s){var o;var b=this.getVariants(v);b.some(function(c,i){if(c.content.fileName===s){o=c;return true;}});return o;};
a.prototype.getVariantChanges=function(v,s){var b=s||this._mVariantManagement[v].defaultVariant;var c=this.getVariants(v);var f=c.filter(function(o){return o.content.fileName===b;});return f.reduce(function(r,o){return o.changes?r.concat(o.changes):r;},[]);};
a.prototype._getReferencedChanges=function(v,c){var r=[];if(c.content.variantReference){r=this.getVariantChanges(v,c.content.variantReference);return r.filter(function(R){return U.isLayerAboveCurrentLayer(R.layer)===-1;});}return r;};
a.prototype.setVariantChanges=function(v,s,c){if(!v||!s||!q.isArray(c)){U.log.error("Cannot set variant changes without Variant reference");return;}return this._mVariantManagement[v].variants.some(function(o,i){if(o.content.fileName===s){o.changes=c;return true;}});};
a.prototype._setVariantData=function(c,v,p){var b=this._mVariantManagement[v].variants;var o=b[p];Object.keys(c).forEach(function(P){o.content[P]=c[P];});b.splice(p,1);var s=this._getIndexToSortVariant(b.slice(1),o);b.splice(s+1,0,o);return s+1;};
a.prototype.loadDefaultChanges=function(){var v;var d=[];Object.keys(this._mVariantManagement).forEach(function(s){v=this._mVariantManagement[s].defaultVariant;d=d.concat(this.getVariantChanges(s,v));}.bind(this));return d;};
a.prototype.getChangesForVariantSwitch=function(v,c,n,m){var b=this.getVariantChanges(v,c).map(function(o){return new C(o).getId();});var d=Object.keys(m).reduce(function(e,f){var g=[];m[f].forEach(function(o){var i=b.indexOf(o.getId());if(i!==-1){g.push(o);}});return e.concat(g);},[]);var N=this.getVariantChanges(v,n).map(function(o){return new C(o);});var r=[];if(N.length>0){r=d.slice();d.some(function(o){if(N[0]&&o.getId()===N[0].getId()){N.shift();r.shift();}else{return true;}});}else{r=d;}var s={aRevert:r.reverse(),aNew:N};return s;};
a.prototype._applyChangesOnVariant=function(v){var m=v.variantChanges,A;Object.keys(m).forEach(function(c){switch(c){case"setTitle":A=this._getActiveChange(c,m);if(A){v.content.title=A.getText("title");}break;default:U.log.error("No valid changes on variant "+v.content.title+" available");}}.bind(this));};
a.prototype._getActiveChange=function(c,v){var l=v[c].length-1;if(l>-1){return new C(v[c][l]);}return false;};
a.prototype._fillVariantModel=function(){var v={};Object.keys(this._mVariantManagement).forEach(function(k){v[k]={defaultVariant:this._mVariantManagement[k].defaultVariant,variants:[]};this.getVariants(k).forEach(function(o,i){this._applyChangesOnVariant(o);v[k].variants[i]={key:o.content.fileName,title:o.content.title,author:o.content.support.user,layer:o.content.layer,readOnly:o.content.fileName===k};}.bind(this));}.bind(this));return v;};
a.prototype.addChangeToVariant=function(c,v,s){var n=this.getVariantChanges(v,s);var b=n.map(function(c){return c.fileName;});var i=b.indexOf(c.getDefinition().fileName);if(i===-1){c.setVariantReference(s);n.push(c.getDefinition());return this.setVariantChanges(v,s,n);}return false;};
a.prototype.removeChangeFromVariant=function(c,v,s){var n=this.getVariantChanges(v,s);n.forEach(function(o,i){var b=new C(o);if(b.getId&&(b.getId()===c.getId())){n.splice(i,1);}});return this.setVariantChanges(v,s,n);};
a.prototype.addVariantToVariantManagement=function(v,s){var b=this._mVariantManagement[s].variants.slice().splice(1);var i=this._getIndexToSortVariant(b,v);if(v.content.variantReference){var r=this._getReferencedChanges(s,v);v.changes=r.concat(v.changes);}this._mVariantManagement[s].variants.splice(i+1,0,v);return i+1;};
a.prototype._getIndexToSortVariant=function(v,o){var i=0;v.some(function(e,b){if(this.compareVariants(o,e)<0){i=b;return true;}i=b+1;}.bind(this));return i;};
a.prototype.removeVariantFromVariantManagement=function(v,s){var i;var f=this._mVariantManagement[s].variants.some(function(c,b){var o=new V(c);if(o.getId()===v.getId()){i=b;return true;}});if(f){this._mVariantManagement[s].variants.splice(i,1);}return i;};
return a;},true);
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/fl/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/fl/manifest.json":'{\n  "_version": "1.9.0",\n  "sap.app": {\n    "id": "sap.ui.fl",\n    "type": "library",\n    "embeds": [\n      "support/apps/contentbrowser"\n    ],\n    "applicationVersion": {\n      "version": "1.52.12"\n    },\n    "title": "SAPUI5 library with sap.ui.fl controls.",\n    "description": "SAPUI5 library with sap.ui.fl controls.",\n    "ach": "CA-UI5-FL",\n    "resources": "resources.json",\n    "offline": true\n  },\n  "sap.ui": {\n    "technology": "UI5",\n    "supportedThemes": [\n      "base"\n    ]\n  },\n  "sap.ui5": {\n    "dependencies": {\n      "minUI5Version": "1.52",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.52.12"\n        },\n        "sap.m": {\n          "minVersion": "1.52.12"\n        }\n      }\n    },\n    "library": {\n      "i18n": "messagebundle.properties"\n    }\n  }\n}'
}});
//# sourceMappingURL=library-preload.js.map