/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/layout/BlockLayoutCellData'],function(q,C,l,B){"use strict";var a=l.BlockBackgroundType;var b=l.BlockRowColorSets;var c=C.extend("sap.ui.layout.BlockLayoutRow",{metadata:{library:"sap.ui.layout",properties:{scrollable:{type:"boolean",group:"Appearance",defaultValue:false},rowColorSet:{type:"sap.ui.layout.BlockRowColorSets",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"content"}},associations:{accentCells:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"accentCell"}},designTime:true}});c.prototype.init=function(){this._applyLayoutData={};};c.prototype.addContent=function(o){this._ensureLayoutData(o);return this.addAggregation("content",o);};c.prototype.insertContent=function(o,i){this._ensureLayoutData(o);return this.insertAggregation("content",o,i);};c.prototype.onBeforeRendering=function(){var d=this.getContent(),t=this;d.forEach(function(o,i){o._setParentRowScrollable(t.getScrollable());});this._calculateBreakpointRendering();};c.prototype.setRowColorSet=function(t){var A=Array.prototype.slice.call(arguments),o=C.prototype.setProperty.apply(this,["rowColorSet"].concat(A)),s="sapUiBlockLayoutBackground"+t,d=this.getParent(),e=d&&d.getBackground(),T=d&&d.indexOfAggregation("content",this),p=d&&d.getContent(),P=(T&&p[T-1])||null,n=(p&&p[T+1])||null,f=b,g=Object.keys(f).map(function(k){return f[k];}),i=false;if(P&&P._hasStyleClass(s,e,i,t)){s+="Inverted";i=true;}g.forEach(function(h){var j="sapUiBlockLayoutBackground"+h,I=j+"Inverted";if(this._hasStyleClass(j,e,false,h)){this.removeStyleClass(j,true);}else if(this._hasStyleClass(I,e,true,h)){this.removeStyleClass(I,true);}},this);this.addStyleClass(s,true);if(n&&n._hasStyleClass(s,e,i,t)){n.setRowColorSet.apply(n,A);}this.invalidate();return o;};c.prototype.addAccentCell=function(i){var o,I=i&&i.getId?i.getId():i,d=Array.prototype.slice.call(arguments),e=a,f=this.getParent(),L=f&&(f.getBackground()||"");o=this.addAssociation.apply(this,["accentCells"].concat(d));if(!f){return this;}if([e.Accent,e.Mixed].indexOf(L)===-1){q.sap.log.warning(I+" was not se as accent cell. Accent cells could be set only for 'Accent' and 'Mixed' layout backgrounds.");return this;}if(e.Mixed===L){this._processMixedCellStyles(I,this.getContent());}else if(e.Accent===L){this._processAccentCellStyles(this.getAccentCells(),this.getContent());}return o;};c.prototype._ensureLayoutData=function(o){var O=o.getLayoutData();if(!O||!(O instanceof B)){o.setLayoutData(new B());}};c.prototype._onParentSizeChange=function(d){this._currentSize=d;this._calculateBreakpointRendering();this.invalidate();};c.prototype._getCellArangementForCurrentSize=function(){if(!this._arrangements||!this._currentSize){return null;}return this._arrangements[this._currentSize];};c.prototype._calculateBreakpointRendering=function(){if(!this._currentSize){return;}this._arrangements={"S":this._calcArrangementForSize("S"),"M":this._calcArrangementForSize("M"),"L":this._calcArrangementForSize("L"),"XL":this._calcArrangementForSize("Xl")};};c.prototype._calcArrangementForSize=function(s){var d=this.getContent();if(d.length>=3&&s==="M"&&d.length<5){return this._generateArrangementForMCase();}else{return this._generateArrangement(s);}};c.prototype._generateArrangement=function(s){var L,I=0,f=[],d=[],A=[[]],e=this.getContent();e.forEach(function(o){L=o.getLayoutData();d.push(L["breakRowOn"+s+"Size"]);f.push(L["get"+s+"Size"]());});f.forEach(function(D,i){A[I].push(D);if(d[i+1]){I++;A[I]=[];}});return A;};c.prototype._generateArrangementForMCase=function(){var d=this.getContent();if(d.length===3&&this._isAllCellsHasSameWidth("M")){return[[1,1,1]];}else if(d.length===3){return[[1,1],[1]];}else if(d.length===4){return[[1,1],[1,1]];}};c.prototype._isAllCellsHasSameWidth=function(s){var d,e=this.getContent(),f=e[0].getLayoutData()["get"+s+"Size"]();for(var i=1;i<e.length;i++){d=e[i].getLayoutData()["get"+s+"Size"]();if(d!==f){return false;}}return true;};c.prototype._processMixedCellStyles=function(i,d){var o,p;if(!d||!d.length){q.sap.log.warning("No accent cells were set");return this;}o=this.getParent();p=o&&(o.hasStyleClass("sapUiBlockLayoutSizeL")||o.hasStyleClass("sapUiBlockLayoutSizeXL"));d.forEach(function(e){var f,u;if(p&&e.getId()===i&&e.getWidth()===1){e.addStyleClass("sapContrast").addStyleClass("sapContrastPlus");f=b;u=this._hasStyleClass("sapUiBlockLayoutBackground"+f.ColorSet1,a.Mixed,false,f.ColorSet1)||this._hasStyleClass("sapUiBlockLayoutBackground"+f.ColorSet1,a.Mixed,true,f.ColorSet1);if(u){e.addStyleClass("sapUiBlockLayoutBackgroundContrast2");}}else if((!p||e.getId()!==i)&&(e.hasStyleClass("sapContrast")||e.hasStyleClass("sapContrastPlus"))){e.removeStyleClass("sapContrast").removeStyleClass("sapContrastPlus").removeStyleClass("sapUiBlockLayoutBackgroundContrast2");this.removeAssociation("accentCells",e);q.sap.log.warning(i+" was removed as accent cell. Only one cell at a time could be accented for Mixed layout background");}},this);return this;};c.prototype._processAccentCellStyles=function(A,r){var o,s,d,i=0,I=0,e=Array.prototype.slice.call(A);if(!A||!A.length){q.sap.log.warning("No accent cells were set");return this;}for(i=0;i<r.length;i++){o=r[i];s=o.getId();if(!e.length){break;}if(e.indexOf(s)>-1){I++;d="sapUiBlockLayoutBackgroundColorSetGray"+((I%2)+1);if(o.hasStyleClass(d)){continue;}e.splice(e.indexOf(s),1);o.removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray1").removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray2").addStyleClass(d);}}return this;};c.prototype._hasStyleClass=function(s,L,I,t){var o=a,d=b,i,S,e;if([o.Light,o.Mixed].indexOf(L)===-1){return this.hasStyleClass(s);}else if(this.hasStyleClass(s)){return true;}e=[[d.ColorSet1,d.ColorSet3],[d.ColorSet2,d.ColorSet4]];for(i=0;i<=e.length;i++){if(e[i]&&e[i].indexOf(t)>-1){break;}}if(!e[i]){return false;}S=e[i].map(function(f){return"sapUiBlockLayoutBackground"+f+(I?"Inverted":"");});return S.some(this.hasStyleClass,this);};return c;});
