/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/core/library','sap/ui/core/ResizeHandler'],function(q,C,l,c,R){"use strict";var O=c.Orientation;var S=C.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}},designTime:true}});var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");S.prototype.init=function(){this._needsInvalidation=false;this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=this._delayedResize.bind(this);this._resizeHandlerId=null;this._autoResize=true;this.enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._switchOrientation();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",20),decrease:this._onKeyboardResize.bind(this,"dec",20),increaseMore:this._onKeyboardResize.bind(this,"incMore",20),decreaseMore:this._onKeyboardResize.bind(this,"decMore",20),max:this._onKeyboardResize.bind(this,"max",20),min:this._onKeyboardResize.bind(this,"min",20)};this._enableKeyboardListeners();this._isPreserved=false;sap.ui.getCore().getEventBus().subscribe("sap.ui","__preserveContent",this._preserveHandler,this);this._bUseIconForSeparator=true;};S.prototype.exit=function(){sap.ui.getCore().getEventBus().unsubscribe("sap.ui","__preserveContent",this._preserveHandler,this);this.disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar;};S.prototype.triggerResize=function(f){if(f){this._resize();}else{this._delayedResize();}};S.prototype.getCalculatedSizes=function(){return this._calculatedSizes;};S.prototype.enableAutoResize=function(t){if(t&&!this._autoResize){return;}this._autoResize=true;var d=this;sap.ui.getCore().attachInit(function(){d._resizeHandlerId=R.register(d,d._resizeCallback);});this._delayedResize();};S.prototype.disableAutoResize=function(t){R.deregister(this._resizeHandlerId);if(!t){this._autoResize=false;}};S.prototype.enableLiveResize=function(){this._liveResize=true;this.$().toggleClass("sapUiLoSplitterAnimated",false);};S.prototype.disableLiveResize=function(){this._liveResize=false;this.$().toggleClass("sapUiLoSplitterAnimated",true);};S.prototype.enableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","0");this._enableKeyboardListeners();};S.prototype.disableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","-1");this._disableKeyboardListeners();};S.prototype.onBeforeRendering=function(){this._switchOrientation();};S.prototype.onAfterRendering=function(){this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");this._$SplitterOverlay.detach();this._isPreserved=false;this._resize();};S.prototype.onLayoutDataChange=function(){this._delayedResize();};S.prototype.ontouchstart=function(j){if(this._ignoreTouch){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}if(!j.changedTouches||!j.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(j.changedTouches[0],true);};S.prototype.onmousedown=function(j){if(this._ignoreMouse){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}this._ignoreTouch=true;this._onBarMoveStart(j);};S.prototype._onBarMoveStart=function(j,t){var I=this.getId();this.disableAutoResize(true);var p=j[this._moveCord];var B=parseInt(j.target.id.substr((I+"-splitbar-").length),10);var $=q(j.target);var m=this.getCalculatedSizes();var d=this._bHorizontal?$.innerWidth():$.innerHeight();var e=this._getContentAreas();var L=e[B].getLayoutData();var o=e[B+1].getLayoutData();if(!L.getResizable()||!o.getResizable()){a(t);return;}var f=0-d;for(var i=0;i<=B;++i){f+=m[i]+d;}this._move={start:p,relStart:f,barNum:B,bar:q(j.target),c1Size:m[B],c1MinSize:L?parseInt(L.getMinSize(),10):0,c2Size:m[B+1],c2MinSize:o?parseInt(o.getMinSize(),10):0};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlay.appendTo(this.getDomRef());this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move["bar"].css("visibility","hidden");this._onBarMove(j);};S.prototype._onBarMove=function(j){if(j.preventDefault){j.preventDefault();}var e=j;if(j.changedTouches&&j.changedTouches[0]){e=j.changedTouches[0];}var p=e[this._moveCord];var d=(p-this._move.start);if(this.getOrientation()==O.Horizontal&&this._bRtl){d=-d;}var f=this._move.c1Size+d;var g=this._move.c2Size-d;var i=(f>=0&&g>=0&&f>=this._move.c1MinSize&&g>=this._move.c2MinSize);if(i){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+d);if(this._liveResize){var m=(this._move["start"]-e[this._moveCord]);if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,false);}}};S.prototype._onBarMoveEnd=function(j){this._ignoreMouse=false;this._ignoreTouch=false;var e=j;if(j.changedTouches&&j.changedTouches[0]){e=j.changedTouches[0];}var p=e[this._moveCord];var m=this._move["start"]-p;if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,true);this._move["bar"].css("visibility","");this._$SplitterOverlay.css("display","");document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this.enableAutoResize(true);q.sap.focus(this._move.bar);};S.prototype._resizeContents=function(L,p,f){if(isNaN(p)){q.sap.log.warning("Splitter: Received invalid resizing values - resize aborted.");return;}var d=this._getContentAreas();var o=d[L].getLayoutData();var e=d[L+1].getLayoutData();var s=o.getSize();var g=e.getSize();var $=this.$("content-"+L);var h=this.$("content-"+(L+1));var n=this._move.c1Size+p;var N=this._move.c2Size-p;var m=parseInt(o.getMinSize(),10);var M=parseInt(e.getMinSize(),10);var D;if(n<m){D=m-n;p+=D;n=m;N-=D;}else if(N<M){D=M-N;p-=D;N=M;n-=D;}if(f){if(s==="auto"&&g!=="auto"){e.setSize(N+"px");}else if(s!=="auto"&&g==="auto"){o.setSize(n+"px");}else{o.setSize(n+"px");e.setSize(N+"px");}}else{$.css(this._sizeType,n+"px");h.css(this._sizeType,N+"px");}};S.prototype._preserveHandler=function(s,e,d){var D=this.getDomRef();if(D&&q.contains(d.domNode,D)){this._isPreserved=true;}};S.prototype._delayedResize=function(d){if(d===undefined){d=0;}if(this.getDomRef()){q.sap.clearDelayedCall(this._resizeTimeout);q.sap.delayedCall(d,this,"_resize",[]);}};S.prototype._resizeBars=function(d){var i,B;var $=this.$();for(i=0;i<d.length-1;++i){B=this.$("splitbar-"+i);B.css(this._sizeTypeNot,"");}for(i=0;i<d.length-1;++i){B=this.$("splitbar-"+i);var s=this._bHorizontal?$.height():$.width();B.css(this._sizeType,"");B.css(this._sizeTypeNot,s+"px");}};S.prototype._resize=function(){if(this._isPreserved){return;}var i=0,B;var d=this._getContentAreas();this._resizeBars(d);var o=this.getCalculatedSizes();this._recalculateSizes();var n=this.getCalculatedSizes();var s=false;for(i=0;i<n.length;++i){if(n[i]!==0){s=true;break;}}if(!s){this._delayedResize(100);return;}var L=true;for(i=0;i<d.length;++i){var $=this.$("content-"+i);var e=d[i];$.css(this._sizeType,n[i]+"px");$.css(this._sizeTypeNot,"");var f=e.getLayoutData();var g=f&&f.getResizable();if(i>0){var h=g&&L;B=this.$("splitbar-"+(i-1));B.toggleClass("sapUiLoSplitterNoResize",!h);B.attr("tabindex",h&&this._keyboardEnabled?"0":"-1");}L=g;}this._resizeBars(d);if(_(o,n)){this.fireResize({oldSizes:o,newSizes:n});}};S.prototype._calculateAvailableContentSize=function(s){var i=0;var $=this.$();var f=this._bHorizontal?$.innerWidth():$.innerHeight();var A=0;var h=false;for(i=0;i<s.length;++i){var d=s[i];if(d.indexOf("%")>-1){A++;}if(s[i]=="auto"){h=true;}}A+=h?1:0;f-=A;var e=s.length-1;var g=0;for(i=0;i<e;++i){g+=this._bHorizontal?this.$("splitbar-"+i).innerWidth():this.$("splitbar-"+i).innerHeight();}return f-g;};S.prototype._recalculateSizes=function(){var i,s,L,d,e;var f=[];var g=this._getContentAreas();for(i=0;i<g.length;++i){L=g[i].getLayoutData();s=L?L.getSize():"auto";f.push(s);}this._calculatedSizes=[];var A=this._calculateAvailableContentSize(f);var h=[];var j=[];var p=[];var k=A;for(i=0;i<f.length;++i){s=f[i];var m;if(s.indexOf("px")>-1){m=parseInt(s,10);k-=m;this._calculatedSizes[i]=m;}else if(s.indexOf("%")>-1){p.push(i);}else if(f[i]=="auto"){L=g[i].getLayoutData();if(L&&parseInt(L.getMinSize(),10)!=0){j.push(i);}else{h.push(i);}}else{q.sap.log.error("Illegal size value: "+f[i]);}}var w=false;if(k<0){w=true;k=0;}var P=p.length;for(i=0;i<P;++i){e=p[i];d=Math.floor((parseFloat(f[e])/100)*A);this._calculatedSizes[e]=d;k-=d;}A=k;if(A<0){w=true;A=0;}d=Math.floor(A/(j.length+h.length),0);var n=j.length;for(i=0;i<n;++i){e=j[i];var M=parseInt(g[e].getLayoutData().getMinSize(),10);if(M>d){this._calculatedSizes[e]=M;A-=M;}else{this._calculatedSizes[e]=d;A-=d;}}if(A<0){w=true;A=0;}k=A;var o=h.length;d=Math.floor(A/o,0);for(i=0;i<o;++i){e=h[i];this._calculatedSizes[e]=d;k-=d;}if(w){q.sap.log.info("[Splitter] The set sizes and minimal sizes of the splitter contents are bigger "+"than the available space in the UI.");}};S.prototype._switchOrientation=function(){this._bHorizontal=this.getOrientation()===O.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right";}else{this._sizeDir="left";}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left";}var t=this.$();t.toggleClass("sapUiLoSplitterH",this._bHorizontal);t.toggleClass("sapUiLoSplitterV",!this._bHorizontal);};S.prototype._onKeyboardResize=function(t,s,e){var B=this.getId()+"-splitbar-";if(!e||!e.target||!e.target.id||e.target.id.indexOf(B)!==0){return;}var i=999999;var d=parseInt(e.target.id.substr(B.length),10);var m=this.getCalculatedSizes();this._move.c1Size=m[d];this._move.c2Size=m[d+1];var f=0;switch(t){case"inc":f=s;break;case"incMore":f=s*10;break;case"dec":f=0-s;break;case"decMore":f=0-s*10;break;case"max":f=i;break;case"min":f=0-i;break;default:q.sap.log.warn("[Splitter] Invalid keyboard resize type");break;}this._resizeContents(d,f,true);};S.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};S.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false;};S.prototype._getText=function(k,A){return(r?r.getText(k,A):k);};function _(s,d){if(s===d){return false;}if(!s||!d||s.length===undefined||d.length===undefined){return true;}if(s.length!=d.length){return true;}for(var i=0;i<s.length;++i){if(s[i]!==d[i]){return true;}}return false;}function a(t){var p=function(e){e.preventDefault();};var A=null;A=function(){document.removeEventListener("touchend",A);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",A);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",A);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",A);document.addEventListener("mousemove",p);}}function b(o){var L=o.getLayoutData();if(L&&(!L.getResizable||!L.getSize||!L.getMinSize)){q.sap.log.warning("Content \""+o.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");L=null;}if(!L){o.setLayoutData(new sap.ui.layout.SplitterLayoutData());}}S.prototype.invalidate=function(o){var f=(o&&this.indexOfContentArea(o)!=-1)||(o&&o instanceof sap.ui.core.CustomData&&o.getWriteToDom())||(o===undefined);if(f||this._needsInvalidation){this._needsInvalidation=false;C.prototype.invalidate.apply(this,arguments);}};S.prototype.setOrientation=function(o){var v=this.setProperty("orientation",o,true);this._switchOrientation();this._delayedResize();this.$().find(".sapUiLoSplitterBar").attr("aria-orientation",this._bHorizontal?"vertical":"horizontal");return v;};S.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",this.getProperty("width"));return this;};S.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",this.getProperty("height"));return this;};S.prototype.addContentArea=function(o){this._needsInvalidation=true;b(o);return this.addAggregation("contentAreas",o);};S.prototype.removeContentArea=function(o){this._needsInvalidation=true;return this.removeAggregation("contentAreas",o);};S.prototype.removeAllContentArea=function(){this._needsInvalidation=true;return this.removeAllAggregation("contentAreas");};S.prototype.destroyContentArea=function(){this._needsInvalidation=true;return this.destroyAggregation("contentAreas");};S.prototype.insertContentArea=function(o,i){this._needsInvalidation=true;b(o);return this.insertAggregation("contentAreas",o,i);};S.prototype._getContentAreas=function(){return this.getContentAreas();};return S;});
