/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./Form','./FormContainer','./FormElement','./FormLayout','sap/ui/base/ManagedObjectObserver','sap/ui/layout/library','sap/ui/core/ResizeHandler'],function(q,C,F,a,b,c,M,l,R){"use strict";var B=l.BackgroundDesign;var S=l.form.SimpleFormLayout;var d;var e;var f;var G;var g;var h;var m=C.extend("sap.ui.layout.form.SimpleForm",{metadata:{library:"sap.ui.layout",properties:{maxContainerCols:{type:"int",group:"Appearance",defaultValue:2},minWidth:{type:"int",group:"Appearance",defaultValue:-1},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:null},labelMinWidth:{type:"int",group:"Misc",defaultValue:192},layout:{type:"sap.ui.layout.form.SimpleFormLayout",group:"Misc",defaultValue:S.ResponsiveLayout},labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600},backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},form:{type:"sap.ui.layout.form.Form",multiple:false,visibility:"hidden"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designTime:true}});m.prototype.init=function(){this._iMaxWeight=8;this._iLabelWeight=3;this._iCurrentWidth=0;var i=new F(this.getId()+"--Form");i.getTitle=function(){return this.getParent().getTitle();};i._origInvalidate=i.invalidate;i.invalidate=function(j){if(this.bOutput){this._origInvalidate(j);}if(this._bIsBeingDestroyed){return;}var k=this.getParent();if(k){k._formInvalidated(j);}};i.getAriaLabelledBy=function(){var j=this.getParent();if(j){return j.getAriaLabelledBy();}else{return null;}};i._origOnLayoutDataChange=i.onLayoutDataChange;i.onLayoutDataChange=function(j){this._origOnLayoutDataChange(j);var k=this.getParent();if(k){k._onLayoutDataChange(j);}};this.setAggregation("form",i);this._aElements=null;this._aLayouts=[];this._changedFormContainers=[];this._changedFormElements=[];this._oObserver=new M(Q.bind(this));};m.prototype.exit=function(){var j=this.getAggregation("form");j.invalidate=j._origInvalidate;O.call(this);for(var i=0;i<this._aLayouts.length;i++){var k=sap.ui.getCore().byId(this._aLayouts[i]);if(k&&k.destroy){k.destroy();}}this._aLayouts=[];this._aElements=null;this._changedFormContainers=[];this._changedFormElements=[];this._oObserver.disconnect();this._oObserver=undefined;};m.prototype.onBeforeRendering=function(){O.call(this);var i=this.getAggregation("form");if(!this._bResponsiveLayoutRequested&&!this._bGridLayoutRequested&&!this._bResponsiveGridLayoutRequested){var j=true;if(!i.getLayout()){j=_.call(this);}if(j){u.call(this);}}};m.prototype.onAfterRendering=function(){if(this.getLayout()==S.ResponsiveLayout){this._bChangedByMe=true;this.$().css("visibility","hidden");this._applyLinebreaks();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._resize,this));this._bChangedByMe=false;}};m.prototype.setEditable=function(i){this._bChangedByMe=true;this.setProperty("editable",i,true);var j=this.getAggregation("form");j.setEditable(i);this._bChangedByMe=false;return this;};m.prototype.setToolbar=function(i){this._bChangedByMe=true;var j=this.getAggregation("form");j.setToolbar(i);this._bChangedByMe=false;return this;};m.prototype.getToolbar=function(){var i=this.getAggregation("form");return i.getToolbar();};m.prototype.destroyToolbar=function(){this._bChangedByMe=true;var i=this.getAggregation("form");i.destroyToolbar();this._bChangedByMe=false;return this;};m.prototype.setLabelMinWidth=function(j){this.setProperty("labelMinWidth",j,true);if(this.getLayout()==S.ResponsiveLayout){this._bLayoutDataChangedByMe=true;var k=this.getContent();for(var i=0;i<k.length;i++){var V=k[i];if(V.getMetadata().isInstanceOf("sap.ui.core.Label")){var W=x.call(this,V);if(U(W,"sap/ui/layout/ResponsiveFlowLayoutData")&&v.call(this,W)){W.setMinWidth(j);}}}this._bLayoutDataChangedByMe=false;}return this;};m.prototype.indexOfContent=function(j){var k=this._aElements;if(k){for(var i=0;i<k.length;i++){if(k[i]==j){return i;}}}return-1;};m.prototype.addContent=function(i){i=this.validateAggregation("content",i,true);if(this.indexOfContent(i)>=0){q.sap.log.warning("SimpleForm.addContent: Content element '"+i+"' already assigned. Please remove before adding!",this);this.removeContent(i);}if(!this._aElements){this._aElements=[];}this._bChangedByMe=true;var j=this._aElements.length;var k;var V=this.getAggregation("form");var W;var X;var Y;var Z;if(i instanceof sap.ui.core.Title||i.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){W=K.call(this,i);V.addFormContainer(W);this._changedFormContainers.push(W);}else if(i.getMetadata().isInstanceOf("sap.ui.core.Label")){if(j>0){k=this._aElements[j-1];Y=k.getParent();if(Y instanceof b){W=Y.getParent();}else if(Y instanceof a){W=Y;}}if(!W){W=K.call(this);V.addFormContainer(W);this._changedFormContainers.push(W);}X=H.call(this,W,i);}else{if(j>0){k=this._aElements[j-1];Y=k.getParent();if(Y instanceof b){W=Y.getParent();X=Y;Z=x.call(this,i);if(U(Z,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,Z)&&Z.getLinebreak()){X=H.call(this,W);}}else if(Y instanceof a){W=Y;X=H.call(this,W);}}else{W=K.call(this);V.addFormContainer(W);this._changedFormContainers.push(W);X=H.call(this,W);}z.call(this,i,5,false,true);X.addField(i);P(this._changedFormElements,X);}this._aElements.push(i);this._oObserver.observe(i,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};m.prototype.insertContent=function(j,k){j=this.validateAggregation("content",j,true);if(this.indexOfContent(j)>=0){q.sap.log.warning("SimpleForm.insertContent: Content element '"+j+"' already assigned. Please remove before insert!",this);this.removeContent(j);}if(!this._aElements){this._aElements=[];}var V=this._aElements.length;var W;if(k<0){W=0;}else if(k>V){W=V;}else{W=k;}if(W!==k){q.sap.log.warning("SimpleForm.insertContent: index '"+k+"' out of range [0,"+V+"], forced to "+W);}if(W==V){this.addContent(j);return this;}this._bChangedByMe=true;var X=this._aElements[W];var Y=this.getAggregation("form");var Z;var $;var a1;var b1;var c1;var d1=0;var e1;var f1;var g1;var h1;var i=0;var i1;var j1;if(j instanceof sap.ui.core.Title||j.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){if(k==0&&!(X instanceof sap.ui.core.Title||X.getMetadata().isInstanceOf("sap.ui.core.Toolbar"))){Z=X.getParent().getParent();if(j instanceof sap.ui.core.Title){Z.setTitle(j);}else{Z.setToolbar(j);}}else{Z=K.call(this,j);if(X instanceof sap.ui.core.Title||X.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){a1=X.getParent();c1=Y.indexOfFormContainer(a1);}else{b1=X.getParent();a1=b1.getParent();c1=Y.indexOfFormContainer(a1)+1;d1=a1.indexOfFormElement(b1);if(!X.getMetadata().isInstanceOf("sap.ui.core.Label")){e1=b1.indexOfField(X);if(e1>0||b1.getLabel()){$=H.call(this,Z);this._changedFormElements.push($);P(this._changedFormElements,b1);f1=b1.getFields();for(i=e1;i<f1.length;i++){i1=f1[i];$.addField(i1);}d1++;}}g1=a1.getFormElements();for(i=d1;i<g1.length;i++){Z.addFormElement(g1[i]);}}Y.insertFormContainer(Z,c1);}this._changedFormContainers.push(Z);}else if(j.getMetadata().isInstanceOf("sap.ui.core.Label")){if(X instanceof sap.ui.core.Title||X.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){a1=X.getParent();c1=Y.indexOfFormContainer(a1);h1=Y.getFormContainers();if(c1==0){Z=K.call(this);Y.insertFormContainer(Z,c1);this._changedFormContainers.push(Z);}else{Z=h1[c1-1];}$=H.call(this,Z,j);}else if(X.getMetadata().isInstanceOf("sap.ui.core.Label")){a1=X.getParent().getParent();d1=a1.indexOfFormElement(X.getParent());$=I.call(this,a1,j,d1);}else{b1=X.getParent();a1=b1.getParent();d1=a1.indexOfFormElement(b1)+1;e1=b1.indexOfField(X);if(e1==0&&!b1.getLabel()){$=b1;$.setLabel(j);z.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}else{$=I.call(this,a1,j,d1);P(this._changedFormElements,b1);f1=b1.getFields();for(i=e1;i<f1.length;i++){i1=f1[i];$.addField(i1);}}}this._changedFormElements.push($);}else{j1=x.call(this,j);if(X instanceof sap.ui.core.Title||X.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){a1=X.getParent();c1=Y.indexOfFormContainer(a1);if(c1==0){Z=K.call(this);Y.insertFormContainer(Z,c1);this._changedFormContainers.push(Z);}else{h1=Y.getFormContainers();Z=h1[c1-1];}g1=Z.getFormElements();if(g1.length==0){$=H.call(this,Z);}else if(U(j1,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,j1)&&j1.getLinebreak()){$=H.call(this,Z);}else{$=g1[g1.length-1];}$.addField(j);}else if(X.getMetadata().isInstanceOf("sap.ui.core.Label")){b1=X.getParent();Z=b1.getParent();d1=Z.indexOfFormElement(b1);if(d1==0){$=I.call(this,Z,null,0);}else if(U(j1,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,j1)&&j1.getLinebreak()){$=I.call(this,Z,null,d1);}else{g1=Z.getFormElements();$=g1[d1-1];}$.addField(j);}else{$=X.getParent();e1=$.indexOfField(X);if(U(j1,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,j1)&&j1.getLinebreak()&&e1>0){Z=$.getParent();d1=Z.indexOfFormElement($);P(this._changedFormElements,$);f1=$.getFields();$=I.call(this,Z,undefined,d1+1);$.addField(j);for(i=e1;i<f1.length;i++){i1=f1[i];$.addField(i1);}}else{$.insertField(j,e1);}}P(this._changedFormElements,$);z.call(this,j,5,false,true);}this._aElements.splice(W,0,j);this._oObserver.observe(j,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};m.prototype.removeContent=function(j){var k=null;var V=-1;var i=0;if(this._aElements){if(typeof(j)=="string"){j=sap.ui.getCore().byId(j);}if(typeof(j)=="object"){for(i=0;i<this._aElements.length;i++){if(this._aElements[i]==j){j=i;break;}}}if(typeof(j)=="number"){if(j<0||j>=this._aElements.length){q.sap.log.warning("Element.removeAggregation called with invalid index: Items, "+j);}else{V=j;k=this._aElements[V];}}}if(k){this._bChangedByMe=true;var W=this.getAggregation("form");var X;var Y;var Z;var $;if(k instanceof sap.ui.core.Title||k.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){X=k.getParent();X.setTitle(null);X.setToolbar(null);if(V>0){Z=X.getFormElements();var a1=W.indexOfFormContainer(X);var b1=W.getFormContainers()[a1-1];if(Z.length>0&&!Z[0].getLabel()){var c1=b1.getFormElements();var d1=c1[c1.length-1];$=Z[0].getFields();for(i=0;i<$.length;i++){d1.addField($[i]);}P(this._changedFormElements,d1);X.removeFormElement(Z[0]);Z[0].destroy();Z.splice(0,1);}for(i=0;i<Z.length;i++){b1.addFormElement(Z[i]);}P(this._changedFormContainers,b1);W.removeFormContainer(X);X.destroy();}else if(X.getFormElements().length==0){W.removeFormContainer(X);X.destroy();}}else if(k.getMetadata().isInstanceOf("sap.ui.core.Label")){Y=k.getParent();X=Y.getParent();Y.setLabel(null);var e1=X.indexOfFormElement(Y);if(e1==0){if(Y.getFields().length==0){X.removeFormElement(Y);Y.destroy();if(X.getFormElements().length==0&&!X.getTitle()&&!X.getToolbar()){W.removeFormContainer(X);X.destroy();}}else{P(this._changedFormElements,Y);}}else{Z=X.getFormElements();var f1=Z[e1-1];$=Y.getFields();for(i=0;i<$.length;i++){f1.addField($[i]);}P(this._changedFormElements,f1);X.removeFormElement(Y);Y.destroy();}}else{Y=k.getParent();Y.removeField(k);if(Y.getFields().length==0&&!Y.getLabel()){X=Y.getParent();X.removeFormElement(Y);Y.destroy();if(X.getFormElements().length==0&&!X.getTitle()&&!X.getToolbar()){W.removeFormContainer(X);X.destroy();}}else{P(this._changedFormElements,Y);}}this._aElements.splice(V,1);k.setParent(null);this._oObserver.unobserve(k);E.call(this,k);this.invalidate();this._bChangedByMe=false;return k;}return null;};m.prototype.removeAllContent=function(){var i=0;if(this._aElements){this._bChangedByMe=true;var k=this.getAggregation("form");var V=k.getFormContainers();for(i=0;i<V.length;i++){var W=V[i];W.setTitle(null);W.setToolbar(null);var X=W.getFormElements();for(var j=0;j<X.length;j++){var Y=X[j];Y.setLabel(null);Y.removeAllFields();}W.destroyFormElements();}k.destroyFormContainers();for(i=0;i<this._aElements.length;i++){var Z=this._aElements[i];E.call(this,Z);this._oObserver.unobserve(Z);}var $=this._aElements;this._aElements=null;this.invalidate();this._bChangedByMe=false;return $;}else{return[];}};m.prototype.destroyContent=function(){var j=this.removeAllContent();if(j){this._bChangedByMe=true;for(var i=0;i<j.length;i++){j[i].destroy();}this.invalidate();this._bChangedByMe=false;}return this;};m.prototype.getContent=function(){if(!this._aElements){this._aElements=this.getAggregation("content",[]);}return this._aElements.slice();};m.prototype.setLayout=function(i){var j=this.getLayout();if(i!=j){s.call(this);}this.setProperty("layout",i);if(i!=j){var k=_.call(this);if(k){t.call(this);}}return this;};m.prototype.clone=function(k){this._bChangedByMe=true;var V=C.prototype.clone.apply(this,arguments);var W=this.getContent();for(var i=0;i<W.length;i++){var X=W[i];var Y=X.getLayoutData();this._oObserver.unobserve(X);var Z=X.clone(k);this._oObserver.observe(X,{properties:["visible"]});if(Y){if(U(Y,"sap/ui/core/VariantLayoutData")){var $=Y.getMultipleLayoutData();for(var j=0;j<$.length;j++){if(v.call(this,$[j])){V._aLayouts.push(Z.getLayoutData().getMultipleLayoutData()[j].getId());}}}else if(v.call(this,Y)){V._aLayouts.push(Z.getLayoutData().getId());}}V.addContent(Z);}this._bChangedByMe=false;return V;};function _(){var i=this.getAggregation("form");if(i.getLayout()){this._bChangedByMe=true;i.destroyLayout();O.call(this);this._bChangedByMe=false;}var j;switch(this.getLayout()){case S.ResponsiveLayout:if((!d||!e)&&!this._bResponsiveLayoutRequested){d=sap.ui.require("sap/ui/layout/form/ResponsiveLayout");e=sap.ui.require("sap/ui/layout/ResponsiveFlowLayoutData");if(!d||!e){sap.ui.require(["sap/ui/layout/form/ResponsiveLayout","sap/ui/layout/ResponsiveFlowLayoutData"],n.bind(this));this._bResponsiveLayoutRequested=true;}}if(d&&e){j=new d(this.getId()+"--Layout");}break;case S.GridLayout:if((!G||!g||!h)&&!this._bGridLayoutRequested){G=sap.ui.require("sap/ui/layout/form/GridLayout");g=sap.ui.require("sap/ui/layout/form/GridContainerData");h=sap.ui.require("sap/ui/layout/form/GridElementData");if(!G||!g||!h){sap.ui.require(["sap/ui/layout/form/GridLayout","sap/ui/layout/form/GridContainerData","sap/ui/layout/form/GridElementData"],o.bind(this));this._bGridLayoutRequested=true;}}if(G&&g&&h){j=new G(this.getId()+"--Layout");}break;case S.ResponsiveGridLayout:if(!f&&!this._bResponsiveGridLayoutRequested){f=sap.ui.require("sap/ui/layout/form/ResponsiveGridLayout");if(!f){sap.ui.require(["sap/ui/layout/form/ResponsiveGridLayout"],p.bind(this));this._bResponsiveGridLayoutRequested=true;}}if(f){j=new f(this.getId()+"--Layout");}break;}if(j){this._bChangedByMe=true;i.setLayout(j);this._bChangedByMe=false;return true;}return false;}function n(i,j){d=i;e=j;this._bResponsiveLayoutRequested=false;if(this.getLayout()==S.ResponsiveLayout){r.call(this);}}function o(i,j,k){G=i;g=j;h=k;this._bGridLayoutRequested=false;if(this.getLayout()==S.GridLayout){r.call(this);}}function p(i){f=i;this._bResponsiveGridLayoutRequested=false;if(this.getLayout()==S.ResponsiveGridLayout){r.call(this);}}function r(){if(!this._bIsBeingDestroyed){_.call(this);t.call(this);if(this.getDomRef()){u.call(this);}}}function s(){this._bChangedByMe=true;var V=this.getAggregation("form");var W=V.getFormContainers();for(var i=0;i<W.length;i++){var X=W[i];P(this._changedFormContainers,X);if(X.getLayoutData()){X.destroyLayoutData();}var Y=X.getFormElements();for(var j=0;j<Y.length;j++){var Z=Y[j];P(this._changedFormElements,Z);if(Z.getLayoutData()){Z.destroyLayoutData();}var $=Z.getLabel();if($){E.call(this,$);}var a1=Z.getFields();for(var k=0;k<a1.length;k++){var b1=a1[k];E.call(this,b1);}}}this._bChangedByMe=false;}function t(){this._bChangedByMe=true;var V=this.getAggregation("form");var W=V.getFormContainers();for(var i=0;i<W.length;i++){var X=W[i];P(this._changedFormContainers,X);D.call(this,X);var Y=X.getFormElements();for(var j=0;j<Y.length;j++){var Z=Y[j];P(this._changedFormElements,Z);A.call(this,Z);var $=Z.getLabel();if($){z.call(this,$,this._iLabelWeight,false,true,this.getLabelMinWidth());}var a1=Z.getFields();for(var k=0;k<a1.length;k++){var b1=a1[k];z.call(this,b1,5,false,true);}}}this._bChangedByMe=false;}function u(){this._bChangedByMe=true;this._changedFormContainers=[];var j=this.getLayout();var k=this.getAggregation("form").getLayout();k.setBackgroundDesign(this.getBackgroundDesign());switch(j){case S.ResponsiveLayout:this._applyLinebreaks();for(var i=0;i<this._changedFormElements.length;i++){var V=this._changedFormElements[i];L.call(this,V);}break;case S.GridLayout:N.call(this);break;case S.ResponsiveGridLayout:k.setLabelSpanXL(this.getLabelSpanXL());k.setLabelSpanL(this.getLabelSpanL());k.setLabelSpanM(this.getLabelSpanM());k.setLabelSpanS(this.getLabelSpanS());k.setAdjustLabelSpan(this.getAdjustLabelSpan());k.setEmptySpanXL(this.getEmptySpanXL());k.setEmptySpanL(this.getEmptySpanL());k.setEmptySpanM(this.getEmptySpanM());k.setEmptySpanS(this.getEmptySpanS());k.setColumnsXL(this.getColumnsXL());k.setColumnsL(this.getColumnsL());k.setColumnsM(this.getColumnsM());k.setSingleContainerFullSize(this.getSingleContainerFullSize());k.setBreakpointXL(this.getBreakpointXL());k.setBreakpointL(this.getBreakpointL());k.setBreakpointM(this.getBreakpointM());break;}this._changedFormElements=[];this._bChangedByMe=false;}function v(i){var j=i.getId(),k=" "+this._aLayouts.join(" ")+" ";return k.indexOf(" "+j+" ")>-1;}function w(W,i,j,k){var V=new e({weight:W,linebreak:i===true,linebreakable:j===true});if(k){V.setMinWidth(k);}this._aLayouts.push(V.getId());return V;}function x(i){var j;switch(this.getLayout()){case S.ResponsiveLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.ResponsiveFlowLayoutData");break;case S.GridLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.form.GridElementData");break;case S.ResponsiveGridLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.GridData");break;}return j;}function y(){if(this._bResponsiveLayoutRequested||this._bGridLayoutRequested||this._bResponsiveGridLayoutRequested){return false;}if(!this.getAggregation("form").getLayout()){var i=this._bChangedByMe;var j=_.call(this);this._bChangedByMe=i;if(!j){return false;}}return true;}function z(i,W,j,k,V){if(this.getLayout()!=S.ResponsiveLayout){return;}if(!y.call(this)){return;}this._bLayoutDataChangedByMe=true;var X=x.call(this,i);if(!X||!v.call(this,X)){X=i.getLayoutData();if(U(X,"sap/ui/core/VariantLayoutData")){X.addMultipleLayoutData(w.call(this,W,j,k,V));}else if(!X){i.setLayoutData(w.call(this,W,j,k,V));}else{q.sap.log.warning("ResponsiveFlowLayoutData can not be set on Field "+i.getId(),"_createFieldLayoutData","SimpleForm");}}this._bLayoutDataChangedByMe=false;}function A(i){if(this.getLayout()!=S.ResponsiveLayout){return;}if(!y.call(this)){return;}this._bLayoutDataChangedByMe=true;i.setLayoutData(new e({linebreak:true,margin:false}));this._bLayoutDataChangedByMe=false;}function D(i){var j=this.getLayout();if(j!=S.ResponsiveLayout&&j!=S.GridLayout){return;}if(!y.call(this)){return;}this._bLayoutDataChangedByMe=true;switch(j){case S.ResponsiveLayout:i.setLayoutData(new e({minWidth:280}));break;case S.GridLayout:if(this.getMaxContainerCols()>1){i.setLayoutData(new g({halfGrid:true}));}else{i.setLayoutData(new g({halfGrid:false}));}break;}this._bLayoutDataChangedByMe=false;}function E(j){this._bLayoutDataChangedByMe=true;var k=x.call(this,j);if(k){var V=k.getId();for(var i=0;i<this._aLayouts.length;i++){var W=this._aLayouts[i];if(V==W){k.destroy();this._aLayouts.splice(i,1);break;}}}this._bLayoutDataChangedByMe=false;}function H(i,j){var k=J.call(this,j);i.addFormElement(k);return k;}function I(i,j,k){var V=J.call(this,j);i.insertFormElement(V,k);return V;}function J(j){var k=new b();A.call(this,k);if(j){j.addStyleClass("sapUiFormLabel-CTX");k.setLabel(j);if(!x.call(this,j)){z.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}}k.isVisible=function(){var V=this.getFields();var W=false;for(var i=0;i<V.length;i++){var X=V[i];if(X.getVisible()){W=true;break;}}return W;};return k;}function K(i){var j=new a();D.call(this,j);j.getAriaLabelledBy=function(){var k=this.getToolbar();if(k){return k.getAriaLabelledBy();}else{return[];}};if(i){if(i instanceof sap.ui.core.Title){j.setTitle(i);}else if(i.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){j.setToolbar(i);}}return j;}function L(j){var k=this._iMaxWeight;var V=j.getFields();var W;var X=V.length;var Y=j.getLabel();var Z;var i=0;this._bLayoutDataChangedByMe=true;if(Y&&x.call(this,Y)){k=k-x.call(this,Y).getWeight();}for(i=0;i<V.length;i++){W=V[i];Z=x.call(this,W);if(U(Z,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,Z)){k=k-Z.getWeight();X--;}}var $=Math.floor(k/X);var a1=k%X;for(i=0;i<V.length;i++){W=V[i];Z=x.call(this,W);var b1=$;if(!Z){z.call(this,W,b1,false,i==0);}else if(v.call(this,Z)&&U(Z,"sap/ui/layout/ResponsiveFlowLayoutData")){if(a1>0){b1++;a1--;}Z.setWeight(b1);}}this._bLayoutDataChangedByMe=false;}m.prototype._applyLinebreaks=function(){if(!d||this._bResponsiveLayoutRequested){return;}this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form"),k=j.getFormContainers();var V=this.getDomRef();var W=this.$();for(var i=1;i<k.length;i++){var X=k[i],Y=X.getLayoutData();if(!V||W.outerWidth(true)>this.getMinWidth()){if(i%this.getMaxContainerCols()==0){Y.setLinebreak(true);}else{Y.setLinebreak(false);}}else{Y.setLinebreak(true);}}if(V&&W.css("visibility")=="hidden"){var Z=this;setTimeout(function(){if(Z.getDomRef()){Z.$().css("visibility","");}},10);}this._bLayoutDataChangedByMe=false;};function N(){this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form");var k=j.getFormContainers();var V=k.length;for(var i=0;i<V;i++){var W=k[i];if((this.getMaxContainerCols()<=1)||((i==V-1)&&(V%2>0))){W.getLayoutData().setHalfGrid(false);}else if(!W.getLayoutData().getHalfGrid()){W.getLayoutData().setHalfGrid(true);}}this._bLayoutDataChangedByMe=false;}m.prototype._resize=function(i){this._bChangedByMe=true;if(this._iCurrentWidth==i.size.width){return;}this._iCurrentWidth=i.size.width;this._applyLinebreaks();this._bChangedByMe=false;};function O(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}}function P(j,k){var V=false;for(var i=0;i<j.length;i++){var W=j[i];if(W==k){V=true;break;}}if(!V){j.push(k);}}function Q(i){if(i.name=="visible"){var j=i.object.getParent();j.invalidate();}}function T(V){var W=[];var X=V.getFormContainers();for(var i=0;i<X.length;i++){var Y=X[i];var Z=Y.getTitle();if(Z){W.push(Z);}else{var $=Y.getToolbar();if($){W.push($);}}var a1=Y.getFormElements();for(var j=0;j<a1.length;j++){var b1=a1[j];var c1=b1.getLabel();if(c1){W.push(c1);}var d1=b1.getFields();for(var k=0;k<d1.length;k++){var e1=d1[k];W.push(e1);}}}return W;}m.prototype._formInvalidated=function(k){if(!this._bChangedByMe){var V=T(this.getAggregation("form"));var i=0;var j=0;var W=false;if(!this._aElements||V.length<this._aElements.length){W=true;}else{for(i=0;i<V.length;i++){var X=V[i];var Y=this._aElements[j];if(X===Y){j++;}else{var Z=V[i+1];if(Z===Y){this.insertContent(X,i);break;}Z=this._aElements[j+1];if(Z===X){W=true;break;}break;}}}if(W){this.removeAllContent();for(i=0;i<V.length;i++){var $=V[i];this.addContent($);}}}};m.prototype._onLayoutDataChange=function(i){if(!this._bLayoutDataChangedByMe&&!this._bIsBeingDestroyed){switch(this.getLayout()){case S.ResponsiveLayout:var j=i.srcControl;var k=j.getParent();if(k instanceof b){var V=this.indexOfContent(j);this.removeContent(j);this.insertContent(j,V);}break;}}};function U(i,j){var k=sap.ui.require(j);return i&&typeof k==='function'&&(i instanceof k);}return m;});
