/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo'],function(Q,T,C,F,a,b,S,c,d,B,A){"use strict";var f="sap.ui.model.analytics.AnalyticalBinding";function t(o){var e=new d.QueryResultRequest(o.oAnalyticalQueryResult),g,s,D,i,j,m,n,p,h=o.mParameters.select.split(","),E=v(h,o.sPath);e.setAggregationLevel(o.aMaxAggregationLevel);e.setMeasures(o.aMeasureName);Object.keys(o.oDimensionDetailsSet).forEach(function(k){D=o.oDimensionDetailsSet[k];e.includeDimensionKeyTextAttributes(k,true,D.textPropertyName!==undefined,D.aAttributeName);});Object.keys(o.oMeasureDetailsSet).forEach(function(M){m=o.oMeasureDetailsSet[M];e.includeMeasureRawFormattedValueUnit(M,m.rawValuePropertyName!==undefined,m.formattedValuePropertyName!==undefined,m.unitPropertyName!==undefined);});s=e.getURIQueryOptionValue("$select");if(s){g=s.split(",");for(i=0,n=g.length;i<n;i++){p=g[i];j=h.indexOf(p);if(j<0){Q.sap.log.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+p+"'",o.sPath,f);E=true;}else{h.splice(j,1);}}}for(i=0,n=h.length;i<n;i++){p=h[i];D=o.oAnalyticalQueryResult.findDimensionByPropertyName(p);if(D&&o.oDimensionDetailsSet[D.getName()]===undefined){u(o.sPath,p,D);E=true;}m=o.oAnalyticalQueryResult.findMeasureByPropertyName(p);if(m&&o.oMeasureDetailsSet[m.getName()]===undefined){u(o.sPath,p,m);E=true;}}return E?[]:h;}function u(p,s,D){var e=D instanceof sap.ui.model.analytics.odata4analytics.Dimension?"dimension":"measure";if(D.getName()===s){Q.sap.log.warning("Ignored the 'select' binding parameter, because it contains"+" the "+e+" property '"+s+"' which is not contained in the analytical info (see updateAnalyticalInfo)",p,f);}else{Q.sap.log.warning("Ignored the 'select' binding parameter, because the property '"+s+"' is associated with the "+e+" property '"+D.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",p,f);}}function v(s,p){var e,E=false,i,n;for(i=0,n=s.length;i<n;i++){s[i]=s[i].trim();}for(i=s.length-1;i>=0;i--){e=s[i];if(s.indexOf(e)!==i){Q.sap.log.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+e+"' multiple times",p,f);s.splice(i,1);E=true;}}return E;}var w=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.aAdditionalSelects=[];this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==c.None){Q.sap.log.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==c.Request||P.countMode==c.Both)){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==c.Request){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){Q.sap.log.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});function x(o,e){return function(){if(!o.__supportUID){o.__supportUID=Q.sap.uid();}return{type:f,analyticalError:e,analyticalBindingId:o.__supportUID};};}w.prototype.setContext=function(o){if(this.oContext!==o){this.oContext=o;this.oDataState=null;if(!this.isRelative()){return;}var r=this.oModel.resolve(this.sPath,this.oContext);if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}}};w.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};w.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};w.prototype.getRootContexts=function(p){if(this.isInitial()){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(w._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(w._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){Q.sap.log.fatal("assertion failed: grand total represented by a single entry");}return r;};w.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,L,n,e;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;L=p.level;n=p.numberOfExpandedLevels;e=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];L=arguments[4];n=arguments[5];e=arguments[6];}var g=this._getContextsForParentContext(o,s,l,i,L,n,e);return g;};w.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};w.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return w.prototype.ContextsAvailabilityStatus.ALL;}else{return w.prototype.ContextsAvailabilityStatus.SOME;}}else{return w.prototype.ContextsAvailabilityStatus.NONE;}};w.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};w.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){Q.sap.log.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};w.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return Q.inArray(this.aAggregationLevel[i-1],this.aMaxAggregationLevel)<this.aMaxAggregationLevel.length-1;};w.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};w.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};w.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};w.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};w.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};w.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};w.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};w.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};w.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};w.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};w.prototype.isMeasure=function(p){return Q.inArray(p,this.aMeasureName)!==-1;};w.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==b.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this._fireRefresh({reason:C.Filter});return this;};w.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};w.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],D=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),V=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),e,s,G;if(D&&this.oDimensionDetailsSet[g].textPropertyName){e=D.getTextProperty();}var h,i,j;if(e){h=D.getTextProperty().name;j=this.mAnalyticalInfoByProperty[h]&&this.mAnalyticalInfoByProperty[h].formatter;i=o.getProperty(h);}if(!e){s=V?V(p):p;G=((D.getLabelText())?D.getLabelText()+': ':'')+s;}else{s=V?V(p,i):p;G=((D.getLabelText())?D.getLabelText()+': ':'')+s;var k=j?j(i,p):i;if(k){G+=' - '+k;}}return G;};w.prototype.updateAnalyticalInfo=function(e,g){if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}if(Q.sap.equal(this._aLastChangedAnalyticalInfo,e)){if(g){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}var p=this.oDimensionDetailsSet;this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];for(var i=0;i<e.length;i++){var D=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(D&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=D.getName();var o=this.oDimensionDetailsSet[D.getName()];if(!o){o={};o.name=D.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[D.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(Q.inArray(D.getName(),this.getSortablePropertyNames())==-1){Q.sap.log.fatal("property "+D.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(D.getName()==e[i].name){o.keyPropertyName=e[i].name;}var h=D.getTextProperty();if(h&&h.name==e[i].name){o.textPropertyName=e[i].name;}if(D.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var m=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(m&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=m.getName();var M=this.oMeasureDetailsSet[m.getName()];if(!M){M={};M.name=m.getName();this.oMeasureDetailsSet[m.getName()]=M;this.aMeasureName.push(M.name);}if(m.getRawValueProperty().name==e[i].name){M.rawValuePropertyName=e[i].name;}var k=m.getFormattedValueProperty();if(k&&k.name==e[i].name){M.formattedValuePropertyName=e[i].name;}M.analyticalInfo=e[i];}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}for(var l in this.oMeasureDetailsSet){var U=this.oAnalyticalQueryResult.findMeasureByName(l).getUnitProperty();if(U){this.oMeasureDetailsSet[l].unitPropertyName=U.name;}}var n=function(q){var N=[];for(var r in q){N.push(r.name);}return N.sort().join(";");};if(n(p)!=n(this.oDimensionDetailsSet)){this.iTotalSize=-1;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=t(this);}if(g){this._fireChange({reason:C.Change});}};w.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};w.prototype.loadGroups=function(g){var G=[];for(var s in g){G.push(s);this._resetData(s);var e=g[s];for(var i=0;i<e.length;i++){var o=e[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,h;(h=G[++j])!==undefined;){r.push(this._getRequestId(w._requestType.groupMembersQuery,{groupId:h}));}this._considerRequestGrouping(r);}};w.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};w._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};w._artificialRootContextGroupId="artificialRootContext";w.prototype._getContextsForParentContext=function(p,s,l,i,L,n,e){if(p===undefined){return[];}if(p&&p.getPath()=="/"+w._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,L);return this._getContextsForParentGroupId(P,s,l,i,n,e);};w.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){Q.sap.log.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){Q.sap.log.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){Q.sap.log.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],L,G,o,m;var k=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[k]){this.aMultiUnitLoadFactor[k]=1;}var q=n>0&&p!=null;if(q){var M=this._getGroupIdLevel(p);var r=M+n;var D=true;if(!g){o=this._calculateRequiredGroupExpansion(p,r,s,l+e);D=o.groupId_Missing==null;D=D||o.groupId_Missing.length<p.length||o.groupId_Missing.substring(0,p.length)!=p;}if(D){h=this._getLoadedContextsForGroup(p,s,l);}else{m=l+e;}L=!D;m=Math.ceil(m*this.aMultiUnitLoadFactor[k]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);L=false;if(!g){G=this._calculateRequiredGroupSection(p,s,l,e,h);var P=G.length>0&&l<G.length;L=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||P;G.length=Math.ceil(G.length*this.aMultiUnitLoadFactor[k]);}}if(!L){this._cleanupGroupingForCompletedRequest(this._getRequestId(w._requestType.groupMembersQuery,{groupId:p}));}var E=false;if(this.oModel.getServiceMetadata()){if(L){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(w._requestType.totalSizeQuery));E=true;var y;if(this.bUseBatchRequests){if(q){y=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,R;(R=y[++i])!==undefined;){if(this._isRequestPending(R)){E=false;break;}}if(E){this.aBatchRequestQueue.push([w._requestType.groupMembersAutoExpansionQuery,p,o,m,n]);}}else{E=!this._isRequestPending(this._getRequestId(w._requestType.groupMembersQuery,{groupId:p}));if(E){this.aBatchRequestQueue.push([w._requestType.groupMembersQuery,p,G.startIndex,G.length]);y=[this._getRequestId(w._requestType.groupMembersQuery,{groupId:p})];}}if(E&&N){y.push(this._getRequestId(w._requestType.totalSizeQuery));this._considerRequestGrouping(y);this.aBatchRequestQueue.push([w._requestType.totalSizeQuery]);}if(E){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(w.prototype._processRequestQueue.bind(this));}}else{var z;if(q){y=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,H;(H=y[++j])!==undefined;){if(this._isRequestPending(H)){E=false;break;}}if(E){z=this._prepareGroupMembersAutoExpansionQueryRequest(w._requestType.groupMembersAutoExpansionQuery,p,o,m,n);}}else{E=!this._isRequestPending(this._getRequestId(w._requestType.groupMembersQuery,{groupId:p}));if(E){z=this._prepareGroupMembersQueryRequest(w._requestType.groupMembersQuery,p,G.startIndex,G.length);y=[z.sRequestId];}}if(E){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(z);if(N&&!z.bIsFlatListRequest){y.push(this._getRequestId(w._requestType.totalSizeQuery));this._considerRequestGrouping(y);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(w._requestType.totalSizeQuery));}}}}}return h;};w.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==w._requestType.groupMembersQuery){o=w.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case w._requestType.groupMembersQuery:continue;case w._requestType.totalSizeQuery:if(!e){o=w.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case w._requestType.groupMembersAutoExpansionQuery:o=w.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case w._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:Q.sap.log.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};w.prototype._prepareGroupMembersQueryRequest=function(r,g,s,L){var G=[];var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=0,h=-1;if(g){G=this._getGroupIdComponents(g);e=h=G.length;var U=0;for(var j=0,p=0;j<e;p++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[p]].grouped==false){++U;}else{++j;}}e=h=e+U;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[h]].grouped==false){if(++h==this.aMaxAggregationLevel.length){break;}}}}var I=h>=this.aMaxAggregationLevel.length-1;var q=this.aMaxAggregationLevel.slice(0,h+1);o.setAggregationLevel(q);for(var i=0;i<q.length;i++){var D=this.oDimensionDetailsSet[q[i]];var y=(D.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(D.name,true,y,D.aAttributeName);if(D.grouped){o.getSortExpression().addSorter(q[i],d.SortOrder.Ascending);}}var z=o.getFilterExpression();z.clear();if(this.aApplicationFilter){z.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){z.addUI5FilterConditions(this.aControlFilter);}if(e>=1){for(var k=0,l=G.length;k<l;k++){z.removeConditions(this.aAggregationLevel[k]);z.addCondition(this.aAggregationLevel[k],a.EQ,G[k]);}}var E;var H;var J;var M;var K=[];if(g!=null||this.bProvideGrandTotals){o.setMeasures(this.aMeasureName);for(var N in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[N];if(!I&&this.mAnalyticalInfoByProperty[N].total==false){E=false;H=false;J=false;}else{E=(M.rawValuePropertyName!=undefined);H=(M.formattedValuePropertyName!=undefined);J=(M.unitPropertyName!=undefined);if(J){if(Q.inArray(M.unitPropertyName,K)==-1){K.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,E,H,J);}for(var n in q){var O;if((O=Q.inArray(q[n],K))!=-1){K.splice(O,1);}}}var P=o.getSortExpression();for(var m=0;m<this.aSorter.length;m++){if(this.aSorter[m]){P.addSorter(this.aSorter[m].sPath,this.aSorter[m].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var R=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){o.setResultPageBoundaries(R.iServiceKeyIndex+1,R.iServiceKeyIndex+L);}o.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(w._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:o,sGroupId:g,aSelectedUnitPropertyName:K,aAggregationLevel:q,bIsFlatListRequest:I&&e==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:L,oKeyIndexMapping:R};};w.prototype._prepareTotalSizeQueryRequest=function(r){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.setAggregationLevel(this.aMaxAggregationLevel);o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(w._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};w.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,G,L,n){var e=this;var p=function(G,o){var y=[];if(G.groupId_Missing==null){Q.sap.log.fatal("missing group Id not present");return y;}var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;if(s>o){Q.sap.log.fatal("the given group ID is too deep for requested level for auto expansion");return y;}var k=[];for(var i=0;i<s;i++){var l=e.aAggregationLevel[i];var V=q[i];var P=e._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,P,V);}var U=null;if(G.startIndex_Missing>0){var W=e._getKey(G.groupId_Missing,G.startIndex_Missing-1);var X=e.oModel.getObject("/"+W);var Y=e.aAggregationLevel[s];var Z=X[Y];U=new F(Y,e._getFilterOperatorMatchingPropertySortOrder(Y,false),Z);}for(var D=0;D<o;D++){var $=[];var _=Math.min(s,D+1);for(var a1=0;a1<_;a1++){var b1=[];var c1=Math.min(s,a1+1);var d1=G.startIndex_Missing>0;for(var e1=0;e1<c1;e1++){var f1=new F("x",a.EQ,"x");f1=Q.extend(true,f1,k[e1]);if(c1>1&&e1<c1-1){f1.sOperator=a.EQ;}if(e1==s-1&&D>s-1&&!d1){if(f1.sOperator==a.GT){f1.sOperator=a.GE;}else{f1.sOperator=a.LE;}}b1.push(f1);}if(b1.length>0){$.push(new F(b1,true));if(D>s-1&&a1==s-1&&d1){var g1=[];for(var j=0;j<b1.length;j++){var h1=new F("x",a.EQ,"x");h1=Q.extend(true,h1,b1[j]);g1.push(h1);}g1[s-1].sOperator=a.EQ;g1.push(U);$.push(new F(g1,true));break;}}}if($.length>0){y[D]=new F($,false);}else{y[D]=null;}}return y;};var h=function(r,g,D,P,E,L,U,V){var W=new d.QueryResultRequest(e.oAnalyticalQueryResult);W.setResourcePath(e._getResourcePath());W.getSortExpression().clear();var X=0,Y=-1;X=Y=D-1;var Z=0;for(var i=0,$=0;i<X;$++){if(e.oDimensionDetailsSet[e.aMaxAggregationLevel[$]].grouped==false){++Z;}else{++i;}}X=Y=X+Z;if(e.aMaxAggregationLevel.length>0){while(e.oDimensionDetailsSet[e.aMaxAggregationLevel[Y]].grouped==false){if(++Y==e.aMaxAggregationLevel.length){break;}}}var _=Y>=e.aMaxAggregationLevel.length-1;var a1=e.aMaxAggregationLevel.slice(0,Y+1);W.setAggregationLevel(a1);for(var l=0;l<a1.length;l++){var b1=e.oDimensionDetailsSet[a1[l]];var c1=(b1.textPropertyName!=undefined);W.includeDimensionKeyTextAttributes(b1.name,true,c1,b1.aAttributeName);if(b1.grouped){W.getSortExpression().addSorter(a1[l],d.SortOrder.Ascending);}}var d1=W.getFilterExpression();d1.clear();if(e.aApplicationFilter){d1.addUI5FilterConditions(e.aApplicationFilter);}if(e.aControlFilter){d1.addUI5FilterConditions(e.aControlFilter);}if(P){d1.addUI5FilterConditions([P]);}var e1;var f1;var g1;var h1;var i1=[];W.setMeasures(e.aMeasureName);for(var j1 in e.oMeasureDetailsSet){h1=e.oMeasureDetailsSet[j1];if(!_&&e.mAnalyticalInfoByProperty[j1].total==false){e1=false;f1=false;g1=false;}else{e1=(h1.rawValuePropertyName!=undefined);f1=(h1.formattedValuePropertyName!=undefined);g1=(h1.unitPropertyName!=undefined);if(g1){if(Q.inArray(h1.unitPropertyName,i1)==-1){i1.push(h1.unitPropertyName);}}}W.includeMeasureRawFormattedValueUnit(h1.name,e1,f1,g1);}for(var j in a1){var k1;if((k1=Q.inArray(a1[j],i1))!=-1){i1.splice(k1,1);}}var l1=W.getSortExpression();for(var k=0;k<e.aSorter.length;k++){if(e.aSorter[k]){l1.addSorter(e.aSorter[k].sPath,e.aSorter[k].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var m1=E;if(!V){m1=0;}else{var n1=0;for(var o1 in e.mServiceKey){if(o1.split("/").length===D+1){n1+=e.mServiceKey[o1].length;}}m1=Math.max(m1,n1);}if(!e.bNoPaging){W.setResultPageBoundaries(m1+1,L);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:W,iLevel:D,aSelectedUnitPropertyName:i1,aAggregationLevel:a1,bIsFlatListRequest:_,bIsLeafGroupsRequest:_,iStartIndex:E,iLength:L,bAvoidLengthUpdate:U};};var m=[];var R=[];if(!G){Q.sap.log.fatal("no first missing group member specified");}var o=this._getGroupIdLevel(g)+n+1;var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;var y=p(G,o);var z;for(var D=1;D<=o;D++){var E;if(D>=s+2){E=0;z=undefined;}else if(D==s+1){E=G.startIndex_Missing;z=G.groupId_Missing;}else if(s>0){if(D==s){z=G.groupId_Missing;}else{z=this._getGroupIdAncestors(G.groupId_Missing,-(s-D))[0];}var H=this._getGroupIdAncestors(G.groupId_Missing,-(s-D+1))[0];if(!H){Q.sap.log.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+D);}E=this._findKeyIndex(H,this.mEntityKey[z]);if(E==-1){Q.sap.log.fatal("failed to determine position of value "+z+" in group "+H);}z=H;E++;}var I=L>D?Math.ceil((L-D)/(o-D+1)):L;var J=y[D-1];if(this.bUseAcceleratedAutoExpand){var K=h(w._requestType.levelMembersQuery,g,D,J,E,I,false,J==null?true:false);K.sGroupId_Missing_AtLevel=z;K.sRequestId=this._getRequestId(w._requestType.levelMembersQuery,{groupId:g,level:D});m.push(K);R.push(K.sRequestId);}else if(J&&J.aFilters.length>0){if(!J._bMultiFilter||J.bAnd){Q.sap.log.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<J.aFilters.length;i++){var M=J.aFilters[i];var N=h(w._requestType.levelMembersQuery,g,D,M,E,I,false,J==null?true:false);N.sGroupId_Missing_AtLevel=z;N.sRequestId=this._getRequestId(w._requestType.levelMembersQuery,{groupId:g,level:D,tupleIndex:i});m.push(N);R.push(N.sRequestId);}}else{var O=h(w._requestType.levelMembersQuery,g,D,null,E,I,false,J==null?true:false);O.sGroupId_Missing_AtLevel=z;O.sRequestId=this._getRequestId(w._requestType.levelMembersQuery,{groupId:g,level:D});m.push(O);R.push(O.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:m,sGroupId:g,iLength:L};};w.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var I=g.bIsLeafGroupsRequest;var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter);}var k=[];for(var i=0;i<e.length;i++){var l=new F(e[i],a.EQ,m.oEntry[e[i]]);k.push(l);}h.addUI5FilterConditions(k);var n;var p;var q;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var y in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[y];if(Q.inArray(M.name,m.aReloadMeasurePropertyName)==-1){continue;}if(!I&&this.mAnalyticalInfoByProperty[y].total==false){n=false;p=false;q=false;}else{n=(M.rawValuePropertyName!=undefined);p=(M.formattedValuePropertyName!=undefined);q=(M.unitPropertyName!=undefined);if(q){if(Q.inArray(M.unitPropertyName,s)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,n,p,q);}for(var j in e){var z;if((z=Q.inArray(e[j],s))!=-1){s.splice(z,1);}}return{iRequestType:r,sRequestId:this._getRequestId(w._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:e,oMultiUnitRepresentative:m};};w.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(w._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};w.prototype._getQueryODataRequestOptions=function(o,g,p){var i;p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){Q.sap.log.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var h=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var j=o.getURIQueryOptionValue("$skip");var k=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(g&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",");}if(this.mParameters&&this.mParameters["filter"]){h+="and ("+this.mParameters["filter"]+")";}var P=[];if(s!==null){P.push("$select="+s);}if(h!==null){P.push("$filter="+h);}if(O!==null){P.push("$orderby="+O);}if(j!==null){P.push("$skip="+j);}if(k!==null){P.push("$top="+k);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};w.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber,R,g=this;var h=[],E=[];function l(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var o=new B();function s(j,k){o.success(k);}function m(j,k){o.error(k||j);}this.bNeedsUpdate=true;for(var D=0;D<r.length;D++){var n=r[D];if(n.aAggregationLevel&&n.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,p;(p=r[++i])!==undefined;){var q=p.oAnalyticalQueryRequest,G=p.sGroupId;if(q.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),w._artificialRootContextGroupId);setTimeout(l);this.bArtificalRootContext=true;continue;}var P=q.getURIToQueryResultEntries();if(!this.oContext&&P[0]!=="/"){P="/"+P;}if(!this._isRequestPending(p.sRequestId)){this._registerNewRequest(p.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(P.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var U=this._getQueryODataRequestOptions(q,p.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){U.push(this.sCustomParams);}var y=this.oModel.read(P.replace(/\ /g,"%20"),{success:s,error:m,context:this.oContext,urlParameters:U});h.push(y);}E.push(p);}}if(h.length>0){Q.sap.log.debug("AnalyticalBinding: executing batch request with "+E.length+" operations");var z;R=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);z=this.oModel.submitBatch(H,I,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{z={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};o.setup({executedRequests:E,binding:this,success:H,error:I});}this._registerNewRequestHandle(R,z);}function H(J,K){g._deregisterHandleOfCompletedRequest(R);if(E.length!=J.__batchResponses.length){Q.sap.log.fatal("assertion failed: received "+J.__batchResponses.length+" responses for "+E.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<E.length;j++){var L=E[j].sRequestId;if(L!==undefined){g._deregisterCompletedRequest(L);g._cleanupGroupingForCompletedRequest(L);}}g.fireDataReceived({data:[]});return;}var M=0;for(var k=0;k<J.__batchResponses.length;k++){if(J.__batchResponses[k].data!=undefined){if(J.__batchResponses[k].data.results.length==0){M++;}switch(E[k].iRequestType){case w._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(E[k],J.__batchResponses[k].data);break;case w._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(E[k],J.__batchResponses[k].data);break;case w._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(E[k],J.__batchResponses[k].data);break;case w._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(E[k],J.__batchResponses[k].data);break;default:Q.sap.log.fatal("invalid request type "+E[k].iRequestType);continue;}}g._deregisterCompletedRequest(E[k].sRequestId);g._cleanupGroupingForCompletedRequest(E[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(M==J.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var O=true;var N;g.fireDataReceived({data:J});var V={};if(g.iModelVersion===A.V1){N=g.oModel._getBatchErrors(J);if(N.length>0){O=false;V=g.oModel._handleError(N[0]);}g.oModel.fireRequestCompleted({url:K.requestUri,type:"POST",async:true,info:"",infoObject:{},success:O,errorobject:O?{}:V});if(O){g.oModel.checkUpdate();}}}function I(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(R);for(var j=-1,J;(J=E[++j])!==undefined;){g._deregisterCompletedRequest(J.sRequestId);g._cleanupGroupingForCompletedRequest(J.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var V=k;if(g.iModelVersion===A.V1){V=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:V});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed(V);}g.fireDataReceived();}};w.prototype._executeQueryRequest=function(r){if(r.iRequestType==w._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,G=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g,r.bIsLeafGroupsRequest);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),w._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}Q.sap.log.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,s,E,false,U,l);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p,{success:s,error:E,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function s(D){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case w._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,D);break;case w._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,D);break;case w._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,D);break;case w._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,D);break;default:Q.sap.log.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){l(D);}}function l(D){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:D});}}function E(m){if(m&&m.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function U(k){h._registerNewRequestHandle(R,k);}};w.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};w.prototype._processGroupMembersQueryResponse=function(R,D){var e,G=R.sGroupId,s=R.aSelectedUnitPropertyName,n=R.aAggregationLevel,y=R.oKeyIndexMapping.iIndex,z=R.oKeyIndexMapping.iServiceKeyIndex,L=R.iLength,K=R.oKeyIndexMapping,E=G==null?0:this._getGroupIdLevel(G)+1,U=(s.length>0),P,H,I,J=0,M,N,O=[];var V=D.results.length;var W=this._getServiceKeys(G,K.iIndex-1);P=undefined;if(W&&W.length>0){for(var i=0,X=W.length;i<X;i++){D.results[i-X]=this.oModel.getObject("/"+W[i]);}var Y=D.results[-W.length];P="";for(var j=0;j<n.length;j++){P+=Y[n[j]]+"|";}}M=W&&W.length==1;for(var h=0;h<V;h++){var Z=D.results[h];if(U){H="";for(var g=0;g<n.length;g++){H+=Z[n[g]]+"|";}if(P==H){if(I===undefined){if(h==0){I=-W.length;K.iServiceKeyIndex-=W.length-1;}else{I=h-1;}}var $=-1,_=D.results[h-1];for(var k=0;k<s.length;k++){if(_[s[k]]!=Z[s[k]]){$=k;break;}}if($==-1){Q.sap.log.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,x(this,"NO_DEVIATING_UNITS"));}}if((P!=H||h==V-1)&&I!==undefined){var a1=[];for(var l=I;l<h;l++){a1.push(D.results[l]);}if(P==H){a1.push(D.results[h]);}var b1=[];for(var m=0;m<s.length;m++){var c1=s[m];for(var o=1;o<a1.length;o++){if(a1[o-1][c1]!=a1[o][c1]){b1.push(c1);break;}}}var d1=this._createMultiUnitRepresentativeEntry(G,D.results[I],s,b1,R.bIsFlatListRequest);if(d1.aReloadMeasurePropertyName.length>0){N=this._prepareReloadMeasurePropertiesQueryRequest(w._requestType.reloadMeasuresQuery,R,d1);if(N.oAnalyticalQueryRequest&&N.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){O.push(N);}}var e1=this._setAdjacentMultiUnitKeys(K,d1,a1);var f1;if(d1.bIsNewEntry){f1=a1.length-1;}else{f1=e1;}if(M){M=false;}if(f1<0){Q.sap.log.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}J+=f1;var g1=this.oModel._getKey(d1.oEntry);var h1=this.oModel.getContext('/'+g1);this._getGroupIdFromContext(h1,E);this.mEntityKey[e]=g1;I=undefined;if(P!=H){M=this._setServiceKey(K,this.oModel._getKey(Z));}}else if(P!=H){M=this._setServiceKey(K,this.oModel._getKey(Z));}P=H;}else{this._setServiceKey(K,this.oModel._getKey(Z));}if(!R.bIsLeafGroupsRequest){var i1=this._getKey(G,K.iIndex-1);e=this._getGroupIdFromContext(this.oModel.getContext('/'+i1),E);this.mEntityKey[e]=i1;}}var j1=[];if(this.bReloadSingleUnitMeasures&&O.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([w._requestType.reloadMeasuresQuery,O]);Promise.resolve().then(w.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<O.length;q++){var k1=O[q];this._executeQueryRequest(k1);}}for(var p=0;p<O.length;p++){var l1=O[p];j1.push(l1.sRequestId);}this._considerRequestGrouping(j1);}if(W&&W.length>0){for(var r=0,m1=W.length;r<m1;r++){delete D.results[r-m1];}}if(U){J+=this._mergeLoadedKeyIndexWithSubsequentIndexes(K,n,s,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var n1=false;if(D.__count){this.mServiceLength[G]=parseInt(D.__count,10);this.mLength[G]=this.mServiceLength[G]-J;this.mFinalLength[G]=true;if(R.bIsFlatListRequest){this.iTotalSize=D.__count;}n1=true;}if(this.mServiceLength[G]<z+V){this.mServiceLength[G]=z+V;this.mLength[G]=y+V-J;this.mFinalLength[G]=false;}if(V<L||L===undefined){this.mServiceLength[G]=z+V;this.mLength[G]=y+K.iIndex-y;this.mFinalLength[G]=true;n1=true;}if(V==0){this.mLength[G]=this.mServiceLength[G]=0;this.mFinalLength[G]=true;n1=true;}if(!n1&&this.mLength[G]!==undefined&&J>0){this.mLength[G]-=J;}}this.bNeedsUpdate=true;if(J>0){if(D.results.length-J>0){this.aMultiUnitLoadFactor[n.length]=D.results.length/(D.results.length-J);}if(this.aMultiUnitLoadFactor[n.length]<1.5){this.aMultiUnitLoadFactor[n.length]=2;}}Q.sap.log.info("MultiUnit Situation in Group ("+G+"), discarded: "+J+", load-factor is now: "+this.aMultiUnitLoadFactor[n.length]);};w.prototype._processTotalSizeQueryResponse=function(r,D){if(D.__count==undefined){Q.sap.log.fatal("missing entity count in query result");return;}this.iTotalSize=D.__count;};w.prototype._processLevelMembersQueryResponse=function(r,D){var e=this;var p,P;var g=function(h,I){var G={iRequestType:w._requestType.groupMembersQuery,sRequestId:e._getRequestId(w._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=G.sGroupId||e._getKeys(G.sGroupId)===undefined)){var s=e._getParentGroupId(G.sGroupId);var j=e._findKeyIndex(s,e.mEntityKey[G.sGroupId]);if(j==-1){Q.sap.log.fatal("assertion failed: failed to determine position of "+G.sGroupId+" in group "+s);}if(j>0&&e._getKey(s,j-1)!==undefined){var k=e._getKey(s,j-1);var l=e._getGroupIdFromContext(e.oModel.getContext('/'+k),e._getGroupIdLevel(G.sGroupId));e.mFinalLength[l]=true;G.iStartIndex=0;}}if(I){G.iLength=P.length;}G.oKeyIndexMapping=e._getKeyIndexMapping(G.sGroupId,G.iStartIndex);var m=Q.extend(true,{},D);m.results=P;e._processGroupMembersQueryResponse(G,m);};if(D.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(D.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<D.results.length;i++){var E=D.results[i];var o=this.oModel.getContext("/"+this.oModel._getKey(D.results[i]));var s=this._getGroupIdFromContext(o,r.iLevel-1);if(p==s){P.push(E);if(i<D.results.length-1){continue;}}g(h,D.results.length==r.iLength&&i==D.results.length-1);h=false;if(p!=s){P=[E];}p=s;}if(D.results.length>1&&P.length==1){g(h,D.results.length==r.iLength);}};w.prototype._processReloadMeasurePropertiesQueryResponse=function(r,D){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(D.results.length!=1){Q.sap.log.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=D.results[0];var o=this.oModel.getObject("/"+M);if(!o){Q.sap.log.fatal("assertion failed: no entity found with key "+M);return;}var e=m.aReloadMeasurePropertyName;for(var i=0;i<e.length;i++){o[e[i]]=R[e[i]];}};w.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,i,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};w.prototype._calculateRequiredGroupSection=function(g,s,l,e,h){var k,m,p,P,r,o={},K=this._getKeys(g),n;m=s;k=0;if(!K){P=s;p=s+l;}else{for(var i=s-1;i>=Math.max(s-e,0);i--){n=K(i);if(!n){P=i+1;break;}}for(var j=s+l;j<s+l+e;j++){n=K(j);if(!n){p=j;break;}}}r=s-P;if(P&&s>e&&r<e){if(h.length!==l){m=s-e;}else{m=P-e;}k=e;}m=Math.max(m,0);if(m===s){m+=h.length;}if(h.length!==l){k+=l-h.length;}r=p-s-l;if(r==0){k+=e;}if(p&&r<e&&r>0){if(m>s){m=p;k+=e;}}if(this.mFinalLength[g]&&this.mLength[g]<(k+m)){k=this.mLength[g]-m;}o.startIndex=m;o.length=k;return o;};w.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var L=h._getGroupIdLevel(g);if(L==e){var y=h._getLoadedContextsForGroup(g,s,l);var z=s+y.length-1;if(y.length>=l){return n;}else if(h.mFinalLength[g]){if(y.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-y.length};}else{return{groupId_Missing:g,startIndex_Missing:z+1,length_Missing:l-y.length};}}else{return{groupId_Missing:g,startIndex_Missing:z+1,length_Missing:l-y.length};}}var D=h._getLoadedContextsForGroup(g,s,l);var k=l,E=s+D.length-1;for(var i=-1,H;(H=D[++i])!==undefined;){k--;var G=j(h._getGroupIdFromContext(H,L+1),e,0,k);if(G.groupId_Missing==null){if(G.length_Missing==0){return G;}else{k=G.length_Missing;}}else{return G;}if(k==0){break;}}if(h.mFinalLength[g]||k==0){return{groupId_Missing:null,length_Missing:k};}else{return{groupId_Missing:g,startIndex_Missing:E+1,length_Missing:k};}};var L=this._getGroupIdLevel(g);if(L==e+1){g=this._getParentGroupId(g);--L;}if(g==null||L>e){return n;}var k=l,m=s;while(g!=null){var G=j(g,e,m,k);if(G.groupId_Missing!=null){return G;}else if(G.length_Missing==0){return G;}else{var o=false;while(!o){var p=this._getParentGroupId(g);if(p==null){g=p;--L;break;}var q=this.mEntityKey[g];if(!q){return n;}var r=this._findKeyIndex(p,q);if(r==-1){return n;}if(r==this._getKeyCount(p)-1){if(this.mFinalLength[p]){g=p;--L;continue;}else{return{groupId_Missing:p,startIndex_Missing:r+1,length_Missing:k};}}else{q=this._getKey(p,r+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+q),L);o=true;}}m=0;k=G.length_Missing;}}return{groupId_Missing:null,length_Missing:k};};w.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};w.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};w.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending;}}return null;};w.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,W){var s;switch(this._getEffectiveSortOrder(p)){case d.SortOrder.Ascending:if(W){s=a.GE;}else{s=a.GT;}break;case d.SortOrder.Descending:if(W){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};w.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};w.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var D=null;if(l>this.aAggregationLevel.length){Q.sap.log.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){D=o.getProperty(this.aAggregationLevel[i]);if(D!=null){g+=encodeURIComponent(D)+"/";}else{g+="@/";}}return g;};w.prototype._getGroupIdLevel=function(g){if(g==null){Q.sap.log.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};w.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var G=g.split("/");var D=[];for(var i=1;i<G.length-1;i++){if(G[i]=="@"){D[i-1]=null;}else{D[i-1]=decodeURIComponent(G[i]);}}return D;};w.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){Q.sap.log.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var G=g.split("/");var e=[],s="";var h=0,k=G.length-3;if(n>0){if(n-1>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=n-1;}}else if(-(n+1)>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{h=k+1+n;for(var i=0;i<h;i++){s+=G[i]+"/";}}for(var j=h;j<=k;j++){s+=G[j]+"/";e.push(s);}return e;};w.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};w.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var U=[];for(var s in o){U.push(s);}return U;};w.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};w.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){Q.sap.log.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};w.prototype._deregisterHandleOfCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequestHandle)){Q.sap.log.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){Q.sap.log.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};w.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};w.prototype._getRequestId=function(r,p){switch(r){case w._requestType.groupMembersQuery:if(p.groupId===undefined){Q.sap.log.fatal("missing group ID");}return w._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case w._requestType.levelMembersQuery:if(p.level===undefined){Q.sap.log.fatal("missing level");}if(p.groupId===undefined){Q.sap.log.fatal("missing groupId");}return""+w._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case w._requestType.totalSizeQuery:return w._requestType.totalSizeQuery;case w._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){Q.sap.log.fatal("missing multi unit entry key");}return w._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:Q.sap.log.fatal("invalid request type "+r);return-1;}};w.prototype._registerNewRequest=function(r){if(r==undefined||r==""){Q.sap.log.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};w.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};w.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};w.prototype._deregisterCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequests)){Q.sap.log.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){Q.sap.log.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};w.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};w.prototype._getKeyIndexMapping=function(g,s){var k=this.mKeyIndex[g];var e=this.mServiceKey[g];var i=s;if(k!==undefined){var l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}var L;if(l==0){L=0;}else{if(k[l]>=0){L=k[l];}else if(k[l+1]===undefined){L=k[l]=="ZERO"?0:-k[l];while(e[L+1]!==undefined){++L;}}else{L=Math.abs(k[l+1])-1;}if(e[L]===undefined){Q.sap.log.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+L);}}var D=s-l;i=L+D;}var K={sGroupId:g,iIndex:s,iServiceKeyIndex:i};return K;};w.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};w.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};w.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};w.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],e=k[I];if(e===undefined){return undefined;}if(e>=0){return[s[e]];}var G=[];if(k[I+1]===undefined){e=k[I]=="ZERO"?0:-k[I];while(s[e]!==undefined){G.push(s[e++]);}}else{e=k[I]=="ZERO"?0:-k[I];for(var i=e,n=Math.abs(k[I+1]);i<n;i++){G.push(s[i]);}}return G;};w.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};w.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};w.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};w.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};w.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,I){var K=this.mKeyIndex[k.sGroupId],g=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],D=0,n=k.iServiceKeyIndex,h=k.iIndex;var M,o;if(K===undefined){return D;}var N=false;var p=g[n-1],j=g[n];if(j===undefined){return D;}if(p===undefined){Q.sap.log.fatal("assertion failed: missing expected entry before given key index");return D;}var P=this.oModel.getObject("/"+p);var l=this.oModel.getObject("/"+j);var q="",r="";for(var i=0;i<e.length;i++){q+=P[e[i]]+"|";r+=l[e[i]]+"|";}N=q==r;var y=h;if(y>=this.mLength[k.sGroupId]){Q.sap.log.fatal("assertion failed: service key exists,but no corresponding key index found");return D;}while(K[y]===undefined||Math.abs(K[y])<n){++y;}if(N){if(Math.abs(K[y])==n&&K[y]<0){if(y>h){if(K[h-1]<0){m[y]=undefined;K.splice(h,y-h+1);m.splice(h,y-h+1);}else{K[h-1]=-K[h-1];m[h-1]=m[y];m[y]=undefined;K.splice(h,y-h+1);m.splice(h,y-h+1);D=1;}}}else if(Math.abs(K[y])>n){var z=y-1;if(K[z]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[z]=-K[z];m[z]=o;if(z>h){K.splice(h,z-h);m.splice(h,z-h);}if(M.bIsNewEntry){D=1;}else{D=0;}}else if(K[h-1]<0){if(y>h){m[z]=undefined;K.splice(h,z-h+1);m.splice(h,z-h+1);}}else{K[h-1]=-K[h-1];m[h-1]=m[z];m[z]=undefined;K.splice(h,z-h+1);m.splice(h,z-h+1);}}else if(K[y]==n){if(y>h){if(K[h-1]<0){K.splice(h,y-h+1);m.splice(h,y-h+1);D=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){Q.sap.log.fatal("assertion failed: multi-unit entry already existed before");}K[h-1]=-K[h-1];m[h-1]=o;K.splice(h,y-h+1);m.splice(h,y-h+1);D=1;}}}else{Q.sap.log.fatal("assertion failed: uncovered case detected");return D;}}else if(K[y]>n){Q.sap.log.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(y-h>0){K.splice(h,y-h);m.splice(h,y-h);}return D;};w.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,D,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(D){if(!o.unitPropertyName||Q.inArray(o.unitPropertyName,D)==-1){R.push(o.rawValuePropertyName);}}}for(var k=0;k<s.length;k++){if(Q.inArray(s[k],D)!=-1){m[s[k]]="*";}}var e="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var h=m[this.aAllDimensionSortedByName[l]];var j=h===""?'""':h;j=j===undefined?"":j;e+=(j+",");}e+="-multiple-units-not-dereferencable";var n;if(this.mMultiUnitKey[g]&&(n=Q.inArray(e,this.mMultiUnitKey[g]))!=-1){return{oEntry:this.oModel.getObject("/"+e),bIsNewEntry:false,iIndex:n,aReloadMeasurePropertyName:R};}m.__metadata.uri=e;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var p=this.oModel._getKey(m);this.oModel.getContext('/'+p)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};w.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};w.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};w.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};w.prototype.refresh=function(e){w.prototype._refresh.apply(this,arguments);};w.prototype._refresh=function(e,m,E){var g=false;if(!e){if(E){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in E)){g=true;}}if(m&&!g){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}if(!m&&!E){g=true;}}if(e||g){this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};w.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};w.prototype.getDownloadUrl=function(s){var e,p,z;var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var g=[];var h=[];for(var D in this.oDimensionDetailsSet){g.push(D);}o.setAggregationLevel(g);for(var n in this.oDimensionDetailsSet){var q=this.oDimensionDetailsSet[n];var I=(q.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(q.name,true,I,q.aAttributeName);}for(var M in this.oMeasureDetailsSet){h.push(M);}o.setMeasures(h);for(var r in this.oMeasureDetailsSet){var y=this.oMeasureDetailsSet[r];var E=(y.rawValuePropertyName!=undefined);var G=(y.formattedValuePropertyName!=undefined);var H=(y.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(y.name,E,G,H);}var J=o.getSortExpression();J.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){J.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}var K=o.getFilterExpression();K.clear();if(this.aApplicationFilter){K.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){K.addUI5FilterConditions(this.aControlFilter);}var P=o.getURIToQueryResultEntitySet();var L=this._getQueryODataRequestOptions(o,true);if(!L){return undefined;}var N=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var O=this.aAnalyticalInfo[k];if((O.visible||O.inResult)&&O.name!==""&&O.name!==N[N.length-1]){N.push(O.name);if(this.oMeasureDetailsSet[O.name]!=undefined&&this.oMeasureDetailsSet[O.name].unitPropertyName!=undefined){N.push(this.oMeasureDetailsSet[O.name].unitPropertyName);}}}for(var j=0,l=L.length;j<l;j++){if(/^\$select/i.test(L[j])){if(this.mParameters.select){e=L[j].slice(8).split(",");for(z=0;z<e.length;z++){p=e[z];if(N.indexOf(p)===-1){N.push(p);}}}L[j]="$select="+N.join(",");break;}}if(s){L.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){L.push(this.sCustomParams);}if(P){return this.oModel._createRequestUrl(P,null,L);}};return w;});
