/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding","sap/ui/model/ClientPropertyBinding","sap/ui/model/ContextBinding","sap/ui/model/Context","sap/ui/model/MetaModel","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Int64","sap/ui/thirdparty/URI","./lib/_Helper","./lib/_SyncPromise","./ValueListType"],function(q,B,C,a,b,c,d,M,O,I,U,_,f,V){"use strict";var g,D=q.sap.log.Level.DEBUG,h,j,s="sap.ui.model.odata.v4.ODataMetaModel",k,r=/\([^/]*|\/-?\d+/g,l=/^-?\d+$/,S={messageChange:true},u={"Edm.Boolean":{type:"sap.ui.model.odata.type.Boolean"},"Edm.Byte":{type:"sap.ui.model.odata.type.Byte"},"Edm.Date":{type:"sap.ui.model.odata.type.Date"},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.DateTimeOffset"},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive","$Precision":"precision","$Scale":"scale"},type:"sap.ui.model.odata.type.Decimal"},"Edm.Double":{type:"sap.ui.model.odata.type.Double"},"Edm.Guid":{type:"sap.ui.model.odata.type.Guid"},"Edm.Int16":{type:"sap.ui.model.odata.type.Int16"},"Edm.Int32":{type:"sap.ui.model.odata.type.Int32"},"Edm.Int64":{type:"sap.ui.model.odata.type.Int64"},"Edm.SByte":{type:"sap.ui.model.odata.type.SByte"},"Edm.Single":{type:"sap.ui.model.odata.type.Single"},"Edm.Stream":{type:"sap.ui.model.odata.type.Stream"},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},type:"sap.ui.model.odata.type.String"},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.TimeOfDay"}},v="@com.sap.vocabularies.Common.v1.ValueListMapping",m={},p="@com.sap.vocabularies.Common.v1.ValueListReferences",t="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",W=q.sap.log.Level.WARNING;function w(e,i){q.sap.log.error(e,i,s);throw new Error(i+": "+e);}function x(o,e,i,L){var P,n;function F(R){var G,K;if(!(i in R)){L(W,n," does not contain ",i);return;}L(D,"Including ",i," from ",n);for(K in R){if(K[0]!=="$"&&A(K)===i){G=R[K];e[K]=G;z(G,e.$Annotations);}}}if(i in e){return e[i];}n=o.mSchema2MetadataUrl[i];if(n){L(D,"Namespace ",i," found in $Include of ",n);P=o.mMetadataUrl2Promise[n];if(!P){L(D,"Reading ",n);P=o.mMetadataUrl2Promise[n]=f.resolve(o.oRequestor.read(n)).then(o.validate.bind(o,n));}P=P.then(F);if(i in e){return e[i];}e[i]=P;return P;}}function y(T,e){if(T===e){return"";}if(T.indexOf(e)===0&&T[e.length]==="#"&&T.indexOf("@",e.length)<0){return T.slice(e.length+1);}}function z(o,e){var T;for(T in o.$Annotations){if(T in e){q.extend(e[T],o.$Annotations[T]);}else{e[T]=o.$Annotations[T];}}delete o.$Annotations;}function A(Q){return Q.slice(0,Q.lastIndexOf(".")+1);}h=c.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(o,P,e){c.call(this,o,P,e);},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange();}},setContext:function(o){if(o!==this.oContext){this.oContext=o;if(!this.bInitial){this.initialize();}}}});j=a.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{constructor:function(){a.apply(this,arguments);},_fireFilter:function(){},_fireSort:function(){},checkUpdate:function(F){var P=this.oList.length;this.update();if(F||this.oList.length!==P){this._fireChange({reason:C.Change});}},fetchContexts:function(){var i,R=this.oModel.resolve(this.sPath,this.oContext),e=this;if(!R){return f.resolve([]);}i=R.slice(-1)==="@";if(!i&&R!=="/"){R+="/";}return this.oModel.fetchObject(R).then(function(o){if(!o){return[];}if(i){R=R.slice(0,-1);}return Object.keys(o).filter(function(K){return K[0]!=="$"&&i!==(K[0]!=="@");}).map(function(K){return new d(e.oModel,R+K);});});},getContexts:function(i,L){this.iCurrentStart=i||0;this.iCurrentLength=Math.min(L||Infinity,this.iLength,this.oModel.iSizeLimit);return this.getCurrentContexts();},getCurrentContexts:function(){var e=[],i,n=this.iCurrentStart+this.iCurrentLength;for(i=this.iCurrentStart;i<n;i++){e.push(this.oList[this.aIndices[i]]);}return e;},setContexts:function(e){this.oList=e;this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();},update:function(){var e=[],P=this.fetchContexts(),i=this;if(P.isFulfilled()){e=P.getResult();}else{P.then(function(e){i.setContexts(e);i._fireChange({reason:C.Change});});}this.setContexts(e);}});k=b.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){b.apply(this,arguments);},_getValue:function(){var P,e=this;P=this.oModel.fetchObject(this.sPath,this.oContext,this.mParameters);if(P.isFulfilled()){return P.getResult();}P.then(function(){e.checkUpdate();});return undefined;},checkUpdate:function(F){var e=this._getValue();if(F||e!==this.oValue){this.oValue=e;this._fireChange({reason:C.Change});}},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var E=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(R,e,i,o,n){M.call(this);this.aAnnotationUris=i&&!Array.isArray(i)?[i]:i;this.sDefaultBindingMode=B.OneTime;this.mETags={};this.dLastModified=new Date(0);this.oMetadataPromise=null;this.oModel=o;this.mMetadataUrl2Promise={};this.oRequestor=R;this.mSchema2MetadataUrl={};this.mSupportedBindingModes={"OneTime":true,"OneWay":true};this.bSupportReferences=n!==false;this.sUrl=e;}});E.prototype._mergeAnnotations=function(e,n){var o=this;this.validate(this.sUrl,e);e.$Annotations={};Object.keys(e).forEach(function(i){if(e[i].$kind==="Schema"){o.mSchema2MetadataUrl[i]=o.sUrl;z(e[i],e.$Annotations);}});n.forEach(function(F,i){var G,Q;o.validate(o.aAnnotationUris[i],F);for(Q in F){if(Q[0]!=="$"){if(Q in e){w("A schema cannot span more than one document: "+Q,o.aAnnotationUris[i]);}G=F[Q];e[Q]=G;if(G.$kind==="Schema"){o.mSchema2MetadataUrl[Q]=o.aAnnotationUris[i];z(G,e.$Annotations);}}}});};E.prototype.attachEvent=function(e){if(!(e in S)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};E.prototype.bindContext=function(P,o){return new h(this,P,o);};E.prototype.bindList=function(P,o,e,F){return new j(this,P,o,e,F);};E.prototype.bindProperty=function(P,o,e){return new k(this,P,o,e);};E.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};E.prototype.fetchCanonicalPath=function(o){return this.fetchUpdateData("",o).then(function(R){if(R.propertyPath){throw new Error("Context "+o.getPath()+" does not point to an entity. It should be "+R.entityPath);}return"/"+R.editUrl;});};E.prototype.fetchEntityContainer=function(){var P,e=this;if(!this.oMetadataPromise){P=[f.resolve(this.oRequestor.read(this.sUrl))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(i){P.push(f.resolve(e.oRequestor.read(i,true)));});}this.oMetadataPromise=f.all(P).then(function(i){var n=i[0];e._mergeAnnotations(n,i.slice(1));return n;});}return this.oMetadataPromise;};E.prototype.fetchModule=function(e){var i;e=e.replace(/\./g,"/");i=sap.ui.require(e);if(i){return f.resolve(i);}return f.resolve(new Promise(function(n,o){sap.ui.require([e],n);}));};E.prototype.fetchObject=function(P,n,F){var R=this.resolve(P,n),G=this;if(!R){q.sap.log.error("Invalid relative path w/o context",P,s);return f.resolve(null);}return this.fetchEntityContainer().then(function(H){var L,N,J=true,K,Q,T,X=H;function Y(i,P){var o,d1=i.indexOf("@",2);if(d1>-1){return $(W,"Unsupported path after ",i.slice(0,d1));}i=i.slice(2);o=i[0]==="."?q.sap.getObject(i.slice(1),undefined,F.scope):q.sap.getObject(i);if(typeof o!=="function"){return $(W,i," is not a function but: "+o);}try{X=o(X,{context:new d(G,P),schemaChildName:Q});}catch(e){$(W,"Error calling ",i,": ",e);}return false;}function Z(o){return o&&typeof o.then==="function";}function $(i){var e;if(q.sap.log.isLoggable(i,s)){e=Array.isArray(L)?L.join("/"):L;q.sap.log[i===D?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(e?" at /"+e:""),R,s);}if(i===W){X=undefined;}return false;}function a1(e,i){var o;function d1(){L=L||T&&i&&T+"/"+i;return $.apply(this,arguments);}if(G.bSupportReferences&&!(e in H)){o=A(e);X=x(G,H,o,d1);}if(e in H){T=N=Q=e;X=K=H[Q];if(!Z(X)){return true;}}if(Z(X)&&X.isPending()){return d1(D,"Waiting for ",o);}return d1(W,"Unknown qualified name ",e);}function b1(e,i,o){var d1,e1;if(e==="$Annotations"){return $(W,"Invalid segment: $Annotations");}if(X!==H&&typeof X==="object"&&e in X){if(e[0]==="$"||l.test(e)){J=false;}}else{d1=e.indexOf("@@");if(d1<0){if(e.length>11&&e.slice(-11)==="@sapui.name"){d1=e.length-11;}else{d1=e.indexOf("@");}}if(d1>0){if(!b1(e.slice(0,d1),i,o)){return false;}e=e.slice(d1);e1=true;}if(typeof X==="string"&&!(e1&&e[0]==="@"&&(e==="@sapui.name"||e[1]==="@"))&&!c1(X,o.slice(0,i))){return false;}if(J){if(e[0]==="$"||l.test(e)){J=false;}else if(!e1){if(e[0]!=="@"&&e.indexOf(".")>0){return a1(e);}else if(X&&"$Type"in X){if(!a1(X.$Type,"$Type")){return false;}}else if(X&&"$Action"in X){if(!a1(X.$Action,"$Action")){return false;}}else if(X&&"$Function"in X){if(!a1(X.$Function,"$Function")){return false;}}else if(i===0){T=N=Q=Q||H.$EntityContainer;X=K=K||H[Q];if(e&&e[0]!=="@"&&!(e in K)){return $(W,"Unknown child ",e," of ",Q);}}if(Array.isArray(X)){if(X.length!==1){return $(W,"Unsupported overloads");}X=X[0].$ReturnType;T=T+"/0/$ReturnType";if(X){if(e==="value"&&!(H[X.$Type]&&H[X.$Type].value)){N=undefined;return true;}if(!a1(X.$Type,"$Type")){return false;}}}}}if(!e){return i+1>=o.length||$(W,"Invalid empty segment");}if(e[0]==="@"){if(e==="@sapui.name"){X=N;if(X===undefined){$(W,"Unsupported path before @sapui.name");}else if(i+1<o.length){$(W,"Unsupported path after @sapui.name");}return false;}if(e[1]==="@"){if(i+1<o.length){return $(W,"Unsupported path after ",e);}return Y(e,"/"+o.slice(0,i).join("/")+"/"+o[i].slice(0,d1));}}if(!X||typeof X!=="object"){X=undefined;return $(D,"Invalid segment: ",e);}if(J&&e[0]==="@"){X=(H.$Annotations||{})[T]||{};J=false;}}if(e!=="@"){N=J||e[0]==="@"?e:undefined;T=J?T+"/"+e:undefined;X=X[e];}return true;}function c1(e,i){var o;if(L){return $(W,"Invalid recursion");}L=i;J=true;X=H;o=e.split("/").every(b1);L=undefined;return o;}c1(R.slice(1));if(Z(X)){X=X.then(function(){return G.fetchObject(P,n,F);});}return X;});};E.prototype.fetchUI5Type=function(P){var o=this.getMetaContext(P),e=this;if(q.sap.endsWith(P,"/$count")){g=g||new I();return f.resolve(g);}return this.fetchObject(undefined,o).then(function(i){var n,N,T=i["$ui5.type"],F,G="sap.ui.model.odata.type.Raw";function H(K,J){if(J!==undefined){n=n||{};n[K]=J;}}if(T){return T;}if(i.$isCollection){q.sap.log.warning("Unsupported collection type, using "+G,P,s);}else{F=u[i.$Type];if(F){G=F.type;for(N in F.constraints){H(F.constraints[N],N[0]==="@"?e.getObject(N,o):i[N]);}if(i.$Nullable===false){H("nullable",false);}}else{q.sap.log.warning("Unsupported type '"+i.$Type+"', using "+G,P,s);}}i["$ui5.type"]=e.fetchModule(G).then(function(J){T=new J(undefined,n);i["$ui5.type"]=T;return T;});return i["$ui5.type"];});};E.prototype.fetchUpdateData=function(P,o){var R=this.resolve(P,o),e=this;function n(i){q.sap.log.error(i,R,s);throw new Error(R+": "+i);}return this.fetchObject(this.getMetaPath(R)).then(function(){return e.fetchEntityContainer();}).then(function(F){var G,H=F[F.$EntityContainer],J,K,L,N,Q,T,X=false,Y;function Z(){G.push({path:N,prefix:G.pop(),type:Y});}function $(b1){var i=b1.indexOf("(");return i>=0?b1.slice(i):"";}function a1(b1){var i=b1.indexOf("(");return i>=0?b1.slice(0,i):b1;}T=R.slice(1).split("/");G=[T.shift()];N="/"+G[0];J=N;L=decodeURIComponent(a1(G[0]));K=H[L];if(!K){n("Not an entity set: "+L);}Y=F[K.$Type];P="";Q="";T.forEach(function(i){var b1,c1;N+="/"+i;if(l.test(i)){Z();J+="/"+i;}else{c1=decodeURIComponent(a1(i));Q=_.buildPath(Q,c1);b1=Y[c1];if(!b1){n("Not a (navigation) property: "+c1);}Y=F[b1.$Type];if(b1.$kind==="NavigationProperty"){if(Q in K.$NavigationPropertyBinding){L=K.$NavigationPropertyBinding[Q];K=H[L];Q="";G=[encodeURIComponent(L)+$(i)];if(!b1.$isCollection){Z();}}else{G.push(i);}J=N;P="";}else{P=_.buildPath(P,i);}}});return f.all(G.map(function(i){if(typeof i==="string"){return i;}return o.fetchValue(i.path).then(function(b1){if(!b1){n("No instance to calculate key predicate at "+i.path);}if("@$ui5.transient"in b1){X=true;return undefined;}if(!b1["@$ui5.predicate"]){n("No key predicate known at "+i.path);}return i.prefix+b1["@$ui5.predicate"];},function(b1){n(b1.message+" at "+i.path);});})).then(function(i){return{editUrl:X?undefined:i.join("/"),entityPath:J,propertyPath:P};});});};E.prototype.fetchValueListMappings=function(o,n,P){var e=this,i=o.getMetaModel();return i.fetchEntityContainer().then(function(F){var G,H=F.$Annotations,J={},K=e===i,T;T=Object.keys(H).filter(function(L){if(_.namespace(L)===n){if(e.getObject("/"+L)===P){return true;}if(!K){throw new Error("Unexpected annotation target '"+L+"' with namespace of data service in "+o.sServiceUrl);}}return false;});if(!T.length){throw new Error("No annotation '"+v.slice(1)+"' in "+o.sServiceUrl);}G=H[T[0]];Object.keys(G).forEach(function(L){var Q=y(L,v);if(Q!==undefined){J[Q]=G[L];}else if(!K){throw new Error("Unexpected annotation '"+L.slice(1)+"' for target '"+T[0]+"' with namespace of data service in "+o.sServiceUrl);}});return J;});};E.prototype.fetchValueListType=function(P){var o=this.getMetaContext(P),e=this;return this.fetchObject(undefined,o).then(function(i){var n,T;if(!i){throw new Error("No metadata for "+P);}n=e.getObject("@",o);if(n[t]){return V.Fixed;}for(T in n){if(y(T,p)!==undefined||y(T,v)!==undefined){return V.Standard;}}return V.None;});};E.prototype.getETags=function(){return this.mETags;};E.prototype.getLastModified=function(){return this.dLastModified;};E.prototype.getMetaContext=function(P){return new d(this,this.getMetaPath(P));};E.prototype.getMetaPath=function(P){return P.replace(r,"");};E.prototype.getOrCreateValueListModel=function(e){var i=new U(this.sUrl).absoluteTo(document.baseURI).pathname().toString(),o,n;n=new U(e).absoluteTo(i).filename("").toString();o=m[n];if(!o){o=new this.oModel.constructor({operationMode:O.Server,serviceUrl:n,synchronizationMode:"None"});o.setDefaultBindingMode(B.OneWay);m[n]=o;o.oRequestor.mHeaders["X-CSRF-Token"]=this.oModel.oRequestor.mHeaders["X-CSRF-Token"];}return o;};E.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};E.prototype.getObject=f.createGetMethod("fetchObject");E.prototype.getProperty=E.prototype.getObject;E.prototype.getUI5Type=f.createGetMethod("fetchUI5Type",true);E.prototype.getValueListType=f.createGetMethod("fetchValueListType",true);E.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};E.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};E.prototype.requestObject=f.createRequestMethod("fetchObject");E.prototype.requestUI5Type=f.createRequestMethod("fetchUI5Type");E.prototype.requestValueListType=f.createRequestMethod("fetchValueListType");E.prototype.requestValueListInfo=function(P){var e=this.getMetaPath(P),T=e.slice(0,e.lastIndexOf("/")+1),i=this;return Promise.all([this.requestObject(T+"@sapui.name"),this.requestObject(e),this.requestObject(e+"@"),this.requestObject(e+t)]).then(function(R){var n=R[2],F=R[3],o={},N=_.namespace(R[0]),G=R[1],H={};function J(K,Q,L,X){if(o[Q]){throw new Error("Annotations '"+v.slice(1)+"' with identical qualifier '"+Q+"' for property "+P+" in "+o[Q]+" and "+L);}if(F&&H[""]){throw new Error("Annotation '"+t.slice(1)+"' but multiple '"+v.slice(1)+"' for property "+P);}o[Q]=L;H[F?"":Q]=q.extend(true,{$model:X},K);}if(!G){throw new Error("No metadata for "+P);}Object.keys(n).filter(function(K){return y(K,v)!==undefined;}).forEach(function(K){J(n[K],y(K,v),i.sUrl,i.oModel);});return Promise.all(Object.keys(n).filter(function(K){return y(K,p)!==undefined;}).map(function(K){var L=n[K];return Promise.all(L.map(function(Q){var X=i.getOrCreateValueListModel(Q);return i.fetchValueListMappings(X,N,G).then(function(Y){Object.keys(Y).forEach(function(Z){J(Y[Z],Z,Q,X);});});}));})).then(function(){if(!Object.keys(H).length){throw new Error("No annotation '"+p.slice(1)+"' for "+P);}return H;});});};E.prototype.resolve=function(P,o){var e,i;if(!P){return o?o.getPath():undefined;}i=P[0];if(i==="/"){return P;}if(!o){return undefined;}if(i==="."){if(P[1]!=="/"){throw new Error("Unsupported relative path: "+P);}P=P.slice(2);}e=o.getPath();return i==="@"||e.slice(-1)==="/"?e+P:e+"/"+P;};E.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};E.prototype.toString=function(){return s+": "+this.sUrl;};E.prototype.validate=function(e,n){var i,o,L,F,R,G;if(!this.bSupportReferences){return n;}for(G in n.$Reference){R=n.$Reference[G];G=new U(G).absoluteTo(this.sUrl).toString();if("$IncludeAnnotations"in R){w("Unsupported IncludeAnnotations",e);}for(i in R.$Include){F=R.$Include[i];if(F in n){w("A schema cannot span more than one document: "+F+" - is both included and defined",e);}else if(F in this.mSchema2MetadataUrl&&this.mSchema2MetadataUrl[F]!==G){w("A schema cannot span more than one document: "+F+" - expected reference URI "+this.mSchema2MetadataUrl[F]+" but instead saw "+G,e);}this.mSchema2MetadataUrl[F]=G;}}L=n.$LastModified?new Date(n.$LastModified):null;this.mETags[e]=n.$ETag?n.$ETag:L;o=n.$Date?new Date(n.$Date):new Date();L=L||o;if(this.dLastModified<L){this.dLastModified=L;}delete n.$Date;delete n.$ETag;delete n.$LastModified;return n;};return E;});
