/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/ChangeReason","./ODataBinding","./lib/_Helper","./lib/_SyncPromise"],function(q,C,a,_,b){"use strict";function O(){}a(O.prototype);var c="sap.ui.model.odata.v4.ODataParentBinding";O.prototype.addToSelect=function(Q,s){Q.$select=Q.$select||[];s.forEach(function(p){if(Q.$select.indexOf(p)<0){Q.$select.push(p);}});};O.prototype.changeParameters=function(p){var B=q.extend(true,{},this.mParameters),s,k,t=this;function d(n){if(t.oModel.bAutoExpandSelect&&n in p){throw new Error("Cannot change $expand or $select parameter in "+"auto-$expand/$select mode: "+n+"="+JSON.stringify(p[n]));}}function u(n){if(n==="$filter"||n==="$search"){s=C.Filter;}else if(n==="$orderby"&&s!==C.Filter){s=C.Sort;}else if(!s){s=C.Change;}}if(!p){throw new Error("Missing map of binding parameters");}d("$expand");d("$select");if(this.hasPendingChanges()){throw new Error("Cannot change parameters due to pending changes");}for(k in p){if(k.indexOf("$$")===0){throw new Error("Unsupported parameter: "+k);}if(p[k]===undefined&&B[k]!==undefined){u(k);delete B[k];}else if(B[k]!==p[k]){u(k);if(typeof p[k]==="object"){B[k]=q.extend(true,{},p[k]);}else{B[k]=p[k];}}}if(s){this.applyParameters(B,s);}};O.prototype.checkUpdate=function(){var t=this;function u(){t.oModel.getDependentBindings(t,true).forEach(function(d){d.checkUpdate();});}if(arguments.length>0){throw new Error("Unsupported operation: "+c+"#checkUpdate must not be"+" called with parameters");}this.oCachePromise.then(function(o){if(o&&t.bRelative&&t.oContext.fetchCanonicalPath){t.oContext.fetchCanonicalPath().then(function(s){if(o.$canonicalPath!==s){t.refreshInternal();}else{u();}})["catch"](function(e){t.oModel.reportError("Failed to update "+t,c,e);});}else{u();}});};O.prototype.createInCache=function(u,v,p,i,f){var t=this;return this.oCachePromise.then(function(o){if(o){return o.create(u,v,p,i,f,function(e){t.oModel.reportError("POST on '"+v+"' failed; will be repeated automatically","sap.ui.model.odata.v4.ODataParentBinding",e);});}return t.oContext.getBinding().createInCache(u,v,_.buildPath(t.oContext.iIndex,t.sPath,p),i,f);});};O.prototype.wrapChildQueryOptions=function(B,s,m){var e="",i,M=s.split("/"),p,P=B,Q={},d=Q;if(s===""){return m;}for(i=0;i<M.length;i+=1){P=_.buildPath(P,M[i]);e=_.buildPath(e,M[i]);p=this.oModel.getMetaModel().getObject(P);if(p.$kind==="NavigationProperty"){d.$expand={};d=d.$expand[e]=(i===M.length-1)?m:{};this.selectKeyProperties(d,P);e="";}else if(p.$kind!=="Property"){return undefined;}}if(p.$kind==="Property"){if(Object.keys(m).length>0){q.sap.log.error("Failed to enhance query options for "+"auto-$expand/$select as the child binding has query options, "+"but its path '"+s+"' points to a structural "+"property",JSON.stringify(m),"sap.ui.model.odata.v4.ODataParentBinding");return undefined;}this.addToSelect(d,[e]);}if("$apply"in m){q.sap.log.debug("Cannot wrap $apply into $expand: "+s,JSON.stringify(m),"sap.ui.model.odata.v4.ODataParentBinding");return undefined;}return Q;};O.prototype.deleteFromCache=function(g,e,p,f){var o=this.oCachePromise.getResult();if(this.oOperation){throw new Error("Cannot delete a deferred operation");}if(!this.oCachePromise.isFulfilled()){throw new Error("DELETE request not allowed");}if(o){g=g||this.getUpdateGroupId();if(!this.oModel.isAutoGroup(g)&&!this.oModel.isDirectGroup(g)){throw new Error("Illegal update group ID: "+g);}return o._delete(g,e,p,f);}return this.oContext.getBinding().deleteFromCache(g,e,_.buildPath(this.oContext.iIndex,this.sPath,p),f);};O.prototype.fetchIfChildCanUseCache=function(o,s,d){var B,e,f,g,F,m=this.oModel.getMetaModel(),p,t=this;function h(){return m.fetchObject(F).then(function(P){if(P&&P.$kind==="NavigationProperty"){return m.fetchObject(F+"/").then(function(){return P;});}return P;});}if(this.oOperation||s==="$count"||s.slice(-7)==="/$count"){return b.resolve(true);}if(!o){return b.resolve(false);}e=this.oCachePromise.isRejected()||this.oCachePromise.isFulfilled()&&!this.oCachePromise.getResult()||this.oCachePromise.isFulfilled()&&this.oCachePromise.getResult().bSentReadRequest;B=m.getMetaPath(o.getPath());g=m.getMetaPath("/"+s).slice(1);F=_.buildPath(B,g);p=[this.doFetchQueryOptions(this.oContext),h(),d];f=b.all(p).then(function(r){var i=r[2],w,l=r[0],P=r[1];if(!t.oOperation){t.selectKeyProperties(l,B);}if(Object.keys(t.mAggregatedQueryOptions).length===0){t.mAggregatedQueryOptions=q.extend(true,{},l);}if(g===""||P&&(P.$kind==="Property"||P.$kind==="NavigationProperty")){w=t.wrapChildQueryOptions(B,g,i);if(w){return t.aggregateQueryOptions(w,e);}return false;}q.sap.log.error("Failed to enhance query options for "+"auto-$expand/$select as the path '"+F+"' does not point to a property",JSON.stringify(P),"sap.ui.model.odata.v4.ODataParentBinding");return false;});this.aChildCanUseCachePromises.push(f);this.oCachePromise=b.all([this.oCachePromise,f]).then(function(r){var i=r[0];if(i&&!i.bSentReadRequest){i.setQueryOptions(q.extend(true,{},t.oModel.mUriParameters,t.mAggregatedQueryOptions));}return i;});return f;};O.prototype.getQueryOptionsForPath=function(p,o){var Q;if(Object.keys(this.mParameters).length){Q=this.mQueryOptions;this.oModel.getMetaModel().getMetaPath("/"+p).slice(1).split("/").some(function(s){Q=Q.$expand&&Q.$expand[s];if(!Q||Q===true){Q={};return true;}});return q.extend(true,{},Q);}o=o||this.oContext;if(!this.bRelative||!o.getQueryOptionsForPath){return{};}return o.getQueryOptionsForPath(_.buildPath(this.sPath,p));};O.prototype.getRelativePath=function(p){var r=this.oModel.resolve(this.sPath,this.oContext);if(p.indexOf(r)<0){if(this.bRelative){return undefined;}throw new Error(p+": invalid path, must start with "+this.sPath);}p=p.slice(r.length);if(p[0]==="/"){p=p.slice(1);}return p;};O.prototype.initialize=function(){if(!this.bRelative||this.oContext){this._fireChange({reason:C.Change});}};O.prototype.aggregateQueryOptions=function(Q,d){var A=q.extend(true,{},this.mAggregatedQueryOptions);function m(e,Q,i){var E,s;function f(h){if(e.$expand[h]){return m(e.$expand[h],Q.$expand[h],true);}if(d){return false;}e.$expand[h]=E[h];return true;}function g(S){if(e.$select.indexOf(S)<0){if(d){return false;}e.$select.push(S);}return true;}E=Q&&Q.$expand;if(E){e.$expand=e.$expand||{};if(!Object.keys(E).every(f)){return false;}}s=Q&&Q.$select;if(s){e.$select=e.$select||[];if(!s.every(g)){return false;}}if(Q&&Q.$count){e.$count=true;}return Object.keys(Q).concat(Object.keys(e)).every(function(n){if(n==="$count"||n==="$expand"||n==="$select"||!i&&!(n in Q)){return true;}return Q[n]===e[n];});}if(m(A,Q)){this.mAggregatedQueryOptions=A;return true;}return false;};O.prototype.selectKeyProperties=function(Q,m){var t=this.oModel.getMetaModel().getObject(m+"/");if(t.$Key){this.addToSelect(Q,t.$Key);}};O.prototype.updateAggregatedQueryOptions=function(n){var A=Object.keys(n).concat(Object.keys(this.mAggregatedQueryOptions)),t=this;A.forEach(function(N){if(N==="$select"||N==="$expand"){return;}if(n[N]===undefined){delete t.mAggregatedQueryOptions[N];}else{t.mAggregatedQueryOptions[N]=n[N];}});};O.prototype.updateValue=function(g,p,v,e,E,s,u){var o;if(!this.oCachePromise.isFulfilled()){throw new Error("PATCH request not allowed");}o=this.oCachePromise.getResult();if(o){g=g||this.getUpdateGroupId();return o.update(g,p,v,e,E,this.getRelativePath(s),u);}return this.oContext.getBinding().updateValue(g,p,v,e,E,s,u);};return function(p){q.extend(p,O.prototype);};},false);
