/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library"],function(q,C,I,a,D,B,O,R,b,A,c,d,l,m){"use strict";var e=l.Importance;var f=m.ButtonType;var P=m.PlacementType;var g=l.ObjectPageHeaderDesign;var h=l.ObjectPageHeaderPictureShape;var j=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.uxap.ObjectPageHeaderPictureShape",defaultValue:h.Square},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:g.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designTime:true}});j.prototype._iAvailablePercentageForActions=0.3;j.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this);};j.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};j.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};j.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};j.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};j._internalAggregationFactory={"_objectImage":c.createObjectImage,"_placeholder":c.createPlaceholder,"_overflowActionSheet":function(){return new A({placement:P.Bottom});},"_lockIconCont":function(i){return this._getButton(i,"sap-icon://private","lock-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(i){return new B({links:i.getAggregation("breadCrumbLinks")});},"_lockIcon":function(i){return this._getButton(i,"sap-icon://private","lock",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(i){return this._getButton(i,"sap-icon://arrow-down","titleArrow-cont",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(i){return this._getButton(i,"sap-icon://arrow-down","titleArrow",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(i){return this._getIcon(i,"favorite",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(i){return this._getIcon(i,"flag",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(i){return this._getButton(i,"sap-icon://overflow","overflow",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"));},"_expandButton":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","expand",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(i){return this._getButton(i,"sap-icon://user-edit","changes-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(i){return this._getButton(i,"sap-icon://user-edit","changes",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(i,s,t){return I.createControlByURI({id:this._getParentAugmentedId(i,s),tooltip:t,src:I.getIconURI(s),visible:false});},_getButton:function(i,s,r,t){return new b({id:this._getParentAugmentedId(i,r),tooltip:t,icon:s,type:f.Transparent});},_getParentAugmentedId:function(i,s){return i.getId()+"-"+s;}};j.prototype._lazyLoadInternalAggregation=function(s,S){if(!this.getAggregation(s)){this.setAggregation(s,j._internalAggregationFactory[s](this),S);}return this.getAggregation(s);};j.prototype._applyActionProperty=function(s,i){var r=i[0];if(this.getProperty(s)!==r){i.unshift(s);this.setProperty.apply(this,i);if(!this._bFirstRendering){this._notifyParentOfChanges();}}return this;};j.prototype._applyObjectImageProperty=function(s,i){var r=i[0];if(this.getProperty(s)!==r){i.unshift(s);this.setProperty.apply(this,i);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true);}}return this;};j.prototype._proxyMethodToBreadCrumbControl=function(F,i){var r=this._lazyLoadInternalAggregation("_breadCrumbs"),v=r[F].apply(r,i);this.invalidate();return v;};j.prototype.setHeaderDesign=function(H){this.setProperty("headerDesign",H);if(this.getParent()){this.getParent().invalidate();}return this;};j.prototype.setObjectTitle=function(N){var s=this.getProperty("objectTitle"),i=s!==N;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));if(i&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":s,"newValue":N});}return this;};var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],o=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape"];var G=function(s){var i="set"+s.charAt(0).toUpperCase()+s.slice(1);j.prototype[i]=function(){var r=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,s,r);};};var k=function(s){var i="set"+s.charAt(0).toUpperCase()+s.slice(1);j.prototype[i]=function(){var r=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,s,r);};};var n=function(s,S,t){var i="set"+s.charAt(0).toUpperCase()+s.slice(1);S[i]=function(){var r=Array.prototype.slice.call(arguments);r.unshift(s);t.setProperty.apply(t,r);return this.setProperty.apply(this,r);};};p.forEach(G);o.forEach(k);j.prototype.getBreadCrumbsLinks=function(){return this._lazyLoadInternalAggregation("_breadCrumbs").getLinks();};j.prototype.addBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("addLink",arguments);};j.prototype.indexOfBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("indexOfLink",arguments);};j.prototype.insertBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("insertLink",arguments);};j.prototype.removeBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("removeLink",arguments);};j.prototype.removeAllBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("removeAllLinks",arguments);};j.prototype.destroyBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("destroyLinks",arguments);};j.prototype._destroyObjectImage=function(){var s="_objectImage",i=this.getAggregation(s);if(i){i.destroy();this.setAggregation(s,null);}};j.prototype.onBeforeRendering=function(){var s=this.getSideContentButton();if(s&&!s.getTooltip()){s.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var i=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._oActionSheetButtonMap={};if(i.length>1||this._hasOneButtonShowText(i)){i.forEach(function(r){if(r instanceof b&&!(r instanceof O)){r._bInternalVisible=r.getVisible();r._getInternalVisible=function(){return this._bInternalVisible;};r._setInternalVisible=function(v,u){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(u){this.invalidate();}}};r.setVisible=function(v){r._setInternalVisible(v,true);b.prototype.setVisible.call(this,v);r.getParent()._adaptOverflow();};r.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};}if(r instanceof b&&(r.getType()==="Default"||r.getType()==="Unstyled")){r.setProperty("type",f.Transparent,false);}if(r instanceof b&&r.getVisible()){var t=this._createActionSheetButton(r);this._oActionSheetButtonMap[r.getId()]=t;this._oOverflowActionSheet.addButton(t);n("text",r,t);n("icon",r,t);n("enabled",r,t);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);this._bFirstRendering=false;};j.prototype._createActionSheetButton=function(i){return new b({press:q.proxy(this._onSeeMoreContentSelect,this),enabled:i.getEnabled(),text:i.getText(),icon:i.getIcon(),tooltip:i.getTooltip(),customData:new a({key:"originalId",value:i.getId()})});};j.prototype._handleImageNotFoundError=function(){var i=this._lazyLoadInternalAggregation("_objectImage"),r=this.getParent(),$=r?r.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{i.addStyleClass("sapMNoImg");}};j.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error");};j.prototype.onAfterRendering=function(){var $=this._lazyLoadInternalAggregation("_objectImage").$();this._adaptLayout();this._clearImageNotFoundHandler();$.error(this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._attachDetachActionButtonsHandler(true);};j.prototype._onHeaderResize=function(){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._adjustHeaderHeights==="function"){this.getParent()._adjustHeaderHeights();}};j.prototype._attachDetachActionButtonsHandler=function(i){var r=this.getActions()||[];if(r.length<1){return;}r.forEach(function(s){if(s instanceof b){var t=this._oActionSheetButtonMap[s.getId()];if(i){s.attachEvent("_change",this._adaptLayout,this);if(t){t.attachEvent("_change",this._adaptOverflow,this);}}else{s.detachEvent("_change",this._adaptLayout,this);if(t){t.detachEvent("_change",this._adaptOverflow,this);}}}},this);};j.prototype._onSeeMoreContentSelect=function(E){var i=E.getSource(),r=sap.ui.getCore().byId(i.data("originalId"));if(r.firePress){r.firePress({overflowButtonId:this._oOverflowButton.getId()});}this._oOverflowActionSheet.close();};j._actionImportanceMap={"Low":3,"Medium":2,"High":1};j._sortActionsByImportance=function(i,r){var s=(i instanceof O)?i.getImportance():e.High,t=(r instanceof O)?r.getImportance():e.High,u=j._actionImportanceMap[s]-j._actionImportanceMap[t];if(u===0){return i.position-r.position;}return u;};j.prototype._hasOneButtonShowText=function(i){var r=false;if(i.length!==1){return r;}if(i[0]instanceof O){r=(!i[0].getHideText()&&i[0].getText()!="");}else if(i[0]instanceof b){r=(i[0].getText()!="");}return r;};j.prototype._adaptLayout=function(E){this._adaptLayoutForDomElement(null,E);};j.prototype._adaptLayoutForDomElement=function($,E){var i=this._findById($,"identifierLine"),r=i.width(),s=this._getActionsWidth(),t=s/r,u=this._iAvailablePercentageForActions*r,v=this._oOverflowButton.$(),w=this._findById($,"actions"),x=w.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(t>this._iAvailablePercentageForActions){this._adaptActions(u);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(D.system.phone){x.css("visibility","visible");}if(x.filter(":visible").length===x.length){v.hide();}this._adaptObjectPageHeaderIndentifierLine($);};j.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){q.sap.clearDelayedCall(this._adaptLayoutTimeout);}this._adaptLayoutTimeout=q.sap.delayedCall(0,this,function(){this._adaptLayoutTimeout=null;this._adaptLayout();});};j.prototype._adaptObjectPageHeaderIndentifierLine=function($){var i=this._findById($,"identifierLine"),r=i.width(),s=this._findById($,"subtitle"),t=this._findById($,"innerTitle"),u=this._findById($,"identifierLineContainer"),S,T,v=this._findById($,"actions"),w=$?$.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),x=v.width()+w.width(),y=this.$().parents().hasClass('sapUiSizeCompact')?7:3;if(s.length){if(s.hasClass("sapOPHSubtitleBlock")){s.removeClass("sapOPHSubtitleBlock");}S=s.outerHeight()+s.position().top;T=t.outerHeight()+t.position().top;if(Math.abs(S-T)>y){s.addClass("sapOPHSubtitleBlock");}}u.width((0.95-(x/r))*100+"%");};j.prototype._adaptActions=function(r){var M=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||D.system.phone,s=this._oOverflowButton.$().css("display"),v=this._oOverflowButton.$().show().width(),t=this.getActions(),u=t.length,w;this._oOverflowButton.$().css("display",s);for(var i=0;i<u;i++){t[i].position=i;}t.sort(j._sortActionsByImportance);t.forEach(function(x){w=this._oActionSheetButtonMap[x.getId()];if(w){v+=x.$().width();if(r>v&&!M){this._setActionButtonVisibility(x,true);}else{this._setActionButtonVisibility(x,false);}}},this);};j.prototype._adaptOverflow=function(){var i=this._oOverflowActionSheet.getButtons();var H=i.some(function(r){return r.getVisible();});this._oOverflowButton.$().toggle(H);};j.prototype._setActionButtonVisibility=function(i,v){var r=this._oActionSheetButtonMap[i.getId()];if(r){if(i.getVisible()){i._setInternalVisible(v);r.setVisible(!v);}else{r.setVisible(false);}}};j.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(i){if(i instanceof b){i.$().show();if(D.system.phone){i.$().css("visibility","hidden");}w+=i.$().outerWidth(true);}});return w;};j.prototype._findById=function($,i){if(!i){return null;}if($){i=this.getId()+'-'+i;return q.sap.byId(i,$);}return this.$(i);};j.prototype._getBreadcrumbsAggregation=function(){var i=this.getBreadcrumbs(),r=this._lazyLoadInternalAggregation('_breadCrumbs',true);return i||((r&&r.getLinks().length)?r:null);};j.prototype._notifyParentOfChanges=function(i){var r=this.getParent();if(r&&typeof r._headerTitleChangeHandler==="function"){r._headerTitleChangeHandler(i);}};j.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);}};j.prototype.setNavigationBar=function(i){this.setAggregation("navigationBar",i);if(i&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":i});}return this;};j.prototype._getAdaptableContent=function(){return this.getNavigationBar();};j.prototype.isDynamic=function(){return false;};j.prototype.getCompatibleHeaderContentClass=function(){return d;};j.prototype.supportsTitleInHeaderContent=function(){return true;};j.prototype.supportsAdaptLayoutForDomElement=function(){return true;};j.prototype.getTitleText=function(){return this.getObjectTitle();};j.prototype.snap=function(){this._adaptLayout();};j.prototype.unSnap=function(){this._adaptLayout();};j.prototype._toggleExpandButton=function(t){};j.prototype._setShowExpandButton=function(v){};j.prototype._focusExpandButton=function(){};return j;});
