/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','jquery.sap.keycodes','jquery.sap.dom','jquery.sap.script',"sap/ui/thirdparty/jquery-mobile-custom"],function(q,D){"use strict";var o,a,b,c,d,m,I=false;if(D.browser.webkit&&/Mobile/.test(navigator.userAgent)&&D.support.touch){I=true;(function(){var e=window.document,H=false,j=null,B=false,S,C,i=0;m=["mousedown","mouseover","mouseup","mouseout","click"];var E=function(J,K){if(!H){return;}var M=K.type=="touchend"?K.changedTouches[0]:K.touches[0];var L=e.createEvent('MouseEvent');L.initMouseEvent(J,true,true,window,K.detail,M.screenX,M.screenY,M.clientX,M.clientY,K.ctrlKey,K.shiftKey,K.altKey,K.metaKey,K.button,K.relatedTarget);L.isSynthetic=true;window.setTimeout(function(){j.dispatchEvent(L);},0);};var F=function(J){return J.target.tagName.match(/input|textarea|select/i);};d=function(J){if(!J.isSynthetic&&!F(J)){J.stopPropagation();J.preventDefault();}};o=function(J){var K=J.touches,L;H=(K.length==1&&!F(J));B=false;if(H){L=K[0];j=L.target;if(j.nodeType===3){j=j.parentNode;}S=L.clientX;C=L.clientY;E("mousedown",J);}};a=function(J){var K;if(H){K=J.touches[0];if(Math.abs(K.clientX-S)>10||Math.abs(K.clientY-C)>10){B=true;}if(B){E("mousemove",J);}}};b=function(J){E("mouseup",J);if(!B){E("click",J);}};c=function(J){E("mouseup",J);};for(;i<m.length;i++){e.addEventListener(m[i],d,true);}e.addEventListener('touchstart',o,true);e.addEventListener('touchmove',a,true);e.addEventListener('touchend',b,true);e.addEventListener('touchcancel',c,true);q.sap.disableTouchToMouseHandling=function(){var i=0;if(!I){return;}e.removeEventListener('touchstart',o,true);e.removeEventListener('touchmove',a,true);e.removeEventListener('touchend',b,true);e.removeEventListener('touchcancel',c,true);for(;i<m.length;i++){e.removeEventListener(m[i],d,true);}};}());}if(!q.sap.disableTouchToMouseHandling){q.sap.disableTouchToMouseHandling=function(){};}q.sap.ControlEvents=["click","dblclick","contextmenu","focusin","focusout","keydown","keypress","keyup","mousedown","mouseout","mouseover","mouseup","select","selectstart","dragstart","dragenter","dragover","dragleave","dragend","drop","compositionstart","compositionend","paste","cut","input"];if(D.support.touch){q.sap.ControlEvents.push("touchstart","touchend","touchmove","touchcancel");}q.sap.PseudoEvents={sapdown:{sName:"sapdown",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ARROW_DOWN&&!k(e);}},sapdownmodifiers:{sName:"sapdownmodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ARROW_DOWN&&k(e);}},sapshow:{sName:"sapshow",aTypes:["keydown"],fnCheck:function(e){return(e.keyCode==q.sap.KeyCodes.F4&&!k(e))||(e.keyCode==q.sap.KeyCodes.ARROW_DOWN&&h(e,false,true,false));}},sapup:{sName:"sapup",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ARROW_UP&&!k(e);}},sapupmodifiers:{sName:"sapupmodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ARROW_UP&&k(e);}},saphide:{sName:"saphide",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ARROW_UP&&h(e,false,true,false);}},sapleft:{sName:"sapleft",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ARROW_LEFT&&!k(e);}},sapleftmodifiers:{sName:"sapleftmodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ARROW_LEFT&&k(e);}},sapright:{sName:"sapright",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ARROW_RIGHT&&!k(e);}},saprightmodifiers:{sName:"saprightmodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ARROW_RIGHT&&k(e);}},saphome:{sName:"saphome",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.HOME&&!k(e);}},saphomemodifiers:{sName:"saphomemodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.HOME&&k(e);}},saptop:{sName:"saptop",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.HOME&&h(e,true,false,false);}},sapend:{sName:"sapend",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.END&&!k(e);}},sapendmodifiers:{sName:"sapendmodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.END&&k(e);}},sapbottom:{sName:"sapbottom",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.END&&h(e,true,false,false);}},sappageup:{sName:"sappageup",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.PAGE_UP&&!k(e);}},sappageupmodifiers:{sName:"sappageupmodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.PAGE_UP&&k(e);}},sappagedown:{sName:"sappagedown",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.PAGE_DOWN&&!k(e);}},sappagedownmodifiers:{sName:"sappagedownmodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.PAGE_DOWN&&k(e);}},sapselect:{sName:"sapselect",aTypes:["keydown"],fnCheck:function(e){return(e.keyCode==q.sap.KeyCodes.ENTER||e.keyCode==q.sap.KeyCodes.SPACE)&&!k(e);}},sapselectmodifiers:{sName:"sapselectmodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.keyCode==q.sap.KeyCodes.ENTER||e.keyCode==q.sap.KeyCodes.SPACE)&&k(e);}},sapspace:{sName:"sapspace",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.SPACE&&!k(e);}},sapspacemodifiers:{sName:"sapspacemodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.SPACE&&k(e);}},sapenter:{sName:"sapenter",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ENTER&&!k(e);}},sapentermodifiers:{sName:"sapentermodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ENTER&&k(e);}},sapbackspace:{sName:"sapbackspace",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.BACKSPACE&&!k(e);}},sapbackspacemodifiers:{sName:"sapbackspacemodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.BACKSPACE&&k(e);}},sapdelete:{sName:"sapdelete",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.DELETE&&!k(e);}},sapdeletemodifiers:{sName:"sapdeletemodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.DELETE&&k(e);}},sapexpand:{sName:"sapexpand",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.NUMPAD_PLUS&&!k(e);}},sapexpandmodifiers:{sName:"sapexpandmodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.NUMPAD_PLUS&&k(e);}},sapcollapse:{sName:"sapcollapse",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.NUMPAD_MINUS&&!k(e);}},sapcollapsemodifiers:{sName:"sapcollapsemodifiers",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.NUMPAD_MINUS&&k(e);}},sapcollapseall:{sName:"sapcollapseall",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.NUMPAD_ASTERISK&&!k(e);}},sapescape:{sName:"sapescape",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.ESCAPE&&!k(e);}},saptabnext:{sName:"saptabnext",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.TAB&&!k(e);}},saptabprevious:{sName:"saptabprevious",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.TAB&&h(e,false,false,true);}},sapskipforward:{sName:"sapskipforward",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.F6&&!k(e);}},sapskipback:{sName:"sapskipback",aTypes:["keydown"],fnCheck:function(e){return e.keyCode==q.sap.KeyCodes.F6&&h(e,false,false,true);}},sapdecrease:{sName:"sapdecrease",aTypes:["keydown"],fnCheck:function(e){var R=sap.ui.getCore().getConfiguration().getRTL();var i=R?q.sap.KeyCodes.ARROW_RIGHT:q.sap.KeyCodes.ARROW_LEFT;return(e.keyCode==i||e.keyCode==q.sap.KeyCodes.ARROW_DOWN)&&!k(e);}},sapminus:{sName:"sapminus",aTypes:["keypress"],fnCheck:function(e){var C=String.fromCharCode(e.which);return C=='-';}},sapdecreasemodifiers:{sName:"sapdecreasemodifiers",aTypes:["keydown"],fnCheck:function(e){var R=sap.ui.getCore().getConfiguration().getRTL();var i=R?q.sap.KeyCodes.ARROW_RIGHT:q.sap.KeyCodes.ARROW_LEFT;return(e.keyCode==i||e.keyCode==q.sap.KeyCodes.ARROW_DOWN)&&k(e);}},sapincrease:{sName:"sapincrease",aTypes:["keydown"],fnCheck:function(e){var R=sap.ui.getCore().getConfiguration().getRTL();var N=R?q.sap.KeyCodes.ARROW_LEFT:q.sap.KeyCodes.ARROW_RIGHT;return(e.keyCode==N||e.keyCode==q.sap.KeyCodes.ARROW_UP)&&!k(e);}},sapplus:{sName:"sapplus",aTypes:["keypress"],fnCheck:function(e){var C=String.fromCharCode(e.which);return C=='+';}},sapincreasemodifiers:{sName:"sapincreasemodifiers",aTypes:["keydown"],fnCheck:function(e){var R=sap.ui.getCore().getConfiguration().getRTL();var N=R?q.sap.KeyCodes.ARROW_LEFT:q.sap.KeyCodes.ARROW_RIGHT;return(e.keyCode==N||e.keyCode==q.sap.KeyCodes.ARROW_UP)&&k(e);}},sapprevious:{sName:"sapprevious",aTypes:["keydown"],fnCheck:function(e){var R=sap.ui.getCore().getConfiguration().getRTL();var i=R?q.sap.KeyCodes.ARROW_RIGHT:q.sap.KeyCodes.ARROW_LEFT;return(e.keyCode==i||e.keyCode==q.sap.KeyCodes.ARROW_UP)&&!k(e);}},sappreviousmodifiers:{sName:"sappreviousmodifiers",aTypes:["keydown"],fnCheck:function(e){var R=sap.ui.getCore().getConfiguration().getRTL();var i=R?q.sap.KeyCodes.ARROW_RIGHT:q.sap.KeyCodes.ARROW_LEFT;return(e.keyCode==i||e.keyCode==q.sap.KeyCodes.ARROW_UP)&&k(e);}},sapnext:{sName:"sapnext",aTypes:["keydown"],fnCheck:function(e){var R=sap.ui.getCore().getConfiguration().getRTL();var N=R?q.sap.KeyCodes.ARROW_LEFT:q.sap.KeyCodes.ARROW_RIGHT;return(e.keyCode==N||e.keyCode==q.sap.KeyCodes.ARROW_DOWN)&&!k(e);}},sapnextmodifiers:{sName:"sapnextmodifiers",aTypes:["keydown"],fnCheck:function(e){var R=sap.ui.getCore().getConfiguration().getRTL();var N=R?q.sap.KeyCodes.ARROW_LEFT:q.sap.KeyCodes.ARROW_RIGHT;return(e.keyCode==N||e.keyCode==q.sap.KeyCodes.ARROW_DOWN)&&k(e);}},sapdelayeddoubleclick:{sName:"sapdelayeddoubleclick",aTypes:["click"],fnCheck:function(e){var i=q(e.target);var j=e.timeStamp;var B=i.data("sapdelayeddoubleclick_lastClickTimestamp");var C=B||0;i.data("sapdelayeddoubleclick_lastClickTimestamp",j);var E=j-C;return(E>=300&&E<=1300);}}};var P=["sapdown","sapdownmodifiers","sapshow","sapup","sapupmodifiers","saphide","sapleft","sapleftmodifiers","sapright","saprightmodifiers","saphome","saphomemodifiers","saptop","sapend","sapendmodifiers","sapbottom","sappageup","sappageupmodifiers","sappagedown","sappagedownmodifiers","sapselect","sapselectmodifiers","sapspace","sapspacemodifiers","sapenter","sapentermodifiers","sapexpand","sapbackspace","sapbackspacemodifiers","sapdelete","sapdeletemodifiers","sapexpandmodifiers","sapcollapse","sapcollapsemodifiers","sapcollapseall","sapescape","saptabnext","saptabprevious","sapskipforward","sapskipback","sapprevious","sappreviousmodifiers","sapnext","sapnextmodifiers","sapdecrease","sapminus","sapdecreasemodifiers","sapincrease","sapplus","sapincreasemodifiers","sapdelayeddoubleclick"];(function initTouchEventSupport(){q.sap.touchEventMode="SIM";var e=[];var j=[];if(D.support.touch){q.sap.touchEventMode="ON";q.event.props.push("touches","targetTouches","changedTouches");}var B=function(U,V,W){var X="__"+U+"Handler";var Y="sap"+U;e.push(Y);j.push({sName:U,aTypes:[Y],fnCheck:function(Z){return true;}});q.event.special[Y]={add:function(Z){var $=this,a1=q(this),b1={domRef:$,eventName:U,sapEventName:Y,eventHandle:Z};var c1=function(d1){W(d1,b1);};Z.__sapSimulatedEventHandler=c1;for(var i=0;i<V.length;i++){a1.on(V[i],c1);}},remove:function(Z){var $=q(this);var W=Z.__sapSimulatedEventHandler;$.removeData(X+Z.guid);for(var i=0;i<V.length;i++){q.event.remove(this,V[i],W);}}};};var M=function(U,V){var $=q(V.domRef);if(U.isMarked("delayedMouseEvent")){return;}if(!(U.type!="mouseout"||(U.type==="mouseout"&&q.sap.checkMouseEnterOrLeave(U,V.domRef)))){var W=true;var X=$.data("__touchstart_control");if(X){var Y=q.sap.domById(X);if(Y&&q.sap.checkMouseEnterOrLeave(U,Y)){W=false;}}if(W){return;}}var Z=q.event.fix(U.originalEvent||U);Z.type=V.sapEventName;if(Z.isMarked("firstUIArea")){Z.setMark("handledByUIArea",false);}var a1=[{identifier:1,pageX:Z.pageX,pageY:Z.pageY,clientX:Z.clientX,clientY:Z.clientY,screenX:Z.screenX,screenY:Z.screenY,target:Z.target,radiusX:1,radiusY:1,rotationAngle:0}];switch(V.eventName){case"touchstart":case"touchmove":Z.touches=Z.changedTouches=Z.targetTouches=a1;break;case"touchend":Z.changedTouches=a1;Z.touches=Z.targetTouches=[];break;}if(V.eventName==="touchstart"||$.data("__touch_in_progress")){$.data("__touch_in_progress","X");var b1=q.fn.control?q(U.target).control(0):null;if(b1){$.data("__touchstart_control",b1.getId());}if(U.type==="mouseout"){Z.setMarked("fromMouseout");}if(U.type!=="dragstart"){V.eventHandle.handler.call(V.domRef,Z);}if((V.eventName==="touchend"||U.type==="dragstart")&&!Z.isMarked("fromMouseout")){$.removeData("__touch_in_progress");$.removeData("__touchstart_control");}}};var E=!(D.os.windows_phone&&D.os.version<10);if(E){B("touchstart",["mousedown"],M);B("touchend",["mouseup","mouseout"],M);B("touchmove",["mousemove","dragstart"],M);}if(D.os.ios){var S=function(U,V){var W=q.event.fix(U.originalEvent||U);W.type=V.sapEventName;if(!window.getSelection||!window.getSelection()||window.getSelection().toString()===""){V.eventHandle.handler.call(V.domRef,W);}};B("contextmenu",["taphold"],S);}if(D.support.touch&&E){var F=false,C=q.vmouse.moveDistanceThreshold,H,J,O,K,L;var N=function(U,V,W){var X=q.event.fix(U.originalEvent||U);X.type=V.sapEventName;delete X.touches;delete X.changedTouches;delete X.targetTouches;X.screenX=W.screenX;X.screenY=W.screenY;X.clientX=W.clientX;X.clientY=W.clientY;X.ctrlKey=W.ctrlKey;X.altKey=W.altKey;X.shiftKey=W.shiftKey;X.button=0;return X;};var Q=function(U,V){if(U.isMarked("handledByTouchToMouse")){return;}U.setMarked("handledByTouchToMouse");if(!F){var W=U.originalEvent.touches[0];F=(Math.abs(W.pageX-H)>C||Math.abs(W.pageY-J)>C);}if(D.os.blackberry){if(L&&U.timeStamp-L<50){return;}L=U.timeStamp;}var X=N(U,V,U.touches[0]);q.sap.delayedCall(0,this,function(){X.setMark("handledByUIArea",false);V.eventHandle.handler.call(V.domRef,X);});};var R=function(U,V){if(U.isMarked("handledByTouchToMouse")){return;}U.setMarked("handledByTouchToMouse");var W,X,Y;function Z(){return N(U,V,V.eventName==="mouseup"?U.changedTouches[0]:U.touches[0]);}if(U.type==="touchstart"){var $=U.originalEvent.touches[0];F=false;L=0;H=$.pageX;J=$.pageY;O=Math.round($.pageX-q(U.target).offset().left);K=Math.round($.pageY-q(U.target).offset().top);W=Z();q.sap.delayedCall(0,this,function(){W.setMark("handledByUIArea",false);V.eventHandle.handler.call(V.domRef,W);});}else if(U.type==="touchend"){X=Z();Y=!F;q.sap.delayedCall(0,this,function(){X.setMark("handledByUIArea",false);V.eventHandle.handler.call(V.domRef,X);if(Y){X.type="click";X.getPseudoTypes=q.Event.prototype.getPseudoTypes;X.setMark("handledByUIArea",false);X.offsetX=O;X.offsetY=K;V.eventHandle.handler.call(V.domRef,X);}});}};q.sap.disableTouchToMouseHandling();B("mousedown",["touchstart"],R);B("mousemove",["touchmove"],Q);B("mouseup",["touchend","touchcancel"],R);}e.push("swipe","tap","swipeleft","swiperight","scrollstart","scrollstop");j.push({sName:"swipebegin",aTypes:["swipeleft","swiperight"],fnCheck:function(U){var V=sap.ui.getCore().getConfiguration().getRTL();return(V&&U.type==="swiperight")||(!V&&U.type==="swipeleft");}});j.push({sName:"swipeend",aTypes:["swipeleft","swiperight"],fnCheck:function(U){var V=sap.ui.getCore().getConfiguration().getRTL();return(!V&&U.type==="swiperight")||(V&&U.type==="swipeleft");}});if(q.sap.Version(q.fn.jquery).compareTo("1.9.1")<0){q.sap.ControlEvents=q.sap.ControlEvents.concat(e);}else{q.sap.ControlEvents=e.concat(q.sap.ControlEvents);}for(var i=0;i<j.length;i++){q.sap.PseudoEvents[j[i].sName]=j[i];P.push(j[i].sName);}}());function f(){var e=q.sap.PseudoEvents,R=[];for(var N in e){if(e[N].aTypes){for(var j=0,i=e[N].aTypes.length;j<i;j++){var B=e[N].aTypes[j];if(R.indexOf(B)==-1){R.push(B);}}}}return R;}var g=f();function h(e,C,i,S){return e.shiftKey==S&&e.altKey==i&&l(e)==C;}function k(e){return e.shiftKey||e.altKey||l(e);}function l(e){return!!(e.metaKey||e.ctrlKey);}q.Event.prototype.getPseudoTypes=function(){var e=[];if(g.indexOf(this.type)!=-1){var j=P;var B=j.length;var C=null;for(var i=0;i<B;i++){C=q.sap.PseudoEvents[j[i]];if(C.aTypes&&C.aTypes.indexOf(this.type)>-1&&C.fnCheck&&C.fnCheck(this)){e.push(C.sName);}}}this.getPseudoTypes=function(){return e.slice();};return e.slice();};q.Event.prototype.isPseudoType=function(e){var i=this.getPseudoTypes();if(e){return i.indexOf(e)>-1;}else{return i.length>0;}};q.sap.bindAnyEvent=function bindAnyEvent(C){if(C){q(document).bind(q.sap.ControlEvents.join(" "),C);}};q.sap.unbindAnyEvent=function unbindAnyEvent(C){if(C){q(document).unbind(q.sap.ControlEvents.join(" "),C);}};q.sap.checkMouseEnterOrLeave=function checkMouseEnterOrLeave(E,i){if(E.type!="mouseover"&&E.type!="mouseout"){return false;}var j=false;var B=i;var C=E.relatedTarget;try{while(C&&C!==B){C=C.parentNode;}if(C!==B){j=true;}}catch(e){}return j;};q.sap.isSpecialKey=function(e){var K=q.sap.KeyCodes,i=e.which,S=n(e)||p(e)||(i>=33&&i<=36)||(i>=44&&i<=46)||(i>=112&&i<=123)||(i===K.BREAK)||(i===K.BACKSPACE)||(i===K.TAB)||(i===K.ENTER)||(i===K.ESCAPE)||(i===K.SCROLL_LOCK);switch(e.type){case"keydown":case"keyup":return S;case"keypress":return(i===0||i===K.BACKSPACE||i===K.ESCAPE||i===K.ENTER)||false;default:return false;}};function n(e){var K=q.sap.KeyCodes,i=e.which;return(i===K.SHIFT)||(i===K.CONTROL)||(i===K.ALT)||(i===K.CAPS_LOCK)||(i===K.NUM_LOCK);}function p(e){var K=e.which,i=(K>=37&&K<=40);switch(e.type){case"keydown":case"keyup":return i;case"keypress":return K===0;default:return false;}}q.Event.prototype.getOffsetX=function(){if(this.type=='click'){if(this.offsetX){return this.offsetX;}if(this.layerX){return this.layerX;}if(this.originalEvent.layerX){return this.originalEvent.layerX;}}return 0;};q.Event.prototype.getOffsetY=function(){if(this.type=='click'){if(this.offsetY){return this.offsetY;}if(this.layerY){return this.layerY;}if(this.originalEvent.layerY){return this.originalEvent.layerY;}}return 0;};var s=q.Event.prototype.stopImmediatePropagation;q.Event.prototype.stopImmediatePropagation=function(S){s.apply(this,arguments);if(S){this._bIsStopHandlers=true;}};q.Event.prototype.isImmediateHandlerPropagationStopped=function(){return!!this._bIsStopHandlers;};var G=function(e){while(e&&e.originalEvent&&e!==e.originalEvent){e=e.originalEvent;}return e;};q.Event.prototype.setMark=function(K,V){K=K||"handledByControl";V=arguments.length<2?true:V;var N=G(this);N["_sapui_"+K]=V;};q.Event.prototype.setMarked=q.Event.prototype.setMark;q.Event.prototype.isMarked=function(K){return!!this.getMark(K);};q.Event.prototype.getMark=function(K){K=K||"handledByControl";var N=G(this);return N["_sapui_"+K];};q.sap._FASTNAVIGATIONKEY="sap-ui-fastnavgroup";function r(R){var $=q(R).closest('[data-sap-ui-customfastnavgroup="true"]');return $[0];}function t(R){var e=r(R);if(e){return e;}var $=q(R).closest('[data-'+q.sap._FASTNAVIGATIONKEY+'="true"]');return $[0];}function u(R,S,N){var $=q(R),e,i;if(N){e=q.merge($.find("*"),q.merge($.nextAll(),$.parents().nextAll()));i=e.find(':sapTabbable').addBack(':sapTabbable');}else{e=q.merge($.prevAll(),$.parents().prevAll());i=q.merge($.parents(':sapTabbable'),e.find(':sapTabbable').addBack(':sapTabbable'));}var i=q.unique(i);return i.filter(function(){return w(S,this);});}function v(R,S){var e=q.sap.domById("sap-ui-static");if(!e){return R;}var j=[];for(var i=0;i<S.length;i++){if(q.contains(e,S[i])){j.push(S[i]);}}return R.filter(function(){if(j.length&&w(j,this)){return true;}return!q.contains(e,this);});}function w(C,R){for(var i=0;i<C.length;i++){if(C[i]===R||q.contains(C[i],R)){return true;}}return false;}function x(F,$,S,e){var j,B;for(var i=$.length-1;i>=0;i--){j=t($[i]);if(j!=S){if(e){S=j;e=false;}else{B=q($[i+1]);break;}}}if(!B&&!e){B=F;}return B;}function y(S,e,F){if(!e||e.length==0){e=[document];}if(!w(e,S)){return;}var j=t(S),$=v(q(e).find(':sapTabbable').addBack(':sapTabbable'),e),B=$.first(),C=v(u(S,e,F),e),E,H;if(F){for(var i=0;i<C.length;i++){E=t(C[i]);if(E!=j){H=q(C[i]);break;}}if(!H||!H.length){H=B;}}else{H=x(B,C,j,true);if(!H||!H.length){if($.length==1){H=q($[0]);}else if($.length>1){j=t($.eq(-1));E=t($.eq(-2));if(j!=E){H=$.eq(-1);}else{H=x(B,$,j,false);}}}}if(H&&H.length){var J=H[0],K=null,L=r(J);if(L&&L.id){var M=sap.ui.getCore().byId(L.id);if(M){K=q.Event("BeforeFastNavigationFocus");K.target=J;K.source=S;K.forward=F;M._handleEvent(K);}}if(!K||!K.isDefaultPrevented()){q.sap.focus(J);}}}q.sap.handleF6GroupNavigation=function(e,S){if(e.type!="keydown"||e.keyCode!=q.sap.KeyCodes.F6||e.isMarked("sapui5_handledF6GroupNavigation")||e.isMarked()||e.isDefaultPrevented()){return;}e.setMark("sapui5_handledF6GroupNavigation");e.setMarked();e.preventDefault();if(S&&S.skip){return;}var i=S&&S.target?S.target:document.activeElement,j=null;if(S&&S.scope){j=Array.isArray(S.scope)?S.scope:[S.scope];}y(i,j,!e.shiftKey);};q(function(){q(document).on("keydown",function(e){q.sap.handleF6GroupNavigation(e,null);});});q.sap._refreshMouseEventDelayedFlag=function(N){N=N||navigator;q.sap.isMouseEventDelayed=!!(D.browser.mobile&&!((D.os.ios&&D.os.version>=8&&D.browser.safari&&!D.browser.webview)||(D.browser.chrome&&!/SAMSUNG/.test(N.userAgent)&&D.browser.version>=32)));};q.sap._refreshMouseEventDelayedFlag(navigator);var T={};var z;function A(){if(!z){z=function(e){var i=q.sap.log.isLoggable(q.sap.log.Level.DEBUG);var E=T[e.type];var O=E.originalTriggerHook;var j=window.performance.now();var B;if(!e.isPropagationStopped()&&!e.isSimulated){for(var C in E.domRefs){var F=E.domRefs[C];if(F.excludedDomRefs.indexOf(e.target)===-1&&q.sap.containsOrEquals(F.domRef,e.target)){e.preventDefault();e.stopImmediatePropagation();B=window.performance.now();if(i){q.sap.log.debug("Perf: jQuery trigger supression event handler "+e.type+" took "+(B-j)+" milliseconds.");}return false;}}}if(O&&O.call(this,e)===false){return false;}};}return z;}function _(e){if(!q.event.special[e]){q.event.special[e]={};}var S=q.event.special[e],i=S.trigger;S.trigger=A();return i;}q.sap._suppressTriggerEvent=function(e,i,E){var j=T[e];var B=q.sap.uid();if(!j){j=T[e]={domRefs:{},originalTriggerHook:_(e)};}j.domRefs[B]={domRef:i,excludedDomRefs:[].concat(E)};return{id:B,type:e};};q.sap._releaseTriggerEvent=function(H){if(!H){return;}var e=T[H.type];if(!e){return;}else if(!e.domRefs[H.id]||!e.domRefs[H.id].domRef){q.sap.log.warning("Release trigger event for event type "+H.type+"on Control "+H.id+": DomRef does not exists");return;}delete e.domRefs[H.id];};return q;});
