/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(q,D,a){"use strict";if(!q){throw new Error("Loading of jQuery failed");}if(q.sap){return;}if(D.browser.edge||D.browser.safari){a.Promise=undefined;}if(!a.Promise){ES6Promise.polyfill();}var _=[];function b(l,m){_.push({level:l,message:m});}function c(d,i){if(i===undefined){i=new URI(document.baseURI).search("");}return new URI(d,i).toString();}var f;var g=/^[0-9]+(?:\.([0-9]+)(?:\.([0-9]+))?)?(.*)$/;function V(d,i,j,s){if(d instanceof V){return d;}if(!(this instanceof V)){return new V(d,i,j,s);}var m;if(typeof d==="string"){m=g.exec(d);}else if(Array.isArray(d)){m=d;}else{m=arguments;}m=m||[];function n(v){v=parseInt(v,10);return isNaN(v)?0:v;}d=n(m[0]);i=n(m[1]);j=n(m[2]);s=String(m[3]||"");this.toString=function(){return d+"."+i+"."+j+s;};this.getMajor=function(){return d;};this.getMinor=function(){return i;};this.getPatch=function(){return j;};this.getSuffix=function(){return s;};this.compareTo=function(){var o=V.apply(a,arguments);return d-o.getMajor()||i-o.getMinor()||j-o.getPatch()||((s<o.getSuffix())?-1:(s===o.getSuffix())?0:1);};}V.prototype.inRange=function(m,v){return this.compareTo(m)>=0&&this.compareTo(v)<0;};var J=V(q.fn.jquery);if(J.compareTo("2.2.3")!=0){b("warning","SAPUI5's default jQuery version is 2.2.3; current version is "+q.fn.jquery+". Please note that we only support version 2.2.3.");}if(!q.browser){q.browser=(function(d){var r=/(webkit)[ \/]([\w.]+)/,i=/(opera)(?:.*version)?[ \/]([\w.]+)/,j=/(msie) ([\w.]+)/,l=/(mozilla)(?:.*? rv:([\w.]+))?/,d=d.toLowerCase(),m=r.exec(d)||i.exec(d)||j.exec(d)||d.indexOf("compatible")<0&&l.exec(d)||[],n={};if(m[1]){n[m[1]]=true;n.version=m[2]||"0";if(n.webkit){n.safari=true;}}return n;}(a.navigator.userAgent));}if(D.browser.msie){q.support=q.support||{};q.support.cors=true;if(a.ActiveXObject!==undefined&&J.inRange("1.11","2")){var C=function(){try{return new XMLHttpRequest();}catch(e){}};var h=function(){try{return new ActiveXObject("Microsoft.XMLHTTP");}catch(e){}};q.ajaxSettings=q.ajaxSettings||{};q.ajaxSettings.xhr=function(){return!this.isLocal?C():h();};}}if(D.browser.firefox){var G=a.getComputedStyle;a.getComputedStyle=function(d,i){var o=G.call(this,d,i);if(o===null){if(document.body==null){var j=document.createElement("body");var l=document.getElementsByTagName("html")[0];l.insertBefore(j,l.firstChild);var H=j.style;j.parentNode.removeChild(j);return H;}return document.body.cloneNode(false).style;}return o;};}if(D.browser.msie||D.browser.edge){var k=Object.getOwnPropertyDescriptor(Document.prototype,'activeElement');if(!k){q.sap.log.warning("activeElementFix: Unable to retrieve property descriptor for 'Document.prototype.activeElement'");return;}var p=k.get;if(!p){q.sap.log.warning("activeElementFix: Unable to retrieve getter of property 'Document.prototype.activeElement'");return;}Object.defineProperty(Document.prototype,'activeElement',{configurable:true,enumerable:true,get:function(){var o=null;try{o=p.call(this);}catch(e){}return(o&&o.nodeType)?o:document.body;}});}if(D.browser.firefox&&a.Proxy){(function(){var s=false,d=false;var i=Promise.prototype.then,j=Promise.prototype.catch,l=a.setTimeout,m=a.setInterval,Q=[];function n(r){if(!d){d=true;l(function(){var v=Q;Q=[];d=false;v.forEach(function(N){N();});},0);}Q.push(r);}function w(r,v,N){if(typeof r!=="function"){return r;}return function(){var O=Array.prototype.slice.call(arguments);if(s||d){return new Promise(function(R,T){n(function(){var U;try{U=r.apply(a,O);R(U);}catch(W){T(W);}});});}return r.apply(a,O);};}Promise.prototype.then=function(T,r){var W=w(T),v=w(r);return i.call(this,W,v);};Promise.prototype.catch=function(r){var W=w(r);return j.call(this,W);};function o(r){var W=function(){var v;if(d){v=[W,0].concat(arguments);l.apply(a,v);}else{r.apply(a,arguments);}};return W;}a.setTimeout=function(v){var r=Array.prototype.slice.call(arguments),N=typeof v==="string"?new Function(v):v,W=o(N);r[0]=W;return l.apply(a,r);};a.setInterval=function(v){var r=Array.prototype.slice.call(arguments),N=typeof v==="string"?new Function(v):v,W=o(N,true);r[0]=W;return m.apply(a,r);};a.XMLHttpRequest=new Proxy(a.XMLHttpRequest,{construct:function(T,r,N){var X=new T(),v=false,O=false,R=0,U;function W($){var a1=function(b1){var c1=X.readyState;function d1(){R=c1;if(a1.active){return $.call(U,b1);}}if(!v&&s){O=true;}if(O){l(d1,0);return true;}return d1();};$.wrappedHandler=a1;a1.active=true;return a1;}function Y($){return Z($.wrappedHandler);}function Z($){if(typeof $==="function"){$.active=false;}return $;}U=new Proxy(X,{get:function($,a1,b1){var c1=$[a1];switch(a1){case"readyState":return R;case"addEventListener":return function(d1,e1,f1){c1.call($,d1,W(e1),f1);};case"removeEventListener":return function(d1,e1,f1){c1.call($,d1,Y(e1),f1);};case"open":return function(d1,e1,f1){v=f1===false;c1.apply($,arguments);R=$.readyState;};case"send":return function(){s=v;c1.apply($,arguments);R=$.readyState;s=false;};}if(typeof c1==="function"){return function(){return c1.apply($,arguments);};}return c1;},set:function($,a1,b1){if(a1.indexOf("on")===0){Z($[a1]);if(typeof b1==="function"){$[a1]=W(b1);return true;}}$[a1]=b1;return true;}});U.addEventListener("readystatechange",function(){});return U;}});})();}var t=(function(){var T,U,r,d=/^(.*\/)?download\/configurator[\/\?]/,i=/^(.*\/)?(sap-ui-(core|custom|boot|merged)(-.*)?)\.js([?#]|$)/,j=/^(.*\/)?resources\//;q("script[src]").each(function(){var s=this.getAttribute("src"),m;if((m=s.match(d))!==null){T=this;U=s;r=(m[1]||"")+"resources/";return false;}else if((m=s.match(i))!==null){T=this;U=s;r=m[1]||"";return false;}else if(this.id=='sap-ui-bootstrap'&&(m=s.match(j))){T=this;U=s;r=m[0];return false;}});return{tag:T,url:U,resourceRoot:r};})();(function(){if(/sap-bootstrap-debug=(true|x|X)/.test(location.search)){debugger;}var r;try{r=a.localStorage.getItem("sap-ui-reboot-URL");a.localStorage.removeItem("sap-ui-reboot-URL");}catch(e){}if(r&&r!=="undefined"){var U=confirm("WARNING!\n\nUI5 will be booted from the URL below.\nPress 'Cancel' unless you have configured this.\n\n"+r);if(U){var s=t.tag,d="<script src=\""+r+"\"";q.each(s.attributes,function(i,o){if(o.nodeName.indexOf("data-sap-ui-")==0){d+=" "+o.nodeName+"=\""+o.nodeValue.replace(/"/g,"&quot;")+"\"";}});d+="></script>";s.parentNode.removeChild(s);q("#sap-ui-bootstrap-cachebusted").remove();a["sap-ui-config"]&&a["sap-ui-config"].resourceRoots&&(a["sap-ui-config"].resourceRoots[""]=undefined);document.write(d);var R=new Error("This is not a real error. Aborting UI5 bootstrap and rebooting from: "+r);R.name="Restart";throw R;}}})();(function(){var U=/(?:^|\?|&)sap-ui-debug=([^&]*)(?:&|$)/.exec(location.search),d=U&&decodeURIComponent(U[1]);try{d=d||a.localStorage.getItem("sap-ui-debug");}catch(e){}if(typeof d==='string'){if(/^(?:false|true|x|X)$/.test(d)){d=d!=='false';}}else{d=!!d;}a["sap-ui-debug"]=d;if(/-dbg\.js([?#]|$)/.test(t.url)){a["sap-ui-loaddbg"]=true;a["sap-ui-debug"]=d=d||true;}if(a["sap-ui-optimized"]&&d){a["sap-ui-loaddbg"]=true;if(d===true){var s=t.url.replace(/\/(?:sap-ui-cachebuster\/)?([^\/]+)\.js/,"/$1-dbg.js");a["sap-ui-optimized"]=false;document.write("<script type=\"text/javascript\" src=\""+s+"\"></script>");var r=new Error("This is not a real error. Aborting UI5 bootstrap and restarting from: "+s);r.name="Restart";throw r;}}})();var u=a["sap-ui-config"]=(function(){function n(o){q.each(o,function(i,v){var m=i.toLowerCase();if(!o.hasOwnProperty(m)){o[m]=v;delete o[i];}});return o;}var s=t.tag,d=a["sap-ui-config"],j="sap-ui-config.json";if(typeof d==="string"){b("warning","Loading external bootstrap configuration from \""+d+"\". This is a design time feature and not for productive usage!");if(d!==j){b("warning","The external bootstrap configuration file should be named \""+j+"\"!");}q.ajax({url:d,dataType:'json',async:false,success:function(o,T,i){d=o;},error:function(i,T,o){b("error","Loading externalized bootstrap configuration from \""+d+"\" failed! Reason: "+o+"!");d=undefined;}});d=d||{};d.__loaded=true;}d=n(d||{});d.resourceroots=d.resourceroots||{};d.themeroots=d.themeroots||{};d.resourceroots['']=d.resourceroots['']||t.resourceRoot;d['xx-loadallmode']=/(^|\/)(sap-?ui5|[^\/]+-all).js([?#]|$)/.test(t.url);if(s){var l=s.getAttribute("data-sap-ui-config");if(l){try{q.extend(d,n((new Function("return {"+l+"};"))()));}catch(e){b("error","failed to parse data-sap-ui-config attribute: "+(e.message||e));}}q.each(s.attributes,function(i,o){var m=o.name.match(/^data-sap-ui-(.*)$/);if(m){m=m[1].toLowerCase();if(m==='resourceroots'){q.extend(d[m],q.parseJSON(o.value));}else if(m==='theme-roots'){q.extend(d.themeroots,q.parseJSON(o.value));}else if(m!=='config'){d[m]=o.value;}}});}return d;}());var x=0;if(u['xx-nosync']==='warn'||/(?:\?|&)sap-ui-xx-nosync=(?:warn)/.exec(a.location.search)){x=1;}if(u['xx-nosync']===true||u['xx-nosync']==='true'||/(?:\?|&)sap-ui-xx-nosync=(?:x|X|true)/.exec(a.location.search)){x=2;}if(x&&u.__loaded){b(x===1?"warning":"error","[nosync]: configuration loaded via sync XHR");}if(u.noconflict===true||u.noconflict==="true"||u.noconflict==="x"){q.noConflict();}q.sap={};q.sap.Version=V;q.sap.now=!(a.performance&&performance.now&&performance.timing)?Date.now:(function(){var n=performance.timing.navigationStart;return function perfnow(){return n+performance.now();};}());function y(d,i,j){return function(v){try{if(v!=null||i==='string'){if(v){localStorage.setItem(d,i==='boolean'?'X':v);}else{localStorage.removeItem(d);}j(v);}v=localStorage.getItem(d);return i==='boolean'?v==='X':v;}catch(e){q.sap.log.warning("Could not access localStorage while accessing '"+d+"' (value: '"+v+"', are cookies disabled?): "+e.message);}};}q.sap.debug=y('sap-ui-debug','',function reloadHint(d){alert("Usage of debug sources is "+(d?"on":"off")+" now.\nFor the change to take effect, you need to reload the page.");});q.sap.setReboot=y('sap-ui-reboot-URL','string',function rebootUrlHint(r){if(r){alert("Next time this app is launched (only once), it will load UI5 from:\n"+r+".\nPlease reload the application page now.");}});q.sap.statistics=y('sap-ui-statistics','boolean',function gatewayStatsHint(U){alert("Usage of Gateway statistics "+(U?"on":"off")+" now.\nFor the change to take effect, you need to reload the page.");});(function(){var d=0,j=1,W=2,l=3,n=4,T=5,s=(a.top==a)?"":"["+a.location.pathname.split('/').slice(-1)[0]+"] ",o=[],r={'':j},N=null,O=false;function Q(i,w){return("000"+String(i)).slice(-w);}function R(i){return(!i||isNaN(r[i]))?r['']:r[i];}function U(){if(!N){N={listeners:[],onLogEntry:function(m){for(var i=0;i<N.listeners.length;i++){if(N.listeners[i].onLogEntry){N.listeners[i].onLogEntry(m);}}},attach:function(i,m){if(m){N.listeners.push(m);if(m.onAttachToLog){m.onAttachToLog(i);}}},detach:function(m,v){for(var i=0;i<N.listeners.length;i++){if(N.listeners[i]===v){if(v.onDetachFromLog){v.onDetachFromLog(m);}N.listeners.splice(i,1);return;}}}};}return N;}function X(i,m,v,w,Z){if(i<=R(w)){if(O){if(!Z&&!w&&typeof v==="function"){Z=v;v="";}if(!Z&&typeof w==="function"){Z=w;w="";}}var $=q.sap.now(),a1=new Date($),b1=Math.floor(($-Math.floor($))*1000),c1={time:Q(a1.getHours(),2)+":"+Q(a1.getMinutes(),2)+":"+Q(a1.getSeconds(),2)+"."+Q(a1.getMilliseconds(),3)+Q(b1,3),date:Q(a1.getFullYear(),4)+"-"+Q(a1.getMonth()+1,2)+"-"+Q(a1.getDate(),2),timestamp:$,level:i,message:String(m||""),details:String(v||""),component:String(w||"")};if(O&&typeof Z==="function"){c1.supportInfo=Z();}o.push(c1);if(N){N.onLogEntry(c1);}if(a.console){var d1=c1.date+" "+c1.time+" "+s+c1.message+" - "+c1.details+" "+c1.component;switch(i){case d:case j:console.error(d1);break;case W:console.warn(d1);break;case l:console.info?console.info(d1):console.log(d1);break;case n:console.debug?console.debug(d1):console.log(d1);break;case T:console.trace?console.trace(d1):console.log(d1);break;}if(console.info&&c1.supportInfo){console.info(c1.supportInfo);}}return c1;}}function Y(i){this.fatal=function(m,v,w,Z){X(d,m,v,w||i,Z);return this;};this.error=function error(m,v,w,Z){X(j,m,v,w||i,Z);return this;};this.warning=function warning(m,v,w,Z){X(W,m,v,w||i,Z);return this;};this.info=function info(m,v,w,Z){X(l,m,v,w||i,Z);return this;};this.debug=function debug(m,v,w,Z){X(n,m,v,w||i,Z);return this;};this.trace=function trace(m,v,w,Z){X(T,m,v,w||i,Z);return this;};this.setLevel=function setLevel(m,w){w=w||i||'';r[w]=m;var Z=[];q.each(q.sap.log.LogLevel,function($,v){Z[v]=$;});X(l,"Changing log level "+(w?"for '"+w+"' ":"")+"to "+Z[m],"","jQuery.sap.log");return this;};this.getLevel=function getLevel(m){return R(m||i);};this.isLoggable=function(m,v){return(m==null?n:m)<=R(v||i);};}q.sap.log=q.extend(new Y(),{Level:{NONE:d-1,FATAL:d,ERROR:j,WARNING:W,INFO:l,DEBUG:n,TRACE:T,ALL:(T+1)},getLogger:function(i,m){if(!isNaN(m)&&r[i]==null){r[i]=m;}return new Y(i);},getLogEntries:function(){return o.slice();},addLogListener:function(N){U().attach(this,N);return this;},removeLogListener:function(N){U().detach(this,N);return this;},logSupportInfo:function logSupportInfo(i){O=i;}});q.sap.log.LogLevel=q.sap.log.Level;q.sap.log.getLog=q.sap.log.getLogEntries;q.sap.assert=function(i,m){if(!i){var v=typeof m==="function"?m():m;if(a.console&&console.assert){console.assert(i,s+v);}else{q.sap.log.debug("[Assertions] "+v);}}};u.loglevel=(function(){var m=/(?:\?|&)sap-ui-log(?:L|-l)evel=([^&]*)/.exec(a.location.search);return m&&m[1];}())||u.loglevel;if(u.loglevel){q.sap.log.setLevel(q.sap.log.Level[u.loglevel.toUpperCase()]||parseInt(u.loglevel,10));}q.sap.log.info("SAP Logger started.");q.each(_,function(i,e){q.sap.log[e.level](e.message);});_=null;}());q.sap.factory=function factory(o){function d(){}d.prototype=o;return d;};q.sap.newObject=function newObject(o){return Object.create(o||null);};q.sap.getter=function getter(v){return function(){return v;};};q.sap.getObject=function getObject(n,N,o){var O=o||a,d=(n||"").split("."),l=d.length,j=isNaN(N)?0:l-N,i;if(x&&o===a){q.sap.log.error("[nosync] getObject called to retrieve global name '"+n+"'");}for(i=0;O&&i<l;i++){if(!O[d[i]]&&i<j){O[d[i]]={};}O=O[d[i]];}return O;};q.sap.setObject=function(n,v,o){var O=o||a,N=(n||"").split("."),l=N.length,i;if(l>0){for(i=0;O&&i<l-1;i++){if(!O[N[i]]){O[N[i]]={};}O=O[N[i]];}O[N[l-1]]=v;}};function P(){function d(i,l,c1,d1,e1){this.id=i;this.info=l;this.start=c1;this.end=d1;this.pause=0;this.resume=0;this.duration=0;this.time=0;this.categories=e1;this.average=false;this.count=0;this.completeDuration=0;}function m(l){if(!R){return true;}if(!l){return R===null;}for(var i=0;i<R.length;i++){if(l.indexOf(R[i])>-1){return true;}}return false;}function j(i){if(!i){i=["javascript"];}i=typeof i==="string"?i.split(","):i;if(!m(i)){return null;}return i;}function n(l,c1){for(var i=0;i<c1.length;i++){if(l.categories.indexOf(c1[i])>-1){return true;}}return c1.length===0;}var o=false,r=q.ajax,R=null,s=[],O=[],v={},w={};this.getActive=function(){return o;};this.setActive=function(i,l){if(!l){l=null;}else if(typeof l==="string"){l=l.split(",");}R=l;if(o===i){return;}o=i;if(o){for(var b1 in v){this[b1]=v[b1];}v={};q.ajax=function(c1,d1){if(typeof c1==='object'){d1=c1;c1=undefined;}d1=d1||{};var e1=c(c1||d1.url);q.sap.measure.start(e1,"Request for "+e1,"xmlhttprequest");var f1=d1.complete;d1.complete=function(){q.sap.measure.end(e1);if(f1){f1.apply(this,arguments);}};return r.call(this,c1,d1);};}else if(r){q.ajax=r;}return o;};v["start"]=function(i,l,c1){if(!o){return;}c1=j(c1);if(!c1){return;}var d1=q.sap.now(),e1=new d(i,l,d1,0,c1);if(q.sap.log.getLevel("sap.ui.Performance")>=4&&a.console&&console.time){console.time(l+" - "+i);}if(e1){w[i]=e1;return this.getMeasurement(e1.id);}else{return false;}};v["pause"]=function(i){if(!o){return;}var l=q.sap.now();var c1=w[i];if(c1&&c1.end>0){return false;}if(c1&&c1.pause==0){c1.pause=l;if(c1.pause>=c1.resume&&c1.resume>0){c1.duration=c1.duration+c1.pause-c1.resume;c1.resume=0;}else if(c1.pause>=c1.start){c1.duration=c1.pause-c1.start;}}if(c1){return this.getMeasurement(c1.id);}else{return false;}};v["resume"]=function(i){if(!o){return;}var l=q.sap.now();var c1=w[i];if(c1&&c1.pause>0){c1.pause=0;c1.resume=l;}if(c1){return this.getMeasurement(c1.id);}else{return false;}};v["end"]=function(i){if(!o){return;}var l=q.sap.now();var c1=w[i];if(c1&&!c1.end){c1.end=l;if(c1.end>=c1.resume&&c1.resume>0){c1.duration=c1.duration+c1.end-c1.resume;c1.resume=0;}else if(c1.pause>0){c1.pause=0;}else if(c1.end>=c1.start){if(c1.average){c1.completeDuration+=(c1.end-c1.start);c1.count++;c1.duration=c1.completeDuration/c1.count;c1.start=l;}else{c1.duration=c1.end-c1.start;}}if(c1.end>=c1.start){c1.time=c1.end-c1.start;}}if(c1){if(q.sap.log.getLevel("sap.ui.Performance")>=4&&a.console&&console.timeEnd){console.timeEnd(c1.info+" - "+i);}return this.getMeasurement(i);}else{return false;}};v["clear"]=function(){w={};};v["remove"]=function(i){delete w[i];};v["add"]=function(i,l,c1,d1,e1,f1,g1){if(!o){return;}g1=j(g1);if(!g1){return false;}var h1=new d(i,l,c1,d1,g1);h1.time=e1;h1.duration=f1;if(h1){w[i]=h1;return this.getMeasurement(h1.id);}else{return false;}};v["average"]=function(i,l,c1){if(!o){return;}c1=j(c1);if(!c1){return;}var d1=w[i],e1=q.sap.now();if(!d1||!d1.average){this.start(i,l,c1);d1=w[i];d1.average=true;}else{if(!d1.end){d1.completeDuration+=(e1-d1.start);d1.count++;}d1.start=e1;d1.end=0;}return this.getMeasurement(d1.id);};this.getMeasurement=function(i){var l=w[i];if(l){var c1={};for(var d1 in l){c1[d1]=l[d1];}return c1;}else{return false;}};this.getAllMeasurements=function(i){return this.filterMeasurements(function(l){return l;},i);};this.filterMeasurements=function(){var l,c1,i=0,d1=[],e1=typeof arguments[i]==="function"?arguments[i++]:undefined,f1=typeof arguments[i]==="boolean"?arguments[i++]:undefined,g1=Array.isArray(arguments[i])?arguments[i]:[];for(var h1 in w){l=this.getMeasurement(h1);c1=(f1===false&&l.end===0)||(f1!==false&&(!f1||l.end));if(c1&&n(l,g1)&&(!e1||e1(l))){d1.push(l);}}return d1;};this.registerMethod=function(i,l,c1,d1){var e1=l[c1];if(e1&&typeof e1==="function"){var f1=s.indexOf(e1)>-1;if(!f1){O.push({func:e1,obj:l,method:c1,id:i});l[c1]=function(){q.sap.measure.average(i,i+" method average",d1);var g1=e1.apply(this,arguments);q.sap.measure.end(i);return g1;};s.push(l[c1]);return true;}}else{q.sap.log.debug(c1+" in not a function. jQuery.sap.measure.register failed");}return false;};this.unregisterMethod=function(i,l,c1){var d1=l[c1],e1=s.indexOf(d1);if(d1&&e1>-1){l[c1]=O[e1].func;s.splice(e1,1);O.splice(e1,1);return true;}return false;};this.unregisterAllMethods=function(){while(O.length>0){var i=O[0];this.unregisterMethod(i.id,i.obj,i.method);}};var N=[];var Q;this.getAllInteractionMeasurements=function(i){if(i){q.sap.measure.endInteraction(true);}return N;};this.filterInteractionMeasurements=function(c1){var d1=[];if(c1){for(var i=0,l=N.length;i<l;i++){if(c1(N[i])){d1.push(N[i]);}}}return d1;};this.getPendingInteractionMeasurement=function(){return Q;};this.clearInteractionMeasurements=function(){N=[];};function T(i){if(i.start>Q.start&&i.end<Q.end){return i;}}function U(i){return i.startTime>0&&i.startTime<=i.requestStart&&i.requestStart<=i.responseEnd;}function W(i){this.end=i.responseEnd>this.end?i.responseEnd:this.end;Q.requestTime+=(i.responseEnd-i.startTime);if(this.roundtripHigherLimit<=i.startTime){Q.navigation+=(this.navigationHigherLimit-this.navigationLowerLimit);Q.roundtrip+=(this.roundtripHigherLimit-this.roundtripLowerLimit);this.navigationLowerLimit=i.startTime;this.roundtripLowerLimit=i.startTime;}if(i.responseEnd>this.roundtripHigherLimit){this.roundtripHigherLimit=i.responseEnd;}if(i.requestStart>this.navigationHigherLimit){this.navigationHigherLimit=i.requestStart;}}function X(i){var l={start:i[0].startTime,end:i[0].responseEnd,navigationLowerLimit:i[0].startTime,navigationHigherLimit:i[0].requestStart,roundtripLowerLimit:i[0].startTime,roundtripHigherLimit:i[0].responseEnd};i.forEach(W,l);Q.navigation+=(l.navigationHigherLimit-l.navigationLowerLimit);Q.roundtrip+=(l.roundtripHigherLimit-l.roundtripLowerLimit);if(Q.networkTime){var c1=Q.requestTime-Q.networkTime;Q.networkTime=c1/i.length;}else{Q.networkTime=0;}if(Q.processing===0){var d1=Q.start-a.performance.timing.fetchStart;Q.duration=l.end-d1;Q.processing=l.start-d1;}}function Y(i){if(Q){Q.end=i;Q.duration=Q.processing;Q.requests=q.sap.measure.getRequestTimings();Q.incompleteRequests=0;Q.measurements=q.sap.measure.filterMeasurements(T,true);var l=Q.requests.filter(U);if(l.length>0){X(l);Q.incompleteRequests=Q.requests.length-l.length;}var c1=Q.processing-Q.navigation-Q.roundtrip;Q.processing=c1>-1?c1:0;N.push(Q);q.sap.log.info("Interaction step finished: trigger: "+Q.trigger+"; duration: "+Q.duration+"; requests: "+Q.requests.length,"jQuery.sap.measure");Q=null;}}function Z(i){var l,c1;if(i){var d1,e1;d1=sap.ui.require("sap/ui/core/Component");while(d1&&i&&i.getParent){e1=d1.getOwnerComponentFor(i);if(e1||i instanceof d1){e1=e1||i;var f1=e1.getManifestEntry("sap.app");l=f1&&f1.id||e1.getMetadata().getName();c1=f1&&f1.applicationVersion&&f1.applicationVersion.version;}i=i.getParent();}}return{id:l?l:"undetermined",version:c1?c1:""};}this.startInteraction=function(i,l){var c1=q.sap.now();if(Q){Y(c1);}this.clearRequestTimings();var d1=Z(l);Q={event:i,trigger:l&&l.getId?l.getId():"undetermined",component:d1.id,appVersion:d1.version,start:c1,end:0,navigation:0,roundtrip:0,processing:0,duration:0,requests:[],measurements:[],sapStatistics:[],requestTime:0,networkTime:0,bytesSent:0,bytesReceived:0,requestCompression:undefined,busyDuration:0};q.sap.log.info("Interaction step started: trigger: "+Q.trigger+"; type: "+Q.event,"jQuery.sap.measure");};this.endInteraction=function(i){if(Q){if(!i){Q.processing=q.sap.now()-Q.start;}else{Y(q.sap.now());}}};this.setRequestBufferSize=function(i){if(!a.performance){return;}if(a.performance.setResourceTimingBufferSize){a.performance.setResourceTimingBufferSize(i);}else if(a.performance.webkitSetResourceTimingBufferSize){a.performance.webkitSetResourceTimingBufferSize(i);}};this.getRequestTimings=function(){if(a.performance&&a.performance.getEntriesByType){return a.performance.getEntriesByType("resource");}return[];};this.clearRequestTimings=function(){if(!a.performance){return;}if(a.performance.clearResourceTimings){a.performance.clearResourceTimings();}else if(a.performance.webkitClearResourceTimings){a.performance.webkitClearResourceTimings();}};this.setRequestBufferSize(1000);var $=location.search.match(/sap-ui-measure=([^\&]*)/);if($&&$[1]){if($[1]==="true"||$[1]==="x"||$[1]==="X"){this.setActive(true);}else{this.setActive(true,$[1]);}}else{var a1=function(){return null;};for(var b1 in v){this[b1]=a1;}}}q.sap.measure=new P();function S(n,d,T){var i=[],o=0,j=0,s;this.startTask=function(m){var r=i.length;i[r]={name:m,finished:false};o++;return r;};this.finishTask=function(m,r){if(!i[m]||i[m].finished){throw new Error("trying to finish non existing or already finished task");}i[m].finished=true;o--;if(r===false){j++;}if(o===0){q.sap.log.info("Sync point '"+n+"' finished (tasks:"+i.length+", open:"+o+", failures:"+j+")");if(s){clearTimeout(s);s=null;}l();}};function l(){d&&d(o,j);d=null;}if(!isNaN(T)){s=setTimeout(function(){q.sap.log.info("Sync point '"+n+"' timed out (tasks:"+i.length+", open:"+o+", failures:"+j+")");l();},T);}q.sap.log.info("Sync point '"+n+"' created"+(T?"(timeout after "+T+" ms)":""));}q.sap.syncPoint=function(n,d,T){return new S(n,d,T);};var z=(function(){var o=q.sap.log.getLogger("sap.ui.ModuleSystem",(/sap-ui-xx-debug(M|-m)odule(L|-l)oading=(true|x|X)/.test(location.search)||u["xx-debugModuleLoading"])?q.sap.log.Level.DEBUG:q.sap.log.Level.INFO),U={'':{'url':'resources/'}},r=0,v=-1,w=1,N=2,O=3,R=4,Q=5,T={},W={},X={},Y=!(/(?:^|\?|&)sap-ui-(?:xx-)?preload=async(?:&|$)/.test(location.search)||u.preload==='async'||u['xx-preload']==='async'),Z={'sap/ui/thirdparty/blanket.js':{amd:true,exports:'blanket'},'sap/ui/thirdparty/caja-html-sanitizer.js':{amd:false,exports:'html'},'sap/ui/thirdparty/crossroads.js':{amd:true,exports:'crossroads',deps:['sap/ui/thirdparty/signals']},'sap/ui/thirdparty/d3.js':{amd:true,exports:'d3'},'sap/ui/thirdparty/datajs.js':{amd:true,exports:'OData'},'sap/ui/thirdparty/es6-promise.js':{amd:true,exports:'ES6Promise'},'sap/ui/thirdparty/flexie.js':{exports:'Flexie'},'sap/ui/thirdparty/handlebars.js':{amd:true,exports:'Handlebars'},'sap/ui/thirdparty/hasher.js':{amd:true,exports:'hasher',deps:['sap/ui/thirdparty/signals']},'sap/ui/thirdparty/IPv6.js':{amd:true,exports:'IPv6'},'sap/ui/thirdparty/iscroll-lite.js':{exports:'iScroll'},'sap/ui/thirdparty/iscroll.js':{exports:'iScroll'},'sap/ui/thirdparty/jquery.js':{amd:true},'sap/ui/thirdparty/jquery-mobile-custom.js':{amd:true,exports:'jQuery.mobile'},'sap/ui/thirdparty/jszip.js':{amd:true,exports:'JSZip'},'sap/ui/thirdparty/less.js':{amd:true,exports:'less'},'sap/ui/thirdparty/mobify-carousel.js':{exports:'Mobify'},'sap/ui/thirdparty/punycode.js':{amd:true,exports:'punycode'},'sap/ui/thirdparty/require.js':{exports:'define'},'sap/ui/thirdparty/SecondLevelDomains.js':{amd:true,exports:'SecondLevelDomains'},'sap/ui/thirdparty/signals.js':{amd:true,exports:'signals'},'sap/ui/thirdparty/sinon.js':{amd:true,exports:'sinon'},'sap/ui/thirdparty/sinon-server.js':{amd:true,exports:'sinon'},'sap/ui/thirdparty/unorm.js':{exports:'UNorm'},'sap/ui/thirdparty/unormdata.js':{exports:'UNorm',deps:['sap/ui/thirdparty/unorm']},'sap/ui/thirdparty/URI.js':{amd:true,exports:'URI'},'sap/ui/thirdparty/URITemplate.js':{amd:true,exports:'URITemplate',deps:['sap/ui/thirdparty/URI']},'sap/ui/thirdparty/vkbeautify.js':{exports:'vkbeautify'},'sap/ui/thirdparty/zyngascroll.js':{exports:'Scroller'},'sap/ui/demokit/js/esprima.js':{amd:true,exports:'esprima'},'sap/ui/thirdparty/RequestRecorder.js':{amd:true,exports:'RequestRecorder',deps:['sap/ui/thirdparty/URI','sap/ui/thirdparty/sinon']}},$=[],a1="",b1=512*1024,c1="fragment",d1="view",e1={js:[d1,c1,"controller","designtime"],xml:[d1,c1],json:[d1,c1],html:[d1,c1]},f1=new RegExp("(\\.(?:"+e1.js.join("|")+"))?\\.js$"),g1,h1;(function(){var s="",d="";q.each(e1,function(i,j){s=(s?s+"|":"")+i;d=(d?d+"|":"")+"(?:(?:"+j.join("\\.|")+"\\.)?"+i+")";});s="\\.("+s+")$";d="\\.(?:"+d+"|[^./]+)$";o.debug("constructed regexp for file types :"+s);o.debug("constructed regexp for file sub-types :"+d);g1=new RegExp(s);h1=new RegExp(d);}());var i1;(function(){var d=a["sap-ui-debug"];function m(j){if(!/\/\*\*\/$/.test(j)){j=j.replace(/\/$/,'/**/');}return j.replace(/\*\*\/|\*|[[\]{}()+?.\\^$|]/g,function(l){switch(l){case'**/':return'(?:[^/]+/)*';case'*':return'[^/]*';default:return'\\'+l;}});}if(typeof d==='string'){var s="^(?:"+d.split(/,/).map(m).join("|")+")",i=new RegExp(s);i1=function(j){return i.test(j);};o.debug("Modules that should be excluded from preload: '"+s+"'");}else if(d===true){i1=function(){return true;};o.debug("All modules should be excluded from preload");}})();function j1(d){this.name=d;this.state=r;this.url=this.loaded=this.data=this.group=null;this.content=T;}j1.prototype.ready=function(d,i){if(this.state===r){this.state=R;this.url=d;this.content=i;}return this;};j1.prototype.preload=function(d,i,j){if(this.state===r&&!(i1&&i1(this.name))){this.state=v;this.url=d;this.data=i;this.group=j;}return this;};j1.get=function(m){return W[m]||(W[m]=new j1(m));};j1.prototype.value=function(){if(this.state===R){if(this.content===T){var s=Z[this.name],d=s&&(Array.isArray(s.exports)?s.exports[0]:s.exports);this.content=q.sap.getObject(d||l1(this.name));}return this.content;}return;};j1.get("sap/ui/thirdparty/URI.js").ready(f,URI);j1.get("sap/ui/Device.js").ready(f,D);j1.get("jquery.sap.global.js").ready(f,q);function k1(s){if(/^jquery\.sap\./.test(s)){return s;}return s.replace(/\./g,"/");}function l1(s){if(!/\.js$/.test(s)){return;}s=s.slice(0,-3);if(/^jquery\.sap\./.test(s)){return s;}return s.replace(/\//g,".");}function m1(s,d){var i=s.split(/\//),l,j,x1,m;if(arguments.length===1&&i.length>0){m=h1.exec(i[i.length-1]);if(m){d=m[0];i[i.length-1]=i[i.length-1].slice(0,m.index);}else{d="";}}for(l=i.length;l>=0;l--){j=i.slice(0,l).join('/');if(U[j]){x1=U[j].url;if(l<i.length){x1+=i.slice(l).join('/');}if(x1.slice(-1)==='/'){x1=x1.slice(0,-1);}return x1+(d||'');}}}function n1(s){var d,i,j;s=c(s);for(d in U){if(U.hasOwnProperty(d)){i=U[d].absoluteUrl.slice(0,-1);if(s.indexOf(i)===0){j=d+s.slice(i.length);if(j.charAt(0)==='/'){j=j.slice(1);}if(W[j]&&W[j].data){return j;}}}}}function o1(d){if(!d.stack){try{throw d;}catch(i){return i.stack;}}return d.stack;}function p1(d,i){if(!D.browser.phantomJS){var j=o1(d);if(j&&i){d.stack=j+"\nCaused by: "+i;}}if(a.console&&!D.browser.chrome){console.error(d.message+"\nCaused by: "+i);}}var q1=/(?:^|\/)\.+/;var r1=/^\.*$/;function s1(s,d){var m=q1.exec(d),x1,y1,i,j,l;if(!m){return d;}if(m.index===0&&s==null){throw new Error("relative name not supported ('"+d+"'");}x1=(m.index===0?s+d:d).split('/');for(i=0,j=0,l=x1.length;i<l;i++){var y1=x1[i];if(r1.test(y1)){if(y1==='.'||y1===''){continue;}else if(y1==='..'){if(j===0){throw new Error("Can't navigate to parent of root (base='"+s+"', name='"+d+"'");}j--;}else{throw new Error("illegal path segment '"+y1+"'");}}else{x1[j++]=y1;}}x1.length=j;return x1.join('/');}function t1(m){var d;d=j1.get(m);if(d.state>r){return d;}if(o.isLoggable()){o.debug(a1+"declare module '"+m+"'");}d.state=R;if($.length===0){$.push(m);d.url=d.url||f;}return d;}function u1(d,s,j){var l=o.isLoggable(),m=f1.exec(s),x1=Z[s],y1,z1,A1,B1,i,C1;if(!m){throw new Error("can only require Javascript module, not "+s);}A1=j1.get(s);if(x1&&x1.deps&&!x1.deps.requested){if(l){o.debug("require dependencies of raw module "+s);}return w1(A1,x1.deps,function(){x1.deps.requested=true;return u1(d,s,j);},j);}y1=s.slice(0,m.index);z1=m[0];if(l){o.debug(a1+"require '"+s+"' of type '"+z1+"'");}if(A1.state!==r){if(A1.state===v){A1.state=N;q.sap.measure.start(s,"Require module "+s+" (preloaded)",["require"]);v1(s,j);q.sap.measure.end(s);}if(A1.state===R){if(l){o.debug(a1+"module '"+s+"' has already been loaded (skipped).");}return A1.value();}else if(A1.state===Q){var D1=new Error("found in negative cache: '"+s+"' from "+A1.url+": "+A1.errorMessage);p1(D1,A1.errorStack);throw D1;}else{return;}}q.sap.measure.start(s,"Require module "+s,["require"]);A1.state=w;B1=a["sap-ui-loaddbg"]?["-dbg",""]:[""];for(i=0;i<B1.length&&A1.state!==N;i++){A1.url=m1(y1,B1[i]+z1);if(l){o.debug(a1+"loading "+(B1[i]?B1[i]+" version of ":"")+"'"+s+"' from '"+A1.url+"'");}if(!j&&x&&s!=='sap/ui/core/Core.js'){C1="[nosync] loading module '"+A1.url+"'";if(x===1){o.error(C1);}else{throw new Error(C1);}}q.ajax({url:A1.url,dataType:'text',async:false,success:function(E1,F1,G1){A1.state=N;A1.data=E1;},error:function(E1,F1,G1){A1.state=Q;A1.errorMessage=E1?E1.status+" - "+E1.statusText:F1;A1.errorStack=G1&&G1.stack;A1.loadError=true;}});}if(A1.state===N){v1(s,j);}q.sap.measure.end(s);if(A1.state!==R){if(a["sap-ui-debug"]){q.sap.includeScript(A1.url);}var D1=new Error("failed to load '"+s+"' from "+A1.url+": "+A1.errorMessage);p1(D1,A1.errorStack);D1.loadError=A1.loadError;throw D1;}return A1.value();}function callPreloadWrapperFn(fn){callPreloadWrapperFn.count++;return fn.call(a);}callPreloadWrapperFn.count=0;function applyAMDFactoryFn(fn,dep){applyAMDFactoryFn.count++;return fn.apply(a,dep);}applyAMDFactoryFn.count=0;function evalModuleStr(script){evalModuleStr.count++;return a.eval(script);}evalModuleStr.count=0;function v1(m,d){var i=W[m],s=Z[m],l=o.isLoggable(),j,x1,y1,z1,A1;if(i&&i.state===N&&typeof i.data!=="undefined"){y1=(s===true||(s&&s.amd))&&typeof a.define==="function"&&a.define.amd;A1=Y;try{if(y1){delete a.define.amd;}Y=d;if(l){o.debug(a1+"executing '"+m+"'");j=a1;a1=a1+": ";}i.state=O;$.push(m);if(typeof i.data==="function"){callPreloadWrapperFn(i.data);}else if(Array.isArray(i.data)){sap.ui.define.apply(sap.ui,i.data);}else{x1=i.data;if(x1){z1=/\/\/[#@] source(Mapping)?URL=(.*)$/.exec(x1);if(z1&&z1[1]&&/[^/]+\.js\.map$/.test(z1[2])){x1=x1.slice(0,z1.index)+z1[0].slice(0,-z1[2].length)+URI(z1[2]).absoluteTo(i.url);}else if(!z1){x1+="\n//# sourceURL="+c(i.url);if(D.browser.safari||D.browser.chrome){x1+="?eval";}}}if(typeof q.sap.require._hook==="function"){x1=q.sap.require._hook(x1,m);}if(a.execScript&&(!i.data||i.data.length<b1)){try{i.data&&a.execScript(x1);}catch(e){$.pop();q.sap.globalEval(i.data);throw e;}}else{evalModuleStr(x1);}}$.pop();i.state=R;i.data=undefined;i.value();if(l){a1=j;o.debug(a1+"finished executing '"+m+"'");}}catch(B1){i.state=Q;i.errorStack=B1&&B1.stack;i.errorMessage=((B1.toString&&B1.toString())||B1.message)+(B1.line?"(line "+B1.line+")":"");i.data=undefined;}finally{if(y1){a.define.amd=y1;}Y=A1;}}}function w1(d,j,l,m){var s=[],x1=o.isLoggable(),y1,i,z1;y1=d&&d.name.slice(0,d.name.lastIndexOf('/')+1);j=j.slice();for(i=0;i<j.length;i++){j[i]=s1(y1,j[i])+".js";}for(i=0;i<j.length;i++){z1=j[i];if(x1){o.debug(a1+"require '"+z1+"'");}s[i]=u1(d,z1,m);if(x1){o.debug(a1+"require '"+z1+"': done.");}}return l(s);}q.sap.getModulePath=function(m,s){return m1(k1(m),s);};q.sap.getResourcePath=m1;q.sap.registerModulePath=function registerModulePath(m,d){m=m.replace(/\./g,"/");d=d||'.';q.sap.registerResourcePath(m,d);};q.sap.registerResourcePath=function registerResourcePath(s,d){function i(m,x1){return m.url===x1.url&&!m["final"]===!x1["final"];}s=String(s||"");if(typeof d==='string'||d instanceof String){d={'url':d};}var j=U[s];if(j&&j["final"]==true){if(!d||!i(j,d)){o.warning("registerResourcePath with prefix "+s+" already set as final to '"+j.url+"'. This call is ignored.");}return;}if(!d||d.url==null){if(j){delete U[s];o.info("registerResourcePath ('"+s+"') (registration removed)");}}else{d.url=String(d.url);var l=d.url.search(/[?#]/);if(l!==-1){d.url=d.url.slice(0,l);}if(d.url.slice(-1)!='/'){d.url+='/';}d.absoluteUrl=c(d.url);U[s]=d;if(!j||!i(j,d)){o.info("registerResourcePath ('"+s+"', '"+d.url+"')"+(d['final']?" (final)":""));}}};q.sap.registerModuleShims=function(s){for(var d in s){var i=s[d];if(Array.isArray(i)){i={deps:i};}Z[d+".js"]=i;}};q.sap.isDeclared=function isDeclared(m,i){m=k1(m)+".js";return W[m]&&(i||W[m].state!==v);};q.sap.isResourceLoaded=function isResourceLoaded(s){return!!W[s];};q.sap.getAllDeclaredModules=function(){var m=[];q.each(W,function(s,d){if(d&&d.state!==v){var i=l1(s);if(i){m.push(i);}}});return m;};if(u.resourceroots){q.each(u.resourceroots,q.sap.registerModulePath);}o.info("URL prefixes set to:");for(var n in U){o.info("  "+(n?"'"+n+"'":"(default)")+" : "+U[n].url+((U[n]['final'])?" (final)":""));}q.sap.declare=function(m,d){var s=m;if(typeof(m)==="object"){s=m.modName;m=k1(m.modName)+(m.type?"."+m.type:"")+".js";}else{m=k1(m)+".js";}t1(m);if(d!==false){q.sap.getObject(s,1);}};q.sap.require=function(m){if(arguments.length>1){for(var i=0;i<arguments.length;i++){q.sap.require(arguments[i]);}return this;}if(typeof(m)==="object"){m=k1(m.modName)+(m.type?"."+m.type:"")+".js";}else{m=k1(m)+".js";}u1(null,m,false);};a.sap=a.sap||{};sap.ui=sap.ui||{};sap.ui.define=function(m,d,i,j){var l=o.isLoggable(),s;if(typeof m==='string'){s=m+'.js';}else{j=i;i=d;d=m;s=$[$.length-1];}m=l1(s);if(!Array.isArray(d)){j=i;i=d;d=[];}if(l){o.debug("define("+s+", "+"['"+d.join("','")+"']"+")");}var x1=t1(s);x1.content=undefined;w1(x1,d,function(y1){if(l){o.debug("define("+s+"): calling factory "+typeof i);}if(j&&x!==2){var z1=s.split('/').slice(0,-1).join('.');if(z1){q.sap.getObject(z1,0);}}if(typeof i==='function'){x1.content=applyAMDFactoryFn(i,y1);}else{x1.content=i;}if(j&&x!==2){if(x1.content==null){o.error("module '"+s+"' returned no content, but should be exported");}else{if(l){o.debug("exporting content of '"+s+"': as global object");}q.sap.setObject(m,x1.content);}}},Y);};sap.ui.predefine=function(m,d,i,j){if(typeof m!=='string'){throw new Error("sap.ui.predefine requires a module name");}var s=m+'.js';j1.get(s).preload("<unknown>/"+m,[m,d,i,j],null);if(s.match(/\/library\.js$/)){X[l1(s)+"-preload"]=true;}};sap.ui.require=function(d,i){if(typeof d==='string'){return j1.get(d+'.js').value();}w1(null,d,function(m){if(typeof i==='function'){setTimeout(function(){i.apply(a,m);},0);}},true);};sap.ui.require.stat=function(s){var i=0;Object.keys(W).sort().forEach(function(m){if(W[m].state>=s){o.info((++i)+" "+m+" "+W[m].state);}});o.info("apply AMD factory function: #"+applyAMDFactoryFn.count);o.info("call preload wrapper function: #"+callPreloadWrapperFn.count);o.info("eval module string : #"+evalModuleStr.count);};sap.ui.requireSync=function(m){return u1(null,m+".js",false);};q.sap.preloadModules=function(s,d,i){var j,l,m;q.sap.log.error("[Deprecated] jQuery.sap.preloadModules was never a public API and will be removed soon. Migrate to Core.loadLibraries()!");if(!d&&x){m="[nosync] synchronous preload of '"+s+"'";if(x===1){o.warning(m);}else{throw new Error(m);}}if(X[s]){return;}X[s]=true;j=q.sap.getModulePath(s,".json");o.debug("preload file "+s);l=i&&i.startTask("load "+s);q.ajax({dataType:"json",async:d,url:j,success:function(x1){if(x1){q.sap.registerPreloadedModules(x1,j);if(Array.isArray(x1.dependencies)){x1.dependencies.forEach(function(y1){q.sap.preloadModules(y1,d,i);});}}i&&i.finishTask(l);},error:function(x1,y1,z1){o.error("failed to preload '"+s+"': "+(z1||y1));i&&i.finishTask(l,false);}});};q.sap.registerPreloadedModules=function(d){var i=V(d.version||"1.0").compareTo("2.0")<0;if(o.isLoggable()){o.debug(a1+"adding preloaded modules from '"+d.url+"'");}if(d.name){X[d.name]=true;}q.each(d.modules,function(s,j){s=i?k1(s)+".js":s;j1.get(s).preload(d.url+"/"+s,j,d.name);if(s.match(/\/library\.js$/)){X[l1(s)+"-preload"]=true;}});};q.sap.unloadResources=function(s,d,j,l){var m=[];if(d==null){d=true;}if(d){q.each(W,function(i,x1){if(x1&&x1.group===s){m.push(i);}});delete X[s];}else{if(W[s]){m.push(s);}}q.each(m,function(i,x1){var y1=W[x1];if(y1&&l&&x1.match(/\.js$/)){q.sap.setObject(l1(x1),undefined);}if(y1&&(j||y1.state===v)){delete W[x1];}});};q.sap.getResourceName=function(m,s){return k1(m)+(s==null?".js":s);};q.sap.loadResource=function(s,m){var i,j,l,x1,y1;if(typeof s==="string"){m=m||{};}else{m=s||{};s=m.name;if(!s&&m.url){s=n1(m.url);}}m=q.extend({failOnError:true,async:false},m);i=m.dataType;if(i==null&&s){i=(i=g1.exec(s))&&i[1];}y1=m.async?new q.Deferred():null;function z1(d,e){if(d==null&&m.failOnError){x1=e||new Error("no data returned for "+s);if(m.async){y1.reject(x1);q.sap.log.error(x1);}return null;}if(m.async){y1.resolve(d);}return d;}function A1(d){var B1=q.ajaxSettings.converters["text "+i];if(typeof B1==="function"){d=B1(d);}return z1(d);}if(s&&W[s]){j=W[s].data;W[s].state=N;}if(j!=null){if(m.async){setTimeout(function(){A1(j);},0);}else{j=A1(j);}}else{if(!m.async&&x){if(x>=1){o.error("[nosync] loading resource '"+(s||m.url)+"' with sync XHR");}else{throw new Error("[nosync] loading resource '"+(s||m.url)+"' with sync XHR");}}q.ajax({url:l=m.url||m1(s),async:m.async,dataType:i,headers:m.headers,success:function(d,B1,C1){j=z1(d);},error:function(d,B1,C1){x1=new Error("resource "+s+" could not be loaded from "+l+". Check for 'file not found' or parse errors. Reason: "+C1);x1.status=B1;x1.error=C1;x1.statusCode=d.status;j=z1(null,x1);}});}if(m.async){return Promise.resolve(y1);}if(x1!=null&&m.failOnError){throw x1;}return j;};q.sap._loadJSResourceAsync=function(s,i){var m=j1.get(s);if(!m.loaded){var d;var j=function(l){return new Promise(function(x1,y1){function z1(e){q.sap.log.info("Javascript resource loaded: "+s);d.removeEventListener('load',z1);d.removeEventListener('error',A1);m.state=R;x1();}function A1(e){d.removeEventListener('load',z1);d.removeEventListener('error',A1);if(l){o.warning("retry loading Javascript resource: "+s);}else{o.error("failed to load Javascript resource: "+s);m.state=Q;}y1();}var B1=m.url=m1(s);m.state=w;d=a.document.createElement('SCRIPT');d.src=B1;d.setAttribute("data-sap-ui-module",s);d.addEventListener('load',z1);d.addEventListener('error',A1);A(d);});};m.loaded=j(true).catch(function(e){if(d&&d.parentNode){d.parentNode.removeChild(d);}return j(false);});}if(i){return m.loaded.catch(function(){return undefined;});}return m.loaded;};return function(){var m={};q.each(U,function(s,d){m[s]=d.url;});return{modules:W,prefixes:m};};}());function A(o){var d=a.document.getElementsByTagName("head")[0];if(d){d.appendChild(o);}}function B(U,m,l,d){var s=a.document.createElement("script");s.src=U;s.type="text/javascript";if(m&&typeof m==="object"){Object.keys(m).forEach(function(j){if(m[j]!=null){s.setAttribute(j,m[j]);}});}if(l){q(s).load(function(){l();q(s).off("load");});}if(d){q(s).error(function(){d();q(s).off("error");});}var o,i=m&&m.id;if((i&&(o=q.sap.domById(i))&&o.tagName==="SCRIPT")){q(o).remove();}A(s);}q.sap.includeScript=function includeScript(U,i,l,d){if(typeof U==="string"){var m=typeof i==="string"?{id:i}:i;B(U,m,l,d);}else{if(U.id){U.attributes=U.attributes||{};U.attributes.id=U.id;}return new Promise(function(r,R){B(U.url,U.attributes,r,R);});}};function E(U,m,l,d){var i=function(U,m,l,d){var j=document.createElement("link");j.type="text/css";j.rel="stylesheet";j.href=U;if(m&&typeof m==="object"){Object.keys(m).forEach(function(v){if(m[v]!=null){j.setAttribute(v,m[v]);}});}var n=function(){q(j).attr("data-sap-ui-ready","false").off("error");if(d){d();}};var r=function(){q(j).attr("data-sap-ui-ready","true").off("load");if(l){l();}};if(D.browser.msie||D.browser.edge){var s=r;r=function(v){var R;try{R=v.target&&v.target.sheet&&v.target.sheet.rules;}catch(w){}if(R&&R.length>0){s();}else{n();}};}q(j).load(r);q(j).error(n);return j;};var o=q.sap.domById(m&&m.id);var j=i(U,m,l,d);if(o&&o.tagName==="LINK"&&o.rel==="stylesheet"){if(l||d||o.href!==j.href){if(o.getAttribute("data-sap-ui-foucmarker")===j.id){q(o).removeAttr("id").before(j);}else{q(o).replaceWith(j);}}else{if(o.getAttribute("data-sap-ui-foucmarker")===j.id){o.removeAttribute("data-sap-ui-foucmarker");}}}else{o=q('#sap-ui-core-customcss');if(o.length>0){o.first().before(j);}else{A(j);}}}q.sap.includeStyleSheet=function includeStyleSheet(U,i,l,d){if(typeof U==="string"){var m=typeof i==="string"?{id:i}:i;E(U,m,l,d);}else{if(U.id){U.attributes=U.attributes||{};U.attributes.id=U.id;}return new Promise(function(r,R){E(U.url,U.attributes,r,R);});}};if(!(u.productive===true||u.productive==="true"||u.productive==="x")){var L=false;document.addEventListener('keydown',function(e){try{if(e.keyCode===18){L=(typeof e.location!=="number"||e.location===1);return;}if(e.shiftKey&&e.altKey&&e.ctrlKey&&L){if(e.keyCode===80){sap.ui.require(['sap/ui/core/support/techinfo/TechnicalInfo'],function(T){T.open(function(){var i=z();return{modules:i.modules,prefixes:i.prefixes,config:u};});});}else if(e.keyCode===83){sap.ui.require(['sap/ui/core/support/Support'],function(d){var s=d.getStub();if(s.getType()!=d.StubType.APPLICATION){return;}s.openSupportTool();});}}}catch(o){}});}if(!q.support){q.support={};}q.extend(q.support,{touch:D.support.touch});var F=["Webkit","ms","Moz"];var H=document.documentElement.style;var I=function(d,j){if(q.support[d]===undefined){if(H[j]!==undefined){q.support[d]=true;if(j==="boxFlex"||j==="flexOrder"||j==="flexGrow"){if(!D.browser.chrome||D.browser.version>28){q.support.flexBoxPrefixed=false;}}return;}else{j=j.charAt(0).toUpperCase()+j.slice(1);for(var i in F){if(H[F[i]+j]!==undefined){q.support[d]=true;return;}}}q.support[d]=false;}};I("cssTransforms","transform");I("cssTransforms3d","perspective");I("cssTransitions","transition");I("cssAnimations","animationName");if(q.support.cssGradients===undefined){var K=document.createElement('div'),H=K.style;try{H.backgroundImage="linear-gradient(left top, red, white)";H.backgroundImage="-moz-linear-gradient(left top, red, white)";H.backgroundImage="-webkit-linear-gradient(left top, red, white)";H.backgroundImage="-ms-linear-gradient(left top, red, white)";H.backgroundImage="-webkit-gradient(linear, left top, right bottom, from(red), to(white))";}catch(e){}q.support.cssGradients=(H.backgroundImage&&H.backgroundImage.indexOf("gradient")>-1);K=null;}q.support.flexBoxPrefixed=true;I("flexBoxLayout","boxFlex");I("newFlexBoxLayout","flexGrow");if(!q.support.newFlexBoxLayout&&H.msFlexOrder!==undefined){q.support.ie10FlexBoxLayout=true;}else{q.support.ie10FlexBoxLayout=false;}if(q.support.flexBoxLayout||q.support.newFlexBoxLayout||q.support.ie10FlexBoxLayout){q.support.hasFlexBoxSupport=true;}else{q.support.hasFlexBoxSupport=false;}var M=function(s){this.mSettings=s||{};this.sMode=this.mSettings.mode||M.Mode.ALLOW;this.fnCallback=this.mSettings.callback;this.iTimeout=this.mSettings.timeout||10000;this.bBlockEvents=this.mSettings.blockEvents!==false;this.bShowBlockLayer=this.mSettings.showBlockLayer!==false;this.bAllowSameOrigin=this.mSettings.allowSameOrigin!==false;this.sParentOrigin='';this.bUnlocked=false;this.bRunnable=false;this.bParentUnlocked=false;this.bParentResponded=false;this.sStatus="pending";this.aFPChilds=[];var d=this;this.iTimer=setTimeout(function(){if(d.bRunnable&&d.bParentResponded&&!d.bParentUnlocked){q.sap.log.error("Reached timeout of "+d.iTimeout+"ms waiting for the parent to be unlocked","","jQuery.sap.FrameOptions");}else{q.sap.log.error("Reached timeout of "+d.iTimeout+"ms waiting for a response from parent window","","jQuery.sap.FrameOptions");}d._callback(false);},this.iTimeout);var i=function(){d._handlePostMessage.apply(d,arguments);};M.__window.addEventListener('message',i);if(M.__parent===M.__self||M.__parent==null||this.sMode===M.Mode.ALLOW){this._applyState(true,true);}else{this._lock();if(this.sMode===M.Mode.DENY){q.sap.log.error("Embedding blocked because configuration mode is set to 'DENY'","","jQuery.sap.FrameOptions");this._callback(false);return;}if(this.bAllowSameOrigin){try{var o=M.__parent;var O=false;var T=true;do{var j=o.document.domain;if(o==M.__top){if(j!=undefined){O=true;}break;}o=o.parent;}while(T);if(O){this._applyState(true,true);}}catch(e){this._sendRequireMessage();}}else{this._sendRequireMessage();}}};M.Mode={TRUSTED:'trusted',ALLOW:'allow',DENY:'deny'};M.__window=a;M.__parent=parent;M.__self=self;M.__top=top;M._events=["mousedown","mouseup","click","dblclick","mouseover","mouseout","touchstart","touchend","touchmove","touchcancel","keydown","keypress","keyup"];M.prototype.match=function(s,d){if(!(/\*/i.test(d))){return s==d;}else{d=d.replace(/\//gi,"\\/");d=d.replace(/\./gi,"\\.");d=d.replace(/\*/gi,".*");d=d.replace(/:\.\*$/gi,":\\d*");if(d.substr(d.length-1,1)!=='$'){d=d+'$';}if(d.substr(0,1)!=='^'){d='^'+d;}var r=new RegExp(d,'i');return r.test(s);}};M._lockHandler=function(o){o.stopPropagation();o.preventDefault();};M.prototype._createBlockLayer=function(){if(document.readyState=="complete"){var l=document.createElement("div");l.style.position="absolute";l.style.top="-1000px";l.style.bottom="-1000px";l.style.left="-1000px";l.style.right="-1000px";l.style.opacity="0";l.style.backgroundColor="white";l.style.zIndex=2147483647;document.body.appendChild(l);this._lockDiv=l;}};M.prototype._setCursor=function(){if(this._lockDiv){this._lockDiv.style.cursor=this.sStatus=="denied"?"not-allowed":"wait";}};M.prototype._lock=function(){var d=this;if(this.bBlockEvents){for(var i=0;i<M._events.length;i++){document.addEventListener(M._events[i],M._lockHandler,true);}}if(this.bShowBlockLayer){this._blockLayer=function(){d._createBlockLayer();d._setCursor();};if(document.readyState=="complete"){this._blockLayer();}else{document.addEventListener("readystatechange",this._blockLayer);}}};M.prototype._unlock=function(){if(this.bBlockEvents){for(var i=0;i<M._events.length;i++){document.removeEventListener(M._events[i],M._lockHandler,true);}}if(this.bShowBlockLayer){document.removeEventListener("readystatechange",this._blockLayer);if(this._lockDiv){document.body.removeChild(this._lockDiv);delete this._lockDiv;}}};M.prototype._callback=function(s){this.sStatus=s?"allowed":"denied";this._setCursor();clearTimeout(this.iTimer);if(typeof this.fnCallback==='function'){this.fnCallback.call(null,s);}};M.prototype._applyState=function(i,d){if(this.bUnlocked){return;}if(i){this.bRunnable=true;}if(d){this.bParentUnlocked=true;}if(!this.bRunnable||!this.bParentUnlocked){return;}this._unlock();this._callback(true);this._notifyChildFrames();this.bUnlocked=true;};M.prototype._applyTrusted=function(T){if(T){this._applyState(true,false);}else{this._callback(false);}};M.prototype._check=function(d){if(this.bRunnable){return;}var T=false;if(this.bAllowSameOrigin&&this.sParentOrigin&&M.__window.document.URL.indexOf(this.sParentOrigin)==0){T=true;}else if(this.mSettings.whitelist&&this.mSettings.whitelist.length!=0){var s=this.sParentOrigin.split('//')[1];s=s.split(':')[0];for(var i=0;i<this.mSettings.whitelist.length;i++){var m=s.indexOf(this.mSettings.whitelist[i]);if(m!=-1&&s.substring(m)==this.mSettings.whitelist[i]){T=true;break;}}}if(T){this._applyTrusted(T);}else if(this.mSettings.whitelistService){var j=this;var l=new XMLHttpRequest();var n=this.mSettings.whitelistService+'?parentOrigin='+encodeURIComponent(this.sParentOrigin);l.onreadystatechange=function(){if(l.readyState==4){j._handleXmlHttpResponse(l,d);}};l.open('GET',n,true);l.setRequestHeader('Accept','application/json');l.send();}else{q.sap.log.error("Embedding blocked because the whitelist or the whitelist service is not configured correctly","","jQuery.sap.FrameOptions");this._callback(false);}};M.prototype._handleXmlHttpResponse=function(d,i){if(d.status===200){var T=false;var r=d.responseText;var R=JSON.parse(r);if(R.active==false){this._applyState(true,true);}else if(i){return;}else{if(this.match(this.sParentOrigin,R.origin)){T=R.framing;}if(!T){q.sap.log.error("Embedding blocked because the whitelist service does not allow framing","","jQuery.sap.FrameOptions");}this._applyTrusted(T);}}else{q.sap.log.error("The configured whitelist service is not available: "+d.status,"","jQuery.sap.FrameOptions");this._callback(false);}};M.prototype._notifyChildFrames=function(){for(var i=0;i<this.aFPChilds.length;i++){this.aFPChilds[i].postMessage('SAPFrameProtection*parent-unlocked','*');}};M.prototype._sendRequireMessage=function(){M.__parent.postMessage('SAPFrameProtection*require-origin','*');if(this.mSettings.whitelistService){setTimeout(function(){if(!this.bParentResponded){this._check(true);}}.bind(this),10);}};M.prototype._handlePostMessage=function(o){var s=o.source,d=o.data;if(s===M.__self||s==null||typeof d!=="string"||d.indexOf("SAPFrameProtection*")===-1){return;}if(s===M.__parent){this.bParentResponded=true;if(!this.sParentOrigin){this.sParentOrigin=o.origin;this._check();}if(d=="SAPFrameProtection*parent-unlocked"){this._applyState(false,true);}}else if(s.parent===M.__self&&d=="SAPFrameProtection*require-origin"&&this.bUnlocked){s.postMessage("SAPFrameProtection*parent-unlocked","*");}else{s.postMessage("SAPFrameProtection*parent-origin","*");this.aFPChilds.push(s);}};q.sap.FrameOptions=M;}(jQuery,sap.ui.Device,window));
jQuery.sap.globalEval=function(){"use strict";eval(arguments[0]);};
