// This file has been generated by the SAPUI5 'AllInOne' Builder
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Device and Feature Detection API: Provides information about the used browser / device and cross platform support for certain events
 * like media queries, orientation change or resizing.
 *
 * This API is independent from any other part of the UI5 framework. This allows it to be loaded beforehand, if it is needed, to create the UI5 bootstrap
 * dynamically depending on the capabilities of the browser or device.
 *
 * @version 1.52.30
 * @namespace
 * @name sap.ui.Device
 * @public
 */

/*global console */

//Declare Module if API is available
if (window.jQuery && window.jQuery.sap && window.jQuery.sap.declare) {
	window.jQuery.sap.declare("sap.ui.Device", false);
}

//Introduce namespace if it does not yet exist
if (typeof window.sap !== "object" && typeof window.sap !== "function" ) {
	  window.sap = {};
}
if (typeof window.sap.ui !== "object") {
	window.sap.ui = {};
}

(function() {
	"use strict";

	//Skip initialization if API is already available
	if (typeof window.sap.ui.Device === "object" || typeof window.sap.ui.Device === "function" ) {
		var apiVersion = "1.52.30";
		window.sap.ui.Device._checkAPIVersion(apiVersion);
		return;
	}

	var device = {};

////-------------------------- Logging -------------------------------------
	/* since we cannot use the logging from jquery.sap.global.js, we need to come up with a seperate
	 * solution for the device API
	 */
	// helper function for date formatting
	function pad0(i,w) {
		return ("000" + String(i)).slice(-w);
	}

	var FATAL = 0, ERROR = 1, WARNING = 2, INFO = 3, DEBUG = 4, TRACE = 5;

	var deviceLogger = function() {
		this.defaultComponent = 'DEVICE';
		this.sWindowName = (window.top == window) ? "" : "[" + window.location.pathname.split('/').slice(-1)[0] + "] ";
	// Creates a new log entry depending on its level and component.
		this.log = function (iLevel, sMessage, sComponent) {
			sComponent = sComponent || this.defaultComponent  || '';
				var oNow = new Date(),
					oLogEntry = {
						time     : pad0(oNow.getHours(),2) + ":" + pad0(oNow.getMinutes(),2) + ":" + pad0(oNow.getSeconds(),2),
						date     : pad0(oNow.getFullYear(),4) + "-" + pad0(oNow.getMonth() + 1,2) + "-" + pad0(oNow.getDate(),2),
						timestamp: oNow.getTime(),
						level    : iLevel,
						message  : sMessage || "",
						component: sComponent || ""
					};
				/*eslint-disable no-console */
				if (window.console) { // in IE and FF, console might not exist; in FF it might even disappear
					var logText = oLogEntry.date + " " + oLogEntry.time + " " + this.sWindowName + oLogEntry.message + " - " + oLogEntry.component;
					switch (iLevel) {
					case FATAL:
					case ERROR: console.error(logText); break;
					case WARNING: console.warn(logText); break;
					case INFO: console.info ? console.info(logText) : console.log(logText); break;    // info not available in iOS simulator
					case DEBUG: console.debug ? console.debug(logText) : console.log(logText); break; // debug not available in IE, fallback to log
					case TRACE: console.trace ? console.trace(logText) : console.log(logText); break; // trace not available in IE, fallback to log (no trace)
					}
				}
				/*eslint-enable no-console */
				return oLogEntry;
		};
	};
// instantiate new logger
	var logger = new deviceLogger();
	logger.log(INFO, "Device API logging initialized");


//******** Version Check ********

	//Only used internal to make clear when Device API is loaded in wrong version
	device._checkAPIVersion = function(sVersion){
		var v = "1.52.30";
		if (v != sVersion) {
			logger.log(WARNING, "Device API version differs: " + v + " <-> " + sVersion);
		}
	};


//******** Event Management ******** (see Event Provider)

	var mEventRegistry = {};

	function attachEvent(sEventId, fnFunction, oListener) {
		if (!mEventRegistry[sEventId]) {
			mEventRegistry[sEventId] = [];
		}
		mEventRegistry[sEventId].push({oListener: oListener, fFunction:fnFunction});
	}

	function detachEvent(sEventId, fnFunction, oListener) {
		var aEventListeners = mEventRegistry[sEventId];

		if (!aEventListeners) {
			return this;
		}

		for (var i = 0, iL = aEventListeners.length; i < iL; i++) {
			if (aEventListeners[i].fFunction === fnFunction && aEventListeners[i].oListener === oListener) {
				aEventListeners.splice(i,1);
				break;
			}
		}
		if (aEventListeners.length == 0) {
			delete mEventRegistry[sEventId];
		}
	}

	function fireEvent(sEventId, mParameters) {
		var aEventListeners = mEventRegistry[sEventId], oInfo;
		if (aEventListeners) {
			aEventListeners = aEventListeners.slice();
			for (var i = 0, iL = aEventListeners.length; i < iL; i++) {
				oInfo = aEventListeners[i];
				oInfo.fFunction.call(oInfo.oListener || window, mParameters);
			}
		}
	}

//******** OS Detection ********

	/**
	 * Contains information about the operating system of the device.
	 *
	 * @namespace
	 * @name sap.ui.Device.os
	 * @public
	 */
	/**
	 * Enumeration containing the names of known operating systems.
	 *
	 * @namespace
	 * @name sap.ui.Device.os.OS
	 * @public
	 */
	/**
	 * The name of the operating system.
	 *
	 * @see sap.ui.Device.os.OS
	 * @name sap.ui.Device.os.name
	 * @type String
	 * @public
	 */
	/**
	 * The version of the operating system as <code>string</code>.
	 *
	 * Might be empty if no version can be determined.
	 *
	 * @name sap.ui.Device.os.versionStr
	 * @type String
	 * @public
	 */
	/**
	 * The version of the operating system as <code>float</code>.
	 *
	 * Might be <code>-1</code> if no version can be determined.
	 *
	 * @name sap.ui.Device.os.version
	 * @type float
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, a Windows operating system is used.
	 *
	 * @name sap.ui.Device.os.windows
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, a Linux operating system is used.
	 *
	 * @name sap.ui.Device.os.linux
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, a Mac operating system is used.
	 *
	 * @name sap.ui.Device.os.macintosh
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, an iOS operating system is used.
	 *
	 * @name sap.ui.Device.os.ios
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, an Android operating system is used.
	 *
	 * @name sap.ui.Device.os.android
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, a Blackberry operating system is used.
	 *
	 * @name sap.ui.Device.os.blackberry
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, a Windows Phone operating system is used.
	 *
	 * @name sap.ui.Device.os.windows_phone
	 * @type boolean
	 * @public
	 */

	/**
	 * Windows operating system name.
	 *
	 * @see sap.ui.Device.os.name
	 * @name sap.ui.Device.os.OS.WINDOWS
	 * @public
	 */
	/**
	 * MAC operating system name.
	 *
	 * @see sap.ui.Device.os.name
	 * @name sap.ui.Device.os.OS.MACINTOSH
	 * @public
	 */
	/**
	 * Linux operating system name.
	 *
	 * @see sap.ui.Device.os.name
	 * @name sap.ui.Device.os.OS.LINUX
	 * @public
	 */
	/**
	 * iOS operating system name.
	 *
	 * @see sap.ui.Device.os.name
	 * @name sap.ui.Device.os.OS.IOS
	 * @public
	 */
	/**
	 * Android operating system name.
	 *
	 * @see sap.ui.Device.os.name
	 * @name sap.ui.Device.os.OS.ANDROID
	 * @public
	 */
	/**
	 * Blackberry operating system name.
	 *
	 * @see sap.ui.Device.os.name
	 * @name sap.ui.Device.os.OS.BLACKBERRY
	 * @public
	 */
	/**
	 * Windows Phone operating system name.
	 *
	 * @see sap.ui.Device.os.name
	 * @name sap.ui.Device.os.OS.WINDOWS_PHONE
	 * @public
	 */

	var OS = {
		"WINDOWS": "win",
		"MACINTOSH": "mac",
		"LINUX": "linux",
		"IOS": "iOS",
		"ANDROID": "Android",
		"BLACKBERRY": "bb",
		"WINDOWS_PHONE": "winphone"
	};

	function getOS(userAgent){ // may return null!!

		userAgent = userAgent || navigator.userAgent;

		var platform, // regular expression for platform
			result;

		function getDesktopOS(){
			var pf = navigator.platform;
			if (pf.indexOf("Win") != -1 ) {
				// userAgent in windows 7 contains: windows NT 6.1
				// userAgent in windows 8 contains: windows NT 6.2 or higher
				// userAgent since windows 10: Windows NT 10[...]
				var rVersion = /Windows NT (\d+).(\d)/i;
				var uaResult = userAgent.match(rVersion);
				var sVersionStr = "";
				if (uaResult[1] == "6") {
					if (uaResult[2] == 1) {
						sVersionStr = "7";
					} else if (uaResult[2] > 1) {
						sVersionStr = "8";
					}
				} else {
					sVersionStr = uaResult[1];
				}
				return {"name": OS.WINDOWS, "versionStr": sVersionStr};
			} else if (pf.indexOf("Mac") != -1) {
				return {"name": OS.MACINTOSH, "versionStr": ""};
			} else if (pf.indexOf("Linux") != -1) {
				return {"name": OS.LINUX, "versionStr": ""};
			}
			logger.log(INFO, "OS detection returned no result");
			return null;
		}

		// Windows Phone. User agent includes other platforms and therefore must be checked first:
		platform = /Windows Phone (?:OS )?([\d.]*)/;
		result = userAgent.match(platform);
		if (result) {
			return ({"name": OS.WINDOWS_PHONE, "versionStr": result[1]});
		}

		// BlackBerry 10:
		if (userAgent.indexOf("(BB10;") > 0) {
			platform = /\sVersion\/([\d.]+)\s/;
			result = userAgent.match(platform);
			if (result) {
				return {"name": OS.BLACKBERRY, "versionStr": result[1]};
			} else {
				return {"name": OS.BLACKBERRY, "versionStr": '10'};
			}
		}

		// iOS, Android, BlackBerry 6.0+:
		platform = /\(([a-zA-Z ]+);\s(?:[U]?[;]?)([\D]+)((?:[\d._]*))(?:.*[\)][^\d]*)([\d.]*)\s/;
		result = userAgent.match(platform);
		if (result) {
			var appleDevices = /iPhone|iPad|iPod/;
			var bbDevices = /PlayBook|BlackBerry/;
			if (result[0].match(appleDevices)) {
				result[3] = result[3].replace(/_/g, ".");
				//result[1] contains info of devices
				return ({"name": OS.IOS, "versionStr": result[3]});
			} else if (result[2].match(/Android/)) {
				result[2] = result[2].replace(/\s/g, "");
				return ({"name": OS.ANDROID, "versionStr": result[3]});
			} else if (result[0].match(bbDevices)) {
				return ({"name": OS.BLACKBERRY, "versionStr": result[4]});
			}
		}

		//Firefox on Android
		platform = /\((Android)[\s]?([\d][.\d]*)?;.*Firefox\/[\d][.\d]*/;
		result = userAgent.match(platform);
		if (result) {
			return ({"name": OS.ANDROID, "versionStr": result.length == 3 ? result[2] : ""});
		}

		// Desktop
		return getDesktopOS();
	}

	function setOS(customUA) {
		device.os = getOS(customUA) || {};
		device.os.OS = OS;
		device.os.version = device.os.versionStr ? parseFloat(device.os.versionStr) : -1;

		if (device.os.name) {
			for (var b in OS) {
				if (OS[b] === device.os.name) {
					device.os[b.toLowerCase()] = true;
				}
			}
		}
	}
	setOS();
	// expose for unit test
	device._setOS = setOS;



//******** Browser Detection ********

	/**
	 * Contains information about the used browser.
	 *
	 * @namespace
	 * @name sap.ui.Device.browser
	 * @public
	 */

	/**
	 * Enumeration containing the names of known browsers.
	 *
	 * @namespace
	 * @name sap.ui.Device.browser.BROWSER
	 * @public
	 */

	/**
	 * The name of the browser.
	 *
	 * @see sap.ui.Device.browser.BROWSER
	 * @name sap.ui.Device.browser.name
	 * @type String
	 * @public
	 */
	/**
	 * The version of the browser as <code>string</code>.
	 *
	 * Might be empty if no version can be determined.
	 *
	 * @name sap.ui.Device.browser.versionStr
	 * @type String
	 * @public
	 */
	/**
	 * The version of the browser as <code>float</code>.
	 *
	 * Might be <code>-1</code> if no version can be determined.
	 *
	 * @name sap.ui.Device.browser.version
	 * @type float
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the mobile variant of the browser is used or
	 * a tablet or phone device is detected.
	 *
	 * <b>Note:</b> This information might not be available for all browsers.
	 *
	 * @name sap.ui.Device.browser.mobile
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the Microsoft Internet Explorer browser is used.
	 *
	 * @name sap.ui.Device.browser.internet_explorer
	 * @type boolean
	 * @deprecated since 1.20, use {@link sap.ui.Device.browser.msie} instead.
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the Microsoft Internet Explorer browser is used.
	 *
	 * @name sap.ui.Device.browser.msie
	 * @type boolean
	 * @since 1.20.0
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the Microsoft Edge browser is used.
	 *
	 * @name sap.ui.Device.browser.edge
	 * @type boolean
	 * @since 1.30.0
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the Mozilla Firefox browser is used.
	 *
	 * @name sap.ui.Device.browser.firefox
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the Google Chrome browser is used.
	 *
	 * @name sap.ui.Device.browser.chrome
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the Apple Safari browser is used.
	 *
	 * <b>Note:</b>
	 * This flag is also <code>true</code> when the standalone (fullscreen) mode or webview is used on iOS devices.
	 * Please also note the flags {@link sap.ui.Device.browser.fullscreen} and {@link sap.ui.Device.browser.webview}.
	 *
	 * @name sap.ui.Device.browser.safari
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, a browser featuring a Webkit engine is used.
	 *
	 * @name sap.ui.Device.browser.webkit
	 * @type boolean
	 * @since 1.20.0
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the Safari browser runs in standalone fullscreen mode on iOS.
	 *
	 * <b>Note:</b> This flag is only available if the Safari browser was detected. Furthermore, if this mode is detected,
	 * technically not a standard Safari is used. There might be slight differences in behavior and detection, e.g.
	 * the availability of {@link sap.ui.Device.browser.version}.
	 *
	 * @name sap.ui.Device.browser.fullscreen
	 * @type boolean
	 * @since 1.31.0
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the Safari browser runs in webview mode on iOS.
	 *
	 * <b>Note:</b> This flag is only available if the Safari browser was detected. Furthermore, if this mode is detected,
	 * technically not a standard Safari is used. There might be slight differences in behavior and detection, e.g.
	 * the availability of {@link sap.ui.Device.browser.version}.
	 *
	 * @name sap.ui.Device.browser.webview
	 * @type boolean
	 * @since 1.31.0
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the Phantom JS browser is used.
	 *
	 * @name sap.ui.Device.browser.phantomJS
	 * @type boolean
	 * @private
	 */
	/**
	 * The version of the used Webkit engine, if available.
	 *
	 * @see sap.ui.Device.browser.webkit
	 * @name sap.ui.Device.browser.webkitVersion
	 * @type String
	 * @since 1.20.0
	 * @private
	 */
	/**
	 * If this flag is set to <code>true</code>, a browser featuring a Mozilla engine is used.
	 *
	 * @name sap.ui.Device.browser.mozilla
	 * @type boolean
	 * @since 1.20.0
	 * @public
	 */
	/**
	 * Internet Explorer browser name.
	 *
	 * @see sap.ui.Device.browser.name
	 * @name sap.ui.Device.browser.BROWSER.INTERNET_EXPLORER
	 * @public
	 */
	/**
	 * Edge browser name.
	 *
	 * @see sap.ui.Device.browser.name
	 * @name sap.ui.Device.browser.BROWSER.EDGE
	 * @since 1.28.0
	 * @public
	 */
	/**
	 * Firefox browser name.
	 *
	 * @see sap.ui.Device.browser.name
	 * @name sap.ui.Device.browser.BROWSER.FIREFOX
	 * @public
	 */
	/**
	 * Chrome browser name.
	 *
	 * @see sap.ui.Device.browser.name
	 * @name sap.ui.Device.browser.BROWSER.CHROME
	 * @public
	 */
	/**
	 * Safari browser name.
	 *
	 * @see sap.ui.Device.browser.name
	 * @name sap.ui.Device.browser.BROWSER.SAFARI
	 * @public
	 */
	/**
	 * Android stock browser name.
	 *
	 * @see sap.ui.Device.browser.name
	 * @name sap.ui.Device.browser.BROWSER.ANDROID
	 * @public
	 */

	var BROWSER = {
		"INTERNET_EXPLORER": "ie",
		"EDGE": "ed",
		"FIREFOX": "ff",
		"CHROME": "cr",
		"SAFARI": "sf",
		"ANDROID": "an"
	};

	var ua = navigator.userAgent;

	/*!
	 * Taken from jQuery JavaScript Library v1.7.1
	 * http://jquery.com/
	 *
	 * Copyright 2011, John Resig
	 * Dual licensed under the MIT or GPL Version 2 licenses.
	 * http://jquery.org/license
	 *
	 * Includes Sizzle.js
	 * http://sizzlejs.com/
	 * Copyright 2011, The Dojo Foundation
	 * Released under the MIT, BSD, and GPL Licenses.
	 *
	 * Date: Mon Nov 21 21:11:03 2011 -0500
	 */
	function calcBrowser(customUa){
		var _ua = (customUa || ua).toLowerCase(); // use custom user-agent if given

		var rwebkit = /(webkit)[ \/]([\w.]+)/;
		var ropera = /(opera)(?:.*version)?[ \/]([\w.]+)/;
		var rmsie = /(msie) ([\w.]+)/;
		var rmsie11 = /(trident)\/[\w.]+;.*rv:([\w.]+)/;
		var redge = /(edge)[ \/]([\w.]+)/;
		var rmozilla = /(mozilla)(?:.*? rv:([\w.]+))?/;

		// WinPhone IE11 and MS Edge userAgents contain "WebKit" and "Mozilla" and therefore must be checked first
		var browserMatch = redge.exec( _ua ) ||
					rmsie11.exec( _ua ) ||
					rwebkit.exec( _ua ) ||
					ropera.exec( _ua ) ||
					rmsie.exec( _ua ) ||
					_ua.indexOf("compatible") < 0 && rmozilla.exec( _ua ) ||
					[];

		var res = { browser: browserMatch[1] || "", version: browserMatch[2] || "0" };
		res[res.browser] = true;
		return res;
	}

	function getBrowser(customUa, customNav) {
		var b = calcBrowser(customUa);
		var _ua = customUa || ua;
		var _navigator = customNav || window.navigator;

		// jQuery checks for user agent strings. We differentiate between browsers
		var oExpMobile;
		if ( b.mozilla ) {
			oExpMobile = /Mobile/;
			if ( _ua.match(/Firefox\/(\d+\.\d+)/) ) {
				var version = parseFloat(RegExp.$1);
				return {
					name: BROWSER.FIREFOX,
					versionStr: "" + version,
					version: version,
					mozilla: true,
					mobile: oExpMobile.test(_ua)
				};
			} else {
				// unknown mozilla browser
				return {
					mobile: oExpMobile.test(_ua),
					mozilla: true,
					version: -1
				};
			}
		} else if ( b.webkit ) {
			// webkit version is needed for calculation if the mobile android device is a tablet (calculation of other mobile devices work without)
			var regExpWebkitVersion = _ua.toLowerCase().match(/webkit[\/]([\d.]+)/);
			var webkitVersion;
			if (regExpWebkitVersion) {
				webkitVersion = regExpWebkitVersion[1];
			}
			oExpMobile = /Mobile/;
			if ( _ua.match(/(Chrome|CriOS)\/(\d+\.\d+).\d+/)) {
				var version = parseFloat(RegExp.$2);
				return {
					name: BROWSER.CHROME,
					versionStr: "" + version,
					version: version,
					mobile: oExpMobile.test(_ua),
					webkit: true,
					webkitVersion: webkitVersion
				};
			} else if ( _ua.match(/FxiOS\/(\d+\.\d+)/)) {
				var version = parseFloat(RegExp.$1);
				return {
					name: BROWSER.FIREFOX,
					versionStr: "" + version,
					version: version,
					mobile: true,
					webkit: true,
					webkitVersion: webkitVersion
				};
			} else if ( _ua.match(/Android .+ Version\/(\d+\.\d+)/) ) {
				var version = parseFloat(RegExp.$1);
				return {
					name: BROWSER.ANDROID,
					versionStr: "" + version,
					version: version,
					mobile: oExpMobile.test(_ua),
					webkit: true,
					webkitVersion: webkitVersion
				};
			} else { // Safari might have an issue with _ua.match(...); thus changing
				var oExp = /(Version|PhantomJS)\/(\d+\.\d+).*Safari/;
				var bStandalone = _navigator.standalone;
				if (oExp.test(_ua)) {
					var aParts = oExp.exec(_ua);
					var version = parseFloat(aParts[2]);
					return {
						name: BROWSER.SAFARI,
						versionStr: "" + version,
						fullscreen: false,
						webview: false,
						version: version,
						mobile: oExpMobile.test(_ua),
						webkit: true,
						webkitVersion: webkitVersion,
						phantomJS: aParts[1] === "PhantomJS"
					};
				} else if (/iPhone|iPad|iPod/.test(_ua) && !(/CriOS/.test(_ua)) && !(/FxiOS/.test(_ua)) && (bStandalone === true || bStandalone === false)) {
					//WebView or Standalone mode on iOS
					return {
						name: BROWSER.SAFARI,
						version: -1,
						fullscreen: bStandalone,
						webview: !bStandalone,
						mobile: oExpMobile.test(_ua),
						webkit: true,
						webkitVersion: webkitVersion
					};
				} else { // other webkit based browser
					return {
						mobile: oExpMobile.test(_ua),
						webkit: true,
						webkitVersion: webkitVersion,
						version: -1
					};
				}
			}
		} else if ( b.msie || b.trident ) {
			var version;
			// recognize IE8 when running in compat mode (only then the documentMode property is there)
			if (document.documentMode && !customUa) { // only use the actual documentMode when no custom user-agent was given
				if (document.documentMode === 7) { // OK, obviously we are IE and seem to be 7... but as documentMode is there this cannot be IE7!
					version = 8.0;
				} else {
					version = parseFloat(document.documentMode);
				}
			} else {
				version = parseFloat(b.version);
			}
			return {
				name: BROWSER.INTERNET_EXPLORER,
				versionStr: "" + version,
				version: version,
				msie: true,
				mobile: false // TODO: really?
			};
		} else if ( b.edge ) {
			var version = version = parseFloat(b.version);
			return {
				name: BROWSER.EDGE,
				versionStr: "" + version,
				version: version,
				edge: true
			};
		}
		return {
			name: "",
			versionStr: "",
			version: -1,
			mobile: false
		};
	}
	device._testUserAgent = getBrowser; // expose the user-agent parsing (mainly for testing), but don't let it be overwritten

	function setBrowser() {
		device.browser = getBrowser();
		device.browser.BROWSER = BROWSER;

		if (device.browser.name) {
			for (var b in BROWSER) {
				if (BROWSER[b] === device.browser.name) {
					device.browser[b.toLowerCase()] = true;
				}
			}
		}
	}
	setBrowser();




//******** Support Detection ********

	/**
	 * Contains information about detected capabilities of the used browser or device.
	 *
	 * @namespace
	 * @name sap.ui.Device.support
	 * @public
	 */

	/**
	 * If this flag is set to <code>true</code>, the used browser supports touch events.
	 *
	 * <b>Note:</b> This flag indicates whether the used browser supports touch events or not.
	 * This does not necessarily mean that the used device has a touchable screen.
	 *
	 * @name sap.ui.Device.support.touch
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the used browser supports pointer events.
	 *
	 * @name sap.ui.Device.support.pointer
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the used browser natively supports media queries via JavaScript.
	 *
	 * <b>Note:</b> The {@link sap.ui.Device.media media queries API} of the device API can also be used when there is no native support.
	 *
	 * @name sap.ui.Device.support.matchmedia
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the used browser natively supports events of media queries via JavaScript.
	 *
	 * <b>Note:</b> The {@link sap.ui.Device.media media queries API} of the device API can also be used when there is no native support.
	 *
	 * @name sap.ui.Device.support.matchmedialistener
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the used browser natively supports the <code>orientationchange</code> event.
	 *
	 * <b>Note:</b> The {@link sap.ui.Device.orientation orientation event} of the device API can also be used when there is no native support.
	 *
	 * @name sap.ui.Device.support.orientation
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the device has a display with a high resolution.
	 *
	 * @name sap.ui.Device.support.retina
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the used browser supports web sockets.
	 *
	 * @name sap.ui.Device.support.websocket
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the used browser supports the <code>placeholder</code> attribute on <code>input</code> elements.
	 *
	 * @name sap.ui.Device.support.input.placeholder
	 * @type boolean
	 * @public
	 */

	device.support = {};

	//Maybe better to but this on Device.browser because there are cases that a browser can touch but a device can't!
	//Chrome 70 removes the 'ontouchstart' from window for device with and without touch screen. Therefore we need to
	//use maxTouchPoints to check whether the device support touch interaction
	device.support.touch = !!(('ontouchstart' in window) || (navigator.maxTouchPoints > 0) || (window.DocumentTouch && document instanceof window.DocumentTouch));

	// FIXME: PhantomJS doesn't support touch events but exposes itself as touch
	//        enabled browser. Therfore we manually override that in jQuery.support!
	//        This has been tested with PhantomJS 1.9.7 and 2.0.0!
	if (device.browser.phantomJS) {
		device.support.touch = false;
	}

	device.support.pointer = !!window.PointerEvent;

	device.support.matchmedia = !!window.matchMedia;
	var m = device.support.matchmedia ? window.matchMedia("all and (max-width:0px)") : null; //IE10 doesn't like empty string as argument for matchMedia, FF returns null when running within an iframe with display:none
	device.support.matchmedialistener = !!(m && m.addListener);
	if (device.browser.safari && device.browser.version < 6 && !device.browser.fullscreen && !device.browser.webview) {
		//Safari seems to have addListener but no events are fired ?!
		device.support.matchmedialistener = false;
	}

	device.support.orientation = !!("orientation" in window && "onorientationchange" in window);

	device.support.retina = (window.retina || window.devicePixelRatio >= 2);

	device.support.websocket = ('WebSocket' in window);

	device.support.input = {};
	device.support.input.placeholder = ('placeholder' in document.createElement("input"));

//******** Match Media ********

	/**
	 * Event API for screen width changes.
	 *
	 * This API is based on media queries but can also be used if media queries are not natively supported by the used browser.
	 * In this case, the behavior of media queries is simulated by this API.
	 *
	 * There are several predefined {@link sap.ui.Device.media.RANGESETS range sets} available. Each of them defines a
	 * set of intervals for the screen width (from small to large). Whenever the screen width changes and the current screen width is in
	 * a different interval to the one before the change, the registered event handlers for the range set are called.
	 *
	 * If needed, it is also possible to define a custom set of intervals.
	 *
	 * The following example shows a typical use case:
	 * <pre>
	 * function sizeChanged(mParams) {
	 *     switch(mParams.name) {
	 *         case "Phone":
	 *             // Do what is needed for a little screen
	 *             break;
	 *         case "Tablet":
	 *             // Do what is needed for a medium sized screen
	 *             break;
	 *         case "Desktop":
	 *             // Do what is needed for a large screen
	 *     }
	 * }
	 *
	 * // Register an event handler to changes of the screen size
	 * sap.ui.Device.media.attachHandler(sizeChanged, null, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
	 * // Do some initialization work based on the current size
	 * sizeChanged(sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD));
	 * </pre>
	 *
	 * @namespace
	 * @name sap.ui.Device.media
	 * @public
	 */
	device.media = {};

	/**
	 * Enumeration containing the names and settings of predefined screen width media query range sets.
	 *
	 * @namespace
	 * @name sap.ui.Device.media.RANGESETS
	 * @public
	 */

	/**
	 * A 3-step range set (S-L).
	 *
	 * The ranges of this set are:
	 * <ul>
	 * <li><code>"S"</code>: For screens smaller than 520 pixels.</li>
	 * <li><code>"M"</code>: For screens greater than or equal to 520 pixels and smaller than 960 pixels.</li>
	 * <li><code>"L"</code>: For screens greater than or equal to 960 pixels.</li>
	 * </ul>
	 *
	 * To use this range set, you must initialize it explicitly ({@link sap.ui.Device.media.initRangeSet}).
	 *
	 * If this range set is initialized, a CSS class is added to the page root (<code>html</code> tag) which indicates the current
	 * screen width range: <code>sapUiMedia-3Step-<i>NAME_OF_THE_INTERVAL</i></code>.
	 *
	 * @name sap.ui.Device.media.RANGESETS.SAP_3STEPS
	 * @public
	 */
	/**
	 * A 4-step range set (S-XL).
	 *
	 * The ranges of this set are:
	 * <ul>
	 * <li><code>"S"</code>: For screens smaller than 520 pixels.</li>
	 * <li><code>"M"</code>: For screens greater than or equal to 520 pixels and smaller than 760 pixels.</li>
	 * <li><code>"L"</code>: For screens greater than or equal to 760 pixels and smaller than 960 pixels.</li>
	 * <li><code>"XL"</code>: For screens greater than or equal to 960 pixels.</li>
	 * </ul>
	 *
	 * To use this range set, you must initialize it explicitly ({@link sap.ui.Device.media.initRangeSet}).
	 *
	 * If this range set is initialized, a CSS class is added to the page root (<code>html</code> tag) which indicates the current
	 * screen width range: <code>sapUiMedia-4Step-<i>NAME_OF_THE_INTERVAL</i></code>.
	 *
	 * @name sap.ui.Device.media.RANGESETS.SAP_4STEPS
	 * @public
	 */
	/**
	 * A 6-step range set (XS-XXL).
	 *
	 * The ranges of this set are:
	 * <ul>
	 * <li><code>"XS"</code>: For screens smaller than 241 pixels.</li>
	 * <li><code>"S"</code>: For screens greater than or equal to 241 pixels and smaller than 400 pixels.</li>
	 * <li><code>"M"</code>: For screens greater than or equal to 400 pixels and smaller than 541 pixels.</li>
	 * <li><code>"L"</code>: For screens greater than or equal to 541 pixels and smaller than 768 pixels.</li>
	 * <li><code>"XL"</code>: For screens greater than or equal to 768 pixels and smaller than 960 pixels.</li>
	 * <li><code>"XXL"</code>: For screens greater than or equal to 960 pixels.</li>
	 * </ul>
	 *
	 * To use this range set, you must initialize it explicitly ({@link sap.ui.Device.media.initRangeSet}).
	 *
	 * If this range set is initialized, a CSS class is added to the page root (<code>html</code> tag) which indicates the current
	 * screen width range: <code>sapUiMedia-6Step-<i>NAME_OF_THE_INTERVAL</i></code>.
	 *
	 * @name sap.ui.Device.media.RANGESETS.SAP_6STEPS
	 * @public
	 */
	/**
	 * A 3-step range set (Phone, Tablet, Desktop).
	 *
	 * The ranges of this set are:
	 * <ul>
	 * <li><code>"Phone"</code>: For screens smaller than 600 pixels.</li>
	 * <li><code>"Tablet"</code>: For screens greater than or equal to 600 pixels and smaller than 1024 pixels.</li>
	 * <li><code>"Desktop"</code>: For screens greater than or equal to 1024 pixels.</li>
	 * </ul>
	 *
	 * This range set is initialized by default. An initialization via {@link sap.ui.Device.media.initRangeSet} is not needed.
	 *
	 * A CSS class is added to the page root (<code>html</code> tag) which indicates the current
	 * screen width range: <code>sapUiMedia-Std-<i>NAME_OF_THE_INTERVAL</i></code>.
	 * Furthermore there are 5 additional CSS classes to hide elements based on the width of the screen:
	 * <ul>
	 * <li><code>sapUiHideOnPhone</code>: Will be hidden if the screen has 600px or more</li>
	 * <li><code>sapUiHideOnTablet</code>: Will be hidden if the screen has less than 600px or more than 1023px</li>
	 * <li><code>sapUiHideOnDesktop</code>: Will be hidden if the screen is smaller than 1024px</li>
	 * <li><code>sapUiVisibleOnlyOnPhone</code>: Will be visible if the screen has less than 600px</li>
	 * <li><code>sapUiVisibleOnlyOnTablet</code>: Will be visible if the screen has 600px or more but less than 1024px</li>
	 * <li><code>sapUiVisibleOnlyOnDesktop</code>: Will be visible if the screen has 1024px or more</li>
	 * </ul>
	 *
	 * @name sap.ui.Device.media.RANGESETS.SAP_STANDARD
	 * @public
	 */

	/**
	 * A 4-step range set (Phone, Tablet, Desktop, LargeDesktop).
	 *
	 * The ranges of this set are:
	 * <ul>
	 * <li><code>"Phone"</code>: For screens smaller than 600 pixels.</li>
	 * <li><code>"Tablet"</code>: For screens greater than or equal to 600 pixels and smaller than 1024 pixels.</li>
	 * <li><code>"Desktop"</code>: For screens greater than or equal to 1024 pixels and smaller than 1440 pixels.</li>
	 * <li><code>"LargeDesktop"</code>: For screens greater than or equal to 1440 pixels.</li>
	 * </ul>
	 *
	 * This range set is initialized by default. An initialization via {@link sap.ui.Device.media.initRangeSet} is not needed.
	 *
	 * A CSS class is added to the page root (<code>html</code> tag) which indicates the current
	 * screen width range: <code>sapUiMedia-StdExt-<i>NAME_OF_THE_INTERVAL</i></code>.
	 *
	 * @name sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED
	 * @public
	 */

	var RANGESETS = {
		"SAP_3STEPS": "3Step",
		"SAP_4STEPS": "4Step",
		"SAP_6STEPS": "6Step",
		"SAP_STANDARD": "Std",
		"SAP_STANDARD_EXTENDED": "StdExt"
	};
	device.media.RANGESETS = RANGESETS;
	device.media._predefinedRangeSets = {};
	device.media._predefinedRangeSets[RANGESETS.SAP_3STEPS] = {points: [520, 960], unit: "px", name: RANGESETS.SAP_3STEPS, names: ["S", "M", "L"]};
	device.media._predefinedRangeSets[RANGESETS.SAP_4STEPS] = {points: [520, 760, 960], unit: "px", name: RANGESETS.SAP_4STEPS, names: ["S", "M", "L", "XL"]};
	device.media._predefinedRangeSets[RANGESETS.SAP_6STEPS] = {points: [241, 400, 541, 768, 960], unit: "px", name: RANGESETS.SAP_6STEPS, names: ["XS", "S", "M", "L", "XL", "XXL"]};
	device.media._predefinedRangeSets[RANGESETS.SAP_STANDARD] = {points: [600, 1024], unit: "px", name: RANGESETS.SAP_STANDARD, names: ["Phone", "Tablet", "Desktop"]};
	device.media._predefinedRangeSets[RANGESETS.SAP_STANDARD_EXTENDED] = {points: [600, 1024, 1440], unit: "px", name: RANGESETS.SAP_STANDARD_EXTENDED, names: ["Phone", "Tablet", "Desktop", "LargeDesktop"]};
	var _defaultRangeSet = RANGESETS.SAP_STANDARD;
	var media_timeout = device.support.matchmedialistener ? 0 : 100;
	var _querysets = {};
	var media_currentwidth = null;

	function getQuery(from, to, unit){
		unit = unit || "px";
		var q = "all";
		if (from > 0) {
			q = q + " and (min-width:" + from + unit + ")";
		}
		if (to > 0) {
			q = q + " and (max-width:" + to + unit + ")";
		}
		return q;
	}

	function handleChange(name){
		if (!device.support.matchmedialistener && media_currentwidth == windowSize()[0]) {
			return; //Skip unnecessary resize events
		}

		if (_querysets[name].timer) {
			clearTimeout(_querysets[name].timer);
			_querysets[name].timer = null;
		}

		_querysets[name].timer = setTimeout(function() {
			var mParams = checkQueries(name, false);
			if (mParams) {
				fireEvent("media_" + name, mParams);
			}
		}, media_timeout);
	}

	function getRangeInfo(sSetName, iRangeIdx){
		var q = _querysets[sSetName].queries[iRangeIdx];
		var info = {from: q.from, unit: _querysets[sSetName].unit};
		if (q.to >= 0) {
			info.to = q.to;
		}
		if (_querysets[sSetName].names) {
			info.name = _querysets[sSetName].names[iRangeIdx];
		}
		return info;
	}

	function checkQueries(name, infoOnly, fnMatches){
		fnMatches = fnMatches || device.media.matches;
		if (_querysets[name]) {
			var aQueries = _querysets[name].queries;
			var info = null;
			for (var i = 0, len = aQueries.length; i < len; i++) {
				var q = aQueries[i];
				if ((q != _querysets[name].currentquery || infoOnly) && fnMatches(q.from, q.to, _querysets[name].unit)) {
					if (!infoOnly) {
						_querysets[name].currentquery = q;
					}
					if (!_querysets[name].noClasses && _querysets[name].names && !infoOnly) {
						refreshCSSClasses(name, _querysets[name].names[i]);
					}
					info = getRangeInfo(name, i);
				}
			}

			return info;
		}
		logger.log(WARNING, "No queryset with name " + name + " found", 'DEVICE.MEDIA');
		return null;
	}

	function refreshCSSClasses(sSetName, sRangeName, bRemove){
		 var sClassPrefix = "sapUiMedia-" + sSetName + "-";
		 changeRootCSSClass(sClassPrefix + sRangeName, bRemove, sClassPrefix);
	}

	function changeRootCSSClass(sClassName, bRemove, sPrefix){
		var oRoot = document.documentElement;
		if (oRoot.className.length == 0) {
			if (!bRemove) {
				oRoot.className = sClassName;
			}
		} else {
			var aCurrentClasses = oRoot.className.split(" ");
			var sNewClasses = "";
			for (var i = 0; i < aCurrentClasses.length; i++) {
				if ((sPrefix && aCurrentClasses[i].indexOf(sPrefix) != 0) || (!sPrefix && aCurrentClasses[i] != sClassName)) {
					sNewClasses = sNewClasses + aCurrentClasses[i] + " ";
				}
			}
			if (!bRemove) {
				sNewClasses = sNewClasses + sClassName;
			}
			oRoot.className = sNewClasses;
		}
	}

	function windowSize(){

		return [window.innerWidth, window.innerHeight];
	}

	function convertToPx(val, unit){
		if (unit === "em" || unit === "rem") {
			var s = window.getComputedStyle || function(e) {
					return e.currentStyle;
				};
				var x = s(document.documentElement).fontSize;
				var f = (x && x.indexOf("px") >= 0) ? parseFloat(x, 10) : 16;
				return val * f;
		}
		return val;
	}

	function match_legacy_by_size (from, to, unit, size) {
		from = convertToPx(from, unit);
		to = convertToPx(to, unit);

		var width = size[0];
		var a = from < 0 || from <= width;
		var b = to < 0 || width <= to;
		return a && b;
	}

	function match_legacy(from, to, unit){
		return match_legacy_by_size(from, to, unit, windowSize());
	}

	function match(from, to, unit){
		var q = getQuery(from, to, unit);
		var mm = window.matchMedia(q); //FF returns null when running within an iframe with display:none
		return mm && mm.matches;
	}

	device.media.matches = device.support.matchmedia ? match : match_legacy;

	/**
	 * Registers the given event handler to change events of the screen width based on the range set with the specified name.
	 *
	 * The event is fired whenever the screen width changes and the current screen width is in
	 * a different interval of the given range set than before the width change.
	 *
	 * The event handler is called with a single argument: a map <code>mParams</code> which provides the following information
	 * about the entered interval:
	 * <ul>
	 * <li><code>mParams.from</code>: The start value (inclusive) of the entered interval as a number</li>
	 * <li><code>mParams.to</code>: The end value (exclusive) range of the entered interval as a number or undefined for the last interval (infinity)</li>
	 * <li><code>mParams.unit</code>: The unit used for the values above, e.g. <code>"px"</code></li>
	 * <li><code>mParams.name</code>: The name of the entered interval, if available</li>
	 * </ul>
	 *
	 * @param {function}
	 *            fnFunction The handler function to call when the event occurs. This function will be called in the context of the
	 *                       <code>oListener</code> instance (if present) or on the <code>window</code> instance. A map with information
	 *                       about the entered range set is provided as a single argument to the handler (see details above).
	 * @param {object}
	 *            [oListener] The object that wants to be notified when the event occurs (<code>this</code> context within the
	 *                        handler function). If it is not specified, the handler function is called in the context of the <code>window</code>.
	 * @param {string}
	 *            sName The name of the range set to listen to. The range set must be initialized beforehand
	 *                  ({@link sap.ui.Device.media.initRangeSet}). If no name is provided, the
	 *                  {@link sap.ui.Device.media.RANGESETS.SAP_STANDARD default range set} is used.
	 *
	 * @name sap.ui.Device.media.attachHandler
	 * @function
	 * @public
	 */
	device.media.attachHandler = function(fnFunction, oListener, sName){
		var name = sName || _defaultRangeSet;
		attachEvent("media_" + name, fnFunction, oListener);
	};

	/**
	 * Removes a previously attached event handler from the change events of the screen width.
	 *
	 * The passed parameters must match those used for registration with {@link #.attachHandler} beforehand.
	 *
	 * @param {function}
	 *            fnFunction The handler function to detach from the event
	 * @param {object}
	 *            [oListener] The object that wanted to be notified when the event occurred
	 * @param {string}
	 *             sName The name of the range set to listen to. If no name is provided, the
	 *                   {@link sap.ui.Device.media.RANGESETS.SAP_STANDARD default range set} is used.
	 *
	 * @name sap.ui.Device.media.detachHandler
	 * @function
	 * @public
	 */
	device.media.detachHandler = function(fnFunction, oListener, sName){
		var name = sName || _defaultRangeSet;
		detachEvent("media_" + name, fnFunction, oListener);
	};

	/**
	 * Initializes a screen width media query range set.
	 *
	 * This initialization step makes the range set ready to be used for one of the other functions in namespace <code>sap.ui.Device.media</code>.
	 * The most important {@link sap.ui.Device.media.RANGESETS predefined range sets} are initialized automatically.
	 *
	 * To make a not yet initialized {@link sap.ui.Device.media.RANGESETS predefined range set} ready to be used, call this function with the
	 * name of the range set to be initialized:
	 * <pre>
	 * sap.ui.Device.media.initRangeSet(sap.ui.Device.media.RANGESETS.SAP_3STEPS);
	 * </pre>
	 *
	 * Alternatively it is possible to define custom range sets as shown in the following example:
	 * <pre>
	 * sap.ui.Device.media.initRangeSet("MyRangeSet", [200, 400], "px", ["Small", "Medium", "Large"]);
	 * </pre>
	 * This example defines the following named ranges:
	 * <ul>
	 * <li><code>"Small"</code>: For screens smaller than 200 pixels.</li>
	 * <li><code>"Medium"</code>: For screens greater than or equal to 200 pixels and smaller than 400 pixels.</li>
	 * <li><code>"Large"</code>: For screens greater than or equal to 400 pixels.</li>
	 * </ul>
	 * The range names are optional. If they are specified a CSS class (e.g. <code>sapUiMedia-MyRangeSet-Small</code>) is also
	 * added to the document root depending on the current active range. This can be suppressed via parameter <code>bSuppressClasses</code>.
	 *
	 * @param {string}
	 *             sName The name of the range set to be initialized - either a {@link sap.ui.Device.media.RANGESETS predefined} or custom one.
	 *                   The name must be a valid id and consist only of letters and numeric digits.
	 * @param {int[]}
	 *             [aRangeBorders] The range borders
	 * @param {string}
	 *             [sUnit] The unit which should be used for the values given in <code>aRangeBorders</code>.
	 *                     The allowed values are <code>"px"</code> (default), <code>"em"</code> or <code>"rem"</code>
	 * @param {string[]}
	 *             [aRangeNames] The names of the ranges. The names must be a valid id and consist only of letters and digits. If names
	 *             are specified, CSS classes are also added to the document root as described above. This behavior can be
	 *             switched off explicitly by using <code>bSuppressClasses</code>. <b>Note:</b> <code>aRangeBorders</code> with <code>n</code> entries
	 *             define <code>n+1</code> ranges. Therefore <code>n+1</code> names must be provided.
	 * @param {boolean}
	 *             [bSuppressClasses] Whether or not writing of CSS classes to the document root should be suppressed when
	 *             <code>aRangeNames</code> are provided
	 *
	 * @name sap.ui.Device.media.initRangeSet
	 * @function
	 * @public
	 */
	device.media.initRangeSet = function(sName, aRangeBorders, sUnit, aRangeNames, bSuppressClasses){
		//TODO Do some Assertions and parameter checking
		var oConfig;
		if (!sName) {
			oConfig = device.media._predefinedRangeSets[_defaultRangeSet];
		} else if (sName && device.media._predefinedRangeSets[sName]) {
			oConfig = device.media._predefinedRangeSets[sName];
		} else {
			oConfig = {name: sName, unit: (sUnit || "px").toLowerCase(), points: aRangeBorders || [], names: aRangeNames, noClasses: !!bSuppressClasses};
		}

		if (device.media.hasRangeSet(oConfig.name)) {
			logger.log(INFO, "Range set " + oConfig.name + " has already been initialized", 'DEVICE.MEDIA');
			return;
		}

		sName = oConfig.name;
		oConfig.queries = [];
		oConfig.timer = null;
		oConfig.currentquery = null;
		oConfig.listener = function(){
			return handleChange(sName);
		};

		var from, to, query;
		var aPoints = oConfig.points;
		for (var i = 0, len = aPoints.length; i <= len; i++) {
			from = (i == 0) ? 0 : aPoints[i - 1];
			to = (i == aPoints.length) ? -1 : aPoints[i];
			query = getQuery(from, to, oConfig.unit);
			oConfig.queries.push({
				query: query,
				from: from,
				to: to
			});
		}

		if (oConfig.names && oConfig.names.length != oConfig.queries.length) {
			oConfig.names = null;
		}

		_querysets[oConfig.name] = oConfig;

		if (device.support.matchmedialistener) { //FF, Safari, Chrome, IE10?
			var queries = oConfig.queries;
			for (var i = 0; i < queries.length; i++) {
				var q = queries[i];
				q.media = window.matchMedia(q.query);
				q.media.addListener(oConfig.listener);
			}
		} else { //IE, Safari (<6?)
			window.addEventListener("resize", oConfig.listener, false);
			window.addEventListener("orientationchange", oConfig.listener, false);
		}

		oConfig.listener();
	};

	/**
	 * Returns information about the current active range of the range set with the given name.
	 *
	 * If the optional parameter <code>iWidth</iWidth> is given, the active range will be determined for that width,
	 * otherwise it is determined for the current window size.
	 *
	 * @param {string} sName The name of the range set. The range set must be initialized beforehand ({@link sap.ui.Device.media.initRangeSet})
	 * @param {int} [iWidth] An optional width, based on which the range should be determined;
	 *             If <code>iWidth</code> is not a number, the window size will be used.
	 * @returns {map} Information about the current active interval of the range set. The returned map has the same structure as the argument of the event handlers ({@link sap.ui.Device.media.attachHandler})
	 *
	 * @name sap.ui.Device.media.getCurrentRange
	 * @function
	 * @public
	 */
	device.media.getCurrentRange = function(sName, iWidth){
		if (!device.media.hasRangeSet(sName)) {
			return null;
		}
		return checkQueries(sName, true, isNaN(iWidth) ? null : function(from, to, unit) {
			return match_legacy_by_size(from, to, unit, [iWidth, 0]);
		});
	};

	/**
	 * Returns <code>true</code> if a range set with the given name is already initialized.
	 *
	 * @param {string} sName The name of the range set.
	 *
	 * @name sap.ui.Device.media.hasRangeSet
	 * @return {boolean} Returns <code>true</code> if a range set with the given name is already initialized
	 * @function
	 * @public
	 */
	device.media.hasRangeSet = function(sName){
		return sName && !!_querysets[sName];
	};

	/**
	 * Removes a previously initialized range set and detaches all registered handlers.
	 *
	 * Only custom range sets can be removed via this function. Initialized predefined range sets
	 * ({@link sap.ui.Device.media.RANGESETS}) cannot be removed.
	 *
	 * @param {string} sName The name of the range set which should be removed.
	 *
	 * @name sap.ui.Device.media.removeRangeSet
	 * @function
	 * @protected
	 */
	device.media.removeRangeSet = function(sName){
		if (!device.media.hasRangeSet(sName)) {
			logger.log(INFO, "RangeSet " + sName + " not found, thus could not be removed.", 'DEVICE.MEDIA');
			return;
		}

		for (var x in RANGESETS) {
			if (sName === RANGESETS[x]) {
				logger.log(WARNING, "Cannot remove default rangeset - no action taken.", 'DEVICE.MEDIA');
				return;
			}
		}

		var oConfig = _querysets[sName];
		if (device.support.matchmedialistener) { //FF, Safari, Chrome, IE10?
			var queries = oConfig.queries;
			for (var i = 0; i < queries.length; i++) {
				queries[i].media.removeListener(oConfig.listener);
			}
		} else { //IE, Safari (<6?)
			window.removeEventListener("resize", oConfig.listener, false);
			window.removeEventListener("orientationchange", oConfig.listener, false);
		}

		refreshCSSClasses(sName, "", true);
		delete mEventRegistry["media_" + sName];
		delete _querysets[sName];
	};

//******** System Detection ********

	/**
	 * Provides a basic categorization of the used device based on various indicators.
	 *
	 * These indicators are for example the support of touch events, the screen size, the used operation system or
	 * the user agent of the browser.
	 *
	 * <b>Note:</b> Depending on the capabilities of the device it is also possible that multiple flags are set to <code>true</code>.
	 *
	 * @namespace
	 * @name sap.ui.Device.system
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the device is recognized as a tablet.
	 *
	 * Furthermore, a CSS class <code>sap-tablet</code> is added to the document root element.
	 *
	 * <b>Note:</b> This flag is also true for some browsers on desktop devices running on Windows 8 or higher. Also see the
	 * documentation for {@link sap.ui.Device.system.combi} devices.
	 * You can use the following logic to ensure that the current device is a tablet device:
	 *
	 * <pre>
	 * if(sap.ui.Device.system.tablet && !sap.ui.Device.system.desktop){
	 *	...tablet related commands...
	 * }
	 * </pre>
	 *
	 * @name sap.ui.Device.system.tablet
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the device is recognized as a phone.
	 *
	 * Furthermore, a CSS class <code>sap-phone</code> is added to the document root element.
	 *
	 * @name sap.ui.Device.system.phone
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the device is recognized as a desktop system.
	 *
	 * Furthermore, a CSS class <code>sap-desktop</code> is added to the document root element.
	 *
	 * @name sap.ui.Device.system.desktop
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the device is recognized as a combination of a desktop system and tablet.
	 *
	 * Furthermore, a CSS class <code>sap-combi</code> is added to the document root element.
	 *
	 * <b>Note:</b> This property is mainly for Microsoft Windows 8 (and following) devices where the mouse and touch event may be supported
	 * natively by the browser being used. This property is set to <code>true</code> only when both mouse and touch event are natively supported.
	 *
	 * @name sap.ui.Device.system.combi
	 * @type boolean
	 * @public
	 */
	/**
	 * Enumeration containing the names of known types of the devices.
	 *
	 * @namespace
	 * @name sap.ui.Device.system.SYSTEMTYPE
	 * @private
	 */

	var SYSTEMTYPE = {
			"TABLET" : "tablet",
			"PHONE" : "phone",
			"DESKTOP" : "desktop",
			"COMBI" : "combi"
	};

	device.system = {};

	function getSystem(_simMobileOnDesktop, customUA) {
		var t = isTablet(customUA);
		var isWin8Upwards = device.os.windows && device.os.version >= 8;
		var isWin7 = device.os.windows && device.os.version === 7;

		var s = {};
		s.tablet = !!(((device.support.touch && !isWin7) || isWin8Upwards || !!_simMobileOnDesktop) && t);
		s.phone = !!(device.os.windows_phone || ((device.support.touch && !isWin7) || !!_simMobileOnDesktop) && !t);
		s.desktop = !!((!s.tablet && !s.phone) || isWin8Upwards || isWin7);
		s.combi = !!(s.desktop && s.tablet);
		s.SYSTEMTYPE = SYSTEMTYPE;

		for (var type in SYSTEMTYPE) {
			changeRootCSSClass("sap-" + SYSTEMTYPE[type], !s[SYSTEMTYPE[type]]);
		}
		return s;
	}

	function isTablet(customUA) {
		var ua = customUA || navigator.userAgent;
		var isWin8Upwards = device.os.windows && device.os.version >= 8;
		if (device.os.name === device.os.OS.IOS) {
			return /ipad/i.test(ua);
		} else {
			//in real mobile device
			if (device.support.touch) {
				if (isWin8Upwards) {
					return true;
				}

				if (device.browser.chrome && device.os.android && device.os.version >= 4.4) {
					// From Android version 4.4, WebView also uses Chrome as Kernel.
					// We can use the user agent pattern defined in Chrome to do phone/tablet detection
					// According to the information here: https://developer.chrome.com/multidevice/user-agent#chrome_for_android_user_agent,
					//  the existence of "Mobile" indicates it's a phone. But because the crosswalk framework which is used in Fiori Client
					//  inserts another "Mobile" to the user agent for both tablet and phone, we need to check whether "Mobile Safari/<Webkit Rev>" exists.
					return !/Mobile Safari\/[.0-9]+/.test(ua);
				} else {
					var densityFactor = window.devicePixelRatio ? window.devicePixelRatio : 1; // may be undefined in Windows Phone devices
					// On Android sometimes window.screen.width returns the logical CSS pixels, sometimes the physical device pixels;
					// Tests on multiple devices suggest this depends on the Webkit version.
					// The Webkit patch which changed the behavior was done here: https://bugs.webkit.org/show_bug.cgi?id=106460
					// Chrome 27 with Webkit 537.36 returns the logical pixels,
					// Chrome 18 with Webkit 535.19 returns the physical pixels.
					// The BlackBerry 10 browser with Webkit 537.10+ returns the physical pixels.
					// So it appears like somewhere above Webkit 537.10 we do not hve to divide by the devicePixelRatio anymore.
					if (device.os.android && device.browser.webkit && (parseFloat(device.browser.webkitVersion) > 537.10)) {
						densityFactor = 1;
					}

					//this is how android distinguishes between tablet and phone
					//http://android-developers.blogspot.de/2011/07/new-tools-for-managing-screen-sizes.html
					var bTablet = (Math.min(window.screen.width / densityFactor, window.screen.height / densityFactor) >= 600);

					// special workaround for Nexus 7 where the window.screen.width is 600px or 601px in portrait mode (=> tablet)
					// but window.screen.height 552px in landscape mode (=> phone), because the browser UI takes some space on top.
					// So the detected device type depends on the orientation :-(
					// actually this is a Chrome bug, as "width"/"height" should return the entire screen's dimensions and
					// "availWidth"/"availHeight" should return the size available after subtracting the browser UI
					if (isLandscape()
							&& (window.screen.height === 552 || window.screen.height === 553) // old/new Nexus 7
							&& (/Nexus 7/i.test(ua))) {
						bTablet = true;
					}

					return bTablet;
				}

			} else {
				// This simple android phone detection can be used here because this is the mobile emulation mode in desktop browser
				var android_phone = (/(?=android)(?=.*mobile)/i.test(ua));
				// in desktop browser, it's detected as tablet when
				// 1. Windows 8 device with a touch screen where "Touch" is contained in the userAgent
				// 2. Android emulation and it's not an Android phone
				return (device.browser.msie && ua.indexOf("Touch") !== -1) || (device.os.android && !android_phone);
			}
		}
	}

	function setSystem(_simMobileOnDesktop, customUA) {
		device.system = getSystem(_simMobileOnDesktop, customUA);
		if (device.system.tablet || device.system.phone) {
			device.browser.mobile = true;
		}
	}
	setSystem();
	// expose the function for unit test
	device._getSystem = getSystem;

//******** Orientation Detection ********

	/**
	 * Common API for orientation change notifications across all platforms.
	 *
	 * For browsers or devices that do not provide native support for orientation change events
	 * the API simulates them based on the ratio of the document's width and height.
	 *
	 * @namespace
	 * @name sap.ui.Device.orientation
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the screen is currently in portrait mode (the height is greater than the width).
	 *
	 * @name sap.ui.Device.orientation.portrait
	 * @type boolean
	 * @public
	 */
	/**
	 * If this flag is set to <code>true</code>, the screen is currently in landscape mode (the width is greater than the height).
	 *
	 * @name sap.ui.Device.orientation.landscape
	 * @type boolean
	 * @public
	 */

	device.orientation = {};

	/**
	 * Common API for document window size change notifications across all platforms.
	 *
	 * @namespace
	 * @name sap.ui.Device.resize
	 * @public
	 */
	/**
	 * The current height of the document's window in pixels.
	 *
	 * @name sap.ui.Device.resize.height
	 * @type int
	 * @public
	 */
	/**
	 * The current width of the document's window in pixels.
	 *
	 * @name sap.ui.Device.resize.width
	 * @type int
	 * @public
	 */

	device.resize = {};

	/**
	 * Registers the given event handler to orientation change events of the document's window.
	 *
	 * The event is fired whenever the screen orientation changes and the width of the document's window
	 * becomes greater than its height or the other way round.
	 *
	 * The event handler is called with a single argument: a map <code>mParams</code> which provides the following information:
	 * <ul>
	 * <li><code>mParams.landscape</code>: If this flag is set to <code>true</code>, the screen is currently in landscape mode, otherwise in portrait mode.</li>
	 * </ul>
	 *
	 * @param {function}
	 *            fnFunction The handler function to call when the event occurs. This function will be called in the context of the
	 *                       <code>oListener</code> instance (if present) or on the <code>window</code> instance. A map with information
	 *                       about the orientation is provided as a single argument to the handler (see details above).
	 * @param {object}
	 *            [oListener] The object that wants to be notified when the event occurs (<code>this</code> context within the
	 *                        handler function). If it is not specified, the handler function is called in the context of the <code>window</code>.
	 *
	 * @name sap.ui.Device.orientation.attachHandler
	 * @function
	 * @public
	 */
	device.orientation.attachHandler = function(fnFunction, oListener){
		attachEvent("orientation", fnFunction, oListener);
	};

	/**
	 * Registers the given event handler to resize change events of the document's window.
	 *
	 * The event is fired whenever the document's window size changes.
	 *
	 * The event handler is called with a single argument: a map <code>mParams</code> which provides the following information:
	 * <ul>
	 * <li><code>mParams.height</code>: The height of the document's window in pixels.</li>
	 * <li><code>mParams.width</code>: The width of the document's window in pixels.</li>
	 * </ul>
	 *
	 * @param {function}
	 *            fnFunction The handler function to call when the event occurs. This function will be called in the context of the
	 *                       <code>oListener</code> instance (if present) or on the <code>window</code> instance. A map with information
	 *                       about the size is provided as a single argument to the handler (see details above).
	 * @param {object}
	 *            [oListener] The object that wants to be notified when the event occurs (<code>this</code> context within the
	 *                        handler function). If it is not specified, the handler function is called in the context of the <code>window</code>.
	 *
	 * @name sap.ui.Device.resize.attachHandler
	 * @function
	 * @public
	 */
	device.resize.attachHandler = function(fnFunction, oListener){
		attachEvent("resize", fnFunction, oListener);
	};

	/**
	 * Removes a previously attached event handler from the orientation change events.
	 *
	 * The passed parameters must match those used for registration with {@link #.attachHandler} beforehand.
	 *
	 * @param {function}
	 *            fnFunction The handler function to detach from the event
	 * @param {object}
	 *            [oListener] The object that wanted to be notified when the event occurred
	 *
	 * @name sap.ui.Device.orientation.detachHandler
	 * @function
	 * @public
	 */
	device.orientation.detachHandler = function(fnFunction, oListener){
		detachEvent("orientation", fnFunction, oListener);
	};

	/**
	 * Removes a previously attached event handler from the resize events.
	 *
	 * The passed parameters must match those used for registration with {@link #.attachHandler} beforehand.
	 *
	 * @param {function}
	 *            fnFunction The handler function to detach from the event
	 * @param {object}
	 *            [oListener] The object that wanted to be notified when the event occurred
	 *
	 * @name sap.ui.Device.resize.detachHandler
	 * @function
	 * @public
	 */
	device.resize.detachHandler = function(fnFunction, oListener){
		detachEvent("resize", fnFunction, oListener);
	};

	function setOrientationInfo(oInfo){
		oInfo.landscape = isLandscape(true);
		oInfo.portrait = !oInfo.landscape;
	}

	function handleOrientationChange(){
		setOrientationInfo(device.orientation);
		fireEvent("orientation", {landscape: device.orientation.landscape});
	}

	function handleResizeChange(){
		setResizeInfo(device.resize);
		fireEvent("resize", {height: device.resize.height, width: device.resize.width});
	}

	function setResizeInfo(oInfo){
		oInfo.width = windowSize()[0];
		oInfo.height = windowSize()[1];
	}

	function handleOrientationResizeChange(){
		var wasL = device.orientation.landscape;
		var isL = isLandscape();
		if (wasL != isL) {
			handleOrientationChange();
		}
		//throttle resize events because most browsers throw one or more resize events per pixel
		//for every resize event inside the period from 150ms (starting from the first resize event),
		//we only fire one resize event after this period
		if (!iResizeTimeout) {
			iResizeTimeout = window.setTimeout(handleResizeTimeout, 150);
		}
	}

	function handleResizeTimeout() {
		handleResizeChange();
		iResizeTimeout = null;
	}

	var bOrientationchange = false;
	var bResize = false;
	var iOrientationTimeout;
	var iResizeTimeout;
	var iClearFlagTimeout;
	var iWindowHeightOld = windowSize()[1];
	var iWindowWidthOld = windowSize()[0];
	var bKeyboardOpen = false;
	var iLastResizeTime;
	var rInputTagRegex = /INPUT|TEXTAREA|SELECT/;
	// On iPhone with iOS version 7.0.x and on iPad with iOS version 7.x (tested with all versions below 7.1.1), there's an invalid resize event fired
	// when changing the orientation while keyboard is shown.
	var bSkipFirstResize = device.os.ios && device.browser.name === "sf" &&
		((device.system.phone && device.os.version >= 7 && device.os.version < 7.1) || (device.system.tablet && device.os.version >= 7));

	function isLandscape(bFromOrientationChange){
		if (device.support.touch && device.support.orientation && device.os.android) {
			//if on screen keyboard is open and the call of this method is from orientation change listener, reverse the last value.
			//this is because when keyboard opens on android device, the height can be less than the width even in portrait mode.
			if (bKeyboardOpen && bFromOrientationChange) {
				return !device.orientation.landscape;
			}
			if (bKeyboardOpen) { //when keyboard opens, the last orientation change value will be returned.
				return device.orientation.landscape;
			}
		} else if (device.support.matchmedia && device.support.orientation) { //most desktop browsers and windows phone/tablet which not support orientationchange
			return !!window.matchMedia("(orientation: landscape)").matches;
		}
		//otherwise compare the width and height of window
		var size = windowSize();
		return size[0] > size[1];
	}

	function handleMobileOrientationResizeChange(evt) {
		if (evt.type == "resize") {
			// suppress the first invalid resize event fired before orientationchange event while keyboard is open on iPhone 7.0.x
			// because this event has wrong size infos
			if (bSkipFirstResize && rInputTagRegex.test(document.activeElement.tagName) && !bOrientationchange) {
				return;
			}

			var iWindowHeightNew = windowSize()[1];
			var iWindowWidthNew = windowSize()[0];
			var iTime = new Date().getTime();
			//skip multiple resize events by only one orientationchange
			if (iWindowHeightNew === iWindowHeightOld && iWindowWidthNew === iWindowWidthOld) {
				return;
			}
			bResize = true;
			//on mobile devices opening the keyboard on some devices leads to a resize event
			//in this case only the height changes, not the width
			if ((iWindowHeightOld != iWindowHeightNew) && (iWindowWidthOld == iWindowWidthNew)) {
				//Asus Transformer tablet fires two resize events when orientation changes while keyboard is open.
				//Between these two events, only the height changes. The check of if keyboard is open has to be skipped because
				//it may be judged as keyboard closed but the keyboard is still open which will affect the orientation detection
				if (!iLastResizeTime || (iTime - iLastResizeTime > 300)) {
					bKeyboardOpen = (iWindowHeightNew < iWindowHeightOld);
				}
				handleResizeChange();
			} else {
				iWindowWidthOld = iWindowWidthNew;
			}
			iLastResizeTime = iTime;
			iWindowHeightOld = iWindowHeightNew;

			if (iClearFlagTimeout) {
				window.clearTimeout(iClearFlagTimeout);
				iClearFlagTimeout = null;
			}
			//Some Android build-in browser fires a resize event after the viewport is applied.
			//This resize event has to be dismissed otherwise when the next orientationchange event happens,
			//a UI5 resize event will be fired with the wrong window size.
			iClearFlagTimeout = window.setTimeout(clearFlags, 1200);
		} else if (evt.type == "orientationchange") {
			bOrientationchange = true;
		}

		if (iOrientationTimeout) {
			clearTimeout(iOrientationTimeout);
			iOrientationTimeout = null;
		}
		iOrientationTimeout = window.setTimeout(handleMobileTimeout, 50);
	}

	function handleMobileTimeout() {
		// with ios split view, the browser fires only resize event and no orientationchange when changing the size of a split view
		// therefore the following if needs to be adapted with additional check of iPad with version greater or equal 9 (splitview was introduced with iOS 9)
		if (bResize && (bOrientationchange || (device.system.tablet && device.os.ios && device.os.version >= 9))) {
			handleOrientationChange();
			handleResizeChange();
			bOrientationchange = false;
			bResize = false;
			if (iClearFlagTimeout) {
				window.clearTimeout(iClearFlagTimeout);
				iClearFlagTimeout = null;
			}
		}
		iOrientationTimeout = null;
	}

	function clearFlags(){
		bOrientationchange = false;
		bResize = false;
		iClearFlagTimeout = null;
	}

//******** Update browser settings for test purposes ********

	device._update = function(_simMobileOnDesktop) {
		ua = navigator.userAgent;
		logger.log(WARNING, "Device API values manipulated: NOT PRODUCTIVE FEATURE!!! This should be only used for test purposes. Only use if you know what you are doing.");
		setBrowser();
		setOS();
		setSystem(_simMobileOnDesktop);
	};

//********************************************************

	setResizeInfo(device.resize);
	setOrientationInfo(device.orientation);

	//Add API to global namespace
	window.sap.ui.Device = device;

	// Add handler for orientationchange and resize after initialization of Device API
	if (device.support.touch && device.support.orientation) {
		// logic for mobile devices which support orientationchange (like ios, android)
		window.addEventListener("resize", handleMobileOrientationResizeChange, false);
		window.addEventListener("orientationchange", handleMobileOrientationResizeChange, false);
	} else {
		// desktop browsers and windows phone/tablet which not support orientationchange
		window.addEventListener("resize", handleOrientationResizeChange, false);
	}

	//Always initialize the default media range set
	device.media.initRangeSet();
	device.media.initRangeSet(RANGESETS["SAP_STANDARD_EXTENDED"]);

	// define module if API is available
	if (sap.ui.define) {
		sap.ui.define("sap/ui/Device", [], function() {
			return device;
		});
	}

}());
/*!
 * URI.js - Mutating URLs
 * Second Level Domain (SLD) Support
 *
 * Version: 1.11.2
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.com/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *   GPL v3 http://opensource.org/licenses/GPL-3.0
 *
 */

(function (root, factory) {
    // https://github.com/umdjs/umd/blob/master/returnExports.js
    if (typeof exports === 'object') {
        // Node
        module.exports = factory();
    } else if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(factory);
    } else {
        // Browser globals (root is window)
        root.SecondLevelDomains = factory(root);
    }
}(this, function (root) {
"use strict";

// save current SecondLevelDomains variable, if any
var _SecondLevelDomains = root && root.SecondLevelDomains;

var hasOwn = Object.prototype.hasOwnProperty;
var SLD = {
    // list of known Second Level Domains
    // converted list of SLDs from https://github.com/gavingmiller/second-level-domains
    // ----
    // publicsuffix.org is more current and actually used by a couple of browsers internally.
    // downside is it also contains domains like "dyndns.org" - which is fine for the security
    // issues browser have to deal with (SOP for cookies, etc) - but is way overboard for URI.js
    // ----
    list: {
        "ac":"com|gov|mil|net|org",
        "ae":"ac|co|gov|mil|name|net|org|pro|sch",
        "af":"com|edu|gov|net|org",
        "al":"com|edu|gov|mil|net|org",
        "ao":"co|ed|gv|it|og|pb",
        "ar":"com|edu|gob|gov|int|mil|net|org|tur",
        "at":"ac|co|gv|or",
        "au":"asn|com|csiro|edu|gov|id|net|org",
        "ba":"co|com|edu|gov|mil|net|org|rs|unbi|unmo|unsa|untz|unze",
        "bb":"biz|co|com|edu|gov|info|net|org|store|tv",
        "bh":"biz|cc|com|edu|gov|info|net|org",
        "bn":"com|edu|gov|net|org",
        "bo":"com|edu|gob|gov|int|mil|net|org|tv",
        "br":"adm|adv|agr|am|arq|art|ato|b|bio|blog|bmd|cim|cng|cnt|com|coop|ecn|edu|eng|esp|etc|eti|far|flog|fm|fnd|fot|fst|g12|ggf|gov|imb|ind|inf|jor|jus|lel|mat|med|mil|mus|net|nom|not|ntr|odo|org|ppg|pro|psc|psi|qsl|rec|slg|srv|tmp|trd|tur|tv|vet|vlog|wiki|zlg",
        "bs":"com|edu|gov|net|org",
        "bz":"du|et|om|ov|rg",
        "ca":"ab|bc|mb|nb|nf|nl|ns|nt|nu|on|pe|qc|sk|yk",
        "ck":"biz|co|edu|gen|gov|info|net|org",
        "cn":"ac|ah|bj|com|cq|edu|fj|gd|gov|gs|gx|gz|ha|hb|he|hi|hl|hn|jl|js|jx|ln|mil|net|nm|nx|org|qh|sc|sd|sh|sn|sx|tj|tw|xj|xz|yn|zj",
        "co":"com|edu|gov|mil|net|nom|org",
        "cr":"ac|c|co|ed|fi|go|or|sa",
        "cy":"ac|biz|com|ekloges|gov|ltd|name|net|org|parliament|press|pro|tm",
        "do":"art|com|edu|gob|gov|mil|net|org|sld|web",
        "dz":"art|asso|com|edu|gov|net|org|pol",
        "ec":"com|edu|fin|gov|info|med|mil|net|org|pro",
        "eg":"com|edu|eun|gov|mil|name|net|org|sci",
        "er":"com|edu|gov|ind|mil|net|org|rochest|w",
        "es":"com|edu|gob|nom|org",
        "et":"biz|com|edu|gov|info|name|net|org",
        "fj":"ac|biz|com|info|mil|name|net|org|pro",
        "fk":"ac|co|gov|net|nom|org",
        "fr":"asso|com|f|gouv|nom|prd|presse|tm",
        "gg":"co|net|org",
        "gh":"com|edu|gov|mil|org",
        "gn":"ac|com|gov|net|org",
        "gr":"com|edu|gov|mil|net|org",
        "gt":"com|edu|gob|ind|mil|net|org",
        "gu":"com|edu|gov|net|org",
        "hk":"com|edu|gov|idv|net|org",
        "id":"ac|co|go|mil|net|or|sch|web",
        "il":"ac|co|gov|idf|k12|muni|net|org",
        "in":"ac|co|edu|ernet|firm|gen|gov|i|ind|mil|net|nic|org|res",
        "iq":"com|edu|gov|i|mil|net|org",
        "ir":"ac|co|dnssec|gov|i|id|net|org|sch",
        "it":"edu|gov",
        "je":"co|net|org",
        "jo":"com|edu|gov|mil|name|net|org|sch",
        "jp":"ac|ad|co|ed|go|gr|lg|ne|or",
        "ke":"ac|co|go|info|me|mobi|ne|or|sc",
        "kh":"com|edu|gov|mil|net|org|per",
        "ki":"biz|com|de|edu|gov|info|mob|net|org|tel",
        "km":"asso|com|coop|edu|gouv|k|medecin|mil|nom|notaires|pharmaciens|presse|tm|veterinaire",
        "kn":"edu|gov|net|org",
        "kr":"ac|busan|chungbuk|chungnam|co|daegu|daejeon|es|gangwon|go|gwangju|gyeongbuk|gyeonggi|gyeongnam|hs|incheon|jeju|jeonbuk|jeonnam|k|kg|mil|ms|ne|or|pe|re|sc|seoul|ulsan",
        "kw":"com|edu|gov|net|org",
        "ky":"com|edu|gov|net|org",
        "kz":"com|edu|gov|mil|net|org",
        "lb":"com|edu|gov|net|org",
        "lk":"assn|com|edu|gov|grp|hotel|int|ltd|net|ngo|org|sch|soc|web",
        "lr":"com|edu|gov|net|org",
        "lv":"asn|com|conf|edu|gov|id|mil|net|org",
        "ly":"com|edu|gov|id|med|net|org|plc|sch",
        "ma":"ac|co|gov|m|net|org|press",
        "mc":"asso|tm",
        "me":"ac|co|edu|gov|its|net|org|priv",
        "mg":"com|edu|gov|mil|nom|org|prd|tm",
        "mk":"com|edu|gov|inf|name|net|org|pro",
        "ml":"com|edu|gov|net|org|presse",
        "mn":"edu|gov|org",
        "mo":"com|edu|gov|net|org",
        "mt":"com|edu|gov|net|org",
        "mv":"aero|biz|com|coop|edu|gov|info|int|mil|museum|name|net|org|pro",
        "mw":"ac|co|com|coop|edu|gov|int|museum|net|org",
        "mx":"com|edu|gob|net|org",
        "my":"com|edu|gov|mil|name|net|org|sch",
        "nf":"arts|com|firm|info|net|other|per|rec|store|web",
        "ng":"biz|com|edu|gov|mil|mobi|name|net|org|sch",
        "ni":"ac|co|com|edu|gob|mil|net|nom|org",
        "np":"com|edu|gov|mil|net|org",
        "nr":"biz|com|edu|gov|info|net|org",
        "om":"ac|biz|co|com|edu|gov|med|mil|museum|net|org|pro|sch",
        "pe":"com|edu|gob|mil|net|nom|org|sld",
        "ph":"com|edu|gov|i|mil|net|ngo|org",
        "pk":"biz|com|edu|fam|gob|gok|gon|gop|gos|gov|net|org|web",
        "pl":"art|bialystok|biz|com|edu|gda|gdansk|gorzow|gov|info|katowice|krakow|lodz|lublin|mil|net|ngo|olsztyn|org|poznan|pwr|radom|slupsk|szczecin|torun|warszawa|waw|wroc|wroclaw|zgora",
        "pr":"ac|biz|com|edu|est|gov|info|isla|name|net|org|pro|prof",
        "ps":"com|edu|gov|net|org|plo|sec",
        "pw":"belau|co|ed|go|ne|or",
        "ro":"arts|com|firm|info|nom|nt|org|rec|store|tm|www",
        "rs":"ac|co|edu|gov|in|org",
        "sb":"com|edu|gov|net|org",
        "sc":"com|edu|gov|net|org",
        "sh":"co|com|edu|gov|net|nom|org",
        "sl":"com|edu|gov|net|org",
        "st":"co|com|consulado|edu|embaixada|gov|mil|net|org|principe|saotome|store",
        "sv":"com|edu|gob|org|red",
        "sz":"ac|co|org",
        "tr":"av|bbs|bel|biz|com|dr|edu|gen|gov|info|k12|name|net|org|pol|tel|tsk|tv|web",
        "tt":"aero|biz|cat|co|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel",
        "tw":"club|com|ebiz|edu|game|gov|idv|mil|net|org",
        "mu":"ac|co|com|gov|net|or|org",
        "mz":"ac|co|edu|gov|org",
        "na":"co|com",
        "nz":"ac|co|cri|geek|gen|govt|health|iwi|maori|mil|net|org|parliament|school",
        "pa":"abo|ac|com|edu|gob|ing|med|net|nom|org|sld",
        "pt":"com|edu|gov|int|net|nome|org|publ",
        "py":"com|edu|gov|mil|net|org",
        "qa":"com|edu|gov|mil|net|org",
        "re":"asso|com|nom",
        "ru":"ac|adygeya|altai|amur|arkhangelsk|astrakhan|bashkiria|belgorod|bir|bryansk|buryatia|cbg|chel|chelyabinsk|chita|chukotka|chuvashia|com|dagestan|e-burg|edu|gov|grozny|int|irkutsk|ivanovo|izhevsk|jar|joshkar-ola|kalmykia|kaluga|kamchatka|karelia|kazan|kchr|kemerovo|khabarovsk|khakassia|khv|kirov|koenig|komi|kostroma|kranoyarsk|kuban|kurgan|kursk|lipetsk|magadan|mari|mari-el|marine|mil|mordovia|mosreg|msk|murmansk|nalchik|net|nnov|nov|novosibirsk|nsk|omsk|orenburg|org|oryol|penza|perm|pp|pskov|ptz|rnd|ryazan|sakhalin|samara|saratov|simbirsk|smolensk|spb|stavropol|stv|surgut|tambov|tatarstan|tom|tomsk|tsaritsyn|tsk|tula|tuva|tver|tyumen|udm|udmurtia|ulan-ude|vladikavkaz|vladimir|vladivostok|volgograd|vologda|voronezh|vrn|vyatka|yakutia|yamal|yekaterinburg|yuzhno-sakhalinsk",
        "rw":"ac|co|com|edu|gouv|gov|int|mil|net",
        "sa":"com|edu|gov|med|net|org|pub|sch",
        "sd":"com|edu|gov|info|med|net|org|tv",
        "se":"a|ac|b|bd|c|d|e|f|g|h|i|k|l|m|n|o|org|p|parti|pp|press|r|s|t|tm|u|w|x|y|z",
        "sg":"com|edu|gov|idn|net|org|per",
        "sn":"art|com|edu|gouv|org|perso|univ",
        "sy":"com|edu|gov|mil|net|news|org",
        "th":"ac|co|go|in|mi|net|or",
        "tj":"ac|biz|co|com|edu|go|gov|info|int|mil|name|net|nic|org|test|web",
        "tn":"agrinet|com|defense|edunet|ens|fin|gov|ind|info|intl|mincom|nat|net|org|perso|rnrt|rns|rnu|tourism",
        "tz":"ac|co|go|ne|or",
        "ua":"biz|cherkassy|chernigov|chernovtsy|ck|cn|co|com|crimea|cv|dn|dnepropetrovsk|donetsk|dp|edu|gov|if|in|ivano-frankivsk|kh|kharkov|kherson|khmelnitskiy|kiev|kirovograd|km|kr|ks|kv|lg|lugansk|lutsk|lviv|me|mk|net|nikolaev|od|odessa|org|pl|poltava|pp|rovno|rv|sebastopol|sumy|te|ternopil|uzhgorod|vinnica|vn|zaporizhzhe|zhitomir|zp|zt",
        "ug":"ac|co|go|ne|or|org|sc",
        "uk":"ac|bl|british-library|co|cym|gov|govt|icnet|jet|lea|ltd|me|mil|mod|national-library-scotland|nel|net|nhs|nic|nls|org|orgn|parliament|plc|police|sch|scot|soc",
        "us":"dni|fed|isa|kids|nsn",
        "uy":"com|edu|gub|mil|net|org",
        "ve":"co|com|edu|gob|info|mil|net|org|web",
        "vi":"co|com|k12|net|org",
        "vn":"ac|biz|com|edu|gov|health|info|int|name|net|org|pro",
        "ye":"co|com|gov|ltd|me|net|org|plc",
        "yu":"ac|co|edu|gov|org",
        "za":"ac|agric|alt|bourse|city|co|cybernet|db|edu|gov|grondar|iaccess|imt|inca|landesign|law|mil|net|ngo|nis|nom|olivetti|org|pix|school|tm|web",
        "zm":"ac|co|com|edu|gov|net|org|sch"
    },
    // SLD expression for each TLD
    //expressions: {},
    // SLD expression for all TLDs
    has_expression: null,
    is_expression: null,
    // validate domain is a known SLD
    has: function(domain) {
        return !!domain.match(SLD.has_expression);
    },
    is: function(domain) {
        return !!domain.match(SLD.is_expression);
    },
    get: function(domain) {
        var t = domain.match(SLD.has_expression);
        return t && t[1] || null;
    },
    noConflict: function(){
      if (root.SecondLevelDomains === this) {
        root.SecondLevelDomains = _SecondLevelDomains;
      }
      return this;
    },
    init: function() {
        var t = '';
        for (var tld in SLD.list) {
            if (!hasOwn.call(SLD.list, tld)) {
                continue;
            }

            var expression = '(' + SLD.list[tld] + ')\.' + tld;
            //SLD.expressions[tld] = new RegExp('\.' + expression + '$', 'i');
            t += '|(' + expression + ')';
        }

        SLD.has_expression = new RegExp('\\.(' + t.substr(1) + ')$', 'i');
        SLD.is_expression = new RegExp('^(' + t.substr(1) + ')$', 'i');
    }
};

SLD.init();

return SLD;
}));
/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.11.2
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.com/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *   GPL v3 http://opensource.org/licenses/GPL-3.0
 *
 */
(function (root, factory) {
    // https://github.com/umdjs/umd/blob/master/returnExports.js
    if (typeof exports === 'object') {
        // Node
        module.exports = factory(require('./punycode'), require('./IPv6'), require('./SecondLevelDomains'));
    } else if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
      // ##### BEGIN: MODIFIED BY SAP
      // define(['./punycode', './IPv6', './SecondLevelDomains'], factory);
      // we can't support loading URI.js via AMD define. URI.js is packaged with SAPUI5 code
      // and define() doesn't execute synchronously. So the UI5 code executed after URI.js
      // fails as it is missing the URI.js code.
      // Instead we use the standard init code and only expose the result via define()
      // The (optional) dependencies are lost or must be loaded in advance
      root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
      define('sap/ui/thirdparty/URI', [], function() { return root.URI; });
      // ##### END: MODIFIED BY SAP
    } else {
        // Browser globals (root is window)
        root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
    }
}(this, function (punycode, IPv6, SLD, root) {
"use strict";

// save current URI variable, if any
var _URI = root && root.URI;

function URI(url, base) {
    // Allow instantiation without the 'new' keyword
    if (!(this instanceof URI)) {
        return new URI(url, base);
    }

    if (url === undefined) {
        if (typeof location !== 'undefined') {
            url = location.href + "";
        } else {
            url = "";
        }
    }

    this.href(url);

    // resolve to base according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#constructor
    if (base !== undefined) {
        return this.absoluteTo(base);
    }

    return this;
};

var p = URI.prototype;
var hasOwn = Object.prototype.hasOwnProperty;

function escapeRegEx(string) {
    // https://github.com/medialize/URI.js/commit/85ac21783c11f8ccab06106dba9735a31a86924d#commitcomment-821963
    return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, '\\$1');
}

function getType(value) {
    // IE8 doesn't return [Object Undefined] but [Object Object] for undefined value
    if (value === undefined) {
        return 'Undefined';
    }

    return String(Object.prototype.toString.call(value)).slice(8, -1);
}

function isArray(obj) {
    return getType(obj) === "Array";
}

function filterArrayValues(data, value) {
    var lookup = {};
    var i, length;

    if (isArray(value)) {
        for (i = 0, length = value.length; i < length; i++) {
            lookup[value[i]] = true;
        }
    } else {
        lookup[value] = true;
    }

    for (i = 0, length = data.length; i < length; i++) {
        if (lookup[data[i]] !== undefined) {
            data.splice(i, 1);
            length--;
            i--;
        }
    }

    return data;
}

function arrayContains(list, value) {
    var i, length;

    // value may be string, number, array, regexp
    if (isArray(value)) {
        // Note: this can be optimized to O(n) (instead of current O(m * n))
        for (i = 0, length = value.length; i < length; i++) {
            if (!arrayContains(list, value[i])) {
                return false;
            }
        }

        return true;
    }

    var _type = getType(value);
    for (i = 0, length = list.length; i < length; i++) {
        if (_type === 'RegExp') {
            if (typeof list[i] === 'string' && list[i].match(value)) {
                return true;
            }
        } else if (list[i] === value) {
            return true;
        }
    }

    return false;
}

function arraysEqual(one, two) {
    if (!isArray(one) || !isArray(two)) {
        return false;
    }

    // arrays can't be equal if they have different amount of content
    if (one.length !== two.length) {
        return false;
    }

    one.sort();
    two.sort();

    for (var i = 0, l = one.length; i < l; i++) {
        if (one[i] !== two[i]) {
            return false;
        }
    }

    return true;
}

URI._parts = function() {
    return {
        protocol: null,
        username: null,
        password: null,
        hostname: null,
        urn: null,
        port: null,
        path: null,
        query: null,
        fragment: null,
        // state
        duplicateQueryParameters: URI.duplicateQueryParameters,
        escapeQuerySpace: URI.escapeQuerySpace
    };
};
// state: allow duplicate query parameters (a=1&a=1)
URI.duplicateQueryParameters = false;
// state: replaces + with %20 (space in query strings)
URI.escapeQuerySpace = true;
// static properties
URI.protocol_expression = /^[a-z][a-z0-9-+-]*$/i;
URI.idn_expression = /[^a-z0-9\.-]/i;
URI.punycode_expression = /(xn--)/i;
// well, 333.444.555.666 matches, but it sure ain't no IPv4 - do we care?
URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
// credits to Rich Brown
// source: http://forums.intermapper.com/viewtopic.php?p=1096#1096
// specification: http://www.ietf.org/rfc/rfc4291.txt
URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
// gruber revised expression - http://rodneyrehm.de/t/url-regex.html
URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
// http://www.iana.org/assignments/uri-schemes.html
// http://en.wikipedia.org/wiki/List_of_TCP_and_UDP_port_numbers#Well-known_ports
URI.defaultPorts = {
    http: "80",
    https: "443",
    ftp: "21",
    gopher: "70",
    ws: "80",
    wss: "443"
};
// allowed hostname characters according to RFC 3986
// ALPHA DIGIT "-" "." "_" "~" "!" "$" "&" "'" "(" ")" "*" "+" "," ";" "=" %encoded
// I've never seen a (non-IDN) hostname other than: ALPHA DIGIT . -
URI.invalid_hostname_characters = /[^a-zA-Z0-9\.-]/;
// map DOM Elements to their URI attribute
URI.domAttributes = {
    'a': 'href',
    'blockquote': 'cite',
    'link': 'href',
    'base': 'href',
    'script': 'src',
    'form': 'action',
    'img': 'src',
    'area': 'href',
    'iframe': 'src',
    'embed': 'src',
    'source': 'src',
    'track': 'src',
    'input': 'src' // but only if type="image"
};
URI.getDomAttribute = function(node) {
    if (!node || !node.nodeName) {
        return undefined;
    }

    var nodeName = node.nodeName.toLowerCase();
    // <input> should only expose src for type="image"
    if (nodeName === 'input' && node.type !== 'image') {
        return undefined;
    }

    return URI.domAttributes[nodeName];
};

function escapeForDumbFirefox36(value) {
    // https://github.com/medialize/URI.js/issues/91
    return escape(value);
}

// encoding / decoding according to RFC3986
function strictEncodeURIComponent(string) {
    // see https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/encodeURIComponent
    return encodeURIComponent(string)
        .replace(/[!'()*]/g, escapeForDumbFirefox36)
        .replace(/\*/g, "%2A");
}
URI.encode = strictEncodeURIComponent;
URI.decode = decodeURIComponent;
URI.iso8859 = function() {
    URI.encode = escape;
    URI.decode = unescape;
};
URI.unicode = function() {
    URI.encode = strictEncodeURIComponent;
    URI.decode = decodeURIComponent;
};
URI.characters = {
    pathname: {
        encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
            map: {
                // -._~!'()*
                "%24": "$",
                "%26": "&",
                "%2B": "+",
                "%2C": ",",
                "%3B": ";",
                "%3D": "=",
                "%3A": ":",
                "%40": "@"
            }
        },
        decode: {
            expression: /[\/\?#]/g,
            map: {
                "/": "%2F",
                "?": "%3F",
                "#": "%23"
            }
        }
    },
    reserved: {
        encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
            map: {
                // gen-delims
                "%3A": ":",
                "%2F": "/",
                "%3F": "?",
                "%23": "#",
                "%5B": "[",
                "%5D": "]",
                "%40": "@",
                // sub-delims
                "%21": "!",
                "%24": "$",
                "%26": "&",
                "%27": "'",
                "%28": "(",
                "%29": ")",
                "%2A": "*",
                "%2B": "+",
                "%2C": ",",
                "%3B": ";",
                "%3D": "="
            }
        }
    }
};
URI.encodeQuery = function(string, escapeQuerySpace) {
    var escaped = URI.encode(string + "");
    return escapeQuerySpace ? escaped.replace(/%20/g, '+') : escaped;
};
URI.decodeQuery = function(string, escapeQuerySpace) {
    string += "";
    try {
        return URI.decode(escapeQuerySpace ? string.replace(/\+/g, '%20') : string);
    } catch(e) {
        // we're not going to mess with weird encodings,
        // give up and return the undecoded original string
        // see https://github.com/medialize/URI.js/issues/87
        // see https://github.com/medialize/URI.js/issues/92
        return string;
    }
};
URI.recodePath = function(string) {
    var segments = (string + "").split('/');
    for (var i = 0, length = segments.length; i < length; i++) {
        segments[i] = URI.encodePathSegment(URI.decode(segments[i]));
    }

    return segments.join('/');
};
URI.decodePath = function(string) {
    var segments = (string + "").split('/');
    for (var i = 0, length = segments.length; i < length; i++) {
        segments[i] = URI.decodePathSegment(segments[i]);
    }

    return segments.join('/');
};
// generate encode/decode path functions
var _parts = {'encode':'encode', 'decode':'decode'};
var _part;
var generateAccessor = function(_group, _part) {
    return function(string) {
        return URI[_part](string + "").replace(URI.characters[_group][_part].expression, function(c) {
            return URI.characters[_group][_part].map[c];
        });
    };
};

for (_part in _parts) {
    URI[_part + "PathSegment"] = generateAccessor("pathname", _parts[_part]);
}

URI.encodeReserved = generateAccessor("reserved", "encode");

URI.parse = function(string, parts) {
    var pos;
    if (!parts) {
        parts = {};
    }
    // [protocol"://"[username[":"password]"@"]hostname[":"port]"/"?][path]["?"querystring]["#"fragment]

    // extract fragment
    pos = string.indexOf('#');
    if (pos > -1) {
        // escaping?
        parts.fragment = string.substring(pos + 1) || null;
        string = string.substring(0, pos);
    }

    // extract query
    pos = string.indexOf('?');
    if (pos > -1) {
        // escaping?
        parts.query = string.substring(pos + 1) || null;
        string = string.substring(0, pos);
    }

    // extract protocol
    if (string.substring(0, 2) === '//') {
        // relative-scheme
        parts.protocol = null;
        string = string.substring(2);
        // extract "user:pass@host:port"
        string = URI.parseAuthority(string, parts);
    } else {
        pos = string.indexOf(':');
        if (pos > -1) {
            parts.protocol = string.substring(0, pos) || null;
            if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
                // : may be within the path
                parts.protocol = undefined;
            } else if (parts.protocol === 'file') {
                // the file scheme: does not contain an authority
                string = string.substring(pos + 3);
            } else if (string.substring(pos + 1, pos + 3) === '//') {
                string = string.substring(pos + 3);

                // extract "user:pass@host:port"
                string = URI.parseAuthority(string, parts);
            } else {
                string = string.substring(pos + 1);
                parts.urn = true;
            }
        }
    }

    // what's left must be the path
    parts.path = string;

    // and we're done
    return parts;
};
URI.parseHost = function(string, parts) {
    // extract host:port
    var pos = string.indexOf('/');
    var bracketPos;
    var t;

    if (pos === -1) {
        pos = string.length;
    }

    if (string.charAt(0) === "[") {
        // IPv6 host - http://tools.ietf.org/html/draft-ietf-6man-text-addr-representation-04#section-6
        // I claim most client software breaks on IPv6 anyways. To simplify things, URI only accepts
        // IPv6+port in the format [2001:db8::1]:80 (for the time being)
        bracketPos = string.indexOf(']');
        parts.hostname = string.substring(1, bracketPos) || null;
        parts.port = string.substring(bracketPos+2, pos) || null;
    } else if (string.indexOf(':') !== string.lastIndexOf(':')) {
        // IPv6 host contains multiple colons - but no port
        // this notation is actually not allowed by RFC 3986, but we're a liberal parser
        parts.hostname = string.substring(0, pos) || null;
        parts.port = null;
    } else {
        t = string.substring(0, pos).split(':');
        parts.hostname = t[0] || null;
        parts.port = t[1] || null;
    }

    if (parts.hostname && string.substring(pos).charAt(0) !== '/') {
        pos++;
        string = "/" + string;
    }

    return string.substring(pos) || '/';
};
URI.parseAuthority = function(string, parts) {
    string = URI.parseUserinfo(string, parts);
    return URI.parseHost(string, parts);
};
URI.parseUserinfo = function(string, parts) {
    // extract username:password
    var firstSlash = string.indexOf('/');
    var pos = firstSlash > -1
        ? string.lastIndexOf('@', firstSlash)
        : string.indexOf('@');
    var t;

    // authority@ must come before /path
    if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
        t = string.substring(0, pos).split(':');
        parts.username = t[0] ? URI.decode(t[0]) : null;
        t.shift();
        parts.password = t[0] ? URI.decode(t.join(':')) : null;
        string = string.substring(pos + 1);
    } else {
        parts.username = null;
        parts.password = null;
    }

    return string;
};
URI.parseQuery = function(string, escapeQuerySpace) {
    if (!string) {
        return {};
    }

    // throw out the funky business - "?"[name"="value"&"]+
    string = string.replace(/&+/g, '&').replace(/^\?*&*|&+$/g, '');

    if (!string) {
        return {};
    }

    var items = {};
    var splits = string.split('&');
    var length = splits.length;
    var v, name, value;

    for (var i = 0; i < length; i++) {
        v = splits[i].split('=');
        name = URI.decodeQuery(v.shift(), escapeQuerySpace);
        // no "=" is null according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#collect-url-parameters
        value = v.length ? URI.decodeQuery(v.join('='), escapeQuerySpace) : null;

        if (items[name]) {
            if (typeof items[name] === "string") {
                items[name] = [items[name]];
            }

            items[name].push(value);
        } else {
            items[name] = value;
        }
    }

    return items;
};

URI.build = function(parts) {
    var t = "";

    if (parts.protocol) {
        t += parts.protocol + ":";
    }

    if (!parts.urn && (t || parts.hostname)) {
        t += '//';
    }

    t += (URI.buildAuthority(parts) || '');

    if (typeof parts.path === "string") {
        if (parts.path.charAt(0) !== '/' && typeof parts.hostname === "string") {
            t += '/';
        }

        t += parts.path;
    }

    if (typeof parts.query === "string" && parts.query) {
        t += '?' + parts.query;
    }

    if (typeof parts.fragment === "string" && parts.fragment) {
        t += '#' + parts.fragment;
    }
    return t;
};
URI.buildHost = function(parts) {
    var t = "";

    if (!parts.hostname) {
        return "";
    } else if (URI.ip6_expression.test(parts.hostname)) {
        if (parts.port) {
            t += "[" + parts.hostname + "]:" + parts.port;
        } else {
            // don't know if we should always wrap IPv6 in []
            // the RFC explicitly says SHOULD, not MUST.
            t += parts.hostname;
        }
    } else {
        t += parts.hostname;
        if (parts.port) {
            t += ':' + parts.port;
        }
    }

    return t;
};
URI.buildAuthority = function(parts) {
    return URI.buildUserinfo(parts) + URI.buildHost(parts);
};
URI.buildUserinfo = function(parts) {
    var t = "";

    if (parts.username) {
        t += URI.encode(parts.username);

        if (parts.password) {
            t += ':' + URI.encode(parts.password);
        }

        t += "@";
    }

    return t;
};
URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
    // according to http://tools.ietf.org/html/rfc3986 or http://labs.apache.org/webarch/uri/rfc/rfc3986.html
    // being »-._~!$&'()*+,;=:@/?« %HEX and alnum are allowed
    // the RFC explicitly states ?/foo being a valid use case, no mention of parameter syntax!
    // URI.js treats the query string as being application/x-www-form-urlencoded
    // see http://www.w3.org/TR/REC-html40/interact/forms.html#form-content-type

    var t = "";
    var unique, key, i, length;
    for (key in data) {
        if (hasOwn.call(data, key) && key) {
            if (isArray(data[key])) {
                unique = {};
                for (i = 0, length = data[key].length; i < length; i++) {
                    if (data[key][i] !== undefined && unique[data[key][i] + ""] === undefined) {
                        t += "&" + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
                        if (duplicateQueryParameters !== true) {
                            unique[data[key][i] + ""] = true;
                        }
                    }
                }
            } else if (data[key] !== undefined) {
                t += '&' + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
            }
        }
    }

    return t.substring(1);
};
URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
    // http://www.w3.org/TR/REC-html40/interact/forms.html#form-content-type -- application/x-www-form-urlencoded
    // don't append "=" for null values, according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#url-parameter-serialization
    return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? "=" + URI.encodeQuery(value, escapeQuerySpace) : "");
};

URI.addQuery = function(data, name, value) {
    if (typeof name === "object") {
        for (var key in name) {
            if (hasOwn.call(name, key)) {
                URI.addQuery(data, key, name[key]);
            }
        }
    } else if (typeof name === "string") {
        if (data[name] === undefined) {
            data[name] = value;
            return;
        } else if (typeof data[name] === "string") {
            data[name] = [data[name]];
        }

        if (!isArray(value)) {
            value = [value];
        }

        data[name] = data[name].concat(value);
    } else {
        throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
    }
};
URI.removeQuery = function(data, name, value) {
    var i, length, key;

    if (isArray(name)) {
        for (i = 0, length = name.length; i < length; i++) {
            data[name[i]] = undefined;
        }
    } else if (typeof name === "object") {
        for (key in name) {
            if (hasOwn.call(name, key)) {
                URI.removeQuery(data, key, name[key]);
            }
        }
    } else if (typeof name === "string") {
        if (value !== undefined) {
            if (data[name] === value) {
                data[name] = undefined;
            } else if (isArray(data[name])) {
                data[name] = filterArrayValues(data[name], value);
            }
        } else {
            data[name] = undefined;
        }
    } else {
        throw new TypeError("URI.addQuery() accepts an object, string as the first parameter");
    }
};
URI.hasQuery = function(data, name, value, withinArray) {
    if (typeof name === "object") {
        for (var key in name) {
            if (hasOwn.call(name, key)) {
                if (!URI.hasQuery(data, key, name[key])) {
                    return false;
                }
            }
        }

        return true;
    } else if (typeof name !== "string") {
        throw new TypeError("URI.hasQuery() accepts an object, string as the name parameter");
    }

    switch (getType(value)) {
        case 'Undefined':
            // true if exists (but may be empty)
            return name in data; // data[name] !== undefined;

        case 'Boolean':
            // true if exists and non-empty
            var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
            return value === _booly;

        case 'Function':
            // allow complex comparison
            return !!value(data[name], name, data);

        case 'Array':
            if (!isArray(data[name])) {
                return false;
            }

            var op = withinArray ? arrayContains : arraysEqual;
            return op(data[name], value);

        case 'RegExp':
            if (!isArray(data[name])) {
                return Boolean(data[name] && data[name].match(value));
            }

            if (!withinArray) {
                return false;
            }

            return arrayContains(data[name], value);

        case 'Number':
            value = String(value);
            // omit break;
        case 'String':
            if (!isArray(data[name])) {
                return data[name] === value;
            }

            if (!withinArray) {
                return false;
            }

            return arrayContains(data[name], value);

        default:
            throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");
    }
};


URI.commonPath = function(one, two) {
    var length = Math.min(one.length, two.length);
    var pos;

    // find first non-matching character
    for (pos = 0; pos < length; pos++) {
        if (one.charAt(pos) !== two.charAt(pos)) {
            pos--;
            break;
        }
    }

    if (pos < 1) {
        return one.charAt(0) === two.charAt(0) && one.charAt(0) === '/' ? '/' : '';
    }

    // revert to last /
    if (one.charAt(pos) !== '/' || two.charAt(pos) !== '/') {
        pos = one.substring(0, pos).lastIndexOf('/');
    }

    return one.substring(0, pos + 1);
};

URI.withinString = function(string, callback) {
    // expression used is "gruber revised" (@gruber v2) determined to be the best solution in
    // a regex sprint we did a couple of ages ago at
    // * http://mathiasbynens.be/demo/url-regex
    // * http://rodneyrehm.de/t/url-regex.html

    return string.replace(URI.find_uri_expression, callback);
};

URI.ensureValidHostname = function(v) {
    // Theoretically URIs allow percent-encoding in Hostnames (according to RFC 3986)
    // they are not part of DNS and therefore ignored by URI.js

    if (v.match(URI.invalid_hostname_characters)) {
        // test punycode
        if (!punycode) {
            throw new TypeError("Hostname '" + v + "' contains characters other than [A-Z0-9.-] and Punycode.js is not available");
        }

        if (punycode.toASCII(v).match(URI.invalid_hostname_characters)) {
            throw new TypeError("Hostname '" + v + "' contains characters other than [A-Z0-9.-]");
        }
    }
};

// noConflict
URI.noConflict = function(removeAll) {
    if (removeAll) {
        var unconflicted = {
            URI: this.noConflict()
        };

        if (URITemplate && typeof URITemplate.noConflict == "function") {
            unconflicted.URITemplate = URITemplate.noConflict();
        }

        if (IPv6 && typeof IPv6.noConflict == "function") {
            unconflicted.IPv6 = IPv6.noConflict();
        }

        if (SecondLevelDomains && typeof SecondLevelDomains.noConflict == "function") {
            unconflicted.SecondLevelDomains = SecondLevelDomains.noConflict();
        }

        return unconflicted;
    } else if (root.URI === this) {
        root.URI = _URI;
    }

    return this;
};

p.build = function(deferBuild) {
    if (deferBuild === true) {
        this._deferred_build = true;
    } else if (deferBuild === undefined || this._deferred_build) {
        this._string = URI.build(this._parts);
        this._deferred_build = false;
    }

    return this;
};

p.clone = function() {
    return new URI(this);
};

p.valueOf = p.toString = function() {
    return this.build(false)._string;
};

// generate simple accessors
_parts = {protocol: 'protocol', username: 'username', password: 'password', hostname: 'hostname',  port: 'port'};
generateAccessor = function(_part){
    return function(v, build) {
        if (v === undefined) {
            return this._parts[_part] || "";
        } else {
            this._parts[_part] = v || null;
            this.build(!build);
            return this;
        }
    };
};

for (_part in _parts) {
    p[_part] = generateAccessor(_parts[_part]);
}

// generate accessors with optionally prefixed input
_parts = {query: '?', fragment: '#'};
generateAccessor = function(_part, _key){
    return function(v, build) {
        if (v === undefined) {
            return this._parts[_part] || "";
        } else {
            if (v !== null) {
                v = v + "";
                if (v.charAt(0) === _key) {
                    v = v.substring(1);
                }
            }

            this._parts[_part] = v;
            this.build(!build);
            return this;
        }
    };
};

for (_part in _parts) {
    p[_part] = generateAccessor(_part, _parts[_part]);
}

// generate accessors with prefixed output
_parts = {search: ['?', 'query'], hash: ['#', 'fragment']};
generateAccessor = function(_part, _key){
    return function(v, build) {
        var t = this[_part](v, build);
        return typeof t === "string" && t.length ? (_key + t) : t;
    };
};

for (_part in _parts) {
    p[_part] = generateAccessor(_parts[_part][1], _parts[_part][0]);
}

p.pathname = function(v, build) {
    if (v === undefined || v === true) {
        var res = this._parts.path || (this._parts.hostname ? '/' : '');
        return v ? URI.decodePath(res) : res;
    } else {
        this._parts.path = v ? URI.recodePath(v) : "/";
        this.build(!build);
        return this;
    }
};
p.path = p.pathname;
p.href = function(href, build) {
    var key;

    if (href === undefined) {
        return this.toString();
    }

    this._string = "";
    this._parts = URI._parts();

    var _URI = href instanceof URI;
    var _object = typeof href === "object" && (href.hostname || href.path || href.pathname);
    if (href.nodeName) {
        var attribute = URI.getDomAttribute(href);
        href = href[attribute] || "";
        _object = false;
    }

    // window.location is reported to be an object, but it's not the sort
    // of object we're looking for:
    // * location.protocol ends with a colon
    // * location.query != object.search
    // * location.hash != object.fragment
    // simply serializing the unknown object should do the trick
    // (for location, not for everything...)
    if (!_URI && _object && href.pathname !== undefined) {
        href = href.toString();
    }

    if (typeof href === "string") {
        this._parts = URI.parse(href, this._parts);
    } else if (_URI || _object) {
        var src = _URI ? href._parts : href;
        for (key in src) {
            if (hasOwn.call(this._parts, key)) {
                this._parts[key] = src[key];
            }
        }
    } else {
        throw new TypeError("invalid input");
    }

    this.build(!build);
    return this;
};

// identification accessors
p.is = function(what) {
    var ip = false;
    var ip4 = false;
    var ip6 = false;
    var name = false;
    var sld = false;
    var idn = false;
    var punycode = false;
    var relative = !this._parts.urn;

    if (this._parts.hostname) {
        relative = false;
        ip4 = URI.ip4_expression.test(this._parts.hostname);
        ip6 = URI.ip6_expression.test(this._parts.hostname);
        ip = ip4 || ip6;
        name = !ip;
        sld = name && SLD && SLD.has(this._parts.hostname);
        idn = name && URI.idn_expression.test(this._parts.hostname);
        punycode = name && URI.punycode_expression.test(this._parts.hostname);
    }

    switch (what.toLowerCase()) {
        case 'relative':
            return relative;

        case 'absolute':
            return !relative;

        // hostname identification
        case 'domain':
        case 'name':
            return name;

        case 'sld':
            return sld;

        case 'ip':
            return ip;

        case 'ip4':
        case 'ipv4':
        case 'inet4':
            return ip4;

        case 'ip6':
        case 'ipv6':
        case 'inet6':
            return ip6;

        case 'idn':
            return idn;

        case 'url':
            return !this._parts.urn;

        case 'urn':
            return !!this._parts.urn;

        case 'punycode':
            return punycode;
    }

    return null;
};

// component specific input validation
var _protocol = p.protocol;
var _port = p.port;
var _hostname = p.hostname;

p.protocol = function(v, build) {
    if (v !== undefined) {
        if (v) {
            // accept trailing ://
            v = v.replace(/:(\/\/)?$/, '');

            if (v.match(/[^a-zA-z0-9\.+-]/)) {
                throw new TypeError("Protocol '" + v + "' contains characters other than [A-Z0-9.+-]");
            }
        }
    }
    return _protocol.call(this, v, build);
};
p.scheme = p.protocol;
p.port = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v !== undefined) {
        if (v === 0) {
            v = null;
        }

        if (v) {
            v += "";
            if (v.charAt(0) === ":") {
                v = v.substring(1);
            }

            if (v.match(/[^0-9]/)) {
                throw new TypeError("Port '" + v + "' contains characters other than [0-9]");
            }
        }
    }
    return _port.call(this, v, build);
};
p.hostname = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v !== undefined) {
        var x = {};
        URI.parseHost(v, x);
        v = x.hostname;
    }
    return _hostname.call(this, v, build);
};

// compound accessors
p.host = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined) {
        return this._parts.hostname ? URI.buildHost(this._parts) : "";
    } else {
        URI.parseHost(v, this._parts);
        this.build(!build);
        return this;
    }
};
p.authority = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined) {
        return this._parts.hostname ? URI.buildAuthority(this._parts) : "";
    } else {
        URI.parseAuthority(v, this._parts);
        this.build(!build);
        return this;
    }
};
p.userinfo = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined) {
        if (!this._parts.username) {
            return "";
        }

        var t = URI.buildUserinfo(this._parts);
        return t.substring(0, t.length -1);
    } else {
        if (v[v.length-1] !== '@') {
            v += '@';
        }

        URI.parseUserinfo(v, this._parts);
        this.build(!build);
        return this;
    }
};
p.resource = function(v, build) {
    var parts;

    if (v === undefined) {
        return this.path() + this.search() + this.hash();
    }

    parts = URI.parse(v);
    this._parts.path = parts.path;
    this._parts.query = parts.query;
    this._parts.fragment = parts.fragment;
    this.build(!build);
    return this;
};

// fraction accessors
p.subdomain = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    // convenience, return "www" from "www.example.org"
    if (v === undefined) {
        if (!this._parts.hostname || this.is('IP')) {
            return "";
        }

        // grab domain and add another segment
        var end = this._parts.hostname.length - this.domain().length - 1;
        return this._parts.hostname.substring(0, end) || "";
    } else {
        var e = this._parts.hostname.length - this.domain().length;
        var sub = this._parts.hostname.substring(0, e);
        var replace = new RegExp('^' + escapeRegEx(sub));

        if (v && v.charAt(v.length - 1) !== '.') {
            v += ".";
        }

        if (v) {
            URI.ensureValidHostname(v);
        }

        this._parts.hostname = this._parts.hostname.replace(replace, v);
        this.build(!build);
        return this;
    }
};
p.domain = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (typeof v === 'boolean') {
        build = v;
        v = undefined;
    }

    // convenience, return "example.org" from "www.example.org"
    if (v === undefined) {
        if (!this._parts.hostname || this.is('IP')) {
            return "";
        }

        // if hostname consists of 1 or 2 segments, it must be the domain
        var t = this._parts.hostname.match(/\./g);
        if (t && t.length < 2) {
            return this._parts.hostname;
        }

        // grab tld and add another segment
        var end = this._parts.hostname.length - this.tld(build).length - 1;
        end = this._parts.hostname.lastIndexOf('.', end -1) + 1;
        return this._parts.hostname.substring(end) || "";
    } else {
        if (!v) {
            throw new TypeError("cannot set domain empty");
        }

        URI.ensureValidHostname(v);

        if (!this._parts.hostname || this.is('IP')) {
            this._parts.hostname = v;
        } else {
            var replace = new RegExp(escapeRegEx(this.domain()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v);
        }

        this.build(!build);
        return this;
    }
};
p.tld = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (typeof v === 'boolean') {
        build = v;
        v = undefined;
    }

    // return "org" from "www.example.org"
    if (v === undefined) {
        if (!this._parts.hostname || this.is('IP')) {
            return "";
        }

        var pos = this._parts.hostname.lastIndexOf('.');
        var tld = this._parts.hostname.substring(pos + 1);

        if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
            return SLD.get(this._parts.hostname) || tld;
        }

        return tld;
    } else {
        var replace;

        if (!v) {
            throw new TypeError("cannot set TLD empty");
        } else if (v.match(/[^a-zA-Z0-9-]/)) {
            if (SLD && SLD.is(v)) {
                replace = new RegExp(escapeRegEx(this.tld()) + "$");
                this._parts.hostname = this._parts.hostname.replace(replace, v);
            } else {
                throw new TypeError("TLD '" + v + "' contains characters other than [A-Z0-9]");
            }
        } else if (!this._parts.hostname || this.is('IP')) {
            throw new ReferenceError("cannot set TLD on non-domain host");
        } else {
            replace = new RegExp(escapeRegEx(this.tld()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v);
        }

        this.build(!build);
        return this;
    }
};
p.directory = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined || v === true) {
        if (!this._parts.path && !this._parts.hostname) {
            return '';
        }

        if (this._parts.path === '/') {
            return '/';
        }

        var end = this._parts.path.length - this.filename().length - 1;
        var res = this._parts.path.substring(0, end) || (this._parts.hostname ? "/" : "");

        return v ? URI.decodePath(res) : res;

    } else {
        var e = this._parts.path.length - this.filename().length;
        var directory = this._parts.path.substring(0, e);
        var replace = new RegExp('^' + escapeRegEx(directory));

        // fully qualifier directories begin with a slash
        if (!this.is('relative')) {
            if (!v) {
                v = '/';
            }

            if (v.charAt(0) !== '/') {
                v = "/" + v;
            }
        }

        // directories always end with a slash
        if (v && v.charAt(v.length - 1) !== '/') {
            v += '/';
        }

        v = URI.recodePath(v);
        this._parts.path = this._parts.path.replace(replace, v);
        this.build(!build);
        return this;
    }
};
p.filename = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined || v === true) {
        if (!this._parts.path || this._parts.path === '/') {
            return "";
        }

        var pos = this._parts.path.lastIndexOf('/');
        var res = this._parts.path.substring(pos+1);

        return v ? URI.decodePathSegment(res) : res;
    } else {
        var mutatedDirectory = false;

        if (v.charAt(0) === '/') {
            v = v.substring(1);
        }

        if (v.match(/\.?\//)) {
            mutatedDirectory = true;
        }

        var replace = new RegExp(escapeRegEx(this.filename()) + "$");
        v = URI.recodePath(v);
        this._parts.path = this._parts.path.replace(replace, v);

        if (mutatedDirectory) {
            this.normalizePath(build);
        } else {
            this.build(!build);
        }

        return this;
    }
};
p.suffix = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined || v === true) {
        if (!this._parts.path || this._parts.path === '/') {
            return "";
        }

        var filename = this.filename();
        var pos = filename.lastIndexOf('.');
        var s, res;

        if (pos === -1) {
            return "";
        }

        // suffix may only contain alnum characters (yup, I made this up.)
        s = filename.substring(pos+1);
        res = (/^[a-z0-9%]+$/i).test(s) ? s : "";
        return v ? URI.decodePathSegment(res) : res;
    } else {
        if (v.charAt(0) === '.') {
            v = v.substring(1);
        }

        var suffix = this.suffix();
        var replace;

        if (!suffix) {
            if (!v) {
                return this;
            }

            this._parts.path += '.' + URI.recodePath(v);
        } else if (!v) {
            replace = new RegExp(escapeRegEx("." + suffix) + "$");
        } else {
            replace = new RegExp(escapeRegEx(suffix) + "$");
        }

        if (replace) {
            v = URI.recodePath(v);
            this._parts.path = this._parts.path.replace(replace, v);
        }

        this.build(!build);
        return this;
    }
};
p.segment = function(segment, v, build) {
    var separator = this._parts.urn ? ':' : '/';
    var path = this.path();
    var absolute = path.substring(0, 1) === '/';
    var segments = path.split(separator);

    if (segment !== undefined && typeof segment !== 'number') {
        build = v;
        v = segment;
        segment = undefined;
    }

    if (segment !== undefined && typeof segment !== 'number') {
        throw new Error("Bad segment '" + segment + "', must be 0-based integer");
    }

    if (absolute) {
        segments.shift();
    }

    if (segment < 0) {
        // allow negative indexes to address from the end
        segment = Math.max(segments.length + segment, 0);
    }

    if (v === undefined) {
        return segment === undefined
            ? segments
            : segments[segment];
    } else if (segment === null || segments[segment] === undefined) {
        if (isArray(v)) {
            segments = [];
            // collapse empty elements within array
            for (var i=0, l=v.length; i < l; i++) {
                if (!v[i].length && (!segments.length || !segments[segments.length -1].length)) {
                    continue;
                }

                if (segments.length && !segments[segments.length -1].length) {
                    segments.pop();
                }

                segments.push(v[i]);
            }
        } else if (v || (typeof v === "string")) {
            if (segments[segments.length -1] === "") {
                // empty trailing elements have to be overwritten
                // to prevent results such as /foo//bar
                segments[segments.length -1] = v;
            } else {
                segments.push(v);
            }
        }
    } else {
        if (v || (typeof v === "string" && v.length)) {
            segments[segment] = v;
        } else {
            segments.splice(segment, 1);
        }
    }

    if (absolute) {
        segments.unshift("");
    }

    return this.path(segments.join(separator), build);
};
p.segmentCoded = function(segment, v, build) {
    var segments, i, l;

    if (typeof segment !== 'number') {
        build = v;
        v = segment;
        segment = undefined;
    }

    if (v === undefined) {
        segments = this.segment(segment, v, build);
        if (!isArray(segments)) {
            segments = segments !== undefined ? URI.decode(segments) : undefined;
        } else {
            for (i = 0, l = segments.length; i < l; i++) {
                segments[i] = URI.decode(segments[i]);
            }
        }

        return segments;
    }

    if (!isArray(v)) {
        v = typeof v === 'string' ? URI.encode(v) : v;
    } else {
        for (i = 0, l = v.length; i < l; i++) {
            v[i] = URI.decode(v[i]);
        }
    }

    return this.segment(segment, v, build);
};

// mutating query string
var q = p.query;
p.query = function(v, build) {
    if (v === true) {
        return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    } else if (typeof v === "function") {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        var result = v.call(this, data);
        this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        this.build(!build);
        return this;
    } else if (v !== undefined && typeof v !== "string") {
        this._parts.query = URI.buildQuery(v, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        this.build(!build);
        return this;
    } else {
        return q.call(this, v, build);
    }
};
p.setQuery = function(name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);

    if (typeof name === "object") {
        for (var key in name) {
            if (hasOwn.call(name, key)) {
                data[key] = name[key];
            }
        }
    } else if (typeof name === "string") {
        data[name] = value !== undefined ? value : null;
    } else {
        throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
    }

    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== "string") {
        build = value;
    }

    this.build(!build);
    return this;
};
p.addQuery = function(name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    URI.addQuery(data, name, value === undefined ? null : value);
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== "string") {
        build = value;
    }

    this.build(!build);
    return this;
};
p.removeQuery = function(name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    URI.removeQuery(data, name, value);
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== "string") {
        build = value;
    }

    this.build(!build);
    return this;
};
p.hasQuery = function(name, value, withinArray) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    return URI.hasQuery(data, name, value, withinArray);
};
p.setSearch = p.setQuery;
p.addSearch = p.addQuery;
p.removeSearch = p.removeQuery;
p.hasSearch = p.hasQuery;

// sanitizing URLs
p.normalize = function() {
    if (this._parts.urn) {
        return this
            .normalizeProtocol(false)
            .normalizeQuery(false)
            .normalizeFragment(false)
            .build();
    }

    return this
        .normalizeProtocol(false)
        .normalizeHostname(false)
        .normalizePort(false)
        .normalizePath(false)
        .normalizeQuery(false)
        .normalizeFragment(false)
        .build();
};
p.normalizeProtocol = function(build) {
    if (typeof this._parts.protocol === "string") {
        this._parts.protocol = this._parts.protocol.toLowerCase();
        this.build(!build);
    }

    return this;
};
p.normalizeHostname = function(build) {
    if (this._parts.hostname) {
        if (this.is('IDN') && punycode) {
            this._parts.hostname = punycode.toASCII(this._parts.hostname);
        } else if (this.is('IPv6') && IPv6) {
            this._parts.hostname = IPv6.best(this._parts.hostname);
        }

        this._parts.hostname = this._parts.hostname.toLowerCase();
        this.build(!build);
    }

    return this;
};
p.normalizePort = function(build) {
    // remove port of it's the protocol's default
    if (typeof this._parts.protocol === "string" && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
        this._parts.port = null;
        this.build(!build);
    }

    return this;
};
p.normalizePath = function(build) {
    if (this._parts.urn) {
        return this;
    }

    if (!this._parts.path || this._parts.path === '/') {
        return this;
    }

    var _was_relative;
    var _path = this._parts.path;
    var _parent, _pos;

    // handle relative paths
    if (_path.charAt(0) !== '/') {
        _was_relative = true;
        _path = '/' + _path;
    }

    // resolve simples
    _path = _path
        .replace(/(\/(\.\/)+)|(\/\.$)/g, '/')
        .replace(/\/{2,}/g, '/');

    // resolve parents
    while (true) {
        _parent = _path.indexOf('/../');
        if (_parent === -1) {
            // no more ../ to resolve
            break;
        } else if (_parent === 0) {
            // top level cannot be relative...
            _path = _path.substring(3);
            break;
        }

        _pos = _path.substring(0, _parent).lastIndexOf('/');
        if (_pos === -1) {
            _pos = _parent;
        }
        _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
    }

    // revert to relative
    if (_was_relative && this.is('relative')) {
        _path = _path.substring(1);
    }

    _path = URI.recodePath(_path);
    this._parts.path = _path;
    this.build(!build);
    return this;
};
p.normalizePathname = p.normalizePath;
p.normalizeQuery = function(build) {
    if (typeof this._parts.query === "string") {
        if (!this._parts.query.length) {
            this._parts.query = null;
        } else {
            this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
        }

        this.build(!build);
    }

    return this;
};
p.normalizeFragment = function(build) {
    if (!this._parts.fragment) {
        this._parts.fragment = null;
        this.build(!build);
    }

    return this;
};
p.normalizeSearch = p.normalizeQuery;
p.normalizeHash = p.normalizeFragment;

p.iso8859 = function() {
    // expect unicode input, iso8859 output
    var e = URI.encode;
    var d = URI.decode;

    URI.encode = escape;
    URI.decode = decodeURIComponent;
    this.normalize();
    URI.encode = e;
    URI.decode = d;
    return this;
};

p.unicode = function() {
    // expect iso8859 input, unicode output
    var e = URI.encode;
    var d = URI.decode;

    URI.encode = strictEncodeURIComponent;
    URI.decode = unescape;
    this.normalize();
    URI.encode = e;
    URI.decode = d;
    return this;
};

p.readable = function() {
    var uri = this.clone();
    // removing username, password, because they shouldn't be displayed according to RFC 3986
    uri.username("").password("").normalize();
    var t = '';
    if (uri._parts.protocol) {
        t += uri._parts.protocol + '://';
    }

    if (uri._parts.hostname) {
        if (uri.is('punycode') && punycode) {
            t += punycode.toUnicode(uri._parts.hostname);
            if (uri._parts.port) {
                t += ":" + uri._parts.port;
            }
        } else {
            t += uri.host();
        }
    }

    if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== '/') {
        t += '/';
    }

    t += uri.path(true);
    if (uri._parts.query) {
        var q = '';
        for (var i = 0, qp = uri._parts.query.split('&'), l = qp.length; i < l; i++) {
            var kv = (qp[i] || "").split('=');
            q += '&' + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace)
                .replace(/&/g, '%26');

            if (kv[1] !== undefined) {
                q += "=" + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace)
                    .replace(/&/g, '%26');
            }
        }
        t += '?' + q.substring(1);
    }

    t += URI.decodeQuery(uri.hash(), true);
    return t;
};

// resolving relative and absolute URLs
p.absoluteTo = function(base) {
    var resolved = this.clone();
    var properties = ['protocol', 'username', 'password', 'hostname', 'port'];
    var basedir, i, p;

    if (this._parts.urn) {
        throw new Error('URNs do not have any generally defined hierarchical components');
    }

    if (!(base instanceof URI)) {
        base = new URI(base);
    }

    if (!resolved._parts.protocol) {
        resolved._parts.protocol = base._parts.protocol;
    }

    if (this._parts.hostname) {
        return resolved;
    }

    for (i = 0; p = properties[i]; i++) {
        resolved._parts[p] = base._parts[p];
    }

    properties = ['query', 'path'];
    for (i = 0; p = properties[i]; i++) {
        if (!resolved._parts[p] && base._parts[p]) {
            resolved._parts[p] = base._parts[p];
        }
    }

    if (resolved.path().charAt(0) !== '/') {
        basedir = base.directory();
        resolved._parts.path = (basedir ? (basedir + '/') : '') + resolved._parts.path;
        resolved.normalizePath();
    }

    resolved.build();
    return resolved;
};
p.relativeTo = function(base) {
    var relative = this.clone().normalize();
    var relativeParts, baseParts, common, relativePath, basePath;

    if (relative._parts.urn) {
        throw new Error('URNs do not have any generally defined hierarchical components');
    }

    base = new URI(base).normalize();
    relativeParts = relative._parts;
    baseParts = base._parts;
    relativePath = relative.path();
    basePath = base.path();

    if (relativePath.charAt(0) !== '/') {
        throw new Error('URI is already relative');
    }

    if (basePath.charAt(0) !== '/') {
        throw new Error('Cannot calculate a URI relative to another relative URI');
    }

    if (relativeParts.protocol === baseParts.protocol) {
        relativeParts.protocol = null;
    }

    if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
        return relative.build();
    }

    if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
        return relative.build();
    }

    if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
        relativeParts.hostname = null;
        relativeParts.port = null;
    } else {
        return relative.build();
    }

    if (relativePath === basePath) {
        relativeParts.path = '';
        return relative.build();
    }

    // determine common sub path
    common = URI.commonPath(relative.path(), base.path());

    // If the paths have nothing in common, return a relative URL with the absolute path.
    if (!common) {
        return relative.build();
    }

    var parents = baseParts.path
        .substring(common.length)
        .replace(/[^\/]*$/, '')
        .replace(/.*?\//g, '../');

    relativeParts.path = parents + relativeParts.path.substring(common.length);

    return relative.build();
};

// comparing URIs
p.equals = function(uri) {
    var one = this.clone();
    var two = new URI(uri);
    var one_map = {};
    var two_map = {};
    var checked = {};
    var one_query, two_query, key;

    one.normalize();
    two.normalize();

    // exact match
    if (one.toString() === two.toString()) {
        return true;
    }

    // extract query string
    one_query = one.query();
    two_query = two.query();
    one.query("");
    two.query("");

    // definitely not equal if not even non-query parts match
    if (one.toString() !== two.toString()) {
        return false;
    }

    // query parameters have the same length, even if they're permuted
    if (one_query.length !== two_query.length) {
        return false;
    }

    one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
    two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);

    for (key in one_map) {
        if (hasOwn.call(one_map, key)) {
            if (!isArray(one_map[key])) {
                if (one_map[key] !== two_map[key]) {
                    return false;
                }
            } else if (!arraysEqual(one_map[key], two_map[key])) {
                return false;
            }

            checked[key] = true;
        }
    }

    for (key in two_map) {
        if (hasOwn.call(two_map, key)) {
            if (!checked[key]) {
                // two contains a parameter not present in one
                return false;
            }
        }
    }

    return true;
};

// state
p.duplicateQueryParameters = function(v) {
    this._parts.duplicateQueryParameters = !!v;
    return this;
};

p.escapeQuerySpace = function(v) {
    this._parts.escapeQuerySpace = !!v;
    return this;
};

return URI;
}));
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global Node, window */
/*
 * A polyfill for document.baseURI (mainly targeting IE11).
 *
 * Implemented as a property getter to also support dynamically created &lt;base&gt; tags.
 */
if ( !('baseURI' in Node.prototype) ) {
	Object.defineProperty(Node.prototype, 'baseURI', {
		get: function() {
			var doc = this.ownerDocument || this, // a Document node returns ownerDocument null
				// look for first base tag with an href attribute
				// (https://html.spec.whatwg.org/multipage/urls-and-fetching.html#document-base-url )
				baseOrLoc = doc.querySelector("base[href]") || window.location;
			return baseOrLoc.href;
		},
		configurable: true
	});
}
/* Copyright Google Inc.
 * Licensed under the Apache Licence Version 2.0
 * Autogenerated at Tue May 22 10:18:21 PDT 2012
 * \@overrides window
 * \@provides cssSchema, CSS_PROP_BIT_QUANTITY, CSS_PROP_BIT_HASH_VALUE, CSS_PROP_BIT_NEGATIVE_QUANTITY, CSS_PROP_BIT_QSTRING_CONTENT, CSS_PROP_BIT_QSTRING_URL, CSS_PROP_BIT_HISTORY_INSENSITIVE, CSS_PROP_BIT_Z_INDEX, CSS_PROP_BIT_ALLOWED_IN_LINK */
/**
 * @const
 * @type {number}
 */
var CSS_PROP_BIT_QUANTITY = 1;
/**
 * @const
 * @type {number}
 */
var CSS_PROP_BIT_HASH_VALUE = 2;
/**
 * @const
 * @type {number}
 */
var CSS_PROP_BIT_NEGATIVE_QUANTITY = 4;
/**
 * @const
 * @type {number}
 */
var CSS_PROP_BIT_QSTRING_CONTENT = 8;
/**
 * @const
 * @type {number}
 */
var CSS_PROP_BIT_QSTRING_URL = 16;
/**
 * @const
 * @type {number}
 */
var CSS_PROP_BIT_HISTORY_INSENSITIVE = 32;
/**
 * @const
 * @type {number}
 */
var CSS_PROP_BIT_Z_INDEX = 64;
/**
 * @const
 * @type {number}
 */
var CSS_PROP_BIT_ALLOWED_IN_LINK = 128;
var cssSchema = (function () {
    var s = [
      'rgb(?:\\(\\s*(?:\\d+|0|\\d+(?:\\.\\d+)?%)\\s*,\\s*(?:\\d+|0|\\d+(?:\\.\\d+)?%)\\s*,\\s*(?:\\d+|0|\\d+(?:\\.\\d+)?%)|a\\(\\s*(?:\\d+|0|\\d+(?:\\.\\d+)?%)\\s*,\\s*(?:\\d+|0|\\d+(?:\\.\\d+)?%)\\s*,\\s*(?:\\d+|0|\\d+(?:\\.\\d+)?%)\\s*,\\s*(?:\\d+|0(?:\\.\\d+)?|\\.\\d+|1(?:\\.0+)?|0|\\d+(?:\\.\\d+)?%)) *\\)'
    ], c = [ /^ *$/i, RegExp('^ *(?:\\s*' + s[ 0 ] + '|(?:\\s*' + s[ 0 ] +
        ')?)+ *$', 'i'), RegExp('^ *\\s*' + s[ 0 ] + ' *$', 'i'),
      RegExp('^ *\\s*' + s[ 0 ] + '\\s*' + s[ 0 ] + ' *$', 'i') ], L = [ [
        'aliceblue', 'antiquewhite', 'aqua', 'aquamarine', 'azure', 'beige',
        'bisque', 'black', 'blanchedalmond', 'blue', 'blueviolet', 'brown',
        'burlywood', 'cadetblue', 'chartreuse', 'chocolate', 'coral',
        'cornflowerblue', 'cornsilk', 'crimson', 'cyan', 'darkblue',
        'darkcyan', 'darkgoldenrod', 'darkgray', 'darkgreen', 'darkkhaki',
        'darkmagenta', 'darkolivegreen', 'darkorange', 'darkorchid', 'darkred',
        'darksalmon', 'darkseagreen', 'darkslateblue', 'darkslategray',
        'darkturquoise', 'darkviolet', 'deeppink', 'deepskyblue', 'dimgray',
        'dodgerblue', 'firebrick', 'floralwhite', 'forestgreen', 'fuchsia',
        'gainsboro', 'ghostwhite', 'gold', 'goldenrod', 'gray', 'green',
        'greenyellow', 'honeydew', 'hotpink', 'indianred', 'indigo', 'ivory',
        'khaki', 'lavender', 'lavenderblush', 'lawngreen', 'lemonchiffon',
        'lightblue', 'lightcoral', 'lightcyan', 'lightgoldenrodyellow',
        'lightgreen', 'lightgrey', 'lightpink', 'lightsalmon', 'lightseagreen',
        'lightskyblue', 'lightslategray', 'lightsteelblue', 'lightyellow',
        'lime', 'limegreen', 'linen', 'magenta', 'maroon', 'mediumaquamarine',
        'mediumblue', 'mediumorchid', 'mediumpurple', 'mediumseagreen',
        'mediumslateblue', 'mediumspringgreen', 'mediumturquoise',
        'mediumvioletred', 'midnightblue', 'mintcream', 'mistyrose',
        'moccasin', 'navajowhite', 'navy', 'oldlace', 'olive', 'olivedrab',
        'orange', 'orangered', 'orchid', 'palegoldenrod', 'palegreen',
        'paleturquoise', 'palevioletred', 'papayawhip', 'peachpuff', 'peru',
        'pink', 'plum', 'powderblue', 'purple', 'red', 'rosybrown',
        'royalblue', 'saddlebrown', 'salmon', 'sandybrown', 'seagreen',
        'seashell', 'sienna', 'silver', 'skyblue', 'slateblue', 'slategray',
        'snow', 'springgreen', 'steelblue', 'tan', 'teal', 'thistle', 'tomato',
        'turquoise', 'violet', 'wheat', 'white', 'whitesmoke', 'yellow',
        'yellowgreen' ], [ 'all-scroll', 'col-resize', 'crosshair', 'default',
        'e-resize', 'hand', 'help', 'move', 'n-resize', 'ne-resize', 'no-drop',
        'not-allowed', 'nw-resize', 'pointer', 'progress', 'row-resize',
        's-resize', 'se-resize', 'sw-resize', 'text', 'vertical-text',
        'w-resize', 'wait' ], [ '-moz-inline-box', '-moz-inline-stack',
        'block', 'inline', 'inline-block', 'inline-table', 'list-item',
        'run-in', 'table', 'table-caption', 'table-cell', 'table-column',
        'table-column-group', 'table-footer-group', 'table-header-group',
        'table-row', 'table-row-group' ], [ 'armenian', 'circle', 'decimal',
        'decimal-leading-zero', 'disc', 'georgian', 'lower-alpha',
        'lower-greek', 'lower-latin', 'lower-roman', 'square', 'upper-alpha',
        'upper-latin', 'upper-roman' ], [ '100', '200', '300', '400', '500',
        '600', '700', '800', '900', 'bold', 'bolder', 'lighter' ], [
        'condensed', 'expanded', 'extra-condensed', 'extra-expanded',
        'narrower', 'semi-condensed', 'semi-expanded', 'ultra-condensed',
        'ultra-expanded', 'wider' ], [ 'behind', 'center-left', 'center-right',
        'far-left', 'far-right', 'left-side', 'leftwards', 'right-side',
        'rightwards' ], [ 'large', 'larger', 'small', 'smaller', 'x-large',
        'x-small', 'xx-large', 'xx-small' ], [ '-moz-pre-wrap', '-o-pre-wrap',
        '-pre-wrap', 'nowrap', 'pre', 'pre-line', 'pre-wrap' ], [ 'dashed',
        'dotted', 'double', 'groove', 'outset', 'ridge', 'solid' ], [
        'baseline', 'middle', 'sub', 'super', 'text-bottom', 'text-top' ], [
        'caption', 'icon', 'menu', 'message-box', 'small-caption', 'status-bar'
      ], [ 'fast', 'faster', 'slow', 'slower', 'x-fast', 'x-slow' ], [ 'above',
        'below', 'higher', 'level', 'lower' ], [ 'border-box', 'contain',
        'content-box', 'cover', 'padding-box' ], [ 'cursive', 'fantasy',
        'monospace', 'sans-serif', 'serif' ], [ 'loud', 'silent', 'soft',
        'x-loud', 'x-soft' ], [ 'no-repeat', 'repeat-x', 'repeat-y', 'round',
        'space' ], [ 'blink', 'line-through', 'overline', 'underline' ], [
        'high', 'low', 'x-high', 'x-low' ], [ 'absolute', 'relative', 'static'
      ], [ 'capitalize', 'lowercase', 'uppercase' ], [ 'child', 'female',
        'male' ], [ 'bidi-override', 'embed' ], [ 'bottom', 'top' ], [ 'clip',
        'ellipsis' ], [ 'continuous', 'digits' ], [ 'hide', 'show' ], [
        'inside', 'outside' ], [ 'italic', 'oblique' ], [ 'left', 'right' ], [
        'ltr', 'rtl' ], [ 'no-content', 'no-display' ], [ 'suppress',
        'unrestricted' ], [ 'thick', 'thin' ], [ ',' ], [ '/' ], [ 'always' ],
      [ 'auto' ], [ 'avoid' ], [ 'both' ], [ 'break-word' ], [ 'center' ], [
        'code' ], [ 'collapse' ], [ 'fixed' ], [ 'hidden' ], [ 'inherit' ], [
        'inset' ], [ 'invert' ], [ 'justify' ], [ 'local' ], [ 'medium' ], [
        'mix' ], [ 'none' ], [ 'normal' ], [ 'once' ], [ 'repeat' ], [ 'scroll'
      ], [ 'separate' ], [ 'small-caps' ], [ 'spell-out' ], [ 'transparent' ],
      [ 'visible' ] ];
    return {
      '-moz-border-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 36 ] ]
      },
      '-moz-border-radius-bottomleft': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-moz-border-radius-bottomright': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-moz-border-radius-topleft': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-moz-border-radius-topright': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-moz-box-shadow': {
        'cssExtra': c[ 1 ],
        'cssAlternates': [ 'boxShadow' ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 35 ], L[ 48 ], L[ 54 ] ]
      },
      '-moz-opacity': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 47 ] ]
      },
      '-moz-outline': {
        'cssExtra': c[ 3 ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 9 ], L[ 34 ], L[ 46 ], L[ 47 ], L[ 48 ], L[
            49 ], L[ 52 ], L[ 54 ] ]
      },
      '-moz-outline-color': {
        'cssExtra': c[ 2 ],
        'cssPropBits': 2,
        'cssLitGroup': [ L[ 0 ], L[ 47 ], L[ 49 ] ]
      },
      '-moz-outline-style': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 9 ], L[ 46 ], L[ 47 ], L[ 48 ], L[ 54 ] ]
      },
      '-moz-outline-width': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 34 ], L[ 47 ], L[ 52 ] ]
      },
      '-o-text-overflow': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 25 ] ]
      },
      '-webkit-border-bottom-left-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-webkit-border-bottom-right-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-webkit-border-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 36 ] ]
      },
      '-webkit-border-radius-bottom-left': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-webkit-border-radius-bottom-right': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-webkit-border-radius-top-left': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-webkit-border-radius-top-right': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-webkit-border-top-left-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-webkit-border-top-right-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      '-webkit-box-shadow': {
        'cssExtra': c[ 1 ],
        'cssAlternates': [ 'boxShadow' ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 35 ], L[ 48 ], L[ 54 ] ]
      },
      'azimuth': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 6 ], L[ 30 ], L[ 42 ], L[ 47 ] ]
      },
      'background': {
        'cssExtra': RegExp('^ *(?:\\s*' + s[ 0 ] + '){0,2} *$', 'i'),
        'cssPropBits': 23,
        'cssLitGroup': [ L[ 0 ], L[ 14 ], L[ 17 ], L[ 24 ], L[ 30 ], L[ 35 ],
          L[ 36 ], L[ 38 ], L[ 42 ], L[ 45 ], L[ 47 ], L[ 51 ], L[ 54 ], L[ 57
          ], L[ 58 ], L[ 62 ] ]
      },
      'background-attachment': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 35 ], L[ 45 ], L[ 51 ], L[ 58 ] ]
      },
      'background-color': {
        'cssExtra': c[ 2 ],
        'cssPropBits': 130,
        'cssLitGroup': [ L[ 0 ], L[ 47 ], L[ 62 ] ]
      },
      'background-image': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 16,
        'cssLitGroup': [ L[ 35 ], L[ 54 ] ]
      },
      'background-position': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 24 ], L[ 30 ], L[ 35 ], L[ 42 ] ]
      },
      'background-repeat': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 17 ], L[ 35 ], L[ 57 ] ]
      },
      'border': {
        'cssExtra': c[ 3 ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 9 ], L[ 34 ], L[ 46 ], L[ 47 ], L[ 48 ], L[
            52 ], L[ 54 ], L[ 62 ] ]
      },
      'border-bottom': {
        'cssExtra': c[ 3 ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 9 ], L[ 34 ], L[ 46 ], L[ 47 ], L[ 48 ], L[
            52 ], L[ 54 ], L[ 62 ] ]
      },
      'border-bottom-color': {
        'cssExtra': c[ 2 ],
        'cssPropBits': 2,
        'cssLitGroup': [ L[ 0 ], L[ 47 ], L[ 62 ] ]
      },
      'border-bottom-left-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      'border-bottom-right-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      'border-bottom-style': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 9 ], L[ 46 ], L[ 47 ], L[ 48 ], L[ 54 ] ]
      },
      'border-bottom-width': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 34 ], L[ 47 ], L[ 52 ] ]
      },
      'border-collapse': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 44 ], L[ 47 ], L[ 59 ] ]
      },
      'border-color': {
        'cssExtra': RegExp('^ *(?:\\s*' + s[ 0 ] + '){1,4} *$', 'i'),
        'cssPropBits': 2,
        'cssLitGroup': [ L[ 0 ], L[ 47 ], L[ 62 ] ]
      },
      'border-left': {
        'cssExtra': c[ 3 ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 9 ], L[ 34 ], L[ 46 ], L[ 47 ], L[ 48 ], L[
            52 ], L[ 54 ], L[ 62 ] ]
      },
      'border-left-color': {
        'cssExtra': c[ 2 ],
        'cssPropBits': 2,
        'cssLitGroup': [ L[ 0 ], L[ 47 ], L[ 62 ] ]
      },
      'border-left-style': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 9 ], L[ 46 ], L[ 47 ], L[ 48 ], L[ 54 ] ]
      },
      'border-left-width': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 34 ], L[ 47 ], L[ 52 ] ]
      },
      'border-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 36 ] ]
      },
      'border-right': {
        'cssExtra': c[ 3 ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 9 ], L[ 34 ], L[ 46 ], L[ 47 ], L[ 48 ], L[
            52 ], L[ 54 ], L[ 62 ] ]
      },
      'border-right-color': {
        'cssExtra': c[ 2 ],
        'cssPropBits': 2,
        'cssLitGroup': [ L[ 0 ], L[ 47 ], L[ 62 ] ]
      },
      'border-right-style': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 9 ], L[ 46 ], L[ 47 ], L[ 48 ], L[ 54 ] ]
      },
      'border-right-width': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 34 ], L[ 47 ], L[ 52 ] ]
      },
      'border-spacing': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'border-style': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 9 ], L[ 46 ], L[ 47 ], L[ 48 ], L[ 54 ] ]
      },
      'border-top': {
        'cssExtra': c[ 3 ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 9 ], L[ 34 ], L[ 46 ], L[ 47 ], L[ 48 ], L[
            52 ], L[ 54 ], L[ 62 ] ]
      },
      'border-top-color': {
        'cssExtra': c[ 2 ],
        'cssPropBits': 2,
        'cssLitGroup': [ L[ 0 ], L[ 47 ], L[ 62 ] ]
      },
      'border-top-left-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      'border-top-right-radius': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5
      },
      'border-top-style': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 9 ], L[ 46 ], L[ 47 ], L[ 48 ], L[ 54 ] ]
      },
      'border-top-width': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 34 ], L[ 47 ], L[ 52 ] ]
      },
      'border-width': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 34 ], L[ 47 ], L[ 52 ] ]
      },
      'bottom': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'box-shadow': {
        'cssExtra': c[ 1 ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 35 ], L[ 48 ], L[ 54 ] ]
      },
      'caption-side': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 24 ], L[ 47 ] ]
      },
      'clear': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 30 ], L[ 40 ], L[ 47 ], L[ 54 ] ]
      },
      'clip': {
        'cssExtra':
        /^ *\s*rect\(\s*(?:0|[+\-]?\d+(?:\.\d+)?(?:[cem]m|ex|in|p[ctx])|auto)\s*,\s*(?:0|[+\-]?\d+(?:\.\d+)?(?:[cem]m|ex|in|p[ctx])|auto)\s*,\s*(?:0|[+\-]?\d+(?:\.\d+)?(?:[cem]m|ex|in|p[ctx])|auto)\s*,\s*(?:0|[+\-]?\d+(?:\.\d+)?(?:[cem]m|ex|in|p[ctx])|auto) *\) *$/i,
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'color': {
        'cssExtra': c[ 2 ],
        'cssPropBits': 130,
        'cssLitGroup': [ L[ 0 ], L[ 47 ] ]
      },
      'content': { 'cssPropBits': 0 },
      'counter-increment': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ], L[ 54 ] ]
      },
      'counter-reset': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ], L[ 54 ] ]
      },
      'cue': {
        'cssPropBits': 16,
        'cssLitGroup': [ L[ 47 ], L[ 54 ] ]
      },
      'cue-after': {
        'cssPropBits': 16,
        'cssLitGroup': [ L[ 47 ], L[ 54 ] ]
      },
      'cue-before': {
        'cssPropBits': 16,
        'cssLitGroup': [ L[ 47 ], L[ 54 ] ]
      },
      'cursor': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 144,
        'cssLitGroup': [ L[ 1 ], L[ 35 ], L[ 38 ], L[ 47 ] ]
      },
      'direction': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 31 ], L[ 47 ] ]
      },
      'display': {
        'cssPropBits': 32,
        'cssLitGroup': [ L[ 2 ], L[ 47 ], L[ 54 ] ]
      },
      'elevation': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 13 ], L[ 47 ] ]
      },
      'empty-cells': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 27 ], L[ 47 ] ]
      },
      'filter': {
        'cssExtra':
        /^ *(?:\s*alpha\(\s*opacity\s*=\s*(?:0|\d+(?:\.\d+)?%|[+\-]?\d+(?:\.\d+)?) *\))+ *$/i,
        'cssPropBits': 32
      },
      'float': {
        'cssAlternates': [ 'cssFloat', 'styleFloat' ],
        'cssPropBits': 32,
        'cssLitGroup': [ L[ 30 ], L[ 47 ], L[ 54 ] ]
      },
      'font': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 9,
        'cssLitGroup': [ L[ 4 ], L[ 7 ], L[ 11 ], L[ 15 ], L[ 29 ], L[ 35 ], L[
            36 ], L[ 47 ], L[ 52 ], L[ 55 ], L[ 60 ] ]
      },
      'font-family': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 8,
        'cssLitGroup': [ L[ 15 ], L[ 35 ], L[ 47 ] ]
      },
      'font-size': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 7 ], L[ 47 ], L[ 52 ] ]
      },
      'font-stretch': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 5 ], L[ 55 ] ]
      },
      'font-style': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 29 ], L[ 47 ], L[ 55 ] ]
      },
      'font-variant': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 47 ], L[ 55 ], L[ 60 ] ]
      },
      'font-weight': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 4 ], L[ 47 ], L[ 55 ] ]
      },
      'height': {
        'cssPropBits': 37,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'left': {
        'cssPropBits': 37,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'letter-spacing': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ], L[ 55 ] ]
      },
      'line-height': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 47 ], L[ 55 ] ]
      },
      'list-style': {
        'cssPropBits': 16,
        'cssLitGroup': [ L[ 3 ], L[ 28 ], L[ 47 ], L[ 54 ] ]
      },
      'list-style-image': {
        'cssPropBits': 16,
        'cssLitGroup': [ L[ 47 ], L[ 54 ] ]
      },
      'list-style-position': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 28 ], L[ 47 ] ]
      },
      'list-style-type': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 3 ], L[ 47 ], L[ 54 ] ]
      },
      'margin': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'margin-bottom': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'margin-left': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'margin-right': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'margin-top': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'max-height': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 38 ], L[ 47 ], L[ 54 ] ]
      },
      'max-width': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 38 ], L[ 47 ], L[ 54 ] ]
      },
      'min-height': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'min-width': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'opacity': {
        'cssPropBits': 33,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'outline': {
        'cssExtra': c[ 3 ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 9 ], L[ 34 ], L[ 46 ], L[ 47 ], L[ 48 ], L[
            49 ], L[ 52 ], L[ 54 ] ]
      },
      'outline-color': {
        'cssExtra': c[ 2 ],
        'cssPropBits': 2,
        'cssLitGroup': [ L[ 0 ], L[ 47 ], L[ 49 ] ]
      },
      'outline-style': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 9 ], L[ 46 ], L[ 47 ], L[ 48 ], L[ 54 ] ]
      },
      'outline-width': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 34 ], L[ 47 ], L[ 52 ] ]
      },
      'overflow': {
        'cssPropBits': 32,
        'cssLitGroup': [ L[ 38 ], L[ 46 ], L[ 47 ], L[ 58 ], L[ 63 ] ]
      },
      'overflow-x': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 32 ], L[ 38 ], L[ 46 ], L[ 58 ], L[ 63 ] ]
      },
      'overflow-y': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 32 ], L[ 38 ], L[ 46 ], L[ 58 ], L[ 63 ] ]
      },
      'padding': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'padding-bottom': {
        'cssPropBits': 33,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'padding-left': {
        'cssPropBits': 33,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'padding-right': {
        'cssPropBits': 33,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'padding-top': {
        'cssPropBits': 33,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'page-break-after': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 30 ], L[ 37 ], L[ 38 ], L[ 39 ], L[ 47 ] ]
      },
      'page-break-before': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 30 ], L[ 37 ], L[ 38 ], L[ 39 ], L[ 47 ] ]
      },
      'page-break-inside': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 38 ], L[ 39 ], L[ 47 ] ]
      },
      'pause': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'pause-after': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'pause-before': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'pitch': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 19 ], L[ 47 ], L[ 52 ] ]
      },
      'pitch-range': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'play-during': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 16,
        'cssLitGroup': [ L[ 38 ], L[ 47 ], L[ 53 ], L[ 54 ], L[ 57 ] ]
      },
      'position': {
        'cssPropBits': 32,
        'cssLitGroup': [ L[ 20 ], L[ 47 ] ]
      },
      'quotes': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 47 ], L[ 54 ] ]
      },
      'richness': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'right': {
        'cssPropBits': 37,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'speak': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 47 ], L[ 54 ], L[ 55 ], L[ 61 ] ]
      },
      'speak-header': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 37 ], L[ 47 ], L[ 56 ] ]
      },
      'speak-numeral': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 26 ], L[ 47 ] ]
      },
      'speak-punctuation': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 43 ], L[ 47 ], L[ 54 ] ]
      },
      'speech-rate': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 12 ], L[ 47 ], L[ 52 ] ]
      },
      'stress': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'table-layout': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 38 ], L[ 45 ], L[ 47 ] ]
      },
      'text-align': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 30 ], L[ 42 ], L[ 47 ], L[ 50 ] ]
      },
      'text-decoration': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 18 ], L[ 47 ], L[ 54 ] ]
      },
      'text-indent': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ] ]
      },
      'text-overflow': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 25 ] ]
      },
      'text-shadow': {
        'cssExtra': c[ 1 ],
        'cssPropBits': 7,
        'cssLitGroup': [ L[ 0 ], L[ 35 ], L[ 48 ], L[ 54 ] ]
      },
      'text-transform': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 21 ], L[ 47 ], L[ 54 ] ]
      },
      'text-wrap': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 33 ], L[ 54 ], L[ 55 ] ]
      },
      'top': {
        'cssPropBits': 37,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'unicode-bidi': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 23 ], L[ 47 ], L[ 55 ] ]
      },
      'vertical-align': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 10 ], L[ 24 ], L[ 47 ] ]
      },
      'visibility': {
        'cssPropBits': 32,
        'cssLitGroup': [ L[ 44 ], L[ 46 ], L[ 47 ], L[ 63 ] ]
      },
      'voice-family': {
        'cssExtra': c[ 0 ],
        'cssPropBits': 8,
        'cssLitGroup': [ L[ 22 ], L[ 35 ], L[ 47 ] ]
      },
      'volume': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 16 ], L[ 47 ], L[ 52 ] ]
      },
      'white-space': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 8 ], L[ 47 ], L[ 55 ] ]
      },
      'width': {
        'cssPropBits': 33,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'word-spacing': {
        'cssPropBits': 5,
        'cssLitGroup': [ L[ 47 ], L[ 55 ] ]
      },
      'word-wrap': {
        'cssPropBits': 0,
        'cssLitGroup': [ L[ 41 ], L[ 55 ] ]
      },
      'z-index': {
        'cssPropBits': 69,
        'cssLitGroup': [ L[ 38 ], L[ 47 ] ]
      },
      'zoom': {
        'cssPropBits': 1,
        'cssLitGroup': [ L[ 55 ] ]
      }
    };
  })();
if (typeof window !== 'undefined') {
  window['cssSchema'] = cssSchema;
}
// Copyright (C) 2011 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * A lexical scannar for CSS3 as defined at http://www.w3.org/TR/css3-syntax .
 *
 * @author Mike Samuel <mikesamuel@gmail.com>
 * \@provides lexCss, decodeCss
 * \@overrides window
 */

var lexCss;
var decodeCss;

(function () {

  /**
   * Decodes an escape sequence as specified in CSS3 section 4.1.
   * http://www.w3.org/TR/css3-syntax/#characters
   * @private
   */
  function decodeCssEscape(s) {
    var i = parseInt(s.substring(1), 16);
    // If parseInt didn't find a hex diigt, it returns NaN so return the
    // escaped character.
    // Otherwise, parseInt will stop at the first non-hex digit so there's no
    // need to worry about trailing whitespace.
    if (i > 0xffff) {
      // A supplemental codepoint.
      return i -= 0x10000,
        String.fromCharCode(
            0xd800 + (i >> 10),
            0xdc00 + (i & 0x3FF));
    } else if (i == i) {
      return String.fromCharCode(i);
    } else if (s[1] < ' ') {
      // "a backslash followed by a newline is ignored".
      return '';
    } else {
      return s[1];
    }
  }

  /**
   * Returns an equivalent CSS string literal given plain text: foo -> "foo".
   * @private
   */
  function escapeCssString(s, replacer) {
    return '"' + s.replace(/[\u0000-\u001f\\\"<>]/g, replacer) + '"';
  }

  /**
   * Maps chars to CSS escaped equivalents: "\n" -> "\\a ".
   * @private
   */
  function escapeCssStrChar(ch) {
    return cssStrChars[ch]
        || (cssStrChars[ch] = '\\' + ch.charCodeAt(0).toString(16) + ' ');
  }

  /**
   * Maps chars to URI escaped equivalents: "\n" -> "%0a".
   * @private
   */
  function escapeCssUrlChar(ch) {
    return cssUrlChars[ch]
        || (cssUrlChars[ch] = (ch < '\x10' ? '%0' : '%')
            + ch.charCodeAt(0).toString(16));
  }

  /**
   * Mapping of CSS special characters to escaped equivalents.
   * @private
   */
  var cssStrChars = {
    '\\': '\\\\'
  };

  /**
   * Mapping of CSS special characters to URL-escaped equivalents.
   * @private
   */
  var cssUrlChars = {
    '\\': '%5c'
  };

  // The comments below are copied from the CSS3 module syntax at
  // http://www.w3.org/TR/css3-syntax .
  // These string constants minify out when this is run-through closure
  // compiler.
  // Rules that have been adapted have comments prefixed with "Diff:", and
  // where rules have been combined to avoid back-tracking in the regex engine
  // or to work around limitations, there is a comment prefixed with
  // "NewRule:".

  // In the below, we assume CRLF and CR have been normalize to CR.

  // wc  ::=  #x9 | #xA | #xC | #xD | #x20
  var WC = '[\\t\\n\\f ]';
  // w  ::=  wc*
  var W = WC + '*';
  // nl  ::=  #xA | #xD #xA | #xD | #xC
  var NL = '[\\n\\f]';
  // nonascii  ::=  [#x80-#xD7FF#xE000-#xFFFD#x10000-#x10FFFF]
  // NewRule: Supplemental codepoints are represented as surrogate pairs in JS.
  var SURROGATE_PAIR = '[\\ud800-\\udbff][\\udc00-\\udfff]';
  var NONASCII = '[\\u0080-\\ud7ff\\ue000-\\ufffd]|' + SURROGATE_PAIR;
  // unicode  ::=  '\' [0-9a-fA-F]{1,6} wc?
  // NewRule: No point in having ESCAPE do (\\x|\\y)
  var UNICODE_TAIL = '[0-9a-fA-F]{1,6}' + WC + '?';
  var UNICODE = '\\\\' + UNICODE_TAIL;
  // escape  ::=  unicode
  //           | '\' [#x20-#x7E#x80-#xD7FF#xE000-#xFFFD#x10000-#x10FFFF]
  // NewRule: Below we use escape tail to efficiently match an escape or a
  // line continuation so we can decode string content.
  var ESCAPE_TAIL = '(?:' + UNICODE_TAIL
      + '|[\\u0020-\\u007e\\u0080-\\ud7ff\\ue000\\ufffd]|'
      + SURROGATE_PAIR + ')';
  var ESCAPE = '\\\\' + ESCAPE_TAIL;
  // urlchar  ::=  [#x9#x21#x23-#x26#x28-#x7E] | nonascii | escape
  var URLCHAR = '(?:[\\t\\x21\\x23-\\x26\\x28-\\x5b\\x5d-\\x7e]|'
      + NONASCII + '|' + ESCAPE + ')';
  // stringchar  ::= urlchar | #x20 | '\' nl
  // We ignore mismatched surrogate pairs inside strings, so stringchar
  // simplifies to a non-(quote|newline|backslash) or backslash any.
  // Since we normalize CRLF to a single code-unit, there is no special
  // handling needed for '\\' + CRLF.
  var STRINGCHAR = '[^\'"\\n\\f\\\\]|\\\\[\\s\\S]';
  // string  ::=  '"' (stringchar | "'")* '"' | "'" (stringchar | '"')* "'"
  var STRING = '"(?:\'|' + STRINGCHAR + ')*"'
      + '|\'(?:\"|' + STRINGCHAR + ')*\'';
  // num  ::=  [0-9]+ | [0-9]* '.' [0-9]+
  // Diff: We attach signs to num tokens.
  var NUM = '[-+]?(?:[0-9]+(?:[.][0-9]+)?|[.][0-9]+)';
  // nmstart  ::=  [a-zA-Z] | '_' | nonascii | escape
  var NMSTART = '(?:[a-zA-Z_]|' + NONASCII + '|' + ESCAPE + ')';
  // nmchar  ::=  [a-zA-Z0-9] | '-' | '_' | nonascii | escape
  var NMCHAR = '(?:[a-zA-Z0-9_-]|' + NONASCII + '|' + ESCAPE + ')';
  // name  ::=  nmchar+
  var NAME = NMCHAR + '+';
  // ident  ::=  '-'? nmstart nmchar*
  var IDENT = '-?' + NMSTART + NMCHAR + '*';

  // ATKEYWORD  ::=  '@' ident
  var ATKEYWORD = '@' + IDENT;
  // HASH  ::=  '#' name
  var HASH = '#' + NAME;
  // NUMBER  ::=  num
  var NUMBER = NUM;

  // NewRule: union of IDENT, ATKEYWORD, HASH, but excluding #[0-9].
  var WORD_TERM = '(?:@?-?' + NMSTART + '|#)' + NMCHAR + '*';

  // PERCENTAGE  ::=  num '%'
  var PERCENTAGE = NUM + '%';
  // DIMENSION  ::=  num ident
  var DIMENSION = NUM + IDENT;
  var NUMERIC_VALUE = NUM + '(?:%|' + IDENT + ')?';
  // URI  ::=  "url(" w (string | urlchar* ) w ")"
  var URI = 'url[(]' + W + '(?:' + STRING + '|' + URLCHAR + '*)' + W + '[)]';
  // UNICODE-RANGE  ::=  "U+" [0-9A-F?]{1,6} ('-' [0-9A-F]{1,6})?
  var UNICODE_RANGE = 'U[+][0-9A-F?]{1,6}(?:-[0-9A-F]{1,6})?';
  // CDO  ::=  "<\!--"
  var CDO = '<\!--';
  // CDC  ::=  "-->"
  var CDC = '-->';
  // S  ::=  wc+
  var S = WC + '+';
  // COMMENT  ::=  "/*" [^*]* '*'+ ([^/] [^*]* '*'+)* "/"
  // Diff: recognizes // comments.
  var COMMENT = '/(?:[*][^*]*[*]+(?:[^/][^*]*[*]+)*/|/[^\\n\\f]*)';
  // FUNCTION  ::=  ident '('
  // Diff: We exclude url explicitly.
  // TODO: should we be tolerant of "fn ("?
  var FUNCTION = '(?!url[(])' + IDENT + '[(]';
  // INCLUDES  ::=  "~="
  var INCLUDES = '~=';
  // DASHMATCH  ::=  "|="
  var DASHMATCH = '[|]=';
  // PREFIXMATCH  ::=  "^="
  var PREFIXMATCH = '[^]=';
  // SUFFIXMATCH  ::=  "$="
  var SUFFIXMATCH = '[$]=';
  // SUBSTRINGMATCH  ::=  "*="
  var SUBSTRINGMATCH = '[*]=';
  // NewRule: one rule for all the comparison operators.
  var CMP_OPS = '[~|^$*]=';
  // CHAR  ::=  any character not matched by the above rules, except for " or '
  // Diff: We exclude / and \ since they are handled above to prevent
  // /* without a following */ from combining when comments are concatenated.
  var CHAR = '[^"\'\\\\/]|/(?![/*])';
  // BOM  ::=  #xFEFF
  var BOM = '\\uFEFF';

  var CSS_TOKEN = new RegExp([
      BOM, UNICODE_RANGE, URI, FUNCTION, WORD_TERM, STRING, NUMERIC_VALUE,
      CDO, CDC, S, COMMENT, CMP_OPS, CHAR].join("|"), 'gi');

  /**
   * Decodes CSS escape sequences in a CSS string body.
   */
   decodeCss = function (css) {
     return css.replace(
         new RegExp('\\\\(?:' + ESCAPE_TAIL + '|' + NL + ')', 'g'),
         decodeCssEscape);
   };

  /**
   * Given CSS Text, returns an array of normalized tokens.
   * @param {string} cssText
   * @return {Array.<string>} tokens where all ignorable token sequences have
   *    been reduced to a single {@code " "} and all strings and
   *    {@code url(...)} tokens have been normalized to use double quotes as
   *    delimiters and to not otherwise contain double quotes.
   */
  lexCss = function (cssText) {
    cssText = '' + cssText;
    var tokens = cssText.replace(/\r\n?/g, '\n')  // Normalize CRLF & CR to LF.
        .match(CSS_TOKEN) || [];
    var j = 0;
    var last = ' ';
    for (var i = 0, n = tokens.length; i < n; ++i) {
      // Normalize all escape sequences.  We will have to re-escape some
      // codepoints in string and url(...) bodies but we already know the
      // boundaries.
      // We might mistakenly treat a malformed identifier like \22\20\22 as a
      // string, but that will not break any valid stylesheets since we requote
      // and re-escape in string below.
      var tok = decodeCss(tokens[i]);
      var len = tok.length;
      var cc = tok.charCodeAt(0);
      tok =
          // All strings should be double quoted, and the body should never
          // contain a double quote.
          (cc == '"'.charCodeAt(0) || cc == '\''.charCodeAt(0))
          ? escapeCssString(tok.substring(1, len - 1), escapeCssStrChar)
          // A breaking ignorable token should is replaced with a single space.
          : (cc == '/'.charCodeAt(0) && len > 1  // Comment.
             || tok == '\\' || tok == CDC || tok == CDO || tok == '\ufeff'
             // Characters in W.
             || cc <= ' '.charCodeAt(0))
          ? ' '
          // Make sure that all url(...)s are double quoted.
          : /url\(/i.test(tok)
          ? 'url(' + escapeCssString(
            tok.replace(
                new RegExp('^url\\(' + W + '["\']?|["\']?' + W + '\\)$', 'gi'),
                ''),
            escapeCssUrlChar)
            + ')'
          // Escapes in identifier like tokens will have been normalized above.
          : tok;
      // Merge adjacent space tokens.
      if (last != tok || tok != ' ') {
        tokens[j++] = last = tok;
      }
    }
    tokens.length = j;
    return tokens;
  };
})();

// Exports for closure compiler.
if (typeof window !== 'undefined') {
  window['lexCss'] = lexCss;
  window['decodeCss'] = decodeCss;
}
// Copyright (C) 2011 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview
 * JavaScript support for client-side CSS sanitization.
 * The CSS property schema API is defined in CssPropertyPatterns.java which
 * is used to generate css-defs.js.
 *
 * @author mikesamuel@gmail.com
 * \@requires CSS_PROP_BIT_ALLOWED_IN_LINK
 * \@requires CSS_PROP_BIT_HASH_VALUE
 * \@requires CSS_PROP_BIT_NEGATIVE_QUANTITY
 * \@requires CSS_PROP_BIT_QSTRING_CONTENT
 * \@requires CSS_PROP_BIT_QSTRING_URL
 * \@requires CSS_PROP_BIT_QUANTITY
 * \@requires CSS_PROP_BIT_Z_INDEX
 * \@requires cssSchema
 * \@requires decodeCss
 * \@requires html4
 * \@overrides window
 * \@requires parseCssStylesheet
 * \@provides sanitizeCssProperty
 * \@provides sanitizeCssSelectors
 * \@provides sanitizeStylesheet
 */

/**
 * Given a series of normalized CSS tokens, applies a property schema, as
 * defined in CssPropertyPatterns.java, and sanitizes the tokens in place.
 * @param property a property name.
 * @param propertySchema a property of cssSchema as defined by
 *    CssPropertyPatterns.java
 * @param tokens as parsed by lexCss.  Modified in place.
 * @param opt_naiveUriRewriter a URI rewriter; an object with a "rewrite"
 *     function that takes a URL and returns a safe URL.
 */
var sanitizeCssProperty = (function () {
  var NOEFFECT_URL = 'url("about:blank")';
  /**
   * The set of characters that need to be normalized inside url("...").
   * We normalize newlines because they are not allowed inside quoted strings,
   * normalize quote characters, angle-brackets, and asterisks because they
   * could be used to break out of the URL or introduce targets for CSS
   * error recovery.  We normalize parentheses since they delimit unquoted
   * URLs and calls and could be a target for error recovery.
   */
  var NORM_URL_REGEXP = /[\n\f\r\"\'()*<>]/g;
  /** The replacements for NORM_URL_REGEXP. */
  var NORM_URL_REPLACEMENTS = {
    '\n': '%0a',
    '\f': '%0c',
    '\r': '%0d',
    '"':  '%22',
    '\'': '%27',
    '(':  '%28',
    ')':  '%29',
    '*':  '%2a',
    '<':  '%3c',
    '>':  '%3e'
  };


  function normalizeUrl(s) {
    if ('string' === typeof s) {
      return 'url("' + s.replace(NORM_URL_REGEXP, normalizeUrlChar) + '")';
    } else {
      return NOEFFECT_URL;
    }
  }
  function normalizeUrlChar(ch) {
    return NORM_URL_REPLACEMENTS[ch];
  }

  // From RFC3986
  var URI_SCHEME_RE = new RegExp(
      '^' +
      '(?:' +
        '([^:\/?# ]+)' +         // scheme
      ':)?'
  );

  var ALLOWED_URI_SCHEMES = /^(?:https?|mailto)$/i;

  function safeUri(uri, prop, naiveUriRewriter) {
    if (!naiveUriRewriter) { return null; }
    var parsed = ('' + uri).match(URI_SCHEME_RE);
    if (parsed && (!parsed[1] || ALLOWED_URI_SCHEMES.test(parsed[1]))) {
      return naiveUriRewriter(uri, prop);
    } else {
      return null;
    }
  }

  function unionArrays(arrs) {
    var map = {};
    for (var i = arrs.length; --i >= 0;) {
      var arr = arrs[i];
      for (var j = arr.length; --j >= 0;) {
        map[arr[j]] = ALLOWED_LITERAL;
      }
    }
    return map;
  }

  /**
   * Normalize tokens within a function call they can match against
   * cssSchema[propName].cssExtra.
   * @return the exclusive end in tokens of the function call.
   */
  function normalizeFunctionCall(tokens, start) {
    var parenDepth = 1, end = start + 1, n = tokens.length;
    while (end < n && parenDepth) {
      // TODO: Can URLs appear in functions?
      var token = tokens[end++];
      parenDepth += (token === '(' ? 1 : token === ')' ? -1 : 0);
    }
    return end;
  }

  // Used as map value to avoid hasOwnProperty checks.
  var ALLOWED_LITERAL = {};

  return function (property, propertySchema, tokens, opt_naiveUriRewriter) {
    var propBits = propertySchema.cssPropBits;
    // Used to determine whether to treat quoted strings as URLs or
    // plain text content, and whether unrecognized keywords can be quoted
    // to treate ['Arial', 'Black'] equivalently to ['"Arial Black"'].
    var qstringBits = propBits & (
        CSS_PROP_BIT_QSTRING_CONTENT | CSS_PROP_BIT_QSTRING_URL);
    // TODO(mikesamuel): Figure out what to do with props like
    // content that admit both URLs and strings.

    // Used to join unquoted keywords into a single quoted string.
    var lastQuoted = NaN;
    var i = 0, k = 0;
    for (;i < tokens.length; ++i) {
      // Has the effect of normalizing hex digits, keywords,
      // and function names.
      var token = tokens[i].toLowerCase();
      var cc = token.charCodeAt(0), cc1, cc2, isnum1, isnum2, end;
      var litGroup, litMap;
      token = (
        // Strip out spaces.  Normally cssparser.js dumps these, but we
        // strip them out in case the content doesn't come via cssparser.js.
        (cc === ' '.charCodeAt(0)) ? ''
        : (cc === '"'.charCodeAt(0)) ? (  // Quoted string.
          (qstringBits === CSS_PROP_BIT_QSTRING_URL && opt_naiveUriRewriter)
          // Sanitize and convert to url("...") syntax.
          // Treat url content as case-sensitive.
          ? (normalizeUrl(safeUri(
                decodeCss(tokens[i].substring(1, token.length - 1)),
                property,
                opt_naiveUriRewriter)))
          // Drop if plain text content strings not allowed.
          : (qstringBits === CSS_PROP_BIT_QSTRING_CONTENT) ? token : '')
        // Preserve hash color literals if allowed.
        : (cc === '#'.charCodeAt(0) && /^#(?:[0-9a-f]{3}){1,2}$/.test(token))
        ? (propBits & CSS_PROP_BIT_HASH_VALUE ? token : '')
        : ('0'.charCodeAt(0) <= cc && cc <= '9'.charCodeAt(0))
        // A number starting with a digit.
        ? ((propBits & CSS_PROP_BIT_QUANTITY)
          ? ((propBits & CSS_PROP_BIT_Z_INDEX)
            ? (token.match(/^\d{1,7}$/) ? token : '')
            : token)
          : '')
        // Normalize quantities so they don't start with a '.' or '+' sign and
        // make sure they all have an integer component so can't be confused
        // with a dotted identifier.
        // This can't be done in the lexer since ".4" is a valid rule part.
        : (cc1 = token.charCodeAt(1),
           cc2 = token.charCodeAt(2),
           isnum1 = '0'.charCodeAt(0) <= cc1 && cc1 <= '9'.charCodeAt(0),
           isnum2 = '0'.charCodeAt(0) <= cc2 && cc2 <= '9'.charCodeAt(0),
           // +.5 -> 0.5 if allowed.
           (cc === '+'.charCodeAt(0)
            && (isnum1 || (cc1 === '.'.charCodeAt(0) && isnum2))))
          ? ((propBits & CSS_PROP_BIT_QUANTITY)
            ? ((propBits & CSS_PROP_BIT_Z_INDEX)
              ? (token.match(/^\+\d{1,7}$/) ? token : '')
              : ((isnum1 ? '' : '0') + token.substring(1)))
            : '')
        // -.5 -> -0.5 if allowed otherwise -> 0 if quantities allowed.
        : (cc === '-'.charCodeAt(0)
           && (isnum1 || (cc1 === '.'.charCodeAt(0) && isnum2)))
          ? ((propBits & CSS_PROP_BIT_NEGATIVE_QUANTITY)
             ? ((propBits & CSS_PROP_BIT_Z_INDEX)
               ? (token.match(/^\-\d{1,7}$/) ? token : '')
               : ((isnum1 ? '-' : '-0') + token.substring(1)))
             : ((propBits & CSS_PROP_BIT_QUANTITY) ? '0' : ''))
        // .5 -> 0.5 if allowed.
        : (cc === '.'.charCodeAt(0) && isnum1)
        ? ((propBits & CSS_PROP_BIT_QUANTITY) ? '0' + token : '')
        // Handle url("...") by rewriting the body.
        : ('url(' === token.substring(0, 4))
        ? ((opt_naiveUriRewriter && (qstringBits & CSS_PROP_BIT_QSTRING_URL))
           ? normalizeUrl(safeUri(
                tokens[i].substring(5, token.length - 2),
                property,
                opt_naiveUriRewriter))
           : '')
        // Handle func(...) and literal tokens
        // such as keywords and punctuation.
        : (
          // Step 1. Combine func(...) into something that can be compared
          // against propertySchema.cssExtra.
          (token.charAt(token.length-1) === '(')
          && (end = normalizeFunctionCall(tokens, i),
              // When tokens is
              //   ['x', ' ', 'rgb(', '255', ',', '0', ',', '0', ')', ' ', 'y']
              // and i is the index of 'rgb(' and end is the index of ')'
              // splices tokens to where i now is the index of the whole call:
              //   ['x', ' ', 'rgb( 255 , 0 , 0 )', ' ', 'y']
              tokens.splice(i, end - i,
                            token = tokens.slice(i, end).join(' '))),
          litGroup = propertySchema.cssLitGroup,
          litMap = (litGroup
                    ? (propertySchema.cssLitMap
                       // Lazily compute the union from litGroup.
                       || (propertySchema.cssLitMap = unionArrays(litGroup)))
                    : ALLOWED_LITERAL),  // A convenient empty object.
          (litMap[token] === ALLOWED_LITERAL
           || propertySchema.cssExtra && propertySchema.cssExtra.test(token)))
          // Token is in the literal map or matches extra.
          ? token
          : (/^\w+$/.test(token)
             && (qstringBits === CSS_PROP_BIT_QSTRING_CONTENT))
          // Quote unrecognized keywords so font names like
          //    Arial Bold
          // ->
          //    "Arial Bold"
          ? (lastQuoted+1 === k
             // If the last token was also a keyword that was quoted, then
             // combine this token into that.
             ? (tokens[lastQuoted] = tokens[lastQuoted]
                .substring(0, tokens[lastQuoted].length-1) + ' ' + token + '"',
                token = '')
             : (lastQuoted = k, '"' + token + '"'))
          // Disallowed.
          : '');
      if (token) {
        tokens[k++] = token;
      }
    }
    // For single URL properties, if the URL failed to pass the sanitizer,
    // then just drop it.
    if (k === 1 && tokens[0] === NOEFFECT_URL) { k = 0; }
    tokens.length = k;
  };
})();

/**
 * Given a series of tokens, returns two lists of sanitized selectors.
 * @param {Array.<string>} selectors In the form produces by csslexer.js.
 * @param {string} suffix a suffix that is added to all IDs and which is
 *    used as a CLASS names so that the returned selectors will only match
 *    nodes under one with suffix as a class name.
 *    If suffix is {@code "sfx"}, the selector
 *    {@code ["a", "#foo", " ", "b", ".bar"]} will be namespaced to
 *    {@code [".sfx", " ", "a", "#foo-sfx", " ", "b", ".bar"]}.
 * @return {Array.<Array.<string>>} an array of length 2 where the zeroeth
 *    element contains history-insensitive selectors and the first element
 *    contains history-sensitive selectors.
 */
function sanitizeCssSelectors(selectors, suffix) {
  // Produce two distinct lists of selectors to sequester selectors that are
  // history sensitive (:visited), so that we can disallow properties in the
  // property groups for the history sensitive ones.
  var historySensitiveSelectors = [];
  var historyInsensitiveSelectors = [];

  // Remove any spaces that are not operators.
  var k = 0, i;
  for (i = 0; i < selectors.length; ++i) {
    if (!(selectors[i] == ' '
          && (selectors[i-1] == '>' || selectors[i+1] == '>'))) {
      selectors[k++] = selectors[i];
    }
  }
  selectors.length = k;

  // Split around commas.  If there is an error in one of the comma separated
  // bits, we throw the whole away, but the failure of one selector does not
  // affect others.
  var n = selectors.length, start = 0;
  for (i = 0; i < n; ++i) {
    if (selectors[i] == ',') {
      processSelector(start, i);
      start = i+1;
    }
  }
  processSelector(start, n);


  function processSelector(start, end) {
    var historySensitive = false;

    // Space around commas is not an operator.
    if (selectors[start] === ' ') { ++start; }
    if (end-1 !== start && selectors[end] === ' ') { --end; }

    // Split the selector into element selectors, content around
    // space (ancestor operator) and '>' (descendant operator).
    var out = [];
    var lastOperator = start;
    var elSelector = '';
    for (var i = start; i < end; ++i) {
      var tok = selectors[i];
      var isChild = (tok === '>');
      if (isChild || tok === ' ') {
        // We've found the end of a single link in the selector chain.
        // We disallow absolute positions relative to html.
        elSelector = processElementSelector(lastOperator, i, false);
        if (!elSelector || (isChild && /^html/i.test(elSelector))) {
          return;
        }
        lastOperator = i+1;
        out.push(elSelector, isChild ? ' > ' : ' ');
      }
    }
    elSelector = processElementSelector(lastOperator, end, true);
    if (!elSelector) { return; }
    out.push(elSelector);

    function processElementSelector(start, end, last) {
      var debugStart = start, debugEnd = end;

      // Split the element selector into three parts.
      // DIV.foo#bar:hover
      //    ^       ^
      // el classes pseudo
      var element, classId, pseudoSelector, tok, elType;
      element = '';
      if (start < end) {
        tok = selectors[start].toLowerCase();
        if (tok === '*'
            || (tok === 'body' && start+1 !== end && !last)
            || ('number' === typeof (elType = html4.ELEMENTS[tok])
                && !(elType & html4.eflags.UNSAFE))) {
          ++start;
          element = tok;
        }
      }
      classId = '';
      while (start < end) {
        tok = selectors[start];
        if (tok.charAt(0) === '#') {
          if (/^#_|__$|[^#0-9A-Za-z:_\-]/.test(tok)) { return null; }
          // Rewrite ID elements to include the suffix.
          classId += tok + '-' + suffix;
        } else if (tok === '.') {
          if (++start < end
              && /^[0-9A-Za-z:_\-]+$/.test(tok = selectors[start])
              && !/^_|__$/.test(tok)) {
            classId += '.' + tok;
          } else {
            return null;
          }
        } else {
          break;
        }
        ++start;
      }
      pseudoSelector = '';
      if (start < end && selectors[start] === ':') {
        tok = selectors[++start];
        if (tok === 'visited' || tok === 'link') {
          if (!/^[a*]?$/.test(element)) {
            return null;
          }
          historySensitive = true;
          pseudoSelector = ':' + tok;
          element = 'a';
          ++start;
        }
      }
      if (start === end) {
        return element + classId + pseudoSelector;
      }
      return null;
    }


    var safeSelector = out.join('');
    if (/^body\b/.test(safeSelector)) {
      // Substitute the class that is attached to pseudo body elements for
      // the body element.
      safeSelector = '.vdoc-body___.' + suffix + safeSelector.substring(4);
    } else {
      // Namespace the selector so that it only matches under
      // a node with suffix in its CLASS attribute.
      safeSelector = '.' + suffix + ' ' + safeSelector;
    }

    (historySensitive
     ? historySensitiveSelectors
     : historyInsensitiveSelectors).push(safeSelector);
  }

  return [historyInsensitiveSelectors, historySensitiveSelectors];
}

var sanitizeStylesheet = (function () {
  var allowed = {};
  var cssMediaTypeWhitelist = {
    'braille': allowed,
    'embossed': allowed,
    'handheld': allowed,
    'print': allowed,
    'projection': allowed,
    'screen': allowed,
    'speech': allowed,
    'tty': allowed,
    'tv': allowed
  };

  /**
   * Given a series of sanitized tokens, removes any properties that would
   * leak user history if allowed to style links differently depending on
   * whether the linked URL is in the user's browser history.
   * @param {Array.<string>} blockOfProperties
   */
  function sanitizeHistorySensitive(blockOfProperties) {
    var elide = false;
    for (var i = 0, n = blockOfProperties.length; i < n-1; ++i) {
      var token = blockOfProperties[i];
      if (':' === blockOfProperties[i+1]) {
        elide = !(cssSchema[token].cssPropBits & CSS_PROP_BIT_ALLOWED_IN_LINK);
      }
      if (elide) { blockOfProperties[i] = ''; }
      if (';' === token) { elide = false; }
    }
    return blockOfProperties.join('');
  }

  /**
   * @param {string} cssText a string containing a CSS stylesheet.
   * @param {string} suffix a suffix that is added to all IDs and which is
   *    used as a CLASS names so that the returned selectors will only match
   *    nodes under one with suffix as a class name.
   *    If suffix is {@code "sfx"}, the selector
   *    {@code ["a", "#foo", " ", "b", ".bar"]} will be namespaced to
   *    {@code [".sfx", " ", "a", "#foo-sfx", " ", "b", ".bar"]}.
   * @param {function(string, string)} opt_naiveUriRewriter maps URLs of media
   *    (images, sounds) that appear as CSS property values to sanitized
   *    URLs or null if the URL should not be allowed as an external media
   *    file in sanitized CSS.
   */
  return function /*sanitizeStylesheet*/(
       cssText, suffix, opt_naiveUriRewriter) {
    var safeCss = void 0;
    // A stack describing the { ... } regions.
    // Null elements indicate blocks that should not be emitted.
    var blockStack = [];
    // True when the content of the current block should be left off safeCss.
    var elide = false;
    parseCssStylesheet(
        cssText,
        {
          startStylesheet: function () {
            safeCss = [];
          },
          endStylesheet: function () {
          },
          startAtrule: function (atIdent, headerArray) {
            if (elide) {
              atIdent = null;
            } else if (atIdent === '@media') {
              headerArray = headerArray.filter(
                function (mediaType) {
                  return cssMediaTypeWhitelist[mediaType] == allowed;
                });
              if (headerArray.length) {
                safeCss.push(atIdent, headerArray.join(','), '{');
              } else {
                atIdent = null;
              }
            } else {
              if (atIdent === '@import') {
                // TODO: Use a logger instead.
                if (window.console) {
                  window.console.log(
                      '@import ' + headerArray.join(' ') + ' elided');
                }
              }
              atIdent = null;  // Elide the block.
            }
            elide = !atIdent;
            blockStack.push(atIdent);
          },
          endAtrule: function () {
            var atIdent = blockStack.pop();
            if (!elide) {
              safeCss.push(';');
            }
            checkElide();
          },
          startBlock: function () {
            // There are no bare blocks in CSS, so we do not change the
            // block stack here, but instead in the events that bracket
            // blocks.
            if (!elide) {
              safeCss.push('{');
            }
          },
          endBlock: function () {
            if (!elide) {
              safeCss.push('}');
              elide = true;  // skip any semicolon from endAtRule.
            }
          },
          startRuleset: function (selectorArray) {
            var historySensitiveSelectors = void 0;
            var removeHistoryInsensitiveSelectors = false;
            if (!elide) {
              var selectors = sanitizeCssSelectors(selectorArray, suffix);
              var historyInsensitiveSelectors = selectors[0];
              historySensitiveSelectors = selectors[1];
              if (!historyInsensitiveSelectors.length
                  && !historySensitiveSelectors.length) {
                elide = true;
              } else {
                var selector = historyInsensitiveSelectors.join(', ');
                if (!selector) {
                  // If we have only history sensitive selectors,
                  // use an impossible rule so that we can capture the content
                  // for later processing by
                  // history insenstive content for use below.
                  selector = 'head > html';
                  removeHistoryInsensitiveSelectors = true;
                }
                safeCss.push(selector, '{');
              }
            }
            blockStack.push(
                elide
                ? null
                // Sometimes a single list of selectors is split in two,
                //   div, a:visited
                // because we want to allow some properties for DIV that
                // we don't want to allow for A:VISITED to avoid leaking
                // user history.
                // Store the history sensitive selectors and the position
                // where the block starts so we can later create a copy
                // of the permissive tokens, and filter it to handle the
                // history sensitive case.
                : {
                    historySensitiveSelectors: historySensitiveSelectors,
                    endOfSelectors: safeCss.length - 1,  // 1 is open curly
                    removeHistoryInsensitiveSelectors:
                       removeHistoryInsensitiveSelectors
                  });
          },
          endRuleset: function () {
            var rules = blockStack.pop();
            var propertiesEnd = safeCss.length;
            if (!elide) {
              safeCss.push('}');
              if (rules) {
                var extraSelectors = rules.historySensitiveSelectors;
                if (extraSelectors.length) {
                  var propertyGroupTokens = safeCss.slice(rules.endOfSelectors);
                  safeCss.push(extraSelectors.join(', '),
                               sanitizeHistorySensitive(propertyGroupTokens));
                }
              }
            }
            if (rules && rules.removeHistoryInsensitiveSelectors) {
              safeCss.splice(
                // -1 and +1 account for curly braces.
                rules.endOfSelectors - 1, propertiesEnd + 1);
            }
            checkElide();
          },
          declaration: function (property, valueArray) {
            if (!elide) {
              var schema = cssSchema[property];
              if (schema) {
                sanitizeCssProperty(property, schema, valueArray, opt_naiveUriRewriter);
                if (valueArray.length) {
                  safeCss.push(property, ':', valueArray.join(' '), ';');
                }
              }
            }
          }
        });
    function checkElide() {
      elide = blockStack.length !== 0
          && blockStack[blockStack.length-1] !== null;
    }
    return safeCss.join('');
  };
})();

// Exports for closure compiler.
if (typeof window !== 'undefined') {
  window['sanitizeCssProperty'] = sanitizeCssProperty;
  window['sanitizeCssSelectors'] = sanitizeCssSelectors;
  window['sanitizeStylesheet'] = sanitizeStylesheet;
}
// Copyright (C) 2010 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview
 * Utilities for dealing with CSS source code.
 *
 * @author mikesamuel@gmail.com
 * \@requires lexCss
 * \@overrides window
 * \@provides parseCssStylesheet, parseCssDeclarations
 */

/**
 * parseCssStylesheet takes a chunk of CSS text and a handler object with
 * methods that it calls as below:
 * <pre>
 * // At the beginning of a stylesheet.
 * handler.startStylesheet();
 *
 * // For an @foo rule ended by a semicolon: @import "foo.css";
 * handler.startAtrule('@import', ['"foo.css"']);
 * handler.endAtrule();
 *
 * // For an @foo rule ended with a block. @media print { ... }
 * handler.startAtrule('@media', ['print']);
 * handler.startBlock();
 * // Calls to contents elided.  Probably selectors and declarations as below.
 * handler.endBlock();
 * handler.endAtrule();
 *
 * // For a ruleset: p.clazz q, s { color: blue; }
 * handler.startRuleset(['p', '.', 'clazz', ' ', 'q', ',', ' ', 's']);
 * handler.declaration('color', ['blue']);
 * handler.endRuleset();
 *
 * // At the end of a stylesheet.
 * handler.endStylesheet();
 * </pre>
 * When errors are encountered, the parser drops the useless tokens and
 * attempts to resume parsing.
 *
 * @param {string} cssText CSS3 content to parse as a stylesheet.
 * @param {Object} handler An object like <pre>{
 *   startStylesheet: function () { ... },
 *   endStylesheet: function () { ... },
 *   startAtrule: function (atIdent, headerArray) { ... },
 *   endAtrule: function () { ... },
 *   startBlock: function () { ... },
 *   endBlock: function () { ... },
 *   startRuleset: function (selectorArray) { ... },
 *   endRuleset: function () { ... },
 *   declaration: function (property, valueArray) { ... },
 * }</pre>
 */
var parseCssStylesheet;

/**
 * parseCssDeclarations parses a run of declaration productions as seen in the
 * body of the HTML5 {@code style} attribute.
 *
 * @param {string} cssText CSS3 content to parse as a run of declarations.
 * @param {Object} handler An object like <pre>{
 *   declaration: function (property, valueArray) { ... },
 * }</pre>
 */
var parseCssDeclarations;

(function () {
  // stylesheet  : [ CDO | CDC | S | statement ]*;
  parseCssStylesheet = function(cssText, handler) {
    var toks = lexCss(cssText);
    if (handler.startStylesheet) { handler.startStylesheet(); }
    for (var i = 0, n = toks.length; i < n;) {
      // CDO and CDC ("<!--" and "-->") are converted to space by the lexer.
      i = toks[i] === ' ' ? i+1 : statement(toks, i, n, handler);
    }
    if (handler.endStylesheet) { handler.endStylesheet(); }
  };

  // statement   : ruleset | at-rule;
  function statement(toks, i, n, handler) {
    if (i < n) {
      var tok = toks[i];
      if (tok.charAt(0) === '@') {
        return atrule(toks, i, n, handler, true);
      } else {
        return ruleset(toks, i, n, handler);
      }
    } else {
      return i;
    }
  }

  // at-rule     : ATKEYWORD S* any* [ block | ';' S* ];
  function atrule(toks, i, n, handler, blockok) {
    var start = i++;
    while (i < n && toks[i] !== '{' && toks[i] !== ';') {
      ++i;
    }
    if (i < n && (blockok || toks[i] === ';')) {
      var s = start+1, e = i;
      if (s < n && toks[s] === ' ') { ++s; }
      if (e > s && toks[e-1] === ' ') { --e; }
      if (handler.startAtrule) {
        handler.startAtrule(toks[start].toLowerCase(), toks.slice(s, e));
      }
      i = (toks[i] === '{')
          ? block(toks, i, n, handler)
          : i+1;  // Skip over ';'
      if (handler.endAtrule) {
        handler.endAtrule();
      }
    }
    // Else we reached end of input or are missing a semicolon.
    // Drop the rule on the floor.
    return i;
  }

  // block       : '{' S* [ any | block | ATKEYWORD S* | ';' S* ]* '}' S*;
   // Assumes the leading '{' has been verified by callers.
  function block(toks, i, n, handler) {
    ++i; //  skip over '{'
    if (handler.startBlock) { handler.startBlock(); }
    while (i < n) {
      var ch = toks[i].charAt(0);
      if (ch == '}') {
        ++i;
        break;
      }
      if (ch === ' ' || ch === ';') {
        i = i+1;
      } else if (ch === '@') {
        i = atrule(toks, i, n, handler, false);
      } else if (ch === '{') {
        i = block(toks, i, n, handler);
      } else {
        // Instead of using (any* block) to subsume ruleset we allow either
        // blocks or rulesets with a non-blank selector.
        // This is more restrictive but does not require atrule specific
        // parse tree fixup to realize that the contents of the block in
        //    @media print { ... }
        // is a ruleset.  We just don't care about any block carrying at-rules
        // whose body content is not ruleset content.
        i = ruleset(toks, i, n, handler);
      }
    }
    if (handler.endBlock) { handler.endBlock(); }
    return i;
  }

  // ruleset    : selector? '{' S* declaration? [ ';' S* declaration? ]* '}' S*;
  function ruleset(toks, i, n, handler) {
    // toks[s:e] are the selector tokens including internal whitespace.
    var s = i, e = selector(toks, i, n, true);
    if (e < 0) {
      // Skip malformed content per selector calling convention.
      e = ~e;
      // Make sure we skip at least one token.
      return i === e ? e+1 : e;
    }
    i = e;
    // Don't include any trailing space in the selector slice.
    if (e > s && toks[e-1] === ' ') { --e; }
    var tok = toks[i];
    ++i;  // Skip over '{'
    if (tok !== '{') {
      // Skips past the '{' when there is a malformed input.
      return i;
    }
    if (handler.startRuleset) {
      handler.startRuleset(toks.slice(s, e));
    }
    while (i < n) {
      tok = toks[i];
      if (tok === '}') {
        ++i;
        break;
      }
      if (tok === ' ') {
        i = i+1;
      } else {
        i = declaration(toks, i, n, handler);
      }
    }
    if (handler.endRuleset) {
      handler.endRuleset();
    }
    return i < n ? i+1 : i;
  }

  // selector    : any+;
  // any         : [ IDENT | NUMBER | PERCENTAGE | DIMENSION | STRING
  //               | DELIM | URI | HASH | UNICODE-RANGE | INCLUDES
  //               | FUNCTION S* any* ')' | DASHMATCH | '(' S* any* ')'
  //               | '[' S* any* ']' ] S*;
  // A negative return value, rv, indicates the selector was malformed and
  // the index at which we stopped is ~rv.
  function selector(toks, i, n, allowSemi) {
    var s = i;
    // The definition of any above can be summed up as
    //   "any run of token except ('[', ']', '(', ')', ':', ';', '{', '}')
    //    or nested runs of parenthesized tokens or square bracketed tokens".
    // Spaces are significant in the selector.
    // Selector is used as (selector?) so the below looks for (any*) for
    // simplicity.
    var tok;
    // Keeping a stack pointer actually causes this to minify better since
    // ".length" and ".push" are a lo of chars.
    var brackets = [], stackLast = -1;
    for (;i < n; ++i) {
      tok = toks[i].charAt(0);
      if (tok === '[' || tok === '(') {
        brackets[++stackLast] = tok;
      } else if ((tok === ']' && brackets[stackLast] === '[') ||
                 (tok === ')' && brackets[stackLast] === '(')) {
        --stackLast;
      } else if (tok === '{' || tok === '}' || tok === ';' || tok === '@'
                 || (tok === ':' && !allowSemi)) {
        break;
      }
    }
    if (stackLast >= 0) {
      // Returns the bitwise inverse of i+1 to indicate an error in the
      // token stream so that clients can ignore it.
      i = ~(i+1);
    }
    return i;
  }

  var ident = /^-?[a-z]/i;

  // declaration : property ':' S* value;
  // property    : IDENT S*;
  // value       : [ any | block | ATKEYWORD S* ]+;
  function declaration(toks, i, n, handler) {
    var property = toks[i++];
    if (!ident.test(property)) {
      return i+1;  // skip one token.
    }
    var tok;
    if (i < n && toks[i] === ' ') { ++i; }
    if (i == n || toks[i] !== ':') {
      // skip tokens to next semi or close bracket.
      while (i < n && (tok = toks[i]) !== ';' && tok !== '}') { ++i; }
      return i;
    }
    ++i;
    if (i < n && toks[i] === ' ') { ++i; }

    // None of the rules we care about want atrules or blocks in value, so
    // we look for any+ but that is the same as selector but not zero-length.
    // This gets us the benefit of not emitting any value with mismatched
    // brackets.
    var s = i, e = selector(toks, i, n, false);
    if (e < 0) {
      // Skip malformed content per selector calling convention.
      e = ~e;
    } else {
      var value = [], valuelen = 0;
      for (var j = s; j < e; ++j) {
        tok = toks[j];
        if (tok !== ' ') {
          value[valuelen++] = tok;
        }
      }
      // One of the following is now true:
      // (1) e is flush with the end of the tokens as in <... style="x:y">.
      // (2) tok[e] points to a ';' in which case we need to consume the semi.
      // (3) tok[e] points to a '}' in which case we don't consume it.
      // (4) else there is bogus unparsed value content at toks[e:].
      // Allow declaration flush with end for style attr body.
      if (e < n) {  // 2, 3, or 4
        do {
          tok = toks[e];
          if (tok === ';' || tok === '}') { break; }
          // Don't emit the property if there is questionable trailing content.
          valuelen = 0;
        } while (++e < n);
        if (tok === ';') {
          ++e;
        }
      }
      if (valuelen && handler.declaration) {
        // TODO: coerce non-keyword ident tokens to quoted strings.
        handler.declaration(property.toLowerCase(), value);
      }
    }
    return e;
  }

  parseCssDeclarations = function(cssText, handler) {
    var toks = lexCss(cssText);
    for (var i = 0, n = toks.length; i < n;) {
      i = toks[i] !== ' ' ? declaration(toks, i, n, handler) : i+1;
    }
  };
})();

// Exports for closure compiler.
if (typeof window !== 'undefined') {
  window['parseCssStylesheet'] = parseCssStylesheet;
  window['parseCssDeclarations'] = parseCssDeclarations;
}
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
// Based on coding from the HTML4 Sanitizer by Google Inc.
// The HTML Attributes and ELements were reorganized according to the actual HTML5 specification
// from the W3C. All types and flags were reviewed again as accurately as possible with HTML4 only
// elements removed, you can still see them as comments. All rules which are new or changed from the
// old HTML4 file are also marked "new" within the comment. The comments also state which attributes
// and elements are assigned to respective types and flags. All rules which were not 100% clear were
// analyzed in a way of similarity, so for example "audio" and "video" content behaves like images etc.
// URIEFFECTS state if a URL is loaded inplace within a tag where the actual document is in control
// of what type of content is loaded like "image" or if a new document is loaded like with "a href".
// LOADERTYPES state if content is loaded as sandboxed which means it is loaded within a specific
// surroundig player like with video content for example or if it is loaded freely without restrictions.
// @overrides window
// @provides html4

var html4 = {};
html4.atype = {
  NONE: 0,
  URI: 1, //action, cite, data, href, icon, manifest, poster, src
  URI_FRAGMENT: 11, //usemap
  SCRIPT: 2, //all event handlers
  STYLE: 3, //style
  ID: 4, //id
  IDREF: 5, //for
  IDREFS: 6, //headers
  GLOBAL_NAME: 7, //name of form, iframe, img, map, meta
  LOCAL_NAME: 8, //name of button, fieldset, input, keygen, object, output, param, select, textarea
  CLASSES: 9, //class
  FRAME_TARGET: 10 //formtarget, srcdoc, target
};

html4.ATTRIBS = {
	'*::accesskey': 0, //NONE
	'*::class': 9, //CLASSES
	'*::contenteditable': 0, //NONE new
	'*::contextmenu': 0, //NONE new
	'*::dir': 0, //NONE
	'*::draggable': 0, //NONE new
	'*::dropzone': 0, //NONE new
	'*::hidden': 0, //NONE new
	'*::id': 4, //ID
	'*::lang': 0, //NONE
	'*::onabort': 2, //SCRIPT new
	'*::onblur': 2, //SCRIPT new
	'*::oncanplay': 2, //SCRIPT new
	'*::oncanplaythrough': 2, //SCRIPT new
	'*::onchange': 2, //SCRIPT new
	'*::onclick': 2, //SCRIPT
	'*::oncontextmenu': 2, //SCRIPT new
	'*::oncuechange': 2, //SCRIPT new
	'*::ondblclick': 2, //SCRIPT
	'*::ondrag': 2, //SCRIPT new
	'*::ondragend': 2, //SCRIPT new
	'*::ondragenter': 2, //SCRIPT new
	'*::ondragleave': 2, //SCRIPT new
	'*::ondragover': 2, //SCRIPT new
	'*::ondragstart': 2, //SCRIPT new
	'*::ondrop': 2, //SCRIPT new
	'*::ondurationchange': 2, //SCRIPT new
	'*::onemptied': 2, //SCRIPT new
	'*::onended': 2, //SCRIPT new
	'*::onerror': 2, //SCRIPT new
	'*::onfocus': 2, //SCRIPT new
	'*::oninput': 2, //SCRIPT new
	'*::oninvalid':	 2, //SCRIPT new
	'*::onkeydown': 2, //SCRIPT
	'*::onkeypress': 2, //SCRIPT
	'*::onkeyup': 2, //SCRIPT
	'*::onload': 2, //SCRIPT
	'*::onloadeddata': 2, //SCRIPT new
	'*::onloadedmetadata': 2, //SCRIPT new
	'*::onloadstart': 2, //SCRIPT new
	'*::onmousedown': 2, //SCRIPT
	'*::onmousemove': 2, //SCRIPT
	'*::onmouseout': 2, //SCRIPT
	'*::onmouseover': 2, //SCRIPT
	'*::onmouseup': 2, //SCRIPT
	'*::onmousewheel': 2, //SCRIPT new
	'*::onpause': 2, //SCRIPT new
	'*::onplay': 2, //SCRIPT new
	'*::onplaying': 2, //SCRIPT new
	'*::onprogress': 2, //SCRIPT new
	'*::onratechange': 2, //SCRIPT new
	'*::onreadystatechange': 2, //SCRIPT new
	'*::onreset': 2, //SCRIPT new
	'*::onscroll': 2, //SCRIPT new
	'*::onseeked': 2, //SCRIPT new
	'*::onseeking': 2, //SCRIPT new
	'*::onselect': 2, //SCRIPT new
	'*::onshow': 2, //SCRIPT new
	'*::onstalled': 2, //SCRIPT new
	'*::onsubmit': 2, //SCRIPT new
	'*::onsuspend': 2, //SCRIPT new
	'*::ontimeupdate': 2, //SCRIPT new
	'*::onvolumechange': 2, //SCRIPT new
	'*::onwaiting': 2, //SCRIPT new
	'*::spellcheck': 0, //NONE new
	'*::style': 3, //STYLE
	'*::tabindex': 0, //NONE
	'*::title': 0, //NONE
//---------------------  'a::accesskey': 0, moved to global
//---------------------  'a::coords': 0,
	'a::href': 1, //URI
	'a::hreflang': 0, //NONE
	'a::media': 0, //NONE new
//---------------------  'a::name': 7,
//---------------------	 'a::onblur': 2, moved to global
//---------------------	 'a::onfocus': 2, moved to global
	'a::rel': 0, //NONE
//---------------------  'a::rev': 0,
//---------------------  'a::shape': 0,
//---------------------  'a::tabindex': 0, moved to global
	'a::target': 0, //changed to "0" because of CSN 1918585 2013, original value was 10 FRAME_TARGET but it seems uncritical
	'a::type': 0, //NONE
//---------------------  'area::accesskey': 0, moved to global
	'area::alt': 0, //NONE
	'area::coords': 0, //NONE
	'area::href': 1, //URI
	'area::hreflang': 0, //NONE new
	'area::media': 0, //NONE new
//---------------------  'area::nohref': 0,
//---------------------	 'area::onblur': 2, moved to global
//---------------------	 'area::onfocus': 2, moved to global
	'area::rel': 0, //NONE new
	'area::shape': 0, //NONE
//---------------------  'area::tabindex': 0, moved to global
	'area::target': 10, //FRAME_TARGET
	'area::type': 0, //NONE
	'audio::autoplay': 0, //NONE new
	'audio::controls': 0, //NONE new
	'audio::loop': 0, //NONE new
	'audio::mediagroup': 0, //NONE new
	'audio::preload': 0, //NONE new
	'audio::src': 1, //URI
	'base::href': 1, //URI
	'base::target': 10, //FRAME_TARGET
//---------------------  'bdo::dir': 0,
	'blockquote::cite': 1, //URI
	'body::onafterprint': 2, //SCRIPT new
	'body::onbeforeprint': 2, //SCRIPT new
	'body::onbeforeunload': 2, //SCRIPT new
	'body::onblur': 2, //SCRIPT new
	'body::onerror': 2, //SCRIPT new
	'body::onfocus': 2, //SCRIPT new
	'body::onhashchange': 2, //SCRIPT new
	'body::onload': 2, //SCRIPT new
	'body::onmessage': 2, //SCRIPT new
	'body::onoffline': 2, //SCRIPT new
	'body::ononline': 2, //SCRIPT new
	'body::onpagehide': 2, //SCRIPT new
	'body::onpageshow': 2, //SCRIPT new
	'body::onpopstate': 2, //SCRIPT new
	'body::onredo': 2, //SCRIPT new
	'body::onresize': 2, //SCRIPT new
	'body::onscroll': 2, //SCRIPT new
	'body::onstorage': 2, //SCRIPT new
	'body::onundo': 2, //SCRIPT new
	'body::onunload': 2, //SCRIPT new
//---------------------  'br::clear': 0,
//---------------------  'button::accesskey': 0, moved to global
	'button::autofocus': 0, //NONE new
	'button::disabled': 0, //NONE
	'button::form': 0, //NONE new
	'button::formaction': 1, //URI new
	'button::formenctype': 0, //NONE new
	'button::formmethod': 0, //NONE new
	'button::formnovalidate': 0, //NONE new
	'button::formtarget': 10, //FRAME_TARGET new
	'button::name': 8, //LOCAL_NAME
//---------------------	 'button::onblur': 2,
//---------------------	 'button::onfocus': 2,
//---------------------  'button::tabindex': 0, moved to global
	'button::type': 0, //NONE
	'button::value': 0, //NONE
	'canvas::height': 0, //NONE
	'canvas::width': 0, //NONE
//---------------------	 'caption::align': 0,
//---------------------  'col::align': 0,
//---------------------	 'col::char': 0,
//---------------------	 'col::charoff': 0,
	'col::span': 0, //NONE
//---------------------	 'col::valign': 0,
//---------------------	 'col::width': 0,
//---------------------	 'colgroup::align': 0,
//---------------------	 'colgroup::char': 0,
//---------------------	 'colgroup::charoff': 0,
	'colgroup::span': 0, //NONE
//---------------------	 'colgroup::valign': 0,
//---------------------	 'colgroup::width': 0,
	'command::checked': 0, //NONE new
	'command::disabled': 0, //NONE new
	'command::icon': 1, //URI new
	'command::label': 0, //NONE new
	'command::radiogroup': 0, //NONE new
	'command::type': 0, //NONE new
	'del::cite': 1, //URI
	'del::datetime': 0, //NONE
	'details::open': 0, //NONE new
//---------------------	 'dir::compact': 0,
//---------------------	 'div::align': 0,
//---------------------	 'dl::compact': 0,
	'embed::height': 0, //NONE new
	'embed::src': 1, //URI new
	'embed::type': 0, //NONE new
	'embed::width': 0, //NONE new
	'fieldset::disabled': 0, //NONE new
	'fieldset::form': 0, //NONE new
	'fieldset::name': 8, //LOCAL_NAME new
//---------------------	 'font::color': 0,
//---------------------	 'font::face': 0,
//---------------------	 'font::size': 0,
//---------------------	 'form::accept': 0,
	'form::accept-charset': 0, //NONE
	'form::action': 1, //URI
	'form::autocomplete': 0, //NONE
	'form::enctype': 0, //NONE
	'form::method': 0, //NONE
	'form::name': 7, //GLOBAL_NAME
	'form::novalidate': 0, //NONE new
//---------------------	 'form::onreset': 2,
//---------------------	 'form::onsubmit': 2,
	'form::target': 10, //FRAME_TARGET
//---------------------	 'h1::align': 0,
//---------------------	 'h2::align': 0,
//---------------------	 'h3::align': 0,
//---------------------	 'h4::align': 0,
//---------------------	 'h5::align': 0,
//---------------------	 'h6::align': 0,
//---------------------	 'hr::align': 0,
//---------------------	 'hr::noshade': 0,
//---------------------	 'hr::size': 0,
//---------------------	 'hr::width': 0,
	'html:: manifest': 1, //URI new
//---------------------	 'iframe::align': 0,
//---------------------	'iframe::frameborder': 0,
	'iframe::height': 0, //NONE
//---------------------	 'iframe::marginheight': 0,
//---------------------	 'iframe::marginwidth': 0,
	'iframe::name': 7, //GLOBAL_NAME new
	'iframe::sandbox': 0, //NONE new
	'iframe::seamless': 0, //NONE new
	'iframe::src': 1, //URI new
	'iframe::srcdoc': 10, //FRAME_TARGET new
	'iframe::width': 0, //NONE
//---------------------	 'img::align': 0,
	'img::alt': 0, //NONE
//---------------------	 'img::border': 0,
	'img::height': 0, //NONE
//---------------------	 'img::hspace': 0,
	'img::ismap': 0, //NONE
	'img::name': 7, //GLOBAL_NAME
	'img::src': 1, //URI
	'img::usemap': 11, //URI_FRAGMENT
//---------------------	'img::vspace': 0,
	'img::width': 0, //NONE
	'input::accept': 0, //NONE
//---------------------	 'input::accesskey': 0, moved to global
//---------------------	 'input::align': 0,
	'input::alt': 0, //NONE
	'input::autocomplete': 0, //NONE
	'input::autofocus': 0, //NONE new
	'input::checked': 0, //NONE
	'input::dirname': 0, //NONE new
	'input::disabled': 0, //NONE
	'input::form': 0, //NONE new
	'input::formaction': 1, //URI new
	'input::formenctype': 0, //NONE new
	'input::formmethod': 0, //NONE new
	'input::formnovalidate': 0, //NONE new
	'input::formtarget': 10, //FRAME_TARGET new
	'input::height': 0, //NONE new
//---------------------	 'input::ismap': 0,
	'input::list': 0, //NONE new
	'input::max': 0, //NONE new
	'input::maxlength': 0, //NONE
	'input::min': 0, //NONE new
	'input::multiple': 0, //NONE new
	'input::name': 8, //LOCAL_NAME
//---------------------	 'input::onblur': 2,
//---------------------	 'input::onchange': 2,
//---------------------	 'input::onfocus': 2,
//---------------------	 'input::onselect': 2,
	'input::pattern': 0, //NONE new
	'input::placeholder': 0, //NONE new
	'input::readonly': 0, //NONE
	'input::required': 0, //NONE new
	'input::step': 0, //NONE new
	'input::size': 0, //NONE
	'input::src': 1, //URI
//---------------------  'input::tabindex': 0, moved to global
	'input::type': 0, //NONE
//---------------------	 'input::usemap': 11,
	'input::value': 0, //NONE
	'input::width': 0, //NONE new
	'ins::cite': 1, //URI
	'ins::datetime': 0, //NONE
//---------------------  'label::accesskey': 0, moved to global
	'keygen::autofocus': 0, //NONE new
	'keygen::challenge': 0, //NONE new
	'keygen::disabled': 0, //NONE new
	'keygen::form': 0, //NONE new
	'keygen::keytype': 0, //NONE new
	'keygen::name': 8, //LOCAL_NAME new
	'label::for': 5, //IDREF
	'label::form': 0, //NONE new
//---------------------	 'label::onblur': 2,
//---------------------	 'label::onfocus': 2,
//---------------------  'legend::accesskey': 0, moved to global
//---------------------  'legend::align': 0,
//---------------------  'li::type': 0,
	'link::href': 1, //URI new
	'link::hreflang': 0, //NONE new
	'link::media': 0, //NONE new
	'link::rel': 0, //NONE new
	'link::sizes': 0, //NONE new
	'link::type': 0, //NONE new
	'li::value': 0, //NONE new
	'map::name': 7, //GLOBAL_NAME
//---------------------  'menu::compact': 0,
	'menu::label': 0, //NONE new
	'menu::type': 0, //NONE new
	'meta::charset': 0, //NONE new
	'meta::content': 0, //NONE new
	'meta::http-equiv': 0, //NONE new
	'meta::name': 7, //GLOBAL_NAME new
	'meter::form': 0, //NONE new
	'meter::high': 0, //NONE new
	'meter::low': 0, //NONE new
	'meter::max': 0, //NONE new
	'meter::min': 0, //NONE new
	'meter::optimum': 0, //NONE new
	'meter::value': 0, //NONE new
	'object::data': 1, //URI new
	'object::form': 0, //NONE new
	'object::height': 0, //NONE new
	'object::name': 8, //LOCAL_NAME new
	'object::type': 0, //NONE new
	'object::usemap': 11, //URI_FRAGMENT new
	'object::width': 0, //NONE new
//---------------------  'ol::compact': 0,
	'ol::reversed': 0, //NONE new
	'ol::start': 0, //NONE
//---------------------  'ol::type': 0,
	'optgroup::disabled': 0, //NONE
	'optgroup::label': 0, //NONE
	'option::disabled': 0, //NONE
	'option::label': 0, //NONE
	'option::selected': 0, //NONE
	'option::value': 0, //NONE
	'output::for': 5, //IDREF new
	'output::form': 0, //NONE new
	'output::name': 8, //LOCAL_NAME new
//---------------------  'p::align': 0,
	'param::name': 8, //LOCAL_NAME new
	'param::value': 0, //NONE new
	'progress::form': 0, //NONE new
	'progress::max': 0, //NONE new
	'progress::value': 0, //NONE new
//---------------------  'pre::width': 0,
	'q::cite': 1, //URI
	'script::async': 0, //NONE new
	'script::charset': 0, //NONE new
	'script::defer': 0, //NONE new
	'script::src': 1, //URI new
	'script::type': 0, //NONE new
	'select::autofocus': 0, //NONE new
	'select::disabled': 0, //NONE
	'select::form': 0, //NONE new
	'select::multiple': 0, //NONE
	'select::name': 8, //LOCAL_NAME
//---------------------	 'select::onblur': 2,
//---------------------	 'select::onchange': 2,
//---------------------	 'select::onfocus': 2,
	'select::required': 0, //NONE new
	'select::size': 0, //NONE
//---------------------  'select::tabindex': 0, moved to global
	'source::media': 0, //NONE new
	'source::src': 1, //URI new
	'source::type': 0, //NONE new
	'style::media': 0, //NONE new
	'style::scoped': 0, //NONE new
	'style::type': 0, //NONE new
//---------------------	 'table::align': 0,
//---------------------	 'table::bgcolor': 0,
	'table::border': 0, //NONE
//---------------------	 'table::cellpadding': 0,
//---------------------	 'table::cellspacing': 0,
//---------------------	 'table::frame': 0,
//---------------------	 'table::rules': 0,
//---------------------	 'table::summary': 0,
//---------------------	 'table::width': 0,
//---------------------	 'tbody::align': 0,
//---------------------	 'tbody::char': 0,
//---------------------	 'tbody::charoff': 0,
//---------------------	 'tbody::valign': 0,
//---------------------	 'td::abbr': 0,
//---------------------	 'td::align': 0,
//---------------------	 'td::axis': 0,
//---------------------	 'td::bgcolor': 0,
//---------------------	 'td::char': 0,
//---------------------	 'td::charoff': 0,
	'td::colspan': 0, //NONE
	'td::headers': 6, //IDREFS
//---------------------	 'td::height': 0,
//---------------------	 'td::nowrap': 0,
	'td::rowspan': 0, //NONE
//---------------------	 'td::scope': 0,
//---------------------  'td::valign': 0,
//---------------------	 'td::width': 0,
//---------------------  'textarea::accesskey': 0, moved to global
	'textarea::autofocus': 0, //NONE new
	'textarea::cols': 0, //NONE
	'textarea::disabled': 0, //NONE
	'textarea::form': 0, //NONE new
	'textarea::maxlength': 0, //NONE new
	'textarea::name': 8, //LOCAL_NAME
//---------------------	 'textarea::onblur': 2,
//---------------------	 'textarea::onchange': 2,
//---------------------	 'textarea::onfocus': 2,
//---------------------	 'textarea::onselect': 2,
	'textarea::placeholder': 0, //NONE new
	'textarea::readonly': 0, //NONE
	'textarea::required': 0, //NONE new
	'textarea::rows': 0, //NONE
	'textarea::wrap': 0, //NONE new
//---------------------  'textarea::tabindex': 0, moved to global
//---------------------	 'tfoot::align': 0,
//---------------------	 'tfoot::char': 0,
//---------------------	 'tfoot::charoff': 0,
//---------------------	 'tfoot::valign': 0,
//---------------------	 'th::abbr': 0,
//---------------------	 'th::align': 0,
//---------------------	 'th::axis': 0,
//---------------------	 'th::bgcolor': 0,
//---------------------	 'th::char': 0,
//---------------------	 'th::charoff': 0,
	'th::colspan': 0, //NONE
	'th::headers': 6, //IDREFS
//---------------------	 'th::height': 0,
//---------------------	 'th::nowrap': 0,
	'th::rowspan': 0, //NONE
	'th::scope': 0, //NONE
//---------------------	 'th::valign': 0,
//---------------------	 'th::width': 0,
//---------------------	 'thead::align': 0,
//---------------------	 'thead::char': 0,
//---------------------	 'thead::charoff': 0,
//---------------------	 'thead::valign': 0,
	'time::datetime': 0, //NONE new
	'time::pubdate': 0, //NONE new
//---------------------	 'tr::align': 0,
//---------------------	 'tr::bgcolor': 0,
//---------------------	 'tr::char': 0,
//---------------------	 'tr::charoff': 0,
//---------------------	 'tr::valign': 0,
	'track::default': 0, //NONE new
	'track::kind': 0, //NONE new
	'track::label': 0, //NONE new
	'track::src': 1, //URI new
	'track::srclang': 0, //NONE new
//---------------------	 'ul::compact': 0,
//---------------------	 'ul::type': 0
	'video::autoplay': 0, //NONE new
	'video::controls': 0, //NONE new
	'video::height': 0, //NONE new
	'video::loop': 0, //NONE new
	'video::mediagroup': 0, //NONE new
	'video::poster': 1, //URI new
	'video::preload': 0, //NONE new
	'video::src': 1, //URI new
	'video::width': 0 //NONE new
};
html4.eflags = {
	OPTIONAL_ENDTAG: 1,
	EMPTY: 2,
	CDATA: 4,
	RCDATA: 8,
	UNSAFE: 16,
	FOLDABLE: 32,
	SCRIPT: 64,
	STYLE: 128
};
html4.ELEMENTS = {
	'a': 0,
	'abbr': 0,
//---------------------	 'acronym': 0,
	'address': 0,
//---------------------	 'applet': 16,
	'area': 2, //EMPTY
	'article': 0, //new
	'aside': 0, //new
	'audio': 0, //new
	'b': 0,
	'base': 18, //EMPTY, UNSAFE
//---------------------	 'basefont': 18,
	'bdi': 0, //new
	'bdo': 0,
//---------------------	 'big': 0,
	'blockquote': 0,
	'body': 49, //OPTIONAL_ENDTAG, UNSAFE, FOLDABLE
	'br': 2, //EMPTY
	'button': 0,
	'canvas': 0,
	'caption': 0,
//---------------------	 'center': 0,
	'cite': 0,
	'code': 0,
	'col': 2, //EMPTY
	'colgroup': 1, //OPTIONAL_ENDTAG
	'command': 2, //EMPTY new
	'datalist': 0, //new
	'dd': 1, //OPTIONAL_ENDTAG
	'del': 0,
	'details': 0, //new
	'dfn': 0,
//---------------------	 'dir': 0,
	'div': 0,
	'dl': 0,
	'dt': 1, //OPTIONAL_ENDTAG
	'em': 0,
	'embed': 18, //EMPTY, UNSAFE new
	'fieldset': 0,
	'figcaption': 0, //new
	'figure': 0, //new
//---------------------	 'font': 0,
	'footer': 0, //new
	'form': 0,
//---------------------	 'frame': 18,
//---------------------	 'frameset': 16,
	'h1': 0,
	'h2': 0,
	'h3': 0,
	'h4': 0,
	'h5': 0,
	'h6': 0,
	'head': 49, //OPTIONAL_ENDTAG, UNSAFE, FOLDABLE
	'header': 0, //new
	'hgroup': 0, //new
	'hr': 2, //EMPTY
	'html': 49, //OPTIONAL_ENDTAG, UNSAFE, FOLDABLE
	'i': 0,
	'iframe': 4, //CDATA
	'img': 2,//EMPTY
	'input': 2, //EMPTY
	'ins': 0,
//---------------------	 'isindex': 18,
	'kbd': 0,
	'keygen': 2, //EMPTY new
	'label': 0,
	'legend': 0,
	'li': 1, //OPTIONAL_ENDTAG
	'link': 18, //EMPTY, UNSAFE
	'map': 0,
	'mark': 0, //new
	'menu': 0,
	'meta': 18, //EMPTY, UNSAFE
	'meter': 0, //new
	'nav': 0,
//---------------------	 'nobr': 0,
//---------------------	 'noembed': 4,
//---------------------	 'noframes': 20,
	'noscript': 20, //CDATA, UNSAFE
	'object': 16, //UNSAFE
	'ol': 0,
	'optgroup': 1, //OPTIONAL_ENDTAG new !!!!vorher 0
	'option': 1, //OPTIONAL_ENDTAG
	'output': 0, //new
	'p': 1, //OPTIONAL_ENDTAG
	'param': 18, //EMPTY, UNSAFE
	'pre': 0,
	'progress': 0, //new
	'q': 0,
	'rp': 1, //OPTIONAL_ENDTAG new
	'rt': 1, //OPTIONAL_ENDTAG new
	'ruby': 0, //new
	's': 0,
	'samp': 0,
	'script': 84, //CDATA, UNSAFE, SCRIPT
	'section': 0, //new
	'select': 0,
	'small': 0,
	'source': 2, //EMPTY new
	'span': 0,
//---------------------	 'strike': 0,
	'strong': 0,
	'style': 148, //CDATA, UNSAFE, STYLE
	'sub': 0,
	'summary': 0, //new
	'sup': 0,
	'table': 0,
	'tbody': 1, //OPTIONAL_ENDTAG
	'td': 1, //OPTIONAL_ENDTAG
	'textarea': 8, //RCDATA
	'tfoot': 1, //OPTIONAL_ENDTAG
	'th': 1, //OPTIONAL_ENDTAG
	'thead': 1, //OPTIONAL_ENDTAG
	'time': 0, //new
	'title': 24, //RCDATA, UNSAFE
	'tr': 1, //OPTIONAL_ENDTAG
	'track': 2, //EMPTY new
//---------------------	 'tt': 0,
	'u': 0,
	'ul': 0,
	'var': 0,
	'video': 0, //new
	'wbr': 2 //EMPTY new
};
html4.ueffects = {
	NOT_LOADED: 0,
	SAME_DOCUMENT: 1,
	NEW_DOCUMENT: 2
};
html4.URIEFFECTS = {
	'a::href': 2, //NEW_DOCUMENT
	'area::href': 2, //NEW_DOCUMENT
	'audio::src': 1, //SAME_DOCUMENT new
	'base::href':2, //NEW_DOCUMENT new
	'blockquote::cite': 0, //NOT_LOADED
//---------------------	 'body::background': 1,
	'button::formaction': 2, //NEW_DOCUMENT new
	'command::icon': 1, //SAME_DOCUMENT new
	'del::cite': 0, //NOT_LOADED
	'embed::src': 1, //SAME_DOCUMENT new
	'form::action': 2, //NEW_DOCUMENT
	'html:: manifest': 1, //SAME_DOCUMENT new
	'iframe::src': 1, //SAME_DOCUMENT new
	'img::src': 1, //SAME_DOCUMENT
	'input::formaction': 2, //NEW_DOCUMENT new
	'input::src': 1, //SAME_DOCUMENT
	'ins::cite': 0, //NOT_LOADED
	'link::href': 2, //NEW_DOCUMENT new
	'object::data': 1, //SAME_DOCUMENT new
	'q::cite': 0, //NOT_LOADED
	'script::src': 1, //SAME_DOCUMENT new
	'source::src': 1, //SAME_DOCUMENT new
	'track::src': 1, //SAME_DOCUMENT new
	'video::poster': 1, //SAME_DOCUMENT new
	'video::src': 1 //SAME_DOCUMENT new
};
html4.ltypes = {
	UNSANDBOXED: 2,
	SANDBOXED: 1,
	DATA: 0
};
html4.LOADERTYPES = {
	'a::href': 2, //UNSANDBOXED
	'area::href': 2, //UNSANDBOXED
	'audio::src': 1, //SANDBOXED new
	'base::href': 2, //UNSANDBOXED new
	'blockquote::cite': 2, //UNSANDBOXED
//---------------------	 'body::background': 1,
	'button::formaction': 2, //UNSANDBOXED new
	'command::icon': 1, //SANDBOXED new
	'del::cite': 2, //UNSANDBOXED
	'embed::src': 1, //SANDBOXED new
	'form::action': 2, //UNSANDBOXED
	'html:: manifest': 1, //SANDBOXED new
	'iframe::src': 1, //SANDBOXED new
	'img::src': 1, //SANDBOXED
	'input::formaction': 2, //UNSANDBOXED new
	'input::src': 1, //SANDBOXED
	'ins::cite': 2, //UNSANDBOXED
	'link::href': 2, //UNSANDBOXED new
	'object::data': 0, //DATA new
	'q::cite': 2, //UNSANDBOXED
	'script::src': 1, //SANDBOXED new
	'source::src': 1, //SANDBOXED new
	'track::src': 1, //SANDBOXED new
	'video::poster': 1, //SANDBOXED new
	'video::src': 1 //SANDBOXED new
};if (typeof window !== 'undefined') {
	window['html4'] = html4;
}// Copyright (C) 2006 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview
 * An HTML sanitizer that can satisfy a variety of security policies.
 *
 * <p>
 * The HTML sanitizer is built around a SAX parser and HTML element and
 * attributes schemas.
 *
 * If the cssparser is loaded, inline styles are sanitized using the
 * css property and value schemas.  Else they are remove during
 * sanitization.
 *
 * If it exists, uses parseCssDeclarations, sanitizeCssProperty,  cssSchema
 *
 * @author mikesamuel@gmail.com
 * @author jasvir@gmail.com
 * \@requires html4
 * \@overrides window
 * \@provides html, html_sanitize
 */

/**
 * \@namespace
 */
var html = (function(html4) {

  // For closure compiler
  var parseCssDeclarations, sanitizeCssProperty, cssSchema;
  if ('undefined' !== typeof window) {
    parseCssDeclarations = window['parseCssDeclarations'];
    sanitizeCssProperty = window['sanitizeCssProperty'];
    cssSchema = window['cssSchema'];
  }

  var lcase;
  // The below may not be true on browsers in the Turkish locale.
  if ('script' === 'SCRIPT'.toLowerCase()) {
    lcase = function(s) { return s.toLowerCase(); };
  } else {
    /**
     * {\@updoc
     * $ lcase('SCRIPT')
     * # 'script'
     * $ lcase('script')
     * # 'script'
     * }
     */
    lcase = function(s) {
      return s.replace(
          /[A-Z]/g,
          function(ch) {
            return String.fromCharCode(ch.charCodeAt(0) | 32);
          });
    };
  }

  // The keys of this object must be 'quoted' or JSCompiler will mangle them!
  var ENTITIES = {
    'lt': '<',
    'gt': '>',
    'amp': '&',
    'nbsp': '\240',
    'quot': '"',
    'apos': '\''
  };

  var decimalEscapeRe = /^#(\d+)$/;
  var hexEscapeRe = /^#x([0-9A-Fa-f]+)$/;
  /**
   * Decodes an HTML entity.
   *
   * {\@updoc
   * $ lookupEntity('lt')
   * # '<'
   * $ lookupEntity('GT')
   * # '>'
   * $ lookupEntity('amp')
   * # '&'
   * $ lookupEntity('nbsp')
   * # '\xA0'
   * $ lookupEntity('apos')
   * # "'"
   * $ lookupEntity('quot')
   * # '"'
   * $ lookupEntity('#xa')
   * # '\n'
   * $ lookupEntity('#10')
   * # '\n'
   * $ lookupEntity('#x0a')
   * # '\n'
   * $ lookupEntity('#010')
   * # '\n'
   * $ lookupEntity('#x00A')
   * # '\n'
   * $ lookupEntity('Pi')      // Known failure
   * # '\u03A0'
   * $ lookupEntity('pi')      // Known failure
   * # '\u03C0'
   * }
   *
   * @param {string} name the content between the '&' and the ';'.
   * @return {string} a single unicode code-point as a string.
   */
  function lookupEntity(name) {
    name = lcase(name);  // TODO: &pi; is different from &Pi;
    if (ENTITIES.hasOwnProperty(name)) { return ENTITIES[name]; }
    var m = name.match(decimalEscapeRe);
    if (m) {
      return String.fromCharCode(parseInt(m[1], 10));
    } else if (!!(m = name.match(hexEscapeRe))) {
      return String.fromCharCode(parseInt(m[1], 16));
    }
    return '';
  }

  function decodeOneEntity(_, name) {
    return lookupEntity(name);
  }

  var nulRe = /\0/g;
  function stripNULs(s) {
    return s.replace(nulRe, '');
  }

  var entityRe = /&(#\d+|#x[0-9A-Fa-f]+|\w+);/g;
  /**
   * The plain text of a chunk of HTML CDATA which possibly containing.
   *
   * {\@updoc
   * $ unescapeEntities('')
   * # ''
   * $ unescapeEntities('hello World!')
   * # 'hello World!'
   * $ unescapeEntities('1 &lt; 2 &amp;&AMP; 4 &gt; 3&#10;')
   * # '1 < 2 && 4 > 3\n'
   * $ unescapeEntities('&lt;&lt <- unfinished entity&gt;')
   * # '<&lt <- unfinished entity>'
   * $ unescapeEntities('/foo?bar=baz&copy=true')  // & often unescaped in URLS
   * # '/foo?bar=baz&copy=true'
   * $ unescapeEntities('pi=&pi;&#x3c0;, Pi=&Pi;\u03A0') // FIXME: known failure
   * # 'pi=\u03C0\u03c0, Pi=\u03A0\u03A0'
   * }
   *
   * @param {string} s a chunk of HTML CDATA.  It must not start or end inside
   *     an HTML entity.
   */
  function unescapeEntities(s) {
    return s.replace(entityRe, decodeOneEntity);
  }

  var ampRe = /&/g;
  var looseAmpRe = /&([^a-z#]|#(?:[^0-9x]|x(?:[^0-9a-f]|$)|$)|$)/gi;
  var ltRe = /[<]/g;
  var gtRe = />/g;
  var quotRe = /\"/g;

  /**
   * Escapes HTML special characters in attribute values.
   *
   * {\@updoc
   * $ escapeAttrib('')
   * # ''
   * $ escapeAttrib('"<<&==&>>"')  // Do not just escape the first occurrence.
   * # '&#34;&lt;&lt;&amp;&#61;&#61;&amp;&gt;&gt;&#34;'
   * $ escapeAttrib('Hello <World>!')
   * # 'Hello &lt;World&gt;!'
   * }
   */
  function escapeAttrib(s) {
    return ('' + s).replace(ampRe, '&amp;').replace(ltRe, '&lt;')
        .replace(gtRe, '&gt;').replace(quotRe, '&#34;');
  }

  /**
   * Escape entities in RCDATA that can be escaped without changing the meaning.
   * {\@updoc
   * $ normalizeRCData('1 < 2 &&amp; 3 > 4 &amp;& 5 &lt; 7&8')
   * # '1 &lt; 2 &amp;&amp; 3 &gt; 4 &amp;&amp; 5 &lt; 7&amp;8'
   * }
   */
  function normalizeRCData(rcdata) {
    return rcdata
        .replace(looseAmpRe, '&amp;$1')
        .replace(ltRe, '&lt;')
        .replace(gtRe, '&gt;');
  }

  // TODO(mikesamuel): validate sanitizer regexs against the HTML5 grammar at
  // http://www.whatwg.org/specs/web-apps/current-work/multipage/syntax.html
  // http://www.whatwg.org/specs/web-apps/current-work/multipage/parsing.html
  // http://www.whatwg.org/specs/web-apps/current-work/multipage/tokenization.html
  // http://www.whatwg.org/specs/web-apps/current-work/multipage/tree-construction.html

  // We initially split input so that potentially meaningful characters
  // like '<' and '>' are separate tokens, using a fast dumb process that
  // ignores quoting.  Then we walk that token stream, and when we see a
  // '<' that's the start of a tag, we use ATTR_RE to extract tag
  // attributes from the next token.  That token will never have a '>'
  // character.  However, it might have an unbalanced quote character, and
  // when we see that, we combine additional tokens to balance the quote.

  var ATTR_RE = new RegExp(
    '^\\s*' +
    '([a-z][a-z-]*)' +          // 1 = Attribute name
    '(?:' + (
      '\\s*(=)\\s*' +           // 2 = Is there a value?
      '(' + (                   // 3 = Attribute value
        // TODO(felix8a): maybe use backref to match quotes
        '(\")[^\"]*(\"|$)' +    // 4, 5 = Double-quoted string
        '|' +
        '(\')[^\']*(\'|$)' +    // 6, 7 = Single-quoted string
        '|' +
        // Positive lookahead to prevent interpretation of
        // <foo a= b=c> as <foo a='b=c'>
        // TODO(felix8a): might be able to drop this case
        '(?=[a-z][a-z-]*\\s*=)' +
        '|' +
        // Unquoted value that isn't an attribute name
        // (since we didn't match the positive lookahead above)
        '[^\"\'\\s]*' ) +
      ')' ) +
    ')?',
    'i');

  var ENTITY_RE = /^(#[0-9]+|#x[0-9a-f]+|\w+);/i;

  // false on IE<=8, true on most other browsers
  var splitWillCapture = ('a,b'.split(/(,)/).length === 3);

  // bitmask for tags with special parsing, like <script> and <textarea>
  var EFLAGS_TEXT = html4.eflags.CDATA | html4.eflags.RCDATA;

  /**
   * Given a SAX-like event handler, produce a function that feeds those
   * events and a parameter to the event handler.
   *
   * The event handler has the form:{@code
   * {
   *   // Name is an upper-case HTML tag name.  Attribs is an array of
   *   // alternating upper-case attribute names, and attribute values.  The
   *   // attribs array is reused by the parser.  Param is the value passed to
   *   // the saxParser.
   *   startTag: function (name, attribs, param) { ... },
   *   endTag:   function (name, param) { ... },
   *   pcdata:   function (text, param) { ... },
   *   rcdata:   function (text, param) { ... },
   *   cdata:    function (text, param) { ... },
   *   startDoc: function (param) { ... },
   *   endDoc:   function (param) { ... }
   * }}
   *
   * @param {Object} handler a record containing event handlers.
   * @return {function(string, Object)} A function that takes a chunk of HTML
   *     and a parameter.  The parameter is passed on to the handler methods.
   */
  function makeSaxParser(handler) {
    return function(htmlText, param) {
      return parse(htmlText, handler, param);
    };
  }

  // Parsing strategy is to split input into parts that might be lexically
  // meaningful (every ">" becomes a separate part), and then recombine
  // parts if we discover they're in a different context.

  // Note, html-sanitizer filters unknown tags here, even though they also
  // get filtered out by the sanitizer's handler.  This is back-compat
  // behavior; makeSaxParser is public.

  // TODO(felix8a): Significant performance regressions from -legacy,
  // tested on
  //    Chrome 18.0
  //    Firefox 11.0
  //    IE 6, 7, 8, 9
  //    Opera 11.61
  //    Safari 5.1.3
  // Many of these are unusual patterns that are linearly slower and still
  // pretty fast (eg 1ms to 5ms), so not necessarily worth fixing.

  // TODO(felix8a): "<script> && && && ... <\/script>" is slower on all
  // browsers.  The hotspot is htmlSplit.

  // TODO(felix8a): "<p title='>>>>...'><\/p>" is slower on all browsers.
  // This is partly htmlSplit, but the hotspot is parseTagAndAttrs.

  // TODO(felix8a): "<a><\/a><a><\/a>..." is slower on IE9.
  // "<a>1<\/a><a>1<\/a>..." is faster, "<a><\/a>2<a><\/a>2..." is faster.

  // TODO(felix8a): "<p<p<p..." is slower on IE[6-8]

  var continuationMarker = {};
  function parse(htmlText, handler, param) {
    var h = handler;
    var m, p, tagName;
    var parts = htmlSplit(htmlText);
    var state = {
      noMoreGT: false,
      noMoreEndComments: false
    };
    parseCPS(handler, parts, 0, state, param);
  }

  function continuationMaker(h, parts, initial, state, param) {
    return function () {
      parseCPS(h, parts, initial, state, param);
    };
  }

  function parseCPS(h, parts, initial, state, param) {
    try {
      if (h.startDoc && initial == 0) { h.startDoc(param); }
      var m, p, tagName;
      for (var pos = initial, end = parts.length; pos < end;) {
        var current = parts[pos++];
        var next = parts[pos];
        switch (current) {
        case '&':
          if (ENTITY_RE.test(next)) {
            if (h.pcdata) {
              h.pcdata('&' + next, param, continuationMarker,
                continuationMaker(h, parts, pos, state, param));
            }
            pos++;
          } else {
            if (h.pcdata) { h.pcdata("&amp;", param, continuationMarker,
                continuationMaker(h, parts, pos, state, param));
            }
          }
          break;
        case '<\/':
          if (m = /^(\w+)[^\'\"]*/.exec(next)) {
            if (m[0].length === next.length && parts[pos + 1] === '>') {
              // fast case, no attribute parsing needed
              pos += 2;
              tagName = lcase(m[1]);
              if (html4.ELEMENTS.hasOwnProperty(tagName)) {
                if (h.endTag) {
                  h.endTag(tagName, param, continuationMarker,
                    continuationMaker(h, parts, pos, state, param));
                }
              }
            } else {
              // slow case, need to parse attributes
              // TODO(felix8a): do we really care about misparsing this?
              pos = parseEndTag(
                parts, pos, h, param, continuationMarker, state);
            }
          } else {
            if (h.pcdata) {
              h.pcdata('&lt;/', param, continuationMarker,
                continuationMaker(h, parts, pos, state, param));
            }
          }
          break;
        case '<':
          if (m = /^(\w+)\s*\/?/.exec(next)) {
            if (m[0].length === next.length && parts[pos + 1] === '>') {
              // fast case, no attribute parsing needed
              pos += 2;
              tagName = lcase(m[1]);
              if (html4.ELEMENTS.hasOwnProperty(tagName)) {
                if (h.startTag) {
                  h.startTag(tagName, [], param, continuationMarker,
                    continuationMaker(h, parts, pos, state, param));
                }
                // tags like <script> and <textarea> have special parsing
                var eflags = html4.ELEMENTS[tagName];
                if (eflags & EFLAGS_TEXT) {
                  var tag = { name: tagName, next: pos, eflags: eflags };
                  pos = parseText(
                    parts, tag, h, param, continuationMarker, state);
                }
              }
            } else {
              // slow case, need to parse attributes
              pos = parseStartTag(
                parts, pos, h, param, continuationMarker, state);
            }
          } else {
            if (h.pcdata) {
              h.pcdata('&lt;', param, continuationMarker,
                continuationMaker(h, parts, pos, state, param));
            }
          }
          break;
        case '<\!--':
          // The pathological case is n copies of '<\!--' without '-->', and
          // repeated failure to find '-->' is quadratic.  We avoid that by
          // remembering when search for '-->' fails.
          if (!state.noMoreEndComments) {
            // A comment <\!--x--> is split into three tokens:
            //   '<\!--', 'x--', '>'
            // We want to find the next '>' token that has a preceding '--'.
            // pos is at the 'x--'.
            for (p = pos + 1; p < end; p++) {
              if (parts[p] === '>' && /--$/.test(parts[p - 1])) { break; }
            }
            if (p < end) {
              pos = p + 1;
            } else {
              state.noMoreEndComments = true;
            }
          }
          if (state.noMoreEndComments) {
            if (h.pcdata) {
              h.pcdata('&lt;!--', param, continuationMarker,
                continuationMaker(h, parts, pos, state, param));
            }
          }
          break;
        case '<\!':
          if (!/^\w/.test(next)) {
            if (h.pcdata) {
              h.pcdata('&lt;!', param, continuationMarker,
                continuationMaker(h, parts, pos, state, param));
            }
          } else {
            // similar to noMoreEndComment logic
            if (!state.noMoreGT) {
              for (p = pos + 1; p < end; p++) {
                if (parts[p] === '>') { break; }
              }
              if (p < end) {
                pos = p + 1;
              } else {
                state.noMoreGT = true;
              }
            }
            if (state.noMoreGT) {
              if (h.pcdata) {
                h.pcdata('&lt;!', param, continuationMarker,
                  continuationMaker(h, parts, pos, state, param));
              }
            }
          }
          break;
        case '<?':
          // similar to noMoreEndComment logic
          if (!state.noMoreGT) {
            for (p = pos + 1; p < end; p++) {
              if (parts[p] === '>') { break; }
            }
            if (p < end) {
              pos = p + 1;
            } else {
              state.noMoreGT = true;
            }
          }
          if (state.noMoreGT) {
            if (h.pcdata) {
              h.pcdata('&lt;?', param, continuationMarker,
                continuationMaker(h, parts, pos, state, param));
            }
          }
          break;
        case '>':
          if (h.pcdata) {
            h.pcdata("&gt;", param, continuationMarker,
              continuationMaker(h, parts, pos, state, param));
          }
          break;
        case '':
          break;
        default:
          if (h.pcdata) {
            h.pcdata(current, param, continuationMarker,
              continuationMaker(h, parts, pos, state, param));
          }
          break;
        }
      }
      if (h.endDoc) { h.endDoc(param); }
    } catch (e) {
      if (e !== continuationMarker) { throw e; }
    }
  }

  // Split str into parts for the html parser.
  function htmlSplit(str) {
    // can't hoist this out of the function because of the re.exec loop.
    var re = /(<\/|<\!--|<[!?]|[&<>])/g;
    str += '';
    if (splitWillCapture) {
      return str.split(re);
    } else {
      var parts = [];
      var lastPos = 0;
      var m;
      while ((m = re.exec(str)) !== null) {
        parts.push(str.substring(lastPos, m.index));
        parts.push(m[0]);
        lastPos = m.index + m[0].length;
      }
      parts.push(str.substring(lastPos));
      return parts;
    }
  }

  function parseEndTag(parts, pos, h, param, continuationMarker, state) {
    var tag = parseTagAndAttrs(parts, pos);
    // drop unclosed tags
    if (!tag) { return parts.length; }
    if (tag.eflags !== void 0) {
      if (h.endTag) {
        h.endTag(tag.name, param, continuationMarker,
          continuationMaker(h, parts, pos, state, param));
      }
    }
    return tag.next;
  }

  function parseStartTag(parts, pos, h, param, continuationMarker, state) {
    var tag = parseTagAndAttrs(parts, pos);
    // drop unclosed tags
    if (!tag) { return parts.length; }
    if (tag.eflags !== void 0) {
      if (h.startTag) {
        h.startTag(tag.name, tag.attrs, param, continuationMarker,
          continuationMaker(h, parts, tag.next, state, param));
      }
      // tags like <script> and <textarea> have special parsing
      if (tag.eflags & EFLAGS_TEXT) {
        return parseText(parts, tag, h, param, continuationMarker, state);
      }
    }
    return tag.next;
  }

  var endTagRe = {};

  // Tags like <script> and <textarea> are flagged as CDATA or RCDATA,
  // which means everything is text until we see the correct closing tag.
  function parseText(parts, tag, h, param, continuationMarker, state) {
    var end = parts.length;
    if (!endTagRe.hasOwnProperty(tag.name)) {
      endTagRe[tag.name] = new RegExp('^' + tag.name + '(?:[\\s\\/]|$)', 'i');
    }
    var re = endTagRe[tag.name];
    var first = tag.next;
    var p = tag.next + 1;
    for (; p < end; p++) {
      if (parts[p - 1] === '<\/' && re.test(parts[p])) { break; }
    }
    if (p < end) { p -= 1; }
    var buf = parts.slice(first, p).join('');
    if (tag.eflags & html4.eflags.CDATA) {
      if (h.cdata) {
        h.cdata(buf, param, continuationMarker,
          continuationMaker(h, parts, p, state, param));
      }
    } else if (tag.eflags & html4.eflags.RCDATA) {
      if (h.rcdata) {
        h.rcdata(normalizeRCData(buf), param, continuationMarker,
          continuationMaker(h, parts, p, state, param));
      }
    } else {
      throw new Error('bug');
    }
    return p;
  }

  // at this point, parts[pos-1] is either "<" or "<\/".
  function parseTagAndAttrs(parts, pos) {
    var m = /^(\w+)/.exec(parts[pos]);
    var tag = { name: lcase(m[1]) };
    if (html4.ELEMENTS.hasOwnProperty(tag.name)) {
      tag.eflags = html4.ELEMENTS[tag.name];
    } else {
      tag.eflags = void 0;
    }
    var buf = parts[pos].substr(m[0].length);
    // Find the next '>'.  We optimistically assume this '>' is not in a
    // quoted context, and further down we fix things up if it turns out to
    // be quoted.
    var p = pos + 1;
    var end = parts.length;
    for (; p < end; p++) {
      if (parts[p] === '>') { break; }
      buf += parts[p];
    }
    if (end <= p) { return void 0; }
    var attrs = [];
    while (buf !== '') {
      m = ATTR_RE.exec(buf);
      if (!m) {
        // No attribute found: skip garbage
        buf = buf.replace(/^[\s\S][^a-z\s]*/, '');

      } else if ((m[4] && !m[5]) || (m[6] && !m[7])) {
        // Unterminated quote: slurp to the next unquoted '>'
        var quote = m[4] || m[6];
        var sawQuote = false;
        var abuf = [buf, parts[p++]];
        for (; p < end; p++) {
          if (sawQuote) {
            if (parts[p] === '>') { break; }
          } else if (0 <= parts[p].indexOf(quote)) {
            sawQuote = true;
          }
          abuf.push(parts[p]);
        }
        // Slurp failed: lose the garbage
        if (end <= p) { break; }
        // Otherwise retry attribute parsing
        buf = abuf.join('');
        continue;

      } else {
        // We have an attribute
        var aName = lcase(m[1]);
        var aValue = m[2] ? decodeValue(m[3]) : aName;
        attrs.push(aName, aValue);
        buf = buf.substr(m[0].length);
      }
    }
    tag.attrs = attrs;
    tag.next = p + 1;
    return tag;
  }

  function decodeValue(v) {
    var q = v.charCodeAt(0);
    if (q === 0x22 || q === 0x27) { // " or '
      v = v.substr(1, v.length - 2);
    }
    return unescapeEntities(stripNULs(v));
  }

  /**
   * Returns a function that strips unsafe tags and attributes from html.
   * @param {function(string, Array.<string>): ?Array.<string>} tagPolicy
   *     A function that takes (tagName, attribs[]), where tagName is a key in
   *     html4.ELEMENTS and attribs is an array of alternating attribute names
   *     and values.  It should return a sanitized attribute array, or null to
   *     delete the tag.  It's okay for tagPolicy to modify the attribs array,
   *     but the same array is reused, so it should not be held between calls.
   * @return {function(string, Array)} A function that sanitizes a string of
   *     HTML and appends result strings to the second argument, an array.
   */
  function makeHtmlSanitizer(tagPolicy) {
    var stack;
    var ignoring;
    var emit = function (text, out) {
      if (!ignoring) { out.push(text); }
    };
    return makeSaxParser({
      startDoc: function(_) {
        stack = [];
        ignoring = false;
      },
      startTag: function(tagName, attribs, out) {
        if (ignoring) { return; }
        if (!html4.ELEMENTS.hasOwnProperty(tagName)) { return; }
        var eflags = html4.ELEMENTS[tagName];
        if (eflags & html4.eflags.FOLDABLE) {
          return;
        }
        attribs = tagPolicy(tagName, attribs);
        if (!attribs) {
          ignoring = !(eflags & html4.eflags.EMPTY);
          return;
        }
        // TODO(mikesamuel): relying on tagPolicy not to insert unsafe
        // attribute names.
        if (!(eflags & html4.eflags.EMPTY)) {
          stack.push(tagName);
        }

        out.push('<', tagName);
        for (var i = 0, n = attribs.length; i < n; i += 2) {
          var attribName = attribs[i],
              value = attribs[i + 1];
          if (value !== null && value !== void 0) {
            out.push(' ', attribName, '="', escapeAttrib(value), '"');
          }
        }
        out.push('>');
      },
      endTag: function(tagName, out) {
        if (ignoring) {
          ignoring = false;
          return;
        }
        if (!html4.ELEMENTS.hasOwnProperty(tagName)) { return; }
        var eflags = html4.ELEMENTS[tagName];
        if (!(eflags & (html4.eflags.EMPTY | html4.eflags.FOLDABLE))) {
          var index;
          if (eflags & html4.eflags.OPTIONAL_ENDTAG) {
            for (index = stack.length; --index >= 0;) {
              var stackEl = stack[index];
              if (stackEl === tagName) { break; }
              if (!(html4.ELEMENTS[stackEl] &
                    html4.eflags.OPTIONAL_ENDTAG)) {
                // Don't pop non optional end tags looking for a match.
                return;
              }
            }
          } else {
            for (index = stack.length; --index >= 0;) {
              if (stack[index] === tagName) { break; }
            }
          }
          if (index < 0) { return; }  // Not opened.
          for (var i = stack.length; --i > index;) {
            var stackEl = stack[i];
            if (!(html4.ELEMENTS[stackEl] &
                  html4.eflags.OPTIONAL_ENDTAG)) {
              out.push('<\/', stackEl, '>');
            }
          }
          stack.length = index;
          out.push('<\/', tagName, '>');
        }
      },
      pcdata: emit,
      rcdata: emit,
      cdata: emit,
      endDoc: function(out) {
        for (; stack.length; stack.length--) {
          out.push('<\/', stack[stack.length - 1], '>');
        }
      }
    });
  }

  // From RFC3986
  var URI_SCHEME_RE = new RegExp(
      '^' +
      '(?:' +
        '([^:\/?# ]+)' +         // scheme
      ':)?'
  );

  var ALLOWED_URI_SCHEMES = /^(?:https?|mailto)$/i;

  function safeUri(uri, naiveUriRewriter) {
    if (!naiveUriRewriter) { return null; }
    var parsed = ('' + uri).match(URI_SCHEME_RE);
    if (parsed && (!parsed[1] || ALLOWED_URI_SCHEMES.test(parsed[1]))) {
      return naiveUriRewriter(uri);
    } else {
      return null;
    }
  }

  /**
   * Sanitizes attributes on an HTML tag.
   * @param {string} tagName An HTML tag name in lowercase.
   * @param {Array.<?string>} attribs An array of alternating names and values.
   * @param {?function(?string): ?string} opt_naiveUriRewriter A transform to
   *     apply to URI attributes; it can return a new string value, or null to
   *     delete the attribute.  If unspecified, URI attributes are deleted.
   * @param {function(?string): ?string} opt_nmTokenPolicy A transform to apply
   *     to attributes containing HTML names, element IDs, and space-separated
   *     lists of classes; it can return a new string value, or null to delete
   *     the attribute.  If unspecified, these attributes are kept unchanged.
   * @return {Array.<?string>} The sanitized attributes as a list of alternating
   *     names and values, where a null value means to omit the attribute.
   */
  function sanitizeAttribs(
      tagName, attribs, opt_naiveUriRewriter, opt_nmTokenPolicy) {
    for (var i = 0; i < attribs.length; i += 2) {
      var attribName = attribs[i];
      var value = attribs[i + 1];
      var atype = null, attribKey;
      if ((attribKey = tagName + '::' + attribName,
           html4.ATTRIBS.hasOwnProperty(attribKey)) ||
          (attribKey = '*::' + attribName,
           html4.ATTRIBS.hasOwnProperty(attribKey))) {
        atype = html4.ATTRIBS[attribKey];
      }
      if (atype !== null) {
        switch (atype) {
          case html4.atype.NONE: break;
          case html4.atype.SCRIPT:
            value = null;
            break;
          case html4.atype.STYLE:
            if ('undefined' === typeof parseCssDeclarations) {
              value = null;
              break;
            }
            var sanitizedDeclarations = [];
            parseCssDeclarations(
                value,
                {
                  declaration: function (property, tokens) {
                    var normProp = property.toLowerCase();
                    var schema = cssSchema[normProp];
                    if (!schema) {
                      return;
                    }
                    sanitizeCssProperty(
                        normProp, schema, tokens,
                        opt_naiveUriRewriter);
                    sanitizedDeclarations.push(property + ': ' + tokens.join(' '));
                  }
                });
            value = sanitizedDeclarations.length > 0 ? sanitizedDeclarations.join(' ; ') : null;
            break;
          case html4.atype.ID:
          case html4.atype.IDREF:
          case html4.atype.IDREFS:
          case html4.atype.GLOBAL_NAME:
          case html4.atype.LOCAL_NAME:
          case html4.atype.CLASSES:
            value = opt_nmTokenPolicy ? opt_nmTokenPolicy(value) : value;
            break;
          case html4.atype.URI:
            value = safeUri(value, opt_naiveUriRewriter);
            break;
          case html4.atype.URI_FRAGMENT:
            if (value && '#' === value.charAt(0)) {
              value = value.substring(1);  // remove the leading '#'
              value = opt_nmTokenPolicy ? opt_nmTokenPolicy(value) : value;
              if (value !== null && value !== void 0) {
                value = '#' + value;  // restore the leading '#'
              }
            } else {
              value = null;
            }
            break;
          default:
            value = null;
            break;
        }
      } else {
        value = null;
      }
      attribs[i + 1] = value;
    }
    return attribs;
  }

  /**
   * Creates a tag policy that omits all tags marked UNSAFE in html4-defs.js
   * and applies the default attribute sanitizer with the supplied policy for
   * URI attributes and NMTOKEN attributes.
   * @param {?function(?string): ?string} opt_naiveUriRewriter A transform to
   *     apply to URI attributes.  If not given, URI attributes are deleted.
   * @param {function(?string): ?string} opt_nmTokenPolicy A transform to apply
   *     to attributes containing HTML names, element IDs, and space-separated
   *     lists of classes.  If not given, such attributes are left unchanged.
   * @return {function(string, Array.<?string>)} A tagPolicy suitable for
   *     passing to html.sanitize.
   */
  function makeTagPolicy(opt_naiveUriRewriter, opt_nmTokenPolicy) {
    return function(tagName, attribs) {
      if (!(html4.ELEMENTS[tagName] & html4.eflags.UNSAFE)) {
        return sanitizeAttribs(
            tagName, attribs, opt_naiveUriRewriter, opt_nmTokenPolicy);
      }
    };
  }

  /**
   * Sanitizes HTML tags and attributes according to a given policy.
   * @param {string} inputHtml The HTML to sanitize.
   * @param {function(string, Array.<?string>)} tagPolicy A function that
   *     decides which tags to accept and sanitizes their attributes (see
   *     makeHtmlSanitizer above for details).
   * @return {string} The sanitized HTML.
   */
  function sanitizeWithPolicy(inputHtml, tagPolicy) {
    var outputArray = [];
    makeHtmlSanitizer(tagPolicy)(inputHtml, outputArray);
    return outputArray.join('');
  }

  /**
   * Strips unsafe tags and attributes from HTML.
   * @param {string} inputHtml The HTML to sanitize.
   * @param {?function(?string): ?string} opt_naiveUriRewriter A transform to
   *     apply to URI attributes.  If not given, URI attributes are deleted.
   * @param {function(?string): ?string} opt_nmTokenPolicy A transform to apply
   *     to attributes containing HTML names, element IDs, and space-separated
   *     lists of classes.  If not given, such attributes are left unchanged.
   */
  function sanitize(inputHtml, opt_naiveUriRewriter, opt_nmTokenPolicy) {
    var tagPolicy = makeTagPolicy(opt_naiveUriRewriter, opt_nmTokenPolicy);
    return sanitizeWithPolicy(inputHtml, tagPolicy);
  }

  return {
    escapeAttrib: escapeAttrib,
    makeHtmlSanitizer: makeHtmlSanitizer,
    makeSaxParser: makeSaxParser,
    makeTagPolicy: makeTagPolicy,
    normalizeRCData: normalizeRCData,
    sanitize: sanitize,
    sanitizeAttribs: sanitizeAttribs,
    sanitizeWithPolicy: sanitizeWithPolicy,
    unescapeEntities: unescapeEntities
  };
})(html4);

var html_sanitize = html.sanitize;

// Exports for closure compiler.  Note this file is also cajoled
// for domado and run in an environment without 'window'
if (typeof window !== 'undefined') {
  window['html'] = html;
  window['html_sanitize'] = html_sanitize;
}
/*!
 * @overview es6-promise - a tiny implementation of Promises/A+.
 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/jakearchibald/es6-promise/master/LICENSE
 * @version   2.3.0
 */

(function() {
    "use strict";
    function lib$es6$promise$utils$$objectOrFunction(x) {
      return typeof x === 'function' || (typeof x === 'object' && x !== null);
    }

    function lib$es6$promise$utils$$isFunction(x) {
      return typeof x === 'function';
    }

    function lib$es6$promise$utils$$isMaybeThenable(x) {
      return typeof x === 'object' && x !== null;
    }

    var lib$es6$promise$utils$$_isArray;
    if (!Array.isArray) {
      lib$es6$promise$utils$$_isArray = function (x) {
        return Object.prototype.toString.call(x) === '[object Array]';
      };
    } else {
      lib$es6$promise$utils$$_isArray = Array.isArray;
    }

    var lib$es6$promise$utils$$isArray = lib$es6$promise$utils$$_isArray;
    var lib$es6$promise$asap$$len = 0;
    var lib$es6$promise$asap$$toString = {}.toString;
    var lib$es6$promise$asap$$vertxNext;
    var lib$es6$promise$asap$$customSchedulerFn;

    var lib$es6$promise$asap$$asap = function asap(callback, arg) {
      lib$es6$promise$asap$$queue[lib$es6$promise$asap$$len] = callback;
      lib$es6$promise$asap$$queue[lib$es6$promise$asap$$len + 1] = arg;
      lib$es6$promise$asap$$len += 2;
      if (lib$es6$promise$asap$$len === 2) {
        // If len is 2, that means that we need to schedule an async flush.
        // If additional callbacks are queued before the queue is flushed, they
        // will be processed by this flush that we are scheduling.
        if (lib$es6$promise$asap$$customSchedulerFn) {
          lib$es6$promise$asap$$customSchedulerFn(lib$es6$promise$asap$$flush);
        } else {
          lib$es6$promise$asap$$scheduleFlush();
        }
      }
    }

    function lib$es6$promise$asap$$setScheduler(scheduleFn) {
      lib$es6$promise$asap$$customSchedulerFn = scheduleFn;
    }

    function lib$es6$promise$asap$$setAsap(asapFn) {
      lib$es6$promise$asap$$asap = asapFn;
    }

    var lib$es6$promise$asap$$browserWindow = (typeof window !== 'undefined') ? window : undefined;
    var lib$es6$promise$asap$$browserGlobal = lib$es6$promise$asap$$browserWindow || {};
    var lib$es6$promise$asap$$BrowserMutationObserver = lib$es6$promise$asap$$browserGlobal.MutationObserver || lib$es6$promise$asap$$browserGlobal.WebKitMutationObserver;
    var lib$es6$promise$asap$$isNode = typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';

    // test for web worker but not in IE10
    var lib$es6$promise$asap$$isWorker = typeof Uint8ClampedArray !== 'undefined' &&
      typeof importScripts !== 'undefined' &&
      typeof MessageChannel !== 'undefined';

    // node
    function lib$es6$promise$asap$$useNextTick() {
      var nextTick = process.nextTick;
      // node version 0.10.x displays a deprecation warning when nextTick is used recursively
      // setImmediate should be used instead instead
      var version = process.versions.node.match(/^(?:(\d+)\.)?(?:(\d+)\.)?(\*|\d+)$/);
      if (Array.isArray(version) && version[1] === '0' && version[2] === '10') {
        nextTick = setImmediate;
      }
      return function() {
        nextTick(lib$es6$promise$asap$$flush);
      };
    }

    // vertx
    function lib$es6$promise$asap$$useVertxTimer() {
      return function() {
        lib$es6$promise$asap$$vertxNext(lib$es6$promise$asap$$flush);
      };
    }

    function lib$es6$promise$asap$$useMutationObserver() {
      var iterations = 0;
      var observer = new lib$es6$promise$asap$$BrowserMutationObserver(lib$es6$promise$asap$$flush);
      var node = document.createTextNode('');
      observer.observe(node, { characterData: true });

      return function() {
        node.data = (iterations = ++iterations % 2);
      };
    }

    // web worker
    function lib$es6$promise$asap$$useMessageChannel() {
      var channel = new MessageChannel();
      channel.port1.onmessage = lib$es6$promise$asap$$flush;
      return function () {
        channel.port2.postMessage(0);
      };
    }

    function lib$es6$promise$asap$$useSetTimeout() {
      return function() {
        setTimeout(lib$es6$promise$asap$$flush, 1);
      };
    }

    var lib$es6$promise$asap$$queue = new Array(1000);
    function lib$es6$promise$asap$$flush() {
      for (var i = 0; i < lib$es6$promise$asap$$len; i+=2) {
        var callback = lib$es6$promise$asap$$queue[i];
        var arg = lib$es6$promise$asap$$queue[i+1];

        callback(arg);

        lib$es6$promise$asap$$queue[i] = undefined;
        lib$es6$promise$asap$$queue[i+1] = undefined;
      }

      lib$es6$promise$asap$$len = 0;
    }

    function lib$es6$promise$asap$$attemptVertex() {
      try {
        var r = require;
        var vertx = r('vertx');
        lib$es6$promise$asap$$vertxNext = vertx.runOnLoop || vertx.runOnContext;
        return lib$es6$promise$asap$$useVertxTimer();
      } catch(e) {
        return lib$es6$promise$asap$$useSetTimeout();
      }
    }

    var lib$es6$promise$asap$$scheduleFlush;
    // Decide what async method to use to triggering processing of queued callbacks:
    if (lib$es6$promise$asap$$isNode) {
      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useNextTick();
    } else if (lib$es6$promise$asap$$BrowserMutationObserver) {
      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useMutationObserver();
    } else if (lib$es6$promise$asap$$isWorker) {
      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useMessageChannel();
    } else if (lib$es6$promise$asap$$browserWindow === undefined && typeof require === 'function') {
      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$attemptVertex();
    } else {
      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useSetTimeout();
    }

    function lib$es6$promise$$internal$$noop() {}

    var lib$es6$promise$$internal$$PENDING   = void 0;
    var lib$es6$promise$$internal$$FULFILLED = 1;
    var lib$es6$promise$$internal$$REJECTED  = 2;

    var lib$es6$promise$$internal$$GET_THEN_ERROR = new lib$es6$promise$$internal$$ErrorObject();

    function lib$es6$promise$$internal$$selfFullfillment() {
      return new TypeError("You cannot resolve a promise with itself");
    }

    function lib$es6$promise$$internal$$cannotReturnOwn() {
      return new TypeError('A promises callback cannot return that same promise.');
    }

    function lib$es6$promise$$internal$$getThen(promise) {
      try {
        return promise.then;
      } catch(error) {
        lib$es6$promise$$internal$$GET_THEN_ERROR.error = error;
        return lib$es6$promise$$internal$$GET_THEN_ERROR;
      }
    }

    function lib$es6$promise$$internal$$tryThen(then, value, fulfillmentHandler, rejectionHandler) {
      try {
        then.call(value, fulfillmentHandler, rejectionHandler);
      } catch(e) {
        return e;
      }
    }

    function lib$es6$promise$$internal$$handleForeignThenable(promise, thenable, then) {
       lib$es6$promise$asap$$asap(function(promise) {
        var sealed = false;
        var error = lib$es6$promise$$internal$$tryThen(then, thenable, function(value) {
          if (sealed) { return; }
          sealed = true;
          if (thenable !== value) {
            lib$es6$promise$$internal$$resolve(promise, value);
          } else {
            lib$es6$promise$$internal$$fulfill(promise, value);
          }
        }, function(reason) {
          if (sealed) { return; }
          sealed = true;

          lib$es6$promise$$internal$$reject(promise, reason);
        }, 'Settle: ' + (promise._label || ' unknown promise'));

        if (!sealed && error) {
          sealed = true;
          lib$es6$promise$$internal$$reject(promise, error);
        }
      }, promise);
    }

    function lib$es6$promise$$internal$$handleOwnThenable(promise, thenable) {
      if (thenable._state === lib$es6$promise$$internal$$FULFILLED) {
        lib$es6$promise$$internal$$fulfill(promise, thenable._result);
      } else if (thenable._state === lib$es6$promise$$internal$$REJECTED) {
        lib$es6$promise$$internal$$reject(promise, thenable._result);
      } else {
        lib$es6$promise$$internal$$subscribe(thenable, undefined, function(value) {
          lib$es6$promise$$internal$$resolve(promise, value);
        }, function(reason) {
          lib$es6$promise$$internal$$reject(promise, reason);
        });
      }
    }

    function lib$es6$promise$$internal$$handleMaybeThenable(promise, maybeThenable) {
      if (maybeThenable.constructor === promise.constructor) {
        lib$es6$promise$$internal$$handleOwnThenable(promise, maybeThenable);
      } else {
        var then = lib$es6$promise$$internal$$getThen(maybeThenable);

        if (then === lib$es6$promise$$internal$$GET_THEN_ERROR) {
          lib$es6$promise$$internal$$reject(promise, lib$es6$promise$$internal$$GET_THEN_ERROR.error);
        } else if (then === undefined) {
          lib$es6$promise$$internal$$fulfill(promise, maybeThenable);
        } else if (lib$es6$promise$utils$$isFunction(then)) {
          lib$es6$promise$$internal$$handleForeignThenable(promise, maybeThenable, then);
        } else {
          lib$es6$promise$$internal$$fulfill(promise, maybeThenable);
        }
      }
    }

    function lib$es6$promise$$internal$$resolve(promise, value) {
      if (promise === value) {
        lib$es6$promise$$internal$$reject(promise, lib$es6$promise$$internal$$selfFullfillment());
      } else if (lib$es6$promise$utils$$objectOrFunction(value)) {
        lib$es6$promise$$internal$$handleMaybeThenable(promise, value);
      } else {
        lib$es6$promise$$internal$$fulfill(promise, value);
      }
    }

    function lib$es6$promise$$internal$$publishRejection(promise) {
      if (promise._onerror) {
        promise._onerror(promise._result);
      }

      lib$es6$promise$$internal$$publish(promise);
    }

    function lib$es6$promise$$internal$$fulfill(promise, value) {
      if (promise._state !== lib$es6$promise$$internal$$PENDING) { return; }

      promise._result = value;
      promise._state = lib$es6$promise$$internal$$FULFILLED;

      if (promise._subscribers.length !== 0) {
        lib$es6$promise$asap$$asap(lib$es6$promise$$internal$$publish, promise);
      }
    }

    function lib$es6$promise$$internal$$reject(promise, reason) {
      if (promise._state !== lib$es6$promise$$internal$$PENDING) { return; }
      promise._state = lib$es6$promise$$internal$$REJECTED;
      promise._result = reason;

      lib$es6$promise$asap$$asap(lib$es6$promise$$internal$$publishRejection, promise);
    }

    function lib$es6$promise$$internal$$subscribe(parent, child, onFulfillment, onRejection) {
      var subscribers = parent._subscribers;
      var length = subscribers.length;

      parent._onerror = null;

      subscribers[length] = child;
      subscribers[length + lib$es6$promise$$internal$$FULFILLED] = onFulfillment;
      subscribers[length + lib$es6$promise$$internal$$REJECTED]  = onRejection;

      if (length === 0 && parent._state) {
        lib$es6$promise$asap$$asap(lib$es6$promise$$internal$$publish, parent);
      }
    }

    function lib$es6$promise$$internal$$publish(promise) {
      var subscribers = promise._subscribers;
      var settled = promise._state;

      if (subscribers.length === 0) { return; }

      var child, callback, detail = promise._result;

      for (var i = 0; i < subscribers.length; i += 3) {
        child = subscribers[i];
        callback = subscribers[i + settled];

        if (child) {
          lib$es6$promise$$internal$$invokeCallback(settled, child, callback, detail);
        } else {
          callback(detail);
        }
      }

      promise._subscribers.length = 0;
    }

    function lib$es6$promise$$internal$$ErrorObject() {
      this.error = null;
    }

    var lib$es6$promise$$internal$$TRY_CATCH_ERROR = new lib$es6$promise$$internal$$ErrorObject();

    function lib$es6$promise$$internal$$tryCatch(callback, detail) {
      try {
        return callback(detail);
      } catch(e) {
        lib$es6$promise$$internal$$TRY_CATCH_ERROR.error = e;
        return lib$es6$promise$$internal$$TRY_CATCH_ERROR;
      }
    }

    function lib$es6$promise$$internal$$invokeCallback(settled, promise, callback, detail) {
      var hasCallback = lib$es6$promise$utils$$isFunction(callback),
          value, error, succeeded, failed;

      if (hasCallback) {
        value = lib$es6$promise$$internal$$tryCatch(callback, detail);

        if (value === lib$es6$promise$$internal$$TRY_CATCH_ERROR) {
          failed = true;
          error = value.error;
          value = null;
        } else {
          succeeded = true;
        }

        if (promise === value) {
          lib$es6$promise$$internal$$reject(promise, lib$es6$promise$$internal$$cannotReturnOwn());
          return;
        }

      } else {
        value = detail;
        succeeded = true;
      }

      if (promise._state !== lib$es6$promise$$internal$$PENDING) {
        // noop
      } else if (hasCallback && succeeded) {
        lib$es6$promise$$internal$$resolve(promise, value);
      } else if (failed) {
        lib$es6$promise$$internal$$reject(promise, error);
      } else if (settled === lib$es6$promise$$internal$$FULFILLED) {
        lib$es6$promise$$internal$$fulfill(promise, value);
      } else if (settled === lib$es6$promise$$internal$$REJECTED) {
        lib$es6$promise$$internal$$reject(promise, value);
      }
    }

    function lib$es6$promise$$internal$$initializePromise(promise, resolver) {
      try {
        resolver(function resolvePromise(value){
          lib$es6$promise$$internal$$resolve(promise, value);
        }, function rejectPromise(reason) {
          lib$es6$promise$$internal$$reject(promise, reason);
        });
      } catch(e) {
        lib$es6$promise$$internal$$reject(promise, e);
      }
    }

    function lib$es6$promise$enumerator$$Enumerator(Constructor, input) {
      var enumerator = this;

      enumerator._instanceConstructor = Constructor;
      enumerator.promise = new Constructor(lib$es6$promise$$internal$$noop);

      if (enumerator._validateInput(input)) {
        enumerator._input     = input;
        enumerator.length     = input.length;
        enumerator._remaining = input.length;

        enumerator._init();

        if (enumerator.length === 0) {
          lib$es6$promise$$internal$$fulfill(enumerator.promise, enumerator._result);
        } else {
          enumerator.length = enumerator.length || 0;
          enumerator._enumerate();
          if (enumerator._remaining === 0) {
            lib$es6$promise$$internal$$fulfill(enumerator.promise, enumerator._result);
          }
        }
      } else {
        lib$es6$promise$$internal$$reject(enumerator.promise, enumerator._validationError());
      }
    }

    lib$es6$promise$enumerator$$Enumerator.prototype._validateInput = function(input) {
      return lib$es6$promise$utils$$isArray(input);
    };

    lib$es6$promise$enumerator$$Enumerator.prototype._validationError = function() {
      return new Error('Array Methods must be provided an Array');
    };

    lib$es6$promise$enumerator$$Enumerator.prototype._init = function() {
      this._result = new Array(this.length);
    };

    var lib$es6$promise$enumerator$$default = lib$es6$promise$enumerator$$Enumerator;

    lib$es6$promise$enumerator$$Enumerator.prototype._enumerate = function() {
      var enumerator = this;

      var length  = enumerator.length;
      var promise = enumerator.promise;
      var input   = enumerator._input;

      for (var i = 0; promise._state === lib$es6$promise$$internal$$PENDING && i < length; i++) {
        enumerator._eachEntry(input[i], i);
      }
    };

    lib$es6$promise$enumerator$$Enumerator.prototype._eachEntry = function(entry, i) {
      var enumerator = this;
      var c = enumerator._instanceConstructor;

      if (lib$es6$promise$utils$$isMaybeThenable(entry)) {
        if (entry.constructor === c && entry._state !== lib$es6$promise$$internal$$PENDING) {
          entry._onerror = null;
          enumerator._settledAt(entry._state, i, entry._result);
        } else {
          enumerator._willSettleAt(c.resolve(entry), i);
        }
      } else {
        enumerator._remaining--;
        enumerator._result[i] = entry;
      }
    };

    lib$es6$promise$enumerator$$Enumerator.prototype._settledAt = function(state, i, value) {
      var enumerator = this;
      var promise = enumerator.promise;

      if (promise._state === lib$es6$promise$$internal$$PENDING) {
        enumerator._remaining--;

        if (state === lib$es6$promise$$internal$$REJECTED) {
          lib$es6$promise$$internal$$reject(promise, value);
        } else {
          enumerator._result[i] = value;
        }
      }

      if (enumerator._remaining === 0) {
        lib$es6$promise$$internal$$fulfill(promise, enumerator._result);
      }
    };

    lib$es6$promise$enumerator$$Enumerator.prototype._willSettleAt = function(promise, i) {
      var enumerator = this;

      lib$es6$promise$$internal$$subscribe(promise, undefined, function(value) {
        enumerator._settledAt(lib$es6$promise$$internal$$FULFILLED, i, value);
      }, function(reason) {
        enumerator._settledAt(lib$es6$promise$$internal$$REJECTED, i, reason);
      });
    };
    function lib$es6$promise$promise$all$$all(entries) {
      return new lib$es6$promise$enumerator$$default(this, entries).promise;
    }
    var lib$es6$promise$promise$all$$default = lib$es6$promise$promise$all$$all;
    function lib$es6$promise$promise$race$$race(entries) {
      /*jshint validthis:true */
      var Constructor = this;

      var promise = new Constructor(lib$es6$promise$$internal$$noop);

      if (!lib$es6$promise$utils$$isArray(entries)) {
        lib$es6$promise$$internal$$reject(promise, new TypeError('You must pass an array to race.'));
        return promise;
      }

      var length = entries.length;

      function onFulfillment(value) {
        lib$es6$promise$$internal$$resolve(promise, value);
      }

      function onRejection(reason) {
        lib$es6$promise$$internal$$reject(promise, reason);
      }

      for (var i = 0; promise._state === lib$es6$promise$$internal$$PENDING && i < length; i++) {
        lib$es6$promise$$internal$$subscribe(Constructor.resolve(entries[i]), undefined, onFulfillment, onRejection);
      }

      return promise;
    }
    var lib$es6$promise$promise$race$$default = lib$es6$promise$promise$race$$race;
    function lib$es6$promise$promise$resolve$$resolve(object) {
      /*jshint validthis:true */
      var Constructor = this;

      if (object && typeof object === 'object' && object.constructor === Constructor) {
        return object;
      }

      var promise = new Constructor(lib$es6$promise$$internal$$noop);
      lib$es6$promise$$internal$$resolve(promise, object);
      return promise;
    }
    var lib$es6$promise$promise$resolve$$default = lib$es6$promise$promise$resolve$$resolve;
    function lib$es6$promise$promise$reject$$reject(reason) {
      /*jshint validthis:true */
      var Constructor = this;
      var promise = new Constructor(lib$es6$promise$$internal$$noop);
      lib$es6$promise$$internal$$reject(promise, reason);
      return promise;
    }
    var lib$es6$promise$promise$reject$$default = lib$es6$promise$promise$reject$$reject;

    var lib$es6$promise$promise$$counter = 0;

    function lib$es6$promise$promise$$needsResolver() {
      throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
    }

    function lib$es6$promise$promise$$needsNew() {
      throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
    }

    var lib$es6$promise$promise$$default = lib$es6$promise$promise$$Promise;
    /**
      Promise objects represent the eventual result of an asynchronous operation. The
      primary way of interacting with a promise is through its `then` method, which
      registers callbacks to receive either a promise's eventual value or the reason
      why the promise cannot be fulfilled.

      Terminology
      -----------

      - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
      - `thenable` is an object or function that defines a `then` method.
      - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
      - `exception` is a value that is thrown using the throw statement.
      - `reason` is a value that indicates why a promise was rejected.
      - `settled` the final resting state of a promise, fulfilled or rejected.

      A promise can be in one of three states: pending, fulfilled, or rejected.

      Promises that are fulfilled have a fulfillment value and are in the fulfilled
      state.  Promises that are rejected have a rejection reason and are in the
      rejected state.  A fulfillment value is never a thenable.

      Promises can also be said to *resolve* a value.  If this value is also a
      promise, then the original promise's settled state will match the value's
      settled state.  So a promise that *resolves* a promise that rejects will
      itself reject, and a promise that *resolves* a promise that fulfills will
      itself fulfill.


      Basic Usage:
      ------------

      ```js
      var promise = new Promise(function(resolve, reject) {
        // on success
        resolve(value);

        // on failure
        reject(reason);
      });

      promise.then(function(value) {
        // on fulfillment
      }, function(reason) {
        // on rejection
      });
      ```

      Advanced Usage:
      ---------------

      Promises shine when abstracting away asynchronous interactions such as
      `XMLHttpRequest`s.

      ```js
      function getJSON(url) {
        return new Promise(function(resolve, reject){
          var xhr = new XMLHttpRequest();

          xhr.open('GET', url);
          xhr.onreadystatechange = handler;
          xhr.responseType = 'json';
          xhr.setRequestHeader('Accept', 'application/json');
          xhr.send();

          function handler() {
            if (this.readyState === this.DONE) {
              if (this.status === 200) {
                resolve(this.response);
              } else {
                reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
              }
            }
          };
        });
      }

      getJSON('/posts.json').then(function(json) {
        // on fulfillment
      }, function(reason) {
        // on rejection
      });
      ```

      Unlike callbacks, promises are great composable primitives.

      ```js
      Promise.all([
        getJSON('/posts'),
        getJSON('/comments')
      ]).then(function(values){
        values[0] // => postsJSON
        values[1] // => commentsJSON

        return values;
      });
      ```

      @class Promise
      @param {function} resolver
      Useful for tooling.
      @constructor
    */
    function lib$es6$promise$promise$$Promise(resolver) {
      this._id = lib$es6$promise$promise$$counter++;
      this._state = undefined;
      this._result = undefined;
      this._subscribers = [];

      if (lib$es6$promise$$internal$$noop !== resolver) {
        if (!lib$es6$promise$utils$$isFunction(resolver)) {
          lib$es6$promise$promise$$needsResolver();
        }

        if (!(this instanceof lib$es6$promise$promise$$Promise)) {
          lib$es6$promise$promise$$needsNew();
        }

        lib$es6$promise$$internal$$initializePromise(this, resolver);
      }
    }

    lib$es6$promise$promise$$Promise.all = lib$es6$promise$promise$all$$default;
    lib$es6$promise$promise$$Promise.race = lib$es6$promise$promise$race$$default;
    lib$es6$promise$promise$$Promise.resolve = lib$es6$promise$promise$resolve$$default;
    lib$es6$promise$promise$$Promise.reject = lib$es6$promise$promise$reject$$default;
    lib$es6$promise$promise$$Promise._setScheduler = lib$es6$promise$asap$$setScheduler;
    lib$es6$promise$promise$$Promise._setAsap = lib$es6$promise$asap$$setAsap;
    lib$es6$promise$promise$$Promise._asap = lib$es6$promise$asap$$asap;

    lib$es6$promise$promise$$Promise.prototype = {
      constructor: lib$es6$promise$promise$$Promise,

    /**
      The primary way of interacting with a promise is through its `then` method,
      which registers callbacks to receive either a promise's eventual value or the
      reason why the promise cannot be fulfilled.

      ```js
      findUser().then(function(user){
        // user is available
      }, function(reason){
        // user is unavailable, and you are given the reason why
      });
      ```

      Chaining
      --------

      The return value of `then` is itself a promise.  This second, 'downstream'
      promise is resolved with the return value of the first promise's fulfillment
      or rejection handler, or rejected if the handler throws an exception.

      ```js
      findUser().then(function (user) {
        return user.name;
      }, function (reason) {
        return 'default name';
      }).then(function (userName) {
        // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
        // will be `'default name'`
      });

      findUser().then(function (user) {
        throw new Error('Found user, but still unhappy');
      }, function (reason) {
        throw new Error('`findUser` rejected and we're unhappy');
      }).then(function (value) {
        // never reached
      }, function (reason) {
        // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
        // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
      });
      ```
      If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.

      ```js
      findUser().then(function (user) {
        throw new PedagogicalException('Upstream error');
      }).then(function (value) {
        // never reached
      }).then(function (value) {
        // never reached
      }, function (reason) {
        // The `PedgagocialException` is propagated all the way down to here
      });
      ```

      Assimilation
      ------------

      Sometimes the value you want to propagate to a downstream promise can only be
      retrieved asynchronously. This can be achieved by returning a promise in the
      fulfillment or rejection handler. The downstream promise will then be pending
      until the returned promise is settled. This is called *assimilation*.

      ```js
      findUser().then(function (user) {
        return findCommentsByAuthor(user);
      }).then(function (comments) {
        // The user's comments are now available
      });
      ```

      If the assimliated promise rejects, then the downstream promise will also reject.

      ```js
      findUser().then(function (user) {
        return findCommentsByAuthor(user);
      }).then(function (comments) {
        // If `findCommentsByAuthor` fulfills, we'll have the value here
      }, function (reason) {
        // If `findCommentsByAuthor` rejects, we'll have the reason here
      });
      ```

      Simple Example
      --------------

      Synchronous Example

      ```javascript
      var result;

      try {
        result = findResult();
        // success
      } catch(reason) {
        // failure
      }
      ```

      Errback Example

      ```js
      findResult(function(result, err){
        if (err) {
          // failure
        } else {
          // success
        }
      });
      ```

      Promise Example;

      ```javascript
      findResult().then(function(result){
        // success
      }, function(reason){
        // failure
      });
      ```

      Advanced Example
      --------------

      Synchronous Example

      ```javascript
      var author, books;

      try {
        author = findAuthor();
        books  = findBooksByAuthor(author);
        // success
      } catch(reason) {
        // failure
      }
      ```

      Errback Example

      ```js

      function foundBooks(books) {

      }

      function failure(reason) {

      }

      findAuthor(function(author, err){
        if (err) {
          failure(err);
          // failure
        } else {
          try {
            findBoooksByAuthor(author, function(books, err) {
              if (err) {
                failure(err);
              } else {
                try {
                  foundBooks(books);
                } catch(reason) {
                  failure(reason);
                }
              }
            });
          } catch(error) {
            failure(err);
          }
          // success
        }
      });
      ```

      Promise Example;

      ```javascript
      findAuthor().
        then(findBooksByAuthor).
        then(function(books){
          // found books
      }).catch(function(reason){
        // something went wrong
      });
      ```

      @method then
      @param {Function} onFulfilled
      @param {Function} onRejected
      Useful for tooling.
      @return {Promise}
    */
      then: function(onFulfillment, onRejection) {
        var parent = this;
        var state = parent._state;

        if (state === lib$es6$promise$$internal$$FULFILLED && !onFulfillment || state === lib$es6$promise$$internal$$REJECTED && !onRejection) {
          return this;
        }

        var child = new this.constructor(lib$es6$promise$$internal$$noop);
        var result = parent._result;

        if (state) {
          var callback = arguments[state - 1];
          lib$es6$promise$asap$$asap(function(){
            lib$es6$promise$$internal$$invokeCallback(state, child, callback, result);
          });
        } else {
          lib$es6$promise$$internal$$subscribe(parent, child, onFulfillment, onRejection);
        }

        return child;
      },

    /**
      `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
      as the catch block of a try/catch statement.

      ```js
      function findAuthor(){
        throw new Error('couldn't find that author');
      }

      // synchronous
      try {
        findAuthor();
      } catch(reason) {
        // something went wrong
      }

      // async with promises
      findAuthor().catch(function(reason){
        // something went wrong
      });
      ```

      @method catch
      @param {Function} onRejection
      Useful for tooling.
      @return {Promise}
    */
      'catch': function(onRejection) {
        return this.then(null, onRejection);
      }
    };
    function lib$es6$promise$polyfill$$polyfill() {
      var local;

      if (typeof global !== 'undefined') {
          local = global;
      } else if (typeof self !== 'undefined') {
          local = self;
      } else {
          try {
              local = Function('return this')();
          } catch (e) {
              throw new Error('polyfill failed because global object is unavailable in this environment');
          }
      }

      var P = local.Promise;

      // ##### BEGIN: MODIFIED BY SAP
      // Original line:
      //    if (P && Object.prototype.toString.call(P.resolve()) === '[object Promise]' && !P.cast) {
      // This lead to the polyfill replacing the native promise object in
      // - Chrome, where "[object Object]" is returned instead of '[object Promise]'
      // - Safari, where native promise contains a definition for Promise.cast
      if (P && Object.prototype.toString.call(P.resolve()).indexOf('[object ') === 0) {
      // ##### END: MODIFIED BY SAP
        return;
      }

      local.Promise = lib$es6$promise$promise$$default;
    }
    var lib$es6$promise$polyfill$$default = lib$es6$promise$polyfill$$polyfill;

    var lib$es6$promise$umd$$ES6Promise = {
      'Promise': lib$es6$promise$promise$$default,
      'polyfill': lib$es6$promise$polyfill$$default
    };

    /* global define:true module:true window: true */
    if (typeof define === 'function' && define['amd']) {
      // ##### BEGIN: MODIFIED BY SAP
      // Original line:
      // define(function() { return lib$es6$promise$umd$$ES6Promise; });
      define('sap/ui/thirdparty/es6-promise', function() { return lib$es6$promise$umd$$ES6Promise; });
      // ##### END: MODIFIED BY SAP
    } else if (typeof module !== 'undefined' && module['exports']) {
      module['exports'] = lib$es6$promise$umd$$ES6Promise;
      // ##### BEGIN: MODIFIED BY SAP
      // When require.js was loaded before the core, this will not set the global window.ES6Promise property and thus
      // keep the rest of the framework from working in browsers that do not have native Promise support.
      // Original line:
      // } else if (typeof this !== 'undefined') {
    }
    if (typeof this !== 'undefined') {
      // ##### END: MODIFIED BY SAP
      this['ES6Promise'] = lib$es6$promise$umd$$ES6Promise;
    }


    // ##### BEGIN: MODIFIED BY SAP
    // Original line:
    //     lib$es6$promise$polyfill$$default();
    // Do not automatically call the polyfill method as this will be called by UI5 only when needed.
    // ##### END: MODIFIED BY SAP
}).call(this);
/*!
 * jQuery JavaScript Library v2.2.3
 * http://jquery.com/
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2016-04-05T19:26Z
 */

(function( global, factory ) {

	if ( typeof module === "object" && typeof module.exports === "object" ) {
		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
}(typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Support: Firefox 18+
// Can't be in strict mode, several libs including ASP.NET trace
// the stack via arguments.caller.callee and Firefox dies if
// you try to trace through "use strict" call chains. (#13335)
//"use strict";
var arr = [];

var document = window.document;

var slice = arr.slice;

var concat = arr.concat;

var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var support = {};



var
	version = "2.2.3",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	},

	// Support: Android<4.1
	// Make sure we trim BOM and NBSP
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

	// Matches dashed string for camelizing
	rmsPrefix = /^-ms-/,
	rdashAlpha = /-([\da-z])/gi,

	// Used by jQuery.camelCase as callback to replace()
	fcamelCase = function( all, letter ) {
		return letter.toUpperCase();
	};

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// Start with an empty selector
	selector: "",

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {
		return num != null ?

			// Return just the one element from the set
			( num < 0 ? this[ num + this.length ] : this[ num ] ) :

			// Return all the elements in a clean array
			slice.call( this );
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;
		ret.context = this.context;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !jQuery.isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// ##### BEGIN: MODIFIED BY SAP
				// Prevent Object.prototype pollution for $.extend( true, ... )
				// For further information, please visit https://github.com/jquery/jquery/pull/4333
				// Code taken from jQuery v3.4.0
				// Prevent never-ending loop
				if ( name === "__proto__" || target === copy ) {
					continue;
				}
				// ##### END: MODIFIED BY SAP

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = jQuery.isArray( copy ) ) ) ) {

					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && jQuery.isArray( src ) ? src : [];

					} else {
						clone = src && jQuery.isPlainObject( src ) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isFunction: function( obj ) {
		return jQuery.type( obj ) === "function";
	},

	isArray: Array.isArray,

	isWindow: function( obj ) {
		return obj != null && obj === obj.window;
	},

	isNumeric: function( obj ) {

		// parseFloat NaNs numeric-cast false positives (null|true|false|"")
		// ...but misinterprets leading-number strings, particularly hex literals ("0x...")
		// subtraction forces infinities to NaN
		// adding 1 corrects loss of precision from parseFloat (#15100)
		var realStringObj = obj && obj.toString();
		return !jQuery.isArray( obj ) && ( realStringObj - parseFloat( realStringObj ) + 1 ) >= 0;
	},

	isPlainObject: function( obj ) {
		var key;

		// Not plain objects:
		// - Any object or value whose internal [[Class]] property is not "[object Object]"
		// - DOM nodes
		// - window
		if ( jQuery.type( obj ) !== "object" || obj.nodeType || jQuery.isWindow( obj ) ) {
			return false;
		}

		// Not own constructor property must be Object
		if ( obj.constructor &&
				!hasOwn.call( obj, "constructor" ) &&
				!hasOwn.call( obj.constructor.prototype || {}, "isPrototypeOf" ) ) {
			return false;
		}

		// Own properties are enumerated firstly, so to speed up,
		// if last one is own, then all properties are own
		for ( key in obj ) {}

		return key === undefined || hasOwn.call( obj, key );
	},

	isEmptyObject: function( obj ) {
		var name;
		for ( name in obj ) {
			return false;
		}
		return true;
	},

	type: function( obj ) {
		if ( obj == null ) {
			return obj + "";
		}

		// Support: Android<4.0, iOS<6 (functionish RegExp)
		return typeof obj === "object" || typeof obj === "function" ?
			class2type[ toString.call( obj ) ] || "object" :
			typeof obj;
	},

	// Evaluates a script in a global context
	globalEval: function( code ) {
		var script,
			indirect = eval;

		code = jQuery.trim( code );

		if ( code ) {

			// If the code includes a valid, prologue position
			// strict mode pragma, execute code by injecting a
			// script tag into the document.
			if ( code.indexOf( "use strict" ) === 1 ) {
				script = document.createElement( "script" );
				script.text = code;
				document.head.appendChild( script ).parentNode.removeChild( script );
			} else {

				// Otherwise, avoid the DOM node creation, insertion
				// and removal by using an indirect global eval

				indirect( code );
			}
		}
	},

	// Convert dashed to camelCase; used by the css and data modules
	// Support: IE9-11+
	// Microsoft forgot to hump their vendor prefix (#9572)
	camelCase: function( string ) {
		return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
	},

	nodeName: function( elem, name ) {
		return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},

	// Support: Android<4.1
	trim: function( text ) {
		return text == null ?
			"" :
			( text + "" ).replace( rtrim, "" );
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
					[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return concat.apply( [], ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// Bind a function to a context, optionally partially applying any
	// arguments.
	proxy: function( fn, context ) {
		var tmp, args, proxy;

		if ( typeof context === "string" ) {
			tmp = fn[ context ];
			context = fn;
			fn = tmp;
		}

		// Quick check to determine if target is callable, in the spec
		// this throws a TypeError, but we will just return undefined.
		if ( !jQuery.isFunction( fn ) ) {
			return undefined;
		}

		// Simulated bind
		args = slice.call( arguments, 2 );
		proxy = function() {
			return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
		};

		// Set the guid of unique handler to the same of original handler, so it can be removed
		proxy.guid = fn.guid = fn.guid || jQuery.guid++;

		return proxy;
	},

	now: Date.now,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

// JSHint would error on this code due to the Symbol not being defined in ES5.
// Defining this global in .jshintrc would create a danger of using the global
// unguarded in another place, it seems safer to just disable JSHint for these
// three lines.
/* jshint ignore: start */
if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}
/* jshint ignore: end */

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
function( i, name ) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
} );

function isArrayLike( obj ) {

	// Support: iOS 8.2 (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = jQuery.type( obj );

	if ( type === "function" || jQuery.isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v2.2.1
 * http://sizzlejs.com/
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2015-10-17
 */
(function( window ) {

var i,
	support,
	Expr,
	getText,
	isXML,
	tokenize,
	compile,
	select,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + 1 * new Date(),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// General-purpose constants
	MAX_NEGATIVE = 1 << 31,

	// Instance methods
	hasOwn = ({}).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	push_native = arr.push,
	push = arr.push,
	slice = arr.slice,
	// Use a stripped-down indexOf as it's faster than native
	// http://jsperf.com/thor-indexof-vs-for/5
	indexOf = function( list, elem ) {
		var i = 0,
			len = list.length;
		for ( ; i < len; i++ ) {
			if ( list[i] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",

	// http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
	identifier = "(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",

	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +
		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +
		// "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" + whitespace +
		"*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +
		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +
		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +
		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*" ),

	rattributeQuotes = new RegExp( "=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + identifier + ")" ),
		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),
		"TAG": new RegExp( "^(" + identifier + "|[*])" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace +
			"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
			"*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),
		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" +
			whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,
	rescape = /'|\\/g,

	// CSS escapes http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig" ),
	funescape = function( _, escaped, escapedWhitespace ) {
		var high = "0x" + escaped - 0x10000;
		// NaN means non-codepoint
		// Support: Firefox<24
		// Workaround erroneous numeric interpretation of +"0x"
		return high !== high || escapedWhitespace ?
			escaped :
			high < 0 ?
				// BMP codepoint
				String.fromCharCode( high + 0x10000 ) :
				// Supplemental Plane codepoint (surrogate pair)
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// Used for iframes
	// See setDocument()
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE
	unloadHandler = function() {
		setDocument();
	};

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		(arr = slice.call( preferredDoc.childNodes )),
		preferredDoc.childNodes
	);
	// Support: Android<4.0
	// Detect silently failing push.apply
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			push_native.apply( target, slice.call(els) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;
			// Can't trust NodeList.length
			while ( (target[j++] = els[i++]) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var m, i, elem, nid, nidselect, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {

		if ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {
			setDocument( context );
		}
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && (match = rquickExpr.exec( selector )) ) {

				// ID selector
				if ( (m = match[1]) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( (elem = context.getElementById( m )) ) {

							// Support: IE, Opera, Webkit
							// TODO: identify versions
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								results.push( elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE, Opera, Webkit
						// TODO: identify versions
						// getElementById can match elements by name instead of ID
						if ( newContext && (elem = newContext.getElementById( m )) &&
							contains( context, elem ) &&
							elem.id === m ) {

							results.push( elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[2] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( (m = match[3]) && support.getElementsByClassName &&
					context.getElementsByClassName ) {

					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( support.qsa &&
				!compilerCache[ selector + " " ] &&
				(!rbuggyQSA || !rbuggyQSA.test( selector )) ) {

				if ( nodeType !== 1 ) {
					newContext = context;
					newSelector = selector;

				// qSA looks outside Element context, which is not what we want
				// Thanks to Andrew Dupont for this workaround technique
				// Support: IE <=8
				// Exclude object elements
				} else if ( context.nodeName.toLowerCase() !== "object" ) {

					// Capture the context ID, setting it first if necessary
					if ( (nid = context.getAttribute( "id" )) ) {
						nid = nid.replace( rescape, "\\$&" );
					} else {
						context.setAttribute( "id", (nid = expando) );
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					nidselect = ridentifier.test( nid ) ? "#" + nid : "[id='" + nid + "']";
					while ( i-- ) {
						groups[i] = nidselect + " " + toSelector( groups[i] );
					}
					newSelector = groups.join( "," );

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;
				}

				if ( newSelector ) {
					try {
						push.apply( results,
							newContext.querySelectorAll( newSelector )
						);
						return results;
					} catch ( qsaError ) {
					} finally {
						if ( nid === expando ) {
							context.removeAttribute( "id" );
						}
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {
		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {
			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return (cache[ key + " " ] = value);
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created div and expects a boolean result
 */
function assert( fn ) {
	var div = document.createElement("div");

	try {
		return !!fn( div );
	} catch (e) {
		return false;
	} finally {
		// Remove from its parent by default
		if ( div.parentNode ) {
			div.parentNode.removeChild( div );
		}
		// release memory in IE
		div = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split("|"),
		i = arr.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[i] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			( ~b.sourceIndex || MAX_NEGATIVE ) -
			( ~a.sourceIndex || MAX_NEGATIVE );

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( (cur = cur.nextSibling) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return (name === "input" || name === "button") && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction(function( argument ) {
		argument = +argument;
		return markFunction(function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ (j = matchIndexes[i]) ] ) {
					seed[j] = !(matches[j] = seed[j]);
				}
			}
		});
	});
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	// documentElement is verified for cases where it doesn't yet exist
	// (such as loading iframes in IE - #4833)
	var documentElement = elem && (elem.ownerDocument || elem).documentElement;
	return documentElement ? documentElement.nodeName !== "HTML" : false;
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare, parent,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	if ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	docElem = document.documentElement;
	documentIsHTML = !isXML( document );

	// Support: IE 9-11, Edge
	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
	if ( (parent = document.defaultView) && parent.top !== parent ) {
		// Support: IE 11
		if ( parent.addEventListener ) {
			parent.addEventListener( "unload", unloadHandler, false );

		// Support: IE 9 - 10 only
		} else if ( parent.attachEvent ) {
			parent.attachEvent( "onunload", unloadHandler );
		}
	}

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties
	// (excepting IE8 booleans)
	support.attributes = assert(function( div ) {
		div.className = "i";
		return !div.getAttribute("className");
	});

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert(function( div ) {
		div.appendChild( document.createComment("") );
		return !div.getElementsByTagName("*").length;
	});

	// Support: IE<9
	support.getElementsByClassName = rnative.test( document.getElementsByClassName );

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert(function( div ) {
		docElem.appendChild( div ).id = expando;
		return !document.getElementsByName || !document.getElementsByName( expando ).length;
	});

	// ID find and filter
	if ( support.getById ) {
		Expr.find["ID"] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var m = context.getElementById( id );
				return m ? [ m ] : [];
			}
		};
		Expr.filter["ID"] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute("id") === attrId;
			};
		};
	} else {
		// Support: IE6/7
		// getElementById is not reliable as a find shortcut
		delete Expr.find["ID"];

		Expr.filter["ID"] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode("id");
				return node && node.value === attrId;
			};
		};
	}

	// Tag
	Expr.find["TAG"] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else if ( support.qsa ) {
				return context.querySelectorAll( tag );
			}
		} :

		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,
				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( (elem = results[i++]) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find["CLASS"] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See http://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( (support.qsa = rnative.test( document.querySelectorAll )) ) {
		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert(function( div ) {
			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// http://bugs.jquery.com/ticket/12359
			docElem.appendChild( div ).innerHTML = "<a id='" + expando + "'></a>" +
				"<select id='" + expando + "-\r\\' msallowcapture=''>" +
				"<option selected=''></option></select>";

			// Support: IE8, Opera 11-12.16
			// Nothing should be selected when empty strings follow ^= or $= or *=
			// The test attribute must be unknown in Opera but "safe" for WinRT
			// http://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
			if ( div.querySelectorAll("[msallowcapture^='']").length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !div.querySelectorAll("[selected]").length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
			if ( !div.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push("~=");
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !div.querySelectorAll(":checked").length ) {
				rbuggyQSA.push(":checked");
			}

			// Support: Safari 8+, iOS 8+
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibing-combinator selector` fails
			if ( !div.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push(".#.+[+~]");
			}
		});

		assert(function( div ) {
			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = document.createElement("input");
			input.setAttribute( "type", "hidden" );
			div.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( div.querySelectorAll("[name=d]").length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( !div.querySelectorAll(":enabled").length ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Opera 10-11 does not throw on post-comma invalid pseudos
			div.querySelectorAll("*,:x");
			rbuggyQSA.push(",.*:");
		});
	}

	if ( (support.matchesSelector = rnative.test( (matches = docElem.matches ||
		docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector) )) ) {

		assert(function( div ) {
			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( div, "div" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( div, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		});
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join("|") );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join("|") );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully self-exclusive
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			));
		} :
		function( a, b ) {
			if ( b ) {
				while ( (b = b.parentNode) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		compare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {

			// Choose the first element that is related to our preferred document
			if ( a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {
				return -1;
			}
			if ( b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {
		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {
			return a === document ? -1 :
				b === document ? 1 :
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( (cur = cur.parentNode) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( (cur = cur.parentNode) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[i] === bp[i] ) {
			i++;
		}

		return i ?
			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[i], bp[i] ) :

			// Otherwise nodes in our document sort first
			ap[i] === preferredDoc ? -1 :
			bp[i] === preferredDoc ? 1 :
			0;
	};

	return document;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	// Make sure that attribute selectors are quoted
	expr = expr.replace( rattributeQuotes, "='$1']" );

	if ( support.matchesSelector && documentIsHTML &&
		!compilerCache[ expr + " " ] &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||
					// As well, disconnected nodes are said to be in a document
					// fragment in IE 9
					elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch (e) {}
	}

	return Sizzle( expr, document, null, [ elem ] ).length > 0;
};

Sizzle.contains = function( context, elem ) {
	// Set document vars if needed
	if ( ( context.ownerDocument || context ) !== document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],
		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			(val = elem.getAttributeNode(name)) && val.specified ?
				val.value :
				null;
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( (elem = results[i++]) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {
		// If no nodeType, this is expected to be an array
		while ( (node = elem[i++]) ) {
			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {
		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {
			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}
	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[1] = match[1].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[3] = ( match[3] || match[4] || match[5] || "" ).replace( runescape, funescape );

			if ( match[2] === "~=" ) {
				match[3] = " " + match[3] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {
			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[1] = match[1].toLowerCase();

			if ( match[1].slice( 0, 3 ) === "nth" ) {
				// nth-* requires argument
				if ( !match[3] ) {
					Sizzle.error( match[0] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === "even" || match[3] === "odd" ) );
				match[5] = +( ( match[7] + match[8] ) || match[3] === "odd" );

			// other types prohibit arguments
			} else if ( match[3] ) {
				Sizzle.error( match[0] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[6] && match[2];

			if ( matchExpr["CHILD"].test( match[0] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[3] ) {
				match[2] = match[4] || match[5] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&
				// Get excess from tokenize (recursively)
				(excess = tokenize( unquoted, true )) &&
				// advance to the next closing parenthesis
				(excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length) ) {

				// excess is a negative index
				match[0] = match[0].slice( 0, excess );
				match[2] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() { return true; } :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				(pattern = new RegExp( "(^|" + whitespace + ")" + className + "(" + whitespace + "|$)" )) &&
				classCache( className, function( elem ) {
					return pattern.test( typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== "undefined" && elem.getAttribute("class") || "" );
				});
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
			};
		},

		"CHILD": function( type, what, argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, context, xml ) {
					var cache, uniqueCache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( (node = node[ dir ]) ) {
									if ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) {

										return false;
									}
								}
								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index

							// ...in a gzip-friendly way
							node = parent;
							outerCache = node[ expando ] || (node[ expando ] = {});

							// Support: IE <9 only
							// Defend against cloned attroperties (jQuery gh-1709)
							uniqueCache = outerCache[ node.uniqueID ] ||
								(outerCache[ node.uniqueID ] = {});

							cache = uniqueCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( (node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								(diff = nodeIndex = 0) || start.pop()) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {
							// Use previously-cached element index if available
							if ( useCache ) {
								// ...in a gzip-friendly way
								node = elem;
								outerCache = node[ expando ] || (node[ expando ] = {});

								// Support: IE <9 only
								// Defend against cloned attroperties (jQuery gh-1709)
								uniqueCache = outerCache[ node.uniqueID ] ||
									(outerCache[ node.uniqueID ] = {});

								cache = uniqueCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {
								// Use the same loop as above to seek `elem` from the start
								while ( (node = ++nodeIndex && node && node[ dir ] ||
									(diff = nodeIndex = 0) || start.pop()) ) {

									if ( ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] || (node[ expando ] = {});

											// Support: IE <9 only
											// Defend against cloned attroperties (jQuery gh-1709)
											uniqueCache = outerCache[ node.uniqueID ] ||
												(outerCache[ node.uniqueID ] = {});

											uniqueCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {
			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction(function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf( seed, matched[i] );
							seed[ idx ] = !( matches[ idx ] = matched[i] );
						}
					}) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {
		// Potentially complex pseudos
		"not": markFunction(function( selector ) {
			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction(function( seed, matches, context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( (elem = unmatched[i]) ) {
							seed[i] = !(matches[i] = elem);
						}
					}
				}) :
				function( elem, context, xml ) {
					input[0] = elem;
					matcher( input, null, xml, results );
					// Don't keep the element (issue #299)
					input[0] = null;
					return !results.pop();
				};
		}),

		"has": markFunction(function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		}),

		"contains": markFunction(function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;
			};
		}),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {
			// lang value must be a valid identifier
			if ( !ridentifier.test(lang || "") ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( (elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute("xml:lang") || elem.getAttribute("lang")) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( (elem = elem.parentNode) && elem.nodeType === 1 );
				return false;
			};
		}),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
		},

		// Boolean properties
		"enabled": function( elem ) {
			return elem.disabled === false;
		},

		"disabled": function( elem ) {
			return elem.disabled === true;
		},

		"checked": function( elem ) {
			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
		},

		"selected": function( elem ) {
			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {
			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos["empty"]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo(function() {
			return [ 0 ];
		}),

		"last": createPositionalPseudo(function( matchIndexes, length ) {
			return [ length - 1 ];
		}),

		"eq": createPositionalPseudo(function( matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		}),

		"even": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"odd": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"lt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"gt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		})
	}
};

Expr.pseudos["nth"] = Expr.pseudos["eq"];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || (match = rcomma.exec( soFar )) ) {
			if ( match ) {
				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[0].length ) || soFar;
			}
			groups.push( (tokens = []) );
		}

		matched = false;

		// Combinators
		if ( (match = rcombinators.exec( soFar )) ) {
			matched = match.shift();
			tokens.push({
				value: matched,
				// Cast descendant combinators to space
				type: match[0].replace( rtrim, " " )
			});
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||
				(match = preFilters[ type ]( match ))) ) {
				matched = match.shift();
				tokens.push({
					value: matched,
					type: type,
					matches: match
				});
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :
			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
};

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[i].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		checkNonElements = base && dir === "parentNode",
		doneName = done++;

	return combinator.first ?
		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( (elem = elem[ dir ]) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, uniqueCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || (elem[ expando ] = {});

						// Support: IE <9 only
						// Defend against cloned attroperties (jQuery gh-1709)
						uniqueCache = outerCache[ elem.uniqueID ] || (outerCache[ elem.uniqueID ] = {});

						if ( (oldCache = uniqueCache[ dir ]) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return (newCache[ 2 ] = oldCache[ 2 ]);
						} else {
							// Reuse newcache so results back-propagate to previous elements
							uniqueCache[ dir ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {
								return true;
							}
						}
					}
				}
			}
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[i]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[0];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[i], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( (elem = unmatched[i]) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction(function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts( selector || "*", context.nodeType ? [ context ] : context, [] ),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?
				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( (elem = temp[i]) ) {
					matcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {
					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( (elem = matcherOut[i]) ) {
							// Restore matcherIn since elem is not yet a final match
							temp.push( (matcherIn[i] = elem) );
						}
					}
					postFinder( null, (matcherOut = []), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( (elem = matcherOut[i]) &&
						(temp = postFinder ? indexOf( seed, elem ) : preMap[i]) > -1 ) {

						seed[temp] = !(results[temp] = elem);
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	});
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[0].type ],
		implicitRelative = leadingRelative || Expr.relative[" "],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				(checkContext = context).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );
			// Avoid hanging onto element (issue #299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( (matcher = Expr.relative[ tokens[i].type ]) ) {
			matchers = [ addCombinator(elementMatcher( matchers ), matcher) ];
		} else {
			matcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {
				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[j].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(
						// If the preceding token was a descendant combinator, insert an implicit any-element `*`
						tokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === " " ? "*" : "" })
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( (tokens = tokens.slice( j )) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,
				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find["TAG"]( "*", outermost ),
				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),
				len = elems.length;

			if ( outermost ) {
				outermostContext = context === document || context || outermost;
			}

			// Add elements passing elementMatchers directly to results
			// Support: IE<9, Safari
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
			for ( ; i !== len && (elem = elems[i]) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;
					if ( !context && elem.ownerDocument !== document ) {
						setDocument( elem );
						xml = !documentIsHTML;
					}
					while ( (matcher = elementMatchers[j++]) ) {
						if ( matcher( elem, context || document, xml) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {
					// They will have gone through all possible matchers
					if ( (elem = !matcher && elem) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// `i` is now the count of elements visited above, and adding it to `matchedCount`
			// makes the latter nonnegative.
			matchedCount += i;

			// Apply set filters to unmatched elements
			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
			// no element matchers and no seed.
			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
			// case, which will result in a "00" `matchedCount` that differs from `i` but is also
			// numerically zero.
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( (matcher = setMatchers[j++]) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {
					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !(unmatched[i] || setMatched[i]) ) {
								setMatched[i] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {
		// Generate a function of recursive functions that can be used to check each element
		if ( !match ) {
			match = tokenize( selector );
		}
		i = match.length;
		while ( i-- ) {
			cached = matcherFromTokens( match[i] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );

		// Save selector and tokenization
		cached.selector = selector;
	}
	return cached;
};

/**
 * A low-level selection function that works with Sizzle's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with Sizzle.compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */
select = Sizzle.select = function( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		compiled = typeof selector === "function" && selector,
		match = !seed && tokenize( (selector = compiled.selector || selector) );

	results = results || [];

	// Try to minimize operations if there is only one selector in the list and no seed
	// (the latter of which guarantees us context)
	if ( match.length === 1 ) {

		// Reduce context if the leading compound selector is an ID
		tokens = match[0] = match[0].slice( 0 );
		if ( tokens.length > 2 && (token = tokens[0]).type === "ID" &&
				support.getById && context.nodeType === 9 && documentIsHTML &&
				Expr.relative[ tokens[1].type ] ) {

			context = ( Expr.find["ID"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];
			if ( !context ) {
				return results;

			// Precompiled matchers will still verify ancestry, so step up a level
			} else if ( compiled ) {
				context = context.parentNode;
			}

			selector = selector.slice( tokens.shift().value.length );
		}

		// Fetch a seed set for right-to-left matching
		i = matchExpr["needsContext"].test( selector ) ? 0 : tokens.length;
		while ( i-- ) {
			token = tokens[i];

			// Abort if we hit a combinator
			if ( Expr.relative[ (type = token.type) ] ) {
				break;
			}
			if ( (find = Expr.find[ type ]) ) {
				// Search, expanding context for leading sibling combinators
				if ( (seed = find(
					token.matches[0].replace( runescape, funescape ),
					rsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context
				)) ) {

					// If seed is empty or no tokens remain, we can return early
					tokens.splice( i, 1 );
					selector = seed.length && toSelector( tokens );
					if ( !selector ) {
						push.apply( results, seed );
						return results;
					}

					break;
				}
			}
		}
	}

	// Compile and execute a filtering function if one is not provided
	// Provide `match` to avoid retokenization if we modified the selector above
	( compiled || compile( selector, match ) )(
		seed,
		context,
		!documentIsHTML,
		results,
		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
};

// One-time assignments

// Sort stability
support.sortStable = expando.split("").sort( sortOrder ).join("") === expando;

// Support: Chrome 14-35+
// Always assume duplicates if they aren't passed to the comparison function
support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert(function( div1 ) {
	// Should return 1, but returns 4 (following)
	return div1.compareDocumentPosition( document.createElement("div") ) & 1;
});

// Support: IE<8
// Prevent attribute/property "interpolation"
// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !assert(function( div ) {
	div.innerHTML = "<a href='#'></a>";
	return div.firstChild.getAttribute("href") === "#" ;
}) ) {
	addHandle( "type|href|height|width", function( elem, name, isXML ) {
		if ( !isXML ) {
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
		}
	});
}

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
if ( !support.attributes || !assert(function( div ) {
	div.innerHTML = "<input/>";
	div.firstChild.setAttribute( "value", "" );
	return div.firstChild.getAttribute( "value" ) === "";
}) ) {
	addHandle( "value", function( elem, name, isXML ) {
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
			return elem.defaultValue;
		}
	});
}

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
if ( !assert(function( div ) {
	return div.getAttribute("disabled") == null;
}) ) {
	addHandle( booleans, function( elem, name, isXML ) {
		var val;
		if ( !isXML ) {
			return elem[ name ] === true ? name.toLowerCase() :
					(val = elem.getAttributeNode( name )) && val.specified ?
					val.value :
				null;
		}
	});
}

return Sizzle;

})( window );



jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;
jQuery.expr[ ":" ] = jQuery.expr.pseudos;
jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;



var dir = function( elem, dir, until ) {
	var matched = [],
		truncate = until !== undefined;

	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
		if ( elem.nodeType === 1 ) {
			if ( truncate && jQuery( elem ).is( until ) ) {
				break;
			}
			matched.push( elem );
		}
	}
	return matched;
};


var siblings = function( n, elem ) {
	var matched = [];

	for ( ; n; n = n.nextSibling ) {
		if ( n.nodeType === 1 && n !== elem ) {
			matched.push( n );
		}
	}

	return matched;
};


var rneedsContext = jQuery.expr.match.needsContext;

var rsingleTag = ( /^<([\w-]+)\s*\/?>(?:<\/\1>|)$/ );



var risSimple = /^.[^:#\[\.,]*$/;

// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( jQuery.isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			/* jshint -W018 */
			return !!qualifier.call( elem, i, elem ) !== not;
		} );

	}

	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		} );

	}

	if ( typeof qualifier === "string" ) {
		if ( risSimple.test( qualifier ) ) {
			return jQuery.filter( qualifier, elements, not );
		}

		qualifier = jQuery.filter( qualifier, elements );
	}

	return jQuery.grep( elements, function( elem ) {
		return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
	} );
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	return elems.length === 1 && elem.nodeType === 1 ?
		jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [] :
		jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
			return elem.nodeType === 1;
		} ) );
};

jQuery.fn.extend( {
	find: function( selector ) {
		var i,
			len = this.length,
			ret = [],
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		// Needed because $( selector, context ) becomes $( context ).find( selector )
		ret = this.pushStack( len > 1 ? jQuery.unique( ret ) : ret );
		ret.selector = this.selector ? this.selector + " " + selector : selector;
		return ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow( this, selector || [], false ) );
	},
	not: function( selector ) {
		return this.pushStack( winnow( this, selector || [], true ) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
} );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Method init() accepts an alternate rootjQuery
		// so migrate can support jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && ( match[ 1 ] || !context ) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Option to run scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {

							// Properties of context are called as methods if possible
							if ( jQuery.isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[ 2 ] );

					// Support: Blackberry 4.6
					// gEBID returns nodes no longer in the document (#6963)
					if ( elem && elem.parentNode ) {

						// Inject the element directly into the jQuery object
						this.length = 1;
						this[ 0 ] = elem;
					}

					this.context = document;
					this.selector = selector;
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || root ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this.context = this[ 0 ] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( jQuery.isFunction( selector ) ) {
			return root.ready !== undefined ?
				root.ready( selector ) :

				// Execute immediately if ready is not present
				selector( jQuery );
		}

		if ( selector.selector !== undefined ) {
			this.selector = selector.selector;
			this.context = selector.context;
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,

	// Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend( {
	has: function( target ) {
		var targets = jQuery( target, this ),
			l = targets.length;

		return this.filter( function() {
			var i = 0;
			for ( ; i < l; i++ ) {
				if ( jQuery.contains( this, targets[ i ] ) ) {
					return true;
				}
			}
		} );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			pos = rneedsContext.test( selectors ) || typeof selectors !== "string" ?
				jQuery( selectors, context || this.context ) :
				0;

		for ( ; i < l; i++ ) {
			for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

				// Always skip document fragments
				if ( cur.nodeType < 11 && ( pos ?
					pos.index( cur ) > -1 :

					// Don't pass non-elements to Sizzle
					cur.nodeType === 1 &&
						jQuery.find.matchesSelector( cur, selectors ) ) ) {

					matched.push( cur );
					break;
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
	},

	// Determine the position of an element within the set
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
		}

		// Index in selector
		if ( typeof elem === "string" ) {
			return indexOf.call( jQuery( elem ), this[ 0 ] );
		}

		// Locate the position of the desired element
		return indexOf.call( this,

			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[ 0 ] : elem
		);
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.uniqueSort(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	}
} );

function sibling( cur, dir ) {
	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
	return cur;
}

jQuery.each( {
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, i, until ) {
		return dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, i, until ) {
		return dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, i, until ) {
		return dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return siblings( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return siblings( elem.firstChild );
	},
	contents: function( elem ) {
		return elem.contentDocument || jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var matched = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			matched = jQuery.filter( selector, matched );
		}

		if ( this.length > 1 ) {

			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				jQuery.uniqueSort( matched );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				matched.reverse();
			}
		}

		return this.pushStack( matched );
	};
} );
var rnotwhite = ( /\S+/g );



// Convert String-formatted options into Object-formatted ones
function createOptions( options ) {
	var object = {};
	jQuery.each( options.match( rnotwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	} );
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		createOptions( options ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,

		// Last fire value for non-forgettable lists
		memory,

		// Flag to know if list was already fired
		fired,

		// Flag to prevent firing
		locked,

		// Actual callback list
		list = [],

		// Queue of execution data for repeatable lists
		queue = [],

		// Index of currently firing callback (modified by add/remove as needed)
		firingIndex = -1,

		// Fire callbacks
		fire = function() {

			// Enforce single-firing
			locked = options.once;

			// Execute callbacks for all pending executions,
			// respecting firingIndex overrides and runtime changes
			fired = firing = true;
			for ( ; queue.length; firingIndex = -1 ) {
				memory = queue.shift();
				while ( ++firingIndex < list.length ) {

					// Run callback and check for early termination
					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
						options.stopOnFalse ) {

						// Jump to end and forget the data so .add doesn't re-fire
						firingIndex = list.length;
						memory = false;
					}
				}
			}

			// Forget the data if we're done with it
			if ( !options.memory ) {
				memory = false;
			}

			firing = false;

			// Clean up if we're done firing for good
			if ( locked ) {

				// Keep an empty list if we have data for future add calls
				if ( memory ) {
					list = [];

				// Otherwise, this object is spent
				} else {
					list = "";
				}
			}
		},

		// Actual Callbacks object
		self = {

			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {

					// If we have memory from a past run, we should fire after adding
					if ( memory && !firing ) {
						firingIndex = list.length - 1;
						queue.push( memory );
					}

					( function add( args ) {
						jQuery.each( args, function( _, arg ) {
							if ( jQuery.isFunction( arg ) ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && jQuery.type( arg ) !== "string" ) {

								// Inspect recursively
								add( arg );
							}
						} );
					} )( arguments );

					if ( memory && !firing ) {
						fire();
					}
				}
				return this;
			},

			// Remove a callback from the list
			remove: function() {
				jQuery.each( arguments, function( _, arg ) {
					var index;
					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
						list.splice( index, 1 );

						// Handle firing indexes
						if ( index <= firingIndex ) {
							firingIndex--;
						}
					}
				} );
				return this;
			},

			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ?
					jQuery.inArray( fn, list ) > -1 :
					list.length > 0;
			},

			// Remove all callbacks from the list
			empty: function() {
				if ( list ) {
					list = [];
				}
				return this;
			},

			// Disable .fire and .add
			// Abort any current/pending executions
			// Clear all callbacks and values
			disable: function() {
				locked = queue = [];
				list = memory = "";
				return this;
			},
			disabled: function() {
				return !list;
			},

			// Disable .fire
			// Also disable .add unless we have memory (since it would have no effect)
			// Abort any pending executions
			lock: function() {
				locked = queue = [];
				if ( !memory ) {
					list = memory = "";
				}
				return this;
			},
			locked: function() {
				return !!locked;
			},

			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( !locked ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					queue.push( args );
					if ( !firing ) {
						fire();
					}
				}
				return this;
			},

			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},

			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


jQuery.extend( {

	Deferred: function( func ) {
		var tuples = [

				// action, add listener, listener list, final state
				[ "resolve", "done", jQuery.Callbacks( "once memory" ), "resolved" ],
				[ "reject", "fail", jQuery.Callbacks( "once memory" ), "rejected" ],
				[ "notify", "progress", jQuery.Callbacks( "memory" ) ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				then: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;
					return jQuery.Deferred( function( newDefer ) {
						jQuery.each( tuples, function( i, tuple ) {
							var fn = jQuery.isFunction( fns[ i ] ) && fns[ i ];

							// deferred[ done | fail | progress ] for forwarding actions to newDefer
							deferred[ tuple[ 1 ] ]( function() {
								var returned = fn && fn.apply( this, arguments );
								if ( returned && jQuery.isFunction( returned.promise ) ) {
									returned.promise()
										.progress( newDefer.notify )
										.done( newDefer.resolve )
										.fail( newDefer.reject );
								} else {
									newDefer[ tuple[ 0 ] + "With" ](
										this === promise ? newDefer.promise() : this,
										fn ? [ returned ] : arguments
									);
								}
							} );
						} );
						fns = null;
					} ).promise();
				},

				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Keep pipe for back-compat
		promise.pipe = promise.then;

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 3 ];

			// promise[ done | fail | progress ] = list.add
			promise[ tuple[ 1 ] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add( function() {

					// state = [ resolved | rejected ]
					state = stateString;

				// [ reject_list | resolve_list ].disable; progress_list.lock
				}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );
			}

			// deferred[ resolve | reject | notify ]
			deferred[ tuple[ 0 ] ] = function() {
				deferred[ tuple[ 0 ] + "With" ]( this === deferred ? promise : this, arguments );
				return this;
			};
			deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
		} );

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( subordinate /* , ..., subordinateN */ ) {
		var i = 0,
			resolveValues = slice.call( arguments ),
			length = resolveValues.length,

			// the count of uncompleted subordinates
			remaining = length !== 1 ||
				( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,

			// the master Deferred.
			// If resolveValues consist of only a single Deferred, just use that.
			deferred = remaining === 1 ? subordinate : jQuery.Deferred(),

			// Update function for both resolve and progress values
			updateFunc = function( i, contexts, values ) {
				return function( value ) {
					contexts[ i ] = this;
					values[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
					if ( values === progressValues ) {
						deferred.notifyWith( contexts, values );
					} else if ( !( --remaining ) ) {
						deferred.resolveWith( contexts, values );
					}
				};
			},

			progressValues, progressContexts, resolveContexts;

		// Add listeners to Deferred subordinates; treat others as resolved
		if ( length > 1 ) {
			progressValues = new Array( length );
			progressContexts = new Array( length );
			resolveContexts = new Array( length );
			for ( ; i < length; i++ ) {
				if ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {
					resolveValues[ i ].promise()
						.progress( updateFunc( i, progressContexts, progressValues ) )
						.done( updateFunc( i, resolveContexts, resolveValues ) )
						.fail( deferred.reject );
				} else {
					--remaining;
				}
			}
		}

		// If we're not waiting on anything, resolve the master
		if ( !remaining ) {
			deferred.resolveWith( resolveContexts, resolveValues );
		}

		return deferred.promise();
	}
} );


// The deferred used on DOM ready
var readyList;

jQuery.fn.ready = function( fn ) {

	// Add the callback
	jQuery.ready.promise().done( fn );

	return this;
};

jQuery.extend( {

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Hold (or release) the ready event
	holdReady: function( hold ) {
		if ( hold ) {
			jQuery.readyWait++;
		} else {
			jQuery.ready( true );
		}
	},

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );

		// Trigger any bound ready events
		if ( jQuery.fn.triggerHandler ) {
			jQuery( document ).triggerHandler( "ready" );
			jQuery( document ).off( "ready" );
		}
	}
} );

/**
 * The ready event handler and self cleanup method
 */
function completed() {
	document.removeEventListener( "DOMContentLoaded", completed );
	window.removeEventListener( "load", completed );
	jQuery.ready();
}

jQuery.ready.promise = function( obj ) {
	if ( !readyList ) {

		readyList = jQuery.Deferred();

		// Catch cases where $(document).ready() is called
		// after the browser event has already occurred.
		// Support: IE9-10 only
		// Older IE sometimes signals "interactive" too soon
		if ( document.readyState === "complete" ||
			( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

			// Handle it asynchronously to allow scripts the opportunity to delay ready
			window.setTimeout( jQuery.ready );

		} else {

			// Use the handy event callback
			document.addEventListener( "DOMContentLoaded", completed );

			// A fallback to window.onload, that will always work
			window.addEventListener( "load", completed );
		}
	}
	return readyList.promise( obj );
};

// Kick off the DOM ready check even if the user does not
jQuery.ready.promise();




// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
	var i = 0,
		len = elems.length,
		bulk = key == null;

	// Sets many values
	if ( jQuery.type( key ) === "object" ) {
		chainable = true;
		for ( i in key ) {
			access( elems, fn, i, key[ i ], true, emptyGet, raw );
		}

	// Sets one value
	} else if ( value !== undefined ) {
		chainable = true;

		if ( !jQuery.isFunction( value ) ) {
			raw = true;
		}

		if ( bulk ) {

			// Bulk operations run against the entire set
			if ( raw ) {
				fn.call( elems, value );
				fn = null;

			// ...except when executing function values
			} else {
				bulk = fn;
				fn = function( elem, key, value ) {
					return bulk.call( jQuery( elem ), value );
				};
			}
		}

		if ( fn ) {
			for ( ; i < len; i++ ) {
				fn(
					elems[ i ], key, raw ?
					value :
					value.call( elems[ i ], i, fn( elems[ i ], key ) )
				);
			}
		}
	}

	return chainable ?
		elems :

		// Gets
		bulk ?
			fn.call( elems ) :
			len ? fn( elems[ 0 ], key ) : emptyGet;
};
var acceptData = function( owner ) {

	// Accepts only:
	//  - Node
	//    - Node.ELEMENT_NODE
	//    - Node.DOCUMENT_NODE
	//  - Object
	//    - Any
	/* jshint -W018 */
	return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
};




function Data() {
	this.expando = jQuery.expando + Data.uid++;
}

Data.uid = 1;

Data.prototype = {

	register: function( owner, initial ) {
		var value = initial || {};

		// If it is a node unlikely to be stringify-ed or looped over
		// use plain assignment
		if ( owner.nodeType ) {
			owner[ this.expando ] = value;

		// Otherwise secure it in a non-enumerable, non-writable property
		// configurability must be true to allow the property to be
		// deleted with the delete operator
		} else {
			Object.defineProperty( owner, this.expando, {
				value: value,
				writable: true,
				configurable: true
			} );
		}
		return owner[ this.expando ];
	},
	cache: function( owner ) {

		// We can accept data for non-element nodes in modern browsers,
		// but we should not, see #8335.
		// Always return an empty object.
		if ( !acceptData( owner ) ) {
			return {};
		}

		// Check if the owner object already has a cache
		var value = owner[ this.expando ];

		// If not, create one
		if ( !value ) {
			value = {};

			// We can accept data for non-element nodes in modern browsers,
			// but we should not, see #8335.
			// Always return an empty object.
			if ( acceptData( owner ) ) {

				// If it is a node unlikely to be stringify-ed or looped over
				// use plain assignment
				if ( owner.nodeType ) {
					owner[ this.expando ] = value;

				// Otherwise secure it in a non-enumerable property
				// configurable must be true to allow the property to be
				// deleted when data is removed
				} else {
					Object.defineProperty( owner, this.expando, {
						value: value,
						configurable: true
					} );
				}
			}
		}

		return value;
	},
	set: function( owner, data, value ) {
		var prop,
			cache = this.cache( owner );

		// Handle: [ owner, key, value ] args
		if ( typeof data === "string" ) {
			cache[ data ] = value;

		// Handle: [ owner, { properties } ] args
		} else {

			// Copy the properties one-by-one to the cache object
			for ( prop in data ) {
				cache[ prop ] = data[ prop ];
			}
		}
		return cache;
	},
	get: function( owner, key ) {
		return key === undefined ?
			this.cache( owner ) :
			owner[ this.expando ] && owner[ this.expando ][ key ];
	},
	access: function( owner, key, value ) {
		var stored;

		// In cases where either:
		//
		//   1. No key was specified
		//   2. A string key was specified, but no value provided
		//
		// Take the "read" path and allow the get method to determine
		// which value to return, respectively either:
		//
		//   1. The entire cache object
		//   2. The data stored at the key
		//
		if ( key === undefined ||
				( ( key && typeof key === "string" ) && value === undefined ) ) {

			stored = this.get( owner, key );

			return stored !== undefined ?
				stored : this.get( owner, jQuery.camelCase( key ) );
		}

		// When the key is not a string, or both a key and value
		// are specified, set or extend (existing objects) with either:
		//
		//   1. An object of properties
		//   2. A key and value
		//
		this.set( owner, key, value );

		// Since the "set" path can have two possible entry points
		// return the expected data based on which path was taken[*]
		return value !== undefined ? value : key;
	},
	remove: function( owner, key ) {
		var i, name, camel,
			cache = owner[ this.expando ];

		if ( cache === undefined ) {
			return;
		}

		if ( key === undefined ) {
			this.register( owner );

		} else {

			// Support array or space separated string of keys
			if ( jQuery.isArray( key ) ) {

				// If "name" is an array of keys...
				// When data is initially created, via ("key", "val") signature,
				// keys will be converted to camelCase.
				// Since there is no way to tell _how_ a key was added, remove
				// both plain key and camelCase key. #12786
				// This will only penalize the array argument path.
				name = key.concat( key.map( jQuery.camelCase ) );
			} else {
				camel = jQuery.camelCase( key );

				// Try the string as a key before any manipulation
				if ( key in cache ) {
					name = [ key, camel ];
				} else {

					// If a key with the spaces exists, use it.
					// Otherwise, create an array by matching non-whitespace
					name = camel;
					name = name in cache ?
						[ name ] : ( name.match( rnotwhite ) || [] );
				}
			}

			i = name.length;

			while ( i-- ) {
				delete cache[ name[ i ] ];
			}
		}

		// Remove the expando if there's no more data
		if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

			// Support: Chrome <= 35-45+
			// Webkit & Blink performance suffers when deleting properties
			// from DOM nodes, so set to undefined instead
			// https://code.google.com/p/chromium/issues/detail?id=378607
			if ( owner.nodeType ) {
				owner[ this.expando ] = undefined;
			} else {
				delete owner[ this.expando ];
			}
		}
	},
	hasData: function( owner ) {
		var cache = owner[ this.expando ];
		return cache !== undefined && !jQuery.isEmptyObject( cache );
	}
};
var dataPriv = new Data();

var dataUser = new Data();



//	Implementation Summary
//
//	1. Enforce API surface and semantic compatibility with 1.9.x branch
//	2. Improve the module's maintainability by reducing the storage
//		paths to a single mechanism.
//	3. Use the same single mechanism to support "private" and "user" data.
//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
//	5. Avoid exposing implementation details on user objects (eg. expando properties)
//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	rmultiDash = /[A-Z]/g;

function dataAttr( elem, key, data ) {
	var name;

	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {
		name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = data === "true" ? true :
					data === "false" ? false :
					data === "null" ? null :

					// Only convert to a number if it doesn't change the string
					+data + "" === data ? +data :
					rbrace.test( data ) ? jQuery.parseJSON( data ) :
					data;
			} catch ( e ) {}

			// Make sure we set the data so it isn't changed later
			dataUser.set( elem, key, data );
		} else {
			data = undefined;
		}
	}
	return data;
}

jQuery.extend( {
	hasData: function( elem ) {
		return dataUser.hasData( elem ) || dataPriv.hasData( elem );
	},

	data: function( elem, name, data ) {
		return dataUser.access( elem, name, data );
	},

	removeData: function( elem, name ) {
		dataUser.remove( elem, name );
	},

	// TODO: Now that all calls to _data and _removeData have been replaced
	// with direct calls to dataPriv methods, these can be deprecated.
	_data: function( elem, name, data ) {
		return dataPriv.access( elem, name, data );
	},

	_removeData: function( elem, name ) {
		dataPriv.remove( elem, name );
	}
} );

jQuery.fn.extend( {
	data: function( key, value ) {
		var i, name, data,
			elem = this[ 0 ],
			attrs = elem && elem.attributes;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = dataUser.get( elem );

				if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
					i = attrs.length;
					while ( i-- ) {

						// Support: IE11+
						// The attrs elements can be null (#14894)
						if ( attrs[ i ] ) {
							name = attrs[ i ].name;
							if ( name.indexOf( "data-" ) === 0 ) {
								name = jQuery.camelCase( name.slice( 5 ) );
								dataAttr( elem, name, data[ name ] );
							}
						}
					}
					dataPriv.set( elem, "hasDataAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each( function() {
				dataUser.set( this, key );
			} );
		}

		return access( this, function( value ) {
			var data, camelKey;

			// The calling jQuery object (element matches) is not empty
			// (and therefore has an element appears at this[ 0 ]) and the
			// `value` parameter was not undefined. An empty jQuery object
			// will result in `undefined` for elem = this[ 0 ] which will
			// throw an exception if an attempt to read a data cache is made.
			if ( elem && value === undefined ) {

				// Attempt to get data from the cache
				// with the key as-is
				data = dataUser.get( elem, key ) ||

					// Try to find dashed key if it exists (gh-2779)
					// This is for 2.2.x only
					dataUser.get( elem, key.replace( rmultiDash, "-$&" ).toLowerCase() );

				if ( data !== undefined ) {
					return data;
				}

				camelKey = jQuery.camelCase( key );

				// Attempt to get data from the cache
				// with the key camelized
				data = dataUser.get( elem, camelKey );
				if ( data !== undefined ) {
					return data;
				}

				// Attempt to "discover" the data in
				// HTML5 custom data-* attrs
				data = dataAttr( elem, camelKey, undefined );
				if ( data !== undefined ) {
					return data;
				}

				// We tried really hard, but the data doesn't exist.
				return;
			}

			// Set the data...
			camelKey = jQuery.camelCase( key );
			this.each( function() {

				// First, attempt to store a copy or reference of any
				// data that might've been store with a camelCased key.
				var data = dataUser.get( this, camelKey );

				// For HTML5 data-* attribute interop, we have to
				// store property names with dashes in a camelCase form.
				// This might not apply to all properties...*
				dataUser.set( this, camelKey, value );

				// *... In the case of properties that might _actually_
				// have dashes, we need to also store a copy of that
				// unchanged property.
				if ( key.indexOf( "-" ) > -1 && data !== undefined ) {
					dataUser.set( this, key, value );
				}
			} );
		}, null, value, arguments.length > 1, null, true );
	},

	removeData: function( key ) {
		return this.each( function() {
			dataUser.remove( this, key );
		} );
	}
} );


jQuery.extend( {
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = dataPriv.get( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || jQuery.isArray( data ) ) {
					queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// Clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// Not public - generate a queueHooks object, or return the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
			empty: jQuery.Callbacks( "once memory" ).add( function() {
				dataPriv.remove( elem, [ type + "queue", key ] );
			} )
		} );
	}
} );

jQuery.fn.extend( {
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[ 0 ], type );
		}

		return data === undefined ?
			this :
			this.each( function() {
				var queue = jQuery.queue( this, type, data );

				// Ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			} );
	},
	dequeue: function( type ) {
		return this.each( function() {
			jQuery.dequeue( this, type );
		} );
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},

	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while ( i-- ) {
			tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
} );
var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

var isHidden = function( elem, el ) {

		// isHidden might be called from jQuery#filter function;
		// in that case, element will be second argument
		elem = el || elem;
		return jQuery.css( elem, "display" ) === "none" ||
			!jQuery.contains( elem.ownerDocument, elem );
	};



function adjustCSS( elem, prop, valueParts, tween ) {
	var adjusted,
		scale = 1,
		maxIterations = 20,
		currentValue = tween ?
			function() { return tween.cur(); } :
			function() { return jQuery.css( elem, prop, "" ); },
		initial = currentValue(),
		unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

		// Starting value computation is required for potential unit mismatches
		initialInUnit = ( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
			rcssNum.exec( jQuery.css( elem, prop ) );

	if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

		// Trust units reported by jQuery.css
		unit = unit || initialInUnit[ 3 ];

		// Make sure we update the tween properties later on
		valueParts = valueParts || [];

		// Iteratively approximate from a nonzero starting point
		initialInUnit = +initial || 1;

		do {

			// If previous iteration zeroed out, double until we get *something*.
			// Use string for doubling so we don't accidentally see scale as unchanged below
			scale = scale || ".5";

			// Adjust and apply
			initialInUnit = initialInUnit / scale;
			jQuery.style( elem, prop, initialInUnit + unit );

		// Update scale, tolerating zero or NaN from tween.cur()
		// Break the loop if scale is unchanged or perfect, or if we've just had enough.
		} while (
			scale !== ( scale = currentValue() / initial ) && scale !== 1 && --maxIterations
		);
	}

	if ( valueParts ) {
		initialInUnit = +initialInUnit || +initial || 0;

		// Apply relative offset (+=/-=) if specified
		adjusted = valueParts[ 1 ] ?
			initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
			+valueParts[ 2 ];
		if ( tween ) {
			tween.unit = unit;
			tween.start = initialInUnit;
			tween.end = adjusted;
		}
	}
	return adjusted;
}
var rcheckableType = ( /^(?:checkbox|radio)$/i );

var rtagName = ( /<([\w:-]+)/ );

var rscriptType = ( /^$|\/(?:java|ecma)script/i );



// We have to close these tags to support XHTML (#13200)
var wrapMap = {

	// Support: IE9
	option: [ 1, "<select multiple='multiple'>", "</select>" ],

	// XHTML parsers do not magically insert elements in the
	// same way that tag soup parsers do. So we cannot shorten
	// this by omitting <tbody> or other required elements.
	thead: [ 1, "<table>", "</table>" ],
	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
	tr: [ 2, "<table><tbody>", "</tbody></table>" ],
	td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

	_default: [ 0, "", "" ]
};

// Support: IE9
wrapMap.optgroup = wrapMap.option;

wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;


function getAll( context, tag ) {

	// Support: IE9-11+
	// Use typeof to avoid zero-argument method invocation on host objects (#15151)
	var ret = typeof context.getElementsByTagName !== "undefined" ?
			context.getElementsByTagName( tag || "*" ) :
			typeof context.querySelectorAll !== "undefined" ?
				context.querySelectorAll( tag || "*" ) :
			[];

	return tag === undefined || tag && jQuery.nodeName( context, tag ) ?
		jQuery.merge( [ context ], ret ) :
		ret;
}


// Mark scripts as having already been evaluated
function setGlobalEval( elems, refElements ) {
	var i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		dataPriv.set(
			elems[ i ],
			"globalEval",
			!refElements || dataPriv.get( refElements[ i ], "globalEval" )
		);
	}
}


var rhtml = /<|&#?\w+;/;

function buildFragment( elems, context, scripts, selection, ignored ) {
	var elem, tmp, tag, wrap, contains, j,
		fragment = context.createDocumentFragment(),
		nodes = [],
		i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		elem = elems[ i ];

		if ( elem || elem === 0 ) {

			// Add nodes directly
			if ( jQuery.type( elem ) === "object" ) {

				// Support: Android<4.1, PhantomJS<2
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

			// Convert non-html into a text node
			} else if ( !rhtml.test( elem ) ) {
				nodes.push( context.createTextNode( elem ) );

			// Convert html into DOM nodes
			} else {
				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

				// Deserialize a standard representation
				tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
				wrap = wrapMap[ tag ] || wrapMap._default;
				tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

				// Descend through wrappers to the right content
				j = wrap[ 0 ];
				while ( j-- ) {
					tmp = tmp.lastChild;
				}

				// Support: Android<4.1, PhantomJS<2
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, tmp.childNodes );

				// Remember the top-level container
				tmp = fragment.firstChild;

				// Ensure the created nodes are orphaned (#12392)
				tmp.textContent = "";
			}
		}
	}

	// Remove wrapper from fragment
	fragment.textContent = "";

	i = 0;
	while ( ( elem = nodes[ i++ ] ) ) {

		// Skip elements already in the context collection (trac-4087)
		if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
			if ( ignored ) {
				ignored.push( elem );
			}
			continue;
		}

		contains = jQuery.contains( elem.ownerDocument, elem );

		// Append to fragment
		tmp = getAll( fragment.appendChild( elem ), "script" );

		// Preserve script evaluation history
		if ( contains ) {
			setGlobalEval( tmp );
		}

		// Capture executables
		if ( scripts ) {
			j = 0;
			while ( ( elem = tmp[ j++ ] ) ) {
				if ( rscriptType.test( elem.type || "" ) ) {
					scripts.push( elem );
				}
			}
		}
	}

	return fragment;
}


( function() {
	var fragment = document.createDocumentFragment(),
		div = fragment.appendChild( document.createElement( "div" ) ),
		input = document.createElement( "input" );

	// Support: Android 4.0-4.3, Safari<=5.1
	// Check state lost if the name is set (#11217)
	// Support: Windows Web Apps (WWA)
	// `name` and `type` must use .setAttribute for WWA (#14901)
	input.setAttribute( "type", "radio" );
	input.setAttribute( "checked", "checked" );
	input.setAttribute( "name", "t" );

	div.appendChild( input );

	// Support: Safari<=5.1, Android<4.2
	// Older WebKit doesn't clone checked state correctly in fragments
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Support: IE<=11+
	// Make sure textarea (and checkbox) defaultValue is properly cloned
	div.innerHTML = "<textarea>x</textarea>";
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;
} )();


var
	rkeyEvent = /^key/,
	rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
	rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

function returnTrue() {
	return true;
}

function returnFalse() {
	return false;
}

// Support: IE9
// See #13393 for more info
function safeActiveElement() {
	try {
		return document.activeElement;
	} catch ( err ) { }
}

function on( elem, types, selector, data, fn, one ) {
	var origFn, type;

	// Types can be a map of types/handlers
	if ( typeof types === "object" ) {

		// ( types-Object, selector, data )
		if ( typeof selector !== "string" ) {

			// ( types-Object, data )
			data = data || selector;
			selector = undefined;
		}
		for ( type in types ) {
			on( elem, type, selector, data, types[ type ], one );
		}
		return elem;
	}

	if ( data == null && fn == null ) {

		// ( types, fn )
		fn = selector;
		data = selector = undefined;
	} else if ( fn == null ) {
		if ( typeof selector === "string" ) {

			// ( types, selector, fn )
			fn = data;
			data = undefined;
		} else {

			// ( types, data, fn )
			fn = data;
			data = selector;
			selector = undefined;
		}
	}
	if ( fn === false ) {
		fn = returnFalse;
	} else if ( !fn ) {
		return elem;
	}

	if ( one === 1 ) {
		origFn = fn;
		fn = function( event ) {

			// Can use an empty set, since event contains the info
			jQuery().off( event );
			return origFn.apply( this, arguments );
		};

		// Use same guid so caller can remove using origFn
		fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
	}
	return elem.each( function() {
		jQuery.event.add( this, types, fn, data, selector );
	} );
}

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	global: {},

	add: function( elem, types, handler, data, selector ) {

		var handleObjIn, eventHandle, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.get( elem );

		// Don't attach events to noData or text/comment nodes (but allow plain objects)
		if ( !elemData ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		if ( !( events = elemData.events ) ) {
			events = elemData.events = {};
		}
		if ( !( eventHandle = elemData.handle ) ) {
			eventHandle = elemData.handle = function( e ) {

				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
					jQuery.event.dispatch.apply( elem, arguments ) : undefined;
			};
		}

		// Handle multiple events separated by a space
		types = ( types || "" ).match( rnotwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// There *must* be a type, no attaching namespace-only handlers
			if ( !type ) {
				continue;
			}

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend( {
				type: type,
				origType: origType,
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join( "." )
			}, handleObjIn );

			// Init the event handler queue if we're the first
			if ( !( handlers = events[ type ] ) ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener if the special events handler returns false
				if ( !special.setup ||
					special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

	},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var j, origCount, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

		if ( !elemData || !( events = elemData.events ) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = ( types || "" ).match( rnotwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector ? special.delegateType : special.bindType ) || type;
			handlers = events[ type ] || [];
			tmp = tmp[ 2 ] &&
				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

			// Remove matching events
			origCount = j = handlers.length;
			while ( j-- ) {
				handleObj = handlers[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					( !handler || handler.guid === handleObj.guid ) &&
					( !tmp || tmp.test( handleObj.namespace ) ) &&
					( !selector || selector === handleObj.selector ||
						selector === "**" && handleObj.selector ) ) {
					handlers.splice( j, 1 );

					if ( handleObj.selector ) {
						handlers.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( origCount && !handlers.length ) {
				if ( !special.teardown ||
					special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove data and the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			dataPriv.remove( elem, "handle events" );
		}
	},

	dispatch: function( event ) {

		// Make a writable jQuery.Event from the native event object
		event = jQuery.event.fix( event );

		var i, j, ret, matched, handleObj,
			handlerQueue = [],
			args = slice.call( arguments ),
			handlers = ( dataPriv.get( this, "events" ) || {} )[ event.type ] || [],
			special = jQuery.event.special[ event.type ] || {};

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[ 0 ] = event;
		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );

		// Run delegates first; they may want to stop propagation beneath us
		i = 0;
		while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
			event.currentTarget = matched.elem;

			j = 0;
			while ( ( handleObj = matched.handlers[ j++ ] ) &&
				!event.isImmediatePropagationStopped() ) {

				// Triggered event must either 1) have no namespace, or 2) have namespace(s)
				// a subset or equal to those in the bound event (both can have no namespace).
				if ( !event.rnamespace || event.rnamespace.test( handleObj.namespace ) ) {

					event.handleObj = handleObj;
					event.data = handleObj.data;

					ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
						handleObj.handler ).apply( matched.elem, args );

					if ( ret !== undefined ) {
						if ( ( event.result = ret ) === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	handlers: function( event, handlers ) {
		var i, matches, sel, handleObj,
			handlerQueue = [],
			delegateCount = handlers.delegateCount,
			cur = event.target;

		// Support (at least): Chrome, IE9
		// Find delegate handlers
		// Black-hole SVG <use> instance trees (#13180)
		//
		// Support: Firefox<=42+
		// Avoid non-left-click in FF but don't block IE radio events (#3861, gh-2343)
		if ( delegateCount && cur.nodeType &&
			( event.type !== "click" || isNaN( event.button ) || event.button < 1 ) ) {

			for ( ; cur !== this; cur = cur.parentNode || this ) {

				// Don't check non-elements (#13208)
				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.nodeType === 1 && ( cur.disabled !== true || event.type !== "click" ) ) {
					matches = [];
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];

						// Don't conflict with Object.prototype properties (#13203)
						sel = handleObj.selector + " ";

						if ( matches[ sel ] === undefined ) {
							matches[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) > -1 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( matches[ sel ] ) {
							matches.push( handleObj );
						}
					}
					if ( matches.length ) {
						handlerQueue.push( { elem: cur, handlers: matches } );
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		if ( delegateCount < handlers.length ) {
			handlerQueue.push( { elem: this, handlers: handlers.slice( delegateCount ) } );
		}

		return handlerQueue;
	},

	// Includes some event props shared by KeyEvent and MouseEvent
	props: ( "altKey bubbles cancelable ctrlKey currentTarget detail eventPhase " +
		"metaKey relatedTarget shiftKey target timeStamp view which" ).split( " " ),

	fixHooks: {},

	keyHooks: {
		props: "char charCode key keyCode".split( " " ),
		filter: function( event, original ) {

			// Add which for key events
			if ( event.which == null ) {
				event.which = original.charCode != null ? original.charCode : original.keyCode;
			}

			return event;
		}
	},

	mouseHooks: {
		props: ( "button buttons clientX clientY offsetX offsetY pageX pageY " +
			"screenX screenY toElement" ).split( " " ),
		filter: function( event, original ) {
			var eventDoc, doc, body,
				button = original.button;

			// Calculate pageX/Y if missing and clientX/Y available
			if ( event.pageX == null && original.clientX != null ) {
				eventDoc = event.target.ownerDocument || document;
				doc = eventDoc.documentElement;
				body = eventDoc.body;

				event.pageX = original.clientX +
					( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) -
					( doc && doc.clientLeft || body && body.clientLeft || 0 );
				event.pageY = original.clientY +
					( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) -
					( doc && doc.clientTop  || body && body.clientTop  || 0 );
			}

			// Add which for click: 1 === left; 2 === middle; 3 === right
			// Note: button is not normalized, so don't use it
			if ( !event.which && button !== undefined ) {
				event.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );
			}

			return event;
		}
	},

	fix: function( event ) {
		if ( event[ jQuery.expando ] ) {
			return event;
		}

		// Create a writable copy of the event object and normalize some properties
		var i, prop, copy,
			type = event.type,
			originalEvent = event,
			fixHook = this.fixHooks[ type ];

		if ( !fixHook ) {
			this.fixHooks[ type ] = fixHook =
				rmouseEvent.test( type ) ? this.mouseHooks :
				rkeyEvent.test( type ) ? this.keyHooks :
				{};
		}
		copy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;

		event = new jQuery.Event( originalEvent );

		i = copy.length;
		while ( i-- ) {
			prop = copy[ i ];
			event[ prop ] = originalEvent[ prop ];
		}

		// Support: Cordova 2.5 (WebKit) (#13255)
		// All events should have a target; Cordova deviceready doesn't
		if ( !event.target ) {
			event.target = document;
		}

		// Support: Safari 6.0+, Chrome<28
		// Target should not be a text node (#504, #13143)
		if ( event.target.nodeType === 3 ) {
			event.target = event.target.parentNode;
		}

		return fixHook.filter ? fixHook.filter( event, originalEvent ) : event;
	},

	special: {
		load: {

			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},
		focus: {

			// Fire native event if possible so blur/focus sequence is correct
			trigger: function() {
				if ( this !== safeActiveElement() && this.focus ) {
					this.focus();
					return false;
				}
			},
			delegateType: "focusin"
		},
		blur: {
			trigger: function() {
				if ( this === safeActiveElement() && this.blur ) {
					this.blur();
					return false;
				}
			},
			delegateType: "focusout"
		},
		click: {

			// For checkbox, fire native event so checked state will be right
			trigger: function() {
				if ( this.type === "checkbox" && this.click && jQuery.nodeName( this, "input" ) ) {
					this.click();
					return false;
				}
			},

			// For cross-browser consistency, don't fire native .click() on links
			_default: function( event ) {
				return jQuery.nodeName( event.target, "a" );
			}
		},

		beforeunload: {
			postDispatch: function( event ) {

				// Support: Firefox 20+
				// Firefox doesn't alert if the returnValue field is not set.
				if ( event.result !== undefined && event.originalEvent ) {
					event.originalEvent.returnValue = event.result;
				}
			}
		}
	}
};

jQuery.removeEvent = function( elem, type, handle ) {

	// This "if" is needed for plain objects
	if ( elem.removeEventListener ) {
		elem.removeEventListener( type, handle );
	}
};

jQuery.Event = function( src, props ) {

	// Allow instantiation without the 'new' keyword
	if ( !( this instanceof jQuery.Event ) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined &&

				// Support: Android<4.0
				src.returnValue === false ?
			returnTrue :
			returnFalse;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || jQuery.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	constructor: jQuery.Event,
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse,

	preventDefault: function() {
		var e = this.originalEvent;

		this.isDefaultPrevented = returnTrue;

		if ( e ) {
			e.preventDefault();
		}
	},
	stopPropagation: function() {
		var e = this.originalEvent;

		this.isPropagationStopped = returnTrue;

		if ( e ) {
			e.stopPropagation();
		}
	},
	stopImmediatePropagation: function() {
		var e = this.originalEvent;

		this.isImmediatePropagationStopped = returnTrue;

		if ( e ) {
			e.stopImmediatePropagation();
		}

		this.stopPropagation();
	}
};

// Create mouseenter/leave events using mouseover/out and event-time checks
// so that event delegation works in jQuery.
// Do the same for pointerenter/pointerleave and pointerover/pointerout
//
// Support: Safari 7 only
// Safari sends mouseenter too often; see:
// https://code.google.com/p/chromium/issues/detail?id=470258
// for the description of the bug (it existed in older Chrome versions as well).
jQuery.each( {
	mouseenter: "mouseover",
	mouseleave: "mouseout",
	pointerenter: "pointerover",
	pointerleave: "pointerout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj;

			// For mouseenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
} );

jQuery.fn.extend( {
	on: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn );
	},
	one: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {

			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ?
					handleObj.origType + "." + handleObj.namespace :
					handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {

			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {

			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each( function() {
			jQuery.event.remove( this, types, fn, selector );
		} );
	}
} );


var
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:-]+)[^>]*)\/>/gi,

	// Support: IE 10-11, Edge 10240+
	// In IE/Edge using regex groups here causes severe slowdowns.
	// See https://connect.microsoft.com/IE/feedback/details/1736512/
	rnoInnerhtml = /<script|<style|<link/i,

	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rscriptTypeMasked = /^true\/(.*)/,
	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

// Manipulating tables requires a tbody
function manipulationTarget( elem, content ) {
	return jQuery.nodeName( elem, "table" ) &&
		jQuery.nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ?

		elem.getElementsByTagName( "tbody" )[ 0 ] ||
			elem.appendChild( elem.ownerDocument.createElement( "tbody" ) ) :
		elem;
}

// Replace/restore the type attribute of script elements for safe DOM manipulation
function disableScript( elem ) {
	elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
	return elem;
}
function restoreScript( elem ) {
	var match = rscriptTypeMasked.exec( elem.type );

	if ( match ) {
		elem.type = match[ 1 ];
	} else {
		elem.removeAttribute( "type" );
	}

	return elem;
}

function cloneCopyEvent( src, dest ) {
	var i, l, type, pdataOld, pdataCur, udataOld, udataCur, events;

	if ( dest.nodeType !== 1 ) {
		return;
	}

	// 1. Copy private data: events, handlers, etc.
	if ( dataPriv.hasData( src ) ) {
		pdataOld = dataPriv.access( src );
		pdataCur = dataPriv.set( dest, pdataOld );
		events = pdataOld.events;

		if ( events ) {
			delete pdataCur.handle;
			pdataCur.events = {};

			for ( type in events ) {
				for ( i = 0, l = events[ type ].length; i < l; i++ ) {
					jQuery.event.add( dest, type, events[ type ][ i ] );
				}
			}
		}
	}

	// 2. Copy user data
	if ( dataUser.hasData( src ) ) {
		udataOld = dataUser.access( src );
		udataCur = jQuery.extend( {}, udataOld );

		dataUser.set( dest, udataCur );
	}
}

// Fix IE bugs, see support tests
function fixInput( src, dest ) {
	var nodeName = dest.nodeName.toLowerCase();

	// Fails to persist the checked state of a cloned checkbox or radio button.
	if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		dest.checked = src.checked;

	// Fails to return the selected option to the default selected state when cloning options
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}
}

function domManip( collection, args, callback, ignored ) {

	// Flatten any nested arrays
	args = concat.apply( [], args );

	var fragment, first, scripts, hasScripts, node, doc,
		i = 0,
		l = collection.length,
		iNoClone = l - 1,
		value = args[ 0 ],
		isFunction = jQuery.isFunction( value );

	// We can't cloneNode fragments that contain checked, in WebKit
	if ( isFunction ||
			( l > 1 && typeof value === "string" &&
				!support.checkClone && rchecked.test( value ) ) ) {
		return collection.each( function( index ) {
			var self = collection.eq( index );
			if ( isFunction ) {
				args[ 0 ] = value.call( this, index, self.html() );
			}
			domManip( self, args, callback, ignored );
		} );
	}

	if ( l ) {
		fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
		first = fragment.firstChild;

		if ( fragment.childNodes.length === 1 ) {
			fragment = first;
		}

		// Require either new content or an interest in ignored elements to invoke the callback
		if ( first || ignored ) {
			scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
			hasScripts = scripts.length;

			// Use the original fragment for the last item
			// instead of the first because it can end up
			// being emptied incorrectly in certain situations (#8070).
			for ( ; i < l; i++ ) {
				node = fragment;

				if ( i !== iNoClone ) {
					node = jQuery.clone( node, true, true );

					// Keep references to cloned scripts for later restoration
					if ( hasScripts ) {

						// Support: Android<4.1, PhantomJS<2
						// push.apply(_, arraylike) throws on ancient WebKit
						jQuery.merge( scripts, getAll( node, "script" ) );
					}
				}

				callback.call( collection[ i ], node, i );
			}

			if ( hasScripts ) {
				doc = scripts[ scripts.length - 1 ].ownerDocument;

				// Reenable scripts
				jQuery.map( scripts, restoreScript );

				// Evaluate executable scripts on first document insertion
				for ( i = 0; i < hasScripts; i++ ) {
					node = scripts[ i ];
					if ( rscriptType.test( node.type || "" ) &&
						!dataPriv.access( node, "globalEval" ) &&
						jQuery.contains( doc, node ) ) {

						if ( node.src ) {

							// Optional AJAX dependency, but won't run scripts if not present
							if ( jQuery._evalUrl ) {
								jQuery._evalUrl( node.src );
							}
						} else {
							jQuery.globalEval( node.textContent.replace( rcleanScript, "" ) );
						}
					}
				}
			}
		}
	}

	return collection;
}

function remove( elem, selector, keepData ) {
	var node,
		nodes = selector ? jQuery.filter( selector, elem ) : elem,
		i = 0;

	for ( ; ( node = nodes[ i ] ) != null; i++ ) {
		if ( !keepData && node.nodeType === 1 ) {
			jQuery.cleanData( getAll( node ) );
		}

		if ( node.parentNode ) {
			if ( keepData && jQuery.contains( node.ownerDocument, node ) ) {
				setGlobalEval( getAll( node, "script" ) );
			}
			node.parentNode.removeChild( node );
		}
	}

	return elem;
}

jQuery.extend( {
	htmlPrefilter: function( html ) {
		return html.replace( rxhtmlTag, "<$1></$2>" );
	},

	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var i, l, srcElements, destElements,
			clone = elem.cloneNode( true ),
			inPage = jQuery.contains( elem.ownerDocument, elem );

		// Fix IE cloning issues
		if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
				!jQuery.isXMLDoc( elem ) ) {

			// We eschew Sizzle here for performance reasons: http://jsperf.com/getall-vs-sizzle/2
			destElements = getAll( clone );
			srcElements = getAll( elem );

			for ( i = 0, l = srcElements.length; i < l; i++ ) {
				fixInput( srcElements[ i ], destElements[ i ] );
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			if ( deepDataAndEvents ) {
				srcElements = srcElements || getAll( elem );
				destElements = destElements || getAll( clone );

				for ( i = 0, l = srcElements.length; i < l; i++ ) {
					cloneCopyEvent( srcElements[ i ], destElements[ i ] );
				}
			} else {
				cloneCopyEvent( elem, clone );
			}
		}

		// Preserve script evaluation history
		destElements = getAll( clone, "script" );
		if ( destElements.length > 0 ) {
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
		}

		// Return the cloned set
		return clone;
	},

	cleanData: function( elems ) {
		var data, elem, type,
			special = jQuery.event.special,
			i = 0;

		for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
			if ( acceptData( elem ) ) {
				if ( ( data = elem[ dataPriv.expando ] ) ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Support: Chrome <= 35-45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataPriv.expando ] = undefined;
				}
				if ( elem[ dataUser.expando ] ) {

					// Support: Chrome <= 35-45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataUser.expando ] = undefined;
				}
			}
		}
	}
} );

jQuery.fn.extend( {

	// Keep domManip exposed until 3.0 (gh-2225)
	domManip: domManip,

	detach: function( selector ) {
		return remove( this, selector, true );
	},

	remove: function( selector ) {
		return remove( this, selector );
	},

	text: function( value ) {
		return access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().each( function() {
					if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
						this.textContent = value;
					}
				} );
		}, null, value, arguments.length );
	},

	append: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.appendChild( elem );
			}
		} );
	},

	prepend: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.insertBefore( elem, target.firstChild );
			}
		} );
	},

	before: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this );
			}
		} );
	},

	after: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			}
		} );
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; ( elem = this[ i ] ) != null; i++ ) {
			if ( elem.nodeType === 1 ) {

				// Prevent memory leaks
				jQuery.cleanData( getAll( elem, false ) );

				// Remove any remaining nodes
				elem.textContent = "";
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function() {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		} );
	},

	html: function( value ) {
		return access( this, function( value ) {
			var elem = this[ 0 ] || {},
				i = 0,
				l = this.length;

			if ( value === undefined && elem.nodeType === 1 ) {
				return elem.innerHTML;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

				value = jQuery.htmlPrefilter( value );

				try {
					for ( ; i < l; i++ ) {
						elem = this[ i ] || {};

						// Remove element nodes and prevent memory leaks
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( getAll( elem, false ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch ( e ) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function() {
		var ignored = [];

		// Make the changes, replacing each non-ignored context element with the new content
		return domManip( this, arguments, function( elem ) {
			var parent = this.parentNode;

			if ( jQuery.inArray( this, ignored ) < 0 ) {
				jQuery.cleanData( getAll( this ) );
				if ( parent ) {
					parent.replaceChild( elem, this );
				}
			}

		// Force callback invocation
		}, ignored );
	}
} );

jQuery.each( {
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			ret = [],
			insert = jQuery( selector ),
			last = insert.length - 1,
			i = 0;

		for ( ; i <= last; i++ ) {
			elems = i === last ? this : this.clone( true );
			jQuery( insert[ i ] )[ original ]( elems );

			// Support: QtWebKit
			// .get() because push.apply(_, arraylike) throws
			push.apply( ret, elems.get() );
		}

		return this.pushStack( ret );
	};
} );


var iframe,
	elemdisplay = {

		// Support: Firefox
		// We have to pre-define these values for FF (#10227)
		HTML: "block",
		BODY: "block"
	};

/**
 * Retrieve the actual display of a element
 * @param {String} name nodeName of the element
 * @param {Object} doc Document object
 */

// Called only from within defaultDisplay
function actualDisplay( name, doc ) {
	var elem = jQuery( doc.createElement( name ) ).appendTo( doc.body ),

		display = jQuery.css( elem[ 0 ], "display" );

	// We don't have any data stored on the element,
	// so use "detach" method as fast way to get rid of the element
	elem.detach();

	return display;
}

/**
 * Try to determine the default display value of an element
 * @param {String} nodeName
 */
function defaultDisplay( nodeName ) {
	var doc = document,
		display = elemdisplay[ nodeName ];

	if ( !display ) {
		display = actualDisplay( nodeName, doc );

		// If the simple way fails, read from inside an iframe
		if ( display === "none" || !display ) {

			// Use the already-created iframe if possible
			iframe = ( iframe || jQuery( "<iframe frameborder='0' width='0' height='0'/>" ) )
				.appendTo( doc.documentElement );

			// Always write a new HTML skeleton so Webkit and Firefox don't choke on reuse
			doc = iframe[ 0 ].contentDocument;

			// Support: IE
			doc.write();
			doc.close();

			display = actualDisplay( nodeName, doc );
			iframe.detach();
		}

		// Store the correct default display
		elemdisplay[ nodeName ] = display;
	}

	return display;
}
var rmargin = ( /^margin/ );

var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

var getStyles = function( elem ) {

		// Support: IE<=11+, Firefox<=30+ (#15098, #14150)
		// IE throws on elements created in popups
		// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
		var view = elem.ownerDocument.defaultView;

		if ( !view || !view.opener ) {
			view = window;
		}

		return view.getComputedStyle( elem );
	};

var swap = function( elem, options, callback, args ) {
	var ret, name,
		old = {};

	// Remember the old values, and insert the new ones
	for ( name in options ) {
		old[ name ] = elem.style[ name ];
		elem.style[ name ] = options[ name ];
	}

	ret = callback.apply( elem, args || [] );

	// Revert the old values
	for ( name in options ) {
		elem.style[ name ] = old[ name ];
	}

	return ret;
};


var documentElement = document.documentElement;



( function() {
	var pixelPositionVal, boxSizingReliableVal, pixelMarginRightVal, reliableMarginLeftVal,
		container = document.createElement( "div" ),
		div = document.createElement( "div" );

	// Finish early in limited (non-browser) environments
	if ( !div.style ) {
		return;
	}

	// Support: IE9-11+
	// Style of cloned element affects source element cloned (#8908)
	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	container.style.cssText = "border:0;width:8px;height:0;top:0;left:-9999px;" +
		"padding:0;margin-top:1px;position:absolute";
	container.appendChild( div );

	// Executing both pixelPosition & boxSizingReliable tests require only one layout
	// so they're executed at the same time to save the second computation.
	function computeStyleTests() {
		div.style.cssText =

			// Support: Firefox<29, Android 2.3
			// Vendor-prefix box-sizing
			"-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;" +
			"position:relative;display:block;" +
			"margin:auto;border:1px;padding:1px;" +
			"top:1%;width:50%";
		div.innerHTML = "";
		documentElement.appendChild( container );

		var divStyle = window.getComputedStyle( div );
		pixelPositionVal = divStyle.top !== "1%";
		reliableMarginLeftVal = divStyle.marginLeft === "2px";
		boxSizingReliableVal = divStyle.width === "4px";

		// Support: Android 4.0 - 4.3 only
		// Some styles come back with percentage values, even though they shouldn't
		div.style.marginRight = "50%";
		pixelMarginRightVal = divStyle.marginRight === "4px";

		documentElement.removeChild( container );
	}

	jQuery.extend( support, {
		pixelPosition: function() {

			// This test is executed only once but we still do memoizing
			// since we can use the boxSizingReliable pre-computing.
			// No need to check if the test was already performed, though.
			computeStyleTests();
			return pixelPositionVal;
		},
		boxSizingReliable: function() {
			if ( boxSizingReliableVal == null ) {
				computeStyleTests();
			}
			return boxSizingReliableVal;
		},
		pixelMarginRight: function() {

			// Support: Android 4.0-4.3
			// We're checking for boxSizingReliableVal here instead of pixelMarginRightVal
			// since that compresses better and they're computed together anyway.
			if ( boxSizingReliableVal == null ) {
				computeStyleTests();
			}
			return pixelMarginRightVal;
		},
		reliableMarginLeft: function() {

			// Support: IE <=8 only, Android 4.0 - 4.3 only, Firefox <=3 - 37
			if ( boxSizingReliableVal == null ) {
				computeStyleTests();
			}
			return reliableMarginLeftVal;
		},
		reliableMarginRight: function() {

			// Support: Android 2.3
			// Check if div with explicit width and no margin-right incorrectly
			// gets computed margin-right based on width of container. (#3333)
			// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
			// This support function is only executed once so no memoizing is needed.
			var ret,
				marginDiv = div.appendChild( document.createElement( "div" ) );

			// Reset CSS: box-sizing; display; margin; border; padding
			marginDiv.style.cssText = div.style.cssText =

				// Support: Android 2.3
				// Vendor-prefix box-sizing
				"-webkit-box-sizing:content-box;box-sizing:content-box;" +
				"display:block;margin:0;border:0;padding:0";
			marginDiv.style.marginRight = marginDiv.style.width = "0";
			div.style.width = "1px";
			documentElement.appendChild( container );

			ret = !parseFloat( window.getComputedStyle( marginDiv ).marginRight );

			documentElement.removeChild( container );
			div.removeChild( marginDiv );

			return ret;
		}
	} );
} )();


function curCSS( elem, name, computed ) {
	var width, minWidth, maxWidth, ret,
		style = elem.style;

	computed = computed || getStyles( elem );
	ret = computed ? computed.getPropertyValue( name ) || computed[ name ] : undefined;

	// Support: Opera 12.1x only
	// Fall back to style even without computed
	// computed is undefined for elems on document fragments
	if ( ( ret === "" || ret === undefined ) && !jQuery.contains( elem.ownerDocument, elem ) ) {
		ret = jQuery.style( elem, name );
	}

	// Support: IE9
	// getPropertyValue is only needed for .css('filter') (#12537)
	if ( computed ) {

		// A tribute to the "awesome hack by Dean Edwards"
		// Android Browser returns percentage for some values,
		// but width seems to be reliably pixels.
		// This is against the CSSOM draft spec:
		// http://dev.w3.org/csswg/cssom/#resolved-values
		if ( !support.pixelMarginRight() && rnumnonpx.test( ret ) && rmargin.test( name ) ) {

			// Remember the original values
			width = style.width;
			minWidth = style.minWidth;
			maxWidth = style.maxWidth;

			// Put in the new values to get a computed value out
			style.minWidth = style.maxWidth = style.width = ret;
			ret = computed.width;

			// Revert the changed values
			style.width = width;
			style.minWidth = minWidth;
			style.maxWidth = maxWidth;
		}
	}

	return ret !== undefined ?

		// Support: IE9-11+
		// IE returns zIndex value as an integer.
		ret + "" :
		ret;
}


function addGetHookIf( conditionFn, hookFn ) {

	// Define the hook, we'll check on the first run if it's really needed.
	return {
		get: function() {
			if ( conditionFn() ) {

				// Hook not needed (or it's not possible to use it due
				// to missing dependency), remove it.
				delete this.get;
				return;
			}

			// Hook needed; redefine it so that the support test is not executed again.
			return ( this.get = hookFn ).apply( this, arguments );
		}
	};
}


var

	// Swappable if display is none or starts with table
	// except "table", "table-cell", or "table-caption"
	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,

	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: "0",
		fontWeight: "400"
	},

	cssPrefixes = [ "Webkit", "O", "Moz", "ms" ],
	emptyStyle = document.createElement( "div" ).style;

// Return a css property mapped to a potentially vendor prefixed property
function vendorPropName( name ) {

	// Shortcut for names that are not vendor prefixed
	if ( name in emptyStyle ) {
		return name;
	}

	// Check for vendor prefixed names
	var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in emptyStyle ) {
			return name;
		}
	}
}

function setPositiveNumber( elem, value, subtract ) {

	// Any relative (+/-) values have already been
	// normalized at this point
	var matches = rcssNum.exec( value );
	return matches ?

		// Guard against undefined "subtract", e.g., when used as in cssHooks
		Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :
		value;
}

function augmentWidthOrHeight( elem, name, extra, isBorderBox, styles ) {
	var i = extra === ( isBorderBox ? "border" : "content" ) ?

		// If we already have the right measurement, avoid augmentation
		4 :

		// Otherwise initialize for horizontal or vertical properties
		name === "width" ? 1 : 0,

		val = 0;

	for ( ; i < 4; i += 2 ) {

		// Both box models exclude margin, so add it if we want it
		if ( extra === "margin" ) {
			val += jQuery.css( elem, extra + cssExpand[ i ], true, styles );
		}

		if ( isBorderBox ) {

			// border-box includes padding, so remove it if we want content
			if ( extra === "content" ) {
				val -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
			}

			// At this point, extra isn't border nor margin, so remove border
			if ( extra !== "margin" ) {
				val -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		} else {

			// At this point, extra isn't content, so add padding
			val += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

			// At this point, extra isn't content nor padding, so add border
			if ( extra !== "padding" ) {
				val += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		}
	}

	return val;
}

function getWidthOrHeight( elem, name, extra ) {

	// Start with offset property, which is equivalent to the border-box value
	var valueIsBorderBox = true,
		val = name === "width" ? elem.offsetWidth : elem.offsetHeight,
		styles = getStyles( elem ),
		isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box";

	// Support: IE11 only
	// In IE 11 fullscreen elements inside of an iframe have
	// 100x too small dimensions (gh-1764).
	if ( document.msFullscreenElement && window.top !== window ) {

		// Support: IE11 only
		// Running getBoundingClientRect on a disconnected node
		// in IE throws an error.
		if ( elem.getClientRects().length ) {
			val = Math.round( elem.getBoundingClientRect()[ name ] * 100 );
		}
	}

	// Some non-html elements return undefined for offsetWidth, so check for null/undefined
	// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
	// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
	if ( val <= 0 || val == null ) {

		// Fall back to computed then uncomputed css if necessary
		val = curCSS( elem, name, styles );
		if ( val < 0 || val == null ) {
			val = elem.style[ name ];
		}

		// Computed unit is not pixels. Stop here and return.
		if ( rnumnonpx.test( val ) ) {
			return val;
		}

		// Check for style in case a browser which returns unreliable values
		// for getComputedStyle silently falls back to the reliable elem.style
		valueIsBorderBox = isBorderBox &&
			( support.boxSizingReliable() || val === elem.style[ name ] );

		// Normalize "", auto, and prepare for extra
		val = parseFloat( val ) || 0;
	}

	// Use the active box-sizing model to add/subtract irrelevant styles
	return ( val +
		augmentWidthOrHeight(
			elem,
			name,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox,
			styles
		)
	) + "px";
}

function showHide( elements, show ) {
	var display, elem, hidden,
		values = [],
		index = 0,
		length = elements.length;

	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}

		values[ index ] = dataPriv.get( elem, "olddisplay" );
		display = elem.style.display;
		if ( show ) {

			// Reset the inline display of this element to learn if it is
			// being hidden by cascaded rules or not
			if ( !values[ index ] && display === "none" ) {
				elem.style.display = "";
			}

			// Set elements which have been overridden with display: none
			// in a stylesheet to whatever the default browser style is
			// for such an element
			if ( elem.style.display === "" && isHidden( elem ) ) {
				values[ index ] = dataPriv.access(
					elem,
					"olddisplay",
					defaultDisplay( elem.nodeName )
				);
			}
		} else {
			hidden = isHidden( elem );

			if ( display !== "none" || !hidden ) {
				dataPriv.set(
					elem,
					"olddisplay",
					hidden ? display : jQuery.css( elem, "display" )
				);
			}
		}
	}

	// Set the display of most of the elements in a second loop
	// to avoid the constant reflow
	for ( index = 0; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}
		if ( !show || elem.style.display === "none" || elem.style.display === "" ) {
			elem.style.display = show ? values[ index ] || "" : "none";
		}
	}

	return elements;
}

jQuery.extend( {

	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {

					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;
				}
			}
		}
	},

	// Don't automatically add "px" to these possibly-unitless properties
	cssNumber: {
		"animationIterationCount": true,
		"columnCount": true,
		"fillOpacity": true,
		"flexGrow": true,
		"flexShrink": true,
		"fontWeight": true,
		"lineHeight": true,
		"opacity": true,
		"order": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {
		"float": "cssFloat"
	},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {

		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = jQuery.camelCase( name ),
			style = elem.style;

		name = jQuery.cssProps[ origName ] ||
			( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );

		// Gets hook for the prefixed version, then unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// Convert "+=" or "-=" to relative numbers (#7345)
			if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {
				value = adjustCSS( elem, name, ret );

				// Fixes bug #9237
				type = "number";
			}

			// Make sure that null and NaN values aren't set (#7116)
			if ( value == null || value !== value ) {
				return;
			}

			// If a number was passed in, add the unit (except for certain CSS properties)
			if ( type === "number" ) {
				value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );
			}

			// Support: IE9-11+
			// background-* props affect original clone's values
			if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {
				style[ name ] = "inherit";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !( "set" in hooks ) ||
				( value = hooks.set( elem, value, extra ) ) !== undefined ) {

				style[ name ] = value;
			}

		} else {

			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks &&
				( ret = hooks.get( elem, false, extra ) ) !== undefined ) {

				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, extra, styles ) {
		var val, num, hooks,
			origName = jQuery.camelCase( name );

		// Make sure that we're working with the right name
		name = jQuery.cssProps[ origName ] ||
			( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );

		// Try prefixed name followed by the unprefixed name
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name, styles );
		}

		// Convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Make numeric if forced or a qualifier was provided and val looks numeric
		if ( extra === "" || extra ) {
			num = parseFloat( val );
			return extra === true || isFinite( num ) ? num || 0 : val;
		}
		return val;
	}
} );

jQuery.each( [ "height", "width" ], function( i, name ) {
	jQuery.cssHooks[ name ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {

				// Certain elements can have dimension info if we invisibly show them
				// but it must have a current display style that would benefit
				return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&
					elem.offsetWidth === 0 ?
						swap( elem, cssShow, function() {
							return getWidthOrHeight( elem, name, extra );
						} ) :
						getWidthOrHeight( elem, name, extra );
			}
		},

		set: function( elem, value, extra ) {
			var matches,
				styles = extra && getStyles( elem ),
				subtract = extra && augmentWidthOrHeight(
					elem,
					name,
					extra,
					jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
					styles
				);

			// Convert to pixels if value adjustment is needed
			if ( subtract && ( matches = rcssNum.exec( value ) ) &&
				( matches[ 3 ] || "px" ) !== "px" ) {

				elem.style[ name ] = value;
				value = jQuery.css( elem, name );
			}

			return setPositiveNumber( elem, value, subtract );
		}
	};
} );

jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,
	function( elem, computed ) {
		if ( computed ) {
			return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||
				elem.getBoundingClientRect().left -
					swap( elem, { marginLeft: 0 }, function() {
						return elem.getBoundingClientRect().left;
					} )
				) + "px";
		}
	}
);

// Support: Android 2.3
jQuery.cssHooks.marginRight = addGetHookIf( support.reliableMarginRight,
	function( elem, computed ) {
		if ( computed ) {
			return swap( elem, { "display": "inline-block" },
				curCSS, [ elem, "marginRight" ] );
		}
	}
);

// These hooks are used by animate to expand properties
jQuery.each( {
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i = 0,
				expanded = {},

				// Assumes a single number if not a string
				parts = typeof value === "string" ? value.split( " " ) : [ value ];

			for ( ; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( !rmargin.test( prefix ) ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
} );

jQuery.fn.extend( {
	css: function( name, value ) {
		return access( this, function( elem, name, value ) {
			var styles, len,
				map = {},
				i = 0;

			if ( jQuery.isArray( name ) ) {
				styles = getStyles( elem );
				len = name.length;

				for ( ; i < len; i++ ) {
					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
				}

				return map;
			}

			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	},
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state ) {
		if ( typeof state === "boolean" ) {
			return state ? this.show() : this.hide();
		}

		return this.each( function() {
			if ( isHidden( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		} );
	}
} );


function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || jQuery.easing._default;
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			// Use a property on the element directly when it is not a DOM element,
			// or when there is no matching style property that exists.
			if ( tween.elem.nodeType !== 1 ||
				tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {
				return tween.elem[ tween.prop ];
			}

			// Passing an empty string as a 3rd parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails.
			// Simple values such as "10px" are parsed to Float;
			// complex values such as "rotate(1rad)" are returned as-is.
			result = jQuery.css( tween.elem, tween.prop, "" );

			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {

			// Use step hook for back compat.
			// Use cssHook if its there.
			// Use .style if available and use plain properties where available.
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.nodeType === 1 &&
				( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null ||
					jQuery.cssHooks[ tween.prop ] ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Support: IE9
// Panic based approach to setting things on disconnected nodes
Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p * Math.PI ) / 2;
	},
	_default: "swing"
};

jQuery.fx = Tween.prototype.init;

// Back Compat <1.8 extension point
jQuery.fx.step = {};




var
	fxNow, timerId,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rrun = /queueHooks$/;

// Animations created synchronously will run synchronously
function createFxNow() {
	window.setTimeout( function() {
		fxNow = undefined;
	} );
	return ( fxNow = jQuery.now() );
}

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		i = 0,
		attrs = { height: type };

	// If we include width, step value is 1 to do all cssExpand values,
	// otherwise step value is 2 to skip over Left and Right
	includeWidth = includeWidth ? 1 : 0;
	for ( ; i < 4 ; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

function createTween( value, prop, animation ) {
	var tween,
		collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),
		index = 0,
		length = collection.length;
	for ( ; index < length; index++ ) {
		if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {

			// We're done with this property
			return tween;
		}
	}
}

function defaultPrefilter( elem, props, opts ) {
	/* jshint validthis: true */
	var prop, value, toggle, tween, hooks, oldfire, display, checkDisplay,
		anim = this,
		orig = {},
		style = elem.style,
		hidden = elem.nodeType && isHidden( elem ),
		dataShow = dataPriv.get( elem, "fxshow" );

	// Handle queue: false promises
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always( function() {

			// Ensure the complete handler is called before this completes
			anim.always( function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			} );
		} );
	}

	// Height/width overflow pass
	if ( elem.nodeType === 1 && ( "height" in props || "width" in props ) ) {

		// Make sure that nothing sneaks out
		// Record all 3 overflow attributes because IE9-10 do not
		// change the overflow attribute when overflowX and
		// overflowY are set to the same value
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Set display property to inline-block for height/width
		// animations on inline elements that are having width/height animated
		display = jQuery.css( elem, "display" );

		// Test default display if display is currently "none"
		checkDisplay = display === "none" ?
			dataPriv.get( elem, "olddisplay" ) || defaultDisplay( elem.nodeName ) : display;

		if ( checkDisplay === "inline" && jQuery.css( elem, "float" ) === "none" ) {
			style.display = "inline-block";
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		anim.always( function() {
			style.overflow = opts.overflow[ 0 ];
			style.overflowX = opts.overflow[ 1 ];
			style.overflowY = opts.overflow[ 2 ];
		} );
	}

	// show/hide pass
	for ( prop in props ) {
		value = props[ prop ];
		if ( rfxtypes.exec( value ) ) {
			delete props[ prop ];
			toggle = toggle || value === "toggle";
			if ( value === ( hidden ? "hide" : "show" ) ) {

				// If there is dataShow left over from a stopped hide or show
				// and we are going to proceed with show, we should pretend to be hidden
				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
					hidden = true;
				} else {
					continue;
				}
			}
			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );

		// Any non-fx value stops us from restoring the original display value
		} else {
			display = undefined;
		}
	}

	if ( !jQuery.isEmptyObject( orig ) ) {
		if ( dataShow ) {
			if ( "hidden" in dataShow ) {
				hidden = dataShow.hidden;
			}
		} else {
			dataShow = dataPriv.access( elem, "fxshow", {} );
		}

		// Store state if its toggle - enables .stop().toggle() to "reverse"
		if ( toggle ) {
			dataShow.hidden = !hidden;
		}
		if ( hidden ) {
			jQuery( elem ).show();
		} else {
			anim.done( function() {
				jQuery( elem ).hide();
			} );
		}
		anim.done( function() {
			var prop;

			dataPriv.remove( elem, "fxshow" );
			for ( prop in orig ) {
				jQuery.style( elem, prop, orig[ prop ] );
			}
		} );
		for ( prop in orig ) {
			tween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );

			if ( !( prop in dataShow ) ) {
				dataShow[ prop ] = tween.start;
				if ( hidden ) {
					tween.end = tween.start;
					tween.start = prop === "width" || prop === "height" ? 1 : 0;
				}
			}
		}

	// If this is a noop like .hide().hide(), restore an overwritten display value
	} else if ( ( display === "none" ? defaultDisplay( elem.nodeName ) : display ) === "inline" ) {
		style.display = display;
	}
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = jQuery.camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( jQuery.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// Not quite $.extend, this won't overwrite existing keys.
			// Reusing 'index' because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

function Animation( elem, properties, options ) {
	var result,
		stopped,
		index = 0,
		length = Animation.prefilters.length,
		deferred = jQuery.Deferred().always( function() {

			// Don't match elem in the :animated selector
			delete tick.elem;
		} ),
		tick = function() {
			if ( stopped ) {
				return false;
			}
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),

				// Support: Android 2.3
				// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)
				temp = remaining / animation.duration || 0,
				percent = 1 - temp,
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length ; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ] );

			if ( percent < 1 && length ) {
				return remaining;
			} else {
				deferred.resolveWith( elem, [ animation ] );
				return false;
			}
		},
		animation = deferred.promise( {
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, {
				specialEasing: {},
				easing: jQuery.easing._default
			}, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
						animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,

					// If we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;
				if ( stopped ) {
					return this;
				}
				stopped = true;
				for ( ; index < length ; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// Resolve when we played the last frame; otherwise, reject
				if ( gotoEnd ) {
					deferred.notifyWith( elem, [ animation, 1, 0 ] );
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		} ),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length ; index++ ) {
		result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			if ( jQuery.isFunction( result.stop ) ) {
				jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =
					jQuery.proxy( result.stop, result );
			}
			return result;
		}
	}

	jQuery.map( props, createTween, animation );

	if ( jQuery.isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	jQuery.fx.timer(
		jQuery.extend( tick, {
			elem: elem,
			anim: animation,
			queue: animation.opts.queue
		} )
	);

	// attach callbacks from options
	return animation.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );
}

jQuery.Animation = jQuery.extend( Animation, {
	tweeners: {
		"*": [ function( prop, value ) {
			var tween = this.createTween( prop, value );
			adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );
			return tween;
		} ]
	},

	tweener: function( props, callback ) {
		if ( jQuery.isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.match( rnotwhite );
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length ; index++ ) {
			prop = props[ index ];
			Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];
			Animation.tweeners[ prop ].unshift( callback );
		}
	},

	prefilters: [ defaultPrefilter ],

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			Animation.prefilters.unshift( callback );
		} else {
			Animation.prefilters.push( callback );
		}
	}
} );

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			jQuery.isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !jQuery.isFunction( easing ) && easing
	};

	opt.duration = jQuery.fx.off ? 0 : typeof opt.duration === "number" ?
		opt.duration : opt.duration in jQuery.fx.speeds ?
			jQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;

	// Normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( jQuery.isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.fn.extend( {
	fadeTo: function( speed, to, easing, callback ) {

		// Show any hidden elements after setting opacity to 0
		return this.filter( isHidden ).css( "opacity", 0 ).show()

			// Animate to the value specified
			.end().animate( { opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {

				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations, or finishing resolves immediately
				if ( empty || dataPriv.get( this, "finish" ) ) {
					anim.stop( true );
				}
			};
			doAnimation.finish = doAnimation;

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue && type !== false ) {
			this.queue( type || "fx", [] );
		}

		return this.each( function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = dataPriv.get( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this &&
					( type == null || timers[ index ].queue === type ) ) {

					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// Start the next in the queue if the last step wasn't forced.
			// Timers currently will call their complete callbacks, which
			// will dequeue but only if they were gotoEnd.
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		} );
	},
	finish: function( type ) {
		if ( type !== false ) {
			type = type || "fx";
		}
		return this.each( function() {
			var index,
				data = dataPriv.get( this ),
				queue = data[ type + "queue" ],
				hooks = data[ type + "queueHooks" ],
				timers = jQuery.timers,
				length = queue ? queue.length : 0;

			// Enable finishing flag on private data
			data.finish = true;

			// Empty the queue first
			jQuery.queue( this, type, [] );

			if ( hooks && hooks.stop ) {
				hooks.stop.call( this, true );
			}

			// Look for any active animations, and finish them
			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
					timers[ index ].anim.stop( true );
					timers.splice( index, 1 );
				}
			}

			// Look for any animations in the old queue and finish them
			for ( index = 0; index < length; index++ ) {
				if ( queue[ index ] && queue[ index ].finish ) {
					queue[ index ].finish.call( this );
				}
			}

			// Turn off finishing flag
			delete data.finish;
		} );
	}
} );

jQuery.each( [ "toggle", "show", "hide" ], function( i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
} );

// Generate shortcuts for custom animations
jQuery.each( {
	slideDown: genFx( "show" ),
	slideUp: genFx( "hide" ),
	slideToggle: genFx( "toggle" ),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
} );

jQuery.timers = [];
jQuery.fx.tick = function() {
	var timer,
		i = 0,
		timers = jQuery.timers;

	fxNow = jQuery.now();

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];

		// Checks the timer has not already been removed
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
	fxNow = undefined;
};

jQuery.fx.timer = function( timer ) {
	jQuery.timers.push( timer );
	if ( timer() ) {
		jQuery.fx.start();
	} else {
		jQuery.timers.pop();
	}
};

jQuery.fx.interval = 13;
jQuery.fx.start = function() {
	if ( !timerId ) {
		timerId = window.setInterval( jQuery.fx.tick, jQuery.fx.interval );
	}
};

jQuery.fx.stop = function() {
	window.clearInterval( timerId );

	timerId = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,

	// Default speed
	_default: 400
};


// Based off of the plugin by Clint Helfers, with permission.
// http://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/
jQuery.fn.delay = function( time, type ) {
	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
	type = type || "fx";

	return this.queue( type, function( next, hooks ) {
		var timeout = window.setTimeout( next, time );
		hooks.stop = function() {
			window.clearTimeout( timeout );
		};
	} );
};


( function() {
	var input = document.createElement( "input" ),
		select = document.createElement( "select" ),
		opt = select.appendChild( document.createElement( "option" ) );

	input.type = "checkbox";

	// Support: iOS<=5.1, Android<=4.2+
	// Default value for a checkbox should be "on"
	support.checkOn = input.value !== "";

	// Support: IE<=11+
	// Must access selectedIndex to make default options select
	support.optSelected = opt.selected;

	// Support: Android<=2.3
	// Options inside disabled selects are incorrectly marked as disabled
	select.disabled = true;
	support.optDisabled = !opt.disabled;

	// Support: IE<=11+
	// An input loses its value after becoming a radio
	input = document.createElement( "input" );
	input.value = "t";
	input.type = "radio";
	support.radioValue = input.value === "t";
} )();


var boolHook,
	attrHandle = jQuery.expr.attrHandle;

jQuery.fn.extend( {
	attr: function( name, value ) {
		return access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each( function() {
			jQuery.removeAttr( this, name );
		} );
	}
} );

jQuery.extend( {
	attr: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set attributes on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === "undefined" ) {
			return jQuery.prop( elem, name, value );
		}

		// All attributes are lowercase
		// Grab necessary hook if one is defined
		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
			name = name.toLowerCase();
			hooks = jQuery.attrHooks[ name ] ||
				( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );
		}

		if ( value !== undefined ) {
			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return;
			}

			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			elem.setAttribute( name, value + "" );
			return value;
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		ret = jQuery.find.attr( elem, name );

		// Non-existent attributes return null, we normalize to undefined
		return ret == null ? undefined : ret;
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				if ( !support.radioValue && value === "radio" &&
					jQuery.nodeName( elem, "input" ) ) {
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		}
	},

	removeAttr: function( elem, value ) {
		var name, propName,
			i = 0,
			attrNames = value && value.match( rnotwhite );

		if ( attrNames && elem.nodeType === 1 ) {
			while ( ( name = attrNames[ i++ ] ) ) {
				propName = jQuery.propFix[ name ] || name;

				// Boolean attributes get special treatment (#10870)
				if ( jQuery.expr.match.bool.test( name ) ) {

					// Set corresponding property to false
					elem[ propName ] = false;
				}

				elem.removeAttribute( name );
			}
		}
	}
} );

// Hooks for boolean attributes
boolHook = {
	set: function( elem, value, name ) {
		if ( value === false ) {

			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			elem.setAttribute( name, name );
		}
		return name;
	}
};
jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( i, name ) {
	var getter = attrHandle[ name ] || jQuery.find.attr;

	attrHandle[ name ] = function( elem, name, isXML ) {
		var ret, handle;
		if ( !isXML ) {

			// Avoid an infinite loop by temporarily removing this function from the getter
			handle = attrHandle[ name ];
			attrHandle[ name ] = ret;
			ret = getter( elem, name, isXML ) != null ?
				name.toLowerCase() :
				null;
			attrHandle[ name ] = handle;
		}
		return ret;
	};
} );




var rfocusable = /^(?:input|select|textarea|button)$/i,
	rclickable = /^(?:a|area)$/i;

jQuery.fn.extend( {
	prop: function( name, value ) {
		return access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		return this.each( function() {
			delete this[ jQuery.propFix[ name ] || name ];
		} );
	}
} );

jQuery.extend( {
	prop: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set properties on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			return ( elem[ name ] = value );
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		return elem[ name ];
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {

				// elem.tabIndex doesn't always return the
				// correct value when it hasn't been explicitly set
				// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				// Use proper attribute retrieval(#12072)
				var tabindex = jQuery.find.attr( elem, "tabindex" );

				return tabindex ?
					parseInt( tabindex, 10 ) :
					rfocusable.test( elem.nodeName ) ||
						rclickable.test( elem.nodeName ) && elem.href ?
							0 :
							-1;
			}
		}
	},

	propFix: {
		"for": "htmlFor",
		"class": "className"
	}
} );

// Support: IE <=11 only
// Accessing the selectedIndex property
// forces the browser to respect setting selected
// on the option
// The getter ensures a default option is selected
// when in an optgroup
if ( !support.optSelected ) {
	jQuery.propHooks.selected = {
		get: function( elem ) {
			var parent = elem.parentNode;
			if ( parent && parent.parentNode ) {
				parent.parentNode.selectedIndex;
			}
			return null;
		},
		set: function( elem ) {
			var parent = elem.parentNode;
			if ( parent ) {
				parent.selectedIndex;

				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
		}
	};
}

jQuery.each( [
	"tabIndex",
	"readOnly",
	"maxLength",
	"cellSpacing",
	"cellPadding",
	"rowSpan",
	"colSpan",
	"useMap",
	"frameBorder",
	"contentEditable"
], function() {
	jQuery.propFix[ this.toLowerCase() ] = this;
} );




var rclass = /[\t\r\n\f]/g;

function getClass( elem ) {
	return elem.getAttribute && elem.getAttribute( "class" ) || "";
}

jQuery.fn.extend( {
	addClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( jQuery.isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		if ( typeof value === "string" && value ) {
			classes = value.match( rnotwhite ) || [];

			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );
				cur = elem.nodeType === 1 &&
					( " " + curValue + " " ).replace( rclass, " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {
						if ( cur.indexOf( " " + clazz + " " ) < 0 ) {
							cur += clazz + " ";
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = jQuery.trim( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( jQuery.isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		if ( !arguments.length ) {
			return this.attr( "class", "" );
		}

		if ( typeof value === "string" && value ) {
			classes = value.match( rnotwhite ) || [];

			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );

				// This expression is here for better compressibility (see addClass)
				cur = elem.nodeType === 1 &&
					( " " + curValue + " " ).replace( rclass, " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {

						// Remove *all* instances
						while ( cur.indexOf( " " + clazz + " " ) > -1 ) {
							cur = cur.replace( " " + clazz + " ", " " );
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = jQuery.trim( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value;

		if ( typeof stateVal === "boolean" && type === "string" ) {
			return stateVal ? this.addClass( value ) : this.removeClass( value );
		}

		if ( jQuery.isFunction( value ) ) {
			return this.each( function( i ) {
				jQuery( this ).toggleClass(
					value.call( this, i, getClass( this ), stateVal ),
					stateVal
				);
			} );
		}

		return this.each( function() {
			var className, i, self, classNames;

			if ( type === "string" ) {

				// Toggle individual class names
				i = 0;
				self = jQuery( this );
				classNames = value.match( rnotwhite ) || [];

				while ( ( className = classNames[ i++ ] ) ) {

					// Check each className given, space separated list
					if ( self.hasClass( className ) ) {
						self.removeClass( className );
					} else {
						self.addClass( className );
					}
				}

			// Toggle whole class name
			} else if ( value === undefined || type === "boolean" ) {
				className = getClass( this );
				if ( className ) {

					// Store className if set
					dataPriv.set( this, "__className__", className );
				}

				// If the element has a class name or if we're passed `false`,
				// then remove the whole classname (if there was one, the above saved it).
				// Otherwise bring back whatever was previously saved (if anything),
				// falling back to the empty string if nothing was stored.
				if ( this.setAttribute ) {
					this.setAttribute( "class",
						className || value === false ?
						"" :
						dataPriv.get( this, "__className__" ) || ""
					);
				}
			}
		} );
	},

	hasClass: function( selector ) {
		var className, elem,
			i = 0;

		className = " " + selector + " ";
		while ( ( elem = this[ i++ ] ) ) {
			if ( elem.nodeType === 1 &&
				( " " + getClass( elem ) + " " ).replace( rclass, " " )
					.indexOf( className ) > -1
			) {
				return true;
			}
		}

		return false;
	}
} );




var rreturn = /\r/g,
	rspaces = /[\x20\t\r\n\f]+/g;

jQuery.fn.extend( {
	val: function( value ) {
		var hooks, ret, isFunction,
			elem = this[ 0 ];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] ||
					jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks &&
					"get" in hooks &&
					( ret = hooks.get( elem, "value" ) ) !== undefined
				) {
					return ret;
				}

				ret = elem.value;

				return typeof ret === "string" ?

					// Handle most common string cases
					ret.replace( rreturn, "" ) :

					// Handle cases where value is null/undef or number
					ret == null ? "" : ret;
			}

			return;
		}

		isFunction = jQuery.isFunction( value );

		return this.each( function( i ) {
			var val;

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( isFunction ) {
				val = value.call( this, i, jQuery( this ).val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";

			} else if ( typeof val === "number" ) {
				val += "";

			} else if ( jQuery.isArray( val ) ) {
				val = jQuery.map( val, function( value ) {
					return value == null ? "" : value + "";
				} );
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		} );
	}
} );

jQuery.extend( {
	valHooks: {
		option: {
			get: function( elem ) {

				var val = jQuery.find.attr( elem, "value" );
				return val != null ?
					val :

					// Support: IE10-11+
					// option.text throws exceptions (#14686, #14858)
					// Strip and collapse whitespace
					// https://html.spec.whatwg.org/#strip-and-collapse-whitespace
					jQuery.trim( jQuery.text( elem ) ).replace( rspaces, " " );
			}
		},
		select: {
			get: function( elem ) {
				var value, option,
					options = elem.options,
					index = elem.selectedIndex,
					one = elem.type === "select-one" || index < 0,
					values = one ? null : [],
					max = one ? index + 1 : options.length,
					i = index < 0 ?
						max :
						one ? index : 0;

				// Loop through all the selected options
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// IE8-9 doesn't update selected after form reset (#2551)
					if ( ( option.selected || i === index ) &&

							// Don't return options that are disabled or in a disabled optgroup
							( support.optDisabled ?
								!option.disabled : option.getAttribute( "disabled" ) === null ) &&
							( !option.parentNode.disabled ||
								!jQuery.nodeName( option.parentNode, "optgroup" ) ) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				return values;
			},

			set: function( elem, value ) {
				var optionSet, option,
					options = elem.options,
					values = jQuery.makeArray( value ),
					i = options.length;

				while ( i-- ) {
					option = options[ i ];
					if ( option.selected =
						jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1
					) {
						optionSet = true;
					}
				}

				// Force browsers to behave consistently when non-matching value is set
				if ( !optionSet ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	}
} );

// Radios and checkboxes getter/setter
jQuery.each( [ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = {
		set: function( elem, value ) {
			if ( jQuery.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );
			}
		}
	};
	if ( !support.checkOn ) {
		jQuery.valHooks[ this ].get = function( elem ) {
			return elem.getAttribute( "value" ) === null ? "on" : elem.value;
		};
	}
} );




// Return jQuery for attributes-only inclusion


var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/;

jQuery.extend( jQuery.event, {

	trigger: function( event, data, elem, onlyHandlers ) {

		var i, cur, tmp, bubbleType, ontype, handle, special,
			eventPath = [ elem || document ],
			type = hasOwn.call( event, "type" ) ? event.type : event,
			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];

		cur = tmp = elem = elem || document;

		// Don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf( "." ) > -1 ) {

			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split( "." );
			type = namespaces.shift();
			namespaces.sort();
		}
		ontype = type.indexOf( ":" ) < 0 && "on" + type;

		// Caller can pass in a jQuery.Event object, Object, or just an event type string
		event = event[ jQuery.expando ] ?
			event :
			new jQuery.Event( type, typeof event === "object" && event );

		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
		event.isTrigger = onlyHandlers ? 2 : 3;
		event.namespace = namespaces.join( "." );
		event.rnamespace = event.namespace ?
			new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
			null;

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data == null ?
			[ event ] :
			jQuery.makeArray( data, [ event ] );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (#9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
		if ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			if ( !rfocusMorph.test( bubbleType + type ) ) {
				cur = cur.parentNode;
			}
			for ( ; cur; cur = cur.parentNode ) {
				eventPath.push( cur );
				tmp = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( tmp === ( elem.ownerDocument || document ) ) {
				eventPath.push( tmp.defaultView || tmp.parentWindow || window );
			}
		}

		// Fire handlers on the event path
		i = 0;
		while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {

			event.type = i > 1 ?
				bubbleType :
				special.bindType || type;

			// jQuery handler
			handle = ( dataPriv.get( cur, "events" ) || {} )[ event.type ] &&
				dataPriv.get( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}

			// Native handler
			handle = ontype && cur[ ontype ];
			if ( handle && handle.apply && acceptData( cur ) ) {
				event.result = handle.apply( cur, data );
				if ( event.result === false ) {
					event.preventDefault();
				}
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( ( !special._default ||
				special._default.apply( eventPath.pop(), data ) === false ) &&
				acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name name as the event.
				// Don't do default actions on window, that's where global variables be (#6170)
				if ( ontype && jQuery.isFunction( elem[ type ] ) && !jQuery.isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					tmp = elem[ ontype ];

					if ( tmp ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;
					elem[ type ]();
					jQuery.event.triggered = undefined;

					if ( tmp ) {
						elem[ ontype ] = tmp;
					}
				}
			}
		}

		return event.result;
	},

	// Piggyback on a donor event to simulate a different one
	simulate: function( type, elem, event ) {
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{
				type: type,
				isSimulated: true

				// Previously, `originalEvent: {}` was set here, so stopPropagation call
				// would not be triggered on donor event, since in our own
				// jQuery.event.stopPropagation function we had a check for existence of
				// originalEvent.stopPropagation method, so, consequently it would be a noop.
				//
				// But now, this "simulate" function is used only for events
				// for which stopPropagation() is noop, so there is no need for that anymore.
				//
				// For the 1.x branch though, guard for "click" and "submit"
				// events is still used, but was moved to jQuery.event.stopPropagation function
				// because `originalEvent` should point to the original event for the constancy
				// with other events and for more focused logic
			}
		);

		jQuery.event.trigger( e, null, elem );

		if ( e.isDefaultPrevented() ) {
			event.preventDefault();
		}
	}

} );

jQuery.fn.extend( {

	trigger: function( type, data ) {
		return this.each( function() {
			jQuery.event.trigger( type, data, this );
		} );
	},
	triggerHandler: function( type, data ) {
		var elem = this[ 0 ];
		if ( elem ) {
			return jQuery.event.trigger( type, data, elem, true );
		}
	}
} );


jQuery.each( ( "blur focus focusin focusout load resize scroll unload click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup error contextmenu" ).split( " " ),
	function( i, name ) {

	// Handle event binding
	jQuery.fn[ name ] = function( data, fn ) {
		return arguments.length > 0 ?
			this.on( name, null, data, fn ) :
			this.trigger( name );
	};
} );

jQuery.fn.extend( {
	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	}
} );




support.focusin = "onfocusin" in window;


// Support: Firefox
// Firefox doesn't have focus(in | out) events
// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
//
// Support: Chrome, Safari
// focus(in | out) events fire after focus & blur events,
// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
// Related ticket - https://code.google.com/p/chromium/issues/detail?id=449857
if ( !support.focusin ) {
	jQuery.each( { focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler on the document while someone wants focusin/focusout
		var handler = function( event ) {
			jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );
		};

		jQuery.event.special[ fix ] = {
			setup: function() {
				var doc = this.ownerDocument || this,
					attaches = dataPriv.access( doc, fix );

				if ( !attaches ) {
					doc.addEventListener( orig, handler, true );
				}
				dataPriv.access( doc, fix, ( attaches || 0 ) + 1 );
			},
			teardown: function() {
				var doc = this.ownerDocument || this,
					attaches = dataPriv.access( doc, fix ) - 1;

				if ( !attaches ) {
					doc.removeEventListener( orig, handler, true );
					dataPriv.remove( doc, fix );

				} else {
					dataPriv.access( doc, fix, attaches );
				}
			}
		};
	} );
}
var location = window.location;

var nonce = jQuery.now();

var rquery = ( /\?/ );



// Support: Android 2.3
// Workaround failure to string-cast null input
jQuery.parseJSON = function( data ) {
	return JSON.parse( data + "" );
};


// Cross-browser xml parsing
jQuery.parseXML = function( data ) {
	var xml;
	if ( !data || typeof data !== "string" ) {
		return null;
	}

	// Support: IE9
	try {
		xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );
	} catch ( e ) {
		xml = undefined;
	}

	if ( !xml || xml.getElementsByTagName( "parsererror" ).length ) {
		jQuery.error( "Invalid XML: " + data );
	}
	return xml;
};


var
	rhash = /#.*$/,
	rts = /([?&])_=[^&]*/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,

	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = "*/".concat( "*" ),

	// Anchor tag for parsing the document origin
	originAnchor = document.createElement( "a" );
	originAnchor.href = location.href;

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType,
			i = 0,
			dataTypes = dataTypeExpression.toLowerCase().match( rnotwhite ) || [];

		if ( jQuery.isFunction( func ) ) {

			// For each dataType in the dataTypeExpression
			while ( ( dataType = dataTypes[ i++ ] ) ) {

				// Prepend if requested
				if ( dataType[ 0 ] === "+" ) {
					dataType = dataType.slice( 1 ) || "*";
					( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );

				// Otherwise append
				} else {
					( structure[ dataType ] = structure[ dataType ] || [] ).push( func );
				}
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

	var inspected = {},
		seekingTransport = ( structure === transports );

	function inspect( dataType ) {
		var selected;
		inspected[ dataType ] = true;
		jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
			var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
			if ( typeof dataTypeOrTransport === "string" &&
				!seekingTransport && !inspected[ dataTypeOrTransport ] ) {

				options.dataTypes.unshift( dataTypeOrTransport );
				inspect( dataTypeOrTransport );
				return false;
			} else if ( seekingTransport ) {
				return !( selected = dataTypeOrTransport );
			}
		} );
		return selected;
	}

	return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};

	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}

	return target;
}

/* Handles responses to an ajax request:
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var ct, type, finalDataType, firstDataType,
		contents = s.contents,
		dataTypes = s.dataTypes;

	// Remove auto dataType and get content-type in the process
	while ( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "Content-Type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {

		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}

		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

/* Chain conversions given the request and the original response
 * Also sets the responseXXX fields on the jqXHR instance
 */
function ajaxConvert( s, response, jqXHR, isSuccess ) {
	var conv2, current, conv, tmp, prev,
		converters = {},

		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice();

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	current = dataTypes.shift();

	// Convert to each sequential dataType
	while ( current ) {

		if ( s.responseFields[ current ] ) {
			jqXHR[ s.responseFields[ current ] ] = response;
		}

		// Apply the dataFilter if provided
		if ( !prev && isSuccess && s.dataFilter ) {
			response = s.dataFilter( response, s.dataType );
		}

		prev = current;
		current = dataTypes.shift();

		if ( current ) {

		// There's only work to do if current dataType is non-auto
			if ( current === "*" ) {

				current = prev;

			// Convert response if prev dataType is non-auto and differs from current
			} else if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split( " " );
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {

								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.unshift( tmp[ 1 ] );
								}
								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s.throws ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return {
								state: "parsererror",
								error: conv ? e : "No conversion from " + prev + " to " + current
							};
						}
					}
				}
			}
		}
	}

	return { state: "success", data: response };
}

jQuery.extend( {

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {},

	ajaxSettings: {
		url: location.href,
		type: "GET",
		isLocal: rlocalProtocol.test( location.protocol ),
		global: true,
		processData: true,
		async: true,
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",
		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			"*": allTypes,
			text: "text/plain",
			html: "text/html",
			xml: "application/xml, text/xml",
			json: "application/json, text/javascript"
		},

		contents: {
			xml: /\bxml\b/,
			html: /\bhtml/,
			json: /\bjson\b/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText",
			json: "responseJSON"
		},

		// Data converters
		// Keys separate source (or catchall "*") and destination types with a single space
		converters: {

			// Convert anything to text
			"* text": String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": jQuery.parseJSON,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			url: true,
			context: true
		}
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		return settings ?

			// Building a settings object
			ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

			// Extending ajaxSettings
			ajaxExtend( jQuery.ajaxSettings, target );
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var transport,

			// URL without anti-cache param
			cacheURL,

			// Response headers
			responseHeadersString,
			responseHeaders,

			// timeout handle
			timeoutTimer,

			// Url cleanup var
			urlAnchor,

			// To know if global events are to be dispatched
			fireGlobals,

			// Loop variable
			i,

			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),

			// Callbacks context
			callbackContext = s.context || s,

			// Context for global events is callbackContext if it is a DOM node or jQuery collection
			globalEventContext = s.context &&
				( callbackContext.nodeType || callbackContext.jquery ) ?
					jQuery( callbackContext ) :
					jQuery.event,

			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks( "once memory" ),

			// Status-dependent callbacks
			statusCode = s.statusCode || {},

			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},

			// The jqXHR state
			state = 0,

			// Default abort message
			strAbort = "canceled",

			// Fake xhr
			jqXHR = {
				readyState: 0,

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( state === 2 ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[ 1 ].toLowerCase() ] = match[ 2 ];
							}
						}
						match = responseHeaders[ key.toLowerCase() ];
					}
					return match == null ? null : match;
				},

				// Raw string
				getAllResponseHeaders: function() {
					return state === 2 ? responseHeadersString : null;
				},

				// Caches the header
				setRequestHeader: function( name, value ) {
					var lname = name.toLowerCase();
					if ( !state ) {
						name = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( !state ) {
						s.mimeType = type;
					}
					return this;
				},

				// Status-dependent callbacks
				statusCode: function( map ) {
					var code;
					if ( map ) {
						if ( state < 2 ) {
							for ( code in map ) {

								// Lazy-add the new callback in a way that preserves old ones
								statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
							}
						} else {

							// Execute the appropriate callbacks
							jqXHR.always( map[ jqXHR.status ] );
						}
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					var finalText = statusText || strAbort;
					if ( transport ) {
						transport.abort( finalText );
					}
					done( 0, finalText );
					return this;
				}
			};

		// Attach deferreds
		deferred.promise( jqXHR ).complete = completeDeferred.add;
		jqXHR.success = jqXHR.done;
		jqXHR.error = jqXHR.fail;

		// Remove hash character (#7531: and string promotion)
		// Add protocol if not provided (prefilters might expect it)
		// Handle falsy url in the settings object (#10093: consistency with old signature)
		// We also use the url parameter if available
		s.url = ( ( url || s.url || location.href ) + "" ).replace( rhash, "" )
			.replace( rprotocol, location.protocol + "//" );

		// Alias method option to type as per ticket #12004
		s.type = options.method || options.type || s.method || s.type;

		// Extract dataTypes list
		s.dataTypes = jQuery.trim( s.dataType || "*" ).toLowerCase().match( rnotwhite ) || [ "" ];

		// A cross-domain request is in order when the origin doesn't match the current origin.
		if ( s.crossDomain == null ) {
			urlAnchor = document.createElement( "a" );

			// Support: IE8-11+
			// IE throws exception if url is malformed, e.g. http://example.com:80x/
			try {
				urlAnchor.href = s.url;

				// Support: IE8-11+
				// Anchor's host property isn't correctly set when s.url is relative
				urlAnchor.href = urlAnchor.href;
				s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !==
					urlAnchor.protocol + "//" + urlAnchor.host;
			} catch ( e ) {

				// If there is an error parsing the URL, assume it is crossDomain,
				// it can be rejected by the transport if it is invalid
				s.crossDomain = true;
			}
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( state === 2 ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)
		fireGlobals = jQuery.event && s.global;

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Save the URL in case we're toying with the If-Modified-Since
		// and/or If-None-Match header later on
		cacheURL = s.url;

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// If data is available, append data to url
			if ( s.data ) {
				cacheURL = ( s.url += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data );

				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Add anti-cache in url if needed
			if ( s.cache === false ) {
				s.url = rts.test( cacheURL ) ?

					// If there is already a '_' parameter, set its value
					cacheURL.replace( rts, "$1_=" + nonce++ ) :

					// Otherwise add one to the end
					cacheURL + ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + nonce++;
			}
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			if ( jQuery.lastModified[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
			}
			if ( jQuery.etag[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
				s.accepts[ s.dataTypes[ 0 ] ] +
					( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend &&
			( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {

			// Abort if not done already and return
			return jqXHR.abort();
		}

		// Aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		for ( i in { success: 1, error: 1, complete: 1 } ) {
			jqXHR[ i ]( s[ i ] );
		}

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;

			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}

			// If request was aborted inside ajaxSend, stop there
			if ( state === 2 ) {
				return jqXHR;
			}

			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = window.setTimeout( function() {
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				state = 1;
				transport.send( requestHeaders, done );
			} catch ( e ) {

				// Propagate exception as error if not done
				if ( state < 2 ) {
					done( -1, e );

				// Simply rethrow otherwise
				} else {
					throw e;
				}
			}
		}

		// Callback for when everything is done
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Called once
			if ( state === 2 ) {
				return;
			}

			// State is "done" now
			state = 2;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				window.clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Determine if successful
			isSuccess = status >= 200 && status < 300 || status === 304;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// Convert no matter what (that way responseXXX fields are always set)
			response = ajaxConvert( s, response, jqXHR, isSuccess );

			// If successful, handle type chaining
			if ( isSuccess ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {
					modified = jqXHR.getResponseHeader( "Last-Modified" );
					if ( modified ) {
						jQuery.lastModified[ cacheURL ] = modified;
					}
					modified = jqXHR.getResponseHeader( "etag" );
					if ( modified ) {
						jQuery.etag[ cacheURL ] = modified;
					}
				}

				// if no content
				if ( status === 204 || s.type === "HEAD" ) {
					statusText = "nocontent";

				// if not modified
				} else if ( status === 304 ) {
					statusText = "notmodified";

				// If we have data, let's convert it
				} else {
					statusText = response.state;
					success = response.data;
					error = response.error;
					isSuccess = !error;
				}
			} else {

				// Extract error from statusText and normalize for non-aborts
				error = statusText;
				if ( status || !statusText ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
					[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );

				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		return jqXHR;
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	}
} );

jQuery.each( [ "get", "post" ], function( i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {

		// Shift arguments if data argument was omitted
		if ( jQuery.isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		// The url can be an options object (which then must have .url)
		return jQuery.ajax( jQuery.extend( {
			url: url,
			type: method,
			dataType: type,
			data: data,
			success: callback
		}, jQuery.isPlainObject( url ) && url ) );
	};
} );


jQuery._evalUrl = function( url ) {
	return jQuery.ajax( {
		url: url,

		// Make this explicit, since user can override this through ajaxSetup (#11264)
		type: "GET",
		dataType: "script",
		async: false,
		global: false,
		"throws": true
	} );
};


jQuery.fn.extend( {
	wrapAll: function( html ) {
		var wrap;

		if ( jQuery.isFunction( html ) ) {
			return this.each( function( i ) {
				jQuery( this ).wrapAll( html.call( this, i ) );
			} );
		}

		if ( this[ 0 ] ) {

			// The elements to wrap the target around
			wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );

			if ( this[ 0 ].parentNode ) {
				wrap.insertBefore( this[ 0 ] );
			}

			wrap.map( function() {
				var elem = this;

				while ( elem.firstElementChild ) {
					elem = elem.firstElementChild;
				}

				return elem;
			} ).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each( function( i ) {
				jQuery( this ).wrapInner( html.call( this, i ) );
			} );
		}

		return this.each( function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		} );
	},

	wrap: function( html ) {
		var isFunction = jQuery.isFunction( html );

		return this.each( function( i ) {
			jQuery( this ).wrapAll( isFunction ? html.call( this, i ) : html );
		} );
	},

	unwrap: function() {
		return this.parent().each( function() {
			if ( !jQuery.nodeName( this, "body" ) ) {
				jQuery( this ).replaceWith( this.childNodes );
			}
		} ).end();
	}
} );


jQuery.expr.filters.hidden = function( elem ) {
	return !jQuery.expr.filters.visible( elem );
};
jQuery.expr.filters.visible = function( elem ) {

	// Support: Opera <= 12.12
	// Opera reports offsetWidths and offsetHeights less than zero on some elements
	// Use OR instead of AND as the element is not visible if either is true
	// See tickets #10406 and #13132
	return elem.offsetWidth > 0 || elem.offsetHeight > 0 || elem.getClientRects().length > 0;
};




var r20 = /%20/g,
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
	rsubmittable = /^(?:input|select|textarea|keygen)/i;

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( jQuery.isArray( obj ) ) {

		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {

				// Treat each array item as a scalar.
				add( prefix, v );

			} else {

				// Item is non-scalar (array or object), encode its numeric index.
				buildParams(
					prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]",
					v,
					traditional,
					add
				);
			}
		} );

	} else if ( !traditional && jQuery.type( obj ) === "object" ) {

		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {

		// Serialize scalar item.
		add( prefix, obj );
	}
}

// Serialize an array of form elements or a set of
// key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, value ) {

			// If value is a function, invoke it and return its value
			value = jQuery.isFunction( value ) ? value() : ( value == null ? "" : value );
			s[ s.length ] = encodeURIComponent( key ) + "=" + encodeURIComponent( value );
		};

	// Set traditional to true for jQuery <= 1.3.2 behavior.
	if ( traditional === undefined ) {
		traditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;
	}

	// If an array was passed in, assume that it is an array of form elements.
	if ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {

		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		} );

	} else {

		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" ).replace( r20, "+" );
};

jQuery.fn.extend( {
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map( function() {

			// Can add propHook for "elements" to filter or add form elements
			var elements = jQuery.prop( this, "elements" );
			return elements ? jQuery.makeArray( elements ) : this;
		} )
		.filter( function() {
			var type = this.type;

			// Use .is( ":disabled" ) so that fieldset[disabled] works
			return this.name && !jQuery( this ).is( ":disabled" ) &&
				rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
				( this.checked || !rcheckableType.test( type ) );
		} )
		.map( function( i, elem ) {
			var val = jQuery( this ).val();

			return val == null ?
				null :
				jQuery.isArray( val ) ?
					jQuery.map( val, function( val ) {
						return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
					} ) :
					{ name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		} ).get();
	}
} );


jQuery.ajaxSettings.xhr = function() {
	try {
		return new window.XMLHttpRequest();
	} catch ( e ) {}
};

var xhrSuccessStatus = {

		// File protocol always yields status code 0, assume 200
		0: 200,

		// Support: IE9
		// #1450: sometimes IE returns 1223 when it should be 204
		1223: 204
	},
	xhrSupported = jQuery.ajaxSettings.xhr();

support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
support.ajax = xhrSupported = !!xhrSupported;

jQuery.ajaxTransport( function( options ) {
	var callback, errorCallback;

	// Cross domain only allowed if supported through XMLHttpRequest
	if ( support.cors || xhrSupported && !options.crossDomain ) {
		return {
			send: function( headers, complete ) {
				var i,
					xhr = options.xhr();

				xhr.open(
					options.type,
					options.url,
					options.async,
					options.username,
					options.password
				);

				// Apply custom fields if provided
				if ( options.xhrFields ) {
					for ( i in options.xhrFields ) {
						xhr[ i ] = options.xhrFields[ i ];
					}
				}

				// Override mime type if needed
				if ( options.mimeType && xhr.overrideMimeType ) {
					xhr.overrideMimeType( options.mimeType );
				}

				// X-Requested-With header
				// For cross-domain requests, seeing as conditions for a preflight are
				// akin to a jigsaw puzzle, we simply never set it to be sure.
				// (it can always be set on a per-request basis or even using ajaxSetup)
				// For same-domain requests, won't change header if already provided.
				if ( !options.crossDomain && !headers[ "X-Requested-With" ] ) {
					headers[ "X-Requested-With" ] = "XMLHttpRequest";
				}

				// Set headers
				for ( i in headers ) {
					xhr.setRequestHeader( i, headers[ i ] );
				}

				// Callback
				callback = function( type ) {
					return function() {
						if ( callback ) {
							callback = errorCallback = xhr.onload =
								xhr.onerror = xhr.onabort = xhr.onreadystatechange = null;

							if ( type === "abort" ) {
								xhr.abort();
							} else if ( type === "error" ) {

								// Support: IE9
								// On a manual native abort, IE9 throws
								// errors on any property access that is not readyState
								if ( typeof xhr.status !== "number" ) {
									complete( 0, "error" );
								} else {
									complete(

										// File: protocol always yields status 0; see #8605, #14207
										xhr.status,
										xhr.statusText
									);
								}
							} else {
								complete(
									xhrSuccessStatus[ xhr.status ] || xhr.status,
									xhr.statusText,

									// Support: IE9 only
									// IE9 has no XHR2 but throws on binary (trac-11426)
									// For XHR2 non-text, let the caller handle it (gh-2498)
									( xhr.responseType || "text" ) !== "text"  ||
									typeof xhr.responseText !== "string" ?
										{ binary: xhr.response } :
										{ text: xhr.responseText },
									xhr.getAllResponseHeaders()
								);
							}
						}
					};
				};

				// Listen to events
				xhr.onload = callback();
				errorCallback = xhr.onerror = callback( "error" );

				// Support: IE9
				// Use onreadystatechange to replace onabort
				// to handle uncaught aborts
				if ( xhr.onabort !== undefined ) {
					xhr.onabort = errorCallback;
				} else {
					xhr.onreadystatechange = function() {

						// Check readyState before timeout as it changes
						if ( xhr.readyState === 4 ) {

							// Allow onerror to be called first,
							// but that will not handle a native abort
							// Also, save errorCallback to a variable
							// as xhr.onerror cannot be accessed
							window.setTimeout( function() {
								if ( callback ) {
									errorCallback();
								}
							} );
						}
					};
				}

				// Create the abort callback
				callback = callback( "abort" );

				try {

					// Do send the request (this may raise an exception)
					xhr.send( options.hasContent && options.data || null );
				} catch ( e ) {

					// #14683: Only rethrow if this hasn't been notified as an error yet
					if ( callback ) {
						throw e;
					}
				}
			},

			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );


// ##### BEGIN: MODIFIED BY SAP
//Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
jQuery.ajaxPrefilter( function( s ) {
	if ( s.crossDomain ) {
		s.contents.script = false;
	}
} );
// ##### END: MODIFIED BY SAP

// Install script dataType
jQuery.ajaxSetup( {
	accepts: {
		script: "text/javascript, application/javascript, " +
			"application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /\b(?:java|ecma)script\b/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
} );

// Handle cache's special case and crossDomain
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
	}
} );

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function( s ) {

	// This transport only deals with cross domain requests
	if ( s.crossDomain ) {
		var script, callback;
		return {
			send: function( _, complete ) {
				script = jQuery( "<script>" ).prop( {
					charset: s.scriptCharset,
					src: s.url
				} ).on(
					"load error",
					callback = function( evt ) {
						script.remove();
						callback = null;
						if ( evt ) {
							complete( evt.type === "error" ? 404 : 200, evt.type );
						}
					}
				);

				// Use native DOM manipulation to avoid our domManip AJAX trickery
				document.head.appendChild( script[ 0 ] );
			},
			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




var oldCallbacks = [],
	rjsonp = /(=)\?(?=&|$)|\?\?/;

// Default jsonp settings
jQuery.ajaxSetup( {
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce++ ) );
		this[ callback ] = true;
		return callback;
	}
} );

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
			"url" :
			typeof s.data === "string" &&
				( s.contentType || "" )
					.indexOf( "application/x-www-form-urlencoded" ) === 0 &&
				rjsonp.test( s.data ) && "data"
		);

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;

		// Insert callback into url or form data
		if ( jsonProp ) {
			s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
		} else if ( s.jsonp !== false ) {
			s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters[ "script json" ] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// Force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		overwritten = window[ callbackName ];
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always( function() {

			// If previous value didn't exist - remove it
			if ( overwritten === undefined ) {
				jQuery( window ).removeProp( callbackName );

			// Otherwise restore preexisting value
			} else {
				window[ callbackName ] = overwritten;
			}

			// Save back as free
			if ( s[ callbackName ] ) {

				// Make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// Save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && jQuery.isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		} );

		// Delegate to script
		return "script";
	}
} );




// Argument "data" should be string of html
// context (optional): If specified, the fragment will be created in this context,
// defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
jQuery.parseHTML = function( data, context, keepScripts ) {
	if ( !data || typeof data !== "string" ) {
		return null;
	}
	if ( typeof context === "boolean" ) {
		keepScripts = context;
		context = false;
	}
	context = context || document;

	var parsed = rsingleTag.exec( data ),
		scripts = !keepScripts && [];

	// Single tag
	if ( parsed ) {
		return [ context.createElement( parsed[ 1 ] ) ];
	}

	parsed = buildFragment( [ data ], context, scripts );

	if ( scripts && scripts.length ) {
		jQuery( scripts ).remove();
	}

	return jQuery.merge( [], parsed.childNodes );
};


// Keep a copy of the old load method
var _load = jQuery.fn.load;

/**
 * Load a url into a page
 */
jQuery.fn.load = function( url, params, callback ) {
	if ( typeof url !== "string" && _load ) {
		return _load.apply( this, arguments );
	}

	var selector, type, response,
		self = this,
		off = url.indexOf( " " );

	if ( off > -1 ) {
		selector = jQuery.trim( url.slice( off ) );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( jQuery.isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// If we have elements to modify, make the request
	if ( self.length > 0 ) {
		jQuery.ajax( {
			url: url,

			// If "type" variable is undefined, then "GET" method will be used.
			// Make value of this field explicit since
			// user can override it through ajaxSetup method
			type: type || "GET",
			dataType: "html",
			data: params
		} ).done( function( responseText ) {

			// Save response for use in complete callback
			response = arguments;

			self.html( selector ?

				// If a selector was specified, locate the right elements in a dummy div
				// Exclude scripts to avoid IE 'Permission Denied' errors
				jQuery( "<div>" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :

				// Otherwise use the full result
				responseText );

		// If the request succeeds, this function gets "data", "status", "jqXHR"
		// but they are ignored because response was set above.
		// If it fails, this function gets "jqXHR", "status", "error"
		} ).always( callback && function( jqXHR, status ) {
			self.each( function() {
				callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );
			} );
		} );
	}

	return this;
};




// Attach a bunch of functions for handling common AJAX events
jQuery.each( [
	"ajaxStart",
	"ajaxStop",
	"ajaxComplete",
	"ajaxError",
	"ajaxSuccess",
	"ajaxSend"
], function( i, type ) {
	jQuery.fn[ type ] = function( fn ) {
		return this.on( type, fn );
	};
} );




jQuery.expr.filters.animated = function( elem ) {
	return jQuery.grep( jQuery.timers, function( fn ) {
		return elem === fn.elem;
	} ).length;
};




/**
 * Gets a window from an element
 */
function getWindow( elem ) {
	return jQuery.isWindow( elem ) ? elem : elem.nodeType === 9 && elem.defaultView;
}

jQuery.offset = {
	setOffset: function( elem, options, i ) {
		var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
			position = jQuery.css( elem, "position" ),
			curElem = jQuery( elem ),
			props = {};

		// Set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		curOffset = curElem.offset();
		curCSSTop = jQuery.css( elem, "top" );
		curCSSLeft = jQuery.css( elem, "left" );
		calculatePosition = ( position === "absolute" || position === "fixed" ) &&
			( curCSSTop + curCSSLeft ).indexOf( "auto" ) > -1;

		// Need to be able to calculate position if either
		// top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;

		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( jQuery.isFunction( options ) ) {

			// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
			options = options.call( elem, i, jQuery.extend( {}, curOffset ) );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );

		} else {
			curElem.css( props );
		}
	}
};

jQuery.fn.extend( {
	offset: function( options ) {
		if ( arguments.length ) {
			return options === undefined ?
				this :
				this.each( function( i ) {
					jQuery.offset.setOffset( this, options, i );
				} );
		}

		var docElem, win,
			elem = this[ 0 ],
			box = { top: 0, left: 0 },
			doc = elem && elem.ownerDocument;

		if ( !doc ) {
			return;
		}

		docElem = doc.documentElement;

		// Make sure it's not a disconnected DOM node
		if ( !jQuery.contains( docElem, elem ) ) {
			return box;
		}

		box = elem.getBoundingClientRect();
		win = getWindow( doc );
		return {
			top: box.top + win.pageYOffset - docElem.clientTop,
			left: box.left + win.pageXOffset - docElem.clientLeft
		};
	},

	position: function() {
		if ( !this[ 0 ] ) {
			return;
		}

		var offsetParent, offset,
			elem = this[ 0 ],
			parentOffset = { top: 0, left: 0 };

		// Fixed elements are offset from window (parentOffset = {top:0, left: 0},
		// because it is its only offset parent
		if ( jQuery.css( elem, "position" ) === "fixed" ) {

			// Assume getBoundingClientRect is there when computed position is fixed
			offset = elem.getBoundingClientRect();

		} else {

			// Get *real* offsetParent
			offsetParent = this.offsetParent();

			// Get correct offsets
			offset = this.offset();
			if ( !jQuery.nodeName( offsetParent[ 0 ], "html" ) ) {
				parentOffset = offsetParent.offset();
			}

			// Add offsetParent borders
			parentOffset.top += jQuery.css( offsetParent[ 0 ], "borderTopWidth", true );
			parentOffset.left += jQuery.css( offsetParent[ 0 ], "borderLeftWidth", true );
		}

		// Subtract parent offsets and element margins
		return {
			top: offset.top - parentOffset.top - jQuery.css( elem, "marginTop", true ),
			left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true )
		};
	},

	// This method will return documentElement in the following cases:
	// 1) For the element inside the iframe without offsetParent, this method will return
	//    documentElement of the parent window
	// 2) For the hidden or detached element
	// 3) For body or html element, i.e. in case of the html node - it will return itself
	//
	// but those exceptions were never presented as a real life use-cases
	// and might be considered as more preferable results.
	//
	// This logic, however, is not guaranteed and can change at any point in the future
	offsetParent: function() {
		return this.map( function() {
			var offsetParent = this.offsetParent;

			while ( offsetParent && jQuery.css( offsetParent, "position" ) === "static" ) {
				offsetParent = offsetParent.offsetParent;
			}

			return offsetParent || documentElement;
		} );
	}
} );

// Create scrollLeft and scrollTop methods
jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
	var top = "pageYOffset" === prop;

	jQuery.fn[ method ] = function( val ) {
		return access( this, function( elem, method, val ) {
			var win = getWindow( elem );

			if ( val === undefined ) {
				return win ? win[ prop ] : elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : win.pageXOffset,
					top ? val : win.pageYOffset
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length );
	};
} );

// Support: Safari<7-8+, Chrome<37-44+
// Add the top/left cssHooks using jQuery.fn.position
// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
// Blink bug: https://code.google.com/p/chromium/issues/detail?id=229280
// getComputedStyle returns percent when specified for top/left/bottom/right;
// rather than make the css module depend on the offset module, just check for it here
jQuery.each( [ "top", "left" ], function( i, prop ) {
	jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
		function( elem, computed ) {
			if ( computed ) {
				computed = curCSS( elem, prop );

				// If curCSS returns percentage, fallback to offset
				return rnumnonpx.test( computed ) ?
					jQuery( elem ).position()[ prop ] + "px" :
					computed;
			}
		}
	);
} );


// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( { padding: "inner" + name, content: type, "": "outer" + name },
		function( defaultExtra, funcName ) {

		// Margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return access( this, function( elem, type, value ) {
				var doc;

				if ( jQuery.isWindow( elem ) ) {

					// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there
					// isn't a whole lot we can do. See pull request at this URL for discussion:
					// https://github.com/jquery/jquery/pull/764
					return elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
					// whichever is greatest
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?

					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable, null );
		};
	} );
} );


jQuery.fn.extend( {

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {

		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ?
			this.off( selector, "**" ) :
			this.off( types, selector || "**", fn );
	},
	size: function() {
		return this.length;
	}
} );

jQuery.fn.andSelf = jQuery.fn.addBack;




// Register as a named AMD module, since jQuery can be concatenated with other
// files that may use define, but not via a proper concatenation script that
// understands anonymous AMD modules. A named AMD is safest and most robust
// way to register. Lowercase jquery is used because AMD module names are
// derived from file names, and jQuery is normally delivered in a lowercase
// file name. Do this after creating the global so that if an AMD module wants
// to call noConflict to hide this version of jQuery, it will work.

// Note that for maximum portability, libraries that are not jQuery should
// declare themselves as anonymous modules, and avoid setting a global if an
// AMD loader is present. jQuery is a special case. For more information, see
// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon

if ( typeof define === "function" && define.amd ) {
	define( "jquery", [], function() {
		return jQuery;
	} );
}



var

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$;

jQuery.noConflict = function( deep ) {
	if ( window.$ === jQuery ) {
		window.$ = _$;
	}

	if ( deep && window.jQuery === jQuery ) {
		window.jQuery = _jQuery;
	}

	return jQuery;
};

// Expose jQuery and $ identifiers, even in AMD
// (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
// and CommonJS for browser emulators (#13566)
if ( !noGlobal ) {
	window.jQuery = window.$ = jQuery;
}

return jQuery;
}));
/*!
 * jQuery UI Core 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/category/ui-core/
 */
(function( $, undefined ) {

var uuid = 0,
	runiqueId = /^ui-id-\d+$/;

// $.ui might exist from components with no dependencies, e.g., $.ui.position
$.ui = $.ui || {};

$.extend( $.ui, {
	version: "1.10.4",

	keyCode: {
		BACKSPACE: 8,
		COMMA: 188,
		DELETE: 46,
		DOWN: 40,
		END: 35,
		ENTER: 13,
		ESCAPE: 27,
		HOME: 36,
		LEFT: 37,
		NUMPAD_ADD: 107,
		NUMPAD_DECIMAL: 110,
		NUMPAD_DIVIDE: 111,
		NUMPAD_ENTER: 108,
		NUMPAD_MULTIPLY: 106,
		NUMPAD_SUBTRACT: 109,
		PAGE_DOWN: 34,
		PAGE_UP: 33,
		PERIOD: 190,
		RIGHT: 39,
		SPACE: 32,
		TAB: 9,
		UP: 38
	}
});

// plugins
$.fn.extend({
	focus: (function( orig ) {
		return function( delay, fn ) {
			return typeof delay === "number" ?
				this.each(function() {
					var elem = this;
					setTimeout(function() {
						$( elem ).focus();
						if ( fn ) {
							fn.call( elem );
						}
					}, delay );
				}) :
				orig.apply( this, arguments );
		};
	})( $.fn.focus ),

	scrollParent: function() {
		var scrollParent;
		if (($.ui.ie && (/(static|relative)/).test(this.css("position"))) || (/absolute/).test(this.css("position"))) {
			scrollParent = this.parents().filter(function() {
				return (/(relative|absolute|fixed)/).test($.css(this,"position")) && (/(auto|scroll)/).test($.css(this,"overflow")+$.css(this,"overflow-y")+$.css(this,"overflow-x"));
			}).eq(0);
		} else {
			scrollParent = this.parents().filter(function() {
				return (/(auto|scroll)/).test($.css(this,"overflow")+$.css(this,"overflow-y")+$.css(this,"overflow-x"));
			}).eq(0);
		}

		return (/fixed/).test(this.css("position")) || !scrollParent.length ? $(document) : scrollParent;
	},

	zIndex: function( zIndex ) {
		if ( zIndex !== undefined ) {
			return this.css( "zIndex", zIndex );
		}

		if ( this.length ) {
			var elem = $( this[ 0 ] ), position, value;
			while ( elem.length && elem[ 0 ] !== document ) {
				// Ignore z-index if position is set to a value where z-index is ignored by the browser
				// This makes behavior of this function consistent across browsers
				// WebKit always returns auto if the element is positioned
				position = elem.css( "position" );
				if ( position === "absolute" || position === "relative" || position === "fixed" ) {
					// IE returns 0 when zIndex is not specified
					// other browsers return a string
					// we ignore the case of nested elements with an explicit value of 0
					// <div style="z-index: -10;"><div style="z-index: 0;"></div></div>
					value = parseInt( elem.css( "zIndex" ), 10 );
					if ( !isNaN( value ) && value !== 0 ) {
						return value;
					}
				}
				elem = elem.parent();
			}
		}

		return 0;
	},

	uniqueId: function() {
		return this.each(function() {
			if ( !this.id ) {
				this.id = "ui-id-" + (++uuid);
			}
		});
	},

	removeUniqueId: function() {
		return this.each(function() {
			if ( runiqueId.test( this.id ) ) {
				$( this ).removeAttr( "id" );
			}
		});
	}
});

// selectors
function focusable( element, isTabIndexNotNaN ) {
	var map, mapName, img,
		nodeName = element.nodeName.toLowerCase();
	if ( "area" === nodeName ) {
		map = element.parentNode;
		mapName = map.name;
		if ( !element.href || !mapName || map.nodeName.toLowerCase() !== "map" ) {
			return false;
		}
		// ##### BEGIN: MODIFIED BY SAP
		img = $( "img[usemap='#" + mapName + "']" )[0];
		// ##### END: MODIFIED BY SAP
		return !!img && visible( img );
	}
	return ( /input|select|textarea|button|object/.test( nodeName ) ?
		!element.disabled :
		"a" === nodeName ?
			element.href || isTabIndexNotNaN :
			isTabIndexNotNaN) &&
		// the element and all of its ancestors must be visible
		visible( element );
}

function visible( element ) {
	return $.expr.filters.visible( element ) &&
		!$( element ).parents().addBack().filter(function() {
			return $.css( this, "visibility" ) === "hidden";
		}).length;
}

$.extend( $.expr[ ":" ], {
	data: $.expr.createPseudo ?
		$.expr.createPseudo(function( dataName ) {
			return function( elem ) {
				return !!$.data( elem, dataName );
			};
		}) :
		// support: jQuery <1.8
		function( elem, i, match ) {
			return !!$.data( elem, match[ 3 ] );
		},

	focusable: function( element ) {
		return focusable( element, !isNaN( $.attr( element, "tabindex" ) ) );
	},

	tabbable: function( element ) {
		var tabIndex = $.attr( element, "tabindex" ),
			isTabIndexNaN = isNaN( tabIndex );
		return ( isTabIndexNaN || tabIndex >= 0 ) && focusable( element, !isTabIndexNaN );
	}
});

// support: jQuery <1.8
if ( !$( "<a>" ).outerWidth( 1 ).jquery ) {
	$.each( [ "Width", "Height" ], function( i, name ) {
		var side = name === "Width" ? [ "Left", "Right" ] : [ "Top", "Bottom" ],
			type = name.toLowerCase(),
			orig = {
				innerWidth: $.fn.innerWidth,
				innerHeight: $.fn.innerHeight,
				outerWidth: $.fn.outerWidth,
				outerHeight: $.fn.outerHeight
			};

		function reduce( elem, size, border, margin ) {
			$.each( side, function() {
				size -= parseFloat( $.css( elem, "padding" + this ) ) || 0;
				if ( border ) {
					size -= parseFloat( $.css( elem, "border" + this + "Width" ) ) || 0;
				}
				if ( margin ) {
					size -= parseFloat( $.css( elem, "margin" + this ) ) || 0;
				}
			});
			return size;
		}

		$.fn[ "inner" + name ] = function( size ) {
			if ( size === undefined ) {
				return orig[ "inner" + name ].call( this );
			}

			return this.each(function() {
				$( this ).css( type, reduce( this, size ) + "px" );
			});
		};

		$.fn[ "outer" + name] = function( size, margin ) {
			if ( typeof size !== "number" ) {
				return orig[ "outer" + name ].call( this, size );
			}

			return this.each(function() {
				$( this).css( type, reduce( this, size, true, margin ) + "px" );
			});
		};
	});
}

// support: jQuery <1.8
if ( !$.fn.addBack ) {
	$.fn.addBack = function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	};
}

// support: jQuery 1.6.1, 1.6.2 (http://bugs.jquery.com/ticket/9413)
if ( $( "<a>" ).data( "a-b", "a" ).removeData( "a-b" ).data( "a-b" ) ) {
	$.fn.removeData = (function( removeData ) {
		return function( key ) {
			if ( arguments.length ) {
				return removeData.call( this, $.camelCase( key ) );
			} else {
				return removeData.call( this );
			}
		};
	})( $.fn.removeData );
}





// deprecated
$.ui.ie = !!/msie [\w.]+/.exec( navigator.userAgent.toLowerCase() );

$.support.selectstart = "onselectstart" in document.createElement( "div" );
$.fn.extend({
	disableSelection: function() {
		return this.bind( ( $.support.selectstart ? "selectstart" : "mousedown" ) +
			".ui-disableSelection", function( event ) {
				event.preventDefault();
			});
	},

	enableSelection: function() {
		return this.unbind( ".ui-disableSelection" );
	}
});

$.extend( $.ui, {
	// $.ui.plugin is deprecated. Use $.widget() extensions instead.
	plugin: {
		add: function( module, option, set ) {
			var i,
				proto = $.ui[ module ].prototype;
			for ( i in set ) {
				proto.plugins[ i ] = proto.plugins[ i ] || [];
				proto.plugins[ i ].push( [ option, set[ i ] ] );
			}
		},
		call: function( instance, name, args ) {
			var i,
				set = instance.plugins[ name ];
			if ( !set || !instance.element[ 0 ].parentNode || instance.element[ 0 ].parentNode.nodeType === 11 ) {
				return;
			}

			for ( i = 0; i < set.length; i++ ) {
				if ( instance.options[ set[ i ][ 0 ] ] ) {
					set[ i ][ 1 ].apply( instance.element, args );
				}
			}
		}
	},

	// only used by resizable
	hasScroll: function( el, a ) {

		//If overflow is hidden, the element might have extra content, but the user wants to hide it
		if ( $( el ).css( "overflow" ) === "hidden") {
			return false;
		}

		var scroll = ( a && a === "left" ) ? "scrollLeft" : "scrollTop",
			has = false;

		if ( el[ scroll ] > 0 ) {
			return true;
		}

		// TODO: determine which cases actually cause this to happen
		// if the element doesn't have the scroll set, see if it's possible to
		// set the scroll
		el[ scroll ] = 1;
		has = ( el[ scroll ] > 0 );
		el[ scroll ] = 0;
		return has;
	}
});

})( jQuery );
/*!
 * jQuery UI Datepicker 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/datepicker/
 *
 * Depends:
 *	jquery.ui.core.js
 */
(function( $, undefined ) {

$.extend($.ui, { datepicker: { version: "1.10.4" } });

var PROP_NAME = "datepicker",
	instActive;

/* Date picker manager.
   Use the singleton instance of this class, $.datepicker, to interact with the date picker.
   Settings for (groups of) date pickers are maintained in an instance object,
   allowing multiple different settings on the same page. */

function Datepicker() {
	this._curInst = null; // The current instance in use
	this._keyEvent = false; // If the last event was a key event
	this._disabledInputs = []; // List of date picker inputs that have been disabled
	this._datepickerShowing = false; // True if the popup picker is showing , false if not
	this._inDialog = false; // True if showing within a "dialog", false if not
	this._mainDivId = "ui-datepicker-div"; // The ID of the main datepicker division
	this._inlineClass = "ui-datepicker-inline"; // The name of the inline marker class
	this._appendClass = "ui-datepicker-append"; // The name of the append marker class
	this._triggerClass = "ui-datepicker-trigger"; // The name of the trigger marker class
	this._dialogClass = "ui-datepicker-dialog"; // The name of the dialog marker class
	this._disableClass = "ui-datepicker-disabled"; // The name of the disabled covering marker class
	this._unselectableClass = "ui-datepicker-unselectable"; // The name of the unselectable cell marker class
	this._currentClass = "ui-datepicker-current-day"; // The name of the current day marker class
	this._dayOverClass = "ui-datepicker-days-cell-over"; // The name of the day hover marker class
	this.regional = []; // Available regional settings, indexed by language code
	this.regional[""] = { // Default regional settings
		closeText: "Done", // Display text for close link
		prevText: "Prev", // Display text for previous month link
		nextText: "Next", // Display text for next month link
		currentText: "Today", // Display text for current month link
		monthNames: ["January","February","March","April","May","June",
			"July","August","September","October","November","December"], // Names of months for drop-down and formatting
		monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"], // For formatting
		dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"], // For formatting
		dayNamesShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"], // For formatting
		dayNamesMin: ["Su","Mo","Tu","We","Th","Fr","Sa"], // Column headings for days starting at Sunday
		weekHeader: "Wk", // Column header for week of the year
		dateFormat: "mm/dd/yy", // See format options on parseDate
		firstDay: 0, // The first day of the week, Sun = 0, Mon = 1, ...
		isRTL: false, // True if right-to-left language, false if left-to-right
		showMonthAfterYear: false, // True if the year select precedes month, false for month then year
		yearSuffix: "" // Additional text to append to the year in the month headers
	};
	this._defaults = { // Global defaults for all the date picker instances
		showOn: "focus", // "focus" for popup on focus,
			// "button" for trigger button, or "both" for either
		showAnim: "fadeIn", // Name of jQuery animation for popup
		showOptions: {}, // Options for enhanced animations
		defaultDate: null, // Used when field is blank: actual date,
			// +/-number for offset from today, null for today
		appendText: "", // Display text following the input box, e.g. showing the format
		buttonText: "...", // Text for trigger button
		buttonImage: "", // URL for trigger button image
		buttonImageOnly: false, // True if the image appears alone, false if it appears on a button
		hideIfNoPrevNext: false, // True to hide next/previous month links
			// if not applicable, false to just disable them
		navigationAsDateFormat: false, // True if date formatting applied to prev/today/next links
		gotoCurrent: false, // True if today link goes back to current selection instead
		changeMonth: false, // True if month can be selected directly, false if only prev/next
		changeYear: false, // True if year can be selected directly, false if only prev/next
		yearRange: "c-10:c+10", // Range of years to display in drop-down,
			// either relative to today's year (-nn:+nn), relative to currently displayed year
			// (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)
		showOtherMonths: false, // True to show dates in other months, false to leave blank
		selectOtherMonths: false, // True to allow selection of dates in other months, false for unselectable
		showWeek: false, // True to show week of the year, false to not show it
		calculateWeek: this.iso8601Week, // How to calculate the week of the year,
			// takes a Date and returns the number of the week for it
		shortYearCutoff: "+10", // Short year values < this are in the current century,
			// > this are in the previous century,
			// string value starting with "+" for current year + value
		minDate: null, // The earliest selectable date, or null for no limit
		maxDate: null, // The latest selectable date, or null for no limit
		duration: "fast", // Duration of display/closure
		beforeShowDay: null, // Function that takes a date and returns an array with
			// [0] = true if selectable, false if not, [1] = custom CSS class name(s) or "",
			// [2] = cell title (optional), e.g. $.datepicker.noWeekends
		beforeShow: null, // Function that takes an input field and
			// returns a set of custom settings for the date picker
		onSelect: null, // Define a callback function when a date is selected
		onChangeMonthYear: null, // Define a callback function when the month or year is changed
		onClose: null, // Define a callback function when the datepicker is closed
		numberOfMonths: 1, // Number of months to show at a time
		showCurrentAtPos: 0, // The position in multipe months at which to show the current month (starting at 0)
		stepMonths: 1, // Number of months to step back/forward
		stepBigMonths: 12, // Number of months to step back/forward for the big links
		altField: "", // Selector for an alternate field to store selected dates into
		altFormat: "", // The date format to use for the alternate field
		constrainInput: true, // The input is constrained by the current date format
		showButtonPanel: false, // True to show button panel, false to not show it
		autoSize: false, // True to size the input for the date format, false to leave as is
		disabled: false // The initial disabled state
	};
	$.extend(this._defaults, this.regional[""]);
	this.dpDiv = bindHover($("<div id='" + this._mainDivId + "' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"));
}

$.extend(Datepicker.prototype, {
	/* Class name added to elements to indicate already configured with a date picker. */
	markerClassName: "hasDatepicker",

	//Keep track of the maximum number of rows displayed (see #7043)
	maxRows: 4,

	// TODO rename to "widget" when switching to widget factory
	_widgetDatepicker: function() {
		return this.dpDiv;
	},

	/* Override the default settings for all instances of the date picker.
	 * @param  settings  object - the new settings to use as defaults (anonymous object)
	 * @return the manager object
	 */
	setDefaults: function(settings) {
		extendRemove(this._defaults, settings || {});
		return this;
	},

	/* Attach the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 * @param  settings  object - the new settings to use for this date picker instance (anonymous)
	 */
	_attachDatepicker: function(target, settings) {
		var nodeName, inline, inst;
		nodeName = target.nodeName.toLowerCase();
		inline = (nodeName === "div" || nodeName === "span");
		if (!target.id) {
			this.uuid += 1;
			target.id = "dp" + this.uuid;
		}
		inst = this._newInst($(target), inline);
		inst.settings = $.extend({}, settings || {});
		if (nodeName === "input") {
			this._connectDatepicker(target, inst);
		} else if (inline) {
			this._inlineDatepicker(target, inst);
		}
	},

	/* Create a new instance object. */
	_newInst: function(target, inline) {
		var id = target[0].id.replace(/([^A-Za-z0-9_\-])/g, "\\\\$1"); // escape jQuery meta chars
		return {id: id, input: target, // associated target
			selectedDay: 0, selectedMonth: 0, selectedYear: 0, // current selection
			drawMonth: 0, drawYear: 0, // month being drawn
			inline: inline, // is datepicker inline or not
			dpDiv: (!inline ? this.dpDiv : // presentation div
			bindHover($("<div class='" + this._inlineClass + " ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>")))};
	},

	/* Attach the date picker to an input field. */
	_connectDatepicker: function(target, inst) {
		var input = $(target);
		inst.append = $([]);
		inst.trigger = $([]);
		if (input.hasClass(this.markerClassName)) {
			return;
		}
		this._attachments(input, inst);
		input.addClass(this.markerClassName).keydown(this._doKeyDown).
			keypress(this._doKeyPress).keyup(this._doKeyUp);
		this._autoSize(inst);
		$.data(target, PROP_NAME, inst);
		//If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)
		if( inst.settings.disabled ) {
			this._disableDatepicker( target );
		}
	},

	/* Make attachments based on settings. */
	_attachments: function(input, inst) {
		var showOn, buttonText, buttonImage,
			appendText = this._get(inst, "appendText"),
			isRTL = this._get(inst, "isRTL");

		if (inst.append) {
			inst.append.remove();
		}
		if (appendText) {
			inst.append = $("<span class='" + this._appendClass + "'>" + appendText + "</span>");
			input[isRTL ? "before" : "after"](inst.append);
		}

		input.unbind("focus", this._showDatepicker);

		if (inst.trigger) {
			inst.trigger.remove();
		}

		showOn = this._get(inst, "showOn");
		if (showOn === "focus" || showOn === "both") { // pop-up date picker when in the marked field
			input.focus(this._showDatepicker);
		}
		if (showOn === "button" || showOn === "both") { // pop-up date picker when button clicked
			buttonText = this._get(inst, "buttonText");
			buttonImage = this._get(inst, "buttonImage");
			inst.trigger = $(this._get(inst, "buttonImageOnly") ?
				$("<img/>").addClass(this._triggerClass).
					attr({ src: buttonImage, alt: buttonText, title: buttonText }) :
				$("<button type='button'></button>").addClass(this._triggerClass).
					html(!buttonImage ? buttonText : $("<img/>").attr(
					{ src:buttonImage, alt:buttonText, title:buttonText })));
			input[isRTL ? "before" : "after"](inst.trigger);
			inst.trigger.click(function() {
				if ($.datepicker._datepickerShowing && $.datepicker._lastInput === input[0]) {
					$.datepicker._hideDatepicker();
				} else if ($.datepicker._datepickerShowing && $.datepicker._lastInput !== input[0]) {
					$.datepicker._hideDatepicker();
					$.datepicker._showDatepicker(input[0]);
				} else {
					$.datepicker._showDatepicker(input[0]);
				}
				return false;
			});
		}
	},

	/* Apply the maximum length for the date format. */
	_autoSize: function(inst) {
		if (this._get(inst, "autoSize") && !inst.inline) {
			var findMax, max, maxI, i,
				date = new Date(2009, 12 - 1, 20), // Ensure double digits
				dateFormat = this._get(inst, "dateFormat");

			if (dateFormat.match(/[DM]/)) {
				findMax = function(names) {
					max = 0;
					maxI = 0;
					for (i = 0; i < names.length; i++) {
						if (names[i].length > max) {
							max = names[i].length;
							maxI = i;
						}
					}
					return maxI;
				};
				date.setMonth(findMax(this._get(inst, (dateFormat.match(/MM/) ?
					"monthNames" : "monthNamesShort"))));
				date.setDate(findMax(this._get(inst, (dateFormat.match(/DD/) ?
					"dayNames" : "dayNamesShort"))) + 20 - date.getDay());
			}
			inst.input.attr("size", this._formatDate(inst, date).length);
		}
	},

	/* Attach an inline date picker to a div. */
	_inlineDatepicker: function(target, inst) {
		var divSpan = $(target);
		if (divSpan.hasClass(this.markerClassName)) {
			return;
		}
		divSpan.addClass(this.markerClassName).append(inst.dpDiv);
		$.data(target, PROP_NAME, inst);
		this._setDate(inst, this._getDefaultDate(inst), true);
		this._updateDatepicker(inst);
		this._updateAlternate(inst);
		//If disabled option is true, disable the datepicker before showing it (see ticket #5665)
		if( inst.settings.disabled ) {
			this._disableDatepicker( target );
		}
		// Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements
		// http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height
		inst.dpDiv.css( "display", "block" );
	},

	/* Pop-up the date picker in a "dialog" box.
	 * @param  input element - ignored
	 * @param  date	string or Date - the initial date to display
	 * @param  onSelect  function - the function to call when a date is selected
	 * @param  settings  object - update the dialog date picker instance's settings (anonymous object)
	 * @param  pos int[2] - coordinates for the dialog's position within the screen or
	 *					event - with x/y coordinates or
	 *					leave empty for default (screen centre)
	 * @return the manager object
	 */
	_dialogDatepicker: function(input, date, onSelect, settings, pos) {
		var id, browserWidth, browserHeight, scrollX, scrollY,
			inst = this._dialogInst; // internal instance

		if (!inst) {
			this.uuid += 1;
			id = "dp" + this.uuid;
			this._dialogInput = $("<input type='text' id='" + id +
				"' style='position: absolute; top: -100px; width: 0px;'/>");
			this._dialogInput.keydown(this._doKeyDown);
			$("body").append(this._dialogInput);
			inst = this._dialogInst = this._newInst(this._dialogInput, false);
			inst.settings = {};
			$.data(this._dialogInput[0], PROP_NAME, inst);
		}
		extendRemove(inst.settings, settings || {});
		date = (date && date.constructor === Date ? this._formatDate(inst, date) : date);
		this._dialogInput.val(date);

		this._pos = (pos ? (pos.length ? pos : [pos.pageX, pos.pageY]) : null);
		if (!this._pos) {
			browserWidth = document.documentElement.clientWidth;
			browserHeight = document.documentElement.clientHeight;
			scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;
			scrollY = document.documentElement.scrollTop || document.body.scrollTop;
			this._pos = // should use actual width/height below
				[(browserWidth / 2) - 100 + scrollX, (browserHeight / 2) - 150 + scrollY];
		}

		// move input on screen for focus, but hidden behind dialog
		this._dialogInput.css("left", (this._pos[0] + 20) + "px").css("top", this._pos[1] + "px");
		inst.settings.onSelect = onSelect;
		this._inDialog = true;
		this.dpDiv.addClass(this._dialogClass);
		this._showDatepicker(this._dialogInput[0]);
		if ($.blockUI) {
			$.blockUI(this.dpDiv);
		}
		$.data(this._dialogInput[0], PROP_NAME, inst);
		return this;
	},

	/* Detach a datepicker from its control.
	 * @param  target	element - the target input field or division or span
	 */
	_destroyDatepicker: function(target) {
		var nodeName,
			$target = $(target),
			inst = $.data(target, PROP_NAME);

		if (!$target.hasClass(this.markerClassName)) {
			return;
		}

		nodeName = target.nodeName.toLowerCase();
		$.removeData(target, PROP_NAME);
		if (nodeName === "input") {
			inst.append.remove();
			inst.trigger.remove();
			$target.removeClass(this.markerClassName).
				unbind("focus", this._showDatepicker).
				unbind("keydown", this._doKeyDown).
				unbind("keypress", this._doKeyPress).
				unbind("keyup", this._doKeyUp);
		} else if (nodeName === "div" || nodeName === "span") {
			$target.removeClass(this.markerClassName).empty();
		}
	},

	/* Enable the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 */
	_enableDatepicker: function(target) {
		var nodeName, inline,
			$target = $(target),
			inst = $.data(target, PROP_NAME);

		if (!$target.hasClass(this.markerClassName)) {
			return;
		}

		nodeName = target.nodeName.toLowerCase();
		if (nodeName === "input") {
			target.disabled = false;
			inst.trigger.filter("button").
				each(function() { this.disabled = false; }).end().
				filter("img").css({opacity: "1.0", cursor: ""});
		} else if (nodeName === "div" || nodeName === "span") {
			inline = $target.children("." + this._inlineClass);
			inline.children().removeClass("ui-state-disabled");
			inline.find("select.ui-datepicker-month, select.ui-datepicker-year").
				prop("disabled", false);
		}
		this._disabledInputs = $.map(this._disabledInputs,
			function(value) { return (value === target ? null : value); }); // delete entry
	},

	/* Disable the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 */
	_disableDatepicker: function(target) {
		var nodeName, inline,
			$target = $(target),
			inst = $.data(target, PROP_NAME);

		if (!$target.hasClass(this.markerClassName)) {
			return;
		}

		nodeName = target.nodeName.toLowerCase();
		if (nodeName === "input") {
			target.disabled = true;
			inst.trigger.filter("button").
				each(function() { this.disabled = true; }).end().
				filter("img").css({opacity: "0.5", cursor: "default"});
		} else if (nodeName === "div" || nodeName === "span") {
			inline = $target.children("." + this._inlineClass);
			inline.children().addClass("ui-state-disabled");
			inline.find("select.ui-datepicker-month, select.ui-datepicker-year").
				prop("disabled", true);
		}
		this._disabledInputs = $.map(this._disabledInputs,
			function(value) { return (value === target ? null : value); }); // delete entry
		this._disabledInputs[this._disabledInputs.length] = target;
	},

	/* Is the first field in a jQuery collection disabled as a datepicker?
	 * @param  target	element - the target input field or division or span
	 * @return boolean - true if disabled, false if enabled
	 */
	_isDisabledDatepicker: function(target) {
		if (!target) {
			return false;
		}
		for (var i = 0; i < this._disabledInputs.length; i++) {
			if (this._disabledInputs[i] === target) {
				return true;
			}
		}
		return false;
	},

	/* Retrieve the instance data for the target control.
	 * @param  target  element - the target input field or division or span
	 * @return  object - the associated instance data
	 * @throws  error if a jQuery problem getting data
	 */
	_getInst: function(target) {
		try {
			return $.data(target, PROP_NAME);
		}
		catch (err) {
			throw "Missing instance data for this datepicker";
		}
	},

	/* Update or retrieve the settings for a date picker attached to an input field or division.
	 * @param  target  element - the target input field or division or span
	 * @param  name	object - the new settings to update or
	 *				string - the name of the setting to change or retrieve,
	 *				when retrieving also "all" for all instance settings or
	 *				"defaults" for all global defaults
	 * @param  value   any - the new value for the setting
	 *				(omit if above is an object or to retrieve a value)
	 */
	_optionDatepicker: function(target, name, value) {
		var settings, date, minDate, maxDate,
			inst = this._getInst(target);

		if (arguments.length === 2 && typeof name === "string") {
			return (name === "defaults" ? $.extend({}, $.datepicker._defaults) :
				(inst ? (name === "all" ? $.extend({}, inst.settings) :
				this._get(inst, name)) : null));
		}

		settings = name || {};
		if (typeof name === "string") {
			settings = {};
			settings[name] = value;
		}

		if (inst) {
			if (this._curInst === inst) {
				this._hideDatepicker();
			}

			date = this._getDateDatepicker(target, true);
			minDate = this._getMinMaxDate(inst, "min");
			maxDate = this._getMinMaxDate(inst, "max");
			extendRemove(inst.settings, settings);
			// reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided
			if (minDate !== null && settings.dateFormat !== undefined && settings.minDate === undefined) {
				inst.settings.minDate = this._formatDate(inst, minDate);
			}
			if (maxDate !== null && settings.dateFormat !== undefined && settings.maxDate === undefined) {
				inst.settings.maxDate = this._formatDate(inst, maxDate);
			}
			if ( "disabled" in settings ) {
				if ( settings.disabled ) {
					this._disableDatepicker(target);
				} else {
					this._enableDatepicker(target);
				}
			}
			this._attachments($(target), inst);
			this._autoSize(inst);
			this._setDate(inst, date);
			this._updateAlternate(inst);
			this._updateDatepicker(inst);
		}
	},

	// change method deprecated
	_changeDatepicker: function(target, name, value) {
		this._optionDatepicker(target, name, value);
	},

	/* Redraw the date picker attached to an input field or division.
	 * @param  target  element - the target input field or division or span
	 */
	_refreshDatepicker: function(target) {
		var inst = this._getInst(target);
		if (inst) {
			this._updateDatepicker(inst);
		}
	},

	/* Set the dates for a jQuery selection.
	 * @param  target element - the target input field or division or span
	 * @param  date	Date - the new date
	 */
	_setDateDatepicker: function(target, date) {
		var inst = this._getInst(target);
		if (inst) {
			this._setDate(inst, date);
			this._updateDatepicker(inst);
			this._updateAlternate(inst);
		}
	},

	/* Get the date(s) for the first entry in a jQuery selection.
	 * @param  target element - the target input field or division or span
	 * @param  noDefault boolean - true if no default date is to be used
	 * @return Date - the current date
	 */
	_getDateDatepicker: function(target, noDefault) {
		var inst = this._getInst(target);
		if (inst && !inst.inline) {
			this._setDateFromField(inst, noDefault);
		}
		return (inst ? this._getDate(inst) : null);
	},

	/* Handle keystrokes. */
	_doKeyDown: function(event) {
		var onSelect, dateStr, sel,
			inst = $.datepicker._getInst(event.target),
			handled = true,
			isRTL = inst.dpDiv.is(".ui-datepicker-rtl");

		inst._keyEvent = true;
		if ($.datepicker._datepickerShowing) {
			switch (event.keyCode) {
				case 9: $.datepicker._hideDatepicker();
						handled = false;
						break; // hide on tab out
				case 13: sel = $("td." + $.datepicker._dayOverClass + ":not(." +
									$.datepicker._currentClass + ")", inst.dpDiv);
						if (sel[0]) {
							$.datepicker._selectDay(event.target, inst.selectedMonth, inst.selectedYear, sel[0]);
						}

						onSelect = $.datepicker._get(inst, "onSelect");
						if (onSelect) {
							dateStr = $.datepicker._formatDate(inst);

							// trigger custom callback
							onSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);
						} else {
							$.datepicker._hideDatepicker();
						}

						return false; // don't submit the form
				case 27: $.datepicker._hideDatepicker();
						break; // hide on escape
				case 33: $.datepicker._adjustDate(event.target, (event.ctrlKey ?
							-$.datepicker._get(inst, "stepBigMonths") :
							-$.datepicker._get(inst, "stepMonths")), "M");
						break; // previous month/year on page up/+ ctrl
				case 34: $.datepicker._adjustDate(event.target, (event.ctrlKey ?
							+$.datepicker._get(inst, "stepBigMonths") :
							+$.datepicker._get(inst, "stepMonths")), "M");
						break; // next month/year on page down/+ ctrl
				case 35: if (event.ctrlKey || event.metaKey) {
							$.datepicker._clearDate(event.target);
						}
						handled = event.ctrlKey || event.metaKey;
						break; // clear on ctrl or command +end
				case 36: if (event.ctrlKey || event.metaKey) {
							$.datepicker._gotoToday(event.target);
						}
						handled = event.ctrlKey || event.metaKey;
						break; // current on ctrl or command +home
				case 37: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, (isRTL ? +1 : -1), "D");
						}
						handled = event.ctrlKey || event.metaKey;
						// -1 day on ctrl or command +left
						if (event.originalEvent.altKey) {
							$.datepicker._adjustDate(event.target, (event.ctrlKey ?
								-$.datepicker._get(inst, "stepBigMonths") :
								-$.datepicker._get(inst, "stepMonths")), "M");
						}
						// next month/year on alt +left on Mac
						break;
				case 38: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, -7, "D");
						}
						handled = event.ctrlKey || event.metaKey;
						break; // -1 week on ctrl or command +up
				case 39: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, (isRTL ? -1 : +1), "D");
						}
						handled = event.ctrlKey || event.metaKey;
						// +1 day on ctrl or command +right
						if (event.originalEvent.altKey) {
							$.datepicker._adjustDate(event.target, (event.ctrlKey ?
								+$.datepicker._get(inst, "stepBigMonths") :
								+$.datepicker._get(inst, "stepMonths")), "M");
						}
						// next month/year on alt +right
						break;
				case 40: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, +7, "D");
						}
						handled = event.ctrlKey || event.metaKey;
						break; // +1 week on ctrl or command +down
				default: handled = false;
			}
		} else if (event.keyCode === 36 && event.ctrlKey) { // display the date picker on ctrl+home
			$.datepicker._showDatepicker(this);
		} else {
			handled = false;
		}

		if (handled) {
			event.preventDefault();
			event.stopPropagation();
		}
	},

	/* Filter entered characters - based on date format. */
	_doKeyPress: function(event) {
		var chars, chr,
			inst = $.datepicker._getInst(event.target);

		if ($.datepicker._get(inst, "constrainInput")) {
			chars = $.datepicker._possibleChars($.datepicker._get(inst, "dateFormat"));
			chr = String.fromCharCode(event.charCode == null ? event.keyCode : event.charCode);
			return event.ctrlKey || event.metaKey || (chr < " " || !chars || chars.indexOf(chr) > -1);
		}
	},

	/* Synchronise manual entry and field/alternate field. */
	_doKeyUp: function(event) {
		var date,
			inst = $.datepicker._getInst(event.target);

		if (inst.input.val() !== inst.lastVal) {
			try {
				date = $.datepicker.parseDate($.datepicker._get(inst, "dateFormat"),
					(inst.input ? inst.input.val() : null),
					$.datepicker._getFormatConfig(inst));

				if (date) { // only if valid
					$.datepicker._setDateFromField(inst);
					$.datepicker._updateAlternate(inst);
					$.datepicker._updateDatepicker(inst);
				}
			}
			catch (err) {
			}
		}
		return true;
	},

	/* Pop-up the date picker for a given input field.
	 * If false returned from beforeShow event handler do not show.
	 * @param  input  element - the input field attached to the date picker or
	 *					event - if triggered by focus
	 */
	_showDatepicker: function(input) {
		input = input.target || input;
		if (input.nodeName.toLowerCase() !== "input") { // find from button/image trigger
			input = $("input", input.parentNode)[0];
		}

		if ($.datepicker._isDisabledDatepicker(input) || $.datepicker._lastInput === input) { // already here
			return;
		}

		var inst, beforeShow, beforeShowSettings, isFixed,
			offset, showAnim, duration;

		inst = $.datepicker._getInst(input);
		if ($.datepicker._curInst && $.datepicker._curInst !== inst) {
			$.datepicker._curInst.dpDiv.stop(true, true);
			if ( inst && $.datepicker._datepickerShowing ) {
				$.datepicker._hideDatepicker( $.datepicker._curInst.input[0] );
			}
		}

		beforeShow = $.datepicker._get(inst, "beforeShow");
		beforeShowSettings = beforeShow ? beforeShow.apply(input, [input, inst]) : {};
		if(beforeShowSettings === false){
			return;
		}
		extendRemove(inst.settings, beforeShowSettings);

		inst.lastVal = null;
		$.datepicker._lastInput = input;
		$.datepicker._setDateFromField(inst);

		if ($.datepicker._inDialog) { // hide cursor
			input.value = "";
		}
		if (!$.datepicker._pos) { // position below input
			$.datepicker._pos = $.datepicker._findPos(input);
			$.datepicker._pos[1] += input.offsetHeight; // add the height
		}

		isFixed = false;
		$(input).parents().each(function() {
			isFixed |= $(this).css("position") === "fixed";
			return !isFixed;
		});

		offset = {left: $.datepicker._pos[0], top: $.datepicker._pos[1]};
		$.datepicker._pos = null;
		//to avoid flashes on Firefox
		inst.dpDiv.empty();
		// determine sizing offscreen
		inst.dpDiv.css({position: "absolute", display: "block", top: "-1000px"});
		$.datepicker._updateDatepicker(inst);
		// fix width for dynamic number of date pickers
		// and adjust position before showing
		offset = $.datepicker._checkOffset(inst, offset, isFixed);
		inst.dpDiv.css({position: ($.datepicker._inDialog && $.blockUI ?
			"static" : (isFixed ? "fixed" : "absolute")), display: "none",
			left: offset.left + "px", top: offset.top + "px"});

		if (!inst.inline) {
			showAnim = $.datepicker._get(inst, "showAnim");
			duration = $.datepicker._get(inst, "duration");
			inst.dpDiv.zIndex($(input).zIndex()+1);
			$.datepicker._datepickerShowing = true;

			if ( $.effects && $.effects.effect[ showAnim ] ) {
				inst.dpDiv.show(showAnim, $.datepicker._get(inst, "showOptions"), duration);
			} else {
				inst.dpDiv[showAnim || "show"](showAnim ? duration : null);
			}

			if ( $.datepicker._shouldFocusInput( inst ) ) {
				inst.input.focus();
			}

			$.datepicker._curInst = inst;
		}
	},

	/* Generate the date picker content. */
	_updateDatepicker: function(inst) {
		this.maxRows = 4; //Reset the max number of rows being displayed (see #7043)
		instActive = inst; // for delegate hover events
		inst.dpDiv.empty().append(this._generateHTML(inst));
		this._attachHandlers(inst);
		inst.dpDiv.find("." + this._dayOverClass + " a").mouseover();

		var origyearshtml,
			numMonths = this._getNumberOfMonths(inst),
			cols = numMonths[1],
			width = 17;

		inst.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width("");
		if (cols > 1) {
			inst.dpDiv.addClass("ui-datepicker-multi-" + cols).css("width", (width * cols) + "em");
		}
		inst.dpDiv[(numMonths[0] !== 1 || numMonths[1] !== 1 ? "add" : "remove") +
			"Class"]("ui-datepicker-multi");
		inst.dpDiv[(this._get(inst, "isRTL") ? "add" : "remove") +
			"Class"]("ui-datepicker-rtl");

		if (inst === $.datepicker._curInst && $.datepicker._datepickerShowing && $.datepicker._shouldFocusInput( inst ) ) {
			inst.input.focus();
		}

		// deffered render of the years select (to avoid flashes on Firefox)
		if( inst.yearshtml ){
			origyearshtml = inst.yearshtml;
			setTimeout(function(){
				//assure that inst.yearshtml didn't change.
				if( origyearshtml === inst.yearshtml && inst.yearshtml ){
					inst.dpDiv.find("select.ui-datepicker-year:first").replaceWith(inst.yearshtml);
				}
				origyearshtml = inst.yearshtml = null;
			}, 0);
		}
	},

	// #6694 - don't focus the input if it's already focused
	// this breaks the change event in IE
	// Support: IE and jQuery <1.9
	_shouldFocusInput: function( inst ) {
		return inst.input && inst.input.is( ":visible" ) && !inst.input.is( ":disabled" ) && !inst.input.is( ":focus" );
	},

	/* Check positioning to remain on screen. */
	_checkOffset: function(inst, offset, isFixed) {
		var dpWidth = inst.dpDiv.outerWidth(),
			dpHeight = inst.dpDiv.outerHeight(),
			inputWidth = inst.input ? inst.input.outerWidth() : 0,
			inputHeight = inst.input ? inst.input.outerHeight() : 0,
			viewWidth = document.documentElement.clientWidth + (isFixed ? 0 : $(document).scrollLeft()),
			viewHeight = document.documentElement.clientHeight + (isFixed ? 0 : $(document).scrollTop());

		offset.left -= (this._get(inst, "isRTL") ? (dpWidth - inputWidth) : 0);
		offset.left -= (isFixed && offset.left === inst.input.offset().left) ? $(document).scrollLeft() : 0;
		offset.top -= (isFixed && offset.top === (inst.input.offset().top + inputHeight)) ? $(document).scrollTop() : 0;

		// now check if datepicker is showing outside window viewport - move to a better place if so.
		offset.left -= Math.min(offset.left, (offset.left + dpWidth > viewWidth && viewWidth > dpWidth) ?
			Math.abs(offset.left + dpWidth - viewWidth) : 0);
		offset.top -= Math.min(offset.top, (offset.top + dpHeight > viewHeight && viewHeight > dpHeight) ?
			Math.abs(dpHeight + inputHeight) : 0);

		return offset;
	},

	/* Find an object's position on the screen. */
	_findPos: function(obj) {
		var position,
			inst = this._getInst(obj),
			isRTL = this._get(inst, "isRTL");

		while (obj && (obj.type === "hidden" || obj.nodeType !== 1 || $.expr.filters.hidden(obj))) {
			obj = obj[isRTL ? "previousSibling" : "nextSibling"];
		}

		position = $(obj).offset();
		return [position.left, position.top];
	},

	/* Hide the date picker from view.
	 * @param  input  element - the input field attached to the date picker
	 */
	_hideDatepicker: function(input) {
		var showAnim, duration, postProcess, onClose,
			inst = this._curInst;

		if (!inst || (input && inst !== $.data(input, PROP_NAME))) {
			return;
		}

		if (this._datepickerShowing) {
			showAnim = this._get(inst, "showAnim");
			duration = this._get(inst, "duration");
			postProcess = function() {
				$.datepicker._tidyDialog(inst);
			};

			// DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed
			if ( $.effects && ( $.effects.effect[ showAnim ] || $.effects[ showAnim ] ) ) {
				inst.dpDiv.hide(showAnim, $.datepicker._get(inst, "showOptions"), duration, postProcess);
			} else {
				inst.dpDiv[(showAnim === "slideDown" ? "slideUp" :
					(showAnim === "fadeIn" ? "fadeOut" : "hide"))]((showAnim ? duration : null), postProcess);
			}

			if (!showAnim) {
				postProcess();
			}
			this._datepickerShowing = false;

			onClose = this._get(inst, "onClose");
			if (onClose) {
				onClose.apply((inst.input ? inst.input[0] : null), [(inst.input ? inst.input.val() : ""), inst]);
			}

			this._lastInput = null;
			if (this._inDialog) {
				this._dialogInput.css({ position: "absolute", left: "0", top: "-100px" });
				if ($.blockUI) {
					$.unblockUI();
					$("body").append(this.dpDiv);
				}
			}
			this._inDialog = false;
		}
	},

	/* Tidy up after a dialog display. */
	_tidyDialog: function(inst) {
		inst.dpDiv.removeClass(this._dialogClass).unbind(".ui-datepicker-calendar");
	},

	/* Close date picker if clicked elsewhere. */
	_checkExternalClick: function(event) {
		if (!$.datepicker._curInst) {
			return;
		}

		var $target = $(event.target),
			inst = $.datepicker._getInst($target[0]);

		if ( ( ( $target[0].id !== $.datepicker._mainDivId &&
				$target.parents("#" + $.datepicker._mainDivId).length === 0 &&
				!$target.hasClass($.datepicker.markerClassName) &&
				!$target.closest("." + $.datepicker._triggerClass).length &&
				$.datepicker._datepickerShowing && !($.datepicker._inDialog && $.blockUI) ) ) ||
			( $target.hasClass($.datepicker.markerClassName) && $.datepicker._curInst !== inst ) ) {
				$.datepicker._hideDatepicker();
		}
	},

	/* Adjust one of the date sub-fields. */
	_adjustDate: function(id, offset, period) {
		var target = $(id),
			inst = this._getInst(target[0]);

		if (this._isDisabledDatepicker(target[0])) {
			return;
		}
		this._adjustInstDate(inst, offset +
			(period === "M" ? this._get(inst, "showCurrentAtPos") : 0), // undo positioning
			period);
		this._updateDatepicker(inst);
	},

	/* Action for current link. */
	_gotoToday: function(id) {
		var date,
			target = $(id),
			inst = this._getInst(target[0]);

		if (this._get(inst, "gotoCurrent") && inst.currentDay) {
			inst.selectedDay = inst.currentDay;
			inst.drawMonth = inst.selectedMonth = inst.currentMonth;
			inst.drawYear = inst.selectedYear = inst.currentYear;
		} else {
			date = new Date();
			inst.selectedDay = date.getDate();
			inst.drawMonth = inst.selectedMonth = date.getMonth();
			inst.drawYear = inst.selectedYear = date.getFullYear();
		}
		this._notifyChange(inst);
		this._adjustDate(target);
	},

	/* Action for selecting a new month/year. */
	_selectMonthYear: function(id, select, period) {
		var target = $(id),
			inst = this._getInst(target[0]);

		inst["selected" + (period === "M" ? "Month" : "Year")] =
		inst["draw" + (period === "M" ? "Month" : "Year")] =
			parseInt(select.options[select.selectedIndex].value,10);

		this._notifyChange(inst);
		this._adjustDate(target);
	},

	/* Action for selecting a day. */
	_selectDay: function(id, month, year, td) {
		var inst,
			target = $(id);

		if ($(td).hasClass(this._unselectableClass) || this._isDisabledDatepicker(target[0])) {
			return;
		}

		inst = this._getInst(target[0]);
		inst.selectedDay = inst.currentDay = $("a", td).html();
		inst.selectedMonth = inst.currentMonth = month;
		inst.selectedYear = inst.currentYear = year;
		this._selectDate(id, this._formatDate(inst,
			inst.currentDay, inst.currentMonth, inst.currentYear));
	},

	/* Erase the input field and hide the date picker. */
	_clearDate: function(id) {
		var target = $(id);
		this._selectDate(target, "");
	},

	/* Update the input field with the selected date. */
	_selectDate: function(id, dateStr) {
		var onSelect,
			target = $(id),
			inst = this._getInst(target[0]);

		dateStr = (dateStr != null ? dateStr : this._formatDate(inst));
		if (inst.input) {
			inst.input.val(dateStr);
		}
		this._updateAlternate(inst);

		onSelect = this._get(inst, "onSelect");
		if (onSelect) {
			onSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);  // trigger custom callback
		} else if (inst.input) {
			inst.input.trigger("change"); // fire the change event
		}

		if (inst.inline){
			this._updateDatepicker(inst);
		} else {
			this._hideDatepicker();
			this._lastInput = inst.input[0];
			if (typeof(inst.input[0]) !== "object") {
				inst.input.focus(); // restore focus
			}
			this._lastInput = null;
		}
	},

	/* Update any alternate field to synchronise with the main field. */
	_updateAlternate: function(inst) {
		var altFormat, date, dateStr,
			altField = this._get(inst, "altField");

		if (altField) { // update alternate field too
			altFormat = this._get(inst, "altFormat") || this._get(inst, "dateFormat");
			date = this._getDate(inst);
			dateStr = this.formatDate(altFormat, date, this._getFormatConfig(inst));
			$(altField).each(function() { $(this).val(dateStr); });
		}
	},

	/* Set as beforeShowDay function to prevent selection of weekends.
	 * @param  date  Date - the date to customise
	 * @return [boolean, string] - is this date selectable?, what is its CSS class?
	 */
	noWeekends: function(date) {
		var day = date.getDay();
		return [(day > 0 && day < 6), ""];
	},

	/* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.
	 * @param  date  Date - the date to get the week for
	 * @return  number - the number of the week within the year that contains this date
	 */
	iso8601Week: function(date) {
		var time,
			checkDate = new Date(date.getTime());

		// Find Thursday of this week starting on Monday
		checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7));

		time = checkDate.getTime();
		checkDate.setMonth(0); // Compare with Jan 1
		checkDate.setDate(1);
		return Math.floor(Math.round((time - checkDate) / 86400000) / 7) + 1;
	},

	/* Parse a string value into a date object.
	 * See formatDate below for the possible formats.
	 *
	 * @param  format string - the expected format of the date
	 * @param  value string - the date in the above format
	 * @param  settings Object - attributes include:
	 *					shortYearCutoff  number - the cutoff year for determining the century (optional)
	 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
	 *					dayNames		string[7] - names of the days from Sunday (optional)
	 *					monthNamesShort string[12] - abbreviated names of the months (optional)
	 *					monthNames		string[12] - names of the months (optional)
	 * @return  Date - the extracted date value or null if value is blank
	 */
	parseDate: function (format, value, settings) {
		if (format == null || value == null) {
			throw "Invalid arguments";
		}

		value = (typeof value === "object" ? value.toString() : value + "");
		if (value === "") {
			return null;
		}

		var iFormat, dim, extra,
			iValue = 0,
			shortYearCutoffTemp = (settings ? settings.shortYearCutoff : null) || this._defaults.shortYearCutoff,
			shortYearCutoff = (typeof shortYearCutoffTemp !== "string" ? shortYearCutoffTemp :
				new Date().getFullYear() % 100 + parseInt(shortYearCutoffTemp, 10)),
			dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort,
			dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames,
			monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort,
			monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames,
			year = -1,
			month = -1,
			day = -1,
			doy = -1,
			literal = false,
			date,
			// Check whether a format character is doubled
			lookAhead = function(match) {
				var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);
				if (matches) {
					iFormat++;
				}
				return matches;
			},
			// Extract a number from the string value
			getNumber = function(match) {
				var isDoubled = lookAhead(match),
					size = (match === "@" ? 14 : (match === "!" ? 20 :
					(match === "y" && isDoubled ? 4 : (match === "o" ? 3 : 2)))),
					digits = new RegExp("^\\d{1," + size + "}"),
					num = value.substring(iValue).match(digits);
				if (!num) {
					throw "Missing number at position " + iValue;
				}
				iValue += num[0].length;
				return parseInt(num[0], 10);
			},
			// Extract a name from the string value and convert to an index
			getName = function(match, shortNames, longNames) {
				var index = -1,
					names = $.map(lookAhead(match) ? longNames : shortNames, function (v, k) {
						return [ [k, v] ];
					}).sort(function (a, b) {
						return -(a[1].length - b[1].length);
					});

				$.each(names, function (i, pair) {
					var name = pair[1];
					if (value.substr(iValue, name.length).toLowerCase() === name.toLowerCase()) {
						index = pair[0];
						iValue += name.length;
						return false;
					}
				});
				if (index !== -1) {
					return index + 1;
				} else {
					throw "Unknown name at position " + iValue;
				}
			},
			// Confirm that a literal character matches the string value
			checkLiteral = function() {
				if (value.charAt(iValue) !== format.charAt(iFormat)) {
					throw "Unexpected literal at position " + iValue;
				}
				iValue++;
			};

		for (iFormat = 0; iFormat < format.length; iFormat++) {
			if (literal) {
				if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
					literal = false;
				} else {
					checkLiteral();
				}
			} else {
				switch (format.charAt(iFormat)) {
					case "d":
						day = getNumber("d");
						break;
					case "D":
						getName("D", dayNamesShort, dayNames);
						break;
					case "o":
						doy = getNumber("o");
						break;
					case "m":
						month = getNumber("m");
						break;
					case "M":
						month = getName("M", monthNamesShort, monthNames);
						break;
					case "y":
						year = getNumber("y");
						break;
					case "@":
						date = new Date(getNumber("@"));
						year = date.getFullYear();
						month = date.getMonth() + 1;
						day = date.getDate();
						break;
					case "!":
						date = new Date((getNumber("!") - this._ticksTo1970) / 10000);
						year = date.getFullYear();
						month = date.getMonth() + 1;
						day = date.getDate();
						break;
					case "'":
						if (lookAhead("'")){
							checkLiteral();
						} else {
							literal = true;
						}
						break;
					default:
						checkLiteral();
				}
			}
		}

		if (iValue < value.length){
			extra = value.substr(iValue);
			if (!/^\s+/.test(extra)) {
				throw "Extra/unparsed characters found in date: " + extra;
			}
		}

		if (year === -1) {
			year = new Date().getFullYear();
		} else if (year < 100) {
			year += new Date().getFullYear() - new Date().getFullYear() % 100 +
				(year <= shortYearCutoff ? 0 : -100);
		}

		if (doy > -1) {
			month = 1;
			day = doy;
			do {
				dim = this._getDaysInMonth(year, month - 1);
				if (day <= dim) {
					break;
				}
				month++;
				day -= dim;
			} while (true);
		}

		date = this._daylightSavingAdjust(new Date(year, month - 1, day));
		if (date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day) {
			throw "Invalid date"; // E.g. 31/02/00
		}
		return date;
	},

	/* Standard date formats. */
	ATOM: "yy-mm-dd", // RFC 3339 (ISO 8601)
	COOKIE: "D, dd M yy",
	ISO_8601: "yy-mm-dd",
	RFC_822: "D, d M y",
	RFC_850: "DD, dd-M-y",
	RFC_1036: "D, d M y",
	RFC_1123: "D, d M yy",
	RFC_2822: "D, d M yy",
	RSS: "D, d M y", // RFC 822
	TICKS: "!",
	TIMESTAMP: "@",
	W3C: "yy-mm-dd", // ISO 8601

	_ticksTo1970: (((1970 - 1) * 365 + Math.floor(1970 / 4) - Math.floor(1970 / 100) +
		Math.floor(1970 / 400)) * 24 * 60 * 60 * 10000000),

	/* Format a date object into a string value.
	 * The format can be combinations of the following:
	 * d  - day of month (no leading zero)
	 * dd - day of month (two digit)
	 * o  - day of year (no leading zeros)
	 * oo - day of year (three digit)
	 * D  - day name short
	 * DD - day name long
	 * m  - month of year (no leading zero)
	 * mm - month of year (two digit)
	 * M  - month name short
	 * MM - month name long
	 * y  - year (two digit)
	 * yy - year (four digit)
	 * @ - Unix timestamp (ms since 01/01/1970)
	 * ! - Windows ticks (100ns since 01/01/0001)
	 * "..." - literal text
	 * '' - single quote
	 *
	 * @param  format string - the desired format of the date
	 * @param  date Date - the date value to format
	 * @param  settings Object - attributes include:
	 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
	 *					dayNames		string[7] - names of the days from Sunday (optional)
	 *					monthNamesShort string[12] - abbreviated names of the months (optional)
	 *					monthNames		string[12] - names of the months (optional)
	 * @return  string - the date in the above format
	 */
	formatDate: function (format, date, settings) {
		if (!date) {
			return "";
		}

		var iFormat,
			dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort,
			dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames,
			monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort,
			monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames,
			// Check whether a format character is doubled
			lookAhead = function(match) {
				var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);
				if (matches) {
					iFormat++;
				}
				return matches;
			},
			// Format a number, with leading zero if necessary
			formatNumber = function(match, value, len) {
				var num = "" + value;
				if (lookAhead(match)) {
					while (num.length < len) {
						num = "0" + num;
					}
				}
				return num;
			},
			// Format a name, short or long as requested
			formatName = function(match, value, shortNames, longNames) {
				return (lookAhead(match) ? longNames[value] : shortNames[value]);
			},
			output = "",
			literal = false;

		if (date) {
			for (iFormat = 0; iFormat < format.length; iFormat++) {
				if (literal) {
					if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
						literal = false;
					} else {
						output += format.charAt(iFormat);
					}
				} else {
					switch (format.charAt(iFormat)) {
						case "d":
							output += formatNumber("d", date.getDate(), 2);
							break;
						case "D":
							output += formatName("D", date.getDay(), dayNamesShort, dayNames);
							break;
						case "o":
							output += formatNumber("o",
								Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 86400000), 3);
							break;
						case "m":
							output += formatNumber("m", date.getMonth() + 1, 2);
							break;
						case "M":
							output += formatName("M", date.getMonth(), monthNamesShort, monthNames);
							break;
						case "y":
							output += (lookAhead("y") ? date.getFullYear() :
								(date.getYear() % 100 < 10 ? "0" : "") + date.getYear() % 100);
							break;
						case "@":
							output += date.getTime();
							break;
						case "!":
							output += date.getTime() * 10000 + this._ticksTo1970;
							break;
						case "'":
							if (lookAhead("'")) {
								output += "'";
							} else {
								literal = true;
							}
							break;
						default:
							output += format.charAt(iFormat);
					}
				}
			}
		}
		return output;
	},

	/* Extract all possible characters from the date format. */
	_possibleChars: function (format) {
		var iFormat,
			chars = "",
			literal = false,
			// Check whether a format character is doubled
			lookAhead = function(match) {
				var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);
				if (matches) {
					iFormat++;
				}
				return matches;
			};

		for (iFormat = 0; iFormat < format.length; iFormat++) {
			if (literal) {
				if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
					literal = false;
				} else {
					chars += format.charAt(iFormat);
				}
			} else {
				switch (format.charAt(iFormat)) {
					case "d": case "m": case "y": case "@":
						chars += "0123456789";
						break;
					case "D": case "M":
						return null; // Accept anything
					case "'":
						if (lookAhead("'")) {
							chars += "'";
						} else {
							literal = true;
						}
						break;
					default:
						chars += format.charAt(iFormat);
				}
			}
		}
		return chars;
	},

	/* Get a setting value, defaulting if necessary. */
	_get: function(inst, name) {
		return inst.settings[name] !== undefined ?
			inst.settings[name] : this._defaults[name];
	},

	/* Parse existing date and initialise date picker. */
	_setDateFromField: function(inst, noDefault) {
		if (inst.input.val() === inst.lastVal) {
			return;
		}

		var dateFormat = this._get(inst, "dateFormat"),
			dates = inst.lastVal = inst.input ? inst.input.val() : null,
			defaultDate = this._getDefaultDate(inst),
			date = defaultDate,
			settings = this._getFormatConfig(inst);

		try {
			date = this.parseDate(dateFormat, dates, settings) || defaultDate;
		} catch (event) {
			dates = (noDefault ? "" : dates);
		}
		inst.selectedDay = date.getDate();
		inst.drawMonth = inst.selectedMonth = date.getMonth();
		inst.drawYear = inst.selectedYear = date.getFullYear();
		inst.currentDay = (dates ? date.getDate() : 0);
		inst.currentMonth = (dates ? date.getMonth() : 0);
		inst.currentYear = (dates ? date.getFullYear() : 0);
		this._adjustInstDate(inst);
	},

	/* Retrieve the default date shown on opening. */
	_getDefaultDate: function(inst) {
		return this._restrictMinMax(inst,
			this._determineDate(inst, this._get(inst, "defaultDate"), new Date()));
	},

	/* A date may be specified as an exact value or a relative one. */
	_determineDate: function(inst, date, defaultDate) {
		var offsetNumeric = function(offset) {
				var date = new Date();
				date.setDate(date.getDate() + offset);
				return date;
			},
			offsetString = function(offset) {
				try {
					return $.datepicker.parseDate($.datepicker._get(inst, "dateFormat"),
						offset, $.datepicker._getFormatConfig(inst));
				}
				catch (e) {
					// Ignore
				}

				var date = (offset.toLowerCase().match(/^c/) ?
					$.datepicker._getDate(inst) : null) || new Date(),
					year = date.getFullYear(),
					month = date.getMonth(),
					day = date.getDate(),
					pattern = /([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g,
					matches = pattern.exec(offset);

				while (matches) {
					switch (matches[2] || "d") {
						case "d" : case "D" :
							day += parseInt(matches[1],10); break;
						case "w" : case "W" :
							day += parseInt(matches[1],10) * 7; break;
						case "m" : case "M" :
							month += parseInt(matches[1],10);
							day = Math.min(day, $.datepicker._getDaysInMonth(year, month));
							break;
						case "y": case "Y" :
							year += parseInt(matches[1],10);
							day = Math.min(day, $.datepicker._getDaysInMonth(year, month));
							break;
					}
					matches = pattern.exec(offset);
				}
				return new Date(year, month, day);
			},
			newDate = (date == null || date === "" ? defaultDate : (typeof date === "string" ? offsetString(date) :
				(typeof date === "number" ? (isNaN(date) ? defaultDate : offsetNumeric(date)) : new Date(date.getTime()))));

		newDate = (newDate && newDate.toString() === "Invalid Date" ? defaultDate : newDate);
		if (newDate) {
			newDate.setHours(0);
			newDate.setMinutes(0);
			newDate.setSeconds(0);
			newDate.setMilliseconds(0);
		}
		return this._daylightSavingAdjust(newDate);
	},

	/* Handle switch to/from daylight saving.
	 * Hours may be non-zero on daylight saving cut-over:
	 * > 12 when midnight changeover, but then cannot generate
	 * midnight datetime, so jump to 1AM, otherwise reset.
	 * @param  date  (Date) the date to check
	 * @return  (Date) the corrected date
	 */
	_daylightSavingAdjust: function(date) {
		if (!date) {
			return null;
		}
		date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0);
		return date;
	},

	/* Set the date(s) directly. */
	_setDate: function(inst, date, noChange) {
		var clear = !date,
			origMonth = inst.selectedMonth,
			origYear = inst.selectedYear,
			newDate = this._restrictMinMax(inst, this._determineDate(inst, date, new Date()));

		inst.selectedDay = inst.currentDay = newDate.getDate();
		inst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth();
		inst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear();
		if ((origMonth !== inst.selectedMonth || origYear !== inst.selectedYear) && !noChange) {
			this._notifyChange(inst);
		}
		this._adjustInstDate(inst);
		if (inst.input) {
			inst.input.val(clear ? "" : this._formatDate(inst));
		}
	},

	/* Retrieve the date(s) directly. */
	_getDate: function(inst) {
		var startDate = (!inst.currentYear || (inst.input && inst.input.val() === "") ? null :
			this._daylightSavingAdjust(new Date(
			inst.currentYear, inst.currentMonth, inst.currentDay)));
			return startDate;
	},

	/* Attach the onxxx handlers.  These are declared statically so
	 * they work with static code transformers like Caja.
	 */
	_attachHandlers: function(inst) {
		var stepMonths = this._get(inst, "stepMonths"),
			id = "#" + inst.id.replace( /\\\\/g, "\\" );
		inst.dpDiv.find("[data-handler]").map(function () {
			var handler = {
				prev: function () {
					$.datepicker._adjustDate(id, -stepMonths, "M");
				},
				next: function () {
					$.datepicker._adjustDate(id, +stepMonths, "M");
				},
				hide: function () {
					$.datepicker._hideDatepicker();
				},
				today: function () {
					$.datepicker._gotoToday(id);
				},
				selectDay: function () {
					$.datepicker._selectDay(id, +this.getAttribute("data-month"), +this.getAttribute("data-year"), this);
					return false;
				},
				selectMonth: function () {
					$.datepicker._selectMonthYear(id, this, "M");
					return false;
				},
				selectYear: function () {
					$.datepicker._selectMonthYear(id, this, "Y");
					return false;
				}
			};
			$(this).bind(this.getAttribute("data-event"), handler[this.getAttribute("data-handler")]);
		});
	},

	/* Generate the HTML for the current state of the date picker. */
	_generateHTML: function(inst) {
		var maxDraw, prevText, prev, nextText, next, currentText, gotoDate,
			controls, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin,
			monthNames, monthNamesShort, beforeShowDay, showOtherMonths,
			selectOtherMonths, defaultDate, html, dow, row, group, col, selectedDate,
			cornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows,
			printDate, dRow, tbody, daySettings, otherMonth, unselectable,
			tempDate = new Date(),
			today = this._daylightSavingAdjust(
				new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate())), // clear time
			isRTL = this._get(inst, "isRTL"),
			showButtonPanel = this._get(inst, "showButtonPanel"),
			hideIfNoPrevNext = this._get(inst, "hideIfNoPrevNext"),
			navigationAsDateFormat = this._get(inst, "navigationAsDateFormat"),
			numMonths = this._getNumberOfMonths(inst),
			showCurrentAtPos = this._get(inst, "showCurrentAtPos"),
			stepMonths = this._get(inst, "stepMonths"),
			isMultiMonth = (numMonths[0] !== 1 || numMonths[1] !== 1),
			currentDate = this._daylightSavingAdjust((!inst.currentDay ? new Date(9999, 9, 9) :
				new Date(inst.currentYear, inst.currentMonth, inst.currentDay))),
			minDate = this._getMinMaxDate(inst, "min"),
			maxDate = this._getMinMaxDate(inst, "max"),
			drawMonth = inst.drawMonth - showCurrentAtPos,
			drawYear = inst.drawYear;

		if (drawMonth < 0) {
			drawMonth += 12;
			drawYear--;
		}
		if (maxDate) {
			maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(),
				maxDate.getMonth() - (numMonths[0] * numMonths[1]) + 1, maxDate.getDate()));
			maxDraw = (minDate && maxDraw < minDate ? minDate : maxDraw);
			while (this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw) {
				drawMonth--;
				if (drawMonth < 0) {
					drawMonth = 11;
					drawYear--;
				}
			}
		}
		inst.drawMonth = drawMonth;
		inst.drawYear = drawYear;

		prevText = this._get(inst, "prevText");
		prevText = (!navigationAsDateFormat ? prevText : this.formatDate(prevText,
			this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),
			this._getFormatConfig(inst)));

		prev = (this._canAdjustMonth(inst, -1, drawYear, drawMonth) ?
			"<a class='ui-datepicker-prev ui-corner-all' data-handler='prev' data-event='click'" +
			" title='" + prevText + "'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "e" : "w") + "'>" + prevText + "</span></a>" :
			(hideIfNoPrevNext ? "" : "<a class='ui-datepicker-prev ui-corner-all ui-state-disabled' title='"+ prevText +"'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "e" : "w") + "'>" + prevText + "</span></a>"));

		nextText = this._get(inst, "nextText");
		nextText = (!navigationAsDateFormat ? nextText : this.formatDate(nextText,
			this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),
			this._getFormatConfig(inst)));

		next = (this._canAdjustMonth(inst, +1, drawYear, drawMonth) ?
			"<a class='ui-datepicker-next ui-corner-all' data-handler='next' data-event='click'" +
			" title='" + nextText + "'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "w" : "e") + "'>" + nextText + "</span></a>" :
			(hideIfNoPrevNext ? "" : "<a class='ui-datepicker-next ui-corner-all ui-state-disabled' title='"+ nextText + "'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "w" : "e") + "'>" + nextText + "</span></a>"));

		currentText = this._get(inst, "currentText");
		gotoDate = (this._get(inst, "gotoCurrent") && inst.currentDay ? currentDate : today);
		currentText = (!navigationAsDateFormat ? currentText :
			this.formatDate(currentText, gotoDate, this._getFormatConfig(inst)));

		controls = (!inst.inline ? "<button type='button' class='ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all' data-handler='hide' data-event='click'>" +
			this._get(inst, "closeText") + "</button>" : "");

		buttonPanel = (showButtonPanel) ? "<div class='ui-datepicker-buttonpane ui-widget-content'>" + (isRTL ? controls : "") +
			(this._isInRange(inst, gotoDate) ? "<button type='button' class='ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all' data-handler='today' data-event='click'" +
			">" + currentText + "</button>" : "") + (isRTL ? "" : controls) + "</div>" : "";

		firstDay = parseInt(this._get(inst, "firstDay"),10);
		firstDay = (isNaN(firstDay) ? 0 : firstDay);

		showWeek = this._get(inst, "showWeek");
		dayNames = this._get(inst, "dayNames");
		dayNamesMin = this._get(inst, "dayNamesMin");
		monthNames = this._get(inst, "monthNames");
		monthNamesShort = this._get(inst, "monthNamesShort");
		beforeShowDay = this._get(inst, "beforeShowDay");
		showOtherMonths = this._get(inst, "showOtherMonths");
		selectOtherMonths = this._get(inst, "selectOtherMonths");
		defaultDate = this._getDefaultDate(inst);
		html = "";
		dow;
		for (row = 0; row < numMonths[0]; row++) {
			group = "";
			this.maxRows = 4;
			for (col = 0; col < numMonths[1]; col++) {
				selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay));
				cornerClass = " ui-corner-all";
				calender = "";
				if (isMultiMonth) {
					calender += "<div class='ui-datepicker-group";
					if (numMonths[1] > 1) {
						switch (col) {
							case 0: calender += " ui-datepicker-group-first";
								cornerClass = " ui-corner-" + (isRTL ? "right" : "left"); break;
							case numMonths[1]-1: calender += " ui-datepicker-group-last";
								cornerClass = " ui-corner-" + (isRTL ? "left" : "right"); break;
							default: calender += " ui-datepicker-group-middle"; cornerClass = ""; break;
						}
					}
					calender += "'>";
				}
				calender += "<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix" + cornerClass + "'>" +
					(/all|left/.test(cornerClass) && row === 0 ? (isRTL ? next : prev) : "") +
					(/all|right/.test(cornerClass) && row === 0 ? (isRTL ? prev : next) : "") +
					this._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate,
					row > 0 || col > 0, monthNames, monthNamesShort) + // draw month headers
					"</div><table class='ui-datepicker-calendar'><thead>" +
					"<tr>";
				thead = (showWeek ? "<th class='ui-datepicker-week-col'>" + this._get(inst, "weekHeader") + "</th>" : "");
				for (dow = 0; dow < 7; dow++) { // days of the week
					day = (dow + firstDay) % 7;
					thead += "<th" + ((dow + firstDay + 6) % 7 >= 5 ? " class='ui-datepicker-week-end'" : "") + ">" +
						"<span title='" + dayNames[day] + "'>" + dayNamesMin[day] + "</span></th>";
				}
				calender += thead + "</tr></thead><tbody>";
				daysInMonth = this._getDaysInMonth(drawYear, drawMonth);
				if (drawYear === inst.selectedYear && drawMonth === inst.selectedMonth) {
					inst.selectedDay = Math.min(inst.selectedDay, daysInMonth);
				}
				leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7;
				curRows = Math.ceil((leadDays + daysInMonth) / 7); // calculate the number of rows to generate
				numRows = (isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows); //If multiple months, use the higher number of rows (see #7043)
				this.maxRows = numRows;
				printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays));
				for (dRow = 0; dRow < numRows; dRow++) { // create date picker rows
					calender += "<tr>";
					tbody = (!showWeek ? "" : "<td class='ui-datepicker-week-col'>" +
						this._get(inst, "calculateWeek")(printDate) + "</td>");
					for (dow = 0; dow < 7; dow++) { // create date picker days
						daySettings = (beforeShowDay ?
							beforeShowDay.apply((inst.input ? inst.input[0] : null), [printDate]) : [true, ""]);
						otherMonth = (printDate.getMonth() !== drawMonth);
						unselectable = (otherMonth && !selectOtherMonths) || !daySettings[0] ||
							(minDate && printDate < minDate) || (maxDate && printDate > maxDate);
						tbody += "<td class='" +
							((dow + firstDay + 6) % 7 >= 5 ? " ui-datepicker-week-end" : "") + // highlight weekends
							(otherMonth ? " ui-datepicker-other-month" : "") + // highlight days from other months
							((printDate.getTime() === selectedDate.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent) || // user pressed key
							(defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate.getTime()) ?
							// or defaultDate is current printedDate and defaultDate is selectedDate
							" " + this._dayOverClass : "") + // highlight selected day
							(unselectable ? " " + this._unselectableClass + " ui-state-disabled": "") +  // highlight unselectable days
							(otherMonth && !showOtherMonths ? "" : " " + daySettings[1] + // highlight custom dates
							(printDate.getTime() === currentDate.getTime() ? " " + this._currentClass : "") + // highlight selected day
							(printDate.getTime() === today.getTime() ? " ui-datepicker-today" : "")) + "'" + // highlight today (if different)
							((!otherMonth || showOtherMonths) && daySettings[2] ? " title='" + daySettings[2].replace(/'/g, "&#39;") + "'" : "") + // cell title
							(unselectable ? "" : " data-handler='selectDay' data-event='click' data-month='" + printDate.getMonth() + "' data-year='" + printDate.getFullYear() + "'") + ">" + // actions
							(otherMonth && !showOtherMonths ? "&#xa0;" : // display for other months
							(unselectable ? "<span class='ui-state-default'>" + printDate.getDate() + "</span>" : "<a class='ui-state-default" +
							(printDate.getTime() === today.getTime() ? " ui-state-highlight" : "") +
							(printDate.getTime() === currentDate.getTime() ? " ui-state-active" : "") + // highlight selected day
							(otherMonth ? " ui-priority-secondary" : "") + // distinguish dates from other months
							"' href='#'>" + printDate.getDate() + "</a>")) + "</td>"; // display selectable date
						printDate.setDate(printDate.getDate() + 1);
						printDate = this._daylightSavingAdjust(printDate);
					}
					calender += tbody + "</tr>";
				}
				drawMonth++;
				if (drawMonth > 11) {
					drawMonth = 0;
					drawYear++;
				}
				calender += "</tbody></table>" + (isMultiMonth ? "</div>" +
							((numMonths[0] > 0 && col === numMonths[1]-1) ? "<div class='ui-datepicker-row-break'></div>" : "") : "");
				group += calender;
			}
			html += group;
		}
		html += buttonPanel;
		inst._keyEvent = false;
		return html;
	},

	/* Generate the month and year header. */
	_generateMonthYearHeader: function(inst, drawMonth, drawYear, minDate, maxDate,
			secondary, monthNames, monthNamesShort) {

		var inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear,
			changeMonth = this._get(inst, "changeMonth"),
			changeYear = this._get(inst, "changeYear"),
			showMonthAfterYear = this._get(inst, "showMonthAfterYear"),
			html = "<div class='ui-datepicker-title'>",
			monthHtml = "";

		// month selection
		if (secondary || !changeMonth) {
			monthHtml += "<span class='ui-datepicker-month'>" + monthNames[drawMonth] + "</span>";
		} else {
			inMinYear = (minDate && minDate.getFullYear() === drawYear);
			inMaxYear = (maxDate && maxDate.getFullYear() === drawYear);
			monthHtml += "<select class='ui-datepicker-month' data-handler='selectMonth' data-event='change'>";
			for ( month = 0; month < 12; month++) {
				if ((!inMinYear || month >= minDate.getMonth()) && (!inMaxYear || month <= maxDate.getMonth())) {
					monthHtml += "<option value='" + month + "'" +
						(month === drawMonth ? " selected='selected'" : "") +
						">" + monthNamesShort[month] + "</option>";
				}
			}
			monthHtml += "</select>";
		}

		if (!showMonthAfterYear) {
			html += monthHtml + (secondary || !(changeMonth && changeYear) ? "&#xa0;" : "");
		}

		// year selection
		if ( !inst.yearshtml ) {
			inst.yearshtml = "";
			if (secondary || !changeYear) {
				html += "<span class='ui-datepicker-year'>" + drawYear + "</span>";
			} else {
				// determine range of years to display
				years = this._get(inst, "yearRange").split(":");
				thisYear = new Date().getFullYear();
				determineYear = function(value) {
					var year = (value.match(/c[+\-].*/) ? drawYear + parseInt(value.substring(1), 10) :
						(value.match(/[+\-].*/) ? thisYear + parseInt(value, 10) :
						parseInt(value, 10)));
					return (isNaN(year) ? thisYear : year);
				};
				year = determineYear(years[0]);
				endYear = Math.max(year, determineYear(years[1] || ""));
				year = (minDate ? Math.max(year, minDate.getFullYear()) : year);
				endYear = (maxDate ? Math.min(endYear, maxDate.getFullYear()) : endYear);
				inst.yearshtml += "<select class='ui-datepicker-year' data-handler='selectYear' data-event='change'>";
				for (; year <= endYear; year++) {
					inst.yearshtml += "<option value='" + year + "'" +
						(year === drawYear ? " selected='selected'" : "") +
						">" + year + "</option>";
				}
				inst.yearshtml += "</select>";

				html += inst.yearshtml;
				inst.yearshtml = null;
			}
		}

		html += this._get(inst, "yearSuffix");
		if (showMonthAfterYear) {
			html += (secondary || !(changeMonth && changeYear) ? "&#xa0;" : "") + monthHtml;
		}
		html += "</div>"; // Close datepicker_header
		return html;
	},

	/* Adjust one of the date sub-fields. */
	_adjustInstDate: function(inst, offset, period) {
		var year = inst.drawYear + (period === "Y" ? offset : 0),
			month = inst.drawMonth + (period === "M" ? offset : 0),
			day = Math.min(inst.selectedDay, this._getDaysInMonth(year, month)) + (period === "D" ? offset : 0),
			date = this._restrictMinMax(inst, this._daylightSavingAdjust(new Date(year, month, day)));

		inst.selectedDay = date.getDate();
		inst.drawMonth = inst.selectedMonth = date.getMonth();
		inst.drawYear = inst.selectedYear = date.getFullYear();
		if (period === "M" || period === "Y") {
			this._notifyChange(inst);
		}
	},

	/* Ensure a date is within any min/max bounds. */
	_restrictMinMax: function(inst, date) {
		var minDate = this._getMinMaxDate(inst, "min"),
			maxDate = this._getMinMaxDate(inst, "max"),
			newDate = (minDate && date < minDate ? minDate : date);
		return (maxDate && newDate > maxDate ? maxDate : newDate);
	},

	/* Notify change of month/year. */
	_notifyChange: function(inst) {
		var onChange = this._get(inst, "onChangeMonthYear");
		if (onChange) {
			onChange.apply((inst.input ? inst.input[0] : null),
				[inst.selectedYear, inst.selectedMonth + 1, inst]);
		}
	},

	/* Determine the number of months to show. */
	_getNumberOfMonths: function(inst) {
		var numMonths = this._get(inst, "numberOfMonths");
		return (numMonths == null ? [1, 1] : (typeof numMonths === "number" ? [1, numMonths] : numMonths));
	},

	/* Determine the current maximum date - ensure no time components are set. */
	_getMinMaxDate: function(inst, minMax) {
		return this._determineDate(inst, this._get(inst, minMax + "Date"), null);
	},

	/* Find the number of days in a given month. */
	_getDaysInMonth: function(year, month) {
		return 32 - this._daylightSavingAdjust(new Date(year, month, 32)).getDate();
	},

	/* Find the day of the week of the first of a month. */
	_getFirstDayOfMonth: function(year, month) {
		return new Date(year, month, 1).getDay();
	},

	/* Determines if we should allow a "next/prev" month display change. */
	_canAdjustMonth: function(inst, offset, curYear, curMonth) {
		var numMonths = this._getNumberOfMonths(inst),
			date = this._daylightSavingAdjust(new Date(curYear,
			curMonth + (offset < 0 ? offset : numMonths[0] * numMonths[1]), 1));

		if (offset < 0) {
			date.setDate(this._getDaysInMonth(date.getFullYear(), date.getMonth()));
		}
		return this._isInRange(inst, date);
	},

	/* Is the given date in the accepted range? */
	_isInRange: function(inst, date) {
		var yearSplit, currentYear,
			minDate = this._getMinMaxDate(inst, "min"),
			maxDate = this._getMinMaxDate(inst, "max"),
			minYear = null,
			maxYear = null,
			years = this._get(inst, "yearRange");
			if (years){
				yearSplit = years.split(":");
				currentYear = new Date().getFullYear();
				minYear = parseInt(yearSplit[0], 10);
				maxYear = parseInt(yearSplit[1], 10);
				if ( yearSplit[0].match(/[+\-].*/) ) {
					minYear += currentYear;
				}
				if ( yearSplit[1].match(/[+\-].*/) ) {
					maxYear += currentYear;
				}
			}

		return ((!minDate || date.getTime() >= minDate.getTime()) &&
			(!maxDate || date.getTime() <= maxDate.getTime()) &&
			(!minYear || date.getFullYear() >= minYear) &&
			(!maxYear || date.getFullYear() <= maxYear));
	},

	/* Provide the configuration settings for formatting/parsing. */
	_getFormatConfig: function(inst) {
		var shortYearCutoff = this._get(inst, "shortYearCutoff");
		shortYearCutoff = (typeof shortYearCutoff !== "string" ? shortYearCutoff :
			new Date().getFullYear() % 100 + parseInt(shortYearCutoff, 10));
		return {shortYearCutoff: shortYearCutoff,
			dayNamesShort: this._get(inst, "dayNamesShort"), dayNames: this._get(inst, "dayNames"),
			monthNamesShort: this._get(inst, "monthNamesShort"), monthNames: this._get(inst, "monthNames")};
	},

	/* Format the given date for display. */
	_formatDate: function(inst, day, month, year) {
		if (!day) {
			inst.currentDay = inst.selectedDay;
			inst.currentMonth = inst.selectedMonth;
			inst.currentYear = inst.selectedYear;
		}
		var date = (day ? (typeof day === "object" ? day :
			this._daylightSavingAdjust(new Date(year, month, day))) :
			this._daylightSavingAdjust(new Date(inst.currentYear, inst.currentMonth, inst.currentDay)));
		return this.formatDate(this._get(inst, "dateFormat"), date, this._getFormatConfig(inst));
	}
});

/*
 * Bind hover events for datepicker elements.
 * Done via delegate so the binding only occurs once in the lifetime of the parent div.
 * Global instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.
 */
function bindHover(dpDiv) {
	var selector = "button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";
	return dpDiv.delegate(selector, "mouseout", function() {
			$(this).removeClass("ui-state-hover");
			if (this.className.indexOf("ui-datepicker-prev") !== -1) {
				$(this).removeClass("ui-datepicker-prev-hover");
			}
			if (this.className.indexOf("ui-datepicker-next") !== -1) {
				$(this).removeClass("ui-datepicker-next-hover");
			}
		})
		.delegate(selector, "mouseover", function(){
			if (!$.datepicker._isDisabledDatepicker( instActive.inline ? dpDiv.parent()[0] : instActive.input[0])) {
				$(this).parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover");
				$(this).addClass("ui-state-hover");
				if (this.className.indexOf("ui-datepicker-prev") !== -1) {
					$(this).addClass("ui-datepicker-prev-hover");
				}
				if (this.className.indexOf("ui-datepicker-next") !== -1) {
					$(this).addClass("ui-datepicker-next-hover");
				}
			}
		});
}

/* jQuery extend now ignores nulls! */
function extendRemove(target, props) {
	$.extend(target, props);
	for (var name in props) {
		if (props[name] == null) {
			target[name] = props[name];
		}
	}
	return target;
}

/* Invoke the datepicker functionality.
   @param  options  string - a command, optionally followed by additional parameters or
					Object - settings for attaching new datepicker functionality
   @return  jQuery object */
$.fn.datepicker = function(options){

	/* Verify an empty collection wasn't passed - Fixes #6976 */
	if ( !this.length ) {
		return this;
	}

	/* Initialise the date picker. */
	if (!$.datepicker.initialized) {
		$(document).mousedown($.datepicker._checkExternalClick);
		$.datepicker.initialized = true;
	}

	/* Append datepicker main container to body if not exist. */
	if ($("#"+$.datepicker._mainDivId).length === 0) {
		$("body").append($.datepicker.dpDiv);
	}

	var otherArgs = Array.prototype.slice.call(arguments, 1);
	if (typeof options === "string" && (options === "isDisabled" || options === "getDate" || options === "widget")) {
		return $.datepicker["_" + options + "Datepicker"].
			apply($.datepicker, [this[0]].concat(otherArgs));
	}
	if (options === "option" && arguments.length === 2 && typeof arguments[1] === "string") {
		return $.datepicker["_" + options + "Datepicker"].
			apply($.datepicker, [this[0]].concat(otherArgs));
	}
	return this.each(function() {
		typeof options === "string" ?
			$.datepicker["_" + options + "Datepicker"].
				apply($.datepicker, [this].concat(otherArgs)) :
			$.datepicker._attachDatepicker(this, options);
	});
};

$.datepicker = new Datepicker(); // singleton instance
$.datepicker.initialized = false;
$.datepicker.uuid = new Date().getTime();
$.datepicker.version = "1.10.4";

})(jQuery);
/*!
 * jQuery UI Position 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/position/
 */
(function( $, undefined ) {

$.ui = $.ui || {};

var cachedScrollbarWidth,
	max = Math.max,
	abs = Math.abs,
	round = Math.round,
	rhorizontal = /left|center|right/,
	rvertical = /top|center|bottom/,
	roffset = /[\+\-]\d+(\.[\d]+)?%?/,
	rposition = /^\w+/,
	rpercent = /%$/,
	_position = $.fn.position;

function getOffsets( offsets, width, height ) {
	return [
		parseFloat( offsets[ 0 ] ) * ( rpercent.test( offsets[ 0 ] ) ? width / 100 : 1 ),
		parseFloat( offsets[ 1 ] ) * ( rpercent.test( offsets[ 1 ] ) ? height / 100 : 1 )
	];
}

function parseCss( element, property ) {
	return parseInt( $.css( element, property ), 10 ) || 0;
}

function getDimensions( elem ) {
	var raw = elem[0];
	if ( raw.nodeType === 9 ) {
		return {
			width: elem.width(),
			height: elem.height(),
			offset: { top: 0, left: 0 }
		};
	}
	if ( $.isWindow( raw ) ) {
		return {
			width: elem.width(),
			height: elem.height(),
			offset: { top: elem.scrollTop(), left: elem.scrollLeft() }
		};
	}
	if ( raw.preventDefault ) {
		return {
			width: 0,
			height: 0,
			offset: { top: raw.pageY, left: raw.pageX }
		};
	}
	// ##### BEGIN: MODIFIED BY SAP
	// When positioning around SVG elements, method getBoundingClientRect should be used
	if (typeof window.SVGElement !== "undefined" && raw instanceof window.SVGElement) {
		var boundingClientRect = raw.getBoundingClientRect();

		return {
			width: boundingClientRect.width,
			height: boundingClientRect.height,
			offset: elem.offset()
		};
	}
	// ##### END: MODIFIED BY SAP
	return {
		width: elem.outerWidth(),
		height: elem.outerHeight(),
		offset: elem.offset()
	};
}

$.position = {
	scrollbarWidth: function() {
		if ( cachedScrollbarWidth !== undefined ) {
			return cachedScrollbarWidth;
		}
		var w1, w2,
			div = $( "<div style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>" ),
			innerDiv = div.children()[0];

		$( "body" ).append( div );
		w1 = innerDiv.offsetWidth;
		div.css( "overflow", "scroll" );

		w2 = innerDiv.offsetWidth;

		if ( w1 === w2 ) {
			w2 = div[0].clientWidth;
		}

		div.remove();

		return (cachedScrollbarWidth = w1 - w2);
	},
	getScrollInfo: function( within ) {
		var overflowX = within.isWindow || within.isDocument ? "" :
				within.element.css( "overflow-x" ),
			overflowY = within.isWindow || within.isDocument ? "" :
				within.element.css( "overflow-y" ),
			hasOverflowX = overflowX === "scroll" ||
				( overflowX === "auto" && within.width < within.element[0].scrollWidth ),
			hasOverflowY = overflowY === "scroll" ||
				( overflowY === "auto" && within.height < within.element[0].scrollHeight );
		return {
			width: hasOverflowY ? $.position.scrollbarWidth() : 0,
			height: hasOverflowX ? $.position.scrollbarWidth() : 0
		};
	},
	getWithinInfo: function( element ) {
		var withinElement = $( element || window ),
			isWindow = $.isWindow( withinElement[0] ),
			isDocument = !!withinElement[ 0 ] && withinElement[ 0 ].nodeType === 9;
		return {
			element: withinElement,
			isWindow: isWindow,
			isDocument: isDocument,
			offset: withinElement.offset() || { left: 0, top: 0 },
			scrollLeft: withinElement.scrollLeft(),
			scrollTop: withinElement.scrollTop(),
			width: isWindow ? withinElement.width() : withinElement.outerWidth(),
			height: isWindow ? withinElement.height() : withinElement.outerHeight()
		};
	}
};

$.fn.position = function( options ) {
	if ( !options || !options.of ) {
		return _position.apply( this, arguments );
	}

	// make a copy, we don't want to modify arguments
	options = $.extend( {}, options );

	var atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions,
		target = $( options.of ),
		within = $.position.getWithinInfo( options.within ),
		scrollInfo = $.position.getScrollInfo( within ),
		collision = ( options.collision || "flip" ).split( " " ),
		offsets = {};

	dimensions = getDimensions( target );
	if ( target[0].preventDefault ) {
		// force left top to allow flipping
		options.at = "left top";
	}
	targetWidth = dimensions.width;
	targetHeight = dimensions.height;
	targetOffset = dimensions.offset;
	// clone to reuse original targetOffset later
	basePosition = $.extend( {}, targetOffset );

	// force my and at to have valid horizontal and vertical positions
	// if a value is missing or invalid, it will be converted to center
	$.each( [ "my", "at" ], function() {
		var pos = ( options[ this ] || "" ).split( " " ),
			horizontalOffset,
			verticalOffset;

		if ( pos.length === 1) {
			pos = rhorizontal.test( pos[ 0 ] ) ?
				pos.concat( [ "center" ] ) :
				rvertical.test( pos[ 0 ] ) ?
					[ "center" ].concat( pos ) :
					[ "center", "center" ];
		}
		pos[ 0 ] = rhorizontal.test( pos[ 0 ] ) ? pos[ 0 ] : "center";
		pos[ 1 ] = rvertical.test( pos[ 1 ] ) ? pos[ 1 ] : "center";

		// calculate offsets
		horizontalOffset = roffset.exec( pos[ 0 ] );
		verticalOffset = roffset.exec( pos[ 1 ] );
		offsets[ this ] = [
			horizontalOffset ? horizontalOffset[ 0 ] : 0,
			verticalOffset ? verticalOffset[ 0 ] : 0
		];

		// reduce to just the positions without the offsets
		options[ this ] = [
			rposition.exec( pos[ 0 ] )[ 0 ],
			rposition.exec( pos[ 1 ] )[ 0 ]
		];
	});

	// normalize collision option
	if ( collision.length === 1 ) {
		collision[ 1 ] = collision[ 0 ];
	}

	if ( options.at[ 0 ] === "right" ) {
		basePosition.left += targetWidth;
	} else if ( options.at[ 0 ] === "center" ) {
		basePosition.left += targetWidth / 2;
	}

	if ( options.at[ 1 ] === "bottom" ) {
		basePosition.top += targetHeight;
	} else if ( options.at[ 1 ] === "center" ) {
		basePosition.top += targetHeight / 2;
	}

	atOffset = getOffsets( offsets.at, targetWidth, targetHeight );
	basePosition.left += atOffset[ 0 ];
	basePosition.top += atOffset[ 1 ];

	return this.each(function() {
		var collisionPosition, using,
			elem = $( this ),
			elemWidth = elem.outerWidth(),
			elemHeight = elem.outerHeight(),
			marginLeft = parseCss( this, "marginLeft" ),
			marginTop = parseCss( this, "marginTop" ),
			collisionWidth = elemWidth + marginLeft + parseCss( this, "marginRight" ) + scrollInfo.width,
			collisionHeight = elemHeight + marginTop + parseCss( this, "marginBottom" ) + scrollInfo.height,
			position = $.extend( {}, basePosition ),
			myOffset = getOffsets( offsets.my, elem.outerWidth(), elem.outerHeight() );

		if ( options.my[ 0 ] === "right" ) {
			position.left -= elemWidth;
		} else if ( options.my[ 0 ] === "center" ) {
			position.left -= elemWidth / 2;
		}

		if ( options.my[ 1 ] === "bottom" ) {
			position.top -= elemHeight;
		} else if ( options.my[ 1 ] === "center" ) {
			position.top -= elemHeight / 2;
		}

		position.left += myOffset[ 0 ];
		position.top += myOffset[ 1 ];

		// if the browser doesn't support fractions, then round for consistent results
		if ( !$.support.offsetFractions ) {
			position.left = round( position.left );
			position.top = round( position.top );
		}

		collisionPosition = {
			marginLeft: marginLeft,
			marginTop: marginTop
		};

		$.each( [ "left", "top" ], function( i, dir ) {
			if ( $.ui.position[ collision[ i ] ] ) {
				$.ui.position[ collision[ i ] ][ dir ]( position, {
					targetWidth: targetWidth,
					targetHeight: targetHeight,
					elemWidth: elemWidth,
					elemHeight: elemHeight,
					collisionPosition: collisionPosition,
					collisionWidth: collisionWidth,
					collisionHeight: collisionHeight,
					offset: [ atOffset[ 0 ] + myOffset[ 0 ], atOffset [ 1 ] + myOffset[ 1 ] ],
					my: options.my,
					at: options.at,
					within: within,
					elem : elem
				});
			}
		});

		if ( options.using ) {
			// adds feedback as second argument to using callback, if present
			using = function( props ) {
				var left = targetOffset.left - position.left,
					right = left + targetWidth - elemWidth,
					top = targetOffset.top - position.top,
					bottom = top + targetHeight - elemHeight,
					feedback = {
						target: {
							element: target,
							left: targetOffset.left,
							top: targetOffset.top,
							width: targetWidth,
							height: targetHeight
						},
						element: {
							element: elem,
							left: position.left,
							top: position.top,
							width: elemWidth,
							height: elemHeight
						},
						horizontal: right < 0 ? "left" : left > 0 ? "right" : "center",
						vertical: bottom < 0 ? "top" : top > 0 ? "bottom" : "middle"
					};
				if ( targetWidth < elemWidth && abs( left + right ) < targetWidth ) {
					feedback.horizontal = "center";
				}
				if ( targetHeight < elemHeight && abs( top + bottom ) < targetHeight ) {
					feedback.vertical = "middle";
				}
				if ( max( abs( left ), abs( right ) ) > max( abs( top ), abs( bottom ) ) ) {
					feedback.important = "horizontal";
				} else {
					feedback.important = "vertical";
				}
				options.using.call( this, props, feedback );
			};
		}

		elem.offset( $.extend( position, { using: using } ) );
	});
};

$.ui.position = {
	fit: {
		left: function( position, data ) {
			var within = data.within,
				withinOffset = within.isWindow ? within.scrollLeft : within.offset.left,
				outerWidth = within.width,
				collisionPosLeft = position.left - data.collisionPosition.marginLeft,
				overLeft = withinOffset - collisionPosLeft,
				overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,
				newOverRight;

			// element is wider than within
			if ( data.collisionWidth > outerWidth ) {
				// element is initially over the left side of within
				if ( overLeft > 0 && overRight <= 0 ) {
					newOverRight = position.left + overLeft + data.collisionWidth - outerWidth - withinOffset;
					position.left += overLeft - newOverRight;
				// element is initially over right side of within
				} else if ( overRight > 0 && overLeft <= 0 ) {
					position.left = withinOffset;
				// element is initially over both left and right sides of within
				} else {
					if ( overLeft > overRight ) {
						position.left = withinOffset + outerWidth - data.collisionWidth;
					} else {
						position.left = withinOffset;
					}
				}
			// too far left -> align with left edge
			} else if ( overLeft > 0 ) {
				position.left += overLeft;
			// too far right -> align with right edge
			} else if ( overRight > 0 ) {
				position.left -= overRight;
			// adjust based on position and margin
			} else {
				position.left = max( position.left - collisionPosLeft, position.left );
			}
		},
		top: function( position, data ) {
			var within = data.within,
				withinOffset = within.isWindow ? within.scrollTop : within.offset.top,
				outerHeight = data.within.height,
				collisionPosTop = position.top - data.collisionPosition.marginTop,
				overTop = withinOffset - collisionPosTop,
				overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,
				newOverBottom;

			// element is taller than within
			if ( data.collisionHeight > outerHeight ) {
				// element is initially over the top of within
				if ( overTop > 0 && overBottom <= 0 ) {
					newOverBottom = position.top + overTop + data.collisionHeight - outerHeight - withinOffset;
					position.top += overTop - newOverBottom;
				// element is initially over bottom of within
				} else if ( overBottom > 0 && overTop <= 0 ) {
					position.top = withinOffset;
				// element is initially over both top and bottom of within
				} else {
					if ( overTop > overBottom ) {
						position.top = withinOffset + outerHeight - data.collisionHeight;
					} else {
						position.top = withinOffset;
					}
				}
			// too far up -> align with top
			} else if ( overTop > 0 ) {
				position.top += overTop;
			// too far down -> align with bottom edge
			} else if ( overBottom > 0 ) {
				position.top -= overBottom;
			// adjust based on position and margin
			} else {
				position.top = max( position.top - collisionPosTop, position.top );
			}
		}
	},
	flip: {
		left: function( position, data ) {
			var within = data.within,
				withinOffset = within.offset.left + within.scrollLeft,
				outerWidth = within.width,
				offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,
				collisionPosLeft = position.left - data.collisionPosition.marginLeft,
				overLeft = collisionPosLeft - offsetLeft,
				overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,
				myOffset = data.my[ 0 ] === "left" ?
					-data.elemWidth :
					data.my[ 0 ] === "right" ?
						data.elemWidth :
						0,
				atOffset = data.at[ 0 ] === "left" ?
					data.targetWidth :
					data.at[ 0 ] === "right" ?
						-data.targetWidth :
						0,
				offset = -2 * data.offset[ 0 ],
				newOverRight,
				newOverLeft;

			if ( overLeft < 0 ) {
				newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth - outerWidth - withinOffset;
				if ( newOverRight < 0 || newOverRight < abs( overLeft ) ) {
					position.left += myOffset + atOffset + offset;
				}
			}
			else if ( overRight > 0 ) {
				newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset + atOffset + offset - offsetLeft;
				if ( newOverLeft > 0 || abs( newOverLeft ) < overRight ) {
					position.left += myOffset + atOffset + offset;
				}
			}
		},
		top: function( position, data ) {
			var within = data.within,
				withinOffset = within.offset.top + within.scrollTop,
				outerHeight = within.height,
				offsetTop = within.isWindow ? within.scrollTop : within.offset.top,
				collisionPosTop = position.top - data.collisionPosition.marginTop,
				overTop = collisionPosTop - offsetTop,
				overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,
				top = data.my[ 1 ] === "top",
				myOffset = top ?
					-data.elemHeight :
					data.my[ 1 ] === "bottom" ?
						data.elemHeight :
						0,
				atOffset = data.at[ 1 ] === "top" ?
					data.targetHeight :
					data.at[ 1 ] === "bottom" ?
						-data.targetHeight :
						0,
				offset = -2 * data.offset[ 1 ],
				newOverTop,
				newOverBottom;
			if ( overTop < 0 ) {
				newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight - outerHeight - withinOffset;
				if ( ( position.top + myOffset + atOffset + offset) > overTop && ( newOverBottom < 0 || newOverBottom < abs( overTop ) ) ) {
					position.top += myOffset + atOffset + offset;
				}
			}
			else if ( overBottom > 0 ) {
				newOverTop = position.top - data.collisionPosition.marginTop + myOffset + atOffset + offset - offsetTop;
				if ( ( position.top + myOffset + atOffset + offset) > overBottom && ( newOverTop > 0 || abs( newOverTop ) < overBottom ) ) {
					position.top += myOffset + atOffset + offset;
				}
			}
		}
	},
	flipfit: {
		left: function() {
			$.ui.position.flip.left.apply( this, arguments );
			$.ui.position.fit.left.apply( this, arguments );
		},
		top: function() {
			$.ui.position.flip.top.apply( this, arguments );
			$.ui.position.fit.top.apply( this, arguments );
		}
	}
};

// fraction support test
(function () {
	var testElement, testElementParent, testElementStyle, offsetLeft, i,
		body = document.getElementsByTagName( "body" )[ 0 ],
		div = document.createElement( "div" );

	//Create a "fake body" for testing based on method used in jQuery.support
	testElement = document.createElement( body ? "div" : "body" );
	testElementStyle = {
		visibility: "hidden",
		width: 0,
		height: 0,
		border: 0,
		margin: 0,
		background: "none"
	};
	if ( body ) {
		$.extend( testElementStyle, {
			position: "absolute",
			left: "-1000px",
			top: "-1000px"
		});
	}
	for ( i in testElementStyle ) {
		testElement.style[ i ] = testElementStyle[ i ];
	}
	testElement.appendChild( div );
	testElementParent = body || document.documentElement;
	testElementParent.insertBefore( testElement, testElementParent.firstChild );

	div.style.cssText = "position: absolute; left: 10.7432222px;";

	offsetLeft = $( div ).offset().left;
	$.support.offsetFractions = offsetLeft > 10 && offsetLeft < 11;

	testElement.innerHTML = "";
	testElementParent.removeChild( testElement );
})();

}( jQuery ) );
/** klay.js version 0.4.1 build 201604131004 */
// ##### BEGIN: MODIFIED BY SAP
// SAP UI5 doesn't use these callback for library registration so we are removing them from the global scope.
//var klayregister;
//var klaycallback;
// ##### END: MODIFIED BY SAP
(function(){
var $wnd, $doc;if(typeof(window) !== 'undefined'){ $wnd = window; $doc = $wnd.document; }
else { $wnd = { Array: function(){} }; }
function kI(){}
function iI(){}
function pb(){}
function Ab(){}
function Tt(){}
function Jt(){}
function Jq(){}
function Vq(){}
function Vs(){}
function yl(){}
function Yl(){}
function gm(){}
function Cu(){}
function tJ(){}
function NJ(){}
function PJ(){}
function PS(){}
function sS(){}
function yS(){}
function AS(){}
function MS(){}
function RS(){}
function TS(){}
function lR(){}
function HR(){}
function IR(){}
function KR(){}
function WR(){}
function AT(){}
function FT(){}
function HT(){}
function JT(){}
function LT(){}
function NT(){}
function sU(){}
function uV(){}
function xV(){}
function EV(){}
function HW(){}
function UX(){}
function XX(){}
function ZX(){}
function _X(){}
function bY(){}
function dY(){}
function wY(){}
function zY(){}
function SY(){}
function VY(){}
function qZ(){}
function tZ(){}
function wZ(){}
function AZ(){}
function d$(){}
function g$(){}
function j$(){}
function w$(){}
function z$(){}
function C$(){}
function F$(){}
function I$(){}
function L$(){}
function N$(){}
function R$(){}
function X$(){}
function _$(){}
function k0(){}
function m0(){}
function s0(){}
function w0(){}
function A0(){}
function C0(){}
function E0(){}
function G0(){}
function V0(){}
function Z0(){}
function _0(){}
function _1(){}
function b1(){}
function e1(){}
function k1(){}
function q1(){}
function u1(){}
function R1(){}
function X1(){}
function Z1(){}
function c2(){}
function f2(){}
function h2(){}
function k2(){}
function n2(){}
function q2(){}
function x2(){}
function A2(){}
function H2(){}
function H4(){}
function z4(){}
function B4(){}
function D4(){}
function U4(){}
function i3(){}
function l3(){}
function u3(){}
function C3(){}
function I3(){}
function $5(){}
function d7(){}
function V7(){}
function q8(){}
function smb(){}
function Wbb(){}
function rcb(){}
function Mcb(){}
function Vdb(){}
function hkb(){}
function Kpb(){}
function Spb(){}
function aqb(){}
function iqb(){}
function pqb(){}
function isb(){}
function mvb(){}
function zwb(){}
function yfb(a){}
function sP(a){}
function XW(a){}
function _t(){Wt()}
function lI(){GP()}
function J8(){G8()}
function m8(){k8()}
function CQ(){zQ()}
function CV(){AV()}
function q0(){p0()}
function S0(){J0()}
function y9(){w9()}
function Bab(){zab()}
function Qab(){Hab()}
function cbb(){abb()}
function sbb(){rbb()}
function Ycb(){Xcb()}
function Wfb(){Mfb()}
function ft(){_s(this)}
function uP(){sP(this)}
function GU(){tU(this)}
function ZW(){XW(this)}
function ic(a){this.a=a}
function sc(a){this.a=a}
function $c(a){this.a=a}
function sf(a){this.a=a}
function Qg(a){this.a=a}
function qh(a){this.a=a}
function Vj(a){this.a=a}
function Nk(a){this.a=a}
function km(a){this.a=a}
function dm(a){this.b=a}
function En(a){this.a=a}
function Hn(a){this.a=a}
function Yp(a){this.a=a}
function bq(a){this.a=a}
function eq(a){this.a=a}
function tq(a){this.a=a}
function wq(a){this.a=a}
function ku(a){this.a=a}
function uu(a){this.a=a}
function Gu(a){this.a=a}
function Uu(a){this.a=a}
function WJ(a){this.a=a}
function rP(a){this.a=a}
function $V(a){this.a=a}
function tW(a){this.a=a}
function yW(a){this.e=a}
function fY(a){this.a=a}
function hY(a){this.a=a}
function lY(a){this.a=a}
function nY(a){this.a=a}
function CY(a){this.a=a}
function JY(a){this.a=a}
function SZ(a){this.a=a}
function Z$(a){this.a=a}
function b_(a){this.a=a}
function d_(a){this.a=a}
function f_(a){this.a=a}
function w1(a){this.a=a}
function y1(a){this.a=a}
function E3(a){this.a=a}
function q4(a){this.a=a}
function x4(a){this.a=a}
function F4(a){this.a=a}
function $8(a){this.a=a}
function a9(a){this.a=a}
function l9(a){this.a=a}
function C9(a){this.a=a}
function k9(a){this.c=a}
function wlb(a){this.a=a}
function nxb(a){this.a=a}
function wcb(a){this.a=a}
function tdb(a){this.a=a}
function ydb(a){this.a=a}
function Ddb(a){this.a=a}
function lkb(a){this.a=a}
function klb(a){this.a=a}
function llb(a){this.a=a}
function inb(a){this.a=a}
function wnb(a){this.d=a}
function Snb(a){this.a=a}
function Ynb(a){this.a=a}
function aob(a){this.a=a}
function fob(a){this.a=a}
function Bob(a){this.b=a}
function Gob(a){this.a=a}
function Mob(a){this.a=a}
function Tob(a){this.c=a}
function opb(a){this.a=a}
function Ipb(a){this.a=a}
function rqb(a){this.a=a}
function zqb(a){this.b=a}
function Nqb(a){this.b=a}
function mrb(a){this.c=a}
function Trb(a){this.a=a}
function Xrb(a){this.a=a}
function Fsb(a){this.a=a}
function ju(){this.a=[]}
function ytb(a){this.a=a}
function Lub(a){this.a=a}
function u5(a){a.b=a.a}
function vg(a){a.c=a.d.d}
function sX(a,b){a.g=b}
function bfb(a,b){a.k=b}
function qfb(a,b){a.a=b}
function rfb(a,b){a.b=b}
function qW(a,b){a.e.k=b}
function qu(a){return a.a}
function yu(a){return a.a}
function Mu(a){return a.a}
function $u(a){return a.a}
function rv(a){return a.a}
function jv(){return null}
function Fu(){return null}
function Rh(){this.c=this}
function tkb(){_s(this)}
function ntb(){Ymb(this)}
function b5(a){a5(this,a)}
function GO(a){IO();$O(a)}
function mI(a){a.a=new aJ}
function IZ(a,b){a.a=b-a.a}
function KZ(a,b){a.b=b-a.b}
function Dq(){Dq=iI;new Jq}
function nW(){nW=iI;new HW}
function ni(){throw new Hmb}
function ii(){throw new Hmb}
function ji(){throw new Hmb}
function li(){throw new Hmb}
function mi(){throw new Hmb}
function dd(){throw new Hmb}
function pj(){throw new Hmb}
function Wn(){throw new Hmb}
function $n(){throw new Hmb}
function qT(){this.a=new GU}
function fU(){this.a=new GU}
function cV(){this.a=new GU}
function pV(){this.a=new GU}
function l7(){this.a=new GU}
function k7(){this.a=new d7}
function A7(){this.a=new n7}
function t8(){this.b=new GU}
function jJ(){aJ.call(this)}
function ZN(){UN.call(this)}
function AP(){uP.call(this)}
function DP(){uP.call(this)}
function q7(){GU.call(this)}
function alb(){ft.call(this)}
function rlb(){ft.call(this)}
function nkb(){ft.call(this)}
function qkb(){ft.call(this)}
function tlb(){ft.call(this)}
function Vlb(){ft.call(this)}
function Hmb(){ft.call(this)}
function Wab(){this.f=new GU}
function Ybb(){this.d=new GU}
function jV(){this.a=new vtb}
function vqb(){throw new Hmb}
function wqb(){throw new Hmb}
function xqb(){throw new Hmb}
function yqb(){throw new Hmb}
function Mqb(){throw new Hmb}
function Uvb(){this.a=new GU}
function it(){it=iI;ht=new pb}
function bmb(){bmb=iI;new smb}
function zb(){zb=iI;yb=new Ab}
function Tq(){Tq=iI;Sq=new Vq}
function dr(){dr=iI;cr=new er}
function Gt(){Gt=iI;Ft=new Jt}
function Bu(){Bu=iI;Au=new Cu}
function fR(){fR=iI;eR=new lR}
function VR(){VR=iI;UR=new WR}
function jS(a){dS(a);return a}
function jl(a){Gi();this.a=a}
function vi(a){hi();this.a=a}
function Uk(a){hi();this.a=a}
function Zk(a){hi();this.a=a}
function ds(a,b){a.i=b;b.f=a}
function ycb(a,b){stb(a.b,b)}
function nsb(){ft.call(this)}
function osb(){ft.call(this)}
function nvb(){ft.call(this)}
function Ccb(){Bcb.call(this)}
function Jcb(){Bcb.call(this)}
function pkb(){nkb.call(this)}
function Xlb(){rlb.call(this)}
function gt(a){et.call(this,a)}
function Vd(a){Md.call(this,a)}
function uh(a){Md.call(this,a)}
function Bk(a){Hj.call(this,a)}
function Jk(a){dk.call(this,a)}
function Lm(a){Em.call(this,a)}
function nq(a){vm.call(this,a)}
function ap(a){Ro.call(this,a)}
function ir(a){Hj.call(this,a)}
function Op(a,b){a.a.W().nb(b)}
function emb(a,b){return a===b}
function Zr(a){return !a?0:a.a}
function Rs(a){return !a?0:a.d}
function Ts(a){return !a?0:a.j}
function zu(a){gt.call(this,a)}
function $J(a){gt.call(this,a)}
function _J(a){gt.call(this,a)}
function EQ(a){_J.call(this,a)}
function Tu(){Uu.call(this,{})}
function y5(a){b5.call(this,a)}
function H5(a){b5.call(this,a)}
function WP(a,b,c){XP(a,b.b,c)}
function a7(a,b,c){f6(a.c,b,c)}
function qV(a,b,c){a.b.Fc(b,c)}
function M9(a){$8.call(this,a)}
function P9(a){$8.call(this,a)}
function YY(){this.a=(sK(),qK)}
function cZ(){this.a=(sK(),qK)}
function vtb(){this.a=new ntb}
function Vwb(){this.a=new iwb}
function vT(){vT=iI;uT=new AT}
function AV(){AV=iI;zV=new EV}
function p0(){p0=iI;o0=new s0}
function Ckb(a){xkb();return a}
function Ixb(a){Dxb(a);return a}
function ikb(a){et.call(this,a)}
function okb(a){gt.call(this,a)}
function slb(a){gt.call(this,a)}
function Kb(a){this.c=$v(_b(a))}
function FI(){this.a=0;this.b=0}
function aJ(){OI(this);_I(this)}
function cI(){aI==null&&(aI=[])}
function Vvb(a){a.b=null;a.c=0}
function mS(a,b){a.b=b;return a}
function nS(a,b){a.c=b;return a}
function oS(a,b){a.f=b;return a}
function pS(a,b){a.g=b;return a}
function S7(a,b){a.a=b;return a}
function T7(a,b){a.f=b;return a}
function U7(a,b){a.k=b;return a}
function xc(a,b){return a.e-b.e}
function H3(a,b){return a.d-b.d}
function Klb(a){return a<0?-a:a}
function hlb(a){return isNaN(a)}
function gv(a){return new Gu(a)}
function iv(a){return new lv(a)}
function rkb(a){gt.call(this,a)}
function ulb(a){gt.call(this,a)}
function Ulb(a){gt.call(this,a)}
function Wlb(a){gt.call(this,a)}
function Imb(a){gt.call(this,a)}
function et(a){this.f=a;_s(this)}
function _2(){this.b=0;this.a=0}
function Ws(){Ws=iI;Math.log(2)}
function Ytb(){Ytb=iI;Xtb=$tb()}
function Vtb(c,a,b){c.set(a,b)}
function Wtb(c,a,b){c.set(a,b)}
function Ot(a,b){Nt();Mt.dc(a,b)}
function tv(a,b){return Skb(a,b)}
function zm(a,b){return a.a.B(b)}
function aP(a,b){return a.g[b.e]}
function bP(a,b){return a.i[b.e]}
function cP(a,b){return a.j[b.e]}
function dP(a,b){return a.n[b.e]}
function eP(a,b){return a.o[b.e]}
function Ou(b,a){return a in b.a}
function Tab(a,b){return a.b-b.b}
function ndb(a,b){return a.d-b.d}
function jgb(a,b){return a.i-b.i}
function Nlb(a,b){return a>b?a:b}
function Olb(a,b){return a>b?a:b}
function Plb(a,b){return a>b?a:b}
function Qlb(a,b){return a<b?a:b}
function Rlb(a,b){return a<b?a:b}
function Slb(a,b){return a<b?a:b}
function awb(a){return !!a&&a.b}
function $ob(a){_ob(a,a.length)}
function bpb(a){apb(a,a.length)}
function dpb(a){cpb(a,a.length)}
function Cmb(a){okb.call(this,a)}
function Bmb(a){lkb.call(this,a)}
function oxb(a){nxb.call(this,a)}
function Ylb(a){slb.call(this,a)}
function Frb(a){zqb.call(this,a)}
function Nrb(a){Frb.call(this,a)}
function csb(a){Rqb.call(this,a)}
function zmb(){lkb.call(this,'')}
function Amb(){lkb.call(this,'')}
function Ikb(a){Gkb(a);return a.n}
function Jkb(a){Gkb(a);return a.j}
function Hkb(a){return a.e&&a.e()}
function Lk(a,b){return a.a.sb(b)}
function Sb(a,b){return a?a:_b(b)}
function vW(a,b){return rJ(a.a,b)}
function w4(a,b){return t4(a.a,b)}
function VH(a,b){return RH(a,b)<0}
function Dlb(a){return bmb(),''+a}
function qe(a){return !a?null:a.d}
function Gr(a){hi();this.a=_b(a)}
function I9(){F9();this.g=new Um}
function J0(){J0=iI;I0=(kP(),hP)}
function Et(){ut!=0&&(ut=0);wt=-1}
function bS(a){cS(a,a.d);return a}
function i7(a,b){a.a.d=b;return a}
function g7(a,b){a.a.a=b;return a}
function h7(a,b){a.a.c=b;return a}
function j7(a,b){a.a.f=b;return a}
function z7(a,b){a.a.f=b;return a}
function y7(a,b){a.a.b=b;return a}
function hxb(a,b,c){a.splice(b,c)}
function oqb(a,b){return Akb(b,a)}
function Drb(a,b){return a.b.t(b)}
function jrb(a,b){return a.c.t(b)}
function ttb(a,b){return a.a.R(b)}
function Ttb(b,a){return b.get(a)}
function Utb(b,a){return b.get(a)}
function elb(a,b){return a.test(b)}
function Jlb(a){return a<=0?0-a:a}
function ilb(a){return bmb(),''+a}
function qlb(a){return bmb(),''+a}
function wtb(a){this.a=new otb(a)}
function Wwb(a){this.a=new jwb(a)}
function nc(a){this.a=Wv(_b(a),19)}
function Bf(a){this.b=Wv(_b(a),57)}
function Ch(a){this.d=Wv(_b(a),56)}
function Ac(a,b){this.d=a;this.e=b}
function Ie(a,b){this.b=a;this.a=b}
function tm(a,b){this.b=a;this.a=b}
function Pf(a,b){this.b=a;this.c=b}
function Fk(a,b){this.a=a;this.b=b}
function Bn(a,b){this.a=a;this.b=b}
function Sn(a,b){this.a=a;this.f=b}
function Mc(a,b){Ac.call(this,a,b)}
function Hh(a,b){Ac.call(this,a,b)}
function yp(a,b){Ac.call(this,a,b)}
function bp(a,b){this.b=a;this.c=b}
function Oq(a,b){this.e=a;this.c=b}
function Yq(a,b){this.a=a;this.b=b}
function fs(a,b){this.a=a;this.b=b}
function rs(a,b){Ac.call(this,a,b)}
function _u(a,b){this.a=a;this.b=b}
function Mo(a){this.a=Wv(_b(a),20)}
function Ro(a){this.a=Wv(_b(a),20)}
function Fp(a){this.a=Wv(_b(a),57)}
function vm(a){this.b=Wv(_b(a),35)}
function HI(a,b){this.a=a;this.b=b}
function RJ(a,b){this.a=a;this.b=b}
function jK(a,b){Ac.call(this,a,b)}
function Qm(a,b){return Qmb(a.b,b)}
function fv(a){return tu(),a?su:ru}
function tK(a){return a==oK||a==pK}
function uK(a){return a==rK||a==nK}
function RI(a,b){TI(a,b,a.a,a.a.a)}
function SI(a,b){TI(a,b,a.c.b,a.c)}
function wK(a,b){Ac.call(this,a,b)}
function FK(a,b){Ac.call(this,a,b)}
function OK(a,b){Ac.call(this,a,b)}
function ZK(a,b){Ac.call(this,a,b)}
function fL(a,b){Ac.call(this,a,b)}
function pM(a,b){Ac.call(this,a,b)}
function AM(a,b){Ac.call(this,a,b)}
function NM(a,b){Ac.call(this,a,b)}
function VM(a,b){Ac.call(this,a,b)}
function uN(a,b){Ac.call(this,a,b)}
function EN(a,b){Ac.call(this,a,b)}
function NN(a,b){Ac.call(this,a,b)}
function EO(a,b){Ac.call(this,a,b)}
function lP(a,b){Ac.call(this,a,b)}
function OS(a,b){this.b=a;this.a=b}
function VS(a,b){this.c=a;this.d=b}
function wW(a,b){this.a=a;this.c=b}
function BW(a,b){this.e=a;this.c=b}
function FW(a,b){this.e=a;this.d=b}
function fT(a,b){Ac.call(this,a,b)}
function DX(a,b){Ac.call(this,a,b)}
function MY(a,b){this.a=a;this.b=b}
function PY(a,b){this.a=a;this.b=b}
function YZ(a,b){Ac.call(this,a,b)}
function f0(a,b){Ac.call(this,a,b)}
function J1(a,b){Ac.call(this,a,b)}
function Y3(a,b){Ac.call(this,a,b)}
function h4(a,b){Ac.call(this,a,b)}
function $7(a,b){Ac.call(this,a,b)}
function y8(a,b){Ac.call(this,a,b)}
function q9(a,b){Ac.call(this,a,b)}
function MR(a,b){return Zsb(a.c,b)}
function Bnb(a){return a.b<a.d.Y()}
function Zmb(a){return a.d.c+a.e.c}
function hrb(a,b){return a.c.ab(b)}
function Brb(a,b){return a.b.kb(b)}
function Crb(a,b){return a.b.lb(b)}
function Erb(a,b){return a.b.pb(b)}
function Irb(a,b){return a.b.kb(b)}
function Jrb(a,b){return a.b.lb(b)}
function dT(a){return a==$S||a==bT}
function eT(a){return a==$S||a==_S}
function MM(a){return a!=IM&&a!=JM}
function lg(a){return Yf(a),a.d.Y()}
function jtb(a){this.c=a;gtb(this)}
function otb(a){$mb.call(this,a,0)}
function iwb(){jwb.call(this,null)}
function xk(){uh.call(this,new ntb)}
function Ap(){yp.call(this,'KEY',0)}
function lr(a){kr();dk.call(this,a)}
function Dt(a){$wnd.clearTimeout(a)}
function um(a){return a.Vb(a.b.H())}
function Pp(a){this.a=Wv(_b(a),144)}
function Um(){this.b=(mp(),new ntb)}
function hsb(){hsb=iI;gsb=new isb}
function Rpb(){Rpb=iI;Qpb=new Spb}
function nqb(){nqb=iI;mqb=new pqb}
function hc(){hc=iI;gc=new Kb(',')}
function nJ(){nJ=iI;Math.pow(2,-65)}
function UN(){VN.call(this,0,0,0,0)}
function wab(a,b){Ac.call(this,a,b)}
function lbb(a,b){Ac.call(this,a,b)}
function Hbb(a,b){Ac.call(this,a,b)}
function Mbb(a,b){Ac.call(this,a,b)}
function xQ(a){wJ();CJ.call(this,a)}
function mcb(a,b){Ac.call(this,a,b)}
function gab(a,b){this.c=a;this.b=b}
function Qbb(a,b){this.a=a;this.b=b}
function Fcb(a,b){this.b=a;this.d=b}
function ggb(a,b){Ac.call(this,a,b)}
function Agb(a,b){Ac.call(this,a,b)}
function Igb(a,b){Ac.call(this,a,b)}
function Rgb(a,b){Ac.call(this,a,b)}
function ahb(a,b){Ac.call(this,a,b)}
function phb(a,b){Ac.call(this,a,b)}
function Ihb(a,b){Ac.call(this,a,b)}
function Nhb(a,b){Ac.call(this,a,b)}
function Yib(a,b){Ac.call(this,a,b)}
function ejb(a,b){Ac.call(this,a,b)}
function Rjb(a,b){Ac.call(this,a,b)}
function dkb(a,b){Ac.call(this,a,b)}
function fxb(a,b,c){a.splice(b,0,c)}
function Yjb(a,b,c){a.g[b.e][b.e]=c}
function D6(a,b){a.a=b;a.g=0;a.f=0}
function BI(a){a.a=0;a.b=0;return a}
function rY(a){return zU(a.b.c,a,0)}
function Llb(a){return Math.ceil(a)}
function Tlb(a){return Math.sqrt(a)}
function cub(a,b){return Utb(a.a,b)}
function vob(a,b){return !!Wvb(a,b)}
function Yob(a,b){Zob(a,a.length,b)}
function Gwb(a,b){Ac.call(this,a,b)}
function Psb(a,b){this.b=a;this.a=b}
function qob(a,b){this.d=a;this.e=b}
function dcb(){$bb();this.c=new vtb}
function Rdb(){Ndb();this.a=new vtb}
function aub(){Ytb();return new Xtb}
function Xb(a){if(!a){throw new rlb}}
function dc(a){if(!a){throw new tlb}}
function Vm(a){if(!a){throw new nvb}}
function SV(){this.b=(mp(),new ntb)}
function Q4(){this.b=(mp(),new ntb)}
function II(a){this.a=a.a;this.b=a.b}
function gw(a){return a==null?null:a}
function re(a){return !a?null:a.zb()}
function $i(a,b){return a.Nb().sb(b)}
function aq(a,b){return a.a.a.a.U(b)}
function nl(a,b){return Ll(a.mb(),b)}
function B3(a,b){return glb(b.b,a.b)}
function h3(a,b){return glb(b.k,a.k)}
function Mlb(a){return Math.floor(a)}
function vmb(a,b){return a.a+=''+b,a}
function xmb(a,b){a.a+=''+b;return a}
function ymb(a,b){a.a+=''+b;return a}
function iw(a){Hxb(a==null);return a}
function T2(a){a.d&&Z2(a);return a.a}
function U2(a){a.d&&Z2(a);return a.b}
function V2(a){a.d&&Z2(a);return a.c}
function Tvb(a,b){vU(a.a,b);return b}
function ptb(a){Ymb(this);he(this,a)}
function _4(a){this.c=a;this.e=false}
function Jh(){Hh.call(this,'OPEN',0)}
function ts(){rs.call(this,'SIZE',0)}
function qxb(){nxb.call(this,'UTF-8')}
function Nxb(){Nxb=iI;Kxb={};Mxb={}}
function IO(){IO=iI;HO=new DJ(yzb,0)}
function Sh(a){_b(a);return new Vh(a)}
function pmb(a){bmb();return a.length}
function Jmb(a,b){return cmb(a.a,b.a)}
function vlb(a,b){return xlb(a.a,b.a)}
function Ys(a,b){return a==b?0:a?1:-1}
function Cs(a){return Rs(a.e)-Rs(a.g)}
function xI(a){return new HI(a.a,a.b)}
function RN(a){return new HI(a.d,a.e)}
function tU(a){a.c=xv(UF,syb,1,0,4,1)}
function Cp(){yp.call(this,'VALUE',1)}
function dX(a){cX.call(this);this.a=a}
function Q2(a){this.a=new $2;this.b=a}
function Vh(a){this.a=a;Rh.call(this)}
function vl(a){this.a=a;Rh.call(this)}
function U8(){P8();this.d=(ckb(),bkb)}
function zxb(a){if(!a){throw new qkb}}
function uxb(a){if(!a){throw new tlb}}
function vxb(a){if(!a){throw new rlb}}
function Hxb(a){if(!a){throw new alb}}
function Bxb(a){if(!a){throw new nvb}}
function Wub(){ytb.call(this,new wub)}
function Kh(){Hh.call(this,'CLOSED',1)}
function Im(a){Em.call(this,new Lm(a))}
function p7(a,b){++a.d;return BU(a,b)}
function kkb(a,b){return gmb(a.a,0,b)}
function jlb(a,b){return glb(a.a,b.a)}
function Al(a){return Pl(a.b.mb(),a.a)}
function Dl(a){return Wl(a.a.mb(),a.b)}
function q6(a,b){return b==a.c?a.d:a.c}
function Zs(a,b){return a<b?-1:a>b?1:0}
function xlb(a,b){return a<b?-1:a>b?1:0}
function pvb(a){return a!=null?vb(a):0}
function Ntb(a){this.a=aub();this.b=a}
function fub(a){this.a=aub();this.b=a}
function Cg(a){this.a=a;xg.call(this,a)}
function o4(){n4();this.b=new q4(this)}
function Oh(){Oh=iI;Nh=Jb(new Kb(', '))}
function Gh(){Gh=iI;Fh=new Jh;Eh=new Kh}
function Il(){Il=iI;Gl=new Yl;Hl=new gm}
function xp(){xp=iI;vp=new Ap;wp=new Cp}
function qs(){qs=iI;ps=new ts;os=new ws}
function wJ(){wJ=iI;uJ=new NJ;vJ=new PJ}
function Teb(a){a.g=new GU;a.b=new GU}
function OI(a){a.a=new mvb;a.c=new mvb}
function n4(){n4=iI;m4=new U4;l4=new u4}
function Uc(){Mc.call(this,'IS_NULL',2)}
function Kwb(){Gwb.call(this,'Head',1)}
function Pwb(){Gwb.call(this,'Tail',3)}
function pR(a,b){qR.call(this,a,b,null)}
function lpb(a,b){ipb(a,0,a.length,b)}
function x7(a,b){vU(b.a,a.a);return a.a}
function CI(a,b){a.a*=b;a.b*=b;return a}
function gl(a,b){Gi();this.a=a;this.b=b}
function i9(a,b){return a.a[b.d.k][b.k]}
function W9(a,b){return a.a[b.d.k][b.k]}
function xJ(a,b){return kmb(a.b,b.mc())}
function Swb(a,b){return qe(Xvb(a.a,b))}
function Twb(a,b){return qe(Yvb(a.a,b))}
function $T(a,b){return Wv(Dd(a.a,b),20)}
function aw(a,b){return a!=null&&Vv(a,b)}
function Qob(a){return a.a<a.c.c.length}
function htb(a){return a.a<a.c.a.length}
function y$(a,b){return glb(a.i.a,b.i.a)}
function S$(a,b){return a.i.b=(Dxb(b),b)}
function T$(a,b){return a.i.b=(Dxb(b),b)}
function utb(a,b){return a.a.eb(b)!=null}
function Vjb(a,b,c){return a.g[b.e][c.e]}
function Bkb(a){xkb();return bmb(),''+a}
function Mwb(){Gwb.call(this,'Range',2)}
function ws(){rs.call(this,'DISTINCT',1)}
function Xc(){Mc.call(this,'NOT_NULL',3)}
function mp(){mp=iI;lp=new Rb((Oh(),Nh))}
function Hj(a){this.d=(ypb(),new mrb(a))}
function Hb(a,b){return Gb(a,new zmb,b).a}
function Mb(a,b){return b==null?a.b:Ib(b)}
function mt(a){return a==null?null:a.name}
function cw(a){return typeof a==='number'}
function ew(a){return typeof a==='string'}
function Hi(a,b){return new Mk(a,a.Y(),b)}
function An(a,b){return new no(a.a,a.b,b)}
function Jb(a){_b(Wxb);return new Nb(a,a)}
function Do(a){Mh(a,Vyb);return new HU(a)}
function Am(a,b){this.a=b;vm.call(this,a)}
function tp(a,b){this.a=b;vm.call(this,a)}
function If(a,b){this.a=a;Bf.call(this,b)}
function ks(a){this.c=a;this.a=Qr(this.c)}
function MZ(a){var b;b=a.a;a.a=a.b;a.b=b}
function pW(a,b){a.e.j.a=b.a;a.e.j.b=b.b}
function xvb(a,b,c){a.a=b^1502;a.b=c^_Ab}
function uI(a,b,c){a.a+=b;a.b+=c;return a}
function DI(a,b,c){a.a-=b;a.b-=c;return a}
function zI(a){a.a=-a.a;a.b=-a.b;return a}
function UI(a){Bxb(a.b!=0);return a.a.a.c}
function VI(a){Bxb(a.b!=0);return a.c.b.c}
function uub(a,b){if(a.a){Hub(b);Gub(b)}}
function rn(a,b,c){var d;d=a.ub(b);d.J(c)}
function Iq(a,b){return Zs(b.Yb(),a.Yb())}
function o5(a){return Wv(yU(a.a,a.b),128)}
function EU(a){return cxb(a.c,a.c.length)}
function Fv(a){return a.l+a.m*czb+a.h*dzb}
function LM(a){return a==EM||a==GM||a==FM}
function UH(a){return typeof a==='number'}
function Zsb(a,b){return !!b&&a.b[b.e]==b}
function lsb(a,b){var c;c=a[WAb];b[WAb]=c}
function FQ(a,b){_J.call(this,a);this.b=b}
function Rqb(a){zqb.call(this,a);this.a=a}
function arb(a){Nqb.call(this,a);this.a=a}
function dsb(a){Frb.call(this,a);this.a=a}
function Xub(a){ytb.call(this,new xub(a))}
function wwb(a){this.a=a;Bob.call(this,a)}
function v5(a){this.c=a;this.a=1;this.b=1}
function Rb(a){this.a=a;this.b=$v(_b('='))}
function B5(){this.a=new aJ;this.e=new aJ}
function tV(){this.a=new fU;this.c=new uV}
function cX(){this.i=new FI;this.j=new FI}
function Md(a){Xb(a.d.c+a.e.c==0);this.b=a}
function _s(a){a.g=null;Ot(a,a.f);return a}
function Nl(a){Il();_b(a);return new om(a)}
function St(a){Nt();return parseInt(a)||-1}
function Uwb(a,b){return cwb(a.a,b)!=null}
function ok(a,b){return !rk(a,b)&&!qk(a,b)}
function txb(a){return a.$H||(a.$H=++sxb)}
function yc(a){return a.d!=null?a.d:''+a.e}
function zc(a){return a.d!=null?a.d:''+a.e}
function pwb(a){return a.b=Wv(Cnb(a.a),21)}
function bw(a){return typeof a==='boolean'}
function pub(a){a.b=new Iub(a);a.c=new ntb}
function oab(){this.a=new GU;this.d=new GU}
function Iub(a){Jub.call(this,a,null,null)}
function ug(a,b,c,d){mg.call(this,a,b,c,d)}
function BP(a,b,c,d){vP.call(this,a,b,c,d)}
function EP(a,b,c,d){vP.call(this,a,b,c,d)}
function Kg(a,b,c){_f.call(this,a,b,c,null)}
function Lg(a,b,c){_f.call(this,a,b,c,null)}
function es(a,b,c){a.i=b;b.f=a;b.i=c;c.f=b}
function tI(a,b){mI(this);this.e=a;this.f=b}
function yg(a,b){this.d=a;vg(this);this.b=b}
function kJ(a){OI(this);_I(this);Ue(this,a)}
function Xv(a){Hxb(a==null||bw(a));return a}
function Yv(a){Hxb(a==null||cw(a));return a}
function $v(a){Hxb(a==null||ew(a));return a}
function vI(a,b){a.a+=b.a;a.b+=b.b;return a}
function EI(a,b){a.a-=b.a;a.b-=b.b;return a}
function U$(a,b){return a.i.a=(Dxb(b),b)+10}
function V$(a,b){return a.i.a=(Dxb(b),b)+10}
function h6(a,b){return Wv(Smb(a.k,b),24).a}
function Bj(a,b){return Lh(a,b),new zr(a,b)}
function Web(a,b){return Wv(a.b.sb(b),92).a}
function WX(a){return Wv(a,7).b.c.length!=0}
function TX(a){return Wv(a,7).e.c.length!=0}
function jX(a){return !a.d?-1:zU(a.d.a,a,0)}
function lt(a){return a==null?null:a.message}
function Gkb(a){if(a.n!=null){return}Wkb(a)}
function wmb(a,b,c,d){jkb(a,b,c,d);return a}
function mmb(a,b){bmb();return a.indexOf(b)}
function QX(a,b){if(!b){throw new Vlb}a.g=b}
function Mn(a){if(a.e.c!=a.b){throw new nsb}}
function Xn(a){if(a.f.c!=a.b){throw new nsb}}
function Uq(a,b){_b(a);_b(b);return Akb(a,b)}
function U6(a,b){this.a=a;this.c=b;this.b=2}
function sI(){mI(this);this.e=-1;this.f=true}
function Dh(){Vd.call(this,new ntb);this.a=3}
function CP(a){vP.call(this,a.d,a.b,a.a,a.c)}
function FP(a){vP.call(this,a.d,a.b,a.a,a.c)}
function r6(a){k6.call(this,a);this.c=new GU}
function Oc(){Mc.call(this,'ALWAYS_TRUE',0)}
function Rc(){Mc.call(this,'ALWAYS_FALSE',1)}
function _T(a){XT();this.a=new Dh;YT(this,a)}
function Y9(a){!a.e&&(a.e=new GU);return a.e}
function W7(a){var b;b=new V7;b.e=a;return b}
function msb(a){var b;b=a[WAb]|0;a[WAb]=b+1}
function Anb(a,b){a.a.rb(a.b,b);++a.b;a.c=-1}
function Enb(a,b){uxb(a.c!=-1);a.a.wb(a.c,b)}
function zkb(a,b){xkb();return a==b?0:a?1:-1}
function Wjb(a,b,c){return a.g[b.e][c.e]*a.d}
function xt(a,b,c){return a.apply(b,c);var d}
function ssb(a,b,c){return rsb(a,Wv(b,17),c)}
function m5(a,b){return b==(sN(),rN)?a.c:a.d}
function Zi(a,b){return b!=null&&a.Nb().kb(b)}
function skb(a,b){this.e=b;this.f=a;_s(this)}
function om(a){this.b=a;this.a=(Il(),Il(),Hl)}
function dk(a){hi();this.a=(ypb(),new Frb(a))}
function hi(){hi=iI;new vi((ypb(),ypb(),vpb))}
function e8(){e8=iI;d8=PQ(new WQ,(d0(),X_))}
function rwb(a){swb.call(this,a,(Fwb(),Bwb))}
function IU(a){tU(this);gxb(this.c,0,a.ob())}
function tr(a,b,c){this.b=a;this.a=b;this.c=c}
function WS(a,b,c){VS.call(this,a,b);this.b=c}
function XV(a,b,c){this.b=a;this.a=b;this.c=c}
function job(a,b){var c;c=a.e;a.e=b;return c}
function qub(a){Ymb(a.c);a.b.b=a.b;a.b.a=a.b}
function Vf(a){a.b?Vf(a.b):Umb(a.f.b,a.e,a.d)}
function YI(a){Bxb(a.b!=0);return $I(a,a.a.a)}
function ZI(a){Bxb(a.b!=0);return $I(a,a.c.b)}
function Wl(a,b){Il();_b(b);return new Am(a,b)}
function np(a,b){mp();return new tp(a.mb(),b)}
function jmb(a,b){bmb();return a.charCodeAt(b)}
function imb(a,b,c){bmb();return a.substr(b,c)}
function qmb(a){bmb();return a==null?Wxb:xb(a)}
function Xjb(a,b,c){return Vjb(a,b.g,c.g)*a.d}
function Ev(a,b,c){return {'l':a,'m':b,'h':c}}
function YU(a,b){return ZU(a,new VS(b.a,b.b))}
function SN(a,b,c,d,e){a.d=b;a.e=c;a.c=d;a.b=e}
function wS(a,b,c,d,e){a.b=b;a.c=c;a.d=d;a.a=e}
function QI(a,b){TI(a,b,a.c.b,a.c);return true}
function vU(a,b){a.c[a.c.length]=b;return true}
function DJ(a,b){wJ();CJ.call(this,a);this.a=b}
function g8(){e8();this.e=new aJ;this.d=new aJ}
function Fmb(){Fmb=iI;Dmb=new hkb;Emb=new hkb}
function zab(){zab=iI;yab=VQ(new WQ,(d0(),v_))}
function abb(){abb=iI;_ab=VQ(new WQ,(d0(),v_))}
function rbb(){rbb=iI;qbb=VQ(new WQ,(d0(),v_))}
function $bb(){$bb=iI;Zbb=VQ(new WQ,(d0(),v_))}
function Wt(){Wt=iI;Error.stackTraceLimit=64}
function xS(){wS(this,false,false,false,false)}
function Bo(a){var b;b=new GU;Jl(b,a);return b}
function Eo(a){var b;b=new aJ;ml(b,a);return b}
function XQ(a){var b;b=new WQ;QQ(b,a);return b}
function Ocb(a){var b;b=new Mcb;b.a=a;return b}
function Wv(a,b){Hxb(a==null||Vv(a,b));return a}
function Dvb(a,b){if(a<0||a>=b){throw new pkb}}
function pl(a,b){_b(a);_b(b);return new Bl(a,b)}
function ul(a,b){_b(a);_b(b);return new El(a,b)}
function nmb(a,b){bmb();return a.lastIndexOf(b)}
function rgb(a,b,c){return a<b?c<=a:a<=c||a==b}
function cvb(a,b,c){this.d=a;this.b=c;this.a=b}
function atb(a,b,c){this.a=a;this.b=b;this.c=c}
function lub(a,b,c){this.a=a;this.b=b;this.c=c}
function Nb(a,b){this.a=a;this.b=Wxb;this.c=b.c}
function z3(a){this.c=a.c;this.a=a.e;this.b=a.b}
function xg(a){this.d=a;vg(this);this.b=Ed(a.d)}
function u4(){FS.call(this);this.a=new x4(this)}
function FS(){this.c=new PS;this.d=new KS(this)}
function qr(a){var b;b=new vtb;Jl(b,a);return b}
function qwb(a){vnb(a.a);dwb(a.c,a.b);a.b=null}
function n5(a){return a.c-Wv(yU(a.a,a.b),128).b}
function t5(a,b){return a.c<b.c?-1:a.c==b.c?0:1}
function t4(a,b){return tK(a.b.d)?b.xc():b.wc()}
function gmb(a,b,c){return bmb(),a.substr(b,c-b)}
function gxb(a,b,c){dxb(c,0,a,b,c.length,false)}
function Jub(a,b,c){this.c=a;qob.call(this,b,c)}
function Bl(a,b){this.b=a;this.a=b;Rh.call(this)}
function El(a,b){this.a=a;this.b=b;Rh.call(this)}
function Lq(a,b){this.b=a;this.a=b;Mh(b,'count')}
function dl(a){this.b=a;this.a=nj(this.b.a).Kb()}
function CJ(a){wJ();this.c=uJ;this.d=vJ;this.b=a}
function iab(a,b,c){gab.call(this,a,b);this.a=c}
function mab(a,b,c){gab.call(this,a,b);this.a=c}
function yU(a,b){Cxb(b,a.c.length);return a.c[b]}
function PQ(a,b){Wv(yU(a.a,5),18).ib(b);return a}
function RQ(a,b){Wv(yU(a.a,0),18).ib(b);return a}
function SQ(a,b){Wv(yU(a.a,1),18).ib(b);return a}
function TQ(a,b){Wv(yU(a.a,2),18).ib(b);return a}
function UQ(a,b){Wv(yU(a.a,3),18).ib(b);return a}
function VQ(a,b){Wv(yU(a.a,4),18).ib(b);return a}
function iS(a){gS(a,(sK(),oK));a.e=true;return a}
function Pt(a){Nt();var b;b=Mt.ec(a);return Qt(b)}
function Pkb(a,b){var c;c=Mkb(a,b);c.g=2;return c}
function _ob(a,b){var c;for(c=0;c<b;++c){a[c]=0}}
function YW(a,b){a.b=b.b;a.c=b.c;a.d=b.d;a.a=b.a}
function Hub(a){a.a.b=a.b;a.b.a=a.a;a.a=a.b=null}
function NX(a){return a.b.c.length+a.e.c.length}
function zv(a){return Array.isArray(a)&&a.ad===kI}
function ol(a,b){return Il(),Tl(new Tob(a),b)!=-1}
function vv(a,b,c,d,e,f){return wv(a,b,c,d,e,0,f)}
function BJ(a,b,c){wJ();FJ.call(this,a.b,b,c,a.d)}
function AJ(a,b){wJ();FJ.call(this,a.b,b,a.c,a.d)}
function uU(a,b,c){Fxb(b,a.c.length);fxb(a.c,b,c)}
function mpb(a,b){Cxb(b,a.a.length);return a.a[b]}
function kpb(c){c.sort(function(a,b){return a-b})}
function _b(a){if(a==null){throw new Vlb}return a}
function lv(a){if(a==null){throw new Vlb}this.a=a}
function Us(a,b,c){if(a.a!=b){throw new nsb}a.a=c}
function wxb(a,b){if(!a){throw new slb((bmb(),b))}}
function Axb(a,b){if(!a){throw new rkb((bmb(),b))}}
function Dxb(a){if(a==null){throw new Vlb}return a}
function Yub(a){ytb.call(this,new wub);Ue(this,a)}
function xtb(a){this.a=new otb(a.Y());Ue(this,a)}
function Lsb(a){this.c=a;this.a=new jtb(this.c.a)}
function Er(a){Gi();this.a=(ypb(),new rqb(_b(a)))}
function xkb(){xkb=iI;vkb=(xkb(),false);wkb=true}
function Glb(){Glb=iI;Flb=xv(PF,Txb,24,256,0,1)}
function k8(){k8=iI;j8=PQ(RQ(new WQ,(d0(),z_)),X_)}
function aS(){aS=iI;ZR=new yS;_R=new FS;$R=new AS}
function dw(a){return a!=null&&fw(a)&&!(a.ad===kI)}
function _v(a){return !Array.isArray(a)&&a.ad===kI}
function Wmb(a,b){return ew(b)?Xmb(a,b):Mtb(a.d,b)}
function Ysb(a,b){return aw(b,17)&&Zsb(a,Wv(b,17))}
function $sb(a,b){return aw(b,17)&&_sb(a,Wv(b,17))}
function bub(a,b){return !(Utb(a.a,b)===undefined)}
function Vsb(a,b){var c;c=Usb(a);zpb(c,b);return c}
function Kt(a,b){!a&&(a=[]);a[a.length]=b;return a}
function rsb(a,b,c){Wsb(a.a,b);return usb(a,b.e,c)}
function omb(a,b,c){bmb();return a.lastIndexOf(b,c)}
function xxb(a,b,c){if(!a){throw new slb(Jxb(b,c))}}
function Zob(a,b,c){var d;for(d=0;d<b;++d){a[d]=c}}
function Qo(a,b){var c;c=a.a.Y();bc(b,c);return c-b}
function ud(a){var b;b=a.i;return !b?(a.i=a.T()):b}
function Ae(a){var b;b=a.c;return !b?(a.c=a.gb()):b}
function ki(a){var b;b=a.c;return !b?(a.c=a.Jb()):b}
function nj(a){if(a.e){return a.e}return a.e=a.Ob()}
function oj(a){if(a.f){return a.f}return a.f=a.Pb()}
function Hv(a,b){return Ev(a.l&b.l,a.m&b.m,a.h&b.h)}
function flb(a,b){return glb((Dxb(a),a),(Dxb(b),b))}
function Ed(a){return aw(a,20)?Wv(a,20).tb():a.mb()}
function Ml(a){Il();_b(a);while(a.G()){a.H();a.I()}}
function Uab(a){var b;b=a;while(b.g){b=b.g}return b}
function LY(a){a.b.i.a+=a.a.f*(a.a.a-1);return null}
function Sob(a){uxb(a.b!=-1);a.c.vb(a.a=a.b);a.b=-1}
function Dnb(a){Bxb(a.b>0);return a.a.sb(a.c=--a.b)}
function $f(a){a.b?$f(a.b):a.d.V()&&Wmb(a.f.b,a.e)}
function wg(a){Yf(a.d);if(a.d.d!=a.c){throw new nsb}}
function ksb(a,b){if(b[WAb]!=a[WAb]){throw new nsb}}
function Pl(a,b){Il();_b(a);_b(b);return new tm(a,b)}
function Zq(a,b){Gi();Yq.call(this,a,Yi(new opb(b)))}
function mg(a,b,c,d){this.a=a;_f.call(this,a,b,c,d)}
function GI(a){this.a=Math.cos(a);this.b=Math.sin(a)}
function GQ(a,b,c){_J.call(this,a);this.b=b;this.a=c}
function NR(a){this.b=new GU;this.a=new GU;this.c=a}
function sY(a){this.c=new FI;this.a=new GU;this.b=a}
function tu(){tu=iI;ru=new uu(false);su=new uu(true)}
function o7(a,b){++a.d;return a.c[a.c.length]=b,true}
function $ub(a,b){TI(a.d,b,a.b.b,a.b);++a.a;a.c=null}
function stb(a,b){var c;c=a.a.db(b,a);return c==null}
function cxb(a,b){var c;c=a.slice(0,b);return Cv(c,a)}
function exb(a,b){var c;c=new Array(b);return Cv(c,a)}
function usb(a,b,c){var d;d=a.b[b];a.b[b]=c;return d}
function apb(a,b){var c;for(c=0;c<b;++c){a[c]=null}}
function cpb(a,b){var c;for(c=0;c<b;++c){a[c]=false}}
function r1(a,b){return xkb(),Wv(b.b,24).a<a?wkb:vkb}
function s1(a,b){return xkb(),Wv(b.a,24).a<a?wkb:vkb}
function Tk(a,b){return Wv(ki(nj(a.a)).sb(b),21).yb()}
function dq(a){return mp(),Wl(Rm(a.a).mb(),(xp(),vp))}
function Uh(a){return Il(),new Im(Dl(ul(a.a,new yl)))}
function fw(a){return typeof a===Sxb||typeof a===Zxb}
function Ct(a){$wnd.setTimeout(function(){throw a},0)}
function oI(a,b){return a>0?new tI(a-1,b):new tI(a,b)}
function Ib(a){_b(a);return aw(a,345)?Wv(a,345):xb(a)}
function Rwb(a,b){return bwb(a.a,b,(xkb(),vkb))==null}
function Po(a,b){var c;c=a.a.Y();$b(b,c);return c-1-b}
function hu(a,b,c){var d;d=gu(a,b);iu(a,b,c);return d}
function Nkb(a,b,c){var d;d=Mkb(a,b);$kb(c,d);return d}
function Mkb(a,b){var c;c=new Kkb;c.i=a;c.d=b;return c}
function Mk(a,b,c){this.a=a;bc(c,b);this.c=b;this.b=c}
function Av(a,b,c){zxb(c==null||sv(a,c));return a[b]=c}
function Pm(a){a.a=null;a.e=null;Ymb(a.b);a.d=0;++a.c}
function Pmb(a){slb.call(this,(bmb(),a==null?Wxb:a))}
function Omb(a){slb.call(this,(bmb(),a==null?Wxb:a))}
function Om(a){var b;return b=a.f,!b?(a.f=new Pp(a)):b}
function Jd(a){var b;return b=a.k,!b?(a.k=new Qg(a)):b}
function Be(a){var b;b=a.e;return !b?(a.e=new Fp(a)):b}
function Vg(a){var b;b=a.e;!b&&(a.e=b=a.gb());return b}
function d6(a){var b,c;b=a.c.f.d;c=a.d.f.d;return b==c}
function Gfb(a,b){var c;c=new Dfb(a);Afb(c,b);return c}
function umb(a,b){a.a+=String.fromCharCode(b);return a}
function hX(a){if(!a.a&&!!a.d){return a.d.b}return a.a}
function _H(a){if(UH(a)){return a|0}return a.l|a.m<<22}
function xo(a){Mh(a,Uyb);return $s(PH(PH(5,a),a/10|0))}
function Smb(a,b){return ew(b)?Tmb(a,b):re(Ktb(a.d,b))}
function tl(a){return aw(a,19)?Wv(a,19).Y():Ul(a.mb())}
function pr(a){return a?new xtb((Oh(),a)):qr(null.mb())}
function Tb(a,b){return gw(a)===gw(b)||a!=null&&rb(a,b)}
function zT(a,b){return vT(),glb(Ixb(Yv(a)),Ixb(Yv(b)))}
function Ep(a){return mp(),Wl(a.a.bb().mb(),(xp(),wp))}
function Gi(){Gi=iI;hi();Fi=new gr((ypb(),ypb(),vpb))}
function kr(){kr=iI;hi();jr=new lr((ypb(),ypb(),xpb))}
function Exb(a,b){if(a==null){throw new Wlb((bmb(),b))}}
function Zfb(a,b){Mfb();return (a-b<=0?0-(a-b):a-b)<0.2}
function U0(a,b){return a.i.b<b.i.b?-1:a.i.b==b.i.b?0:1}
function Zjb(a,b,c,d){a.g[b.e][c.e]=d;a.g[c.e][b.e]=d}
function vnb(a){uxb(a.c!=-1);a.d.vb(a.c);a.b=a.c;a.c=-1}
function Sub(a){this.c=a;this.b=a.a.b.a;lsb(a.a.c,this)}
function ufb(a){efb.call(this,new opb(a));this.a=new FI}
function er(){Bk.call(this,new ir(new ntb));this.a=this}
function OQ(){JQ();this.b=(mp(),new ntb);this.a=new ntb}
function zp(){xp();return Bv(tv(jy,1),uyb,188,0,[vp,wp])}
function Ih(){Gh();return Bv(tv(dx,1),uyb,159,0,[Fh,Eh])}
function ss(){qs();return Bv(tv(Ty,1),uyb,205,0,[ps,os])}
function psb(a){We(a.a);a.b=xv(UF,syb,1,a.b.length,4,1)}
function krb(a){!a.b&&(a.b=new Frb(a.c.W()));return a.b}
function cwb(a,b){var c;c=new zwb;ewb(a,b,c);return c.d}
function Qkb(a,b){var c;c=Mkb('',a);c.k=b;c.g=1;return c}
function We(a){var b;for(b=a.mb();b.G();){b.H();b.I()}}
function yJ(a,b){return aw(b,79)&&emb(a.b,Wv(b,79).mc())}
function Z3(){X3();return Bv(tv(iD,1),uyb,175,0,[V3,W3])}
function a8(){Z7();return Bv(tv(WD,1),uyb,193,0,[X7,Y7])}
function s9(){p9();return Bv(tv(hE,1),uyb,192,0,[o9,n9])}
function Umb(a,b,c){return ew(b)?Vmb(a,b,c):Ltb(a.d,b,c)}
function h5(a,b,c){a.i=0;a.e=0;if(b==c){return}d5(a,b,c)}
function g5(a,b,c){a.i=0;a.e=0;if(b==c){return}c5(a,b,c)}
function t6(a,b,c,d){this.d=a;this.b=b;this.a=c;this.c=d}
function VN(a,b,c,d){this.d=a;this.e=b;this.c=c;this.b=d}
function E5(a,b,c,d){this.a=a;this.c=b;this.b=c;this.d=d}
function vO(a,b,c,d){Ac.call(this,a,b);this.a=c;this.b=d}
function Jtb(a,b){var c;c=Ttb(a.a,b);return c==null?[]:c}
function kmb(a,b){bmb();if(a==b){return 0}return a<b?-1:1}
function CR(a,b){var c;c=hR(a.f,b);return vI(zI(c),a.f.d)}
function qsb(a,b){return Ysb(a.a,b)?a.b[Wv(b,17).e]:null}
function ovb(a,b){return gw(a)===gw(b)||a!=null&&rb(a,b)}
function Pu(a,b){if(b==null){throw new Vlb}return Qu(a,b)}
function Zv(a){Hxb(a==null||fw(a)&&!(a.ad===kI));return a}
function irb(a){!a.a&&(a.a=new Nrb(a.c.bb()));return a.a}
function lrb(a){!a.d&&(a.d=new zqb(a.c.fb()));return a.d}
function _I(a){a.a.a=a.c;a.c.b=a.a;a.a.b=a.c.a=null;a.b=0}
function Cnb(a){return Bxb(a.b<a.d.Y()),a.d.sb(a.c=a.b++)}
function Xmb(a,b){return b==null?Mtb(a.d,null):eub(a.e,b)}
function $9(a,b){this.g=a;this.d=Bv(tv(qB,1),Nzb,9,0,[b])}
function KS(a){this.c=a;this.b=new Wwb(Wv(_b(new MS),56))}
function hW(){this.a=new jJ;this.b=(Mh(3,Vyb),new HU(3))}
function Dg(a,b){this.a=a;yg.call(this,a,Wv(a.d,20).ub(b))}
function rab(a,b,c,d){this.a=a;this.c=b;this.b=c;this.d=d}
function Zlb(a,b,c){this.a=Yxb;this.d=a;this.b=b;this.c=c}
function $W(){XW(this);this.d=0;this.b=0;this.a=0;this.c=0}
function Bcb(){this.b=new vtb;this.d=new aJ;this.e=new Uvb}
function ypb(){ypb=iI;vpb=new Kpb;wpb=new aqb;xpb=new iqb}
function Lc(){Lc=iI;Ic=new Oc;Hc=new Rc;Jc=new Uc;Kc=new Xc}
function Z7(){Z7=iI;X7=new $7('GREEDY',0);Y7=new $7(zAb,1)}
function zQ(){zQ=iI;yQ=new AJ((eM(),EL),(xkb(),xkb(),wkb))}
function w9(){w9=iI;v9=PQ(UQ(TQ(new WQ,(d0(),N_)),B_),M_)}
function N6(a,b){var c;c=M6(b);return Wv(Smb(a.c,c),24).a}
function PR(a,b){var c;c=utb(a.a,b);c&&(b.f=null);return c}
function Krb(a){var b;b=a.b.ob();Mrb(b,b.length);return b}
function NP(a){if(a<0){return -1}if(a>0){return 1}return 0}
function mP(){kP();return Bv(tv(Rz,1),uyb,171,0,[jP,gP,hP])}
function gL(){eL();return Bv(tv(Fz,1),uyb,166,0,[cL,bL,dL])}
function WM(){UM();return Bv(tv(Jz,1),uyb,149,0,[TM,SM,RM])}
function FO(){DO();return Bv(tv(Pz,1),uyb,225,0,[BO,AO,CO])}
function ZZ(){XZ();return Bv(tv(VB,1),uyb,221,0,[VZ,WZ,UZ])}
function A8(){x8();return Bv(tv(_D,1),uyb,173,0,[w8,v8,u8])}
function QH(a,b){return SH(Hv(UH(a)?YH(a):a,UH(b)?YH(b):b))}
function XI(a){return a.b==0?null:(Bxb(a.b!=0),$I(a,a.a.a))}
function zfb(a){a.d=a.d-15;a.b=a.b-15;a.c=a.c+15;a.a=a.a+15}
function Rn(a){this.b=a;this.c=a;a.e=null;a.c=null;this.a=1}
function nZ(a,b,c){this.d=a;this.b=new GU;this.c=b;this.a=c}
function sfb(a,b){qfb(this,new HI(a.a,a.b));rfb(this,Eo(b))}
function Xf(a,b){if(b===a){return true}Yf(a);return a.d.t(b)}
function Oeb(a){if(a==neb||a==keb){return true}return false}
function VO(a){if(!Qob(new Tob(zW(a.e)))){return}OO(a);QO(a)}
function Y2(a,b){var c;c=Wv(vub(a.e,b),116);!!c&&(a.d=true)}
function Lrb(a,b){var c;c=a.b.pb(b);Mrb(c,a.b.Y());return c}
function a6(a){var b;b=e6(a,(sN(),rN));b+=e6(a,ZM);return b}
function f6(a,b,c){j6(a,b,c,(sN(),ZM),a.f);j6(a,b,c,rN,a.n)}
function PX(a,b){!!a.f&&BU(a.f.f,a);a.f=b;!!a.f&&vU(a.f.f,a)}
function rX(a,b){!!a.d&&BU(a.d.a,a);a.d=b;!!a.d&&vU(a.d.a,a)}
function eW(a,b){!!a.d&&BU(a.d.b,a);a.d=b;!!a.d&&vU(a.d.b,a)}
function dW(a,b){!!a.c&&BU(a.c.e,a);a.c=b;!!a.c&&vU(a.c.e,a)}
function Zdb(a){var b;b=Eo(a.b);Ue(b,a.c);Ue(b,a.i);return b}
function Qxb(){if(Lxb==256){Kxb=Mxb;Mxb={};Lxb=0}++Lxb}
function Gbb(){Gbb=iI;Fbb=new Hbb(pzb,0);Ebb=new Hbb(ozb,1)}
function fgb(){fgb=iI;dgb=new ggb(ozb,0);egb=new ggb(pzb,1)}
function hgb(){fgb();return Bv(tv(fF,1),uyb,223,0,[dgb,egb])}
function xab(){vab();return Bv(tv(rE,1),uyb,242,0,[uab,tab])}
function Ibb(){Gbb();return Bv(tv(BE,1),uyb,248,0,[Fbb,Ebb])}
function Nbb(){Lbb();return Bv(tv(CE,1),uyb,247,0,[Jbb,Kbb])}
function ncb(){lcb();return Bv(tv(JE,1),uyb,194,0,[jcb,kcb])}
function Ohb(){Mhb();return Bv(tv(pF,1),uyb,174,0,[Khb,Lhb])}
function Hpb(a){ypb();return aw(a,63)?new csb(a):new Rqb(a)}
function Rm(a){var b;return b=a.g,Wv(!b?(a.g=new En(a)):b,20)}
function Ktb(a,b){return Itb(a,b,Jtb(a,b==null?0:a.b.Vc(b)))}
function tX(a){var b;return b=lX(a),'n_'+(b==null?Dlb(a.k):b)}
function ob(a){return Ikb(tb(a))+'@'+(vb(a)>>>0).toString(16)}
function ykb(a,b){return zkb(Ckb((Dxb(a),a)),Ckb((Dxb(b),b)))}
function Tmb(a,b){return b==null?re(Ktb(a.d,null)):cub(a.e,b)}
function Rr(a,b,c){return new Ur(a.c,pk(a.b,wk(a.d,b,c)),a.a)}
function hw(a){return Math.max(Math.min(a,$xb),-2147483648)|0}
function Ptb(a){this.e=a;this.b=this.e.a.entries();this.a=[]}
function xf(a){this.c=a;this.b=new rnb((new inb(this.c.a)).a)}
function Em(a){this.b=(Il(),Il(),Il(),Gl);this.a=Wv(_b(a),35)}
function EJ(a,b,c){wJ();DJ.call(this,a,b);c!=null&&(this.c=c)}
function cc(a,b,c){if(a<0||b<a||b>c){throw new okb(Wb(a,b,c))}}
function $b(a,b){if(a<0||a>=b){throw new okb(Ub(a,b))}return a}
function ac(a,b){if(a==null){throw new Wlb((bmb(),b))}return a}
function Dm(a){if(!Cm(a)){throw new nvb}a.c=a.b;return a.b.H()}
function jI(a){function b(){}
;b.prototype=a||{};return new b}
function rr(a){var b;b=new wtb(op(a.length));zpb(b,a);return b}
function Gub(a){var b;b=a.c.b.b;a.b=b;a.a=a.c.b;b.a=a.c.b.b=a}
function jwb(a){this.b=null;!a&&(a=(hsb(),hsb(),gsb));this.a=a}
function W6(a){this.b=a;this.a=new Fnb(this.b,this.b.c.length)}
function Li(a){Gi();_b(a);return a?Ki(a):Ki(Bo(new Tob(null)))}
function rt(a,b){var c=qt[a.charCodeAt(0)];return c==null?a:c}
function Skb(a,b){var c=a.a=a.a||[];return c[b]||(c[b]=a.Oc(b))}
function CU(a,b,c){var d;Gxb(b,c,a.c.length);d=c-b;hxb(a.c,b,d)}
function Ur(a,b,c){Ch.call(this,b.a);this.c=a;this.b=b;this.a=c}
function ko(a){Vm(a.c);a.e=a.a=a.c;a.c=a.c.c;++a.d;return a.a.f}
function lo(a){Vm(a.e);a.c=a.a=a.e;a.e=a.e.e;--a.d;return a.a.f}
function MX(a){return MI(Bv(tv(qz,1),Fzb,10,0,[a.f.i,a.i,a.a]))}
function GK(){EK();return Bv(tv(Cz,1),uyb,107,0,[DK,AK,BK,CK])}
function PK(){NK();return Bv(tv(Dz,1),uyb,122,0,[MK,KK,JK,LK])}
function ON(){MN();return Bv(tv(Mz,1),uyb,139,0,[KN,LN,JN,IN])}
function FN(){DN();return Bv(tv(Lz,1),uyb,150,0,[BN,CN,AN,zN])}
function Nc(){Lc();return Bv(tv(Bw,1),uyb,136,0,[Ic,Hc,Jc,Kc])}
function iT(){cT();return Bv(tv(yA,1),uyb,201,0,[$S,bT,_S,aT])}
function wN(){sN();return Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN])}
function xK(){sK();return Bv(tv(Bz,1),uyb,59,0,[qK,pK,oK,nK,rK])}
function c8(){c8=iI;b8=Cc((Z7(),Bv(tv(WD,1),uyb,193,0,[X7,Y7])))}
function _3(){_3=iI;$3=Cc((X3(),Bv(tv(iD,1),uyb,175,0,[V3,W3])))}
function u9(){u9=iI;t9=Cc((p9(),Bv(tv(hE,1),uyb,192,0,[o9,n9])))}
function Jhb(){Hhb();return Bv(tv(oF,1),uyb,140,0,[Fhb,Ghb,Ehb])}
function Jgb(){Hgb();return Bv(tv(jF,1),uyb,218,0,[Fgb,Egb,Ggb])}
function fjb(){djb();return Bv(tv(rF,1),uyb,219,0,[cjb,ajb,bjb])}
function Sjb(){Qjb();return Bv(tv(sF,1),uyb,153,0,[Njb,Pjb,Ojb])}
function ekb(){ckb();return Bv(tv(uF,1),uyb,172,0,[_jb,akb,bkb])}
function Vmb(a,b,c){return b==null?Ltb(a.d,null,c):dub(a.e,b,c)}
function wk(a,b,c){return new sk(a,false,null,(Gh(),Fh),true,b,c)}
function tsb(a,b){return $sb(a.a,b)?usb(a,Wv(b,17).e,null):null}
function ql(a){_b(a);return Ql((Il(),new Im(Dl(ul(a.a,new yl)))))}
function Epb(a){ypb();if(!a){return nqb(),mqb}return new Ipb(a)}
function Oo(a,b){var c,d;d=Qo(a,b);c=a.a.ub(d);return new bp(a,c)}
function Cpb(a,b){var c,d;d=a.Y();for(c=0;c<d;c++){a.wb(c,b[c])}}
function Xbb(a,b,c){var d;d=new Wbb;d.b=b;d.a=c;++b.b;vU(a.d,d)}
function fW(a,b,c){!!a.d&&BU(a.d.b,a);a.d=b;!!a.d&&uU(a.d.b,c,a)}
function Mnb(a,b,c){Gxb(b,c,a.Y());this.c=a;this.a=b;this.b=c-b}
function vP(a,b,c,d){sP(this);this.d=a;this.b=b;this.a=c;this.c=d}
function zr(a,b){Bk.call(this,Fpb(_b(a),_b(b)));this.b=a;this.c=b}
function Fnb(a,b){this.a=a;wnb.call(this,a);Fxb(b,a.Y());this.b=b}
function FJ(a,b,c,d){wJ();EJ.call(this,a,b,c);d!=null&&(this.d=d)}
function e5(a,b,c){a.i=0;a.e=0;if(b==c){return}d5(a,b,c);c5(a,b,c)}
function Rob(a){Bxb(a.a<a.c.c.length);a.b=a.a++;return a.c.c[a.b]}
function avb(a){Bxb(a.b.b!=a.d.a);a.c=a.b=a.b.b;--a.a;return a.c.c}
function gwb(a,b){var c;c=1-b;a.a[c]=hwb(a.a[c],c);return hwb(a,b)}
function S2(a){var b;b=(Ieb(),Ieb(),heb);a.d&&Z2(a);ni();return b}
function ZH(a){var b;if(UH(a)){b=a;return b==-0.?0:b}return Nv(a)}
function Ii(a){var b;b=(_b(a),new IU((Oh(),a)));Dpb(b);return Yi(b)}
function Rl(a){Il();var b;while(true){b=a.H();if(!a.G()){return b}}}
function Yn(a){Xn(a);Vm(a.c);a.e=a.a=a.c;a.c=a.c.b;++a.d;return a.a}
function Zn(a){Xn(a);Vm(a.e);a.c=a.a=a.e;a.e=a.e.d;--a.d;return a.a}
function Wf(a){var b;b=a.Y();if(b==0){return}a.d.Q();a.f.c-=b;$f(a)}
function At(a,b,c){var d;d=yt();try{return xt(a,b,c)}finally{Bt(d)}}
function zt(b){return function(){return At(b,this,arguments);var a}}
function sl(a){if(aw(a,19)){return Wv(a,19).V()}return !a.mb().G()}
function gr(a){Gi();this.a=(ypb(),aw(a,63)?new csb(a):new Rqb(a))}
function Mhb(){Mhb=iI;Khb=new Nhb(qzb,0);Lhb=new Nhb('TOP_LEFT',1)}
function Lbb(){Lbb=iI;Jbb=new Mbb('DOWN',0);Kbb=new Mbb('UP',1)}
function p9(){p9=iI;o9=new q9('LAYER_SWEEP',0);n9=new q9(zAb,1)}
function vab(){vab=iI;uab=new wab('UPPER',0);tab=new wab('LOWER',1)}
function yxb(a){if(a<0){throw new Ulb('Negative array size: '+a)}}
function hnb(a,b){if(aw(b,21)){return ee(a.a,Wv(b,21))}return false}
function Esb(a,b){if(aw(b,21)){return ee(a.a,Wv(b,21))}return false}
function Kub(a,b){if(aw(b,21)){return ee(a.a,Wv(b,21))}return false}
function IV(a){var b;b=new hW;qJ(b,a);sJ(b,(eM(),CL),null);return b}
function je(a,b){return b===a?'(this Map)':(bmb(),b==null?Wxb:xb(b))}
function Ld(a,b,c,d){return aw(c,63)?new ug(a,b,c,d):new mg(a,b,c,d)}
function BM(){zM();return Bv(tv(Hz,1),uyb,100,0,[yM,xM,uM,vM,wM])}
function OM(){KM();return Bv(tv(Iz,1),uyb,28,0,[JM,IM,HM,EM,GM,FM])}
function kK(){iK();return Bv(tv(Az,1),uyb,103,0,[cK,fK,gK,hK,dK,eK])}
function $K(){YK();return Bv(tv(Ez,1),uyb,133,0,[WK,UK,XK,SK,VK,TK])}
function YM(){YM=iI;XM=Cc((UM(),Bv(tv(Jz,1),uyb,149,0,[TM,SM,RM])))}
function iL(){iL=iI;hL=Cc((eL(),Bv(tv(Fz,1),uyb,166,0,[cL,bL,dL])))}
function C8(){C8=iI;B8=Cc((x8(),Bv(tv(_D,1),uyb,173,0,[w8,v8,u8])))}
function EX(){CX();return Bv(tv(pB,1),uyb,132,0,[AX,zX,xX,BX,yX,wX])}
function i4(){g4();return Bv(tv(jD,1),uyb,125,0,[e4,b4,f4,d4,c4,a4])}
function Vl(a){Il();return umb(Gb((Oh(),Nh),umb(new zmb,91),a),93).a}
function Gpb(a,b){ypb();var c;c=a.ob();ipb(c,0,c.length,b);Cpb(a,c)}
function G3(a,b,c,d,e){this.c=a;this.e=b;this.d=c;this.b=d;this.a=e}
function Peb(a,b,c,d,e){Ac.call(this,a,b);this.a=c;this.b=d;this.c=e}
function Ahb(a,b,c,d,e){Ac.call(this,a,b);this.a=c;this.b=d;this.c=e}
function QT(a,b,c){this.a=b;this.c=a;this.b=(_b(c),new IU((Oh(),c)))}
function $U(){tU(this);this.b=new HI(Uzb,Uzb);this.a=new HI(Vzb,Vzb)}
function X3(){X3=iI;V3=new Y3('QUADRATIC',0);W3=new Y3('SCANLINE',1)}
function Te(){throw new Imb('Add not supported on this collection')}
function pq(a){var b,c;c=qmb(a.Zb());b=a.Yb();return b==1?c:c+' x '+b}
function _ub(a){Bxb(a.b!=a.d.c);a.c=a.b;a.b=a.b.a;++a.a;return a.c.c}
function Ukb(a){if(a.Tc()){return null}var b=a.k;var c=fI[b];return c}
function bc(a,b){if(a<0||a>b){throw new okb(Vb(a,b,'index'))}return a}
function Zf(a,b){var c;Yf(a);c=a.d.nb(b);if(c){--a.f.c;$f(a)}return c}
function RT(a,b,c){var d;d=(_b(a),new IU((Oh(),a)));PT(new QT(d,b,c))}
function cmb(a,b){return kmb((bmb(),a.toLowerCase()),b.toLowerCase())}
function rmb(a,b){return kmb((bmb(),a.toLowerCase()),b.toLowerCase())}
function Jwb(){Fwb();return Bv(tv(DH,1),uyb,138,0,[Bwb,Cwb,Dwb,Ewb])}
function bxb(a,b,c,d){Array.prototype.splice.apply(a,[b,c].concat(d))}
function TI(a,b,c,d){var e;e=new mvb;e.c=b;e.b=c;e.a=d;d.b=c.a=e;++a.b}
function Sm(a,b){var c;c=Hpb(Bo(new mo(a,b)));Ml(new mo(a,b));return c}
function Su(d,a,b){if(b){var c=b.gc();d.a[a]=c(b)}else{delete d.a[a]}}
function iu(d,a,b){if(b){var c=b.gc();b=c(b)}else{b=undefined}d.a[a]=b}
function Dfb(a){yfb(this);this.d=a.d;this.c=a.c;this.a=a.a;this.b=a.b}
function n7(){this.g=new q7;this.c=new q7;this.a=new GU;this.k=new GU}
function dR(){this.d=new OQ;this.a=new tV;this.c=new SV;this.b=new CV}
function oR(){this.i=new GU;this.g=new FI;this.n=new xS;this.q=new xS}
function _Y(a,b,c,d){this.e=a;this.b=new GU;this.d=b;this.a=c;this.c=d}
function oT(){oT=iI;lT=new FT;mT=new HT;jT=new JT;kT=new LT;nT=new NT}
function DO(){DO=iI;BO=new EO(ozb,0);AO=new EO(qzb,1);CO=new EO(pzb,2)}
function IK(){IK=iI;HK=Cc((EK(),Bv(tv(Cz,1),uyb,107,0,[DK,AK,BK,CK])))}
function RK(){RK=iI;QK=Cc((NK(),Bv(tv(Dz,1),uyb,122,0,[MK,KK,JK,LK])))}
function QN(){QN=iI;PN=Cc((MN(),Bv(tv(Mz,1),uyb,139,0,[KN,LN,JN,IN])))}
function HN(){HN=iI;GN=Cc((DN(),Bv(tv(Lz,1),uyb,150,0,[BN,CN,AN,zN])))}
function pcb(){pcb=iI;ocb=Cc((lcb(),Bv(tv(JE,1),uyb,194,0,[jcb,kcb])))}
function Qhb(){Qhb=iI;Phb=Cc((Mhb(),Bv(tv(pF,1),uyb,174,0,[Khb,Lhb])))}
function Ao(a){_b(a);return aw(a,19)?new IU((Oh(),Wv(a,19))):Bo(a.mb())}
function yY(a){return Ckb(Ixb(Xv(rJ(a,(Rib(),Vhb)))))&&rJ(a,uib)!=null}
function UY(a){return Ckb(Ixb(Xv(rJ(a,(Rib(),Vhb)))))&&rJ(a,uib)!=null}
function jkb(a,b,c,d){b==null&&(b=Wxb);a.a+=''+(bmb(),b.substr(c,d-c))}
function Mrb(a,b){var c;for(c=0;c<b;++c){Av(a,c,new Xrb(Wv(a[c],21)))}}
function Hd(a,b){var c,d;c=Wv(sp(a.b,b),19);if(c){d=c.Y();c.Q();a.c-=d}}
function DU(a,b,c){var d;d=(Cxb(b,a.c.length),a.c[b]);a.c[b]=c;return d}
function itb(a){Bxb(a.a<a.c.a.length);a.b=a.a;gtb(a);return a.c.b[a.b]}
function Ul(a){Il();var b;b=0;while(a.G()){a.H();b=PH(b,1)}return $s(b)}
function hub(a){this.d=a;this.b=this.d.a.entries();this.a=this.b.next()}
function DT(a){this.g=a;this.f=new GU;this.a=Qlb(this.g.c.c,this.g.d.c)}
function kt(a){it();this.e=null;this.f=null;this.a='';this.b=a;this.a=''}
function wub(){ntb.call(this);pub(this);this.b.b=this.b;this.b.a=this.b}
function Bt(a){a&&It((Gt(),Ft));--ut;if(a){if(wt!=-1){Dt(wt);wt=-1}}}
function bW(a){if(!a.c||!a.d){return false}return !!a.c.f&&a.c.f==a.d.f}
function pt(){if(Date.now){return Date.now()}return (new Date).getTime()}
function lX(a){if(a.c.c.length!=0){return Wv(yU(a.c,0),33).a}return null}
function OX(a){if(a.c.c.length!=0){return Wv(yU(a.c,0),33).a}return null}
function qd(a){a.d=3;a.c=sm(a);if(a.d!=2){a.d=0;return true}return false}
function bgb(a,b,c){this.a=a;this.b=b;this.c=c;vU(a.j,this);vU(b.d,this)}
function VP(a,b,c,d){var e;a.c?(e=new Gu(hw(d))):(e=new Gu(d));Ru(b,c,e)}
function Co(a){var b,c;_b(a);b=xo(a.length);c=new HU(b);zpb(c,a);return c}
function Dv(a){var b,c,d;b=a&azb;c=a>>22&azb;d=a<0?bzb:0;return Ev(b,c,d)}
function nbb(){kbb();return Bv(tv(zE,1),uyb,141,0,[jbb,gbb,hbb,fbb,ibb])}
function Sgb(){Pgb();return Bv(tv(kF,1),uyb,115,0,[Lgb,Kgb,Ngb,Mgb,Ogb])}
function Zib(){Xib();return Bv(tv(qF,1),uyb,85,0,[Wib,Sib,Tib,Uib,Vib])}
function zK(){zK=iI;yK=Cc((sK(),Bv(tv(Bz,1),uyb,59,0,[qK,pK,oK,nK,rK])))}
function yN(){yN=iI;xN=Cc((sN(),Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN])))}
function DM(){DM=iI;CM=Cc((zM(),Bv(tv(Hz,1),uyb,100,0,[yM,xM,uM,vM,wM])))}
function F9(){F9=iI;E9=PQ(UQ(UQ(UQ(TQ(new WQ,(d0(),N_)),U_),r_),B_),M_)}
function TT(a,b){var c,d;for(d=b.mb();d.G();){c=Wv(d.H(),55);ST(a,c,0,0)}}
function VT(a,b,c){var d,e;for(e=a.mb();e.G();){d=Wv(e.H(),55);UT(d,b,c)}}
function X8(a,b,c){var d,e;d=0;for(e=0;e<b.length;e++){d+=a.Hc(b[e],d,c)}}
function AU(a,b){var c;c=(Cxb(b,a.c.length),a.c[b]);hxb(a.c,b,1);return c}
function Kl(a){var b;_b(a);Yb(true);for(b=0;b<0&&Cm(a);b++){Dm(a)}return b}
function Ymb(a){var b;a.d=new Ntb(a);a.e=new fub(a);b=a[WAb]|0;a[WAb]=b+1}
function igb(a){a.g=new vtb;a.o=new vtb;a.c=new vtb;a.j=new GU;a.d=new GU}
function Fxb(a,b){if(a<0||a>b){throw new okb('Index: '+a+', Size: '+b)}}
function Cxb(a,b){if(a<0||a>=b){throw new okb('Index: '+a+', Size: '+b)}}
function uob(a,b){var c,d;c=b.yb();d=Wvb(a,c);return !!d&&ovb(d.e,b.zb())}
function zbb(a,b){var c;c=a.d;if(b>0){return Wv(yU(c.a,b-1),9)}return null}
function xv(a,b,c,d,e,f){var g;g=yv(e,d);e!=9&&Bv(tv(a,f),b,c,e,g);return g}
function pd(a){var b;if(!od(a)){throw new nvb}a.d=1;b=a.c;a.c=null;return b}
function _f(a,b,c,d){this.f=a;this.e=b;this.d=c;this.b=d;this.c=!d?null:d.d}
function MH(b,c){if(b&&typeof b==Sxb){try{b.__gwt$exception=c}catch(a){}}}
function wT(a,b){if(a.a.$b(b.d,a.b)>0){vU(a.c,new WS(b.c,b.d,a.d));a.b=b.d}}
function W4(a,b){var c;c=glb(a.j,b.j);if(c==0){return glb(a.k,b.k)}return c}
function C6(a){var b,c;c=Wv(yU(a.f,0),7);b=Wv(rJ(c,(Rib(),uib)),7);return b}
function M6(a){var b,c;c=Wv(yU(a.f,0),7);b=Wv(rJ(c,(Rib(),uib)),7);return b}
function B$(a,b){return glb(Ixb(Yv(rJ(a,(Rib(),Cib)))),Ixb(Yv(rJ(b,Cib))))}
function Ujb(){Ujb=iI;Tjb=Cc((Qjb(),Bv(tv(sF,1),uyb,153,0,[Njb,Pjb,Ojb])))}
function gkb(){gkb=iI;fkb=Cc((ckb(),Bv(tv(uF,1),uyb,172,0,[_jb,akb,bkb])))}
function mK(){mK=iI;lK=Cc((iK(),Bv(tv(Az,1),uyb,103,0,[cK,fK,gK,hK,dK,eK])))}
function aL(){aL=iI;_K=Cc((YK(),Bv(tv(Ez,1),uyb,133,0,[WK,UK,XK,SK,VK,TK])))}
function QM(){QM=iI;PM=Cc((KM(),Bv(tv(Iz,1),uyb,28,0,[JM,IM,HM,EM,GM,FM])))}
function k4(){k4=iI;j4=Cc((g4(),Bv(tv(jD,1),uyb,125,0,[e4,b4,f4,d4,c4,a4])))}
function K1(){I1();return Bv(tv(GC,1),uyb,109,0,[G1,B1,E1,C1,D1,A1,F1,H1])}
function qM(){oM();return Bv(tv(Gz,1),uyb,41,0,[gM,fM,iM,nM,mM,lM,jM,kM,hM])}
function Bgb(){zgb();return Bv(tv(iF,1),uyb,123,0,[ygb,xgb,wgb,ugb,tgb,vgb])}
function bhb(){_gb();return Bv(tv(lF,1),uyb,124,0,[Ygb,Xgb,$gb,Wgb,Zgb,Vgb])}
function bK(){bK=iI;aK=new DJ('de.cau.cs.kieler.labels.labelManager',null)}
function ixb(){if(Date.now){return Date.now()}return (new Date).getTime()}
function Xsb(a){var b;b=Wv(cxb(a.b,a.b.length),11);return new atb(a.a,b,a.c)}
function dmb(a,b){var c;c=(bmb(),b.length);return emb(imb(a,a.length-c,c),b)}
function dwb(a,b){var c;c=new zwb;c.c=true;c.d=b.zb();return ewb(a,b.yb(),c)}
function He(a,b){var c;c=b.yb();return mp(),new Fk(c,Kd(a.b,c,Wv(b.zb(),19)))}
function BU(a,b){var c;c=zU(a,b,0);if(c==-1){return false}a.vb(c);return true}
function Cv(a,b){uv(b)!=9&&Bv(tb(b),b._c,b.__elementTypeId$,uv(b),a);return a}
function Rub(a){ksb(a.c.a.c,a);Bxb(a.b!=a.c.a.b);a.a=a.b;a.b=a.b.a;return a.a}
function qnb(a){uxb(!!a.c);ksb(a.e,a);a.c.I();a.c=null;a.b=onb(a);lsb(a.e,a)}
function Acb(a,b,c){a.a=b;a.c=c;a.b.a.Q();_I(a.d);a.e.a.c=xv(UF,syb,1,0,4,1)}
function Ar(a,b,c){Bk.call(this,Fpb(_b(a),_b(b)));this.b=a;this.c=b;this.a=c}
function j9(a,b,c,d){this.b=new l9(this);this.a=a;this.c=b;this.e=c;this.d=d}
function xub(a){$mb.call(this,a,0);pub(this);this.b.b=this.b;this.b.a=this.b}
function ywb(a,b){qob.call(this,a,b);this.a=xv(yH,syb,183,2,0,1);this.b=true}
function Qmb(a,b){return ew(b)?b==null?!!Ktb(a.d,null):bub(a.e,b):!!Ktb(a.d,b)}
function RR(a,b){return Ws(),(a-b>0?a-b:-(a-b))<=$yb||a==b||isNaN(a)&&isNaN(b)}
function Xs(a,b){Ws();return (a-b>0?a-b:-(a-b))<=$yb||a==b||isNaN(a)&&isNaN(b)}
function Z5(a){var b,c;b=true;do{b?(c=W5(a)):(c=U5(a));b=!b}while(c);S5(a,a.d)}
function Ru(a,b,c){var d;if(b==null){throw new Vlb}d=Pu(a,b);Su(a,b,c);return d}
function sJ(a,b,c){!a.n&&(a.n=new ntb);c==null?Wmb(a.n,b):Umb(a.n,b,c);return a}
function zU(a,b,c){for(;c<a.c.length;++c){if(ovb(b,a.c[c])){return c}}return -1}
function b2(a,b){while(b>=a.a.c.length){vU(a.a,new aJ)}return Wv(yU(a.a,b),20)}
function Fe(a,b){var c;c=Wv(rp(a.a,b),19);if(!c){return null}return Kd(a.b,b,c)}
function XP(a,b,c){var d;d=Pu(a,Gzb);if(!d){d=new Tu;Ru(a,Gzb,d)}Ru(d.kc(),b,c)}
function Okb(a,b,c,d,e){var f;f=Mkb(a,b);$kb(c,f);f.g=e?8:0;f.f=d;f.e=e;return f}
function mo(a,b){var c;this.f=a;this.b=b;c=Wv(Smb(a.b,b),126);this.c=!c?null:c.b}
function fJ(a,b){var c,d,e;for(d=0,e=b.length;d<e;++d){c=b[d];TI(a,c,a.c.b,a.c)}}
function GV(a,b,c,d,e,f){var g;g=IV(d);dW(g,e);eW(g,f);Fd(a.a,d,new XV(g,b,c.f))}
function bab(a,b,c){var d;d=0;a.c[c]>0&&(d+=dab(b));a.b[c]&&(d+=eab(b));return d}
function vub(a,b){var c;c=Wv(Wmb(a.c,b),176);if(c){Hub(c);return c.e}return null}
function $s(a){if(RH(a,$xb)>0){return $xb}if(RH(a,eyb)<0){return eyb}return _H(a)}
function Ph(a){Oh();Mh(a,'size');return _H(VH(WH(a,8),Nyb)?WH(a,8):Nyb),new Amb}
function ukb(a){skb.call(this,(bmb(),a==null?Wxb:xb(a)),aw(a,46)?Wv(a,46):null)}
function HU(a){tU(this);wxb(a>=0,'Initial capacity must not be negative')}
function JQ(){JQ=iI;HQ=VQ(UQ(UQ(new WQ,(d0(),O_)),C_),J_);IQ=TQ(new WQ,G_)}
function LX(){LX=iI;IX=new UX;GX=new XX;HX=new ZX;FX=new _X;JX=new bY;KX=new dY}
function Fwb(){Fwb=iI;Bwb=new Gwb('All',0);Cwb=new Kwb;Dwb=new Mwb;Ewb=new Pwb}
function x8(){x8=iI;w8=new y8(DAb,0);v8=new y8('LONGEST_PATH',1);u8=new y8(zAb,2)}
function Rv(){Rv=iI;Ov=Ev(azb,azb,524287);Pv=Ev(0,0,524288);Dv(1);Dv(2);Qv=Dv(0)}
function M1(){M1=iI;L1=Cc((I1(),Bv(tv(GC,1),uyb,109,0,[G1,B1,E1,C1,D1,A1,F1,H1])))}
function pbb(){pbb=iI;obb=Cc((kbb(),Bv(tv(zE,1),uyb,141,0,[jbb,gbb,hbb,fbb,ibb])))}
function Ugb(){Ugb=iI;Tgb=Cc((Pgb(),Bv(tv(kF,1),uyb,115,0,[Lgb,Kgb,Ngb,Mgb,Ogb])))}
function _ib(){_ib=iI;$ib=Cc((Xib(),Bv(tv(qF,1),uyb,85,0,[Wib,Sib,Tib,Uib,Vib])))}
function zvb(a){tvb();xvb(this,_H(QH(SH(Lv(UH(a)?YH(a):a,24)),bBb)),_H(QH(a,bBb)))}
function tb(a){return ew(a)?$F:cw(a)?HF:bw(a)?EF:_v(a)?a.$c:zv(a)?a.$c:a.$c||$y}
function uv(a){return a.__elementTypeCategory$==null?9:a.__elementTypeCategory$}
function Ht(a){var b,c;if(a.a){c=null;do{b=a.a;a.a=null;c=Lt(b,c)}while(a.a);a.a=c}}
function It(a){var b,c;if(a.b){c=null;do{b=a.b;a.b=null;c=Lt(b,c)}while(a.b);a.b=c}}
function oJ(a){nJ();var b,c;c=jzb;for(b=0;b<a.length;b++){a[b]>c&&(c=a[b])}return c}
function KQ(a,b){var c;c=Wv(Smb(a.b,b),106);if(!c){c=b.rc();Umb(a.b,b,c)}return c}
function rub(a,b){var c;c=Wv(Smb(a.c,b),176);if(c){uub(a,c);return c.e}return null}
function R2(a,b,c,d){var e;e=Wv(rub(a.e,b),116);e.b+=c;e.a+=d;tub(a.e,b,e);a.d=true}
function gtb(a){var b;++a.a;for(b=a.c.a.length;a.a<b;++a.a){if(a.c.b[a.a]){return}}}
function bt(a){var b,c,d;for(b=(a.g==null&&(a.g=Pt(a)),a.g),c=0,d=b.length;c<d;++c);}
function Tf(a,b){var c,d;Yf(a);d=a.d.V();c=a.d.ib(b);if(c){++a.f.c;d&&Vf(a)}return c}
function Mh(a,b){if(a<0){throw new slb(b+' cannot be negative but was: '+a)}return a}
function Yb(a){if(!a){throw new slb((bmb(),'numberToAdvance must be nonnegative'))}}
function nm(a){if(!a.a.G()){a.a=a.b.mb();if(!a.a.G()){throw new nvb}}return a.a.H()}
function Xl(a){Il();var b;_b(a);if(aw(a,108)){b=Wv(a,108);return b}return new km(a)}
function gu(d,a){var b=d.a[a];var c=(ev(),dv)[typeof b];return c?c(b):kv(typeof b)}
function K2(a,b){var c,d;for(d=new Tob(a);d.a<d.c.c.length;){c=Wv(Rob(d),7);J2(c,b)}}
function Z9(a,b){var c,d,e,f;for(d=a.d,e=0,f=d.length;e<f;++e){c=d[e];W9(a.g,c).a=b}}
function hR(a,b){var c;c=EI(xI(Wv(Smb(a.g,b),10)),RN(Wv(Smb(a.f,b),198).b));return c}
function sr(a){var b;return !od(Pl((b=(new Snb(a.b.a)).a.bb().mb(),new Ynb(b)),a.a))}
function bvb(a){var b;uxb(!!a.c);b=a.c.a;$I(a.d,a.c);a.b==a.c?(a.b=b):--a.a;a.c=null}
function gW(a){return !!a.c&&!!a.d?a.c.f+'('+a.c+')->'+a.d.f+'('+a.d+')':'e_'+txb(a)}
function gT(a,b){cT();return a==$S&&b==bT||a==bT&&b==$S||a==aT&&b==_S||a==_S&&b==aT}
function hT(a,b){cT();return a==$S&&b==_S||a==$S&&b==aT||a==bT&&b==aT||a==bT&&b==_S}
function Bhb(){zhb();return Bv(tv(nF,1),uyb,110,0,[shb,whb,thb,xhb,uhb,yhb,vhb,rhb])}
function sM(){sM=iI;rM=Cc((oM(),Bv(tv(Gz,1),uyb,41,0,[gM,fM,iM,nM,mM,lM,jM,kM,hM])))}
function UM(){UM=iI;TM=new VM('OUTSIDE',0);SM=new VM('INSIDE',1);RM=new VM('FIXED',2)}
function Hhb(){Hhb=iI;Fhb=new Ihb(tzb,0);Ghb=new Ihb('TOP',1);Ehb=new Ihb('BOTTOM',2)}
function mxb(){mxb=iI;lxb=new qxb;kxb=new oxb('ISO-LATIN-1');jxb=new oxb('ISO-8859-1')}
function lcb(){lcb=iI;jcb=new mcb('CLASSIC',0);kcb=new mcb('IMPROVE_STRAIGHTNESS',1)}
function kW(){this.e=new FI;this.a=new $W;this.d=new FI;this.b=new GU;this.c=new GU}
function kdb(a,b,c){this.b=b;this.a=a;this.c=c;vU(this.a.e,this);vU(this.b.b,this)}
function Afb(a,b){a.d=Qlb(a.d,b.d);a.c=Nlb(a.c,b.c);a.a=Nlb(a.a,b.a);a.b=Qlb(a.b,b.b)}
function $I(a,b){var c;c=b.c;b.a.b=b.b;b.b.a=b.a;b.a=b.b=null;b.c=null;--a.b;return c}
function Jl(a,b){Il();var c;_b(a);_b(b);c=false;while(b.G()){c=c|a.ib(b.H())}return c}
function pnb(a){var b;ksb(a.e,a);Bxb(a.b);a.c=a.a;b=Wv(a.a.H(),21);a.b=onb(a);return b}
function sm(a){var b;while(a.b.G()){b=a.b.H();if(a.a.D(b)){return b}}return a.d=2,null}
function _sb(a,b){if(!!b&&a.b[b.e]==b){Av(a.b,b.e,null);--a.c;return true}return false}
function TH(a){if(ezb<a&&a<dzb){return a<0?Math.ceil(a):Math.floor(a)}return SH(Jv(a))}
function rl(a){if(a){if(a.V()){throw new nvb}return a.sb(a.Y()-1)}return Rl(null.mb())}
function ybb(a,b){var c;c=a.d;if(b<c.a.c.length-1){return Wv(yU(c.a,b+1),9)}return null}
function $kb(a,b){var c;if(!a){return}b.k=a;var d=Ukb(b);if(!d){fI[a]=[b];return}d.$c=b}
function O5(a,b){var c,d;d=false;do{a.i?(c=V5(a,b)):(c=X5(a,b));d=d|c}while(c);return d}
function Bbb(a,b,c){var d,e;d=b;do{e=Ixb(a.n[d.k])+c;a.n[d.k]=e;d=a.a[d.k]}while(d!=b)}
function M4(a){var b,c;for(c=new Tob(a.a.b);c.a<c.c.c.length;){b=Wv(Rob(c),25);b.vc()}}
function bI(){cI();var a=aI;for(var b=0;b<arguments.length;b++){a.push(arguments[b])}}
function dn(a,b){var c,d;for(c=0,d=a.Y();c<d;++c){if(ovb(b,a.sb(c))){return c}}return -1}
function or(a,b){var c;ac(a,'set1');ac(b,'set2');c=(hc(),new nc(b));return new tr(a,c,b)}
function Rt(a){var b=/function(?:\s+([\w$]+))?\s*\(/;var c=b.exec(a);return c&&c[1]||Xxb}
function YQ(a,b,c){nI(c,Tzb,3);NV(a.c,b,rI(c,1));aR(a,b,rI(c,1));BV(b,rI(c,1));pI(c)}
function Dgb(){Dgb=iI;Cgb=Cc((zgb(),Bv(tv(iF,1),uyb,123,0,[ygb,xgb,wgb,ugb,tgb,vgb])))}
function dhb(){dhb=iI;chb=Cc((_gb(),Bv(tv(lF,1),uyb,124,0,[Ygb,Xgb,$gb,Wgb,Zgb,Vgb])))}
function Ilb(){Ilb=iI;Hlb=Bv(tv(mw,1),Yyb,26,12,[0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15])}
function djb(){djb=iI;cjb=new ejb(szb,0);ajb=new ejb('INPUT',1);bjb=new ejb('OUTPUT',2)}
function de(a){this.c=a;this.b=new rnb((new inb(a.b)).a);this.a=null;this.d=(Il(),Il(),Hl)}
function Nn(a){this.e=a;this.d=new wtb(op(ud(this.e).Y()));this.c=this.e.a;this.b=this.e.c}
function qR(a,b,c){this.c=a;oR.call(this);this.b=b;this.j=new VN(b.d,b.e,b.c,b.b);this.a=c}
function qI(a,b){if(a.j>0&&a.c<a.j){a.c+=b;!!a.g&&a.g.d>0&&a.e!=0&&qI(a.g,b/a.j*a.g.d)}}
function WV(a){if(a.b.d.f.g==(CX(),xX)){return Wv(rJ(a.b.d.f,(Rib(),uib)),7)}return a.b.d}
function VV(a){if(a.b.c.f.g==(CX(),xX)){return Wv(rJ(a.b.c.f,(Rib(),uib)),7)}return a.b.c}
function od(a){dc(a.d!=3);switch(a.d){case 2:return false;case 0:return true;}return qd(a)}
function CZ(a){switch(a.e){case 2:return sN(),rN;case 4:return sN(),ZM;default:return a;}}
function DZ(a){switch(a.e){case 1:return sN(),pN;case 3:return sN(),$M;default:return a;}}
function Km(a){var b;if(aw(a,90)){b=Wv(a,90);return new Lm(b.a)}else{return Il(),new dm(a)}}
function Fpb(a,b){ypb();var c;c=new otb(1);ew(a)?Vmb(c,a,b):Ltb(c.d,a,b);return new mrb(c)}
function Is(a,b){if(!a.g){return a.e}else{a.g=Is(a.g,b);--a.a;a.j=XH(a.j,b.c);return Gs(a)}}
function Js(a,b){if(!a.e){return a.g}else{a.e=Js(a.e,b);--a.a;a.j=XH(a.j,b.c);return Gs(a)}}
function Ue(a,b){var c,d,e;Dxb(b);c=false;for(e=b.mb();e.G();){d=e.H();c=c|a.ib(d)}return c}
function nr(a){var b,c,d;b=0;for(d=a.mb();d.G();){c=d.H();b+=c!=null?vb(c):0;b=~~b}return b}
function BY(a){var b,c,d,e;for(c=a.a,d=0,e=c.length;d<e;++d){b=c[d];b.B(null)}return null}
function Xeb(a){var b,c,d;d=new jJ;for(c=a.b.mb();c.G();){b=Wv(c.H(),92);QI(d,b.a)}return d}
function mfb(a){var b,c,d;b=0;for(d=a.mb();d.G();){c=Yv(d.H());b+=(Dxb(c),c)}return b/a.Y()}
function Rbb(a,b){var c;c=Wv(Smb(a.c,b),200);if(!c){c=new Ybb;c.c=b;Umb(a.c,c.c,c)}return c}
function Wsb(a,b){var c;Dxb(b);c=b.e;if(!a.b[c]){Av(a.b,c,b);++a.c;return true}return false}
function hwb(a,b){var c,d;c=1-b;d=a.a[c];a.a[c]=d.a[b];d.a[b]=a;a.b=true;d.b=false;return d}
function yI(a,b){var c;if(aw(b,10)){c=Wv(b,10);return a.a==c.a&&a.b==c.b}else{return false}}
function Bs(a,b,c){a.g=new Os(b,c);es(a,a.g,a.i);a.d=Plb(2,a.d);++a.a;a.j=PH(a.j,c);return a}
function As(a,b,c){a.e=new Os(b,c);es(a.f,a.e,a);a.d=Plb(2,a.d);++a.a;a.j=PH(a.j,c);return a}
function Nu(e,a){var b=e.a;var c=0;for(var d in b){b.hasOwnProperty(d)&&(a[c++]=d)}return a}
function he(a,b){var c,d;Dxb(b);for(d=b.bb().mb();d.G();){c=Wv(d.H(),21);a.db(c.yb(),c.zb())}}
function vcb(a,b,c){var d;d=a.a.e[Wv(b.a,9).k]-a.a.e[Wv(c.a,9).k];return hw(d>0?1:d<0?-1:0)}
function r5(a,b,c){this.g=a;this.d=b;this.e=c;this.a=new GU;p5(this);ypb();Gpb(this.a,null)}
function Os(a,b){Xb(b>0);this.b=a;this.c=b;this.j=b;this.a=1;this.d=1;this.e=null;this.g=null}
function qcb(a){a.a=null;a.e=null;a.b.c=xv(UF,syb,1,0,4,1);a.f.c=xv(UF,syb,1,0,4,1);a.c=null}
function qhb(){ohb();return Bv(tv(mF,1),uyb,113,0,[fhb,hhb,ihb,jhb,khb,lhb,nhb,ehb,ghb,mhb])}
function uvb(a){return wvb(a,26)*1.4901161193847656E-8+wvb(a,27)*1.1102230246251565E-16}
function Fo(a){return aw(a,87)?Ii(Wv(a,87)):aw(a,88)?Wv(a,88).a:aw(a,63)?new ap(a):new Ro(a)}
function Udb(a){var b;b=Wv(rJ(a,(Rib(),hib)),32);return a.g==(CX(),xX)&&(b==(sN(),rN)||b==ZM)}
function YT(a,b){if(ZT(a,b)){Fd(a.a,Wv(rJ(b,(Rib(),fib)),18),b);return true}else{return false}}
function QQ(a,b){var c;if(b){for(c=0;c<6;c++){Wv(yU(a.a,c),18).jb(Wv(yU(b.a,c),19))}}return a}
function rI(a,b){var c;if(a.b){return null}else{c=oI(a.e,a.f);QI(a.a,c);c.g=a;a.d=b;return c}}
function hJ(a,b){var c,d;for(d=WI(a,0);d.b!=d.d.c;){c=Wv(_ub(d),10);c.a+=b.a;c.b+=b.b}return a}
function J9(a,b){var c,d;for(c=0;c<b.length;c++){for(d=0;d<b[c].length;d++){b[c][d]=a[c][d]}}}
function P2(a){var b,c;for(c=new Tob(a.b.f);c.a<c.c.c.length;){b=Wv(Rob(c),7);Y2(a.a,Reb(b.g))}}
function cT(){cT=iI;$S=new fT('Q1',0);bT=new fT('Q4',1);_S=new fT('Q2',2);aT=new fT('Q3',3)}
function EK(){EK=iI;DK=new FK(szb,0);AK=new FK(qzb,1);BK=new FK('HEAD',2);CK=new FK('TAIL',3)}
function ckb(){ckb=iI;_jb=new dkb('AGGRESSIVE',0);akb=new dkb('CAREFUL',1);bkb=new dkb('OFF',2)}
function Dhb(){Dhb=iI;Chb=Cc((zhb(),Bv(tv(nF,1),uyb,110,0,[shb,whb,thb,xhb,uhb,yhb,vhb,rhb])))}
function Akb(a,b){xkb();return ew(a)?kmb(a,$v(b)):cw(a)?flb(a,Yv(b)):bw(a)?ykb(a,Xv(b)):a.F(b)}
function Es(a,b,c){var d;d=b.$b(c,a.b);return d<0?!a.e?0:Es(a.e,b,c):d>0?!a.g?0:Es(a.g,b,c):a.c}
function rk(a,b){var c,d;if(!a.b){return false}d=a.e;c=a.a.$b(b,d);return c<0|c==0&a.d==(Gh(),Fh)}
function qk(a,b){var c,d;if(!a.c){return false}d=a.g;c=a.a.$b(b,d);return c>0|c==0&a.f==(Gh(),Fh)}
function SH(a){var b;b=a.h;if(b==0){return a.l+a.m*czb}if(b==bzb){return a.l+a.m*czb-dzb}return a}
function MI(a){var b,c,d,e;b=new FI;for(d=0,e=a.length;d<e;++d){c=a[d];b.a+=c.a;b.b+=c.b}return b}
function J6(a){var b,c,d,e;for(c=a.a,d=0,e=c.length;d<e;++d){b=c[d];Q6(a,b,(sN(),pN));Q6(a,b,$M)}}
function zo(a){var b,c,d;b=1;for(d=a.mb();d.G();){c=d.H();b=31*b+(c==null?0:vb(c));b=~~b}return b}
function Tsb(a){var b,c;b=Wv(a.e&&a.e(),11);c=Wv(cxb(b,b.length),11);return new atb(b,c,b.length)}
function R6(a){this.e=gw(rJ(hX(a[0]),(eM(),uL)))===gw((NK(),JK));this.a=a;this.c=new ntb;J6(this)}
function kR(a){fR();this.g=(mp(),new ntb);this.f=new ntb;this.b=new ntb;this.c=new xk;this.i=a}
function odb(a){this.o=a;this.g=new GU;this.j=new aJ;this.n=new aJ;this.e=new GU;this.b=new GU}
function OR(a,b){stb(a.a,b);if(b.f){throw new gt('CNode belongs to another CGroup.')}b.f=a}
function eI(a,b){typeof window===Sxb&&typeof window['$gwt']===Sxb&&(window['$gwt'][a]=b)}
function K5(a,b,c,d){var e,f;e=I5(a,b,c,d);e<0&&(e=-e-1);for(f=c-1;f>=e;f--){a[f+1]=a[f]}a[e]=d}
function kab(a,b,c,d){var e,f;e=jab(a,b,c,d);e<0&&(e=-e-1);for(f=c-1;f>=e;f--){a[f+1]=a[f]}a[e]=d}
function Xe(a,b){var c,d;Dxb(b);for(d=b.mb();d.G();){c=d.H();if(!a.kb(c)){return false}}return true}
function Ll(a,b){Il();var c;_b(b);while(a.G()){c=a.H();if(!Udb(Wv(c,9))){return false}}return true}
function wV(a,b){var c,d,e;c=b.k-a.k;if(c==0){d=a.e.a*a.e.b;e=b.e.a*b.e.b;return glb(d,e)}return c}
function YH(a){var b,c,d,e;e=a;d=0;if(e<0){e+=dzb;d=bzb}c=hw(e/czb);b=hw(e-c*czb);return Ev(b,c,d)}
function n6(a,b){a.c.c=xv(UF,syb,1,0,4,1);o6(a,a.e,b);o6(a,a.a,b);ypb();Gpb(a.c,null);return p6(a)}
function c5(a,b,c){a.g=i5(a,b,(sN(),ZM),a.b);a.d=i5(a,c,ZM,a.b);if(a.g.c==0||a.d.c==0){return}f5(a)}
function d5(a,b,c){a.g=i5(a,b,(sN(),rN),a.j);a.d=i5(a,c,rN,a.j);if(a.g.c==0||a.d.c==0){return}f5(a)}
function pU(a,b,c){return new VN(Qlb(a.a,b.a)-c/2,Qlb(a.b,b.b)-c/2,Jlb(a.a-b.a)+c,Jlb(a.b-b.b)+c)}
function onb(a){if(a.a.G()){return true}if(a.a!=a.d){return false}a.a=new Ptb(a.e.d);return a.a.G()}
function xU(a,b){var c,d;c=b.ob();d=c.length;if(d==0){return false}gxb(a.c,a.c.length,c);return true}
function S5(a,b){var c,d;for(c=0;c<a.a.length;c++){for(d=0;d<a.a[c].length;d++){a.a[c][d]=b[c][d]}}}
function zpb(a,b){ypb();var c,d,e,f;f=false;for(d=0,e=b.length;d<e;++d){c=b[d];f=f|a.ib(c)}return f}
function op(a){mp();if(a<3){Mh(a,'expectedSize');return a+1}if(a<Nyb){return hw(a/0.75+1)}return $xb}
function ml(a,b){var c;if(aw(b,19)){c=(Oh(),Wv(b,19));return a.jb(c)}return Jl(a,Wv(_b(b),22).mb())}
function Ufb(a,b){var c,d;d=a.d.f;if(d.g==(CX(),AX)){return}c=Uh(mX(d));Cm(c)&&Umb(b,a,Wv(Dm(c),12))}
function Xob(a,b){var c,d;yxb(b);return c=epb(a,0,b),d=xv(mw,Yyb,26,b,12,1),dxb(a,0,d,0,c,true),d}
function swb(a,b){var c;this.c=a;c=new GU;Zvb(a,c,b,a.b,null,false,null,false);this.a=new Fnb(c,0)}
function is(a){if(!a.a){return false}else if(qk(a.c.b,a.a.b)){a.a=null;return false}else{return true}}
function ec(a){if(!a){throw new ulb((bmb(),'no calls to next() since the last call to remove()'))}}
function ev(){ev=iI;dv={'boolean':fv,'number':gv,'string':iv,'object':hv,'function':hv,'undefined':jv}}
function xR(){xR=iI;vR=rr(Bv(tv(Bz,1),uyb,59,0,[(sK(),oK),pK]));wR=rr(Bv(tv(Bz,1),uyb,59,0,[rK,nK]))}
function Apb(a){ypb();var b,c,d;d=0;for(c=a.mb();c.G();){b=c.H();d=d+(b!=null?vb(b):0);d=d|0}return d}
function Hq(a){Dq();var b,c,d;d=0;for(c=Vg(a).mb();c.G();){b=Wv(c.H(),83);d=PH(d,b.Yb())}return $s(d)}
function dS(a){var b,c;for(c=new Tob(a.a.b);c.a<c.c.c.length;){b=Wv(Rob(c),25);b.i.Q()}a.c.Dc(a);eS(a)}
function eub(a,b){var c;c=Utb(a.a,b);if(c===undefined){++a.d}else{a.a[$Ab](b);--a.c;msb(a.b)}return c}
function X5(a,b){var c,d,e,f;c=false;d=a.d[b].length;for(e=d-1;e>0;e--){f=e-1;c=c|Y5(a,b,f,e)}return c}
function V5(a,b){var c,d,e,f;c=false;d=a.d[b].length;for(f=0;f<d-1;f++){e=f+1;c=c|Y5(a,b,f,e)}return c}
function Gv(a,b){var c,d,e;c=a.l+b.l;d=a.m+b.m+(c>>22);e=a.h+b.h+(d>>22);return Ev(c&azb,d&azb,e&bzb)}
function Mv(a,b){var c,d,e;c=a.l-b.l;d=a.m-b.m+(c>>22);e=a.h-b.h+(d>>22);return Ev(c&azb,d&azb,e&bzb)}
function LI(a,b){var c;for(c=0;c<(bmb(),b.length);c++){if(a==b.charCodeAt(c)){return true}}return false}
function yP(a,b){var c;for(c=0;c<(bmb(),b.length);c++){if(a==b.charCodeAt(c)){return true}}return false}
function rJ(a,b){var c,d;if(a.n){d=Smb(a.n,b);if(d!=null){return d}}c=zJ(b);aw(c,5)&&sJ(a,b,c);return c}
function lJ(a){var b,c,d;b=new jJ;for(d=WI(a,0);d.b!=d.d.c;){c=Wv(_ub(d),10);rn(b,0,new II(c))}return b}
function Q6(a,b,c){var d,e,f,g;g=new U6(b,c);f=0;for(e=T6(g);e.G();){d=Wv(e.H(),7);Umb(a.c,d,Elb(f++))}}
function Fb(a,b,c){_b(b);if(c.G()){vmb(b,a.C(c.H()));while(c.G()){vmb(b,a.c);vmb(b,a.C(c.H()))}}return b}
function g9(a,b,c,d,e){if(d){h9(a,b)}else{d9(a,b,e);e9(a,b,c)}if(b.c.length>1){Gpb(b,a.b);V9(a.c,b)}}
function Bv(a,b,c,d,e){e.$c=a;e._c=b;e.ad=kI;e.__elementTypeId$=c;e.__elementTypeCategory$=d;return e}
function vS(a,b,c){switch(c.e){case 2:a.b=b;break;case 1:a.c=b;break;case 4:a.d=b;break;case 3:a.a=b;}}
function B6(a,b,c){var d,e;e=C6(c).g;d=w6(a,b,e).a;return d-Klb(Wv(Smb(a.c,b),24).a-Wv(Smb(a.c,c),24).a)}
function glb(a,b){if(a<b){return -1}if(a>b){return 1}if(a==b){return 0}return isNaN(a)?isNaN(b)?0:1:-1}
function Yi(a){switch(a.Y()){case 0:return Fi;case 1:return new Er(a.mb().H());default:return new gr(a);}}
function Nt(){Nt=iI;var a,b;b=!(!!Error.stackTraceLimit||'stack' in new Error);a=new _t;Mt=b?new Tt:a}
function RP(){RP=iI;OP=new DJ('intCoordinates',(xkb(),xkb(),vkb));PP=new CJ('jsonObject');QP=new HI(0,0)}
function XZ(){XZ=iI;VZ=new YZ('MIRROR_X',0);WZ=new YZ('TRANSPOSE',1);UZ=new YZ('MIRROR_AND_TRANSPOSE',2)}
function Hgb(){Hgb=iI;Fgb=new Igb(tzb,0);Egb=new Igb('INCOMING_ONLY',1);Ggb=new Igb('OUTGOING_ONLY',2)}
function Seb(){Ieb();return Bv(tv(_E,1),uyb,60,0,[meb,jeb,ieb,peb,oeb,Heb,Geb,neb,keb,leb,qeb,Eeb,Feb])}
function b3(){b3=iI;var a,b,c,d;a3=new vsb(_E);for(b=Seb(),c=0,d=b.length;c<d;++c){a=b[c];ssb(a3,a,null)}}
function Bpb(a){ypb();var b,c,d;d=1;for(c=a.mb();c.G();){b=c.H();d=31*d+(b!=null?vb(b):0);d=d|0}return d}
function Tl(a,b){Il();var c,d;ac(b,'predicate');for(d=0;a.G();d++){c=a.H();if(b.D(c)){return d}}return -1}
function Or(a,b){var c,d;c=a.c.a;d=b.ac(c);a.b.b&&(d=XH(d,Nr(a,b,c)));a.b.c&&(d=XH(d,Mr(a,b,c)));return d}
function bwb(a,b,c){var d,e;d=new ywb(b,c);e=new zwb;a.b=_vb(a,a.b,d,e);e.b||++a.c;a.b.b=false;return e.d}
function gJ(a,b,c){var d,e,f;d=new aJ;for(f=WI(c,0);f.b!=f.d.c;){e=Wv(_ub(f),10);QI(d,new II(e))}sn(a,b,d)}
function Mp(a,b){var c;if(b===a){return true}if(aw(b,144)){c=Wv(b,144);return a.P().t(c.P())}return false}
function Svb(a){var b;b=a.a.c.length;if(b>0){return Dvb(b-1,a.a.c.length),AU(a.a,b-1)}else{throw new osb}}
function p2(a){if(a.b.c.length-a.e.c.length<0){QX(a,(sN(),ZM));a.a.a=a.j.a}else{QX(a,(sN(),rN));a.a.a=0}}
function $mb(a,b){wxb(a>=0,'Negative initial capacity');wxb(b>=0,'Non-positive load factor');Ymb(this)}
function rnb(a){var b;this.e=a;this.d=new hub(this.e.e);this.a=this.d;this.b=onb(this);b=a[WAb];this[WAb]=b}
function Kkb(){++Fkb;this.n=null;this.j=null;this.i=null;this.d=null;this.b=null;this.k=null;this.a=null}
function fpb(a){var b,c,d,e;e=1;for(c=0,d=a.length;c<d;++c){b=a[c];e=31*e+(b!=null?vb(b):0);e=e|0}return e}
function Cc(a){var b,c,d,e;b={};for(d=0,e=a.length;d<e;++d){c=a[d];b[':'+(c.d!=null?c.d:''+c.e)]=c}return b}
function wO(a){uO();var b,c,d,e;for(c=xO(),d=0,e=c.length;d<e;++d){b=c[d];if(Zi(b.a,a)){return b}}return tO}
function Itb(a,b,c){var d,e,f;for(e=0,f=c.length;e<f;++e){d=c[e];if(a.b.Uc(b,d.yb())){return d}}return null}
function Rmb(a,b,c){var d,e;for(e=c.mb();e.G();){d=Wv(e.H(),21);if(a.Uc(b,d.zb())){return true}}return false}
function Wvb(a,b){var c,d,e;e=a.b;while(e){c=a.a.$b(b,e.d);if(c==0){return e}d=c<0?0:1;e=e.a[d]}return null}
function Ge(a,b){var c,d;c=Wv(Wmb(a.a,b),19);if(!c){return null}d=a.b.Z();d.jb(c);a.b.c-=c.Y();c.Q();return d}
function y0(a,b,c){var d;d=Wv(b.B(a),9);while(d.g==(CX(),zX)){!d.n&&(d.n=new ntb);Wmb(d.n,c);d=Wv(b.B(d),9)}}
function RH(a,b){var c;if(UH(a)&&UH(b)){c=a-b;if(!isNaN(c)){return c}}return Iv(UH(a)?YH(a):a,UH(b)?YH(b):b)}
function OH(a){var b;if(aw(a,46)){return a}b=a&&a.__gwt$exception;if(!b){b=new kt(a);Ot(b,a);MH(a,b)}return b}
function p6(a){var b,c,d;b=0;for(d=new Tob(a.c);d.a<d.c.c.length;){c=Wv(Rob(d),226);b+=b6(a,c.a,c.b)}return b}
function pT(a){var b;b=new DT(a);RT(a.a,nT,new opb(Bv(tv(JA,1),syb,160,0,[b])));!!b.d&&vU(b.f,b.d);return b.f}
function w6(a,b,c){switch(c.e){case 1:return Wv(Smb(a.d,b),24);case 3:return Wv(Smb(a.j,b),24);}return Elb(0)}
function M5(a,b,c){if(!a.d[b.k][c.k]){L5(a,b,c);a.d[b.k][c.k]=true;a.d[c.k][b.k]=true}return a.a[b.k][c.k]}
function Ds(a,b,c){var d;d=b.$b(c,a.b);return d<0?!a.e?a:Wv(Sb(Ds(a.e,b,c),a),206):d==0?a:!a.g?null:Ds(a.g,b,c)}
function rb(a,b){return ew(a)?emb(a,b):cw(a)?(Dxb(a),a===b):bw(a)?(Dxb(a),a===b):_v(a)?a.t(b):zv(a)?a===b:a===b}
function vQ(a,b){return emb(a.b,b)||dmb(a.b,b)&&((bmb(),b.length)==pmb(a.b)||jmb(a.b,pmb(a.b)-b.length-1)==46)}
function L6(a,b){var c,d,e;c=0;for(e=nX(a,b).mb();e.G();){d=Wv(e.H(),7);c+=rJ(d,(Rib(),Bib))!=null?1:0}return c}
function Xvb(a,b){var c,d,e;d=null;e=a.b;while(e){c=a.a.$b(b,e.d);if(c>=0){e=e.a[1]}else{d=e;e=e.a[0]}}return d}
function Yvb(a,b){var c,d,e;d=null;e=a.b;while(e){c=a.a.$b(b,e.d);if(c<=0){e=e.a[0]}else{d=e;e=e.a[1]}}return d}
function u0(a,b,c,d){var e,f;for(f=a.mb();f.G();){e=Wv(f.H(),33);e.i.a=b.a+(d.a-e.j.a)/2;e.i.b=b.b;b.b+=e.j.b+c}}
function o$(a,b){var c;if(a.c.length==0){return}c=Wv(FU(a,xv(qB,Nzb,9,a.c.length,0,1)),51);lpb(c,new z$);l$(c,b)}
function t$(a,b){var c;if(a.c.length==0){return}c=Wv(FU(a,xv(qB,Nzb,9,a.c.length,0,1)),51);lpb(c,new C$);l$(c,b)}
function _Z(a){var b,c;b=a.g;if(b==(CX(),xX)){c=Wv(rJ(a,(Rib(),hib)),32);return c==(sN(),$M)||c==pN}return false}
function Gc(a,b){var c;Dxb(b);c=a[':'+b];xxb(!!c,'Enum constant undefined: %s',Bv(tv(UF,1),syb,1,4,[b]));return c}
function Zb(a,b,c){if(!a){throw new slb(fc('lowerEndpoint (%s) > upperEndpoint (%s)',Bv(tv(UF,1),syb,1,4,[b,c])))}}
function kv(a){ev();throw new zu("Unexpected typeof result '"+a+"'; please report this bug to the GWT team")}
function tN(a){switch(a.e){case 1:return pN;case 2:return rN;case 3:return $M;case 4:return ZM;default:return qN;}}
function vK(a){switch(a.e){case 2:return pK;case 1:return oK;case 4:return nK;case 3:return rK;default:return qK;}}
function Dkb(a){if(a>=48&&a<58){return a-48}if(a>=97&&a<97){return a-97+10}if(a>=65&&a<65){return a-65+10}return -1}
function td(a,b){var c,d;for(d=Ep(Be(a.P()));d.b.G();){c=Wv(zm(d,d.b.H()),19);if(c.kb(b)){return true}}return false}
function js(a){var b;if(!is(a)){throw new nvb}b=new fs(a.c,a.a);a.b=b;a.a.i==a.c.a?(a.a=null):(a.a=a.a.i);return b}
function pp(a,b){mp();var c;if(a===b){return true}else if(aw(b,57)){c=Wv(b,57);return mr(nj(a),c.bb())}return false}
function Gq(a,b,c,d){Dq();Mh(c,'oldCount');Mh(d,'newCount');if(a.Cb(b)==c){a.Gb(b,d);return true}else{return false}}
function Bh(a,b,c,d,e){_b(c);_b(e);return Rr(new Ur(a.c,pk(a.b,new sk(a.d,true,b,c,false,null,(Gh(),Fh))),a.a),d,e)}
function ck(a){hi();switch(a.Y()){case 0:return kr(),jr;case 1:return new Gr(a.mb().H());default:return new lr(a);}}
function PH(a,b){var c;if(UH(a)&&UH(b)){c=a+b;if(ezb<c&&c<dzb){return c}}return SH(Gv(UH(a)?YH(a):a,UH(b)?YH(b):b))}
function WH(a,b){var c;if(UH(a)&&UH(b)){c=a*b;if(ezb<c&&c<dzb){return c}}return SH(Kv(UH(a)?YH(a):a,UH(b)?YH(b):b))}
function XH(a,b){var c;if(UH(a)&&UH(b)){c=a-b;if(ezb<c&&c<dzb){return c}}return SH(Mv(UH(a)?YH(a):a,UH(b)?YH(b):b))}
function sK(){sK=iI;qK=new wK(szb,0);pK=new wK(pzb,1);oK=new wK(ozb,2);nK=new wK('DOWN',3);rK=new wK('UP',4)}
function NK(){NK=iI;MK=new OK(szb,0);KK=new OK('POLYLINE',1);JK=new OK('ORTHOGONAL',2);LK=new OK('SPLINES',3)}
function eL(){eL=iI;cL=new fL('INHERIT',0);bL=new fL('INCLUDE_CHILDREN',1);dL=new fL('SEPARATE_CHILDREN',2)}
function G8(){G8=iI;D8=TQ(RQ(new WQ,(d0(),p_)),I_);E8=PQ(TQ(SQ(new WQ,j_),h_),i_);F8=PQ(UQ(new WQ,k_),i_)}
function P8(){P8=iI;M8=TQ(RQ(new WQ,(d0(),p_)),I_);N8=PQ(TQ(SQ(new WQ,j_),h_),i_);O8=PQ(UQ(new WQ,k_),i_)}
function deb(a){this.a=new Wub;this.d=new Wub;this.b=new Wub;this.c=new Wub;this.g=new Wub;this.i=new Wub;this.f=a}
function UV(a,b,c,d,e,f){this.e=new GU;this.f=(djb(),cjb);vU(this.e,a);this.d=b;this.a=c;this.b=d;this.f=e;this.c=f}
function hpb(a,b,c,d,e,f,g,h){var i;i=c;while(f<g){i>=d||b<c&&h.$b(a[b],a[i])<=0?Av(e,f++,a[b++]):Av(e,f++,a[i++])}}
function v0(a,b,c,d,e){var f,g;for(g=a.mb();g.G();){f=Wv(g.H(),33);f.i.a=b.a;f.i.b=e?b.b:b.b+d.b-f.j.b;b.a+=f.j.a+c}}
function gcb(a,b){$bb();var c,d;for(d=Uh(gX(a));Cm(d);){c=Wv(Dm(d),12);if(c.d.f==b||c.c.f==b){return c}}return null}
function fdb(a,b,c){var d,e,f;d=0;for(f=WI(a,0);f.b!=f.d.c;){e=Ixb(Yv(_ub(f)));if(e>c){break}else e>=b&&++d}return d}
function sn(a,b,c){var d,e,f,g;Dxb(c);g=false;f=WI(a,b);for(e=WI(c,0);e.b!=e.d.c;){d=_ub(e);$ub(f,d);g=true}return g}
function Uf(a,b){var c,d,e;if(b.V()){return false}e=a.Y();c=a.d.jb(b);if(c){d=a.d.Y();a.f.c+=d-e;e==0&&Vf(a)}return c}
function qJ(a,b){var c;if(!b){return a}c=!b.n?(ypb(),ypb(),wpb):b.n;c.V()||(!a.n?(a.n=new ptb(c)):he(a.n,c));return a}
function Gb(b,c,d){var e;try{Fb(b,c,d)}catch(a){a=OH(a);if(aw(a,181)){e=a;throw new ukb(e)}else throw NH(a)}return c}
function Qb(b,c,d){var e;try{Pb(b,c,d)}catch(a){a=OH(a);if(aw(a,181)){e=a;throw new ukb(e)}else throw NH(a)}return c}
function NH(a){var b;if(aw(a,164)){b=Wv(a,164);if(gw(b.b)!==gw((it(),ht))){return gw(b.b)===gw(ht)?null:b.b}}return a}
function SW(a,b){var c;c=Wv(rJ(hX(a),(Rib(),zib)),9);while(c){if(c==b){return true}c=Wv(rJ(hX(c),zib),9)}return false}
function EZ(a){switch(Wv(rJ(a,(Rib(),mib)),140).e){case 1:sJ(a,mib,(Hhb(),Ehb));break;case 2:sJ(a,mib,(Hhb(),Ghb));}}
function Kk(a){hi();switch(a.c){case 0:return kr(),jr;case 1:return new Gr(Sl(new jtb(a)));default:return new Jk(a);}}
function Ti(a){Gi();var b,c;for(b=0,c=a.length;b<c;b++){if(a[b]==null){throw new Wlb('at index '+b)}}return new opb(a)}
function $4(a,b,c){if(b.length==0||c.length==0){return 0}a.e?(a.b=new y5(a.c)):(a.b=new H5(a.c));return a.b.Gc(b,c)}
function pI(a){if(a.i==null){throw new ulb('The task has not begun yet.')}if(!a.b){a.c<a.j&&qI(a,a.j-a.c);a.b=true}}
function DR(a,b){var c,d;for(d=new Tob(b);d.a<d.c.c.length;){c=Wv(Rob(d),27);BU(a.b.b,c.b);PR(Wv(c.a,78),Wv(c.b,25))}}
function aU(a,b){var c,d;for(d=new Tob(a.a);d.a<d.c.c.length;){c=Wv(Rob(d),222);if(YT(c,b)){return}}vU(a.a,new _T(b))}
function aV(a){var b,c,d;b=new GU;for(d=new Tob(a.b);d.a<d.c.c.length;){c=Wv(Rob(d),251);xU(b,Wv(c.Ac(),19))}return b}
function Q0(a,b){var c,d,e;e=new GU;for(d=nX(a,b).mb();d.G();){c=Wv(d.H(),7);e.c[e.c.length]=c}Gpb(e,new V0);return e}
function iX(a){var b,c,d;b=new GU;for(d=new Tob(a.f);d.a<d.c.c.length;){c=Wv(Rob(d),7);vU(b,c.b)}return _b(b),new Vh(b)}
function mX(a){var b,c,d;b=new GU;for(d=new Tob(a.f);d.a<d.c.c.length;){c=Wv(Rob(d),7);vU(b,c.e)}return _b(b),new Vh(b)}
function Elb(a){var b,c;if(a>-129&&a<128){b=a+128;c=(Glb(),Flb)[b];!c&&(c=Flb[b]=new wlb(a));return c}return new wlb(a)}
function R5(a){var b,c;b=Z4(a.b,a.d);c=$xb;while(c>b){S5(a,a.d);if(b==0){c=0;break}W5(a);U5(a);c=b;b=Z4(a.b,a.d)}a.c=c}
function yvb(){tvb();var a,b,c;c=svb+++ixb();a=hw(Math.floor(c*FAb))&bBb;b=hw(c-a*aBb);this.a=a^1502;this.b=b^_Ab}
function vb(a){return ew(a)?Pxb(a):cw(a)?hw((Dxb(a),a)):bw(a)?Ckb((Dxb(a),a))?1231:1237:_v(a)?a.v():zv(a)?txb(a):txb(a)}
function AQ(a,b,c){var d,e,f;e=new jQ;e.d=c;d=UP(e,b);f=new dR;Ckb(Ixb(Xv(rJ(d,yQ))))?YQ(f,d,new sI):BQ(a,f,d);ZP(e,d)}
function E6(a,b,c,d){var e,f,g,h;h=new U6(b,d);g=0;for(f=T6(h);f.G();){e=Wv(f.H(),7);Umb(a.i,e,Elb(g++))}Umb(c,b,Elb(g))}
function c6(a,b){var c,d,e,f,g;c=0;g=0;for(e=0,f=b.length;e<f;++e){d=b[e];c=i6(a,c,d,(sN(),ZM),a.f);g=i6(a,g,d,rN,a.n)}}
function pJ(a,b){var c,d,e,f;if(!a.n){return}for(d=0,e=b.length;d<e;++d){c=b[d];f=Smb(a.n,c);if(f!=null){c.nc();c.oc()}}}
function L2(a,b){var c,d,e;for(d=new Tob(b);d.a<d.c.c.length;){c=Wv(Rob(d),75);e=X2(a.a);R2(a.a,e,c.k,c.j);aeb(c,e,true)}}
function M2(a,b){var c,d,e;for(d=new Tob(b);d.a<d.c.c.length;){c=Wv(Rob(d),75);e=W2(a.a);R2(a.a,e,c.k,c.j);aeb(c,e,true)}}
function PW(a){var b,c;c=Wv(rJ(a,(eM(),sL)),59);if(c==(sK(),qK)){b=Wv(rJ(a,(Rib(),Rhb)),15).a;return b>=1?pK:nK}return c}
function Cm(a){_b(a.b);if(a.b.G()){return true}while(a.a.G()){_b(a.b=a.Wb(a.a.H()));if(a.b.G()){return true}}return false}
function m7(a){if(a.d!=a.c.d||a.i!=a.g.d){a.a.c=xv(UF,syb,1,0,4,1);xU(a.a,a.c);xU(a.a,a.g);a.d=a.c.d;a.i=a.g.d}return a.a}
function Yf(a){var b;if(a.b){Yf(a.b);if(a.b.d!=a.c){throw new nsb}}else if(a.d.V()){b=Wv(Smb(a.f.b,a.e),19);!!b&&(a.d=b)}}
function H9(a,b,c,d,e){var f,g,h,i;i=Co(a);g9(b,i,d,e,c);f=0;for(h=new Tob(i);h.a<h.c.c.length;){g=Wv(Rob(h),9);a[f++]=g}}
function oP(a){var b,c,d;d=Wv(vW(a.a,(eM(),DL)),15).a;for(c=new Tob(uW(a.a));c.a<c.c.c.length;){b=Wv(Rob(c),626);qP(a,b,d)}}
function WQ(){var a,b;this.a=new HU(6);for(b=0;b<6;b++){vU(this.a,(a=Wv(Hkb(mC),11),new atb(a,Wv(exb(a,a.length),11),0)))}}
function W5(a){var b,c,d;d=false;for(c=0;c<a.d.length;c++){a.j=(b=new N5(a.e,a.d,c,0),new b7(c,a.d,b));d=d|O5(a,c)}return d}
function H8(a,b,c){var d,e;e=a.a.c;for(d=e.c.length;d<c;d++){uU(e,0,new sY(a.a))}rX(b,Wv(yU(e,e.c.length-c),16));a.b[b.k]=c}
function hdb(a,b){var c,d;c=WI(a,0);while(c.b!=c.d.c){d=Ixb(Yv(_ub(c)));if(d==b){return}else if(d>b){avb(c);break}}$ub(c,b)}
function dub(a,b,c){var d;d=Utb(a.a,b);Wtb(a.a,b,c===undefined?null:c);if(d===undefined){++a.c;msb(a.b)}else{++a.d}return d}
function qgb(a,b,c){if((b-a<=0?0-(b-a):b-a)<uAb||(c-a<=0?0-(c-a):c-a)<uAb){return true}return b-a>uAb?a-c>uAb:c-a>uAb}
function Qgb(a){switch(a.e){case 0:return Kgb;case 1:return Lgb;case 2:return Mgb;case 3:return Ngb;default:return Ogb;}}
function uS(a,b){switch(b.e){case 2:return a.b;case 1:return a.c;case 4:return a.d;case 3:return a.a;default:return false;}}
function vN(a){sN();switch(a.e){case 4:return $M;case 1:return ZM;case 3:return pN;case 2:return rN;default:return qN;}}
function c7(a,b){if(b==a.c){return a.d}else if(b==a.d){return a.c}else{throw new slb('Node '+b+' not part of edge '+a)}}
function zO(a,b){var c;if(Zsb(a.a,b)){return Wv(Zsb(a.a,b)?a.b[b.e]:null,62)}else{c=new ZN;Wsb(a.a,b);usb(a,b.e,c);return c}}
function Zeb(a,b){var c,d,e,f;f=a.g.tb();c=0;while(f.G()){d=Ixb(Yv(f.H()));e=d-b;if(e>RAb){return c}else e>SAb&&++c}return c}
function Usb(a){var b,c,d,e;c=(b=Wv(Hkb((d=a.$c,e=d.f,e==IF?d:e)),11),new atb(b,Wv(exb(b,b.length),11),0));Wsb(c,a);return c}
function yR(a,b){var c,d;for(d=new Tob(b);d.a<d.c.c.length;){c=Wv(Rob(d),27);vU(a.b.b,Wv(c.b,25));OR(Wv(c.a,78),Wv(c.b,25))}}
function gpb(a,b,c,d){var e,f,g;for(e=b+1;e<c;++e){for(f=e;f>b&&d.$b(a[f-1],a[f])>0;--f){g=a[f];Av(a,f,a[f-1]);Av(a,f-1,g)}}}
function k3(a){var b,c;if(!MM(Wv(rJ(a,(eM(),TL)),28))){for(c=new Tob(a.f);c.a<c.c.c.length;){b=Wv(Rob(c),7);QX(b,(sN(),qN))}}}
function oX(a,b){switch(b.e){case 1:return pl(a.f,(LX(),GX));case 2:return pl(a.f,(LX(),IX));default:return ypb(),ypb(),vpb;}}
function oW(a,b){if(yJ(b,(eM(),cM))){return rJ(a.e,(Rib(),Jib))}else if(yJ(b,LL)){return rJ(a.e,(Rib(),tib))}return rJ(a.e,b)}
function I5(a,b,c,d){var e,f,g;f=b;e=c-1;while(f<=e){g=(f+e)/2|0;if(a[g]==d){return g}else a[g]<d?(f=g+1):(e=g-1)}return -f-1}
function Ve(a,b,c){var d,e;for(e=a.mb();e.G();){d=e.H();if(gw(b)===gw(d)||b!=null&&rb(b,d)){c&&e.I();return true}}return false}
function epb(a,b,c){var d;xxb(b<=c,'%s > %s',Bv(tv(UF,1),syb,1,4,[Elb(b),Elb(c)]));d=a.length;c=c<d?c:d;Gxb(b,c,d);return c-b}
function aW(a,b){var c,d,e;c=a;e=0;do{if(c==b){return e}d=Wv(rJ(c,(Rib(),zib)),9);if(!d){throw new rlb}c=hX(d);++e}while(true)}
function U5(a){var b,c,d;d=false;for(c=a.d.length-1;c>=0;c--){a.j=(b=new N5(a.e,a.d,c,1),new b7(c,a.d,b));d=d|O5(a,c)}return d}
function k6(a){this.f=(mp(),new ntb);this.n=new ntb;this.k=new ntb;this.g=new vtb;this.i=new Vr((Tq(),Sq));this.j=a;c6(this,a)}
function vsb(a){var b;this.a=(b=Wv(a.e&&a.e(),11),new atb(b,Wv(exb(b,b.length),11),0));this.b=xv(UF,syb,1,this.a.a.length,4,1)}
function jf(a,b){var c;if(b===a){return true}if(!aw(b,18)){return false}c=Wv(b,18);if(c.Y()!=a.Y()){return false}return a.lb(c)}
function Reb(a){Ieb();switch(a.e){case 1:return meb;case 2:return ieb;case 3:return oeb;case 4:return Geb;default:return Feb;}}
function pgb(a,b){switch(b.e){case 1:return a.e.d;case 2:return a.e.c;case 3:return a.e.a;case 4:return a.e.b;default:return 0;}}
function xO(){uO();return Bv(tv(Oz,1),uyb,67,0,[rO,qO,sO,iO,hO,jO,mO,lO,kO,pO,oO,nO,fO,eO,gO,cO,bO,dO,_N,$N,aO,tO])}
function zM(){zM=iI;yM=new AM(szb,0);xM=new AM('JUSTIFIED',1);uM=new AM('BEGIN',2);vM=new AM(qzb,3);wM=new AM('END',4)}
function DN(){DN=iI;BN=new EN('PORTS',0);CN=new EN('PORT_LABELS',1);AN=new EN('NODE_LABELS',2);zN=new EN('MINIMUM_SIZE',3)}
function kP(){kP=iI;jP=new lP('UNKNOWN',0);gP=new lP('ABOVE',1);hP=new lP('BELOW',2);iP=new DJ('de.cau.cs.kieler.labelSide',jP)}
function Qjb(){Qjb=iI;Njb=new Rjb('EQUALLY_DISTRIBUTED',0);Pjb=new Rjb('NORTH_STACKED',1);Ojb=new Rjb('NORTH_SEQUENCE',2)}
function gI(){fI={};!Array.isArray&&(Array.isArray=function(a){return Object.prototype.toString.call(a)==='[object Array]'})}
function SR(a,b){return Ws(),Ws(),((a-b>0?a-b:-(a-b))<=$yb||a==b||isNaN(a)&&isNaN(b)?0:a<b?-1:a>b?1:Ys(isNaN(a),isNaN(b)))>0}
function TR(a,b){return Ws(),Ws(),((a-b>0?a-b:-(a-b))<=$yb||a==b||isNaN(a)&&isNaN(b)?0:a<b?-1:a>b?1:Ys(isNaN(a),isNaN(b)))<0}
function Veb(a){var b,c;a.d||cfb(a);c=new jJ;b=a.b.mb();b.H();while(b.G()){QI(c,Wv(b.H(),92).a)}Bxb(c.b!=0);$I(c,c.c.b);return c}
function $db(a){var b,c,d,e;e=new Wub;b=new IU(a.c);Dpb(b);for(d=new Tob(b);d.a<d.c.c.length;){c=Wv(Rob(d),7);e.a.db(c,e)}return e}
function Np(a,b){var c,d,e;_b(b);for(d=(e=a.g,Wv(!e?(a.g=new En(a)):e,20)).mb();d.G();){c=Wv(d.H(),21);Fd(b,c.zb(),c.yb())}return b}
function mf(a,b){var c,d,e;if(aw(b,21)){c=Wv(b,21);d=c.yb();e=rp(a.qb(),d);return Tb(e,c.zb())&&(e!=null||a.qb().R(d))}return false}
function Yeb(a,b){var c,d,e;e=a.g.tb();while(e.G()){c=Ixb(Yv(e.H()));d=c-b<=0?0-(c-b):c-b;if(d<RAb){return e.L()-1}}return a.g.Y()}
function Vfb(a){var b,c;for(c=new Tob(a.a);c.a<c.c.c.length;){b=Wv(Rob(c),9);if(b.g==(CX(),AX)||b.g==wX){return false}}return true}
function nI(a,b,c){if(a.b){throw new ulb('The task is already done.')}else if(a.i!=null){return false}else{a.i=b;a.j=c;return true}}
function A5(a,b){if(a.f<b.f){return -1}else if(a.f>b.f){return 1}else if(a.g<b.g){return -1}else if(a.g>b.g){return 1}return a.b-b.b}
function S8(a,b){if(b.c==a){return b.d}else if(b.d==a){return b.c}throw new slb('Input edge is not connected to the input port.')}
function q5(a){var b;if(a.c==0){return}b=Wv(yU(a.a,a.b),128);b.b==1?(++a.b,a.b<a.a.c.length&&u5(Wv(yU(a.a,a.b),128))):--b.b;--a.c}
function ZU(a,b){a.b.a=Qlb(a.b.a,b.c);a.b.b=Qlb(a.b.b,b.d);a.a.a=Nlb(a.a.a,b.c);a.a.b=Nlb(a.a.b,b.d);return a.c[a.c.length]=b,true}
function vbb(a,b,c){var d,e;d=Ixb(a.n[b.f.k])+Ixb(a.d[b.f.k])+b.i.b+b.a.b;e=Ixb(a.n[c.f.k])+Ixb(a.d[c.f.k])+c.i.b+c.a.b;return e-d}
function Y5(a,b,c,d){var e,f,g;e=false;if($6(a.j,c,d)){a7(a.j,a.d[b][c],a.d[b][d]);f=a.d[b];g=f[d];f[d]=f[c];f[c]=g;e=true}return e}
function fX(a,b,c){var d,e,f,g,h;h=hX(a);e=h.a;d=Wv(rJ(h,(Rib(),Xhb)),15).a;f=h.d;g=a.i;b&&(g.a=g.a-e.b-d-f.a);c&&(g.b=g.b-e.d-d-f.b)}
function Q$(a,b){var c,d,e;for(d=Uh(gX(a));Cm(d);){c=Wv(Dm(d),12);e=Wv(b.B(c),9);return new $c(_b(e.i.b+e.j.b/2))}return zb(),zb(),yb}
function ifb(a){var b,c,d,e,f;d=gfb(a);b=rAb;f=0;e=0;while(b>0.5&&f<50){e=ofb(d);c=$eb(d,e,true);b=Jlb(c.b);++f}return $eb(a,e,false)}
function jfb(a){var b,c,d,e,f;d=gfb(a);b=rAb;f=0;e=0;while(b>0.5&&f<50){e=nfb(d);c=$eb(d,e,true);b=Jlb(c.a);++f}return $eb(a,e,false)}
function QR(a){var b,c,d;this.a=new Wub;this.e=new vtb;this.f=0;for(c=0,d=a.length;c<d;++c){b=a[c];!this.g&&(this.g=b);OR(this,b)}}
function dfb(a){Teb(this);this.c=a.c;this.f=a.f;this.e=a.e;this.k=a.k;this.d=a.d;this.g=Eo(a.g);this.j=a.j;this.i=a.i;this.b=Eo(a.b)}
function oU(a){switch(a.e){case 1:return sK(),rK;case 4:return sK(),oK;case 2:return sK(),pK;case 3:return sK(),nK;}return sK(),qK}
function Xdb(a,b){if(_db(a,b)){stb(a.g,b);return true}b.g!=(sN(),qN)&&stb(a.i,b);b.e.c.length==0?stb(a.c,b):stb(a.b,b);return false}
function wU(a,b){var c,d;Fxb(0,a.c.length);c=Ye(b,xv(UF,syb,1,b.a.Y(),4,1));d=c.length;if(d==0){return false}gxb(a.c,0,c);return true}
function Zkb(a,b){var c=0;while(!b[c]||b[c]==''){c++}var d=b[c++];for(;c<b.length;c++){if(!b[c]||b[c]==''){continue}d+=a+b[c]}return d}
function yt(){var a;if(ut!=0){a=pt();if(a-vt>2000){vt=a;wt=$wnd.setTimeout(Et,10)}}if(ut++==0){Ht((Gt(),Ft));return true}return false}
function kS(a){var b,c;for(c=new Tob(a.a.b);c.a<c.c.c.length;){b=Wv(Rob(c),25);b.j.d=-b.j.d-b.j.c;!!b.o&&(b.g.a=-b.g.a+b.o.j.c)}fS(a)}
function D2(a,b){var c;c=a;while(b.b<b.d.Y()&&c==a){c=(Bxb(b.b<b.d.Y()),Wv(b.d.sb(b.c=b.b++),7)).g}c==a||(Bxb(b.b>0),b.a.sb(b.c=--b.b))}
function a$(a){var b;if(!LM(Wv(rJ(a,(eM(),TL)),28))){return}b=a.c;b$((Cxb(0,b.c.length),Wv(b.c[0],16)));b$(Wv(yU(b,b.c.length-1),16))}
function NV(a,b,c){nI(c,'Compound graph preprocessor',1);a.a=new xk;RV(a,b,null);MV(a,b);sJ(b,(Rib(),bib),a.a);a.a=null;Ymb(a.b);pI(c)}
function P0(a){var b,c;b=Wv(Dm(Uh(iX(a))),12);c=Wv(Dm(Uh(mX(a))),12);return !Ckb(Ixb(Xv(rJ(b,(Rib(),Iib)))))||!Ckb(Ixb(Xv(rJ(c,Iib))))}
function O6(a,b,c){if(b.g==(CX(),AX)&&c.g==zX){a.d=L6(b,(sN(),pN));a.b=L6(b,$M)}if(c.g==AX&&b.g==zX){a.d=L6(c,(sN(),$M));a.b=L6(c,pN)}}
function _8(a,b,c){var d,e,f,g;f=b.g;g=c.g;if(f!=g){return f.e-g.e}else{d=a.a[b.k];e=a.a[c.k];return !d&&!e?0:!d?-1:!e?1:glb(d.a,e.a)}}
function jab(a,b,c,d){var e,f,g,h;f=b;e=c-1;while(f<=e){g=f+e>>>1;h=a[g];if(h<d){f=g+1}else if(h>d){e=g-1}else{return g}}return -(f+1)}
function Id(a){return aw(a,137)?(ypb(),new dsb(Wv(a,137))):aw(a,18)?(ypb(),new Frb(Wv(a,18))):aw(a,20)?Hpb(Wv(a,20)):(ypb(),new zqb(a))}
function Kd(a,b,c){return aw(c,137)?new Lg(a,b,Wv(c,137)):aw(c,18)?new Kg(a,b,Wv(c,18)):aw(c,20)?Ld(a,b,Wv(c,20),null):new _f(a,b,c,null)}
function tn(b,c){var d;d=b.ub(c);try{return d.H()}catch(a){a=OH(a);if(aw(a,74)){throw new okb("Can't get element "+c)}else throw NH(a)}}
function rp(b,c){mp();_b(b);try{return b.cb(c)}catch(a){a=OH(a);if(aw(a,119)){return null}else if(aw(a,76)){return null}else throw NH(a)}}
function Qu(f,a){var b=f.a;var c;a=String(a);b.hasOwnProperty(a)&&(c=b[a]);var d=(ev(),dv)[typeof c];var e=d?d(c):kv(typeof c);return e}
function kgb(a,b,c,d){if(b<c){a.b=0.5*(b+c);a.p=UAb*a.b+0.9*b;a.a=UAb*a.b+0.9*c}else{a.b=0.5*(b+d);a.p=UAb*a.b+0.9*d;a.a=UAb*a.b+0.9*b}}
function Vr(a){Ch.call(this,a);this.b=new sk(a,false,null,(Gh(),Fh),false,null,Fh);this.a=new Os(null,1);ds(this.a,this.a);this.c=new Vs}
function xT(a){vT();this.c=new GU;this.d=a;switch(a.e){case 0:case 2:this.a=Epb(uT);this.b=Uzb;break;case 3:case 1:this.a=uT;this.b=Vzb;}}
function iK(){iK=iI;cK=new jK('AUTOMATIC',0);fK=new jK(ozb,1);gK=new jK(pzb,2);hK=new jK('TOP',3);dK=new jK('BOTTOM',4);eK=new jK(qzb,5)}
function Pxb(a){Nxb();var b,c,d;c=':'+a;d=Mxb[c];if(!(d===undefined)){return d}d=Kxb[c];b=d===undefined?Oxb(a):d;Qxb();Mxb[c]=b;return b}
function bk(a,b,c,d,e,f,g){hi();var h,i;i=g.length+6;h=new HU(i);zpb(h,Bv(tv(UF,1),syb,1,4,[a,b,c,d,e,f]));zpb(h,g);return Yj(new Tob(h))}
function GZ(a){var b;b=Wv(rJ(a,(eM(),JL)),18);if(b.V()){return}if(b.kb((oM(),gM))){b.nb(gM);b.ib(iM)}else if(b.kb(iM)){b.nb(iM);b.ib(gM)}}
function HZ(a){var b;b=Wv(rJ(a,(eM(),JL)),18);if(b.V()){return}if(b.kb((oM(),nM))){b.nb(nM);b.ib(lM)}else if(b.kb(lM)){b.nb(lM);b.ib(nM)}}
function f$(a,b){var c,d,e,f;e=a.g;c=Ixb(Yv(rJ(a,(Rib(),Cib))));f=b.g;d=Ixb(Yv(rJ(b,Cib)));return f!=(CX(),xX)?-1:e!=xX?1:c==d?0:c<d?-1:1}
function g6(a,b,c){var d,e;d=Slb(h6(a,b.d),h6(a,b.c));e=Plb(h6(a,b.d),h6(a,b.c));return $s(Or(Bh(c,Elb(d),(Gh(),Fh),Elb(e),Fh),(qs(),ps)))}
function qp(b,c){mp();_b(b);try{return b.R(c)}catch(a){a=OH(a);if(aw(a,119)){return false}else if(aw(a,76)){return false}else throw NH(a)}}
function Qh(b,c){Oh();_b(b);try{return hnb(b,c)}catch(a){a=OH(a);if(aw(a,119)){return false}else if(aw(a,76)){return false}else throw NH(a)}}
function nab(a,b){if(a.e<b.e){return -1}else if(a.e>b.e){return 1}else if(a.f<b.f){return -1}else if(a.f>b.f){return 1}return txb(a)-txb(b)}
function QZ(a){switch(a.e){case 1:return sN(),rN;case 4:return sN(),$M;case 3:return sN(),ZM;case 2:return sN(),pN;default:return sN(),qN;}}
function Ki(a){var b,c;b=cxb(a.c,a.c.length);switch(b.length){case 0:return Fi;case 1:c=new Er(b[0]);return c;default:return new gr(Ti(b));}}
function EY(a){var b,c,d,e;d=xv(ow,syb,64,a.c.length,0,1);e=0;for(c=new Tob(a);c.a<c.c.c.length;){b=Wv(Rob(c),64);d[e++]=b}return new CY(d)}
function sW(a){var b,c;if(!a.b){a.b=Do(a.a.b.c.length);for(c=new Tob(a.a.b);c.a<c.c.c.length;){b=Wv(Rob(c),33);vU(a.b,new yW(b))}}return a.b}
function K6(a,b){var c,d,e;if(a.e){return 1}c=0;for(e=new Tob(b.f);e.a<e.c.c.length;){d=Wv(Rob(e),7);c+=d.b.c.length+d.e.c.length}return c}
function I6(a){var b,c,d,e;b=false;e=false;for(d=new Tob(a.f);d.a<d.c.c.length;){c=Wv(Rob(d),7);b=b|c.g==(sN(),ZM);e=e|c.g==rN}return b&&e}
function bV(a){var b,c;this.b=new GU;this.c=a;this.a=false;for(c=new Tob(a.b);c.a<c.c.c.length;){b=Wv(Rob(c),9);this.a=this.a|b.g==(CX(),AX)}}
function uX(a){cX.call(this);this.g=(CX(),AX);this.f=(Mh(6,Vyb),new HU(6));this.c=(Mh(2,Vyb),new HU(2));this.e=new ZW;this.b=new ZW;this.a=a}
function ffb(a,b,c,d,e,f){Teb(this);this.e=a;this.f=b;this.d=c;this.c=d;this.g=e;this.b=f;this.j=Ixb(Yv(e.mb().H()));this.i=Ixb(Yv(rl(e)))}
function Lh(a,b){if(a==null){throw new Wlb('null key in entry: null='+b)}else if(b==null){throw new Wlb('null value in entry: '+a+'=null')}}
function Hab(){Hab=iI;Eab=VQ(new WQ,(d0(),v_));Fab=new DJ('linearSegments.inputPrio',Elb(0));Gab=new DJ('linearSegments.outputPrio',Elb(0))}
function Cd(a){var b,c,d,e;for(c=(e=(new aob(a.b)).a.bb().mb(),new fob(e));c.a.G();){b=(d=Wv(c.a.H(),21),Wv(d.zb(),19));b.Q()}Ymb(a.b);a.c=0}
function WI(a,b){var c,d;Fxb(b,a.b);if(b>=a.b>>1){d=a.c;for(c=a.b;c>b;--c){d=d.b}}else{d=a.a.a;for(c=0;c<b;++c){d=d.a}}return new cvb(a,b,d)}
function cU(a,b){var c,d,e;e=new FI;for(d=a.mb();d.G();){c=Wv(d.H(),55);UT(c,e.a,0);e.a+=c.e.a+b;e.b=Nlb(e.b,c.e.b)}e.b>0&&(e.b+=b);return e}
function eU(a,b){var c,d,e;e=new FI;for(d=a.mb();d.G();){c=Wv(d.H(),55);UT(c,0,e.b);e.b+=c.e.b+b;e.a=Nlb(e.a,c.e.a)}e.a>0&&(e.a+=b);return e}
function tub(a,b,c){var d,e,f;e=Wv(Smb(a.c,b),176);if(!e){d=new Jub(a,b,c);Umb(a.c,b,d);Gub(d);return null}else{f=job(e,c);uub(a,e);return f}}
function y3(a,b){if(!Keb(a.b).kb(b.c)){return false}return Oeb(a.b)?!(rgb(b.d,a.c,a.a)&&rgb(b.a,a.c,a.a)):rgb(b.d,a.c,a.a)&&rgb(b.a,a.c,a.a)}
function s6(a,b){return a.c<b.c||a.c==b.c&&d6(a.a)&&d6(b.a)&&h6(a.d,q6(a.a,a.b))>h6(a.d,q6(b.a,b.b))?-1:a.c==b.c&&q6(a.a,a.b)==q6(a.a,a.b)?0:1}
function L5(a,b,c){if(a.e){switch(a.b){case 1:g5(a.c,b,c);break;case 0:h5(a.c,b,c);}}else{e5(a.c,b,c)}a.a[b.k][c.k]=a.c.i;a.a[c.k][b.k]=a.c.e}
function LW(a,b,c){switch(c.e){case 1:a.a=b.a/2;a.b=0;break;case 2:a.a=b.a;a.b=b.b/2;break;case 3:a.a=b.a/2;a.b=b.b;break;case 4:a.a=0;a.b=b.b/2;}}
function Jeb(a){switch(a.e){case 8:return sN(),$M;case 9:return sN(),pN;case 10:return sN(),ZM;case 11:return sN(),rN;default:return sN(),qN;}}
function Qt(a){var b,c,d;b='Ot';d=Slb(a.length,5);for(c=0;c<d;c++){if(emb(a[c].d,b)){a.length>=c+1&&(a.splice(0,c+1),undefined);break}}return a}
function Vv(a,b){if(ew(a)){return !!Uv[b]}else if(a._c){return !!a._c[b]}else if(cw(a)){return !!Tv[b]}else if(bw(a)){return !!Sv[b]}return false}
function jQ(){RP();this.i=(mp(),new ntb);this.a=new ntb;this.k=new ntb;this.j=new ntb;this.b=new ntb;this.n=new ntb;this.f=new ntb;this.e=new ntb}
function r$(a,b){var c,d;if(b.a.R(a)){return}else{d=Wv(rJ(a,(Rib(),hib)),32);c=Wv(yU(a.f,0),7);d==(sN(),$M)?QX(c,pN):d==pN&&QX(c,$M);b.a.db(a,b)}}
function bbb(a){var b,c;c=Plb(1,Wv(rJ(a,(Rib(),Eib)),24).a);a.c.f.g==(CX(),AX)&&a.d.f.g==AX?(b=1):a.c.f.g==AX||a.d.f.g==AX?(b=2):(b=8);return c*b}
function P1(a){var b,c,d,e,f;f=Wv(rJ(a,(Rib(),uib)),7);b=Wv(FU(a.b,xv(dB,gAb,12,a.b.c.length,0,1)),47);for(d=0,e=b.length;d<e;++d){c=b[d];eW(c,f)}}
function Q1(a){var b,c,d,e,f;c=Wv(rJ(a,(Rib(),uib)),7);b=Wv(FU(a.e,xv(dB,gAb,12,a.e.c.length,0,1)),47);for(e=0,f=b.length;e<f;++e){d=b[e];dW(d,c)}}
function Cfb(a){var b,c;yfb(this);c=a.i;b=vI(new HI(c.a,c.b),a.j);this.d=Qlb(c.b,b.b);this.a=Nlb(c.b,b.b);this.b=Qlb(c.a,b.a);this.c=Nlb(c.a,b.a)}
function ipb(a,b,c,d){var e,f,g,h;!d&&(d=(hsb(),hsb(),gsb));e=(f=epb(a,b,c),g=(h=new Array(c-b),Cv(h,a)),dxb(a,b,g,0,f,true),g);jpb(e,a,b,c,-b,d)}
function FU(a,b){var c,d,e;e=a.c.length;b.length<e&&(b=(d=new Array(e),Cv(d,b)));for(c=0;c<e;++c){Av(b,c,a.c[c])}b.length>e&&Av(b,e,null);return b}
function npb(a,b){var c,d,e;e=a.a.length;b.length<e&&(b=(d=new Array(e),Cv(d,b)));for(c=0;c<e;++c){Av(b,c,a.a[c])}b.length>e&&Av(b,e,null);return b}
function xb(a){return ew(a)?a:cw(a)?ilb((Dxb(a),a)):bw(a)?Bkb(Ckb((Dxb(a),a))):_v(a)?a.w():zv(a)?ob(a):a.toString?a.toString():'[JavaScriptObject]'}
function A6(a){var b,c,d,e,f;f=0;for(c=a.b,d=0,e=c.length;d<e;++d){b=c[d];b.g==(CX(),zX)||Umb(a.c,b,Elb(f++));E6(a,b,a.d,(sN(),$M));E6(a,b,a.j,pN)}}
function kbb(){kbb=iI;jbb=new lbb('SIMPLE',0);gbb=new lbb(zAb,1);hbb=new lbb('LINEAR_SEGMENTS',2);fbb=new lbb('BRANDES_KOEPF',3);ibb=new lbb(DAb,4)}
function Xib(){Xib=iI;Wib=new Yib(tzb,0);Sib=new Yib('FIRST',1);Tib=new Yib('FIRST_SEPARATE',2);Uib=new Yib('LAST',3);Vib=new Yib('LAST_SEPARATE',4)}
function Ndb(){Ndb=iI;Mdb=new Vdb;Kdb=TQ(new WQ,(d0(),A_));Ldb=PQ(TQ(new WQ,R_),Q_);Idb=PQ(UQ(TQ(SQ(new WQ,D_),F_),H_),E_);Jdb=PQ(UQ(new WQ,H_),q_)}
function ceb(a){var b,c,d,e;for(c=(e=(new Snb(a.d.a)).a.bb().mb(),new Ynb(e));c.a.G();){b=(d=Wv(c.a.H(),21),Wv(d.yb(),12));vU(b.c.e,b);vU(b.d.b,b)}}
function vvb(a,b){var c,d;vxb(b>0);if((b&-b)==b){return hw(b*wvb(a,31)*4.6566128730773926E-10)}do{c=wvb(a,31);d=c%b}while(c-d+(b-1)<0);return hw(d)}
function zcb(a,b){if(a.c.f==b){return a.d.f}else if(a.d.f==b){return a.c.f}else{throw new slb('Node '+b+' is neither source nor target of edge '+a)}}
function Ekb(a,b,c){vxb(a>=0&&a<=1114111);if(a>=ayb){b[c++]=55296+(a-ayb>>10&1023)&byb;b[c]=56320+(a-ayb&1023)&byb;return 2}else{b[c]=a&byb;return 1}}
function Ol(a,b){Il();var c,d;while(a.G()){if(!b.G()){return false}c=a.H();d=b.H();if(!(gw(c)===gw(d)||c!=null&&rb(c,d))){return false}}return !b.G()}
function JS(a){var b,c,d;Vvb(a.b.a);a.a=xv(kA,syb,25,a.c.b.a.b.c.length,0,1);b=0;for(d=new Tob(a.c.b.a.b);d.a<d.c.c.length;){c=Wv(Rob(d),25);c.k=b++}}
function PT(a){var b,c,d,e;Gpb(a.c,a.a);for(e=new Tob(a.c);e.a<e.c.c.length;){d=Rob(e);for(c=new Tob(a.b);c.a<c.c.c.length;){b=Wv(Rob(c),160);b.Ec(d)}}}
function zW(a){var b,c;if(!a.a){a.a=Do(Wv(a.e,9).c.c.length);for(c=new Tob(Wv(a.e,9).c);c.a<c.c.c.length;){b=Wv(Rob(c),33);vU(a.a,new yW(b))}}return a.a}
function DW(a){var b,c;if(!a.b){a.b=Do(Wv(a.e,7).c.c.length);for(c=new Tob(Wv(a.e,7).c);c.a<c.c.c.length;){b=Wv(Rob(c),33);vU(a.b,new yW(b))}}return a.b}
function F6(a){this.b=a;this.c=(mp(),new ntb);this.i=new ntb;this.d=new ntb;this.j=new ntb;this.k=gw(rJ(hX(a[0]),(eM(),uL)))===gw((NK(),JK));A6(this)}
function sgb(a){switch(a.e){case 1:return 4.71238898038469;default:case 2:return 0;case 3:return 1.5707963267948966;case 4:return 3.141592653589793;}}
function Ql(a){Il();var b;b=Kl(a);if(!Cm(a)){throw new okb('position (0) must be less than the number of elements that remained ('+b+')')}return Dm(a)}
function un(b,c){var d,e;d=b.ub(c);try{e=d.H();d.I();return e}catch(a){a=OH(a);if(aw(a,74)){throw new okb("Can't remove element "+c)}else throw NH(a)}}
function Ye(a,b){var c,d,e,f;f=a.Y();b.length<f&&(b=(e=new Array(f),Cv(e,b)));d=a.mb();for(c=0;c<f;++c){Av(b,c,d.H())}b.length>f&&Av(b,f,null);return b}
function qX(a,b,c){if(!!c&&(b<0||b>c.a.c.length)){throw new slb('index must be >= 0 and <= layer node count')}!!a.d&&BU(a.d.a,a);a.d=c;!!c&&uU(c.a,b,a)}
function Zvb(a,b,c,d,e,f,g,h){var i,j;if(!d){return}i=d.a[0];!!i&&Zvb(a,b,c,i,e,f,g,h);$vb(a,c,d.d,e,f,g,h)&&b.ib(d);j=d.a[1];!!j&&Zvb(a,b,c,j,e,f,g,h)}
function Gxb(a,b,c){if(a<0){throw new okb(jyb+a+' < 0')}if(b>c){throw new okb('toIndex: '+b+' > size '+c)}if(a>b){throw new slb(jyb+a+' > toIndex: '+b)}}
function ee(a,b){var c,d,e;c=b.yb();e=b.zb();d=a.cb(c);if(!(gw(e)===gw(d)||e!=null&&rb(e,d))){return false}if(d==null&&!a.R(c)){return false}return true}
function h1(a,b,c){var d;d=b.c.f;if(d.g==(CX(),zX)){sJ(a,(Rib(),qib),Wv(rJ(d,qib),7));sJ(a,rib,Wv(rJ(d,rib),7))}else{sJ(a,(Rib(),qib),b.c);sJ(a,rib,c.d)}}
function w2(a,b,c){var d;d=b.c.f;if(d.g==(CX(),zX)){sJ(a,(Rib(),qib),Wv(rJ(d,qib),7));sJ(a,rib,Wv(rJ(d,rib),7))}else{sJ(a,(Rib(),qib),b.c);sJ(a,rib,c.d)}}
function at(a,b,c){var d,e,f,g,h;bt(a);for(e=(a.i==null&&(a.i=xv(_F,Txb,46,0,0,1)),a.i),f=0,g=e.length;f<g;++f){d=e[f];at(d,b,'\t'+c)}h=a.e;!!h&&at(h,b,c)}
function yv(a,b){var c=new Array(b);var d;switch(a){case 11:case 12:d=0;break;case 13:d=false;break;default:return c;}for(var e=0;e<b;++e){c[e]=d}return c}
function P5(a){var b,c,d,e;e=xv(qB,Txb,51,a.a.length,0,2);for(c=0;c<e.length;c++){d=a.a[c].length;b=xv(qB,Nzb,9,d,0,1);Gmb(a.a[c],0,b,0,d);e[c]=b}return e}
function AW(a){var b,c;if(!a.b){a.b=Do(Wv(a.e,9).f.c.length);for(c=new Tob(Wv(a.e,9).f);c.a<c.c.c.length;){b=Wv(Rob(c),7);vU(a.b,new FW(b,a.c))}}return a.b}
function sp(b,c){mp();_b(b);try{return ew(c)?Xmb(b,c):Mtb(b.d,c)}catch(a){a=OH(a);if(aw(a,119)){return null}else if(aw(a,76)){return null}else throw NH(a)}}
function Blb(a){var b;b=(Ilb(),Hlb);return b[a>>>28]|b[a>>24&15]<<4|b[a>>20&15]<<8|b[a>>16&15]<<12|b[a>>12&15]<<16|b[a>>8&15]<<20|b[a>>4&15]<<24|b[a&15]<<28}
function ZV(a,b,c){var d,e;if(b.c==(djb(),bjb)&&c.c==ajb){return -1}else if(b.c==ajb&&c.c==bjb){return 1}d=aW(b.a,a.a);e=aW(c.a,a.a);return b.c==bjb?e-d:d-e}
function L7(a){var b,c,d,e,f;e=$xb;f=null;for(d=new Tob(a.d);d.a<d.c.c.length;){c=Wv(Rob(d),89);if(c.c.j^c.d.j){b=c.d.e-c.c.e-c.a;if(b<e){e=b;f=c}}}return f}
function $vb(a,b,c,d,e,f,g){var h,i;if(b.Xc()&&(i=a.a.$b(c,d),i<0||!e&&i==0)){return false}if(b.Yc()&&(h=a.a.$b(c,f),h>0||!g&&h==0)){return false}return true}
function Yj(a){hi();var b,c;if(!a.G()){return kr(),jr}c=a.H();if(!a.G()){return new Gr(c)}b=new Wub;stb(b,_b(c));do{stb(b,_b(a.H()))}while(a.G());return ck(b)}
function m6(a,b,c){a.e=b;a.a=c;a.d=n6(a,(sN(),ZM));a.d+=n6(a,rN);j6(a,b,c,ZM,a.f);j6(a,b,c,rN,a.n);a.b=n6(a,ZM);a.b+=n6(a,rN);j6(a,c,b,ZM,a.f);j6(a,c,b,rN,a.n)}
function hmb(a){var b,c,d;c=(bmb(),a.length);d=0;while(d<c&&a.charCodeAt(d)<=32){++d}b=c;while(b>d&&a.charCodeAt(b-1)<=32){--b}return d>0||b<c?a.substr(d,b-d):a}
function dxb(a,b,c,d,e,f){var g,h,i;if(gw(a)===gw(c)){a=a.slice(b,b+e);b=0}for(h=b,i=b+e;h<i;){g=h+10000<i?h+10000:i;e=g-h;bxb(c,d,f?e:0,a.slice(h,g));h=g;d+=e}}
function Nv(a){var b,c,d;if(Iv(a,(Rv(),Qv))<0){return -Fv((b=~a.l+1&azb,c=~a.m+(b==0?1:0)&azb,d=~a.h+(b==0&&c==0?1:0)&bzb,Ev(b,c,d)))}return a.l+a.m*czb+a.h*dzb}
function JW(a,b){var c;c=a.f;switch(b.e){case 1:return -(a.i.b+a.j.b);case 2:return a.i.a-c.j.a;case 3:return a.i.b-c.j.b;case 4:return -(a.i.a+a.j.a);}return 0}
function KM(){KM=iI;JM=new NM(szb,0);IM=new NM('FREE',1);HM=new NM('FIXED_SIDE',2);EM=new NM('FIXED_ORDER',3);GM=new NM('FIXED_RATIO',4);FM=new NM('FIXED_POS',5)}
function ZT(a,b){var c,d,e,f;c=Wv(rJ(b,(Rib(),fib)),18);f=Wv(Dd(WT,c),18);for(e=f.mb();e.G();){d=Wv(e.H(),18);if(!Wv(Dd(a.a,d),20).V()){return false}}return true}
function HY(a,b,c){this.b=new Dh;this.i=new GU;this.d=new JY(this);this.g=a;this.a=b.c.length;this.c=b;this.e=Wv(yU(this.c,this.c.c.length-1),9);this.f=c;FY(this)}
function Pgb(){Pgb=iI;Lgb=new Rgb('ALWAYS_UP',0);Kgb=new Rgb('ALWAYS_DOWN',1);Ngb=new Rgb('DIRECTION_UP',2);Mgb=new Rgb('DIRECTION_DOWN',3);Ogb=new Rgb('SMART',4)}
function Iv(a,b){var c,d,e,f,g,h,i,j;i=a.h>>19;j=b.h>>19;if(i!=j){return j-i}e=a.h;h=b.h;if(e!=h){return e-h}d=a.m;g=b.m;if(d!=g){return d-g}c=a.l;f=b.l;return c-f}
function K7(a){var b,c,d,e;for(c=(e=(new Snb(a.p.a)).a.bb().mb(),new Ynb(e));c.a.G();){b=(d=Wv(c.a.H(),21),Wv(d.yb(),89));if(b.e&&a.b[b.b]<0){return b}}return null}
function TN(a,b){var c,d,e,f,g;d=Qlb(a.d,b.d);f=Qlb(a.e,b.e);e=Nlb(a.d+a.c,b.d+b.c);g=Nlb(a.e+a.b,b.e+b.b);if(e<d){c=d;d=e;e=c}if(g<f){c=f;f=g;g=c}SN(a,d,f,e-d,g-f)}
function hQ(a,b){var c;if(Gzb in a.a){c=Pu(a,Gzb);if(!c.kc()){throw new GQ("The 'properties' property of a graph element must be an object.",c,a)}iQ(c.kc(),b,true)}}
function HS(a,b){var c,d,e;d=a.b.j.e;a.a||(d+=a.b.j.b);e=b.b.j.e;b.a||(e+=b.b.j.b);c=glb(d,e);if(c==0){if(!a.a&&b.a){return -1}else if(!b.a&&a.a){return 1}}return c}
function kX(a){var b,c;switch(Wv(rJ(hX(a),(Mjb(),ujb)),174).e){case 0:b=a.i;c=a.j;return new HI(b.a+c.a/2,b.b+c.b/2);case 1:return new II(a.i);default:return null;}}
function RX(){LX();cX.call(this);this.g=(sN(),qN);this.a=new FI;this.d=new ZW;this.c=(Mh(2,Vyb),new HU(2));this.b=(Mh(4,Vyb),new HU(4));this.e=(Mh(4,Vyb),new HU(4))}
function G6(a,b,c){a.d=0;a.b=0;P6(a,b,c);b.g==(CX(),BX)&&c.g==zX?M6(b).g==(sN(),$M)?(a.d=1):(a.b=1):c.g==BX&&b.g==zX&&(M6(c).g==(sN(),$M)?(a.b=1):(a.d=1));O6(a,b,c)}
function h9(a,b){var c,d;for(d=new Tob(b);d.a<d.c.c.length;){c=Wv(Rob(d),9);a.a[c.d.k][c.k].a=uvb(a.e);a.a[c.d.k][c.k].d=Ixb(a.a[c.d.k][c.k].a);a.a[c.d.k][c.k].b=1}}
function d9(a,b,c){var d,e,f;for(f=new Tob(b);f.a<f.c.c.length;){d=Wv(Rob(f),9);a.a[d.d.k][d.k].e=false}for(e=new Tob(b);e.a<e.c.c.length;){d=Wv(Rob(e),9);c9(a,d,c)}}
function Ydb(a,b){var c,d,e,f;c=0;d=0;for(f=new Tob(b.b);f.a<f.c.c.length;){e=Wv(Rob(f),33);c=Nlb(c,e.j.a);d+=e.j.b}sJ(b,(Rib(),Lib),new HI(c,d));a.k<c&&(a.k=c);a.j+=d}
function Vbb(a,b){this.c=(mp(),new ntb);this.a=a;this.b=b;this.d=Wv(rJ(a,(Rib(),Kib)),134);gw(rJ(a,(Mjb(),hjb)))===gw((lcb(),kcb))?(this.e=new Jcb):(this.e=new Ccb)}
function Z4(a,b){var c,d,e,f;e=0;for(d=0;d<b.length;d++){c=b[d];if(d<b.length-1){f=b[d+1];e+=$4(a,c,f)}e+=(a.d=new F6(c),x6(a.d));e+=(a.a=new k6(c),a6(a.a))}return e}
function S6(a){switch(a.c.e){case 1:return LX(),HX;case 2:return LX(),FX;case 3:return LX(),JX;case 4:return LX(),KX;}throw new Imb("Can't filter on undefined side")}
function Pr(b,c){var d;try{d=b.c.a;if(!ok(b.b,c)||!d){return 0}return Es(d,b.d,c)}catch(a){a=OH(a);if(aw(a,119)){return 0}else if(aw(a,76)){return 0}else throw NH(a)}}
function J4(a){var b,c,d,e,f;for(d=new rnb((new inb(a.b)).a);d.b;){c=pnb(d);b=Wv(c.yb(),9);f=Wv(Wv(c.zb(),27).a,9);e=Wv(Wv(c.zb(),27).b,10);vI(BI(b.i),vI(xI(f.i),e))}}
function B9(a,b,c){var d,e,f;d=glb(a.a[b.k],a.a[c.k]);if(d==0){e=Wv(rJ(b,(Rib(),oib)),20);f=Wv(rJ(c,oib),20);if(e.kb(c)){return -1}else if(f.kb(b)){return 1}}return d}
function ogb(a,b){var c,d;d=vI(xI(a.i),a.a);c=a.f.j;switch(b.e){case 1:return -d.b;case 2:return -d.a+c.a;case 3:return -d.b+c.b;case 4:return -d.a;default:return 0;}}
function Z8(a,b){var c,d,e,f;for(e=0;e<b.length;e++){e+1<b.length&&X8(a,b[e+1],(djb(),ajb));f=b[e];c=0;for(d=0;d<f.length;d++){Y8(a,f[d]);c+=a.Hc(f[d],c,(djb(),bjb))}}}
function Mfb(){Mfb=iI;Lfb=UQ(UQ(RQ(new WQ,(d0(),__)),$_),a0);Hfb=PQ(UQ(TQ(SQ(new WQ,D_),F_),H_),E_);Jfb=TQ(new WQ,A_);Kfb=PQ(TQ(new WQ,R_),Q_);Ifb=PQ(UQ(new WQ,H_),q_)}
function dI(b,c,d,e){cI();var f=aI;$moduleName=c;$moduleBase=d;LH=e;function g(){for(var a=0;a<f.length;a++){f[a]()}}
if(b){try{Rxb(g)()}catch(a){b(c,a)}}else{Rxb(g)()}}
function clb(a){blb==null&&(blb=/^\s*[+-]?(NaN|Infinity|((\d+\.?\d*)|(\.\d+))([eE][+-]?\d+)?[dDfF]?)\s*$/);if(!elb(blb,a)){throw new Ylb(dyb+a+'"')}return parseFloat(a)}
function _gb(){_gb=iI;Ygb=new ahb(tzb,0);Xgb=new ahb('LEFTUP',1);$gb=new ahb('RIGHTUP',2);Wgb=new ahb('LEFTDOWN',3);Zgb=new ahb('RIGHTDOWN',4);Vgb=new ahb('BALANCED',5)}
function zgb(){zgb=iI;ygb=new Agb('V_TOP',0);xgb=new Agb('V_CENTER',1);wgb=new Agb('V_BOTTOM',2);ugb=new Agb('H_LEFT',3);tgb=new Agb('H_CENTER',4);vgb=new Agb('H_RIGHT',5)}
function YK(){YK=iI;WK=new ZK(tzb,0);UK=new ZK('DIRECTED',1);XK=new ZK('UNDIRECTED',2);SK=new ZK('ASSOCIATION',3);VK=new ZK('GENERALIZATION',4);TK=new ZK('DEPENDENCY',5)}
function CX(){CX=iI;AX=new DX('NORMAL',0);zX=new DX('LONG_EDGE',1);xX=new DX('EXTERNAL_PORT',2);BX=new DX('NORTH_SOUTH_PORT',3);yX=new DX('LABEL',4);wX=new DX('BIG_NODE',5)}
function wv(a,b,c,d,e,f,g){var h,i,j,k,l;k=e[f];j=f==g-1;h=j?d:0;l=yv(h,k);d!=9&&Bv(tv(a,g-f),b[f],c[f],h,l);if(!j){++f;for(i=0;i<k;++i){l[i]=wv(a,b,c,d,e,f,g)}}return l}
function gX(a){var b,c,d;b=new GU;for(d=new Tob(a.f);d.a<d.c.c.length;){c=Wv(Rob(d),7);vU(b,Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[c.b,c.e]))))))}return _b(b),new Vh(b)}
function b7(a,b,c){this.a=c;if(a>=b.length){throw new okb('Greedy SwitchDecider: Free layer layer not in graph.')}this.b=b[a];this.c=new r6(this.b);this.d=new R6(this.b)}
function _n(a,b){var c;this.f=a;this.b=this.f.c;c=a.d;bc(b,c);if(b>=(c/2|0)){this.e=a.e;this.d=c;while(b++<c){Zn(this)}}else{this.c=a.a;while(b-->0){Yn(this)}}this.a=null}
function qS(a){var b,c,d;for(c=new Tob(a.a.b);c.a<c.c.c.length;){b=Wv(Rob(c),25);d=b.j.d;b.j.d=b.j.e;b.j.e=d;d=b.j.c;b.j.c=b.j.b;b.j.b=d;d=b.g.a;b.g.a=b.g.b;b.g.b=d}fS(a)}
function f1(a,b){var c,d,e;d=new Fnb(a.b,0);while(d.b<d.d.Y()){c=(Bxb(d.b<d.d.Y()),Wv(d.d.sb(d.c=d.b++),33));e=Wv(rJ(c,(eM(),tL)),107);if(e==(EK(),BK)){vnb(d);vU(b.b,c)}}}
function Vab(a,b,c){var d,e,f,g;g=zU(a.f,b,0);f=new Wab;f.b=c;d=new Fnb(a.f,g);while(d.b<d.d.Y()){e=(Bxb(d.b<d.d.Y()),Wv(d.d.sb(d.c=d.b++),9));e.k=c;vU(f.f,e);vnb(d)}return f}
function Eq(a,b){Dq();var c,d,e;if(b.V()){return false}if(aw(b,207)){e=Wv(b,207);for(d=e.bb().mb();d.G();){c=Wv(d.H(),83);a.Bb(c.Zb(),c.Yb())}}else{Jl(a,b.mb())}return true}
function MN(){MN=iI;KN=new NN('DEFAULT_MINIMUM_SIZE',0);LN=new NN('MINIMUM_SIZE_ACCOUNTS_FOR_INSETS',1);JN=new NN('COMPUTE_INSETS',2);IN=new NN('APPLY_ADDITIONAL_INSETS',3)}
function MP(a){var b,c,d,e;c=a.a.b+2;e=xv(qz,Fzb,10,c,0,1);e[0]=xI(MX(a.c));d=WI(a.a,0);while(d.b!=d.d.c){b=Wv(_ub(d),10);e[d.a]=new HI(b.a,b.b)}e[c-1]=xI(MX(a.d));return e}
function ge(a,b,c){var d,e,f;for(e=a.bb().mb();e.G();){d=Wv(e.H(),21);f=d.yb();if(gw(b)===gw(f)||b!=null&&rb(b,f)){if(c){d=new qob(d.yb(),d.zb());e.I()}return d}}return null}
function f9(a,b,c){var d,e;d=a.a[b.d.k][b.k];e=a.a[c.d.k][c.k];if(d.a!=null&&e.a!=null){return flb(d.a,e.a)}else if(d.a!=null){return -1}else if(e.a!=null){return 1}return 0}
function beb(a,b,c){var d,e,f;e=b.c;f=b.d;d=c;if(stb(a.a,b)){Xdb(a,e)&&(d=true);Xdb(a,f)&&(d=true);if(d){BU(b.c.e,b);BU(b.d.b,b);stb(a.d,b)}Ydb(a,b);return true}return false}
function $eb(a,b,c){var d,e;e=Zeb(a,b);if(e==a.c){return Web(a,Yeb(a,b))}if(c){_eb(a,b,a.c-e);return Web(a,Yeb(a,b))}else{d=new dfb(a);_eb(d,b,a.c-e);return Web(d,Yeb(d,b))}}
function $tb(){function b(){try{return (new Map).entries().next().done}catch(a){return false}}
if(typeof Map===Zxb&&Map.prototype.entries&&b()){return Map}else{return _tb()}}
function Dd(a,b){var c;c=Wv(Smb(a.b,b),19);!c&&(c=a.Z());return aw(c,137)?new Lg(a,b,Wv(c,137)):aw(c,18)?new Kg(a,b,Wv(c,18)):aw(c,20)?Ld(a,b,Wv(c,20),null):new _f(a,b,c,null)}
function Gs(a){switch(Rs(a.e)-Rs(a.g)){case -2:Cs(a.g)>0&&(a.g=Ls(a.g));return Ks(a);case 2:Cs(a.e)<0&&(a.e=Ks(a.e));return Ls(a);default:a.d=1+Plb(Rs(a.e),Rs(a.g));return a;}}
function k5(a,b){this.f=(mp(),new ntb);this.b=new ntb;this.j=new ntb;this.a=a;this.c=b;this.c>0&&j5(this,this.c-1,(sN(),ZM));this.c<this.a.length-1&&j5(this,this.c+1,(sN(),rN))}
function jt(a){var b;if(a.c==null){b=gw(a.b)===gw(ht)?null:a.b;a.d=b==null?Wxb:dw(b)?mt(Zv(b)):ew(b)?'String':Ikb(tb(b));a.a=a.a+': '+(dw(b)?lt(Zv(b)):b+'');a.c='('+a.d+') '+a.a}}
function IY(a){var b,c,d,e;for(c=new Tob(a.a.c);c.a<c.c.c.length;){b=Wv(Rob(c),9);for(e=WI(Eo(b.c),0);e.b!=e.d.c;){d=Wv(_ub(e),33);rJ(d,(Rib(),uib))==null&&BU(b.c,d)}}return null}
function e3(a,b){var c,d,e,f,g;g=new GU;for(d=Wv(qsb(a3,a),20).mb();d.G();){c=Wv(d.H(),75);xU(g,c.b)}Dpb(g);K2(g,a.a);for(f=new Tob(g);f.a<f.c.c.length;){e=Wv(Rob(f),7);Anb(b,e)}}
function P7(a){var b,c,d,e;while(a.o.a.c.length!=0){c=Wv(Svb(a.o),27);d=Wv(c.a,61);b=Wv(c.b,89);e=c7(b,d);if(b.d==d){o7(e.g,b);d.e=e.e+b.a}else{o7(e.c,b);d.e=e.e-b.a}vU(a.e.a,d)}}
function Tr(a,b,c){var d,e,f;Mh(c,'count');if(!ok(a.b,b)){Xb(c==0);return 0}f=a.c.a;if(!f){c>0&&Lr(a,b,c);return 0}e=xv(mw,Yyb,26,1,12,1);d=Ns(f,a.d,b,c,e);Us(a.c,f,d);return e[0]}
function l$(a,b){var c,d,e,f,g;e=Wv(rJ(b,(Rib(),Jib)),15).a*Wv(rJ(b,(Mjb(),qjb)),15).a;g=a[0].i.a+a[0].j.a;for(f=1;f<a.length;f++){c=a[f].i;d=a[f].j;c.a<=g+e&&(c.a=g+e);g=c.a+d.a}}
function tvb(){tvb=iI;var a,b,c,d;qvb=xv(kw,hyb,26,25,12,1);rvb=xv(kw,hyb,26,33,12,1);d=1.52587890625E-5;for(b=32;b>=0;b--){rvb[b]=d;d*=0.5}c=1;for(a=24;a>=0;a--){qvb[a]=c;c*=0.5}}
function f5(a){while(a.g.c!=0&&a.d.c!=0){if(o5(a.g).c>o5(a.d).c){a.i+=a.g.c;q5(a.d)}else if(o5(a.d).c>o5(a.g).c){a.e+=a.d.c;q5(a.g)}else{a.i+=n5(a.g);a.e+=n5(a.d);q5(a.g);q5(a.d)}}}
function TP(a){if(!a){throw new EQ('An element is null. The origin of an edge could not be determined, this might be due to an inconsistency within the internal element mappings.')}}
function UP(a,b){var c,d;Ymb(a.i);Ymb(a.a);Ymb(a.k);Ymb(a.j);Ymb(a.b);Ymb(a.n);Ymb(a.f);Ymb(a.e);if(a.d){d=Pu(a.d,OP.b);!!d&&!!d.ic()&&(a.c=d.ic().a)}c=fQ(a,b,null);bQ(a,b);return c}
function kfb(a){var b,c,d,e,f,g;d=hfb(gfb(a));b=rAb;f=0;e=0;while(b>0.5&&f<50){e=ofb(d);c=$eb(d,e,true);b=Jlb(c.b);++f}g=Yv(tn(Eo(a.g),Eo(a.g).b-1));return $eb(a,(Dxb(g),g)-e,false)}
function lfb(a){var b,c,d,e,f,g;d=hfb(gfb(a));b=rAb;f=0;e=0;while(b>0.5&&f<50){e=nfb(d);c=$eb(d,e,true);b=Jlb(c.a);++f}g=Yv(tn(Eo(a.g),Eo(a.g).b-1));return $eb(a,(Dxb(g),g)-e,false)}
function Ze(a){var b,c,d,e;e=new Bmb('[');b=false;for(d=a.mb();d.G();){c=d.H();b?(e.a+=', ',e):(b=true);ymb(e,c===a?'(this Collection)':(bmb(),c==null?Wxb:xb(c)))}e.a+=']';return e.a}
function ie(a){var b,c,d,e;e=new Bmb('{');b=false;for(d=a.bb().mb();d.G();){c=Wv(d.H(),21);b?(e.a+=', ',e):(b=true);ymb(e,je(a,c.yb()));e.a+='=';ymb(e,je(a,c.zb()))}e.a+='}';return e.a}
function Ks(a){var b;dc(!!a.g);b=a.g;a.g=b.e;b.e=a;b.j=a.j;b.a=a.a;a.a=1+Zr(a.e)+Zr(a.g);a.j=PH(PH(a.c,Ts(a.e)),Ts(a.g));a.d=1+Plb(Rs(a.e),Rs(a.g));b.d=1+Plb(Rs(b.e),Rs(b.g));return b}
function Ls(a){var b;dc(!!a.e);b=a.e;a.e=b.g;b.g=a;b.j=a.j;b.a=a.a;a.a=1+Zr(a.e)+Zr(a.g);a.j=PH(PH(a.c,Ts(a.e)),Ts(a.g));a.d=1+Plb(Rs(a.e),Rs(a.g));b.d=1+Plb(Rs(b.e),Rs(b.g));return b}
function ZO(a){var b;if(!Qob(new Tob(AW(a.e)))){return}b=Wv(oW(a.e,(eM(),TL)),28);b==(KM(),FM)?SO(a.e):b==GM?TO(a.e):Ckb(Ixb(Xv(oW(a.e,AL))))||a.e.e.j.a==0&&a.e.e.j.b==0?UO(a.e):WO(a)}
function s3(a,b,c){var d,e,f;e=new Tob(a);if(e.a<e.c.c.length){f=Wv(Rob(e),33);d=r3(f,b,c);while(e.a<e.c.c.length){f=Wv(Rob(e),33);Afb(d,r3(f,b,c))}return new Dfb(d)}else{return null}}
function u2(a,b){var c,d,e,f,g,h;e=0;for(d=new Tob(b.c);d.a<d.c.c.length;){c=Wv(Rob(d),16);for(g=new Tob(c.a);g.a<g.c.c.length;){f=Wv(Rob(g),9);h=f.j.a+f.e.c+f.e.b+a.b;e=e>h?e:h}}return e}
function sT(a,b){oT();var c;if(a.c==b.c){if(a.b==b.b||gT(a.b,b.b)){c=dT(a.b)?1:-1;if(a.a&&!b.a){return c}else if(!a.a&&b.a){return -c}}return xlb(a.b.e,b.b.e)}else{return glb(a.c,b.c)}}
function nU(a){var b,c;c=xI(MI(Bv(tv(qz,1),Fzb,10,0,[a.f.i,a.i,a.a])));b=a.f.e;switch(a.g.e){case 1:c.b-=b.d;break;case 2:c.a+=b.c;break;case 3:c.b+=b.a;break;case 4:c.a-=b.b;}return c}
function z6(a,b){var c;c=0;if(b.g==(CX(),BX)){if(C6(b).f!=a.a){D6(a,C6(b).f);a.e=true}a.e?++a.g:(c+=a.f)}else if(b.g==zX){a.e?(c+=a.g):++a.f}else if(b.g==AX){D6(a,b);a.e=false}return c}
function HV(a,b,c,d,e){var f,g,h,i;i=null;for(h=new Tob(d);h.a<h.c.c.length;){g=Wv(Rob(h),187);if(g!=c&&zU(g.e,e,0)!=-1){i=g;break}}f=IV(e);dW(f,c.b);eW(f,i.b);Fd(a.a,e,new XV(f,b,c.f))}
function FZ(a){switch(Wv(rJ(a,(Mjb(),vjb)),85).e){case 1:sJ(a,vjb,(Xib(),Uib));break;case 2:sJ(a,vjb,(Xib(),Vib));break;case 3:sJ(a,vjb,(Xib(),Sib));break;case 4:sJ(a,vjb,(Xib(),Tib));}}
function iQ(a,b,c){var d,e,f,g;if(a){for(e=(f=Nu(a,xv($F,Txb,2,0,5,1)),new wnb(new opb((new _u(a,f)).b)));e.b<e.d.Y();){d=(Bxb(e.b<e.d.Y()),$v(e.d.sb(e.c=e.b++)));g=Pu(a,d);wQ(b,d,g,c)}}}
function G5(a,b,c){var d,e,f,g,h,i;e=1;while(e<a){e*=2}i=2*e-1;e-=1;h=xv(mw,Yyb,26,i,12,1);d=0;for(g=0;g<b;g++){f=c[g]+e;++h[f];while(f>0){f%2>0&&(d+=h[f+1]);f=(f-1)/2|0;++h[f]}}return d}
function aeb(a,b,c){var d,e,f,g;a.e=b;if(c){for(e=(g=(new Snb(a.a.a)).a.bb().mb(),new Ynb(g));e.a.G();){d=(f=Wv(e.a.H(),21),Wv(f.yb(),12));sJ(d,(Rib(),Mib),a.e);QX(d.c,b.a);QX(d.d,b.b)}}}
function g4(){g4=iI;e4=new h4(tzb,0);b4=new h4(ozb,1);f4=new h4(pzb,2);d4=new h4('LEFT_RIGHT_CONSTRAINT_LOCKING',3);c4=new h4('LEFT_RIGHT_CONNECTION_LOCKING',4);a4=new h4('EDGE_LENGTH',5)}
function N5(a,b,c,d){var e;this.b=d;this.e=a.a;e=b[c];this.d=vv(KH,[Txb,xAb],[227,26],13,[e.length,e.length],2);this.a=vv(mw,[Txb,Yyb],[52,26],12,[e.length,e.length],2);this.c=new k5(b,c)}
function fwb(a,b,c,d){var e,f;f=b;e=f.d==null||a.a.$b(c.d,f.d)>0?1:0;while(f.a[e]!=c){f=f.a[e];e=a.a.$b(c.d,f.d)>0?1:0}f.a[e]=d;d.b=c.b;d.a[0]=c.a[0];d.a[1]=c.a[1];c.a[0]=null;c.a[1]=null}
function ZQ(a,b,c){var d,e,f,g;nI(c,Tzb,1);NQ(a.d,b);g=sV(a.a,b);if(g.Y()==1){_Q(Wv(g.sb(0),55),c)}else{f=1/g.Y();for(e=g.mb();e.G();){d=Wv(e.H(),55);_Q(d,rI(c,f))}}qV(a.a,g,b);bR(b);pI(c)}
function o6(a,b,c){var d,e,f,g,h;h=new U6(b,c);for(g=T6(h);g.G();){f=Wv(g.H(),7);for(e=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[f.b,f.e]))))));Cm(e);){d=Wv(Dm(e),12);bW(d)||l6(a,b,f,d)}}}
function _6(a,b){var c,d,e;e=nX(a,b);for(d=e.mb();d.G();){c=Wv(d.H(),7);if(rJ(c,(Rib(),Bib))!=null||Cm(Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[c.b,c.e])))))))){return true}}return false}
function Efb(a){var b,c;if(sl(a)){throw new slb(TAb)}for(c=WI(a,0);c.b!=c.d.c;){b=Wv(_ub(c),10);this.d=Qlb(this.d,b.b);this.c=Nlb(this.c,b.a);this.a=Nlb(this.a,b.b);this.b=Qlb(this.b,b.a)}}
function wI(a,b,c){if(b<0||c<0){throw new slb('The highx must be bigger then lowx and the highy must be bigger then lowy')}a.a<0?(a.a=0):a.a>b&&(a.a=b);a.b<0?(a.b=0):a.b>c&&(a.b=c);return a}
function nX(a,b){switch(b.e){case 1:return pl(a.f,(LX(),HX));case 2:return pl(a.f,(LX(),FX));case 3:return pl(a.f,(LX(),JX));case 4:return pl(a.f,(LX(),KX));default:return ypb(),ypb(),vpb;}}
function K0(a){var b,c,d,e;for(e=(Il(),new Im(Dl(ul(a.a,new yl))));Cm(e);){d=Wv(Dm(e),9);d.g==(CX(),yX)&&sJ(d,(Rib(),pib),(kP(),hP));for(c=Uh(mX(d));Cm(c);){b=Wv(Dm(c),12);M0(b,(kP(),hP))}}}
function L0(a){var b,c,d,e;for(e=(Il(),new Im(Dl(ul(a.a,new yl))));Cm(e);){d=Wv(Dm(e),9);d.g==(CX(),yX)&&sJ(d,(Rib(),pib),(kP(),gP));for(c=Uh(mX(d));Cm(c);){b=Wv(Dm(c),12);M0(b,(kP(),gP))}}}
function cdb(a,b){this.b=new vtb;switch(a){case 0:this.d=new Ddb(this);break;case 1:this.d=new tdb(this);break;case 2:this.d=new ydb(this);break;default:throw new rlb;}this.c=b;this.a=0.2*b}
function uW(a){var b,c,d,e;if(!a.b){a.b=new GU;for(c=new Tob(a.a.c);c.a<c.c.c.length;){b=Wv(Rob(c),16);for(e=new Tob(b.a);e.a<e.c.c.length;){d=Wv(Rob(e),9);vU(a.b,new BW(d,a.c))}}}return a.b}
function l5(a,b){var c,d,e;c=m5(b,a.e);d=Wv(Smb(a.g.f,c),24).a;e=a.a.c.length-1;if(a.a.c.length!=0&&Wv(yU(a.a,e),128).c==d){++Wv(yU(a.a,e),128).a;++Wv(yU(a.a,e),128).b}else{vU(a.a,new v5(d))}}
function lmb(a){bmb();var b,c;if(a>=ayb){b=55296+(a-ayb>>10&1023)&byb;c=56320+(a-ayb&1023)&byb;return String.fromCharCode(b)+(''+String.fromCharCode(c))}else{return String.fromCharCode(a&byb)}}
function KV(a,b,c,d){var e,f,g;e=hX(c);f=PW(e);g=new RX;PX(g,c);switch(d.e){case 1:QX(g,tN(vN(f)));break;case 2:QX(g,vN(f));}sJ(g,(Rib(),tib),Wv(rJ(b,tib),15));sJ(b,uib,g);Umb(a.b,g,b);return g}
function l6(a,b,c,d){var e;vU(a.c,new t6(a,c,d,Wv(Smb(a.k,c),24).a));if(d6(d)&&(b==a.e?d.d.f!=a.a&&d.c.f!=a.a:d.d.f!=a.e&&d.c.f!=a.e)){e=c==d.c?d.d:d.c;vU(a.c,new t6(a,e,d,Wv(Smb(a.k,e),24).a))}}
function fe(a,b){var c,d,e;if(b===a){return true}if(!aw(b,57)){return false}e=Wv(b,57);if(a.Y()!=e.Y()){return false}for(d=e.bb().mb();d.G();){c=Wv(d.H(),21);if(!a._(c)){return false}}return true}
function $Z(a,b){var c,d,e;d=new uX(a);qJ(d,b);sJ(d,(Rib(),gib),b);sJ(d,(eM(),TL),(KM(),FM));sJ(d,lL,(iK(),eK));sX(d,(CX(),xX));c=new RX;PX(c,d);QX(c,(sN(),rN));e=new RX;PX(e,d);QX(e,ZM);return d}
function O7(a,b){var c,d,e;e=$xb;for(d=new Tob(m7(b));d.a<d.c.c.length;){c=Wv(Rob(d),89);if(c.e&&!a.c[c.b]){a.c[c.b]=true;e=Slb(e,O7(a,c7(c,b)))}}a.i[b.b]=a.j;a.g[b.b]=Slb(e,a.j++);return a.g[b.b]}
function _eb(a,b,c){var d,e,f,g;g=a.g.tb();if(a.e){for(e=0;e<a.c;e++){g.H()}}else{for(e=0;e<a.c-1;e++){g.H()}}f=a.b.tb();d=Ixb(Yv(g.H()));while(d-b<RAb){d=Ixb(Yv(g.H()));f.H()}g.M();afb(a,c,b,f,g)}
function Lt(b,c){var d,e,f,g;for(e=0,f=b.length;e<f;e++){g=b[e];try{g[1]?g[0].bd()&&(c=Kt(c,g)):g[0].bd()}catch(a){a=OH(a);if(aw(a,46)){d=a;Ct(aw(d,164)?Wv(d,164).cc():d)}else throw NH(a)}}return c}
function Qr(a){var b,c,d;d=a.c.a;if(!d){return null}if(a.b.b){b=a.b.e;c=Ds(a.c.a,a.d,b);if(!c){return null}a.b.d==(Gh(),Fh)&&a.d.$b(b,c.b)==0&&(c=c.i)}else{c=a.a.i}return c==a.a||!ok(a.b,c.b)?null:c}
function t2(a,b){var c,d,e,f,g,h;f=0;for(d=new Tob(b.c);d.a<d.c.c.length;){c=Wv(Rob(d),16);e=0;for(h=new Tob(c.a);h.a<h.c.c.length;){g=Wv(Rob(h),9);e+=g.j.b+g.e.a+g.e.d+a.a}e-=a.a;f=f>e?f:e}return f}
function M7(a){var b,c,d,e,f;f=$xb;e=$xb;for(d=new Tob(m7(a));d.a<d.c.c.length;){c=Wv(Rob(d),89);b=c.d.e-c.c.e;c.d==a&&b<e?(e=b):b<f&&(f=b)}e==$xb&&(e=-1);f==$xb&&(f=-1);return new RJ(Elb(e),Elb(f))}
function l8(a,b,c){var d,e,f,g,h;b.k=-1;for(h=oX(b,(djb(),bjb)).mb();h.G();){g=Wv(h.H(),7);for(e=new Tob(g.e);e.a<e.c.c.length;){d=Wv(Rob(e),12);f=d.d.f;b!=f&&(f.k<0?c.ib(d):f.k>0&&l8(a,f,c))}}b.k=0}
function Bfb(a,b){yfb(this);if(0>b){throw new slb('Top must be smaller or equal to bottom.')}else if(0>a){throw new slb('Left must be smaller or equal to right.')}this.d=0;this.c=a;this.a=b;this.b=0}
function Ffb(a){var b,c,d;yfb(this);if(a.length==0){throw new slb(TAb)}for(c=0,d=a.length;c<d;++c){b=a[c];this.d=Qlb(this.d,b.b);this.c=Nlb(this.c,b.a);this.a=Nlb(this.a,b.b);this.b=Qlb(this.b,b.a)}}
function g0(){d0();return Bv(tv(mC,1),uyb,37,0,[L_,o_,c0,m_,p_,__,z_,T_,j_,D_,S_,P_,I_,s_,h_,N_,W_,F_,G_,A_,Z_,V_,R_,r_,U_,$_,Y_,B_,x_,H_,k_,C_,a0,O_,t_,v_,J_,i_,l_,y_,u_,M_,Q_,E_,w_,X_,K_,n_,b0,q_])}
function a5(a,b){var c,d,e,f,g,h,i,j,k;k=0;for(d=0,e=b.length;d<e;++d){c=b[d];for(g=0,h=c.length;g<h;++g){f=c[g];for(j=new Tob(f.f);j.a<j.c.c.length;){i=Wv(Rob(j),7);i.k=k++}}}a.a=xv(mw,Yyb,26,k,12,1)}
function Sl(a){Il();var b,c,d;b=a.H();if(!a.G()){return b}d=new zmb;d.a+='expected one element but was: <'+b;for(c=0;c<4&&a.G();c++){ymb(d,', '+a.H())}a.G()&&(d.a+=', ...',d);d.a+='>';throw new slb(d.a)}
function x6(a){var b,c,d,e,f;b=0;for(d=a.b,e=0,f=d.length;e<f;++e){c=d[e];b+=z6(a,c);if(LM(Wv(rJ(c,(eM(),TL)),28))){nX(c,(sN(),$M)).mb().G()&&(b+=y6(a,c,$M));nX(c,pN).mb().G()&&(b+=y6(a,c,pN))}}return b}
function i5(a,b,c,d){var e,f,g,h,i;if(d.d.c+d.e.c==0){for(g=a.a[a.c],h=0,i=g.length;h<i;++h){f=g[h];Umb(d,f,new r5(a,f,c))}}e=Wv(re(Ktb(d.d,b)),284);e.b=0;e.c=e.f;e.c==0||u5(Wv(yU(e.a,e.b),128));return e}
function Dpb(a){var h;ypb();var b,c,d,e,f,g;if(aw(a,63)){for(e=0,d=a.Y()-1;e<d;++e,--d){h=a.sb(e);a.wb(e,a.sb(d));a.wb(d,h)}}else{b=a.tb();f=a.ub(a.Y());while(b.L()<f.N()){c=b.H();g=f.M();b.O(g);f.O(c)}}}
function Wb(a,b,c){if(a<0||a>c){return Vb(a,c,'start index')}if(b<0||b>c){return Vb(b,c,'end index')}return fc('end index (%s) must not be less than start index (%s)',Bv(tv(UF,1),syb,1,4,[Elb(b),Elb(a)]))}
function SP(a){if(!('id' in a.a)){throw new FQ("Every graph element must specify an 'id' property.",a)}if(!Pu(a,'id').lc()){throw new FQ("Invalid format for 'id'. Must be a string, was "+Pu(a,'id').$c,a)}}
function f3(a,b){var c,d,e,f,g,h,i;i=a.b;for(d=Wv(qsb(a3,a),20).mb();d.G();){c=Wv(d.H(),75);for(h=(f=(new Snb(c.c.a)).a.bb().mb(),new Ynb(f));h.a.G();){g=(e=Wv(h.a.H(),21),Wv(e.yb(),7));Anb(b,g);J2(g,i)}}}
function _db(a,b){var c,d,e;for(e=new Tob(b.e);e.a<e.c.c.length;){c=Wv(Rob(e),12);if(c.d.f!=a.f){return true}}for(d=new Tob(b.b);d.a<d.c.c.length;){c=Wv(Rob(d),12);if(c.c.f!=a.f){return true}}return false}
function Z2(a){var b,c,d,e;We(a.c);We(a.b);We(a.a);for(e=(c=(new Snb(a.e)).a.bb().mb(),new Ynb(c));e.a.G();){d=(b=Wv(e.a.H(),21),Wv(b.yb(),60));if(d.c!=2){Wsb(a.a,d);d.c==0&&Wsb(a.c,d)}Wsb(a.b,d)}a.d=false}
function mr(b,c){var d;if(b===c){return true}if(aw(c,18)){d=Wv(c,18);try{return b.Y()==d.Y()&&b.lb(d)}catch(a){a=OH(a);if(aw(a,76)){return false}else if(aw(a,119)){return false}else throw NH(a)}}return false}
function Ltb(a,b,c){var d,e,f,g;g=b==null?0:a.b.Vc(b);e=(d=Ttb(a.a,g),d==null?[]:d);if(e.length==0){Vtb(a.a,g,e)}else{f=Itb(a,b,e);if(f){return f.Ab(c)}}Av(e,e.length,new qob(b,c));++a.c;msb(a.b);return null}
function Vb(a,b,c){if(a<0){return fc(ryb,Bv(tv(UF,1),syb,1,4,[c,Elb(a)]))}else if(b<0){throw new slb(tyb+b)}else{return fc('%s (%s) must not be greater than size (%s)',Bv(tv(UF,1),syb,1,4,[c,Elb(a),Elb(b)]))}}
function Ub(a,b){if(a<0){return fc(ryb,Bv(tv(UF,1),syb,1,4,['index',Elb(a)]))}else if(b<0){throw new slb(tyb+b)}else{return fc('%s (%s) must be less than size (%s)',Bv(tv(UF,1),syb,1,4,['index',Elb(a),Elb(b)]))}}
function jW(a){var b,c,d,e;e=xv(qB,Txb,51,a.c.c.length,0,2);d=new Fnb(a.c,0);while(d.b<d.d.Y()){b=(Bxb(d.b<d.d.Y()),Wv(d.d.sb(d.c=d.b++),16));c=d.b-1;e[c]=Wv(FU(b.a,xv(qB,Nzb,9,b.a.c.length,0,1)),51)}return e}
function w3(a,b,c,d,e){this.c=e;this.d=b;this.a=c;switch(e.e){case 4:this.b=Jlb(a.b);break;case 1:this.b=Jlb(a.d);break;case 2:this.b=Jlb(a.c-d.j.a);break;case 3:this.b=Jlb(a.a-d.j.b);break;default:this.b=0;}}
function adb(a,b,c,d,e){var f,g,h,i,j;if(b){for(h=b.mb();h.G();){g=Wv(h.H(),9);for(j=pX(g,(djb(),bjb),c).mb();j.G();){i=Wv(j.H(),7);f=Wv(re(Ktb(e.d,i)),80);if(!f){f=new odb(a);d.c[d.c.length]=f;mdb(f,i,e)}}}}}
function Ofb(a,b){var c,d,e;c=a.c;if(c.a.Y()>1){throw new slb('In straight hyperEdges there may be only one edge.')}QI((e=(new Snb(c.a)).a.bb().mb(),d=Wv((new Ynb(e)).a.H(),21),Wv(d.yb(),12)).a,new HI(b,a.b))}
function no(a,b,c){var d,e;this.f=a;d=Wv(Smb(a.b,b),126);e=!d?0:d.a;bc(c,e);if(c>=(e/2|0)){this.e=!d?null:d.c;this.d=e;while(c++<e){lo(this)}}else{this.c=!d?null:d.b;while(c-->0){ko(this)}}this.b=b;this.a=null}
function HP(a,b){if(typeof klaycallback===Zxb){klaycallback(b)}else{typeof document!==Czb?Rxb(a(b)):typeof module===Sxb&&module.exports&&Rxb(a(b));typeof document===Czb&&typeof self!==Czb&&self.postMessage(b)}}
function _P(a,b){var c,d,e,f;if('x' in a.a){e=Wv(Pu(a,'x'),104);b.i.a=e.a}if('y' in a.a){f=Wv(Pu(a,'y'),104);b.i.b=f.a}if(Jzb in a.a){d=Wv(Pu(a,Jzb),104);b.j.a=d.a}if(Kzb in a.a){c=Wv(Pu(a,Kzb),104);b.j.b=c.a}}
function lgb(a,b,c){var d,e;igb(this);b==(fgb(),dgb)?stb(this.g,a.c):stb(this.o,a.c);c==dgb?stb(this.g,a.d):stb(this.o,a.d);stb(this.c,a);d=MX(a.c).b;e=MX(a.d).b;kgb(this,d,e,e);this.f=Zfb(MX(a.c).b,MX(a.d).b)}
function p5(a){var b,c,d,e,f,g;g=new U6(a.d,a.e);for(f=T6(g);f.G();){e=Wv(f.H(),7);d=a.e==(sN(),rN)?e.b:e.e;for(c=new Tob(d);c.a<c.c.c.length;){b=Wv(Rob(c),12);if(!bW(b)&&b.c.f.d!=b.d.f.d){l5(a,b);++a.f;++a.c}}}}
function LQ(a,b,c){var d,e,f,g,h;g=(ypb(),new Frb(Wv(yU(b.a,c),18)));h=new HU(g.b.Y());for(e=new Nqb(g.b.mb());e.b.G();){d=Wv(e.b.H(),37);f=Wv(Smb(a.a,d),31);if(!f){f=e0(d);Umb(a.a,d,f)}h.c[h.c.length]=f}return h}
function T5(a,b){var c,d,e,f;d=new Fnb(a.f.c,0);while(d.b<d.d.Y()){c=(Bxb(d.b<d.d.Y()),Wv(d.d.sb(d.c=d.b++),16));f=b[d.b-1];e=new Fnb(c.a,0);while(e.b<e.d.Y()){Bxb(e.b<e.d.Y());e.d.sb(e.c=e.b++);Enb(e,f[e.b-1])}}}
function m2(a){var b,c;if(MM(Wv(rJ(a,(eM(),TL)),28))){for(c=new Tob(a.f);c.a<c.c.c.length;){b=Wv(Rob(c),7);b.g==(sN(),qN)&&p2(b)}}else{for(c=new Tob(a.f);c.a<c.c.c.length;){b=Wv(Rob(c),7);p2(b)}sJ(a,TL,(KM(),HM))}}
function jpb(a,b,c,d,e,f){var g,h,i,j;g=d-c;if(g<7){gpb(b,c,d,f);return}i=c+e;h=d+e;j=i+(h-i>>1);jpb(b,a,i,j,-e,f);jpb(b,a,j,h,-e,f);if(f.$b(a[j-1],a[j])<=0){while(c<d){Av(b,c++,a[i++])}return}hpb(a,i,j,h,b,c,d,f)}
function hv(a){if(!a){return Bu(),Au}var b=a.valueOf?a.valueOf():a;if(b!==a){var c=dv[typeof b];return c?c(b):kv(typeof b)}else if(a instanceof Array||a instanceof $wnd.Array){return new ku(a)}else{return new Uu(a)}}
function I7(a,b,c){var d,e;d=c.c;e=c.d;if(a.g[d.b]<=a.i[b.b]&&a.i[b.b]<=a.i[d.b]&&a.g[e.b]<=a.i[b.b]&&a.i[b.b]<=a.i[e.b]){if(a.i[d.b]<a.i[e.b]){return false}return true}if(a.i[d.b]<a.i[e.b]){return true}return false}
function j5(a,b,c){var d,e,f,g,h,i,j,k;j=0;for(e=a.a[b],f=0,g=e.length;f<g;++f){d=e[f];k=new U6(d,c);for(i=T6(k);i.G();){h=Wv(i.H(),7);Umb(a.f,h,Elb(j));LM(Wv(rJ(d,(eM(),TL)),28))&&++j}LM(Wv(rJ(d,(eM(),TL)),28))||++j}}
function Pb(a,b,c){var d,e;_b(b);if(c.G()){e=Wv(c.H(),21);vmb(b,Mb(a.a,e.yb()));vmb(b,a.b);vmb(b,Mb(a.a,e.zb()));while(c.G()){vmb(b,a.a.c);d=Wv(c.H(),21);vmb(b,Mb(a.a,d.yb()));vmb(b,a.b);vmb(b,Mb(a.a,d.zb()))}}return b}
function Gd(a,b){var c,d;c=Wv(Wmb(a.b,b),19);if(!c){return a.$()}d=a.Z();d.jb(c);a.c-=c.Y();c.Q();return aw(d,137)?(ypb(),new dsb(Wv(d,137))):aw(d,18)?(ypb(),new Frb(Wv(d,18))):aw(d,20)?Hpb(Wv(d,20)):(ypb(),new zqb(d))}
function Tm(a,b){var c;b.d?(b.d.b=b.b):(a.a=b.b);b.b?(b.b.d=b.d):(a.e=b.d);if(!b.e&&!b.c){c=Wv(Wmb(a.b,b.a),126);c.a=0;++a.c}else{c=Wv(Smb(a.b,b.a),126);--c.a;!b.e?(c.b=b.c):(b.e.c=b.c);!b.c?(c.c=b.e):(b.c.e=b.e)}--a.d}
function mU(a,b,c){switch(c.e){case 1:return new HI(b.a,Qlb(a.d.b,b.b));case 2:return new HI(Nlb(a.c.a,b.a),b.b);case 3:return new HI(b.a,Nlb(a.c.b,b.b));case 4:return new HI(Qlb(b.a,a.d.a),b.b);}return new HI(b.a,b.b)}
function Oxb(a){var b,c,d,e;b=0;d=(bmb(),a.length);e=d-4;c=0;while(c<e){b=a.charCodeAt(c+3)+31*(a.charCodeAt(c+2)+31*(a.charCodeAt(c+1)+31*(a.charCodeAt(c)+31*b)));b=b|0;c+=4}while(c<d){b=b*31+jmb(a,c++)}b=b|0;return b}
function X9(a,b){var c,d,e;this.a=a;this.c=b;this.b=xv(nE,Txb,673,a.length,0,2);for(c=0;c<a.length;++c){e=a[c].length;this.b[c]=xv(nE,{673:1,3:1,5:1,6:1},102,e,0,1);for(d=0;d<e;++d){this.b[c][d]=new $9(this,a[c][d].c)}}}
function sk(a,b,c,d,e,f,g){var h;this.a=Wv(_b(a),56);this.b=b;this.c=e;this.e=c;this.d=Wv(_b(d),159);this.g=f;this.f=Wv(_b(g),159);b&&a.$b(c,c);e&&a.$b(f,f);if(b&&e){h=a.$b(c,f);Zb(h<=0,c,f);h==0&&Xb(d!=(Gh(),Fh)|g!=Fh)}}
function eV(a){this.a=a;if(a.c.f.g==(CX(),xX)){this.c=a.c;this.d=Wv(rJ(a.c.f,(Rib(),hib)),32)}else if(a.d.f.g==xX){this.c=a.d;this.d=Wv(rJ(a.d.f,(Rib(),hib)),32)}else{throw new slb('Edge '+a+' is not an external edge.')}}
function Xcb(){Xcb=iI;Scb=UQ(new WQ,(d0(),x_));Ucb=TQ(new WQ,A_);Vcb=PQ(TQ(new WQ,R_),Q_);Rcb=PQ(UQ(TQ(new WQ,s_),t_),u_);Wcb=TQ(new WQ,Z_);Tcb=PQ(new WQ,y_);Pcb=PQ(UQ(TQ(SQ(new WQ,D_),F_),H_),E_);Qcb=PQ(UQ(new WQ,H_),q_)}
function Lr(a,b,c){var d,e,f,g;Mh(c,Xyb);if(c==0){return Pr(a,b)}Xb(ok(a.b,b));g=a.c.a;if(!g){a.d.$b(b,b);e=new Os(b,c);es(a.a,e,a.a);Us(a.c,null,e);return 0}f=xv(mw,Yyb,26,1,12,1);d=zs(g,a.d,b,c,f);Us(a.c,g,d);return f[0]}
function i$(a,b,c){var d,e,f,g,h,i;d=0;i=c;if(!b){d=c*(a.c.length-1);i*=-1}for(f=new Tob(a);f.a<f.c.c.length;){e=Wv(Rob(f),9);sJ(e,(eM(),lL),(iK(),eK));e.j.a=d;for(h=nX(e,(sN(),ZM)).mb();h.G();){g=Wv(h.H(),7);g.i.a=d}d+=i}}
function Fd(a,b,c){var d;d=Wv(Smb(a.b,b),19);if(!d){d=a.Z();if(d.ib(c)){++a.c;Umb(a.b,b,d);return true}else{throw new ukb('New Collection violated the Collection spec')}}else if(d.ib(c)){++a.c;return true}else{return false}}
function ES(a,b,c){var d,e,f;CS(a,b,c);f=new GU;for(e=new Tob(a.b.a.b);e.a<e.c.c.length;){d=Wv(Rob(e),25);if(b.D(d)){vU(f,new OS(d,true));vU(f,new OS(d,false))}}JS(a.d);RT(f,a.c,new opb(Bv(tv(JA,1),syb,160,0,[a.d])));DS(a,b,c)}
function R8(a,b){var c,d,e,f,g;a.c[b.k]=true;vU(a.a,b);for(g=new Tob(b.f);g.a<g.c.c.length;){f=Wv(Rob(g),7);for(d=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[f.b,f.e]))))));Cm(d);){c=Wv(Dm(d),12);e=S8(f,c).f;a.c[e.k]||R8(a,e)}}}
function dQ(a,b,c,d){var e,f,g;if('labels' in b.a){g=Pu(b,'labels');if(!g.hc()){throw new GQ("The 'labels' property of a node must be an array.",g,b)}f=g.hc();for(e=0;e<f.a.length;++e){aw(gu(f,e),69)&&cQ(a,Wv(gu(f,e),69),c,d)}}}
function j0(a,b,c){var d,e,f,g,h,i;f=Wv(yU(b.b,0),12).c;d=f.f;e=d.g;i=Wv(yU(c.e,0),12).d;g=i.f;h=g.g;e==(CX(),zX)?sJ(a,(Rib(),qib),Wv(rJ(d,qib),7)):sJ(a,(Rib(),qib),f);h==zX?sJ(a,(Rib(),rib),Wv(rJ(g,rib),7)):sJ(a,(Rib(),rib),i)}
function oM(){oM=iI;gM=new pM('H_LEFT',0);fM=new pM('H_CENTER',1);iM=new pM('H_RIGHT',2);nM=new pM('V_TOP',3);mM=new pM('V_CENTER',4);lM=new pM('V_BOTTOM',5);jM=new pM('INSIDE',6);kM=new pM('OUTSIDE',7);hM=new pM('H_PRIORITY',8)}
function rS(a){aS();var b,c,d;this.b=ZR;this.c=_R;this.d=(sK(),qK);this.g=(VR(),UR);this.a=a;oS(this,new sS);fS(this);for(d=new Tob(a.b);d.a<d.c.c.length;){c=Wv(Rob(d),25);if(!c.f){b=new QR(Bv(tv(kA,1),syb,25,0,[c]));vU(a.a,b)}}}
function R7(a,b){var c,d,e,f;e=1;b.j=true;for(d=new Tob(m7(b));d.a<d.c.c.length;){c=Wv(Rob(d),89);if(!a.c[c.b]){a.c[c.b]=true;f=c7(c,b);if(c.e){e+=R7(a,f)}else if(!f.j&&c.a==c.d.e-c.c.e){c.e=true;stb(a.p,c);e+=R7(a,f)}}}return e}
function Abb(a){var b,c,d,e,f,g,h,i;e=Uzb;d=Vzb;for(c=new Tob(a.e.c);c.a<c.c.c.length;){b=Wv(Rob(c),16);for(g=new Tob(b.a);g.a<g.c.c.length;){f=Wv(Rob(g),9);i=Ixb(a.n[f.k]);h=i+Ixb(a.b[a.f[f.k].k]);e=e<i?e:i;d=d>h?d:h}}return d-e}
function DQ(a){var b;b=new Tu;Ru(b,'type',new lv((Gkb($z),$z.n)));Ru(b,Dzb,new lv(a.f));!!a.b&&Ru(b,'value',a.b);!!a.a&&Ru(b,'context',a.a);Ru(b,Ezb,new lv(Hb(new Kb('\n'),new wnb(new opb((a.g==null&&(a.g=Pt(a)),a.g))))));return b}
function D5(a,b){if(a.c<b.c){return -1}else if(a.c>b.c){return 1}else if(a.b<b.b){return -1}else if(a.b>b.b){return 1}else if(a.a!=b.a){return a.a.b-b.a.b}else if(a.d==0&&b.d==1){return -1}else if(a.d==1&&b.d==0){return 1}return 0}
function cn(a,b){var c,d,e,f,g;if(b===a){return true}if(!aw(b,20)){return false}g=Wv(b,20);if(a.Y()!=g.Y()){return false}f=g.mb();for(d=a.mb();d.G();){c=d.H();e=f.H();if(!(gw(c)===gw(e)||c!=null&&rb(c,e))){return false}}return true}
function st(b){var c=(!qt&&(qt=tt()),qt);var d=b.replace(/[\x00-\x1f\xad\u0600-\u0603\u06dd\u070f\u17b4\u17b5\u200b-\u200f\u2028-\u202e\u2060-\u2064\u206a-\u206f\ufeff\ufff9-\ufffb"\\]/g,function(a){return rt(a,c)});return '"'+d+'"'}
function ER(a,b){var c,d,e,f,g,h,i;e=b==1?wR:vR;for(d=(g=(new Snb(e.a)).a.bb().mb(),new Ynb(g));d.a.G();){c=(f=Wv(d.a.H(),21),Wv(f.yb(),59));for(i=Wv(Dd(a.f.c,c),18).mb();i.G();){h=Wv(i.H(),27);BU(a.b.b,h.b);BU(a.b.a,Wv(h.b,25).f)}}}
function aR(a,b,c){var d,e,f,g;nI(c,'Recursive layout',2);if(b.b.c.length!=0){g=1/b.b.c.length;for(f=new Tob(b.b);f.a<f.c.c.length;){e=Wv(Rob(f),9);d=Wv(rJ(e,(Rib(),sib)),55);if(d){aR(a,d,rI(c,g));$Q(e,d)}}NQ(a.d,b);_Q(b,c)}bR(b);pI(c)}
function L3(a,b){oR.call(this);this.d=new vtb;this.b=Wv(rJ(b,(Rib(),Jib)),15).a*Wv(rJ(b,(Mjb(),qjb)),15).a;this.e=this.b*Wv(rJ(b,Ejb),15).a;this.a=new jJ;this.c=new jJ;this.j=new VN(a.j,a.k,0,a.n-a.k);this.o=a.g;this.g.a=a.i;K3(this,a)}
function Mtb(a,b){var c,d,e,f,g;f=b==null?0:a.b.Vc(b);d=(c=Ttb(a.a,f),c==null?[]:c);for(g=0;g<d.length;g++){e=d[g];if(a.b.Uc(b,e.yb())){if(d.length==1){d.length=0;a.a[$Ab](f)}else{d.splice(g,1)}--a.c;msb(a.b);return e.zb()}}return null}
function hU(a,b,c){var d;d=null;!!b&&(d=b.e);ZU(a,new VS(b.i.a-d.b+c.a,b.i.b-d.d+c.b));ZU(a,new VS(b.i.a-d.b+c.a,b.i.b+b.j.b+d.a+c.b));ZU(a,new VS(b.i.a+b.j.a+d.c+c.a,b.i.b-d.d+c.b));ZU(a,new VS(b.i.a+b.j.a+d.c+c.a,b.i.b+b.j.b+d.a+c.b))}
function J2(a,b){switch(b.e){case 2:QX(a,(sN(),ZM));a.a.a=a.j.a;a.a.b=a.j.b/2;break;case 4:QX(a,(sN(),rN));a.a.a=0;a.a.b=a.j.b/2;break;case 1:QX(a,(sN(),$M));a.a.a=a.j.a/2;a.a.b=0;break;case 3:QX(a,(sN(),pN));a.a.a=a.j.a/2;a.a.b=a.j.b;}}
function Fq(a,b){Dq();var c,d,e;if(b===a){return true}if(aw(b,207)){e=Wv(b,207);if(a.Y()!=e.Y()||Vg(a).Y()!=e.bb().Y()){return false}for(d=e.bb().mb();d.G();){c=Wv(d.H(),83);if(a.Cb(c.Zb())!=c.Yb()){return false}}return true}return false}
function wvb(a,b){var c,d,e,f,g,h;f=a.a*_Ab+a.b*1502;h=a.b*_Ab+11;c=Math.floor(h*FAb);f+=c;h-=c*aBb;f%=aBb;a.a=f;a.b=h;if(b<=24){return Mlb(a.a*qvb[b])}else{e=a.a*(1<<b-24);g=Mlb(a.b*rvb[b]);d=e+g;d>=2147483648&&(d-=4294967296);return d}}
function MW(a,b,c){var d,e,f;if(b==c){return}d=b;do{vI(a,d.d);f=Wv(rJ(d,(Rib(),zib)),9);if(f){e=d.a;uI(a,e.b,e.d);vI(a,f.i);d=hX(f)}}while(f);d=c;do{EI(a,d.d);f=Wv(rJ(d,(Rib(),zib)),9);if(f){e=d.a;DI(a,e.b,e.d);EI(a,f.i);d=hX(f)}}while(f)}
function n3(a,b){var c,d,e,f,g,h;c=new GU;h=new Um;for(e=(g=(new Snb(a.a)).a.bb().mb(),new Ynb(g));e.a.G();){d=(f=Wv(e.a.H(),21),Wv(f.yb(),12));Nm(h,d.c,d,null);Nm(h,d.d,d,null)}while(h.a){vU(c,m3(h,b,LM(Wv(rJ(b,(eM(),TL)),28))))}return c}
function B7(a,b){var c,d,e,f,g;for(f=new Tob(a.e.a);f.a<f.c.c.length;){e=Wv(Rob(f),61);if(e.c.c.length==e.g.c.length){d=e.e;g=M7(e);for(c=e.e-Wv(g.a,24).a+1;c<e.e+Wv(g.b,24).a;c++){b[c]<b[d]&&(d=c)}if(b[d]<b[e.e]){--b[e.e];++b[d];e.e=d}}}}
function zR(a,b){var c,d,e,f,g,h,i;e=b==1?wR:vR;for(d=(g=(new Snb(e.a)).a.bb().mb(),new Ynb(g));d.a.G();){c=(f=Wv(d.a.H(),21),Wv(f.yb(),59));for(i=Wv(Dd(a.f.c,c),18).mb();i.G();){h=Wv(i.H(),27);vU(a.b.b,Wv(h.b,25));vU(a.b.a,Wv(h.b,25).f)}}}
function ecb(a){$bb();var b,c,d,e,f,g,h;c=(mp(),new wub);for(e=new Tob(a.e.c);e.a<e.c.c.length;){d=Wv(Rob(e),16);for(g=new Tob(d.a);g.a<g.c.c.length;){f=Wv(Rob(g),9);h=a.f[f.k];b=Wv(rub(c,h),20);if(!b){b=new GU;tub(c,h,b)}b.ib(f)}}return c}
function cS(a,b){var c,d,e,f;for(d=new Tob(a.a.a);d.a<d.c.c.length;){c=Wv(Rob(d),78);c.i=true}for(f=new Tob(a.a.b);f.a<f.c.c.length;){e=Wv(Rob(f),25);e.p=Ckb(Ixb(Xv(a.f.B(new RJ(e,b)))));e.f.i=e.f.i&Ckb(Ixb(Xv(a.f.B(new RJ(e,b)))))}return a}
function RY(a,b){var c,d,e,f;e=Eo(mX(b));for(d=WI(e,0);d.b!=d.d.c;){c=Wv(_ub(d),12);f=c.d.f;if(f.g==(CX(),wX)&&!(Ckb(Ixb(Xv(rJ(f,(Rib(),Vhb)))))&&rJ(f,uib)!=null)){BU(f.d.a,f);PX(c.c,null);PX(c.d,null);return RY(a,f)}else{return b}}return b}
function D7(a,b){var c,d,e,f,g,h,i;if(!b.e){throw new slb('The input edge is not a tree edge.')}f=null;e=$xb;for(d=new Tob(a.d);d.a<d.c.c.length;){c=Wv(Rob(d),89);h=c.c;i=c.d;if(I7(a,h,b)&&!I7(a,i,b)){g=i.e-h.e-c.a;if(g<e){e=g;f=c}}}return f}
function Icb(a,b){var c,d,e,f,g;f=b.a;f.c.f==b.b?(g=f.d):(g=f.c);f.c.f==b.b?(d=f.c):(d=f.d);e=vbb(a.a,g,d);if(e>0&&e<rAb){c=wbb(a.a,d.f,e);Bbb(a.a,d.f,-c);return c>0}else if(e<0&&-e<rAb){c=xbb(a.a,d.f,-e);Bbb(a.a,d.f,c);return c>0}return false}
function Odb(a,b,c,d,e){var f,g;if(!yI(MI(Bv(tv(qz,1),Fzb,10,0,[e.f.i,e.i,e.a])),c)){b.c==e?rn(b.a,0,new II(c)):QI(b.a,new II(c));if(d&&!ttb(a.a,c)){g=Wv(rJ(b,(eM(),CL)),44);if(!g){g=new jJ;sJ(b,CL,g)}f=new II(c);TI(g,f,g.c.b,g.c);stb(a.a,f)}}}
function Pdb(a){var b,c,d,e,f,g,h;b=0;for(d=new Tob(a.a);d.a<d.c.c.length;){c=Wv(Rob(d),9);for(f=Uh(mX(c));Cm(f);){e=Wv(Dm(f),12);if(a==e.d.f.d&&e.c.g==(sN(),rN)){g=MX(e.c).b;h=MX(e.d).b;b=b>(h-g<=0?0-(h-g):h-g)?b:h-g<=0?0-(h-g):h-g}}}return b}
function yo(a,b){var c,d,e;if(gw(b)===gw(_b(a))){return true}if(!aw(b,20)){return false}d=Wv(b,20);e=a.Y();if(e!=d.Y()){return false}if(aw(d,63)){for(c=0;c<e;c++){if(!Tb(a.sb(c),d.sb(c))){return false}}return true}else{return Ol(a.mb(),d.mb())}}
function I8(a,b){var c,d,e,f,g,h,i,j;e=a.b[b.k];if(e>=0){return e}else{f=1;for(h=new Tob(b.f);h.a<h.c.c.length;){g=Wv(Rob(h),7);for(d=new Tob(g.e);d.a<d.c.c.length;){c=Wv(Rob(d),12);j=c.d.f;if(b!=j){i=I8(a,j);f=f>i+1?f:i+1}}}H8(a,b,f);return f}}
function edb(a,b,c){var d,e,f,g,h,i;d=0;if(a.b!=0&&b.b!=0){f=WI(a,0);g=WI(b,0);h=Ixb(Yv(_ub(f)));i=Ixb(Yv(_ub(g)));e=true;do{h>i-c&&h<i+c&&++d;h<=i&&f.b!=f.d.c?(h=Ixb(Yv(_ub(f)))):i<=h&&g.b!=g.d.c?(i=Ixb(Yv(_ub(g)))):(e=false)}while(e)}return d}
function sv(a,b){switch(uv(a)){case 5:return ew(b);case 6:return cw(b);case 7:return bw(b);case 0:return Vv(b,a.__elementTypeId$);case 2:return fw(b)&&!(b.ad===kI);case 1:return fw(b)&&!(b.ad===kI)||Vv(b,a.__elementTypeId$);default:return true;}}
function Lv(a,b){var c,d,e,f,g;b&=63;c=a.h;d=(c&524288)!=0;d&&(c|=-1048576);if(b<22){g=c>>b;f=a.m>>b|c<<22-b;e=a.l>>b|a.m<<22-b}else if(b<44){g=d?bzb:0;f=c>>b-22;e=a.m>>b-22|c<<44-b}else{g=d?bzb:0;f=d?azb:0;e=c>>b-44}return Ev(e&azb,f&azb,g&bzb)}
function O9(a,b){switch(a.e){case 1:switch(b.e){case 1:return 1;case 4:return 2;case 3:return 3;case 2:return 4;}break;case 2:switch(b.e){case 1:return 1;case 2:return 2;case 3:return 3;case 4:return 4;}break;default:throw new slb(GAb);}return 0}
function hZ(a,b,c){var d,e,f,g,h,i;d=new GU;d.c[d.c.length]=b;i=b;h=0;do{i=mZ(a,i);!!i&&(d.c[d.c.length]=i,true);++h}while(i);g=(c-(d.c.length-1)*a.d.d)/d.c.length;for(f=new Tob(d);f.a<f.c.c.length;){e=Wv(Rob(f),9);e.j.a=g}return new RJ(Elb(h),g)}
function kZ(a,b,c){var d,e,f,g,h,i;d=new GU;d.c[d.c.length]=b;i=b;h=0;do{i=lZ(a,i);!!i&&(d.c[d.c.length]=i,true);++h}while(i);g=(c-(d.c.length-1)*a.d.d)/d.c.length;for(f=new Tob(d);f.a<f.c.c.length;){e=Wv(Rob(f),9);e.j.a=g}return new RJ(Elb(h),g)}
function m$(a){var b,c,d,e,f,g;e=Wv(yU(a.f,0),7);g=0;for(d=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[new fY(e),new lY(e)]))))));Cm(d);){c=Wv(Dm(d),7);g+=c.f.i.a+c.i.a+c.a.a}b=Wv(rJ(a,(eM(),SL)),10);f=!b?0:b.a;a.i.a=g/(e.b.c.length+e.e.c.length)-f}
function Ueb(a,b){var c,d,e,f;if(b<2*a.c){throw new slb('The knot vector must have at least two time the dimension elements.')}a.j=0;a.i=1;for(d=0;d<a.c;d++){a.g.ib(0)}f=b+1-2*a.c;for(e=1;e<f;e++){a.g.ib(e/f)}if(a.e){for(c=0;c<a.c;c++){a.g.ib(1)}}}
function Fs(a){var b,c;c=a.c;a.c=0;ds(a.f,a.i);if(!a.e){return a.g}else if(!a.g){return a.e}else if(a.e.d>=a.g.d){b=a.f;b.e=Is(a.e,b);b.g=a.g;b.a=a.a-1;b.j=XH(a.j,c);return Gs(b)}else{b=a.i;b.g=Js(a.g,b);b.e=a.e;b.a=a.a-1;b.j=XH(a.j,c);return Gs(b)}}
function e2(a){var b,c,d,e,f,g;for(e=new Tob(a.a);e.a<e.c.c.length;){d=Wv(Rob(e),9);if(d.g==(CX(),BX)){f=Wv(rJ(d,(Rib(),nib)),9);c=d.f;b=(Cxb(0,c.c.length),Wv(c.c[0],7));g=Wv(rJ(b,uib),7);g.g==(sN(),$M)&&d.k>f.k?QX(g,pN):g.g==pN&&f.k>d.k&&QX(g,$M)}}}
function q3(a,b,c){var d,e,f,g,h,i,j;j=a.b;g=0;for(f=new Tob(a.a.b);f.a<f.c.c.length;){e=Wv(Rob(f),33);g=Nlb(g,e.j.a)}i=wfb(a.a.c,a.a.d,b,c,g);Ue(a.a.a,Veb(i));h=s3(a.a.b,i.a,j);d=new Dfb((!i.k&&(i.k=new Efb(Xeb(i))),i.k));zfb(d);return !h?d:Gfb(d,h)}
function wbb(a,b,c){var d,e,f,g,h,i,j;d=c;e=b;do{e=a.a[e.k];g=(j=a.f[e.k],Ixb(a.n[j.k])+Ixb(a.d[e.k])-e.e.d);h=zbb(e,!e.d?-1:zU(e.d.a,e,0));if(h){f=(i=a.f[h.k],Ixb(a.n[i.k])+Ixb(a.d[h.k])+h.j.b+h.e.a);d=Qlb(d,g-(f+Xjb(a.j,e,h)))}}while(b!=e);return d}
function xbb(a,b,c){var d,e,f,g,h,i,j;d=c;e=b;do{e=a.a[e.k];f=(j=a.f[e.k],Ixb(a.n[j.k])+Ixb(a.d[e.k])+e.j.b+e.e.a);h=ybb(e,!e.d?-1:zU(e.d.a,e,0));if(h){g=(i=a.f[h.k],Ixb(a.n[i.k])+Ixb(a.d[h.k])-h.e.d);d=Qlb(d,g-(f+Xjb(a.j,e,h)))}}while(b!=e);return d}
function Sr(b,c,d){var e,f,g;Mh(d,Xyb);if(d==0){return Pr(b,c)}g=b.c.a;f=xv(mw,Yyb,26,1,12,1);try{if(!ok(b.b,c)||!g){return 0}e=Hs(g,b.d,c,d,f)}catch(a){a=OH(a);if(aw(a,119)){return 0}else if(aw(a,76)){return 0}else throw NH(a)}Us(b.c,g,e);return f[0]}
function MO(a,b){var c,d,e,f,g;if(a.b){d=Wv(oW(a.e,(eM(),jL)),65);e=d.b+d.c;c=d.d+d.a}else{e=b*2;c=b*2}g=Nlb(a.o[1]>0?e+a.i[1]*b+a.n[1]:0,a.o[3]>0?e+a.i[3]*b+a.n[3]:0);f=Nlb(a.o[4]>0?c+a.i[4]*b+a.n[4]:0,a.o[2]>0?c+a.i[2]*b+a.n[2]:0);return new HI(g,f)}
function b$(a){var b,c,d,e,f,g;g=Wv(FU(a.a,xv(qB,Nzb,9,a.a.c.length,0,1)),51);lpb(g,new g$);c=null;for(e=0,f=g.length;e<f;++e){d=g[e];if(d.g!=(CX(),xX)){break}b=Wv(rJ(d,(Rib(),hib)),32);if(b!=(sN(),rN)&&b!=ZM){continue}!!c&&Wv(rJ(c,oib),20).ib(d);c=d}}
function j6(a,b,c,d,e){var f,g,h,i;i=new U6(b,d);for(h=T6(i);h.G();){f=Wv(h.H(),7);Umb(a.k,f,Elb(Wv(Smb(a.k,f),24).a+Wv(re(Ktb(e.d,c)),24).a))}i=new U6(c,d);for(g=T6(i);g.G();){f=Wv(g.H(),7);Umb(a.k,f,Elb(Wv(Smb(a.k,f),24).a-Wv(re(Ktb(e.d,b)),24).a))}}
function hI(a,b,c){var d=fI,h;var e=d[a];var f=e instanceof Array?e[0]:null;if(e&&!f){_=e}else{_=(h=b&&b.prototype,!h&&(h=fI[b]),jI(h));_._c=c;_.constructor=_;!b&&(_.ad=kI);d[a]=_}for(var g=3;g<arguments.length;++g){arguments[g].prototype=_}f&&(_.$c=f)}
function Wkb(a){if(a.Sc()){var b=a.c;b.Tc()?(a.n='['+b.k):!b.Sc()?(a.n='[L'+b.Qc()+';'):(a.n='['+b.Qc());a.b=b.Pc()+'[]';a.j=b.Rc()+'[]';return}var c=a.i;var d=a.d;d=d.split('/');a.n=Zkb('.',[c,Zkb('$',d)]);a.b=Zkb('.',[c,Zkb('.',d)]);a.j=d[d.length-1]}
function Mr(a,b,c){var d;if(!c){return 0}d=a.d.$b(a.b.g,c.b);if(d>0){return Mr(a,b,c.g)}else if(d==0){switch(a.b.f.e){case 0:return PH(b._b(c),b.ac(c.g));case 1:return b.ac(c.g);default:throw new tkb;}}else{return PH(PH(b.ac(c.g),b._b(c)),Mr(a,b,c.e))}}
function Nr(a,b,c){var d;if(!c){return 0}d=a.d.$b(a.b.e,c.b);if(d<0){return Nr(a,b,c.e)}else if(d==0){switch(a.b.d.e){case 0:return PH(b._b(c),b.ac(c.e));case 1:return b.ac(c.e);default:throw new tkb;}}else{return PH(PH(b.ac(c.e),b._b(c)),Nr(a,b,c.g))}}
function z2(a,b,c,d){var e,f,g,h;g=new uX(a);sX(g,(CX(),zX));sJ(g,(Rib(),uib),b);sJ(g,(eM(),TL),(KM(),FM));sJ(g,qib,c);sJ(g,rib,d);f=new RX;QX(f,(sN(),rN));PX(f,g);h=new RX;QX(h,ZM);PX(h,g);eW(b,f);e=new hW;qJ(e,b);sJ(e,CL,null);dW(e,h);eW(e,d);return g}
function e6(a,b){var c,d,e,f,g,h,i,j,k,l;c=0;for(g=a.j,h=0,i=g.length;h<i;++h){f=g[h];l=new U6(f,b);for(k=T6(l);k.G();){j=Wv(k.H(),7);for(e=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[j.b,j.e]))))));Cm(e);){d=Wv(Dm(e),12);bW(d)||(c+=b6(a,d,j))}}}return c}
function qab(a,b){if(a.c<b.c){return -1}else if(a.c>b.c){return 1}else if(a.b<b.b){return -1}else if(a.b>b.b){return 1}else if(a.a!=b.a){return txb(a.a)-txb(b.a)}else if(a.d==(vab(),uab)&&b.d==tab){return -1}else if(a.d==tab&&b.d==uab){return 1}return 0}
function R4(a){var b,c,d,e,f,g;e=new aJ;for(d=new Tob(a.d.a);d.a<d.c.c.length;){c=Wv(Rob(d),61);c.c.c.length==0&&(TI(e,c,e.c.b,e.c),true)}if(e.b>1){b=x7(y7(new A7,a.b++),a.d);for(g=WI(e,0);g.b!=g.d.c;){f=Wv(_ub(g),61);f7(i7(h7(j7(g7(new k7,1),0),b),f))}}}
function p3(a,b,c,d){var e,f,g,h,i,j;j=0;for(g=new Tob(a.a.b);g.a<g.c.c.length;){f=Wv(Rob(g),33);j=Nlb(j,f.j.a)}i=vfb(a.a.c,b,a.a.d,d,Jeb(a.b),c);Ue(a.a.a,Veb(i));h=s3(a.a.b,i.a,a.b);e=new Dfb((!i.k&&(i.k=new Efb(Xeb(i))),i.k));zfb(e);return !h?e:Gfb(e,h)}
function M0(a,b){var c,d,e,f,g;for(d=new Tob(a.b);d.a<d.c.c.length;){c=Wv(Rob(d),33);sJ(c,(Rib(),pib),b)}for(g=new Tob(a.c.c);g.a<g.c.c.length;){e=Wv(Rob(g),33);sJ(e,(Rib(),pib),b)}for(f=new Tob(a.d.c);f.a<f.c.c.length;){e=Wv(Rob(f),33);sJ(e,(Rib(),pib),b)}}
function I1(){I1=iI;G1=new J1(tzb,0);B1=new J1('NIKOLOV',1);E1=new J1('NIKOLOV_PIXEL',2);C1=new J1('NIKOLOV_IMPROVED',3);D1=new J1('NIKOLOV_IMPROVED_PIXEL',4);A1=new J1('DUMMYNODE_PERCENTAGE',5);F1=new J1('NODECOUNT_PERCENTAGE',6);H1=new J1('NO_BOUNDARY',7)}
function cab(a,b){var c,d,e,f,g;f=0;g=Wv(re(Ktb(b.d,a)),24);if(!g){return 0}for(e=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[a.b,a.e]))))));Cm(e);){d=Wv(Dm(e),12);d.c==a?(c=Wv(Smb(b,d.d),24)):(c=Wv(Smb(b,d.c),24));!!c&&g.a>c.a&&(f=Plb(f,g.a-c.a-1))}return f}
function RZ(a){var b,c;b=Wv(rJ(a,(eM(),HL)),15).a;c=Wv(rJ(a,IL),15).a;sJ(a,IL,new llb(b));sJ(a,HL,new llb(c));switch(Wv(rJ(a,lL),103).e){case 1:sJ(a,lL,(iK(),hK));break;case 2:sJ(a,lL,(iK(),dK));break;case 3:sJ(a,lL,(iK(),fK));break;case 4:sJ(a,lL,(iK(),gK));}}
function N0(a){var b,c,d,e,f;for(e=(Il(),new Im(Dl(ul(a.a,new yl))));Cm(e);){d=Wv(Dm(e),9);if(d.g==(CX(),yX)){f=P0(d)?(kP(),hP):(kP(),gP);sJ(d,(Rib(),pib),f)}for(c=Uh(mX(d));Cm(c);){b=Wv(Dm(c),12);f=Ckb(Ixb(Xv(rJ(b,(Rib(),Iib)))))?(kP(),gP):(kP(),hP);M0(b,f)}}}
function O0(a){var b,c,d,e,f;for(e=(Il(),new Im(Dl(ul(a.a,new yl))));Cm(e);){d=Wv(Dm(e),9);if(d.g==(CX(),yX)){f=P0(d)?(kP(),gP):(kP(),hP);sJ(d,(Rib(),pib),f)}for(c=Uh(mX(d));Cm(c);){b=Wv(Dm(c),12);f=Ckb(Ixb(Xv(rJ(b,(Rib(),Iib)))))?(kP(),hP):(kP(),gP);M0(b,f)}}}
function jdb(a,b,c){var d,e,f;for(f=new Tob(a.e);f.a<f.c.c.length;){d=Wv(Rob(f),118);if(d.b.d<0&&d.c>0){d.b.c-=d.c;d.b.c<=0&&d.b.f>0&&QI(b,d.b)}}for(e=new Tob(a.b);e.a<e.c.c.length;){d=Wv(Rob(e),118);if(d.a.d<0&&d.c>0){d.a.f-=d.c;d.a.f<=0&&d.a.c>0&&QI(c,d.a)}}}
function agb(a,b,c){var d,e,f;for(f=new Tob(a.j);f.a<f.c.c.length;){d=Wv(Rob(f),117);if(d.b.i<0&&d.c>0){d.b.e-=d.c;d.b.e<=0&&d.b.k>0&&QI(b,d.b)}}for(e=new Tob(a.d);e.a<e.c.c.length;){d=Wv(Rob(e),117);if(d.a.i<0&&d.c>0){d.a.k-=d.c;d.a.k<=0&&d.a.e>0&&QI(c,d.a)}}}
function tj(a){var b,c,d,e,f;f=a.d.c+a.e.c;switch(f){case 0:return dr(),cr;case 1:d=Wv(Sl(new rnb((new inb(a)).a)),21);return Bj(d.yb(),d.zb());default:e=(mp(),new wub);for(c=new rnb((new inb(a)).a);c.b;){b=pnb(c);tub(e,_b(b.yb()),_b(b.zb()))}return new ir(e);}}
function DS(a,b,c){var d,e,f;for(e=new Tob(a.b.a.b);e.a<e.c.c.length;){d=Wv(Rob(e),25);if(!b.D(d)){continue}f=Ixb(Yv(c.B(d)));if(f>0){!(tK(a.b.d)&&d.q.d)&&!(uK(a.b.d)&&d.q.b)&&(d.j.e+=0>f/2-0.5?0:f/2-0.5);!(tK(a.b.d)&&d.q.a)&&!(uK(a.b.d)&&d.q.c)&&(d.j.b-=f-1)}}}
function R9(a,b){switch(a.e){case 1:switch(b.e){case 1:return HAb;case 4:return 0.5;case 3:return IAb;case 2:return JAb;}break;case 2:switch(b.e){case 1:return HAb;case 2:return 0.5;case 3:return IAb;case 4:return JAb;}break;default:throw new slb(GAb);}return 0}
function rT(a,b){var c,d,e,f;f=new Fnb(a,0);c=(Bxb(f.b<f.d.Y()),Wv(f.d.sb(f.c=f.b++),48));while(f.b<f.d.Y()){d=(Bxb(f.b<f.d.Y()),Wv(f.d.sb(f.c=f.b++),48));e=new WS(d.c,c.d,b);Bxb(f.b>0);f.a.sb(f.c=--f.b);Anb(f,e);Bxb(f.b<f.d.Y());f.d.sb(f.c=f.b++);e.a=false;c=d}}
function oZ(a){var b,c,d,e,f,g;e=Wv(rJ(a,(Rib(),Zhb)),7);for(g=new Tob(a.f);g.a<g.c.c.length;){f=Wv(Rob(g),7);for(d=new Tob(f.e);d.a<d.c.c.length;){b=Wv(Rob(d),12);eW(b,e);return f}for(c=new Tob(f.b);c.a<c.c.c.length;){b=Wv(Rob(c),12);dW(b,e);return f}}return null}
function i6(a,b,c,d,e){var f,g,h,i,j,k;g=b;f=0;h=false;k=new U6(c,d);for(j=T6(k);j.G();){i=Wv(j.H(),7);h=true;Umb(a.k,i,Elb(g));if(LM(Wv(rJ(c,(eM(),TL)),28))||i.b.c.length+i.e.c.length>1){++f;++g}}if(!LM(Wv(rJ(c,(eM(),TL)),28))&&h){++f;++g}Umb(e,c,Elb(f));return g}
function nfb(a){var b,c,d,e,f,g,h,i,j,k,l,m;g=a.b.mb();h=Wv(g.H(),92);k=h.a.a;j=k>RAb;i=k<SAb;while(g.G()){c=h;f=k;e=j;d=i;h=Wv(g.H(),92);k=h.a.a;j=k>RAb;i=k<SAb;if(!(j||i)){return mfb(h.b)}if(e&&i||d&&j){b=f/(f-k);l=mfb(c.b);m=mfb(h.b);return b*l+(1-b)*m}}return 0}
function ofb(a){var b,c,d,e,f,g,h,i,j,k,l,m;g=a.b.mb();h=Wv(g.H(),92);k=h.a.b;j=k>RAb;i=k<SAb;while(g.G()){c=h;f=k;e=j;d=i;h=Wv(g.H(),92);k=h.a.b;j=k>RAb;i=k<SAb;if(!(j||i)){return mfb(h.b)}if(e&&i||d&&j){b=f/(f-k);l=mfb(c.b);m=mfb(h.b);return b*l+(1-b)*m}}return 0}
function b6(a,b,c){var d,e;d=0;if(d6(b)){if(ttb(a.g,b)){Sr(a.i,Elb(h6(a,b.c)),1)>0;Sr(a.i,Elb(h6(a,b.d)),1)>0;utb(a.g,b);d+=g6(a,b,a.i)}else{stb(a.g,b);Lr(a.i,Elb(h6(a,b.c)),1);Lr(a.i,Elb(h6(a,b.d)),1)}}else{e=Pr(a.i,Elb(Wv(Smb(a.k,c),24).a));d+=a.g.a.Y()-e}return d}
function Keb(a){switch(a.e){case 0:return veb;case 1:return seb;case 2:return reb;case 3:return yeb;case 4:return xeb;case 5:return Deb;case 6:return Ceb;case 7:return web;case 8:return teb;case 9:return ueb;case 11:return Aeb;case 10:return zeb;default:return Beb;}}
function Leb(a){switch(a.e){case 0:return neb;case 1:return meb;case 2:return jeb;case 3:return ieb;case 4:return peb;case 5:return oeb;case 6:return Heb;case 7:return Geb;case 8:return leb;case 9:return keb;case 10:return Eeb;case 11:return qeb;default:return Feb;}}
function Meb(a){switch(a.e){case 0:return oeb;case 1:return Heb;case 2:return Geb;case 3:return neb;case 4:return meb;case 5:return jeb;case 6:return ieb;case 7:return peb;case 8:return leb;case 9:return keb;case 10:return Eeb;case 11:return qeb;default:return Feb;}}
function Neb(a){switch(a.e){case 0:return jeb;case 1:return ieb;case 2:return peb;case 3:return oeb;case 4:return Heb;case 5:return Geb;case 6:return neb;case 7:return meb;case 8:return leb;case 9:return keb;case 10:return Eeb;case 11:return qeb;default:return Feb;}}
function fcb(a){var b,c,d,e,f,g,h,i;c=(mp(),new wub);h=new Yub((Oh(),new opb(a.f)));for(g=(e=(new Snb(h.a)).a.bb().mb(),new Ynb(e));g.a.G();){f=(d=Wv(g.a.H(),21),Wv(d.yb(),9));if(!f){Fmb();break}i=a.i[f.k];b=Wv(rub(c,i),20);if(!b){b=new GU;tub(c,i,b)}b.ib(f)}return c}
function CS(a,b,c){var d,e,f;for(e=new Tob(a.b.a.b);e.a<e.c.c.length;){d=Wv(Rob(e),25);if(!b.D(d)){continue}f=Ixb(Yv(c.B(d)));if(f>0){!(tK(a.b.d)&&d.q.d)&&!(uK(a.b.d)&&d.q.b)&&(d.j.e-=0>f/2-0.5?0:f/2-0.5);!(tK(a.b.d)&&d.q.a)&&!(uK(a.b.d)&&d.q.c)&&(d.j.b+=0>f-1?0:f-1)}}}
function T6(a){var b,c,d;d=a.a.f;switch(a.b){case 0:return new Tob(a.a.f);case 1:return Pl((c=new W6(d),c),S6(a));case 2:switch(a.c.e){case 2:case 1:return Pl(new Tob(d),S6(a));case 3:case 4:return Pl((b=new W6(d),b),S6(a));}}throw new Imb('PortOrder not implemented.')}
function CT(a,b){var c;if(!!a.d&&(b.c!=a.e.c||hT(a.e.b,b.b))){vU(a.f,a.d);a.a=a.d.d+a.d.c;a.d=null;a.e=null}eT(b.b)?(a.c=b):(a.b=b);if(b.b==(cT(),$S)&&!b.a||b.b==_S&&b.a||b.b==aT&&b.a||b.b==bT&&!b.a){if(!!a.c&&!!a.b){c=new VN(a.a,a.c.d,b.c-a.a,a.b.d-a.c.d);a.d=c;a.e=b}}}
function Cbb(a,b,c,d){this.e=a;this.j=Wv(rJ(a,(Rib(),Kib)),134);this.f=xv(qB,Nzb,9,b,0,1);this.b=xv(HF,Txb,184,b,6,1);this.a=xv(qB,Nzb,9,b,0,1);this.d=xv(HF,Txb,184,b,6,1);this.i=xv(qB,Nzb,9,b,0,1);this.g=xv(HF,Txb,184,b,6,1);this.n=xv(HF,Txb,184,b,6,1);this.k=c;this.c=d}
function P6(a,b,c){var d,e;if(b.g==(CX(),BX)&&c.g==BX){if(!LM(Wv(rJ(Wv(rJ(b,(Rib(),uib)),9),(eM(),TL)),28))||Wv(rJ(b,uib),9)!=Wv(rJ(c,uib),9)){return}if(I6(b)||I6(c)){a.d=1;a.b=1;return}e=Wv(yU(b.f,0),7).g;d=Wv(yU(c.f,0),7).g;M6(b).g==(sN(),$M)?H6(a,b,c,e,d):H6(a,c,b,d,e)}}
function f7(a){if(!a.a.c||!a.a.d){throw new ulb((Gkb(QD),QD.j+' must have a source and target '+(Gkb(UD),UD.j)+' specified.'))}if(a.a.c==a.a.d){throw new ulb('Network simplex does not support self-loops: '+a.a+' '+a.a.c+' '+a.a.d)}o7(a.a.c.g,a.a);o7(a.a.d.c,a.a);return a.a}
function H6(a,b,c,d,e){if(d==(sN(),ZM)&&e==ZM){N6(a,b)>N6(a,c)?(a.d=K6(a,c)):(a.b=K6(a,b))}else if(d==rN&&e==rN){N6(a,b)<N6(a,c)?(a.d=K6(a,c)):(a.b=K6(a,b))}else if(d==rN&&e==ZM){if(N6(a,b)>N6(a,c)){a.d=K6(a,c);a.b=K6(a,b)}}else{if(N6(a,b)<N6(a,c)){a.d=K6(a,c);a.b=K6(a,b)}}}
function W1(a){var b,c,d,e,f,g,h,i;i=a.f.c.length;c=0;b=i;e=2*i;for(h=new Tob(a.f);h.a<h.c.c.length;){g=Wv(Rob(h),7);switch(g.g.e){case 2:case 4:g.k=-1;break;case 1:case 3:d=g.b.c.length;f=g.e.c.length;d>0&&f>0?(g.k=b++):d>0?(g.k=c++):f>0?(g.k=e++):(g.k=c++);}}Gpb(a.f,new Z1)}
function i0(a,b,c,d){var e,f,g,h,i;if(c.d.f==b.f){return}e=new uX(a);sX(e,(CX(),zX));sJ(e,(Rib(),uib),c);sJ(e,(eM(),TL),(KM(),FM));d.c[d.c.length]=e;g=new RX;PX(g,e);QX(g,(sN(),rN));h=new RX;PX(h,e);QX(h,ZM);i=c.d;eW(c,g);f=new hW;qJ(f,c);sJ(f,CL,null);dW(f,h);eW(f,i);j0(e,g,h)}
function W2(a){var b,c,d,e,f,g,h,i,j;g=rAb;i=rAb;h=null;for(c=new Sub(new Lub(a.e));c.b!=c.c.a.b;){b=Rub(c);if(Wv(b.d,60).c==1){d=Wv(b.e,116).a;j=Wv(b.e,116).b;e=g-d>uAb;f=d-g<uAb&&i-j>uAb;if(e||f){i=Wv(b.e,116).b;g=Wv(b.e,116).a;h=Wv(b.d,60);if(i==0&&g==0){return h}}}}return h}
function i1(a,b){var c,d,e,f,g,h;f=a.d;h=Wv(rJ(a,(eM(),dM)),15).a;if(h<0){h=0;sJ(a,dM,new llb(h))}b.j.b=h;g=Math.floor(h/2);d=new RX;QX(d,(sN(),rN));PX(d,b);d.i.b=g;e=new RX;QX(e,ZM);PX(e,b);e.i.b=g;eW(a,d);c=new hW;qJ(c,a);sJ(c,CL,null);dW(c,e);eW(c,f);h1(b,a,c);f1(a,c);return c}
function OZ(a){var b,c;c=Wv(rJ(a,(Mjb(),vjb)),85);b=Wv(rJ(a,(Rib(),mib)),140);if(c==(Xib(),Tib)){sJ(a,vjb,Wib);sJ(a,mib,(Hhb(),Ghb))}else if(c==Vib){sJ(a,vjb,Wib);sJ(a,mib,(Hhb(),Ehb))}else if(b==(Hhb(),Ghb)){sJ(a,vjb,Tib);sJ(a,mib,Fhb)}else if(b==Ehb){sJ(a,vjb,Vib);sJ(a,mib,Fhb)}}
function QO(a){var b,c,d,e,f;for(d=new Tob(zW(a.e));d.a<d.c.c.length;){c=Wv(Rob(d),129);f=new II(c.e.i);e=xO()[c.e.k];b=Wv(qsb(a.c,e),283);f.b=b.e+b.a;e.b==(DO(),BO)?(f.a=b.d):e.b==AO?(f.a=b.d+(b.c-c.e.j.a)/2):e.b==CO&&(f.a=b.d+b.c-c.e.j.a);c.e.i.a=f.a;c.e.i.b=f.b;b.a+=c.e.j.b+a.d}}
function UO(a){var b,c,d;for(c=new Tob(AW(a));c.a<c.c.c.length;){b=Wv(Rob(c),161);d=new II(b.e.i);switch(Wv(b.e,7).g.e){case 4:d.a=0;d.b=a.e.j.b/2;break;case 2:d.a=a.e.j.a;d.b=a.e.j.b/2;break;case 1:d.a=a.e.j.a/2;d.b=0;break;case 3:d.a=a.e.j.a/2;d.b=a.e.j.b;}b.e.i.a=d.a;b.e.i.b=d.b}}
function oV(){this.c=xv(kw,hyb,26,(sN(),Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN])).length,12,1);this.b=xv(kw,hyb,26,Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN]).length,12,1);this.a=xv(kw,hyb,26,Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN]).length,12,1);Yob(this.c,Uzb);Yob(this.b,Vzb);Yob(this.a,Vzb)}
function tfb(a,b,c){var d,e,f,g,h,i,j,k;f=Ixb(Yv(a.b.mb().H()));j=Ixb(Yv(rl(b.b)));d=CI(xI(a.a),j-c);e=CI(xI(b.a),c-f);k=vI(d,e);CI(k,1/(j-f));this.a=k;this.b=new GU;h=true;g=a.b.mb();g.H();while(g.G()){i=Ixb(Yv(g.H()));if(h&&i-c>RAb){this.b.ib(c);h=false}this.b.ib(i)}h&&this.b.ib(c)}
function G7(a){var b,c,d,e;J7(a,a.n);if(a.d.c.length>0){dpb(a.c);while(R7(a,Wv(Rob(new Tob(a.e.a)),61))<a.e.a.c.length){b=L7(a);e=b.d.e-b.c.e-b.a;b.d.j&&(e=-e);for(d=new Tob(a.e.a);d.a<d.c.c.length;){c=Wv(Rob(d),61);c.j&&(c.e+=e)}dpb(a.c)}dpb(a.c);O7(a,Wv(Rob(new Tob(a.e.a)),61));C7(a)}}
function Aab(a,b){var c,d,e,f,g,h,i;c=Vzb;h=(CX(),AX);for(e=new Tob(b.a);e.a<e.c.c.length;){d=Wv(Rob(e),9);f=d.g;if(f!=AX){g=Yv(rJ(d,(Rib(),wib)));if(g==null){c=c>0?c:0;d.i.b=c+Wjb(a.a,f,h)}else{d.i.b=(Dxb(g),g)}}i=Wjb(a.a,f,h);d.i.b<c+i+d.e.d&&(d.i.b=c+i+d.e.d);c=d.i.b+d.j.b+d.e.a;h=f}}
function mdb(a,b,c){var d,e,f;c.db(b,a);vU(a.g,b);f=a.o.d.Lc(b);hlb(a.k)?(a.k=f):(a.k=Qlb(a.k,f));hlb(a.a)?(a.a=f):(a.a=Nlb(a.a,f));b.g==a.o.d.Mc()?hdb(a.j,f):hdb(a.n,f);for(e=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[new fY(b),new lY(b)]))))));Cm(e);){d=Wv(Dm(e),7);c.R(d)||mdb(a,d,c)}}
function dlb(a){var b,c,d,e,f;d=(bmb(),a.length);e=d>0&&(a.charCodeAt(0)==45||a.charCodeAt(0)==43)?1:0;for(b=e;b<d;b++){if(Dkb(a.charCodeAt(b))==-1){throw new Ylb(dyb+a+'"')}}f=parseInt(a,10);c=f<eyb;if(isNaN(f)){throw new Ylb(dyb+a+'"')}else if(c||f>$xb){throw new Ylb(dyb+a+'"')}return f}
function H$(a,b,c,d){var e,f,g,h;e=Wv(nX(b,(sN(),rN)).mb().H(),7);f=Wv(nX(b,ZM).mb().H(),7);for(h=new Tob(a.f);h.a<h.c.c.length;){g=Wv(Rob(h),7);while(g.b.c.length!=0){eW(Wv(yU(g.b,0),12),e)}while(g.e.c.length!=0){dW(Wv(yU(g.e,0),12),f)}}c||sJ(b,(Rib(),qib),null);d||sJ(b,(Rib(),rib),null)}
function jU(a){var b,c,d,e,f,g,h;h=new $U;for(g=new Tob(a.b);g.a<g.c.c.length;){f=Wv(Rob(g),9);if(f.g==(CX(),xX)){continue}hU(h,f,new FI);for(e=Uh(mX(f));Cm(e);){d=Wv(Dm(e),12);if(d.c.f.g==xX||d.d.f.g==xX){continue}for(c=WI(d.a,0);c.b!=c.d.c;){b=Wv(_ub(c),10);ZU(h,new VS(b.a,b.b))}}}return h}
function X4(a,b,c,d){var e,f,g;this.e=new jJ;this.a=a;this.b=b;if(a.b<b.b){this.j=a.a;this.k=a.b;this.n=b.b}else{this.j=b.a;this.k=b.b;this.n=a.b}e=Wv(rJ(d,(eM(),CL)),44);if(e){for(g=WI(e,0);g.b!=g.d.c;){f=Wv(_ub(g),10);RR(f.a,a.a)&&QI(this.e,f)}}this.g=c;!!this.g&&(this.i=this.j-c.j.d);this.f=d}
function Zj(a){hi();var b,c,d,e,f,g;g=new Wub;zpb(g,a);for(c=(f=(new Snb(g.a)).a.bb().mb(),new Ynb(f));c.a.G();){b=(d=Wv(c.a.H(),21),d.yb());_b(b)}switch(g.a.Y()){case 0:return kr(),jr;case 1:return new Gr((e=(new Snb(g.a)).a.bb().mb(),d=Wv((new Ynb(e)).a.H(),21),d.yb()));default:return new lr(g);}}
function $P(a,b,c,d){var e,f,g;VP(a,c,'x',b.i.a+d.a);VP(a,c,'y',b.i.b+d.b);VP(a,c,Jzb,b.j.a);VP(a,c,Kzb,b.j.b);if(aw(b,9)){if(Wv(rJ(b,(eM(),bM)),86).kb((MN(),JN))){e=Wv(b,9).b;g=Pu(c,Lzb);if(!g){g=new Tu;Ru(c,Lzb,g)}f=g.kc();VP(a,f,'left',e.b);VP(a,f,'top',e.d);VP(a,f,'right',e.c);VP(a,f,Azb,e.a)}}}
function GR(a,b){var c,d,e,f,g,h,i,j,k,l;g=b==1?wR:vR;for(f=(i=(new Snb(g.a)).a.bb().mb(),new Ynb(i));f.a.G();){e=(h=Wv(f.a.H(),21),Wv(h.yb(),59));for(k=Wv(Dd(a.f.c,e),18).mb();k.G();){j=Wv(k.H(),27);d=Wv(j.b,25);l=Wv(j.a,78);c=l.c;switch(e.e){case 2:case 1:d.j.e+=c;break;case 4:case 3:d.j.d+=c;}}}}
function IS(a,b){var c,d,e;b.a?(Rwb(a.b,b.b),a.a[b.b.k]=Wv(Twb(a.b,b.b),25),c=Wv(Swb(a.b,b.b),25),!!c&&(a.a[c.k]=b.b),undefined):(d=Wv(Twb(a.b,b.b),25),!!d&&d==a.a[b.b.k]&&!!d.f&&d.f!=b.b.f&&d.i.ib(b.b),e=Wv(Swb(a.b,b.b),25),!!e&&a.a[e.k]==b.b&&!!e.f&&e.f!=b.b.f&&b.b.i.ib(e),Uwb(a.b,b.b),undefined)}
function p1(a,b){var c,d,e,f,g,h,i;e=new GU;for(c=0;c<=a.i;c++){d=new sY(b);d.k=a.i-c;e.c[e.c.length]=d}for(h=new Tob(a.o);h.a<h.c.c.length;){g=Wv(Rob(h),9);rX(g,Wv(yU(e,a.i-a.f[g.k]),16))}f=new Tob(e);while(f.a<f.c.c.length){i=Wv(Rob(f),16);i.a.c.length==0&&Sob(f)}b.c.c=xv(UF,syb,1,0,4,1);xU(b.c,e)}
function N4(a){var b,c,d,e;a.a.a.c=xv(UF,syb,1,0,4,1);for(d=new Tob(a.a.b);d.a<d.c.c.length;){b=Wv(Rob(d),25);b.f=null}for(e=new Tob(a.a.b);e.a<e.c.c.length;){b=Wv(Rob(e),25);!b.o&&vU(a.a.a,new QR(Bv(tv(kA,1),syb,25,0,[b])))}for(c=new Tob(a.a.b);c.a<c.c.c.length;){b=Wv(Rob(c),25);!!b.o&&OR(b.o.f,b)}}
function fc(a,b){var c,d,e,f;a=(bmb(),a==null?Wxb:a);c=(a.length+16*b.length,new Amb);f=0;d=0;while(d<b.length){e=a.indexOf('%s',f);if(e==-1){break}jkb(c,a,f,e);xmb(c,b[d++]);f=e+2}wmb(c,a,f,a.length);if(d<b.length){c.a+=' [';xmb(c,b[d++]);while(d<b.length){c.a+=', ';xmb(c,b[d++])}c.a+=']'}return c.a}
function _vb(a,b,c,d){var e,f;if(!b){return c}else{e=a.a.$b(c.d,b.d);if(e==0){d.d=job(b,c.e);d.b=true;return b}f=e<0?0:1;b.a[f]=_vb(a,b.a[f],c,d);if(awb(b.a[f])){if(awb(b.a[1-f])){b.b=true;b.a[0].b=false;b.a[1].b=false}else{awb(b.a[f].a[f])?(b=hwb(b,1-f)):awb(b.a[f].a[1-f])&&(b=gwb(b,1-f))}}}return b}
function GY(a,b){var c,d,e,f,g,h,i,j,k,l;i=pmb(b.a);h=hw(Llb(i/a.a));l=b.a;g=0;j=h;for(f=0;f<a.a;++f){k=(bmb(),l.substr((0>g?0:g)<i?0>g?0:g:i,(0>(j<i?j:i)?0:j<i?j:i)-((0>g?0:g)<i?0>g?0:g:i)));g=j;j+=h;d=Wv(yU(a.c,f),9);c=new dX(k);c.j.b=b.j.b;Fd(a.b,b,c);vU(d.c,c)}BU(a.g.c,b);vU(a.i,(e=new PY(a,b),e))}
function p8(a,b,c){var d,e,f,g,h,i,j,k,l;b.k=1;f=b.d;for(l=oX(b,(djb(),bjb)).mb();l.G();){k=Wv(l.H(),7);for(e=new Tob(k.e);e.a<e.c.c.length;){d=Wv(Rob(e),12);j=d.d.f;if(b!=j){g=j.d;if(g.k<=f.k){h=f.k+1;if(h==c.c.c.length){i=new sY(c);i.k=h;vU(c.c,i);rX(j,i)}else{i=Wv(yU(c.c,h),16);rX(j,i)}p8(a,j,c)}}}}}
function SO(a){var b,c,d,e,f;b=a.e.j;for(d=new Tob(AW(a));d.a<d.c.c.length;){c=Wv(Rob(d),161);e=Wv(oW(c,(eM(),LL)),15);!e&&(e=new llb(0));f=new II(c.e.i);switch(Wv(c.e,7).g.e){case 4:f.a=-c.e.j.a-e.a;break;case 2:f.a=b.a+e.a;break;case 1:f.b=-c.e.j.b-e.a;break;case 3:f.b=b.b+e.a;}c.e.i.a=f.a;c.e.i.b=f.b}}
function PZ(a){var b,c,d;d=Wv(rJ(a,(eM(),JL)),18);if(d.V()){return}c=(b=Wv(Hkb(Gz),11),new atb(b,Wv(exb(b,b.length),11),0));d.kb((oM(),jM))?Wsb(c,jM):Wsb(c,kM);d.kb(hM)||Wsb(c,hM);d.kb(gM)?Wsb(c,nM):d.kb(fM)?Wsb(c,mM):d.kb(iM)&&Wsb(c,lM);d.kb(nM)?Wsb(c,gM):d.kb(mM)?Wsb(c,fM):d.kb(lM)&&Wsb(c,iM);sJ(a,JL,c)}
function afb(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o;m=Zeb(a,c);for(i=0;i<b;i++){e.J(c);n=new GU;o=Wv(d.H(),92);for(k=m+i;k<a.c;k++){h=o;o=Wv(d.H(),92);vU(n,new tfb(h,o,c))}for(l=m+i;l<a.c;l++){d.M();l>m+i&&d.I()}for(g=new Tob(n);g.a<g.c.c.length;){f=Wv(Rob(g),92);d.J(f)}if(i<b-1){for(j=m+i;j<a.c;j++){d.M()}}}}
function CW(a){var b,c,d,e;if(a.d&&Wv(a.e,7).f.g==(CX(),BX)){return ypb(),ypb(),vpb}else if(!a.a){a.a=new GU;for(d=new Tob(Wv(a.e,7).b);d.a<d.c.c.length;){b=Wv(Rob(d),12);vU(a.a,new tW(b))}if(a.d){e=Wv(rJ(Wv(a.e,7),(Rib(),Bib)),9);if(e){for(c=Uh(iX(e));Cm(c);){b=Wv(Dm(c),12);vU(a.a,new tW(b))}}}}return a.a}
function EW(a){var b,c,d,e;if(a.d&&Wv(a.e,7).f.g==(CX(),BX)){return ypb(),ypb(),vpb}else if(!a.c){a.c=new GU;for(d=new Tob(Wv(a.e,7).e);d.a<d.c.c.length;){b=Wv(Rob(d),12);vU(a.c,new tW(b))}if(a.d){e=Wv(rJ(Wv(a.e,7),(Rib(),Bib)),9);if(e){for(c=Uh(mX(e));Cm(c);){b=Wv(Dm(c),12);vU(a.c,new tW(b))}}}}return a.c}
function N1(a,b){var c,d,e,f,g,h,i,j;h=Wv(rJ(a,(Rib(),uib)),7);i=MI(Bv(tv(qz,1),Fzb,10,0,[h.f.i,h.i,h.a])).a;j=a.f.i.b;c=Wv(FU(a.b,xv(dB,gAb,12,a.b.c.length,0,1)),47);for(e=0,f=c.length;e<f;++e){d=c[e];eW(d,h);SI(d.a,new HI(i,j));if(b){g=Wv(rJ(d,(eM(),CL)),44);if(!g){g=new jJ;sJ(d,CL,g)}QI(g,new HI(i,j))}}}
function O1(a,b){var c,d,e,f,g,h,i,j;e=Wv(rJ(a,(Rib(),uib)),7);i=MI(Bv(tv(qz,1),Fzb,10,0,[e.f.i,e.i,e.a])).a;j=a.f.i.b;c=Wv(FU(a.e,xv(dB,gAb,12,a.e.c.length,0,1)),47);for(g=0,h=c.length;g<h;++g){f=c[g];dW(f,e);RI(f.a,new HI(i,j));if(b){d=Wv(rJ(f,(eM(),CL)),44);if(!d){d=new jJ;sJ(f,CL,d)}QI(d,new HI(i,j))}}}
function X2(a){var b,c,d,e,f,g,h,i,j;g=rAb;i=rAb;h=null;for(c=new Sub(new Lub(a.e));c.b!=c.c.a.b;){b=Rub(c);if(gw(b.d)===gw((Ieb(),keb))||gw(b.d)===gw(leb)){d=Wv(b.e,116).a;j=Wv(b.e,116).b;e=g-d>uAb;f=d-g<uAb&&i-j>uAb;if(e||f){i=Wv(b.e,116).b;g=Wv(b.e,116).a;h=Wv(b.d,60);if(i==0&&g==0){return h}}}}return h}
function P4(a,b){var c,d,e,f,g;a.d=b;Ymb(a.b);a.c=false;h:for(d=new Tob(a.d.c);d.a<d.c.c.length;){c=Wv(Rob(d),16);for(f=new Tob(c.a);f.a<f.c.c.length;){e=Wv(Rob(f),9);if(!sl(gX(e))){a.c=true;break h}}}g=Vsb((sK(),qK),Bv(tv(Bz,1),uyb,59,0,[oK,pK]));if(!a.c){Wsb(g,rK);Wsb(g,nK)}a.a=new NR(g);O4(a);return a.a}
function $2(){var a,b,c,d,e;this.e=(mp(),new wub);this.b=(c=Wv(Hkb(_E),11),new atb(c,Wv(exb(c,c.length),11),0));this.c=(d=Wv(Hkb(_E),11),new atb(d,Wv(exb(d,d.length),11),0));this.a=(e=Wv(Hkb(_E),11),new atb(e,Wv(exb(e,e.length),11),0));for(b=(Ieb(),Ieb(),feb).mb();b.G();){a=Wv(b.H(),60);tub(this.e,a,new _2)}}
function gdb(a,b,c){var d,e,f,g,h,i;if(Jlb(a.k-a.a)<dAb||Jlb(b.k-b.a)<dAb){return}d=edb(a.n,b.j,c);e=edb(b.n,a.j,c);f=fdb(a.n,b.k,b.a)+fdb(b.j,a.k,a.a);g=fdb(b.n,a.k,a.a)+fdb(a.j,b.k,b.a);h=16*d+f;i=16*e+g;if(h<i){new kdb(a,b,i-h)}else if(h>i){new kdb(b,a,h-i)}else if(h>0&&i>0){new kdb(a,b,0);new kdb(b,a,0)}}
function c3(a,b){var c,d,e,f,g,h,i,j,k;j=new GU;k=null;for(d=Wv(qsb(a3,a),20).mb();d.G();){c=Wv(d.H(),75);for(i=(f=(new Snb(c.c.a)).a.bb().mb(),new Ynb(f));i.a.G();){g=(e=Wv(i.a.H(),21),Wv(e.yb(),7));Anb(b,g);J2(g,a.b)}xU(j,c.b);k=a.a}Dpb(j);K2(j,k);for(h=new Tob(j);h.a<h.c.c.length;){g=Wv(Rob(h),7);Anb(b,g)}}
function GP(){var b={'layout':function(a){Rxb(IP(a))}};if(typeof klayregister===Zxb){klayregister(b)}else{typeof document!==Czb&&($wnd.$klay=b);typeof module===Sxb&&module.exports&&(module.exports=b);typeof document===Czb&&typeof self!==Czb&&self.addEventListener('message',function(a){b.layout(a.data)},false)}}
function _cb(a,b,c,d,e){var f,g,h;h=e?d.b:d.a;if(h>c.k&&h<c.a||c.j.b!=0&&c.n.b!=0&&(Jlb(h-Ixb(Yv(UI(c.j))))<dAb&&Jlb(h-Ixb(Yv(UI(c.n))))<dAb||Jlb(h-Ixb(Yv(VI(c.j))))<dAb&&Jlb(h-Ixb(Yv(VI(c.n))))<dAb)){if(!ttb(a.b,d)){g=Wv(rJ(b,(eM(),CL)),44);if(!g){g=new jJ;sJ(b,CL,g)}f=new II(d);TI(g,f,g.c.b,g.c);stb(a.b,f)}}}
function lU(a,b,c){var d,e,f,g,h,i,j,k,l;d=c.c;e=c.d;h=MX(b.c);i=MX(b.d);if(d==b.c){h=mU(a,h,e);i=nU(b.d)}else{h=nU(b.c);i=mU(a,i,e)}j=new kJ(b.a);TI(j,h,j.a,j.a.a);TI(j,i,j.c.b,j.c);g=b.c==d;l=new pV;for(f=0;f<j.b-1;++f){k=new RJ(Wv(tn(j,f),10),Wv(tn(j,f+1),10));g&&f==0||!g&&f==j.b-2?(l.b=k):vU(l.a,k)}return l}
function GW(a,b){var c,d,e,f;f=a.g.e-b.g.e;if(f!=0){return f}c=Wv(rJ(a,(eM(),UL)),24);d=Wv(rJ(b,UL),24);if(!!c&&!!d){e=c.a-d.a;if(e!=0){return e}}switch(a.g.e){case 1:return glb(a.i.a,b.i.a);case 2:return glb(a.i.b,b.i.b);case 3:return glb(b.i.a,a.i.a);case 4:return glb(b.i.b,a.i.b);default:throw new ulb(iAb);}}
function KO(a,b){var c,d,e,f,g;g=new FI;for(f=new Tob(AW(a));f.a<f.c.c.length;){e=Wv(Rob(f),161);switch(Wv(e.e,7).g.e){case 4:case 2:g.b=Nlb(g.b,e.e.i.b+e.e.j.b+(b?(d=Wv(e.e,7).d,new EP(d.d,d.b,d.a,d.c)).a:0));break;case 1:case 3:g.a=Nlb(g.a,e.e.i.a+e.e.j.a+(b?(c=Wv(e.e,7).d,new EP(c.d,c.b,c.a,c.c)).c:0));}}return g}
function d3(a,b){var c,d,e,f,g,h,i;e=new GU;i=new GU;c=Wv(qsb(a3,a),20).mb();while(c.G()){d=Wv(c.H(),75);wU(e,d.b);wU(e,$db(d));if(c.G()){d=Wv(c.H(),75);xU(i,$db(d));xU(i,d.b)}}K2(e,a.b);K2(i,a.a);for(h=new Tob(e);h.a<h.c.c.length;){f=Wv(Rob(h),7);Anb(b,f)}for(g=new Tob(i);g.a<g.c.c.length;){f=Wv(Rob(g),7);Anb(b,f)}}
function ohb(){ohb=iI;fhb=new phb('COMMENTS',0);hhb=new phb('EXTERNAL_PORTS',1);ihb=new phb('HYPEREDGES',2);jhb=new phb('HYPERNODES',3);khb=new phb('NON_FREE_PORTS',4);lhb=new phb('NORTH_SOUTH_PORTS',5);nhb=new phb('SELF_LOOPS',6);ehb=new phb('CENTER_LABELS',7);ghb=new phb('END_LABELS',8);mhb=new phb('PARTITIONS',9)}
function Jxb(a,b){var c,d,e,f;a=(bmb(),a==null?Wxb:a);c=(a.length+16*b.length,new Amb);f=0;d=0;while(d<b.length){e=a.indexOf('%s',f);if(e==-1){break}ymb(c,a.substr(f,e-f));xmb(c,b[d++]);f=e+2}ymb(c,imb(a,f,a.length-f));if(d<b.length){c.a+=' [';xmb(c,b[d++]);while(d<b.length){c.a+=', ';xmb(c,b[d++])}c.a+=']'}return c.a}
function pX(a,b,c){var d,e;e=null;switch(b.e){case 1:e=(LX(),GX);break;case 2:e=(LX(),IX);}d=null;switch(c.e){case 1:d=(LX(),HX);break;case 2:d=(LX(),FX);break;case 3:d=(LX(),JX);break;case 4:d=(LX(),KX);}return !!e&&!!d?pl(a.f,(hc(),new ic(new opb(Bv(tv(tw,1),syb,68,0,[Wv(_b(e),68),Wv(_b(d),68)]))))):(ypb(),ypb(),vpb)}
function vY(a,b,c){var d,e,f,g,h,i,j;i=Eo(mX(b));for(e=WI(i,0);e.b!=e.d.c;){d=Wv(_ub(e),12);j=d.d.f;if(!(Ckb(Ixb(Xv(rJ(j,(Rib(),Vhb)))))&&rJ(j,uib)!=null)&&j.g==(CX(),wX)&&!Ckb(Ixb(Xv(rJ(d,Iib))))&&d.d.g==(sN(),rN)){f=rY(j.d)-rY(b.d);if(f>1){c?(g=rY(b.d)+1):(g=rY(j.d)-1);h=Wv(yU(a.a.c,g),16);rX(j,h)}vY(a,j,c)}}return b}
function Hcb(a,b){var c,d,e,f;b.d?(e=a.a.c==(Gbb(),Fbb)?iX(b.b):mX(b.b)):(e=a.a.c==(Gbb(),Ebb)?iX(b.b):mX(b.b));f=false;for(d=(Il(),new Im(Dl(ul(e.a,new yl))));Cm(d);){c=Wv(Dm(d),12);if(a.c.a[c.c.f.d.k]===a.c.a[c.d.f.d.k]){continue}f=true;if(ttb(a.b,a.a.f[zcb(c,b.b).k])){b.c=true;b.a=c;return b}}b.c=f;b.a=null;return b}
function K4(a,b,c){var d,e,f,g;d=Wv(rJ(a.d,(eM(),pL)),15).a;for(f=new Tob(a.a.b);f.a<f.c.c.length;){e=Wv(Rob(f),25);if(aw(e,93)){g=Wv(e,93).b;if(g.g==(CX(),xX)){switch(Wv(rJ(g,(Rib(),hib)),32).e){case 4:g.i.a=b.a-d;break;case 2:g.i.a=c.a+d-(g.j.a+g.e.c);break;case 1:g.i.b=b.b-d;break;case 3:g.i.b=c.b+d-(g.j.b+g.e.a);}}}}}
function Ztb(){if(!Object.create||!Object.getOwnPropertyNames){return false}var a='__proto__';var b=Object.create(null);if(b[a]!==undefined){return false}var c=Object.getOwnPropertyNames(b);if(c.length!=0){return false}b[a]=42;if(b[a]!==42){return false}if(Object.getOwnPropertyNames(b).length==0){return false}return true}
function eS(a){var b,c,d,e,f,g,h,i,j;for(g=new Tob(a.a.a);g.a<g.c.c.length;){e=Wv(Rob(g),78);e.f=0;e.e.a.Q()}for(f=new Tob(a.a.a);f.a<f.c.c.length;){e=Wv(Rob(f),78);for(c=(j=(new Snb(e.a.a)).a.bb().mb(),new Ynb(j));c.a.G();){b=(d=Wv(c.a.H(),21),Wv(d.yb(),25));for(i=b.i.mb();i.G();){h=Wv(i.H(),25);if(h.f!=e){stb(e.e,h);++h.f.f}}}}}
function bcb(a,b,c,d){var e,f,g,h;if(b.g==(CX(),wX)){for(f=Uh(iX(b));Cm(f);){e=Wv(Dm(f),12);g=e.c.f;if((g.g==wX||Ckb(Ixb(Xv(rJ(g,(Rib(),Vhb))))))&&a.d.a[e.c.f.d.k]==d&&a.d.a[b.d.k]==c){return true}}}if(b.g==zX){for(f=Uh(iX(b));Cm(f);){e=Wv(Dm(f),12);h=e.c.f.g;if(h==zX&&a.d.a[e.c.f.d.k]==d&&a.d.a[b.d.k]==c){return true}}}return false}
function cfb(a){var b,c,d,e,f,g;e=a.g.tb();d=a.b.tb();if(a.e){for(c=0;c<a.c;c++){e.H()}}else{for(c=0;c<a.c-1;c++){e.H();e.I()}}b=Ixb(Yv(e.H()));while(a.i-b>RAb){f=b;g=0;while((b-f<=0?0-(b-f):b-f)<RAb){++g;b=Ixb(Yv(e.H()));d.H()}if(g<a.c){e.M();afb(a,a.c-g,f,d,e);e.H()}d.M()}if(!a.e){for(c=0;c<a.c-1;c++){e.H();e.I()}}a.e=true;a.d=true}
function O2(a){var b,c,d,e;switch(V2(a.a).c){case 4:return Ieb(),oeb;case 3:return Wv(S2(a.a).mb().H(),60);case 2:d=V2(a.a);c=new jtb(d);b=Wv(itb(c),60);e=Wv(itb(c),60);return Meb(b)==e?Zsb(d,(Ieb(),oeb))?ieb:oeb:Leb(Leb(b))==e?Leb(b):Neb(b);case 1:d=V2(a.a);return Meb(Wv(itb(new jtb(d)),60));case 0:return Ieb(),peb;default:return null;}}
function Q3(a,b){var c;oR.call(this);this.a=Wv(rJ(b,(Rib(),Jib)),15).a;this.c=this.a*Wv(rJ(b,(Mjb(),Ejb)),15).a;this.b=a;this.j=new VN(a.i.a-a.e.b,a.i.b-a.e.d,a.j.a+a.e.b+a.e.c,a.j.b+a.e.d+a.e.a);BI(this.g);c=tl(iX(a))-tl(mX(a));c<0?vS(this.n,true,(sK(),oK)):c>0&&vS(this.n,true,(sK(),pK));a.g==(CX(),xX)&&wS(this.n,false,false,false,false)}
function UT(a,b,c){var d,e,f,g,h,i,j,k,l,m;f=new HI(b,c);for(k=new Tob(a.b);k.a<k.c.c.length;){j=Wv(Rob(k),9);vI(j.i,f);for(m=new Tob(j.f);m.a<m.c.c.length;){l=Wv(Rob(m),7);for(e=new Tob(l.e);e.a<e.c.c.length;){d=Wv(Rob(e),12);hJ(d.a,f);g=Wv(rJ(d,(eM(),CL)),44);!!g&&hJ(g,f);for(i=new Tob(d.b);i.a<i.c.c.length;){h=Wv(Rob(i),33);vI(h.i,f)}}}}}
function TW(a,b,c){var d,e,f,g,h,i,j,k,l,m;f=new HI(b,c);for(k=new Tob(a.b);k.a<k.c.c.length;){j=Wv(Rob(k),9);vI(j.i,f);for(m=new Tob(j.f);m.a<m.c.c.length;){l=Wv(Rob(m),7);for(e=new Tob(l.e);e.a<e.c.c.length;){d=Wv(Rob(e),12);hJ(d.a,f);g=Wv(rJ(d,(eM(),CL)),44);!!g&&hJ(g,f);for(i=new Tob(d.b);i.a<i.c.c.length;){h=Wv(Rob(i),33);vI(h.i,f)}}}}}
function X0(a,b){var c,d,e,f,g;for(g=new Tob(a.f);g.a<g.c.c.length;){f=Wv(Rob(g),7);if(b){if(f.b.c.length!=0){throw new $J((e=lX(a),nAb+(e==null?Dlb(a.k):e)+oAb+pAb+qAb))}}else{for(d=new Tob(f.b);d.a<d.c.c.length;){c=Wv(Rob(d),12);if(gw(rJ(c.c.f,(Mjb(),vjb)))!==gw((Xib(),Tib))){throw new $J((e=lX(a),nAb+(e==null?Dlb(a.k):e)+oAb+pAb+qAb))}}}}}
function y6(a,b,c){var d,e,f,g,h,i,j;d=0;j=nX(b,c);for(i=j.mb();i.G();){h=Wv(i.H(),7);if(Wv(rJ(h,(Rib(),Bib)),9)){g=Wv(rJ(h,Bib),9);nX(g,(sN(),ZM)).mb().G()&&(d+=(f=a.k?1:NX(Wv(yU(g.f,0),7)),f*Slb(w6(a,b,c).a-1-Wv(Smb(a.i,h),24).a,B6(a,b,g))));nX(g,rN).mb().G()&&(d+=(e=a.k?1:NX(Wv(yU(g.f,0),7)),e*Slb(Wv(Smb(a.i,h),24).a,B6(a,b,g))))}}return d}
function J7(a,b){var c,d,e,f,g,h,i;e=xv(mw,Yyb,26,a.e.a.c.length,12,1);for(g=new Tob(a.e.a);g.a<g.c.c.length;){f=Wv(Rob(g),61);e[f.b]+=f.c.c.length}h=Eo(b);while(h.b!=0){f=Wv(h.b==0?null:(Bxb(h.b!=0),$I(h,h.a.a)),61);for(d=new Tob(f.g);d.a<d.c.c.length;){c=Wv(Rob(d),89);i=c.d;i.e=Plb(i.e,f.e+c.a);--e[i.b];e[i.b]==0&&(TI(h,i,h.c.b,h.c),true)}}}
function nP(a,b,c,d,e,f,g){a.d=d.e.i.a;a.e=d.e.i.b;if(e){a.d+=e.e.i.a;a.e+=e.e.i.b}a.c=b.e.j.a;a.b=b.e.j.b;if(!e){c?(a.d-=g+b.e.j.a):(a.d+=d.e.j.a+g)}else{switch(Wv(e.e,7).g.e){case 0:case 2:a.d+=e.e.j.a+g+f.a+g;break;case 4:a.d-=g+f.a+g+b.e.j.a;break;case 1:a.d+=e.e.j.a+g;a.e-=g+f.b+g+b.e.j.b;break;case 3:a.d+=e.e.j.a+g;a.e+=e.e.j.b+g+f.b+g;}}}
function V9(a,b){var c,d,e,f,g,h,i,j,k;e=new GU;for(i=new Tob(b);i.a<i.c.c.length;){f=Wv(Rob(i),9);vU(e,a.b[f.d.k][f.k])}S9(a,e);while(k=T9(e)){U9(a,Wv(k.a,102),Wv(k.b,102),e)}b.c=xv(UF,syb,1,0,4,1);for(d=new Tob(e);d.a<d.c.c.length;){c=Wv(Rob(d),102);for(g=c.d,h=0,j=g.length;h<j;++h){f=g[h];b.c[b.c.length]=f;a.a[f.d.k][f.k].a=W9(c.g,c.d[0]).a}}}
function lS(a){var b,c,d,e,f,g,h;h=(mp(),new ntb);for(d=new Tob(a.a.b);d.a<d.c.c.length;){b=Wv(Rob(d),25);Umb(h,b,new GU)}for(e=new Tob(a.a.b);e.a<e.c.c.length;){b=Wv(Rob(e),25);b.r=Vzb;for(g=b.i.mb();g.G();){f=Wv(g.H(),25);Wv(re(Ktb(h.d,f)),20).ib(b)}}for(c=new Tob(a.a.b);c.a<c.c.c.length;){b=Wv(Rob(c),25);b.i.Q();b.i=Wv(re(Ktb(h.d,b)),20)}eS(a)}
function kU(a){var b,c,d,e,f;e=Wv(yU(a.b,0),9);b=new uX(a);vU(a.b,b);b.j.a=Nlb(1,e.j.a);b.j.b=Nlb(1,e.j.b);b.i.a=e.i.a;b.i.b=e.i.b;switch(Wv(rJ(e,(Rib(),hib)),32).e){case 4:b.i.a+=2;break;case 1:b.i.b+=2;break;case 2:b.i.a-=2;break;case 3:b.i.b-=2;}d=new RX;PX(d,b);c=new hW;f=Wv(yU(e.f,0),7);dW(c,f);eW(c,d);vI(BI(d.i),f.i);vI(BI(d.a),f.a);return b}
function T8(a){var b,c,d,e,f,g,h,i,j;j=(mp(),new ntb);b=0;c=new l7;for(h=a.mb();h.G();){f=Wv(h.H(),9);i=x7(z7(y7(new A7,b++),f),c);Ltb(j.d,f,i)}for(g=a.mb();g.G();){f=Wv(g.H(),9);for(e=Uh(mX(f));Cm(e);){d=Wv(Dm(e),12);if(bW(d)){continue}f7(i7(h7(g7(j7(new k7,Plb(1,Wv(rJ(d,(Rib(),Eib)),24).a)),1),Wv(Smb(j,d.c.f),61)),Wv(Smb(j,d.d.f),61)))}}return c}
function E2(a){var b,c;if(a.V()){return}c=Wv(a.sb(0),75).f;new g3(a);b=new Fnb(c.f,0);e3((Ieb(),neb),b);f3(Eeb,b);D2((sN(),$M),b);d3(meb,b);f3(qeb,b);c3(jeb,b);e3(keb,b);D2(ZM,b);d3(ieb,b);e3(leb,b);c3(peb,b);e3(qeb,b);D2(pN,b);d3(oeb,b);e3(Eeb,b);c3(Heb,b);f3(leb,b);while(b.b<b.d.Y()){Bxb(b.b<b.d.Y());b.d.sb(b.c=b.b++)}d3(Geb,b);f3(keb,b);f3(neb,b)}
function F2(a){var b,c;if(a.V()){return}c=Wv(a.sb(0),75).f;new g3(a);b=new Fnb(c.f,0);e3((Ieb(),neb),b);f3(Eeb,b);D2((sN(),$M),b);c3(meb,b);f3(qeb,b);c3(jeb,b);e3(keb,b);D2(ZM,b);c3(ieb,b);e3(leb,b);c3(peb,b);e3(qeb,b);D2(pN,b);c3(oeb,b);e3(Eeb,b);c3(Heb,b);f3(leb,b);while(b.b<b.d.Y()){Bxb(b.b<b.d.Y());b.d.sb(b.c=b.b++)}c3(Geb,b);f3(keb,b);f3(neb,b)}
function N7(a){var b,c,d,e,f,g,h,i,j;e=eyb;g=$xb;for(j=new Tob(a.e.a);j.a<j.c.c.length;){h=Wv(Rob(j),61);g=Slb(g,h.e);e=Plb(e,h.e)}f=0;d=xv(mw,Yyb,26,e-g+1,12,1);for(i=new Tob(a.e.a);i.a<i.c.c.length;){h=Wv(Rob(i),61);h.e-=g;++d[h.e]}if(a.k){for(c=new Tob(a.k.c);c.a<c.c.c.length;){b=Wv(Rob(c),16);d[f++]+=b.a.c.length;if(d.length==f){break}}}return d}
function L4(a){var b,c,d,e;M4(a);J4(a);e=new HI(Uzb,Uzb);b=new HI(Vzb,Vzb);for(d=new Tob(a.a.b);d.a<d.c.c.length;){c=Wv(Rob(d),25);e.a=Qlb(e.a,c.j.d);e.b=Qlb(e.b,c.j.e);b.a=Nlb(b.a,c.j.d+c.j.c);b.b=Nlb(b.b,c.j.e+c.j.b)}vI(BI(a.d.d),zI(new HI(e.a,e.b)));vI(BI(a.d.e),EI(new HI(b.a,b.b),e));K4(a,e,b);a.a.a.c=xv(UF,syb,1,0,4,1);a.a.b.c=xv(UF,syb,1,0,4,1)}
function j1(a,b){var c,d,e,f,g,h,i,j,k,l;g=a.e;k=Wv(rJ(a,(Rib(),Qib)),20);l=0;if(k){i=0;for(f=k.mb();f.G();){e=Wv(f.H(),9);i=Nlb(i,e.j.b);l+=e.j.a}l+=b/2*(k.Y()-1);g.d+=i+b}c=Wv(rJ(a,Yhb),20);d=0;if(c){i=0;for(f=c.mb();f.G();){e=Wv(f.H(),9);i=Nlb(i,e.j.b);d+=e.j.a}d+=b/2*(c.Y()-1);g.a+=i+b}h=l>d?l:d;if(h>a.j.a){j=(h-a.j.a)/2;g.b=Nlb(g.b,j);g.c=Nlb(g.c,j)}}
function ST(a,b,c,d){var e,f,g,h,i,j,k,l,m,n;g=uI(b.d,c,d);for(l=new Tob(b.b);l.a<l.c.c.length;){k=Wv(Rob(l),9);vI(k.i,g);for(n=new Tob(k.f);n.a<n.c.c.length;){m=Wv(Rob(n),7);for(f=new Tob(m.e);f.a<f.c.c.length;){e=Wv(Rob(f),12);hJ(e.a,g);h=Wv(rJ(e,(eM(),CL)),44);!!h&&hJ(h,g);for(j=new Tob(e.b);j.a<j.c.c.length;){i=Wv(Rob(j),33);vI(i.i,g)}}}vU(a.b,k);k.a=a}}
function Q8(a,b){var c,d,e,f,g;a.c==null||a.c.length<b.c.length?(a.c=xv(KH,xAb,26,b.c.length,13,1)):dpb(a.c);a.a=new GU;d=0;for(g=new Tob(b);g.a<g.c.c.length;){e=Wv(Rob(g),9);e.k=d++}c=new aJ;for(f=new Tob(b);f.a<f.c.c.length;){e=Wv(Rob(f),9);if(!a.c[e.k]){R8(a,e);c.b==0||(Bxb(c.b!=0),Wv(c.a.a.c,20)).Y()<a.a.c.length?RI(c,a.a):SI(c,a.a);a.a=new GU}}return c}
function xfb(a,b,c){var d,e,f,g,h,i,j,k,l;d=sgb(a.g);j=vI(xI(a.i),a.a);k=vI(xI(b.i),b.a);e=vI(new II(j),CI(new GI(d),c));l=vI(new II(k),CI(new GI(d),c));g=CI(EI(new II(e),l),0.5);i=vI(vI(new II(l),g),CI(new GI(d),Tlb(g.a*g.a+g.b*g.b)));h=new ufb(Bv(tv(qz,1),Fzb,10,0,[j,e,i,l,k]));f=$eb(h,0.5,false);h.a=f;bfb(h,new Ffb(Bv(tv(qz,1),Fzb,10,0,[f,j,k])));return h}
function F7(a,b){var c,d,e,f,g;nI(b,'Network simplex',1);if(a.e.a.c.length<1){pI(b);return}for(f=new Tob(a.e.a);f.a<f.c.c.length;){e=Wv(Rob(f),61);e.e=0}g=a.e.a.c.length>=40;g&&Q7(a);H7(a);G7(a);c=K7(a);d=0;while(!!c&&d<a.f){E7(a,c,D7(a,c));c=K7(a);++d}g&&P7(a);a.a?B7(a,N7(a)):N7(a);a.b=null;a.d=null;a.p=null;a.c=null;a.g=null;a.i=null;a.n=null;a.o=null;pI(b)}
function uQ(a){var b,c,d,e,f,g,h,i,j,k;j=new vtb;e=(mp(),new ntb);for(h=0,i=a.length;h<i;++h){g=a[h];b=g.mc();j.a.db(b,j);b==null?Ltb(e.d,null,g):dub(e.e,b,g);k=gmb(b,(bmb(),b.lastIndexOf('.'))+1,b.length);if(!ttb(sQ,k)){j.a.db(k,j);k==null?Ltb(e.d,null,g):dub(e.e,k,g);stb(sQ,k)}}d=(hi(),Yj((f=(new Snb(j.a)).a.bb().mb(),new Ynb(f))));c=tj(e);return new RJ(d,c)}
function E7(a,b,c){var d,e,f;if(!b.e){throw new slb('Given leave edge is no tree edge.')}if(c.e){throw new slb('Given enter edge is a tree edge already.')}b.e=false;utb(a.p,b);c.e=true;stb(a.p,c);d=c.d.e-c.c.e-c.a;I7(a,c.d,b)||(d=-d);for(f=new Tob(a.e.a);f.a<f.c.c.length;){e=Wv(Rob(f),61);I7(a,e,b)||(e.e+=d)}a.j=1;dpb(a.c);O7(a,Wv(Rob(new Tob(a.e.a)),61));C7(a)}
function dU(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;if(a.V()){return new FI}j=0;l=0;for(e=a.mb();e.G();){d=Wv(e.H(),55);f=d.e;j=Nlb(j,f.a);l+=f.a*f.b}j=Nlb(j,Math.sqrt(l)*Wv(rJ(Wv(a.mb().H(),55),(Rib(),Rhb)),15).a);m=0;n=0;i=0;c=b;for(h=a.mb();h.G();){g=Wv(h.H(),55);k=g.e;if(m+k.a>j){m=0;n+=i+b;i=0}UT(g,m,n);c=Nlb(c,m+k.a);i=Nlb(i,k.b);m+=k.a+b}return new HI(c+b,n+i+b)}
function Nm(a,b,c,d){var e,f,g;g=new Sn(b,c);if(!a.a){a.a=a.e=g;Umb(a.b,b,new Rn(g));++a.c}else if(!d){a.e.b=g;g.d=a.e;a.e=g;e=Wv(Smb(a.b,b),126);if(!e){Umb(a.b,b,new Rn(g));++a.c}else{++e.a;f=e.c;f.c=g;g.e=f;e.c=g}}else{e=Wv(Smb(a.b,b),126);++e.a;g.d=d.d;g.e=d.e;g.b=d;g.c=d;!d.e?(Wv(Smb(a.b,b),126).b=g):(d.e.c=g);!d.d?(a.a=g):(d.d.b=g);d.d=g;d.e=g}++a.d;return g}
function hS(a){var b,c,d,e,f,g,h,i;if(a.e){throw new ulb((Gkb(nA),'The '+nA.j+Yzb))}a.d==(sK(),qK)&&gS(a,oK);for(c=new Tob(a.a.a);c.a<c.c.c.length;){b=Wv(Rob(c),78);b.f=0}for(g=new Tob(a.a.b);g.a<g.c.c.length;){f=Wv(Rob(g),25);f.r=Vzb;for(e=f.i.mb();e.G();){d=Wv(e.H(),25);++d.f.f}}a.b.Cc(a);for(i=new Tob(a.a.b);i.a<i.c.c.length;){h=Wv(Rob(i),25);h.p=true}return a}
function V1(a,b,c,d,e){var f,g,h,i;f=new uX(a);sX(f,(CX(),BX));sJ(f,(eM(),TL),(KM(),FM));sJ(f,(Rib(),uib),b.c.f);g=new RX;sJ(g,uib,b.c);QX(g,e);PX(g,f);sJ(b.c,Bib,f);h=new uX(a);sX(h,BX);sJ(h,TL,FM);sJ(h,uib,b.d.f);i=new RX;sJ(i,uib,b.d);QX(i,e);PX(i,h);sJ(b.d,Bib,h);dW(b,g);eW(b,i);Fxb(0,c.c.length);fxb(c.c,0,f);d.c[d.c.length]=h;sJ(f,aib,Elb(1));sJ(h,aib,Elb(1))}
function j2(a,b){var c,d,e,f,g;g=Wv(rJ(a.f,(eM(),TL)),28);f=a.g.e-b.g.e;if(f!=0||g==(KM(),HM)){return f}if(g==(KM(),EM)){c=Wv(rJ(a,UL),24);d=Wv(rJ(b,UL),24);if(!!c&&!!d){e=c.a-d.a;if(e!=0){return e}}}switch(a.g.e){case 1:return glb(a.i.a,b.i.a);case 2:return glb(a.i.b,b.i.b);case 3:return glb(b.i.a,a.i.a);case 4:return glb(b.i.b,a.i.b);default:throw new ulb(iAb);}}
function hfb(a){var b,c,d,e,f,g,h,i,j,k,l;h=new GU;f=Ixb(Yv(a.g.sb(a.g.Y()-1)));for(l=a.g.mb();l.G();){k=Yv(l.H());uU(h,0,f-(Dxb(k),k))}g=lJ(Xeb(a));j=new GU;e=new Tob(h);i=new GU;for(b=0;b<a.c-1;b++){vU(j,Yv(Rob(e)))}for(d=WI(g,0);d.b!=d.d.c;){c=Wv(_ub(d),10);vU(j,Yv(Rob(e)));vU(i,new sfb(c,j));Cxb(0,j.c.length);j.c.splice(0,1)}return new ffb(a.e,a.f,a.d,a.c,h,i)}
function zs(a,b,c,d,e){var f,g,h,i,j;f=b.$b(c,a.b);if(f<0){h=a.e;if(!h){e[0]=0;return As(a,c,d)}g=h.d;a.e=zs(h,b,c,d,e);e[0]==0&&++a.a;a.j=PH(a.j,d);return a.e.d==g?a:Gs(a)}else if(f>0){i=a.g;if(!i){e[0]=0;return Bs(a,c,d)}g=i.d;a.g=zs(i,b,c,d,e);e[0]==0&&++a.a;a.j=PH(a.j,d);return a.g.d==g?a:Gs(a)}e[0]=a.c;j=PH(a.c,d);Xb(RH(j,$xb)<=0);a.c+=d;a.j=PH(a.j,d);return a}
function iJ(b,c){var d,e,f,g,h,i;f=fmb(c,',|;|\\(|\\)|\\[|\\]|\\{|\\}| |\t|\n');_I(b);try{e=0;h=0;g=0;i=0;while(e<f.length){if(f[e]!=null&&pmb(hmb(f[e]))>0){h%2==0?(g=clb(f[e])):(i=clb(f[e]));h>0&&h%2!=0&&QI(b,new HI(g,i));++h}++e}}catch(a){a=OH(a);if(aw(a,130)){d=a;throw new slb('The given string does not match the expected format for vectors.'+d)}else throw NH(a)}}
function _bb(a,b,c){var d,e,f,g,h,i,j,k;e=true;for(g=new Tob(b.c);g.a<g.c.c.length;){f=Wv(Rob(g),16);j=Vzb;for(i=new Tob(f.a);i.a<i.c.c.length;){h=Wv(Rob(i),9);k=Ixb(c.n[h.k])+Ixb(c.d[h.k])-h.e.d;d=Ixb(c.n[h.k])+Ixb(c.d[h.k])+h.j.b+h.e.a;if(k>j&&d>j){j=Ixb(c.n[h.k])+Ixb(c.d[h.k])+h.j.b+h.e.a}else{e=false;a.a&&(Fmb(),Emb);break}}if(!e){break}}a.a&&(Fmb(),Emb);return e}
function Jv(a){var b,c,d,e,f,g,h,i;if(isNaN(a)){return Rv(),Qv}if(a<-9223372036854775808){return Rv(),Pv}if(a>=9223372036854775807){return Rv(),Ov}e=false;if(a<0){e=true;a=-a}d=0;if(a>=dzb){d=hw(a/dzb);a-=d*dzb}c=0;if(a>=czb){c=hw(a/czb);a-=c*czb}b=hw(a);f=Ev(b,c,d);e&&(g=~f.l+1&azb,h=~f.m+(g==0?1:0)&azb,i=~f.h+(g==0&&h==0?1:0)&bzb,f.l=g,f.m=h,f.h=i,undefined);return f}
function JO(a){var b,c,d,e,f,g,h;e=DW(a);if(Qob(new Tob(e))){h=new VN(0,0,a.e.j.a,a.e.j.b);for(c=new Tob(e);c.a<c.c.c.length;){b=Wv(Rob(c),129);d=new VN(b.e.i.a,b.e.i.b,b.e.j.a,b.e.j.b);TN(h,d)}g=new FP((f=Wv(a.e,7).d,new EP(f.d,f.b,f.a,f.c)));g.d=-h.e;g.a=h.e+h.b-a.e.j.b;g.b=-h.d;g.c=h.d+h.c-a.e.j.a;Wv(a.e,7).d.b=g.b;Wv(a.e,7).d.d=g.d;Wv(a.e,7).d.c=g.c;Wv(a.e,7).d.a=g.a}}
function Y0(a){var b,c,d,e,f;for(f=new Tob(a.f);f.a<f.c.c.length;){e=Wv(Rob(f),7);for(d=new Tob(e.e);d.a<d.c.c.length;){c=Wv(Rob(d),12);if(gw(rJ(c.d.f,(Mjb(),vjb)))!==gw((Xib(),Vib))){throw new $J((b=lX(a),nAb+(b==null?Dlb(a.k):b)+"' has its layer constraint set to LAST or LAST_SEPARATE, but has "+'at least one outgoing edge. Connections between nodes with these '+qAb))}}}}
function Rfb(a,b,c,d){var e,f,g,h,i,j;for(f=new Tob(a);f.a<f.c.c.length;){e=Wv(Rob(f),12);g=e.c;if(b.a.R(g)){h=(fgb(),dgb)}else if(c.a.R(g)){h=(fgb(),egb)}else{throw new slb('Source port must be in one of the port sets.')}i=e.d;if(b.a.R(i)){j=(fgb(),dgb)}else if(c.a.R(i)){j=(fgb(),egb)}else{throw new slb('Target port must be in one of the port sets.')}vU(d,new lgb(e,h,j))}}
function bQ(a,b){var c,d,e,f,g,h;if('edges' in b.a){h=Pu(b,'edges');if(!h.hc()){throw new GQ("The 'edges' property of a node has to be an array.",h,b)}f=h.hc();for(g=0;g<f.a.length;++g){e=gu(f,g);if(!e.kc()){throw new GQ("All elements of the 'edges' property must be objects.",e,b)}aQ(a,e.kc())}}if(Mzb in b.a){d=Pu(b,Mzb).hc();for(g=0;g<d.a.length;++g){c=gu(d,g).kc();bQ(a,c)}}}
function fS(a){var b,c,d,e,f,g,h,i;for(d=new Tob(a.a.a);d.a<d.c.c.length;){c=Wv(Rob(d),78);c.g=null;for(g=(i=(new Snb(c.a.a)).a.bb().mb(),new Ynb(i));g.a.G();){e=(b=Wv(g.a.H(),21),Wv(b.yb(),25));BI(e.g);(!c.g||e.j.d<c.g.j.d)&&(c.g=e)}for(f=(h=(new Snb(c.a.a)).a.bb().mb(),new Ynb(h));f.a.G();){e=(b=Wv(f.a.H(),21),Wv(b.yb(),25));e.g.a=e.j.d-c.g.j.d;e.g.b=e.j.e-c.g.j.e}}return a}
function Nab(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;c=false;n=$yb*a.b.f*a.b.d;for(e=new Tob(b.c);e.a<e.c.c.length;){d=Wv(Rob(e),16);j=new Tob(d.a);f=Wv(Rob(j),9);k=Uab(a.a[f.k]);while(j.a<j.c.c.length){h=Wv(Rob(j),9);l=Uab(a.a[h.k]);if(k!=l){m=Xjb(a.b,f,h);g=f.i.b+f.j.b+f.e.a+k.a+m;i=h.i.b-h.e.d+l.a;if(g>i+n){o=k.i+l.i;l.a=(l.i*l.a+k.i*k.a)/o;l.i=o;k.g=l;c=true}}f=h;k=l}}return c}
function XY(a){var b,c,d,e,f,g;if(gw(rJ(a,(eM(),TL)))===gw((KM(),GM))||gw(rJ(a,TL))===gw(FM)){for(g=new Tob(a.f);g.a<g.c.c.length;){f=Wv(Rob(g),7);if(f.g==(sN(),$M)||f.g==pN){return false}}}if(MM(Wv(rJ(a,TL),28))){for(e=nX(a,(sN(),ZM)).mb();e.G();){d=Wv(e.H(),7);if(d.b.c.length!=0){return false}}}for(c=Uh(mX(a));Cm(c);){b=Wv(Dm(c),12);if(b.c.f==b.d.f){return false}}return true}
function KW(a,b){var c,d,e,f,g,h,i,j,k;e=a.f;g=e.j.a;f=e.j.b;if(g<=0&&f<=0){return sN(),qN}j=a.i.a;k=a.i.b;h=a.j.a;c=a.j.b;switch(b.e){case 2:case 1:if(j<0){return sN(),rN}else if(j+h>g){return sN(),ZM}break;case 4:case 3:if(k<0){return sN(),$M}else if(k+c>f){return sN(),pN}}i=(j+h/2)/g;d=(k+c/2)/f;return i+d<=1&&i-d<=0?(sN(),rN):i+d>=1&&i-d>=0?(sN(),ZM):d<0.5?(sN(),$M):(sN(),pN)}
function pP(a,b,c,d,e,f,g){var h,i,j,k,l,m;m=new UN;for(j=b.mb();j.G();){h=Wv(j.H(),627);for(l=new Tob(sW(h));l.a<l.c.c.length;){k=Wv(Rob(l),129);if(gw(oW(k,(eM(),tL)))===gw((EK(),CK))){nP(m,k,false,d,e,f,g);TN(a,m)}}}for(i=c.mb();i.G();){h=Wv(i.H(),627);for(l=new Tob(sW(h));l.a<l.c.c.length;){k=Wv(Rob(l),129);if(gw(oW(k,(eM(),tL)))===gw((EK(),BK))){nP(m,k,true,d,e,f,g);TN(a,m)}}}}
function f8(a,b){var c,d,e,f,g,h,i,j;for(i=new Tob(b.f);i.a<i.c.c.length;){h=Wv(Rob(i),7);for(e=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[h.b,h.e]))))));Cm(e);){d=Wv(Dm(e),12);c=d.c==h?d.d:d.c;f=c.f;if(b==f){continue}j=Wv(rJ(d,(Rib(),Eib)),24).a;j<0&&(j=0);g=f.k;if(a.b[g]==0){if(d.d==c){a.a[g]-=j+1;a.a[g]<=0&&a.c[g]>0&&QI(a.e,f)}else{a.c[g]-=j+1;a.c[g]<=0&&a.a[g]>0&&QI(a.d,f)}}}}}
function tcb(a,b){var c,d,e,f,g,h,i,j,k;for(g=new Tob(b.c);g.a<g.c.c.length;){f=Wv(Rob(g),16);for(j=new Tob(f.a);j.a<j.c.c.length;){i=Wv(Rob(j),9);k=new GU;h=0;for(e=Uh(iX(i));Cm(e);){c=Wv(Dm(e),12);Wv(rJ(c,(Rib(),Eib)),24).a>h&&(h=Wv(rJ(c,Eib),24).a)}for(d=Uh(iX(i));Cm(d);){c=Wv(Dm(d),12);i.d!=c.c.f.d&&Wv(rJ(c,(Rib(),Eib)),24).a==h&&vU(k,new RJ(c.c.f,c))}Gpb(k,a.c);uU(a.b,i.k,k)}}}
function ucb(a,b){var c,d,e,f,g,h,i,j,k;for(g=new Tob(b.c);g.a<g.c.c.length;){f=Wv(Rob(g),16);for(j=new Tob(f.a);j.a<j.c.c.length;){i=Wv(Rob(j),9);k=new GU;h=0;for(e=Uh(mX(i));Cm(e);){c=Wv(Dm(e),12);Wv(rJ(c,(Rib(),Eib)),24).a>h&&(h=Wv(rJ(c,Eib),24).a)}for(d=Uh(mX(i));Cm(d);){c=Wv(Dm(d),12);i.d!=c.d.f.d&&Wv(rJ(c,(Rib(),Eib)),24).a==h&&vU(k,new RJ(c.d.f,c))}Gpb(k,a.c);uU(a.f,i.k,k)}}}
function g3(a){b3();var b,c,d,e,f,g,h,i,j,k;this.b=new i3;this.c=new GU;this.a=new GU;for(i=Seb(),j=0,k=i.length;j<k;++j){h=i[j];ssb(a3,h,new GU)}for(c=a.mb();c.G();){b=Wv(c.H(),75);xU(this.a,Zdb(b));b.g.a.Y()==0?Wv(qsb(a3,b.e),20).ib(b):vU(this.c,b)}for(f=(g=(new aob(a3)).a.bb().mb(),new fob(g));f.a.G();){e=(d=Wv(f.a.H(),21),Wv(d.zb(),20));Gpb(e,this.b)}Dpb(Wv(qsb(a3,(Ieb(),neb)),20))}
function E$(a,b){var c,d,e,f,g,h,i;i=Wv(rJ(b,(eM(),TL)),28);if(!(i==(KM(),GM)||i==FM)){return}f=(c=Wv(rJ(b,(Rib(),Xhb)),15).a,new HI(b.e.a+b.a.b+b.a.c+2*c,b.e.b+b.a.d+b.a.a+2*c)).b;for(h=new Tob(a.a);h.a<h.c.c.length;){g=Wv(Rob(h),9);if(g.g!=(CX(),xX)){continue}d=Wv(rJ(g,hib),32);if(d!=(sN(),ZM)&&d!=rN){continue}e=Ixb(Yv(rJ(g,Cib)));i==GM&&(e*=f);g.i.b=e-Wv(rJ(g,SL),10).b;fX(g,false,true)}}
function fZ(a,b){var c,d,e,f,g,h,i,j;c=new uX(a.d.c);sX(c,(CX(),wX));sJ(c,(eM(),TL),Wv(rJ(b,TL),28));sJ(c,JL,Wv(rJ(b,JL),86));c.k=a.d.b++;vU(a.b,c);c.j.b=b.j.b;c.j.a=0;j=(sN(),ZM);f=Ao(nX(b,j));for(i=new Tob(f);i.a<i.c.c.length;){h=Wv(Rob(i),7);PX(h,c)}g=new RX;QX(g,j);PX(g,b);g.i.a=c.j.a;g.i.b=c.j.b/2;e=new RX;QX(e,tN(j));PX(e,c);e.i.b=c.j.b/2;e.i.a=-e.j.a;d=new hW;dW(d,g);eW(d,e);return c}
function m3(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;i=new Dh;Np(a,i);e=new deb(b);n=new GU;vU(n,(o=a.j,Wv(um(dq(!o?(a.j=new eq(a)):o)),7)));m=new GU;while(n.c.length!=0){h=Wv(Rob(new Tob(n)),7);m.c[m.c.length]=h;d=Sm(a,h);for(g=new Nqb(d.b.mb());g.b.G();){f=Wv(g.b.H(),12);if(beb(e,f,c)){l=Wv(Gd(i,f),20);for(k=l.mb();k.G();){j=Wv(k.H(),7);zU(m,j,0)!=-1||(n.c[n.c.length]=j,true)}}}BU(n,h)}return e}
function fmb(a,b){var c,d,e,f,g,h,i;c=RegExp(b,'g');h=xv($F,Txb,2,0,5,1);d=0;i=a;f=null;while(true){g=c.exec(i);if(g==null||i==''){h[d]=i;break}else{h[d]=gmb(i,0,g.index);i=gmb(i,g.index+g[0].length,(bmb(),i.length));c.lastIndex=0;if(f==i){h[d]=i.substr(0,1);i=imb(i,1,i.length-1)}f=i;++d}}if((bmb(),a.length)>0){e=h.length;while(e>0&&h[e-1]==''){--e}e<h.length&&(h.length=e,undefined)}return h}
function NO(a){var b,c,d,e,f,g;for(g=new Tob(AW(a.e));g.a<g.c.c.length;){f=Wv(Rob(g),161);switch(Wv(f.e,7).g.e){case 4:a.q.b=Nlb(a.q.b,(c=Wv(f.e,7).d,new EP(c.d,c.b,c.a,c.c)).c);break;case 2:a.q.c=Nlb(a.q.c,(d=Wv(f.e,7).d,new EP(d.d,d.b,d.a,d.c)).b);break;case 1:a.q.d=Nlb(a.q.d,(e=Wv(f.e,7).d,new EP(e.d,e.b,e.a,e.c)).a);break;case 3:a.q.a=Nlb(a.q.a,(b=Wv(f.e,7).d,new EP(b.d,b.b,b.a,b.c)).d);}}}
function Ns(a,b,c,d,e){var f,g,h;f=b.$b(c,a.b);if(f<0){g=a.e;if(!g){e[0]=0;return d>0?As(a,c,d):a}a.e=Ns(g,b,c,d,e);d==0&&e[0]!=0?--a.a:d>0&&e[0]==0&&++a.a;a.j=PH(a.j,d-e[0]);return Gs(a)}else if(f>0){h=a.g;if(!h){e[0]=0;return d>0?Bs(a,c,d):a}a.g=Ns(h,b,c,d,e);d==0&&e[0]!=0?--a.a:d>0&&e[0]==0&&++a.a;a.j=PH(a.j,d-e[0]);return Gs(a)}e[0]=a.c;if(d==0){return Fs(a)}a.j=PH(a.j,d-a.c);a.c=d;return a}
function Q7(a){var b,c,d,e,f,g,h;a.o=new Uvb;d=new aJ;for(g=new Tob(a.e.a);g.a<g.c.c.length;){f=Wv(Rob(g),61);m7(f).c.length==1&&(TI(d,f,d.c.b,d.c),true)}while(d.b!=0){f=Wv(d.b==0?null:(Bxb(d.b!=0),$I(d,d.a.a)),61);if(m7(f).c.length==0){continue}b=Wv(yU(m7(f),0),89);c=f.g.c.length>0;h=c7(b,f);c?p7(h.c,b):p7(h.g,b);m7(h).c.length==1&&(TI(d,h,d.c.b,d.c),true);e=new RJ(f,b);Tvb(a.o,e);BU(a.e.a,f)}}
function Hs(a,b,c,d,e){var f,g,h;f=b.$b(c,a.b);if(f<0){g=a.e;if(!g){e[0]=0;return a}a.e=Hs(g,b,c,d,e);if(e[0]>0){if(d>=e[0]){--a.a;a.j=XH(a.j,e[0])}else{a.j=XH(a.j,d)}}return e[0]==0?a:Gs(a)}else if(f>0){h=a.g;if(!h){e[0]=0;return a}a.g=Hs(h,b,c,d,e);if(e[0]>0){if(d>=e[0]){--a.a;a.j=XH(a.j,e[0])}else{a.j=XH(a.j,d)}}return Gs(a)}e[0]=a.c;if(d>=a.c){return Fs(a)}else{a.c-=d;a.j=XH(a.j,d);return a}}
function BQ(a,b,c){var d,e,f,g,h,i,j,k;for(i=new Tob(c.b);i.a<i.c.c.length;){h=Wv(Rob(i),9);g=Wv(rJ(h,(Rib(),sib)),55);if(g){k=BQ(a,b,g);h.j.a=(f=Wv(rJ(k,Xhb),15).a,new HI(k.e.a+k.a.b+k.a.c+2*f,k.e.b+k.a.d+k.a.a+2*f)).a;h.j.b=(e=Wv(rJ(k,Xhb),15).a,new HI(k.e.a+k.a.b+k.a.c+2*e,k.e.b+k.a.d+k.a.a+2*e)).b}}j=new sI;d=$v(rJ(c,(eM(),kL)));d!=null&&emb(d,'de.cau.cs.kieler.fixed')?JP(c,j):ZQ(b,c,j);return c}
function bR(a){var b,c,d,e,f,g,h,i;h=Wv(rJ(a,(eM(),aM)),18);i=Wv(rJ(a,bM),18);d=Wv(rJ(a,(Rib(),Xhb)),15).a;a.d.a+=d;a.d.b+=d;a.e.a+=2*d;a.e.b+=2*d;sJ(a,Xhb,new llb(0));e=(c=Wv(rJ(a,Xhb),15).a,new HI(a.e.a+a.a.b+a.a.c+2*c,a.e.b+a.a.d+a.a.a+2*c));b=new II(e);if(h.kb((DN(),zN))){g=Wv(rJ(a,IL),15).a;f=Wv(rJ(a,HL),15).a;if(i.kb((MN(),KN))){g<=0&&(g=20);f<=0&&(f=20)}b.a=Nlb(e.a,g);b.b=Nlb(e.b,f)}cR(a,e,b)}
function rV(a,b,c){var d,e,f,g,h,i,j,k;if(b.k==0){b.k=1;g=c;if(!c){e=new GU;f=(d=Wv(Hkb(Kz),11),new atb(d,Wv(exb(d,d.length),11),0));g=new RJ(e,f)}Wv(g.a,20).ib(b);b.g==(CX(),xX)&&Wv(g.b,18).ib(Wv(rJ(b,(Rib(),hib)),32));for(i=new Tob(b.f);i.a<i.c.c.length;){h=Wv(Rob(i),7);for(k=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[new fY(h),new lY(h)]))))));Cm(k);){j=Wv(Dm(k),7);rV(a,j.f,g)}}return g}return null}
function QW(a,b,c,d){var e,f,g,h,i;i=new II(b.i);i.a+=b.j.a/2;i.b+=b.j.b/2;h=Wv(rJ(b,(Rib(),tib)),15).a;f=a.e;g=a.a;e=a.d;switch(Wv(rJ(b,hib),32).e){case 1:i.a+=g.b+e.a-c/2;i.b=-d-h;b.i.b=-(g.d+h+e.b);break;case 2:i.a=f.a+g.b+g.c+h;i.b+=g.d+e.b-d/2;b.i.a=f.a+g.c+h-e.a;break;case 3:i.a+=g.b+e.a-c/2;i.b=f.b+g.d+g.a+h;b.i.b=f.b+g.a+h-e.b;break;case 4:i.a=-c-h;i.b+=g.d+e.b-d/2;b.i.a=-(g.b+h+e.a);}return i}
function $Q(a,b){var c,d,e,f,g,h,i;for(f=new Tob(b.b);f.a<f.c.c.length;){e=Wv(Rob(f),9);g=rJ(e,(Rib(),uib));if(aw(g,7)){h=Wv(g,7);i=QW(b,e,h.j.a,h.j.b);h.i.a=i.a;h.i.b=i.b;QX(h,Wv(rJ(e,hib),32))}}c=(d=Wv(rJ(b,(Rib(),Xhb)),15).a,new HI(b.e.a+b.a.b+b.a.c+2*d,b.e.b+b.a.d+b.a.a+2*d));if(Wv(rJ(b,jib),18).kb((ohb(),hhb))){sJ(a,(eM(),TL),(KM(),FM));Wv(rJ(hX(a),jib),18).ib(khb);WW(a,c,false)}else{WW(a,c,true)}}
function VW(a,b,c){var d,e,f,g,h;h=null;switch(b.e){case 1:for(e=new Tob(a.f);e.a<e.c.c.length;){d=Wv(Rob(e),7);if(Ckb(Ixb(Xv(rJ(d,(Rib(),kib)))))){return d}}h=new RX;sJ(h,(Rib(),kib),(xkb(),xkb(),wkb));break;case 2:for(g=new Tob(a.f);g.a<g.c.c.length;){f=Wv(Rob(g),7);if(Ckb(Ixb(Xv(rJ(f,(Rib(),yib)))))){return f}}h=new RX;sJ(h,(Rib(),yib),(xkb(),xkb(),wkb));}if(h){PX(h,a);QX(h,c);LW(h.i,a.j,c)}return h}
function pk(a,b){var c,d,e,f,g,h,i;_b(b);Xb(a.a.t(b.a));d=a.b;f=a.e;g=a.d;if(a.b){if(b.b){c=a.a.$b(a.e,b.e);if(c<0||c==0&&b.d==(Gh(),Fh)){f=b.e;g=b.d}}}else{d=b.b;f=b.e;g=b.d}e=a.c;h=a.g;i=a.f;if(a.c){if(b.c){c=a.a.$b(a.g,b.g);if(c>0||c==0&&b.f==(Gh(),Fh)){h=b.g;i=b.f}}}else{e=b.c;h=b.g;i=b.f}if(d&&e){c=a.a.$b(f,h);if(c>0||c==0&&g==(Gh(),Fh)&&i==(Gh(),Fh)){f=h;g=(Gh(),Fh);i=Eh}}return new sk(a.a,d,f,g,e,h,i)}
function h0(a,b,c,d){var e,f,g,h,i,j,k;if(c.c.f==b.f){return}e=new uX(a);sX(e,(CX(),zX));sJ(e,(Rib(),uib),c);sJ(e,(eM(),TL),(KM(),FM));d.c[d.c.length]=e;g=new RX;PX(g,e);QX(g,(sN(),rN));h=new RX;PX(h,e);QX(h,ZM);eW(c,g);f=new hW;qJ(f,c);sJ(f,CL,null);dW(f,h);eW(f,b);j0(e,g,h);j=new Fnb(c.b,0);while(j.b<j.d.Y()){i=(Bxb(j.b<j.d.Y()),Wv(j.d.sb(j.c=j.b++),33));k=Wv(rJ(i,tL),107);if(k==(EK(),BK)){vnb(j);vU(f.b,i)}}}
function Pfb(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q;f=c+(b.n+1)*a.a;g=b.b;e=new HI(f,g);for(i=(k=(new Snb(b.c.a)).a.bb().mb(),new Ynb(k));i.a.G();){h=(j=Wv(i.a.H(),21),Wv(j.yb(),12));o=MX(h.d);l=MX(h.c);n=new HI(f,l.b);q=new HI(f,o.b);m=new HI(c-10,l.b);p=new HI(d,o.b);o.a>=d&&l.a>=d&&(m.a=d);o.a<=c&&l.a<=c&&(p.a=c-10);b.c.a.Y()==1?fJ(h.a,Bv(tv(qz,1),Fzb,10,0,[m,n,q,p])):fJ(h.a,Bv(tv(qz,1),Fzb,10,0,[m,n,e,q,p]))}}
function cW(a,b){var c,d,e,f,g,h;f=a.c;g=a.d;dW(a,null);eW(a,null);b&&Ckb(Ixb(Xv(rJ(g,(Rib(),kib)))))?dW(a,VW(g.f,(djb(),bjb),(sN(),ZM))):dW(a,g);b&&Ckb(Ixb(Xv(rJ(f,(Rib(),yib)))))?eW(a,VW(f.f,(djb(),ajb),(sN(),rN))):eW(a,f);for(d=new Tob(a.b);d.a<d.c.c.length;){c=Wv(Rob(d),33);e=Wv(rJ(c,(eM(),tL)),107);e==(EK(),CK)?sJ(c,tL,BK):e==BK&&sJ(c,tL,CK)}h=Ckb(Ixb(Xv(rJ(a,(Rib(),Iib)))));sJ(a,Iib,(xkb(),h?vkb:wkb));a.a=lJ(a.a)}
function efb(a){var b,c,d,e,f,g;Teb(this);for(c=a.Y()-1;c<3;c++){a.rb(0,Wv(a.sb(0),10))}if(a.Y()<4){throw new slb('At (least dimension + 1) control points are necessary!')}else{this.c=3;this.e=true;this.f=true;this.d=false;Ueb(this,a.Y()+this.c-1);g=new GU;f=this.g.mb();for(b=0;b<this.c-1;b++){vU(g,Yv(f.H()))}for(e=a.mb();e.G();){d=Wv(e.H(),10);vU(g,Yv(f.H()));this.b.ib(new sfb(d,g));Cxb(0,g.c.length);g.c.splice(0,1)}}}
function scb(a){var b,c,d,e,f,g,h,i,j,k,l;l=new rcb;l.d=0;for(g=new Tob(a.c);g.a<g.c.c.length;){f=Wv(Rob(g),16);l.d+=f.a.c.length}d=0;e=0;l.a=xv(mw,Yyb,26,a.c.c.length,12,1);j=0;l.e=xv(mw,Yyb,26,l.d,12,1);for(c=new Tob(a.c);c.a<c.c.c.length;){b=Wv(Rob(c),16);b.k=d++;l.a[b.k]=e++;k=0;for(i=new Tob(b.a);i.a<i.c.c.length;){h=Wv(Rob(i),9);h.k=j++;l.e[h.k]=k++}}l.c=new wcb(l);l.b=Do(l.d);tcb(l,a);l.f=Do(l.d);ucb(l,a);return l}
function Lab(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;h=xv(mw,Yyb,26,b.c.c.length,12,1);j=xv(pB,uyb,132,b.c.c.length,0,1);for(l=a.a,m=0,n=l.length;m<n;++m){k=l[m];p=0;for(g=new Tob(k.f);g.a<g.c.c.length;){e=Wv(Rob(g),9);i=e.g;d=rY(e.d);++h[d];o=a.b.a*a.b.d;h[d]>0&&!!j[d]&&(o=Wjb(a.b,j[d],i));p=Nlb(p,e.d.c.b+o)}for(f=new Tob(k.f);f.a<f.c.c.length;){e=Wv(Rob(f),9);e.i.b=p+e.e.d;c=e.d;c.c.b=p+e.e.d+e.j.b+e.e.a;j[zU(c.b.c,c,0)]=e.g}}}
function n$(a){var b,c,d,e,f,g,h,i,j,k;for(i=new Tob(a.a);i.a<i.c.c.length;){h=Wv(Rob(i),9);if(h.g!=(CX(),xX)){continue}e=Wv(rJ(h,(Rib(),hib)),32);if(e==(sN(),ZM)||e==rN){for(d=Uh(gX(h));Cm(d);){c=Wv(Dm(d),12);b=c.a;if(b.b==0){continue}j=c.c;if(j.f==h){f=(Bxb(b.b!=0),Wv(b.a.a.c,10));f.b=MI(Bv(tv(qz,1),Fzb,10,0,[j.f.i,j.i,j.a])).b}k=c.d;if(k.f==h){g=(Bxb(b.b!=0),Wv(b.c.b.c,10));g.b=MI(Bv(tv(qz,1),Fzb,10,0,[k.f.i,k.i,k.a])).b}}}}}
function U9(a,b,c,d){var e,f,g,h,i,j;g=new _9(a,b,c);i=new Fnb(d,0);e=false;while(i.b<i.d.Y()){h=(Bxb(i.b<i.d.Y()),Wv(i.d.sb(i.c=i.b++),102));if(h==b||h==c){vnb(i)}else if(!e&&Ixb(W9(h.g,h.d[0]).a)>Ixb(W9(g.g,g.d[0]).a)){Bxb(i.b>0);i.a.sb(i.c=--i.b);Anb(i,g);e=true}else if(!!h.e&&h.e.Y()>0){f=(!h.e&&(h.e=new GU),h.e).nb(b);j=(!h.e&&(h.e=new GU),h.e).nb(c);if(f||j){(!h.e&&(h.e=new GU),h.e).ib(g);++g.c}}}e||(d.c[d.c.length]=g,true)}
function s2(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;if(c.d.f==b.f){return}e=new uX(a);sX(e,(CX(),zX));sJ(e,(Rib(),uib),c);sJ(e,(eM(),TL),(KM(),FM));d.c[d.c.length]=e;g=new RX;PX(g,e);QX(g,(sN(),rN));h=new RX;PX(h,e);QX(h,ZM);i=c.d;eW(c,g);f=new hW;qJ(f,c);sJ(f,CL,null);dW(f,h);eW(f,i);j=Wv(yU(g.b,0),12).c;k=j.f;l=k.g;m=Wv(yU(h.e,0),12).d;n=m.f;o=n.g;l==zX?sJ(e,qib,Wv(rJ(k,qib),7)):sJ(e,qib,j);o==zX?sJ(e,rib,Wv(rJ(n,rib),7)):sJ(e,rib,m)}
function $6(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;if(h=a.b[b],i=a.b[c],(j=Wv(rJ(h,(Rib(),oib)),20),!!j&&j.Y()!=0&&j.kb(i))||(k=h.g!=(CX(),zX)&&i.g!=zX,l=Wv(rJ(h,nib),9),m=Wv(rJ(i,nib),9),n=!!l&&l!=h||!!m&&m!=i,o=l!=m,p=_6(h,(sN(),$M)),q=_6(i,pN),r=n&&o||p||q,k&&r)||h.g==(CX(),BX)&&i.g==AX||i.g==(CX(),BX)&&h.g==AX){return false}g=a.b[b];d=a.b[c];m6(a.c,g,d);G6(a.d,g,d);f=M5(a.a,g,d)+a.c.d+a.d.d;e=M5(a.a,d,g)+a.c.b+a.d.b;return f>e}
function v2(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;g=b;m=b.d;k=b.c.f;n=b.d.f;l=rY(k.d);o=rY(n.d);for(h=l;h<o;h++){e=new uX(a);sX(e,(CX(),zX));sJ(e,(Rib(),uib),g);sJ(e,(eM(),TL),(KM(),FM));i=Wv(yU(a.c,h+1),16);rX(e,i);p=Wv(rJ(g,dM),15).a;if(p<0){p=0;sJ(g,dM,new llb(p))}e.j.b=p;j=Math.floor(p/2);d=new RX;QX(d,(sN(),rN));PX(d,e);d.i.b=j;f=new RX;QX(f,ZM);PX(f,e);f.i.b=j;eW(g,d);c=new hW;qJ(c,g);sJ(c,CL,null);dW(c,f);eW(c,m);w2(e,g,c);g=c}}
function Qeb(a,b){Ieb();if(a==b){return Reb(a)}switch(a.e){case 1:switch(b.e){case 4:return neb;case 1:return meb;case 2:return jeb;case 3:return qeb;}case 2:switch(b.e){case 1:return jeb;case 2:return ieb;case 3:return peb;case 4:return keb;}case 3:switch(b.e){case 2:return peb;case 3:return oeb;case 4:return Heb;case 1:return qeb;}case 4:switch(b.e){case 3:return Heb;case 4:return Geb;case 1:return neb;case 2:return keb;}}return Feb}
function s$(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p;l=new Wub;e=null;for(g=new Tob(a.c);g.a<g.c.c.length;){f=Wv(Rob(g),16);for(i=new Tob(f.a);i.a<i.c.c.length;){h=Wv(Rob(i),9);if(h.g!=(CX(),xX)){continue}k=Wv(rJ(h,(Rib(),gib)),9);if(k){r$(k,l);m=new RX;PX(m,h);n=Wv(rJ(h,hib),32);QX(m,n);o=Wv(yU(k.f,0),7);p=new hW;dW(p,m);eW(p,o)}}e=f}for(c=(j=(new Snb(l.a)).a.bb().mb(),new Ynb(j));c.a.G();){b=(d=Wv(c.a.H(),21),Wv(d.yb(),9));rX(b,e)}return l}
function RV(a,b,c){var d,e,f,g,h,i,j,k,l;e=new GU;for(j=new Tob(b.b);j.a<j.c.c.length;){i=Wv(Rob(j),9);h=Wv(rJ(i,(Rib(),sib)),55);if(h){d=RV(a,h,i);xU(e,d);PV(a,h,i);if(Wv(rJ(h,jib),18).kb((ohb(),hhb))){for(l=new Tob(i.f);l.a<l.c.c.length;){k=Wv(Rob(l),7);if(Smb(a.b,k)==null){f=NW(k,(KM(),IM),k.g,-(k.b.c.length-k.e.c.length),k.j,Wv(rJ(h,(eM(),sL)),59),h);sJ(f,uib,k);Umb(a.b,k,f);vU(h.b,f)}}}}}g=new GU;OV(a,b,c,e,g);!!c&&QV(a,b,c,g);return g}
function Obb(a){var b,c,d,e,f,g,h,i,j,k,l,m;b=ecb(a);for(k=(h=(new Snb(b)).a.bb().mb(),new Ynb(h));k.a.G();){j=(e=Wv(k.a.H(),21),Wv(e.yb(),9));l=j.e.d;m=j.j.b+j.e.a;a.d[j.k]=0;c=j;while((f=a.a[c.k])!=j){d=gcb(c,f);a.c==(Gbb(),Ebb)?(i=d.d.i.b+d.d.a.b-d.c.i.b-d.c.a.b):(i=d.c.i.b+d.c.a.b-d.d.i.b-d.d.a.b);g=Ixb(a.d[c.k])+i;a.d[f.k]=g;l=Nlb(l,f.e.d-g);m=Nlb(m,g+f.j.b+f.e.a);c=f}c=j;do{a.d[c.k]=Ixb(a.d[c.k])+l;c=a.a[c.k]}while(c!=j);a.b[j.k]=l+m}}
function Gcb(a,b,c){var d,e,f,g,h,i,j,k;d=a.a.k==(Lbb(),Kbb)?Uzb:Vzb;h=Hcb(a,new Fcb(b,c));if(!h.a&&h.c){QI(a.d,h);return d}else if(h.a){e=h.a.c;i=h.a.d;if(c){j=a.a.c==(Gbb(),Fbb)?i:e;f=a.a.c==Fbb?e:i;g=a.a.f[f.f.k];k=Ixb(a.a.n[g.k])+Ixb(a.a.d[f.f.k])+f.i.b+f.a.b-Ixb(a.a.d[j.f.k])-j.i.b-j.a.b}else{j=a.a.c==(Gbb(),Ebb)?i:e;f=a.a.c==Ebb?e:i;k=Ixb(a.a.n[a.a.f[f.f.k].k])+Ixb(a.a.d[f.f.k])+f.i.b+f.a.b-Ixb(a.a.d[j.f.k])-j.i.b-j.a.b}return k}return d}
function FY(a){var b,c,d,e,f;sJ(a.g,(Rib(),Thb),Eo(a.g.c));for(b=1;b<a.c.c.length-1;++b){sJ(Wv(yU(a.c,b),9),(eM(),JL),(oM(),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[mM,fM]))))}for(d=WI(Eo(a.g.c),0);d.b!=d.d.c;){c=Wv(_ub(d),33);e=Wv(rJ(a.g,(eM(),JL)),86);if(Xe(e,Vsb((oM(),kM),Bv(tv(Gz,1),uyb,41,0,[gM,mM]))));else if(Xe(e,Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[iM,mM])))){vU(a.e.c,c);BU(a.g.c,c);f=new MY(a,c);sJ(a.g,Uhb,f)}else{GY(a,c);vU(a.i,a.d);sJ(a.g,Uhb,EY(a.i))}}}
function OW(a,b,c,d){var e,f,g,h,i,j,k;f=PW(d);h=Ckb(Ixb(Xv(rJ(d,(Mjb(),xjb)))));if((h||Ckb(Ixb(Xv(rJ(a,(eM(),AL))))))&&!MM(Wv(rJ(a,(eM(),TL)),28))){e=vN(f);i=VW(a,c,c==(djb(),bjb)?e:tN(e))}else{i=new RX;PX(i,a);k=i.i;k.a=b.a-a.i.a;k.b=b.b-a.i.b;wI(k,a.j.a,a.j.b);QX(i,KW(i,f));g=Wv(rJ(d,(Rib(),jib)),18);j=i.g;switch(f.e){case 2:case 1:(j==(sN(),$M)||j==pN)&&g.ib((ohb(),lhb));break;case 4:case 3:(j==(sN(),ZM)||j==rN)&&g.ib((ohb(),lhb));}}return i}
function G2(a){var b,c,d,e,f,g,h,i;d=Nl(Ao(a.a));e=(b=Wv(Hkb(_E),11),new atb(b,Wv(exb(b,b.length),11),0));while(d.a.G()||d.b.mb().G()){c=Wv(nm(d),12);h=c.c.g;i=c.d.g;if(h==(sN(),qN)){if(i!=qN){g=Reb(i);sJ(c,(Rib(),Mib),g);QX(c.c,i);Wsb(e,g);d.a.I()}}else{if(i==qN){g=Reb(h);sJ(c,(Rib(),Mib),g);QX(c.d,h);Wsb(e,g);d.a.I()}else{g=Qeb(h,i);sJ(c,(Rib(),Mib),g);Wsb(e,g);d.a.I()}}}e.c==1?(f=Wv(itb(new jtb(e)),60)):(f=(Ieb(),Feb));aeb(a,f,false);return f}
function AI(b,c){var d,e,f,g;f=0;while(f<(bmb(),c.length)&&LI(c.charCodeAt(f),fzb)){++f}d=c.length;while(d>0&&LI(c.charCodeAt(d-1),gzb)){--d}if(f>=d){throw new slb('The given string does not contain any numbers.')}g=fmb(c.substr(f,d-f),',|;|\r|\n');if(g.length!=2){throw new slb('Exactly two numbers are expected, '+g.length+' were found.')}try{b.a=clb(hmb(g[0]));b.b=clb(hmb(g[1]))}catch(a){a=OH(a);if(aw(a,130)){e=a;throw new slb(hzb+e)}else throw NH(a)}}
function Qdb(a,b,c){var d,e,f,g,h,i,j,k,l;i=c+b.d.c.a;for(l=new Tob(b.f);l.a<l.c.c.length;){k=Wv(Rob(l),7);d=MI(Bv(tv(qz,1),Fzb,10,0,[k.f.i,k.i,k.a]));f=new HI(0,d.b);if(k.g==(sN(),ZM)){f.a=i}else if(k.g==rN){f.a=c}else{continue}if(d.a==f.a){continue}e=k.e.c.length+k.b.c.length>1;for(h=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[k.b,k.e]))))));Cm(h);){g=Wv(Dm(h),12);j=g.c==k?g.d:g.c;Jlb(MI(Bv(tv(qz,1),Fzb,10,0,[j.f.i,j.i,j.a])).b-f.b)>1&&Odb(a,g,f,e,k)}}}
function FR(a,b){var c,d,e,f,g,h;for(g=new rnb((new inb(a.f.b)).a);g.b;){f=pnb(g);e=Wv(f.yb(),251);if(b==1){if(e.yc()!=(sK(),rK)&&e.yc()!=nK){continue}}else{if(e.yc()!=(sK(),oK)&&e.yc()!=pK){continue}}d=Wv(Wv(f.zb(),27).b,25);h=Wv(Wv(f.zb(),27).a,78);c=h.c;switch(e.yc().e){case 2:d.j.d=a.e.a;d.j.c=Nlb(1,d.j.c+c);break;case 1:d.j.d=d.j.d+c;d.j.c=Nlb(1,d.j.c-c);break;case 4:d.j.e=a.e.b;d.j.b=Nlb(1,d.j.b+c);break;case 3:d.j.e=d.j.e+c;d.j.b=Nlb(1,d.j.b-c);}}}
function bdb(a,b,c,d,e){var f,g,h,i,j,k,l,m,n;m=(mp(),new ntb);h=new GU;adb(a,c,a.d.Mc(),h,m);adb(a,d,a.d.Nc(),h,m);i=new Fnb(h,0);while(i.b<i.d.Y()){f=(Bxb(i.b<i.d.Y()),Wv(i.d.sb(i.c=i.b++),80));j=new Fnb(h,i.b);while(j.b<j.d.Y()){g=(Bxb(j.b<j.d.Y()),Wv(j.d.sb(j.c=j.b++),80));gdb(f,g,a.a)}}ddb(h,Wv(rJ(b,(Rib(),Gib)),154));idb(h);n=-1;for(l=new Tob(h);l.a<l.c.c.length;){k=Wv(Rob(l),80);if(Jlb(k.k-k.a)<dAb){continue}n=Plb(n,k.i);a.d.Kc(k,e)}a.b.a.Q();return n+1}
function r3(a,b,c){var d,e;e=new II(b);d=new II(a.j);switch(c.e){case 1:case 8:case 7:uI(e,-d.a/2,-d.b);uI(b,0,-(0.5+d.b));break;case 3:case 4:case 5:uI(e,-d.a/2,0);uI(b,0,0.5+d.b);break;case 0:uI(e,-d.a/2,-d.b);uI(b,0,-(0.5+-d.b));break;case 10:case 2:uI(e,0,-d.b/2);uI(b,0,-(0.5+d.b));break;case 6:uI(e,-d.a,d.b/2);uI(b,0,-(0.5+d.b));break;case 9:uI(e,-d.a/2,0);uI(b,0,-(0.5+d.b));break;case 11:uI(e,-d.a,-d.b/2);uI(b,0,-(0.5+d.b));}vI(BI(a.i),e);return new Cfb(a)}
function Gmb(a,b,c,d,e){Fmb();var f,g,h,i,j,k,l;Exb(a,'src');Exb(c,'dest');k=tb(a);h=tb(c);Axb((k.g&4)!=0,'srcType is not an array');Axb((h.g&4)!=0,'destType is not an array');j=k.c;f=h.c;Axb((j.g&1)!=0?j==f:(f.g&1)==0,"Array types don't match");l=a.length;i=c.length;if(b<0||d<0||e<0||b+e>l||d+e>i){throw new nkb}if(((j.g&1)==0||(j.g&4)!=0)&&k!=h){if(a===c&&b<d){b+=e;for(g=d+e;g-->d;){c[g]=a[--b]}}else{for(g=d+e;d<g;){c[d++]=a[b++]}}}else e>0&&dxb(a,b,c,d,e,true)}
function cR(a,b,c){var d,e,f,g,h;d=Wv(rJ(a,(Mjb(),jjb)),18);c.a>b.a&&(d.kb((zgb(),tgb))?(a.d.a+=(c.a-b.a)/2):d.kb(vgb)&&(a.d.a+=c.a-b.a));c.b>b.b&&(d.kb((zgb(),xgb))?(a.d.b+=(c.b-b.b)/2):d.kb(wgb)&&(a.d.b+=c.b-b.b));if(Wv(rJ(a,(Rib(),jib)),18).kb((ohb(),hhb))&&(c.a>b.a||c.b>b.b)){for(h=new Tob(a.b);h.a<h.c.c.length;){g=Wv(Rob(h),9);if(g.g==(CX(),xX)){e=Wv(rJ(g,hib),32);e==(sN(),ZM)?(g.i.a+=c.a-b.a):e==pN&&(g.i.b+=c.b-b.b)}}}f=a.a;a.e.a=c.a-f.b-f.c;a.e.b=c.b-f.d-f.a}
function Ms(a,b,c,d,e,f){var g,h,i;g=b.$b(c,a.b);if(g<0){h=a.e;if(!h){f[0]=0;if(d==0&&e>0){return As(a,c,e)}return a}a.e=Ms(h,b,c,d,e,f);if(f[0]==d){e==0&&f[0]!=0?--a.a:e>0&&f[0]==0&&++a.a;a.j=PH(a.j,e-f[0])}return Gs(a)}else if(g>0){i=a.g;if(!i){f[0]=0;if(d==0&&e>0){return Bs(a,c,e)}return a}a.g=Ms(i,b,c,d,e,f);if(f[0]==d){e==0&&f[0]!=0?--a.a:e>0&&f[0]==0&&++a.a;a.j=PH(a.j,e-f[0])}return Gs(a)}f[0]=a.c;if(d==a.c){if(e==0){return Fs(a)}a.j=PH(a.j,e-a.c);a.c=e}return a}
function gfb(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;i=a.e;n=a.f;g=a.d;o=a.c;k=o-1;p=a.g;l=Eo(a.g.xb(1,a.g.Y()-1));j=new GU;for(c=0;c<a.b.Y()-1;c++){h=CI(EI(xI(Wv(a.b.sb(c+1),92).a),Wv(a.b.sb(c),92).a),o/(Ixb(Yv(p.sb(c+o)))-Ixb(Yv(p.sb(c)))));j.c[j.c.length]=h}q=new GU;f=WI(l,0);m=new GU;for(b=0;b<k-1;b++){vU(q,Yv(_ub(f)))}for(e=new Tob(j);e.a<e.c.c.length;){d=Wv(Rob(e),10);vU(q,Yv(_ub(f)));vU(m,new sfb(d,q));Cxb(0,q.c.length);q.c.splice(0,1)}return new ffb(i,n,g,k,l,m)}
function fP(a){this.q=new AP;this.p=new AP;this.o=xv(mw,Yyb,26,(sN(),Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN])).length,12,1);this.i=xv(mw,Yyb,26,Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN]).length,12,1);this.j=xv(kw,hyb,26,Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN]).length,12,1);this.n=xv(kw,hyb,26,Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN]).length,12,1);this.g=xv(Hz,uyb,100,Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN]).length,0,1);this.c=new vsb(Oz);this.e=a;$ob(this.o);$ob(this.i);Yob(this.n,0)}
function _Q(a,b){var c,d,e,f,g,h,i,j,k,l;g=b.i!=null&&!b.b;g||nI(b,'Component Layout',1);c=Wv(rJ(a,(Rib(),Fib)),20);f=1/c.Y();if(Ckb(Ixb(Xv(rJ(a,(eM(),rL)))))){l=0;for(k=c.mb();k.G();){j=Wv(k.H(),31);++l;Jkb(tb(j));j.sc(a,rI(b,f))}}else{for(k=c.mb();k.G();){j=Wv(k.H(),31);j.sc(a,rI(b,f))}}for(e=new Tob(a.c);e.a<e.c.c.length;){d=Wv(Rob(e),16);xU(a.b,d.a);d.a.c=xv(UF,syb,1,0,4,1)}for(i=new Tob(a.b);i.a<i.c.c.length;){h=Wv(Rob(i),9);rX(h,null)}a.c.c=xv(UF,syb,1,0,4,1);g||pI(b)}
function S9(a,b){var c,d,e,f,g,h,i,j,k,l,m;for(g=new Tob(b);g.a<g.c.c.length;){e=Wv(Rob(g),102);e.e=null;e.c=0}h=null;for(f=new Tob(b);f.a<f.c.c.length;){e=Wv(Rob(f),102);k=e.d[0];for(m=Wv(rJ(k,(Rib(),oib)),20).mb();m.G();){l=Wv(m.H(),9);(!e.e&&(e.e=new GU),e.e).ib(a.b[l.d.k][l.k]);++a.b[l.d.k][l.k].c}if(k.g==(CX(),AX)){if(h){for(j=An(new Bn(a.c,h),0);j.c;){i=Wv(ko(j),9);for(d=An(new Bn(a.c,k),0);d.c;){c=Wv(ko(d),9);Y9(a.b[i.d.k][i.k]).ib(a.b[c.d.k][c.k]);++a.b[c.d.k][c.k].c}}}h=k}}}
function gQ(a,b,c,d){var e,f,g,h,i,j;SP(b);f=Wv(rJ(d,(Rib(),jib)),18);h=(eM(),KL).b;if(h in b.a&&Pu(b,h).ic().a){return}i=new RX;sJ(i,uib,b);PX(i,c);g=Wv(Pu(b,'id'),97);Vmb(a.k,g.a,i);Umb(a.n,i,b);_P(b,i);hQ(b,i);dQ(a,b,i,d);QX(i,Wv(rJ(i,WL),32));j=Wv(rJ(c,TL),28);j==(KM(),JM)&&(j=IM);e=Wv(rJ(d,sL),59);e==(sK(),qK)&&(e=pK);RW(i,j,e,Wv(rJ(i,SL),10));switch(e.e){case 2:case 1:(i.g==(sN(),$M)||i.g==pN)&&f.ib((ohb(),lhb));break;case 4:case 3:(i.g==(sN(),ZM)||i.g==rN)&&f.ib((ohb(),lhb));}}
function Q5(a,b){var c,d,e,f,g,h,i,j;a.f=b;e=b.c.c.length;a.a=xv(qB,Txb,51,e,0,2);a.d=xv(qB,Txb,51,e,0,2);a.g=xv(qB,Txb,51,e,0,2);g=new Fnb(b.c,0);while(g.b<g.d.Y()){d=(Bxb(g.b<g.d.Y()),Wv(g.d.sb(g.c=g.b++),16));h=d.a.c.length;f=g.b-1;a.a[f]=xv(qB,Nzb,9,h,0,1);a.d[f]=xv(qB,Nzb,9,h,0,1);a.g[f]=xv(qB,Nzb,9,h,0,1);j=new Fnb(d.a,0);c=0;while(j.b<j.d.Y()){i=(Bxb(j.b<j.d.Y()),Wv(j.d.sb(j.c=j.b++),9));i.k=c++;a.d[f][j.b-1]=i;a.a[f][j.b-1]=i;a.g[f][j.b-1]=i}}a.b=new _4(a.d);a.e.c&&(a.b.e=true)}
function gZ(a){var b,c,d,e,f,g;e=new GU;for(g=new Tob(a.c.f);g.a<g.c.c.length;){f=Wv(Rob(g),7);f.g==(sN(),ZM)&&(e.c[e.c.length]=f,true)}if(a.d.a==(sK(),pK)&&!MM(Wv(rJ(a.c,(eM(),TL)),28))){for(d=Uh(mX(a.c));Cm(d);){c=Wv(Dm(d),12);vU(e,c.c)}}sJ(a.c,(Rib(),Whb),new llb(a.c.j.a));sJ(a.c,Vhb,(xkb(),xkb(),wkb));vU(a.b,a.c);b=null;a.e==1?(b=jZ(a,a.c,rY(a.c.d),a.c.j.a)):a.e==0?(b=iZ(a,a.c,rY(a.c.d),a.c.j.a)):a.e==3?(b=kZ(a,a.c,a.c.j.a)):a.e==2&&(b=hZ(a,a.c,a.c.j.a));!!b&&new HY(a.c,a.b,Ixb(Yv(b.b)))}
function Mab(a,b,c){var d,e,f,g,h,i,j,k;e=b.g;Ckb(Ixb(Xv(rJ(b,(Rib(),Vhb)))))&&(e=(CX(),wX));if(b.k>=0){return false}else if(!!c.e&&e==(CX(),wX)&&e!=c.e){return false}else{b.k=c.b;vU(c.f,b)}c.e=e;if(e==(CX(),zX)||e==BX||e==wX){for(g=new Tob(b.f);g.a<g.c.c.length;){f=Wv(Rob(g),7);for(k=(d=new Tob((new lY(f)).a.e),new nY(d));Qob(k.a);){j=Wv(Rob(k.a),12).d;h=j.f;i=h.g;if(b.d!=h.d){if(e==wX){if(i==wX){if(Mab(a,h,c)){return true}}}else{if(i==zX||i==BX){if(Mab(a,h,c)){return true}}}}}}}return true}
function K3(a,b){var c,d,e,f,g,h,i,j,k;fJ(a.a,Bv(tv(qz,1),Fzb,10,0,[b.a,b.b]));Ue(a.c,b.e);a.q.d=a.q.d|b.d;a.q.a=a.q.a|b.c;h=Qlb(a.j.e,b.k);i=Nlb(a.j.e+a.j.b,b.n);SN(a.j,b.j,h,0,i-h);stb(a.d,b.f);b.f.c.f==b.f.d.f&&wS(a.n,true,true,true,true);g=new vtb;j=new vtb;for(e=(k=(new Snb(a.d.a)).a.bb().mb(),new Ynb(k));e.a.G();){d=(f=Wv(e.a.H(),21),Wv(f.yb(),12));stb(g,d.c);stb(j,d.d)}c=g.a.Y()-j.a.Y();if(c<0){vS(a.n,true,(sK(),oK));vS(a.n,false,pK)}else if(c>0){vS(a.n,false,(sK(),oK));vS(a.n,true,pK)}}
function tP(b,c){var d,e,f,g,h,i,j,k,l,m;h=0;while(h<(bmb(),c.length)&&yP(c.charCodeAt(h),fzb)){++h}d=c.length;while(d>0&&yP(c.charCodeAt(d-1),gzb)){--d}if(h<d){l=fmb(c.substr(h,d-h),',|;');try{for(j=0,k=l.length;j<k;++j){i=l[j];g=fmb(i,'=');if(g.length!=2){throw new slb('Expecting a list of key-value pairs.')}f=hmb(g[0]);m=clb(hmb(g[1]));emb(f,'top')?(b.d=m):emb(f,'left')?(b.b=m):emb(f,Azb)?(b.a=m):emb(f,'right')&&(b.c=m)}}catch(a){a=OH(a);if(aw(a,130)){e=a;throw new slb(hzb+e)}else throw NH(a)}}}
function Ubb(a,b){var c,d,e,f,g,h,i,j,k;k=new aJ;for(h=(j=(new aob(a.c)).a.bb().mb(),new fob(j));h.a.G();){f=(e=Wv(h.a.H(),21),Wv(e.zb(),200));f.b==0&&(TI(k,f,k.c.b,k.c),true)}while(k.b!=0){f=Wv(k.b==0?null:(Bxb(k.b!=0),$I(k,k.a.a)),200);for(d=new Tob(f.d);d.a<d.c.c.length;){c=Wv(Rob(d),279);b.k==(Lbb(),Jbb)?(c.b.a=Qlb(c.b.a,f.a+c.a)):(c.b.a=Nlb(c.b.a,f.a+c.a));--c.b.b;c.b.b==0&&QI(k,c.b)}}for(g=(i=(new aob(a.c)).a.bb().mb(),new fob(i));g.a.G();){f=(e=Wv(g.a.H(),21),Wv(e.zb(),200));b.g[f.c.k]=f.a}}
function yZ(a,b,c){var d,e,f,g;f=a.i;e=MI(Bv(tv(qz,1),Fzb,10,0,[b.i,b.f.i]));d=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a]));g=b.d;switch(b.g.e){case 4:f.a=Qlb(e.a,d.a)-g.b-a.j.a-c;f.b=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a])).b+c;break;case 2:f.a=Nlb(e.a+b.j.a,d.a)+g.c+c;f.b=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a])).b+c;break;case 1:f.a=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a])).a+c;f.b=Qlb(e.b,d.b)-g.d-a.j.b-c;break;case 3:f.a=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a])).a+c;f.b=Nlb(e.b+b.j.b,d.b)+g.a+c;}}
function zZ(a,b,c){var d,e,f,g;f=a.i;e=MI(Bv(tv(qz,1),Fzb,10,0,[b.i,b.f.i]));d=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a]));g=b.d;switch(b.g.e){case 4:f.a=Qlb(e.a,d.a)-g.b-a.j.a-c;f.b=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a])).b-a.j.b-c;break;case 2:f.a=Nlb(e.a+b.j.a,d.a)+g.c+c;f.b=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a])).b-a.j.b-c;break;case 1:f.a=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a])).a+c;f.b=Qlb(e.b,d.b)-g.d-a.j.b-c;break;case 3:f.a=MI(Bv(tv(qz,1),Fzb,10,0,[b.f.i,b.i,b.a])).a+c;f.b=Nlb(e.b+b.j.b,d.b)+g.a+c;}}
function MQ(a){var b,c;c=Wv(rJ(a,(Rib(),jib)),18);b=XQ(HQ);Ckb(Ixb(Xv(rJ(a,(Mjb(),rjb)))))?RQ(b,(d0(),W_)):TQ(b,(d0(),W_));rJ(a,(bK(),aK))!=null&&QQ(b,IQ);switch(Wv(rJ(a,(eM(),sL)),59).e){case 2:PQ(RQ(b,(d0(),L_)),K_);break;case 3:PQ(RQ(b,(d0(),o_)),n_);break;case 4:PQ(RQ(b,(d0(),c0)),b0);}c.kb((ohb(),fhb))&&PQ(RQ(b,(d0(),m_)),l_);gw(rJ(a,Bjb))!==gw((I1(),G1))&&TQ(b,(d0(),P_));gw(rJ(a,Fjb))!==gw((g4(),e4))&&gw(rJ(a,eib))===gw((NK(),JK))&&PQ(b,(d0(),w_));if(c.kb(mhb)){RQ(b,(d0(),T_));TQ(b,S_)}return b}
function zhb(){zhb=iI;shb=new Ahb('ONE_SIDED',0,true,false,false);whb=new Ahb('TWO_SIDED',1,false,false,false);thb=new Ahb('ONE_SIDED_BEST_OF_UP_OR_DOWN',2,true,true,false);xhb=new Ahb('TWO_SIDED_BEST_OF_UP_OR_DOWN',3,false,true,false);uhb=new Ahb('ONE_SIDED_BEST_OF_UP_OR_DOWN_ORTHOGONAL_HYPEREDGES',4,true,true,true);yhb=new Ahb('TWO_SIDED_BEST_OF_UP_OR_DOWN_ORTHOGONAL_HYPEREDGES',5,false,true,true);vhb=new Ahb('ONE_SIDED_ORTHOGONAL_HYPEREDGES',6,true,false,true);rhb=new Ahb('OFF',7,false,false,false)}
function LV(a,b,c,d,e,f,g){var h,i,j,k,l,m,n;l=Ckb(Ixb(Xv(rJ(b,(Mjb(),yjb)))));m=null;f==(djb(),ajb)&&d.c.f==c?(m=d.c):f==bjb&&d.d.f==c&&(m=d.d);j=g;if(!g||!l||!!m){k=(sN(),qN);m?(k=m.g):MM(Wv(rJ(c,(eM(),TL)),28))&&(k=f==ajb?rN:ZM);i=JV(a,b,c,f,k,d);h=IV((hX(c),d));if(f==ajb){dW(h,Wv(yU(i.f,0),7));eW(h,e)}else{dW(h,e);eW(h,Wv(yU(i.f,0),7))}j=new UV(d,h,i,Wv(rJ(i,(Rib(),uib)),7),f,!m)}else{vU(g.e,d);n=Olb(Wv(rJ(g.d,(eM(),dM)),15).a,Wv(rJ(d,dM),15).a);sJ(g.d,dM,new llb(n))}Fd(a.a,d,new XV(j.d,b,f));return j}
function T1(a,b,c,d){var e,f,g,h,i,j,k,l;f=new uX(a);sX(f,(CX(),BX));sJ(f,(eM(),TL),(KM(),FM));e=0;if(b){g=new RX;sJ(g,(Rib(),uib),b);sJ(f,uib,b.f);QX(g,(sN(),rN));PX(g,f);l=Wv(FU(b.b,xv(dB,gAb,12,b.b.c.length,0,1)),47);for(j=0,k=l.length;j<k;++j){i=l[j];eW(i,g)}sJ(b,Bib,f);++e}if(c){h=new RX;sJ(f,(Rib(),uib),c.f);sJ(h,uib,c);QX(h,(sN(),ZM));PX(h,f);l=Wv(FU(c.e,xv(dB,gAb,12,c.e.c.length,0,1)),47);for(j=0,k=l.length;j<k;++j){i=l[j];dW(i,h)}sJ(c,Bib,f);++e}sJ(f,(Rib(),aib),Elb(e));d.c[d.c.length]=f;return f}
function MV(a,b){var c,d,e,f,g,h,i;for(g=ud(a.a).mb();g.G();){f=Wv(g.H(),12);if(f.b.c.length>0){d=new IU(Wv(Dd(a.a,f),18));Gpb(d,new $V(b));e=new Fnb(f.b,0);while(e.b<e.d.Y()){c=(Bxb(e.b<e.d.Y()),Wv(e.d.sb(e.c=e.b++),33));h=-1;switch(Wv(rJ(c,(eM(),tL)),107).e){case 2:h=d.c.length-1;break;case 1:h=d.c.length/2|0;break;case 3:h=0;}if(h!=-1){i=(Cxb(h,d.c.length),Wv(d.c[h],114));vU(i.b.b,c);Wv(rJ(hX(i.b.c.f),(Rib(),jib)),18).ib((ohb(),ghb));Wv(rJ(hX(i.b.c.f),jib),18).ib(ehb);vnb(e);sJ(c,xib,f)}}}dW(f,null);eW(f,null)}}
function H7(a){var b,c,d,e,f,g,h,i,j,k,l;k=a.e.a.c.length;for(g=new Tob(a.e.a);g.a<g.c.c.length;){f=Wv(Rob(g),61);f.j=false}a.i=xv(mw,Yyb,26,k,12,1);a.g=xv(mw,Yyb,26,k,12,1);a.n=new GU;e=0;l=new GU;for(i=new Tob(a.e.a);i.a<i.c.c.length;){h=Wv(Rob(i),61);h.b=e++;h.c.c.length==0&&vU(a.n,h);xU(l,h.g)}b=0;for(d=new Tob(l);d.a<d.c.c.length;){c=Wv(Rob(d),89);c.b=b++;c.e=false}j=l.c.length;if(a.b==null||a.b.length<j){a.b=xv(kw,hyb,26,j,12,1);a.c=xv(KH,xAb,26,j,13,1)}else{dpb(a.c)}a.d=l;a.p=new Xub(op(a.d.c.length));a.j=1}
function z0(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u;p=a.d;q=b.d;n=Wv(oX(a,(djb(),ajb)).mb().H(),7);t=Wv(oX(a,bjb).mb().H(),7);o=Wv(oX(b,ajb).mb().H(),7);u=Wv(oX(b,bjb).mb().H(),7);l=Wv(FU(n.b,xv(dB,gAb,12,1,0,1)),47);r=Wv(FU(t.e,xv(dB,gAb,12,1,0,1)),47);m=Wv(FU(o.b,xv(dB,gAb,12,1,0,1)),47);s=Wv(FU(u.e,xv(dB,gAb,12,1,0,1)),47);rX(a,q);for(e=0,i=m.length;e<i;++e){c=m[e];eW(c,n)}for(f=0,j=s.length;f<j;++f){c=s[f];dW(c,t)}rX(b,p);for(g=0,k=l.length;g<k;++g){c=l[g];eW(c,o)}for(d=0,h=r.length;d<h;++d){c=r[d];dW(c,u)}}
function gR(a){var b,c,d,e,f,g,h,i;for(f=new Tob(a.a.b);f.a<f.c.c.length;){e=Wv(Rob(f),25);e.vc()}i=new HI(Uzb,Uzb);b=new HI(Vzb,Vzb);for(d=new Tob(a.a.b);d.a<d.c.c.length;){c=Wv(Rob(d),25);i.a=Qlb(i.a,c.j.d);i.b=Qlb(i.b,c.j.e);b.a=Nlb(b.a,c.j.d+c.j.c);b.b=Nlb(b.b,c.j.e+c.j.b)}for(h=Jd(a.c).mb();h.G();){g=Wv(h.H(),27);c=Wv(g.b,25);i.a=Qlb(i.a,c.j.d);i.b=Qlb(i.b,c.j.e);b.a=Nlb(b.a,c.j.d+c.j.c);b.b=Nlb(b.b,c.j.e+c.j.b)}a.d=zI(new HI(i.a,i.b));a.e=EI(new HI(b.a,b.b),i);a.a.a.c=xv(UF,syb,1,0,4,1);a.a.b.c=xv(UF,syb,1,0,4,1)}
function P$(a){var b,c,d,e,f,g,h;h=Wv(yU(a.f,0),7);if(h.e.c.length!=0&&h.b.c.length!=0){throw new ulb('Interactive layout does not support NORTH/SOUTH ports with incoming _and_ outgoing edges.')}if(h.e.c.length!=0){f=Uzb;for(c=new Tob(h.e);c.a<c.c.c.length;){b=Wv(Rob(c),12);g=b.d.f;d=Wv(rJ(g,(eM(),GL)),65);f=Qlb(f,g.i.a-d.b)}return new $c(_b(f))}if(h.b.c.length!=0){e=Vzb;for(c=new Tob(h.b);c.a<c.c.c.length;){b=Wv(Rob(c),12);g=b.c.f;d=Wv(rJ(g,(eM(),GL)),65);e=Nlb(e,g.i.a+g.j.a+d.c)}return new $c(_b(e))}return zb(),zb(),yb}
function JV(a,b,c,d,e,f){var g,h,i,j,k,l,m;j=d==(djb(),ajb)?f.c:f.d;i=PW(b);if(j.f==c){g=Wv(Smb(a.b,j),9);if(!g){g=NW(j,Wv(rJ(c,(eM(),TL)),28),e,d==ajb?-1:1,j.j,i,b);sJ(g,(Rib(),uib),j);Umb(a.b,j,g)}}else{k=Wv(rJ(f,(eM(),dM)),15).a;g=NW((l=new tJ,m=Wv(rJ(b,(Rib(),Jib)),15).a*Wv(rJ(b,(Mjb(),qjb)),15).a/2,sJ(l,tib,new llb(m)),l),Wv(rJ(c,TL),28),e,d==ajb?-1:1,new HI(k,k),i,b);h=KV(a,g,c,d);sJ(g,uib,h);Umb(a.b,h,g)}Wv(rJ(b,(Rib(),jib)),18).ib((ohb(),hhb));MM(Wv(rJ(b,(eM(),TL)),28))?sJ(b,TL,(KM(),HM)):sJ(b,TL,(KM(),IM));return g}
function Iab(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;d=Wv(rJ(b,(Mjb(),wjb)),15).a;v=Wv(rJ(b,Kjb),24).a;m=4;e=3;w=20/v;n=false;i=0;g=$xb;do{f=i!=1;l=i!=0;A=0;for(q=a.a,s=0,u=q.length;s<u;++s){o=q[s];o.g=null;Jab(a,o,f,l,d);A+=Jlb(o.a)}do{h=Nab(a,b)}while(h);for(p=a.a,r=0,t=p.length;r<t;++r){o=p[r];c=Uab(o).a;if(c!=0){for(k=new Tob(o.f);k.a<k.c.c.length;){j=Wv(Rob(k),9);j.i.b+=c}}}if(i==0||i==1){--m;if(m<=0&&(A<g||-m>v)){i=2;g=$xb}else if(i==0){i=1;g=A}else{i=0;g=A}}else{n=A>=g||g-A<w;g=A;n&&--e}}while(!(n&&e<=0))}
function vZ(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;l=Wv(FU(a.f,xv(BB,mAb,7,a.f.c.length,0,1)),346);for(j=0,k=l.length;j<k;++j){i=l[j];if(c!=(djb(),ajb)){h=Wv(FU(i.e,xv(dB,gAb,12,i.e.c.length,0,1)),47);for(e=0,f=h.length;e<f;++e){d=h[e];n=Wv(rJ(d.d.f,(Mjb(),vjb)),85);!Ckb(Ixb(Xv(rJ(d,(Rib(),Iib)))))&&!(b==(Xib(),Uib)&&n==Vib)&&cW(d,true)}}if(c!=bjb){g=Wv(FU(i.b,xv(dB,gAb,12,i.b.c.length,0,1)),47);for(e=0,f=g.length;e<f;++e){d=g[e];m=Wv(rJ(d.c.f,(Mjb(),vjb)),85);!Ckb(Ixb(Xv(rJ(d,(Rib(),Iib)))))&&!(b==(Xib(),Sib)&&m==Tib)&&cW(d,true)}}}}
function RW(a,b,c,d){var e,f,g,h,i;g=a.g;if(g==(sN(),qN)&&b!=(KM(),IM)&&b!=(KM(),JM)){g=KW(a,c);QX(a,g);rJ(a,(eM(),LL))==null&&g!=qN&&(a.i.a!=0||a.i.b!=0)&&sJ(a,LL,new llb(JW(a,g)))}if(b==(KM(),GM)){i=0;switch(g.e){case 1:case 3:f=a.f.j.a;f>0&&(i=a.i.a/f);break;case 2:case 4:e=a.f.j.b;e>0&&(i=a.i.b/e);}sJ(a,(Rib(),Cib),i)}h=a.j;if(d){a.a.a=d.a;a.a.b=d.b}else if(b!=IM&&b!=JM&&g!=qN){switch(g.e){case 1:a.a.a=h.a/2;break;case 2:a.a.a=h.a;a.a.b=h.b/2;break;case 3:a.a.a=h.a/2;a.a.b=h.b;break;case 4:a.a.b=h.b/2;}}else{a.a.a=h.a/2;a.a.b=h.b/2}}
function zJ(a){var b,c,d,e;if(aw(a.a,10)){return xI(Wv(a.a,10))}else if(aw(a.a,66)){return Xsb(Wv(a.a,86))}else if(aw(a.a,50)){return Wv(a.a,50).Wc()}else if(aw(a.a,191)){b=new Vwb;e=(d=new rwb((new wwb((new Gob(Wv(a.a,191).a)).a)).b),new Mob(d));while(Bnb(e.a.a)){Rwb(b,(c=pwb(e.a),c.yb()))}return b}else if(aw(a.a,13)){return new IU(Wv(a.a,13))}else if(aw(a.a,44)){b=new jJ;e=WI(Wv(a.a,44),0);while(e.b!=e.d.c){QI(b,Wv(_ub(e),10))}return b}else if(aw(a.a,58)){b=new aJ;e=WI(Wv(a.a,58),0);while(e.b!=e.d.c){QI(b,_ub(e))}return b}else{return a.a}}
function o1(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;h=0;o=0;i=Xob(a.f,a.f.length);f=a.d;g=a.i;d=a.a;e=a.b;do{n=0;for(k=new Tob(a.p);k.a<k.c.c.length;){j=Wv(Rob(k),9);m=n1(a,j);c=true;(a.q==(I1(),B1)||a.q==E1)&&(c=Ckb(Ixb(Xv(m.b))));if(Wv(m.a,24).a<0&&c){++n;i=Xob(a.f,a.f.length);a.d=a.d+Wv(m.a,24).a;o+=f-a.d;f=a.d+Wv(m.a,24).a;g=a.i;d=Ao(a.a);e=Ao(a.b)}else{a.f=Xob(i,i.length);a.d=f;a.a=(_b(d),d?new IU((Oh(),d)):Bo(new Tob(null)));a.b=(_b(e),e?new IU((Oh(),e)):Bo(new Tob(null)));a.i=g}}++h;l=n!=0&&Ckb(Ixb(Xv(b.B(new RJ(Elb(o),Elb(h))))))}while(l)}
function yO(a,b,c,d){var e,f,g,h,i,j,k;if(!Qob(new Tob(zW(a)))){return d}k=wO(Wv(oW(a,(eM(),JL)),86));for(i=new Tob(zW(a));i.a<i.c.c.length;){h=Wv(Rob(i),129);j=wO(Wv(oW(h,JL),86));j==(uO(),tO)&&(j=k);qW(h,j.e);e=zO(c,j);e.c=Nlb(e.c,h.e.j.a);e.b+=h.e.j.b+b}for(g=new Lsb((new Fsb(c)).a);htb(g.a);){f=(g.b=itb(g.a),new Psb(g.c,g.b));e=Wv(f.b.b[f.a.e],62);e.b-=b;switch(Wv(f.a,67).e){case 12:case 13:case 14:d.d=Nlb(d.d,e.b+b);break;case 15:d.b=Nlb(d.b,e.c+b);break;case 17:d.c=Nlb(d.c,e.c+b);break;case 18:case 19:case 20:d.a=Nlb(d.a,e.b+b);}}return d}
function mgb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;igb(this);c==(fgb(),dgb)?stb(this.g,a):stb(this.o,a);n=rAb;m=4.9E-324;for(j=(g=(new Snb(b.a)).a.bb().mb(),new Ynb(g));j.a.G();){h=(e=Wv(j.a.H(),21),Wv(e.yb(),27));k=Wv(h.a,223);d=Wv(h.b,12);l=d.c;l==a&&(l=d.d);k==dgb?stb(this.g,l):stb(this.o,l);p=MI(Bv(tv(qz,1),Fzb,10,0,[l.f.i,l.i,l.a])).b;n=n<p?n:p;m=m>p?m:p}o=MI(Bv(tv(qz,1),Fzb,10,0,[a.f.i,a.i,a.a])).b;kgb(this,o,n,m);for(i=(f=(new Snb(b.a)).a.bb().mb(),new Ynb(f));i.a.G();){h=(e=Wv(i.a.H(),21),Wv(e.yb(),27));stb(this.c,Wv(h.b,12))}this.f=false}
function cQ(a,b,c,d){var e,f,g,h,i,j;h=(eM(),KL).b;if(h in b.a&&Pu(b,h).ic().a){return}j=Pu(b,Dzb);if(!j){throw new GQ("Labels must have a property 'text'.",null,b)}else if(!j.lc()){throw new GQ("A label's 'text' property must be a string.",j,b)}i=j.lc().a;f=new dX(i);sJ(f,(Rib(),uib),b);Umb(a.f,f,b);_P(b,f);hQ(b,f);aw(c,9)?vU(Wv(c,9).c,f):aw(c,12)?vU(Wv(c,12).b,f):aw(c,7)&&vU(Wv(c,7).c,f);if(aw(c,12)){g=Wv(rJ(f,tL),107);_P(b,f);sJ(f,tL,g);e=Wv(rJ(d,jib),18);switch(g.e){case 2:case 3:e.ib((ohb(),ghb));case 1:case 0:e.ib((ohb(),ehb));sJ(f,tL,(EK(),AK));}}}
function UW(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;f=0;g=0;for(j=new Tob(a.a);j.a<j.c.c.length;){h=Wv(Rob(j),9);f=Nlb(f,h.e.b);g=Nlb(g,h.e.c)}for(i=new Tob(a.a);i.a<i.c.c.length;){h=Wv(Rob(i),9);c=Wv(rJ(h,(eM(),lL)),103);switch(c.e){case 1:o=0;break;case 2:o=1;break;case 5:o=0.5;break;default:d=0;l=0;for(n=new Tob(h.f);n.a<n.c.c.length;){m=Wv(Rob(n),7);m.b.c.length==0||++d;m.e.c.length==0||++l}d+l==0?(o=0.5):(o=l/(d+l));}q=a.c;k=h.j.a;r=(q.a-k)*o;o>0.5?(r-=g*2*(o-0.5)):o<0.5&&(r+=f*2*(0.5-o));e=h.e.b;r<e&&(r=e);p=h.e.c;r>q.a-p-k&&(r=q.a-p-k);h.i.a=b+r}}
function Kv(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G;c=a.l&8191;d=a.l>>13|(a.m&15)<<9;e=a.m>>4&8191;f=a.m>>17|(a.h&255)<<5;g=(a.h&1048320)>>8;h=b.l&8191;i=b.l>>13|(b.m&15)<<9;j=b.m>>4&8191;k=b.m>>17|(b.h&255)<<5;l=(b.h&1048320)>>8;B=c*h;C=d*h;D=e*h;F=f*h;G=g*h;if(i!=0){C+=c*i;D+=d*i;F+=e*i;G+=f*i}if(j!=0){D+=c*j;F+=d*j;G+=e*j}if(k!=0){F+=c*k;G+=d*k}l!=0&&(G+=c*l);n=B&azb;o=(C&511)<<13;m=n+o;q=B>>22;r=C>>9;s=(D&262143)<<4;t=(F&31)<<17;p=q+r+s+t;v=D>>18;w=F>>5;A=(G&4095)<<8;u=v+w+A;p+=m>>22;m&=azb;u+=p>>22;p&=azb;u&=bzb;return Ev(m,p,u)}
function jZ(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;q=a.d.c.c.c.length;if(c>=q-1){return null}e=new GU;e.c[e.c.length]=b;u=b;g=c;o=-1;h=Wv(yU(a.d.c.c,c),16);for(n=0;n<h.a.c.length;++n){r=Wv(yU(h.a,n),9);if(r==b){o=n;break}}p=eZ(a,1,o,c,q,a.a);if(!p){return null}v=a.a;m=0;f=0;while(!!u&&v>1&&g<q-1){k=fZ(a,u);l=Wv(yU(a.d.c.c,g+1),16);w=Wv(p.sb(m++),24).a;s=Slb(w,l.a.c.length);qX(k,s,l);!!u&&(e.c[e.c.length]=u,true);u=k;--v;++f;++g}t=(d-(e.c.length-1)*a.d.d)/e.c.length;for(j=new Tob(e);j.a<j.c.c.length;){i=Wv(Rob(j),9);i.j.a=t}return new RJ(Elb(f),t)}
function iZ(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;if(c<=0){return null}e=new GU;e.c[e.c.length]=b;u=b;g=c;o=-1;h=Wv(yU(a.d.c.c,c),16);for(n=0;n<h.a.c.length;++n){q=Wv(yU(h.a,n),9);if(q==b){o=n;break}}p=eZ(a,0,o,c,a.d.c.c.c.length,a.a);if(!p){return null}v=a.a;m=0;f=0;t=o;while(!!u&&v>1&&g>1){k=fZ(a,u);h=Wv(yU(a.d.c.c,g),16);l=Wv(yU(a.d.c.c,g-1),16);w=Wv(p.sb(m++),24).a;r=Slb(w,l.a.c.length);qX(u,r,l);qX(k,t,h);t=r;!!u&&(e.c[e.c.length]=u,true);u=k;--v;++f;--g}s=(d-(e.c.length-1)*a.d.d)/e.c.length;for(j=new Tob(e);j.a<j.c.c.length;){i=Wv(Rob(j),9);i.j.a=s}return new RJ(Elb(f),s)}
function sV(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;a.b=a.c;o=Xv(rJ(b,(eM(),_L)));n=o==null||Ckb((Dxb(o),o));f=Wv(rJ(b,(Rib(),jib)),18).kb((ohb(),hhb));e=Wv(rJ(b,TL),28);c=!(e==(KM(),EM)||e==GM||e==FM);if(n&&(c||!f)){for(l=new Tob(b.b);l.a<l.c.c.length;){j=Wv(Rob(l),9);j.k=0}m=new GU;for(k=new Tob(b.b);k.a<k.c.c.length;){j=Wv(Rob(k),9);d=rV(a,j,null);if(d){i=new kW;qJ(i,b);sJ(i,fib,Wv(d.b,18));YW(i.a,b.a);for(h=Wv(d.a,20).mb();h.G();){g=Wv(h.H(),9);vU(i.b,g);g.a=i}m.ib(i)}}f&&(a.b=a.a)}else{m=new opb(Bv(tv(mB,1),{38:1,39:1,42:1,3:1,8:1,5:1,6:1},55,0,[b]))}return m}
function T4(a){var b,c,d,e,f,g,h,i,j;for(c=new Tob(a.a.a.b);c.a<c.c.c.length;){b=Wv(Rob(c),25);for(g=b.i.mb();g.G();){f=Wv(g.H(),25);if(b.f==f.f){continue}tK(a.a.d)?(i=a.a.g.tc(b,f)):(i=a.a.g.uc(b,f));d=b.g.a+b.j.c+i-f.g.a;d=Math.ceil(d);d=0>d?0:d;if(!!b.o&&!!f.o&&aw(b,82)&&aw(f,82)&&!sr(or(Wv(b,82).d,Wv(f,82).d))){e=x7(new A7,a.d);h=hw(Llb(f.g.a-b.g.a));f7(i7(h7(j7(g7(new k7,0>h?0:h),1),e),a.c[b.f.d]));f7(i7(h7(j7(g7(new k7,0>-h?0:-h),1),e),a.c[f.f.d]))}else{j=1;(aw(b,82)&&aw(f,93)||aw(f,82)&&aw(b,93))&&(j=2);f7(i7(h7(j7(g7(new k7,hw(d)),j),a.c[b.f.d]),a.c[f.f.d]))}}}}
function tQ(){tQ=iI;sQ=new vtb;rQ=uQ(Bv(tv(rz,1),syb,79,0,[(eM(),kL),xL]));oQ=uQ(Bv(tv(rz,1),syb,79,0,[ML,UL,(Mjb(),Hjb),yL,(Rib(),Eib),Kjb,Cjb]));kQ=uQ(Bv(tv(rz,1),syb,79,0,[mL,qL,KL,wL,BL,EL,FL,$L,_L,AL,gjb,mjb,njb,xjb,rjb,yjb,Ijb,Djb,ijb]));nQ=uQ(Bv(tv(rz,1),syb,79,0,[IL,HL,DL,dM,LL,Dib,Xhb,Rhb,Jib,Ejb,qjb,wjb]));mQ=uQ(Bv(tv(rz,1),syb,79,0,[WL,lL,sL,uL,tL,vL,zL,NL,OL,PL,QL,RL,TL,VL,hjb,ljb,zjb,ojb,kjb,Ajb,Bjb,sjb,tjb,vjb,Fjb,Gjb,Jjb,Ljb,ujb]));lQ=uQ(Bv(tv(rz,1),syb,79,0,[JL,aM,bM,jjb]));qQ=uQ(Bv(tv(rz,1),syb,79,0,[jL,oL,CL,GL,SL,YL]));pQ=uQ(Bv(tv(rz,1),syb,79,0,[(RP(),OP)]))}
function AR(a){var b,c,d,e,f,g,h;b=0;for(f=new Tob(a.b.a);f.a<f.c.c.length;){d=Wv(Rob(f),78);d.b=0;d.c=0}zR(a,0);yR(a,a.g);fS(a.c);jS(a.c);c=(sK(),oK);hS(bS(gS(hS(bS(gS(hS(gS(a.c,c)),vK(c)))),c)));gS(a.c,oK);DR(a,a.g);ER(a,0);FR(a,0);GR(a,1);zR(a,1);yR(a,a.d);fS(a.c);for(g=new Tob(a.b.a);g.a<g.c.c.length;){d=Wv(Rob(g),78);b+=Jlb(d.c)}for(h=new Tob(a.b.a);h.a<h.c.c.length;){d=Wv(Rob(h),78);d.b=0;d.c=0}c=rK;hS(bS(gS(hS(bS(gS(hS(jS(gS(a.c,c))),vK(c)))),c)));gS(a.c,oK);DR(a,a.d);ER(a,1);FR(a,1);GR(a,0);jS(a.c);for(e=new Tob(a.b.a);e.a<e.c.c.length;){d=Wv(Rob(e),78);b+=Jlb(d.c)}return b}
function BR(a){var b,c,d,e,f,g,h;b=new GU;a.g=new GU;a.d=new GU;for(g=new rnb((new inb(a.f.b)).a);g.b;){f=pnb(g);vU(b,Wv(Wv(f.zb(),27).b,25));tK(Wv(f.yb(),251).yc())?vU(a.d,Wv(f.zb(),27)):vU(a.g,Wv(f.zb(),27))}yR(a,a.d);yR(a,a.g);a.c=new rS(a.b);pS(a.c,(fR(),eR));DR(a,a.d);DR(a,a.g);xU(b,a.c.a.b);a.e=new HI(Uzb,Uzb);a.a=new HI(Vzb,Vzb);for(d=new Tob(b);d.a<d.c.c.length;){c=Wv(Rob(d),25);a.e.a=Qlb(a.e.a,c.j.d);a.e.b=Qlb(a.e.b,c.j.e);a.a.a=Nlb(a.a.a,c.j.d+c.j.c);a.a.b=Nlb(a.a.b,c.j.e+c.j.b)}oS(a.c,new IR);h=0;do{e=AR(a);++h}while((h<2||e>$yb)&&h<10);oS(a.c,new KR);AR(a);iS(a.c);gR(a.f)}
function tT(a){oT();var b,c,d,e,f,g,h;h=new qT;for(c=new Tob(a);c.a<c.c.c.length;){b=Wv(Rob(c),48);(!h.b||b.c>=h.b.c)&&(h.b=b);if(!h.c||b.c<=h.c.c){h.d=h.c;h.c=b}(!h.e||b.d>=h.e.d)&&(h.e=b);(!h.f||b.d<=h.f.d)&&(h.f=b)}d=new xT((cT(),$S));RT(a,mT,new opb(Bv(tv(JA,1),syb,160,0,[d])));g=new xT(bT);RT(a,lT,new opb(Bv(tv(JA,1),syb,160,0,[g])));e=new xT(_S);RT(a,kT,new opb(Bv(tv(JA,1),syb,160,0,[e])));f=new xT(aT);RT(a,jT,new opb(Bv(tv(JA,1),syb,160,0,[f])));rT(d.c,$S);rT(e.c,_S);rT(f.c,aT);rT(g.c,bT);h.a.c=xv(UF,syb,1,0,4,1);xU(h.a,d.c);xU(h.a,Fo(e.c));xU(h.a,f.c);xU(h.a,Fo(g.c));return h}
function $O(a){var b,c,d,e,f,g,h,i,j,k;e=Wv(vW(a,(eM(),DL)),15).a;for(h=new Tob(uW(a));h.a<h.c.c.length;){g=Wv(Rob(h),626);c=new fP(g);c.d=e;c.k=Wv(oW(g,XL),15).a;d=Wv(oW(g,VL),149);b=Ckb(Ixb(Xv(rJ(Wv(g.e,9),(Rib(),$hb)))));for(k=new Tob(AW(g));k.a<k.c.c.length;){j=Wv(Rob(k),161);d==(UM(),SM)?XO(j,b,e):d==TM&&YO(j,e);JO(j)}LO(c,Wv(oW(g,aM),86).kb((DN(),CN)));NO(c);yO(c.e,c.d,c.c,c.p);_O(c);ZO(c);VO(c);i=new CP((f=Wv(g.e,9).b,new BP(f.d,f.b,f.a,f.c)));i.b=c.p.b+c.q.b;i.c=c.p.c+c.q.c;i.d=c.p.d+c.q.d;i.a=c.p.a+c.q.a;Wv(g.e,9).b.b=i.b;Wv(g.e,9).b.d=i.d;Wv(g.e,9).b.c=i.c;Wv(g.e,9).b.a=i.a}}
function c1(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;i=Wv(nX(a,(sN(),rN)).mb().H(),7).b;n=Wv(nX(a,ZM).mb().H(),7).e;h=i.c.length;t=MX(Wv(yU(a.f,0),7));while(h-->0){p=(Cxb(0,i.c.length),Wv(i.c[0],12));e=(Cxb(0,n.c.length),Wv(n.c[0],12));s=e.d.b;f=zU(s,e,0);fW(p,e.d,f);dW(e,null);eW(e,null);o=p.a;b&&QI(o,new II(t));for(d=WI(e.a,0);d.b!=d.d.c;){c=Wv(_ub(d),10);QI(o,new II(c))}r=p.b;for(m=new Tob(e.b);m.a<m.c.c.length;){l=Wv(Rob(m),33);r.c[r.c.length]=l}q=Wv(rJ(p,(eM(),CL)),44);g=Wv(rJ(e,CL),44);if(g){if(!q){q=new jJ;sJ(p,CL,q)}for(k=WI(g,0);k.b!=k.d.c;){j=Wv(_ub(k),10);QI(q,new II(j))}}}}
function XO(a,b,c){var d,e,f,g,h;f=Li(DW(a));if(f.Nb().V()){return}h=0;switch(Wv(a.e,7).g.e){case 4:case 2:h=b&&Ckb(Ixb(Xv(rJ(Wv(a.e,7),(Rib(),lib)))))?a.e.j.b:(a.e.j.b-Wv(f.Nb().sb(0),129).pc().b)/2-c;break;case 1:h=a.e.j.b;break;case 3:h=0;}Wv(a.e,7).g==(sN(),pN)&&Ii(f);for(e=new Tob(DW(a));e.a<e.c.c.length;){d=Wv(Rob(e),129);g=new II(a.e.i);switch(Wv(a.e,7).g.e){case 4:g.a=a.e.j.a+c;g.b=h+c;h+=c+d.e.j.b;break;case 2:g.a=-d.e.j.a-c;g.b=h+c;h+=c+d.e.j.b;break;case 1:g.a=(a.e.j.a-d.e.j.a)/2;g.b=h+c;h+=c+d.e.j.b;break;case 3:g.a=(a.e.j.a-d.e.j.a)/2;g.b=h-c-d.e.j.b;h-=c+d.e.j.b;}d.e.i.a=g.a;d.e.i.b=g.b}}
function jR(a,b){var c,d,e,f,g,h,i,j,k,l;a.a=new NR(Tsb(Bz));for(d=new Tob(b.a);d.a<d.c.c.length;){c=Wv(Rob(d),347);h=new QR(Bv(tv(kA,1),syb,25,0,[]));vU(a.a.a,h);for(j=new Tob(c.d);j.a<j.c.c.length;){i=Wv(Rob(j),62);k=new pR(a,i);iR(k,Wv(rJ(c.c,(Rib(),fib)),18));if(!Qmb(a.g,c)){Umb(a.g,c,new HI(i.d,i.e));Umb(a.f,c,k)}vU(a.a.b,k);OR(h,k)}for(g=new Tob(c.b);g.a<g.c.c.length;){f=Wv(Rob(g),251);k=new pR(a,f.Bc());Umb(a.b,f,new RJ(h,k));iR(k,Wv(rJ(c.c,(Rib(),fib)),18));if(f.zc()){l=new qR(a,f.zc(),1);iR(l,Wv(rJ(c.c,fib),18));e=new QR(Bv(tv(kA,1),syb,25,0,[]));OR(e,l);Fd(a.c,f.yc(),new RJ(h,l))}}}return a.a}
function ccb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;p=b.c.c.length;if(p<3){return}n=xv(mw,Yyb,26,p,12,1);l=0;for(k=new Tob(b.c);k.a<k.c.c.length;){j=Wv(Rob(k),16);n[l++]=j.a.c.length}m=new Fnb(b.c,2);for(d=1;d<p-1;d++){c=(Bxb(m.b<m.d.Y()),Wv(m.d.sb(m.c=m.b++),16));o=new Tob(c.a);f=0;h=0;for(i=0;i<n[d+1];i++){t=Wv(Rob(o),9);if(i==n[d+1]-1||bcb(a,t,d+1,d)){g=n[d]-1;bcb(a,t,d+1,d)&&(g=a.d.e[Wv(Wv(Wv(yU(a.d.b,t.k),20).sb(0),27).a,9).k]);while(h<=i){s=Wv(yU(c.a,h),9);if(!bcb(a,s,d+1,d)){for(r=Wv(yU(a.d.b,s.k),20).mb();r.G();){q=Wv(r.H(),27);e=a.d.e[Wv(q.a,9).k];(e<f||e>g)&&stb(a.c,Wv(q.b,12))}}++h}f=g}}}}
function _9(a,b,c){var d,e,f,g,h,i;this.g=a;h=b.d.length;i=c.d.length;this.d=xv(qB,Nzb,9,h+i,0,1);for(g=0;g<h;g++){this.d[g]=b.d[g]}for(f=0;f<i;f++){this.d[h+f]=c.d[f]}if(b.e){this.e=Eo(b.e);this.e.nb(c);if(c.e){for(e=c.e.mb();e.G();){d=Wv(e.H(),102);if(d==b){continue}else this.e.kb(d)?--d.c:this.e.ib(d)}}}else if(c.e){this.e=Eo(c.e);this.e.nb(b)}this.f=b.f+c.f;this.a=b.a+c.a;this.a>0?Z9(this,this.f/this.a):W9(b.g,b.d[0]).a!=null&&W9(c.g,c.d[0]).a!=null?Z9(this,(Ixb(W9(b.g,b.d[0]).a)+Ixb(W9(c.g,c.d[0]).a))/2):W9(b.g,b.d[0]).a!=null?Z9(this,W9(b.g,b.d[0]).a):W9(c.g,c.d[0]).a!=null&&Z9(this,W9(c.g,c.d[0]).a)}
function x9(a,b){var c,d,e,f,g,h,i,j,k,l,m;switch(a.g.e){case 1:d=Wv(rJ(a,(Rib(),uib)),12);c=Wv(rJ(d,vib),44);!c?(c=new jJ):Ckb(Ixb(Xv(rJ(d,Iib))))&&(c=lJ(c));j=Wv(rJ(a,qib),7);k=MI(Bv(tv(qz,1),Fzb,10,0,[j.f.i,j.i,j.a]));if(b<=k.a){return k.b}TI(c,k,c.a,c.a.a);l=Wv(rJ(a,rib),7);m=MI(Bv(tv(qz,1),Fzb,10,0,[l.f.i,l.i,l.a]));if(m.a<=b){return m.b}TI(c,m,c.c.b,c.c);i=WI(c,0);g=Wv(_ub(i),10);h=Wv(_ub(i),10);while(h.a<b&&i.b!=i.d.c){g=h;h=Wv(_ub(i),10)}return g.b+(b-g.a)/(h.a-g.a)*(h.b-g.b);case 3:f=Wv(rJ(Wv(yU(a.f,0),7),(Rib(),uib)),7);e=f.f;switch(f.g.e){case 1:return e.i.b;case 3:return e.i.b+e.j.b;}}return kX(a).b}
function KP(a){var b,c,d,e,f,g,h,i,j,k,l,m;k=gw(rJ(a.c.f,(Rib(),sib)))===gw(rJ(a.d.f,sib));g=new FI;c=Wv(rJ(a,(eM(),oL)),44);if(!!c&&c.b>=2){_I(a.a);d=0;for(m=WI(c,0);m.b!=m.d.c;){l=Wv(_ub(m),10);if(d==0){b=EI(EI(new HI(l.a,l.b),a.c.i),a.c.f.i);a.c.a.a=b.a;a.c.a.b=b.b}else if(d==c.b-1){b=EI(EI(new HI(l.a,l.b),a.d.i),a.d.f.i);a.d.a.a=b.a;a.d.a.b=b.b}else{QI(a.a,l)}++d}}if(k){for(i=WI(a.a,0);i.b!=i.d.c;){h=Wv(_ub(i),10);g.a=Nlb(g.a,h.a);g.b=Nlb(g.b,h.b)}}for(f=new Tob(a.b);f.a<f.c.c.length;){e=Wv(Rob(f),33);j=Wv(rJ(e,YL),10);if(j){e.i.a=j.a;e.i.b=j.b}if(k){g.a=Nlb(g.a,e.i.a+e.j.a);g.b=Nlb(g.b,e.i.b+e.j.b)}}return g}
function eQ(a,b,c){var d,e,f,g,h,i,j;SP(b);d=Wv(rJ(c,(Rib(),jib)),18);g=new uX(c);sJ(g,uib,b);vU(c.b,g);f=Wv(Pu(b,'id'),97);Vmb(a.i,f.a,g);Umb(a.j,g,b);_P(b,g);hQ(b,g);if('ports' in b.a){j=Pu(b,'ports');if(!j.hc()){throw new GQ("The 'ports' property of the node must be an array.",j,b)}i=j.hc();for(e=0;e<i.a.length;++e){aw(gu(i,e),69)&&gQ(a,Wv(gu(i,e),69),g,c)}}dQ(a,b,g,c);Mzb in b.a&&Pu(b,Mzb).hc().a.length>0&&sJ(g,$hb,(xkb(),xkb(),wkb));h=Wv(rJ(g,(eM(),TL)),28);h==(KM(),JM)?IM:h!=IM&&d.ib((ohb(),khb));Ckb(Ixb(Xv(rJ(g,qL))))&&d.ib((ohb(),fhb));if(Ckb(Ixb(Xv(rJ(g,AL))))){d.ib((ohb(),jhb));d.ib(ihb);sJ(g,TL,IM)}return g}
function iR(a,b){b.V()&&wS(a.n,true,true,true,true);b.t((sN(),eN))&&wS(a.n,true,true,true,false);b.t(_M)&&wS(a.n,false,true,true,true);b.t(mN)&&wS(a.n,true,true,false,true);b.t(oN)&&wS(a.n,true,false,true,true);b.t(fN)&&wS(a.n,false,true,true,false);b.t(aN)&&wS(a.n,false,true,false,true);b.t(nN)&&wS(a.n,true,false,false,true);b.t(lN)&&wS(a.n,true,false,true,false);b.t(jN)&&wS(a.n,true,true,true,true);b.t(cN)&&wS(a.n,true,true,true,true);b.t(jN)&&wS(a.n,true,true,true,true);b.t(bN)&&wS(a.n,true,true,true,true);b.t(kN)&&wS(a.n,true,true,true,true);b.t(iN)&&wS(a.n,true,true,true,true);b.t(hN)&&wS(a.n,true,true,true,true)}
function n1(a,b){var c,d,e,f,g,h,i,j,k,l;i=true;e=0;j=a.f[b.k];k=b.j.b+a.n;c=a.c[b.k][2];DU(a.a,j,Elb(Wv(yU(a.a,j),24).a-1+c));DU(a.b,j,Ixb(Yv(yU(a.b,j)))-k+c*a.e);++j;if(j>=a.i){++a.i;vU(a.a,Elb(1));vU(a.b,k)}else{d=a.c[b.k][1];DU(a.a,j,Elb(Wv(yU(a.a,j),24).a+1-d));DU(a.b,j,Ixb(Yv(yU(a.b,j)))+k-d*a.e)}(a.q==(I1(),B1)&&(Wv(yU(a.a,j),24).a>a.j||Wv(yU(a.a,j-1),24).a>a.j)||a.q==E1&&(Ixb(Yv(yU(a.b,j)))>a.k||Ixb(Yv(yU(a.b,j-1)))>a.k))&&(i=false);for(g=Uh(iX(b));Cm(g);){f=Wv(Dm(g),12);h=f.c.f;if(a.f[h.k]==j){l=n1(a,h);e=e+Wv(l.a,24).a;i=i&&Ckb(Ixb(Xv(l.b)))}}a.f[b.k]=j;e=e+a.c[b.k][0];return new RJ(Elb(e),(xkb(),i?wkb:vkb))}
function WW(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;m=new II(a.j);r=b.a/m.a;h=b.b/m.b;p=b.a-m.a;f=b.b-m.b;if(c){e=gw(rJ(a,(eM(),TL)))===gw((KM(),FM));for(o=new Tob(a.f);o.a<o.c.c.length;){n=Wv(Rob(o),7);switch(n.g.e){case 1:e||(n.i.a*=r);break;case 2:n.i.a+=p;e||(n.i.b*=h);break;case 3:e||(n.i.a*=r);n.i.b+=f;break;case 4:e||(n.i.b*=h);}}}for(j=new Tob(a.c);j.a<j.c.c.length;){i=Wv(Rob(j),33);k=i.i.a+i.j.a/2;l=i.i.b+i.j.b/2;q=k/m.a;g=l/m.b;if(q+g>=1){if(q-g>0&&l>=0){i.i.a+=p;i.i.b+=f*g}else if(q-g<0&&k>=0){i.i.a+=p*q;i.i.b+=f}}}a.j.a=b.a;a.j.b=b.b;sJ(a,(eM(),aM),(DN(),d=Wv(Hkb(Lz),11),new atb(d,Wv(exb(d,d.length),11),0)))}
function C7(a){var b,c,d,e,f,g,h,i,j,k;d=new GU;for(g=new Tob(a.e.a);g.a<g.c.c.length;){e=Wv(Rob(g),61);k=0;e.k.c=xv(UF,syb,1,0,4,1);for(c=new Tob(m7(e));c.a<c.c.c.length;){b=Wv(Rob(c),89);if(b.e){vU(e.k,b);++k}}k==1&&(d.c[d.c.length]=e,true)}for(f=new Tob(d);f.a<f.c.c.length;){e=Wv(Rob(f),61);while(e.k.c.length==1){j=Wv(Rob(new Tob(e.k)),89);a.b[j.b]=j.f;h=j.c;i=j.d;for(c=new Tob(m7(e));c.a<c.c.c.length;){b=Wv(Rob(c),89);b==j||(b.e?h==b.c||i==b.d?(a.b[j.b]-=a.b[b.b]-b.f):(a.b[j.b]+=a.b[b.b]-b.f):e==h?b.c==e?(a.b[j.b]+=b.f):(a.b[j.b]-=b.f):b.c==e?(a.b[j.b]-=b.f):(a.b[j.b]+=b.f))}BU(h.k,j);BU(i.k,j);h==e?(e=j.d):(e=j.c)}}}
function _fb(a){var b,c,d,e,f,g,h,i,j,k;j=new aJ;h=new aJ;for(f=new Tob(a);f.a<f.c.c.length;){d=Wv(Rob(f),77);d.e=d.d.c.length;d.k=d.j.c.length;d.e==0&&(TI(j,d,j.c.b,j.c),true);d.k==0&&d.g.a.Y()==0&&(TI(h,d,h.c.b,h.c),true)}g=-1;while(j.b!=0){d=Wv(un(j,0),77);for(c=new Tob(d.j);c.a<c.c.c.length;){b=Wv(Rob(c),117);k=b.b;k.n=Plb(k.n,d.n+1);g=Plb(g,k.n);--k.e;k.e==0&&(TI(j,k,j.c.b,j.c),true)}}if(g>-1){for(e=WI(h,0);e.b!=e.d.c;){d=Wv(_ub(e),77);d.n=g}while(h.b!=0){d=Wv(un(h,0),77);for(c=new Tob(d.d);c.a<c.c.c.length;){b=Wv(Rob(c),117);i=b.a;if(i.g.a.Y()!=0){continue}i.n=Slb(i.n,d.n-1);--i.k;i.k==0&&(TI(h,i,h.c.b,h.c),true)}}}}
function QV(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;i=new GU;for(f=new Tob(b.b);f.a<f.c.c.length;){e=Wv(Rob(f),9);for(h=new Tob(e.f);h.a<h.c.c.length;){g=Wv(Rob(h),7);k=null;for(t=Wv(FU(g.e,xv(dB,gAb,12,0,0,1)),47),u=0,v=t.length;u<v;++u){s=t[u];if(!SW(s.d.f,c)){r=LV(a,b,c,s,s.c,(djb(),bjb),k);r!=k&&(i.c[i.c.length]=r,true);r.c&&(k=r)}}j=null;for(o=Wv(FU(g.b,xv(dB,gAb,12,0,0,1)),47),p=0,q=o.length;p<q;++p){n=o[p];if(!SW(n.c.f,c)){r=LV(a,b,c,n,n.d,(djb(),ajb),j);r!=j&&(i.c[i.c.length]=r,true);r.c&&(j=r)}}}}for(m=new Tob(i);m.a<m.c.c.length;){l=Wv(Rob(m),187);zU(b.b,l.a,0)!=-1||vU(b.b,l.a);l.c&&(d.c[d.c.length]=l,true)}}
function WO(a){var b,c,d,e,f,g,h,i,j;d=a.e.e.j;b=Wv(oW(a.e,(eM(),aM)),86).kb((DN(),CN));PO(a);for(f=new Tob(AW(a.e));f.a<f.c.c.length;){e=Wv(Rob(f),161);h=Wv(oW(e,LL),15);!h&&(h=new llb(0));i=e.e.j;g=(c=Wv(e.e,7).d,new EP(c.d,c.b,c.a,c.c));j=new II(e.e.i);switch(Wv(e.e,7).g.e){case 4:j.a=-i.a-h.a;j.b=a.s-i.b-(b?g.a:0);a.s-=cP(a,(sN(),rN))+i.b+(b?g.d+g.a:0);break;case 2:j.a=d.a+h.a;j.b=a.a+(b?g.d:0);a.a+=cP(a,(sN(),ZM))+i.b+(b?g.d+g.a:0);break;case 1:j.a=a.f+(b?g.b:0);j.b=-e.e.j.b-h.a;a.f+=cP(a,(sN(),$M))+i.a+(b?g.b+g.c:0);break;case 3:j.a=a.r-i.a-(b?g.c:0);j.b=d.b+h.a;a.r-=cP(a,(sN(),pN))+i.a+(b?g.b+g.c:0);}e.e.i.a=j.a;e.e.i.b=j.b}}
function u$(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;k=new Wub;l=new Wub;q=new Wub;r=new Wub;j=Wv(rJ(b,(Rib(),Jib)),15).a;f=j*Wv(rJ(b,(Mjb(),qjb)),15).a;Ckb(Ixb(Xv(rJ(b,(eM(),rL)))));for(i=(m=(new Snb(c.a)).a.bb().mb(),new Ynb(m));i.a.G();){h=(g=Wv(i.a.H(),21),Wv(g.yb(),9));n=Wv(rJ(h,hib),32);if(n==(sN(),$M)){l.a.db(h,l);for(e=Uh(iX(h));Cm(e);){d=Wv(Dm(e),12);stb(k,d.c.f)}}else if(n==pN){r.a.db(h,r);for(e=Uh(iX(h));Cm(e);){d=Wv(Dm(e),12);stb(q,d.c.f)}}}if(k.a.Y()!=0){o=new cdb(2,f);p=bdb(o,b,k,l,-j-b.d.b);if(p>0){a.a=j+(p-1)*f;b.d.b+=a.a;b.e.b+=a.a}}if(q.a.Y()!=0){o=new cdb(1,f);p=bdb(o,b,q,r,b.e.b+j-b.d.b);p>0&&(b.e.b+=j+(p-1)*f)}}
function Xt(a,b){var c,d,e,f,g,h,i,j,k;if((bmb(),b.length)==0){return a.fc(Yxb,Xxb,-1,-1)}k=hmb(b);emb(k.substr(0,3),'at ')&&(k=imb(k,3,k.length-3));k=k.replace(/\[.*?\]/g,'');g=k.indexOf('(');if(g==-1){g=k.indexOf('@');if(g==-1){j=k;k=''}else{j=hmb(imb(k,g+1,k.length-(g+1)));k=hmb(k.substr(0,g))}}else{c=k.indexOf(')',g);j=k.substr(g+1,c-(g+1));k=hmb(k.substr(0,g))}g=mmb(k,lmb(46));g!=-1&&(k=imb(k,g+1,k.length-(g+1)));(k.length==0||emb(k,'Anonymous function'))&&(k=Xxb);h=nmb(j,lmb(58));e=omb(j,lmb(58),h-1);i=-1;d=-1;f=Yxb;if(h!=-1&&e!=-1){f=j.substr(0,e);i=St(j.substr(e+1,h-(e+1)));d=St(imb(j,h+1,j.length-(h+1)))}return a.fc(f,k,i,d)}
function idb(a){var b,c,d,e,f,g,h,i,j,k;j=new GU;h=new GU;for(g=new Tob(a);g.a<g.c.c.length;){e=Wv(Rob(g),80);e.c=e.b.c.length;e.f=e.e.c.length;e.c==0&&(j.c[j.c.length]=e,true);e.f==0&&e.j.b==0&&(h.c[h.c.length]=e,true)}d=-1;while(j.c.length!=0){e=Wv(AU(j,0),80);for(c=new Tob(e.e);c.a<c.c.c.length;){b=Wv(Rob(c),118);k=b.b;k.i=Plb(k.i,e.i+1);d=Plb(d,k.i);--k.c;k.c==0&&(j.c[j.c.length]=k,true)}}if(d>-1){for(f=new Tob(h);f.a<f.c.c.length;){e=Wv(Rob(f),80);e.i=d}while(h.c.length!=0){e=Wv(AU(h,0),80);for(c=new Tob(e.b);c.a<c.c.c.length;){b=Wv(Rob(c),118);i=b.a;if(i.j.b>0){continue}i.i=Slb(i.i,e.i-1);--i.f;i.f==0&&(h.c[h.c.length]=i,true)}}}}
function PV(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;if(!Ckb(Ixb(Xv(rJ(c,(eM(),$L)))))){return}for(h=new Tob(c.f);h.a<h.c.c.length;){g=Wv(Rob(h),7);l=Wv(FU(g.e,xv(dB,gAb,12,g.e.c.length,0,1)),47);for(j=0,k=l.length;j<k;++j){i=l[j];f=i.d.f==c;e=f&&Ckb(Ixb(Xv(rJ(i,$L))));if(e){n=i.c;m=Wv(Smb(a.b,n),9);if(!m){m=NW(n,(KM(),IM),n.g,-1,n.j,Wv(rJ(b,sL),59),b);sJ(m,(Rib(),uib),n);Umb(a.b,n,m);vU(b.b,m)}p=i.d;o=Wv(Smb(a.b,p),9);if(!o){o=NW(p,(KM(),IM),p.g,1,p.j,Wv(rJ(b,sL),59),b);sJ(o,(Rib(),uib),p);Umb(a.b,p,o);vU(b.b,o)}d=IV(i);dW(d,Wv(yU(m.f,0),7));eW(d,Wv(yU(o.f,0),7));Fd(a.a,i,new XV(d,b,(djb(),bjb)));Wv(rJ(b,(Rib(),jib)),18).ib((ohb(),hhb))}}}}
function vfb(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t;n=sgb(a.g);p=sgb(c.g);o=vI(xI(a.i),a.a);q=vI(xI(c.i),c.a);g=vI(new II(o),CI(new GI(n),b));h=vI(new II(q),CI(new GI(p),d));j=ogb(a,e);e==(sN(),pN)||e==ZM?(j+=f):(j-=f);m=new FI;r=new FI;switch(e.e){case 1:case 3:m.a=g.a;m.b=o.b+j;r.a=h.a;r.b=m.b;break;case 2:case 4:m.a=o.a+j;m.b=g.b;r.a=m.a;r.b=h.b;break;default:return null;}k=CI(vI(new HI(m.a,m.b),r),0.5);l=new ufb(Bv(tv(qz,1),Fzb,10,0,[o,g,m,k,r,h,q]));i=ifb(l);t=jfb(l);switch(e.e){case 1:case 3:l.a=i;s=lfb(l);break;case 2:case 4:l.a=t;s=kfb(l);break;default:return null;}bfb(l,new Ffb(Bv(tv(qz,1),Fzb,10,0,[i,t,s,o,q])));return l}
function qU(a,b,c,d){var e,f,g,h,i,j,k,l,m,n;f=new eV(b);l=lU(a,b,f);n=Nlb(Wv(rJ(b,(eM(),dM)),15).a,1);for(k=new Tob(l.a);k.a<k.c.c.length;){j=Wv(Rob(k),27);i=pU(Wv(j.a,10),Wv(j.b,10),n);o=true;o=o&YU(c,new HI(i.d,i.e));o=o&YU(c,uI(new HI(i.d,i.e),i.c,0));o=o&YU(c,uI(new HI(i.d,i.e),0,i.b));o&YU(c,uI(new HI(i.d,i.e),i.c,i.b))}m=f.d;h=pU(Wv(l.b.a,10),Wv(l.b.b,10),n);if(m==(sN(),rN)||m==ZM){d.c[m.e]=Qlb(d.c[m.e],h.e);d.b[m.e]=Nlb(d.b[m.e],h.e+h.b)}else{d.c[m.e]=Qlb(d.c[m.e],h.d);d.b[m.e]=Nlb(d.b[m.e],h.d+h.c)}e=Vzb;g=f.c.f.e;switch(m.e){case 4:e=g.c;break;case 2:e=g.b;break;case 1:e=g.a;break;case 3:e=g.d;}d.a[m.e]=Nlb(d.a[m.e],e);return f}
function OV(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q;f=new GU;for(j=new Tob(d);j.a<j.c.c.length;){h=Wv(Rob(j),187);g=null;if(h.f==(djb(),bjb)){for(o=new Tob(h.e);o.a<o.c.c.length;){n=Wv(Rob(o),12);q=n.d.f;if(hX(q)==b){GV(a,b,h,n,h.b,n.d)}else if(!c||SW(q,c)){HV(a,b,h,d,n)}else{m=LV(a,b,c,n,h.b,bjb,g);m!=g&&(f.c[f.c.length]=m,true);m.c&&(g=m)}}}else{for(l=new Tob(h.e);l.a<l.c.c.length;){k=Wv(Rob(l),12);p=k.c.f;if(hX(p)==b){GV(a,b,h,k,k.c,h.b)}else if(!c||SW(p,c)){continue}else{m=LV(a,b,c,k,h.b,ajb,g);m!=g&&(f.c[f.c.length]=m,true);m.c&&(g=m)}}}}for(i=new Tob(f);i.a<i.c.c.length;){h=Wv(Rob(i),187);zU(b.b,h.a,0)!=-1||vU(b.b,h.a);h.c&&(e.c[e.c.length]=h,true)}}
function TO(a){var b,c,d,e;b=a.e.j;for(d=new Tob(AW(a));d.a<d.c.c.length;){c=Wv(Rob(d),161);e=Wv(oW(c,(eM(),LL)),15);!e&&(e=new llb(0));switch(Wv(c.e,7).g.e){case 4:c.e.i.b=b.b*Ixb(Yv(oW(c,HO)));c.e.i.a=-c.e.j.a-e.a;break;case 2:c.e.i.b=b.b*Ixb(Yv(oW(c,HO)));c.e.i.a=b.a+e.a;break;case 1:c.e.i.a=b.a*Ixb(Yv(oW(c,HO)));c.e.i.b=-c.e.j.b-e.a;break;case 3:c.e.i.a=b.a*Ixb(Yv(oW(c,HO)));c.e.i.b=b.b+e.a;}switch(Wv(c.e,7).g.e){case 4:c.e.i.b=b.b*Ixb(Yv(oW(c,HO)));c.e.i.a=-c.e.j.a-e.a;break;case 2:c.e.i.b=b.b*Ixb(Yv(oW(c,HO)));c.e.i.a=b.a+e.a;break;case 1:c.e.i.a=b.a*Ixb(Yv(oW(c,HO)));c.e.i.b=-c.e.j.b-e.a;break;case 3:c.e.i.a=b.a*Ixb(Yv(oW(c,HO)));c.e.i.b=b.b+e.a;}}}
function C2(a){var b,c,d,e,f,g,h,i,j;f=a.f;e=pr(Zdb(a));j=WI(Eo(a.g),0);while(j.b!=j.d.c){i=Wv(_ub(j),7);if(i.e.c.length==0){for(c=new Tob(i.b);c.a<c.c.c.length;){b=Wv(Rob(c),12);d=b.c;if(e.a.R(d)){g=new Fnb(f.f,0);h=(Bxb(g.b<g.d.Y()),Wv(g.d.sb(g.c=g.b++),7));while(h!=i){h=(Bxb(g.b<g.d.Y()),Wv(g.d.sb(g.c=g.b++),7))}Anb(g,d);$ub(j,d);J2(d,i.g);avb(j);avb(j);e.a.eb(d)!=null}}}else{for(c=new Tob(i.e);c.a<c.c.c.length;){b=Wv(Rob(c),12);d=b.d;if(e.a.R(d)){g=new Fnb(f.f,0);h=(Bxb(g.b<g.d.Y()),Wv(g.d.sb(g.c=g.b++),7));while(h!=i){h=(Bxb(g.b<g.d.Y()),Wv(g.d.sb(g.c=g.b++),7))}Bxb(g.b>0);g.a.sb(g.c=--g.b);Anb(g,d);$ub(j,d);J2(d,i.g);avb(j);avb(j);e.a.eb(d)!=null}}}}}
function IP(b){var c,d,e,f,g,h,i,j,k;g=new Uu(b);f=Pu(g,'graph');j=Pu(g,'success');e=Pu(g,'error');h=Pu(g,'options');try{if(!f||!f.kc()){throw new $J("Mandatory parameter missing, 'graph' must be specified")}AQ(new CQ,f.kc(),h?h.kc():null);i=f.kc().a;!!j&&!!j.kc()?HP(j.kc().a,i):HP(null,i)}catch(a){a=OH(a);if(aw(a,73)){k=a;!!e&&!!e.kc()?HP(e.kc().a,DQ(k).a):HP(null,DQ(k).a)}else if(aw(a,54)){c=a;d=new Tu;Ru(d,'type',new lv(Ikb(c.$c)));c.bc()!=null?Ru(d,Dzb,new lv(c.bc())):Ru(d,Dzb,new lv('null (sic)'));Ru(d,Ezb,new lv(Hb(new Kb('\n'),new wnb(new opb((c.g==null&&(c.g=Pt(c)),c.g))))));!!e&&!!e.kc()?HP(e.kc().a,d.a):HP(null,d.a);at(c,(Fmb(),Dmb),'')}else throw NH(a)}}
function e9(a,b,c){var d,e,f,g,h,i,j,k,l,m;if(c){d=-1;k=new Fnb(b,0);while(k.b<k.d.Y()){h=(Bxb(k.b<k.d.Y()),Wv(k.d.sb(k.c=k.b++),9));l=a.a[h.d.k][h.k].a;if(l==null){g=d+1;f=new Fnb(b,k.b);while(f.b<f.d.Y()){m=i9(a,(Bxb(f.b<f.d.Y()),Wv(f.d.sb(f.c=f.b++),9))).a;if(m!=null){g=(Dxb(m),m);break}}l=(d+g)/2;a.a[h.d.k][h.k].a=l;a.a[h.d.k][h.k].d=(Dxb(l),l);a.a[h.d.k][h.k].b=1}d=(Dxb(l),l)}}else{e=0;for(j=new Tob(b);j.a<j.c.c.length;){h=Wv(Rob(j),9);a.a[h.d.k][h.k].a!=null&&(e=Nlb(e,Ixb(a.a[h.d.k][h.k].a)))}e+=2;for(i=new Tob(b);i.a<i.c.c.length;){h=Wv(Rob(i),9);if(a.a[h.d.k][h.k].a==null){l=wvb(a.e,24)*FAb*e-1;a.a[h.d.k][h.k].a=l;a.a[h.d.k][h.k].d=l;a.a[h.d.k][h.k].b=1}}}}
function RO(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;i=0;j=0;o=0;n=0;g=0;m=0;l=0;k=0;for(f=new Lsb((new Fsb(a.c)).a);htb(f.a);){e=(f.b=itb(f.a),new Psb(f.c,f.b));d=Wv(e.b.b[e.a.e],62);switch(Wv(e.a,67).e){case 12:case 13:case 14:m+=d.c+b;break;case 15:case 16:case 17:l+=d.c+b;g=Nlb(g,d.b+b);break;case 18:case 19:case 20:k+=d.c+b;break;case 0:case 1:case 2:o+=d.c+b;break;case 3:case 4:case 5:n+=d.c+b;break;case 6:case 7:case 8:i+=d.b+b;break;case 9:case 10:case 11:j+=d.b+b;}}i-=b;j-=b;o-=b;n-=b;m+=m!=0?b:0;l+=l!=0?b:0;k+=k!=0?b:0;h=a.p.d+g+a.p.a;h+=h!=0?b:0;c.a=Nlb(c.a,o);c.a=Nlb(c.a,m);c.a=Nlb(c.a,l);c.a=Nlb(c.a,k);c.a=Nlb(c.a,n);c.b=Nlb(c.b,i);c.b=Nlb(c.b,h);c.b=Nlb(c.b,j)}
function T9(a){var b,c,d,e,f,g,h,i;b=null;for(d=new Tob(a);d.a<d.c.c.length;){c=Wv(Rob(d),102);Ixb(W9(c.g,c.d[0]).a);c.b=null;if(!!c.e&&c.e.Y()>0&&c.c==0){!b&&(b=new GU);b.c[b.c.length]=c}}if(b){while(b.c.length!=0){c=Wv(AU(b,0),102);if(!!c.b&&c.b.c.length>0){for(f=(!c.b&&(c.b=new GU),new Tob(c.b));f.a<f.c.c.length;){e=Wv(Rob(f),102);if(Ixb(W9(e.g,e.d[0]).a)==Ixb(W9(c.g,c.d[0]).a)){if(zU(a,e,0)>zU(a,c,0)){return new RJ(e,c)}}else if(Ixb(W9(e.g,e.d[0]).a)>Ixb(W9(c.g,c.d[0]).a)){return new RJ(e,c)}}}for(h=(!c.e&&(c.e=new GU),c.e).mb();h.G();){g=Wv(h.H(),102);i=(!g.b&&(g.b=new GU),g.b);Fxb(0,i.c.length);fxb(i.c,0,c);g.c==i.c.length&&(b.c[b.c.length]=g,true)}}}return null}
function R0(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p;l=(mp(),new ntb);for(k=(Il(),new Im(Dl(ul(a.a,new yl))));Cm(k);){j=Wv(Dm(k),9);e=Q0(j,(sN(),ZM));for(d=new Tob(e);d.a<d.c.c.length;){c=Wv(Rob(d),7);for(g=new Tob(c.e);g.a<g.c.c.length;){f=Wv(Rob(g),12);kP();p=f.d.f;(p.g==(CX(),zX)||p.g==yX)&&(p=Wv(rJ(p,(Rib(),rib)),7).f);if(Ktb(l.d,p)){b=Wv(re(Ktb(l.d,p)),171)}else{e.c.length==2?gw(c)===gw((Cxb(0,e.c.length),e.c[0]))?(b=gP):(b=hP):(b=gP);Ltb(l.d,p,b)}for(i=new Tob(f.b);i.a<i.c.c.length;){h=Wv(Rob(i),33);sJ(h,(Rib(),pib),b)}for(o=new Tob(f.c.c);o.a<o.c.c.length;){m=Wv(Rob(o),33);sJ(m,(Rib(),pib),b)}for(n=new Tob(f.d.c);n.a<n.c.c.length;){m=Wv(Rob(n),33);sJ(m,(Rib(),pib),b)}}}}}
function lZ(a,b){var c,d,e,f,g,h,i,j,k;if(tl(mX(b))!=1||Wv(ql(mX(b)),12).d.f.g!=(CX(),zX)){return null}f=Wv(ql(mX(b)),12);c=f.d.f;sX(c,(CX(),wX));sJ(c,(Rib(),qib),null);sJ(c,rib,null);sJ(c,(eM(),TL),Wv(rJ(b,TL),28));sJ(c,JL,Wv(rJ(b,JL),86));e=rJ(f.c,uib);g=null;for(j=nX(c,(sN(),ZM)).mb();j.G();){h=Wv(j.H(),7);if(h.e.c.length!=0){sJ(h,uib,e);k=f.c;h.j.a=k.j.a;h.j.b=k.j.b;h.a.a=k.a.a;h.a.b=k.a.b;xU(h.c,k.c);k.c.c=xv(UF,syb,1,0,4,1);g=h;break}}sJ(f.c,uib,null);if(!sl(nX(b,ZM))){for(i=new Tob(Ao(nX(b,ZM)));i.a<i.c.c.length;){h=Wv(Rob(i),7);if(h.e.c.length==0){d=new RX;QX(d,ZM);d.j.a=h.j.a;d.j.b=h.j.b;PX(d,c);sJ(d,uib,rJ(h,uib));PX(h,null)}else{PX(g,c)}}}c.j.b=b.j.b;vU(a.b,c);return c}
function _O(a){var b,c,d,e,f,g,h,i,j;f=a.e.e.j;g=new II(f);i=Wv(oW(a.e,(eM(),aM)),86);j=Wv(oW(a.e,bM),86);h=Wv(oW(a.e,TL),28);b=Zsb(i,(DN(),CN));if(i.c==0){return}f.a=0;f.b=0;d=null;switch(h.e){case 1:case 2:case 3:d=MO(a,a.k);break;case 4:d=new II(g);break;case 5:d=KO(a.e,b);}if(Zsb(i,BN)){if(d){f.a=Nlb(f.a,d.a);f.b=Nlb(f.b,d.b)}if(b){f.a=Nlb(f.a,a.q.b+a.q.c+a.k);f.b=Nlb(f.b,a.q.d+a.q.a+a.k)}}Zsb(i,AN)&&Qob(new Tob(zW(a.e)))&&RO(a,a.d,f);if(Zsb(i,zN)){e=Wv(oW(a.e,IL),15).a;c=Wv(oW(a.e,HL),15).a;if(Zsb(j,(MN(),KN))){e<=0&&(e=20);c<=0&&(c=20)}if(Zsb(j,LN)){e>0&&(f.a=Nlb(f.a,e+a.q.b+a.q.c));c>0&&(f.b=Nlb(f.b,c+a.q.d+a.q.a))}else{e>0&&(f.a=Nlb(f.a,e));c>0&&(f.b=Nlb(f.b,c))}}pW(a.e,f)}
function ewb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;if(!a.b){return false}g=null;m=null;i=new ywb(null,null);e=1;i.a[1]=a.b;l=i;while(l.a[e]){j=e;h=m;m=l;l=l.a[e];d=a.a.$b(b,l.d);e=d<0?0:1;d==0&&(!c.c||ovb(l.e,c.d))&&(g=l);if(!(!!l&&l.b)&&!awb(l.a[e])){if(awb(l.a[1-e])){m=m.a[j]=hwb(l,e)}else if(!awb(l.a[1-e])){n=m.a[1-j];if(n){if(!awb(n.a[1-j])&&!awb(n.a[j])){m.b=false;n.b=true;l.b=true}else{f=h.a[1]==m?1:0;awb(n.a[j])?(h.a[f]=gwb(m,j)):awb(n.a[1-j])&&(h.a[f]=hwb(m,j));l.b=h.a[f].b=true;h.a[f].a[0].b=false;h.a[f].a[1].b=false}}}}}if(g){c.b=true;c.d=g.e;if(l!=g){k=new ywb(l.d,l.e);fwb(a,i,g,k);m==g&&(m=k)}m.a[m.a[1]==l?1:0]=l.a[!l.a[0]?1:0];--a.c}a.b=i.a[1];!!a.b&&(a.b.b=false);return c.b}
function v$(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;d=Wv(rJ(a,(eM(),TL)),28);i=a.e;h=a.a;c=Wv(rJ(a,(Rib(),Xhb)),15).a;j=i.a+h.b+h.c+2*c;k=0-h.d-c-a.d.b;n=i.b+h.d+h.a+2*c-a.d.b;l=new GU;o=new GU;for(f=(m=(new Snb(b.a)).a.bb().mb(),new Ynb(m));f.a.G();){e=(g=Wv(f.a.H(),21),Wv(g.yb(),9));switch(d.e){case 1:case 2:case 3:m$(e);break;case 4:p=Wv(rJ(e,SL),10);q=!p?0:p.a;e.i.a=j*Ixb(Yv(rJ(e,Cib)))-q;fX(e,true,false);break;case 5:r=Wv(rJ(e,SL),10);s=!r?0:r.a;e.i.a=Ixb(Yv(rJ(e,Cib)))-s;fX(e,true,false);i.a=Nlb(i.a,e.i.a+e.j.a/2);}switch(Wv(rJ(e,hib),32).e){case 1:e.i.b=k;l.c[l.c.length]=e;break;case 3:e.i.b=n;o.c[o.c.length]=e;}}switch(d.e){case 1:case 2:o$(l,a);o$(o,a);break;case 3:t$(l,a);t$(o,a);}}
function OY(a){var b,c,d,e,f,g;d=Wv(rJ(a.a.g,(eM(),JL)),86);if(jf(d,(oM(),b=Wv(Hkb(Gz),11),new atb(b,Wv(exb(b,b.length),11),0))));else if(Xe(d,Usb(gM))){c=Wv(Wv(Dd(a.a.b,a.b),20).sb(0),33);a.b.i.a=c.i.a;a.b.i.b=c.i.b}else if(Xe(d,Usb(iM))){e=Wv(yU(a.a.c,a.a.c.c.length-1),9);f=Wv(Wv(Dd(a.a.b,a.b),20).sb(Wv(Dd(a.a.b,a.b),20).Y()-1),33);g=e.j.a-(f.i.a+f.j.a);a.b.i.a=a.a.g.j.a-g-a.b.j.a;a.b.i.b=f.i.b}else if(Xe(d,Vsb(mM,Bv(tv(Gz,1),uyb,41,0,[fM])))){c=Wv(Wv(Dd(a.a.b,a.b),20).sb(0),33);a.b.i.a=(a.a.g.j.a-a.b.j.a)/2;a.b.i.b=c.i.b}else if(Xe(d,Usb(mM))){c=Wv(Wv(Dd(a.a.b,a.b),20).sb(0),33);a.b.i.b=c.i.b}else if(Xe(d,Usb(fM))){c=Wv(Wv(Dd(a.a.b,a.b),20).sb(0),33);a.b.i.a=(a.a.g.j.a-a.b.j.a)/2;a.b.i.b=c.i.b}return null}
function NZ(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;for(o=new Tob(a);o.a<o.c.c.length;){n=Wv(Rob(o),9);MZ(n.i);MZ(n.j);PZ(n);RZ(n);for(q=new Tob(n.f);q.a<q.c.c.length;){p=Wv(Rob(q),7);MZ(p.i);MZ(p.a);MZ(p.j);QX(p,QZ(p.g));f=Wv(rJ(p,(eM(),UL)),24);!!f&&sJ(p,UL,Elb(-f.a));for(e=new Tob(p.e);e.a<e.c.c.length;){d=Wv(Rob(e),12);for(c=WI(d.a,0);c.b!=c.d.c;){b=Wv(_ub(c),10);MZ(b)}i=Wv(rJ(d,CL),44);if(i){for(h=WI(i,0);h.b!=h.d.c;){g=Wv(_ub(h),10);MZ(g)}}for(l=new Tob(d.b);l.a<l.c.c.length;){j=Wv(Rob(l),33);MZ(j.i);MZ(j.j)}}for(m=new Tob(p.c);m.a<m.c.c.length;){j=Wv(Rob(m),33);MZ(j.i);MZ(j.j)}}if(n.g==(CX(),xX)){sJ(n,(Rib(),hib),QZ(Wv(rJ(n,hib),32)));OZ(n)}for(k=new Tob(n.c);k.a<k.c.c.length;){j=Wv(Rob(k),33);MZ(j.j);MZ(j.i)}}}
function YP(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;TP(c);if(SW(b.d.f,b.c.f)){k=b.c;l=MI(Bv(tv(qz,1),Fzb,10,0,[k.i,k.a]));j=k.f.b;uI(l,-j.b,-j.d);l.a-=d.a;l.b-=d.b}else{l=MX(b.c)}l.a+=d.a;l.b+=d.b;m=new Tu;VP(a,m,'x',l.a);VP(a,m,'y',l.b);Ru(c,'sourcePoint',m);n=MX(b.d);rJ(b,(Rib(),Pib))!=null&&vI(n,Wv(rJ(b,Pib),10));vI(n,d);o=new Tu;VP(a,o,'x',n.a);VP(a,o,'y',n.b);Ru(c,'targetPoint',o);e=new ju;s=hJ(b.a,d);f=0;for(r=WI(s,0);r.b!=r.d.c;){p=Wv(_ub(r),10);i=new Tu;VP(a,i,'x',p.a);VP(a,i,'y',p.b);hu(e,f++,i)}s.b==0?Ru(c,Hzb,null):Ru(c,Hzb,e);g=Wv(rJ(b,(eM(),CL)),44);f=0;if(g){hJ(g,d);h=new ju;for(q=WI(g,0);q.b!=q.d.c;){p=Wv(_ub(q),10);i=new Tu;VP(a,i,'x',p.a);VP(a,i,'y',p.b);hu(h,f++,i)}Ru(c,Izb,h)}else{Ru(c,Izb,null)}}
function pZ(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r;p=a.i;q=a.j;m=a.e;if(b){l=d/2*(b.Y()-1);n=0;for(j=b.mb();j.G();){h=Wv(j.H(),9);l+=h.j.a;n=Nlb(n,h.j.b)}r=p.a-(l-q.a)/2;g=p.b-m.d+n;e=q.a/(b.Y()+1);f=e;for(i=b.mb();i.G();){h=Wv(i.H(),9);h.i.a=r;h.i.b=g-h.j.b;r+=h.j.a+d/2;k=oZ(h);k.i.a=h.j.a/2-k.a.a;k.i.b=h.j.b;o=Wv(rJ(h,(Rib(),Zhb)),7);if(o.b.c.length+o.e.c.length==1){o.i.a=f-o.a.a;o.i.b=0;PX(o,a)}f+=e}}if(c){l=d/2*(c.Y()-1);n=0;for(j=c.mb();j.G();){h=Wv(j.H(),9);l+=h.j.a;n=Nlb(n,h.j.b)}r=p.a-(l-q.a)/2;g=p.b+q.b+m.a-n;e=q.a/(c.Y()+1);f=e;for(i=c.mb();i.G();){h=Wv(i.H(),9);h.i.a=r;h.i.b=g;r+=h.j.a+d/2;k=oZ(h);k.i.a=h.j.a/2-k.a.a;k.i.b=0;o=Wv(rJ(h,(Rib(),Zhb)),7);if(o.b.c.length+o.e.c.length==1){o.i.a=f-o.a.a;o.i.b=q.b;PX(o,a)}f+=e}}}
function Jab(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;w=0;n=0;for(l=new Tob(b.f);l.a<l.c.c.length;){k=Wv(Rob(l),9);m=0;h=0;i=c?Wv(rJ(k,Fab),24).a:eyb;r=d?Wv(rJ(k,Gab),24).a:eyb;j=i>r?i:r;for(t=new Tob(k.f);t.a<t.c.c.length;){s=Wv(Rob(t),7);u=k.i.b+s.i.b+s.a.b;if(d){for(g=new Tob(s.e);g.a<g.c.c.length;){f=Wv(Rob(g),12);p=f.d;o=p.f;if(b!=a.a[o.k]){q=Plb(Wv(rJ(o,Fab),24).a,Wv(rJ(o,Gab),24).a);v=Wv(rJ(f,(Rib(),Eib)),24).a;if(v>=j&&v>=q){m+=o.i.b+p.i.b+p.a.b-u;++h}}}}if(c){for(g=new Tob(s.b);g.a<g.c.c.length;){f=Wv(Rob(g),12);p=f.c;o=p.f;if(b!=a.a[o.k]){q=Plb(Wv(rJ(o,Fab),24).a,Wv(rJ(o,Gab),24).a);v=Wv(rJ(f,(Rib(),Eib)),24).a;if(v>=j&&v>=q){m+=o.i.b+p.i.b+p.a.b-u;++h}}}}}if(h>0){w+=m/h;++n}}if(n>0){b.a=e*w/n;b.i=n}else{b.a=0;b.i=0}}
function Kab(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;n=b.c.length;m=0;for(l=new Tob(a.c);l.a<l.c.c.length;){k=Wv(Rob(l),16);r=k.a;if(r.c.length==0){continue}q=new Tob(r);j=0;s=null;e=Wv(Rob(q),9);while(e){f=Wv(yU(b,e.k),111);if(f.c>=0){i=null;h=new Fnb(k.a,j+1);while(h.b<h.d.Y()){g=(Bxb(h.b<h.d.Y()),Wv(h.d.sb(h.c=h.b++),9));i=Wv(yU(b,g.k),111);if(i.d==f.d&&i.c<f.c){break}else{i=null}}if(i){if(s){DU(d,e.k,Elb(Wv(yU(d,e.k),24).a-1));Wv(yU(c,s.k),20).nb(f)}f=Vab(f,e,n++);b.c[b.c.length]=f;vU(c,new GU);if(s){Wv(yU(c,s.k),20).ib(f);vU(d,Elb(1))}else{vU(d,Elb(0))}}}o=null;if(q.a<q.c.c.length){o=Wv(Rob(q),9);p=Wv(yU(b,o.k),111);Wv(yU(c,e.k),20).ib(p);DU(d,o.k,Elb(Wv(yU(d,o.k),24).a+1))}f.d=m;f.c=j++;s=e;e=o}++m}Ckb(Ixb(Xv(rJ(a,(eM(),rL)))))&&undefined}
function gS(a,b){var c;if(a.e){throw new ulb((Gkb(nA),'The '+nA.j+Yzb))}if(!MR(a.a,b)){throw new gt('The direction '+b+' is not supported by the CGraph instance.')}if(b==a.d){return a}c=a.d;a.d=b;switch(c.e){case 0:switch(b.e){case 2:dS(a);break;case 1:kS(a);dS(a);break;case 4:qS(a);dS(a);break;case 3:qS(a);kS(a);dS(a);}break;case 2:switch(b.e){case 1:kS(a);lS(a);break;case 4:qS(a);dS(a);break;case 3:qS(a);kS(a);dS(a);}break;case 1:switch(b.e){case 2:kS(a);lS(a);break;case 4:kS(a);qS(a);dS(a);break;case 3:kS(a);qS(a);kS(a);dS(a);}break;case 4:switch(b.e){case 2:qS(a);dS(a);break;case 1:qS(a);kS(a);dS(a);break;case 3:kS(a);lS(a);}break;case 3:switch(b.e){case 2:kS(a);qS(a);dS(a);break;case 1:kS(a);qS(a);kS(a);dS(a);break;case 4:kS(a);lS(a);}}return a}
function c9(a,b,c){var d,e,f,g,h,i,j,k,l;if(a.a[b.d.k][b.k].e){return}else{a.a[b.d.k][b.k].e=true}a.a[b.d.k][b.k].b=0;a.a[b.d.k][b.k].d=0;a.a[b.d.k][b.k].a=null;for(k=new Tob(b.f);k.a<k.c.c.length;){j=Wv(Rob(k),7);l=c?new fY(j):new lY(j);for(i=l.mb();i.G();){h=Wv(i.H(),7);g=h.f;if(g.d==b.d){if(g!=b){c9(a,g,c);a.a[b.d.k][b.k].b+=a.a[g.d.k][g.k].b;a.a[b.d.k][b.k].d+=a.a[g.d.k][g.k].d}}else{a.a[b.d.k][b.k].d+=a.d[h.k];++a.a[b.d.k][b.k].b}}}f=Wv(rJ(b,(Rib(),Shb)),20);if(f){for(e=f.mb();e.G();){d=Wv(e.H(),9);if(b.d==d.d){c9(a,d,c);a.a[b.d.k][b.k].b+=a.a[d.d.k][d.k].b;a.a[b.d.k][b.k].d+=a.a[d.d.k][d.k].d}}}if(a.a[b.d.k][b.k].b>0){a.a[b.d.k][b.k].d+=wvb(a.e,24)*FAb*0.07000000029802322-0.03500000014901161;a.a[b.d.k][b.k].a=a.a[b.d.k][b.k].d/a.a[b.d.k][b.k].b}}
function Sbb(a,b){var c,d,e,f,g,h,i,j,k,l,m;for(e=new Tob(a.a.c);e.a<e.c.c.length;){c=Wv(Rob(e),16);for(i=new Tob(c.a);i.a<i.c.c.length;){h=Wv(Rob(i),9);b.i[h.k]=h;b.g[h.k]=b.k==(Lbb(),Kbb)?Vzb:Uzb}}g=a.a.c;b.c==(Gbb(),Ebb)&&(g=aw(g,87)?Ii(Wv(g,87)):aw(g,88)?Wv(g,88).a:aw(g,63)?new ap(g):new Ro(g));Acb(a.e,b,a.b);bpb(b.n);for(f=g.mb();f.G();){c=Wv(f.H(),16);j=c.a;b.k==(Lbb(),Kbb)&&(j=aw(j,87)?Ii(Wv(j,87)):aw(j,88)?Wv(j,88).a:aw(j,63)?new ap(j):new Ro(j));for(m=j.mb();m.G();){l=Wv(m.H(),9);b.f[l.k]==l&&Tbb(a,l,b)}}Ubb(a,b);for(d=g.mb();d.G();){c=Wv(d.H(),16);for(m=new Tob(c.a);m.a<m.c.c.length;){l=Wv(Rob(m),9);b.n[l.k]=b.n[b.f[l.k].k];if(l==b.f[l.k]){k=Ixb(b.g[b.i[l.k].k]);(b.k==(Lbb(),Kbb)&&k>Vzb||b.k==Jbb&&k<Uzb)&&(b.n[l.k]=Ixb(b.n[l.k])+k)}}}a.e.Jc()}
function NQ(a,b){var c,d,e,f,g,h,i,j,k,l,m;pJ(b,Bv(tv(rz,1),syb,79,0,[(Rib(),Jib),Xhb,(Mjb(),Kjb),Rhb]));j=Wv(rJ(b,Jib),15).a;Wv(rJ(b,qjb),15).a*j<2&&sJ(b,qjb,new llb(2/j));k=Wv(rJ(b,(eM(),sL)),59);k==(sK(),qK)&&sJ(b,sL,PW(b));l=Wv(rJ(b,Hjb),24);l.a==0?sJ(b,Gib,new yvb):sJ(b,Gib,new zvb(l.a));m=new $jb(b);sJ(b,Kib,m);e=KQ(a,Wv(rJ(b,ljb),180));h=KQ(a,Wv(rJ(b,zjb),180));d=KQ(a,Wv(rJ(b,kjb),180));i=KQ(a,Wv(rJ(b,Ajb),180));f=KQ(a,Ocb(Wv(rJ(b,eib),122)));g=new WQ;sJ(b,_hb,g);QQ(QQ(QQ(QQ(QQ(QQ(g,e.qc(b)),h.qc(b)),d.qc(b)),i.qc(b)),f.qc(b)),MQ(b));c=(Mh(30,Vyb),new HU(30));sJ(b,Fib,c);xU(c,LQ(a,g,0));c.c[c.c.length]=e;xU(c,LQ(a,g,1));c.c[c.c.length]=h;xU(c,LQ(a,g,2));c.c[c.c.length]=d;xU(c,LQ(a,g,3));c.c[c.c.length]=i;xU(c,LQ(a,g,4));c.c[c.c.length]=f;xU(c,LQ(a,g,5))}
function YO(a,b){var c,d,e,f,g,h;f=Li(DW(a));if(f.Nb().V()){return}e=Wv(rJ(Wv(Wv(Wv(f.Nb().sb(0),129),224).e,33),(kP(),iP)),171);e=e==jP?hP:e;h=0;switch(Wv(a.e,7).g.e){case 4:case 2:e==hP&&(h=a.e.j.b);break;case 3:h=a.e.j.b;}(Wv(a.e,7).g==(sN(),$M)||e==gP)&&(f=Ii(f));for(d=Xl(f.Nb().mb());d.G();){c=Wv(d.H(),129);g=new II(c.e.i);if(e==gP){switch(Wv(a.e,7).g.e){case 1:case 4:g.a=-c.e.j.a-b;g.b=h-b-c.e.j.b;h-=b+c.e.j.b;break;case 2:g.a=a.e.j.a+b;g.b=h-b-c.e.j.b;h-=b+c.e.j.b;break;case 3:g.a=-c.e.j.a-b;g.b=h+b;h+=b+c.e.j.b;}}else{switch(Wv(a.e,7).g.e){case 4:g.a=-c.e.j.a-b;g.b=h+b;h+=b+c.e.j.b;break;case 2:g.a=a.e.j.a+b;g.b=h+b;h+=b+c.e.j.b;break;case 1:g.a=a.e.j.a+b;g.b=h-b-c.e.j.b;h-=b+c.e.j.b;break;case 3:g.a=a.e.j.a+b;g.b=h+b;h+=b+c.e.j.b;}}c.e.i.a=g.a;c.e.i.b=g.b}}
function fab(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;d=0;e=0;for(k=0;k<a.length;k++){i=a[k];if(LM(Wv(rJ(i,(eM(),TL)),28))){for(g=nX(i,(sN(),ZM)).mb();g.G();){f=Wv(g.H(),7);if(f.b.c.length+f.e.c.length>0){d+=f.b.c.length+f.e.c.length;Umb(b,f,Elb(d))}}}else{for(h=nX(i,(sN(),ZM)).mb();h.G();){f=Wv(h.H(),7);d+=f.b.c.length+f.e.c.length}for(g=nX(i,ZM).mb();g.G();){f=Wv(g.H(),7);f.b.c.length+f.e.c.length>0&&Umb(b,f,Elb(d))}}}for(j=a.length-1;j>=0;j--){i=a[j];if(LM(Wv(rJ(i,(eM(),TL)),28))){for(m=nX(i,(sN(),rN)).mb();m.G();){l=Wv(m.H(),7);if(l.b.c.length+l.e.c.length>0){e+=l.b.c.length+l.e.c.length;Umb(c,l,Elb(e))}}}else{for(n=nX(i,(sN(),rN)).mb();n.G();){l=Wv(n.H(),7);e+=l.b.c.length+l.e.c.length}for(m=nX(i,rN).mb();m.G();){l=Wv(m.H(),7);l.b.c.length+l.e.c.length>0&&Umb(c,l,Elb(e))}}}}
function wfb(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q,r;m=sgb(a.g);o=sgb(b.g);n=vI(xI(a.i),a.a);p=vI(xI(b.i),b.a);i=vI(new HI(n.a,n.b),CI(new GI(m),1.3*c));q=vI(new HI(p.a,p.b),CI(new GI(o),1.3*d));h=Jlb(i.a-q.a);h<e&&(a.g==(sN(),rN)||a.g==ZM?i.a<q.a?(i.a=q.a-e):(i.a=q.a+e):i.a<q.a?(q.a=i.a+e):(q.a=i.a-e));f=0;g=0;switch(a.g.e){case 4:f=2*(n.a-c)-0.5*(i.a+q.a);break;case 2:f=2*(n.a+c)-0.5*(i.a+q.a);break;case 1:g=2*(n.b-c)-0.5*(i.b+q.b);break;case 3:g=2*(n.b+c)-0.5*(i.b+q.b);}switch(b.g.e){case 4:f=2*(p.a-d)-0.5*(q.a+i.a);break;case 2:f=2*(p.a+d)-0.5*(q.a+i.a);break;case 1:g=2*(p.b-d)-0.5*(q.b+i.b);break;case 3:g=2*(p.b+d)-0.5*(q.b+i.b);}l=new HI(f,g);k=new ufb(Bv(tv(qz,1),Fzb,10,0,[n,i,l,q,p]));j=ifb(k);r=jfb(k);k.a=j;bfb(k,new Ffb(Bv(tv(qz,1),Fzb,10,0,[j,r,n,p])));return k}
function p$(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q;i=c.a;e=Wv(rJ(c,(Rib(),Xhb)),15).a;o=c.d;h=(d=Wv(rJ(c,Xhb),15).a,new HI(c.e.a+c.a.b+c.a.c+2*d,c.e.b+c.a.d+c.a.a+2*d));j=h.b;for(m=new Tob(a.a);m.a<m.c.c.length;){k=Wv(Rob(m),9);if(k.g!=(CX(),xX)){continue}f=Wv(rJ(k,hib),32);g=Wv(rJ(k,iib),10);n=k.i;switch(f.e){case 2:n.a=c.e.a+e+i.c-o.a;break;case 4:n.a=-o.a-e-i.b;}q=0;switch(f.e){case 2:case 4:if(b==(KM(),GM)){p=Ixb(Yv(rJ(k,Cib)));n.b=h.b*p-Wv(rJ(k,(eM(),SL)),10).b;q=n.b+g.b;fX(k,false,true)}else if(b==FM){n.b=Ixb(Yv(rJ(k,Cib)))-Wv(rJ(k,(eM(),SL)),10).b;q=n.b+g.b;fX(k,false,true)}}j=j>q?j:q}c.e.b+=j-h.b;for(l=new Tob(a.a);l.a<l.c.c.length;){k=Wv(Rob(l),9);if(k.g!=(CX(),xX)){continue}f=Wv(rJ(k,hib),32);n=k.i;switch(f.e){case 1:n.b=-o.b-e-i.d;break;case 3:n.b=c.e.b+e+i.a-o.b;}}}
function $Y(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o;e=new GU;for(i=new Tob(a.d.f);i.a<i.c.c.length;){g=Wv(Rob(i),7);g.g==(sN(),ZM)&&(e.c[e.c.length]=g,true)}if(a.e.a==(sK(),pK)&&!MM(Wv(rJ(a.d,(eM(),TL)),28))){for(d=Uh(mX(a.d));Cm(d);){c=Wv(Dm(d),12);vU(e,c.c)}}f=a.d.j.a;sJ(a.d,(Rib(),Whb),new llb(a.d.j.a));a.d.j.a=a.c;sJ(a.d,Vhb,(xkb(),xkb(),wkb));vU(a.b,a.d);j=a.d;f-=a.c;k=a.a;while(k>1){b=Qlb(f,a.c);j=(l=new uX(a.e.c),sX(l,(CX(),wX)),sJ(l,(eM(),TL),Wv(rJ(j,TL),28)),sJ(l,JL,Wv(rJ(j,JL),86)),l.k=a.e.b++,vU(a.b,l),l.j.b=j.j.b,l.j.a=b,m=new RX,QX(m,(sN(),ZM)),PX(m,j),m.i.a=l.j.a,m.i.b=l.j.b/2,n=new RX,QX(n,rN),PX(n,l),n.i.b=l.j.b/2,n.i.a=-n.j.a,o=new hW,dW(o,m),eW(o,n),l);vU(a.e.c.b,j);--k;f-=a.c+a.e.d}new HY(a.d,a.b,a.c);for(h=new Tob(e);h.a<h.c.c.length;){g=Wv(Rob(h),7);BU(a.d.f,g);PX(g,j)}}
function Qfb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;if(a.p>b.a||b.p>a.a){return}c=0;d=0;for(l=(g=(new Snb(a.o.a)).a.bb().mb(),new Ynb(g));l.a.G();){j=(e=Wv(l.a.H(),21),Wv(e.yb(),7));qgb(MI(Bv(tv(qz,1),Fzb,10,0,[j.f.i,j.i,j.a])).b,b.p,b.a)&&++c}for(m=(h=(new Snb(a.g.a)).a.bb().mb(),new Ynb(h));m.a.G();){j=(e=Wv(m.a.H(),21),Wv(e.yb(),7));qgb(MI(Bv(tv(qz,1),Fzb,10,0,[j.f.i,j.i,j.a])).b,b.p,b.a)&&--c}for(n=(i=(new Snb(b.o.a)).a.bb().mb(),new Ynb(i));n.a.G();){j=(e=Wv(n.a.H(),21),Wv(e.yb(),7));qgb(MI(Bv(tv(qz,1),Fzb,10,0,[j.f.i,j.i,j.a])).b,a.p,a.a)&&++d}for(k=(f=(new Snb(b.g.a)).a.bb().mb(),new Ynb(f));k.a.G();){j=(e=Wv(k.a.H(),21),Wv(e.yb(),7));qgb(MI(Bv(tv(qz,1),Fzb,10,0,[j.f.i,j.i,j.a])).b,a.p,a.a)&&--d}if(c<d){new bgb(a,b,d-c)}else if(d<c){new bgb(b,a,c-d)}else{new bgb(b,a,0);new bgb(a,b,0)}}
function $jb(a){var b;this.f=Wv(rJ(a,(Rib(),Jib)),15).a;this.d=Wv(rJ(a,(Mjb(),Ejb)),15).a;this.a=this.f*Wv(rJ(a,qjb),15).a;this.b=this.f*Wv(rJ(a,pjb),15).a;Wv(rJ(a,Dib),15);this.c=Wv(rJ(a,Dib),15).a;this.e=Wv(rJ(a,(eM(),DL)),15).a;b=(CX(),Bv(tv(pB,1),uyb,132,0,[AX,zX,xX,BX,yX,wX])).length;this.g=vv(lw,[Txb,tAb],[250,26],12,[b,b],2);Yjb(this,AX,this.f);Zjb(this,AX,zX,this.b);Zjb(this,AX,BX,this.b);Zjb(this,AX,xX,this.c);Zjb(this,AX,yX,this.b);Zjb(this,AX,wX,this.b);Yjb(this,zX,this.a);Zjb(this,zX,BX,this.a);Zjb(this,zX,xX,this.c);Zjb(this,zX,yX,this.e);Zjb(this,zX,wX,this.b);Yjb(this,BX,this.a);Zjb(this,BX,xX,this.c);Zjb(this,BX,yX,this.e);Zjb(this,BX,wX,this.b);Yjb(this,xX,this.c);Zjb(this,xX,yX,this.c);Zjb(this,xX,wX,this.c);Yjb(this,yX,this.e);Zjb(this,yX,wX,this.e);Yjb(this,wX,this.f)}
function mZ(a,b){var c,d,e,f,g,h,i,j,k;if(tl(iX(b))!=1||Wv(ql(iX(b)),12).c.f.g!=(CX(),zX)){return null}c=Wv(ql(iX(b)),12);d=c.c.f;sX(d,(CX(),AX));sJ(d,(Rib(),qib),null);sJ(d,rib,null);sJ(d,Whb,Wv(rJ(b,Whb),15));sJ(d,Vhb,(xkb(),xkb(),wkb));sJ(d,uib,rJ(b,uib));d.j.b=b.j.b;f=rJ(c.d,uib);g=null;for(j=nX(d,(sN(),rN)).mb();j.G();){h=Wv(j.H(),7);if(h.b.c.length!=0){sJ(h,uib,f);k=c.d;h.j.a=k.j.a;h.j.b=k.j.b;h.a.a=k.a.a;h.a.b=k.a.b;xU(h.c,k.c);k.c.c=xv(UF,syb,1,0,4,1);g=h;break}}sJ(c.d,uib,null);if(tl(nX(b,rN))>1){for(i=WI(Eo(nX(b,rN)),0);i.b!=i.d.c;){h=Wv(_ub(i),7);if(h.b.c.length==0){e=new RX;QX(e,rN);e.j.a=h.j.a;e.j.b=h.j.b;PX(e,d);sJ(e,uib,rJ(h,uib));PX(h,null)}else{PX(g,d)}}}sJ(b,uib,null);sJ(b,Vhb,(null,vkb));sX(b,wX);sJ(d,(eM(),TL),Wv(rJ(b,TL),28));sJ(d,JL,Wv(rJ(b,JL),86));uU(a.b,0,d);return d}
function NW(a,b,c,d,e,f,g){var h,i,j,k,l,m;l=c;j=new uX(g);sX(j,(CX(),xX));sJ(j,(Rib(),iib),e);sJ(j,(eM(),TL),(KM(),FM));sJ(j,tib,Wv(rJ(a,LL),15));i=Wv(rJ(a,SL),10);!i&&(i=new HI(e.a/2,e.b/2));sJ(j,SL,i);k=new RX;PX(k,j);if(!(b!=IM&&b!=JM)){h=f!=(sK(),qK)?f:pK;d>0?(l=vN(h)):(l=tN(vN(h)));sJ(a,WL,l)}switch(l.e){case 4:sJ(j,(Mjb(),vjb),(Xib(),Tib));sJ(j,dib,(Hgb(),Ggb));j.j.b=e.b;QX(k,(sN(),ZM));k.i.b=i.b;break;case 2:sJ(j,(Mjb(),vjb),(Xib(),Vib));sJ(j,dib,(Hgb(),Egb));j.j.b=e.b;QX(k,(sN(),rN));k.i.b=i.b;break;case 1:sJ(j,mib,(Hhb(),Ghb));j.j.a=e.a;QX(k,(sN(),pN));k.i.a=i.a;break;case 3:sJ(j,mib,(Hhb(),Ehb));j.j.a=e.a;QX(k,(sN(),$M));k.i.a=i.a;}if(b==EM||b==GM||b==FM){m=0;switch(l.e){case 4:case 2:m=null.cd;b==GM&&(m/=null.cd);break;case 1:case 3:m=null.cd;b==GM&&(m/=null.cd);}sJ(j,Cib,m)}sJ(j,hib,l);return j}
function LP(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;j=new jJ;r=(mp(),new ntb);Umb(r,a,MP(a));d=(Mh(2,Vyb),new HU(2));!!a.c&&vU(d,a.c);!!a.d&&vU(d,a.d);for(n=new Tob(d);n.a<n.c.c.length;){m=Wv(Rob(n),7);b=new aJ;Ue(b,Ao(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[m.b,m.e])))))));Ve(b,a,true);if(b.b!=0){t=Wv(re(Ktb(r.d,a)),34);if(m==a.d){o=t[t.length-1];s=true}else{o=t[0];s=false}for(i=1;i<t.length;i++){s?(p=t[t.length-1-i]):(p=t[i]);c=WI(b,0);while(c.b!=c.d.c){k=Wv(_ub(c),12);l=Wv(re(Ktb(r.d,k)),34);if(l==null){l=MP(k);Ltb(r.d,k,l)}if(l.length<=i){bvb(c)}else{s?(q=l[l.length-1-i]):(q=l[i]);if(p.a!=q.a||p.b!=q.b){e=p.a-o.a;g=p.b-o.b;f=q.a-o.a;h=q.b-o.b;f*g==h*e&&NP(e)==NP(f)&&NP(g)==NP(h)?((e<=0?0-e:e)<(f<=0?0-f:f)||(g<=0?0-g:g)<(h<=0?0-h:h))&&(TI(j,p,j.c.b,j.c),true):i>1&&(TI(j,o,j.c.b,j.c),true);bvb(c)}}}o=p}}}return j}
function m1(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p;a.n=Wv(rJ(a.g,(Rib(),Jib)),15).a*Wv(rJ(a.g,(Mjb(),Ejb)),15).a;a.e=a.n*Wv(rJ(a.g,qjb),15).a;a.i=a.g.c.c.length;h=a.i-1;m=0;a.j=0;a.k=0;a.a=Co(xv(PF,Txb,24,a.i,0,1));a.b=Co(xv(HF,Txb,184,a.i,6,1));for(g=new Tob(a.g.c);g.a<g.c.c.length;){e=Wv(Rob(g),16);e.k=h;for(l=new Tob(e.a);l.a<l.c.c.length;){k=Wv(Rob(l),9);k.k=m;++m}--h}a.f=xv(mw,Yyb,26,m,12,1);a.c=vv(mw,[Txb,Yyb],[52,26],12,[m,3],2);a.o=new GU;a.p=new GU;b=0;a.d=0;for(f=new Tob(a.g.c);f.a<f.c.c.length;){e=Wv(Rob(f),16);h=e.k;d=0;p=0;i=e.a.c.length;j=0;for(l=new Tob(e.a);l.a<l.c.c.length;){k=Wv(Rob(l),9);m=k.k;a.f[m]=k.d.k;j+=k.j.b+a.n;c=tl(iX(k));o=tl(mX(k));a.c[m][0]=o-c;a.c[m][1]=c;a.c[m][2]=o;d+=c;p+=o;c>0&&vU(a.p,k);vU(a.o,k)}b-=d;n=i+b;j+=b*a.e;DU(a.a,h,Elb(n));DU(a.b,h,j);a.j=Plb(a.j,n);a.k=Nlb(a.k,j);a.d+=b;b+=p}}
function sN(){sN=iI;var a;qN=new uN(szb,0);$M=new uN('NORTH',1);ZM=new uN('EAST',2);pN=new uN('SOUTH',3);rN=new uN('WEST',4);dN=(ypb(),new Frb((a=Wv(Hkb(Kz),11),new atb(a,Wv(exb(a,a.length),11),0))));eN=Kk(Vsb($M,Bv(tv(Kz,1),uyb,32,0,[])));_M=Kk(Vsb(ZM,Bv(tv(Kz,1),uyb,32,0,[])));mN=Kk(Vsb(pN,Bv(tv(Kz,1),uyb,32,0,[])));oN=Kk(Vsb(rN,Bv(tv(Kz,1),uyb,32,0,[])));jN=Kk(Vsb($M,Bv(tv(Kz,1),uyb,32,0,[pN])));cN=Kk(Vsb(ZM,Bv(tv(Kz,1),uyb,32,0,[rN])));lN=Kk(Vsb($M,Bv(tv(Kz,1),uyb,32,0,[rN])));fN=Kk(Vsb($M,Bv(tv(Kz,1),uyb,32,0,[ZM])));nN=Kk(Vsb(pN,Bv(tv(Kz,1),uyb,32,0,[rN])));aN=Kk(Vsb(ZM,Bv(tv(Kz,1),uyb,32,0,[pN])));iN=Kk(Vsb($M,Bv(tv(Kz,1),uyb,32,0,[ZM,rN])));bN=Kk(Vsb(ZM,Bv(tv(Kz,1),uyb,32,0,[pN,rN])));kN=Kk(Vsb($M,Bv(tv(Kz,1),uyb,32,0,[pN,rN])));gN=Kk(Vsb($M,Bv(tv(Kz,1),uyb,32,0,[ZM,pN])));hN=Kk(Vsb($M,Bv(tv(Kz,1),uyb,32,0,[ZM,pN,rN])))}
function q$(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;u=new GU;for(m=new Tob(a.c);m.a<m.c.c.length;){l=Wv(Rob(m),16);for(p=new Tob(l.a);p.a<p.c.c.length;){n=Wv(Rob(p),9);if(n.g!=(CX(),xX)){continue}if(rJ(n,(Rib(),gib))==null){continue}q=null;s=null;r=null;for(A=new Tob(n.f);A.a<A.c.c.length;){w=Wv(Rob(A),7);switch(w.g.e){case 4:q=w;break;case 2:s=w;break;default:r=w;}}t=Wv(yU(r.e,0),12);i=new kJ(t.a);h=new II(r.i);vI(h,n.i);j=WI(i,0);$ub(j,h);v=lJ(t.a);k=new II(r.i);vI(k,n.i);TI(v,k,v.c.b,v.c);B=Wv(rJ(n,gib),9);C=Wv(yU(B.f,0),7);g=Wv(FU(q.b,xv(dB,gAb,12,0,0,1)),47);for(d=0,f=g.length;d<f;++d){b=g[d];eW(b,C);gJ(b.a,b.a.b,i)}g=Wv(FU(s.e,xv(dB,gAb,12,s.e.c.length,0,1)),47);for(c=0,e=g.length;c<e;++c){b=g[c];dW(b,C);gJ(b.a,0,v)}dW(t,null);eW(t,null);u.c[u.c.length]=n}}for(o=new Tob(u);o.a<o.c.c.length;){n=Wv(Rob(o),9);rX(n,null)}}
function _tb(){function e(){this.obj=this.createObject()}
;e.prototype.createObject=function(a){return Object.create(null)};e.prototype.get=function(a){return this.obj[a]};e.prototype.set=function(a,b){this.obj[a]=b};e.prototype[$Ab]=function(a){delete this.obj[a]};e.prototype.keys=function(){return Object.getOwnPropertyNames(this.obj)};e.prototype.entries=function(){var b=this.keys();var c=this;var d=0;return {'next':function(){if(d>=b.length)return {'done':true};var a=b[d++];return {'value':[a,c.get(a)],'done':false}}}};if(!Ztb()){e.prototype.createObject=function(){return {}};e.prototype.get=function(a){return this.obj[':'+a]};e.prototype.set=function(a,b){this.obj[':'+a]=b};e.prototype[$Ab]=function(a){delete this.obj[':'+a]};e.prototype.keys=function(){var a=[];for(var b in this.obj){b.charCodeAt(0)==58&&a.push(b.substring(1))}return a}}return e}
function fQ(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u;k=new kW;sJ(k,PP,b);Umb(a.e,b,k);sJ(k,(Rib(),zib),c);!!a.d&&iQ(a.d,k,false);hQ(b,k);if(Lzb in b.a){q=k.a;r=Wv(Pu(b,Lzb),69);p=Wv(Pu(r,'left'),104);!!p&&(q.b=p.a);t=Wv(Pu(r,'top'),104);!!t&&(q.d=t.a);s=Wv(Pu(r,'right'),104);!!s&&(q.c=s.a);e=Wv(Pu(r,Azb),104);!!e&&(q.a=e.a)}l=(d=Wv(Hkb(mF),11),new atb(d,Wv(exb(d,d.length),11),0));sJ(k,jib,l);a.g==null&&(a.g=Xv(rJ(k,(zQ(),yQ))));if(Mzb in b.a){u=Pu(b,Mzb);if(!u.hc()){throw new GQ("The 'children' property of nodes must be an array.",u,b)}j=u.hc();if(j.a.length>0){!!c&&sJ(c,sib,k);h=xv(qB,Nzb,9,j.a.length,0,1);for(n=0;n<j.a.length;++n){i=gu(j,n);if(!i.kc()){throw new GQ("A 'children' array contains a non-object node element.",i,b)}f=eQ(a,i.kc(),k);h[n]=f}for(m=0;m<j.a.length;++m){o=gu(j,m).kc();g=h[m];Mzb in o.a&&!Ckb(Ixb(Xv(rJ(g,(eM(),KL)))))&&fQ(a,o,g)}}}return k}
function LO(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;if(!Qob(new Tob(AW(a.e)))){return}for(h=new Tob(AW(a.e));h.a<h.c.c.length;){g=Wv(Rob(h),161);j=Wv(g.e,7).g.e;++a.o[j];switch(Wv(g.e,7).g.e){case 4:case 2:a.n[j]+=g.e.j.b+(b?(d=Wv(g.e,7).d,new EP(d.d,d.b,d.a,d.c)).a+(e=Wv(g.e,7).d,new EP(e.d,e.b,e.a,e.c)).d:0);break;case 1:case 3:a.n[j]+=g.e.j.a+(b?(f=Wv(g.e,7).d,new EP(f.d,f.b,f.a,f.c)).b+(c=Wv(g.e,7).d,new EP(c.d,c.b,c.a,c.c)).c:0);}}i=Wv(oW(a.e,(eM(),NL)),100);i=i==(zM(),yM)?xM:i;a.g[1]=Wv(oW(a.e,PL),100);a.g[3]=Wv(oW(a.e,QL),100);a.g[4]=Wv(oW(a.e,RL),100);a.g[2]=Wv(oW(a.e,OL),100);for(l=(sN(),Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN])),n=0,p=l.length;n<p;++n){j=l[n];a.g[j.e]=a.g[j.e]==yM?i:a.g[j.e]}a.b=oW(a.e,jL)!=null;for(k=Bv(tv(Kz,1),uyb,32,0,[qN,$M,ZM,pN,rN]),m=0,o=k.length;m<o;++m){j=k[m];a.o[j.e]==1?(a.i[j.e]=2):!a.b&&a.g[j.e]==xM?(a.i[j.e]=a.o[j.e]+1):(a.i[j.e]=a.o[j.e]-1)}}
function Tfb(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;i=Wv(a.a,16);p=Wv(a.b,16);j=Wv(b.a,18);q=Wv(b.b,18);if(i){for(l=new Tob(i.a);l.a<l.c.c.length;){k=Wv(Rob(l),9);for(t=nX(k,(sN(),ZM)).mb();t.G();){s=Wv(t.H(),7);j.ib(s);for(h=new Tob(s.e);h.a<h.c.c.length;){g=Wv(Rob(h),12);if(bW(g)){continue}c.c[c.c.length]=g;Ufb(g,d);r=g.c.f.g;(r==(CX(),AX)||r==BX)&&(e.c[e.c.length]=g,true);v=g.d;u=v.f.d;u==p?q.ib(v):u==i?j.ib(v):BU(c,g)}}}}if(p){for(l=new Tob(p.a);l.a<l.c.c.length;){k=Wv(Rob(l),9);for(o=new Tob(k.f);o.a<o.c.c.length;){n=Wv(Rob(o),7);for(h=new Tob(n.e);h.a<h.c.c.length;){g=Wv(Rob(h),12);bW(g)&&(m=f.a.db(g,f),m==null)}}for(t=nX(k,(sN(),rN)).mb();t.G();){s=Wv(t.H(),7);q.ib(s);for(h=new Tob(s.e);h.a<h.c.c.length;){g=Wv(Rob(h),12);if(bW(g)){continue}c.c[c.c.length]=g;Ufb(g,d);r=g.c.f.g;(r==(CX(),AX)||r==BX)&&(e.c[e.c.length]=g,true);v=g.d;u=v.f.d;u==p?q.ib(v):u==i?j.ib(v):BU(c,g)}}}}}
function acb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B;t=b.c.length;e=new Cbb(a.b,c,null,null);B=xv(kw,hyb,26,t,12,1);p=xv(kw,hyb,26,t,12,1);o=xv(kw,hyb,26,t,12,1);q=0;for(h=0;h<t;h++){p[h]=$xb;o[h]=eyb}for(i=0;i<t;i++){d=(Cxb(i,b.c.length),Wv(b.c[i],81));B[i]=Abb(d);B[q]>B[i]&&(q=i);for(l=new Tob(a.b.c);l.a<l.c.c.length;){k=Wv(Rob(l),16);for(s=new Tob(k.a);s.a<s.c.c.length;){r=Wv(Rob(s),9);w=Ixb(d.n[r.k])+Ixb(d.d[r.k]);p[i]=p[i]<w?p[i]:w;o[i]=Nlb(o[i],w+r.j.b)}}}A=xv(kw,hyb,26,t,12,1);for(j=0;j<t;j++){(Cxb(j,b.c.length),Wv(b.c[j],81)).k==(Lbb(),Jbb)?(A[j]=p[q]-p[j]):(A[j]=o[q]-o[j])}f=xv(kw,hyb,26,t,12,1);for(n=new Tob(a.b.c);n.a<n.c.c.length;){m=Wv(Rob(n),16);for(v=new Tob(m.a);v.a<v.c.c.length;){u=Wv(Rob(v),9);for(g=0;g<t;g++){f[g]=Ixb((Cxb(g,b.c.length),Wv(b.c[g],81)).n[u.k])+Ixb((Cxb(g,b.c.length),Wv(b.c[g],81)).d[u.k])+A[g]}kpb(f);e.n[u.k]=(f[1]+f[2])/2;e.d[u.k]=0}}return e}
function Sfb(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;p=null;c==(fgb(),dgb)?(p=a):c==egb&&(p=b);for(r=(m=(new Snb(p.a)).a.bb().mb(),new Ynb(m));r.a.G();){q=(k=Wv(r.a.H(),21),Wv(k.yb(),7));s=MI(Bv(tv(qz,1),Fzb,10,0,[q.f.i,q.i,q.a])).b;v=new vtb;g=new vtb;for(i=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[q.b,q.e]))))));Cm(i);){h=Wv(Dm(i),12);if(Ckb(Ixb(Xv(rJ(h,(Rib(),Iib)))))!=d){continue}if(zU(e,h,0)!=-1){h.d==q?(t=h.c):(t=h.d);u=MI(Bv(tv(qz,1),Fzb,10,0,[t.f.i,t.i,t.a])).b;if((u-s<=0?0-(u-s):u-s)<0.2){continue}u<s?a.a.R(t)?stb(v,new RJ(dgb,h)):stb(v,new RJ(egb,h)):a.a.R(t)?stb(g,new RJ(dgb,h)):stb(g,new RJ(egb,h))}}if(v.a.Y()>1){vU(f,new mgb(q,v,c));for(o=(l=(new Snb(v.a)).a.bb().mb(),new Ynb(l));o.a.G();){n=(j=Wv(o.a.H(),21),Wv(j.yb(),27));BU(e,n.b)}}if(g.a.Y()>1){vU(f,new mgb(q,g,c));for(o=(l=(new Snb(g.a)).a.bb().mb(),new Ynb(l));o.a.G();){n=(j=Wv(o.a.H(),21),Wv(j.yb(),27));BU(e,n.b)}}}}
function dab(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;e=0;s=0;r=(mp(),new ntb);d=new ntb;f=new ntb;A=new ntb;fab(a,f,A);b=null;q=0;w=0;t=true;i=true;for(m=0,o=a.length;m<o;++m){k=a[m];for(v=new Tob(k.f);v.a<v.c.c.length;){u=Wv(Rob(v),7);switch(u.g.e){case 2:e+=cab(u,f);break;case 4:e+=cab(u,A);}}p=k.g;if(i&&(p==(CX(),AX)||p==BX)){j=Wv(rJ(k,(Rib(),nib)),9);if(!j){i=false;continue}if(b!=j){!!b&&Umb(r,b,new RJ(Elb(q),Elb(w)));b=j;q=0;w=0;t=true}k==b&&(t=false);if(t){q+=Wv(rJ(k,aib),24).a;Umb(d,k,Elb(q))}else{w+=Wv(rJ(k,aib),24).a;Umb(d,k,Elb(w))}}}!!b&&Umb(r,b,new RJ(Elb(q),Elb(w)));if(i){h=null;g=0;c=0;t=true;for(l=0,n=a.length;l<n;++l){k=a[l];p=k.g;switch(p.e){case 0:g=Wv(re(Ktb(d.d,k)),24).a;c=Wv(Wv(re(Ktb(r.d,k)),27).b,24).a;h=k;t=false;break;case 3:g=Wv(re(Ktb(d.d,k)),24).a;j=Wv(rJ(k,(Rib(),nib)),9);if(j!=h){c=Wv(Wv(re(Ktb(r.d,j)),27).a,24).a;h=j;t=true}break;default:s+=t?g:c-g;}}}return e+s}
function S4(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;l=(mp(),new ntb);j=new xk;for(d=new Tob(a.a.a.b);d.a<d.c.c.length;){b=Wv(Rob(d),25);if(aw(b,93)){k=Wv(b,93).b;Ltb(l.d,k,b)}else if(aw(b,82)){for(f=(o=(new Snb(Wv(b,82).d.a)).a.bb().mb(),new Ynb(o));f.a.G();){e=(g=Wv(f.a.H(),21),Wv(g.yb(),12));Fd(j,e,b)}}}for(c=new Tob(a.a.a.b);c.a<c.c.c.length;){b=Wv(Rob(c),25);if(aw(b,93)){k=Wv(b,93).b;for(i=Uh(mX(k));Cm(i);){h=Wv(Dm(i),12);if(bW(h)){continue}q=h.c;t=h.d;if((sN(),jN).kb(h.c.g)&&jN.kb(h.d.g)){continue}r=Wv(Smb(l,h.d.f),25);f7(i7(h7(j7(g7(new k7,0),100),a.c[b.f.d]),a.c[r.f.d]));if(q.g==rN&&TX((LX(),IX,q))){for(n=Wv(Dd(j,h),18).mb();n.G();){m=Wv(n.H(),25);if(m.j.d<b.j.d){p=a.c[m.f.d];s=a.c[b.f.d];if(p==s){continue}f7(i7(h7(j7(g7(new k7,1),100),p),s))}}}if(t.g==ZM&&WX((LX(),GX,t))){for(n=Wv(Dd(j,h),18).mb();n.G();){m=Wv(n.H(),25);if(m.j.d>b.j.d){p=a.c[b.f.d];s=a.c[m.f.d];if(p==s){continue}f7(i7(h7(j7(g7(new k7,1),100),p),s))}}}}}}}
function t3(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;g=new z3(a);h=Ao(pl(b,g));Gpb(h,new C3);e=a.b;switch(e.c){case 2:i=new E3(e.a);c=Al(pl(h,i));od(c)?(j=Wv(pd(c),91).b):(j=15);i=new E3(Jeb(e));c=Al(pl(h,i));od(c)?(f=Wv(pd(c),91).b):(f=15);i=new E3(e.b);c=Al(pl(h,i));od(c)?(k=Wv(pd(c),91).b):(k=15);d=p3(a,j,f,k);stb(b,new w3(d,a.c,a.e,a.a.c.f,e.a));stb(b,new w3(d,a.c,a.e,a.a.c.f,Jeb(e)));stb(b,new w3(d,a.c,a.e,a.a.c.f,e.b));break;case 1:i=new E3(e.a);c=Al(pl(h,i));od(c)?(j=Wv(pd(c),91).b):(j=15);i=new E3(e.b);c=Al(pl(h,i));od(c)?(k=Wv(pd(c),91).b):(k=15);d=q3(a,j,k);stb(b,new w3(d,a.c,a.e,a.a.c.f,e.a));stb(b,new w3(d,a.c,a.e,a.a.c.f,e.b));break;case 0:i=new E3(e.a);c=Al(pl(h,i));od(c)?(j=Wv(pd(c),91).b):(j=15);d=(l=a.b,m=xfb(a.a.c,a.a.d,j),Ue(a.a.a,Veb(m)),n=s3(a.a.b,m.a,l),o=new Dfb((!m.k&&(m.k=new Efb(Xeb(m))),m.k)),zfb(o),!n?o:Gfb(o,n));stb(b,new w3(d,a.c,a.e,a.a.c.f,e.a));break;default:throw new slb('The loopside must be defined.');}return d}
function Pbb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;for(h=new Tob(a.a.c);h.a<h.c.c.length;){f=Wv(Rob(h),16);for(t=new Tob(f.a);t.a<t.c.c.length;){s=Wv(Rob(t),9);b.f[s.k]=s;b.a[s.k]=s;b.d[s.k]=0}}i=a.a.c;b.c==(Gbb(),Ebb)&&(i=aw(i,87)?Ii(Wv(i,87)):aw(i,88)?Wv(i,88).a:aw(i,63)?new ap(i):new Ro(i));for(g=i.mb();g.G();){f=Wv(g.H(),16);n=-1;m=f.a;if(b.k==(Lbb(),Kbb)){n=$xb;m=aw(m,87)?Ii(Wv(m,87)):aw(m,88)?Wv(m,88).a:aw(m,63)?new ap(m):new Ro(m)}for(v=m.mb();v.G();){u=Wv(v.H(),9);b.c==Ebb?(l=Wv(yU(a.b.f,u.k),20)):(l=Wv(yU(a.b.b,u.k),20));if(l.Y()>0){d=l.Y();j=hw(Math.floor((d+1)/2))-1;e=hw(Math.ceil((d+1)/2))-1;if(b.k==Kbb){for(k=e;k>=j;k--){if(b.a[u.k]==u){p=Wv(l.sb(k),27);o=Wv(p.a,9);if(!ttb(c,p.b)&&n>a.b.e[o.k]){b.a[o.k]=u;b.f[u.k]=b.f[o.k];b.a[u.k]=b.f[u.k];n=a.b.e[o.k]}}}}else{for(k=j;k<=e;k++){if(b.a[u.k]==u){r=Wv(l.sb(k),27);q=Wv(r.a,9);if(!ttb(c,r.b)&&n<a.b.e[q.k]){b.a[q.k]=u;b.f[u.k]=b.f[q.k];b.a[u.k]=b.f[u.k];n=a.b.e[q.k]}}}}}}}}
function Ieb(){Ieb=iI;meb=new Peb('N',0,(sN(),$M),$M,0);jeb=new Peb('EN',1,ZM,$M,1);ieb=new Peb('E',2,ZM,ZM,0);peb=new Peb('SE',3,pN,ZM,1);oeb=new Peb('S',4,pN,pN,0);Heb=new Peb('WS',5,rN,pN,1);Geb=new Peb('W',6,rN,rN,0);neb=new Peb('NW',7,$M,rN,1);keb=new Peb('ENW',8,ZM,rN,2);leb=new Peb('ESW',9,ZM,rN,2);qeb=new Peb('SEN',10,pN,$M,2);Eeb=new Peb('SWN',11,pN,$M,2);Feb=new Peb(szb,12,qN,qN,3);feb=bk(meb,jeb,ieb,peb,oeb,Heb,Bv(tv(_E,1),uyb,60,0,[Geb,neb,keb,leb,qeb,Eeb]));heb=(hi(),Zj(Bv(tv(UF,1),syb,1,4,[meb,ieb,oeb,Geb])));geb=Zj(Bv(tv(UF,1),syb,1,4,[jeb,peb,Heb,neb]));veb=new Gr($M);seb=Zj(Bv(tv(UF,1),syb,1,4,[ZM,$M]));reb=new Gr(ZM);yeb=Zj(Bv(tv(UF,1),syb,1,4,[pN,ZM]));xeb=new Gr(pN);Deb=Zj(Bv(tv(UF,1),syb,1,4,[rN,pN]));Ceb=new Gr(rN);web=Zj(Bv(tv(UF,1),syb,1,4,[$M,rN]));teb=Zj(Bv(tv(UF,1),syb,1,4,[ZM,$M,rN]));ueb=Zj(Bv(tv(UF,1),syb,1,4,[ZM,pN,rN]));Aeb=Zj(Bv(tv(UF,1),syb,1,4,[pN,rN,$M]));zeb=Zj(Bv(tv(UF,1),syb,1,4,[pN,ZM,$M]));Beb=(kr(),jr)}
function JZ(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u;s=0;if(b.e.a==0){for(q=new Tob(a);q.a<q.c.c.length;){o=Wv(Rob(q),9);s=Nlb(s,o.i.a+o.j.a+o.e.c)}}else{s=b.e.a-b.d.a}s-=b.d.a;for(p=new Tob(a);p.a<p.c.c.length;){o=Wv(Rob(p),9);IZ(o.i,s-o.j.a);GZ(o);switch(Wv(rJ(o,(eM(),lL)),103).e){case 1:sJ(o,lL,(iK(),gK));break;case 2:sJ(o,lL,(iK(),fK));}r=o.j;for(u=new Tob(o.f);u.a<u.c.c.length;){t=Wv(Rob(u),7);IZ(t.i,r.a-t.j.a);IZ(t.a,t.j.a);QX(t,CZ(t.g));g=Wv(rJ(t,UL),24);!!g&&sJ(t,UL,Elb(-g.a));for(f=new Tob(t.e);f.a<f.c.c.length;){e=Wv(Rob(f),12);for(d=WI(e.a,0);d.b!=d.d.c;){c=Wv(_ub(d),10);c.a=s-c.a}j=Wv(rJ(e,CL),44);if(j){for(i=WI(j,0);i.b!=i.d.c;){h=Wv(_ub(i),10);h.a=s-h.a}}for(m=new Tob(e.b);m.a<m.c.c.length;){k=Wv(Rob(m),33);IZ(k.i,s-k.j.a)}}for(n=new Tob(t.c);n.a<n.c.c.length;){k=Wv(Rob(n),33);IZ(k.i,-k.j.a)}}if(o.g==(CX(),xX)){sJ(o,(Rib(),hib),CZ(Wv(rJ(o,hib),32)));FZ(o)}for(l=new Tob(o.c);l.a<l.c.c.length;){k=Wv(Rob(l),33);IZ(k.i,r.a-k.j.a)}}}
function LZ(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u;s=0;if(b.e.b==0){for(q=new Tob(a);q.a<q.c.c.length;){o=Wv(Rob(q),9);s=Nlb(s,o.i.b+o.j.b+o.e.a)}}else{s=b.e.b-b.d.b}s-=b.d.b;for(p=new Tob(a);p.a<p.c.c.length;){o=Wv(Rob(p),9);KZ(o.i,s-o.j.b);HZ(o);switch(Wv(rJ(o,(eM(),lL)),103).e){case 3:sJ(o,lL,(iK(),dK));break;case 4:sJ(o,lL,(iK(),hK));}r=o.j;for(u=new Tob(o.f);u.a<u.c.c.length;){t=Wv(Rob(u),7);KZ(t.i,r.b-t.j.b);KZ(t.a,t.j.b);QX(t,DZ(t.g));g=Wv(rJ(t,UL),24);!!g&&sJ(t,UL,Elb(-g.a));for(f=new Tob(t.e);f.a<f.c.c.length;){e=Wv(Rob(f),12);for(d=WI(e.a,0);d.b!=d.d.c;){c=Wv(_ub(d),10);c.b=s-c.b}j=Wv(rJ(e,CL),44);if(j){for(i=WI(j,0);i.b!=i.d.c;){h=Wv(_ub(i),10);h.b=s-h.b}}for(m=new Tob(e.b);m.a<m.c.c.length;){k=Wv(Rob(m),33);KZ(k.i,s-k.j.b)}}for(n=new Tob(t.c);n.a<n.c.c.length;){k=Wv(Rob(n),33);KZ(k.i,-k.j.b)}}if(o.g==(CX(),xX)){sJ(o,(Rib(),hib),DZ(Wv(rJ(o,hib),32)));EZ(o)}for(l=new Tob(o.c);l.a<l.c.c.length;){k=Wv(Rob(l),33);KZ(k.i,r.b-k.j.b)}}}
function qP(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;d=new VN(b.e.i.a,b.e.i.b,b.e.j.a,b.e.j.b);e=new UN;if(a.c){for(g=new Tob(zW(b));g.a<g.c.c.length;){f=Wv(Rob(g),129);e.d=f.e.i.a+b.e.i.a;e.e=f.e.i.b+b.e.i.b;e.c=f.e.j.a;e.b=f.e.j.b;TN(d,e)}}for(k=new Tob(AW(b));k.a<k.c.c.length;){j=Wv(Rob(k),161);l=j.e.i.a+b.e.i.a;m=j.e.i.b+b.e.i.b;if(a.e){e.d=l;e.e=m;e.c=j.e.j.a;e.b=j.e.j.b;TN(d,e)}if(a.d){for(g=new Tob(DW(j));g.a<g.c.c.length;){f=Wv(Rob(g),129);e.d=f.e.i.a+l;e.e=f.e.i.b+m;e.c=f.e.j.a;e.b=f.e.j.b;TN(d,e)}}if(a.b){n=new HI(-c,-c);if(gw(oW(b,(eM(),VL)))===gw((UM(),TM))){for(g=new Tob(DW(j));g.a<g.c.c.length;){f=Wv(Rob(g),129);n.a+=f.e.j.a+c;n.b+=f.e.j.b+c}}n.a=Nlb(n.a,0);n.b=Nlb(n.b,0);pP(d,EW(j),CW(j),b,j,n,c)}}a.b&&pP(d,(ypb(),ypb(),vpb),(null,vpb),b,null,null,c);i=new FP((h=Wv(b.e,9).e,new EP(h.d,h.b,h.a,h.c)));i.d=b.e.i.b-d.e;i.a=d.e+d.b-(b.e.i.b+b.e.j.b);i.b=b.e.i.a-d.d;i.c=d.d+d.c-(b.e.i.a+b.e.j.a);Wv(b.e,9).e.b=i.b;Wv(b.e,9).e.d=i.d;Wv(b.e,9).e.c=i.c;Wv(b.e,9).e.a=i.a}
function XT(){XT=iI;WT=new xk;Fd(WT,(sN(),dN),hN);Fd(WT,oN,kN);Fd(WT,oN,hN);Fd(WT,_M,gN);Fd(WT,_M,hN);Fd(WT,eN,iN);Fd(WT,eN,hN);Fd(WT,mN,bN);Fd(WT,mN,hN);Fd(WT,jN,cN);Fd(WT,jN,iN);Fd(WT,jN,bN);Fd(WT,jN,hN);Fd(WT,cN,jN);Fd(WT,cN,kN);Fd(WT,cN,gN);Fd(WT,cN,hN);Fd(WT,lN,lN);Fd(WT,lN,iN);Fd(WT,lN,kN);Fd(WT,fN,fN);Fd(WT,fN,iN);Fd(WT,fN,gN);Fd(WT,nN,nN);Fd(WT,nN,bN);Fd(WT,nN,kN);Fd(WT,aN,aN);Fd(WT,aN,bN);Fd(WT,aN,gN);Fd(WT,iN,eN);Fd(WT,iN,jN);Fd(WT,iN,lN);Fd(WT,iN,fN);Fd(WT,iN,iN);Fd(WT,iN,kN);Fd(WT,iN,gN);Fd(WT,iN,hN);Fd(WT,bN,mN);Fd(WT,bN,jN);Fd(WT,bN,nN);Fd(WT,bN,aN);Fd(WT,bN,bN);Fd(WT,bN,kN);Fd(WT,bN,gN);Fd(WT,bN,hN);Fd(WT,kN,oN);Fd(WT,kN,cN);Fd(WT,kN,lN);Fd(WT,kN,nN);Fd(WT,kN,iN);Fd(WT,kN,bN);Fd(WT,kN,kN);Fd(WT,kN,hN);Fd(WT,gN,_M);Fd(WT,gN,cN);Fd(WT,gN,fN);Fd(WT,gN,aN);Fd(WT,gN,iN);Fd(WT,gN,bN);Fd(WT,gN,gN);Fd(WT,gN,hN);Fd(WT,hN,dN);Fd(WT,hN,oN);Fd(WT,hN,_M);Fd(WT,hN,eN);Fd(WT,hN,mN);Fd(WT,hN,jN);Fd(WT,hN,cN);Fd(WT,hN,iN);Fd(WT,hN,bN);Fd(WT,hN,kN);Fd(WT,hN,gN);Fd(WT,hN,hN)}
function Tbb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;if(c.n[b.k]!=null){return}i=true;c.n[b.k]=0;g=b;r=c.k==(Lbb(),Jbb)?Vzb:Uzb;do{e=a.b.e[g.k];f=g.d.a.c.length;h=g.g;if(c.k==Jbb&&e>0||c.k==Kbb&&e<f-1){c.k==Kbb?(j=Wv(yU(g.d.a,e+1),9)):(j=Wv(yU(g.d.a,e-1),9));l=c.f[j.k];k=j.g;Tbb(a,l,c);r=a.e.Ic(r,b,g);c.i[b.k]==b&&(c.i[b.k]=c.i[l.k]);if(c.i[b.k]==c.i[l.k]){q=Wjb(a.d,h,k);if(c.k==Kbb){d=Ixb(c.n[b.k]);n=Ixb(c.n[l.k])+Ixb(c.d[j.k])-j.e.d-q-g.e.a-g.j.b-Ixb(c.d[g.k]);if(i){i=false;c.n[b.k]=n<r?n:r}else{c.n[b.k]=d<(n<r?n:r)?d:n<r?n:r}}else{d=Ixb(c.n[b.k]);n=Ixb(c.n[l.k])+Ixb(c.d[j.k])+j.j.b+j.e.a+q+g.e.d-Ixb(c.d[g.k]);if(i){i=false;c.n[b.k]=n>r?n:r}else{c.n[b.k]=d>(n>r?n:r)?d:n>r?n:r}}}else{q=a.d.f;p=Rbb(a,c.i[b.k]);m=Rbb(a,c.i[l.k]);if(c.k==Kbb){o=Ixb(c.n[b.k])+Ixb(c.d[g.k])+g.j.b+g.e.a+q-(Ixb(c.n[l.k])+Ixb(c.d[j.k])-j.e.d);Xbb(p,m,o)}else{o=Ixb(c.n[b.k])+Ixb(c.d[g.k])-g.e.d-Ixb(c.n[l.k])-Ixb(c.d[j.k])-j.j.b-j.e.a-q;Xbb(p,m,o)}}}else{r=a.e.Ic(r,b,g)}g=c.a[g.k]}while(g!=b);ycb(a.e,b)}
function sZ(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;m=false;l=false;if(MM(Wv(rJ(d,(eM(),TL)),28))){g=false;h=false;t:for(o=new Tob(d.f);o.a<o.c.c.length;){n=Wv(Rob(o),7);for(q=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[new fY(n),new lY(n)]))))));Cm(q);){p=Wv(Dm(q),7);if(!Ckb(Ixb(Xv(rJ(p.f,qL))))){if(n.g==(sN(),$M)){g=true;break t}if(n.g==pN){h=true;break t}}}}m=h&&!g;l=g&&!h}if(!m&&!l&&d.c.c.length!=0){k=0;for(j=new Tob(d.c);j.a<j.c.c.length;){i=Wv(Rob(j),33);k+=i.i.b+i.j.b/2}k/=d.c.c.length;s=k>=d.j.b/2}else{s=!l}if(s){r=Wv(rJ(d,(Rib(),Qib)),20);if(!r){f=new GU;sJ(d,Qib,f)}else if(m){f=r}else{e=Wv(rJ(d,Yhb),20);if(!e){f=new GU;sJ(d,Yhb,f)}else{r.Y()<=e.Y()?(f=r):(f=e)}}}else{e=Wv(rJ(d,(Rib(),Yhb)),20);if(!e){f=new GU;sJ(d,Yhb,f)}else if(l){f=e}else{r=Wv(rJ(d,Qib),20);if(!r){f=new GU;sJ(d,Qib,f)}else{e.Y()<=r.Y()?(f=e):(f=r)}}}f.ib(a);sJ(a,(Rib(),Zhb),c);if(b.d==c){eW(b,null);c.b.c.length+c.e.c.length==0&&PX(c,null)}else{dW(b,null);c.b.c.length+c.e.c.length==0&&PX(c,null)}_I(b.a)}
function rU(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;c=new bV(b);c.a||kU(b);j=jU(b);i=new xk;q=new oV;for(p=new Tob(b.b);p.a<p.c.c.length;){o=Wv(Rob(p),9);for(e=Uh(mX(o));Cm(e);){d=Wv(Dm(e),12);if(d.c.f.g==(CX(),xX)||d.d.f.g==xX){k=qU(a,d,j,q);Fd(i,oU(k.d),k.a)}}}g=new GU;for(t=Wv(rJ(c.c,(Rib(),fib)),18).mb();t.G();){s=Wv(t.H(),32);n=q.c[s.e];m=q.b[s.e];h=q.a[s.e];f=null;r=null;switch(s.e){case 4:f=new VN(a.d.a,n,j.b.a-a.d.a,m-n);r=new VN(a.d.a,n,h,m-n);YU(j,new HI(f.d+f.c,f.e));YU(j,new HI(f.d+f.c,f.e+f.b));break;case 2:f=new VN(j.a.a,n,a.c.a-j.a.a,m-n);r=new VN(a.c.a-h,n,h,m-n);YU(j,new HI(f.d,f.e));YU(j,new HI(f.d,f.e+f.b));break;case 1:f=new VN(n,a.d.b,m-n,j.b.b-a.d.b);r=new VN(n,a.d.b,m-n,h);YU(j,new HI(f.d,f.e+f.b));YU(j,new HI(f.d+f.c,f.e+f.b));break;case 3:f=new VN(n,j.a.b,m-n,a.c.b-j.a.b);r=new VN(n,a.c.b-h,m-n,h);YU(j,new HI(f.d,f.e));YU(j,new HI(f.d+f.c,f.e));}if(f){l=new jV;l.d=s;l.b=f;l.c=r;l.a=pr(Wv(Dd(i,oU(s)),18));g.c[g.c.length]=l}}xU(c.b,g);c.d=pT(tT(j));return c}
function tt(){var a=['\\u0000','\\u0001','\\u0002','\\u0003','\\u0004','\\u0005','\\u0006','\\u0007','\\b','\\t','\\n','\\u000B','\\f','\\r','\\u000E','\\u000F','\\u0010','\\u0011','\\u0012','\\u0013','\\u0014','\\u0015','\\u0016','\\u0017','\\u0018','\\u0019','\\u001A','\\u001B','\\u001C','\\u001D','\\u001E','\\u001F'];a[34]='\\"';a[92]='\\\\';a[173]='\\u00ad';a[1536]='\\u0600';a[1537]='\\u0601';a[1538]='\\u0602';a[1539]='\\u0603';a[1757]='\\u06dd';a[1807]='\\u070f';a[6068]='\\u17b4';a[6069]='\\u17b5';a[8203]='\\u200b';a[8204]='\\u200c';a[8205]='\\u200d';a[8206]='\\u200e';a[8207]='\\u200f';a[8232]='\\u2028';a[8233]='\\u2029';a[8234]='\\u202a';a[8235]='\\u202b';a[8236]='\\u202c';a[8237]='\\u202d';a[8238]='\\u202e';a[8288]='\\u2060';a[8289]='\\u2061';a[8290]='\\u2062';a[8291]='\\u2063';a[8292]='\\u2064';a[8298]='\\u206a';a[8299]='\\u206b';a[8300]='\\u206c';a[8301]='\\u206d';a[8302]='\\u206e';a[8303]='\\u206f';a[65279]='\\ufeff';a[65529]='\\ufff9';a[65530]='\\ufffa';a[65531]='\\ufffb';return a}
function eab(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;b=0;r=true;w=null;for(d=0;d<a.length;d++){f=a[d];q=f.g;if(q==(CX(),AX)){w=f;r=false}else if(q==BX){if(aw(rJ(f,(Rib(),uib)),12)){continue}c=Wv(rJ(f,uib),9);if(w!=c){w=c;r=true}if(!LM(Wv(rJ(c,(eM(),TL)),28))){continue}m=null;o=null;for(t=new Tob(f.f);t.a<t.c.c.length;){s=Wv(Rob(t),7);s.b.c.length==0?s.e.c.length==0||(o=Wv(rJ(s,uib),7)):(m=Wv(rJ(s,uib),7))}for(e=d+1;e<a.length;e++){g=a[e];l=g.g;if(l==AX){break}else if(l==BX){if(gw(rJ(g,uib))!==gw(c)){break}h=null;j=null;for(v=new Tob(g.f);v.a<v.c.c.length;){u=Wv(Rob(v),7);u.b.c.length==0?u.e.c.length==0||(j=Wv(rJ(u,uib),7)):(h=Wv(rJ(u,uib),7))}if(r){n=false;p=false;if(!!o&&!!h&&o.k<h.k){++b;p=true}if(!!m&&!!j&&m.k>j.k){++b;n=true}if(!!o&&!!j&&o.k>j.k){++b;p=true}if(!!m&&!!h&&m.k<h.k){++b;n=true}n&&p&&m==o&&--b}else{i=false;k=false;if(!!m&&!!j&&m.k<j.k){++b;k=true}if(!!o&&!!h&&o.k>h.k){++b;i=true}if(!!m&&!!h&&m.k<h.k){++b;i=true}if(!!o&&!!j&&o.k>j.k){++b;k=true}i&&k&&h==j&&--b}}}}}return b}
function Oab(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D;for(t=a.a,u=0,v=t.length;u<v;++u){s=t[u];j=$xb;k=$xb;for(o=new Tob(s.f);o.a<o.c.c.length;){m=Wv(Rob(o),9);g=!m.d?-1:zU(m.d.a,m,0);if(g>0){l=Wv(yU(m.d.a,g-1),9);B=Xjb(a.b,m,l);q=m.i.b-m.e.d-(l.i.b+l.j.b+l.e.a+B)}else{q=m.i.b-m.e.d}j=q<j?q:j;if(g<m.d.a.c.length-1){l=Wv(yU(m.d.a,g+1),9);B=Xjb(a.b,m,l);r=l.i.b-l.e.d-(m.i.b+m.j.b+m.e.a+B)}else{r=2*m.i.b}k=r<k?r:k}i=$xb;f=false;e=Wv(yU(s.f,0),9);for(D=new Tob(e.f);D.a<D.c.c.length;){C=Wv(Rob(D),7);p=e.i.b+C.i.b+C.a.b;for(d=new Tob(C.b);d.a<d.c.c.length;){c=Wv(Rob(d),12);w=c.c;b=w.f.i.b+w.i.b+w.a.b-p;if((b<=0?0-b:b)<(i<=0?0-i:i)&&(b<=0?0-b:b)<(b<0?j:k)){i=b;f=true}}}h=Wv(yU(s.f,s.f.c.length-1),9);for(A=new Tob(h.f);A.a<A.c.c.length;){w=Wv(Rob(A),7);p=h.i.b+w.i.b+w.a.b;for(d=new Tob(w.e);d.a<d.c.c.length;){c=Wv(Rob(d),12);C=c.d;b=C.f.i.b+C.i.b+C.a.b-p;if((b<=0?0-b:b)<(i<=0?0-i:i)&&(b<=0?0-b:b)<(b<0?j:k)){i=b;f=true}}}if(f&&i!=0){for(n=new Tob(s.f);n.a<n.c.c.length;){m=Wv(Rob(n),9);m.i.b+=i}}}}
function bU(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D;l=dU($T(a,(sN(),dN)),b);o=cU($T(a,eN),b);u=cU($T(a,mN),b);B=eU($T(a,oN),b);m=eU($T(a,_M),b);s=cU($T(a,lN),b);p=cU($T(a,fN),b);w=cU($T(a,nN),b);v=cU($T(a,aN),b);C=eU($T(a,cN),b);r=cU($T(a,jN),b);t=cU($T(a,iN),b);A=cU($T(a,bN),b);D=eU($T(a,kN),b);n=eU($T(a,gN),b);q=cU($T(a,hN),b);c=oJ(Bv(tv(kw,1),hyb,26,12,[s.a,B.a,w.a,D.a]));d=oJ(Bv(tv(kw,1),hyb,26,12,[o.a,l.a,u.a,q.a]));e=r.a;f=oJ(Bv(tv(kw,1),hyb,26,12,[p.a,m.a,v.a,n.a]));j=oJ(Bv(tv(kw,1),hyb,26,12,[s.b,o.b,p.b,t.b]));i=oJ(Bv(tv(kw,1),hyb,26,12,[B.b,l.b,m.b,q.b]));k=C.b;h=oJ(Bv(tv(kw,1),hyb,26,12,[w.b,u.b,v.b,A.b]));VT($T(a,dN),c+e,j+k);VT($T(a,hN),c+e,j+k);VT($T(a,eN),c+e,0);VT($T(a,mN),c+e,j+k+i);VT($T(a,oN),0,j+k);VT($T(a,_M),c+e+d,j+k);VT($T(a,fN),c+e+d,0);VT($T(a,nN),0,j+k+i);VT($T(a,aN),c+e+d,j+k+i);VT($T(a,cN),0,j);VT($T(a,jN),c,0);VT($T(a,bN),0,j+k+i);VT($T(a,gN),c+e+d,0);g=new FI;g.a=oJ(Bv(tv(kw,1),hyb,26,12,[c+d+e+f,C.a,t.a,A.a]));g.b=oJ(Bv(tv(kw,1),hyb,26,12,[j+i+k+h,r.b,D.b,n.b]));return g}
function Nfb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;d=new jJ;j=null;o=a.c;n=o.f.g;if(n!=(CX(),AX)&&n!=BX){throw new slb('The target node of the edge must be a normal node or a northSouthPort.')}if(n==BX){m=Wv(rJ(o,(Rib(),uib)),7);j=new HI(MI(Bv(tv(qz,1),Fzb,10,0,[m.f.i,m.i,m.a])).a,MI(Bv(tv(qz,1),Fzb,10,0,[o.f.i,o.i,o.a])).b);o=m}SI(d,MI(Bv(tv(qz,1),Fzb,10,0,[o.f.i,o.i,o.a])));g=Nlb(5,pgb(o.f,o.g));l=new GI(sgb(o.g));l.a*=g;l.b*=g;QI(d,vI(l,MI(Bv(tv(qz,1),Fzb,10,0,[o.f.i,o.i,o.a]))));!!j&&TI(d,j,d.c.b,d.c);f=a;i=a;h=null;c=false;while(f){e=f.a;if(e.b!=0){if(c){QI(d,CI(vI(h,(Bxb(e.b!=0),Wv(e.a.a.c,10))),0.5));c=false}else{c=true}h=xI((Bxb(e.b!=0),Wv(e.c.b.c,10)));Ue(d,e);_I(e)}i=f;f=Wv(re(Ktb(b.d,f)),12)}p=i.d;if(p.f.g==BX){m=Wv(rJ(p,(Rib(),uib)),7);QI(d,new HI(MI(Bv(tv(qz,1),Fzb,10,0,[m.f.i,m.i,m.a])).a,MI(Bv(tv(qz,1),Fzb,10,0,[p.f.i,p.i,p.a])).b));p=m}g=Nlb(5,pgb(p.f,p.g));l=new GI(sgb(p.g));CI(l,g);QI(d,vI(l,MI(Bv(tv(qz,1),Fzb,10,0,[p.f.i,p.i,p.a]))));SI(d,MI(Bv(tv(qz,1),Fzb,10,0,[p.f.i,p.i,p.a])));k=new efb(d);Ue(a.a,Veb(k))}
function bZ(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o;if(gw(rJ(a.c,(eM(),TL)))===gw((KM(),GM))||gw(rJ(a.c,TL))===gw(FM)){for(k=new Tob(a.c.f);k.a<k.c.c.length;){j=Wv(Rob(k),7);if(j.g==(sN(),$M)||j.g==pN){return false}}}for(d=Uh(mX(a.c));Cm(d);){c=Wv(Dm(d),12);if(c.c.f==c.d.f){return false}}if(MM(Wv(rJ(a.c,TL),28))){n=new GU;for(i=nX(a.c,(sN(),rN)).mb();i.G();){g=Wv(i.H(),7);vU(n,Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[g.b,g.e]))))))}o=(_b(n),new Vh(n));n=new GU;for(h=nX(a.c,ZM).mb();h.G();){g=Wv(h.H(),7);vU(n,Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[g.b,g.e]))))))}b=(_b(n),new Vh(n))}else{o=iX(a.c);b=mX(a.c)}f=!sl(mX(a.c));e=!sl(iX(a.c));if(!f&&!e){return false}if(!f){a.e=1;return true}if(!e){a.e=0;return true}if(Ul((Il(),new Im(Dl(ul(o.a,new yl)))))==1){l=(_b(o),Wv(Ql(new Im(Dl(ul(o.a,new yl)))),12)).c.f;if(l.g==(CX(),zX)&&Wv(rJ(l,(Rib(),qib)),7).f!=a.c){a.e=2;return true}}if(Ul(new Im(Dl(ul(b.a,new yl))))==1){m=(_b(b),Wv(Ql(new Im(Dl(ul(b.a,new yl)))),12)).d.f;if(m.g==(CX(),zX)&&Wv(rJ(m,(Rib(),rib)),7).f!=a.c){a.e=3;return true}}return false}
function K$(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;d=new GU;e=$xb;f=$xb;g=$xb;if(c){e=a.e.a;for(p=new Tob(b.f);p.a<p.c.c.length;){o=Wv(Rob(p),7);for(i=new Tob(o.e);i.a<i.c.c.length;){h=Wv(Rob(i),12);if(h.a.b!=0){k=Wv(UI(h.a),10);if(k.a<e){f=e-k.a;g=$xb;d.c=xv(UF,syb,1,0,4,1);e=k.a}if(k.a<=e){d.c[d.c.length]=h;h.a.b>1&&(g=Qlb(g,Jlb(Wv(tn(h.a,1),10).b-k.b)))}}}}}else{for(p=new Tob(b.f);p.a<p.c.c.length;){o=Wv(Rob(p),7);for(i=new Tob(o.b);i.a<i.c.c.length;){h=Wv(Rob(i),12);if(h.a.b!=0){m=Wv(VI(h.a),10);if(m.a>e){f=m.a-e;g=$xb;d.c=xv(UF,syb,1,0,4,1);e=m.a}if(m.a>=e){d.c[d.c.length]=h;h.a.b>1&&(g=Qlb(g,Jlb(Wv(tn(h.a,h.a.b-2),10).b-m.b)))}}}}}if(d.c.length!=0&&f>b.j.a/2&&g>b.j.b/2){n=new RX;PX(n,b);QX(n,(sN(),$M));n.i.a=b.j.a/2;r=new RX;PX(r,b);QX(r,pN);r.i.a=b.j.a/2;r.i.b=b.j.b;for(i=new Tob(d);i.a<i.c.c.length;){h=Wv(Rob(i),12);if(c){j=Wv(YI(h.a),10);q=h.a.b==0?MX(h.d):Wv(UI(h.a),10);q.b>=j.b?dW(h,r):dW(h,n)}else{j=Wv(ZI(h.a),10);q=h.a.b==0?MX(h.c):Wv(VI(h.a),10);q.b>=j.b?eW(h,r):eW(h,n)}l=Wv(rJ(h,(eM(),CL)),44);!!l&&Ve(l,j,true)}b.i.a=e-b.j.a/2}}
function N2(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;r=new GU;s=new GU;t=new GU;for(f=new Tob(b);f.a<f.c.c.length;){e=Wv(Rob(f),75);e.k>50?(r.c[r.c.length]=e,true):e.k>0?(s.c[s.c.length]=e,true):(t.c[t.c.length]=e,true)}if(s.c.length==1&&r.c.length==0){xU(r,s);s.c=xv(UF,syb,1,0,4,1)}r.c.length!=0&&Zsb(U2(a.a),(Ieb(),meb))&&Zsb(U2(a.a),(Ieb(),oeb))?L2(a,r):xU(s,r);s.c.length==0||M2(a,s);if(t.c.length!=0){c=V2(a.a);if(c.c!=0){k=new Tob(t);i=(_b(c),Nl((new vl(c)).a));while(k.a<k.c.c.length){e=Wv(Rob(k),75);while(k.a<k.c.c.length&&e.a.a.Y()<2){e=Wv(Rob(k),75)}if(e.a.a.Y()>1){p=Wv(nm(i),60);aeb(e,p,true);Sob(k);Y2(a.a,p)}}}m=t.c.length;d=O2(a);n=new GU;g=m/T2(a.a).c|0;for(h=0;h<g;h++){xU(n,T2(a.a))}o=m%T2(a.a).c;if(o>3){xU(n,(Ieb(),Ieb(),geb));o-=4}switch(o){case 3:vU(n,Meb(d));case 2:q=Leb(Meb(d));do{q=Leb(q)}while(!Zsb(U2(a.a),q));n.c[n.c.length]=q;q=Neb(Meb(d));do{q=Neb(q)}while(!Zsb(U2(a.a),q));n.c[n.c.length]=q;break;case 1:vU(n,Meb(d));}l=new Tob(n);j=new Tob(t);while(l.a<l.c.c.length&&j.a<j.c.c.length){aeb(Wv(Rob(j),75),Wv(Rob(l),60),true)}}}
function G9(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;k=b.c.c.length;a.a=xv(qB,Txb,51,k,0,2);a.b=xv(qB,Txb,51,k,0,2);a.k=xv(qB,Txb,51,k,0,2);i=xv(mw,Yyb,26,k,12,1);g=xv(KH,xAb,26,k,13,1);a.c=xv(KH,xAb,26,k,13,1);a.d=xv(KH,xAb,26,k,13,1);r=0;v=0;m=new Fnb(b.c,0);while(m.b<m.d.Y()){j=(Bxb(m.b<m.d.Y()),Wv(m.d.sb(m.c=m.b++),16));l=m.b-1;n=j.a.c.length;a.a[l]=xv(qB,Nzb,9,n,0,1);a.k[l]=xv(qB,Nzb,9,n,0,1);a.b[l]=xv(qB,Nzb,9,n,0,1);i[l]=0;g[l]=false;s=new Fnb(j.a,0);while(s.b<s.d.Y()){q=(Bxb(s.b<s.d.Y()),Wv(s.d.sb(s.c=s.b++),9));a.b[l][s.b-1]=q;q.k=r++;o=Wv(rJ(q,(Rib(),nib)),9);!!o&&(Nm(a.g,o,q,null),true);for(u=new Tob(q.f);u.a<u.c.c.length;){t=Wv(Rob(u),7);t.k=v++;for(f=new Tob(t.e);f.a<f.c.c.length;){e=Wv(Rob(f),12);e.d.f.d==j&&++i[l]}t.g==(sN(),ZM)?t.e.c.length+t.b.c.length>1&&(a.c[l]=true):t.g==rN&&t.e.c.length+t.b.c.length>1&&(a.d[l]=true)}if(q.g==(CX(),BX)){++i[l];g[l]=true}}}c=true;p=true;for(h=0;h<a.d.length-1;h++){d=a.c[h]||a.d[h+1];c=c&d;p=p&!d}a.j=xv(lw,tAb,26,v,12,1);w=xv(mw,Yyb,26,v,12,1);if(!c){a.i=new iab(i,g,w);a.f=a.i}if(!p){a.e=new mab(i,g,w);a.f=a.e}}
function iU(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B;a.d=new HI(Uzb,Uzb);a.c=new HI(Vzb,Vzb);for(m=b.mb();m.G();){k=Wv(m.H(),55);for(t=new Tob(k.b);t.a<t.c.c.length;){s=Wv(Rob(t),9);a.d.a=Qlb(a.d.a,s.i.a-s.e.b);a.d.b=Qlb(a.d.b,s.i.b-s.e.d);a.c.a=Nlb(a.c.a,s.i.a+s.j.a+s.e.c);a.c.b=Nlb(a.c.b,s.i.b+s.j.b+s.e.a)}}h=new cV;for(l=b.mb();l.G();){k=Wv(l.H(),55);d=rU(a,k);vU(h.a,d);d.a=d.a|!Wv(rJ(d.c,(Rib(),fib)),18).V()}a.b=(xR(),B=new HR,B.f=new kR(c),B.b=jR(B.f,h),B);BR((o=a.b,new sI,o));a.e=new FI;a.a=a.b.f.e;for(g=new Tob(h.a);g.a<g.c.c.length;){e=Wv(Rob(g),347);u=CR(a.b,e);TW(e.c,u.a,u.b);for(q=new Tob(e.c.b);q.a<q.c.c.length;){p=Wv(Rob(q),9);if(p.g==(CX(),xX)){r=mU(a,p.i,Wv(rJ(p,(Rib(),hib)),32));vI(BI(p.i),r)}}}for(f=new Tob(h.a);f.a<f.c.c.length;){e=Wv(Rob(f),347);for(j=new Tob(aV(e));j.a<j.c.c.length;){i=Wv(Rob(j),12);A=new kJ(i.a);rn(A,0,MX(i.c));QI(A,MX(i.d));n=null;for(w=WI(A,0);w.b!=w.d.c;){v=Wv(_ub(w),10);if(!n){n=v;continue}if(Xs(n.a,v.a)){a.e.a=Qlb(a.e.a,n.a);a.a.a=Nlb(a.a.a,n.a)}else if(Xs(n.b,v.b)){a.e.b=Qlb(a.e.b,n.b);a.a.b=Nlb(a.a.b,n.b)}n=v}}}zI(a.e);vI(a.a,a.e)}
function U1(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F;p=new HU(b.b);u=new HU(b.b);m=new HU(b.b);B=new HU(b.b);q=new HU(b.b);for(A=WI(b,0);A.b!=A.d.c;){v=Wv(_ub(A),7);for(h=new Tob(v.e);h.a<h.c.c.length;){f=Wv(Rob(h),12);if(f.c.f==f.d.f){if(v.g==f.d.g){B.c[B.c.length]=f;continue}else if(v.g==(sN(),$M)&&f.d.g==pN){q.c[q.c.length]=f;continue}}}}for(i=new Tob(q);i.a<i.c.c.length;){f=Wv(Rob(i),12);V1(a,f,c,d,(sN(),ZM))}for(g=new Tob(B);g.a<g.c.c.length;){f=Wv(Rob(g),12);C=new uX(a);sX(C,(CX(),BX));sJ(C,(eM(),TL),(KM(),FM));sJ(C,(Rib(),uib),f);D=new RX;sJ(D,uib,f.d);QX(D,(sN(),rN));PX(D,C);F=new RX;sJ(F,uib,f.c);QX(F,ZM);PX(F,C);sJ(f.c,Bib,C);sJ(f.d,Bib,C);dW(f,null);eW(f,null);c.c[c.c.length]=C;sJ(C,aib,Elb(2))}for(w=WI(b,0);w.b!=w.d.c;){v=Wv(_ub(w),7);j=v.b.c.length>0;r=v.e.c.length>0;j&&r?(m.c[m.c.length]=v,true):j?(p.c[p.c.length]=v,true):r&&(u.c[u.c.length]=v,true)}for(o=new Tob(p);o.a<o.c.c.length;){n=Wv(Rob(o),7);vU(e,T1(a,n,null,c))}for(t=new Tob(u);t.a<t.c.c.length;){s=Wv(Rob(t),7);vU(e,T1(a,null,s,c))}for(l=new Tob(m);l.a<l.c.c.length;){k=Wv(Rob(l),7);vU(e,T1(a,k,k,c))}}
function ZP(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;u=new II(b.d);i=new GU;for(t=new Tob(b.b);t.a<t.c.c.length;){r=Wv(Rob(t),9);n=Wv(Smb(a.j,r),69);if(n){$P(a,r,n,u);for(w=new Tob(r.f);w.a<w.c.c.length;){v=Wv(Rob(w),7);o=Wv(Smb(a.n,v),69);if(o){$P(a,v,o,QP);WP(o,(eM(),WL),new lv(yc(v.g)))}if(gw(rJ(r,(eM(),VL)))!==gw((UM(),RM))){for(q=new Tob(v.c);q.a<q.c.c.length;){p=Wv(Rob(q),33);m=Wv(Smb(a.f,p),69);$P(a,p,m,QP)}}}if(Wv(rJ(r,(eM(),JL)),86).Y()!=0){for(q=new Tob(r.c);q.a<q.c.c.length;){p=Wv(Rob(q),33);m=Wv(Smb(a.f,p),69);$P(a,p,m,QP)}}for(h=Uh(mX(r));Cm(h);){f=Wv(Dm(h),12);SW(f.d.f,r)||(i.c[i.c.length]=f,true)}}}A=Wv(rJ(b,(Rib(),zib)),9);if(A){for(h=Uh(mX(A));Cm(h);){f=Wv(Dm(h),12);SW(f.d.f,A)&&(i.c[i.c.length]=f,true)}}for(g=new Tob(i);g.a<g.c.c.length;){f=Wv(Rob(g),12);l=Wv(Smb(a.b,f),69);YP(a,f,l,u);for(q=new Tob(f.b);q.a<q.c.c.length;){p=Wv(Rob(q),33);m=Wv(Smb(a.f,p),69);$P(a,p,m,u)}}c=(d=Wv(rJ(b,Xhb),15).a,new HI(b.e.a+b.a.b+b.a.c+2*d,b.e.b+b.a.d+b.a.a+2*d));k=Wv(rJ(b,zib),9);if(k){k.j.a=c.a;k.j.b=c.b}j=Wv(rJ(b,PP),69);VP(a,j,Jzb,c.a);VP(a,j,Kzb,c.b);for(s=new Tob(b.b);s.a<s.c.c.length;){r=Wv(Rob(s),9);e=Wv(rJ(r,sib),55);!!e&&ZP(a,e)}}
function Xfb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H;F=new aJ;B=new aJ;r=-1;for(i=new Tob(a);i.a<i.c.c.length;){g=Wv(Rob(i),77);g.i=r--;l=0;v=0;for(f=new Tob(g.j);f.a<f.c.c.length;){d=Wv(Rob(f),117);v+=d.c}for(e=new Tob(g.d);e.a<e.c.c.length;){d=Wv(Rob(e),117);l+=d.c}g.e=l;g.k=v;v==0?(TI(B,g,B.c.b,B.c),true):l==0&&(TI(F,g,F.c.b,F.c),true)}H=new Yub((Oh(),a));m=a.c.length;q=m+1;s=m-1;o=new GU;while(H.a.Y()!=0){while(B.b!=0){A=(Bxb(B.b!=0),Wv($I(B,B.a.a),77));H.a.eb(A)!=null;A.i=s--;agb(A,F,B)}while(F.b!=0){C=(Bxb(F.b!=0),Wv($I(F,F.a.a),77));H.a.eb(C)!=null;C.i=q++;agb(C,F,B)}p=eyb;for(j=(t=(new Snb(H.a)).a.bb().mb(),new Ynb(t));j.a.G();){g=(k=Wv(j.a.H(),21),Wv(k.yb(),77));u=g.k-g.e;if(u>=p){if(u>p){o.c=xv(UF,syb,1,0,4,1);p=u}o.c[o.c.length]=g}}if(o.c.length!=0){n=Wv(yU(o,vvb(b,o.c.length)),77);H.a.eb(n)!=null;n.i=q++;agb(n,F,B);o.c=xv(UF,syb,1,0,4,1)}}w=a.c.length+1;for(h=new Tob(a);h.a<h.c.c.length;){g=Wv(Rob(h),77);g.i<m&&(g.i+=w)}for(D=new Tob(a);D.a<D.c.c.length;){C=Wv(Rob(D),77);c=new Fnb(C.j,0);while(c.b<c.d.Y()){d=(Bxb(c.b<c.d.Y()),Wv(c.d.sb(c.c=c.b++),117));G=d.b;if(C.i>G.i){vnb(c);BU(G.d,d);if(d.c>0){d.a=G;vU(G.j,d);d.b=C;vU(C.d,d)}}}}}
function OO(a){var b,c,d;for(d=new Lsb((new Fsb(a.c)).a);htb(d.a);){c=(d.b=itb(d.a),new Psb(d.c,d.b));b=Wv(c.b.b[c.a.e],62);switch(Wv(c.a,67).e){case 0:b.d=0;b.e=-(b.b+a.d);break;case 1:b.d=(a.e.e.j.a-b.c)/2;b.e=-(b.b+a.d);break;case 2:b.d=a.e.e.j.a-b.c;b.e=-(b.b+a.d);break;case 3:b.d=0;b.e=a.e.e.j.b+a.d;break;case 4:b.d=(a.e.e.j.a-b.c)/2;b.e=a.e.e.j.b+a.d;break;case 5:b.d=a.e.e.j.a-b.c;b.e=a.e.e.j.b+a.d;break;case 6:b.d=-(b.c+a.d);b.e=0;break;case 7:b.d=-(b.c+a.d);b.e=(a.e.e.j.b-b.b)/2;break;case 8:b.d=-(b.c+a.d);b.e=a.e.e.j.b-b.b;break;case 9:b.d=a.e.e.j.a+a.d;b.e=0;break;case 10:b.d=a.e.e.j.a+a.d;b.e=(a.e.e.j.b-b.b)/2;break;case 11:b.d=a.e.e.j.a+a.d;b.e=a.e.e.j.b-b.b;break;case 12:b.d=a.q.b+a.d;b.e=a.q.d+a.d;break;case 13:b.d=(a.e.e.j.a-b.c)/2;b.e=a.q.d+a.d;break;case 14:b.d=a.e.e.j.a-a.q.c-b.c-a.d;b.e=a.q.d+a.d;break;case 15:b.d=a.q.b+a.d;b.e=(a.e.e.j.b-b.b)/2;break;case 16:b.d=(a.e.e.j.a-b.c)/2;b.e=(a.e.e.j.b-b.b)/2;break;case 17:b.d=a.e.e.j.a-a.q.c-b.c-a.d;b.e=(a.e.e.j.b-b.b)/2;break;case 18:b.d=a.q.b+a.d;b.e=a.e.e.j.b-a.q.a-b.b-a.d;break;case 19:b.d=(a.e.e.j.a-b.c)/2;b.e=a.e.e.j.b-a.q.a-b.b-a.d;break;case 20:b.d=a.e.e.j.a-a.q.c-b.c-a.d;b.e=a.e.e.j.b-a.q.a-b.b-a.d;}}}
function ddb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I;F=new aJ;B=new aJ;o=-1;for(s=new Tob(a);s.a<s.c.c.length;){q=Wv(Rob(s),80);q.d=o--;i=0;v=0;for(f=new Tob(q.e);f.a<f.c.c.length;){d=Wv(Rob(f),118);v+=d.c}for(e=new Tob(q.b);e.a<e.c.c.length;){d=Wv(Rob(e),118);i+=d.c}q.c=i;q.f=v;v==0?(TI(B,q,B.c.b,B.c),true):i==0&&(TI(F,q,F.c.b,F.c),true)}H=(I=new Vwb,ml(I,a),I);j=a.c.length;p=j-1;n=j+1;l=new GU;while(H.a.c!=0){while(B.b!=0){A=(Bxb(B.b!=0),Wv($I(B,B.a.a),80));cwb(H.a,A)!=null;A.d=p--;jdb(A,F,B)}while(F.b!=0){C=(Bxb(F.b!=0),Wv($I(F,F.a.a),80));cwb(H.a,C)!=null;C.d=n++;jdb(C,F,B)}m=eyb;for(t=(h=new rwb((new wwb((new Gob(H.a)).a)).b),new Mob(h));Bnb(t.a.a);){q=(g=pwb(t.a),Wv(g.yb(),80));u=q.f-q.c;if(u>=m){if(u>m){l.c=xv(UF,syb,1,0,4,1);m=u}l.c[l.c.length]=q}}if(l.c.length!=0){k=Wv(yU(l,vvb(b,l.c.length)),80);cwb(H.a,k)!=null;k.d=n++;jdb(k,F,B);l.c=xv(UF,syb,1,0,4,1)}}w=a.c.length+1;for(r=new Tob(a);r.a<r.c.c.length;){q=Wv(Rob(r),80);q.d<j&&(q.d+=w)}for(D=new Tob(a);D.a<D.c.c.length;){C=Wv(Rob(D),80);c=new Fnb(C.e,0);while(c.b<c.d.Y()){d=(Bxb(c.b<c.d.Y()),Wv(c.d.sb(c.c=c.b++),118));G=d.b;if(C.d>G.d){vnb(c);BU(G.b,d);if(d.c>0){d.a=G;vU(G.e,d);d.b=C;vU(C.b,d)}}}}}
function e0(a){switch(a.e){case 14:return new wY;case 37:return new SY;case 8:return new YY;case 30:return new cZ;case 38:return new qZ;case 3:return new tZ;case 47:case 1:return new SZ((XZ(),WZ));case 4:return new wZ;case 49:return new AZ;case 23:return new $5;case 13:return new d$;case 34:return new j$;case 40:return new w$;case 35:return new F$;case 44:return new o4;case 28:return new I$;case 39:return new L$;case 27:return new N$;case 6:return new R$;case 31:return new m0;case 9:return new q0;case 43:return new w0;case 17:return new A0;case 18:return new G0;case 29:return new S0;case 11:return new q1;case 12:return new Z0;case 36:return new _0;case 46:case 0:return new SZ((XZ(),VZ));case 41:return new b1;case 15:return new e1;case 33:return new k1;case 42:return new R1;case 22:return new X1;case 19:return new k0;case 10:return new _1;case 7:return new c2;case 24:return new f2;case 21:return new h2;case 16:return new n2;case 45:return new q2;case 26:return new x2;case 20:return new A2;case 25:return new H2;case 5:return new l3;case 32:return new u3;case 48:case 2:return new SZ((XZ(),UZ));default:throw new slb('No implementation is available for the layout processor '+(a.d!=null?a.d:''+a.e));}}
function PO(a){var b,c,d,e,f,g,h;c=a.e.e.j;a.b?(b=Wv(oW(a.e,(eM(),jL)),65)):(b=new EP(a.k,a.k,a.k,a.k));e=c.a;(a.b||a.g[1]!=(zM(),xM))&&(e-=b.b+b.c);f=c.a;(a.b||a.g[3]!=(zM(),xM))&&(f-=b.b+b.c);g=c.b;(a.b||a.g[4]!=(zM(),xM))&&(g-=b.d+b.a);d=c.b;(a.b||a.g[2]!=(zM(),xM))&&(d-=b.d+b.a);if(aP(a,(sN(),$M))==(zM(),xM)){a.j[1]=(e-dP(a,$M))/bP(a,$M);a.f=a.b?b.b+(eP(a,$M)==1?a.j[1]:0):a.j[1]}else{a.j[1]=a.k;h=dP(a,$M)+a.j[1]*(eP(a,$M)-1);switch(aP(a,$M).e){case 2:a.f=b.b;break;case 3:a.f=b.b+(e-h)/2;break;case 4:a.f=c.a-h-b.c;}}if(aP(a,pN)==xM){a.j[3]=(f-dP(a,pN))/bP(a,pN);a.r=c.a-(a.b?b.c+(eP(a,pN)==1?a.j[3]:0):a.j[3])}else{a.j[3]=a.k;h=dP(a,pN)+a.j[3]*(eP(a,pN)-1);switch(aP(a,pN).e){case 2:a.r=h+b.b;break;case 3:a.r=c.a-(f-h)/2-b.c;break;case 4:a.r=c.a-b.c;}}if(aP(a,rN)==xM){a.j[4]=(g-dP(a,rN))/bP(a,rN);a.s=c.b-(a.b?b.a+(eP(a,rN)==1?a.j[4]:0):a.j[4])}else{a.j[4]=a.k;h=dP(a,rN)+a.j[4]*(eP(a,rN)-1);switch(aP(a,rN).e){case 2:a.s=h+b.d;break;case 3:a.s=c.b-(g-h)/2-b.a;break;case 4:a.s=c.b-b.a;}}if(aP(a,ZM)==xM){a.j[2]=(d-dP(a,ZM))/bP(a,ZM);a.a=a.b?b.d+(eP(a,ZM)==1?a.j[2]:0):a.j[2]}else{a.j[2]=a.k;h=dP(a,ZM)+a.j[2]*(eP(a,ZM)-1);switch(aP(a,ZM).e){case 2:a.a=b.d;break;case 3:a.a=b.d+(d-h)/2;break;case 4:a.a=c.b-h-b.a;}}}
function hab(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I;G=0;g=0;l=b[0].d;B=c[0].d;for(o=0,q=c.length;o<q;++o){m=c[o];if(LM(Wv(rJ(m,(eM(),TL)),28))){s=0;for(v=new Tob(m.f);v.a<v.c.c.length;){u=Wv(Rob(v),7);if(u.g==(sN(),$M)){for(f=new Tob(u.b);f.a<f.c.c.length;){e=Wv(Rob(f),12);if(e.c.f.d==l){++s;break}}}else{break}}t=0;A=new Fnb(m.f,m.f.c.length);while(A.b>0){u=(Bxb(A.b>0),Wv(A.a.sb(A.c=--A.b),7));w=0;for(f=new Tob(u.b);f.a<f.c.c.length;){e=Wv(Rob(f),12);e.c.f.d==l&&++w}if(w>0){if(u.g==(sN(),$M)){a.a[u.k]=G;++G}else{a.a[u.k]=G+s+t;++t}g+=w}}G+=t}else{r=0;for(v=new Tob(m.f);v.a<v.c.c.length;){u=Wv(Rob(v),7);for(f=new Tob(u.b);f.a<f.c.c.length;){e=Wv(Rob(f),12);e.c.f.d==l&&++r}a.a[u.k]=G}if(r>0){++G;g+=r}}}C=xv(mw,Yyb,26,g,12,1);i=0;for(n=0,p=b.length;n<p;++n){m=b[n];if(LM(Wv(rJ(m,(eM(),TL)),28))){for(v=new Tob(m.f);v.a<v.c.c.length;){u=Wv(Rob(v),7);D=i;for(f=new Tob(u.e);f.a<f.c.c.length;){e=Wv(Rob(f),12);F=e.d;F.f.d==B&&kab(C,D,i++,a.a[F.k])}}}else{D=i;for(v=new Tob(m.f);v.a<v.c.c.length;){u=Wv(Rob(v),7);for(f=new Tob(u.e);f.a<f.c.c.length;){e=Wv(Rob(f),12);F=e.d;F.f.d==B&&kab(C,D,i++,a.a[F.k])}}}}h=1;while(h<G){h*=2}I=2*h-1;h-=1;H=xv(mw,Yyb,26,I,12,1);d=0;for(k=0;k<g;k++){j=C[k]+h;++H[j];while(j>0){j%2>0&&(d+=H[j+1]);j=(j-1)/2|0;++H[j]}}return d}
function BV(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J;nI(b,'Compound graph postprocessor',1);c=Ckb(Ixb(Xv(rJ(a,(Mjb(),gjb)))));h=Wv(rJ(a,(Rib(),bib)),144);l=new vtb;for(w=h.W().mb();w.G();){v=Wv(w.H(),12);g=new IU(h.U(v));Gpb(g,new $V(a));F=VV((Cxb(0,g.c.length),Wv(g.c[0],114)));H=WV(Wv(yU(g,g.c.length-1),114));_I(v.a);C=F.f;SW(H.f,C)?(B=Wv(rJ(C,sib),55)):(B=hX(C));o=Wv(rJ(v,(eM(),CL)),44);if(ol(g,zV)){if(!o){o=new jJ;sJ(v,CL,o)}else{_I(o)}}else !!o&&sJ(v,CL,null);q=null;for(f=new Tob(g);f.a<f.c.c.length;){e=Wv(Rob(f),114);u=new FI;MW(u,e.a,B);r=e.b;d=new jJ;gJ(d,0,r.a);hJ(d,u);D=new II(MX(r.c));G=new II(MX(r.d));D.a+=u.a;D.b+=u.b;G.a+=u.a;G.b+=u.b;if(q){d.b==0?(t=G):(t=(Bxb(d.b!=0),Wv(d.a.a.c,10)));I=Jlb(q.a-t.a)>dAb;J=Jlb(q.b-t.b)>dAb;(!c&&I&&J||c&&(I||J))&&QI(v.a,D)}Ue(v.a,d);d.b==0?(q=D):(q=(Bxb(d.b!=0),Wv(d.c.b.c,10)));s=Wv(rJ(r,CL),44);if(s){n=new jJ;gJ(n,0,s);hJ(n,u);Ue(o,n)}if(WV(e)==H){if(hX(H.f)!=e.a){u=new FI;MW(u,hX(H.f),B)}sJ(v,Pib,u)}p=new Fnb(r.b,0);while(p.b<p.d.Y()){i=(Bxb(p.b<p.d.Y()),Wv(p.d.sb(p.c=p.b++),33));if(gw(rJ(i,xib))!==gw(v)){continue}MW(i.i,hX(r.c.f),B);vnb(p);vU(v.b,i)}l.a.db(r,l)}dW(v,F);eW(v,H)}for(k=(A=(new Snb(l.a)).a.bb().mb(),new Ynb(A));k.a.G();){j=(m=Wv(k.a.H(),21),Wv(m.yb(),12));dW(j,null);eW(j,null)}pI(b)}
function c$(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I;C=Wv(rJ(a,(eM(),TL)),28);if(!(C!=(KM(),IM)&&C!=JM)){return}p=a.c;o=p.c.length;l=new HU((Mh(o+2,Uyb),$s(PH(PH(5,o+2),(o+2)/10|0))));q=new HU((Mh(o+2,Uyb),$s(PH(PH(5,o+2),(o+2)/10|0))));vU(l,new ntb);vU(l,new ntb);vU(q,new GU);vU(q,new GU);A=new vtb;for(b=0;b<o;b++){c=(Cxb(b,p.c.length),Wv(p.c[b],16));D=(Cxb(b,l.c.length),Wv(l.c[b],57));r=(mp(),new ntb);l.c[l.c.length]=r;G=(Cxb(b,q.c.length),Wv(q.c[b],20));t=new GU;q.c[q.c.length]=t;for(e=new Tob(c.a);e.a<e.c.c.length;){d=Wv(Rob(e),9);for(j=Uh(iX(d));Cm(j);){h=Wv(Dm(j),12);H=h.c.f;if(!_Z(H)){continue}A.a.db(H,A);F=Wv(D.cb(rJ(H,(Rib(),uib))),9);if(!F){F=$Z(a,H);D.db(rJ(H,uib),F);G.ib(F)}dW(h,Wv(yU(F.f,1),7))}for(i=Uh(mX(d));Cm(i);){h=Wv(Dm(i),12);I=h.d.f;if(!_Z(I)){continue}A.a.db(I,A);s=Wv(Smb(r,rJ(I,(Rib(),uib))),9);if(!s){s=$Z(a,I);Umb(r,rJ(I,uib),s);t.c[t.c.length]=s}eW(h,Wv(yU(s.f,0),7))}}}for(m=0;m<q.c.length;m++){u=(Cxb(m,q.c.length),Wv(q.c[m],20));if(u.V()){continue}if(m==0){n=new sY(a);Fxb(0,p.c.length);fxb(p.c,0,n)}else if(m==l.c.length-1){n=new sY(a);p.c[p.c.length]=n}else{n=(Cxb(m-1,p.c.length),Wv(p.c[m-1],16))}for(g=u.mb();g.G();){f=Wv(g.H(),9);rX(f,n)}}for(w=(B=(new Snb(A.a)).a.bb().mb(),new Ynb(B));w.a.G();){v=(k=Wv(w.a.H(),21),Wv(k.yb(),9));rX(v,null)}}
function Pab(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K;I=new GU;for(o=new Tob(b.c);o.a<o.c.c.length;){m=Wv(Rob(o),16);for(v=new Tob(m.a);v.a<v.c.c.length;){u=Wv(Rob(v),9);u.k=-1;l=eyb;B=eyb;for(D=new Tob(u.f);D.a<D.c.c.length;){C=Wv(Rob(D),7);for(e=new Tob(C.b);e.a<e.c.c.length;){c=Wv(Rob(e),12);F=Wv(rJ(c,(Rib(),Eib)),24).a;l=l>F?l:F}for(d=new Tob(C.e);d.a<d.c.c.length;){c=Wv(Rob(d),12);F=Wv(rJ(c,(Rib(),Eib)),24).a;B=B>F?B:F}}sJ(u,Fab,Elb(l));sJ(u,Gab,Elb(B))}}r=0;for(n=new Tob(b.c);n.a<n.c.c.length;){m=Wv(Rob(n),16);for(v=new Tob(m.a);v.a<v.c.c.length;){u=Wv(Rob(v),9);if(u.k<0){H=new Wab;H.b=r++;Mab(a,u,H);I.c[I.c.length]=H}}}A=Do(I.c.length);k=Do(I.c.length);for(g=0;g<I.c.length;g++){vU(A,new GU);vU(k,Elb(0))}Kab(b,I,A,k);J=Wv(FU(I,xv(wE,NAb,111,I.c.length,0,1)),625);w=Wv(FU(A,xv(sH,{3:1,5:1,6:1,672:1},20,A.c.length,0,1)),672);j=xv(mw,Yyb,26,k.c.length,12,1);for(h=0;h<j.length;h++){j[h]=(Cxb(h,k.c.length),Wv(k.c[h],24)).a}s=0;t=new GU;for(i=0;i<J.length;i++){j[i]==0&&vU(t,J[i])}q=xv(mw,Yyb,26,J.length,12,1);while(t.c.length!=0){H=Wv(AU(t,0),111);q[H.b]=s++;while(!w[H.b].V()){K=Wv(w[H.b].vb(0),111);--j[K.b];j[K.b]==0&&(t.c[t.c.length]=K,true)}}a.a=xv(wE,NAb,111,J.length,0,1);for(f=0;f<J.length;f++){p=J[f];G=q[f];a.a[G]=p;p.b=G;for(v=new Tob(p.f);v.a<v.c.c.length;){u=Wv(Rob(v),9);u.k=G}}return a.a}
function JP(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;nI(b,'Fixed Layout',1);i=Wv(rJ(a,(eM(),uL)),122);p=0;q=0;for(t=new Tob(a.b);t.a<t.c.c.length;){r=Wv(Rob(t),9);B=Wv(rJ(r,YL),10);if(B){r.i.a=B.a;r.i.b=B.b;if(Wv(rJ(r,aM),86).kb((DN(),zN))){C=Wv(rJ(r,IL),15).a;j=Wv(rJ(r,HL),15).a;C>0&&j>0&&WW(r,new HI(C,j),true)}}p=Nlb(p,r.i.a+r.j.a);q=Nlb(q,r.i.b+r.j.b);for(n=new Tob(r.c);n.a<n.c.c.length;){l=Wv(Rob(n),33);B=Wv(rJ(l,YL),10);if(B){l.i.a=B.a;l.i.b=B.b}p=Nlb(p,r.i.a+l.i.a+l.j.a);q=Nlb(q,r.i.b+l.i.b+l.j.b)}for(v=new Tob(r.f);v.a<v.c.c.length;){u=Wv(Rob(v),7);B=Wv(rJ(u,YL),10);if(B){u.i.a=B.a;u.i.b=B.b}w=r.i.a+u.i.a;A=r.i.b+u.i.b;p=Nlb(p,w+u.j.a);q=Nlb(q,A+u.j.b);for(m=new Tob(u.c);m.a<m.c.c.length;){l=Wv(Rob(m),33);B=Wv(rJ(l,YL),10);if(B){l.i.a=B.a;l.i.b=B.b}p=Nlb(p,w+l.i.a+l.j.a);q=Nlb(q,A+l.i.b+l.j.b)}}for(h=Uh(mX(r));Cm(h);){f=Wv(Dm(h),12);o=KP(f);p=Nlb(p,o.a);q=Nlb(q,o.b)}for(g=Uh(iX(r));Cm(g);){f=Wv(Dm(g),12);if(gw(rJ(f.c.f,(Rib(),sib)))!==gw(a)){o=KP(f);p=Nlb(p,o.a);q=Nlb(q,o.b)}}}if(i==(NK(),JK)){for(s=new Tob(a.b);s.a<s.c.c.length;){r=Wv(Rob(s),9);for(g=Uh(mX(r));Cm(g);){f=Wv(Dm(g),12);k=LP(f);k.b==0?sJ(f,CL,null):sJ(f,CL,k)}}}a.e.a=p;a.e.b=q;sJ(a,aM,(DN(),d=Wv(Hkb(Lz),11),new atb(d,Wv(exb(d,d.length),11),0)));e=Wv(rJ(a,(Rib(),zib)),9);!!e&&sJ(e,aM,(c=Wv(Hkb(Lz),11),new atb(c,Wv(exb(c,c.length),11),0)));pI(b)}
function Y8(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G;if(!LM(Wv(rJ(b,(eM(),TL)),28))){if(b.f.c.length>1){A=xv(LF,Txb,15,a.a.length,0,1);j=Do(a.a.length);p=0;o=0;c=2*b.d.a.c.length+1;H:for(w=new Tob(b.f);w.a<w.c.c.length;){v=Wv(Rob(w),7);r=v.g==(sN(),$M)||v.g==pN;G=0;if(r){B=Wv(rJ(v,(Rib(),Bib)),9);if(!B){continue}m=false;u=false;for(D=new Tob(B.f);D.a<D.c.c.length;){C=Wv(Rob(D),7);gw(rJ(C,uib))===gw(v)&&(C.e.c.length==0?C.b.c.length==0||(m=true):(u=true))}m&&!u?(G=v.g==$M?-(!B.d?-1:zU(B.d.a,B,0)):c-(!B.d?-1:zU(B.d.a,B,0))):u&&!m?(G=(!B.d?-1:zU(B.d.a,B,0))+1):m&&u&&(G=v.g==$M?0:c/2)}else{for(t=new Tob(v.e);t.a<t.c.c.length;){s=Wv(Rob(t),12);e=s.d;if(e.f.d==b.d){j.c[j.c.length]=v;continue H}else{G+=a.a[e.k]}}for(l=new Tob(v.b);l.a<l.c.c.length;){k=Wv(Rob(l),12);e=k.c;if(e.f.d==b.d){j.c[j.c.length]=v;continue H}else{G-=a.a[e.k]}}}if(v.b.c.length+v.e.c.length>0){A[v.k]=new llb(G/(v.b.c.length+v.e.c.length));p=Rlb(p,A[v.k].a);o=Olb(o,A[v.k].a)}else r&&(A[v.k]=new llb(G))}q=(!b.d?-1:zU(b.d.a,b,0))+1;n=b.d.a.c.length+1;for(i=new Tob(j);i.a<i.c.c.length;){h=Wv(Rob(i),7);G=0;g=0;for(f=Uh(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[new fY(h),new lY(h)]))))));Cm(f);){e=Wv(Dm(f),7);if(e.f.d==b.d){G+=jX(e.f)+1;++g}}d=G/g;F=h.g;F==(sN(),ZM)?d<q?(A[h.k]=new llb(p-d)):(A[h.k]=new llb(o+(n-d))):F==rN&&(d<q?(A[h.k]=new llb(o+d)):(A[h.k]=new llb(p-(n-d))))}Gpb(b.f,new a9(A))}sJ(b,TL,(KM(),EM))}}
function O4(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;B=new GU;a.a.b.c=xv(UF,syb,1,0,4,1);u=(mp(),new ntb);for(r=new Tob(a.d.c);r.a<r.c.c.length;){p=Wv(Rob(r),16);for(t=new Tob(p.a);t.a<t.c.c.length;){s=Wv(Rob(t),9);if(Ckb(Ixb(Xv(rJ(s,(eM(),qL)))))){if(!sl(gX(s))){h=Wv(ql(gX(s)),12);v=h.c.f;v==s&&(v=h.d.f);w=new RJ(v,EI(xI(s.i),v.i));Umb(a.b,s,w);continue}}f=new Q3(s,a.d);vU(a.a.b,f);Ltb(u.d,s,f)}}for(q=new Tob(a.d.c);q.a<q.c.c.length;){p=Wv(Rob(q),16);for(t=new Tob(p.a);t.a<t.c.c.length;){s=Wv(Rob(t),9);f=Wv(re(Ktb(u.d,s)),25);for(k=Uh(mX(s));Cm(k);){i=Wv(Dm(k),12);d=WI(i.a,0);l=true;o=null;if(d.b!=d.d.c){b=Wv(_ub(d),10);if(i.c.g==(sN(),$M)){C=new X4(b,new HI(b.a,f.j.e),f,i);C.c=true;B.c[B.c.length]=C}if(i.c.g==pN){C=new X4(b,new HI(b.a,f.j.e+f.j.b),f,i);C.d=true;B.c[B.c.length]=C}while(d.b!=d.d.c){c=Wv(_ub(d),10);if(!RR(b.b,c.b)){o=new X4(b,c,null,i);B.c[B.c.length]=o;if(l){l=false;if(c.b<f.j.e){o.c=true}else if(c.b>f.j.e+f.j.b){o.d=true}else{o.d=true;o.c=true}}}d.b!=d.d.c&&(b=c)}if(o){g=Wv(Smb(u,i.d.f),25);if(b.b<g.j.e){o.c=true}else if(b.b>g.j.e+g.j.b){o.d=true}else{o.d=true;o.c=true}}}}for(j=Uh(iX(s));Cm(j);){i=Wv(Dm(j),12);if(i.a.b!=0){b=Wv(VI(i.a),10);if(i.d.g==(sN(),$M)){C=new X4(b,new HI(b.a,f.j.e),f,i);C.c=true;B.c[B.c.length]=C}if(i.d.g==pN){C=new X4(b,new HI(b.a,f.j.e+f.j.b),f,i);C.d=true;B.c[B.c.length]=C}}}}}if(B.c.length!=0){ypb();Gpb(B,null);n=(Cxb(0,B.c.length),Wv(B.c[0],142));e=new L3(n,a.d);for(m=1;m<B.c.length;m++){A=(Cxb(m,B.c.length),Wv(B.c[m],142));if(RR(e.j.d,A.j)&&!(TR(e.j.e+e.j.b,A.k)||TR(A.n,e.j.e))){K3(e,A)}else{vU(a.a.b,e);e=new L3(A,a.d)}}vU(a.a.b,e)}B.c=xv(UF,syb,1,0,4,1);N4(a)}
function eZ(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M;h=Wv(yU(a.d.c.c,d),16);K=new vtb;o=new vtb;for(n=0;n<h.a.c.length;++n){s=Wv(yU(h.a,n),9);n<c?(D=K.a.db(s,K),D==null):n>c&&(C=o.a.db(s,o),C==null)}L=new vtb;p=new vtb;for(u=(G=(new Snb(K.a)).a.bb().mb(),new Ynb(G));u.a.G();){s=(l=Wv(u.a.H(),21),Wv(l.yb(),9));g=b==1?mX(s):iX(s);for(j=(Il(),new Im(Dl(ul(g.a,new yl))));Cm(j);){i=Wv(Dm(j),12);rY(s.d)!=rY(i.d.f.d)&&stb(L,i.d.f)}}for(v=(H=(new Snb(o.a)).a.bb().mb(),new Ynb(H));v.a.G();){s=(l=Wv(v.a.H(),21),Wv(l.yb(),9));g=b==1?mX(s):iX(s);for(j=(Il(),new Im(Dl(ul(g.a,new yl))));Cm(j);){i=Wv(Dm(j),12);rY(s.d)!=rY(i.d.f.d)&&stb(p,i.d.f)}}if(aZ){Fmb()}B=Wv(yU(a.d.c.c,d+(b==1?1:-1)),16);q=eyb;r=$xb;for(m=0;m<B.a.c.length;m++){s=Wv(yU(B.a,m),9);L.a.R(s)?(q=q>m?q:m):p.a.R(s)&&(r=r<m?r:m)}if(q<r){for(w=(I=(new Snb(L.a)).a.bb().mb(),new Ynb(I));w.a.G();){s=(l=Wv(w.a.H(),21),Wv(l.yb(),9));for(k=Uh(mX(s));Cm(k);){i=Wv(Dm(k),12);if(rY(s.d)==rY(i.d.f.d)){return null}}for(j=Uh(iX(s));Cm(j);){i=Wv(Dm(j),12);if(rY(s.d)==rY(i.c.f.d)){return null}}}for(A=(F=(new Snb(p.a)).a.bb().mb(),new Ynb(F));A.a.G();){s=(l=Wv(A.a.H(),21),Wv(l.yb(),9));for(k=Uh(mX(s));Cm(k);){i=Wv(Dm(k),12);if(rY(s.d)==rY(i.d.f.d)){return null}}for(j=Uh(iX(s));Cm(j);){i=Wv(Dm(j),12);if(rY(s.d)==rY(i.c.f.d)){return null}}}K.a.Y()==0?(M=0):o.a.Y()==0?(M=B.a.c.length):(M=q+1);for(t=new Tob(h.a);t.a<t.c.c.length;){s=Wv(Rob(t),9);if(s.g==(CX(),BX)){return null}}if(f==1){return Co(Bv(tv(PF,1),Txb,24,0,[Elb(M)]))}else if(b==1&&d==e-2||b==0&&d==1){return Co(Bv(tv(PF,1),Txb,24,0,[Elb(M)]))}else{J=eZ(a,b,M,d+(b==1?1:-1),e,f-1);!!J&&b==1&&J.rb(0,Elb(M));return J}}return null}
function aQ(b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u;SP(c);o=(eM(),KL).b;if(o in c.a&&Pu(c,o).ic().a){return}j=Pu(c,'source');k=Pu(c,'sourcePort');l=Pu(c,'target');m=Pu(c,'targetPort');if(!j){throw new GQ("Edges must contain a 'source' property.",null,c)}else if(!j.lc()){throw new GQ("Invalid format of an edge's 'source' property. It must be a string.",j,c)}if(!l){throw new GQ("Edges must contain a 'target' property.",null,c)}else if(!l.lc()){throw new GQ("Invalid format of an edge's 'target' property. It must be a string.",l,c)}r=null;t=null;try{q=Wv(Tmb(b.i,j.lc().a),9);!!k&&!!k.lc()&&(r=Wv(Tmb(b.k,k.lc().a),7));s=Wv(Tmb(b.i,l.lc().a),9);!!m&&!!m.lc()&&(t=Wv(Tmb(b.k,m.lc().a),7))}catch(a){a=OH(a);if(aw(a,76)){throw new FQ("An edge's 'source', 'target', 'sourcePort', and 'targetPort' properties have to be strings.",c)}else throw NH(a)}if(!Ckb(Ixb(b.g))){if(!q||!s){return}else if(hX(q)!=hX(s)){return}}if(!q||!s){throw new FQ("An edge's source or target node could not be resolved.",c)}p=hX(q);e=new hW;sJ(e,(Rib(),uib),c);h=Wv(Pu(c,'id'),97);Vmb(b.a,h.a,e);Umb(b.b,e,c);hQ(c,e);dQ(b,c,e,p);f=Wv(rJ(p,jib),18);q==s&&f.ib((ohb(),nhb));if(!r){r=OW(q,new FI,(djb(),bjb),p)}else if(r.f!=q){throw new EQ('Inconsistent source port reference found.')}if(!t){t=OW(s,new FI,(djb(),ajb),p)}else if(t.f!=s){throw new EQ('Inconsistent target port reference found.')}dW(e,r);eW(e,t);(tl(Sh((Gi(),new gr(Ti(Bv(tv(UF,1),syb,1,4,[r.b,r.e]))))))>1||tl(Sh(new gr(Ti(Bv(tv(UF,1),syb,1,4,[t.b,t.e])))))>1)&&f.ib((ohb(),ihb));if(gw(rJ(p,(Mjb(),kjb)))===gw((p9(),n9))&&!(Hzb in c.a)){d=new jJ;try{i=Pu(c,Hzb).hc();for(g=0;g<i.a.length;++g){n=gu(i,g).kc();u=new HI(Pu(n,'x').jc().a,Pu(n,'y').jc().a);TI(d,u,d.c.b,d.c)}sJ(e,vib,d)}catch(a){a=OH(a);if(aw(a,54)){throw new FQ("Invalid format of an edges 'bendPoints' property.",c)}else throw NH(a)}}sJ(e,CL,null)}
function d0(){d0=iI;L_=new f0('LEFT_DIR_PREPROCESSOR',0);o_=new f0('DOWN_DIR_PREPROCESSOR',1);c0=new f0('UP_DIR_PREPROCESSOR',2);m_=new f0('COMMENT_PREPROCESSOR',3);p_=new f0('EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER',4);__=new f0('SPLINE_SELF_LOOP_PREPROCESSOR',5);z_=new f0('INTERACTIVE_EXTERNAL_PORT_POSITIONER',6);T_=new f0('PARTITION_PREPROCESSOR',7);j_=new f0('BIG_NODES_PREPROCESSOR',8);D_=new f0('LABEL_DUMMY_INSERTER',9);S_=new f0('PARTITION_POSTPROCESSOR',10);P_=new f0('NODE_PROMOTION',11);I_=new f0('LAYER_CONSTRAINT_PROCESSOR',12);s_=new f0('HIERARCHICAL_PORT_CONSTRAINT_PROCESSOR',13);h_=new f0('BIG_NODES_INTERMEDIATEPROCESSOR',14);N_=new f0('LONG_EDGE_SPLITTER',15);W_=new f0('PORT_SIDE_PROCESSOR',16);F_=new f0('LABEL_DUMMY_SWITCHER',17);G_=new f0('LABEL_MANAGEMENT_PROCESSOR',18);A_=new f0('INVERTED_PORT_PROCESSOR',19);Z_=new f0('SELF_LOOP_PROCESSOR',20);V_=new f0('PORT_LIST_SORTER',21);R_=new f0('NORTH_SOUTH_PORT_PREPROCESSOR',22);r_=new f0('GREEDY_SWITCH',23);U_=new f0('PORT_DISTRIBUTER',24);$_=new f0('SPLINE_SELF_LOOP_POSITIONER',25);Y_=new f0('SAUSAGE_COMPACTION',26);B_=new f0('IN_LAYER_CONSTRAINT_PROCESSOR',27);x_=new f0('HYPEREDGE_DUMMY_MERGER',28);H_=new f0('LABEL_SIDE_SELECTOR',29);k_=new f0('BIG_NODES_SPLITTER',30);C_=new f0('LABEL_AND_NODE_SIZE_PROCESSOR',31);a0=new f0('SPLINE_SELF_LOOP_ROUTER',32);O_=new f0('NODE_MARGIN_CALCULATOR',33);t_=new f0('HIERARCHICAL_PORT_DUMMY_SIZE_PROCESSOR',34);v_=new f0('HIERARCHICAL_PORT_POSITION_PROCESSOR',35);J_=new f0('LAYER_SIZE_AND_GRAPH_HEIGHT_CALCULATOR',36);i_=new f0('BIG_NODES_POSTPROCESSOR',37);l_=new f0('COMMENT_POSTPROCESSOR',38);y_=new f0('HYPERNODE_PROCESSOR',39);u_=new f0('HIERARCHICAL_PORT_ORTHOGONAL_EDGE_ROUTER',40);M_=new f0('LONG_EDGE_JOINER',41);Q_=new f0('NORTH_SOUTH_PORT_POSTPROCESSOR',42);E_=new f0('LABEL_DUMMY_REMOVER',43);w_=new f0('HORIZONTAL_COMPACTOR',44);X_=new f0('REVERSED_EDGE_RESTORER',45);K_=new f0('LEFT_DIR_POSTPROCESSOR',46);n_=new f0('DOWN_DIR_POSTPROCESSOR',47);b0=new f0('UP_DIR_POSTPROCESSOR',48);q_=new f0('END_LABEL_PROCESSOR',49)}
function Rib(){Rib=iI;var a,b;uib=new CJ('origin');_hb=new CJ('processingConfiguration');Fib=new CJ('processors');$hb=new DJ('compoundNode',(xkb(),xkb(),vkb));lib=new DJ('insideConnections',(null,vkb));sib=new CJ('nestedLGraph');zib=new CJ('parentLNode');vib=new CJ('originalBendpoints');wib=new CJ('originalDummyNodePosition');xib=new CJ('originalLabelEdge');Hib=new CJ('representedLabels');pib=new DJ('labelSide',(kP(),jP));Iib=new DJ('reversed',(null,vkb));Gib=new CJ('random');qib=new DJ('longEdgeSource',null);rib=new DJ('longEdgeTarget',null);dib=new DJ('edgeConstraint',(Hgb(),Fgb));nib=new CJ('inLayerLayoutUnit');mib=new DJ('inLayerConstraint',(Hhb(),Fhb));oib=new DJ('inLayerSuccessorConstraint',new GU);Bib=new CJ('portDummy');aib=new DJ('crossingHint',Elb(0));jib=new DJ('graphProperties',(b=Wv(Hkb(mF),11),new atb(b,Wv(exb(b,b.length),11),0)));hib=new DJ('externalPortSide',(sN(),qN));iib=new DJ('externalPortSize',new FI);gib=new CJ('externalPortReplacedDummy');fib=new DJ('externalPortConnections',(a=Wv(Hkb(Kz),11),new atb(a,Wv(exb(a,a.length),11),0)));Cib=new DJ(yzb,0);Shb=new CJ('barycenterAssociates');Qib=new CJ('TopSideComments');Yhb=new CJ('BottomSideComments');Zhb=new CJ('CommentConnectionPort');kib=new DJ('inputCollect',(null,vkb));yib=new DJ('outputCollect',(null,vkb));cib=new DJ('cyclic',(null,vkb));Whb=new DJ('bigNodeOriginalSize',new llb(0));Vhb=new DJ('bigNodeInitial',(null,vkb));Thb=new DJ('de.cau.cs.kieler.klay.layered.bigNodeLabels',new GU);Uhb=new DJ('de.cau.cs.kieler.klay.layered.postProcess',null);bib=new CJ('crossHierarchyMap');Pib=new CJ('targetOffset');Lib=new DJ('splineLabelSize',new FI);Mib=new DJ('splineLoopSide',(Ieb(),Feb));Nib=new DJ('splineSelfLoopComponents',new GU);Oib=new DJ('splineSelfLoopMargins',new DP);Kib=new CJ('spacings');Aib=new DJ('partitionConstraint',(null,vkb));tib=new AJ((eM(),LL),new llb(0));Jib=new BJ(cM,new llb(20),new llb(1));Dib=new BJ(XL,new llb(10),new llb(1));Xhb=new BJ(pL,new llb(12),new llb(0));Eib=new AJ(ZL,Elb(0));Rhb=new BJ(nL,new llb(cAb),new llb(0));eib=new AJ(uL,(NK(),JK))}
function Mjb(){Mjb=iI;Bjb=new DJ('de.cau.cs.kieler.klay.layered.nodePromotion',(I1(),G1));Cjb=new FJ('de.cau.cs.kieler.klay.layered.nodePromotionBoundary',Elb(0),Elb(0),Elb(100));Hjb=new DJ(vzb,Elb(1));Ejb=new EJ('de.cau.cs.kieler.klay.layered.inLayerSpacingFactor',new llb(1),new llb(0));qjb=new DJ('de.cau.cs.kieler.klay.layered.edgeSpacingFactor',new llb(0.5));pjb=new DJ('de.cau.cs.kieler.klay.layered.edgeNodeSpacingFactor',new llb(IAb));njb=new DJ('de.cau.cs.kieler.klay.layered.distributeNodes',(xkb(),xkb(),vkb));Ljb=new DJ('de.cau.cs.kieler.klay.layered.wideNodesOnMultipleLayers',(ckb(),bkb));ljb=new DJ('de.cau.cs.kieler.klay.layered.cycleBreaking',(Z7(),X7));zjb=new DJ('de.cau.cs.kieler.klay.layered.nodeLayering',(x8(),w8));kjb=new DJ('de.cau.cs.kieler.klay.layered.crossMin',(p9(),o9));tjb=new DJ('de.cau.cs.kieler.klay.layered.greedySwitch',(zhb(),whb));Ajb=new DJ('de.cau.cs.kieler.klay.layered.nodePlace',(kbb(),fbb));wjb=new FJ('de.cau.cs.kieler.klay.layered.linearSegmentsDeflectionDampening',new llb(HAb),new llb(0),new llb(1));sjb=new DJ('de.cau.cs.kieler.klay.layered.fixedAlignment',(_gb(),Ygb));ojb=new DJ('de.cau.cs.kieler.klay.layered.edgeLabelSideSelection',(Pgb(),Lgb));mjb=new DJ(uzb,(null,vkb));Kjb=new EJ('de.cau.cs.kieler.klay.layered.thoroughness',Elb(10),Elb(1));vjb=new DJ('de.cau.cs.kieler.klay.layered.layerConstraint',(Xib(),Wib));xjb=new DJ('de.cau.cs.kieler.klay.layered.mergeEdges',(null,vkb));yjb=new DJ('de.cau.cs.kieler.klay.layered.mergeHierarchyEdges',(null,wkb));ujb=new DJ('de.cau.cs.kieler.klay.layered.interactiveReferencePoint',(Mhb(),Khb));rjb=new DJ('de.cau.cs.kieler.klay.layered.feedBackEdges',(null,vkb));gjb=new DJ('de.cau.cs.kieler.klay.layered.unnecessaryBendpoints',(null,vkb));jjb=new DJ('de.cau.cs.kieler.klay.layered.contentAlignment',(zgb(),Vsb(ygb,Bv(tv(iF,1),uyb,123,0,[ugb]))));Ijb=new DJ('de.cau.cs.kieler.klay.layered.sausageFolding',(null,vkb));Jjb=new DJ('de.cau.cs.kieler.klay.layered.splines.selfLoopPlacement',(Qjb(),Pjb));hjb=new DJ('de.cau.cs.kieler.klay.layered.nodeplace.compactionStrategy',(lcb(),jcb));Djb=new DJ('de.cau.cs.kieler.klay.layered.northOrSouthPort',(null,vkb));Fjb=new DJ('de.cau.cs.kieler.klay.layered.postCompaction',(g4(),e4));Gjb=new DJ('de.cau.cs.kieler.klay.layered.postCompaction.constraints',(X3(),W3));ijb=new DJ('de.cau.cs.kieler.klay.layered.components.compact',(null,vkb))}
function uO(){uO=iI;rO=new vO('OUT_T_L',0,(Gi(),new Er(Vsb((oM(),kM),Bv(tv(Gz,1),uyb,41,0,[nM,gM])))),(DO(),BO));qO=new vO('OUT_T_C',1,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[nM,fM])),Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[nM,fM,hM]))]))),AO);sO=new vO('OUT_T_R',2,new Er(Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[nM,iM]))),CO);iO=new vO('OUT_B_L',3,new Er(Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[lM,gM]))),BO);hO=new vO('OUT_B_C',4,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[lM,fM])),Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[lM,fM,hM]))]))),AO);jO=new vO('OUT_B_R',5,new Er(Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[lM,iM]))),CO);mO=new vO('OUT_L_T',6,new Er(Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[gM,nM,hM]))),CO);lO=new vO('OUT_L_C',7,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[gM,mM])),Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[gM,mM,hM]))]))),CO);kO=new vO('OUT_L_B',8,new Er(Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[gM,lM,hM]))),CO);pO=new vO('OUT_R_T',9,new Er(Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[iM,nM,hM]))),BO);oO=new vO('OUT_R_C',10,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[iM,mM])),Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[iM,mM,hM]))]))),BO);nO=new vO('OUT_R_B',11,new Er(Vsb(kM,Bv(tv(Gz,1),uyb,41,0,[iM,lM,hM]))),BO);fO=new vO('IN_T_L',12,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[nM,gM])),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[nM,gM,hM]))]))),BO);eO=new vO('IN_T_C',13,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[nM,fM])),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[nM,fM,hM]))]))),AO);gO=new vO('IN_T_R',14,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[nM,iM])),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[nM,iM,hM]))]))),CO);cO=new vO('IN_C_L',15,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[mM,gM])),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[mM,gM,hM]))]))),BO);bO=new vO('IN_C_C',16,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[mM,fM])),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[mM,fM,hM]))]))),AO);dO=new vO('IN_C_R',17,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[mM,iM])),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[mM,iM,hM]))]))),CO);_N=new vO('IN_B_L',18,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[lM,gM])),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[lM,gM,hM]))]))),BO);$N=new vO('IN_B_C',19,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[lM,fM])),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[lM,fM,hM]))]))),AO);aO=new vO('IN_B_R',20,new gr(Ti(Bv(tv(UF,1),syb,1,4,[Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[lM,iM])),Vsb(jM,Bv(tv(Gz,1),uyb,41,0,[lM,iM,hM]))]))),CO);tO=new vO(szb,21,(null,Fi),null)}
function lab(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab,bb,cb,db,eb,fb,gb,hb,ib;$=0;for(G=0,J=b.length;G<J;++G){D=b[G];if(LM(Wv(rJ(D,(eM(),TL)),28))){for(S=new Tob(D.f);S.a<S.c.c.length;){R=Wv(Rob(S),7);U=0;for(h=new Tob(R.e);h.a<h.c.c.length;){g=Wv(Rob(h),12);D.d!=g.d.f.d&&++U}U>0&&(a.a[R.k]=$++)}}else{L=0;for(S=new Tob(D.f);S.a<S.c.c.length;){R=Wv(Rob(S),7);for(h=new Tob(R.e);h.a<h.c.c.length;){g=Wv(Rob(h),12);D.d!=g.d.f.d&&++L}a.a[R.k]=$}L>0&&++$}}eb=0;for(H=0,K=c.length;H<K;++H){D=c[H];if(LM(Wv(rJ(D,(eM(),TL)),28))){M=0;for(S=new Tob(D.f);S.a<S.c.c.length;){R=Wv(Rob(S),7);if(R.g==(sN(),$M)){for(h=new Tob(R.b);h.a<h.c.c.length;){g=Wv(Rob(h),12);if(D.d!=g.c.f.d){++M;break}}}else{break}}O=0;V=new Fnb(D.f,D.f.c.length);while(V.b>0){R=(Bxb(V.b>0),Wv(V.a.sb(V.c=--V.b),7));U=0;for(h=new Tob(R.b);h.a<h.c.c.length;){g=Wv(Rob(h),12);D.d!=g.c.f.d&&++U}if(U>0){if(R.g==(sN(),$M)){a.a[R.k]=eb;++eb}else{a.a[R.k]=eb+M+O;++O}}}eb+=O}else{L=0;for(S=new Tob(D.f);S.a<S.c.c.length;){R=Wv(Rob(S),7);for(h=new Tob(R.b);h.a<h.c.c.length;){g=Wv(Rob(h),12);D.d!=g.c.f.d&&++L}a.a[R.k]=eb}L>0&&++eb}}T=(mp(),new ntb);n=new Wub;for(F=0,I=b.length;F<I;++F){D=b[F];for(cb=new Tob(D.f);cb.a<cb.c.c.length;){bb=Wv(Rob(cb),7);for(h=new Tob(bb.e);h.a<h.c.c.length;){g=Wv(Rob(h),12);gb=g.d;if(D.d!=gb.f.d){ab=Wv(re(Ktb(T.d,bb)),197);fb=Wv(re(Ktb(T.d,gb)),197);if(!ab&&!fb){m=new oab;n.a.db(m,n);vU(m.a,g);vU(m.d,bb);Ltb(T.d,bb,m);vU(m.d,gb);Ltb(T.d,gb,m)}else if(!ab){vU(fb.a,g);vU(fb.d,bb);Ltb(T.d,bb,fb)}else if(!fb){vU(ab.a,g);vU(ab.d,gb);Ltb(T.d,gb,ab)}else if(ab==fb){vU(ab.a,g)}else{vU(ab.a,g);for(Q=new Tob(fb.d);Q.a<Q.c.c.length;){P=Wv(Rob(Q),7);Ltb(T.d,P,ab)}xU(ab.a,fb.a);xU(ab.d,fb.d);n.a.eb(fb)!=null}}}}}o=Wv(Ye(n,xv(tE,{674:1,3:1,5:1,6:1},197,n.a.Y(),0,1)),674);C=b[0].d;Z=c[0].d;for(k=0,l=o.length;k<l;++k){j=o[k];j.e=$;j.f=eb;for(S=new Tob(j.d);S.a<S.c.c.length;){R=Wv(Rob(S),7);W=a.a[R.k];if(R.f.d==C){W<j.e&&(j.e=W);W>j.b&&(j.b=W)}else if(R.f.d==Z){W<j.f&&(j.f=W);W>j.c&&(j.c=W)}}}ipb(o,0,o.length,(hsb(),hsb(),gsb));db=xv(mw,Yyb,26,o.length,12,1);d=xv(mw,Yyb,26,eb+1,12,1);for(q=0;q<o.length;q++){db[q]=o[q].f;d[db[q]]=1}f=0;for(r=0;r<d.length;r++){d[r]==1?(d[r]=f):--f}X=0;for(s=0;s<db.length;s++){db[s]+=d[db[s]];X=Plb(X,db[s]+1)}i=1;while(i<X){i*=2}ib=2*i-1;i-=1;hb=xv(mw,Yyb,26,ib,12,1);e=0;for(A=0;A<db.length;A++){w=db[A]+i;++hb[w];while(w>0){w%2>0&&(e+=hb[w+1]);w=(w-1)/2|0;++hb[w]}}B=xv(sE,syb,156,o.length*2,0,1);for(t=0;t<o.length;t++){B[2*t]=new rab(o[t],o[t].e,o[t].b,(vab(),uab));B[2*t+1]=new rab(o[t],o[t].b,o[t].e,tab)}ipb(B,0,B.length,(null,gsb));N=0;for(u=0;u<B.length;u++){switch(B[u].d.e){case 0:++N;break;case 1:--N;e+=N;}}Y=xv(sE,syb,156,o.length*2,0,1);for(v=0;v<o.length;v++){Y[2*v]=new rab(o[v],o[v].f,o[v].c,(vab(),uab));Y[2*v+1]=new rab(o[v],o[v].c,o[v].f,tab)}ipb(Y,0,Y.length,(null,gsb));N=0;for(p=0;p<Y.length;p++){switch(Y[p].d.e){case 0:++N;break;case 1:--N;e+=N;}}return e}
function eM(){eM=iI;var a,b;mL=new DJ('de.cau.cs.kieler.animate',(xkb(),xkb(),wkb));new DJ('de.cau.cs.kieler.minAnimTime',Elb(400));new DJ('de.cau.cs.kieler.maxAnimTime',Elb(4000));new DJ('de.cau.cs.kieler.animTimeFactor',Elb(100));jL=new DJ('de.cau.cs.kieler.additionalPortSpace',null);qL=new DJ('de.cau.cs.kieler.commentBox',(null,vkb));new CJ('de.cau.cs.kieler.diagramType');tL=new DJ('de.cau.cs.kieler.edgeLabelPlacement',(EK(),DK));vL=new DJ('de.cau.cs.kieler.edgeType',(YK(),WK));xL=new CJ('de.cau.cs.kieler.fontName');yL=new DJ('de.cau.cs.kieler.fontSize',Elb(0));AL=new DJ('de.cau.cs.kieler.hypernode',(null,vkb));CL=new DJ('de.cau.cs.kieler.junctionPoints',new jJ);new DJ('de.cau.cs.kieler.layoutAncestors',(null,vkb));GL=new DJ('de.cau.cs.kieler.margins',new DP);HL=new EJ('de.cau.cs.kieler.minHeight',new llb(0),new llb(0));IL=new EJ('de.cau.cs.kieler.minWidth',new llb(0),new llb(0));KL=new DJ('de.cau.cs.kieler.noLayout',(null,vkb));LL=new CJ('de.cau.cs.kieler.offset');SL=new CJ('de.cau.cs.kieler.klay.layered.portAnchor');UL=new CJ('de.cau.cs.kieler.portIndex');WL=new DJ('de.cau.cs.kieler.portSide',(sN(),qN));new DJ('de.cau.cs.kieler.progressBar',(null,vkb));new DJ('de.cau.cs.kieler.resetConfig',(null,wkb));new DJ('de.cau.cs.kieler.scaleFactor',new llb(1));dM=new DJ('de.cau.cs.kieler.thickness',new llb(1));new DJ('de.cau.cs.kieler.zoomToFit',(null,vkb));kL=new CJ('de.cau.cs.kieler.algorithm');lL=new DJ('de.cau.cs.kieler.alignment',(iK(),cK));nL=new DJ('de.cau.cs.kieler.aspectRatio',new llb(0));oL=new CJ('de.cau.cs.kieler.bendPoints');pL=new DJ('de.cau.cs.kieler.borderSpacing',new llb(-1));rL=new DJ(uzb,(null,vkb));sL=new DJ('de.cau.cs.kieler.direction',(sK(),qK));uL=new DJ('de.cau.cs.kieler.edgeRouting',(NK(),MK));wL=new DJ('de.cau.cs.kieler.expandNodes',(null,vkb));zL=new DJ('de.cau.cs.kieler.hierarchyHandling',(eL(),cL));BL=new DJ('de.cau.cs.kieler.interactive',(null,vkb));DL=new EJ('de.cau.cs.kieler.labelSpacing',new llb(3),new llb(0));EL=new DJ('de.cau.cs.kieler.layoutHierarchy',(null,vkb));JL=new DJ('de.cau.cs.kieler.nodeLabelPlacement',(oM(),b=Wv(Hkb(Gz),11),new atb(b,Wv(exb(b,b.length),11),0)));TL=new DJ('de.cau.cs.kieler.portConstraints',(KM(),JM));VL=new DJ('de.cau.cs.kieler.portLabelPlacement',(UM(),TM));XL=new EJ('de.cau.cs.kieler.portSpacing',new llb(-1),new llb(0));NL=new DJ('de.cau.cs.kieler.portAlignment',(zM(),xM));PL=new DJ('de.cau.cs.kieler.portAlignment.north',yM);QL=new DJ('de.cau.cs.kieler.portAlignment.south',yM);RL=new DJ('de.cau.cs.kieler.portAlignment.west',yM);OL=new DJ('de.cau.cs.kieler.portAlignment.east',yM);YL=new CJ('de.cau.cs.kieler.position');ZL=new CJ('de.cau.cs.kieler.priority');new CJ(vzb);$L=new DJ('de.cau.cs.kieler.selfLoopInside',(null,vkb));_L=new CJ('de.cau.cs.kieler.separateConnComp');aM=new DJ('de.cau.cs.kieler.sizeConstraint',(DN(),a=Wv(Hkb(Lz),11),new atb(a,Wv(exb(a,a.length),11),0)));bM=new DJ('de.cau.cs.kieler.sizeOptions',Vsb((MN(),KN),Bv(tv(Mz,1),uyb,139,0,[IN])));cM=new EJ('de.cau.cs.kieler.spacing',new llb(-1),new llb(0));FL=new DJ('de.cau.cs.kieler.layoutPartitions',(null,vkb));ML=new CJ('de.cau.cs.kieler.partition')}
function wQ(b,c,d,e){tQ();var f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;if(!e){if((!b.n?(ypb(),ypb(),wpb):b.n).R(new xQ(c))){return}}if(Wv(rQ.a,18).kb(c)){if(!d.lc()){throw new _J(Pzb+c+Qzb+d+').')}o=Wv(Wv(rQ.b,57).cb(c),79);p=d.lc().a;sJ(b,o,p);return}else if(Wv(oQ.a,18).kb(c)){try{if(!d.jc()){throw new Xlb}o=Wv(Wv(oQ.b,57).cb(c),79);s=Elb(dlb((bmb(),''+d.jc().a)));sJ(b,o,s);return}catch(a){a=OH(a);if(aw(a,130)){throw new _J("Invalid integer format for property '"+c+Qzb+d+').')}else throw NH(a)}}else if(Wv(kQ.a,18).kb(c)){if(!d.ic()){throw new _J(Pzb+c+Qzb+d+').')}o=Wv(Wv(kQ.b,57).cb(c),79);s=(xkb(),d.ic().a?wkb:vkb);sJ(b,o,s);return}else if(Wv(nQ.a,18).kb(c)){if(!d.jc()){throw new _J("Invalid float format for property '"+c+Qzb+d+').')}o=Wv(Wv(nQ.b,57).cb(c),79);s=new klb(d.jc().a);sJ(b,o,s);return}else if(Wv(mQ.a,18).kb(c)){if(!d.lc()){throw new _J(Rzb+c+Qzb+d+').')}l=d.lc().a;m=null;try{vQ((eM(),WL),c)?(m=(sN(),Wv(Gc((yN(),xN),l),32))):vQ(lL,c)?(m=(iK(),Wv(Gc((mK(),lK),l),103))):vQ(sL,c)?(m=(sK(),Wv(Gc((zK(),yK),l),59))):vQ(uL,c)?(m=(NK(),Wv(Gc((RK(),QK),l),122))):vQ(zL,c)?(m=(eL(),Wv(Gc((iL(),hL),l),166))):vQ(NL,c)||vQ(OL,c)||vQ(PL,c)||vQ(QL,c)||vQ(RL,c)?(m=(zM(),Wv(Gc((DM(),CM),l),100))):vQ(TL,c)?(m=(KM(),Wv(Gc((QM(),PM),l),28))):vQ(VL,c)?(m=(UM(),Wv(Gc((YM(),XM),l),149))):vQ(vL,c)?(m=(YK(),Wv(Gc((aL(),_K),l),133))):vQ(tL,c)?(m=(EK(),Wv(Gc((IK(),HK),l),107))):vQ((Mjb(),ljb),c)?(m=(Z7(),Wv(Gc((c8(),b8),l),193))):vQ(zjb,c)?(m=(x8(),Wv(Gc((C8(),B8),l),173))):vQ(ojb,c)?(m=(Pgb(),Wv(Gc((Ugb(),Tgb),l),115))):vQ(hjb,c)?(m=(lcb(),Wv(Gc((pcb(),ocb),l),194))):vQ(kjb,c)?(m=(p9(),Wv(Gc((u9(),t9),l),192))):vQ(Bjb,c)?(m=(I1(),Wv(Gc((M1(),L1),l),109))):vQ(Ajb,c)?(m=(kbb(),Wv(Gc((pbb(),obb),l),141))):vQ(Fjb,c)?(m=(g4(),Wv(Gc((k4(),j4),l),125))):vQ(Gjb,c)?(m=(X3(),Wv(Gc((_3(),$3),l),175))):vQ(sjb,c)?(m=(_gb(),Wv(Gc((dhb(),chb),l),124))):vQ(tjb,c)?(m=(zhb(),Wv(Gc((Dhb(),Chb),l),110))):vQ(vjb,c)?(m=(Xib(),Wv(Gc((_ib(),$ib),l),85))):vQ(Jjb,c)?(m=(Qjb(),Wv(Gc((Ujb(),Tjb),l),153))):vQ(Ljb,c)?(m=(ckb(),Wv(Gc((gkb(),fkb),l),172))):vQ(ujb,c)&&(m=(Mhb(),Wv(Gc((Qhb(),Phb),l),174)))}catch(a){a=OH(a);if(aw(a,54)){throw new _J(Rzb+c+Qzb+d+').')}else throw NH(a)}o=Wv(Wv(mQ.b,57).cb(c),79);sJ(b,o,m);return}else if(Wv(lQ.a,18).kb(c)){if(!d.lc()){throw new _J(Rzb+c+Qzb+d+').')}k=d.lc().a;q=null;j=fmb(k,'[\\[\\]\\s,]+');for(h=0,i=j.length;h<i;++h){g=j[h];if(pmb(hmb(g))==0){continue}if(vQ((eM(),JL),c)){!q&&(q=(f=Wv(Hkb(Gz),11),new atb(f,Wv(exb(f,f.length),11),0)));Wsb(q,(oM(),Wv(Gc((sM(),rM),g),41)))}else if(vQ(aM,c)){!q&&(q=(f=Wv(Hkb(Lz),11),new atb(f,Wv(exb(f,f.length),11),0)));Wsb(q,(DN(),Wv(Gc((HN(),GN),g),150)))}else if(vQ(bM,c)){!q&&(q=(f=Wv(Hkb(Mz),11),new atb(f,Wv(exb(f,f.length),11),0)));Wsb(q,(MN(),Wv(Gc((QN(),PN),g),139)))}else if(vQ((Mjb(),jjb),c)){!q&&(q=(f=Wv(Hkb(iF),11),new atb(f,Wv(exb(f,f.length),11),0)));Wsb(q,(zgb(),Wv(Gc((Dgb(),Cgb),g),123)))}}o=Wv(Wv(lQ.b,57).cb(c),79);sJ(b,o,q);return}else if(Wv(qQ.a,18).kb(c)){if(!d.lc()){throw new _J("Invalid _other_ format for property '"+c+Qzb+d+').')}if(vQ((eM(),YL),c)||vQ(SL,c)){try{r=new FI;AI(r,d.lc().a);o=Wv(Wv(qQ.b,57).cb(c),79);sJ(b,o,r);return}catch(a){a=OH(a);if(aw(a,29)){throw new _J("Invalid KVector format for property '"+c+"' "+d+'.')}else throw NH(a)}}else if(vQ(oL,c)||vQ(CL,c)){try{t=new jJ;iJ(t,d.lc().a);o=Wv(Wv(qQ.b,57).cb(c),79);sJ(b,o,t);return}catch(a){a=OH(a);if(aw(a,29)){throw new _J("Invalid KVectorChain format for property '"+c+"' "+d+'.')}else throw NH(a)}}else if(vQ(GL,c)||vQ(jL,c)){try{n=new DP;tP(n,d.lc().a);o=Wv(Wv(qQ.b,57).cb(c),79);sJ(b,o,n);return}catch(a){a=OH(a);if(aw(a,29)){throw new _J("Invalid Margins format for property '"+c+"' "+d+'.')}else throw NH(a)}}}else if(Wv(pQ.a,18).kb(c)){return}throw new _J("Unsupported layout option '"+c+Qzb+d+').')}
var Sxb='object',Txb={3:1,8:1,5:1,6:1},Uxb={3:1,46:1},Vxb={3:1,54:1,46:1},Wxb='null',Xxb='anonymous',Yxb='Unknown',Zxb='function',$xb=2147483647,_xb={181:1,3:1,54:1,46:1},ayb=65536,byb=65535,cyb={3:1,54:1,29:1,46:1},dyb='For input string: "',eyb=-2147483648,fyb={56:1},gyb={23:1,145:1,185:1},hyb={3:1,5:1},iyb='Invalid UTF8 sequence',jyb='fromIndex: ',kyb='java.lang',lyb='com.google.gwt.core.client',myb='com.google.gwt.core.client.impl',nyb='java.io',oyb='java.nio.charset',pyb='javaemul.internal',qyb='com.google.common.base',ryb='%s (%s) must not be negative',syb={3:1,5:1,6:1},tyb='negative size: ',uyb={3:1,8:1,5:1,11:1,6:1},vyb={68:1,136:1,3:1,23:1,17:1},wyb={108:1,35:1},xyb='com.google.common.collect',yyb={108:1,35:1,96:1},zyb={144:1,3:1},Ayb={35:1},Byb={57:1},Cyb='java.util',Dyb={22:1,19:1},Eyb={22:1,19:1,18:1},Fyb={22:1,19:1,20:1},Gyb={22:1,19:1,20:1,63:1},Hyb={35:1,96:1},Iyb={22:1,19:1,18:1,137:1},Jyb={21:1},Kyb='AbstractMapEntry',Lyb={207:1,22:1,19:1},Myb={159:1,3:1,23:1,17:1},Nyb=1073741824,Oyb={22:1},Pyb={3:1,22:1,19:1},Qyb={87:1,3:1,22:1,19:1,20:1,63:1},Ryb={3:1,57:1},Syb={3:1,22:1,19:1,18:1},Tyb={64:1},Uyb='arraySize',Vyb='initialArraySize',Wyb={64:1,188:1,3:1,23:1,17:1},Xyb='occurrences',Yyb={52:1,3:1,5:1},Zyb={205:1,3:1,23:1,17:1},$yb=1.0E-4,_yb='com.google.gwt.json.client',azb=4194303,bzb=1048575,czb=4194304,dzb=17592186044416,ezb=-17592186044416,fzb='([{"\' \t\r\n',gzb=')]}"\' \t\r\n',hzb='The given string contains parts that cannot be parsed as numbers.',izb='de.cau.cs.kieler.core.math',jzb=-1.7976931348623157E308,kzb='de.cau.cs.kieler.core.properties',lzb={79:1,23:1},mzb='de.cau.cs.kieler.core.util',nzb='de.cau.cs.kieler.kiml',ozb='LEFT',pzb='RIGHT',qzb='CENTER',rzb='de.cau.cs.kieler.kiml.options',szb='UNDEFINED',tzb='NONE',uzb='de.cau.cs.kieler.debugMode',vzb='de.cau.cs.kieler.randomSeed',wzb='de.cau.cs.kieler.kiml.util.nodespacing',xzb='de.cau.cs.kieler.kiml.util.labelspacing',yzb='portRatioOrPosition',zzb='NodeMarginCalculator',Azb='bottom',Bzb={286:1,121:1,3:1,5:1},Czb='undefined',Dzb='text',Ezb='stacktrace',Fzb={34:1,3:1,8:1,5:1,6:1},Gzb='properties',Hzb='bendPoints',Izb='junctionPoints',Jzb='width',Kzb='height',Lzb='padding',Mzb='children',Nzb={38:1,39:1,42:1,51:1,71:1,3:1,8:1,5:1,6:1},Ozb='de.cau.cs.kieler.klay.gwt.client.layout',Pzb="Invalid boolean format for property '",Qzb="' (",Rzb="Invalid enum format for property '",Szb='de.cau.cs.kieler.klay.layered',Tzb='Layered layout',Uzb=Infinity,Vzb=-Infinity,Wzb='de.cau.cs.kieler.klay.layered.compaction.components',Xzb='de.cau.cs.kieler.klay.layered.compaction.oned',Yzb=' instance has been finished already.',Zzb='de.cau.cs.kieler.klay.layered.compaction.oned.algs',$zb='de.cau.cs.kieler.klay.layered.compaction.recthull',_zb={68:1},aAb='de.cau.cs.kieler.klay.layered.components',bAb={3:1,5:1,22:1,13:1,19:1,20:1,63:1},cAb=1.600000023841858,dAb=0.001,eAb={31:1},fAb='de.cau.cs.kieler.klay.layered.compound',gAb={38:1,39:1,47:1,42:1,3:1,8:1,5:1,6:1},hAb='de.cau.cs.kieler.klay.layered.graph',iAb='Port side is undefined',jAb='de.cau.cs.kieler.klay.layered.intermediate',kAb='Big nodes pre-processing',lAb=3.4028234663852886E38,mAb={38:1,39:1,42:1,346:1,71:1,3:1,8:1,5:1,6:1},nAb="Node '",oAb="' has its layer constraint set to FIRST or FIRST_SEPARATE, but has ",pAb='at least one incoming edge. Connections between nodes with these ',qAb='layer constraints are not supported.',rAb=1.7976931348623157E308,sAb='Odd port side processing',tAb={250:1,3:1,5:1},uAb=1.0E-8,vAb='de.cau.cs.kieler.klay.layered.intermediate.compaction',wAb='de.cau.cs.kieler.klay.layered.intermediate.greedyswitch',xAb={227:1,3:1,5:1},yAb='de.cau.cs.kieler.klay.layered.networksimplex',zAb='INTERACTIVE',AAb='de.cau.cs.kieler.klay.layered.p1cycles',BAb={106:1,31:1},CAb='de.cau.cs.kieler.klay.layered.p2layers',DAb='NETWORK_SIMPLEX',EAb='de.cau.cs.kieler.klay.layered.p3order',FAb=5.9604644775390625E-8,GAb='Port type is undefined',HAb=0.30000001192092896,IAb=0.699999988079071,JAb=0.8999999761581421,KAb='de.cau.cs.kieler.klay.layered.p3order.constraints',LAb='de.cau.cs.kieler.klay.layered.p3order.counting',MAb='de.cau.cs.kieler.klay.layered.p4nodes',NAb={625:1,3:1,5:1,6:1},OAb='de.cau.cs.kieler.klay.layered.p4nodes.bk',PAb='de.cau.cs.kieler.klay.layered.p5edges',QAb='de.cau.cs.kieler.klay.layered.p5edges.splines',RAb=1.0E-6,SAb=-1.0E-6,TAb='The list of vectors may not be empty.',UAb=0.09999999999999998,VAb='de.cau.cs.kieler.klay.layered.properties',WAb='_gwt_modCount',XAb={3:1,22:1,19:1,20:1,63:1},YAb={3:1,5:1,57:1},ZAb={3:1,5:1,22:1,19:1,50:1,18:1},$Ab='delete',_Ab=15525485,aBb=16777216,bBb=16777215,cBb={3:1,5:1,22:1,19:1,20:1,63:1},dBb={3:1,23:1,17:1,138:1};var _,fI,aI,LH=-1;gI();hI(1,null,{},pb);_.t=function qb(a){return this===a};_.u=function sb(){return this.$c};_.v=function ub(){return txb(this)};_.w=function wb(){return ob(this)};_.toString=function(){return this.w()};hI(46,1,Uxb);_.bc=function ct(){return this.f};_.w=function dt(){var a,b;return a=Ikb(this.$c),b=this.bc(),b!=null?a+': '+b:a};hI(54,46,Vxb);hI(72,54,Vxb,gt);hI(164,72,{164:1,3:1,54:1,46:1},kt);_.bc=function nt(){jt(this);return this.c};_.cc=function ot(){return gw(this.b)===gw(ht)?null:this.b};var ht;var Mt;hI(642,1,{});hI(356,642,{},Tt);_.dc=function Ut(a,b){var c={},k;var d=[];a.__gwt$backingJsError={'fnStack':d};var e=arguments.callee.caller;while(e){var f=(Nt(),e.name||(e.name=Rt(e.toString())));d.push(f);var g=':'+f;var h=c[g];if(h){var i,j;for(i=0,j=h.length;i<j;i++){if(h[i]===e){return}}}(h||(c[g]=[])).push(e);e=e.caller}};_.ec=function Vt(a){var b,c,d,e,f;d=(Nt(),f=a.__gwt$backingJsError,f&&f.fnStack?f.fnStack:[]);c=d.length;e=xv(WF,Txb,146,c,0,1);for(b=0;b<c;b++){e[b]=new Zlb(d[b],null,-1)}return e};hI(643,642,{});_.dc=function Yt(c,d){function e(b){if(!('stack' in b)){try{throw b}catch(a){}}return b}
var f;typeof d=='string'?(f=e(new Error(d.replace('\n',' ')))):d&&typeof d==Sxb&&'stack' in d?(f=d):(f=e(new Error));c.__gwt$backingJsError=f};_.fc=function Zt(a,b,c,d){return new Zlb(b,a+'@'+d,c<0?-1:c)};_.ec=function $t(a){var b,c,d,e,f,g,h;e=(Nt(),h=a.__gwt$backingJsError,h&&h.stack?h.stack.split('\n'):[]);f=xv(WF,Txb,146,0,0,1);b=0;d=e.length;if(d==0){return f}g=Xt(this,e[0]);emb(g.d,Xxb)||(f[b++]=g);for(c=1;c<d;c++){f[b++]=Xt(this,e[c])}return f};hI(357,643,{},_t);_.fc=function au(a,b,c,d){return new Zlb(b,a,-1)};var Sv,Tv,Uv;hI(181,54,_xb);hI(351,181,_xb,ikb);hI(288,1,{},Kkb);_.Oc=function Lkb(a){var b;b=new Kkb;b.g=4;a>1?(b.c=Skb(this,a-1)):(b.c=this);return b};_.Pc=function Rkb(){Gkb(this);return this.b};_.Qc=function Tkb(){return Ikb(this)};_.Rc=function Vkb(){return Jkb(this)};_.Sc=function Xkb(){return (this.g&4)!=0};_.Tc=function Ykb(){return (this.g&1)!=0};_.w=function _kb(){return ((this.g&2)!=0?'interface ':(this.g&1)!=0?'':'class ')+(Gkb(this),this.n)};_.g=0;var Fkb=1;hI(119,72,{3:1,119:1,54:1,46:1},alb);hI(29,72,cyb,rlb,slb);hI(95,72,Vxb,nkb,okb);hI(231,1,{3:1,231:1});var blb;hI(24,231,{3:1,23:1,24:1,231:1},wlb);_.F=function ylb(a){return vlb(this,Wv(a,24))};_.t=function zlb(a){return aw(a,24)&&Wv(a,24).a==this.a};_.v=function Alb(){return this.a};_.w=function Clb(){return Dlb(this.a)};_.a=0;Uv={3:1,345:1,23:1,2:1};hI(350,1,fyb,smb);_.$b=function tmb(a,b){return rmb($v(a),$v(b))};hI(257,95,Vxb,Cmb);hI(145,1,{23:1,145:1});_.F=function Kmb(a){return Jmb(this,Wv(a,145))};_.t=function Lmb(a){var b;if(a===this){return true}if(!aw(a,145)){return false}b=Wv(a,145);return emb(this.a,b.a)};_.v=function Mmb(){return Pxb(this.a)};_.w=function Nmb(){return this.a};hI(358,29,cyb,Omb);hI(256,29,{3:1,54:1,29:1,46:1,256:1},Pmb);hI(185,145,gyb);var jxb,kxb,lxb;hI(289,185,gyb,oxb);_.Zc=function pxb(a,b,c){var d,e;d=xv(jw,hyb,26,c,12,1);for(e=0;e<c;++e){d[e]=a[b+e]&255&byb}return d};hI(355,185,gyb,qxb);_.Zc=function rxb(a,b,c){var d,e,f,g,h,i,j,k;f=0;for(j=0;j<c;){++f;e=a[b+j];if((e&192)==128){throw new slb(iyb)}else if((e&128)==0){++j}else if((e&224)==192){j+=2}else if((e&240)==224){j+=3}else if((e&248)==240){j+=4}else{throw new slb(iyb)}if(j>c){throw new okb(iyb)}}g=xv(jw,hyb,26,f,12,1);k=0;h=0;for(i=0;i<c;){e=a[b+i++];if((e&128)==0){h=1;e&=127}else if((e&224)==192){h=2;e&=31}else if((e&240)==224){h=3;e&=15}else if((e&248)==240){h=4;e&=7}else if((e&252)==248){h=5;e&=3}while(--h>0){d=a[b+i++];if((d&192)!=128){throw new slb('Invalid UTF8 sequence at '+(b+i-1)+', byte='+(d>>>0).toString(16))}e=e<<6|d&63}k+=Ekb(e,g,k)}return g};var UF=Nkb(kyb,'Object',1);var _F=Nkb(kyb,'Throwable',46);var KF=Nkb(kyb,'Exception',54);var VF=Nkb(kyb,'RuntimeException',72);var Zy=Nkb(lyb,'JavaScriptException',164);var ez=Nkb(myb,'StackTraceCreator/Collector',642);var bz=Nkb(myb,'StackTraceCreator/CollectorLegacy',356);var dz=Nkb(myb,'StackTraceCreator/CollectorModern',643);var cz=Nkb(myb,'StackTraceCreator/CollectorModernNoSourceMap',357);var wF=Nkb(nyb,'IOException',181);var zF=Nkb(nyb,'UnsupportedEncodingException',351);var GF=Nkb(kyb,'Class',288);var FF=Nkb(kyb,'ClassCastException',119);var MF=Nkb(kyb,'IllegalArgumentException',29);var OF=Nkb(kyb,'IndexOutOfBoundsException',95);var TF=Nkb(kyb,'Number',231);var PF=Nkb(kyb,'Integer',24);var $F=Nkb(kyb,'String',2);var XF=Nkb(kyb,'String/1',350);var ZF=Nkb(kyb,'StringIndexOutOfBoundsException',257);var bG=Nkb(oyb,'Charset',145);var cG=Nkb(oyb,'IllegalCharsetNameException',358);var dG=Nkb(oyb,'UnsupportedCharsetException',256);var JH=Nkb(pyb,'EmulatedCharset',185);var HH=Nkb(pyb,'EmulatedCharset/LatinCharset',289);var IH=Nkb(pyb,'EmulatedCharset/UtfCharset',355);hI(669,1,{3:1});var sw=Nkb(qyb,'Optional',669);hI(601,669,{3:1},Ab);_.t=function Bb(a){return a===this};_.v=function Cb(){return 2040732332};_.w=function Db(){return 'Optional.absent()'};_.A=function Eb(a){_b(a);return zb(),yb};var yb;var nw=Nkb(qyb,'Absent',601);var ow=Pkb(qyb,'Function');hI(208,1,{},Kb);_.C=function Lb(a){return Ib(a)};var rw=Nkb(qyb,'Joiner',208);hI(363,208,{},Nb);_.C=function Ob(a){return Mb(this,a)};var pw=Nkb(qyb,'Joiner/1',363);hI(362,1,{},Rb);var qw=Nkb(qyb,'Joiner/MapJoiner',362);var tw=Pkb(qyb,'Predicate');var gc;hI(244,1,{68:1,244:1,3:1},ic);_.D=function jc(a){var b;for(b=0;b<this.a.a.length;b++){if(!Wv(mpb(this.a,b),68).D(a)){return false}}return true};_.t=function kc(a){var b;if(aw(a,244)){b=Wv(a,244);return cn(this.a,b.a)}return false};_.v=function lc(){return Bpb(this.a)+306654252};_.w=function mc(){return 'Predicates.and('+Hb((hc(),gc),new wnb(this.a))+')'};var uw=Nkb(qyb,'Predicates/AndPredicate',244);hI(246,1,{68:1,246:1,3:1},nc);_.D=function oc(b){try{return this.a.kb(b)}catch(a){a=OH(a);if(aw(a,76)){return false}else if(aw(a,119)){return false}else throw NH(a)}};_.t=function pc(a){var b;if(aw(a,246)){b=Wv(a,246);return this.a.t(b.a)}return false};_.v=function qc(){return this.a.v()};_.w=function rc(){return 'Predicates.in('+this.a+')'};var vw=Nkb(qyb,'Predicates/InPredicate',246);hI(245,1,{68:1,245:1,3:1},sc);_.D=function tc(a){return rb(this.a,a)};_.t=function uc(a){var b;if(aw(a,245)){b=Wv(a,245);return rb(this.a,b.a)}return false};_.v=function vc(){return vb(this.a)};_.w=function wc(){return