/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/m/Toolbar","sap/m/ToolbarSeparator","sap/m/OverflowToolbar","sap/m/Button"],function(l,C,M,T,a,O,B){"use strict";var D=l.DynamicPageTitleArea;var c=sap.ui.getCore();var b=C.extend("sap.f.DynamicPageTitle",{metadata:{library:"sap.f",properties:{primaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:D.Begin}},aggregations:{heading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},snappedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},expandedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},navigationActions:{type:"sap.m.Button",multiple:true,singularName:"navigationAction"},content:{type:"sap.ui.core.Control",multiple:true},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},breadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navActionsToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_navActionsToolbarSeparator:{type:"sap.m.ToolbarSeparator",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},designTime:true}});function e(o){if(arguments.length===1){return o&&("length"in o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(d){return e(d);});}b.NAV_ACTIONS_PLACEMENT_BREAK_POINT=1280;b._renderControl=function(o,d){var r;if(!d||!o){return;}r=c.createRenderManager();r.renderControl(d);r.flush(o);r.destroy();};function i(o){return typeof o==="function";}b.prototype.init=function(){this._bExpandedState=true;this._bShowExpandButton=false;this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);this._bNavigationActionsInTopArea=false;this._oRB=c.getLibraryResourceBundle("sap.f");this._oObserver=new M(b.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content"]});this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.f");};b.prototype.onBeforeRendering=function(){this._getActionsToolbar();};b.prototype.onAfterRendering=function(){this._cacheDomElements();this._toggleState(this._bExpandedState);this._doNavigationActionsLayout();};b.prototype.exit=function(){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}};b.prototype.setPrimaryArea=function(A){if(this.getDomRef()){this._toggleAreaPriorityClasses(A===D.Begin);}return this.setProperty("primaryArea",A,true);};b.prototype.ontap=function(E){var s=E.srcControl;if(s===this||s===this.getAggregation("_actionsToolbar")||s===this.getAggregation("breadcrumbs")){this.fireEvent("_titlePress");}};b.prototype.onmouseover=function(E){this.fireEvent("_titleMouseOver");};b.prototype.onmouseout=function(E){this.fireEvent("_titleMouseOut");};b.prototype.onsapspace=function(E){this.onsapenter(E);};b.prototype.onsapenter=function(E){if(E.srcControl===this){this.fireEvent("_titlePress");}};["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(m){b.prototype[m]=function(o){var t=this._getActionsToolbar(),s=m.replace(/Actions?/,"Content"),S=true,r;if(m==="addAction"||m==="insertAction"){t[s].apply(t,arguments);this._preProcessAction(o,"actions");r=this;}else if(m==="removeAction"){this._postProcessAction(o);}else if(m==="removeAllActions"){this.getActions().forEach(this._postProcessAction,this);}else if(m==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);t[s].apply(t,arguments);r=this;}else if(m==="getActions"){S=false;}r=r||t[s].apply(t,arguments);S&&this._updateSeparatorVisibility();return r;};});["addNavigationAction","insertNavigationAction","removeNavigationAction","indexOfNavigationAction","removeAllNavigationActions","destroyNavigationActions","getNavigationActions"].forEach(function(m){b.prototype[m]=function(o){var t=this._getNavigationActionsToolbar(),s=m.replace(/NavigationActions?/,"Content"),S=true,r;if(m==="addNavigationAction"||m==="insertNavigationAction"){t[s].apply(t,arguments);this._preProcessAction(o,"navigationActions");r=this;}else if(m==="removeNavigationAction"){this._postProcessAction(o);}else if(m==="removeAllNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);}else if(m==="destroyNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);t[s].apply(t,arguments);r=this;}else if(m==="getNavigationActions"){S=false;}r=r||t[s].apply(t,arguments);S&&this._updateSeparatorVisibility();return r;};});b.prototype.clone=function(I,L,o){var t=C.prototype.clone.apply(this,arguments),d=true;if(o){d=!!o.cloneChildren;}if(!d){return t;}var f=function(A){if(!this.isBound(A)){var g=this.getMetadata().getAggregation(A);g.get(this).forEach(function(h){g.add(t,h.clone());},this);}}.bind(this);f("actions");f("navigationActions");return t;};b.prototype._cacheDomElements=function(){this.$topNavigationActionsArea=this.$("topNavigationArea");this.$mainNavigationActionsArea=this.$("mainNavigationArea");this.$beginArea=this.$("left-inner");this.$middleArea=this.$("content");this.$snappedHeadingWrapper=this.$("snapped-heading-wrapper");this.$expandHeadingWrapper=this.$("expand-heading-wrapper");this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");};b.prototype._toggleAreaPriorityClasses=function(d){this.$beginArea.toggleClass("sapFDynamicPageTitleAreaHighPriority",d);this.$beginArea.toggleClass("sapFDynamicPageTitleAreaLowPriority",!d);this.$middleArea.toggleClass("sapFDynamicPageTitleAreaHighPriority",!d);this.$middleArea.toggleClass("sapFDynamicPageTitleAreaLowPriority",d);};b.prototype._getActionsToolbar=function(){if(!this.getAggregation("_actionsToolbar")){this.setAggregation("_actionsToolbar",new O({id:this.getId()+"-_actionsToolbar"}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_actionsToolbar");};b.prototype._getNavigationActionsToolbar=function(){if(!this.getAggregation("_navActionsToolbar")){this.setAggregation("_navActionsToolbar",new T({id:this.getId()+"-navActionsToolbar"}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_navActionsToolbar");};b.prototype._getToolbarSeparator=function(){if(!this.getAggregation("_navActionsToolbarSeparator")){this.setAggregation("_navActionsToolbarSeparator",new a({id:this.getId()+"-separator"}),true);}return this.getAggregation("_navActionsToolbarSeparator");};b.prototype._preProcessAction=function(A,p){if(i(A._fnOriginalGetParent)){return;}this._observeAction(A);A._fnOriginalGetParent=A.getParent;A.getParent=this._fnActionSubstituteParentFunction;A._sOriginalParentAggregationName=A.sParentAggregationName;A.sParentAggregationName=p;};b.prototype._postProcessAction=function(A){if(!i(A._fnOriginalGetParent)){return;}this._unobserveAction(A);A.getParent=A._fnOriginalGetParent;A._fnOriginalGetParent=null;A.sParentAggregationName=A._sOriginalParentAggregationName;A._sOriginalParentAggregationName=null;};b.prototype._observeAction=function(o){this._oObserver.observe(o,{properties:["visible"]});};b.prototype._unobserveAction=function(o){this._oObserver.unobserve(o,{properties:["visible"]});};b.prototype._doNavigationActionsLayout=function(){var r,n,N;if(this.getNavigationActions().length===0){return;}N=this._getNavigationActionsToolbar();r=this._shouldRenderActionsInTopArea();if(r){n=this.$topNavigationActionsArea[0];}else{n=this.$mainNavigationActionsArea[0];}this._bNavigationActionsInTopArea=r;b._renderControl(n,N);this._updateSeparatorVisibility();};b.prototype._onResize=function(d){var n,N,s;if(this.getNavigationActions().length===0){return;}n=d<b.NAV_ACTIONS_PLACEMENT_BREAK_POINT;N=this._areNavigationActionsInTopArea();s=n^N;if(s){this._toggleNavigationActionsPlacement(n);}};b.prototype._toggleNavigationActionsPlacement=function(s){this["_showNavigationActionsIn"+(s?"Top":"Main")+"Area"]();this._updateSeparatorVisibility();};b.prototype._showNavigationActionsInTopArea=function(){var n=this._getNavigationActionsToolbar();if(this.$topNavigationActionsArea&&this.$topNavigationActionsArea.length>0){this.$topNavigationActionsArea.html(n.$());}this._bNavigationActionsInTopArea=true;};b.prototype._showNavigationActionsInMainArea=function(){var n=this._getNavigationActionsToolbar();if(this.$mainNavigationActionsArea&&this.$mainNavigationActionsArea.length>0){this.$mainNavigationActionsArea.html(n.$());}this._bNavigationActionsInTopArea=false;};b.prototype._areNavigationActionsInTopArea=function(){return this._bNavigationActionsInTopArea;};b.prototype._updateSeparatorVisibility=function(){if(this.getDomRef()){this._getToolbarSeparator().toggleStyleClass("sapUiHidden",!this._shouldShowSeparator());}};b.prototype._shouldShowSeparator=function(){var h,H;if(this._bNavigationActionsInTopArea){return false;}h=this._getVisibleActions().length>0;H=this._getVisibleNavigationActions().length>0;return h&&H;};b.prototype._getVisibleActions=function(){return this.getActions().filter(function(A){return A.getVisible();});};b.prototype._getVisibleNavigationActions=function(){return this.getNavigationActions().filter(function(A){return A.getVisible();});};b.prototype._shouldRenderActionsInTopArea=function(){return this._getWidth()<b.NAV_ACTIONS_PLACEMENT_BREAK_POINT;};b.prototype._toggleState=function(E){this._bExpandedState=E;if(e(this.getSnappedContent())){this.$snappedWrapper.toggleClass("sapUiHidden",E);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageTitleMainSnapContentVisible",!E);}if(e(this.getSnappedHeading())){this.$snappedHeadingWrapper.toggleClass("sapUiHidden",E);}if(e(this.getExpandedContent())){this.$expandWrapper.toggleClass("sapUiHidden",!E);this.$expandWrapper.parent().toggleClass("sapFDynamicPageTitleMainExpandContentVisible",E);}if(e(this.getExpandedHeading())){this.$expandHeadingWrapper.toggleClass("sapUiHidden",!E);}};b.prototype._getExpandButton=function(){if(!this.getAggregation("_expandButton")){var E=new B({id:this.getId()+"-expandBtn",icon:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this),tooltip:this._oRB.getText("EXPAND_HEADER_BUTTON_TOOLTIP")}).addStyleClass("sapFDynamicPageToggleHeaderIndicator sapUiHidden");this.setAggregation("_expandButton",E,true);}return this.getAggregation("_expandButton");};b.prototype._onExpandButtonPress=function(){this.fireEvent("_titleVisualIndicatorPress");};b.prototype._toggleExpandButton=function(t){this._setShowExpandButton(t);this._getExpandButton().$().toggleClass("sapUiHidden",!t);};b.prototype._getShowExpandButton=function(){return this._bShowExpandButton;};b.prototype._setShowExpandButton=function(v){this._bShowExpandButton=!!v;};b.prototype._focusExpandButton=function(){this._getExpandButton().$().focus();};b.prototype._getWidth=function(){return this.$().outerWidth();};b.prototype._getState=function(){var h=this.getActions().length>0,H=this.getNavigationActions().length>0,d=this.getContent(),s=this.getSnappedContent(),E=this.getExpandedContent(),f=E.length>0,g=s.length>0,j=this.getPrimaryArea()===D.Begin,o=this._getExpandButton(),k=this.getBreadcrumbs(),m=k||H,n=!!(k&&!H),p=H&&!k;o.toggleStyleClass("sapUiHidden",!this._getShowExpandButton());return{id:this.getId(),actionBar:this._getActionsToolbar(),navigationBar:this._getNavigationActionsToolbar(),hasActions:h,hasNavigationActions:H,content:d,hasContent:d.length>0,heading:this.getHeading(),snappedHeading:this.getSnappedHeading(),expandedHeading:this.getExpandedHeading(),expandButton:o,snappedContent:s,expandedContent:E,hasSnappedContent:g,hasExpandedContent:f,hasAdditionalContent:f||g,isSnapped:!this._bExpandedState,isPrimaryAreaBegin:j,ariaText:this._oRB.getText("TOGGLE_HEADER"),breadcrumbs:this.getBreadcrumbs(),separator:this._getToolbarSeparator(),hasTopContent:m,hasOnlyBreadcrumbs:n,hasOnlyNavigationActions:p,contentAreaFlexBasis:this._sContentAreaFlexBasis};};b.prototype._observeChanges=function(o){var d=o.object,s=o.name;if(d===this){if(s==="content"){this._observeContentChanges(o);}}else if(s==="visible"){this._updateSeparatorVisibility();}};b.prototype._observeContentChanges=function(o){var d=o.child,m=o.mutation;if(!(d instanceof O)){return;}if(m==="insert"){d.attachEvent("_contentSizeChange",this._onContentSizeChange,this);}else if(m==="remove"){d.detachEvent("_contentSizeChange",this._onContentSizeChange,this);this._setContentAreaFlexBasis(0);}};b.prototype._onContentSizeChange=function(E){var d=E.getParameter("contentSize");this._setContentAreaFlexBasis(d);};b.prototype._setContentAreaFlexBasis=function(d){var f;d=parseInt(d,10);f=d?d+"px":"auto";this.$("content").css({"flex-basis":f,"-webkit-flex-basis":f});this._sContentAreaFlexBasis=f!=="auto"?f:undefined;};return b;});
