/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','./InputBase','./DateTimeField','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library'],function(q,D,I,a,U,l,C,c){"use strict";var T=c.TextAlign;var b=c.CalendarType;var d;var e=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"}}}},designTime:true}});e.prototype.init=function(){I.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);};e.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}if(this._iInvalidateCalendar){q.sap.clearDelayedCall(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};e.prototype.invalidate=function(o){if(!o||o!=this._oCalendar){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=q.sap.delayedCall(0,this,n);}};e.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();};e.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};e.prototype.getWidth=function(w){return this.getProperty("width")||"100%";};e.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;I.prototype.applyFocusInfo.apply(this,arguments);};e.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};e.prototype.onsapshow=function(E){f.call(this);E.preventDefault();};e.prototype.onsaphide=e.prototype.onsapshow;e.prototype.onsappageup=function(E){h.call(this,1,"day");E.preventDefault();};e.prototype.onsappageupmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){h.call(this,1,"month");}else{h.call(this,1,"year");}E.preventDefault();};e.prototype.onsappagedown=function(E){h.call(this,-1,"day");E.preventDefault();};e.prototype.onsappagedownmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){h.call(this,-1,"month");}else{h.call(this,-1,"year");}E.preventDefault();};e.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var s=String.fromCharCode(E.charCode);if(s&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(s)<0){E.preventDefault();}};e.prototype.onclick=function(E){if(q(E.target).hasClass("sapUiIcon")){f.call(this);}};e.prototype._dateValidation=function(o){this._bValid=true;if(o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime())){this._bValid=false;}this.setProperty("dateValue",o);return o;};e.prototype.setMinDate=function(o){if(this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getMinDate(),o)){return this;}if(o){var y=o.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(o.getTime());var p=this.getDateValue();if(p&&p.getTime()<o.getTime()){q.sap.log.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",o);if(this._oCalendar){this._oCalendar.setMinDate(o);}this._oMinDate.setHours(0,0,0,0);return this;};e.prototype.setMaxDate=function(o){if(this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getMaxDate(),o)){return this;}if(o){var y=o.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(o.getTime());var p=this.getDateValue();if(p&&p.getTime()>o.getTime()){q.sap.log.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",o);if(this._oCalendar){this._oCalendar.setMaxDate(o);}this._oMaxDate.setHours(23,59,59,999);return this;};e.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var o=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(o.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",o,true);this.setProperty("maxDate",M,true);if(this._oCalendar){this._oCalendar.setMinDate(o);this._oCalendar.setMaxDate(M);}}var p=this.getDateValue();if(p&&(p.getTime()<this._oMinDate.getTime()||p.getTime()>this._oMaxDate.getTime())){q.sap.log.error("dateValue "+p.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};e.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};e.prototype._handleDateValidation=function(o){this._bValid=true;if(!o||o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime()){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);}this.setProperty("dateValue",o);};e.prototype.setDisplayFormatType=function(s){if(s){var F=false;for(var t in b){if(t==s){F=true;break;}}if(!F){throw new Error(s+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",s,true);this.setDisplayFormat(this.getDisplayFormat());return this;};e.prototype.setSecondaryCalendarType=function(s){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",s,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(s);}return this;};e.prototype.addSpecialDate=function(s){m.call(this,s);this.addAggregation("specialDates",s,true);n.call(this);return this;};e.prototype.insertSpecialDate=function(s,o){m.call(this,s);this.insertAggregation("specialDates",s,o,true);n.call(this);return this;};e.prototype.removeSpecialDate=function(s){var r=this.removeAggregation("specialDates",s,true);n.call(this);return r;};e.prototype.removeAllSpecialDates=function(){var r=this.removeAllAggregation("specialDates",true);n.call(this);return r;};e.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);n.call(this);return this;};e.prototype.setLegend=function(L){this.setAssociation("legend",L,true);var s=this.getLegend();if(s){var o=sap.ui.require("sap/ui/unified/CalendarLegend");L=sap.ui.getCore().byId(s);if(L&&!(typeof o=="function"&&L instanceof o)){throw new Error(L+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._oCalendar){this._oCalendar.setLegend(s);}return this;};e.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var o=this._formatValue(this.getDateValue());if(v==o&&this._bValid){return;}var p;this._bValid=true;if(v!=""){p=this._parseValue(v,true);if(!p||p.getTime()<this._oMinDate.getTime()||p.getTime()>this._oMaxDate.getTime()){this._bValid=false;p=undefined;}else{v=this._formatValue(p);}}if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}if(p){v=this._formatValue(p,true);}if(this._lastValue!==v||(p&&this.getDateValue()&&p.getFullYear()!==this.getDateValue().getFullYear())){this._lastValue=v;this.setProperty("value",v,true);var N=this.getValue();if(this._bValid&&v==N){this.setProperty("dateValue",p,true);}v=N;if(this._oPopup&&this._oPopup.isOpen()){if(this._bValid){p=this.getDateValue();}this._oCalendar.focusDate(p);var s=this._oDateRange.getStartDate();if((!s&&p)||(s&&p&&s.getTime()!=p.getTime())){this._oDateRange.setStartDate(new Date(p.getTime()));}else if(s&&!p){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(v,{valid:this._bValid});}};e.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var o=this._parseValue(v,true);v=this._formatValue(o,true);return v;};e.prototype.updateDomValue=function(v){if(this.isActive()&&(this._$input.val()!==v)){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var o=this._parseValue(v,true);v=this._formatValue(o);this._$input.val(v);this._$input.cursorPos(this._curpos);}return this;};e.prototype._storeInputSelection=function(o){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:o.selectionStart,iEnd:o.selectionEnd};o.selectionStart=0;o.selectionEnd=0;}};e.prototype._restoreInputSelection=function(o){if((D.browser.msie||D.browser.edge)&&!D.support.touch){o.selectionStart=this._oInputSelBeforePopupOpen.iStart;o.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};function _(){this._createPopup();this._createPopupContent();var s;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){s=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.calendarType;}if(!s){s=this.getDisplayFormatType();}if(s){this._oCalendar.setPrimaryCalendarType(s);}var v=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(v!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}e.prototype._createPopup=function(){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setDurations(0,0);this._oPopup.attachOpened(i,this);this._oPopup.attachClosed(j,this);}};e.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup.setAutoCloseAreas([this.getDomRef()]);var o=sap.ui.core.Popup.Dock;var A;if(this.getTextAlign()==T.End){A=o.EndBottom+"-4";this._oPopup.open(0,o.EndTop,A,this,null,"fit",true);}else{A=o.BeginBottom+"-4";this._oPopup.open(0,o.BeginTop,A,this,null,"fit",true);}};e.prototype._getVisibleDatesRange=function(o){var v=o._getVisibleDays();return new sap.ui.unified.DateRange({startDate:v[0].toLocalJSDate(),endDate:v[v.length-1].toLocalJSDate()});};e.prototype._createPopupContent=function(){if(!this._oCalendar){if(!d){sap.ui.getCore().loadLibrary("sap.ui.unified");d=sap.ui.requireSync("sap/ui/unified/Calendar");}this._oCalendar=new d(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}.bind(this)});this._oDateRange=new sap.ui.unified.DateRange();this._oCalendar.addSelectedDate(this._oDateRange);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._selectDate,this);this._oCalendar.attachCancel(g,this);this._oCalendar.attachEvent("_renderMonth",k,this);this._oCalendar.setPopupMode(true);this._oCalendar.setParent(this,undefined,true);this._oPopup.setContent(this._oCalendar);}}};e.prototype._fillDateRange=function(){var o=this.getDateValue();if(o&&o.getTime()>=this._oMinDate.getTime()&&o.getTime()<=this._oMaxDate.getTime()){this._oCalendar.focusDate(new Date(o.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=o.getTime()){this._oDateRange.setStartDate(new Date(o.getTime()));}}else{var F=new Date();var M=this._oMaxDate.getTime()+86400000;if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._oCalendar.focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};e.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var o=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var p=this.getDateValue();if(p){v=this._formatValue(p);}}o.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATEINPUT");o.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return o;};function f(){if(this.getEditable()&&this.getEnabled()){if(!this._oPopup||!this._oPopup.isOpen()){_.call(this);}else{g.call(this);}}}e.prototype._selectDate=function(E){var o=this.getDateValue();var p=this._getSelectedDate();var v="";if(!q.sap.equal(p,o)){this.setDateValue(new Date(p.getTime()));v=this.getValue();this.fireChangeEvent(v,{valid:true});this._focusInput();}else if(!this._bValid){v=this._formatValue(p);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);this._lastValue=v;}v=this._formatValue(p,true);this.setProperty("value",v,true);this.fireChangeEvent(v,{valid:true});this._focusInput();}}else if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this.focus();}this._oPopup.close();};e.prototype._focusInput=function(){if(this.getDomRef()&&(D.system.desktop||!D.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}return this;};e.prototype._getSelectedDate=function(){var s=this._oCalendar.getSelectedDates();var o;if(s.length>0){o=s[0].getStartDate();}return o;};function g(E){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this.focus();}}}function h(N,u){var o=this.getDateValue();var p=this._$input.cursorPos();if(o&&this.getEditable()&&this.getEnabled()){var s;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){s=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.calendarType;}if(!s){s=this.getDisplayFormatType();}var r=U.getInstance(new Date(o.getTime()),s);o=U.getInstance(new Date(o.getTime()),s);switch(u){case"day":r.setDate(r.getDate()+N);break;case"month":r.setMonth(r.getMonth()+N);var M=(o.getMonth()+N)%12;if(M<0){M=12+M;}while(r.getMonth()!=M){r.setDate(r.getDate()-1);}break;case"year":r.setFullYear(r.getFullYear()+N);while(r.getMonth()!=o.getMonth()){r.setDate(r.getDate()-1);}break;default:break;}if(r.getTime()<this._oMinDate.getTime()){r=new U(this._oMinDate.getTime());}else if(r.getTime()>this._oMaxDate.getTime()){r=new U(this._oMaxDate.getTime());}if(!q.sap.equal(this.getDateValue(),r.getJSDate())){this.setDateValue(new Date(r.getTime()));this._curpos=p;this._$input.cursorPos(this._curpos);var v=this.getValue();this.fireChangeEvent(v,{valid:true});}}}function i(E){this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);}function j(E){this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));}function k(E){var o=E.getParameter("days");if(o>this._renderedDays){this._renderedDays=o;this._oPopup._applyPosition(this._oPopup._oLastPosition);}}function m(s){var o=sap.ui.require("sap/ui/unified/DateTypeRange");if(s&&!(o&&s instanceof o)){throw new Error(s+"is not valid for aggregation \"specialDates\" of "+this);}}function n(){if(this._oPopup&&this._oPopup.isOpen()){this._oCalendar._bDateRangeChanged=true;this._oCalendar.invalidate();}}return e;});
