/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./DatePicker','sap/ui/model/type/Date','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/LocaleData','jquery.sap.keycodes'],function(q,D,a,l,C,b,c,L){"use strict";var P=l.PlacementType;var S="Phone";var d=D.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",aggregations:{_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}}}});var e=C.extend("DateTimePickerPopup",{metadata:{aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},timeSliders:{type:"sap.ui.core.Control",multiple:false}}},renderer:function(r,p){r.write("<div");r.writeControlData(p);r.addClass("sapMDateTimePopupCont");r.addClass("sapMTimePickerDropDown");r.writeClasses();r.write(">");var s=p.getAggregation("_switcher");if(s){r.write("<div");r.addClass("sapMTimePickerSwitch");r.writeClasses();r.write(">");r.renderControl(s);r.write("</div>");}var o=p.getCalendar();if(o){r.renderControl(o);}r.write("<div");r.addClass("sapMTimePickerSep");r.writeClasses();r.write(">");r.write("</div>");var i=p.getTimeSliders();if(i){r.renderControl(i);}r.write("</div>");},init:function(){},onBeforeRendering:function(){var s=this.getAggregation("_switcher");if(!s){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=r.getText("DATETIMEPICKER_DATE");var t=r.getText("DATETIMEPICKER_TIME");s=new sap.m.SegmentedButton(this.getId()+"-Switch",{selectedKey:"Cal",items:[new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Cal",{key:"Cal",text:i}),new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Sli",{key:"Sli",text:t})]});s.attachSelect(this._handleSelect,this);this.setAggregation("_switcher",s,true);}if(b.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){s.setVisible(true);s.setSelectedKey("Cal");}else{s.setVisible(false);}},onAfterRendering:function(){if(b.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){var s=this.getAggregation("_switcher");var K=s.getSelectedKey();this._switchVisibility(K);}},_handleSelect:function(E){this._switchVisibility(E.getParameter("key"));},_switchVisibility:function(K){var o=this.getCalendar();var s=this.getTimeSliders();if(!o||!s){return;}if(K=="Cal"){o.$().css("display","");s.$().css("display","none");}else{o.$().css("display","none");s.$().css("display","");s.updateSlidersValues();s._onOrientationChanged();s._initFocus();}},switchToTime:function(){var s=this.getAggregation("_switcher");if(s&&s.getVisible()){s.setSelectedKey("Sli");this._switchVisibility("Sli");}},getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates();}});d.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bOnlyCalendar=false;};d.prototype.exit=function(){D.prototype.exit.apply(this,arguments);if(this._oSliders){this._oSliders.destroy();delete this._oSliders;}this._oPopupContent=undefined;b.media.detachHandler(this._handleWindowResize,this);};d.prototype.setDisplayFormat=function(s){D.prototype.setDisplayFormat.apply(this,arguments);if(this._oSliders){this._oSliders.setFormat(k.call(this));}return this;};d.prototype.setMinDate=function(o){D.prototype.setMinDate.call(this,o);if(o){this._oMinDate.setHours(o.getHours(),o.getMinutes(),o.getSeconds());}return this;};d.prototype.setMaxDate=function(o){D.prototype.setMaxDate.call(this,o);if(o){this._oMaxDate.setHours(o.getHours(),o.getMinutes(),o.getSeconds());}return this;};d.prototype._getFormatInstance=function(A,i){var M=q.extend({},A);var s=-1;if(M.style){s=M.style.indexOf("/");}if(i){var o=q.extend({},M);if(s>0){o.style=o.style.substr(0,s);}this._oDisplayFormatDate=c.getInstance(o);}return c.getDateTimeInstance(M);};d.prototype._checkStyle=function(p){if(D.prototype._checkStyle.apply(this,arguments)){return true;}else if(p.indexOf("/")>0){var s=["short","medium","long","full"];var n=false;for(var i=0;i<s.length;i++){var o=s[i];for(var j=0;j<s.length;j++){var r=s[j];if(p==o+"/"+r){n=true;break;}}if(n){break;}}return n;}return false;};d.prototype._parseValue=function(v,i){var o=D.prototype._parseValue.apply(this,arguments);if(i&&!o){o=this._oDisplayFormatDate.parse(v);if(o){var O=this.getDateValue();if(!O){O=new Date();}o.setHours(O.getHours());o.setMinutes(O.getMinutes());o.setSeconds(O.getSeconds());o.setMilliseconds(O.getMilliseconds());}}return o;};d.prototype._getPlaceholderPattern=function(o,p){var s=p.indexOf("/");if(s>0){return o.getCombinedDateTimePattern(p.substr(0,s),p.substr(s+1));}else{return o.getCombinedDateTimePattern(p,p);}};d.prototype._createPopup=function(){if(!this._oPopup){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var o=r.getText("TIMEPICKER_SET");var s=r.getText("TIMEPICKER_CANCEL");this._oPopupContent=new e(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oPopup=new sap.m.ResponsivePopover(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:P.VerticalPreferedBottom,beginButton:new sap.m.Button(this.getId()+"-OK",{text:o,press:q.proxy(_,this)}),endButton:new sap.m.Button(this.getId()+"-Cancel",{text:s,press:q.proxy(f,this)}),content:this._oPopupContent});this._oPopup.addStyleClass("sapMDateTimePopup");var p=this._oPopup.getAggregation("_popup");if(p.setShowArrow){p.setShowArrow(false);}this._oPopup.attachAfterOpen(g,this);this._oPopup.attachAfterClose(h,this);if(b.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(E){var K=q.sap.KeyCodes,i=E.which||E.keyCode,A=E.altKey;if((A&&(i===K.ARROW_UP||i===K.ARROW_DOWN))||i===K.F4){_.call(this,E);this.focus();E.preventDefault();}}};this._oPopup.addEventDelegate(this._oPopoverKeydownEventDelegate,this);}this.setAggregation("_popup",this._oPopup,true);}};d.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));var p=this._oPopup.getAggregation("_popup");p.oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);var s=this._oPopup.getContent()[0]&&this._oPopup.getContent()[0].getTimeSliders();if(s){q.sap.delayedCall(0,s,s.updateSlidersValues);}};d.prototype._createPopupContent=function(){var n=!this._oCalendar;D.prototype._createPopupContent.apply(this,arguments);if(n){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(m,this);}if(!this._oSliders){q.sap.require("sap.m.TimePickerSliders");this._oSliders=new sap.m.TimePickerSliders(this.getId()+"-Sliders",{format:k.call(this),invokedBy:this.getId()});this._oPopupContent.setTimeSliders(this._oSliders);}};d.prototype._fillDateRange=function(){var o=this.getDateValue();if(o){o=new Date(o.getTime());}else{o=new Date();var M=this._oMaxDate.getTime()+86400000;if(o.getTime()<this._oMinDate.getTime()||o.getTime()>M){o=this._oMinDate;}}this._oCalendar.focusDate(o);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=o.getTime()){this._oDateRange.setStartDate(o);}this._oSliders.setTimeValues(o);};d.prototype._getSelectedDate=function(){var o=D.prototype._getSelectedDate.apply(this,arguments);if(o){var i=this._oSliders.getTimeValues();var p=this._oSliders.getFormat();if(p.search("h")>=0||p.search("H")>=0){o.setHours(i.getHours());}if(p.search("m")>=0){o.setMinutes(i.getMinutes());}if(p.search("s")>=0){o.setSeconds(i.getSeconds());}if(o.getTime()<this._oMinDate.getTime()){o=new Date(this._oMinDate.getTime());}else if(o.getTime()>this._oMaxDate.getTime()){o=new Date(this._oMaxDate.getTime());}}return o;};d.prototype.getLocaleId=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};d.prototype.getAccessibilityInfo=function(){var i=D.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return i;};function _(E){this._selectDate();}function f(E){this.onsaphide(E);}d.prototype._handleWindowResize=function(p){var s=this.getAggregation("_popup").getContent()[0].getAggregation("_switcher"),o=this.getAggregation("_popup").getContent()[0].getCalendar(),i=this.getAggregation("_popup").getContent()[0].getTimeSliders();if(p.name===S){s.setVisible(true);this.getAggregation("_popup").getContent()[0]._switchVisibility(s.getSelectedKey());}else{s.setVisible(false);i.$().css("display","");o.$().css("display","");}};function g(E){this.$("inner").attr("aria-expanded",true);this._oCalendar.focus();this._oSliders._onOrientationChanged();b.media.attachHandler(this._handleWindowResize,this);}function h(){this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));b.media.detachHandler(this._handleWindowResize,this);}function k(){var s=this.getDisplayFormat();var t;var B=this.getBinding("value");if(B&&B.oType&&(B.oType instanceof a)){s=B.oType.getOutputPattern();}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.pattern;}else{s=this.getDisplayFormat();}if(!s){s="medium";}var i=s.indexOf("/");if(i>0&&this._checkStyle(s)){s=s.substr(i+1);}if(s=="short"||s=="medium"||s=="long"||s=="full"){var o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var j=L.getInstance(o);t=j.getTimePattern(s);}else{t=s;}return t;}function m(E){this._oPopupContent.switchToTime();}return d;});
