/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/m/Text','sap/m/Button','sap/ui/core/ResizeHandler','sap/ui/Device','sap/ui/core/Icon','sap/ui/layout/VerticalLayout','./InstanceManager','sap/ui/core/InvisibleText','sap/ui/core/library'],function(q,l,C,P,T,B,R,D,I,V,a,b,c){'use strict';var d=c.TextAlign;var e=l.ButtonType;var L=l.LightBoxLoadingStates;var f=C.extend('sap.m.LightBox',{metadata:{interfaces:['sap.ui.core.PopupInterface'],library:'sap.m',aggregations:{imageContent:{type:'sap.m.LightBoxItem',multiple:true,bindable:"bindable"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:'hidden'},_errorIcon:{type:'sap.ui.core.Icon',multiple:false,visibility:'hidden'},_errorTitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_errorSubtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_verticalLayout:{type:'sap.ui.layout.VerticalLayout',multiple:false,visibility:'hidden'},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},events:{},defaultAggregation:'imageContent'}});f.prototype.init=function(){this._createPopup();this._width=0;this._height=0;this._isRendering=true;this._resizeListenerId=null;this._$lightBox=null;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._closeButtonText=this._rb.getText("LIGHTBOX_CLOSE_BUTTON");if(sap.ui.getCore().getConfiguration().getAccessibility()){this.setAggregation("_invisiblePopupText",new b());}};f.prototype.onBeforeRendering=function(){var i=this._getImageContent(),n=i._getNativeImage(),s=i.getImageSrc(),S=i._getImageState();this._createErrorControls();if(n.src!==s){n.src=s;}if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}switch(S){case L.Loading:this._timeoutId=setTimeout(function(){i._setImageState(L.TimeOutError);},10000);break;case L.Loaded:clearTimeout(this._timeoutId);this._calculateSizes(n);break;case L.Error:clearTimeout(this._timeoutId);break;default:break;}var o=this.getAggregation('_invisiblePopupText');if(i&&o){o.setText(this._rb.getText("LIGHTBOX_ARIA_ENLARGED",i.getTitle()));}this._isRendering=true;};f.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._resizeListenerId){D.resize.attachHandler(this._onResize.bind(this));this._resizeListenerId=R.register(this,this._onResize.bind(this));}};f.prototype.forceInvalidate=C.prototype.invalidate;f.prototype.invalidate=function(o){var i=this._getImageContent();if(this.isOpen()){if(i&&i.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};f.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnOpened,this);this._oPopup.detachClosed(this._fnClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}a.removeLightBoxInstance(this);};f.prototype.open=function(){var i=this._getImageContent();this._oPopup.setContent(this);if(i&&i.getImageSrc()){this._oPopup.open(300,'center center','center center',document.body,null);a.addLightBoxInstance(this);}return this;};f.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};f.prototype.close=function(){if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._oPopup.close();a.removeLightBoxInstance(this);return this;};f.prototype._getCloseButton=function(){var h=this.getAggregation('_closeButton');if(!h){h=new B({id:this.getId()+'-closeButton',text:this._closeButtonText,type:e.Transparent,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',h,true);}return h;};f.prototype._getBusyIndicator=function(){var h=this.getAggregation("_busy");if(!h){h=new sap.m.BusyIndicator();this.setAggregation("_busy",h,true);}return h;};f.prototype._imageStateChanged=function(n){var s=n===L.Loaded||n===L.Error;if(s&&!this._isRendering){this.rerender();}};f.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnOpened,this);this._oPopup.attachClosed(this._fnClosed,this);};f.prototype._fnOpened=function(){var t=this;q('#sap-ui-blocklayer-popup').on("click",function(){t.close();});};f.prototype._fnClosed=function(){q('#sap-ui-blocklayer-popup').off("click");};f.prototype._createErrorControls=function(){var r=this._rb;var h;var i;if(this._getImageContent()._getImageState()===L.TimeOutError){h=r.getText('LIGHTBOX_IMAGE_TIMED_OUT');i=r.getText('LIGHTBOX_IMAGE_TIMED_OUT_DETAILS');}else{h=r.getText('LIGHTBOX_IMAGE_ERROR');i=r.getText('LIGHTBOX_IMAGE_ERROR_DETAILS');}if(!this.getAggregation('_verticalLayout')){var j=new T({text:h,textAlign:d.Center}).addStyleClass("sapMLightBoxErrorTitle"),k=new T({text:i,textAlign:d.Center}).addStyleClass("sapMLightBoxErrorSubtitle"),m=new I({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation('_verticalLayout',new V({content:[m,j,k]}).addStyleClass('sapMLightBoxVerticalLayout'));}};f.prototype._onResize=function(){var m=g()/2+'px',t=m,h=m,i='',j='',o=this._getImageContent(),k=this.getDomRef(),n,p,r=g(),s=2;if(o._getImageState()===L.Loaded){this._calculateSizes(o._getNativeImage());n=this._width;p=this._height;this._$lightBox.width(n);this._$lightBox.height(p);}else{n=k.clientWidth;p=k.clientHeight;}if(window.innerWidth>n+r){h='50%';j=Math.round(-n/2);}if(window.innerHeight>p+r){t='50%';i=Math.round(-p/2);}if(sap.ui.getCore().getConfiguration().getTheme()==='sap_hcb'){i-=s;j-=s;}this._$lightBox.css({'top':t,'margin-top':i,'left':h,'margin-left':j});};f.prototype._calculateSizes=function(i){var F=this._calculateFooterHeightInPx(),h=288-F,j=this._getImageContent().getAggregation("_image"),k;this._setImageSize(j,i.naturalWidth,i.naturalHeight);this._calculateAndSetLightBoxSize(j);k=this._pxToNumber(j.getHeight());this.toggleStyleClass('sapMLightBoxMinSize',(k<h));this._isBusy=false;};f.prototype._calculateFooterHeightInPx=function(){var h=this.$().parents().hasClass('sapUiSizeCompact');var s=this._getImageContent().getSubtitle();var i=2.5;if(!h){i+=0.5;}if(s){i+=1.5;}return i*16;};f.prototype._calculateAndSetLightBoxSize=function(i){var h,j=(20*16),k=(18*16),F=this._calculateFooterHeightInPx();h=this._pxToNumber(i.getHeight());this._width=Math.max(j,this._pxToNumber(i.getWidth()));this._height=Math.max(k,h+F);};f.prototype._setImageSize=function(i,h,j){var k=this._calculateFooterHeightInPx(),m=this._getDimensions(h,j,k);i.setWidth(m.width+'px');i.setHeight(m.height+'px');};f.prototype._getDimensions=function(i,h,j){var k=20*16,m=18*16,$=q(window),w=$.height(),n=$.width(),o=g(),p=Math.max(n-o,k),r=Math.max(w-o,m),s;r-=j;if(h<=r){if(i<=p){}else{h*=p/i;i=p;}}else{if(i<=p){i*=r/h;h=r;}else{s=Math.max(i/p,h/r);i/=s;h/=s;}}return{width:Math.round(i),height:Math.round(h)};};f.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};f.prototype._getImageContent=function(){var r=this.getAggregation('imageContent');return r&&r[0];};function g(){var s=D.system;if(s.desktop){return 4*16;}if(s.tablet){return 2*16;}return 0;}return f;});
