/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./GroupHeaderListItem','./ListItemBase','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/core/LabelEnablement','sap/ui/Device','jquery.sap.keycodes'],function(q,G,L,l,C,I,a,b,D){"use strict";var c=l.ListType;var d=l.ListKeyboardMode;var f=l.ListGrowingDirection;var S=l.SwipeDirection;var g=l.ListSeparators;var h=l.ListMode;var j=l.ListHeaderDesign;var k=C.extend("sap.m.ListBase",{metadata:{library:"sap.m",properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:j.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:h.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:g.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:S.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},growingDirection:{type:"sap.m.ListGrowingDirection",group:"Behavior",defaultValue:f.Downwards},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:d.Navigation}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable"},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},"delete":{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}}},designTime:true}});k.prototype.bAnnounceDetails=true;k.getInvisibleText=function(){return this.oInvisibleText||(this.oInvisibleText=new a().toStatic());};k.prototype.sNavItemClass="sapMLIB";k.prototype.init=function(){this._aNavSections=[];this._aSelectedPaths=[];this._iItemNeedsHighlight=0;this.data("sap-ui-fastnavgroup","true",true);};k.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent();};k.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();if(D.system.desktop){this._bItemNavigationInvalidated=true;}};k.prototype.exit=function(){this._oSelectedItem=null;this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation();};k.prototype.refreshItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(r);}else{if(!this._bReceivingData){this._updateStarted(r);this._bReceivingData=true;}this.refreshAggregation("items");}};k.prototype.updateItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(r);}else{if(this._bReceivingData){this._bReceivingData=false;}else{this._updateStarted(r);}this.updateAggregation("items");this._updateFinished();}};k.prototype.setBindingContext=function(){this._resetItemsBinding();return C.prototype.setBindingContext.apply(this,arguments);};k.prototype._bindAggregation=function(n,B){function e(B,E,H){B.events=B.events||{};if(!B.events[E]){B.events[E]=H;}else{var o=B.events[E];B.events[E]=function(){o.apply(this,arguments);H.apply(this,arguments);};}}if(n==="items"){this._resetItemsBinding();e(B,"dataRequested",this._onBindingDataRequestedListener.bind(this));e(B,"dataReceived",this._onBindingDataReceivedListener.bind(this));}C.prototype._bindAggregation.call(this,n,B);};k.prototype._onBindingDataRequestedListener=function(e){this._showBusyIndicator();if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};k.prototype._onBindingDataReceivedListener=function(e){if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){this._hideBusyIndicator();delete this._dataReceivedHandlerId;});};k.prototype.destroyItems=function(s){if(!this.getItems(true).length){return this;}this._oSelectedItem=null;this.destroyAggregation("items","KeepDom");if(!s){this.invalidate();}return this;};k.prototype.removeAllItems=function(A){this._oSelectedItem=null;return this.removeAllAggregation("items");};k.prototype.removeItem=function(i){var o=this.removeAggregation("items",i);if(o&&o===this._oSelectedItem){this._oSelectedItem=null;}return o;};k.prototype.getItems=function(r){if(r){return this.mAggregations["items"]||[];}return this.getAggregation("items",[]);};k.prototype.getId=function(s){var i=this.sId;return s?i+"-"+s:i;};k.prototype.setGrowing=function(e){e=!!e;if(this.getGrowing()!=e){this.setProperty("growing",e,!e);if(e){q.sap.require("sap.m.GrowingEnablement");this._oGrowingDelegate=new sap.m.GrowingEnablement(this);}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}}return this;};k.prototype.setGrowingThreshold=function(t){return this.setProperty("growingThreshold",t,true);};k.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(!this.getEnableBusyIndicator()){this._hideBusyIndicator();}return this;};k.prototype.setNoDataText=function(n){this.setProperty("noDataText",n,true);this.$("nodata-text").text(this.getNoDataText());return this;};k.prototype.getNoDataText=function(e){if(e&&this._bBusy){return"";}var n=this.getProperty("noDataText");n=n||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_NO_DATA");return n;};k.prototype.getSelectedItem=function(){var e=this.getItems(true);for(var i=0;i<e.length;i++){if(e[i].getSelected()){return e[i];}}return null;};k.prototype.setSelectedItem=function(o,s,F){if(this.indexOfItem(o)<0){q.sap.log.warning("setSelectedItem is called without valid ListItem parameter on "+this);return;}if(this._bSelectionMode){o.setSelected((s===undefined)?true:!!s);F&&this._fireSelectionChangeEvent([o]);}};k.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(i){return i.getSelected();});};k.prototype.setSelectedItemById=function(i,s){var o=sap.ui.getCore().byId(i);return this.setSelectedItem(o,s);};k.prototype.getSelectedContexts=function(A){var B=this.getBindingInfo("items"),m=(B||{}).model,M=this.getModel(m);if(!B||!M){return[];}if(A&&this.getRememberSelections()){return this._aSelectedPaths.map(function(p){return M.getContext(p);});}return this.getSelectedItems().map(function(i){return i.getBindingContext(m);});};k.prototype.removeSelections=function(A,F,e){var i=[];this._oSelectedItem=null;A&&(this._aSelectedPaths=[]);this.getItems(true).forEach(function(o){if(!o.getSelected()){return;}if(e&&o.isSelectedBoundTwoWay()){return;}o.setSelected(false,true);i.push(o);!A&&this._updateSelectedPaths(o);},this);if(F&&i.length){this._fireSelectionChangeEvent(i);}return this;};k.prototype.selectAll=function(F){if(this.getMode()!="MultiSelect"){return this;}var e=[];this.getItems(true).forEach(function(i){if(!i.getSelected()){i.setSelected(true,true);e.push(i);this._updateSelectedPaths(i);}},this);if(F&&e.length){this._fireSelectionChangeEvent(e,F);}return this;};k.prototype.getLastMode=function(m){return this._sLastMode;};k.prototype.setMode=function(m){m=this.validateProperty("mode",m);var o=this.getMode();if(o==m){return this;}this._bSelectionMode=m.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true);}else{var s=this.getSelectedItems();if(s.length>1){this.removeSelections(true);}else if(o===h.MultiSelect){this._oSelectedItem=s[0];}}return this.setProperty("mode",m);};k.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null;};k.prototype.setRememberSelections=function(r){this.setProperty("rememberSelections",r,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this;};k.prototype.setSelectedContextPaths=function(s){this._aSelectedPaths=s||[];};k.prototype.getSelectedContextPaths=function(A){if(!A||(A&&this.getRememberSelections())){return this._aSelectedPaths.slice(0);}return this.getSelectedItems().map(function(i){return i.getBindingContextPath();});};k.prototype.isAllSelectableSelected=function(){if(this.getMode()!=h.MultiSelect){return false;}var i=this.getItems(true),s=this.getSelectedItems().length,e=i.filter(function(o){return o.isSelectable();}).length;return(i.length>0)&&(s==e);};k.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(i){return i.getVisible();});};k.prototype.getActiveItem=function(){return this._bActiveItem;};k.prototype.onItemDOMUpdate=function(o){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true);}};k.prototype.onItemActiveChange=function(o,A){this._bActiveItem=A;};k.prototype.onItemHighlightChange=function(i,n){this._iItemNeedsHighlight+=(n?1:-1);if(this._iItemNeedsHighlight==1&&n){this.$("listUl").addClass("sapMListHighlight");}else if(this._iItemNeedsHighlight==0){this.$("listUl").removeClass("sapMListHighlight");}};k.prototype.onItemSelectedChange=function(o,s){if(this.getMode()==h.MultiSelect){this._updateSelectedPaths(o,s);return;}if(s){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=o;}else if(this._oSelectedItem===o){this._oSelectedItem=null;}this._updateSelectedPaths(o,s);};k.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl");};k.prototype.checkGrowingFromScratch=function(){};k.prototype.onBeforePageLoaded=function(o,s){this._fireUpdateStarted(s,o);this.fireGrowingStarted(o);};k.prototype.onAfterPageLoaded=function(o,s){this._fireUpdateFinished(o);this.fireGrowingFinished(o);};k.prototype.addNavSection=function(i){this._aNavSections.push(i);return i;};k.prototype.getMaxItemsCount=function(){var B=this.getBinding("items");if(B&&B.getLength){return B.getLength()||0;}return this.getItems(true).length;};k.prototype.shouldRenderItems=function(){return true;};k.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation){this._oItemNavigation.iFocusedIndex=-1;}}};k.prototype._updateStarted=function(r){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(r);}};k.prototype._fireUpdateStarted=function(r,i){this._sUpdateReason=q.sap.charToUpperCase(r||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});};k.prototype.onThemeChanged=function(){if(this._oGrowingDelegate){this._oGrowingDelegate._updateTrigger();}};k.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false;}};k.prototype._fireUpdateFinished=function(i){this._hideBusyIndicator();q.sap.delayedCall(0,this,function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});});};k.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this._sBusyTimer=q.sap.delayedCall(this.getBusyIndicatorDelay(),this,function(){this.$("nodata-text").text("");});this.setBusy(true,"listUl");}};k.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;this.setBusy(false,"listUl");q.sap.clearDelayedCall(this._sBusyTimer);if(!this.getItems(true).length){this.$("nodata-text").text(this.getNoDataText());}}};k.prototype.onItemBindingContextSet=function(i){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return;}if(i.isSelectedBoundTwoWay()){return;}var p=i.getBindingContextPath();if(p){var s=(this._aSelectedPaths.indexOf(p)>-1);i.setSelected(s);}};k.prototype.onItemInserted=function(i,s){if(s){this.onItemSelectedChange(i,true);}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||i.isSelectedBoundTwoWay()||i.getSelected()){return;}var p=i.getBindingContextPath();if(p&&this._aSelectedPaths.indexOf(p)>-1){i.setSelected(true);}};k.prototype.onItemSelect=function(o,s){if(this.getMode()==h.MultiSelect){this._fireSelectionChangeEvent([o]);}else if(this._bSelectionMode&&s){this._fireSelectionChangeEvent([o]);}};k.prototype._fireSelectionChangeEvent=function(e,s){var o=e&&e[0];if(!o){return;}this.fireSelectionChange({listItem:o,listItems:e,selected:o.getSelected(),selectAll:!!s});this.fireSelect({listItem:o});};k.prototype.onItemDelete=function(o){this.fireDelete({listItem:o});};k.prototype.onItemPress=function(o,s){if(o.getType()==c.Inactive){return;}q.sap.delayedCall(0,this,function(){this.fireItemPress({listItem:o,srcControl:s});});};k.prototype._updateSelectedPaths=function(i,s){if(!this.getRememberSelections()||!this.isBound("items")){return;}var p=i.getBindingContextPath();if(!p){return;}s=(s===undefined)?i.getSelected():s;var e=this._aSelectedPaths.indexOf(p);if(s){e<0&&this._aSelectedPaths.push(p);}else{e>-1&&this._aSelectedPaths.splice(e,1);}};k.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}};k.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};k.prototype._getTouchBlocker=function(){return this.$().children();};k.prototype._getSwipeContainer=function(){return this._$swipeContainer||(q.sap.require("sap.m.InstanceManager"),this._$swipeContainer=q("<div>",{"id":this.getId("swp"),"class":"sapMListSwp"}));};k.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top);}};k.prototype._renderSwipeContent=function(){var $=this._swipedItem.$(),e=this._getSwipeContainer();this.$().prepend(e.css({top:$.position().top,height:$.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var r=sap.ui.getCore().createRenderManager();r.render(this.getSwipeContent(),e.empty()[0]);r.destroy();}return this;};k.prototype._swipeIn=function(){var t=this,$=t._getTouchBlocker(),i=t._getSwipeContainer();t._isSwipeActive=true;t._renderSwipeContent();sap.m.InstanceManager.addDialogInstance(t);window.document.activeElement.blur();q(window).on("resize.swp",function(){t._setSwipePosition();});$.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!i[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation();}});i.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");i.css("opacity",1).focus();$.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(e){if(!i[0].firstChild.contains(e.target)){t.swipeOut();}});}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim");};k.prototype._onSwipeOut=function(e){this._getSwipeContainer().css("opacity",0).remove();q(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof e=="function"){e.call(this,this._swipedItem,this.getSwipeContent());}this._isSwipeActive=false;sap.m.InstanceManager.removeDialogInstance(this);};k.prototype.swipeOut=function(e){if(!this._isSwipeActive){return this;}var t=this,$=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");$.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._onSwipeOut(e);}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this;};k.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut();}};k.prototype.close=k.prototype._removeSwipeContent;k.prototype._onSwipe=function(e){var o=this.getSwipeContent(),s=e.srcControl;if(o&&s&&!this._isSwipeActive&&this!==s&&!this._eventHandledByControl&&D.support.touch){for(var i=s;i&&!(i instanceof L);i=i.oParent);if(i instanceof L){this._swipedItem=i;this.fireSwipe({listItem:this._swipedItem,swipeContent:o,srcControl:s},true)&&this._swipeIn();}}};k.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();};k.prototype.onswipeleft=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"RightToLeft":"LeftToRight";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};k.prototype.onswiperight=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"LeftToRight":"RightToLeft";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};k.prototype.setSwipeDirection=function(s){return this.setProperty("swipeDirection",s,true);};k.prototype.getSwipedItem=function(){return(this._isSwipeActive?this._swipedItem:null);};k.prototype.setSwipeContent=function(o){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!o);return this.setAggregation("swipeContent",o,!this._isSwipeActive);};k.prototype.invalidate=function(o){if(o&&o===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return this;}C.prototype.invalidate.apply(this,arguments);return this;};k.prototype.addItemGroup=function(o,H,s){H=H||new G({title:o.text||o.key});H._bGroupHeader=true;this.addAggregation("items",H,s);return H;};k.prototype.removeGroupHeaders=function(s){this.getItems(true).forEach(function(i){if(i.isGroupHeader()){i.destroy(s);}});};k.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LIST");};k.prototype.getAccessibilityStates=function(){if(!this.getItems(true).length){return"";}var s="",m=h,M=this.getMode(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(b.isRequired(this)){s+=B.getText("LIST_REQUIRED")+" ";}if(M==m.MultiSelect){s+=B.getText("LIST_MULTISELECTABLE")+" ";}else if(M==m.Delete){s+=B.getText("LIST_DELETABLE")+" ";}else if(M!=m.None){s+=B.getText("LIST_SELECTABLE")+" ";}if(this.isGrouped()){s+=B.getText("LIST_GROUPED")+" ";}return s;};k.prototype.getAccessibilityDescription=function(){var s=this.getAriaLabelledBy().map(function(A){var o=sap.ui.getCore().byId(A);return L.getAccessibilityText(o);}).join(" ");var H=this.getHeaderToolbar();if(H){var t=H.getTitleControl();if(t){s+=t.getText()+" ";}}else{s+=this.getHeaderText()+" ";}s+=this.getAccessibilityStates()+" ";return s;};k.prototype.getAccessibilityInfo=function(){return{description:this.getAccessibilityDescription().trim(),focusable:true};};k.prototype.getAccessbilityPosition=function(i){var s=0,e=this.getVisibleItems(),p=e.indexOf(i)+1,B=this.getBinding("items");if(this.getGrowing()&&this.getGrowingScrollToLoad()&&B&&B.isLengthFinal()){s=B.getLength();if(B.isGrouped()){s+=e.filter(function(i){return i.isGroupHeader()&&i.getVisible();}).length;}}else{s=e.length;}return{setSize:s,posInset:p};};k.prototype.onItemFocusIn=function(i){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}var o=i.getDomRef(),p=this.getAccessbilityPosition(i);if(!i.getContentAnnouncement){this.getNavigationRoot().setAttribute("aria-activedescendant",o.id);o.setAttribute("aria-posinset",p.posInset);o.setAttribute("aria-setsize",p.setSize);}else{var A=i.getAccessibilityInfo(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=A.type+" ";s+=B.getText("LIST_ITEM_POSITION",[p.posInset,p.setSize])+" ";s+=A.description;this.updateInvisibleText(s,o);return s;}};k.prototype.updateInvisibleText=function(t,i,p){var o=k.getInvisibleText(),F=q(i||document.activeElement);if(this.bAnnounceDetails){this.bAnnounceDetails=false;t=this.getAccessibilityInfo().description+" "+t;}o.setText(t.trim());F.addAriaLabelledBy(o.getId(),p);window.setTimeout(function(){F.removeAriaLabelledBy(o.getId());},0);};k.prototype.getNavigationRoot=function(){return this.getDomRef("listUl");};k.prototype.getFocusDomRef=function(){return this.getNavigationRoot();};k.prototype._startItemNavigation=function(i){if(!D.system.desktop){return;}var K=this.getKeyboardMode(),m=d;if(K==m.Edit&&!this.getItems(true).length){return;}var n=this.getNavigationRoot();var t=(K==m.Edit)?-1:0;if(i&&!n.contains(document.activeElement)){this._bItemNavigationInvalidated=true;if(!n.getAttribute("tabindex")){n.tabIndex=t;}return;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);this._setItemNavigationTabIndex(t);this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}this._oItemNavigation.setPageSize(this.getGrowingThreshold());this._oItemNavigation.setRootDomRef(n);this.setNavigationItems(this._oItemNavigation,n);this._bItemNavigationInvalidated=false;};k.prototype.setNavigationItems=function(i,n){var N=q(n).children(".sapMLIB").get();i.setItemDomRefs(N);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==f.Upwards){i.setFocusedIndex(N.length-1);}else{i.setFocusedIndex(0);}}};k.prototype.getItemNavigation=function(){return this._oItemNavigation;};k.prototype._setItemNavigationTabIndex=function(t){if(this._oItemNavigation){this._oItemNavigation.iActiveTabIndex=t;this._oItemNavigation.iTabIndex=t;}};k.prototype.setKeyboardMode=function(K){this.setProperty("keyboardMode",K,true);if(this.isActive()){var t=(K==d.Edit)?-1:0;this.$("nodata").prop("tabIndex",~t);this.$("listUl").prop("tabIndex",t);this.$("after").prop("tabIndex",t);this._setItemNavigationTabIndex(t);}return this;};k.prototype.setItemFocusable=function(o){if(!this._oItemNavigation){return;}var i=this._oItemNavigation.getItemDomRefs();var e=i.indexOf(o.getDomRef());if(e>=0){this._oItemNavigation.setFocusedIndex(e);}};k.prototype.forwardTab=function(F){this._bIgnoreFocusIn=true;this.$(F?"after":"before").focus();};k.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==d.Edit){return;}if(e.target.id==this.getId("nodata")){this.forwardTab(true);e.setMarked();}};k.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==d.Edit){return;}var t=e.target.id;if(t==this.getId("nodata")){this.forwardTab(false);}else if(t==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};k.prototype._navToSection=function(F){var t;var i=0;var s=F?1:-1;var e=this._aNavSections.length;this._aNavSections.some(function(m,n){var p=q.sap.domById(m);if(p&&p.contains(document.activeElement)){i=n;return true;}});var o=this.getItemsContainerDomRef();var $=q.sap.byId(this._aNavSections[i]);if($[0]===o&&this._oItemNavigation){$.data("redirect",this._oItemNavigation.getFocusedIndex());}this._aNavSections.some(function(){i=(i+s+e)%e;t=q.sap.byId(this._aNavSections[i]);if(t[0]===o&&this._oItemNavigation){var r=t.data("redirect");var m=this._oItemNavigation.getItemDomRefs();var T=m[r]||o.children[0];t=q(T);}if(t.is(":focusable")){t.focus();return true;}},this);return t;};k.prototype.onsapshow=function(e){if(e.isMarked()||e.which==q.sap.KeyCodes.F4||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(true)){e.preventDefault();e.setMarked();}};k.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(false)){e.preventDefault();e.setMarked();}};k.prototype.onkeydown=function(e){var i=(e.which==q.sap.KeyCodes.A)&&(e.metaKey||e.ctrlKey);if(e.isMarked()||!i||!q(e.target).hasClass(this.sNavItemClass)){return;}e.preventDefault();if(this.getMode()!==h.MultiSelect){return;}if(this.isAllSelectableSelected()){this.removeSelections(false,true);}else{this.selectAll(true);}e.setMarked();};k.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation();}};k.prototype.focusPrevious=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(n[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");var F=t.eq(-1).add($).eq(-1);this.bAnnounceDetails=true;F.focus();};k.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return;}if(this._bItemNavigationInvalidated){this._startItemNavigation();}var t=e.target;if(t.id==this.getId("nodata")){this.updateInvisibleText(this.getNoDataText(),t);}if(e.isMarked()||!this._oItemNavigation||this.getKeyboardMode()==d.Edit||t.id!=this.getId("after")){return;}this.focusPrevious();e.setMarked();};k.prototype.onsapfocusleave=function(e){if(this._oItemNavigation&&!this.bAnnounceDetails&&!this.getNavigationRoot().contains(document.activeElement)){this.bAnnounceDetails=true;}};k.prototype.onItemArrowUpDown=function(o,e){var i=this.getItems(true),m=i.indexOf(o)+(e.type=="sapup"?-1:1),n=i[m];if(n&&n.isGroupHeader()){n=i[m+(e.type=="sapup"?-1:1)];}if(!n){return;}var t=n.getTabbables(),F=o.getTabbables().index(e.target),E=t.eq(t[F]?F:-1);E[0]?E.focus():n.focus();e.preventDefault();e.setMarked();};k.prototype.getAggregationDomRef=function(A){if(A=="items"){return this.getItemsContainerDomRef();}};k.prototype.isGrouped=function(){var B=this.getBinding("items");return B&&B.isGrouped();};return k;});
