/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/library','sap/m/library','sap/ui/core/Control','sap/ui/core/IconPool','sap/m/Text','sap/m/VBox','sap/m/Page','sap/m/Image'],function(q,l,c,m,C,I,T,V,P,a){"use strict";var b=c.TextAlign;var d=c.TextDirection;var F=m.FlexJustifyContent;var e=m.FlexAlignItems;var M=C.extend("sap.m.MessagePage",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:"No matching items found."},description:{type:"string",group:"Misc",defaultValue:"Check the filter settings."},title:{type:"string",group:"Misc",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:"sap-icon://documents"},iconAlt:{type:"string",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit}},aggregations:{customText:{type:"sap.m.Link",multiple:false},customDescription:{type:"sap.m.Link",multiple:false},_page:{type:"sap.m.Page",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{navButtonPress:{}}}});M.prototype.init=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setAggregation("_page",new P({id:this.getId()+"-page",showHeader:this.getShowHeader(),navButtonPress:q.proxy(function(){this.fireNavButtonPress();},this)}));this.setProperty("text",B.getText("MESSAGE_PAGE_TEXT"),true);this.setProperty("description",B.getText("MESSAGE_PAGE_DESCRIPTION"),true);};M.prototype.onBeforeRendering=function(){if(!(this._oText&&this._oDescription)){this._addPageContent();}};M.prototype.exit=function(){var p=this.getAggregation("_page");if(p){p.destroy();p=null;}if(this._oVBox){this._oVBox=null;}if(this._oText){this._oText=null;}if(this._oDescription){this._oDescription=null;}if(this._oIconControl){this._oIconControl=null;}};M.prototype.setTitle=function(t){this.setProperty("title",t,true);this.getAggregation("_page").setTitle(t);return this;};M.prototype.setText=function(t){this.setProperty("text",t,true);this._oText&&this._oText.setText(t);return this;};M.prototype.setDescription=function(D){this.setProperty("description",D,true);this._oDescription&&this._oDescription.setText(D);return this;};M.prototype.setShowHeader=function(s){this.setProperty("showHeader",s,true);this.getAggregation("_page").setShowHeader(s);return this;};M.prototype.setShowNavButton=function(s){this.setProperty("showNavButton",s,true);this.getAggregation("_page").setShowNavButton(s);return this;};M.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);this._oText&&this._oText.setTextDirection(t);this._oDescription&&this._oDescription.setTextDirection(t);return this;};M.prototype.setIcon=function(i){var o=this.getIcon();this.setProperty("icon",i,true);if(this._oIconControl){if(o!==i&&I.isIconURI(o)!==I.isIconURI(i)){var v=this._getMessagePageContent();v.removeItem(this._oIconControl);v.insertItem(this._getIconControl(),0);}else{this._oIconControl.setSrc(i);}}return this;};M.prototype.setIconAlt=function(i){this.setProperty("iconAlt",i,true);if(this._oIconControl){this._oIconControl.setAlt(i);}return this;};M.prototype._addPageContent=function(){this.getAggregation("_page").addContent(this._getMessagePageContent());};M.prototype._getMessagePageContent=function(){if(!this._oVBox){this._oVBox=new V(this.getId()+'-vbox',{fitContainer:true,justifyContent:F.Center,alignItems:e.Center,items:[this._getIconControl(),this._getText(),this._getDescription()]});}return this._oVBox;};M.prototype._getIconControl=function(){if(this._oIconControl){this._oIconControl.destroy();}this._oIconControl=I.createControlByURI({id:this.getId()+"-pageIcon",src:this.getIcon(),height:"8rem",useIconTooltip:true,decorative:false,alt:this.getIconAlt()},a).addStyleClass("sapMMessagePageIcon");return this._oIconControl;};M.prototype._getText=function(){if(this.getAggregation("customText")){this._oText=this.getAggregation("customText");}else{this._oText=new T({id:this.getId()+"-customText",text:this.getText(),textAlign:b.Center,textDirection:this.getTextDirection()});}this._oText.addStyleClass("sapMMessagePageMainText");return this._oText;};M.prototype._getDescription=function(){if(this.getAggregation("customDescription")){this._oDescription=this.getAggregation("customDescription");}else{this._oDescription=new T({id:this.getId()+"-customDescription",text:this.getDescription(),textAlign:b.Center,textDirection:this.getTextDirection()});}this._oDescription.addStyleClass("sapMMessagePageDescription");return this._oDescription;};M.prototype._getAnyHeader=function(){return this._getInternalHeader();};M.prototype._getInternalHeader=function(){return this.getAggregation("_page").getAggregation("_internalHeader");};return M;});
