/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","./Button","./Toolbar","./ToolbarSpacer","./List","./StandardListItem","./library","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./MessageItem","./GroupHeaderListItem","sap/ui/core/library","jquery.sap.keycodes"],function(q,C,a,I,H,b,B,T,c,L,S,l,d,e,P,N,f,M,G,g){"use strict";var V=g.ValueState;var h=g.MessageType;var j=l.ListType;var k=C.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},groupItems:{type:"boolean",group:"Behavior",defaultValue:false},showDetailsPageHeader:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false},_navContainer:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});var m="sapMMsgView";var n={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")};var o=["all","error","warning","success","information"];var A=["asyncDescriptionHandler","asyncURLHandler"];var D={asyncDescriptionHandler:function(i){var s=i.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(p){i.item.setDescription(p);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);i.promise.reject(E);}});}}};k.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};k.prototype.init=function(){var t=this;this._bHasHeaderButton=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};k.prototype.onBeforeRendering=function(){var i,p=this.getItems();this._clearLists();this._detailsPage.setShowHeader(this.getShowDetailsPageHeader());if(this.getGroupItems()){i=this._groupItems(p);this._fillGroupedLists(i);}else{this._fillLists(p);}var r=this.getHeaderButton();if(r){this._bHasHeaderButton=true;this._oListHeader.insertContent(r,2);}this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList(this._getCurrentMessageTypeFilter()||"all");if(p.length===1&&this._oLists.all.getItems()[0].getType()===j.Navigation){this._fnHandleForwardNavigation(this._oLists.all.getItems()[0],"show");this._navContainer._pageStack[this._navContainer._pageStack.length-1].transition="slide";}this._makeAutomaticBinding();};k.prototype._fillGroupedLists=function(i){var p=Object.keys(i),u=p.indexOf(""),U,r;if(u!==-1){U=i[""];r=Object.keys(U);r.forEach(function(t){var s=U[t];this._fillLists(s);delete i[""];p.splice(u,1);},this);}p.forEach(function(s){this._fillListsWithGroups(s,i[s]);},this);};k.prototype._fillListsWithGroups=function(s,i){var t=Object.keys(i),p=new G({title:s}),r;this._oLists["all"].addAggregation("items",p,true);t.forEach(function(u){this._oLists[u.toLowerCase()].addAggregation("items",p.clone(),true);r=i[u];this._fillLists(r);},this);};k.prototype.exit=function(){if(this._oLists){this._destroyLists();}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy();}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;};k.prototype._makeAutomaticBinding=function(){var i=this.getItems();if(!this.getBindingInfo("items")&&!i.length){this._bindToMessageModel();}};k.prototype._bindToMessageModel=function(){var t=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new M({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:t._oMessageItemTemplate});};k.prototype._groupItems=function(i){var p={},s,r;i.forEach(function(t){s=t.getGroupName();r=t.getType();p[s]=p[s]||{};var u=p[s];if(u[r]){u[r].push(t);}else{u[r]=[t];}});return p;};k.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==q.sap.KeyCodes.ENTER){this.navigateBack();}};k.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};k.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};k.prototype._createListHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDescr";var p=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var r=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var t=this.getId()+"-HeadingDescr";var u=new H(t,{content:"<span id=\""+t+"\" style=\"display: none;\" role=\"heading\">"+r+"</span>"});this._oSegmentedButton=new e(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new c(),p,u]});return this._oListHeader;};k.prototype._createDetailsHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDetDescr";var p=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var r=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var t=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var u=this.getId()+"-BackBtnDetDescr";var v=new H(u,{content:"<span id=\""+u+"\" style=\"display: none;\">"+t+"</span>"});this._oBackButton=new B({icon:n["back"],press:this.navigateBack.bind(this),ariaLabelledBy:v,tooltip:r}).addStyleClass(m+"BackBtn");this._oDetailsHeader=new T({content:[this._oBackButton,new c(),p,v]});return this._oDetailsHeader;};k.prototype._createNavigationPages=function(){this._listPage=new P(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new P(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgPopoverItemDisabledLink")!==-1||t.className.indexOf("sapMMsgPopoverItemPendingLink")!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage]});this.setAggregation("_navContainer",this._navContainer);return this;};k.prototype._createLists=function(){this._oLists={};o.forEach(function(s){this._oLists[s]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[s],true);},this);return this;};k.prototype._clearLists=function(){o.forEach(function(s){if(this._oLists[s]){this._oLists[s].destroyAggregation("items",true);}},this);return this;};k.prototype._destroyLists=function(){o.forEach(function(s){this._oLists[s]=null;},this);this._oLists=null;};k.prototype._fillLists=function(i){i.forEach(function(p){var r=this._mapItemToListItem(p),s=this._mapItemToListItem(p);this._oLists["all"].addAggregation("items",r,true);this._oLists[p.getType().toLowerCase()].addAggregation("items",s,true);},this);};k.prototype._mapItemToListItem=function(i){if(!i){return null;}var t=i.getType(),p=this._getItemType(i),r=new S({title:i.getTitle(),description:i.getSubtitle(),counter:i.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"\r",type:p}).addStyleClass(m+"Item").addStyleClass(m+"Item"+t);if(p!==j.Navigation){r.addEventDelegate({onAfterRendering:function(){var s=this.getDomRef().querySelector(".sapMSLITitleDiv > div");if(s.offsetWidth<s.scrollWidth){this.setType(j.Navigation);}}},r);}r._oMessageItem=i;return r;};k.prototype._mapInfoState=function(t){if(!t){return null;}switch(t){case h.Warning:return V.Warning;case h.Error:return V.Error;case h.Success:return V.Success;case h.Information:case h.None:return V.None;default:q.sap.log.warning("The provided MessageType is not mapped to a specific ValueState",t);return null;}};k.prototype._mapIcon=function(i){if(!i){return null;}return n[i.toLowerCase()];};k.prototype._getItemType=function(i){return(i.getDescription()||i.getMarkupDescription()||i.getLongtextUrl())?j.Navigation:j.Inactive;};k.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};k.prototype._fillSegmentedButton=function(){var t=this;var p=function(r){return function(){t._fnFilterList(r);};};o.forEach(function(r){var u=this._oLists[r],v=r=="all"?"MESSAGEPOPOVER_ALL":"MESSAGEVIEW_BUTTON_TOOLTIP_"+r.toUpperCase(),w=u.getItems().filter(function(y){return(y instanceof S);}).length,x;if(w>0){x=new B(this.getId()+"-"+r,{text:r=="all"?this._oResourceBundle.getText(v):w,tooltip:this._oResourceBundle.getText(v),icon:n[r],press:p(r)}).addStyleClass(m+"Btn"+r.charAt(0).toUpperCase()+r.slice(1));this._oSegmentedButton.addButton(x,true);}},this);var s=this._oSegmentedButton.getButtons().length>2;this._oSegmentedButton.setVisible(s);if(!s){this._oSegmentedButton.setSelectedButton(this._oSegmentedButton.getButtons()[0]);this._fnFilterList('all');}var i=s||this._bHasHeaderButton;this._listPage.setShowHeader(i);return this;};k.prototype._setIcon=function(i,p){this._previousIconTypeClass=m+"DescIcon"+i.getType();this._oMessageIcon=new b({src:p.getIcon()}).addStyleClass(m+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};k.prototype._setTitle=function(i){this._oMessageTitleText=new d(this.getId()+"MessageTitleText",{text:i.getTitle()}).addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",this._oMessageTitleText);};k.prototype._setDescription=function(i){var p=i.getLink();this._oLastSelectedItem=i;if(i.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+i.getDescription()+"</div>"});}else{this._oMessageDescriptionText=new d(this.getId()+"MessageDescriptionText",{text:i.getDescription()}).addStyleClass("sapMMsgViewDescriptionText");}this._detailsPage.addContent(this._oMessageDescriptionText);if(p){var r=this._createLinkCopy(p);this._detailsPage.addContent(r);r.addStyleClass("sapMMsgViewDescriptionLink");}};k.prototype._createLinkCopy=function(i){var p,r=i.clone("","",{cloneChildren:false,cloneBindings:false}),s=i.getCustomData()||[];p=Object.keys(i.getMetadata().getProperties());p.forEach(function(t){r.setProperty(t,i.getProperty(t));});r.destroyCustomData();s.forEach(function(t){var u=new a({key:t.getKey(),value:t.getValue()});r.addCustomData(u);});return r;};k.prototype._iNextValidationTaskId=0;k.prototype._validateURL=function(u){if(q.sap.validateUrl(u)){return u;}q.sap.log.warning("You have entered invalid URL");return"";};k.prototype._queueValidation=function(i){var p=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var r={};var s=new window.Promise(function(t,u){r.resolve=t;r.reject=u;var w={url:i,id:v,promise:r};p(w);});s.id=v;return s;};k.prototype._getTagPolicy=function(){var t=this,i;var p=html.makeTagPolicy(this._validateURL());return function customTagPolicy(r,s){var u,v=false;if(r.toUpperCase()==="A"){for(i=0;i<s.length;){if(s[i]==="href"){v=true;u=s[i+1];s.splice(0,2);continue;}i+=2;}}s=p(r,s);if(v&&typeof t.getAsyncURLHandler()==="function"){s=s||[];var w="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink";var x=s.indexOf("class");if(x>-1){s[x+1]+=w;}else{s.unshift(w);s.unshift("class");}var y=s.indexOf("id");if(y>-1){s.splice(y+1,1);s.splice(y,1);}var z=t._queueValidation(u);s.push("href");s.push(u);s.push("target");s.push("_blank");s.push("id");s.push("sap-ui-"+t.getId()+"-link-under-validation-"+z.id);z.then(function(E){var $=q.sap.byId("sap-ui-"+t.getId()+"-link-under-validation-"+E.id);if(E.allowed){q.sap.log.info("Allow link "+u);}else{q.sap.log.info("Disallow link "+u);}$.removeClass("sapMMsgViewItemPendingLink");$.toggleClass("sapMMsgViewItemDisabledLink",!E.allowed);t.fireUrlValidated();}).catch(function(){q.sap.log.warning("Async URL validation could not be performed.");});}return s;};};k.prototype._sanitizeDescription=function(i){q.sap.require("jquery.sap.encoder");q.sap.require("sap.ui.thirdparty.caja-html-sanitizer");var s=i.getDescription();if(i.getMarkupDescription()){var t=this._getTagPolicy();s=html.sanitizeWithPolicy(s,t);}i.setDescription(s);this._setDescription(i);};k.prototype._fnHandleForwardNavigation=function(i,t){var p=i._oMessageItem,r=this._detailsPage.getContent()||[],s=this.getAsyncDescriptionHandler();this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:p,messageTypeFilter:this._getCurrentMessageTypeFilter()});this._clearDetailsPage.call(this,r);if(typeof s==="function"&&!!p.getLongtextUrl()){p.setMarkupDescription(true);var u={};var v=new window.Promise(function(x,y){u.resolve=x;u.reject=y;});var w=function(){this._detailsPage.setBusy(false);this._navigateToDetails.call(this,p,i,t,true);}.bind(this);v.then(w).catch(function(){q.sap.log.warning("Async description loading could not be performed.");w();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);s({promise:u,item:p});}else{this._navigateToDetails.call(this,p,i,t,false);}this._listPage.$().attr("aria-hidden","true");};k.prototype._fnHandleItemPress=function(E){this._fnHandleForwardNavigation(E.getParameter("listItem"),"slide");};k.prototype._navigateToDetails=function(i,p,t,s){this._setTitle(i);this._sanitizeDescription(i);this._setIcon(i,p);this._detailsPage.rerender();this.fireLongtextLoaded();if(!s){this._navContainer.to(this._detailsPage,t);}};k.prototype._clearDetailsPage=function(i){i.forEach(function(p){p.destroy();},this);};k.prototype.navigateBack=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};k.prototype._fnFilterList=function(s){o.forEach(function(i){if(i!=s&&this._oLists[i].getVisible()){this._oLists[i].setVisible(false);}},this);this._sCurrentList=s;this._oLists[s].setVisible(true);this._listPage.rerender();this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};k.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};k.prototype._isListPage=function(){return this._navContainer.getCurrentPage()==this._listPage;};return k;});
