/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/Item'],function(q,l,C,I,a){"use strict";var t=l.touch;var S=l.SelectListKeyboardNavigationMode;var b=C.extend("sap.m.SelectList",{metadata:{library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},keyboardNavigationMode:{type:"sap.m.SelectListKeyboardNavigationMode",group:"Behavior",defaultValue:S.Delimited}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}},itemPress:{parameters:{item:{type:"sap.ui.core.Item"}}}}}});b.prototype._setSelectedIndex=function(i,_){var o;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);o=_[i];if(o){this.setSelection(o);}};b.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;this.synchronizeSelection({forceSelection:false});setTimeout(this.synchronizeSelection.bind(this),0);};b.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};b.prototype._activateItem=function(i){if(i instanceof a&&i&&i.getEnabled()){this.fireItemPress({item:i});if(this.getSelectedItem()!==i){this.setSelection(i);this.fireSelectionChange({selectedItem:i});}}};b.prototype._queryEnabledItemsDomRefs=function(d){var c="."+this.getRenderer().CSS_CLASS+"ItemBase";d=d||this.getDomRef();return d?Array.prototype.slice.call(d.querySelectorAll(c+":not("+c+"Disabled)")):[];};b.prototype._handleARIAActivedescendant=function(){var A=q(document.activeElement).control(0),d=this.getDomRef();if(A&&d){d.setAttribute("aria-activedescendant",A.getId());}};b.prototype.init=function(){this._iStartTimeout=0;this._iActiveTouchId=0;this._fStartX=0;this._fStartY=0;this._oItemNavigation=null;this._$ItemPressed=null;};b.prototype.onBeforeRendering=function(){this.synchronizeSelection();};b.prototype.onAfterRendering=function(){if(this.getKeyboardNavigationMode()===S.None){this.destroyItemNavigation();}else{this.createItemNavigation();}};b.prototype.exit=function(){this.destroyItemNavigation();this._$ItemPressed=null;};b.prototype.ontouchstart=function(e){if(t.countContained(e.touches,this.getId())>1||!this.getEnabled()){return;}e.setMarked();var T=e.targetTouches[0];this._iActiveTouchId=T.identifier;this._fStartX=T.pageX;this._fStartY=T.pageY;this._iStartTimeout=setTimeout(function(){var i=e.srcControl.$();if(i){i.addClass(this.getRenderer().CSS_CLASS+"ItemBasePressed");this._$ItemPressed=i;}}.bind(this),100);};b.prototype.ontouchmove=function(e){var T=null;if(!this.getEnabled()){return;}T=t.find(e.changedTouches,this._iActiveTouchId);if(T&&((Math.abs(T.pageX-this._fStartX)>10)||(Math.abs(T.pageY-this._fStartY)>10))){clearTimeout(this._iStartTimeout);if(this._$ItemPressed){this._$ItemPressed.removeClass(this.getRenderer().CSS_CLASS+"ItemBasePressed");this._$ItemPressed=null;}}};b.prototype.ontouchend=function(e){var T=null;if(!this.getEnabled()){return;}e.setMarked();T=t.find(e.changedTouches,this._iActiveTouchId);if(T){setTimeout(function(){if(this._$ItemPressed){this._$ItemPressed.removeClass(this.getRenderer().CSS_CLASS+"ItemBasePressed");this._$ItemPressed=null;}this._iStartTimeout=null;}.bind(this),100);}};b.prototype.ontouchcancel=b.prototype.ontouchend;b.prototype.ontap=function(e){if(this.getEnabled()){e.setMarked();this._activateItem(e.srcControl);}};b.prototype.onsapselect=function(e){if(this.getEnabled()){e.setMarked();e.preventDefault();this._activateItem(e.srcControl);}};b.prototype.onAfterFocus=function(c){this._handleARIAActivedescendant();};b.prototype.findFirstEnabledItem=function(c){c=c||this.getItems();for(var i=0;i<c.length;i++){if(c[i].getEnabled()){return c[i];}}return null;};b.prototype.setSelection=function(i){var s=this.getSelectedItem(),c=this.getRenderer().CSS_CLASS;this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof a)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setProperty("selectedKey",i?i.getKey():"",true);if(s){s.$().removeClass(c+"ItemBaseSelected").attr("aria-selected","false");}s=this.getSelectedItem();if(s){s.$().addClass(c+"ItemBaseSelected").attr("aria-selected","true");}};b.prototype.synchronizeSelection=function(o){if(this.isSelectionSynchronized()){return;}var f=true;if(o){f=!!o.forceSelection;}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);}else if(f&&this.getDefaultSelectedItem()&&(!this.isBound("items")||this.bItemsUpdated)){this.setSelection(this.getDefaultSelectedItem());}};b.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};b.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};b.prototype.getVisibleItems=function(){for(var i=0,o,c=this.getItems(),v=[];i<c.length;i++){o=c[i];if(o.bVisible||(o.bVisible===undefined)){v.push(o);}}return v;};b.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};b.prototype.findItem=function(p,v){var m="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,c=this.getItems();i<c.length;i++){if(c[i][m]()===v){return c[i];}}return null;};b.prototype.getItemByText=function(T){return this.findItem("text",T);};b.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};b.prototype.getDefaultSelectedItem=function(i){return null;};b.prototype.clearSelection=function(){this.setSelection(null);};b.prototype.createItemNavigation=function(){var d;if(!this._oItemNavigation){this._oItemNavigation=new I(null,null,!this.getEnabled());this._oItemNavigation.attachEvent(I.Events.AfterFocus,this.onAfterFocus,this);this.addEventDelegate(this._oItemNavigation);}d=this.getDomRef();this._oItemNavigation.setRootDomRef(d);this._oItemNavigation.setItemDomRefs(this._queryEnabledItemsDomRefs(d));this._oItemNavigation.setCycling(false);this._oItemNavigation.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));this._oItemNavigation.setPageSize(10);};b.prototype.destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};b.prototype.getItemNavigation=function(){return this._oItemNavigation;};b.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=sap.ui.getCore().byId(i);}if(!(i instanceof a)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);return this;};b.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);this.setSelection(i);return this;};b.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var i=this.getItemByKey(k);if(i||(k==="")){if(!i&&k===""){i=this.getDefaultSelectedItem();}this.setSelection(i);return this;}return this.setProperty("selectedKey",k);};b.prototype.getSelectedItem=function(){var s=this.getAssociation("selectedItem");return(s===null)?null:sap.ui.getCore().byId(s)||null;};b.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};b.prototype.getFirstItem=function(){return this.getItems()[0]||null;};b.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};b.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};b.prototype.getItemByKey=function(k){return this.findItem("key",k);};b.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){this.setSelection(this.getDefaultSelectedItem());}return i;};b.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items",true);this.$().children("li").remove();return i;};b.prototype.destroyItems=function(){this.destroyAggregation("items",true);return this;};b.prototype.setNoDataText=q.noop;return b;});
