/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/m/semantic/SemanticPage','sap/ui/core/InvisibleText','sap/ui/Device','sap/ui/base/ManagedObject','sap/m/NavContainer','sap/m/Popover'],function(q,l,C,I,S,a,D,M,N,P){"use strict";var B=l.ButtonType;var b=l.PlacementType;var c=l.SplitAppMode;var d=C.extend("sap.m.SplitContainer",{metadata:{library:"sap.m",properties:{defaultTransitionNameDetail:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMaster:{type:"string",group:"Appearance",defaultValue:"slide"},mode:{type:"sap.m.SplitAppMode",group:"Appearance",defaultValue:c.ShowHideMode},masterButtonText:{type:"string",group:"Appearance",defaultValue:null},masterButtonTooltip:{type:"string",group:"Appearance",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1}},aggregations:{masterPages:{type:"sap.ui.core.Control",multiple:true,singularName:"masterPage"},detailPages:{type:"sap.ui.core.Control",multiple:true,singularName:"detailPage"},_navMaster:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_navDetail:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_navPopover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},associations:{initialDetail:{type:"sap.ui.core.Control",multiple:false},initialMaster:{type:"sap.ui.core.Control",multiple:false}},events:{masterNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMasterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},masterButton:{},beforeMasterOpen:{},afterMasterOpen:{},beforeMasterClose:{},afterMasterClose:{},detailNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterDetailNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}},designTime:true}});d.prototype.init=function(){var t=this;this._isMie9=false;if(D.browser.internet_explorer&&D.browser.version<10){this._isMie9=true;}if(sap.ui.getCore().getConfiguration().getAccessibility()&&!d._sAriaPopupLabelId){d._sAriaPopupLabelId=new a({text:''}).toStatic().getId();}this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aMasterPages=[];this._aDetailPages=[];if(!D.system.phone){this._oMasterNav=new N(this.getId()+"-Master",{width:"",navigate:function(e){t._handleNavigationEvent(e,false,true);},afterNavigate:function(e){t._handleNavigationEvent(e,true,true);t._updateMasterButtonTooltip();}});this._oDetailNav=new N(this.getId()+"-Detail",{width:"",navigate:function(e){t._handleNavigationEvent(e,false,false);},afterNavigate:function(e){t._handleNavigationEvent(e,true,false);}});this.setAggregation("_navMaster",this._oMasterNav,true);this.setAggregation("_navDetail",this._oDetailNav,true);this._createShowMasterButton();this._oPopOver=new P(this.getId()+"-Popover",{placement:b.Bottom,showHeader:false,contentWidth:"320px",contentHeight:"600px",beforeOpen:function(){t.fireBeforeMasterOpen();},beforeClose:function(){t.fireBeforeMasterClose();},afterOpen:function(){t.fireAfterMasterOpen();t._bMasterisOpen=true;},afterClose:function(){t._afterHideMasterAnimation();}}).addStyleClass("sapMSplitContainerPopover");if(d._sAriaPopupLabelId){this._oPopOver.addAriaLabelledBy(d._sAriaPopupLabelId);}this.setAggregation("_navPopover",this._oPopOver,true);}else{this._oMasterNav=this._oDetailNav=new N({width:"",navigate:function(e){t._handleNavigationEvent(e,false,true);},afterNavigate:function(e){t._handleNavigationEvent(e,true,true);}});this.setAggregation("_navMaster",this._oMasterNav,true);}this._oldIsLandscape=D.orientation.landscape;this._bMasterisOpen=false;var t=this;var p=function(r,n,s){return function(o,A,e){r.apply(t[n],arguments);if(A==="pages"&&q.inArray(o,t[s])!==-1){t._removePageFromArray(t[s],o);}};};var m=this._oMasterNav._removeChild;this._oMasterNav._removeChild=p(m,"_oMasterNav","_aMasterPages");if(this._oDetailNav){var f=this._oDetailNav._removeChild;this._oDetailNav._removeChild=p(f,"_oDetailNav","_aDetailPages");}};d.prototype.onBeforeRendering=function(){if(this._fnResize){D.resize.detachHandler(this._fnResize);}if(this._bMasterisOpen&&(this._portraitHide()||this._hideMode())){this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");this._bMasterisOpen=false;}this._updateMasterButtonTooltip();};d.prototype.exit=function(){if(this._fnResize){D.resize.detachHandler(this._fnResize);}delete this._aMasterPages;delete this._aDetailPages;if(this._oShowMasterBtn){this._oShowMasterBtn.destroy();this._oShowMasterBtn=null;}};d.prototype.onAfterRendering=function(){if(!D.system.phone&&this._oPopOver&&this._oPopOver.isOpen()){this._oPopOver.close();}if(!this._fnResize){this._fnResize=q.proxy(this._handleResize,this);}D.resize.attachHandler(this._fnResize);if(D.os.windows&&D.browser.internet_explorer){this._oMasterNav.$().append('<iframe class="sapMSplitContainerMasterBlindLayer" src="about:blank"></iframe>');}q.sap.delayedCall(0,this,function(){this._oMasterNav.removeStyleClass("sapMSplitContainerNoTransition");});};d.prototype.applySettings=function(s,o){C.prototype.applySettings.call(this,s,o);this._updateMasterInitialPage();};d.prototype.ontouchstart=function(e){if(!D.system.phone){this._bIgnoreSwipe=(e.originalEvent&&e.originalEvent._sapui_handledByControl);}};d.prototype.onswiperight=function(e){if(D.support.touch===false){return;}if((D.system.tablet||(D.os.windows&&D.os.version>=8))&&(this._portraitHide()||this._hideMode())&&!this._bIgnoreSwipe&&!this._bDetailNavButton){this.showMaster();}};d.prototype.ontap=function(e){if(D.system.phone){return;}var i=true,$=q(e.target).closest(".sapMSplitContainerDetail, .sapMSplitContainerMaster"),m=e.srcControl.getMetadata();if($.length>0&&$.hasClass("sapMSplitContainerDetail")){i=false;}if(((!this._oldIsLandscape&&this.getMode()=="ShowHideMode")||this.getMode()=="HideMode")&&!i&&!q.sap.containsOrEquals(this._oShowMasterBtn.getDomRef(),e.target)&&(!m.getEvent("tap")||!m.getEvent("press"))){this.hideMaster();}};d.prototype.onswipeleft=function(e){if((D.system.tablet||(D.os.windows&&D.os.version>=8))&&(this._portraitHide()||this._hideMode())&&!this._bIgnoreSwipe){this.hideMaster();}};d.prototype._onMasterButtonTap=function(e){if(D.system.phone){return;}if(!this._oldIsLandscape){if(this.getMode()=="PopoverMode"){if(!this._oPopOver.isOpen()){this._oPopOver.openBy(this._oShowMasterBtn,true);}else{this._oPopOver.close();}}else{this.showMaster();}}else{if(this.getMode()==="HideMode"){this.showMaster();}}};d.prototype.to=function(p,t,e,T){if(this._oMasterNav.getPage(p)){this._oMasterNav.to(p,t,e,T);}else{this._oDetailNav.to(p,t,e,T);}};d.prototype.backToPage=function(p,e,t){if(this._oMasterNav.getPage(p)){this._oMasterNav.backToPage(p,e,t);}else{this._oDetailNav.backToPage(p,e,t);}};d.prototype.insertPreviousPage=function(p,t,e){if(this._oMasterNav.getPage(p)){this._oMasterNav.insertPreviousPage(p,t,e);}else{this._oDetailNav.insertPreviousPage(p,t,e);}return this;};d.prototype.toMaster=function(p,t,e,T){this._oMasterNav.to(p,t,e,T);};d.prototype.backMaster=function(e,t){this._oMasterNav.back(e,t);};d.prototype.backMasterToPage=function(p,e,t){this._oMasterNav.backToPage(p,e,t);};d.prototype.toDetail=function(p,t,e,T){this._oDetailNav.to(p,t,e,T);};d.prototype.backDetail=function(e,t){this._oDetailNav.back(e,t);};d.prototype.backDetailToPage=function(p,e,t){this._oDetailNav.backToPage(p,e,t);};d.prototype.backToTopMaster=function(e,t){this._oMasterNav.backToTop(e,t);};d.prototype.backToTopDetail=function(e,t){this._oDetailNav.backToTop(e,t);};d.prototype.addMasterPage=function(p){if(this._hasPageInArray(this._aMasterPages,p)){return;}if(this._oMasterNav===this._oDetailNav&&q.inArray(p,this._oDetailNav.getPages())!==-1){this._removePageFromArray(this._aDetailPages,p);}this._oMasterNav.insertPage(p,this._aMasterPages.length);this._aMasterPages.push(p);return this;};d.prototype.addDetailPage=function(p){var t=this,r=this._getRealPage(p);if(this._hasPageInArray(this._aDetailPages,p)){return;}p.addDelegate({onBeforeShow:function(){if(r){if(!D.system.phone){if(t._needShowMasterButton()){t._setMasterButton(r);}}}}});if(r){r.addDelegate({onBeforeRendering:function(){if(!D.system.phone&&(t._oDetailNav.getCurrentPage()===r)){if(!r.getShowNavButton()&&t._needShowMasterButton()){t._setMasterButton(r,true);}else{t._removeMasterButton(r);}}}});if(!D.system.phone){if(!r._setCustomHeaderInSC){r._setCustomHeaderInSC=r.setCustomHeader;}r.setCustomHeader=function(h){this._setCustomHeaderInSC.apply(this,arguments);if(h&&t._needShowMasterButton()){t._setMasterButton(r);}return this;};if(!r._setShowNavButtonInSC){r._setShowNavButtonInSC=r.setShowNavButton;}r.setShowNavButton=function(s){this._setShowNavButtonInSC.apply(this,arguments);if(!s&&t._needShowMasterButton()){t._setMasterButton(r);}else{t._removeMasterButton(r,true);}return this;};}}if(this._oMasterNav===this._oDetailNav&&q.inArray(p,this._oMasterNav.getPages())!==-1){this._removePageFromArray(this._aMasterPages,p);}this._oDetailNav.addPage(p);this._aDetailPages.push(p);return this;};d.prototype.getMasterPages=function(){return this._aMasterPages;};d.prototype.getDetailPages=function(){return this._aDetailPages;};d.prototype.indexOfMasterPage=function(p){return this._indexOfMasterPage(p);};d.prototype.indexOfDetailPage=function(p){return this._indexOfDetailPage(p);};d.prototype.insertMasterPage=function(p,i,s){return this._insertPage(this._aMasterPages,"masterPages",p,i,s);};d.prototype.removeMasterPage=function(p,s){return this._removePage(this._aMasterPages,"masterPages",p,s);};d.prototype.removeAllMasterPages=function(s){this._aMasterPages=[];return this.removeAllAggregation("masterPages",s);};d.prototype.insertDetailPage=function(p,i,s){return this._insertPage(this._aDetailPages,"detailPages",p,i,s);};d.prototype._restoreMethodsInPage=function(p){if(D.system.phone){return;}var r=this._getRealPage(p);if(r){if(r._setCustomHeaderInSC){r.setCustomHeader=r._setCustomHeaderInSC;delete r._setCustomHeaderInSC;}if(r._setShowNavButtonInSC){r.setShowNavButton=r._setShowNavButtonInSC;delete r._setShowNavButtonInSC;}}};d.prototype.removeDetailPage=function(p,s){this._restoreMethodsInPage(p);return this._removePage(this._aDetailPages,"detailPages",p,s);};d.prototype.removeAllDetailPages=function(s){var p=this.getDetailPages();for(var i=0;i<p.length;i++){this._restoreMethodsInPage(p[i]);}this._aDetailPages=[];return this.removeAllAggregation("detailPages",s);};d.prototype.addPage=function(p,m){if(m){return this.addMasterPage(p);}else{return this.addDetailPage(p);}};d.prototype.showMaster=function(){var _=this._oMasterNav.$(),t=this,A=q.proxy(this._afterShowMasterAnimation,this),e=this._getRealPage(this._oDetailNav.getCurrentPage());function f(){this._oPopOver.detachAfterOpen(f,this);this._bMasterOpening=false;this._bMasterisOpen=true;this.fireAfterMasterOpen();}if(this._portraitPopover()){if(!this._oPopOver.isOpen()){this._oPopOver.attachAfterOpen(f,this);this.fireBeforeMasterOpen();this._oPopOver.openBy(this._oShowMasterBtn,true);this._bMasterOpening=true;}}else{if((this._portraitHide()||this._hideMode())&&(!this._bMasterisOpen||this._bMasterClosing)){if(this._isMie9){this._oMasterNav.$().css("width","320px");_.animate({left:"+=320"},{duration:300,complete:A});this._bMasterisOpen=true;t._bMasterOpening=false;this._removeMasterButton(e);}else{_.bind("webkitTransitionEnd transitionend",A);}this.fireBeforeMasterOpen();this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",true);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",false);this._bMasterOpening=true;t._removeMasterButton(e);if(D.browser.webkit){var m=this._oMasterNav;window.setTimeout(function(){m.$().css("box-shadow","none");window.setTimeout(function(){m.$().css("box-shadow","");},50);},0);}}}return this;};d.prototype.hideMaster=function(){var _=this._oMasterNav.$(),A=q.proxy(this._afterHideMasterAnimation,this);if(this._portraitPopover()){if(this._oPopOver.isOpen()){this._oPopOver.close();this._bMasterClosing=true;}}else{if((this._portraitHide()||this._hideMode())&&(this._bMasterisOpen||this._oMasterNav.$().hasClass("sapMSplitContainerMasterVisible"))){if(this._isMie9){_.animate({left:"-=320"},{duration:300,complete:A});}else{_.bind("webkitTransitionEnd transitionend",A);}this.fireBeforeMasterClose();this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",false);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",true);this._bMasterClosing=true;}}return this;};d.prototype._afterShowMasterAnimation=function(){if(this._portraitHide()||this._hideMode()){if(!this._isMie9){var m=this._oMasterNav.$();m.unbind("webkitTransitionEnd transitionend",this._afterShowMasterAnimation);}this._bMasterOpening=false;this._bMasterisOpen=true;this.fireAfterMasterOpen();}};d.prototype._afterHideMasterAnimation=function(){if(this._portraitHide()||this._hideMode()){if(!this._isMie9){var m=this._oMasterNav.$();m.unbind("webkitTransitionEnd transitionend",this._afterHideMasterAnimation);}}var o=this._getRealPage(this._oDetailNav.getCurrentPage());this._setMasterButton(o);this._bMasterClosing=false;this._bMasterisOpen=false;if(q.sap.containsOrEquals(this._oMasterNav.getDomRef(),document.activeElement)){document.activeElement.blur();}this.fireAfterMasterClose();};d.prototype.getCurrentMasterPage=function(){return this._oMasterNav.getCurrentPage();};d.prototype.getCurrentDetailPage=function(){return this._oDetailNav.getCurrentPage();};d.prototype.getCurrentPage=function(m){if(m){return this.getCurrentMasterPage();}else{return this.getCurrentDetailPage();}};d.prototype.getPreviousPage=function(m){if(m){return this._oMasterNav.getPreviousPage();}else{return this._oDetailNav.getPreviousPage();}};d.prototype.getMasterPage=function(p){return this._oMasterNav.getPage(p);};d.prototype.getDetailPage=function(p){return this._oDetailNav.getPage(p);};d.prototype.getPage=function(p,m){if(m){return this.getMasterPage(p);}else{return this.getDetailPage(p);}};d.prototype.isMasterShown=function(){if(D.system.phone){var o=this._oMasterNav.getCurrentPage();return this._indexOfMasterPage(o)!==-1;}else{var m=this.getMode();switch(m){case c.StretchCompressMode:return true;case c.HideMode:return this._bMasterisOpen;case c.PopoverMode:case c.ShowHideMode:return D.orientation.landscape||this._bMasterisOpen;default:return false;}}};d.prototype.setInitialMaster=function(p){this._oMasterNav.setInitialPage(p);this.setAssociation('initialMaster',p,true);return this;};d.prototype.setInitialDetail=function(p){if(!D.system.phone){this._oDetailNav.setInitialPage(p);}this.setAssociation('initialDetail',p,true);return this;};d.prototype.setDefaultTransitionNameDetail=function(t){this.setProperty("defaultTransitionNameDetail",t,true);this._oDetailNav.setDefaultTransitionName(t);return this;};d.prototype.setDefaultTransitionNameMaster=function(t){this.setProperty("defaultTransitionNameMaster",t,true);this._oMasterNav.setDefaultTransitionName(t);return this;};d.prototype.setMasterButtonText=function(t){if(!D.system.phone){if(!t){t=this._rb.getText("SplitContainer_NAVBUTTON_TEXT");}this._oShowMasterBtn.setText(t);}this.setProperty("masterButtonText",t,true);return this;};d.prototype.setMode=function(m){var o=this.getMode();if(o===m){return this;}this.setProperty("mode",m,true);if(!D.system.phone&&this.getDomRef()){if(o==="HideMode"&&this._oldIsLandscape){this._removeMasterButton(this._oDetailNav.getCurrentPage());if(this._isMie9){this._oMasterNav.$().css({left:0,width:""});}}if(m!=="PopoverMode"&&this._oPopOver.getContent().length>0){this._updateMasterPosition("landscape");}else if(m=="PopoverMode"){if(!this._oldIsLandscape){if(this._oPopOver.getContent().length===0){this._updateMasterPosition("popover");}this._setMasterButton(this._oDetailNav.getCurrentPage());}this.toggleStyleClass("sapMSplitContainerShowHide",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",false);this.toggleStyleClass("sapMSplitContainerHideMode",false);this.toggleStyleClass("sapMSplitContainerPopover",true);}if(m=="StretchCompressMode"){this.toggleStyleClass("sapMSplitContainerShowHide",false);this.toggleStyleClass("sapMSplitContainerPopover",false);this.toggleStyleClass("sapMSplitContainerHideMode",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",true);this._removeMasterButton(this._oDetailNav.getCurrentPage());}if(m=="ShowHideMode"){this.toggleStyleClass("sapMSplitContainerPopover",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",false);this.toggleStyleClass("sapMSplitContainerHideMode",false);this.toggleStyleClass("sapMSplitContainerShowHide",true);if(!D.orientation.landscape){this._setMasterButton(this._oDetailNav.getCurrentPage());}}if(m==="HideMode"){this.toggleStyleClass("sapMSplitContainerPopover",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",false);this.toggleStyleClass("sapMSplitContainerShowHide",false);this.toggleStyleClass("sapMSplitContainerHideMode",true);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",false);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",true);this._bMasterisOpen=false;this._setMasterButton(this._oDetailNav.getCurrentPage());if(this._isMie9){this._oMasterNav.$().css({left:"",width:"auto"});}}}return this;};d.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){q.sap.log.warning("Invalid value "+o+" for SplitContainer.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};d.prototype._updateMasterInitialPage=function(){if(this.getMode()==="HideMode"&&D.system.phone&&this._aDetailPages){this._oMasterNav.setInitialPage(this.getInitialDetail()?this.getInitialDetail():(this.getInitialMaster()||this._aDetailPages[0]));}};d.prototype._indexOfMasterPage=function(p){return q.inArray(p,this._aMasterPages);};d.prototype._indexOfDetailPage=function(p){return q.inArray(p,this._aDetailPages);};d.prototype._insertPage=function(p,A,o,e,s){this.insertAggregation(A,o,e,s);var i;if(e<0){i=0;}else if(e>p.length){i=p.length;}else{i=e;}var O=q.inArray(o,p);p.splice(i,0,o);if(O!=-1){this._removePageFromArray(p,o);}return this;};d.prototype._removePage=function(p,A,o,s){var r=this.removeAggregation(A,o,s);if(r){this._removePageFromArray(p,r);}return r;};d.prototype._removePageFromArray=function(p,o){var i=q.inArray(o,p);if(i!=-1){p.splice(i,1);if(p===this._aDetailPages){this._restoreMethodsInPage(o);}}};d.prototype._handleNavigationEvent=function(e,A,m){var E=(A?"After":"")+(m?"Master":"Detail")+"Navigate",f;E=E.charAt(0).toLowerCase()+E.slice(1);f=this.fireEvent(E,e.mParameters,true);if(!f){e.preventDefault();}};d.prototype._handleResize=function(){var i=D.orientation.landscape,_=this._oDetailNav.getCurrentPage(),m=this.getMode();if(this._oldIsLandscape!==i){this._oldIsLandscape=i;if(!D.system.phone){this.toggleStyleClass("sapMSplitContainerPortrait",!i);if(m==="HideMode"){return;}if(m==="ShowHideMode"){if(i){this.fireBeforeMasterOpen();}else{this.fireBeforeMasterClose();}}if(this._isMie9){if(i){this._oMasterNav.$().css({left:0,width:""});}else{if(m==="ShowHideMode"||m==="PopoverMode"){this._oMasterNav.$().css({left:-320,width:"auto"});}}}if(m==="ShowHideMode"||m==="PopoverMode"){this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",i);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",!i);}if(m==="ShowHideMode"){if(i){this._bMasterisOpen=true;this.fireAfterMasterOpen();}else{this._bMasterisOpen=false;this.fireAfterMasterClose();}}if(m=="PopoverMode"){if(this._oPopOver.isOpen()){this._oPopOver.attachAfterClose(this._handlePopClose,this);this._oPopOver.close();}else{this._handlePopClose();}}_=this._getRealPage(_);if(!this._oldIsLandscape&&m!="StretchCompressMode"){this._setMasterButton(_);}else{this._removeMasterButton(_);}}if(this._onOrientationChange){this._onOrientationChange();}}};d.prototype._handlePopClose=function(e){this._oPopOver.detachAfterClose(this._handlePopClose,this);if(this._oldIsLandscape){this._updateMasterPosition("landscape");}else{this._updateMasterPosition("popover");}};d.prototype._getRealPage=function(p){var r=p,e;while(r){if(r instanceof sap.m.Page){return r;}if(r instanceof sap.m.MessagePage){return r;}if(r instanceof S){return r;}if(r instanceof sap.ui.core.mvc.View){e=r.getContent();if(e.length===1){r=e[0];continue;}}else if(r instanceof N){r=r.getCurrentPage();continue;}r=null;}return r;};d.prototype._updateMasterPosition=function(p){var t=this;if(p=="popover"){this.removeAggregation("_navMaster",this._oMasterNav,true);this._oMasterNav.$().remove();this._oPopOver.addContent(this._oMasterNav);this._bMasterisOpen=false;}if(p=="landscape"){var r=function(){t._oPopOver.removeAggregation("content",t._oMasterNav,false);t.setAggregation("_navMaster",t._oMasterNav,true);var $=t.$();if($[0]){var e=sap.ui.getCore().createRenderManager();e.renderControl(t._oMasterNav.addStyleClass("sapMSplitContainerMaster"));e.flush($[0],false,(t.$("BG")[0])?1:0);e.destroy();}};if(this._oPopOver.isOpen()){var A=function(){this._oPopOver.detachAfterClose(A,this);this._bMasterisOpen=false;r();};this._oPopOver.attachAfterClose(A,this);this._oPopOver.close();}else{r();}}};d.prototype._portraitHide=function(){if(!this._oldIsLandscape&&!D.system.phone&&this.getMode()==="ShowHideMode"){return true;}else{return false;}};d.prototype._portraitPopover=function(){if(!this._oldIsLandscape&&!D.system.phone&&this.getMode()==="PopoverMode"){return true;}else{return false;}};d.prototype._hideMode=function(){return this.getMode()==="HideMode"&&!D.system.phone;};d.prototype._needShowMasterButton=function(){return(this._portraitHide()||this._hideMode()||this._portraitPopover())&&(!this._bMasterisOpen||this._bMasterClosing);};d.prototype._updateMasterButtonTooltip=function(){if(!this._oShowMasterBtn){return;}var t=this.getMasterButtonTooltip();if(t){this._oShowMasterBtn.setTooltip(t);return;}var p=this._oMasterNav.getCurrentPage();if(p&&p.getTitle){var T=p.getTitle();if(T){T=T.replace(/[_0-9]+$/,'');t=this._rb.getText('SPLITCONTAINER_NAVBUTTON_TOOLTIP',T);}}if(!t){t=this._rb.getText('SPLITCONTAINER_NAVBUTTON_DEFAULT_TOOLTIP');}this._oShowMasterBtn.setTooltip(t);};d.prototype._createShowMasterButton=function(){if(this._oShowMasterBtn&&!this._oShowMasterBtn.bIsDestroyed){return;}this._oShowMasterBtn=new sap.m.Button(this.getId()+"-MasterBtn",{icon:I.getIconURI("menu2"),tooltip:this.getMasterButtonTooltip(),type:B.Default,press:q.proxy(this._onMasterButtonTap,this)}).addStyleClass("sapMSplitContainerMasterBtn");};d.prototype._setMasterButton=function(p,f,s){if(!p){return;}if(typeof f==='boolean'){s=f;f=undefined;}p=this._getRealPage(p);if(!p){return;}var h=d._getHeaderButtonAggregation(p),H=h.sAggregationName,e=h.aAggregationContent;for(var i=0;i<e.length;i++){if(e[i]instanceof sap.m.Button&&e[i].getVisible()&&(e[i].getType()==B.Back||(e[i].getType()==B.Up&&e[i]!==this._oShowMasterBtn))){this._bDetailNavButton=true;return;}}this._bDetailNavButton=false;var o=p._getAnyHeader();var g=false;for(var i=0;i<e.length;i++){if(e[i]===this._oShowMasterBtn){g=true;}}if(!g){this._createShowMasterButton();this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");if(o){o.insertAggregation(H,this._oShowMasterBtn,0,s);}}else{if(this._isMie9){this._oShowMasterBtn.$().fadeIn();}this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnHide",false);this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnShow",true);}if(f){f(p);}this.fireMasterButton({show:true});};d._getHeaderButtonAggregation=function(p){var h=p._getAnyHeader(),A,s;if(!h){return;}if(h.getContentLeft){A=h.getContentLeft();s="contentLeft";}if(h.getContent){A=h.getContent();s="content";}return{aAggregationContent:A,sAggregationName:s};};d.prototype._removeMasterButton=function(p,f,n){if(!p){return;}var t=this,h=this._oShowMasterBtn.$().is(":hidden"),H;if(typeof f==="boolean"){n=f;f=undefined;}if(!h&&!n){p=this._getRealPage(p);if(!p){return;}H=p._getAnyHeader();if(H){var e=d._getHeaderButtonAggregation(p).aAggregationContent;for(var i=0;i<e.length;i++){if(e[i]===this._oShowMasterBtn){if(this._isMie9){this._oShowMasterBtn.$().fadeOut();if(f){f(p);}}this._oShowMasterBtn.destroy();this._oShowMasterBtn.$().parent().bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._oShowMasterBtn.addStyleClass("sapMSplitContainerMasterBtnHidden");if(f){f(p);}});return;}}}this.fireMasterButton({show:false});}else{this._oShowMasterBtn.addStyleClass("sapMSplitContainerMasterBtnHidden");if(f){f(p);}if(!h){this.fireMasterButton({show:false});}}};d.prototype._callMethodInManagedObject=function(f,A){var e=Array.prototype.slice.call(arguments);if(A==="masterPages"){if(f==="indexOfAggregation"){return this._indexOfMasterPage.apply(this,e.slice(2));}else{return this._callNavContainerMethod(f,this._oMasterNav,e);}}else if(A==="detailPages"){if(f==="indexOfAggregation"){return this._indexOfDetailPage.apply(this,e.slice(2));}else{return this._callNavContainerMethod(f,this._oDetailNav,e);}}else{return M.prototype[f].apply(this,e.slice(1));}};d.prototype._callNavContainerMethod=function(f,n,A){A[1]="pages";A=A.slice(1);var r=d._mFunctionMapping[f];if(r){A.shift();f=r;}return n[f].apply(n,A);};d.prototype._hasPageInArray=function(e,p){return e.some(function(A){return p&&(p===A);});};d.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};d.prototype.setAggregation=function(A,o,s){this._callMethodInManagedObject("setAggregation",A,o,s);return this;};d.prototype.getAggregation=function(A,o){return this._callMethodInManagedObject("getAggregation",A,o);};d.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};d.prototype.insertAggregation=function(A,o,i,s){this._callMethodInManagedObject("insertAggregation",A,o,i,s);return this;};d.prototype.addAggregation=function(A,o,s){this._callMethodInManagedObject("addAggregation",A,o,s);return this;};d.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};d.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};d.prototype.destroyAggregation=function(A,s){this._callMethodInManagedObject("destroyAggregation",A,s);return this;};d._mFunctionMapping={"getAggregation":"getPage","addAggregation":"addPage","insertAggregation":"insertPage","removeAggregation":"removePage","removeAllAggregation":"removeAllPages"};return d;});
