/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','./Manifest','./ComponentMetadata','./Core','sap/ui/thirdparty/URI','jquery.sap.trace'],function(q,M,a,C,b,U){"use strict";function c(u){['sap-client','sap-server'].forEach(function(n){if(!u.hasSearch(n)){var v=sap.ui.getCore().getConfiguration().getSAPParam(n);if(v){u.addSearch(n,v);}}});}function d(D,m,s,S){if(s){for(var n in D){if(!m[n]&&s[n]&&s[n].uri){m[n]=S;}}}}function g(m,o,K,e){var D=o.getEntry(K);if(D!==undefined&&!q.isPlainObject(D)){return D;}var p,P;if(e&&(p=m.getParent())instanceof C){P=p.getManifestEntry(K,e);}if(P||D){D=q.extend(true,{},P,D);}return D;}function f(o,e){var i=Object.create(Object.getPrototypeOf(o));i._oMetadata=o;i._oManifest=e;for(var m in o){if(!/^(getManifest|getManifestObject|getManifestEntry|getMetadataVersion)$/.test(m)&&typeof o[m]==="function"){i[m]=o[m].bind(o);}}i.getManifest=function(){return e&&e.getJson();};i.getManifestObject=function(){return e;};i.getManifestEntry=function(K,n){return g(o,e,K,n);};i.getMetadataVersion=function(){return 2;};return i;}function r(e,o,t){var i=M._sOwnerId;try{M._sOwnerId=o;return e.call(t);}finally{M._sOwnerId=i;}}var h=M.extend("sap.ui.core.Component",{constructor:function(i,s){var e=Array.prototype.slice.call(arguments);if(typeof i!=="string"){s=i;i=undefined;}if(s&&typeof s._metadataProxy==="object"){this._oMetadataProxy=s._metadataProxy;this._oManifest=s._metadataProxy._oManifest;delete s._metadataProxy;this.getMetadata=function(){return this._oMetadataProxy;};}if(s&&typeof s._cacheTokens==="object"){this._mCacheTokens=s._cacheTokens;delete s._cacheTokens;}if(s&&typeof s._manifestModels==="object"){this._mManifestModels=s._manifestModels;delete s._manifestModels;}else{this._mManifestModels={};}this._mServices={};M.apply(this,e);},metadata:{stereotype:"component","abstract":true,specialSettings:{componentData:'any'},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},C);h.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata().getManifest();}else{return this._oManifest.getJson();}};h.prototype.getManifestEntry=function(K){return this._getManifestEntry(K);};h.prototype._getManifestEntry=function(K,m){if(!this._oManifest){return this.getMetadata().getManifestEntry(K,m);}else{return g(this.getMetadata(),this._oManifest,K,m);}};h.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject();}else{return this._oManifest;}};h.prototype._isVariant=function(){if(this._oManifest){var m=this._oMetadataProxy._oMetadata.getManifestEntry("/sap.app/id");return m!==this.getManifestEntry("/sap.app/id");}else{return false;}};h.activateCustomizing=function(s){};h.deactivateCustomizing=function(s){};h.getOwnerIdFor=function(o){var O=(o instanceof M)&&o._sOwnerId;return O||undefined;};h.getOwnerComponentFor=function(o){var O=h.getOwnerIdFor(o);return O&&sap.ui.component(O);};h.prototype.runAsOwner=function(e){return r(e,this.getId());};h.prototype.getInterface=function(){return this;};h.prototype._initCompositeSupport=function(s){this.oComponentData=s&&s.componentData;if(!this._isVariant()){this.getMetadata().init();}else{this._oManifest.init(this);}this.initComponentModels();if(this.onWindowError){this._fnWindowErrorHandler=q.proxy(function(e){var E=e.originalEvent;this.onWindowError(E.message,E.filename,E.lineno);},this);q(window).bind("error",this._fnWindowErrorHandler);}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=q.proxy(this.onWindowBeforeUnload,this);q(window).bind("beforeunload",this._fnWindowBeforeUnloadHandler);}if(this.onWindowUnload){this._fnWindowUnloadHandler=q.proxy(this.onWindowUnload,this);q(window).bind("unload",this._fnWindowUnloadHandler);}};h.prototype.destroy=function(){for(var L in this._mServices){if(this._mServices[L].instance){this._mServices[L].instance.destroy();}}delete this._mServices;for(var m in this._mManifestModels){this._mManifestModels[m].destroy();}delete this._mManifestModels;if(this._fnWindowErrorHandler){q(window).unbind("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler;}if(this._fnWindowBeforeUnloadHandler){q(window).unbind("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler;}if(this._fnWindowUnloadHandler){q(window).unbind("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler;}if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus;}M.prototype.destroy.apply(this,arguments);sap.ui.getCore().getMessageManager().unregisterObject(this);if(!this._isVariant()){this.getMetadata().exit();}else{this._oManifest.exit(this);}};h.prototype.getComponentData=function(){return this.oComponentData;};h.prototype.getEventBus=function(){if(!this._oEventBus){var E=sap.ui.requireSync("sap/ui/core/EventBus");this._oEventBus=new E();}return this._oEventBus;};h.prototype.initComponentModels=function(){var m=this.getMetadata();if(m.isBaseClass()){return;}var o=this._getManifestEntry("/sap.app/dataSources",true)||{};var e=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(e,o);};h.prototype._initComponentModels=function(m,D){var A=h._createManifestModelConfigurations({models:m,dataSources:D,component:this,mergeParent:true,cacheTokens:this._mCacheTokens});if(!A){return;}var e={};for(var s in A){if(!this._mManifestModels[s]){e[s]=A[s];}}var i=h._createManifestModels(e,this.toString());for(var s in i){this._mManifestModels[s]=i[s];}for(var s in this._mManifestModels){var o=this._mManifestModels[s];this.setModel(o,s||undefined);}};h.prototype.getService=function(L){if(!this._mServices[L]){this._mServices[L]={};this._mServices[L].promise=new Promise(function(R,e){sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(S){var s=this.getManifestEntry("/sap.ui5/services/"+L);var i=s&&s.factoryName;if(!i){e(new Error("Service "+L+" not declared!"));return;}var o=S.get(i);if(o){o.createInstance({scopeObject:this,scopeType:"component",settings:s.settings||{}}).then(function(m){if(!this.bIsDestroyed){this._mServices[L].instance=m;this._mServices[L].interface=m.getInterface();R(this._mServices[L].interface);}else{e(new Error("Service "+L+" could not be loaded as its Component was destroyed."));}}.bind(this)).catch(e);}else{var E="The ServiceFactory "+i+" for Service "+L+" not found in ServiceFactoryRegistry!";var O=this.getManifestEntry("/sap.ui5/services/"+L+"/optional");if(!O){q.sap.log.error(E);}e(new Error(E));}}.bind(this));}.bind(this));}return this._mServices[L].promise;};function j(o){var s=o.getManifestEntry("/sap.ui5/services");for(var S in s){if(s[S].lazy===false){o.getService(S);}}}h.prototype.createComponent=function(u){var m={async:true};if(u&&typeof u==="object"){m.usage=u.usage;["id","async","settings","componentData"].forEach(function(n){if(u[n]!==undefined){m[n]=u[n];}});}else if(typeof u==="string"){m.usage=u;}return this._createComponent(m);};h.prototype._createComponent=function(m){if(m&&m.usage){var u=m.usage;var e=this.getManifestEntry("/sap.ui5/componentUsages/"+u);if(!e){throw new Error("Component usage \""+u+"\" not declared in Component \""+this.getManifestObject().getComponentName()+"\"!");}m=q.extend(true,e,m);}return this.runAsOwner(function(){return sap.ui.component(m);});};h._createManifestModelConfigurations=function(o){var e=o.component;var m=o.manifest||e.getManifestObject();var n=o.mergeParent;var p=o.cacheTokens||{};var L=e?e.toString():m.getComponentName();var s=sap.ui.getCore().getConfiguration();if(!o.models){return null;}var t={models:o.models,dataSources:o.dataSources||{},origin:{dataSources:{},models:{}}};if(e&&n){var u=e.getMetadata();while(u instanceof C){var v=u.getManifestObject();var w=u.getManifestEntry("/sap.app/dataSources");d(t.dataSources,t.origin.dataSources,w,v);var x=u.getManifestEntry("/sap.ui5/models");d(t.models,t.origin.models,x,v);u=u.getParent();}}var y={};for(var z in t.models){var A=t.models[z];var I=false;var B=null;if(typeof A==='string'){A={dataSource:A};}if(A.dataSource){var D=t.dataSources&&t.dataSources[A.dataSource];if(typeof D==='object'){if(D.type===undefined){D.type='OData';}if(!A.type){switch(D.type){case'OData':if(D.settings&&D.settings.odataVersion==="4.0"){A.type='sap.ui.model.odata.v4.ODataModel';}else{A.type='sap.ui.model.odata.v2.ODataModel';}break;case'JSON':A.type='sap.ui.model.json.JSONModel';break;case'XML':A.type='sap.ui.model.xml.XMLModel';break;default:}}if(A.type==='sap.ui.model.odata.v4.ODataModel'&&D.settings&&D.settings.odataVersion){A.settings=A.settings||{};A.settings.odataVersion=D.settings.odataVersion;}if(!A.uri){A.uri=D.uri;I=true;}if(D.type==='OData'&&D.settings&&typeof D.settings.maxAge==="number"){A.settings=A.settings||{};A.settings.headers=A.settings.headers||{};A.settings.headers["Cache-Control"]="max-age="+D.settings.maxAge;}if(D.type==='OData'&&D.settings&&D.settings.annotations){var E=D.settings.annotations;for(var i=0;i<E.length;i++){var F=t.dataSources[E[i]];if(!F){q.sap.log.error("Component Manifest: ODataAnnotation \""+E[i]+"\" for dataSource \""+A.dataSource+"\" could not be found in manifest","[\"sap.app\"][\"dataSources\"][\""+E[i]+"\"]",L);continue;}if(F.type!=='ODataAnnotation'){q.sap.log.error("Component Manifest: dataSource \""+E[i]+"\" was expected to have type \"ODataAnnotation\" but was \""+F.type+"\"","[\"sap.app\"][\"dataSources\"][\""+E[i]+"\"]",L);continue;}if(!F.uri){q.sap.log.error("Component Manifest: Missing \"uri\" for ODataAnnotation \""+E[i]+"\"","[\"sap.app\"][\"dataSources\"][\""+E[i]+"\"]",L);continue;}var G=new U(F.uri);if(A.type==='sap.ui.model.odata.v2.ODataModel'){["sap-language","sap-client"].forEach(function(Y){if(!G.hasQuery(Y)&&s.getSAPParam(Y)){G.setQuery(Y,s.getSAPParam(Y));}});var H=p.dataSources&&p.dataSources[F.uri];if(H){var J=function(){if(!G.hasQuery("sap-language")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+H+"\" for ODataAnnotation \""+E[i]+"\" ("+G.toString()+"). "+"Missing \"sap-language\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+E[i]+"\"]",L);return;}if(!G.hasQuery("sap-client")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+H+"\" for ODataAnnotation \""+E[i]+"\" ("+G.toString()+"). "+"Missing \"sap-client\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+E[i]+"\"]",L);return;}if(!G.hasQuery("sap-client",s.getSAPParam("sap-client"))){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+H+"\" for ODataAnnotation \""+E[i]+"\" ("+G.toString()+"). "+"URI parameter \"sap-client="+G.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+s.getSAPParam("sap-client")+"\"","[\"sap.app\"][\"dataSources\"][\""+E[i]+"\"]",L);return;}if(G.hasQuery("sap-context-token")&&!G.hasQuery("sap-context-token",H)){var Y=G.query(true)["sap-context-token"];q.sap.log.warning("Component Manifest: Overriding existing \"sap-context-token="+Y+"\" with provided value \""+H+"\" for ODataAnnotation \""+E[i]+"\" ("+G.toString()+").","[\"sap.app\"][\"dataSources\"][\""+E[i]+"\"]",L);}G.setQuery("sap-context-token",H);};J();}}var K=t.origin.dataSources[E[i]]||m;var N=K.resolveUri(G).toString();A.settings=A.settings||{};A.settings.annotationURI=A.settings.annotationURI||[];A.settings.annotationURI.push(N);}}}else{q.sap.log.error("Component Manifest: dataSource \""+A.dataSource+"\" for model \""+z+"\" not found or invalid","[\"sap.app\"][\"dataSources\"][\""+A.dataSource+"\"]",L);}}if(!A.type){q.sap.log.error("Component Manifest: Missing \"type\" for model \""+z+"\"","[\"sap.ui5\"][\"models\"][\""+z+"\"]",L);continue;}if(A.type==='sap.ui.model.odata.ODataModel'&&(!A.settings||A.settings.json===undefined)){A.settings=A.settings||{};A.settings.json=true;}if(A.uri){var O=new U(A.uri);var P=(I?t.origin.dataSources[A.dataSource]:t.origin.models[z])||m;O=P.resolveUri(O);if(A.dataSource){c(O);if(A.type==='sap.ui.model.odata.v2.ODataModel'){B=A.settings&&A.settings.metadataUrlParams;if((!B||typeof B['sap-language']==='undefined')&&!O.hasQuery('sap-language')&&s.getSAPParam('sap-language')){A.settings=A.settings||{};B=A.settings.metadataUrlParams=A.settings.metadataUrlParams||{};B['sap-language']=s.getSAPParam('sap-language');}if(p.dataSources){var H=p.dataSources[D.uri];if(H){var Q=function(){if(O.hasQuery("sap-context-token")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+H+"\" for model \""+z+"\" ("+O.toString()+"). "+"Model URI already contains parameter \"sap-context-token="+O.query(true)["sap-context-token"]+"\"","[\"sap.ui5\"][\"models\"][\""+z+"\"]",L);return;}if((!B||typeof B["sap-language"]==="undefined")&&!O.hasQuery("sap-language")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+H+"\" for model \""+z+"\" ("+O.toString()+"). "+"Missing \"sap-language\" parameter","[\"sap.ui5\"][\"models\"][\""+z+"\"]",L);return;}if(!O.hasQuery("sap-client")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+H+"\" for model \""+z+"\" ("+O.toString()+"). "+"Missing \"sap-client\" parameter","[\"sap.ui5\"][\"models\"][\""+z+"\"]",L);return;}if(!O.hasQuery("sap-client",s.getSAPParam("sap-client"))){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+H+"\" for model \""+z+"\" ("+O.toString()+"). "+"URI parameter \"sap-client="+O.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+s.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+z+"\"]",L);return;}if(B&&typeof B["sap-client"]!=="undefined"){if(B["sap-client"]!==s.getSAPParam("sap-client")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+H+"\" for model \""+z+"\" ("+O.toString()+"). "+"Parameter metadataUrlParams[\"sap-client\"] = \""+B["sap-client"]+"\" must be identical with configuration \"sap-client="+s.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+z+"\"]",L);return;}}if(B&&B["sap-context-token"]&&B["sap-context-token"]!==H){q.sap.log.warning("Component Manifest: Overriding existing \"sap-context-token="+B["sap-context-token"]+"\" with provided value \""+H+"\" for model \""+z+"\" ("+O.toString()+").","[\"sap.ui5\"][\"models\"][\""+z+"\"]",L);}if(!B){A.settings=A.settings||{};B=A.settings.metadataUrlParams=A.settings.metadataUrlParams||{};}B["sap-context-token"]=H;};Q();}}}}A.uri=O.toString();}if(A.uriSettingName===undefined){switch(A.type){case'sap.ui.model.odata.ODataModel':case'sap.ui.model.odata.v2.ODataModel':case'sap.ui.model.odata.v4.ODataModel':A.uriSettingName='serviceUrl';break;case'sap.ui.model.resource.ResourceModel':A.uriSettingName='bundleUrl';break;default:}}var S;var R;if(e){R=e.getComponentData();}else{R=o.componentData;}S=R&&R.startupParameters&&R.startupParameters["sap-system"];if(!S){S=s.getSAPParam("sap-system");}var T=false;var V;if(S&&["sap.ui.model.odata.ODataModel","sap.ui.model.odata.v2.ODataModel"].indexOf(A.type)!=-1){T=true;V=sap.ui.requireSync("sap/ui/model/odata/ODataUtils");}if(A.uri){if(T){A.preOriginBaseUri=A.uri.split("?")[0];A.uri=V.setOrigin(A.uri,{alias:S});A.postOriginBaseUri=A.uri.split("?")[0];}if(A.uriSettingName!==undefined){A.settings=A.settings||{};if(!A.settings[A.uriSettingName]){A.settings[A.uriSettingName]=A.uri;}}else if(A.settings){A.settings=[A.uri,A.settings];}else{A.settings=[A.uri];}}else{if(T&&A.uriSettingName!==undefined&&A.settings&&A.settings[A.uriSettingName]){A.preOriginBaseUri=A.settings[A.uriSettingName].split("?")[0];A.settings[A.uriSettingName]=V.setOrigin(A.settings[A.uriSettingName],{alias:S});A.postOriginUri=A.settings[A.uriSettingName].split("?")[0];}}if(T&&A.settings&&A.settings.annotationURI){var W=[].concat(A.settings.annotationURI);var X=[];for(var i=0;i<W.length;i++){X.push(V.setAnnotationOrigin(W[i],{alias:S,preOriginBaseUri:A.preOriginBaseUri,postOriginBaseUri:A.postOriginBaseUri}));}A.settings.annotationURI=X;}if(A.settings&&!Array.isArray(A.settings)){A.settings=[A.settings];}y[z]=A;}return y;};h._createManifestModels=function(m,L){var e={};for(var s in m){var o=m[s];try{q.sap.require(o.type);}catch(E){q.sap.log.error("Component Manifest: Class \""+o.type+"\" for model \""+s+"\" could not be loaded. "+E,"[\"sap.ui5\"][\"models\"][\""+s+"\"]",L);continue;}var i=q.sap.getObject(o.type);if(!i){q.sap.log.error("Component Manifest: Class \""+o.type+"\" for model \""+s+"\" could not be found","[\"sap.ui5\"][\"models\"][\""+s+"\"]",L);continue;}var A=[null].concat(o.settings||[]);var F=i.bind.apply(i,A);var n=new F();e[s]=n;}return e;};function k(m,o,e){var i={afterManifest:{},afterPreload:{}};var n=q.extend(true,{},m.getEntry("/sap.app/dataSources"));var p=q.extend(true,{},m.getEntry("/sap.ui5/models"));var A=h._createManifestModelConfigurations({models:p,dataSources:n,manifest:m,componentData:o,cacheTokens:e});var P=q.sap.getUriParameters().get("sap-ui-xx-preload-component-models-"+m.getComponentName());var s=P&&P.split(",");for(var t in A){var u=A[t];if(!u.preload&&s&&s.indexOf(t)>-1){u.preload=true;q.sap.log.warning("FOR TESTING ONLY!!! Activating preload for model \""+t+"\" ("+u.type+")",m.getComponentName(),"sap.ui.core.Component");}if(u.type==="sap.ui.model.resource.ResourceModel"&&Array.isArray(u.settings)&&u.settings.length>0&&u.settings[0].async!==true){i.afterPreload[t]=u;}else if(u.preload){if(q.sap.isDeclared(u.type,true)){i.afterManifest[t]=u;}else{q.sap.log.warning("Can not preload model \""+t+"\" as required class has not been loaded: \""+u.type+"\"",m.getComponentName(),"sap.ui.core.Component");}}}return i;}h._fnLoadComponentCallback=null;h._fnOnInstanceCreated=null;sap.ui.component=function(v){if(!v){throw new Error("sap.ui.component cannot be called without parameter!");}if(typeof v==='string'){return sap.ui.getCore().getComponent(v);}function e(o){var n=v.name,I=v.id,m=v.componentData,p=n+'.Component',S=v.settings;var t=new o(q.extend({},S,{id:I,componentData:m,_cacheTokens:v.asyncHints&&v.asyncHints.cacheTokens}));q.sap.log.info("Component instance Id = "+t.getId());var H=t.getMetadata().handleValidation()!==undefined||v.handleValidation;if(H){if(t.getMetadata().handleValidation()!==undefined){H=t.getMetadata().handleValidation();}else{H=v.handleValidation;}sap.ui.getCore().getMessageManager().registerObject(t,H);}j(t);if(typeof h._fnOnInstanceCreated==="function"){var P=h._fnOnInstanceCreated(t,v);if(v.async&&P instanceof Promise){return P.then(function(){return t;});}}return t;}var i=l(v,{failOnError:true,createModels:true,waitFor:v.asyncHints&&v.asyncHints.waitFor});if(v.async){var s=M._sOwnerId;return i.then(function(o){return r(function(){return e(o);},s);});}else{return e(i);}};sap.ui.component.load=function(o,F){return l(o,{failOnError:F,preloadOnly:o.asyncHints&&o.asyncHints.preloadOnly});};function l(o,O){var n=o.name,u=o.url,m=sap.ui.getCore().getConfiguration(),p=/^(sync|async)$/.test(m.getComponentPreload()),s=o.manifest,t,w,x,y,z,A;function B(R){var x=new a(JSON.parse(JSON.stringify(R)));return o.async?Promise.resolve(x):x;}if(s===undefined){t=o.manifestFirst===undefined?m.getManifestFirst():!!o.manifestFirst;w=o.manifestUrl;}else{if(o.async===undefined){o.async=true;}t=!!s;w=s&&typeof s==='string'?s:undefined;x=s&&typeof s==='object'?B(s):undefined;}q.sap.interaction.setStepComponent(n);if(!x&&w){x=a.load({manifestUrl:w,componentName:n,async:o.async});}if(x&&!o.async){n=x.getComponentName();}if(!(x&&o.async)){if(!n){throw new Error("The name of the component is undefined.");}}if(n&&u){q.sap.registerModulePath(n,u);}if(t&&!x){x=a.load({manifestUrl:q.sap.getModulePath(n)+"/manifest.json",componentName:n,async:o.async,failOnError:false});}function D(){return q.sap.getResourceName(n+".Component","");}function E(e){var i=n+'.Component';if(!e){var v="The specified component controller '"+i+"' could not be found!";if(O.failOnError){throw new Error(v);}else{q.sap.log.warning(v);}}if(x){var R=f(e.getMetadata(),x);var S=function(){var T=Array.prototype.slice.call(arguments);var V;if(T.length===0||typeof T[0]==="object"){V=T[0]=T[0]||{};}else if(typeof T[0]==="string"){V=T[1]=T[1]||{};}V._metadataProxy=R;if(y){V._manifestModels=y;}var W=Object.create(e.prototype);e.apply(W,T);return W;};S.getMetadata=function(){return R;};S.extend=function(){throw new Error("Extending Components created by Manifest is not supported!");};return S;}else{return e;}}function F(v,i){if(typeof v==='object'){if(v.url){q.sap.registerModulePath(v.name,v.url);}return(v.lazy&&i!==true)?undefined:v.name;}return v;}function G(i,v){var R=i+'.Component',S;if(p&&i!=null&&!q.sap.isDeclared(R,true)){if(v){S=q.sap.getResourceName(R,'-preload.js');return q.sap._loadJSResourceAsync(S,true);}try{S=R+'-preload';q.sap.require(S);}catch(e){q.sap.log.warning("couldn't preload component from "+S+": "+((e&&e.message)||e));}}else if(v){return Promise.resolve();}}function H(e,x,i){var v=[];var R=i?function(Y){v.push(Y);}:q.noop;x.defineResourceRoots();var S=x.getEntry("/sap.ui5/dependencies/libs");if(S){var T=[];for(var V in S){if(!S[V].lazy){T.push(V);}}if(T.length>0){q.sap.log.info("Component \""+e+"\" is loading libraries: \""+T.join(", ")+"\"");R(sap.ui.getCore().loadLibraries(T,{async:i}));}}var W=x.getEntry("/sap.ui5/extends/component");if(W){R(G(W,i));}var X=x.getEntry("/sap.ui5/dependencies/components");if(X){for(var e in X){if(!X[e].lazy){R(G(e,i));}}}return i?Promise.all(v):undefined;}if(o.async){var I=o.asyncHints||{},J=[],K=function(e){e=e.then(function(v){return{result:v,rejected:false};},function(v){return{result:v,rejected:true};});return e;},L=function(e){if(e){J.push(K(e));}},N=function($){return $;},P,Q;if(x&&O.createModels){L(x.then(function(x){z=k(x,o.componentData,I.cacheTokens);return x;}).then(function(x){if(Object.keys(z.afterManifest).length>0){y=h._createManifestModels(z.afterManifest,x.getComponentName());}return x;}));}P=[];if(Array.isArray(I.preloadBundles)){I.preloadBundles.forEach(function(v){P.push(q.sap._loadJSResourceAsync(F(v,true),true));});}if(Array.isArray(I.libs)){Q=I.libs.map(F).filter(N);P.push(sap.ui.getCore().loadLibraries(Q,{preloadOnly:true}));}P=Promise.all(P);if(Q&&!O.preloadOnly){P=P.then(function(){return sap.ui.getCore().loadLibraries(Q);});}L(P);if(!x){L(G(n,true));}else{L(x.then(function(x){var e=x.getComponentName();if(u){q.sap.registerModulePath(e,u);}return G(e,true).then(function(){if(!O.createModels){return null;}var R=Object.keys(z.afterPreload);if(R.length===0){return null;}return new Promise(function(i){sap.ui.require(["sap/ui/model/resource/ResourceModel"],function(v){i(v);});}).then(function(i){function v(S){var T=z.afterPreload[S];if(Array.isArray(T.settings)&&T.settings.length>0){var V=T.settings[0];return i.loadResourceBundle(V,true).then(function(W){V.bundle=W;},function(W){q.sap.log.error("Component Manifest: Could not preload ResourceBundle for ResourceModel. "+"The model will be skipped here and tried to be created on Component initialization.","[\"sap.ui5\"][\"models\"][\""+S+"\"]",e);q.sap.log.error(W);delete z.afterPreload[S];});}else{return Promise.resolve();}}return Promise.all(R.map(v)).then(function(){if(Object.keys(z.afterPreload).length>0){var S=h._createManifestModels(z.afterPreload,x.getComponentName());if(!y){y={};}for(var T in S){y[T]=S[T];}}});});});}));A=function(e){if(typeof h._fnLoadComponentCallback==="function"){var i=q.extend(true,{},o);var v=q.extend(true,{},e);try{h._fnLoadComponentCallback(i,v);}catch(R){q.sap.log.error("Callback for loading the component \""+x.getComponentName()+"\" run into an error. The callback was skipped and the component loading resumed.",R,"sap.ui.core.Component");}}};}if(I.components){q.each(I.components,function(i,v){L(G(F(v),true));});}return Promise.all(J).then(function(v){var R=[],e=false,i;e=v.some(function(S){if(S&&S.rejected){i=S.result;return true;}R.push(S.result);});if(e){return Promise.reject(i);}return R;}).then(function(v){if(x&&A){x.then(A);}return v;}).then(function(v){q.sap.log.debug("Component.load: all promises fulfilled, then "+v);if(x){return x.then(function(e){x=e;n=x.getComponentName();return H(n,x,true);});}else{return v;}}).then(function(){if(O.preloadOnly){return true;}return new Promise(function(e,i){sap.ui.require([D()],function(v){e(E(v));});});}).then(function(e){var i=O.waitFor;if(i){var v=Array.isArray(i)?i:[i];return Promise.all(v).then(function(){return e;});}return e;}).catch(function(e){if(y){for(var n in y){var i=y[n];if(i&&typeof i.destroy==="function"){i.destroy();}}}throw e;});}if(x){H(n,x);}G(n);return E(sap.ui.requireSync(D()));}return h;});
