/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/library','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/date/UniversalDate','jquery.sap.strings'],function(q,l,L,a,U){"use strict";var C=l.CalendarType;var D=function(){throw new Error();};var c={};D.oDateInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(o,s,e){return o.getDatePattern(s,e);},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["FullYear","Quarter","Month","Week","Date"]};D.oDateTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(o,s,e){var S=s.indexOf("/");if(S>0){return o.getCombinedDateTimePattern(s.substr(0,S),s.substr(S+1),e);}else{return o.getCombinedDateTimePattern(s,s,e);}},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["FullYear","Quarter","Month","Week","Date","DayPeriod","Hours","Minutes","Seconds"]};D.oTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(o,s,e){return o.getTimePattern(s,e);},oRequiredParts:{"text":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["DayPeriod","Hours","Minutes","Seconds"]};D.getInstance=function(F,o){return this.getDateInstance(F,o);};D.getDateInstance=function(F,o){return this.createInstance(F,o,this.oDateInfo);};D.getDateTimeInstance=function(F,o){return this.createInstance(F,o,this.oDateTimeInfo);};D.getTimeInstance=function(F,o){return this.createInstance(F,o,this.oTimeInfo);};function b(F){var P=F.oLocaleData.getIntervalPattern("",F.oFormatOptions.calendarType);P=P.replace(/[^\{\}01 ]/,"-");return P.replace(/\{(0|1)\}/g,F.oFormatOptions.pattern);}D.createInstance=function(F,o,i){var e=Object.create(this.prototype);if(F instanceof L){o=F;F=undefined;}if(!o){o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}e.oLocale=o;e.oLocaleData=a.getInstance(o);e.oFormatOptions=q.extend(false,{},i.oDefaultFormatOptions,F);if(!e.oFormatOptions.calendarType){e.oFormatOptions.calendarType=sap.ui.getCore().getConfiguration().getCalendarType();}if(!e.oFormatOptions.pattern){if(e.oFormatOptions.format){e.oFormatOptions.pattern=e.oLocaleData.getCustomDateTimePattern(e.oFormatOptions.format,e.oFormatOptions.calendarType);}else{e.oFormatOptions.pattern=i.getPattern(e.oLocaleData,e.oFormatOptions.style,e.oFormatOptions.calendarType);}}if(e.oFormatOptions.interval){if(e.oFormatOptions.format){e.intervalPatterns=e.oLocaleData.getCustomIntervalPattern(e.oFormatOptions.format,null,e.oFormatOptions.calendarType);if(typeof e.intervalPatterns==="string"){e.intervalPatterns=[e.intervalPatterns];}e.intervalPatterns.push(e.oLocaleData.getCustomDateTimePattern(e.oFormatOptions.format,e.oFormatOptions.calendarType));}else{e.intervalPatterns=[e.oLocaleData.getCombinedIntervalPattern(e.oFormatOptions.pattern,e.oFormatOptions.calendarType),e.oFormatOptions.pattern];}var s=b(e);e.intervalPatterns.push(s);}if(!e.oFormatOptions.fallback){if(!i.oFallbackFormats){i.oFallbackFormats={};}var g=o.toString(),h=e.oFormatOptions.calendarType,k=g+"-"+h,P,j;if(e.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){k=k+"-"+e.oFormatOptions.pattern;}if(e.oFormatOptions.interval){k=k+"-"+"interval";}var n=i.oFallbackFormats[k]?q.sap.extend(false,{},i.oFallbackFormats[k]):undefined;if(!n){j=i.aFallbackFormatOptions;if(i.bShortFallbackFormatOptions){P=i.getPattern(e.oLocaleData,"short");j=j.concat(D._createFallbackOptionsWithoutDelimiter(P));}if(e.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){j=D._createFallbackOptionsWithoutDelimiter(e.oFormatOptions.pattern).concat(j);}n=D._createFallbackFormat(j,h,o,i,e.oFormatOptions.interval);}e.aFallbackFormats=n;}e.oRequiredParts=i.oRequiredParts;e.aRelativeScales=i.aRelativeScales;e.aRelativeParseScales=i.aRelativeParseScales;e.aIntervalCompareFields=i.aIntervalCompareFields;e.init();return e;};D.prototype.init=function(){var s=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData.getMonths("abbreviated",s);this.aMonthsWide=this.oLocaleData.getMonths("wide",s);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",s);this.aMonthsAbbrevSt=this.oLocaleData.getMonthsStandAlone("abbreviated",s);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",s);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",s);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",s);this.aDaysWide=this.oLocaleData.getDays("wide",s);this.aDaysNarrow=this.oLocaleData.getDays("narrow",s);this.aDaysShort=this.oLocaleData.getDays("short",s);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",s);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",s);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",s);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",s);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",s);this.aQuartersWide=this.oLocaleData.getQuarters("wide",s);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",s);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",s);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",s);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",s);this.aErasNarrow=this.oLocaleData.getEras("narrow",s);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",s);this.aErasWide=this.oLocaleData.getEras("wide",s);this.aDayPeriods=this.oLocaleData.getDayPeriods("abbreviated",s);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray);};D._createFallbackFormat=function(F,s,o,i,I){return F.map(function(O){var e=q.sap.extend(false,{},O);if(I){e.interval=true;}e.calendarType=s;e.fallback=true;var g=D.createInstance(e,o,i);g.bIsFallback=true;return g;});};D._createFallbackOptionsWithoutDelimiter=function(B){var r=/[^dMyGU]/g,o={regex:/d+/g,replace:"dd"},M={regex:/M+/g,replace:"MM"},y={regex:/[yU]+/g,replace:["yyyy","yy"]};B=B.replace(r,"");B=B.replace(o.regex,o.replace);B=B.replace(M.regex,M.replace);return y.replace.map(function(R){return{pattern:B.replace(y.regex,R),strictParsing:true};});};var p={isNumber:function(i){return i>=48&&i<=57;},findNumbers:function(v,M){var i=0;while(i<M&&this.isNumber(v.charCodeAt(i))){i++;}if(typeof v!=="string"){v=v.toString();}return v.substr(0,i);},findEntry:function(v,e){var F=-1,M=0;for(var j=0;j<e.length;j++){if(e[j]&&e[j].length>M&&v.indexOf(e[j])===0){F=j;M=e[j].length;}}return{index:F,value:F===-1?null:e[F]};},parseTZ:function(v,i){var e=0;var t=v.charAt(0)=="+"?-1:1;var P;e++;P=this.findNumbers(v.substr(e),2);var T=parseInt(P,10);e+=2;if(i){e++;}P=this.findNumbers(v.substr(e),2);e+=2;var g=parseInt(P,10);return{length:e,tzDiff:(g+60*T)*t};},checkValid:function(t,P,F){if(t in F.oRequiredParts&&P){return false;}}};D.prototype.oSymbols={"":{name:"text",format:function(F,o,u,e){return F.value;},parse:function(v,P,F,o){var s;var V=true;var i=0;var e=0;for(;e<P.value.length;e++){s=P.value.charAt(e);if(s!==" "){if(v.charAt(i)!==s){V=false;}i++;}else{while(v.charAt(i)===" "){i++;}}if(!V){break;}}if(V){return{length:i};}else{var g=false;if(o.index<o.formatArray.length-1){g=(o.formatArray[o.index+1].type in F.oRequiredParts);}return{valid:p.checkValid(P.type,g,F)};}}},"G":{name:"era",format:function(F,o,u,e){var E=u?o.getUTCEra():o.getEra();if(F.digits<=3){return e.aErasAbbrev[E];}else if(F.digits===4){return e.aErasWide[E];}else{return e.aErasNarrow[E];}},parse:function(v,P,F,o){var e=[F.aErasWide,F.aErasAbbrev,F.aErasNarrow];for(var i=0;i<e.length;i++){var V=e[i];var g=p.findEntry(v,V);if(g.index!==-1){return{era:g.index,length:g.value.length};}}return{era:F.aErasWide.length-1,valid:p.checkValid(P.type,true,F)};}},"y":{name:"year",format:function(F,o,u,e){var y=u?o.getUTCFullYear():o.getFullYear();var Y=String(y);var s=e.oFormatOptions.calendarType;if(F.digits==2&&Y.length>2){Y=Y.substr(Y.length-2);}if(s!=C.Japanese&&F.digits==1&&y<100){Y=q.sap.padLeft(Y,"0",4);}return q.sap.padLeft(Y,"0",F.digits);},parse:function(v,P,F,o){var s=F.oFormatOptions.calendarType;var e;if(P.digits==1){e=p.findNumbers(v,4);}else if(P.digits==2){e=p.findNumbers(v,2);}else{e=p.findNumbers(v,P.digits);}var y=parseInt(e,10);if(s!=C.Japanese&&e.length<=2){var g=U.getInstance(new Date(),s),i=g.getFullYear(),h=Math.floor(i/100),Y=h*100+y-i;if(Y<-70){y+=(h+1)*100;}else if(Y<30){y+=h*100;}else{y+=(h-1)*100;}}return{length:e.length,valid:p.checkValid(P.type,e==="",F),year:y};}},"Y":{name:"weekYear",format:function(F,o,u,e){var w=u?o.getUTCWeek():o.getWeek();var W=w.year;var s=String(W);var g=e.oFormatOptions.calendarType;if(F.digits==2&&s.length>2){s=s.substr(s.length-2);}if(g!=C.Japanese&&F.digits==1&&W<100){s=q.sap.padLeft(s,"0",4);}return q.sap.padLeft(s,"0",F.digits);},parse:function(v,P,F,o){var s=F.oFormatOptions.calendarType;var e;if(P.digits==1){e=p.findNumbers(v,4);}else if(P.digits==2){e=p.findNumbers(v,2);}else{e=p.findNumbers(v,P.digits);}var y=parseInt(e,10);var w;if(s!=C.Japanese&&e.length<=2){var g=U.getInstance(new Date(),s),i=g.getFullYear(),h=Math.floor(i/100),Y=h*100+w-i;if(Y<-70){w+=(h+1)*100;}else if(Y<30){w+=h*100;}else{w+=(h-1)*100;}}return{length:e.length,valid:p.checkValid(P.type,e==="",F),year:y,weekYear:w};}},"M":{name:"month",format:function(F,o,u,e){var M=u?o.getUTCMonth():o.getMonth();if(F.digits==3){return e.aMonthsAbbrev[M];}else if(F.digits==4){return e.aMonthsWide[M];}else if(F.digits>4){return e.aMonthsNarrow[M];}else{return q.sap.padLeft(String(M+1),"0",F.digits);}},parse:function(v,P,F,o){var M=[F.aMonthsWide,F.aMonthsWideSt,F.aMonthsAbbrev,F.aMonthsAbbrevSt,F.aMonthsNarrow,F.aMonthsNarrowSt];var V;var e;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);e=parseInt(s,10)-1;if(o.strict&&(e>11||e<0)){V=false;}}else{for(var i=0;i<M.length;i++){var g=M[i];var h=p.findEntry(v,g);if(h.index!==-1){return{month:h.index,length:h.value.length};}}V=p.checkValid(P.type,true,F);}return{month:e,length:s?s.length:0,valid:V};}},"L":{name:"monthStandalone",format:function(F,o,u,e){var M=u?o.getUTCMonth():o.getMonth();if(F.digits==3){return e.aMonthsAbbrevSt[M];}else if(F.digits==4){return e.aMonthsWideSt[M];}else if(F.digits>4){return e.aMonthsNarrowSt[M];}else{return q.sap.padLeft(String(M+1),"0",F.digits);}},parse:function(v,P,F,o){var M=[F.aMonthsWide,F.aMonthsWideSt,F.aMonthsAbbrev,F.aMonthsAbbrevSt,F.aMonthsNarrow,F.aMonthsNarrowSt];var V;var e;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);e=parseInt(s,10)-1;if(o.strict&&(e>11||e<0)){V=false;}}else{for(var i=0;i<M.length;i++){var g=M[i];var h=p.findEntry(v,g);if(h.index!==-1){return{month:h.index,length:h.value.length};}}V=p.checkValid(P.type,true,F);}return{month:e,length:s?s.length:0,valid:V};}},"w":{name:"weekInYear",format:function(F,o,u,e){var w=u?o.getUTCWeek():o.getWeek();var W=w.week;var s=String(W+1);if(F.digits<3){s=q.sap.padLeft(s,"0",F.digits);}else{s=e.oLocaleData.getCalendarWeek(F.digits===3?"narrow":"wide",q.sap.padLeft(s,"0",2));}return s;},parse:function(v,P,F,o){var V;var s;var w;var i=0;if(P.digits<3){s=p.findNumbers(v,2);i=s.length;w=parseInt(s,10)-1;V=p.checkValid(P.type,!s,F);}else{s=F.oLocaleData.getCalendarWeek(P.digits===3?"narrow":"wide");s=s.replace("{0}","[0-9]+");var r=new RegExp(s),R=r.exec(v);if(R){i=R[0].length;w=parseInt(R[0],10)-1;}else{V=p.checkValid(P.type,true,F);}}return{length:i,valid:V,week:w};}},"W":{name:"weekInMonth",format:function(F,o,u,e){return"";},parse:function(){return{};}},"D":{name:"dayInYear",format:function(F,o,u,e){},parse:function(){return{};}},"d":{name:"day",format:function(F,o,u,e){var i=u?o.getUTCDate():o.getDate();return q.sap.padLeft(String(i),"0",F.digits);},parse:function(v,P,F,o){var s=p.findNumbers(v,Math.max(P.digits,2));var V=p.checkValid(P.type,s==="",F);var i=parseInt(s,10);if(o.strict&&(i>31||i<1)){V=false;}return{day:i,length:s.length,valid:V};}},"Q":{name:"quarter",format:function(F,o,u,e){var Q=u?o.getUTCQuarter():o.getQuarter();if(F.digits==3){return e.aQuartersAbbrev[Q];}else if(F.digits==4){return e.aQuartersWide[Q];}else if(F.digits>4){return e.aQuartersNarrow[Q];}else{return q.sap.padLeft(String(Q+1),"0",F.digits);}},parse:function(v,P,F,o){var V;var Q;var s;var e=[F.aQuartersWide,F.aQuartersWideSt,F.aQuartersAbbrev,F.aQuartersAbbrevSt,F.aQuartersNarrow,F.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);Q=parseInt(s,10)-1;if(o.strict&&Q>3){V=false;}}else{for(var i=0;i<e.length;i++){var g=e[i];var h=p.findEntry(v,g);if(h.index!==-1){return{quarter:h.index,length:h.value.length};}}V=p.checkValid(P.type,true,F);}return{length:s?s.length:0,quarter:Q,valid:V};}},"q":{name:"quarterStandalone",format:function(F,o,u,e){var Q=u?o.getUTCQuarter():o.getQuarter();if(F.digits==3){return e.aQuartersAbbrevSt[Q];}else if(F.digits==4){return e.aQuartersWideSt[Q];}else if(F.digits>4){return e.aQuartersNarrowSt[Q];}else{return q.sap.padLeft(String(Q+1),"0",F.digits);}},parse:function(v,P,F,o){var V;var Q;var s;var e=[F.aQuartersWide,F.aQuartersWideSt,F.aQuartersAbbrev,F.aQuartersAbbrevSt,F.aQuartersNarrow,F.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);Q=parseInt(s,10)-1;if(o.strict&&Q>3){V=false;}}else{for(var i=0;i<e.length;i++){var g=e[i];var h=p.findEntry(v,g);if(h.index!==-1){return{quarter:h.index,length:h.value.length};}}V=p.checkValid(P.type,true,F);}return{length:s?s.length:0,quarter:Q,valid:V};}},"F":{name:"dayOfWeekInMonth",format:function(F,o,u,e){return"";},parse:function(){return{};}},"E":{name:"dayNameInWeek",format:function(F,o,u,e){var i=u?o.getUTCDay():o.getDay();if(F.digits<4){return e.aDaysAbbrev[i];}else if(F.digits==4){return e.aDaysWide[i];}else if(F.digits==5){return e.aDaysNarrow[i];}else{return e.aDaysShort[i];}},parse:function(v,P,F,o){var e=[F.aDaysWide,F.aDaysWideSt,F.aDaysAbbrev,F.aDaysAbbrevSt,F.aDaysShort,F.aDaysShortSt,F.aDaysNarrow,F.aDaysNarrowSt];for(var i=0;i<e.length;i++){var V=e[i];var g=p.findEntry(v,V);if(g.index!==-1){var h=F.oLocaleData.getFirstDayOfWeek();var j=g.index-(h-1);if(j<=0){j+=7;}return{dayNumberOfWeek:j,length:g.value.length};}}}},"c":{name:"dayNameInWeekStandalone",format:function(F,o,u,e){var i=u?o.getUTCDay():o.getDay();if(F.digits<4){return e.aDaysAbbrevSt[i];}else if(F.digits==4){return e.aDaysWideSt[i];}else if(F.digits==5){return e.aDaysNarrowSt[i];}else{return e.aDaysShortSt[i];}},parse:function(v,P,F,o){var e=[F.aDaysWide,F.aDaysWideSt,F.aDaysAbbrev,F.aDaysAbbrevSt,F.aDaysShort,F.aDaysShortSt,F.aDaysNarrow,F.aDaysNarrowSt];for(var i=0;i<e.length;i++){var V=e[i];var g=p.findEntry(v,V);if(g.index!==-1){return{day:g.index,length:g.value.length};}}}},"u":{name:"dayNumberOfWeek",format:function(F,o,u,e){var i=u?o.getUTCDay():o.getDay();var g=e.oLocaleData.getFirstDayOfWeek();var h=i-(g-1);if(h<=0){h+=7;}return h;},parse:function(v,P,F,o){var s=p.findNumbers(v,P.digits);return{dayNumberOfWeek:parseInt(s,10),length:s.length};}},"a":{name:"amPmMarker",format:function(F,o,u,e){var i=u?o.getUTCDayPeriod():o.getDayPeriod();return e.aDayPeriods[i];},parse:function(v,P,F,o){var e;var i;var A=F.aDayPeriods[0],s=F.aDayPeriods[1];var r=/[aApP](?:\.)?[mM](?:\.)?/;var M=v.match(r);var V=(M&&M.index===0);if(V){v=M[0].replace(/\./g,"").toLowerCase()+v.substring(M[0].length);A=A.replace(/\./g,"").toLowerCase();s=s.replace(/\./g,"").toLowerCase();}if(v.indexOf(A)===0){e=false;i=(V?M[0].length:A.length);}else if(v.indexOf(s)===0){e=true;i=(V?M[0].length:s.length);}return{pm:e,length:i};}},"H":{name:"hour0_23",format:function(F,o,u,e){var h=u?o.getUTCHours():o.getHours();return q.sap.padLeft(String(h),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&h>23){V=false;}return{hour:h,length:s.length,valid:V};}},"k":{name:"hour1_24",format:function(F,o,u,e){var h=u?o.getUTCHours():o.getHours();var H=(h===0?"24":String(h));return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(h==24){h=0;}if(o.strict&&h>23){V=false;}return{hour:h,length:s.length,valid:V};}},"K":{name:"hour0_11",format:function(F,o,u,e){var h=u?o.getUTCHours():o.getHours();var H=String(h>11?h-12:h);return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&h>11){V=false;}return{hour:h,length:s.length,valid:V};}},"h":{name:"hour1_12",format:function(F,o,u,e){var h=u?o.getUTCHours():o.getHours();var H;if(h>12){H=String(h-12);}else if(h==0){H="12";}else{H=String(h);}return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var e=o.dateValue.pm;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);var V=p.checkValid(P.type,s==="",F);if(h==12){h=0;e=(e===undefined)?true:e;}if(o.strict&&h>11){V=false;}return{hour:h,length:s.length,pm:e,valid:V};}},"m":{name:"minute",format:function(F,o,u,e){var M=u?o.getUTCMinutes():o.getMinutes();return q.sap.padLeft(String(M),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var M=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&M>59){V=false;}return{length:s.length,minute:M,valid:V};}},"s":{name:"second",format:function(F,o,u,e){var s=u?o.getUTCSeconds():o.getSeconds();return q.sap.padLeft(String(s),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var S=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&S>59){V=false;}return{length:s.length,second:S,valid:V};}},"S":{name:"fractionalsecond",format:function(F,o,u,e){var M=u?o.getUTCMilliseconds():o.getMilliseconds();var s=String(M);var g=q.sap.padLeft(s,"0",3);g=g.substr(0,F.digits);g=q.sap.padRight(g,"0",F.digits);return g;},parse:function(v,P,F,o){var s=p.findNumbers(v,P.digits);var i=s.length;s=s.substr(0,3);s=q.sap.padRight(s,"0",3);var M=parseInt(s,10);return{length:i,millisecond:M};}},"z":{name:"timezoneGeneral",format:function(F,o,u,e){if(F.digits>3&&o.getTimezoneLong()){return o.getTimezoneLong();}else if(o.getTimezoneShort()){return o.getTimezoneShort();}var t="GMT";var T=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(T/60);var M=T%60;if(!u&&T!=0){t+=(P?"-":"+");t+=q.sap.padLeft(String(h),"0",2);t+=":";t+=q.sap.padLeft(String(M),"0",2);}else{t+="Z";}return t;},parse:function(v,P,F,o){var i=0;var t;var T=v.substring(0,3);if(T==="GMT"||T==="UTC"){i=3;}else if(v.substring(0,2)==="UT"){i=2;}else if(v.charAt(0)=="Z"){i=1;t=0;}else{return{error:"cannot be parsed correcly by sap.ui.core.format.DateFormat: The given timezone is not supported!"};}if(v.charAt(0)!="Z"){var e=p.parseTZ(v.substr(i),true);i+=e.length;t=e.tzDiff;}return{length:i,tzDiff:t};}},"Z":{name:"timezoneRFC822",format:function(F,o,u,e){var t=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=q.sap.padLeft(String(h),"0",2);T+=q.sap.padLeft(String(M),"0",2);}return T;},parse:function(v,P,F,o){return p.parseTZ(v,false);}},"X":{name:"timezoneISO8601",format:function(F,o,u,e){var t=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=q.sap.padLeft(String(h),"0",2);T+=":";T+=q.sap.padLeft(String(M),"0",2);}else{T+="Z";}return T;},parse:function(v,P,F,o){if(v.charAt(0)=="Z"){return{length:1,tzDiff:0};}else{return p.parseTZ(v,true);}}}};D.prototype._format=function(j,u){if(this.oFormatOptions.relative){var r=this.formatRelative(j,u,this.oFormatOptions.relativeRange);if(r){return r;}}var s=this.oFormatOptions.calendarType;var o=U.getInstance(j,s);var B=[],P,R,S;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";B.push(this.oSymbols[S].format(P,o,u,this));}R=B.join("");if(sap.ui.getCore().getConfiguration().getOriginInfo()){R=new String(R);R.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern};}return R;};D.prototype.format=function(j,u){if(u===undefined){u=this.oFormatOptions.UTC;}if(Array.isArray(j)){if(!this.oFormatOptions.interval){q.sap.log.error("Non-interval DateFormat can't format more than one date instance.");return"";}if(j.length!==2){q.sap.log.error("Interval DateFormat can only format with 2 date instances but "+j.length+" is given.");return"";}var v=j.every(function(J){return J&&!isNaN(J.getTime());});if(!v){q.sap.log.error("At least one date instance which is passed to the interval DateFormat isn't valid.");return"";}return this._formatInterval(j,u);}else{if(!j||isNaN(j.getTime())){q.sap.log.error("The given date instance isn't valid.");return"";}if(this.oFormatOptions.interval){q.sap.log.error("Interval DateFormat expects an array with two dates for the first argument but only one date is given.");return"";}return this._format(j,u);}};D.prototype._formatInterval=function(j,u){var s=this.oFormatOptions.calendarType;var F=U.getInstance(j[0],s);var t=U.getInstance(j[1],s);var o;var P;var S;var B=[];var e;var g=this._getGreatestDiffField([F,t],u);if(!g){return this._format(j[0],u);}if(this.oFormatOptions.format){e=this.oLocaleData.getCustomIntervalPattern(this.oFormatOptions.format,g,s);}else{e=this.oLocaleData.getCombinedIntervalPattern(this.oFormatOptions.pattern,s);}this.aFormatArray=this.parseCldrDatePattern(e);o=F;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";if(P.repeat){o=t;}B.push(this.oSymbols[S].format(P,o,u,this));}return B.join("");};var f={FullYear:"Year",Quarter:"Quarter",Month:"Month",Week:"Week",Date:"Day",DayPeriod:"DayPeriod",Hours:"Hour",Minutes:"Minute",Seconds:"Second"};D.prototype._getGreatestDiffField=function(e,u){var g=false,h={};this.aIntervalCompareFields.forEach(function(F){var G="get"+(u?"UTC":""),M=G+F,s=f[F],v=e[0][M].apply(e[0]),t=e[1][M].apply(e[1]);if(!q.sap.equal(v,t)){g=true;h[s]=true;}});if(g){return h;}return null;};D.prototype._parse=function(v,F,u,s){var I=0,P,S,r;var o={valid:true};var e={formatArray:F,dateValue:o,strict:s};for(var i=0;i<F.length;i++){S=v.substr(I);P=F[i];e.index=i;r=this.oSymbols[P.symbol||""].parse(S,P,this,e)||{};o=q.extend(o,r);if(r.valid===false){break;}I+=r.length||0;}o.index=I;if(o.pm){o.hour+=12;}if(o.quarter!==undefined&&o.month===undefined&&o.day===undefined){o.month=3*o.quarter;o.day=1;}return o;};D.prototype._parseInterval=function(v,s,u,S){var e,r,o;this.intervalPatterns.some(function(P){var F=this.parseCldrDatePattern(P);r=undefined;for(var i=0;i<F.length;i++){if(F[i].repeat){r=i;break;}}if(r===undefined){o=this._parse(v,F,u,S);if(o.index===0||o.index<v.length){o.valid=false;}if(o.valid===false){return;}e=[o,o];return true;}else{e=[];o=this._parse(v,F.slice(0,r),u,S);if(o.valid===false){return;}e.push(o);var g=o.index;o=this._parse(v.substring(g),F.slice(r),u,S);if(o.index===0||o.index+g<v.length){o.valid=false;}if(o.valid===false){return;}e.push(o);return true;}}.bind(this));return e;};var d=function(o,s,u,S){var e,y=typeof o.year==="number"?o.year:1970;if(o.valid){if(u||o.tzDiff!==undefined){e=U.getInstance(new Date(0),s);e.setUTCEra(o.era||U.getCurrentEra(s));e.setUTCFullYear(y);e.setUTCMonth(o.month||0);e.setUTCDate(o.day||1);e.setUTCHours(o.hour||0);e.setUTCMinutes(o.minute||0);e.setUTCSeconds(o.second||0);e.setUTCMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==e.getUTCDate()){o.valid=false;e=undefined;}else{if(o.tzDiff){e.setUTCMinutes((o.minute||0)+o.tzDiff);}if(o.week!==undefined){e.setUTCWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){e.setUTCDate(e.getUTCDate()+o.dayNumberOfWeek-1);}}}}else{e=U.getInstance(new Date(1970,0,1,0,0,0),s);e.setEra(o.era||U.getCurrentEra(s));e.setFullYear(y);e.setMonth(o.month||0);e.setDate(o.day||1);e.setHours(o.hour||0);e.setMinutes(o.minute||0);e.setSeconds(o.second||0);e.setMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==e.getDate()){o.valid=false;e=undefined;}else if(o.week!==undefined){e.setWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){e.setDate(e.getDate()+o.dayNumberOfWeek-1);}}}if(o.valid){e=e.getJSDate();return e;}}return null;};function m(o,e){if(o===e){return o;}var M={};Object.keys(o).forEach(function(k){M[k]=o[k];});Object.keys(e).forEach(function(k){if(!M.hasOwnProperty(k)){M[k]=e[k];}});return M;}D.prototype.parse=function(v,u,s){v=q.trim(v);var o;var e=this.oFormatOptions.calendarType;if(u===undefined){u=this.oFormatOptions.UTC;}if(s===undefined){s=this.oFormatOptions.strictParsing;}if(!this.oFormatOptions.interval){var j=this.parseRelative(v,u);if(j){return j;}o=this._parse(v,this.aFormatArray,u,s);if(o.index===0||o.index<v.length){o.valid=false;}j=d(o,e,u,s);if(j){return j;}}else{var g=this._parseInterval(v,e,u,s);var J,h;if(g&&g.length==2){var k=m(g[0],g[1]);var n=m(g[1],g[0]);J=d(k,e,u,s);h=d(n,e,u,s);if(J&&h){return[J,h];}}}if(!this.bIsFallback){var r;q.each(this.aFallbackFormats,function(i,F){r=F.parse(v,u,s);if(Array.isArray(r)){return!(r[0]&&r[1]);}else{return!r;}});return r;}if(!this.oFormatOptions.interval){return null;}else{return[null,null];}};D.prototype.parseCldrDatePattern=function(P){if(c[P]){return c[P];}var F=[],i,Q=false,o=null,s="",n="",A={},I=false;for(i=0;i<P.length;i++){var e=P.charAt(i),N,g,h;if(Q){if(e=="'"){g=P.charAt(i-1);h=P.charAt(i-2);N=P.charAt(i+1);if(g=="'"&&h!="'"){Q=false;}else if(N=="'"){i+=1;}else{Q=false;continue;}}if(s=="text"){o.value+=e;}else{o={type:"text",value:e};F.push(o);s="text";}}else{if(e=="'"){Q=true;}else if(this.oSymbols[e]){n=this.oSymbols[e].name;if(s==n){o.digits++;}else{o={type:n,symbol:e,digits:1};F.push(o);s=n;if(!I){if(A[n]){o.repeat=true;I=true;}else{A[n]=true;}}}}else{if(s=="text"){o.value+=e;}else{o={type:"text",value:e};F.push(o);s="text";}}}}c[P]=F;return F;};D.prototype.parseRelative=function(v,u){var P,e,r,R,V;if(!v){return null;}P=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var i=0;i<P.length;i++){e=P[i];r=new RegExp("^\\s*"+e.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");R=r.exec(v);if(R){if(e.value!==undefined){return g(e.value,e.scale);}else{V=parseInt(R[1],10);return g(V*e.sign,e.scale);}}}function g(h,s){var t,T=new Date(),j;if(u){t=T.getTime();}else{t=Date.UTC(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours(),T.getMinutes(),T.getSeconds(),T.getMilliseconds());}j=new Date(t);switch(s){case"second":j.setUTCSeconds(j.getUTCSeconds()+h);break;case"minute":j.setUTCMinutes(j.getUTCMinutes()+h);break;case"hour":j.setUTCHours(j.getUTCHours()+h);break;case"day":j.setUTCDate(j.getUTCDate()+h);break;case"week":j.setUTCDate(j.getUTCDate()+h*7);break;case"month":j.setUTCMonth(j.getUTCMonth()+h);break;case"quarter":j.setUTCMonth(j.getUTCMonth()+h*3);break;case"year":j.setUTCFullYear(j.getUTCFullYear()+h);break;}if(u){return j;}else{return new Date(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate(),j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());}}};D.prototype.formatRelative=function(j,u,r){var t=new Date(),s=this.oFormatOptions.relativeScale||"day",T,i,e,P,g;g=(j.getTime()-t.getTime())/1000;if(this.oFormatOptions.relativeScale=="auto"){s=this._getScale(g,this.aRelativeScales);}if(!r){r=this._mRanges[s];}if(s=="year"||s=="month"||s=="day"){T=Date.UTC(t.getFullYear(),t.getMonth(),t.getDate());if(u){i=Date.UTC(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());}else{i=Date.UTC(j.getFullYear(),j.getMonth(),j.getDate());}g=(i-T)/1000;}e=this._getDifference(s,g);if(this.oFormatOptions.relativeScale!="auto"&&(e<r[0]||e>r[1])){return null;}P=this.oLocaleData.getRelativePattern(s,e,g>0,this.oFormatOptions.relativeStyle);return q.sap.formatMessage(P,[Math.abs(e)]);};D.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};D.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592000,quarter:7776000,year:31536000};D.prototype._getScale=function(e,s){var S,t;e=Math.abs(e);for(var i=0;i<s.length;i++){t=s[i];if(e>=this._mScales[t]){S=t;break;}}if(!S){S=s[s.length-1];}return S;};D.prototype._getDifference=function(s,i){var S=this._mScales[s],e=i/S;if(i>0){e=Math.floor(e);}else{e=Math.ceil(e);}return e;};D.prototype.getAllowedCharacters=function(F){if(this.oFormatOptions.relative){return"";}var A="";var n=false;var e=false;var P;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];switch(P.type){case"text":if(A.indexOf(P.value)<0){A+=P.value;}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!n){A+="0123456789";n=true;}break;case"month":case"monthStandalone":if(P.digits<3){if(!n){A+="0123456789";n=true;}}else{e=true;}break;default:e=true;break;}}if(e){A="";}return A;};return D;},true);
