/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/base/ManagedObject','sap/ui/model/message/MessageModel','./Message','./ControlMessageProcessor','sap/ui/core/message/MessageProcessor'],function(q,E,M,c,d,C,e){"use strict";var f=E.extend("sap.ui.core.message.MessageManager",{constructor:function(){E.apply(this,arguments);this.mProcessors={};this.mObjects={};this.mMessages={};var h=sap.ui.getCore().getConfiguration().getHandleValidation();if(h){sap.ui.getCore().attachValidationSuccess(h,this._handleSuccess,this);sap.ui.getCore().attachValidationError(h,this._handleError,this);sap.ui.getCore().attachParseError(h,this._handleError,this);sap.ui.getCore().attachFormatError(h,this._handleError,this);}},metadata:{publicMethods:["addMessages","removeMessages","removeAllMessages","registerMessageProcessor","unregisterMessageProcessor","registerObject","unregisterObject","getMessageModel","destroy"]}});f.prototype._handleError=function(o,h){if(!this.oControlMessageProcessor){this.oControlMessageProcessor=new C();}if(h){var a=o.getParameter("element");var p=o.getParameter("property");var t=a.getId()+'/'+p;var P=this.oControlMessageProcessor.getId();var T=o.sId==="formatError";if(this.mMessages[P]&&this.mMessages[P][t]){this._removeMessages(this.mMessages[P][t],true);}var r={};r[a.getId()]={properties:{},fieldGroupIds:a.getFieldGroupIds?a.getFieldGroupIds():undefined};r[a.getId()].properties[p]=true;var m=new d({type:sap.ui.core.MessageType.Error,message:o.getParameter("message"),target:t,processor:this.oControlMessageProcessor,technical:T,references:r,validation:true});this.addMessages(m);}o.cancelBubble();};f.prototype._handleSuccess=function(o,h){if(!this.oControlMessageProcessor){this.oControlMessageProcessor=new C();}if(h){var a=o.getParameter("element");var p=o.getParameter("property");var t=a.getId()+'/'+p;var P=this.oControlMessageProcessor.getId();if(this.mMessages[P]&&this.mMessages[P][t]){this._removeMessages(this.mMessages[P][t],true);}}o.cancelBubble();};f.prototype.addMessages=function(m){var o=m,p=this.getAffectedProcessors(m);if(!m){return;}else if(Array.isArray(m)){for(var i=0;i<m.length;i++){o=m[i];this._importMessage(o);}}else{this._importMessage(m);}this._updateMessageModel(p);};f.prototype._importMessage=function(m){var s=m.getTarget(),p=m.getMessageProcessor(),P=p&&p.getId();if(!this.mMessages[P]){this.mMessages[P]={};}var a=this.mMessages[P][s]?this.mMessages[P][s]:[];a.push(m);this.mMessages[P][s]=a;};f.prototype._pushMessages=function(p){var t=this;q.each(p,function(i,P){var m=t.mMessages[i]?t.mMessages[i]:{};t._sortMessages(m);m=Object.keys(m).length===0?null:q.extend(true,{},m);P.setMessages(m);});};f.prototype._sortMessages=function(m){var s={'Error':0,'Warning':1,'Success':2,'Information':3};if(Array.isArray(m)){m={"ignored":m};}q.each(m,function(t,g){if(g.length>0){g.sort(function(a,b){return s[a.type]-s[b.type];});}});};f.prototype._updateMessageModel=function(p){var m=[],o=this.getMessageModel();q.each(this.mMessages,function(P,a){q.each(a,function(k,v){m=q.merge(m,v);});});this._pushMessages(p);o.setData(m);};f.prototype.removeAllMessages=function(){var p={};for(var P in this.mMessages){var F=Object.keys(this.mMessages[P])[0];var m=this.mMessages[P][F];q.extend(p,this.getAffectedProcessors(m));}this.aMessages=[];this.mMessages={};this._updateMessageModel(p);};f.prototype.removeMessages=function(m){return this._removeMessages.apply(this,arguments);};f.prototype._removeMessages=function(m,o){var t=this,p=this.getAffectedProcessors(m);if(!m||(Array.isArray(m)&&m.length==0)){return;}else if(Array.isArray(m)){var O=m.slice(0);for(var i=0;i<O.length;i++){if(!o||O[i].validation){t._removeMessage(O[i]);}}}else if(m instanceof d&&(!o||m.validation)){t._removeMessage(m);}else{q.each(m,function(T,a){t._removeMessages(a,o);});}this._updateMessageModel(p);};f.prototype._removeMessage=function(m){var p=m.getMessageProcessor(),P=p&&p.getId(),a=this.mMessages[P];if(!a){return;}var b=a[m.getTarget()];if(b){for(var i=0;i<b.length;i++){var o=b[i];if(q.sap.equal(o,m)){b.splice(i,1);--i;}}if(a[m.getTarget()].length===0){delete a[m.getTarget()];}}};f.prototype.onMessageChange=function(o){var O=o.getParameter('oldMessages');var n=o.getParameter('newMessages');this.removeMessages(O);this.addMessages(n);};f.prototype.registerMessageProcessor=function(p){var P=p.getId(),m={};if(!this.mProcessors[P]){this.mProcessors[P]=P;p.attachMessageChange(this.onMessageChange,this);if(P in this.mMessages){m[P]=p;this._pushMessages(m);}}};f.prototype.unregisterMessageProcessor=function(p){this.removeMessagesByProcessor(p.getId());delete this.mProcessors[p.getId()];p.detachMessageChange(this.onMessageChange,this);};f.prototype.registerObject=function(o,h){if(!o instanceof M){q.sap.log.error(this+" : "+o.toString()+" is not an instance of sap.ui.base.ManagedObject");return;}o.attachValidationSuccess(h,this._handleSuccess,this);o.attachValidationError(h,this._handleError,this);o.attachParseError(h,this._handleError,this);o.attachFormatError(h,this._handleError,this);};f.prototype.unregisterObject=function(o){if(!o instanceof M){q.sap.log.error(this+" : "+o.toString()+" is not an instance of sap.ui.base.ManagedObject");return;}o.detachValidationSuccess(this._handleSuccess);o.detachValidationError(this._handleError);o.detachParseError(this._handleError);o.detachFormatError(this._handleError);};f.prototype.destroy=function(){q.sap.log.warning("Deprecated: Do not call destroy on a MessageManager");};f.prototype.getMessageModel=function(){if(!this.oMessageModel){this.oMessageModel=new c(this);this.oMessageModel.setData([]);}return this.oMessageModel;};f.prototype.getAffectedProcessors=function(m){var p,P,a={};if(m){if(!Array.isArray(m)){m=[m];}m.forEach(function(o){p=o.getMessageProcessor();if(p instanceof e){P=p.getId();a[P]=p;}});}return a;};f.prototype.removeMessagesByProcessor=function(p){delete this.mMessages[p];this._updateMessageModel({});};return f;});
