/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/demokit/CodeSampleContainer',['jquery.sap.global','sap/ui/core/Control','sap/ui/commons/Link','./library','./CodeViewer','./UIAreaSubstitute'],function(q,C,L,l,a,U){"use strict";
var b=C.extend("sap.ui.demokit.CodeSampleContainer",{metadata:{library:"sap.ui.demokit",properties:{scriptElementId:{type:"string",group:"Misc",defaultValue:null},uiAreaId:{type:"string",group:"Misc",defaultValue:null},title:{type:"string",group:"Misc",defaultValue:null},sourceVisible:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'90%'}},aggregations:{_uiarea:{type:"sap.ui.demokit.UIAreaSubstitute",multiple:false,visibility:"hidden"}},events:{apply:{parameters:{code:{type:"string"}}}}}});
b.prototype.init=function(){this._oUIArea=new U(this.getUiAreaId());this.setAggregation("_uiarea",this._oUIArea);this._oCodeViewer=new a({visible:false,source:"",press:[this._setCodeEditable,this],save:[this._saveAndApplyCode,this]});this._oCodeViewer.setParent(this);this._oShowCodeLink=new L({text:"Show Source",press:[this._toggleCodeDisplay,this]});this._oShowCodeLink.setParent(this);this._oApplyCodeLink=new L({visible:false,text:'Apply',press:[this._saveAndApplyCode,this]});this._oApplyCodeLink.setParent(this);};
b.prototype.setSourceVisible=function(s){this.setProperty("sourceVisible",s);this._oCodeViewer&&this._oCodeViewer.setVisible(this.getSourceVisible());this._oShowCodeLink&&this._oShowCodeLink.setText(this.getSourceVisible()?"Hide Source":"Show Source");this._oApplyCodeLink&&this._oApplyCodeLink.setVisible(this.getSourceVisible());};
b.prototype.setUiAreaId=function(I){this.setProperty("uiAreaId",I);var c;if(this._oUIArea){c=this._oUIArea.removeAllContent();this._oUIArea.destroy();}this._oUIArea=new U(this.getUiAreaId());this.setAggregation("_uiarea",this._oUIArea);if(c){for(var i=0;i<c.length;i++){this._oUIArea.addContent(c[i]);}}};
b.prototype.setScriptElementId=function(i){this.setProperty("scriptElementId",i);this._oCodeViewer.setSource(this._getSource());if(i&&!this._oScriptRef){var t=this;sap.ui.getCore().attachInitEvent(function(){t._oCodeViewer.setSource(t._getSource());});}};
b.prototype._getSource=function(){var s="!source not found! ("+this.getScriptElementId()+")";if(this.getScriptElementId()){this._oScriptRef=q.sap.domById(this.getScriptElementId());if(this._oScriptRef){s=this._oScriptRef.innerHTML;}}return s;};
b.prototype._setCodeEditable=function(){this._oCodeViewer.setEditable(true);var t=this;setTimeout(function(){t._oCodeViewer.focus();},50);};
b.prototype._toggleCodeDisplay=function(){this.setSourceVisible(!this.getSourceVisible());};
b.prototype._saveAndApplyCode=function(){var c=this._oCodeViewer.getSource();if(this._oCodeViewer.getEditable()){c=this._oCodeViewer.getCurrentSource();this._oCodeViewer.setSource(c);this._oCodeViewer.setEditable(false);}this._oUIArea.destroyContent();if(!this.hasListeners("apply")){q.sap.globalEval(c);}else{this.fireApply({code:c});}};
return b;});
sap.ui.predefine('sap/ui/demokit/CodeSampleContainerRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.write(" class='sapUiDKitCSample sapUiShd'");var w=c.getWidth();if(w){a.addStyle("width",w);}a.writeStyles();a.write(">");a.write("<div id='",q.sap.encodeHTML(c.getUiAreaId()),"'");a.write(" class='sapUiBody'");a.write(">");var b=c._oUIArea.getContent();for(var i=0;i<b.length;i++){a.renderControl(b[i]);}a.write("</div>");a.write("<div class='sapUiDKitCSampleBorder'>");a.renderControl(c._oShowCodeLink);a.write(" ");a.renderControl(c._oApplyCodeLink);a.write(" ");a.renderControl(c._oCodeViewer);a.write("</div>");a.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/demokit/CodeViewer',['jquery.sap.global','sap/ui/commons/Button','sap/ui/commons/Dialog','sap/ui/core/Control','./library','jquery.sap.keycodes'],function(q,B,D,C,l){"use strict";
var a=C.extend("sap.ui.demokit.CodeViewer",{metadata:{library:"sap.ui.demokit",properties:{source:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:false},lineNumbering:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Misc",defaultValue:true}},events:{press:{},save:{}}}});
a.load=function(){if(!window.prettyPrint){q.sap.require("sap.ui.demokit.js.google-code-prettify.prettify");}};
a.load();
a.prototype.onAfterRendering=function(){var d=this.getDomRef();if(!this.getEditable()&&d&&d.className.indexOf("prettyprint")!==-1&&window.prettyPrint){prettyPrint();d.className='sapUiCodeViewer sapUiCodeViewerRO '+(this.aCustomStyleClasses||[]).join(' ');}};
a.prototype.onclick=function(b){if(!this.getEditable()){this.firePress({id:this.getId()});b.preventDefault();b.stopPropagation();}};
a.prototype.onsapescape=function(){if(this.getEditable()){this.setEditable(false);}};
a.prototype.onkeydown=function(e){if(this.getEditable()&&((e.keyCode==q.sap.KeyCodes.S&&e.ctrlKey&&!e.shiftKey&&!e.altKey)||(e.keyCode==q.sap.KeyCodes.F2))){e.preventDefault();e.stopPropagation();this.fireSave();}};
a.prototype.getCurrentSource=(function(){var S=/<(\/?[^ >]+)[^>]*>|(&[^;]+;)/g,T={"/p":"\n","br":"\n","div":"\n"},E={"&nbsp;":" ","&lt;":"<","&gt;":">","&amp;":"&"};return function(){var c='',d=this.getDomRef();if(d){c=d.innerHTML;c=c.replace(S,function(m,b,e){if(b){b=b.toLowerCase();if(T[b]){return T[b];}}else if(e){e=e.toLowerCase();if(E[e]){return E[e];}}return"";});}return c;};})();
a.showScript=function(i){var d=document.getElementById(i);var s=d.innerHTML;if(!d||!s){return;}var c=new B({text:"Close",press:function(){o.close();}});var o=new D({applyContentPadding:false,title:"Source Code for '"+i+"'",resizable:true,minWidth:"400px",minHeight:"200px",buttons:[c],content:new a({source:s,press:function(){q.sap.log.info('clicked into code viewer');}}),defaultButton:c});o.center();o.open();};
return a;});
sap.ui.predefine('sap/ui/demokit/CodeViewerRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){if(!c.getVisible()){return;}r.write("<pre");r.writeControlData(c);if(c.getEditable()){r.addClass("sapUiCodeViewer");r.addClass("editable");r.writeAttribute("contentEditable","true");}else{r.addClass("prettyprint");}if(c.getLineNumbering()){r.addClass("linenums");}var h=c.getHeight();if(h){r.addStyle("height",h);}var w=c.getWidth();if(w){r.addStyle("width",w);}r.writeClasses();r.writeStyles();r.write(">");if(c.getSource()){r.write(q.sap.encodeHTML(c.getSource()));}r.write("</pre>");};
return C;},true);
sap.ui.predefine('sap/ui/demokit/DemokitApp',['jquery.sap.global','sap/ui/Device','sap/ui/core/CustomData','sap/ui/core/HTML','sap/ui/core/library','sap/ui/core/ListItem','sap/ui/core/Title','sap/ui/core/mvc/View','sap/ui/core/search/OpenSearchProvider','sap/ui/core/util/LibraryInfo','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/json/JSONModel','sap/ui/layout/form/Form','sap/ui/layout/form/FormContainer','sap/ui/layout/form/FormElement','sap/ui/layout/form/GridLayout','sap/ui/layout/form/GridElementData','sap/ui/layout/VerticalLayout','sap/ui/commons/Button','sap/ui/commons/Dialog','sap/ui/commons/DropdownBox','sap/ui/commons/FormattedTextView','sap/ui/commons/Image','sap/ui/commons/Label','sap/ui/commons/library','sap/ui/commons/Link','sap/ui/commons/TextView','sap/ui/commons/SearchField','sap/ui/commons/Splitter','sap/ui/commons/Tree','sap/ui/commons/TreeNode','sap/ui/commons/layout/AbsoluteLayout','sap/ui/ux3/DataSet','sap/ui/ux3/DataSetItem','sap/ui/ux3/DataSetSimpleView','sap/ui/ux3/NavigationItem','sap/ui/ux3/Shell','sap/ui/ux3/ToolPopup','./FeedbackClient','./library','./Tag','./TagCloud','jquery.sap.script'],function(q,D,C,H,c,L,T,V,O,d,F,f,J,g,h,k,G,m,n,B,r,s,t,I,u,v,w,y,S,z,A,E,K,M,N,P,Q,R,U,W,X,Y,Z){"use strict";var $=v.TextViewColor,_=v.TextViewDesign,a1=c.mvc.ViewType;var b1=function(a,b,e){var i=this;function j(p){return p.split('/').slice(0,-1).join('/')+'/';}var l=window.location.href;if(l.indexOf('#')>=0){l=l.slice(0,l.indexOf('#'));}this.sBaseUrl=j(l);this.sBasePathname=j(window.location.pathname);this._iPendingCalls=0;this._mBestMatchingPage={};this._aTopLevelNavItems=[];this._aThemes=e||["sap_belize","sap_belize_plus","sap_belize_hcb","sap_belize_hcw","sap_bluecrystal","sap_hcb"];this._sTheme=this._aThemes[0];this._sCurrentContent=null;this._mAliases={};this._bIgnoreIFrameOnLoad=false;this._sTitleStr=a;this._sVersionStr=b;this._sSelectedWorkSetItem=null;b1.getInstance=q.sap.getter(this);q(window).bind('hashchange',function(){var o=window.location.hash;q.sap.log.debug("hashchange occured, current='"+i._sCurrentContent+"', new='"+o+"'");if(o&&o!="#"+i._sCurrentContent){q.sap.log.info("navigate to "+o);i.navigateTo(o,true);}});};
b1.getInstance=function(){var o=q.sap.getObject("top.sap.ui.demokit.DemokitApp");if(o&&o!=b1){return o.getInstance();}};
b1.prototype.calcRelativeUrl=function(a){return a.indexOf(this.sBaseUrl)==0?a.substring(this.sBaseUrl.length):null;};
b1.prototype.registerPageForType=function(a,b){this._mBestMatchingPage[b[0]]=a;};
b1.prototype.findPageForType=function(a){return this._mBestMatchingPage[a]||"docs/api/symbols/"+a+".html";};
b1.prototype._addPendingCall=function(){this._iPendingCalls++;};
b1.prototype._removePendingCall=function(){this._iPendingCalls--;};
b1.prototype.addIndex=function(i,o){o=o||{};var a=this;var b={id:"mi-"+i,text:o.caption||i,newWindow:o.newWindow,visible:(typeof o.visible==="boolean")?o.visible:true,themable:o.themable||false};this._aTopLevelNavItems.push(b);this._createWorksetItem(b);if(o.index){if(o.extend){o.extend(o.index,function(e){a._setIndexData(i,e);});}else{a._setIndexData(i,o.index);}}else if(o.url){this._loadIndexFromUrl(i,o.url,o.transformer,o.extend);}};
b1.prototype._loadIndexFromUrl=function(i,a,b,j){var l=this;q.ajax({url:a,dataType:a.slice(-4)==".xml"?"xml":"json",error:function(x,o,e){l._removePendingCall();q.sap.log.error("failed to load index '"+i+"' from '"+a+"': "+o+", "+e);var p=l._findIndexById(i);if(p){p.navItem.setVisible(false);}},success:function(o,e,x){var p=b?b.call(this,o):o;if(j){j(p,function(o){l._removePendingCall();l._setIndexData(i,o);});}else{l._removePendingCall();l._setIndexData(i,p);}}});this._addPendingCall();};
b1.prototype._setIndexData=function(a,o){var b=this,e,j;function p(l){var i;j++;if(l.ref&&l.controls){var x=q.isArray(l.controls)?l.controls:l.controls.split(/,/);b.registerPageForType(l.ref,x);}if(l.alias&&l.ref){var c1=l.alias.split(",");for(i=0;i<c1.length;i++){b._mAliases[c1[i]]=l.ref;}}if(l.links){for(i=0;i<l.links.length;i++){p(l.links[i]);}}}e=this._findIndexById(a);if(e){e.ref=o.ref;e.links=o;j=0;p(o);e._iTreeSize=j;this._createNavigationTree(e);e.navItem.setEnabled(!!e._oTree);e.navItem.setHref(o.ref);}};
b1.prototype._findIndexById=function(a){for(var i=0;i<this._aTopLevelNavItems.length;i++){var o=this._aTopLevelNavItems[i];if(o.id==="mi-"+a){return o;}}};
b1.prototype.getInitialPage=function(a,b){var i=a,e=window.location.hash,j=q.sap.getUriParameters().get("optimized-module-set");function l(o){return/^([a-zA-Z0-9-_]+\/)*[a-zA-Z0-9-_.]+\.(?:html|txt)(#.*)?$/.test(o);}if(e){e=e.indexOf("#")===0?e.substring(1):e;if(l(e)){i=e;}}if(b&&j){i="customize.html?data="+j;}return i;};
b1.prototype.getPagesForCategory=function(a){var b=this._findIndexById("controls");if(!b||!b.links){return b1.RETRY_LATER;}var p=a.split('/');var o=b.links;for(var i=0;i<p.length;i++){var e=p[i],j;for(j=0;j<o.links.length;j++){if(e==o.links[j].text){break;}}if(j==o.links.length){return[];}o=o.links[j];}return o.links||[];};
b1.RETRY_LATER=-2;
b1.prototype.findIndexForPage=function(a){function b(o,a){if(a&&o.ref&&a.indexOf(o.ref)===0){return true;}if(o.links){for(var j=0;j<o.links.length;j++){if(b(o.links[j],a)){return true;}}}return false;}for(var i=0;i<this._aTopLevelNavItems.length;i++){if(this._aTopLevelNavItems[i].links&&b(this._aTopLevelNavItems[i].links,a)){return i;}}if(this._aTopLevelNavItems.length===0||this._iPendingCalls>0){return b1.RETRY_LATER;}else{q.sap.log.error("could not find "+a+" in nav tree");return-1;}};
b1.DEFAULT_TLN_ITEM=0;
b1.prototype._createNavigationTree=function(o){var a=this;var b=0;function e(p){var h1=p.getSource().getCustomData();for(var i in h1){if(h1[i].getKey()=="_ref_"){a.navigateTo(h1[i].getValue());}}}function j(p,h1,i1,j1){for(var i=0;i<h1.length;i++){var k1={text:h1[i].text,tooltip:h1[i].tooltip,expanded:i1<1,selectable:!!h1[i].ref,selected:e};k1._ref_=h1[i].ref;k1.parentName=(i1<1)?h1[i].text:j1+"."+h1[i].text;p.push(k1);b++;if(h1[i].links&&h1[i].links.length>0){k1.nodes=[];j(k1.nodes,h1[i].links,i1+1,k1.parentName);}}}function l(h1,x){if(h1==="mi-devguidekm"){x.collapseAll();var i1=x.getNodes();for(var i=0;i<i1.length;i++){var j1=i1[i].getCustomData();for(var p=0;p<j1.length;p++){if(j1[p].getKey()==="_ref_"&&j1[p].getValue()&&j1[p].getValue().indexOf("95d113be50ae40d5b0b562b84d715227")!==-1){i1[i].expand();}}}}}if(o._oTree){return;}var x=new A(o.id+"-index",{showHeader:false,width:"100%",height:"100%",showHorizontalScrollbar:true,selectionMode:"Single"});x.addStyleClass("sapUiTreeWithHeader");var c1=new E({text:"{text}",tooltip:"{tooltip}",expanded:"{expanded}",selectable:"{selectable}",selected:e});var d1=new C({key:"_ref_",value:"{_ref_}"});c1.addCustomData(d1);var e1=new C({key:"parentName",value:"{parentName}"});c1.addCustomData(e1);var f1=[];j(f1,o.links.links,0,"");var g1=new J();g1.setSizeLimit(b);x.setModel(g1);g1.setData(f1);x.bindNodes("/",c1);l(o.id,x);if(f1.length>25){x.collapseAll();}o._oTree=x;o._iTreeSize=b;o._oEmptyTreeLabel=new u({text:"No matching entry found.",visible:false,width:"100%",textAlign:"Center"});};
b1.prototype._createWorksetItem=function(o){var a=o.navItem=new Q({key:o.id,text:o.text,href:"#"+o.ref,visible:o.visible,enabled:false});a._itemData_=o;if(this._oShell){this._oShell.addWorksetItem(a);}};
b1.prototype.createUI=function(e,o){var p;var x=this;var c1="theme/img/themeswitch_";var d1=b1.THEMES;this._oThemeSwitch=new s({change:[this._handleThemeChanged,this],items:q.map(this._aThemes,function(a){return new L({text:d1[a],key:a});}),value:d1[this._sTheme]});this._oThemeSwitchPopup=new U({title:"Select a theme",icon:c1+"regular.png",iconHover:c1+"hover.png",iconSelected:c1+"selected.png",content:[this._oThemeSwitch],initialFocus:this._oThemeSwitch});var e1=new H("content",{content:"<iframe id=\"content\" name=\"content\" src=\"about:blank\" frameborder=\"0\" onload=\"sap.ui.demokit.DemokitApp.getInstance().onContentLoaded();\"></iframe>"});var f1=this._oSidePanelLayout=new K();D.os.name==D.os.OS.IOS?p=true:p=false;var g1;if(!this._sVersionStr||(this._sVersionStr.indexOf("SNAPSHOT")>-1)||(this._sVersionStr.split(".").length>1&&parseInt(this._sVersionStr.split(".")[1],10)%2===1)){g1=new y({text:"Development version! Work in Progress!",semanticColor:$.Negative,design:_.Bold});}var h1=new y({text:this._sVersionStr,tooltip:"Used SAPUI5 Version is "+this._sVersionStr});var i1=new y({text:this._sVersionStr,tooltip:"SAPUI5 Version"});var j1=function(){var a;var b=sap.ui.getCore().byId('aboutDlg');var l;if(b instanceof r){a=b;a.open();return;}var i=new B({text:"Back",visible:false,press:function(){q1();}});var j=new B({text:"Close",press:function(){a.close();}});var q1=function(){a.removeAllContent();a.addContent(l);i.setVisible(false);};var r1=new I();var s1;var t1=sap.ui.getVersionInfo();if(t1&&t1.gav&&/openui5/i.test(t1.gav)){r1.setSrc("resources/sap/ui/demokit/themes/base/images/OpenUI5_new_small_size.png");r1.setTooltip("OpenUI5 logo blue");r1.setWidth("446px");r1.addStyleClass("extraLeftPadding");s1='<h2>OpenUI5 - Demo Kit</h2>';s1+='<span>&copy; 2009-2017 SAP SE or an SAP affiliate company.</span><br>';s1+='<span>Licensed under the Apache License, Version 2.0 – <embed data-index="3"><br><br><br></span>';s1+='<span>OpenUI5 Version <embed data-index="0"></span><br>';}else{r1.setSrc("resources/sap/ui/demokit/themes/base/images/logo-SAPUI5-blue-446x140.png");r1.setTooltip("SAPUI5 logo blue");r1.addStyleClass("extraLeftPadding");s1='<h2>SAP UI Development Toolkit for HTML5 (SAPUI5) - Demo Kit</h2>';s1+='<span>&copy; Copyright 2009-2017 SAP SE. All rights reserved.</span><br><br><br>';s1+='<span>SAPUI5 Version <embed data-index="0"></span><br>';}s1+='<span>This software includes the following library versions</span><br>';s1+='<span>(a full change log for all libraries can be found <embed data-index="1">).</span><br>';s1+='<embed data-index="2"><br><br><br>';var u1='<span>This software includes third-party open source software.</span><br>';u1+='<embed data-index="0"><br>';var v1=new w({text:"here",tooltip:"Go to Version Change Log",press:function(){a.close();},href:"releasenotes.html",target:"content"});var w1=new w({text:"Version Details",tooltip:"Go to Version Details",press:function(){a.removeAllContent();a.addContent(k1());i.setVisible(true);}});var x1=new w({text:"Included Third-Party Software",tooltip:"Go to Included Third-Party Software list",press:function(){a.removeAllContent();a.addContent(l1());i.setVisible(true);}});var y1=new w({text:"see LICENSE.txt",tooltip:"Go to LICENSE.txt",press:function(){a.close();},href:"LICENSE.txt",target:"content"});var z1=new t();z1.setContent(s1,[i1,v1,w1,y1]);z1.addStyleClass("extraLeftPadding");var A1=new t();A1.setContent(u1,[x1]);A1.addStyleClass("extraLeftPadding");if(t1&&t1.gav&&/openui5/i.test(t1.gav)){l=new n({content:[r1,z1]});}else{l=new n({content:[r1,z1,A1]});}a=new r('aboutDlg',{title:"About",modal:true,buttons:[i,j],content:[l],showCloseButton:false,width:"550px",height:"800px",maxHeight:"100%"});a.attachClosed(q1);a.open();};var k1=function(){q.sap.registerModulePath("versioninfo","./versioninfo/");var a=new J();X._loadAllLibInfo("","_getLibraryInfo","",function(r1,s1){var t1={};var u1=new d();for(var i=0,l=r1.length;i<l;i++){r1[i]=s1[r1[i]];r1[i].libDefaultComponent=u1._getDefaultComponent(r1[i]);}t1.libs=r1;a.setData(t1);});var b=function openReleaseDialog(){var i;var l;var r1=sap.ui.getCore().byId("notesView");var s1=sap.ui.getCore().byId("notesDialog");if(!s1){l=new y({text:"No changes for this library!",id:"noRelNote"});r1=sap.ui.view({id:"notesView",viewName:"versioninfo.notes",type:a1.Template});i=new J();r1.setModel(i);s1=new r("notesDialog");s1.addButton(new B({text:"OK",press:function(){s1.close();}}));s1.setModal(true);s1.setHeight("40%");s1.setWidth("40%");r1.addStyleClass("myReleaseNotes");s1.setResizable(true);}var t1=new d();s1.setTitle("Change log for: "+this.getBindingContext().getProperty("library"));var u1=q.sap.Version(this.getBindingContext().getProperty("version"));var v1=u1.getMajor()+"."+u1.getMinor()+"."+u1.getPatch()+u1.getSuffix();t1._getReleaseNotes(this.getBindingContext().getProperty("library"),v1,function(w1,v1){s1.removeAllContent();if(w1&&w1[v1]&&w1[v1].notes&&w1[v1].notes.length>0){s1.addContent(r1);r1.getModel().setData(w1);r1.bindObject("/"+v1);s1.open();}else{if(l){s1.addContent(l);}else{s1.addContent(sap.ui.getCore().byId("noRelNote"));}s1.open();}});};var j=new M({items:{path:"/libs",template:new N({title:"{library}"})},views:[new P({floating:false,template:new g({title:new T({text:"{library}"}),width:"100%",layout:new G(),formContainers:[new h({formElements:[new k({label:new u({text:"Version:",layoutData:new m({hCells:"3"})}),fields:[new y({text:"{version}"})]}),new k({label:new u({text:"Description:",layoutData:new m({hCells:"3"})}),fields:[new y({text:"{documentation}"})]}),new k({label:new u({text:"Change Log:",layoutData:new m({hCells:"3"})}),fields:[new w({text:"Open Change Log",press:b})],visible:{path:"releasenotes",formatter:function(i){return!!i;}}}),new k({label:new u({text:"Component:",layoutData:new m({hCells:"3"})}),fields:[new y({text:"{libDefaultComponent}"})],visible:{path:"libDefaultComponent",formatter:function(i){return!!i;}}})]})]})})],showToolbar:false,selectionChanged:function(){j.setLeadSelection(-1);}});j.setModel(a);var q1=new n({content:[j]});return q1;};var l1=function(){var l=new J();X._loadAllLibInfo("","_getThirdPartyInfo",function(t1,u1){if(!t1){return;}var v1={};v1.thirdparty=[];for(var j=0;j<t1.length;j++){var w1=u1[t1[j]];for(var i=0;i<w1.libs.length;i++){var x1=w1.libs[i];x1._lib=t1[j];v1.thirdparty.push(x1);}}v1.thirdparty.sort(function(a,b){var y1=(a.displayName||"").toUpperCase();var z1=(b.displayName||"").toUpperCase();if(y1>z1){return 1;}else if(y1<z1){return-1;}else{return 0;}});l.setData(v1);});var q1=new M({items:{path:"/thirdparty",template:new N({title:"{displayName}"})},views:[new P({floating:false,template:new g({title:new T({text:"{displayName}"}),width:"100%",layout:new G(),formContainers:[new h({formElements:[new k({fields:[new w({text:"Web Site",target:"_blank",href:"{homepage}",layoutData:new m({hCells:"auto"})}),new w({text:"License Conditions",target:"_blank",href:"{license/url}",layoutData:new m({hCells:"5"})})]}),new k({fields:[new w({text:"Licensed by SAP under '{license/type}'",target:"_blank",href:"{license/file}"})]})]})]})})],showToolbar:false,selectionChanged:function(){l.setLeadSelection(-1);}});var r1=q.sap.getUriParameters().get("sap-ui-debug");if(r1==="x"||r1==="X"||r1==="true"){l.getViews()[0].getTemplate().getFormContainers()[0].addFormElement(new k({label:new u({text:"Requested by UI Library:",layoutData:new m({hCells:"3"})}),fields:[new y({text:"{_lib}"})]}));}q1.setModel(l);var s1=new n({content:[q1]});return s1;};var m1=new w({text:"About",tooltip:"About",press:function(){j1();}});this._oFeedbackClient=new W();this._oFeedbackPopup=this._oFeedbackClient.createFeedbackPopup();var n1=this._oShell=new R({appTitle:this._sTitleStr,showLogoutButton:false,showFeederTool:false,applyContentPadding:false,showSearchTool:e,fullHeightContent:true,toolPopups:[this._oFeedbackPopup,this._oThemeSwitchPopup],search:function(a){x.navigateTo("search.html?q="+encodeURIComponent(a.getParameter("text")));x._oShell._getSearchTool().close();},worksetItemSelected:function(a){var b=a.getParameter("item");if(b.getEnabled()){var i=b._itemData_;if(i.newWindow){a.preventDefault();}x.navigateTo(i.ref,null,null,i.newWindow);}else{a.preventDefault();}},content:[new z("demokitSplitter",{width:"100%",height:"100%",splitterPosition:"0%",splitterBarVisible:false,firstPaneContent:[f1],secondPaneContent:[e1],showScrollBars:p})],headerItems:g1?[m1,g1,h1]:[m1,h1]});this._oShell.addStyleClass("sapDkShell");function o1(a){var b=new Z({minFontSize:15,maxFontSize:30,press:function(j){var l=sap.ui.getCore().byId(j.getParameter("tagId")).getText();n1.fireSearch({text:l});}}).addStyleClass("grTagCloud");for(var i=0;i<a.length;i++){b.addTag(new Y({text:a[i].tag,weight:a[i].score}));}n1._getSearchTool&&n1._getSearchTool().addContent(b);}if(e){var p1=n1.getSearchField();p1.setEnableListSuggest(true);p1.setShowListExpander(false);p1.setVisibleItemCount(5);p1.setSearchProvider(new O({suggestType:"json",suggestUrl:"suggest?q={searchTerms}"}));q.ajax({url:"keywords?kind=tags&max=50",dataType:"json",success:function(a,b,i){if(a&&a[0]&&a[0].success&&a[0].keywords&&a[0].keywords.length){o1(a[0].keywords);p1.setWidth("80%");}}});}q.each(this._aTopLevelNavItems,function(i,a){n1.addWorksetItem(a.navItem);});this.navigateTo(o);sap.ui.getCore().addPrerenderingTask(function(){q("body").append("<div id=\"logo\"><img id=\"logoico\"><img id=\"logotxt\"></div>");var a=sap.ui.getVersionInfo();if(a&&a.gav&&/openui5/i.test(a.gav)){q("#logoico").attr("src","resources/sap/ui/demokit/themes/base/images/OpenUI5_new_small_size.png").addClass("sapUiImg");}else{q("#logoico").attr("src","resources/sap/ui/core/mimes/logo/icotxt_white_220x72_blue.png").addClass("sapUiImg");}});};
b1.prototype.placeAt=function(i){this._oShell.placeAt(i);};
b1.prototype.onContentLoaded=function(e){var a=this;var o=q("#content")[0].contentWindow;var i=this.calcRelativeUrl(o.location.href);if(i&&!this._bIgnoreIFrameOnLoad){this.navigateTo(i,true,true);window.location.replace("#"+i);}this._applyTheme();this._bIgnoreIFrameOnLoad=false;q(o).bind("hashchange",function(){var i=a.calcRelativeUrl(o.location.href);if(i&&!a._bIgnoreIFrameOnLoad){a.navigateTo(i,true,true);window.location.hash=i;}a._bIgnoreIFrameOnLoad=false;});};
b1.prototype.navigateTo=function(a,b,e,l){var o=this;var p="0px";var x="32px";var c1="30px";var d1="0px";var e1="0px";var f1=a.indexOf("#")===0?a.substring(1):a;var g1=this._mAliases[f1];if(g1&&f1!=g1){e=false;f1=g1;}if(this._sCurrentContent==f1){return;}var h1=q("#content")[0];var i1=h1&&h1.contentWindow;var j1=this.findIndexForPage(f1);if(l){window.open(f1,"_blank");return;}if(!i1||j1===b1.RETRY_LATER){setTimeout(function(){o.navigateTo(f1,b,e);},200);return;}var k1=this._aTopLevelNavItems[j1>=0?j1:0];var l1=this._oShell;var m1=sap.ui.getCore().byId("demokitSplitter");var n1;if(k1&&k1._iTreeSize<=1){if(m1.getSplitterBarVisible()){n1=m1.getSplitterPosition();if(n1!=="0%"){m1._oldPos=n1;m1.setSplitterPosition("0%");}m1.setSplitterBarVisible(false);}}else if(!m1.getSplitterBarVisible()){n1=m1._oldPos||"20%";m1.setSplitterPosition(n1);m1.setSplitterBarVisible(true);}this._sCurrentContent=f1;function o1(f1,B1,C1){if(B1){if(C1&&B1.getSelectedNode&&B1.getSelectedNode()){B1.getSelectedNode().setIsSelected(false);}var D1=B1.getNodes();for(var i=0;i<D1.length;i++){var E1=D1[i].getCustomData();var F1=false;for(var j in E1){if(E1[j].getKey()=="_ref_"&&E1[j].getValue()&&E1[j].getValue().indexOf(f1)>=0){F1=true;break;}}if(F1){var G1=B1;while(G1 instanceof E){G1.expand();G1=G1.getParent();}D1[i].setIsSelected(true);return D1[i];}else{var H1=o1(f1,D1[i],false);if(H1){return H1;}}}}return null;}function p1(w1,j){var B1=function(w1,D1,j){var E1=[];var F1=new F("parentName",f.Contains,D1);E1.push(F1);var G1=w1.getBinding("nodes");G1.filter(E1);if(D1!==""){w1.expandAll();}var H1=(w1.getNodes().length===0);w1.setVisible(!H1);j.setVisible(H1);};var C1=new S({enableListSuggest:false,enableClear:true,enableFilterMode:true,startSuggestion:0,suggest:function(D1){B1(w1,D1.getParameter("value"),j);}});C1.addEventDelegate({onAfterRendering:function(){C1._ctrl.$("searchico").addClass('sapUiIcon sapUiSearchFieldFilterIcon');C1._ctrl.$("searchico").attr('style','font-family: SAP-icons; cursor: default;');C1._ctrl.$("searchico").attr('data-sap-ui-icon-content','');}});C1._ctrl.setPlaceholder("Filter");C1.addStyleClass("sapUiDemokitAbsLayoutFirtsRow sapUiDemokitSearchField");return C1;}function q1(w1,j,B1,C1,D1){var E1=new B({lite:true,icon:B1,press:j.bind(w1)});E1.addStyleClass("sapUiDemokitExpandCollapseButtons sapUiDemokitAbsLayoutFirtsRow");if(D1){E1.addStyleClass(D1);}E1.setTooltip(C1);E1.addEventDelegate({onAfterRendering:function(){E1.$("icon").attr("title",C1);E1.$("icon").attr("aria-label",C1);}});return E1;}function r1(w1){return q1(w1,w1.collapseAll,"sap-icon://collapse-group","Collapse All","sapUiDemokitCollapseButton");}function s1(w1){return q1(w1,w1.expandAll,"sap-icon://expand-group","Expand All");}var t1=null;var u1=k1&&k1.navItem;if(u1&&this._sSelectedWorkSetItem!=u1.getId()){u1.setVisible(true);l1.setSelectedWorksetItem(u1);this._oSidePanelLayout.removeAllContent();if(k1._oTree){this._oSidePanelLayout.addContent(p1(k1._oTree,k1._oEmptyTreeLabel));this._oSidePanelLayout.addContent(r1(k1._oTree),{right:d1,top:e1});this._oSidePanelLayout.addContent(s1(k1._oTree),{right:c1,top:e1});this._oSidePanelLayout.addContent(k1._oTree,{left:p,top:x});this._oSidePanelLayout.addContent(k1._oEmptyTreeLabel,{left:p,top:x});}t1=o1(f1,k1._oTree,true);if(k1.themable&&l1.indexOfToolPopup(this._oThemeSwitchPopup)==-1){l1.addToolPopup(this._oThemeSwitchPopup);}else if((!k1.themable)&&l1.indexOfToolPopup(this._oThemeSwitchPopup)!=-1){l1.removeToolPopup(this._oThemeSwitchPopup);}}else{var v1=this._oSidePanelLayout.getContent();var w1;for(var i in v1){if(v1[i].getId().indexOf("index")>-1){w1=v1[i];}}t1=o1(f1,w1,true);if(!t1&&f1.indexOf("#")>0){var x1=f1.substr(0,f1.indexOf("#")-1);t1=o1(x1,w1);}}sap.ui.getCore().applyChanges();this._sSelectedWorkSetItem=l1.getSelectedWorksetItem();if(!b){window.location.hash=f1;}if(!e){this._bIgnoreIFrameOnLoad=true;var y1=f1&&f1.match(/\/sap\/me?\//);var z1=f1&&f1.indexOf("sap/m/demokit")!==-1;var A1=(y1&&!z1)?"?sap-ui-xx-fakeOS=ios":"";i1.location.replace((f1.indexOf("/")==0?"":this.sBasePathname)+f1+A1);}this._oFeedbackClient.updateFeedbackContextText();};
b1.THEMES={"sap_bluecrystal":"Blue Crystal","sap_belize":"Belize","sap_belize_plus":"Belize Plus","sap_belize_hcb":"Belize High Contrast Black","sap_belize_hcw":"Belize High Contrast White","sap_hcb":"High Contrast Black"};
b1.prototype._handleThemeChanged=function(e){var a=e.getParameter("newValue");for(var x in b1.THEMES){if(b1.THEMES[x]==a){this._sTheme=x;this._applyTheme();e.getSource().getParent().close();break;}}};
b1.prototype._applyTheme=function(){var o=q("#content")[0].contentWindow;var a=this.calcRelativeUrl(o.location.href);var b=a?this.findIndexForPage(a):-1;if(a&&b>=0&&this._aTopLevelNavItems[b].themable&&o&&o.sap&&o.sap.ui&&o.sap.ui.getCore){var e=a.match(/\/sap\/me?\//);var j=e?["sap_bluecrystal","sap_belize","sap_belize_plus","sap_belize_hcb","sap_belize_hcw"]:this._aThemes;var l=o.sap.ui.demokit&&o.sap.ui.demokit._supportedThemes?o.sap.ui.demokit._supportedThemes:j;var p=this._oThemeSwitch.getItems();for(var i=0;i<p.length;i++){p[i].setEnabled(q.inArray(p[i].getKey(),l)>=0);}if(q.inArray(this._sTheme,l)<0){this._sTheme=l[0];this._oThemeSwitch.setValue(b1.THEMES[this._sTheme]);}o.sap.ui.getCore().applyTheme(this._sTheme);}};
(function(){
function a(o,e){if(o.ref&&o.resolve==="lib"){o.ref=e+o.ref;}if(o.links){for(var i=0;i<o.links.length;i++){a(o.links[i],e);}}}
function b(o,e){if(o.key!=e.key||!e.links||e.links.length==0){return;}if(!o.links){o.links=e.links;return;}function p(c1,d1){for(var j=0;j<c1.links.length;j++){if(c1.links[j].key===d1){return c1.links[j];}}return null;}var x;for(var i=0;i<e.links.length;i++){x=e.links[i];if(!x.key){o.links.push(x);}else{var c1=p(o,x.key);if(c1){b(c1,x);}else{o.links.push(x);}}}}
function l(i,e,o,p){for(var j=0;j<o.length;j++){var x=p[o[j]];if(x&&x.docu){a(x.docu,x.libraryUrl);b(i,x.docu);}}e(i);}
b1.addReleaseNotesToDevGuide=function(o,e,j,p){if(!e){e="releasenotes.html";}if(!j){j="Release Notes";}if(!p){p=1;}function x(d1){if(d1&&d1.links&&d1.links.length>0){return d1.links[0];}return null;}var c1=o;for(var i=0;i<p;i++){c1=x(c1);}if(c1){c1.links=c1.links||[];c1.links.push({ref:e,text:j,alias:"releasenotes.html"});}return o;};
b1.extendDevGuide=function(o,j){var p=new d();var x="discovery/all_libs";q.ajax({url:x,dataType:"json",error:function(i,c1,e){q.sap.log.error("failed to load library list from '"+x+"': "+c1+", "+e);j(o);},success:function(e,c1,d1){var e1=e["all_libs"];if(!e1){q.sap.log.error("failed to load library list from '"+x+"': "+c1+", Data: "+e1);j(o);return;}var f1=0,g1=e1.length,h1={},i1=[],j1;for(var i=0;i<g1;i++){j1=e1[i].entry.replace(/\//g,".");i1.push(j1);p._getDocuIndex(j1,function(k1){h1[k1.library]=k1;f1++;if(f1==g1){l(o,j,i1,h1);}});}}});};
})();return b1;},true);
sap.ui.predefine('sap/ui/demokit/EntityInfo',['jquery.sap.global','./util/jsanalyzer/ModuleAnalyzer','./util/APIInfo'],function(q,c,A){"use strict";var r={};
function g(n){var P=n.split('.');var a=r;var l=P.length-1;for(var i=0;i<l&&!a.__noMetamodel&&!a.__noSource;i++){a=a[P[i]]||(a[P[i]]={});}return a;}
var C="boolean int float number function object string void any Element Control Component";
function d(t,a){if(t.indexOf("/")>=0){return t.replace(/\//g,".");}else if(t&&t.indexOf(".")<0&&C.indexOf(t)>=0){return"sap.ui.core."+t;}else{return a.split(".").slice(0,-1).concat([t.replace(/\//g,".")]).join(".");}}
function p(D,e){var $=q(D.documentElement);var a={metatype:'control',baseType:undefined,doc:undefined,deprecation:undefined,properties:{},aggregations:{},associations:{},events:{},methods:{}};var b=$.children("baseType").text();a.baseType=(b)?d(b,e):null;a.doc=k($);a.deprecation=m($);j($,"properties/property",function(i){a.properties[i.attr("name")]={kind:0,type:d(i.attr("type")||"string",e),defaultValue:i.attr("defaultValue")||"empty/undefined",doc:k(i),deprecation:m(i),since:i.attr("since")||null};});a.defaultAggregation=a.defaultAggregation||$.children("aggregations").attr("default");j($,"aggregations/aggregation",function(i){a.aggregations[i.attr("name")]={kind:i.attr("cardinality")==="0..1"?1:2,type:d(i.attr("type")||"sap.ui.core/Control",e),cardinality:i.attr("cardinality")||"0..n",visibility:i.attr("visibility")||null,doc:k(i),deprecation:m(i),since:i.attr("since")||null};});j($,"associations/association",function(i){a.associations[i.attr("name")]={kind:i.attr("cardinality")==="0..n"?4:3,type:d(i.attr("type")||"sap.ui.core/Control",e),cardinality:i.attr("cardinality")||"0..1",doc:k(i),deprecation:m(i),since:i.attr("since")||null};});j($,"events/event",function(i){var n=i.attr("name");a.events[n]={kind:5,doc:k(i),deprecation:m(i),since:i.attr("since")||null,parameters:[]};j(i,"parameters/parameter",function(l){a.events[n].parameters[l.attr("name")]={kind:6,type:d(l.attr("type")||"string",e),doc:k(l),since:l.attr("since")||null,deprecation:m(l)};});});j($,"methods/method",function(i){var n=i.attr("name");a.methods[n]={kind:7,type:d(i.attr("type")||"sap.ui.core/void",e),doc:k(i),deprecation:m(i),since:i.attr("since")||null,parameters:[]};j(i,"parameters/parameter",function(l){a.methods[n].parameters.push({kind:8,name:l.attr("name"),type:d(l.attr("type")||"sap.ui.core/Control",e),doc:k(l),since:l.attr("since")||null,deprecation:m(l)});});});return a;}
function f(D,e){var $=q(D.documentElement);var a={metatype:'type',doc:undefined,deprecation:false,values:{}};a.doc=k($);a.deprecation=m($);j($,"enumeration/value",function(b){var n=b.attr("name");a.values[n]={value:b.attr("value")||n,doc:k(b),deprecation:m(b)};});a.pattern=$.children("pattern").text();a.baseType=d($.children("baseType").text(),e);return a;}
function h(D,e,M){return c.analyze(D,e,M);}
function j($,N,a){q.each(N.split("/"),function(i,n){$=$.children(n);});$.each(function(i,e){a(q(e));});}
function k($){return $.children("documentation").text();}
function m($){return $.children("deprecation").text();}
function o(n,t,D,P,e){var a;q.ajax({async:false,url:q.sap.getModulePath(n,t),dataType:D,success:function(R){a=P(R,e,n.replace(/\./g,'/'));},error:function(b){q.sap.log.debug("tried to load entity docu for: "+n+t);}});return a;}
function s(e,t){var b=!t||t==="control";var T=!t||t==="type";var P=g(e);var a;if(!a&&!P.__noAPIJson){a=A.getEntityInfo(e);if(a){P.__noSource=true;P.__noMetamodel=true;}}else if(P.__noAPIJson){q.sap.log.debug("ancestor package for "+e+" is marked with 'noMetamodel'");}if(!a&&!P.__noMetamodel){if(!a&&b){a=o(e,".control","xml",p,e);}if(!a&&T){a=o(e,".type","xml",f,e);}if(a){P.__noSource=true;}}else if(P.__noMetamodel){q.sap.log.debug("ancestor package for "+e+" is marked with 'noMetamodel'");}if(!a&&!P.noSource){if(!a&&T){var l=e.replace(/\.[^.]+$/,".library");a=o(l,".js","text",h,e);}if(!a){a=o(e,".js","text",h,e);}if(a){P.__noMetamodel=true;}}else if(P.__noSource){q.sap.log.debug("ancestor package for "+e+" is marked with 'noSource'");}return a;}
var E={getEntityDocu:function(e,t,R){function i(a,b){for(var n in b){if(b.hasOwnProperty(n)&&!a.hasOwnProperty(n)){a[n]=b[n];}}}var l=s(e,t);if(R){var D=l;while(D&&D.baseType){D=s(D.baseType,D.metatype);if(D){i(l.properties,D.properties);i(l.aggregations,D.aggregations);i(l.associations,D.assocations);i(l.events,D.events);i(l.methods,D.methods);}}}return l;}};return E;},true);
sap.ui.predefine('sap/ui/demokit/FeedbackClient',['jquery.sap.global','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/layout/HorizontalLayout','sap/ui/layout/VerticalLayout','sap/ui/layout/form/SimpleForm','sap/ui/layout/form/SimpleFormLayout','sap/ui/commons/Button','sap/ui/commons/CheckBox','sap/ui/commons/FormattedTextView','sap/ui/commons/Label','sap/ui/commons/Link','sap/ui/commons/SegmentedButton','sap/ui/commons/TextArea','sap/ui/commons/TextView','sap/ui/ux3/ToolPopup'],function(q,I,c,H,V,S,a,B,C,F,L,b,d,T,e,f){"use strict";var g=c.ValueState;var h=function(){};
h.prototype.updateFeedbackContextText=function(){if(this._oIncludeFeedbackContextCB.getChecked()){u.call(this);}else{i.call(this);}function u(){this._oFeedbackContextText.setText("Location: "+this._getCurrentPageRelativeURL()+"\n"+this._getUI5Distribution()+" Version: "+sap.ui.getVersionInfo().version);}function i(){this._oFeedbackContextText.setText(this._getUI5Distribution()+" Version: "+sap.ui.getVersionInfo().version);}};
h.prototype._getUI5Distribution=function(){var v=sap.ui.getVersionInfo();var u="SAPUI5";if(v&&v.gav&&/openui5/i.test(v.gav)){u="OpenUI5";}return u;};
h.prototype._getCurrentPageRelativeURL=function(){var p=window.location;return p.pathname+p.hash+p.search;};
h.prototype.createFeedbackPopup=function(){this._oFeedbackContextText=new e("oFeedbackContextText");this._oIncludeFeedbackContextCB=new C("includePageCB");var t=this;var o=q.sap.loadResource('sap/ui/demokit/configuration/properties.json');var s=o["FeedbackServiceURL"];var i='Describe what you like or what needs to be improved. You can share your feedback for the overall Demokit experience or for the specific page you are currently viewing.';var j,k,l,m,r,n,p,u,v,w;function x(Q){z();Q.addContent(v);j.removeAllContent();j.addContent(Q);}function y(){j.setBusyIndicatorDelay(0);j.setBusy(true);p.setValueState(g.None);p.setPlaceholder(i);}function z(){j.setBusy(false);m.setText("");n.setSelectedButton();p.setValue('');t._oIncludeFeedbackContextCB.setChecked(false);t._oIncludeFeedbackContextCB.fireChange();t._oFeedbackContextText.setVisible(false);u.setText("Show context data");u.setTooltip("Show context data");w.setEnabled(false);}function A(){I.addIcon("icon-face-very-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E086",suppressMirroring:true});I.addIcon("icon-face-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E087",suppressMirroring:true});I.addIcon("icon-face-neutral","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E089",suppressMirroring:true});I.addIcon("icon-face-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08B",suppressMirroring:true});I.addIcon("icon-face-very-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08C",suppressMirroring:true});}function D(){var R=new F("feedbackRateYourExperienceLabel");R.setHtmlText("<span class='feedbackAsterisk'>*</span>Rate your experience:");m=new L("feedbackRatingLabel",{});return new H('feedbackRatingHeader',{content:[R,m]});}function E(){A();n=new d({id:"feedbackRatingButton",buttons:[Q("icon-face-very-bad","Very Poor",1),Q("icon-face-bad","Poor",2),Q("icon-face-neutral","Average",3),Q("icon-face-happy","Good",4),Q("icon-face-very-happy","Excellent",5)]});function Q(U,W,X){var Y="sap-icon://FeedbackRatingFaces/"+U;return new B({icon:Y,width:"20%",press:R.bind(this,W,X)});}function R(U,W){m.setText(U);r=W;w.setEnabled(true);}return n;}function G(){p=new T("demokitFeedbackInput",{rows:13});p.setPlaceholder(i);return p;}function J(){t._oIncludeFeedbackContextCB.setText('Feedback is related to the current page');t._oIncludeFeedbackContextCB.attachChange(t.updateFeedbackContextText.bind(t));u=new b("feedbackContextDataLink",{wrapping:"false",text:"Show context data",tooltip:"Show context data",press:function(){if(t._oFeedbackContextText.getVisible()===false){u.setText("Hide context data");u.setTooltip("Hide context data");t._oFeedbackContextText.setVisible(true);}else{u.setText("Show context data");u.setTooltip("Show context data");t._oFeedbackContextText.setVisible(false);}}});return new H("feedbackContextButtons",{content:[t._oIncludeFeedbackContextCB,u]});}function K(){t._oFeedbackContextText.addStyleClass("feedbackContextData");t._oFeedbackContextText.setVisible(false);t.updateFeedbackContextText();return t._oFeedbackContextText;}function M(){var Q=new b({text:"Privacy",tooltip:"Privacy",target:"_blank",href:"https://help.hana.ondemand.com/privacy.htm"});var R=new b({text:"Terms of Use",tooltip:"Terms of Use",target:"_blank",href:"https://help.hana.ondemand.com/terms_of_use.html"});var U=new b({text:"Legal Agreement",tooltip:"Legal Agreement",target:"_blank",href:"./legal_agreement_with_privacy.html"});var W=new F();var X='Your feedback is anonymous, we do not collect any personal data. For more information see <embed data-index=\"0\">, <embed data-index=\"1\"> & <embed data-index=\"2\">.';W.addStyleClass("feedbackLicenseText");W.setHtmlText(X);W.addControl(Q);W.addControl(R);W.addControl(U);return W;}function N(){var Q=new B({text:"Cancel",tooltip:"Cancel",press:function(){z();j.close();}});v=new B('closeBtn',{text:"Close",tooltip:"Close",press:function(){j.close();}});w=new B('sendBtn',{text:"Send",tooltip:"Send feedback",enabled:false,press:function(){var R={};if(t._oIncludeFeedbackContextCB.getChecked()){R={"texts":{"t1":p.getValue()},"ratings":{"r1":{"value":r}},"context":{"page":t._getCurrentPageRelativeURL(),"attr1":t._getUI5Distribution()+":"+sap.ui.version}};}else{R={"texts":{"t1":p.getValue()},"ratings":{"r1":{"value":r}},"context":{"attr1":t._getUI5Distribution()+":"+sap.ui.version}};}y();q.ajax({url:s,type:"POST",contentType:"application/json",data:JSON.stringify(R)}).done(function(){x(k);}).fail(function(){x(l);});}});k=new V({content:[new F('successMsg',{htmlText:'<h4>Your feedback was sent successfully.</h4>'})]});l=new V({content:[new F('errorMsg',{htmlText:'<h4>Your feedback was not sent.</h4>'})]});return new H('feedbackButtons',{content:[w,Q]});}var O=new S({maxContainerCols:1,width:'400px',editable:true,layout:a.ResponsiveGridLayout,content:[new L({text:'Send us your feedback!'}),D(),E(),G(),J(),K(),M(),N()]});var P="theme/img/themeswitch_";j=new f('feedBackPopup',{icon:'sap-icon://comment',iconHover:P+'hover.png',iconSelected:P+'selected.png',content:[O],defaultButton:w,closed:function(){this.removeAllContent();this.addContent(O);}});j.setTooltip("Send us your feedback!");return j;};
return h;});
sap.ui.predefine('sap/ui/demokit/FileUploadIntrospector',['jquery.sap.global','sap/ui/core/Control','./library','jquery.sap.act'],function(q,C,l){"use strict";
var F=C.extend("sap.ui.demokit.FileUploadIntrospector",{metadata:{library:"sap.ui.demokit",properties:{uploadUrl:{type:"string",group:"Misc",defaultValue:null},autoRefreshInterval:{type:"string",group:"Misc",defaultValue:'0'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null}}}});
F.prototype.init=function(){this._aFiles=[];this._iHash=0;q.sap.act.attachActivate(this._activate,this);};
F.prototype.exit=function(){q.sap.act.detachActivate(this._activate,this);};
F.prototype._activate=function(){this.setAutoRefreshInterval(this.getAutoRefreshInterval());};
F.prototype.setAutoRefreshInterval=function(i){this.setProperty("autoRefreshInterval",i);if(this.oTimer){q.sap.clearDelayedCall(this.oTimer);this.oTimer=undefined;}if(i>0){this.oTimer=q.sap.delayedCall(i,this,"_autoRefresh");}};
F.prototype.refresh=function(){var t=this;q.getJSON(this.getUploadUrl(),function(d){t._receiveFileList(d);});};
F.prototype._autoRefresh=function(){if(this.oTimer){q.sap.clearDelayedCall(this.oTimer);this.oTimer=undefined;}this.refresh();var i=this.getAutoRefreshInterval();if(i>0&&q.sap.act.isActive()){this.oTimer=q.sap.delayedCall(i,this,"_autoRefresh");}};
F.prototype._receiveFileList=function(r){if(!this._aFiles||this._iHash!==r.hash){this._aFiles=r.files;this._iHash=r.hash;this.invalidate();}};
return F;});
sap.ui.predefine('sap/ui/demokit/FileUploadIntrospectorRenderer',function(){"use strict";var F={};
F.render=function(r,c){var a=r;function f(d){var D=new Date(d),m=(D.getMonth()+1)<10?"0"+(D.getMonth()+1):""+(D.getMonth()+1),y=D.getFullYear()<10?"0"+D.getFullYear():""+D.getFullYear(),s=D.getDate()<10?"0"+D.getDate():""+D.getDate(),h=D.getHours()<10?"0"+D.getHours():""+D.getHours(),M=D.getMinutes()<10?"0"+D.getMinutes():""+D.getMinutes(),S=D.getSeconds()<10?"0"+D.getSeconds():""+D.getSeconds();return y+"-"+m+"-"+s+" "+h+":"+M+":"+S;}a.write("<div");a.writeControlData(c);a.write(" class='sapUiDkitFileList'");if(c.getWidth()){a.addStyle("width",c.getWidth());}a.writeStyles();a.write(">");var b=c._aFiles||[];a.write("<div");if(c.getHeight()){a.addStyle("height",c.getHeight());a.addStyle("overflow-y","auto");}a.writeStyles();a.write(">");a.write("<table border='0'>");a.write("<tr class='sapUiDkitFileItem'>");a.write("<th>Filename</th>");a.write("<th>Date</th>");a.write("<th>Size</th>");a.write("</tr>");for(var i=0;i<b.length;i++){a.write("<tr class='sapUiDkitFileItem'>");a.write("<td style='padding:1px 3px;'><span style='white-space:nowrap'>"+b[i].name+"</span></td>");a.write("<td style='border-left:1px solid #ccc;padding:1px 3px;width:12ex'><span style='white-space:nowrap'>"+f(b[i].time)+"</span></td>");a.write("<td style='border-left:1px solid #ccc;padding:1px 3px;width:8ex;text-align:right'><span style='white-space:nowrap'>"+b[i].size+"</span></td>");a.write("</tr>");}a.write("</table>");a.write("</div>");a.write("<div class='sapUiDkitBottomLine'>");a.write("Last Refresh: "+(f(new Date().getTime())));a.write("</div>");a.write("</div>");};
return F;},true);
sap.ui.predefine('sap/ui/demokit/HexagonButton',['sap/ui/core/Control','./library'],function(C,l){"use strict";
var H=C.extend("sap.ui.demokit.HexagonButton",{metadata:{library:"sap.ui.demokit",properties:{icon:{type:"string",group:"Misc",defaultValue:null},color:{type:"string",group:"Misc",defaultValue:'blue'},position:{type:"string",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Misc",defaultValue:true},imagePosition:{type:"string",group:"Misc",defaultValue:null}},events:{press:{}}}});
H.prototype.onclick=function(b){if(this.getEnabled()){this.firePress({id:this.getId()});}b.preventDefault();b.stopPropagation();};
H.prototype._attachPress=H.prototype.attachPress;
H.prototype.attachPress=function(){this._attachPress.apply(this,arguments);this.invalidate();};
H.prototype._detachPress=H.prototype.detachPress;
H.prototype.detachPress=function(){this._detachPress.apply(this,arguments);this.invalidate();};
return H;});
sap.ui.predefine('sap/ui/demokit/HexagonButtonGroup',['sap/ui/core/Control','./library'],function(C,l){"use strict";
var H=C.extend("sap.ui.demokit.HexagonButtonGroup",{metadata:{library:"sap.ui.demokit",properties:{colspan:{type:"int",group:"Misc",defaultValue:3}},aggregations:{buttons:{type:"sap.ui.demokit.HexagonButton",multiple:true,singularName:"button"}}}});
return H;});
sap.ui.predefine('sap/ui/demokit/HexagonButtonGroupRenderer',function(){"use strict";var H={};
H.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.writeAttribute("class","sapUiHexGroup");a.write(">");var C=c.getColspan();var b=c.getButtons();for(var i=0;i<b.length;i++){var d=i%C;var e=Math.floor(i/C);if(d<Math.floor(C/2)){d=1+2*d;}else{d=2*(d-Math.floor(C/2));}var x=100+90*d;var y=100+100*e+100-50*(d%2);var B=b[i];B.setPosition("position:absolute;left:"+x+"px;top:"+y+"px;");r.renderControl(B);}a.write("</div>");};
return H;},true);
sap.ui.predefine('sap/ui/demokit/HexagonButtonRenderer',['jquery.sap.global','jquery.sap.encoder'],function(q){"use strict";var H={};
H.render=function(r,c){var a=r;a.write("<div ");a.writeControlData(c);a.addClass("sapUiHexBtn");a.addClass("sapUiHexBtn"+q.sap.encodeHTML(c.getEnabled()?c.getColor():"Gray"));if(c.getEnabled()&&c.hasListeners('press')){a.addClass("sapUiHexBtnActive");}a.writeClasses();a.write(" style='"+q.sap.encodeHTML(c.getPosition())+"'");if(c.getTooltip_AsString()){a.writeAttributeEscaped("title",c.getTooltip_AsString());}a.write(">");if(c.getIcon()){a.write("<IMG ");a.writeAttributeEscaped("src",c.getIcon());var i=c.getImagePosition();if(i){a.write(" style='"+q.sap.encodeHTML(i)+"'");}else{a.write(" style='position:relative;left:40px;top:45px;'");}a.write(" border='0'");a.write("/>");}a.write("</div>");};
return H;},true);
sap.ui.predefine('sap/ui/demokit/IndexLayout',['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/IntervalTrigger','./library'],function(q,D,C,I,l){"use strict";
var a=C.extend("sap.ui.demokit.IndexLayout",{metadata:{library:"sap.ui.demokit",properties:{itemWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'200px'},itemHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'200px'},enableScaling:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
a._MINMARGIN=18;a._DEFAULT_ITEM_HEIGHT=200;a._DEFAULT_ITEM_WIDTH=200;a._pos=null;(function(){a._IntervalTrigger=new I(300);
a.prototype.init=function(){this._itemWidth=a._DEFAULT_ITEM_WIDTH;this._itemHeight=a._DEFAULT_ITEM_HEIGHT;this._tilesPerRow;this._width;this._registered=false;this._itemScaleFactor=1;D.media.attachHandler(s,this,D.media.RANGESETS.SAP_STANDARD);};
a.prototype.exit=function(){this.onBeforeRendering();D.media.detachHandler(s,this,D.media.RANGESETS.SAP_STANDARD);};
a.prototype.setItemWidth=function(i){this.setProperty("itemWidth",i,true);if(!i||i.indexOf("px")<0){this._itemWidth=a._DEFAULT_ITEM_WIDTH;this.setProperty("itemWidth",this._itemWidth,true);}else{this._itemWidth=parseInt(i,10);}_(this);return this;};
a.prototype.setItemHeight=function(i){this.setProperty("itemHeight",i,true);if(!i||i.indexOf("px")<0){this._itemHeight=a._DEFAULT_ITEM_HEIGHT;this.setProperty("itemHeight",this._itemHeight,true);}else{this._itemHeight=parseInt(i,10);}_(this);return this;};
a.prototype.setEnableScaling=function(e){this.setProperty("enableScaling",e,true);_(this);return this;};
a.prototype.onBeforeRendering=function(){if(this._registered){a._IntervalTrigger.removeListener(r,this);this._registered=false;}var m=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD);s.apply(this,[m,true]);};
a.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};
a.prototype.onAfterRendering=function(){if(!a._pos){var t=null;var S=this.getDomRef().style;if("webkitTransform"in S){t="-webkit-transform";}else if("transform"in S){t="transform";}else if("msTransform"in S){t="-ms-transform";}else if("MozTransform"in S){t="-moz-transform";}if(t){a._pos=function($,x,y){$.css(t,"translate("+x+"px,"+y+"px)");};}else{a._pos=function($,x,y){$.css({top:y+"px",left:x+"px"});};}}if(!this._registered){a._IntervalTrigger.addListener(r,this);this._registered=true;}this.$().toggleClass("sapDkIdxLayoutHidden",false);};
a.prototype._scale=function(v){if(!this.getEnableScaling()){return v;}return Math.floor(v*this._itemScaleFactor);};
function _(L,n){r.apply(L,[!n]);}
function r(i){if(!this.getDomRef()){this.onBeforeRendering();return;}i=i||!this._registered;var L=this.$(),w=L.outerWidth(),h=L.outerHeight(),b=this._height!=h;if(this._width===w&&!b&&!i){return;}this._width=w;this._height=h;var c=this.getContent().length,d=this._scale(this._itemWidth),e=this._scale(this._itemHeight),t=g(this._width,c,d),f=this._tilesPerRow!=t;this._tilesPerRow=t;if(!i){L.toggleClass("sapDkIdxLayoutAnim",true);}if(!f&&!i&&!b){return;}var j=0,k=0;this.$("cntnt").css({"padding-left":a._MINMARGIN+"px","width":(t*d+a._MINMARGIN*2)+"px","height":Math.ceil(c/t)*e}).children().each(function(m){if(m>0&&m%t===0){j=j+e;k=0;}a._pos(q(this),k,j);k=k+d;});if(i){L.css({"padding-top":a._MINMARGIN+"px","padding-bottom":a._MINMARGIN+"px"});}}
function g(b,c,d){var t=Math.min(Math.floor((b-2*a._MINMARGIN)/d),c);var e=c%t;if(e==0||c<=t){return t;}function f(x){var n=c%x;return(t-x)*Math.floor(c/x)+(n!=0?(t-n):0);}var h=f(t);var j=[t];var i;for(i=t-1;i>=1;i--){var w=f(i);if(w<h){j=[i];h=w;}else if(w==h){j.push(i);}}for(i=0;i<j.length;i++){var m=c%j[i];if(m==0){return j[i];}else if(i==0||m>h){h=m;t=j[i];}}return t;}
function s(m,S){switch(m.name){case"Tablet":this._itemScaleFactor=0.75;break;case"Phone":this._itemScaleFactor=0.5;break;default:this._itemScaleFactor=1;}if(!this.getDomRef()||S){return;}var w=this._scale(this._itemWidth);var h=this._scale(this._itemHeight);this.$("cntnt").children().each(function(){q(this).css({width:w,height:h});});_(this);}
C.extend("sap.ui.demokit.IndexLayout._Tile",{
metadata:{properties:{"title":"string","description":"string","target":"string","icon":"sap.ui.core.URI","href":"sap.ui.core.URI"},events:{"press":{}}},
onclick:function(e){if(!this.getHref()){this.firePress();e.preventDefault();}},
renderer:function(R,c){R.write("<a");R.addClass("sapDkIdxLayout_Tile");R.writeClasses();R.writeControlData(c);if(c.getHref()){R.writeAttributeEscaped("href",c.getHref());if(c.getTarget()){R.writeAttributeEscaped("target",c.getTarget());}}else{R.writeAttribute("href","#");}R.writeAttributeEscaped("title",c.getDescription());R.write(">");R.write("<span class='sapDkIdxLayout_TileIcon'>");R.writeIcon(c.getIcon());R.write("</span>");R.write("<span class='sapDkIdxLayout_TileLabel'");R.writeAttributeEscaped("title",c.getTitle());R.write(">");R.writeEscaped(c.getTitle());R.write("</span>");R.write("<span class='sapDkIdxLayout_TileDesc'");R.writeAttributeEscaped("title",c.getDescription());R.write(">");R.writeEscaped(c.getDescription());R.write("</span>");R.write("</a>");}
});
})();return a;});
sap.ui.predefine('sap/ui/demokit/IndexLayoutPage',['jquery.sap.global','sap/ui/core/IconPool','./IndexLayout','sap/ui/model/json/JSONModel','sap/ui/core/Control','sap/ui/core/Element','jquery.sap.encoder'],function(q,I,a,J,C,E){"use strict";var b=function IndexPage(d,t,B,c){var m=new J(d);sap.ui.getCore().setModel(m);var o=new b.Repeat({categories:{path:"/categories",template:new b.Cat({title:"{text}",layout:new a({enableScaling:true,content:{path:"links",template:new a._Tile({title:"{text}",description:"{desc}",target:t,icon:{path:"icon",formatter:function(i){if(!i){i="learning-assistant";}return"sap-icon://"+i;}},href:"{ref}"})}})})}});if(c){I.addIcon("explored","custom","brandico","e001",true);I.addIcon("cart","custom","brandico","e002",true);I.addIcon("makit","custom","brandico","e005",true);I.addIcon("helloworld","custom","brandico","e003",true);I.addIcon("poa","custom","brandico","e007",true);I.addIcon("flexbox","custom","brandico","e00A",true);I.addIcon("crud","custom","brandico","e009",true);I.addIcon("icon-explorer","custom","brandico","e006",true);I.addIcon("splitapp","custom","brandico","e00C",true);I.addIcon("mvc","custom","brandico","e00B",true);}sap.ui.getCore().attachInit(function(){if(c){var f=q.sap.getModulePath("","/../test-resources/sap/m/demokit/demokit-home/");b._introduceCustomFont("brandico",f,"demoAppsIconFont");}q("body").append("<div id='root'></div>");o.placeAt("root");});};
E.extend("sap.ui.demokit.IndexLayoutPage.Cat",{metadata:{properties:{"title":"string"},aggregations:{"layout":{type:"sap.ui.demokit.IndexLayout",multiple:false}}}});
C.extend("sap.ui.demokit.IndexLayoutPage.Repeat",{
metadata:{aggregations:{"categories":{type:"sap.ui.demokit.IndexLayoutPage.Cat",multiple:true}}},
renderer:function(r,c){r.write("<div");r.writeControlData(c);r.write(">");var d=c.getCategories();for(var i=0;i<d.length;i++){r.write("<div");r.writeElementData(d[i]);r.write(">");if(d[i].getTitle()){r.write("<h2>");r.writeEscaped(d[i].getTitle());r.write("</h2>");}r.renderControl(d[i].getLayout());r.write("</div>");}r.write("</div>");}
});
b._introduceCustomFont=function(f,F,s){var c="@font-face {"+"font-family: '"+f+"';"+"src: url('"+F+s+".eot');"+"src: url('"+F+s+".eot?#iefix') format('embedded-opentype'), url('"+F+s+".ttf') format('truetype');"+"font-weight: normal;"+"font-style: normal;"+"}";q('head').append('<style type="text/css">'+c+'</style>');};
return b;},true);
sap.ui.predefine('sap/ui/demokit/IndexLayoutRenderer',[],function(){"use strict";var I={};
I.render=function(r,l){var a=l.getId();r.write("<div");r.writeControlData(l);r.addClass("sapDkIdxLayout");r.addClass("sapDkIdxLayoutHidden");if(l.getEnableScaling()){r.addClass("sapDkIdxLayoutScale");}r.writeClasses();r.write("><div id=\"",a,"-cntnt\">");var c=l.getContent();for(var i=0;i<c.length;i++){r.write("<div class=\"sapDkIdxLayoutItem\" style=\"width:",l._scale(l._itemWidth),"px;height:",l._scale(l._itemHeight),"px;\"><div>");r.renderControl(c[i]);r.write("</div></div>");}r.write("</div></div>");};
return I;},true);
sap.ui.predefine('sap/ui/demokit/IndexPage',['jquery.sap.global','sap/ui/commons/RichTooltip','./DemokitApp','./HexagonButton','./HexagonButtonGroup'],function(q,R,D,H,a){"use strict";var I=function(c){var d=D.getInstance(),h=3,C;function b(s,n){return s.split('/').slice(-n-1).join('/');}this.oDemokit=d;this.sPathToRoot=b("../../../../../../../",h);this.sRootUrl=window.location.pathname.split('/').slice(-h-1,-1).join('/')+'/';this.sColor="Blue";this.oHexGroup=new a({colspan:(C||5)});if(c&&d){var p=d.getPagesForCategory(c);for(var i=0;i<p.length;i++){this.add(true,p[i].text,'',this.sPathToRoot+p[i].ico,undefined,p[i].ref);}}};
I.prototype.add=function add(e,c,t,i,l,r){var b=this,B;if(typeof e!=="boolean"){r=l;l=i;i=t;t=c;c=e;e=true;}r=r||this.sRootUrl+c+'.html';if(!l){l="sap.ui.commons";}if(!t){if(e){t="A short tutorial that explains how to use the "+c+". Click to start it.";}else{t="Here you should find a tutorial for the "+c+". Unfortunately we didn't write it in time. Please hover back soon ;-)";}}B=new H({enabled:e,color:"Gray",tooltip:new R({title:c,imageSrc:i||(e?"":this.sPathToRoot+"theme/img/Under-construction.png"),text:t}),press:function(){b.oDemokit.navigateTo(r);}});if(i){B.setIcon(i);}this.oHexGroup.addButton(B);return this;};
I.prototype.placeAt=function(i){this.oHexGroup.placeAt(i);q(function(){if(q("#vistaico-license").size()==0){q("body").append('<div id="vistaico-license" class="license">Some icon(s) created by <a class="sapUiDemokitLink" href="http://VistaICO.com" target="_blank">VistaICO.com</a> and <a class="sapUiDemokitLink" href="http://www.iconarchive.com/artist/fatcow.html" target="_blank">Fatcow Web Hosting</a>,	used under Creative Commons 3.0 Attribution Unported license</div>');}});};
return I;},true);
sap.ui.predefine('sap/ui/demokit/SimpleTree',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/m/SearchField'],function(q,C,I,F,a,S){"use strict";
var b=C.extend("sap.ui.demokit.SimpleTree",{metadata:{library:"sap.ui.demokit",properties:{title:{type:"string",defaultValue:null},width:{type:"sap.ui.core.CSSSize",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",defaultValue:'auto'},showFilter:{type:"boolean",defaultValue:true},filterAttribute:{type:"string",defaultValue:'text'}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.demokit.SimpleTreeNode",multiple:true,singularName:"node",bindable:"bindable"},_searchField:{type:"sap.m.SearchField",multiple:false,visibility:"hidden"}}}});
b.prototype.init=function(){this._initializeSearchField();this._createNodesFocusHandling();};
b.prototype.expandAll=function(){var c=this.getNodes();for(var i=0;i<c.length;i++){c[i].expand(true);}};
b.prototype.collapseAll=function(){var c=this.getNodes();for(var i=0;i<c.length;i++){c[i].collapse(true);}};
b.prototype.isTreeBinding=function(n){return(n=="nodes");};
b.prototype.onAfterRendering=function(){var s=q(this.getDomRef()).find('.sapDkSimpleTreeNodeSelected'),n=this._itemNavigation.getItemDomRefs().indexOf(s.parent()[0]);this._initializeNodesFocusHandling();this.sSelectedNodeId=s.parent().attr('id');this._itemNavigation.setSelectedIndex(n);s.focus();};
b.prototype.exit=function(){this._destroyNodesFocusHandling();};
b.prototype._initializeSearchField=function(){var t=this;var s=this.getAggregation("_searchField");s=new S({selectOnFocus:false,showSearchButton:false,liveChange:function(e){_.call(t,e.getParameter("newValue"));}});s.addStyleClass("sapDkSimpleTreeSearchField");this.setAggregation("_searchField",s,true);function _(f){var c=[];var n=new F(this.getFilterAttribute(),a.Contains,f);c.push(n);var B=this.getBinding("nodes");B.filter(c);this.expandAll();}};
b.prototype._createNodesFocusHandling=function(){this._itemNavigation=new I();this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);};
b.prototype._initializeNodesFocusHandling=function(){this._itemNavigation.setRootDomRef(this.$().children("ul")[0]);this._itemNavigation.setItemDomRefs(this._getDomRefs());};
b.prototype._destroyNodesFocusHandling=function(){if(this._itemNavigation){this._itemNavigation.destroy();}};
b.prototype._getDomRefs=function(){var d=[];var n=this.getNodes();for(var i=0;i<n.length;i++){n[i]._getDomRefs(d);}return d;};
return b;});
sap.ui.predefine('sap/ui/demokit/SimpleTreeNode',['sap/ui/core/Element','sap/ui/core/Icon'],function(E,I){"use strict";
var S=E.extend("sap.ui.demokit.SimpleTreeNode",{metadata:{library:"sap.ui.demokit",properties:{text:{type:"string",defaultValue:null},ref:{type:"string",defaultValue:null},expanded:{type:"boolean",defaultValue:false},isSelected:{type:"boolean",defaultValue:false}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.demokit.SimpleTreeNode",multiple:true,singularName:"node",bindable:"bindable"},_iconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{selected:{}}}});
S.ANIMATION_DURATION=600;
S.prototype.init=function(){this._bIsRTL=sap.ui.getCore().getConfiguration().getRTL();var i=new I({useIconTooltip:false}).addStyleClass('sapDkSimpleTreeNodeIconCol');if(this._bIsRTL){i.setSrc("sap-icon://navigation-left-arrow");}else{i.setSrc("sap-icon://navigation-right-arrow");}this.setAggregation("_iconControl",i,true);};
S.prototype.expand=function(e){this._executeExpandCollapse(true,e);};
S.prototype.collapse=function(c){this._executeExpandCollapse(false,c);};
S.prototype.setExpanded=function(e){if(this.getExpanded()!==e){this.setProperty("expanded",e,false);this._toggleNodeArrow(e);}};
S.prototype._executeExpandCollapse=function(s,r){this._toggleNodeExpandedProperty(s);this._toggleNodeArrow(s);this._toggleDirectChildrenVisibility(this.$(),s);this._toggleNodeBottomBorder(this.$(),s);if(r){this._expandCollapseChildrenRecursively(s);}};
S.prototype._toggleNodeExpandedProperty=function(s){this.setProperty("expanded",false,true);if(s&&!this.getExpanded()&&this.getNodes().length>0){this.setProperty("expanded",true,true);}};
S.prototype._toggleNodeArrow=function(s){var i=this.getAggregation("_iconControl");if(s&&((i.getSrc().indexOf("navigation-right-arrow")>-1)||(i.getSrc().indexOf("navigation-left-arrow")>-1))){i.removeStyleClass("sapDkSimpleTreeNodeIconCol");i.addStyleClass("sapDkSimpleTreeNodeIconExp");i.setSrc("navigation-down-arrow");}else if(!s&&i.getSrc().indexOf("navigation-down-arrow")>-1){i.removeStyleClass("sapDkSimpleTreeNodeIconExp");i.addStyleClass("sapDkSimpleTreeNodeIconCol");if(this._bIsRTL){i.setSrc("navigation-left-arrow");}else{i.setSrc("navigation-right-arrow");}}};
S.prototype._toggleDirectChildrenVisibility=function(d,s){var l=d.children("ul");if((s&&l.hasClass("sapDkSimpleTreeHiddenChildrenNodes"))||(!s&&l.hasClass("sapDkSimpleTreeVisibleChildrenNodes"))){l.toggleClass("sapDkSimpleTreeHiddenChildrenNodes");l.toggleClass("sapDkSimpleTreeVisibleChildrenNodes");this._executeExpandCollapseAnimation(l,s);}if(!s&&d.children("a").last().attr("aria-expanded")==="true"){d.children("a").last().attr("aria-expanded","false");}else if(s&&this.getNodes().length>0){d.children("a").last().attr("aria-expanded","true");}};
S.prototype._executeExpandCollapseAnimation=function(d,s){if(s){d.css({display:'none'});d.show(S.ANIMATION_DURATION);}else{d.css({display:'block'});d.hide(S.ANIMATION_DURATION);}};
S.prototype._toggleNodeBottomBorder=function(d,s){if((s&&d.hasClass("sapDkSimpleTreeNodeFirstLvlRootCol"))||(!s&&d.hasClass("sapDkSimpleTreeNodeFirstLvlRootExp"))){d.toggleClass("sapDkSimpleTreeNodeFirstLvlRootCol sapDkSimpleTreeNodeFirstLvlRootExp");}};
S.prototype._expandCollapseChildrenRecursively=function(s){var c=this.getNodes();for(var i=0;i<c.length;i++){if(s){c[i].expand(true);}else{c[i].collapse(true);}}};
S.prototype._selectNode=function(s,e){if(!e.target.classList.contains("sapUiIcon")){this.fireSelected();this._refreshNodeSelection(this.$());}else if(s){this.expand();}else{this.collapse();}e.preventDefault();e.stopPropagation();};
S.prototype._refreshNodeSelection=function(d){var t=this._getTree();this._clearPreviousNodeSelection(t);this._setNodeSelection(d,t);};
S.prototype._getTree=function(){var p=this.getParent();while(p instanceof S){p=p.getParent();}return p;};
S.prototype._clearPreviousNodeSelection=function(t){if(t.sSelectedNodeId===null){return;}var p=sap.ui.getCore().byId(t.sSelectedNodeId);if(p){p.setProperty("isSelected",false,true);p.$().children("a").removeClass("sapDkSimpleTreeNodeSelected");p.$().children("a").removeAttr("aria-selected");}};
S.prototype._setNodeSelection=function(d,t){this.setProperty("isSelected",true,true);t.sSelectedNodeId=this.getId();d.children("a").last().addClass("sapDkSimpleTreeNodeSelected");d.children("a").last().attr("aria-selected","true");};
S.prototype.onclick=function(e){this._selectNode(!this.getExpanded(),e);};
S.prototype.ontap=function(e){e.preventDefault();};
S.prototype.onsapselect=function(e){this._selectNode(!this.getExpanded(),e);};
S.prototype.onsapleft=function(e){this._selectNode(this._bIsRTL?true:false,e);};
S.prototype.onsapright=function(e){this._selectNode(this._bIsRTL?false:true,e);};
S.prototype._getDomRefs=function(d){d.push(this.$().children("a")[0]);var n=this.getNodes();for(var i=0;i<n.length;i++){n[i]._getDomRefs(d);}};
return S;});
sap.ui.predefine('sap/ui/demokit/SimpleTreeRenderer',["jquery.sap.global","sap/ui/demokit/SimpleTreeNode","jquery.sap.encoder"],function(q,S){"use strict";var a={};
a.render=function(r,t){var b=r;var s=_(t.getNodes());c(s);d();if(t.getTitle()){e();}if(t.getShowFilter()&&t.getModel()){f();}g();h(t.getNodes());j();k();function _(n){if(!n){return null;}for(var i=0;i<n.length;i++){if(n[i].getIsSelected()){return n[i];}var C=n[i].getNodes();var l=_(C);if(l){return l;}}return null;}function c(n){if(n instanceof S){n.setExpanded(true);var N=n.getParent();c(N);}}function d(){b.write("<div");b.writeControlData(t);b.addClass("sapDkSimpleTree sapUiSizeCompact");b.writeClasses();b.addStyle("width",t.getWidth()||"auto");b.addStyle("height",t.getHeight()||"auto");b.writeStyles();b.writeAttribute("role","tree");b.write(">");}function e(){b.write("<div");b.addClass("sapDkSimpleTreeTitle");b.writeClasses();b.writeAttribute("role","heading");b.write(">");b.writeEscaped(t.getTitle());b.write("</div>");}function f(){b.renderControl(t.getAggregation("_searchField"));}function g(){b.write("<ul");b.addClass("sapDkSimpleTreeRootList");b.writeClasses();b.write(">");}function h(n){for(var i=0;i<n.length;i++){a.renderNode(b,n[i],n.length,i);}}function j(){b.write("</ul>");}function k(){b.write("</div>");}};
a.renderNode=function(r,t,R,b){var B=7;var N=15;var c=0;_(t,c,R,b);function _(n,h,s,j){d(n,h,s,j);var C=n.getNodes();if(C&&C.length>0){h++;f(n.getExpanded());for(var i=0;i<C.length;i++){_(C[i],h,C.length,i);}h--;g();}e(n);}function d(n,i,s,h){var j=n.getNodes(),H=(j&&j.length>0);r.write("<li");r.writeElementData(n);r.addClass("sapDkSimpleTreeNode");if(i===0){if(n.getExpanded()){r.addClass("sapDkSimpleTreeNodeFirstLvlRootExp");}else if(H){r.addClass("sapDkSimpleTreeNodeFirstLvlRootCol");}}r.writeClasses();r.write(">");r.write("<a href=\""+q.sap.encodeHTML(n.getRef()||"")+"\"");var I=sap.ui.getCore().getConfiguration().getRTL();r.addStyle(I?"padding-right":"padding-left",((i*N)+B)+"px");r.writeStyles();r.writeAttribute("tabindex","-1");if(n.getIsSelected()){r.addClass("sapDkSimpleTreeNodeSelected");}if(i===0){r.addClass("sapDkSimpleTreeNodeFirstLvl");}r.writeClasses();var p={role:'treeitem',level:i+1,setsize:s,posinset:h+1};if(n.getExpanded()){p["expanded"]=true;}else if(H){p["expanded"]=false;}r.writeAccessibilityState(n,p);r.write(">");if(H){r.renderControl(n.getAggregation("_iconControl"));}else{r.write("<span");r.addClass("sapDkSimpleTreeNodeNoChildren");r.writeClasses();r.write(">");r.write("</span>");}r.write("<span");r.addClass("sapDkSimpleTreeNodeLabel");r.writeClasses();r.write(">");r.writeEscaped(n.getText());r.write("</span>");r.write("</a>");}function e(){r.write("</li>");}function f(i){r.write("<ul");if(i){r.addClass("sapDkSimpleTreeVisibleChildrenNodes");}else{r.addClass("sapDkSimpleTreeHiddenChildrenNodes");}r.writeClasses();r.write(">");}function g(){r.write("</ul>");}};
return a;},true);
sap.ui.predefine('sap/ui/demokit/Tag',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var T=E.extend("sap.ui.demokit.Tag",{metadata:{library:"sap.ui.demokit",properties:{text:{type:"string",group:"Misc",defaultValue:null},weight:{type:"int",group:"Misc",defaultValue:1}}}});
T.prototype.onclick=function(e){this.oParent.firePressEvent(this);};
return T;});
sap.ui.predefine('sap/ui/demokit/TagCloud',['sap/ui/core/Control','./library'],function(C,l){"use strict";
var T=C.extend("sap.ui.demokit.TagCloud",{metadata:{library:"sap.ui.demokit",properties:{maxFontSize:{type:"int",group:"Misc",defaultValue:30},minFontSize:{type:"int",group:"Misc",defaultValue:10}},defaultAggregation:"tags",aggregations:{tags:{type:"sap.ui.demokit.Tag",multiple:true,singularName:"tag"}},events:{press:{parameters:{tagId:{type:"string"}}}}}});
T.prototype.firePressEvent=function(t){this.firePress({tagId:t.getId()});};
return T;});
sap.ui.predefine('sap/ui/demokit/TagCloudRenderer',function(){"use strict";var T={};
T.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiTagCloud");a.writeClasses();a.write(">");var t=c.getTags();if(!t||!t.length){return;}var f=c.getMinFontSize(),b=c.getMaxFontSize()-f,d=this.computeWeightRange(t),e=d.min,g=d.max-e;var h=g===0?function(w){return f;}:function(w){return f+(w-e)/g*b;};for(var i=0;i<t.length;i++){var j=t[i];a.write("<span");a.writeElementData(j);a.writeAttribute("class","sapUiTagCloudTextNormal");if(j.getTooltip_AsString()){a.writeAttributeEscaped("title",j.getTooltip_AsString());}a.writeAttribute("style","font-size:"+h(j.getWeight())+"px;");a.write(">");a.writeEscaped(j.getText());a.write("</span>");}a.write("</div>");};
T.computeWeightRange=function(t){var m=t[0].getWeight(),a=m;for(var i=1;i<t.length;i++){var w=t[i].getWeight();if(w>a){a=w;}if(w<m){m=w;}}return{min:m,max:a};};
return T;},true);
sap.ui.predefine('sap/ui/demokit/UI5EntityCueCard',['jquery.sap.global','sap/ui/core/Control','sap/ui/commons/Link','./EntityInfo','./library'],function(q,C,L,E,l){"use strict";
var U=C.extend("sap.ui.demokit.UI5EntityCueCard",{metadata:{library:"sap.ui.demokit",properties:{collapsible:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:false},navigable:{type:"boolean",group:"Misc",defaultValue:false},entityName:{type:"string",group:"Misc",defaultValue:null},style:{type:"sap.ui.demokit.UI5EntityCueCardStyle",group:"Misc",defaultValue:null}},events:{navigate:{allowPreventDefault:true,parameters:{entityName:{type:"string"}}}}}});
U.prototype.init=function(){this._oShowCueCardLink=new L({text:"Show All Settings",press:[this._toggleExpanded,this]});this._oShowCueCardLink.setParent(this);this._aHistory=[];this._iHistory=-1;};
U.prototype.setEntityName=function(e){if(e!==this.getEntityName()){this.setProperty("entityName",e);this._aHistory[++this._iHistory]=e;this._aHistory.length=this._iHistory+1;}};
U.prototype.back=function(){if(this._iHistory>0){this.setProperty("entityName",this._aHistory[--this._iHistory]);}};
U.prototype.forward=function(){if(this._iHistory+1<this._aHistory.length){this.setProperty("entityName",this._aHistory[++this._iHistory]);}};
U.prototype.setExpanded=function(e){this.setProperty("expanded",e);this._oShowCueCardLink&&this._oShowCueCardLink.setText(this.getExpanded()?"Hide Settings":"Show All Settings");};
U.prototype.onclick=function(e){if(this.getNavigable()){var s=q(e.target).attr("data-sap-ui-entity");if(s&&this.fireNavigate({entityName:s})){this.setEntityName(s);}}};
U.prototype._toggleExpanded=function(){this.setExpanded(!this.getExpanded());};
U.prototype._getDoc=function(){var n=this.getEntityName();return E.getEntityDocu(n);};
U.createDialog=function(){return new Promise(function(r,a){sap.ui.require(['sap/ui/commons/Button','sap/ui/commons/Dialog','sap/ui/commons/Toolbar'],function(B,D,T){var c=new U({collapsible:false,expanded:true,navigable:true});var d=new D({title:"Cue Card",minWidth:"200px",minHeight:"200px",maxWidth:"75%",maxHeight:"75%",content:[new T({standalone:false,items:[new B({text:"Back",press:function(){c.back();}}),new B({text:"Fwd",press:function(){c.forward();}})]}),c]});d.openForClass=function(s){c.setEntityName(s);this.rerender();this.open();};r(d);});});};
U.attachToContextMenu=function(n){var d;function a(){return d?Promise.resolve(d):U.createDialog().then(function(r){d=r;return r;});}q(n||window.document).bind("contextmenu.sapDkCueCd",function(e){if(e.shiftKey&&e.ctrlKey){var c=q(e.target).control(0);if(c&&(!d||!d.getDomRef()||(d.getDomRef()!==e.target&&!q.contains(d.getDomRef(),e.target)))){a().then(function(d){d.openForClass(c.getMetadata().getName());e.preventDefault();e.stopPropagation();});}}});};
U.detachFromContextMenu=function(n){q(n||window.document).unbind("contextmenu.sapDkCueCd");};
return U;});
sap.ui.predefine('sap/ui/demokit/UI5EntityCueCardRenderer',['jquery.sap.global','./library'],function(q,l){"use strict";var U={};
U.render=function(d,C){var N=C.getNavigable();var D=C.getStyle()==l.UI5EntityCueCardStyle.Demokit;function e(t){while(t.slice(-2)=="[]"){t=t.slice(0,-2);}if(t.indexOf("sap.ui.core.")==0){t=t.slice("sap.ui.core.".length);}return/^(any|boolean|float|int|object|string|void)$/.test(t);}d.write("<div");d.writeControlData(C);d.writeAttribute("class","sapDkCueCd");d.write(">");var f=0;function g(o){var r=[];for(var s in o){r.push(s);}r.sort(function(a,b){var k=o[a].deprecation?1:0;var p=o[b].deprecation?1:0;var c=k-p;if(c===0&&a!==b){c=a<b?-1:1;}return c;});return r;}function h(i){return" class='"+((i%2)?"sapDkCueCdOdd":"sapDkCueCdEven")+"'";}function m(k){if(k===0){return"Property of type ";}else if(k===1||k===2){return"Aggregation of type ";}else if(k===3||k===4){return"Association of type ";}else if(k===6){return"Event parameter of type ";}else if(k===7){return"Return value of type ";}else if(k===6){return"Method parameter of type ";}else{return"";}}function u(p,t,c){if(t){if(c==="0..n"){return u(p,t)+"[]";}var b=e(t);var s=q.sap.encodeHTML(t.split(".").slice(-1)[0]);var a=q.sap.encodeHTML(m(p.kind)+t);if(N&&(!D||!b)){return"<a class='sapDkLnk' id='"+C.getId()+"-l-"+(f++)+"' data-sap-ui-entity='"+t+"' title='"+a+"'>"+s+"</a>";}else{return"<span title='"+t+"'>"+s+"</span>";}}return'';}function v(o){return o.deprecation?" sapDkCueCdDeprct":"";}function w(o){return o.deprecation?"<br><i><b>Deprecated</b>: "+o.deprecation+"</i>":"";}function x(I){return I?" sapDkCueCdDfltAggr":"";}function y(I){return I?"<br><b>Note</b>: This is the default aggregation.":"";}if(!C.getCollapsible()||C.getExpanded()){var z=C._getDoc();if(z){var n,i,j,P;d.write("<table>");if(!D){d.write("<tr><td colspan='3' class='sapDkCueCdHd0",v(z),"'>",C.getEntityName(),"</td></tr>");d.write("<tr><td colspan='3' class='sapDkCueCdDoc'>",z.doc||'',w(z),"</td></tr>");}if(z.metatype==='control'){var A=q.extend({},z.properties,z.aggregations,z.associations);n=g(A);if(n.length>0){d.write("<tr><td colspan='3' class='sapDkCueCdHd'>","Properties, Aggregations, Associations","</td></tr>");for(i=0;i<n.length;i++){var B=A[n[i]];d.write("<tr",h(i),"><td class='sapDkCueCdName",v(B),x(n[i]===z.defaultAggregation),"'>",n[i],"</td>","<td class='sapDkCueCdType'>",u(B,B.type,B.cardinality),"</td>","<td class='sapDkCueCdDoc'>",B.doc,w(B),y(n[i]===z.defaultAggregation),"</td></tr>");}}n=g(z.events);if(n.length>0){d.write("<tr><td colspan='3' class='sapDkCueCdHd'>","Events","</td></tr>");for(i=0;i<n.length;i++){var E=z.events[n[i]];d.write("<tr",h(i),"><td class='sapDkCueCdName",v(E),"'>",n[i],"</td>","<td class='sapDkCueCdType'>","&nbsp","</td>","<td class='sapDkCueCdDoc'>",E.doc,w(E),"</td></tr>");var F=g(E.parameters);for(j=0;j<F.length;j++){var G=F[j];P=E.parameters[G];d.write("<tr",h(i),"><td class='sapDkCueCdSubName",v(P),"'>",G,"</td>","<td class='sapDkCueCdType'>",u(P,P.type),"</td>","<td class='sapDkCueCdDoc'>",P.doc,w(P),"</td></tr>");}}}n=g(z.methods);if(n.length>0){d.write("<tr><td colspan='3' class='sapDkCueCdHd'>","Methods","</td></tr>");for(i=0;i<n.length;i++){var M=z.methods[n[i]];if(M.synthetic){continue;}var H=n[i]+"(";for(j=0;j<M.parameters.length;j++){if(j>0){H+=",";}H+=M.parameters[j].name;}H+=")";d.write("<tr",h(i),"><td class='sapDkCueCdName",v(M),"' colspan='2'>",H,"</td>","<td class='sapDkCueCdDoc'>",M.doc,w(M),"</td></tr>");for(j=0;j<M.parameters.length;j++){P=M.parameters[j];d.write("<tr",h(i),"><td class='sapDkCueCdSubName",v(P),"'>",P.name,"</td>","<td class='sapDkCueCdType'>",u(P,P.type),"</td>","<td class='sapDkCueCdDoc'>",P.doc,w(P),"</td></tr>");}if(M.type!=="sap.ui.core/void"){d.write("<tr",h(i),"><td class='sapDkCueCdSubName'>","<i>returns</i>","</td>","<td class='sapDkCueCdType'>",u(M,M.type),"</td>","<td class='sapDkCueCdDoc'>","&nbsp;","</td></tr>");}}}}if(z.metatype==='type'){n=g(z.values);if(n.length>0){d.write("<tr><td colspan='3' class='sapDkCueCdHd",v(z),"'>","Values","</td></tr>");for(i=0;i<n.length;i++){var V=z.values[n[i]];d.write("<tr",h(i),"><td class='sapDkCueCdName",v(V),"'>",n[i],"</td>","<td class='sapDkCueCdType'>","&nbsp;","</td>","<td class='sapDkCueCdDoc'>",V.doc,w(V),"</td></tr>");}}if(z.pattern){d.write("<tr><td colspan='3' class='sapDkCueCdHd'>","Constraints","</td></tr>");d.write("<tr",h(i),"><td class='sapDkCueCdName'>","pattern","</td>","<td>","&nbsp;","</td>","<td class='sapDkCueCdDoc'>",z.pattern,"</td></tr>");}}d.write("</table>");}}if(C.getCollapsible()){d.renderControl(C._oShowCueCardLink);}d.write("</div>");};
return U;},true);
sap.ui.predefine('sap/ui/demokit/UIAreaSubstitute',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var U=E.extend("sap.ui.demokit.UIAreaSubstitute",{metadata:{library:"sap.ui.demokit",aggregatingType:"sap.ui.demokit.CodeSampleContainer",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
return U;});
sap.ui.predefine('sap/ui/demokit/demoapps/Component',['sap/ui/core/UIComponent','sap/ui/model/json/JSONModel','sap/ui/demokit/demoapps/model/libraryData'],function(U,J,l){"use strict";return U.extend("sap.ui.demokit.demoapps.Component",{metadata:{manifest:"json"},init:function(){U.prototype.init.apply(this,arguments);var m=new J();l.fillJSONModel(m);this.setModel(m);}});});
sap.ui.predefine('sap/ui/demokit/demoapps/controller/App.controller',["sap/ui/core/mvc/Controller","jquery.sap.global","sap/ui/demokit/demoapps/model/sourceFileDownloader","sap/ui/demokit/demoapps/model/formatter","sap/m/MessageBox","sap/m/MessageToast","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/library"],function(C,$,s,f,M,a,F,b){"use strict";return C.extend("sap.ui.demokit.demoapps.controller.App",{formatter:f,onDownloadButtonPress:function(e){var d=this.byId("downloadDialog");this._oDownloadButton=e.getSource();d.getBinding("items").filter([]);d.open();d._oDialog.setContentHeight("");},onSearch:function(e){e.getParameters().itemsBinding.filter([new F("name",b.Contains,e.getParameters().value)]);},onDownloadPress:function(e){var S=e.getParameters().selectedItem,l=S?S:e.getSource().getParent();this._oDownloadButton.setBusy(true);sap.ui.require(["sap/ui/core/util/File","sap/ui/thirdparty/jszip"],function(o){var z=new JSZip();$.getJSON(l.data("config"),function(c){var d=c.files,p=[],g=[];d.forEach(function(h){var P=s(c.cwd+h);P.then(function(i){if(i.errorMessage){g.push(i.errorMessage);}else{z.file(h,i,{base64:false,binary:true});}});p.push(P);});Promise.all(p).then(function(){if(g.length){var h=g.reduce(function(E,j){return E+j+"\n";},"Could not locate the following download files:\n");this._handleError(h);}this._oDownloadButton.setBusy(false);a.show("Downloading for app \""+l.getLabel()+"\" has been started");var i=z.generate({type:"blob"});this._createArchive(o,i,l.getLabel());}.bind(this));}.bind(this));}.bind(this));},createDemoAppRow:function(i,B){var o;if(!B.getObject().categoryId){if(B.getObject().teaser){try{$.sap.registerResourcePath("test-resources","test-resources");var r=$.sap.getResourcePath(B.getObject().teaser);var t=sap.ui.xmlfragment(i,r);o=sap.ui.xmlfragment(i,"sap.ui.demokit.demoapps.view.BlockLayoutTeaserCell",this);o.getContent()[0].addContent(t);$.sap.registerResourcePath("test-resources",null);}catch(e){$.sap.log.warning("Teaser for demo app \""+B.getObject().name+"\" could not be loaded: "+e);o=sap.ui.xmlfragment(i,"sap.ui.demokit.demoapps.view.BlockLayoutCell",this);}}else{o=sap.ui.xmlfragment(i,"sap.ui.demokit.demoapps.view.BlockLayoutCell",this);}}else{o=sap.ui.xmlfragment(i,"sap.ui.demokit.demoapps.view.BlockLayoutHeadlineCell",this);}o.setBindingContext(B);return o;},_createArchive:function(o,c,d){o.save(c,d,"zip","application/zip");},_handleError:function(e){M.error(e);}});});
sap.ui.predefine('sap/ui/demokit/demoapps/model/formatter',[],function(){"use strict";return{crossLink:function(l){if(l[0]==="#"){l=document.location.href.substring(0,document.location.href.search("demoapps\.html"))+l;}return l;},libraryLink:function(n){if(n&&n.search("sap\\.")===0){return this.formatter.crossLink("#docs/api/symbols/"+n+".html");}else{return"";}},libraryLinkEnabled:function(n){return!!this.formatter.libraryLink.bind(this)(n);},categoryName:function(c){var r=this.getView().getModel("i18n").getResourceBundle();return r.getText("demoAppCategory"+c);}};});
sap.ui.predefine('sap/ui/demokit/demoapps/model/libraryData',['jquery.sap.global','sap/ui/demokit/library'],function(q,l){"use strict";
function c(d,L,s){var b=[];if(q.isPlainObject(d.links)){b=Object.keys(d.links).map(function(k){return{name:k,ref:d.links[k]};});}var A={lib:d.namespace||s,name:d.text,icon:d.icon,desc:d.desc,config:d.config,teaser:d.teaser,category:d.category,ref:(d.resolve==="lib"?L:"")+d.ref,links:b};return A;}
function a(L,d){var C=["Showcase","Tool","Tutorial","Template","RTA","Misc"];var D={};C.forEach(function(s){D[s]=[];});var o={demoApps:[],demoAppsByCategory:[]};for(var i=0;i<L.length;i++){var b=d[L[i]].demo;if(!b){continue;}if(b.links&&b.links.length>0){for(var j=0;j<b.links.length;j++){var e=c(b.links[j],d[L[i]].libraryUrl,b.text);o.demoApps.push(e);if(C.indexOf(e.category)<0){q.sap.log.warning("Demo app category \""+e.category+"\" not found, correcting demo app \""+e.name+"\" to \"Misc\"");e.category="Misc";}D[e.category].push(e);}}}Object.keys(D).forEach(function(k){if(D[k].length===0){return;}o.demoAppsByCategory.push([{categoryId:k}]);var f=o.demoAppsByCategory.push([]);var g=0;for(var i=0;i<D[k].length;i++){g++;if(D[k][i].teaser){g++;}if(g>4){f=o.demoAppsByCategory.push([]);g=0;}o.demoAppsByCategory[f-1].push(D[k][i]);}});return o;}
return{fillJSONModel:function(m){function h(L,d){if(!L){return;}var M=m.getData();m.setData(q.extend(M,a(L,d)));}l._loadAllLibInfo("","_getDocuIndex",h);}};});
sap.ui.predefine('sap/ui/demokit/demoapps/model/sourceFileDownloader',['jquery.sap.global'],function(q){"use strict";var c={};return function(u){return new Promise(function(r){var s=function(a){c[u]=a;r(a);};var e=function(){r({errorMessage:"File not found: '"+u+"'"});};if(!(u in c)){q.ajax({url:u,type:"GET",dataType:"text",beforeSend:function(a){a.overrideMimeType("text/plain; charset=x-user-defined");}}).done(s).fail(e);}else{r(c[u]);}});};});
sap.ui.predefine('sap/ui/demokit/explored/Bootstrap',['jquery.sap.global','sap/ui/core/ComponentContainer','sap/m/Shell','sap/ui/demokit/library','./data'],function(q,C,S,l,d){"use strict";q("#busyIndicator").css({"margin-top":"8em","text-align":"center",color:"#555555"});var B={run:function(){l._loadAllLibInfo("","_getDocuIndex",function(L,D){B._processAndStoreIndices(L,D);B._loadUi();});},_processAndStoreIndices:function(L,D){var c=["Action","Application","Chart","Container","Data Binding","Data Visualization","Display","Layout","List","Map","Mini Chart","Popup","Routing","Testing","Theming","Tile","Tutorial","User Input"];var a=["namespace","since","category"];var f={namespace:{},since:{},category:{},formFactors:{"Independent":true,"Condensed":true,"Compact":true,"Cozy":true}};var F={"-":"Independent","S":"Condensed","SM":"Condensed, Compact","SL":"Condensed, Cozy","SML":"Condensed, Compact, Cozy","M":"Compact","ML":"Compact, Cozy","L":"Cozy"};d.entityCount=0;d.entities=[];d.filter={};d.samples={};q.each(D,function(i,h){if(!h.explored){return;}else if(!h.explored.samplesRef){q.sap.log.error("explored: cannot register lib '"+h.library+"'. missing 'explored.samplesRef'");return;}else if(Array.isArray(h.explored.samplesRef)&&h.explored.samplesRef.length!==h.explored.samplesRef.filter(function(I){return I.namespace&&I.ref;}).length){q.sap.log.error("explored: cannot register lib '"+h.library+"'. missing 'explored.samplesRef.namespace' or 'explored.samplesRef.ref' in one or more of the configured namespaces");return;}else if(!Array.isArray(h.explored.samplesRef)&&!h.explored.samplesRef.namespace){q.sap.log.error("explored: cannot register lib '"+h.library+"'. missing 'explored.samplesRef.namespace'");return;}else if(!Array.isArray(h.explored.samplesRef)&&!h.explored.samplesRef.ref){q.sap.log.error("explored: cannot register lib '"+h.library+"'. missing 'explored.samplesRef.ref'");return;}else if(!h.explored.entities){q.sap.log.error("explored: cannot register lib '"+h.library+"'. missing 'explored.entities'");return;}else{q.sap.log.info("explored: now reading lib '"+h.library+"'");}if(Array.isArray(h.explored.samplesRef)){h.explored.samplesRef.forEach(function(I){q.sap.registerModulePath(I.namespace,""+I.ref);});}else{q.sap.registerModulePath(h.explored.samplesRef.namespace,""+h.explored.samplesRef.ref);}q.each(h.explored.samples,function(i,s){if(!s.id){q.sap.log.error("explored: cannot register sample '?'. missing 'id'");}else if(!s.name){q.sap.log.error("explored: cannot register sample '"+s.id+"'. missing 'name'");}else{d.samples[s.id]=s;}});q.each(h.explored.entities,function(j,E){if(!E.id){q.sap.log.error("explored: cannot register entity '?'. missing 'id'");return;}if(h.explored.entitiesDefaults){q.each(h.explored.entitiesDefaults,function(k,v){if(!E.hasOwnProperty(k)){E[k]=v;}});}var I=E.id.lastIndexOf(".");var n=(I!==-1)?E.id.substring(0,I):E.id;E.namespace=n;if(!E.name){q.sap.log.error("explored: cannot register entity '"+E.id+"'. missing 'name'");return;}if(c.indexOf(E.category)===-1){q.sap.log.error("explored: cannot register entity '"+E.id+"'. category '"+E.category+"' is not allowed");return;}if(!E.formFactors){q.sap.log.error("explored: cannot register entity '"+E.id+"'. missing 'formFactors'");return;}if(!F[E.formFactors]){q.sap.log.error("explored: cannot register entity '"+E.id+"'. formFactors '"+E.formFactors+"' is not allowed");return;}E.formFactors=F[E.formFactors];var A=false;q.each(a,function(i,p){if(!E[p]){q.sap.log.error("explored: cannot register entity '"+E.id+"'. missing '"+p+"'");A=true;return false;}});if(A){return;}q.each(a,function(i,p){f[p][E[p]]=true;});d.entities.push(E);});});q.each(d.entities,function(n,E){var i=0,s,p;E.searchTags=E.name+" "+E.name.replace(/ /g,"")+" "+E.category;if(E.samples&&!(E.samples instanceof Array)){E.samples=[];q.sap.log.error("explored: cannot register samples for entity '"+E.id+"'. 'samples' is not an array");return;}if(!E.samples){E.samples=[];}if(E.samplesAsSteps){if(!(E.samplesAsSteps instanceof Array)){q.sap.log.error("explored: cannot register samples for entity '"+E.id+"'. 'samplesAsSteps' is not an array");return;}p=function(N){if(N.toString().length===1){return"0"+N;}return N;};for(;i<E.samplesAsSteps.length;i++){s={"id":E.id+"."+p(i+1),"name":E.name+" - Step "+(i+1)+" - "+E.samplesAsSteps[i]};if(i>0){s.previousSampleId=E.id+"."+p(i);}if(i<E.samplesAsSteps.length-1){s.nextSampleId=E.id+"."+p(i+2);}E.samples.push(s);d.samples[s.id]=s;E.searchTags+=" "+s.name;}}else{var h=[],P;q.each(E.samples,function(j,I){var k=d.samples[I];if(!k){q.sap.log.warning("explored: cannot register sample '"+I+"' for '"+E.id+"'. not found in the available docu indizes");}else{k.previousSampleId=(P?P.id:undefined);if(P){P.nextSampleId=k.id;}P=k;h.push(k);E.searchTags+=" "+k.name;}});E.samples=h;}E.sampleCount=E.samples.length;});d.entityCount=d.entities.length;q.each(f,function(s,h){d.filter[s]=[];q.each(h,function(k,v){d.filter[s].push({id:k});});});q.sap.require("sap.ui.core.util.LibraryInfo");var b=sap.ui.require("sap/ui/core/util/LibraryInfo");var o=new b();var e={};var g=function(h){e[h.library]=h.componentInfo;};for(var i=0;i<L.length;i++){o._getLibraryInfo(L[i],g);}d.libComponentInfos=e;},_loadUi:function(){var p=q.sap.getModulePath("sap.ui.demokit.explored");new S("Shell",{title:"SAPUI5 Explored",showLogout:false,app:new C({name:'sap.ui.demokit.explored'}),homeIcon:{'phone':p+'/img/57_iPhone_Desktop_Launch.png','phone@2':p+'/img/114_iPhone-Retina_Web_Clip.png','tablet':p+'/img/72_iPad_Desktop_Launch.png','tablet@2':p+'/img/144_iPad_Retina_Web_Clip.png','favicon':p+'/img/favicon.ico','precomposed':false}}).placeAt('content');}};return B;},true);
sap.ui.predefine('sap/ui/demokit/explored/Component',['jquery.sap.global','sap/ui/Device','sap/ui/core/UIComponent','sap/ui/core/mvc/View','sap/ui/model/json/JSONModel','sap/ui/model/resource/ResourceModel','sap/m/routing/RouteMatchedHandler','./util/MyRouter','./util/ToggleFullScreenHandler','./data'],function(q,D,U,V,J,R,a,M,T,d){"use strict";
var C=U.extend("sap.ui.demokit.explored.Component",{
metadata:{includes:["css/style.css"],routing:{config:{routerClass:M,viewType:"XML",viewPath:"sap.ui.demokit.explored.view",targetControl:"splitApp",clearTarget:false,async:true},routes:[{pattern:"entity/{id}/{part}",name:"entity",view:"entity",viewLevel:3,targetAggregation:"detailPages"},{pattern:"sample/{id}/preview",name:"sample",view:"sample",viewLevel:4,targetAggregation:"detailPages"},{pattern:"sample/{id}/code/{fileName}",name:"code_file",view:"code",viewLevel:6,targetAggregation:"detailPages",transition:"flip"},{pattern:"sample/{id}/code",name:"code",view:"code",viewLevel:5,targetAggregation:"detailPages",transition:"flip"},{pattern:"",name:"home",view:"master",viewLevel:1,targetAggregation:"masterPages",subroutes:[{pattern:"{all*}",name:"notFound",view:"notFound",viewLevel:2,targetAggregation:"detailPages"}]}]}},
init:function(){U.prototype.init.apply(this,arguments);var r=this.getRouter();if(!D.system.phone){r.myNavToWithoutHash("sap.ui.demokit.explored.view.master","XML",true);r.myNavToWithoutHash("sap.ui.demokit.explored.view.welcome","XML",false);}this.routeHandler=new a(r);r.initialize();},
destroy:function(){if(this.routeHandler){this.routeHandler.destroy();}T.cleanUp();U.prototype.destroy.apply(this,arguments);},
createContent:function(){var v=sap.ui.view({id:"app",viewName:"sap.ui.demokit.explored.view.app",type:"JS",viewData:{component:this}});var p=q.sap.getModulePath("sap.ui.demokit.explored");var i=new R({bundleUrl:p+"/i18n/messageBundle.properties"});v.setModel(i,"i18n");var e={entityCount:d.entityCount,entities:d.entities};var E=new J(e);E.setSizeLimit(100000);v.setModel(E,"entity");var f=d.filter;var F=new J(f);F.setSizeLimit(100000);this.setModel(F,"filter");var b=new J({isTouch:D.support.touch,isNoTouch:!D.support.touch,isPhone:D.system.phone,isNoPhone:!D.system.phone,listMode:(D.system.phone)?"None":"SingleSelectMaster",listItemType:(D.system.phone)?"Active":"Inactive"});b.setDefaultBindingMode("OneWay");v.setModel(b,"device");return v;}
});
return C;});
sap.ui.predefine('sap/ui/demokit/explored/data',function(){"use strict";return{};},true);
sap.ui.predefine('sap/ui/demokit/explored/util/MyRouter',['sap/ui/core/routing/History','sap/ui/core/routing/Router','sap/ui/core/Core'],function(H,R,C){"use strict";
var M=R.extend("sap.ui.demokit.explored.util.MyRouter",{
myNavBack:function(r,d){var h=H.getInstance();var p=h.getPreviousHash();if(p!==undefined){window.history.go(-1);}else{var b=true;this.navTo(r,d,b);}},
myNavToWithoutHash:function(v,a,m,d){var b=sap.ui.getCore().byId("splitApp");var c=this.getView(v,a);b.addPage(c,m);b.toDetail(c.getId(),"show",d);}
});
return M;});
sap.ui.predefine('sap/ui/demokit/explored/util/ObjectSearch',['jquery.sap.global'],function(q){"use strict";var O={getEntityPath:function(d,I){if(!d.entities){return null;}var r=null;q.each(d.entities,function(i,e){if(e.id===I){r="/entities/"+i+"/";return false;}});return r;}};return O;},true);
sap.ui.predefine('sap/ui/demokit/explored/util/ToggleFullScreenHandler',[],function(){"use strict";var T={updateMode:function(e,v){if(!this._oShell){this._oShell=sap.ui.getCore().byId('Shell');}var s=(this._getSplitApp().getMode()==="ShowHideMode");if(s){this._getSplitApp().setMode('HideMode');this._oShell.setAppWidthLimited(false);}else{this._getSplitApp().setMode('ShowHideMode');this._oShell.setAppWidthLimited(true);}this.updateControl(e.getSource(),v,s);},_getSplitApp:function(){if(!this._oSplitApp){this._oSplitApp=sap.ui.getCore().byId('splitApp');}return this._oSplitApp;},updateControl:function(b,v,f){if(arguments.length===2){f=!(this._getSplitApp().getMode()==="ShowHideMode");}var i=v.getModel('i18n');if(!f){b.setTooltip(i.getProperty('sampleFullScreenTooltip'));b.setIcon('sap-icon://full-screen');}else{b.setTooltip(i.getProperty('sampleExitFullScreenTooltip'));b.setIcon('sap-icon://exit-full-screen');}},cleanUp:function(){this._oSplitApp=null;this._oShell=null;}};return T;},true);
sap.ui.predefine('sap/ui/demokit/explored/view/app.controller',["jquery.sap.global","sap/ui/core/Core","sap/ui/core/Component","sap/ui/core/mvc/Controller"],function(q,C,a,b){"use strict";return b.extend("sap.ui.demokit.explored.view.app",{onInit:function(){this._afterRenderingDone=false;this._component=a.getOwnerComponentFor(this.getView());this._component.getEventBus().subscribe("app","applyAppConfiguration",this._applyAppConfiguration,this);},onAfterRendering:function(){if(this.hasOwnProperty("_compactOn")){q('body').toggleClass("sapUiSizeCompact",this._compactOn).toggleClass("sapUiSizeCozy",!this._compactOn);}if(this.hasOwnProperty("_themeActive")&&!q.sap.getUriParameters().get("sap-theme")&&!q.sap.getUriParameters().get("sap-ui-theme")){sap.ui.getCore().applyTheme(this._themeActive);}this._afterRenderingDone=true;},_applyAppConfiguration:function(c,e,d){if(this._afterRenderingDone){sap.ui.getCore().applyTheme(d.themeActive);q('body').toggleClass("sapUiSizeCompact",d.compactOn).toggleClass("sapUiSizeCozy",!d.compactOn);var s=sap.ui.getCore().byId("sampleFrame");if(s&&s.$()[0]){var S=s.$()[0].contentWindow;if(S){S.sap.ui.getCore().applyTheme(d.themeActive);S.jQuery('body').toggleClass("sapUiSizeCompact",d.compactOn).toggleClass("sapUiSizeCozy",!d.compactOn);}}}else{this._themeActive=d.themeActive;this._compactOn=d.compactOn;}}});});
sap.ui.predefine('sap/ui/demokit/explored/view/app.view',["sap/ui/core/mvc/JSView","sap/m/SplitApp"],function(J,S){"use strict";sap.ui.jsview("sap.ui.demokit.explored.view.app",{getControllerName:function(){return"sap.ui.demokit.explored.view.app";},createContent:function(c){this.setDisplayBlock(true);return new S("splitApp",{afterDetailNavigate:function(){this.hideMaster();}});}});});
sap.ui.predefine('sap/ui/demokit/explored/view/base.controller',["jquery.sap.global","sap/ui/core/mvc/Controller","jquery.sap.storage"],function(q,C){"use strict";return C.extend("sap.ui.demokit.explored.view.base",{_oViewSettings:null,_oStorage:q.sap.storage(q.sap.storage.Type.local),_sStorageKey:"UI5_EXPLORED_VIEW_SETTINGS",_oDefaultSettings:{filter:{},groupProperty:"category",groupDescending:false,compactOn:false,themeActive:"sap_belize",rtl:false,version:q.sap.Version(sap.ui.version).getMajor()+"."+q.sap.Version(sap.ui.version).getMinor()},_applyViewConfigurations:function(){if(!this._oViewSettings){this._initViewSettings();this.getOwnerComponent().getEventBus().publish("app","applyAppConfiguration",{themeActive:this._oViewSettings.themeActive,compactOn:this._oViewSettings.compactOn});}},_initViewSettings:function(){var j=this._oStorage.get(this._sStorageKey);if(!j){this._oViewSettings=this._oDefaultSettings;}else{this._oViewSettings=JSON.parse(j);var f=this.getOwnerComponent().getModel("filter").getData();var c={};q.each(this._oViewSettings.filter,function(p,V){var n=[];q.each(V,function(i,a){var b=false;q.each(f[p],function(i,o){if(o.id===a){b=true;return false;}});if(b){n.push(a);}});if(n.length>0){c[p]=n;}});this._oViewSettings.filter=c;if(!this._oViewSettings.hasOwnProperty("compactOn")){this._oViewSettings.compactOn=false;}if(!this._oViewSettings.hasOwnProperty("themeActive")){this._oViewSettings.themeActive="sap_bluecrystal";}else if(this._oViewSettings.version!==this._oDefaultSettings.version){var v=q.sap.Version(sap.ui.version);if(v.compareTo("1.40.0")>=0){this._oViewSettings.themeActive="sap_belize";}else{this._oViewSettings.themeActive="sap_bluecrystal";}}if(!this._oViewSettings.hasOwnProperty("rtl")){this._oViewSettings.rtl=false;}if(this._oViewSettings.rtl&&!q.sap.getUriParameters().get('sap-ui-rtl')){this._handleRTL(true);}}},_handleRTL:function(s){q.sap.require("sap.ui.core.routing.HashChanger");var H=sap.ui.require("sap/ui/core/routing/HashChanger");var h=new H();var a=h.getHash();var u=window.location;if(!window.location.origin){window.location.origin=window.location.protocol+"//"+window.location.hostname+(window.location.port?':'+window.location.port:'');}if(s){window.location=u.origin+u.pathname+"?sap-ui-rtl=true#"+a;}else{window.location=u.origin+u.pathname+"#/"+a;}}});});
sap.ui.predefine('sap/ui/demokit/explored/view/code.controller',['jquery.sap.global','sap/ui/core/routing/History','sap/ui/core/Component','sap/ui/core/UIComponent','sap/ui/core/mvc/Controller','sap/ui/model/json/JSONModel','../data'],function(q,H,C,U,a,J,d){"use strict";return a.extend("sap.ui.demokit.explored.view.code",{_aMockFiles:["products.json","supplier.json","img.json"],onInit:function(){this.router=U.getRouterFor(this);this.router.attachRoutePatternMatched(this.onRouteMatched,this);this._viewData=sap.ui.getCore().byId("app").getViewData();this._viewData.component.codeCache={};},onRouteMatched:function(e){if(e.getParameter("name")!=="code"&&e.getParameter("name")!=="code_file"){return;}this._sId=e.getParameter("arguments").id;var f=decodeURIComponent(e.getParameter("arguments").fileName);var s=d.samples[this._sId];if(!s){this.router.myNavToWithoutHash("sap.ui.demokit.explored.view.notFound","XML",false,{path:this._sId});return;}if(!this._oData||s.id!==this._oData.id){var c='sampleComp-'+this._sId;var b=this._sId;var o=sap.ui.component(c);if(!o){o=sap.ui.getCore().createComponent({id:c,name:b});}var m=o.getMetadata();var g=(m)?m.getConfig():null;this._oData={id:s.id,title:"Code: "+s.name,name:s.name,stretch:g.sample?g.sample.stretch:false,files:[],iframe:g.sample.iframe,fileName:f,includeInDownload:g.sample.additionalDownloadFiles};if(g&&g.sample&&g.sample.files){var r=q.sap.getModulePath(s.id);for(var i=0;i<g.sample.files.length;i++){var F=g.sample.files[i];var h=this.fetchSourceFile(r,F);this._oData.files.push({name:F,raw:h,code:this._convertCodeToHtml(h)});}}}else{this._oData.fileName=f;}var j=new J(this._oData);this.getView().setModel(j);j.refresh(true);var p=this.getView().byId("page");p.scrollTo(0);},fetchSourceFile:function(r,f){var t=this;var u=r+"/"+f;var s=function(b){t._viewData.component.codeCache[u]=b;};var e=function(b){t._viewData.component.codeCache[u]="not found: '"+u+"'";};if(!(u in this._viewData.component.codeCache)){this._viewData.component.codeCache[u]="";q.ajax({url:u,type:"GET",async:false,dataType:"text",success:s,error:e,beforeSend:function(b){b.overrideMimeType("text/plain; charset=x-user-defined");}});}return t._viewData.component.codeCache[u];},onDownload:function(e){q.sap.require("sap.ui.thirdparty.jszip");var z=new JSZip();var D=this.getView().getModel().getData(),r=0;for(var i=0;i<D.files.length;i++){var f=D.files[i],R=f.raw,F=f.name.split("../").length-1,s=f.name.slice();if(F>r){r=F;}if(F>0){s=f.name.slice(f.name.lastIndexOf("../")+3);}if(s&&(s===D.iframe||s.split(".").pop()==="html")){R=this._changeIframeBootstrapToCloud(R);}z.file(s,R,{base64:false,binary:true});for(var j=0;j<this._aMockFiles.length;j++){var m=this._aMockFiles[j];if(f.raw.indexOf(m)>-1){z.file("mockdata/"+m,this.downloadMockFile(m));}}}var b=q.sap.getModulePath(this._sId),E=D.includeInDownload||[],t=this;if(!D.iframe){z.file("Component.js",this.fetchSourceFile(b,"Component.js"),{base64:false,binary:true});z.file("index.html",this._changeIframeBootstrapToCloud(this.createIndexFile(D,r)));}E.forEach(function(g,h){z.file(g,t.fetchSourceFile(b,g),{base64:false,binary:true});});var c=z.generate({type:"blob"});this._openGeneratedFile(c);},_openGeneratedFile:function(c){q.sap.require("sap.ui.core.util.File");var F=sap.ui.require("sap/ui/core/util/File");F.save(c,this._sId,"zip","application/zip");},createIndexFile:function(D,r){var h,s;var R=q.sap.getModulePath("sap.ui.demokit.explored.tmpl");var I=this.fetchSourceFile(R,"index.html.tmpl");I=I.replace(/{{TITLE}}/g,D.name);I=I.replace(/{{SAMPLE_ID}}/g,D.id);var p="",o=D.id.slice();for(var i=0;i<r;i++){o=o.substring(0,o.lastIndexOf("."));p+="\""+o+"\" : \"./\", ";}I=I.replace(/{{PARENT_RESOURCES}}/g,p);h=D.stretch?'height : "100%", ':"";I=I.replace(/{{HEIGHT}}/g,h);s=!D.stretch;I=I.replace(/{{SCROLLING}}/g,s);return I;},downloadMockFile:function(f){var r=q.sap.getModulePath("sap.ui.demo.mock");var w="test-resources/sap/ui/demokit/explored/img/";var c="https://openui5.hana.ondemand.com/test-resources/sap/ui/demokit/explored/img/";var R=new RegExp(w,"g");var m=this.fetchSourceFile(r,f);if(m){m=m.replace(R,c);}return m;},onNavBack:function(){var h,p;h=H.getInstance();p=h.getPreviousHash();if(p!==undefined){window.history.go(-1);}else{this.router.navTo("home",{},true);}},_convertCodeToHtml:function(c){q.sap.require("jquery.sap.encoder");c=c.toString();c=c.replace(/^function.+{/,"");c=c.replace(/}[!}]*$/,"");c=c.replace(/^[\n\s\S]*\/\/\s*CODESNIP_START\n/,"");c=c.replace(/\/\/\s*CODESNIP_END[\n\s\S]*$/,"");c=c.replace(/\t/g,"  ");return c;},_changeIframeBootstrapToCloud:function(r){var b=/src=(?:"[^"]*\/sap-ui-core\.js"|'[^']*\/sap-ui-core\.js')/;var c=new URI(window.location.href).search("");var R=new URI(q.sap.getResourcePath("","/sap-ui-core.js"));var B=R.absoluteTo(c).toString();return r.replace(b,'src="'+B+'"');},handleTabSelectEvent:function(e){var f=e.getParameter("selectedKey");this.router.navTo("code_file",{id:this._sId,fileName:encodeURIComponent(f)},true);}});},true);
sap.ui.predefine('sap/ui/demokit/explored/view/entity.controller',["jquery.sap.global","sap/ui/Device","sap/ui/core/Component","sap/ui/core/UIComponent","sap/ui/core/routing/History","sap/ui/model/json/JSONModel","sap/ui/demokit/EntityInfo","sap/ui/demokit/util/JSDocUtil","../util/ObjectSearch","../util/ToggleFullScreenHandler","../data","sap/ui/demokit/explored/view/base.controller"],function(q,D,C,U,H,J,E,a,O,T,d,B){"use strict";return B.extend("sap.ui.demokit.explored.view.entity",{descriptionText:function(t){var h;if(t){h="<span>"+t+"</span>";}return h;},onInit:function(){this.router=U.getRouterFor(this);this.router.attachRoutePatternMatched(this.onRouteMatched,this);this._component=C.getOwnerComponentFor(this.getView());this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);this.getView().addEventDelegate({onBeforeFirstShow:q.proxy(this._applyViewConfigurations,this)});},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this);},onTypeLinkPress:function(e){var t=e.getSource().data("type");this.router.navTo("entity",{id:t,part:"samples"},false);this._component.getEventBus().publish("app","selectEntity",{id:t});},onJSDocLinkClick:function(e){var t=e.target.getAttribute("data-sap-ui-target");if(t&&t.indexOf('#')>=0){t=t.slice(0,t.indexOf('#'));}if(t){this.router.navTo("entity",{id:t,part:"samples"},false);this._component.getEventBus().publish("app","selectEntity",{id:t});e.preventDefault();}},onIntroLinkPress:function(e){var p=document.location.pathname.split("/"),b=document.location.origin+p.splice(0,p.length-1).join("/")+"/";window.open(b+this.getView().getModel().getProperty("/docuLink"),"_blank");},onTabSelect:function(e){var t=e.getParameter("key");this.router.navTo("entity",{id:this._sId,part:t},true);},onNavBack:function(e){this.router.myNavBack("home",{});},onNavToSample:function(e){var p=e.getSource().getBindingContext("entity").getPath();var s=this.getView().getModel("entity").getProperty(p);this.router.navTo("sample",{id:s.id});},_TAB_KEYS:["samples","about","properties","aggregations","associations","events","methods"],onRouteMatched:function(e){var r=e.getParameter("name"),n=e.getParameter("arguments").id,N=e.getParameter("arguments").part;if(r!=="entity"){return;}var o=this.getView().getModel("entity");var p=O.getEntityPath(o.getData(),n);var b=(p)?o.getProperty(p):null;var c=!!p;var h=H.getInstance();var P=h.getPreviousHash();var s=D.system.phone||(!c&&!!P);this.getView().byId("page").setShowNavButton(s);var m,f;if(this._sId!==n){var g=E.getEntityDocu(n);if(!b&&!g){this.router.myNavToWithoutHash("sap.ui.demokit.explored.view.notFound","XML",false,{path:n});return;}f=this._getViewData(n,g,b);m=new J(f);this.getView().setModel(m);this.getView().bindElement("entity>"+p);this._sId=n;}else{m=this.getView().getModel();m.refresh(true);f=m.getData();}if(this._TAB_KEYS.indexOf(N)===-1){N="samples";}if(!f.show[N]){N="samples";}var t=this.getView().byId("tabBar");if(N!==t.getSelectedKey()&&t.getExpanded()){t.setSelectedKey(N);}},onToggleFullScreen:function(e){T.updateMode(e,this.getView());},_getViewData:function(i,o,e){var b=this._convertEntityInfo(i,o),s=false,S=0;if(e){if(!b.shortDescription&&e.description){b.shortDescription=e.description;}if(e.docuLink){b.show.introLink=true;b.docuLink=e.docuLink;}s=e.samples.length>0;S=e.samples.length;}b.show.samples=s;b.count.samples=S;return b;},_convertEntityInfo:function(I,o){var b={name:I,deprecated:(o)?this._formatDeprecated(o.deprecation):null,deprecatedMark:(o)?this._createDeprecatedMark(o.deprecation):null,baseType:(o)?this._formatType(o.baseType):null,baseTypeText:(o)?this._formatTypeText(o.baseType):"-",baseTypeNav:(o)?this._formatTypeNav(o.baseType):null,shortDescription:(o)?this._formatDeprecatedDescription(o.deprecation):null,description:(o)?this._wrapInSpanTag(o.doc):null,docuLink:null,properties:[],events:[],methods:[],aggregations:[],associations:[],values:[],show:{baseType:(o)?!!o.baseType:false,about:!!o,properties:false,events:false,methods:false,aggregations:false,associations:false,values:false,introActive:false},count:{properties:0,events:0,methods:0,aggregations:0,associations:0},appComponent:this._takeControlComponent(I)};var m=0,e=0;var s=I.slice(I.lastIndexOf('.')+1);if(!o){return b;}var k=null;for(k in o.properties){if(o.properties.hasOwnProperty(k)&&k.indexOf("_")!==0){var P=o.properties[k];P.name=k;P.deprecatedDescription=this._formatDeprecatedSinceDescription(P.deprecation,P.deprecationSince);P.deprecated=this._formatDeprecated(P.deprecation);P.doc=this._wrapInSpanTag(P.doc);P.typeText=this._formatTypeText(P.type);P.typeNav=this._formatTypeNav(P.type);P.type=this._formatType(P.type);P.defaultValue=(P.defaultValue)?String(P.defaultValue).replace("empty/undefined","-"):"";b.properties.push(P);}}for(k in o.events){if(o.events.hasOwnProperty(k)&&k.indexOf("_")!==0){var c=o.events[k];c.name=k;c.deprecatedDescription=this._formatDeprecatedDescription(c.deprecation);c.deprecated=this._formatDeprecated(c.deprecation);c.doc=this._wrapInSpanTag(c.doc);b.events.push(c);e++;for(var p in c.parameters){if(c.parameters.hasOwnProperty(p)&&p.indexOf("_")!==0){b.events.push({param:p,since:c.parameters[p].since,typeText:this._formatTypeText(c.parameters[p].type),typeNav:this._formatTypeNav(c.parameters[p].type),type:this._formatType(c.parameters[p].type),doc:this._wrapInSpanTag(c.parameters[p].doc),deprecatedDescription:this._formatDeprecatedDescription(c.parameters[p].deprecation),deprecated:this._formatDeprecated(c.parameters[p].deprecation)});}}}}for(k in o.methods){if(o.methods.hasOwnProperty(k)&&k.indexOf("_")!==0&&!o.methods[k].synthetic){var M=o.methods[k];M.name=o.methods[k].static?s+"."+k:k;M.deprecatedDescription=this._formatDeprecatedDescription(M.deprecation);M.deprecated=this._formatDeprecated(M.deprecation);M.doc=this._wrapInSpanTag(M.doc);M.param="returnValue";M.typeText=this._formatTypeText(M.type);M.typeNav=this._formatTypeNav(M.type);M.type=this._formatType(M.type);b.methods.push(M);m++;for(var i=0;i<M.parameters.length;i++){var f=M.parameters[i].name;if(f.indexOf("_")!==0){b.methods.push({param:f,since:M.parameters[i].since,typeText:this._formatTypeText(M.parameters[i].type),typeNav:this._formatTypeNav(M.parameters[i].type),type:this._formatType(M.parameters[i].type),doc:this._wrapInSpanTag(M.parameters[i].doc),deprecatedDescription:this._formatDeprecatedDescription(M.parameters[i].deprecation),deprecated:this._formatDeprecated(M.parameters[i].deprecation)});}}}}for(k in o.aggregations){var A=o.aggregations[k];var n=(!A.hasOwnProperty("visibility")||A.visibility!=="hidden");if(o.aggregations.hasOwnProperty(k)&&k.indexOf("_")!==0&&n){A.name=k;A.deprecated=this._formatDeprecated(A.deprecation);A.deprecatedDescription=this._formatDeprecatedDescription(A.deprecation);A.doc=this._wrapInSpanTag(A.doc);A.typeText=this._formatTypeText(A.type);A.typeNav=this._formatTypeNav(A.type);A.type=this._formatType(A.type);b.aggregations.push(A);}}for(k in o.associations){if(o.associations.hasOwnProperty(k)&&k.indexOf("_")!==0){var g=o.associations[k];g.name=k;g.deprecatedDescription=this._formatDeprecatedDescription(g.deprecation);g.deprecated=this._formatDeprecated(g.deprecation);g.doc=this._wrapInSpanTag(g.doc);g.typeText=this._formatTypeText(g.type);g.typeNav=this._formatTypeNav(g.type);g.type=this._formatType(g.type);b.associations.push(g);}}for(k in o.values){if(o.values.hasOwnProperty(k)&&k.indexOf("_")!==0){var v=o.values[k];v.name=k;v.deprecatedDescription=this._formatDeprecatedDescription(v.deprecation);v.deprecated=this._formatDeprecated(v.deprecation);b.values.push(v);}}b.show.properties=b.properties.length>0;b.show.events=e>0;b.show.methods=m>0;b.show.aggregations=b.aggregations.length>0;b.show.associations=b.associations.length>0;b.show.values=b.values.length>0;b.count.properties=b.properties.length;b.count.events=e;b.count.methods=m;b.count.aggregations=b.aggregations.length;b.count.associations=b.associations.length;return b;},_wrapInSpanTag:function(t){return'<span class="fs0875">'+a.formatTextBlock(t,{linkFormatter:function(b,c){var p;b=b.trim().replace(/\.prototype\./g,"#");p=b.indexOf("#");if(p===0){return"<code>"+b.slice(1)+"</code>";}if(p>0){c=c||b;b=b.slice(0,p);}return"<a class=\"jsdoclink\" href=\"#\" data-sap-ui-target=\""+b+"\">"+(c||b)+"</a>";}})+'</span>';},_formatDeprecated:function(s){return(s&&s.length>0)?"true":"false";},_formatDeprecatedDescription:function(s){return(this._isDeprecated(s))?(this._createDeprecatedMark(s)+": "+s):null;},_formatDeprecatedSinceDescription:function(s,b){return(this._isDeprecated(s))?(this._createDeprecatedSinceMark()+" "+b+": "+s):null;},_isDeprecated:function(s){return(s&&s.length>0);},_formatType:function(t){if(!t){return null;}else{return t.replace("[]","");}},_formatTypeText:function(t){if(!t){return null;}else{t=t.replace("sap.ui.core.","");var i=t.lastIndexOf(".");return(i!==-1)?t.substr(i+1):t;}},_createDeprecatedMark:function(s){return(s)?this._getI18nModel().getProperty("deprecated"):"";},_createDeprecatedSinceMark:function(){return this._getI18nModel().getProperty("deprecatedSince");},_getI18nModel:function(){return this.getView().getModel("i18n");},_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","any","object","function","float","int","boolean","string"],_formatTypeNav:function(t){return this._baseTypes.indexOf(t)===-1;},_takeControlComponent:function(c){var l=d.libComponentInfos;q.sap.require("sap.ui.core.util.LibraryInfo");var L=sap.ui.require("sap/ui/core/util/LibraryInfo");var o=new L();var A=o._getActualComponent(l,c);return A;}});});
sap.ui.predefine('sap/ui/demokit/explored/view/master.controller',["jquery.sap.global","sap/ui/Device","sap/ui/core/Component","sap/ui/core/Fragment","sap/ui/core/UIComponent","sap/ui/model/Filter","sap/ui/model/Sorter","sap/m/GroupHeaderListItem","../util/ToggleFullScreenHandler","sap/ui/demokit/explored/view/base.controller","jquery.sap.storage"],function(q,D,C,F,U,a,S,G,T,B){"use strict";return B.extend("sap.ui.demokit.explored.view.master",{_bIsViewUpdatedAtLeastOnce:false,_oVSDialog:null,_mGroupFunctions:{"name":function(c){var k=c.getProperty("name").charAt(0);return{key:k,text:k};},"namespace":true,"category":true,"since":true,"formFactors":true},onInit:function(){this.router=U.getRouterFor(this);this.router.attachRoutePatternMatched(this.onRouteMatched,this);this._component=C.getOwnerComponentFor(this.getView());this._component.getEventBus().subscribe("app","selectEntity",this.onSelectEntity,this);this._sCurrentGroup=this._oDefaultSettings.groupProperty;this.getView().addEventDelegate({onBeforeFirstShow:q.proxy(this.onBeforeFirstShow,this)});},onBeforeFirstShow:function(){if(!this._bIsViewUpdatedAtLeastOnce){this._updateView();}},onRouteMatched:function(e){var r=e.getParameter("name");if(r!=="home"&&r!="notFound"){var v=e.getParameter('view');if(v){var t=v.byId("toggleFullScreenBtn");if(t){T.updateControl(t,v);}}return;}this._updateView();},onOpenAppSettings:function(e){if(!this._oSettingsDialog){this._oSettingsDialog=sap.ui.xmlfragment("sap.ui.demokit.explored.view.appSettingsDialog",this);this.getView().addDependent(this._oSettingsDialog);}q.sap.delayedCall(0,this,function(){var A=sap.ui.getCore().getConfiguration();var c=this._oViewSettings.compactOn;var r=this._oViewSettings.rtl;var u=q.sap.getUriParameters().get("sap-theme");var s=q.sap.getUriParameters().get("sap-ui-rtl");if(u){sap.ui.getCore().byId("ThemeButtons").setSelectedKey(u);}else{sap.ui.getCore().byId("ThemeButtons").setSelectedKey(A.getTheme());}sap.ui.getCore().byId("CompactModeButtons").setState(c);if(s){sap.ui.getCore().byId("RTLButtons").setState(s==="true"?true:false);}else{sap.ui.getCore().byId("RTLButtons").setState(r);}this._oSettingsDialog.open();});},onSaveAppSettings:function(e){this._oSettingsDialog.close();if(!this._oBusyDialog){q.sap.require("sap.m.BusyDialog");var b=sap.ui.require("sap/m/BusyDialog");this._oBusyDialog=new b();this.getView().addDependent(this._oBusyDialog);}var c=sap.ui.getCore().byId('CompactModeButtons').getState();var t=sap.ui.getCore().byId('ThemeButtons').getSelectedKey();var r=sap.ui.getCore().byId('RTLButtons').getState();var R=(r!==this._oViewSettings.rtl);this._oBusyDialog.open();q.sap.delayedCall(1000,this,function(){this._oBusyDialog.close();});this._oViewSettings.compactOn=c;this._oViewSettings.themeActive=t;this._oViewSettings.rtl=r;this._oViewSettings.version=this._oDefaultSettings.version;var s=JSON.stringify(this._oViewSettings);this._oStorage.put(this._sStorageKey,s);this._component.getEventBus().publish("app","applyAppConfiguration",{themeActive:t,compactOn:c});if(R){this._handleRTL(r);}},onDialogCloseButton:function(){this._oSettingsDialog.close();},onSelectEntity:function(c,e,d){var v=this.getView(),l=v.byId("list"),m=v.getModel("entity");var s=null;var I=l.getItems();q.each(I,function(i,o){var b=o.getBindingContext("entity");if(b){var p=b.getPath();var E=m.getProperty(p);if(E.id===d.id){s=o;return false;}}});if(s){l.setSelectedItem(s);}else{l.removeSelections();}},onOpenViewSettings:function(){if(!this._oVSDialog){this._oVSDialog=sap.ui.xmlfragment(this.getView().getId(),"sap.ui.demokit.explored.view.viewSettingsDialog",this);this.getView().addDependent(this._oVSDialog);}q.sap.delayedCall(0,this,function(){var f={};q.each(this._oViewSettings.filter,function(p,v){q.each(v,function(i,V){f[V]=true;});});this._oVSDialog.setSelectedFilterKeys(f);this._oVSDialog.setSelectedGroupItem(this._oViewSettings.groupProperty);this._oVSDialog.setGroupDescending(this._oViewSettings.groupDescending);q('body').toggleClass("sapUiSizeCompact",this._oViewSettings.compactOn).toggleClass("sapUiSizeCozy",!this._oViewSettings.compactOn);this._oVSDialog.open();});},onConfirmViewSettings:function(e){var t=this;this._oViewSettings.filter={};var f=e.getParameter("filterItems");q.each(f,function(i,I){var k=I.getKey();var p=I.getParent().getKey();if(!t._oViewSettings.filter.hasOwnProperty(p)){t._oViewSettings.filter[p]=[];}t._oViewSettings.filter[p].push(k);});var g=e.getParameter("groupItem");var n=(g)?g.getKey():null;this._oViewSettings.groupProperty=n;this._oViewSettings.groupDescending=e.getParameter("groupDescending");var s=JSON.stringify(this._oViewSettings);this._oStorage.put(this._sStorageKey,s);this._updateView();},onSearch:function(){this._updateView();},onNavToEntity:function(e){var i=e.getParameter("listItem");var I=(i)?i:e.getSource();var p=I.getBindingContext("entity").getPath();var E=this.getView().getModel("entity").getProperty(p);var r=!D.system.phone;this.router.navTo("entity",{id:E.id,part:"samples"},r);},_updateView:function(){this._applyViewConfigurations();this._updateFilterBarDisplay();this._updateListBinding();},_updateFilterBarDisplay:function(){var f="";q.each(this._oViewSettings.filter,function(p,V){q.each(V,function(i,b){f+=b+", ";});});if(f.length>0){var I=f.lastIndexOf(", ");f=f.substring(0,I);}var v=this.getView();v.byId("vsFilterBar").setVisible(f.length>0);v.byId("vsFilterLabel").setText(f);},_updateListBinding:function(){var f=[],s=[],b=false,g=false,o=this.getView().byId("searchField"),l=this.getView().byId("list"),c=l.getBinding("items");var Q=o.getValue().trim();b=true;f.push(new a("searchTags","Contains",Q));q.each(this._oViewSettings.filter,function(p,v){var P=[];q.each(v,function(i,V){var O=(p==="formFactors")?"Contains":"EQ";P.push(new a(p,O,V));});var d=new a(P,false);b=true;f.push(d);});if(b&&f.length===0){c.filter(f,"Application");}else if(b&&f.length>0){var d=new a(f,true);c.filter(d,"Application");}if(this._oViewSettings.groupProperty&&this._oViewSettings.groupProperty!==this._sCurrentGroup){g=true;}else if(this._oViewSettings.groupProperty&&this._oViewSettings.groupDescending!==this._bCurrentlyGroupedDescending){g=true;}if(g){var e=new S(this._oViewSettings.groupProperty,this._oViewSettings.groupDescending,this._mGroupFunctions[this._oViewSettings.groupProperty]);s.push(e);s.push(new S("name",false));c.sort(s);}this._sCurrentGroup=this._oViewSettings.groupProperty;this._bCurrentlyGroupedDescending=this._oViewSettings.groupDescending;this._bIsViewUpdatedAtLeastOnce=true;},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});}});});
sap.ui.predefine('sap/ui/demokit/explored/view/notFound.controller',["sap/ui/core/mvc/Controller","sap/ui/core/UIComponent","sap/ui/model/json/JSONModel"],function(C,U,J){"use strict";return C.extend("sap.ui.demokit.explored.view.notFound",{onInit:function(){this.router=U.getRouterFor(this);this.router.attachRoutePatternMatched(this.onRouteMatched,this);this.getView().addEventDelegate(this);this.getView().setModel(new J({entityName:""}));},onRouteMatched:function(e){if(e.getParameter("name")!=="notFound"){return;}var p=e.getParameter("arguments")["all*"];this.getView().getModel().setProperty("/entityName",p);},onBeforeShow:function(e){if(e.data.path){this.getView().getModel().setProperty("/entityName",e.data.path);}},onNavBack:function(){this.router.myNavBack("home",{});}});});
sap.ui.predefine('sap/ui/demokit/explored/view/sample.controller',['jquery.sap.global','sap/ui/Device','sap/ui/core/Component','sap/ui/core/ComponentContainer','sap/ui/core/HTML','sap/ui/core/UIComponent','sap/ui/core/routing/History','sap/ui/model/json/JSONModel','sap/m/library','sap/m/Text','../util/ToggleFullScreenHandler','../data','sap/ui/demokit/explored/view/base.controller','sap/ui/fl/FakeLrepConnectorLocalStorage','sap/ui/fl/Utils'],function(q,D,C,a,H,U,b,J,m,T,c,d,B,F,e){"use strict";
var S=B.extend("sap.ui.demokit.explored.view.sample",{
onInit:function(){this.router=U.getRouterFor(this);this.router.attachRoutePatternMatched(this.onRouteMatched,this);this._viewModel=new J({showNavButton:true,showNewTab:false});this._initFakeLREP();this._loadRuntimeAuthoring();this.getView().setModel(this._viewModel);this.getView().addEventDelegate({onBeforeFirstShow:q.proxy(this._applyViewConfigurations,this)});},
onRouteMatched:function(E){if(this._oRTA){this._oRTA.destroy();this._oRTA=null;}if(E.getParameter("name")!=="sample"){return;}var M=this._viewModel.getData();this._sId=E.getParameter("arguments").id;var s=d.samples[this._sId];if(!s){this.router.myNavToWithoutHash("sap.ui.demokit.explored.view.notFound","XML",false,{path:this._sId});return;}var p=this.getView().byId("page");var h=b.getInstance();var P=h.getPreviousHash();M.showNavButton=D.system.phone||!!P;M.previousSampleId=s.previousSampleId;M.nextSampleId=s.nextSampleId;p.setTitle("Sample: "+s.name);var o;try{o=this._createComponent();}catch(g){p.removeAllContent();p.addContent(new T({text:"Error while loading the sample: "+g}));return;}var i=(this._oComp.getMetadata())?this._oComp.getMetadata().getConfig():null;var j=i&&i.sample||{};M.showNewTab=!!j.iframe;if(j.iframe){o=this._createIframe(j.iframe);}else{this.sIFrameUrl=null;}var k=!!j.stretch;var l=k?"100%":null;p.setEnableScrolling(!k);if(o.setHeight){o.setHeight(l);}p.removeAllContent();p.addContent(o);p.scrollTo(0);this._viewModel.setData(M);},
onNewTab:function(){m.URLHelper.redirect(this.sIFrameUrl,true);},
onPreviousSample:function(E){this.router.navTo("sample",{id:this._viewModel.getProperty("/previousSampleId")},true);},
onNextSample:function(E){this.router.navTo("sample",{id:this._viewModel.getProperty("/nextSampleId")},true);},
_createIframe:function(i){var s=this._sId;if(typeof i==="string"){this.sIFrameUrl=S._createIFrameURL(i,s);}else{q.sap.log.error("no iframe source was provided");return null;}var h=sap.ui.getCore().byId("sampleFrame");if(h){h.destroy();}h=new H({id:"sampleFrame",content:'<iframe src="'+this.sIFrameUrl+'" id="sampleFrame" frameBorder="0"></iframe>'}).addEventDelegate({onAfterRendering:function(){h.$().on("load",function(){var o=h.$()[0].contentWindow;if(!o.sap){return;}o.sap.ui.getCore().attachInit(function(){var o=h.$()[0].contentWindow;o.sap.ui.getCore().applyTheme(sap.ui.getCore().getConfiguration().getTheme());o.jQuery('body').toggleClass("sapUiSizeCompact",q("body").hasClass("sapUiSizeCompact")).toggleClass("sapUiSizeCozy",q("body").hasClass("sapUiSizeCozy"));});});}});return h;},
_createComponent:function(){var s='sampleComp-'+this._sId;var g=this._sId;this._oComp=sap.ui.component(s);if(this._oComp){this._oComp.destroy();}this._oComp=sap.ui.getCore().createComponent({id:s,name:g});return new a({component:this._oComp});},
onNavBack:function(E){if(this._oComp&&this._oComp.exit){this._oComp.exit();}this.router.myNavBack("home",{});},
onNavToCode:function(g){this.router.navTo("code",{id:this._sId},false);},
onToggleFullScreen:function(E){c.updateMode(E,this.getView());},
_initFakeLREP:function(){e.checkControlId=function(){return true;};F.enableFakeConnector({"isProductiveSystem":true});},
_loadRuntimeAuthoring:function(){try{sap.ui.require(["sap/ui/rta/RuntimeAuthoring"],function(g){this.getView().byId("toggleRTA").setVisible(true);}.bind(this));}catch(E){q.sap.log.info("sap.ui.rta.RuntimeAuthoring could not be loaded, UI adaptation mode is disabled");}},
onAdaptUI:function(E){sap.ui.require(["sap/ui/rta/RuntimeAuthoring"],function(g){if(!this._oRTA){this._oRTA=new g({flexSettings:{developerMode:false}});this._oRTA.setRootControl(this.getView().byId("page").getContent()[0]);this._oRTA.attachStop(function(){this._oRTA.destroy();}.bind(this));this._oRTA.start();}}.bind(this));}
});
var R=/\/([^\/]*)$/,f=/\..+$/;
S._createIFrameURL=function(i,s){var g=R.exec(i);var h=(g&&g.length>1?g[1]:i);var j=f.exec(h)[0];var I=i.replace(f,"");I=q.sap.getModulePath(s+"."+I,j||".html");var k=window.location.search,t="sap-ui-theme="+sap.ui.getCore().getConfiguration().getTheme();if(k&&k!=="?"){var r=/sap-ui-theme=[a-z0-9\-\_]+/;if(k.match(r)){k=k.replace(r,t);}else{k+="&"+t;}}else{k="?"+t;}if(i.indexOf("?")>-1){k=k.replace("?","&");}return I+k;};
return S;});
sap.ui.predefine('sap/ui/demokit/library',['jquery.sap.global','sap/ui/Global','sap/ui/core/Core','./js/highlight-query-terms'],function(q,G){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.demokit",version:"1.52.30",dependencies:["sap.ui.core","sap.ui.commons"],types:["sap.ui.demokit.UI5EntityCueCardStyle"],interfaces:[],controls:["sap.ui.demokit.CodeSampleContainer","sap.ui.demokit.CodeViewer","sap.ui.demokit.FileUploadIntrospector","sap.ui.demokit.HexagonButton","sap.ui.demokit.HexagonButtonGroup","sap.ui.demokit.IndexLayout","sap.ui.demokit.SimpleTree","sap.ui.demokit.TagCloud","sap.ui.demokit.UI5EntityCueCard"],elements:["sap.ui.demokit.SimpleTreeNode","sap.ui.demokit.Tag","sap.ui.demokit.UIAreaSubstitute"]});var t=sap.ui.demokit;t.UI5EntityCueCardStyle={Standard:"Standard",Demokit:"Demokit"};sap.ui.lazyRequire("sap.ui.demokit.UI5EntityCueCard","attachToContextMenu detachFromContextMenu");sap.ui.lazyRequire("sap.ui.demokit.DemokitApp","new getInstance");sap.ui.lazyRequire("sap.ui.demokit.IndexPage");sap.ui.getCore().attachInit(function(){if(q("body").hasClass("sapUiDemokitBody")){var C=sap.ui.requireSync('sap/ui/demokit/CodeSampleContainer');var H=sap.ui.requireSync('sap/ui/demokit/HexagonButton');var U=sap.ui.requireSync('sap/ui/demokit/UI5EntityCueCard');q("h1").each(function(){var $=q(this),T=$.text(),a="Gray",i=$.attr('icon'),I=$.attr('iconPos')||'left:40px;top:20px;',e=q("<div class='sapUiDemokitTitle'><span>"+T+"</span></div>");$.replaceWith(e);if(a||i){e.prepend("<div id='sap-demokit-icon'></div>");new H({color:a,imagePosition:'position: relative;'+I,icon:i}).placeAt("sap-demokit-icon");}});var b=q("h2");var c=q('h2[id="settings"]');var s=q("html").attr('data-sap-ui-dk-controls');if(c.size()===0&&b.size()>=2&&s){q(b[1]).before(q("<h2 id='settings'>Settings (Overview)</h2><div cue-card='"+s.split(',')[0]+"'></div>"));b=q("h2");}var d=q("ul.sapDkTLN");if(b.size()>0&&d.size()==0){b.first().before(d=q("<ul class='sapDkTLN'></ul>"));}b.each(function(i){var $=q(this);if($.css('display')==='none'){return;}if(!$.attr('id')){$.attr('id','__'+i);}var a=q("<a></a>").attr("href","#"+$.attr('id')).text($.text()).addClass('sapDkLnk');var l=q("<li></li>").append(a);d.append(l);});q("[code-sample]").each(function(){var $=q(this),u=$.attr('code-sample'),S=$.attr('script')||$.children('script').attr('id')||u+"-script";$.addClass("sapUiDemokitSampleCont");new C("code-sample-"+u,{scriptElementId:S,uiAreaId:u}).placeAt(this);});q("[cue-card]").each(function(){var $=q(this),e=$.attr('cue-card');new U({entityName:e,collapsible:false,expanded:true,style:'Demokit',navigable:true,navigate:function(E){top.sap.ui.demokit.DemokitApp.getInstance().navigateToType(E.getParameter("entityName"));E.preventDefault();},title:'Settings (Overview)'}).placeAt(this);});}});
t._getAppInfo=function(c){var u=sap.ui.resource("","sap-ui-version.json");q.ajax({url:u,dataType:"json",error:function(x,s,e){q.sap.log.error("failed to load library list from '"+u+"': "+s+", "+e);c(null);},success:function(a,s,x){if(!a){q.sap.log.error("failed to load library list from '"+u+"': "+s+", Data: "+a);c(null);return;}c(a);}});};
t._loadAllLibInfo=function(a,I,r,c){if(typeof r==="function"){c=r;r=undefined;}q.sap.require("sap.ui.core.util.LibraryInfo");var L=sap.ui.require("sap/ui/core/util/LibraryInfo");var l=new L();var f=I=="_getLibraryInfoAndReleaseNotes";if(f){I="_getLibraryInfo";}t._getAppInfo(function(A){if(!(A&&A.libraries)){c(null,null);return;}var b=0,d=A.libraries,e=d.length,o={},g={},h=[],j,k;for(var i=0;i<e;i++){j=d[i].name;k=d[i].version;h.push(j);g[j]=k;l[I](j,function(E){var D=function(){b++;if(b==e){c(h,o,A);}};o[E.library]=E;if(!o[E.library].version){o[E.library].version=g[E.library];}if(f){if(!r){r=g[E.library];}l._getReleaseNotes(E.library,r,function(R){o[E.library].relnotes=R;D();});}else{D();}});}});};
return t;});
sap.ui.predefine('sap/ui/demokit/util/APIInfo',['jquery.sap.global'],function(q){"use strict";var t;var l;
function f(E){var v=sap.ui.getVersionInfo();if(v&&Array.isArray(v.libraries)){for(var i=0;i<v.libraries.length;i++){var a=v.libraries[i];if(E===a.name||E.indexOf(a.name+".")===0){return a.name;}}}return"sap.ui.core";}
function g(L){if(!L){return undefined;}var o=l[L];if(o===undefined){q.ajax({async:false,url:t+L.replace(/\./g,'/')+'/designtime/api.json',dataType:'json',success:function(r){o=l[L]=r;},error:function(a){q.sap.log.debug("failed to load api.json for: "+L);l[L]=null;}});}return o;}
function c(L,E){var i,j;if(!L){return undefined;}var s=L.symbols;for(i=0;i<s.length;i++){if(s[i].name===E){return s[i];}if(E.indexOf(s[i].name+'.')===0){if(s[i].properties){for(j=0;j<s[i].properties.length;j++){if(s[i].properties[j].static&&E===s[i].name+"."+s[i].properties[j].name){return s[i].properties[j];}}}if(s[i].methods){for(j=0;j<s[i].methods.length;j++){if(s[i].methods[j].static&&E===s[i].name+"."+s[i].methods[j].name){return s[i].methods[j];}}}}}}
function d(j){var u=j['ui5-metadata'],E={metatype:u&&u.stereotype,name:j.name,module:j.module,baseType:j.extends||undefined,doc:j.description,deprecation:j.deprecated&&j.deprecated.text,since:j.since,experimental:j.experimental&&j.experimental.text,specialSettings:{},properties:{},aggregations:{},associations:{},events:{},values:{},methods:{}},i={},k={getMetadata:true,extend:true},H=/^(?:fn|a|b|d|f|i|j|m|o|r|s|v)([A-Z])(.*)$/;function r(s){var a=H.exec(s);if(a){return a[1].toLowerCase()+a[2];}return s;}function m(a){if(a){if(typeof a==='string'){a=a.split(' ');}a.forEach(function(b){i[b]=true;});}return a;}function p(n,P,s){for(var a in n){if(n.hasOwnProperty(a)){var N=s+"."+n[a].name;P.push({kind:8,name:r(N),type:n[a].type,doc:n[a].description,since:n[a].since,deprecation:n[a].deprecated&&n[a].deprecated.text});if(n[a].parameterProperties){p(n[a].parameterProperties,P,N);}}}}if(u){if(u.specialSettings){u.specialSettings.forEach(function(s){E.specialSettings[s.name]={kind:-1,name:s.name,type:s.type||'any'};});}if(u.properties){u.properties.forEach(function(P){E.properties[P.name]={kind:0,name:P.name,visibility:P.visibility||"public",type:P.type,defaultValue:P.defaultValue,doc:P.description,deprecation:P.deprecated&&P.deprecated.text,deprecationSince:P.deprecated&&P.deprecated.since,experimental:P.experimental&&P.experimental.text,since:P.since,bindable:P.bindable||false,methods:m(P.methods)};});}if(u.aggregations){u.aggregations.forEach(function(a){E.aggregations[a.name]={kind:a.cardinality==="0..1"?1:2,name:a.name,type:a.type,cardinality:a.cardinality||"0..n",visibility:a.visibility||"public",doc:a.description,deprecation:a.deprecated&&a.deprecated.text,experimental:a.experimental&&a.experimental.text,since:a.since,bindable:a.bindable||false,methods:m(a.methods)};});}if(u.associations){u.associations.forEach(function(a){E.associations[a.name]={kind:a.cardinality==="0..n"?4:3,name:a.name,type:a.type,cardinality:a.cardinality||"0..1",visibility:a.visibility||"public",doc:a.description,deprecation:a.deprecated&&a.deprecated.text,experimental:a.experimental&&a.experimental.text,since:a.since,methods:m(a.methods)};});}if(u.events){u.events.forEach(function(o){E.events[o.name]={kind:5,doc:o.description,deprecation:o.deprecated&&o.deprecated.text,since:o.since,parameters:{},methods:m(o.methods)};if(o.parameters){q.each(o.parameters,function(n,P){E.events[o.name].parameters[P.name]={kind:6,name:P.name,type:P.type,doc:P.description,since:P.since,deprecation:P.deprecated&&P.deprecated.text};});}});}}if(j.properties){j.properties.forEach(function(F){E.values[F.name]={kind:9,type:F.type,module:F.module,visibility:F.visibility||'public','static':F['static']||false,doc:F.description,deprecation:F.deprecated&&F.deprecated.text,experimental:F.experimental&&F.experimental.text,since:F.since};});}if(j.methods){j.methods.slice().sort(function(a,b){if(!a.static&&b.static){return-1;}else if(a.static&&!b.static){return 1;}else if(a.name!==b.name){return a.name<b.name?-1:1;}else{return 0;}}).forEach(function(M){E.methods[M.name]={kind:7,type:M.returnValue&&M.returnValue.type||"sap.ui.core.void",module:M.module,visibility:M.visibility||'public','static':M['static']||false,doc:M.description,deprecation:M.deprecated&&M.deprecated.text,since:M.since,parameters:[],synthetic:i.hasOwnProperty(M.name)||(M['static']&&k.hasOwnProperty(M.name))};if(M.parameters){M.parameters.forEach(function(P){E.methods[M.name].parameters.push({kind:8,name:r(P.name),type:P.type,doc:P.description,since:P.since,deprecation:P.deprecated&&P.deprecated.text});if(P.parameterProperties){p(P.parameterProperties,E.methods[M.name].parameters,P.name);}});}});}return E;}
function e(r){r=r==null?q.sap.getModulePath('','/')+'../test-resources/':r;if(r.slice(-1)!='/'){r+='/';}t=r;l={};}
function h(E){var L=g(f(E));var s=c(L,E);return s?d(s):undefined;}
e();return{_setRoot:e,getEntityInfo:h};});
sap.ui.predefine('sap/ui/demokit/util/JSDocUtil',['jquery.sap.global','jquery.sap.strings'],function(q){"use strict";
function d(t,a){return"<code>"+(a||t)+"</code>";}
function f(s,o){o=o||{};var b=o.beforeParagraph==null?'<p>':o.beforeParagraph;var a=o.afterParagraph==null?'</p>':o.afterParagraph;var c=o.beforeFirstParagraph==null?b:o.beforeFirstParagraph;var e=o.afterLastParagraph==null?a:o.afterLastParagraph;var l=typeof o.linkFormatter==='function'?o.linkFormatter:d;var r=/(<pre>)|(<\/pre>)|(<h[\d+]>)|(<\/h[\d+]>)|\{@link\s+([^}\s]+)(?:\s+([^\}]*))?\}|((?:\r\n|\r|\n)[ \t]*(?:\r\n|\r|\n))/gi;var i=false;s=s||'';l=l||d;s=c+s.replace(r,function(m,p,g,h,j,k,n,t){if(p){i=true;}else if(g){i=false;}else if(h){if(!i){return a+m;}}else if(j){if(!i){return m+b;}}else if(t){if(!i){return a+b;}}else if(k){if(!i){return l(k,n);}}return m;})+e;s=s.replace(new RegExp(q.sap.escapeRegExp(b)+"\s*"+q.sap.escapeRegExp(a),"g"),"");return s;}
return{formatTextBlock:f};});
sap.ui.predefine('sap/ui/demokit/util/jsanalyzer/ASTUtils',['jquery.sap.global','sap/ui/demokit/js/esprima'],function(q,e){"use strict";var S=esprima.Syntax;
function u(n){if(n.type==S.AssignmentExpression&&n.left.type==S.Identifier&&n.right.type==S.ObjectExpression){return n.right;}return n;}
function c(n,d){var r;if(n!=null){n=u(n);if(n.type===S.Literal&&d!=null){r={};r[d]={type:S.Property,value:n};return r;}if(n.type!=S.ObjectExpression){q.sap.log.error("not an object literal:"+n.type+":"+n.value);return;}r={};for(var i=0;i<n.properties.length;i++){var p=n.properties[i];var b;if(p.key.type===S.Identifier){b=p.key.name;}else if(p.key.type===S.Literal){b=String(p.key.value);}else{b=p.key.toSource();}r[b]=p;}}return r;}
var a={AssignmentExpression:['left','right'],ArrayExpression:['elements'],BlockStatement:['body'],BinaryExpression:['left','right'],BreakStatement:[],CallExpression:['callee','arguments'],CatchClause:[],ConditionalExpression:['test','consequent','alternate'],ContinueStatement:[],DoWhileStatement:['body','test'],DebuggerStatement:[],EmptyStatement:[],ExpressionStatement:['expression'],ForStatement:['init','test','update','body'],ForInStatement:['left','right','body'],FunctionDeclaration:['id','params','body'],FunctionExpression:['id','params','body'],Identifier:[],IfStatement:['test','consequent','alternate'],Literal:[],LabeledStatement:['body'],LogicalExpression:['left','right'],MemberExpression:['object','property'],NewExpression:['callee','arguments'],ObjectExpression:['properties'],Program:['body'],Property:['key','value'],ReturnStatement:['argument'],SequenceExpression:['expressions'],SwitchStatement:['discriminant','cases'],SwitchCase:['test','consequent'],ThisExpression:[],ThrowStatement:['argument'],TryStatement:[''],UnaryExpression:['argument'],UpdateExpression:['argument'],VariableDeclaration:['declarations'],VariableDeclarator:['id','init'],WhileStatement:['test','body'],WithStatement:['object','body']};
function v(r,d,b){function _(n){if(d["*"]){d["*"].call(d,n,b);}if(d[n.type]){d[n.type].call(d,n,b);}var C=a[n.type];if(C){for(var i=0;i<C.length;i++){var f=n[C[i]];if(q.isArray(f)){for(var j=0;j<f.length;j++){if(f[j]){_(f[j]);}}}else if(f){_(f);}}}else{q.sap.log.warning("don't know how to handle "+n.type);}if(d["after:"+n.type]){d["after:"+n.type].call(d,n,b);}if(d["after:*"]){d["after:*"].call(d,n,b);}}_(r);}
return{createPropertyMap:c,unlend:u,visit:v};},true);
sap.ui.predefine('sap/ui/demokit/util/jsanalyzer/Doclet',['jquery.sap.global'],function(q,e){"use strict";
function u(c){if(!c){return'';}return c.replace(/^\/\*\*+/,'').replace(/\*+\/$/,'').replace(/(^|\r\n|\r|\n)([ \t*]*[ \t]*)/g,'$1');}
var r=/((?:^|\r\n|\r|\n)[ \t]*@)([a-zA-Z][-_a-zA-Z0-9]*)/g;
function D(c){this.comment=c=u(c);this.tags=[];var m;var l=0;var a="description";while((m=r.exec(c))!=null){this._addTag(a,c.slice(l,m.index));a=m[2];l=r.lastIndex;}this._addTag(a,c.slice(l));}
D.prototype._addTag=function(t,c){if(/^(public|private|protected)$/.test(t)){this.visibility=t;}else if(/^(classdesc|description|deprecated|experimental|since|name|alias|type)$/.test(t)){this[t]=q.trim(c);}else if(t==="class"){c=q.trim(c);if(c.split(/\s+/).length>1){this.classdesc=c;}}else{this.tags.push({tag:t,content:q.trim(c)});}};
D.prototype.isPublic=function(){return this.visibility==='public';};
D.get=function(n){var c=null;var l=n.leadingComments;if(q.isArray(l)){for(var i=0;i<l.length;i++){if(l[i].value&&/^\*/.test(l[i].value)){c=l[i].value;}}}return c?new D(c):null;};
return D;},true);
sap.ui.predefine('sap/ui/demokit/util/jsanalyzer/ModuleAnalyzer',['jquery.sap.global','sap/ui/base/ManagedObjectMetadata','./ASTUtils','./Doclet','sap/ui/demokit/js/esprima'],function(q,M,A,D,e){"use strict";var S=esprima.Syntax;var c;var I;var p;var C;var s;var a=A.createPropertyMap;var u=A.unlend;var g=M._guessSingularName;var b=D.get;var d=q.sap.log.error;var w=q.sap.log.warning;var v=q.sap.log.debug;
function f(n){return(n&&n.type===S.CallExpression&&n.callee.type===S.MemberExpression&&n.callee.property.type===S.Identifier&&n.callee.property.name==='extend'&&n.arguments.length>=2&&n.arguments[0].type===S.Literal&&typeof n.arguments[0].value==="string"&&u(n.arguments[1]).type===S.ObjectExpression);}
function h(n){return(n&&n.type===S.CallExpression&&n.callee.type===S.MemberExpression&&k(n.callee)==='sap.ui.define');}
function k(n){if(n.type===S.MemberExpression){var i=k(n.object);return i?i+"."+n.property.name:null;}else if(n.type===S.Identifier){return s[n.name]?s[n.name]:n.name;}else{return null;}}
function l(n,i){var j;if(n.type===S.Literal){return n.value;}else if(n.type===S.UnaryExpression&&n.prefix&&n.argument.type===S.Literal&&typeof n.argument.value==='number'&&(n.operator==='-'||n.operator==='+')){j=n.argument.value;return n.operator==='-'?-j:j;}else if(n.type===S.MemberExpression&&i){j=k(n);if(j.indexOf(i+".")===0){return j.slice(i.length+1);}else if(j.indexOf(i.split(".").slice(-1)[0]+".")===0){return j.slice(i.split(".").slice(-1)[0].length+1);}else{w("did not understand default value '%s', falling back to source",j);return j;}}else if(n.type===S.Identifier&&n.name==='undefined'){return undefined;}else if(n.type===S.ArrayExpression&&n.elements.length===0){return"[]";}d("unexpected type of default value (type='%s', source='%s'), falling back to '???'",n.type,JSON.stringify(n,null,"\t"));return'???';}
function m(i,j){var E=k(i.callee.object);var F={metatype:'control',name:i.arguments[0].value,baseType:E,doc:j&&(j.classdesc||j.description),deprecation:j&&j.deprecated,since:j&&j.since,experimental:j&&j.experimental,specialSettings:{},properties:{},aggregations:{},associations:{},events:{},methods:{}};function G(n){return n.slice(0,1).toUpperCase()+n.slice(1);}function H(N,O,P){var Q,n,R,T;Q=N&&a(N.value);if(Q){for(n in Q){if(Q.hasOwnProperty(n)){T=b(Q[n]);R=a(Q[n].value,O);if(R==null){d("no valid metadata for "+n+" (AST type '"+Q[n].value.type+"')");continue;}P(n,R,T,Q[n]);}}}}var J=u(i.arguments[1]);var K=a(J);if(K&&K.metadata&&K.metadata.value.type!==S.ObjectExpression){w("class metadata exists but can't be analyzed. It is not of type 'ObjectExpression', but a '"+K.metadata.value.type+"'.");return null;}var L=K&&K.metadata&&a(K.metadata.value);if(L){v("  analyzing metadata for '"+F.name+"'");F["abstract"]=!!(L["abstract"]&&L["abstract"].value.value);F["final"]=!!(L["final"]&&L["final"].value.value);H(L.specialSettings,"readonly",function(n,N,O){F.specialSettings[n]={name:n,doc:O&&O.description,since:O&&O.since,deprecation:O&&O.deprecated,experimental:O&&O.experimental,visibility:(N.visibility&&N.visibility.value.value)||"public",type:N.type?N.type.value.value:"any",readonly:(N.readyonly&&N.readonly.value.value)||true};});H(L.properties,"type",function(n,O,P){var Q;var N=G(n);var R;F.properties[n]={name:n,doc:P&&P.description,since:P&&P.since,deprecation:P&&P.deprecated,experimental:P&&P.experimental,visibility:(O.visibility&&O.visibility.value.value)||"public",type:(Q=O.type?O.type.value.value:"string"),defaultValue:O.defaultValue?l(O.defaultValue.value,Q):null,group:O.group?O.group.value.value:'Misc',bindable:O.bindable?!!l(O.bindable.value):false,methods:(R={"get":"get"+N,"set":"set"+N})};if(F.properties[n].bindable){R["bind"]="bind"+N;R["unbind"]="unbind"+N;}});F.defaultAggregation=(L.defaultAggregation&&L.defaultAggregation.value.value)||undefined;H(L.aggregations,"type",function(n,O,P){var N=G(n);var Q;F.aggregations[n]={name:n,doc:P&&P.description,deprecation:P&&P.deprecated,since:P&&P.since,experimental:P&&P.experimental,visibility:(O.visibility&&O.visibility.value.value)||"public",type:O.type?O.type.value.value:"sap.ui.core.Control",singularName:O.singularName?O.singularName.value.value:g(n),cardinality:(O.multiple&&!O.multiple.value.value)?"0..1":"0..n",bindable:O.bindable?!!l(O.bindable.value):false,methods:(Q={"get":"get"+N,"destroy":"destroy"+N})};if(F.aggregations[n].cardinality==="0..1"){Q["set"]="set"+N;}else{var R=G(F.aggregations[n].singularName);Q["insert"]="insert"+R;Q["add"]="add"+R;Q["remove"]="remove"+R;Q["indexOf"]="indexOf"+R;Q["removeAll"]="removeAll"+N;}if(F.aggregations[n].bindable){Q["bind"]="bind"+N;Q["unbind"]="unbind"+N;}});H(L.associations,"type",function(n,O,P){var N=G(n);var Q;F.associations[n]={name:n,doc:P&&P.description,deprecation:P&&P.deprecated,since:P&&P.since,experimental:P&&P.experimental,visibility:(O.visibility&&O.visibility.value.value)||"public",type:O.type?O.type.value.value:"sap.ui.core.Control",singularName:O.singularName?O.singularName.value.value:g(n),cardinality:(O.multiple&&O.multiple.value.value)?"0..n":"0..1",methods:(Q={"get":"get"+N})};if(F.associations[n].cardinality==="0..1"){Q["set"]="set"+N;}else{var R=G(F.associations[n].singularName);Q["add"]="add"+R;Q["remove"]="remove"+R;Q["removeAll"]="removeAll"+N;}});H(L.events,null,function(n,O,P){var N=G(n);var Q=F.events[n]={name:n,doc:P&&P.description,deprecation:P&&P.deprecated,since:P&&P.since,experimental:P&&P.experimental,allowPreventDefault:!!(O.allowPreventDefault&&O.allowPreventDefault.value.value),parameters:{},methods:{"attach":"attach"+N,"detach":"detach"+N,"fire":"fire"+N}};H(O.parameters,null,function(R,T,U){Q.parameters[R]={name:R,doc:U&&U.description,deprecation:U&&U.deprecated,since:U&&U.since,experimental:U&&U.experimental,type:T&&T.type?T.type.value.value:""};});});}return F;}
function o(n){var j=D.get(n);var E=k(n.expression.left);if(E&&j&&j.isPublic()){var T={metatype:"type",doc:undefined,deprecation:false,visibility:'public'};T.name=E;if(j){T.doc=j.description;T.deprecation=j.deprecation;T.since=j.since;T.experimental=j.experimental;}var F=n.expression.right.properties||[];T.values={};for(var i=0;i<F.length;i++){var G=D.get(F[i]);var H=F[i].key;var J=F[i].value;var K={};if(H.type==S.Identifier){K.name=H.name;}else if(H.type==S.Literal){K.name=H.value;}else{throw new Error();}if(J.type==S.Literal){K.value=J.value;}else{throw new Error();}if(G!=null){K.doc=G.description;K.deprecation=G.deprecation;K.since=G.since;K.experimental=G.experimental;}T.values[K.name]=K;}I.push(T);}}
function r(n){var i=D.get(n);var j=n.expression.right.arguments[0].value;var E=A.createPropertyMap(n.expression.right.arguments[1]);var F=null;if(n.expression.right.arguments.length>2&&n.expression.right.arguments[2].type==S.CallExpression&&n.expression.right.arguments[2].callee.type==S.MemberExpression&&k(n.expression.right.arguments[2].callee)=="sap.ui.base.DataType.getType"&&n.expression.right.arguments[2].arguments.length>0&&n.expression.right.arguments[2].arguments[0].type==S.Literal){F=n.expression.right.arguments[2].arguments[0].value;}if(j&&i&&i.isPublic()){var T={metatype:"type",doc:undefined,deprecation:false,visibility:'public'};T.name=j;if(i){T.doc=i.description;T.deprecation=i.deprecation;T.since=i.since;T.experimental=i.experimental;}var G=E.defaultValue;if(G){T.defaultValue=l(G.value,j);}var H=E.isValid;if(H&&H.value.type==S.FunctionExpression&&H.value.body&&H.value.body.body.length>0&&H.value.body.body[0].type==S.ReturnStatement&&H.value.body.body[0].argument.type==S.CallExpression&&H.value.body.body[0].argument.callee.type==S.MemberExpression&&H.value.body.body[0].argument.callee.object.type==S.Literal&&H.value.body.body[0].argument.callee.object.value instanceof RegExp){var J=H.value.body.body[0].argument.callee.object.value.source;if(/^\^\(.*\)\$$/.test(J)){J=J.slice(2,-2);}T.pattern=J;}T.baseType=F;I.push(T);}}
function t(i){return/^\.\//.test(i)?c+i.slice(1):i;}
function x(P,j){var n='',E='',F,G,H=/{(.*)}/,J;for(var i=0;i<j.length;i++){if(j[i].tag!=='param'){continue;}J=H.exec(j[i].content);F=j[i].content.indexOf(P);if(J&&F>-1){n=J[1];G=F+P.length;E=j[i].content.substr(G);E=E.replace(/[-]/,'').trim();break;}}return{name:P,type:n,doc:E};}
var y={"ExpressionStatement":function(n){if(h(n.expression)){var i=0;var E,F;if(i<n.expression.arguments.length&&n.expression.arguments[i].type===S.Literal){n.expression.arguments[i++].value;}if(i<n.expression.arguments.length&&n.expression.arguments[i].type===S.ArrayExpression){E=n.expression.arguments[i++].elements;}if(i<n.expression.arguments.length&&n.expression.arguments[i].type===S.FunctionExpression){F=n.expression.arguments[i++];}if(E&&F&&F.params){for(var j=0;j<E.length;j++){var G=E[j].type===S.Literal?t(E[j].value):null;var H=j<F.params.length?F.params[j].name:null;if(G&&H){s[H]=G.replace(/\//g,'.');}}}}if(n.expression.type==S.AssignmentExpression&&n.expression.right.type==S.ObjectExpression&&n.expression.left.type==S.MemberExpression){o(n);}if(n.expression.type===S.AssignmentExpression&&n.expression.right.type===S.CallExpression&&n.expression.right.callee.type===S.MemberExpression&&n.expression.right.callee.property.type===S.Identifier&&n.expression.right.callee.property.name==='createType'&&k(n.expression.right.callee.object)=='sap.ui.base.DataType'&&n.expression.right.arguments.length>=2&&n.expression.right.arguments[0].type===S.Literal&&n.expression.right.arguments[1].type===S.ObjectExpression){r(n);}if(f(n.expression)){var J=D.get(n)||D.get(n.expression);var K=m(n.expression,J);if(K){I.push(K);}}},"VariableDeclaration":function(n){if(n.declarations.length==1&&n.declarations[0].init&&f(n.declarations[0].init)){var i=D.get(n)||D.get(n.declarations[0]);var j=m(n.declarations[0].init,i);if(j){I.push(j);}}},"FunctionExpression":function(n){var F=n.body.body;F.forEach(function(i){if(i.expression&&i.expression.type!==S.AssignmentExpression){return;}var P=i;var j=D.get(i);if(j&&j.isPublic()&&P.expression&&P.expression.left&&P.expression.left.property&&P.expression.left.object&&P.expression.left.object.object&&P.expression.left.object.object.name===C){var E={},G=P.expression.right.params?P.expression.right.params:[];E.name=P.expression.left.property.name;E.doc=j.description;E.since=j.since;E.experimental=j.experimental;E.deprecation=j.deprecated;E.type=j.type?j.type:'';E.parameters=[];G.forEach(function(H){var J=x(H.name,j.tags);E.parameters.push(J);});p[E.name]=E;}});}};
function z(i){i.methods=p;}
function B(j,E,n){c=n.split('/').slice(0,-1).join('/');I=[];p={};s={};C=E.split('.').pop();var F=esprima.parse(j,{comment:true,attachComment:true});A.visit(F,y);for(var i=0;i<I.length;i++){if(I[i].name===E){z(I[i]);return I[i];}}}
return{analyze:B};},false);
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/demokit/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/demokit/demoapps/manifest.json":'{\n\t"_version": "1.8.0",\n\t"sap.app": {\n\t\t"id": "sap.ui.demokit.demoapps",\n\t\t"type": "application",\n\t\t"i18n": "i18n/i18n.properties",\n\t\t"title": "{{appTitle}}",\n\t\t"description": "{{appDescription}}",\n\t\t"applicationVersion": {\n\t\t\t"version": "1.0.0"\n\t\t}\n\t},\n\t"sap.ui": {\n\t\t"technology": "UI5",\n\t\t"icons": {\n\t\t\t"icon": "sap-icon://detail-view",\n\t\t\t"favIcon": "",\n\t\t\t"phone": "",\n\t\t\t"phone@2": "",\n\t\t\t"tablet": "",\n\t\t\t"tablet@2": ""\n\t\t},\n\t\t"deviceTypes": {\n\t\t\t"desktop": true,\n\t\t\t"tablet": true,\n\t\t\t"phone": true\n\t\t},\n\t\t"supportedThemes": [\n\t\t\t"sap_hcb",\n\t\t\t"sap_belize"\n\t\t]\n\t},\n\t"sap.ui5": {\n\t\t"rootView": {\n\t\t\t"viewName": "sap.ui.demokit.demoapps.view.App",\n\t\t\t"type": "XML",\n\t\t\t"id": "app"\n\t\t},\n\t\t"resources": {\n\t\t\t"css": [\n\t\t\t\t{\n\t\t\t\t\t"uri": "css/style.css"\n\t\t\t\t}\n\t\t\t]\n\t\t},\n\t\t"dependencies": {\n\t\t\t"minUI5Version": "1.30",\n\t\t\t"libs": {\n\t\t\t\t"sap.ui.core": {},\n\t\t\t\t"sap.m": {},\n\t\t\t\t"sap.ui.layout": {}\n\t\t\t}\n\t\t},\n\t\t"contentDensities": {\n\t\t\t"compact": true,\n\t\t\t"cozy": true\n\t\t},\n\t\t"models": {\n\t\t\t"i18n": {\n\t\t\t\t"type": "sap.ui.model.resource.ResourceModel",\n\t\t\t\t"settings": {\n\t\t\t\t\t"bundleName": "sap.ui.demokit.demoapps.i18n.i18n"\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}',
	"sap/ui/demokit/demoapps/view/App.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.demokit.demoapps.controller.App"\n\txmlns="sap.m"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout"\n\tdisplayBlock="true">\n\t<App\n\t\tid="app"\n\t\tclass="sapUiDemoApps">\n\t\t<Page showHeader="false" enableScrolling="false">\n\t\t\t<ScrollContainer vertical="true" width="100%" height="100%">\n\t\t\t\t<l:BlockLayout\n\t\t\t\t\tid="headerLayout"\n\t\t\t\t\tbackground="Light">\n\t\t\t\t\t<l:BlockLayoutRow>\n\t\t\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="gradient sapUiContentPadding">\n\t\t\t\t\t\t\t<l:Grid\n\t\t\t\t\t\t\t\thSpacing="0"\n\t\t\t\t\t\t\t\tdefaultSpan="L6 M6 S12">\n\t\t\t\t\t\t\t\t<l:VerticalLayout class="sapUiTinyMarginEnd">\n\t\t\t\t\t\t\t\t\t<Title\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>pageTitle}"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiMediumMarginBottom"/>\n\t\t\t\t\t\t\t\t\t<Button\n\t\t\t\t\t\t\t\t\t\tid="download"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>downloadButtonText}"\n\t\t\t\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\t\t\t\tpress="onDownloadButtonPress"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://download">\n\t\t\t\t\t\t\t\t\t</Button>\n\t\t\t\t\t\t\t\t\t<Link\n\t\t\t\t\t\t\t\t\t\t\ttext="{i18n>linkText}"\n\t\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\t\thref="#docs/guide/a3ab54ecf7ac493b91904beb2095d208.html"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginTop readMoreLink" />\n\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\t\tsrc="resources/sap/ui/demokit/demoapps/img/demoAppsTeaser.png"\n\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\twidth="100%"/>\n\t\t\t\t\t\t\t</l:Grid>\n\t\t\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t\t</l:BlockLayoutRow>\n\t\t\t\t</l:BlockLayout>\n\t\t\t\t<l:BlockLayout\n\t\t\t\t\tid="demoAppsLayout"\n\t\t\t\t\tcontent="{\n\t\t\t\t\t\tpath: \'/demoAppsByCategory\'\n\t\t\t\t\t}"\n\t\t\t\t\tbackground="Light">\n\t\t\t\t\t<l:BlockLayoutRow content="{\n\t\t\t\t\t\tpath: \'\',\n\t\t\t\t\t\tfactory: \'.createDemoAppRow\'\n\t\t\t\t\t}"/>\n\t\t\t\t</l:BlockLayout>\n\t\t\t</ScrollContainer>\n\t\t\t<dependents>\n\t\t\t\t<SelectDialog id="downloadDialog"\n\t\t\t\t\titems="{/demoApps}"\n\t\t\t\t\ttitle="{i18n>downloadDialogTitle}"\n\t\t\t\t\tliveChange="onSearch"\n\t\t\t\t\tgrowingThreshold="100"\n\t\t\t\t\tconfirm="onDownloadPress">\n\t\t\t\t\t<InputListItem\n\t\t\t\t\t\tvisible="{= !!${config} }"\n\t\t\t\t\t\tlabel="{name}"\n\t\t\t\t\t\ttype="Active"\n\t\t\t\t\t\ticon="sap-icon://{icon}">\n\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t<core:CustomData key="config" value="{config}"/>\n\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t<Button\n\t\t\t\t\t\t\ttext="{i18n>downloadButtonText}"\n\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\tpress="onDownloadPress"/>\n\t\t\t\t\t</InputListItem>\n\t\t\t\t</SelectDialog>\n\t\t\t</dependents>\n\t\t</Page>\n\t</App>\n</mvc:View>\n',
	"sap/ui/demokit/demoapps/view/BlockLayoutCell.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout">\n\t<l:BlockLayoutCell\n\t\tclass="sapUiContentPadding"\n\t\twidth="2">\n\t\t<l:VerticalLayout width="100%">\n\t\t\t<core:Icon\n\t\t\t\tsrc="{icon}"\n\t\t\t\tsize="2rem"\n\t\t\t\tcolor="Default">\n\t\t\t</core:Icon>\n\t\t\t<Title\n\t\t\t\tlevel="H1"\n\t\t\t\ttitleStyle="H1"\n\t\t\t\ttext="{name}"\n\t\t\t\tclass="sapUiTinyMarginTop"/>\n\t\t\t<Text\n\t\t\t\ttext="{desc}"\n\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t<Link\n\t\t\t\thref="{ref}"\n\t\t\t\ttarget="_blank"\n\t\t\t\ttext="{i18n>demoAppTileLaunchDemo}"\n\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\temphasized="true"/>\n\t\t\t<Label\n\t\t\t\ttext="{i18n>demoAppTileLinkTitle}"\n\t\t\t\tvisible="{= ${links}.length === 0 ? false : true }"\n\t\t\t\tdesign="Bold"/>\n\t\t\t<l:VerticalLayout\n\t\t\t\tcontent="{links}"\n\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\tvisible="{= ${links}.length === 0 ? false : true }">\n\t\t\t\t<Link\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'ref\',\n\t\t\t\t\t\tformatter: \'.formatter.crossLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\ttext="{name}"/>\n\t\t\t</l:VerticalLayout>\n\t\t\t<l:HorizontalLayout>\n\t\t\t\t<Label\n\t\t\t\t\ttext="{i18n>demoAppTileLibrary}"\n\t\t\t\t\tclass="sapUiTinyMarginEnd"/>\n\t\t\t\t<Link\n\t\t\t\t\ttext="{lib}"\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\tenabled="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLinkEnabled\'\n\t\t\t\t\t}"\n\t\t\t\t\tsubtle="true"/>\n\t\t\t</l:HorizontalLayout>\n\t\t</l:VerticalLayout>\n\t</l:BlockLayoutCell>\n</core:FragmentDefinition>',
	"sap/ui/demokit/demoapps/view/BlockLayoutHeadlineCell.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout">\n\t<l:BlockLayoutCell\n\t\tclass="sapUiContentPadding headlineCell"\n\t\twidth="2">\n\t\t<l:content>\n\t\t\t<Title\n\t\t\t\tlevel="H3"\n\t\t\t\ttitleStyle="H3"\n\t\t\t\ttext="{\n\t\t\t\t\tpath: \'categoryId\',\n\t\t\t\t\tformatter: \'.formatter.categoryName\'\n\t\t\t\t}"/>\n\t\t</l:content>\n\t</l:BlockLayoutCell>\n</core:FragmentDefinition>',
	"sap/ui/demokit/demoapps/view/BlockLayoutTeaserCell.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout">\n<l:BlockLayoutCell\n\tclass="sapUiContentPadding"\n\twidth="4">\n\t<l:Grid\n\t\thSpacing="0"\n\t\tdefaultSpan="L6 M12 S12">\n\t\t<l:VerticalLayout class="sapUiTinyMarginEnd" width="100%">\n\t\t\t<core:Icon\n\t\t\t\tsrc="{icon}"\n\t\t\t\tsize="2rem"\n\t\t\t\tcolor="Default">\n\t\t\t</core:Icon>\n\t\t\t<Title\n\t\t\t\tlevel="H1"\n\t\t\t\ttitleStyle="H1"\n\t\t\t\ttext="{name}"\n\t\t\t\tclass="sapUiTinyMarginTop"/>\n\t\t\t<Text\n\t\t\t\ttext="{desc}"\n\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t<Link\n\t\t\t\thref="{ref}"\n\t\t\t\ttarget="_blank"\n\t\t\t\ttext="{i18n>demoAppTileLaunchDemo}"\n\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\temphasized="true"/>\n\t\t\t<Label\n\t\t\t\ttext="{i18n>demoAppTileLinkTitle}"\n\t\t\t\tvisible="{= ${links}.length === 0 ? false : true }"\n\t\t\t\tdesign="Bold"/>\n\t\t\t<l:VerticalLayout\n\t\t\t\tcontent="{links}"\n\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\tvisible="{= ${links}.length === 0 ? false : true }">\n\t\t\t\t<Link\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'ref\',\n\t\t\t\t\t\tformatter: \'.formatter.crossLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\ttext="{name}"/>\n\t\t\t</l:VerticalLayout>\n\t\t\t<l:HorizontalLayout>\n\t\t\t\t<Label\n\t\t\t\t\ttext="{i18n>demoAppTileLibrary}"\n\t\t\t\t\tclass="sapUiTinyMarginEnd"/>\n\t\t\t\t<Link\n\t\t\t\t\ttext="sap.m"\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\tenabled="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLinkEnabled\'\n\t\t\t\t\t}"\n\t\t\t\t\tsubtle="true"/>\n\t\t\t</l:HorizontalLayout>\n\t\t</l:VerticalLayout>\n\t</l:Grid>\n</l:BlockLayoutCell>\n</core:FragmentDefinition>',
	"sap/ui/demokit/explored/view/appSettingsDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:f="sap.ui.layout.form"\n\t\txmlns:core="sap.ui.core">\n\t<Dialog\n\t\t\ttitle="Settings"\n\t\t\tclass="sapUiPopupWithPadding"\n\t\t\tcontentWidth="350px"\n\t\t\tid="AppSettingsDialog">\n\t\t<content>\n\t\t\t<l:Grid\n\t\t\t\t\tclass="sapUiSmallMarginTop"\n\t\t\t\t\thSpacing="0.5"\n\t\t\t\t\tvSpacing="0.5"\n\t\t\t\t\tdefaultSpan="L6 M6 S10">\n\t\t\t\t<l:content>\n\t\t\t\t\t<Label text="Theme:" design="Standard" id="ThemeLabel">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<l:GridData span="L12 M12 S12"/>\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</Label>\n\n\t\t\t\t\t<Select id="ThemeButtons" width="100%">\n\t\t\t\t\t\t<core:Item key="sap_belize" text="Belize"/>\n\t\t\t\t\t\t<core:Item key="sap_belize_plus" text="Belize Deep"/>\n\t\t\t\t\t\t<core:Item key="sap_belize_hcb" text="High Contrast Black"/>\n\t\t\t\t\t\t<core:Item key="sap_belize_hcw" text="High Contrast White"/>\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<l:GridData span="L12 M12 S12"/>\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</Select>\n\n\t\t\t\t\t<Label id="CompactModeLabel" text="Compact Content Density:" design="Standard">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<l:GridData span="L8 M8 S8"/>\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</Label>\n\t\t\t\t\t<Switch id="CompactModeButtons" state="false">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<l:GridData span="L4 M4 S4"/>\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</Switch>\n\n\t\t\t\t\t<Label id="RTLLabel" text="Right To Left Mode:" design="Standard">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<l:GridData span="L8 M8 S8"/>\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</Label>\n\t\t\t\t\t<Switch id="RTLButtons" state="false">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<l:GridData span="L4 M4 S4"/>\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</Switch>\n\t\t\t\t</l:content>\n\t\t\t</l:Grid>\n\t\t</content>\n\t\t<beginButton>\n\t\t\t<Button text="OK" press="onSaveAppSettings"/>\n\t\t</beginButton>\n\t\t<endButton>\n\t\t\t<Button text="Cancel" press="onDialogCloseButton"/>\n\t\t</endButton>\n\t</Dialog>\n</core:FragmentDefinition>\n\n',
	"sap/ui/demokit/explored/view/code.view.xml":'<mvc:View\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout"\n\txmlns:d="sap.ui.demokit"\n\tcontrollerName="sap.ui.demokit.explored.view.code"\n\txmlns="sap.m">\n\t<Page\n\t\tid="page"\n\t\tshowNavButton="true"\n\t\tnavButtonPress="onNavBack"\n\t\ttitle="{/title}"\n\t\ticon="img/144_iPad_Retina_Web_Clip.png" >\n\t\t<landmarkInfo>\n\t\t\t<PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"></PageAccessibleLandmarkInfo>\n\t\t</landmarkInfo>\n\t\t<headerContent>\n\t\t\t<Button\n\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\ttext="Download"\n\t\t\t\ticon="sap-icon://download"\n\t\t\t\tpress="onDownload" />\n\t\t\t<Button\n\t\t\t\tclass="sapUiVisibleOnlyOnPhone"\n\t\t\t\ticon="sap-icon://download"\n\t\t\t\tpress="onDownload" />\n\t\t</headerContent>\n\t\t<content>\n\t\t\t<IconTabBar\n\t\t\t\t\tclass="sapUiContentPadding"\n\t\t\t\t\texpandable="false"\n\t\t\t\t\tselectedKey="{/fileName}"\n\t\t\t\t\tselect="handleTabSelectEvent"\n\t\t\t\t\titems="{/files}" >\n\t\t\t\t<items>\n\t\t\t\t\t<IconTabFilter\n\t\t\t\t\t\t\tkey="{name}"\n\t\t\t\t\t\t\ttext="{name}" >\n\t\t\t\t\t\t<content>\n\t\t\t\t\t\t\t<d:CodeViewer class="sapUiExploredCodeViewer" source="{raw}" lineNumbering="true"/>\n\t\t\t\t\t\t</content>\n\t\t\t\t\t</IconTabFilter>\n\t\t\t\t</items>\n\t\t\t</IconTabBar>\n\t\t</content>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/demokit/explored/view/entity.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.demokit.explored.view.entity"\n\txmlns:l="sap.ui.layout"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns:core="sap.ui.core"\n\txmlns:f="sap.ui.layout.form"\n\txmlns="sap.m">\n\t<Page\n\t\ttitle="Entity"\n\t\tclass="sapUiFioriObjectPage"\n\t\tnavButtonPress="onNavBack"\n\t\tid="page">\n\t\t<landmarkInfo>\n\t\t\t<PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"></PageAccessibleLandmarkInfo>\n\t\t</landmarkInfo>\n\t\t<headerContent>\n\t\t\t<Button\n\t\t\t    id="toggleFullScreenBtn"\n\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\ttooltip="{i18n>sampleFullScreenTooltip}"\n\t\t\t\tpress="onToggleFullScreen" />\n\t\t</headerContent>\n\n\t\t<ObjectHeader\n\t\t\tid="entityHeader"\n\t\t\ttitle="{/name}"\n\t\t\tresponsive="true"\n\t\t\tbackgroundDesign="Translucent"\n\t\t\tnumber="{/deprecatedMark}"\n\t\t\tnumberState="Warning"\n\t\t\tintro="{/shortDescription}"\n\t\t\tintroActive="{/show/introLink}"\n\t\t\tintroPress="onIntroLinkPress">\n\n\t\t\t<attributes>\n\t\t\t\t<ObjectAttribute\n\t\t\t\t\ttitle="Application Component"\n\t\t\t\t\ttext="{/appComponent}" />\n\t\t\t\t<ObjectAttribute\n\t\t\t\t\ttitle="Available Since"\n\t\t\t\t\ttext="{entity>since}" />\n\t\t\t\t<ObjectAttribute\n\t\t\t\t\ttitle="Inherits from"\n\t\t\t\t\ttext="{/baseTypeText}"\n\t\t\t\t\tactive="{/baseTypeNav}"\n\t\t\t\t\tpress="onTypeLinkPress" >\n\t\t\t\t\t<customData>\n\t\t\t\t\t\t<core:CustomData key="type" value="{/baseType}" />\n\t\t\t\t\t</customData>\n\t\t\t\t</ObjectAttribute>\n\t\t\t\t<ObjectAttribute\n\t\t\t\t\ttitle="Content Density"\n\t\t\t\t\ttext="{entity>formFactors}" />\n\t\t\t\t<ObjectAttribute\n\t\t\t\t\ttitle="Category"\n\t\t\t\t\ttext="{entity>category}" />\n\t\t\t</attributes>\n\n\t\t\t<headerContainer>\n\n\n\t\t\t\t<IconTabBar\n\t\t\t\t\tid="tabBar"\n\t\t\t\t\texpanded="{device>/isNoPhone}"\n\t\t\t\t\tselect="onTabSelect"\n\t\t\t\t\tupperCase="true"\n\t\t\t\t\tclass="sapUiResponsiveContentPadding">\n\t\t\t\t\t<items>\n\n\t\t\t\t\t\t<IconTabFilter\n\t\t\t\t\t\t\tkey="about"\n\t\t\t\t\t\t\ttext="About"\n\t\t\t\t\t\t\tvisible="{/show/about}" >\n\t\t\t\t\t\t\t<core:HTML content="{/description}" />\n\t\t\t\t\t\t\t<Table\n\t\t\t\t\t\t\t\tclass="myTable"\n\t\t\t\t\t\t\t\tvisible="{/show/values}"\n\t\t\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\titems="{/values}" >\n\t\t\t\t\t\t\t\t<columns>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Name" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader"><Label text="Description" /></Column>\n\t\t\t\t\t\t\t\t</columns>\n\t\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t\t<ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t<cells>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{name}" class="docuKey" wrapping="false" />\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{doc}" />\n\t\t\t\t\t\t\t\t\t\t</cells>\n\t\t\t\t\t\t\t\t\t</ColumnListItem>\n\t\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t\t</Table>\n\t\t\t\t\t\t</IconTabFilter>\n\n\t\t\t\t\t\t<IconTabFilter\n\t\t\t\t\t\t\tkey="samples"\n\t\t\t\t\t\t\tcount="{/count/samples}"\n\t\t\t\t\t\t\ttext="Samples"\n\t\t\t\t\t\t\tvisible="{/show/samples}" >\n\t\t\t\t\t\t\t<Table\n\t\t\t\t\t\t\t\tclass="myTable"\n\t\t\t\t\t\t\t\tid="table"\n\t\t\t\t\t\t\t\titems="{entity>samples}"\n\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\tshowSeparators="Inner" >\n\t\t\t\t\t\t\t\t<columns>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Name" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet"><Label text="Description" /></Column>\n\t\t\t\t\t\t\t\t</columns>\n\t\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t\t<ColumnListItem type="Navigation" press="onNavToSample" vAlign="Middle">\n\t\t\t\t\t\t\t\t\t\t<cells>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{entity>name}" class="entitySampleName" wrapping="false" />\n\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{path: \'entity>description\', formatter:\'.descriptionText\'}" sanitizeContent="true"></core:HTML>\n\t\t\t\t\t\t\t\t\t\t</cells>\n\t\t\t\t\t\t\t\t\t</ColumnListItem>\n\t\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t\t</Table>\n\t\t\t\t\t\t</IconTabFilter>\n\n\t\t\t\t\t\t<IconTabFilter\n\t\t\t\t\t\t\tkey="properties"\n\t\t\t\t\t\t\ttext="Properties"\n\t\t\t\t\t\t\tcount="{/count/properties}"\n\t\t\t\t\t\t\tvisible="{/show/properties}" >\n\t\t\t\t\t\t\t<Table\n\t\t\t\t\t\t\t\tclass="myTable"\n\t\t\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\twidth=""\n\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\tpath:\'/properties\',\n\t\t\t\t\t\t\t\t\tsorter: {\n\t\t\t\t\t\t\t\t\t\tpath: \'name\',\n\t\t\t\t\t\t\t\t\t\tdescending: false\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}" >\n\t\t\t\t\t\t\t\t<columns>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Name" /></Column>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Type" /></Column>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Default" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader"><Label text="Description" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="false"><Label text="Since" /></Column>\n\t\t\t\t\t\t\t\t</columns>\n\t\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t\t<ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t<cells>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{name}" class="docuKey" wrapping="false">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData writeToDom="true" key="deprecated" value="{deprecated}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Text>\n\t\t\t\t\t\t\t\t\t\t\t<Link text="{typeText}" enabled="{typeNav}" press="onTypeLinkPress">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData key="type" value="{type}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Link>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{defaultValue}" wrapping="false" />\n\t\t\t\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{doc}" />\n\t\t\t\t\t\t\t\t\t\t\t\t<ObjectStatus\n\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{deprecatedDescription}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="Warning"\t/>\n\t\t\t\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t<Label text="{since}" />\n\t\t\t\t\t\t\t\t\t\t</cells>\n\t\t\t\t\t\t\t\t\t</ColumnListItem>\n\t\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t\t</Table>\n\t\t\t\t\t\t</IconTabFilter>\n\n\t\t\t\t\t\t<IconTabFilter\n\t\t\t\t\t\t\tkey="aggregations"\n\t\t\t\t\t\t\ttext="Aggregations"\n\t\t\t\t\t\t\tcount="{/count/aggregations}"\n\t\t\t\t\t\t\tvisible="{/show/aggregations}" >\n\t\t\t\t\t\t\t<Table\n\t\t\t\t\t\t\t\tclass="myTable"\n\t\t\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\tpath:\'/aggregations\',\n\t\t\t\t\t\t\t\t\tsorter: {\n\t\t\t\t\t\t\t\t\t\tpath: \'name\',\n\t\t\t\t\t\t\t\t\t\tdescending: false\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}" >\n\t\t\t\t\t\t\t\t<columns>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Name" /></Column>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Cardinality" /></Column>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Type" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader"><Label text="Description" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="false"><Label text="Since" /></Column>\n\t\t\t\t\t\t\t\t</columns>\n\t\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t\t<ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t<cells>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{name}" class="docuKey" wrapping="false">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData writeToDom="true" key="deprecated" value="{deprecated}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Text>\n\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{cardinality}" wrapping="false" />\n\t\t\t\t\t\t\t\t\t\t\t<Link text="{typeText}" enabled="{typeNav}" press="onTypeLinkPress">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData key="type" value="{type}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Link>\n\t\t\t\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{doc}" />\n\t\t\t\t\t\t\t\t\t\t\t\t<ObjectStatus\n\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{deprecatedDescription}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="Warning"\t/>\n\t\t\t\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t<Label text="{since}" />\n\t\t\t\t\t\t\t\t\t\t</cells>\n\t\t\t\t\t\t\t\t\t</ColumnListItem>\n\t\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t\t</Table>\n\t\t\t\t\t\t</IconTabFilter>\n\n\t\t\t\t\t\t<IconTabFilter\n\t\t\t\t\t\t\tkey="associations"\n\t\t\t\t\t\t\ttext="Associations"\n\t\t\t\t\t\t\tcount="{/count/associations}"\n\t\t\t\t\t\t\tvisible="{/show/associations}" >\n\t\t\t\t\t\t\t<Table\n\t\t\t\t\t\t\t\tclass="myTable"\n\t\t\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\tpath:\'/associations\',\n\t\t\t\t\t\t\t\t\tsorter: {\n\t\t\t\t\t\t\t\t\t\tpath: \'name\',\n\t\t\t\t\t\t\t\t\t\tdescending: false\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}" >\n\t\t\t\t\t\t\t\t<columns>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Name" /></Column>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Cardinality" /></Column>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Type" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader"><Label text="Description" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="false"><Label text="Since" /></Column>\n\t\t\t\t\t\t\t\t</columns>\n\t\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t\t<ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t<cells>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{name}" class="docuKey" wrapping="false">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData writeToDom="true" key="deprecated" value="{deprecated}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Text>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{cardinality}" wrapping="false" />\n\t\t\t\t\t\t\t\t\t\t\t<Link text="{typeText}" enabled="{typeNav}" press="onTypeLinkPress">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData key="type" value="{type}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Link>\n\t\t\t\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{doc}" />\n\t\t\t\t\t\t\t\t\t\t\t\t<ObjectStatus\n\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{deprecatedDescription}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="Warning"\t/>\n\t\t\t\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t<Label text="{since}" />\n\t\t\t\t\t\t\t\t\t\t</cells>\n\t\t\t\t\t\t\t\t\t</ColumnListItem>\n\t\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t\t</Table>\n\t\t\t\t\t\t</IconTabFilter>\n\n\t\t\t\t\t\t<IconTabFilter\n\t\t\t\t\t\t\tkey="events"\n\t\t\t\t\t\t\ttext="Events"\n\t\t\t\t\t\t\tcount="{/count/events}"\n\t\t\t\t\t\t\tvisible="{/show/events}" >\n\t\t\t\t\t\t\t<Table\n\t\t\t\t\t\t\t\tclass="myTable"\n\t\t\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\titems="{/events}" >\n\t\t\t\t\t\t\t\t<columns>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Name" /></Column>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Param" /></Column>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Type" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader"><Label text="Description" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="false"><Label text="Since" /></Column>\n\t\t\t\t\t\t\t\t</columns>\n\t\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t\t<ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t<cells>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{name}" class="docuKey" wrapping="false">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData writeToDom="true" key="deprecated" value="{deprecated}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Text>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{param}" class="docuParam" wrapping="false" />\n\t\t\t\t\t\t\t\t\t\t\t<Link text="{typeText}" enabled="{typeNav}" press="onTypeLinkPress">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData key="type" value="{type}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Link>\n\t\t\t\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{doc}" />\n\t\t\t\t\t\t\t\t\t\t\t\t<ObjectStatus\n\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{deprecatedDescription}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="Warning"\t/>\n\t\t\t\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t<Label text="{since}" />\n\t\t\t\t\t\t\t\t\t\t</cells>\n\t\t\t\t\t\t\t\t\t</ColumnListItem>\n\t\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t\t</Table>\n\t\t\t\t\t\t</IconTabFilter>\n\n\t\t\t\t\t\t<IconTabFilter\n\t\t\t\t\t\t\tkey="methods"\n\t\t\t\t\t\t\ttext="Methods"\n\t\t\t\t\t\t\tcount="{/count/methods}"\n\t\t\t\t\t\t\tvisible="{/show/methods}" >\n\t\t\t\t\t\t\t<Table\n\t\t\t\t\t\t\t\tclass="myTable"\n\t\t\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\titems="{/methods}" >\n\t\t\t\t\t\t\t\t<columns>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Name" /></Column>\n\t\t\t\t\t\t\t\t\t<Column width="15%"><Label text="Param" /></Column>\n\t\t\t\t\t\t\t\t\t<Column><Label text="Type" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader"><Label text="Description" /></Column>\n\t\t\t\t\t\t\t\t\t<Column minScreenWidth="Tablet" demandPopin="false"><Label text="Since" /></Column>\n\t\t\t\t\t\t\t\t</columns>\n\t\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t\t<ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t<cells>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{name}" class="docuKey" wrapping="false">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData writeToDom="true" key="deprecated" value="{deprecated}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Text>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{param}" class="docuParam" wrapping="true" />\n\t\t\t\t\t\t\t\t\t\t\t<Link text="{typeText}" enabled="{typeNav}" press="onTypeLinkPress">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData key="type" value="{type}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Link>\n\t\t\t\t\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{doc}" />\n\t\t\t\t\t\t\t\t\t\t\t\t<ObjectStatus\n\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{deprecatedDescription}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="Warning"\t/>\n\t\t\t\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t\t\t\t<Label text="{since}" />\n\t\t\t\t\t\t\t\t\t\t</cells>\n\t\t\t\t\t\t\t\t\t</ColumnListItem>\n\t\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t\t</Table>\n\t\t\t\t\t\t</IconTabFilter>\n\n\t\t\t\t\t</items>\n\t\t\t\t</IconTabBar>\n\t\t\t</headerContainer>\n\t\t</ObjectHeader>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/demokit/explored/view/master.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.demokit.explored.view.master"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns="sap.m">\n\t<Page\n\t\tid="page" >\n\t\t<landmarkInfo>\n\t\t\t<PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Master" headerRole="Region" headerLabel="Header" subHeaderRole="Search" subHeaderLabel="Object Search" contentRole="Navigation" contentLabel="Items"></PageAccessibleLandmarkInfo>\n\t\t</landmarkInfo>\n\t\t<customHeader>\n\t\t\t<Toolbar>\n\t\t\t\t\t<Button icon="sap-icon://drop-down-list" id="viewSettingsButton" press="onOpenViewSettings" />\n\t\t\t\t\t<ToolbarSpacer/>\n\t\t\t\t\t<Title text="Entities ({entity>/entityCount})" />\n\t\t\t\t\t<ToolbarSpacer/>\n\t\t\t\t\t<Button icon="sap-icon://action-settings" tooltip="{i18n>settings}" press="onOpenAppSettings" />\n\n\t\t\t</Toolbar>\n\t\t</customHeader>\n\t\t<subHeader>\n\t\t\t<Bar\n\t\t\t\tid="searchBar">\n\t\t\t\t<contentMiddle>\n\t\t\t\t\t<SearchField\n\t\t\t\t\t\tid="searchField"\n\t\t\t\t\t\tplaceholder="Search"\n\t\t\t\t\t\tliveChange="onSearch"\n\t\t\t\t\t\twidth="100%" >\n\t\t\t\t\t</SearchField>\n\t\t\t\t</contentMiddle>\n\t\t\t</Bar>\n\t\t</subHeader>\n\t\t<content>\n\t\t\t<List\n\t\t\t\tid="list"\n\t\t\t\tclass="myList"\n\t\t\t\tnoDataText="{i18n>masterListNoData}"\n\t\t\t\tmode="{device>/listMode}"\n\t\t\t\tselectionChange="onNavToEntity"\n\t\t\t\titems="{\n\t\t\t\t\tpath: \'entity>/entities\',\n\t\t\t\t\tgroupHeaderFactory: \'.getGroupHeader\',\n\t\t\t\t\tsorter: [{\n\t\t\t\t\t\tpath: \'category\',\n\t\t\t\t\t\tdescending: false,\n\t\t\t\t\t\tgroup: true\n\t\t\t\t\t},{\n\t\t\t\t\t\tpath: \'name\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}]\n\t\t\t\t}" >\n\t\t\t\t<infoToolbar>\n\t\t\t\t\t<Toolbar\n\t\t\t\t\t\tid="vsFilterBar"\n\t\t\t\t\t\tactive="true"\n\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\tpress="onOpenViewSettings">\n\t\t\t\t\t\t<Label id="vsFilterLabel" />\n\t\t\t\t\t</Toolbar>\n\t\t\t\t</infoToolbar>\n\t\t\t\t<items>\n\t\t\t\t\t<StandardListItem\n\t\t\t\t\t\ttitle="{entity>name}"\n\t\t\t\t\t\tcounter="{entity>sampleCount}"\n\t\t\t\t\t\ttype="{device>/listItemType}"\n\t\t\t\t\t\tpress="onNavToEntity" />\n\t\t\t\t</items>\n\t\t\t</List>\n\t\t</content>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/demokit/explored/view/notFound.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.demokit.explored.view.notFound"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns:core="sap.ui.core"\n\txmlns:h="http://www.w3.org/1999/xhtml"\n\txmlns="sap.m">\n\t<Page\n\t\ttitle="Not Found"\n\t\tshowNavButton="{device>/isPhone}"\n\t\tnavButtonPress="onNavBack"\n\t\tenableScrolling="false" >\n\t\t<content>\n\t\t\t<Text text="The requested entity \'{/entityName}\' is unknown to the explored app." textAlign="Center" width="100%"></Text>\n\t\t</content>\n\t</Page>\n</mvc:View>',
	"sap/ui/demokit/explored/view/sample.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.demokit.explored.view.sample"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns="sap.m">\n\t<Page\n\t\tid="page"\n\t\tshowNavButton="{/showNavButton}"\n\t\tnavButtonPress="onNavBack" >\n\t\t<landmarkInfo>\n\t\t\t<PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"></PageAccessibleLandmarkInfo>\n\t\t</landmarkInfo>\n\t\t<headerContent>\n\t\t\t<Button\n\t\t\t\tid="prevSample"\n\t\t\t\ticon="sap-icon://navigation-up-arrow"\n\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\ttooltip="{i18n>samplePreviousTooltip}"\n\t\t\t\tenabled="{= ${/previousSampleId} !== undefined }"\n\t\t\t\tpress="onPreviousSample"/>\n\t\t\t<Button\n\t\t\t\tid="nextSample"\n\t\t\t\ticon="sap-icon://navigation-down-arrow"\n\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\ttooltip="{i18n>sampleNextTooltip}"\n\t\t\t\tenabled="{= ${/nextSampleId} !== undefined }"\n\t\t\t\tpress="onNextSample"/>\n\t\t\t<Button\n\t\t\t\tid="toggleFullScreenBtn"\n\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\ttooltip="{i18n>sampleFullScreenTooltip}"\n\t\t\t\tpress="onToggleFullScreen" />\n\t\t\t<Button\n\t\t\t\tid="toggleRTA"\n\t\t\t\ticon="sap-icon://wrench"\n\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\ttooltip="{i18n>sampleAdaptTooltip}"\n\t\t\t\tpress="onAdaptUI" visible="false"/>\n\t\t\t<Button\n\t\t\t\tid="code"\n\t\t\t\ticon="sap-icon://syntax"\n\t\t\t\ttooltip="{i18n>sampleShowCodeTooltip}"\n\t\t\t\tpress="onNavToCode" />\n\t\t\t<Button visible="{/showNewTab}"\n\t\t\t\t\tid="newTab"\n\t\t\t\t\ttooltip="{i18n>sampleNewTabTooltip}"\n\t\t\t\t\ticon="sap-icon://inspect"\n\t\t\t\t\tpress="onNewTab" />\n\t\t</headerContent>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/demokit/explored/view/viewSettingsDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core">\n\t<ViewSettingsDialog\n\t\tid="viewSettingsDialog"\n\t\tconfirm="onConfirmViewSettings">\n\t\t<groupItems>\n\t\t\t<ViewSettingsItem text="{i18n>itemName}" key="name" selected="true" />\n\t\t\t<ViewSettingsItem text="{i18n>itemCategory}" key="category" />\n\t\t\t<ViewSettingsItem text="{i18n>itemFormFactors}" key="formFactors" />\n\t\t\t<ViewSettingsItem text="{i18n>itemNamespace}" key="namespace" />\n\t\t\t<ViewSettingsItem text="{i18n>itemSince}" key="since" />\n\t\t</groupItems>\n\t\t<filterItems>\n\t\t\t<ViewSettingsFilterItem\n\t\t\t\ttext="{i18n>itemCategory}"\n\t\t\t\tkey="category"\n\t\t\t\tid="categoryFilter"\n\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/category\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'filter>id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" >\n\t\t\t\t<items>\n\t\t\t\t\t<ViewSettingsItem text="{filter>id}" key="{filter>id}" />\n\t\t\t\t</items>\n\t\t\t</ViewSettingsFilterItem>\n\t\t\t<ViewSettingsFilterItem\n\t\t\t\ttext="{i18n>itemFormFactors}"\n\t\t\t\tkey="formFactors"\n\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/formFactors\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'filter>id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" >\n\t\t\t\t<items>\n\t\t\t\t\t<ViewSettingsItem text="{filter>id}" key="{filter>id}" />\n\t\t\t\t</items>\n\t\t\t</ViewSettingsFilterItem>\n\t\t\t<ViewSettingsFilterItem\n\t\t\t\ttext="{i18n>itemNamespace}"\n\t\t\t\tkey="namespace"\n\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/namespace\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'filter>id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" >\n\t\t\t\t<items>\n\t\t\t\t\t<ViewSettingsItem text="{filter>id}" key="{filter>id}" />\n\t\t\t\t</items>\n\t\t\t</ViewSettingsFilterItem>\n\t\t\t<ViewSettingsFilterItem\n\t\t\t\ttext="{i18n>itemSince}"\n\t\t\t\tkey="since"\n\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/since\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'filter>id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" >\n\t\t\t\t<items>\n\t\t\t\t\t<ViewSettingsItem text="{filter>id}" key="{filter>id}" />\n\t\t\t\t</items>\n\t\t\t</ViewSettingsFilterItem>\n\t\t</filterItems>\n\t</ViewSettingsDialog>\n</core:FragmentDefinition>\n',
	"sap/ui/demokit/explored/view/welcome.view.xml":'<mvc:View\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns="sap.m">\n\t<Page\n\t\ttitle="Welcome"\n\t\tenableScrolling="false">\n\t\t<landmarkInfo>\n\t\t\t<PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"></PageAccessibleLandmarkInfo>\n\t\t</landmarkInfo>\n\t\t<content>\n\t\t\t<Text text="Select an entity from the list..." textAlign="Center" width="100%"></Text>\n\t\t</content>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/demokit/manifest.json":'{\n  "_version": "1.9.0",\n  "sap.app": {\n    "id": "sap.ui.demokit",\n    "type": "library",\n    "embeds": [\n      "demoapps",\n      "explored"\n    ],\n    "applicationVersion": {\n      "version": "1.52.30"\n    },\n    "title": "Non-public controls that should be used in a UI5 demokit (SDK) only.",\n    "description": "Non-public controls that should be used in a UI5 demokit (SDK) only.",\n    "ach": "CA-UI5-CTR",\n    "resources": "resources.json",\n    "offline": true,\n    "openSourceComponents": [\n      {\n        "name": "esprima",\n        "packagedWithMySelf": true,\n        "version": "0.0.0"\n      },\n      {\n        "name": "google-code-prettify",\n        "packagedWithMySelf": true,\n        "version": "0.0.0"\n      }\n    ]\n  },\n  "sap.ui": {\n    "technology": "UI5",\n    "supportedThemes": [\n      "base",\n      "sap_belize",\n      "sap_belize_plus",\n      "sap_bluecrystal",\n      "sap_goldreflection",\n      "sap_hcb"\n    ]\n  },\n  "sap.ui5": {\n    "dependencies": {\n      "minUI5Version": "1.52",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.52.30"\n        },\n        "sap.ui.commons": {\n          "minVersion": "1.52.30"\n        }\n      }\n    },\n    "library": {\n      "i18n": false,\n      "content": {\n        "controls": [\n          "sap.ui.demokit.CodeSampleContainer",\n          "sap.ui.demokit.CodeViewer",\n          "sap.ui.demokit.FileUploadIntrospector",\n          "sap.ui.demokit.HexagonButton",\n          "sap.ui.demokit.HexagonButtonGroup",\n          "sap.ui.demokit.IndexLayout",\n          "sap.ui.demokit.SimpleTree",\n          "sap.ui.demokit.TagCloud",\n          "sap.ui.demokit.UI5EntityCueCard"\n        ],\n        "elements": [\n          "sap.ui.demokit.SimpleTreeNode",\n          "sap.ui.demokit.Tag",\n          "sap.ui.demokit.UIAreaSubstitute"\n        ],\n        "types": [\n          "sap.ui.demokit.UI5EntityCueCardStyle"\n        ],\n        "interfaces": []\n      }\n    }\n  }\n}',
/*!
 * @copyright@
 */
	"sap/ui/demokit/demoapps/all.js":function(){sap.ui.getCore().attachInit(function(){"use strict";jQuery.sap.includeStyleSheet(jQuery.sap.getResourcePath("sap/ui/demokit/demoapps/css/style.css"));sap.ui.require(["sap/ui/core/ComponentContainer"],function(C){new C({name:"sap.ui.demokit.demoapps"}).placeAt("content");});});
}
}});
//# sourceMappingURL=library-preload.js.map