/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/context/ContextManager","sap/ui/fl/registry/Settings","sap/ui/fl/variants/VariantController"],function(C,V,U,L,a,b,S,c){"use strict";var d=function(m){this._mComponent=m;this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};this._mChangesInitial={};if(!this._mComponent||!this._mComponent.name){U.log.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._oVariantController=new c(this._mComponent.name,this._mComponent.appVersion,{});this._oConnector=this._createLrepConnector();this._aDirtyChanges=[];this._oMessagebundle=undefined;};d.prototype.getComponentName=function(){return this._mComponent.name;};d.prototype._createLrepConnector=function(){return L.createConnector();};d.prototype.getCacheKey=function(){return a.getCacheKey(this._mComponent);};d.prototype._preconditionsFulfilled=function(A,i,o){function _(){if(i){return(o.fileType==="change")||(o.fileType==="variant");}return(o.fileType==="change")&&(o.changeType!=="defaultVariant");}function e(){if(i){if((o.fileType==="variant")||(o.changeType==="defaultVariant")){return o.selector&&o.selector.persistencyKey;}}return true;}function f(){return b.doesContextMatch(o,A);}if(_()&&e()&&f()){return true;}return false;};d.prototype.getChangesForComponent=function(p){return a.getChangesFillingCache(this._oConnector,this._mComponent,p).then(function(w){var o=p&&p.oComponent;if(w.changes&&w.changes.settings){S._storeInstance(w.changes.settings);}if(!w.changes||!w.changes.changes){return[];}var f=w.changes.changes;if(!this._oMessagebundle&&w.messagebundle&&o){if(!o.getModel("i18nFlexVendor")){if(f.some(function(j){return j.layer==="VENDOR";})){this._oMessagebundle=w.messagebundle;var m=new sap.ui.model.json.JSONModel(this._oMessagebundle);o.setModel(m,"i18nFlexVendor");}}}if(w.changes.variantSection&&Object.keys(w.changes.variantSection).length!==0&&!this._oVariantController._getChangeFileContent()){this._oVariantController._setChangeFileContent(w);var v=this._oVariantController.loadDefaultChanges();f=f.concat(v);}var s=p&&p.currentLayer;if(s){var g=[];f.forEach(function(j){if(j.layer===s){g.push(j);}});f=g;}else if(U.isLayerFilteringRequired()&&!(p&&p.ignoreMaxLayerParameter)){var F=[];f.forEach(function(j){if(!U.isOverMaxLayer(j.layer)){F.push(j);}});f=F;}var i=p&&p.includeVariants;var h=w.changes.contexts||[];return new Promise(function(r){b.getActiveContexts(h).then(function(A){r(f.filter(this._preconditionsFulfilled.bind(this,A,i)).map(e));}.bind(this));}.bind(this));}.bind(this));function e(o){var f=new C(o);f.setState(C.states.PERSISTED);return f;}};d.prototype._addChangeIntoMap=function(o,e){var s=e.getSelector();if(s&&s.id){var f=s.id;if(s.idIsLocal){f=o.createId(f);}this._addMapEntry(f,e);if(s.idIsLocal===undefined&&f.indexOf("---")!=-1){var g=f.split("---")[0];if(g!==o.getId()){f=f.split("---")[1];f=o.createId(f);this._addMapEntry(f,e);}}}return this._mChanges;};d.prototype._addMapEntry=function(s,o){if(!this._mChanges.mChanges[s]){this._mChanges.mChanges[s]=[];}this._mChanges.mChanges[s].push(o);};d.prototype._addDependency=function(D,o){if(!this._mChanges.mDependencies[D.getId()]){this._mChanges.mDependencies[D.getId()]={changeObject:D,dependencies:[]};}this._mChanges.mDependencies[D.getId()].dependencies.push(o.getId());if(!this._mChanges.mDependentChangesOnMe[o.getId()]){this._mChanges.mDependentChangesOnMe[o.getId()]=[];}this._mChanges.mDependentChangesOnMe[o.getId()].push(D.getId());};d.prototype._addControlsDependencies=function(D,e){if(e.length>0){if(!this._mChanges.mDependencies[D.getId()]){this._mChanges.mDependencies[D.getId()]={changeObject:D,dependencies:[],controlsDependencies:[]};}this._mChanges.mDependencies[D.getId()].controlsDependencies=e;}};d.prototype.loadChangesMapForComponent=function(o,p){p.oComponent=o;return this.getChangesForComponent(p).then(e.bind(this));function e(f){this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};f.forEach(this._addChangeAndUpdateDependencies.bind(this,o));this._mChangesInitial=jQuery.extend(true,{},this._mChanges);return this.getChangesMapForComponent.bind(this);}};d.prototype.copyDependenciesFromInitialChangesMap=function(o,D){var i=jQuery.extend(true,{},this._mChangesInitial.mDependencies);var I=i[o.getId()];if(I){var n=[];I.dependencies.forEach(function(s){if(D(s)){if(!this._mChanges.mDependentChangesOnMe[s]){this._mChanges.mDependentChangesOnMe[s]=[];}this._mChanges.mDependentChangesOnMe[s].push(o.getId());n.push(s);}}.bind(this));I.dependencies=n;this._mChanges.mDependencies[o.getId()]=I;}return this._mChanges;};d.prototype._addChangeAndUpdateDependencies=function(o,e,I,f){this._addChangeIntoMap(o,e);var A=U.getAppComponentForControl(o);var D=e.getDependentIdList(A);var g=e.getDependentControlIdList(A);this._addControlsDependencies(e,g);var p;var P;var h;var F;for(var i=I-1;i>=0;i--){p=f[i];P=f[i].getDependentIdList(A);F=false;for(var j=0;j<D.length&&!F;j++){h=P.indexOf(D[j]);if(h>-1){this._addDependency(e,p);F=true;}}}};d.prototype.getChangesMapForComponent=function(){return this._mChanges;};d.prototype.getChangesForView=function(v,p){var t=this;return this.getChangesForComponent(p).then(function(f){return f.filter(e.bind(t));});function e(o){var s=o.getSelector();if(!s){return false;}var f=s.id;if(!f||!p){return false;}var g=f.slice(0,f.lastIndexOf("--"));var v;if(o.getSelector().idIsLocal){var A=p.appComponent;if(A){v=A.getLocalId(p.viewId);}}else{v=p.viewId;}return g===v;}};d.prototype.addChange=function(v,o){var e=this.addDirtyChange(v);if(e.getFileType()!=="ctrl_variant"){this._addChangeIntoMap(o,e);}this._addPropagationListener(o);return e;};d.prototype.addDirtyChange=function(v){var n;if(v instanceof C||v instanceof V){n=v;}else{n=new C(v);}this._aDirtyChanges.push(n);return n;};d.prototype._addPropagationListener=function(o){if(o){var f=function(p){return!p._bIsSapUiFlFlexControllerApplyChangesOnControl;};var n=o.getPropagationListeners().every(f);if(n){var m=o.getManifest();var v=U.getAppVersionFromManifest(m);var F=sap.ui.fl.FlexControllerFactory.create(this.getComponentName(),v);var p=F.getBoundApplyChangesOnControl(this.getChangesMapForComponent.bind(this),o);o.addPropagationListener(p);}}};d.prototype.saveDirtyChanges=function(s){var D=this._aDirtyChanges.slice(0);var e=this._aDirtyChanges;var r=this._getRequests(D);var p=this._getPendingActions(D);if(p.length===1&&r.length===1&&p[0]==="NEW"){var R=r[0];var P=this._prepareDirtyChanges(e);return this._oConnector.create(P,R).then(this._massUpdateCacheAndDirtyState(e,D,s));}else{return D.reduce(function(f,o){var g=f.then(this._performSingleSaveAction(o).bind(this));g.then(this._updateCacheAndDirtyState(e,o,s));return g;}.bind(this),Promise.resolve(true));}};d.prototype.saveAsDirtyChanges=function(r){return S.getInstance().then(function(s){var p={reference:r};var n=U.createNamespace(p,"changes");var D=this.getDirtyChanges();D.forEach(function(o){if(s.isAtoEnabled()){o.setRequest("ATO_NOTIFICATION");}o.setNamespace(n);o.setComponent(r);});return this.saveDirtyChanges(true);}.bind(this));};d.prototype._performSingleSaveAction=function(D){return function(){if(D.getPendingAction()==="NEW"){return this._oConnector.create(D.getDefinition(),D.getRequest());}if(D.getPendingAction()==="DELETE"){return this._oConnector.deleteChange({sChangeName:D.getId(),sLayer:D.getLayer(),sNamespace:D.getNamespace(),sChangelist:D.getRequest()});}};};d.prototype._updateCacheAndDirtyState=function(D,o,s){var t=this;return function(){if(!s){if(o.getPendingAction()==="NEW"){a.addChange(t._mComponent,o.getDefinition());}if(o.getPendingAction()==="DELETE"){a.deleteChange(t._mComponent,o.getDefinition());}}var i=D.indexOf(o);if(i>-1){D.splice(i,1);}};};d.prototype._massUpdateCacheAndDirtyState=function(D,e,s){e.forEach(function(o){this._updateCacheAndDirtyState(D,o,s)();},this);};d.prototype._getRequests=function(D){var r=[];D.forEach(function(o){var R=o.getRequest();if(r.indexOf(R)===-1){r.push(R);}});return r;};d.prototype._getPendingActions=function(D){var p=[];D.forEach(function(o){var P=o.getPendingAction();if(p.indexOf(P)===-1){p.push(P);}});return p;};d.prototype._prepareDirtyChanges=function(D){var e=[];D.forEach(function(o){e.push(o.getDefinition());});return e;};d.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};d.prototype.deleteChange=function(o){var n=this._aDirtyChanges.indexOf(o);if(n>-1){if(o.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(n,1);this._deleteChangeInMap(o);return;}o.markForDeletion();this.addDirtyChange(o);this._deleteChangeInMap(o);};d.prototype._deleteChangeInMap=function(o){var s=o.getId();var m=this._mChanges.mChanges;var D=this._mChanges.mDependencies;var e=this._mChanges.mDependentChangesOnMe;Object.keys(m).some(function(k){var f=m[k];var n=f.map(function(E){return E.getId();}).indexOf(o.getId());if(n!==-1){f.splice(n,1);return true;}});Object.keys(D).forEach(function(k){if(k===s){delete D[k];}else if(D[k].dependencies&&jQuery.isArray(D[k].dependencies)&&D[k].dependencies.indexOf(s)!==-1){D[k].dependencies.splice(D[k].dependencies.indexOf(s),1);if(D[k].dependencies.length===0){delete D[k];}}});Object.keys(e).forEach(function(k){if(k===s){delete e[k];}else if(jQuery.isArray(e[k])&&e[k].indexOf(s)!==-1){e[k].splice(e[k].indexOf(s),1);if(e[k].length===0){delete e[k];}}});};d.prototype.loadSwitchChangesMapForComponent=function(v,s,n){return this._oVariantController.getChangesForVariantSwitch(v,s,n,this._mChanges.mChanges);};return d;},true);
