/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/fl/Variant"],function(q,U,C,V){"use strict";var a=function(c,A,o){this._sComponentName=c||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;this._setChangeFileContent(o);};a.prototype.getComponentName=function(){return this._sComponentName;};a.prototype.getAppVersion=function(){return this._sAppVersion;};a.prototype._setChangeFileContent=function(c){if(c&&c.changes&&c.changes.variantSection){this._mVariantManagement={};Object.keys(c.changes.variantSection).forEach(function(v){this._mVariantManagement[v]={};var o=c.changes.variantSection[v];var b=o.variants.concat().sort(this.compareVariants);var i=-1;b.forEach(function(d,e){if(d.content.fileName===v){i=e;}});if(i>-1){var s=b.splice(i,1)[0];b.splice(0,0,s);}this._mVariantManagement[v].variants=b;this._mVariantManagement[v].defaultVariant=o.defaultVariant;}.bind(this));}};a.prototype._getChangeFileContent=function(){return this._mVariantManagement;};a.prototype.compareVariants=function(v,o){if(v.content.title.toLowerCase()<o.content.title.toLowerCase()){return-1;}else if(v.content.title.toLowerCase()>o.content.title.toLowerCase()){return 1;}else{return 0;}};a.prototype.getVariants=function(v){var b=this._mVariantManagement[v]&&this._mVariantManagement[v].variants;return b?b:[];};a.prototype.getVariant=function(v,s){var o;var b=this.getVariants(v);b.some(function(c,i){if(c.content.fileName===s){o=c;return true;}});return o;};a.prototype.getVariantChanges=function(v,s){var b=s||this._mVariantManagement[v].defaultVariant;var c=this.getVariants(v);var f=c.filter(function(o){return o.content.fileName===b;});return f.reduce(function(r,o){return o.changes?r.concat(o.changes):r;},[]);};a.prototype._getReferencedChanges=function(v,c){var r=[];if(c.content.variantReference){r=this.getVariantChanges(v,c.content.variantReference);return r.filter(function(R){return U.isLayerAboveCurrentLayer(R.layer)===-1;});}return r;};a.prototype.setVariantChanges=function(v,s,c){if(!v||!s||!q.isArray(c)){U.log.error("Cannot set variant changes without Variant reference");return;}return this._mVariantManagement[v].variants.some(function(o,i){if(o.content.fileName===s){o.changes=c;return true;}});};a.prototype._setVariantData=function(c,v,p){var b=this._mVariantManagement[v].variants;var o=b[p];Object.keys(c).forEach(function(P){o.content[P]=c[P];});b.splice(p,1);var s=this._getIndexToSortVariant(b.slice(1),o);b.splice(s+1,0,o);return s+1;};a.prototype.loadDefaultChanges=function(){var v;var d=[];Object.keys(this._mVariantManagement).forEach(function(s){v=this._mVariantManagement[s].defaultVariant;d=d.concat(this.getVariantChanges(s,v));}.bind(this));return d;};a.prototype.getChangesForVariantSwitch=function(v,c,n,m){var b=this.getVariantChanges(v,c).map(function(o){return new C(o).getId();});var d=Object.keys(m).reduce(function(e,f){var g=[];m[f].forEach(function(o){var i=b.indexOf(o.getId());if(i!==-1){g.push(o);}});return e.concat(g);},[]);var N=this.getVariantChanges(v,n).map(function(o){return new C(o);});var r=[];if(N.length>0){r=d.slice();d.some(function(o){if(N[0]&&o.getId()===N[0].getId()){N.shift();r.shift();}else{return true;}});}else{r=d;}var s={aRevert:r.reverse(),aNew:N};return s;};a.prototype._applyChangesOnVariant=function(v){var m=v.variantChanges,A;Object.keys(m).forEach(function(c){switch(c){case"setTitle":A=this._getActiveChange(c,m);if(A){v.content.title=A.getText("title");}break;default:U.log.error("No valid changes on variant "+v.content.title+" available");}}.bind(this));};a.prototype._getActiveChange=function(c,v){var l=v[c].length-1;if(l>-1){return new C(v[c][l]);}return false;};a.prototype._fillVariantModel=function(){var v={};Object.keys(this._mVariantManagement).forEach(function(k){v[k]={defaultVariant:this._mVariantManagement[k].defaultVariant,variants:[]};this.getVariants(k).forEach(function(o,i){this._applyChangesOnVariant(o);v[k].variants[i]={key:o.content.fileName,title:o.content.title,author:o.content.support.user,layer:o.content.layer,readOnly:o.content.fileName===k};}.bind(this));}.bind(this));return v;};a.prototype.addChangeToVariant=function(c,v,s){var n=this.getVariantChanges(v,s);var b=n.map(function(c){return c.fileName;});var i=b.indexOf(c.getDefinition().fileName);if(i===-1){c.setVariantReference(s);n.push(c.getDefinition());return this.setVariantChanges(v,s,n);}return false;};a.prototype.removeChangeFromVariant=function(c,v,s){var n=this.getVariantChanges(v,s);n.forEach(function(o,i){var b=new C(o);if(b.getId&&(b.getId()===c.getId())){n.splice(i,1);}});return this.setVariantChanges(v,s,n);};a.prototype.addVariantToVariantManagement=function(v,s){var b=this._mVariantManagement[s].variants.slice().splice(1);var i=this._getIndexToSortVariant(b,v);if(v.content.variantReference){var r=this._getReferencedChanges(s,v);v.changes=r.concat(v.changes);}this._mVariantManagement[s].variants.splice(i+1,0,v);return i+1;};a.prototype._getIndexToSortVariant=function(v,o){var i=0;v.some(function(e,b){if(this.compareVariants(o,e)<0){i=b;return true;}i=b+1;}.bind(this));return i;};a.prototype.removeVariantFromVariantManagement=function(v,s){var i;var f=this._mVariantManagement[s].variants.some(function(c,b){var o=new V(c);if(o.getId()===v.getId()){i=b;return true;}});if(f){this._mVariantManagement[s].variants.splice(i,1);}return i;};return a;},true);
