/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/message/MessageProcessor','./BindingMode','./Context','./Filter','./FilterOperator'],function(q,M,B,C,F,a){"use strict";var b=M.extend("sap.ui.model.Model",{constructor:function(){M.apply(this,arguments);this.oData={};this.bDestroyed=false;this.aBindings=[];this.mContexts={};this.iSizeLimit=100;this.sDefaultBindingMode=B.TwoWay;this.mSupportedBindingModes={"OneWay":true,"TwoWay":true,"OneTime":true};this.mUnsupportedFilterOperators={};this.bLegacySyntax=false;this.sUpdateTimer=null;},metadata:{"abstract":true,publicMethods:["bindProperty","bindList","bindTree","bindContext","createBindingContext","destroyBindingContext","getProperty","getDefaultBindingMode","setDefaultBindingMode","isBindingModeSupported","attachParseError","detachParseError","attachRequestCompleted","detachRequestCompleted","attachRequestFailed","detachRequestFailed","attachRequestSent","detachRequestSent","attachPropertyChange","detachPropertyChange","setSizeLimit","refresh","isList","getObject"]}});b.M_EVENTS={ParseError:"parseError",RequestFailed:"requestFailed",RequestSent:"requestSent",RequestCompleted:"requestCompleted",PropertyChange:"propertyChange"};b.prototype.attachRequestFailed=function(d,f,l){this.attachEvent("requestFailed",d,f,l);return this;};b.prototype.detachRequestFailed=function(f,l){this.detachEvent("requestFailed",f,l);return this;};b.prototype.fireRequestFailed=function(A){this.fireEvent("requestFailed",A);return this;};b.prototype.attachParseError=function(d,f,l){this.attachEvent("parseError",d,f,l);return this;};b.prototype.detachParseError=function(f,l){this.detachEvent("parseError",f,l);return this;};b.prototype.fireParseError=function(A){this.fireEvent("parseError",A);return this;};b.prototype.attachRequestSent=function(d,f,l){this.attachEvent("requestSent",d,f,l);return this;};b.prototype.detachRequestSent=function(f,l){this.detachEvent("requestSent",f,l);return this;};b.prototype.fireRequestSent=function(A){this.fireEvent("requestSent",A);return this;};b.prototype.attachRequestCompleted=function(d,f,l){this.attachEvent("requestCompleted",d,f,l);return this;};b.prototype.detachRequestCompleted=function(f,l){this.detachEvent("requestCompleted",f,l);return this;};b.prototype.fireRequestCompleted=function(A){this.fireEvent("requestCompleted",A);return this;};b.prototype.attachMessageChange=function(d,f,l){this.attachEvent("messageChange",d,f,l);return this;};b.prototype.detachMessageChange=function(f,l){this.detachEvent("messageChange",f,l);return this;};b.prototype.firePropertyChange=function(A){this.fireEvent("propertyChange",A);return this;};b.prototype.attachPropertyChange=function(d,f,l){this.attachEvent("propertyChange",d,f,l);return this;};b.prototype.detachPropertyChange=function(f,l){this.detachEvent("propertyChange",f,l);return this;};b.prototype.getObject=function(p,c,P){return this.getProperty(p,c,P);};b.prototype.getContext=function(p){if(!q.sap.startsWith(p,"/")){throw new Error("Path "+p+" must start with a / ");}var c=this.mContexts[p];if(!c){c=new C(this,p);this.mContexts[p]=c;}return c;};b.prototype.resolve=function(p,c){var i=typeof p=="string"&&!q.sap.startsWith(p,"/"),r=p,s;if(i){if(c){s=c.getPath();r=s+(q.sap.endsWith(s,"/")?"":"/")+p;}else{r=this.isLegacySyntax()?"/"+p:undefined;}}if(!p&&c){r=c.getPath();}if(r&&r!=="/"&&q.sap.endsWith(r,"/")){r=r.substr(0,r.length-1);}return r;};b.prototype.addBinding=function(o){this.aBindings.push(o);};b.prototype.removeBinding=function(o){var i=this.aBindings.indexOf(o);if(i!==-1){this.aBindings.splice(i,1);}};b.prototype.getDefaultBindingMode=function(){return this.sDefaultBindingMode;};b.prototype.setDefaultBindingMode=function(m){if(this.isBindingModeSupported(m)){this.sDefaultBindingMode=m;return this;}throw new Error("Binding mode "+m+" is not supported by this model.",this);};b.prototype.isBindingModeSupported=function(m){return(m in this.mSupportedBindingModes);};b.prototype.setLegacySyntax=function(l){this.bLegacySyntax=l;};b.prototype.isLegacySyntax=function(){return this.bLegacySyntax;};b.prototype.setSizeLimit=function(s){this.iSizeLimit=s;};b.prototype.getInterface=function(){return this;};b.prototype.refresh=function(f){this.checkUpdate(f);if(f){this.fireMessageChange({oldMessages:this.mMessages});}};b.prototype.checkUpdate=function(f,A){if(A){if(!this.sUpdateTimer){this.sUpdateTimer=q.sap.delayedCall(0,this,function(){this.checkUpdate(f);});}return;}if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);this.sUpdateTimer=null;}var c=this.aBindings.slice(0);q.each(c,function(i,o){o.checkUpdate(f);});};b.prototype.setMessages=function(m){m=m||{};if(!q.sap.equal(this.mMessages,m)){this.mMessages=m;this.checkMessages();}};b.prototype.getMessagesByPath=function(p){if(this.mMessages){return this.mMessages[p]||[];}return null;};b.prototype.checkMessages=function(){q.each(this.aBindings,function(i,o){if(o.checkDataState){o.checkDataState();}});};b.prototype.destroy=function(){M.prototype.destroy.apply(this,arguments);this.oData={};this.aBindings=[];this.mContexts={};if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);}this.bDestroyed=true;};b.prototype.getMetaModel=function(){return undefined;};b.prototype.getOriginalProperty=function(p,c){return this.getProperty(p,c);};b.prototype.isLaundering=function(p,c){return false;};b.prototype.checkFilterOperation=function(f){_(f,function(o){if(this.mUnsupportedFilterOperators[o.sOperator]){throw new Error("Filter instances contain an unsupported FilterOperator: "+o.sOperator);}}.bind(this));};function _(f,c){f=f||[];if(f instanceof F){f=[f];}for(var i=0;i<f.length;i++){var o=f[i];c(o);_(o.oCondition,c);_(o.aFilters,c);}}return b;});
