/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','sap/ui/model/odata/v2/ODataAnnotations','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/UpdateMethod','sap/ui/model/odata/OperationMode','./ODataContextBinding','./ODataListBinding','sap/ui/model/odata/ODataMetadata','sap/ui/model/odata/ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/odata/ODataMetaModel','sap/ui/core/message/MessageParser','sap/ui/model/odata/ODataMessageParser','sap/ui/thirdparty/datajs','jquery.sap.script','jquery.sap.strings'],function(q,B,C,M,O,a,b,U,c,d,e,f,g,h,l,m,o,p){"use strict";var r=M.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(s,P){M.apply(this,arguments);var u,i,H,t,w,j,k,R,n,L,D,v,x,y,z,S,E,J,F,G,I,K,N,Q,T,V=this;if(typeof(s)==="object"){P=s;s=P.serviceUrl;}if(P){u=P.user;i=P.password;H=P.headers;t=P.tokenHandling;w=P.withCredentials;j=P.maxDataServiceVersion;k=P.useBatch;R=P.refreshAfterChange;n=P.annotationURI;L=P.loadAnnotationsJoined;x=P.defaultBindingMode;D=P.defaultCountMode;v=P.preliminaryContext;y=P.defaultOperationMode;z=P.metadataNamespaces;S=P.serviceUrlParams;E=P.metadataUrlParams;J=P.json;F=P.messageParser;G=P.skipMetadataAnnotationParsing;I=P.defaultUpdateMethod;K=P.disableHeadRequestForToken;N=P.sequentializeRequests;Q=P.disableSoftStateHeader;T=P.bindableResponseHeaders;}this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.sDefaultBindingMode=x||B.OneWay;this.bJSON=J!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};this.sDefaultUpdateMethod=I||U.Merge;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=k!==false;this.bRefreshAfterChange=R!==false;this.sMaxDataServiceVersion=j;this.bLoadAnnotationsJoined=L!==false;this.sAnnotationURI=n;this.sDefaultCountMode=D||b.Request;this.sDefaultOperationMode=y||c.Default;this.sMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=!!G;this.bDisableHeadRequestForToken=!!K;this.bSequentializeRequests=!!N;this.bDisableSoftStateHeader=!!Q;this.aBindableResponseHeaders=T?T:null;this.bPreliminaryContext=v||false;this.mMetadataUrlParams=E||{};if(F){F.setProcessor(this);}this.oMessageParser=F;this.sDefaultChangeGroup="changes";this.setDeferredGroups([this.sDefaultChangeGroup]);this.setChangeGroups({"*":{groupId:this.sDefaultChangeGroup}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();this.sServiceUrl=s;var W=s.split("?");if(W.length>1){this.sServiceUrl=W[0];if(W[1]){this.aUrlParams.push(W[1]);}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=u;this.sPassword=i;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.oHeaders={};this.setHeaders(H);if(!this.bDisableSoftStateHeader){this.oHeaders["sap-contextid-accept"]="header";this.mCustomHeaders["sap-contextid-accept"]="header";}var X=this._createMetadataUrl("/$metadata");this.oServiceData=r.mServiceData[X];if(!this.oServiceData){r.mServiceData[X]={};this.oServiceData=r.mServiceData[X];}if(!this.oServiceData.oMetadata||this.oServiceData.oMetadata.bFailed){this.oMetadata=new f(X,{async:true,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:z,withCredentials:this.bWithCredentials});this.oServiceData.oMetadata=this.oMetadata;}else{this.oMetadata=this.oServiceData.oMetadata;}this.oAnnotations=new O(this.oMetadata,{source:this.sAnnotationURI,skipMetadata:this.bSkipMetadataAnnotationParsing,headers:this.mCustomHeaders,combineEvents:true});if(!this.bDisableSoftStateHeader){delete this.mCustomHeaders["sap-contextid-accept"];}this.oAnnotations.attachAllFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachSomeLoaded(this.onAnnotationsLoaded,this);this.pAnnotationsLoaded=this.oAnnotations.loaded();if(S){this.aUrlParams=this.aUrlParams.concat(a._createUrlParamsArray(S));}this.onMetadataFailed=function(Y){V.fireMetadataFailed(Y.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachFailed(this.onMetadataFailed);}this.oMetadata.loaded().then(function(){V._initializeMetadata();});if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";}if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","getPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});r.M_EVENTS={MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};r.prototype.attachBatchRequestFailed=function(D,F,L){this.attachEvent("batchRequestFailed",D,F,L);return this;};r.prototype.detachBatchRequestFailed=function(F,L){this.detachEvent("batchRequestFailed",F,L);return this;};r.prototype.fireBatchRequestFailed=function(i){this.fireEvent("batchRequestFailed",i);return this;};r.prototype.attachBatchRequestSent=function(D,F,L){this.attachEvent("batchRequestSent",D,F,L);return this;};r.prototype.detachBatchRequestSent=function(F,L){this.detachEvent("batchRequestSent",F,L);return this;};r.prototype.fireBatchRequestSent=function(i){this.fireEvent("batchRequestSent",i);return this;};r.prototype.attachBatchRequestCompleted=function(D,F,L){this.attachEvent("batchRequestCompleted",D,F,L);return this;};r.prototype.detachBatchRequestCompleted=function(F,L){this.detachEvent("batchRequestCompleted",F,L);return this;};r.prototype.fireBatchRequestCompleted=function(i){this.fireEvent("batchRequestCompleted",i);return this;};r.mServiceData={};r.prototype._initializeMetadata=function(){if(this.bDestroyed){return;}var F=function(){this.fireMetadataLoaded({metadata:this.oMetadata});q.sap.log.debug(this+" - metadataloaded fired");}.bind(this);this.initialize();if(this.bLoadAnnotationsJoined){this.oAnnotations.loaded().then(F,this.fireMetadataFailed.bind(this));}else{F();}};r.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh();}};r.prototype.fireAnnotationsLoaded=function(i){this.fireEvent("annotationsLoaded",i);return this;};r.prototype.attachAnnotationsLoaded=function(D,F,L){this.attachEvent("annotationsLoaded",D,F,L);return this;};r.prototype.detachAnnotationsLoaded=function(F,L){this.detachEvent("annotationsLoaded",F,L);return this;};r.prototype.fireAnnotationsFailed=function(i){this.fireEvent("annotationsFailed",i);q.sap.log.debug(this+" - annotationsfailed fired");return this;};r.prototype.attachAnnotationsFailed=function(D,F,L){this.attachEvent("annotationsFailed",D,F,L);return this;};r.prototype.detachAnnotationsFailed=function(F,L){this.detachEvent("annotationsFailed",F,L);return this;};r.prototype.fireMetadataLoaded=function(i){this.fireEvent("metadataLoaded",i);return this;};r.prototype.attachMetadataLoaded=function(D,F,L){this.attachEvent("metadataLoaded",D,F,L);return this;};r.prototype.detachMetadataLoaded=function(F,L){this.detachEvent("metadataLoaded",F,L);return this;};r.prototype.fireMetadataFailed=function(i){this.fireEvent("metadataFailed",i);return this;};r.prototype.attachMetadataFailed=function(D,F,L){this.attachEvent("metadataFailed",D,F,L);return this;};r.prototype.detachMetadataFailed=function(F,L){this.detachEvent("metadataFailed",F,L);return this;};r.prototype._createEventInfo=function(R,k,n){var E={};E.url=R.requestUri;E.method=R.method;E.async=R.async;E.headers=R.headers;if(n){E.requests=[];for(var i=0;i<n.length;i++){var s={};if(Array.isArray(n[i])){var t=n[i];for(var j=0;j<t.length;j++){var R=t[j].request;var I=n[i][j].response;s={};s.url=R.requestUri;s.method=R.method;s.headers=R.headers;if(I){s.response={};if(R._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}else{var R=n[i].request;var I=n[i].response;s.url=R.requestUri;s.method=R.method;s.headers=R.headers;if(I){s.response={};if(R._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}}if(k){E.response={};E.success=true;if(k.message){E.response.message=k.message;E.success=false;}if(k.response){k=k.response;}if(k&&k.statusCode!=undefined){E.response.headers=k.headers;E.response.statusCode=k.statusCode;E.response.statusText=k.statusText;E.response.responseText=k.body!==undefined?k.body:k.responseText;}}E.ID=R.requestID;return E;};r.prototype._createRequestID=function(){var R;R=q.sap.uid();return R;};r.prototype._createMetadataUrl=function(u){if(u.indexOf(this.sServiceUrl)==-1){if(!q.sap.startsWith(u,"/")){u="/"+u;}u=this.sServiceUrl+u;}var i=q.sap.getUriParameters(u).mParams||{};Object.keys(i).forEach(function(K){i[K]=i[K][0];});var j=q.extend({},this.mMetadataUrlParams,i);var k=a._createUrlParamsArray(j);var n=u.split("?");if(n.length>1){u=n[0];}return this._addUrlParams(u,k);};r.prototype._addUrlParams=function(u,i){var j=[];if(this.aUrlParams){j=j.concat(this.aUrlParams);}if(i){j=j.concat(i);}if(j&&j.length>0){u+="?"+j.join("&");}return u;};r.prototype._createRequestUrl=function(P,i,u,j){var n,s="";n=this._normalizePath(P,i);if(!j){s=this.sServiceUrl+n;}else{s=n.substr(n.indexOf('/')+1);}return this._addUrlParams(s,u);};r.prototype._importData=function(D,j,R){var t=this,L,k,n,E;if(D.results){L=[];q.each(D.results,function(i,w){var k=t._importData(w,j,R);if(k){L.push(k);}});return L;}else{k=this._getKey(D);if(!k){return k;}E=this._getEntity(k);if(!E||(E.__metadata&&E.__metadata.invalid)){E=D;this._addEntity(E);}if(this.aBindableResponseHeaders){var H={};for(var s in R.headers){var u=s.toLowerCase();if(this.aBindableResponseHeaders.indexOf(u)>-1){H[u]=R.headers[s];}}if(!q.isEmptyObject(H)){if(!D.__metadata){D.__metadata={};}D.__metadata.headers=H;}}q.each(D,function(N,P){if(P&&(P.__metadata&&P.__metadata.uri||P.results)&&!P.__deferred){n=t._importData(P,j,R);if(Array.isArray(n)){E[N]={__list:n};}else{E[N]={__ref:n};}}else if(!P||!P.__deferred){E[N]=P;}});var v={};v[k]=E;this._updateChangedEntities(v);j[k]=true;return k;}};r.prototype._removeReferences=function(D){var t=this,L;if(!D){return D;}if(D.results){L=[];q.each(D.results,function(i,j){L.push(t._removeReferences(j));});return L;}else{q.each(D,function(P,i){if(i){if(i["__ref"]||i["__list"]){delete D[P];}}});return D;}};r.prototype._restoreReferences=function(D,v){var t=this,k,j,R;function n(k){var j=v[k];if(!j){j=t._getObject("/"+k);if(j){j=q.sap.extend(true,{},j);v[k]=j;t._restoreReferences(j,v);}}return j;}if(!v){v={};}q.each(D,function(P,s){if(s){if(s.__ref){k=s.__ref;j=n(k);if(j){D[P]=j;}delete s.__ref;}else if(s.__list){R=[];q.each(s.__list,function(i,k){j=n(k);if(j){R.push(j);}});delete s.__list;s.results=R;}}});return D;};r.prototype.removeData=function(){this.oData={};};r.prototype.initialize=function(){var i=this.aBindings.slice(0);i.forEach(function(j){j.initialize();});};r.prototype.invalidate=function(i){var E;for(var k in this.oData){E=this.oData[k];if(!i||i(k,E)){E.__metadata.invalid=true;}}};r.prototype.invalidateEntry=function(E){var i;if(typeof E==="string"){if(E.indexOf("/")===0){i=this._getObject(E);}else{i=this.oData[E];}}else if(E instanceof C){i=this._getObject(E.getPath());}if(i&&i.__metadata){i.__metadata.invalid=true;}};r.prototype.invalidateEntityType=function(E){var i;for(var k in this.oData){i=this.oData[k];if(i.__metadata.type===E){i.__metadata.invalid=true;}}};r.prototype.refresh=function(F,R,G){if(typeof F==="string"){G=F;F=false;R=false;}if(R){this.removeData();}this._refresh(F,G);};r.prototype._refresh=function(F,G,i,E){var j=this.aBindings.slice(0);this.sRefreshGroupId=G;j.forEach(function(k){k._refresh(F,i,E);});this.sRefreshGroupId=undefined;};r.prototype.checkUpdate=function(F,i,j,k){if(i){if(!this.sUpdateTimer){this.sUpdateTimer=q.sap.delayedCall(0,this,function(){this.checkUpdate(F,false,j);});}return;}if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);this.sUpdateTimer=null;}var n=this.aBindings.slice(0);n.forEach(function(s){if(!k||this.isMetaModelPath(s.getPath())){s.checkUpdate(F,j);}}.bind(this));this._processAfterUpdate();};r.prototype.checkDataState=function(L){var i=this.aBindings.slice(0);i.forEach(function(j){if(j.checkDataState){j.checkDataState(L);}});};r.prototype.bindProperty=function(P,i,j){var k=new g(this,P,i,j);return k;};r.prototype.bindList=function(P,i,s,F,j){var k=new e(this,P,i,s,F,j);return k;};r.prototype.bindTree=function(P,i,F,j,s){var k=new h(this,P,i,F,j,s);return k;};r.prototype.createBindingContext=function(P,i,j,k,R){var s=this.resolve(P,i),n,N,G,t=this;if(typeof i=="function"){R=j;k=i;j=undefined;i=undefined;}if(typeof j=="function"){R=k;k=j;j=undefined;}if(!s){if(k){k(null);}return null;}if(R===undefined){R=this._isReloadNeeded(s,j);}if(!R){n=this.resolve(P,i,true);N=this.getContext(n);if(k){k(N);}return N;}function u(D){var K=D?t._getKey(D):null,L=!(P===""||P.indexOf("/")>0),y=null,z,E;N=null;if(K){N=t.getContext('/'+K);y={__ref:K};}if(i&&I&&L){z=i.getPath();z=z.substr(1);E=t._getEntity(z);if(E){E[P]=y;}}k(N);}function v(E){var y;if(E.statusCode=='404'&&i&&I){var z=i.getPath();z=z.substr(1);y=t._getEntity(z);if(y){y[P]={__ref:null};}}k(null);}if(k){var I=!q.sap.startsWith(P,"/");if(s){var w=[],x=this.createCustomParams(j);if(x){w.push(x);}if(j&&(j.batchGroupId||j.groupId)){G=j.groupId||j.batchGroupId;}this.read(s,{groupId:G,urlParameters:w,success:u,error:v});}else{k(null);}}if(j&&j.createPreliminaryContext){s=this.resolve(P,i);N=this.getContext(s);return N;}};r.prototype._updateContext=function(i,P){if(!q.sap.startsWith(P,"/")){throw new Error("Path "+P+" must start with a / ");}i.sPath=P;this.mContexts[P]=i;};r.prototype._splitEntries=function(E){return E.replace(/\s/g,"").split(',').map(function(s){return s.split("/");});};r.prototype._filterOwnSelect=function(s,E){var i,j;if(!E){return[];}j=E.map(function(P){return P.name;});i=s.filter(function(S){return S.length===1;}).map(function(S){return S[0];});if(s.length===0||i.indexOf("*")!==-1||i.indexOf("**")!==-1){return j;}else{return i.filter(function(S){return j.indexOf(S)!==-1;});}};r.prototype._filterOwnExpand=function(E,s){return E.map(function(S){return S[0];}).filter(function(v,i,j){return j.indexOf(v)===i;}).filter(function(v){return s.length===0||s.some(function(S){return S.indexOf(v)===0||S.indexOf("**")===0;});});};r.prototype._filterSelectByNavProp=function(E,n){return E.filter(function(s){return s[0]===n;}).map(function(s){return s.length>1?s.slice(1):["**"];});};r.prototype._filterExpandByNavProp=function(E,n){return E.filter(function(s){return s.length>1&&s[0]===n;}).map(function(s){return s.slice(1);});};r.prototype._isReloadNeeded=function(P,k){var t=this,n=this.oMetadata,E=this.oMetadata._getEntityTypeByPath(P),s=this._getObject(P),u=[],S=[];if(this._isCreatedEntity(s)){return false;}function v(E,s,S,u){var w,x,N,y,z,D,F,G,H;if(!E){return false;}if(s===null){return false;}if(!s){return true;}if(s.__metadata&&s.__metadata.invalid){return true;}w=t._filterOwnSelect(S,E.property);for(var i=0;i<w.length;i++){H=w[i];if(s[H]===undefined){return true;}}x=t._filterOwnExpand(u,S);for(var i=0;i<x.length;i++){G=x[i];N=s[G];if(N===null){continue;}if(N===undefined||N.__deferred){return true;}y=n._getEntityTypeByNavProperty(E,G);D=t._filterSelectByNavProp(S,G);F=t._filterExpandByNavProp(u,G);if(N.__ref){z=t._getEntity(N.__ref);if(v(y,z,D,F)){return true;}}if(N.__list){for(var j=0;j<N.__list.length;j++){z=t._getEntity(N.__list[j]);if(v(y,z,D,F)){return true;}}}}return false;}if(k){if(k.select){S=this._splitEntries(k.select);}if(k.expand){u=this._splitEntries(k.expand);}}return v(E,s,S,u);};r.prototype.createCustomParams=function(P){var i=[],j,s={expand:true,select:true};for(var n in P){if(n in s){i.push("$"+n+"="+q.sap.encodeURL(P[n]));}if(n==="custom"){j=P[n];for(n in j){if(n.indexOf("$")===0){q.sap.log.warning(this+" - Trying to set OData parameter '"+n+"' as custom query option!");}else if(typeof j[n]==='string'){i.push(n+"="+q.sap.encodeURL(j[n]));}else{i.push(n);}}}}return i.join("&");};r.prototype.bindContext=function(P,i,j){var k=new d(this,P,i,j);return k;};r.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s;};r.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};r.prototype._addEntity=function(E){var k=this._getKey(E);this.oData[k]=E;};r.prototype._removeEntity=function(k){k=k&&a._normalizeKey(k);delete this.oData[k];delete this.mChangedEntities[k];delete this.mContexts["/"+k];};r.prototype._getEntity=function(k){var E=this.oData[k];if(!E){k=k&&a._normalizeKey(k);E=this.oData[k];}return E;};r.prototype._getKey=function(v){var k,u;if(v instanceof C){k=v.getPath().substr(1);}else if(v&&v.__metadata&&v.__metadata.uri){u=v.__metadata.uri;k=u.substr(u.lastIndexOf("/")+1);}else if(typeof v==='string'){k=v.substr(v.lastIndexOf("/")+1);}if(!this.oData[k]){k=k&&a._normalizeKey(k);}return k;};r.prototype.getKey=function(v){return this._getKey(v);};r.prototype.createKey=function(s,k){var E=this.oMetadata._getEntityTypeByPath(s),K=s,t=this,n,P;K+="(";if(E.key.propertyRef.length===1){n=E.key.propertyRef[0].name;P=this.oMetadata._getPropertyMetadata(E,n);K+=encodeURIComponent(a.formatValue(k[n],P.type));}else{q.each(E.key.propertyRef,function(i,j){if(i>0){K+=",";}n=j.name;P=t.oMetadata._getPropertyMetadata(E,n);K+=n;K+="=";K+=encodeURIComponent(a.formatValue(k[n],P.type));});}K+=")";return K;};r.prototype.getProperty=function(P,i,I){var v=this._getObject(P,i);if(!I){return v;}if(!q.isPlainObject(v)){return v;}v=q.sap.extend(true,{},v);if(I===true){return this._restoreReferences(v);}else{return this._removeReferences(v);}};r.prototype.getObject=function(P,n,s){if(q.isPlainObject(n)){s=n;n=undefined;}var t=this,R=this.resolve(P,n),v=this._getObject(R),E=this.oMetadata._getEntityTypeByPath(R),u=[],S=[];if(!E||!q.isPlainObject(v)||!v.__metadata||!v.__metadata.uri){return v;}if(!s||!(s.select||s.expand)){return q.sap.extend(true,{},v);}function w(E,v,S,u){var x,y,z,D,N,F,G,H,I,J,K,L,Q;if(!v){return undefined;}if(!E){return undefined;}z=t._filterOwnSelect(S,E.property);y={};for(var i=0;i<z.length;i++){L=z[i];if(v[L]!==undefined){y[L]=v[L];}else{q.sap.log.fatal("No data loaded for select property: "+L+" of entry: "+t.getKey(v));return undefined;}}if(v.__metadata){y.__metadata=v.__metadata;}x=t._filterOwnExpand(u,S);for(var i=0;i<x.length;i++){K=x[i];N=v[K];F=t.oMetadata._getEntityTypeByNavProperty(E,K);I=t._filterSelectByNavProp(S,K);J=t._filterExpandByNavProp(u,K);if(N&&N.__ref){H=t._getObject("/"+N.__ref);G=w(F,H,I,J);if(G!==undefined){y[K]=G;}else{q.sap.log.fatal("No data loaded for expand property: "+K+" of entry: "+t.getKey(G));return undefined;}}if(N&&N.__list){Q=[];for(var j=0;j<N.__list.length;j++){H=t._getObject("/"+N.__list[j]);G=w(F,H,I,J);if(G!==undefined){Q.push(G);}else{q.sap.log.fatal("No data loaded for expand property: "+K+" of entry: "+t.getKey(G));return undefined;}}y[K]=Q;}}D=t._filterOwnSelect(S,E.navigationProperty);for(var k=0;k<D.length;k++){K=D[k];if(x.indexOf(K)===-1){var T=y.__metadata.uri+"/"+K;y[K]={__deferred:{uri:T}};}}return y;}if(s.select){S=this._splitEntries(s.select);}if(s.expand){u=this._splitEntries(s.expand);}v=w(E,v,S,u);return v;};r.prototype._getObject=function(P,i,j){var n=this.isLegacySyntax()?this.oData:null,k,s,R=this.resolve(P,i),S,D,t,u,K,v;if(!R){return n;}if(this._isMetadataPath(R)){if(this.oMetadata&&this.oMetadata.isLoaded()){if(this.isMetaModelPath(R)){S=R.indexOf('/##');v=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=R.substr(0,S);t=R.substr(S+3);u=v.getMetaContext(D);n=v.getProperty(t,u);}else{n=this.oMetadata._getAnnotation(R);}}}else{if(R==="/"){return this.oData;}var w=R.split("/"),I=0;K=w[1];w.splice(0,2);k=this.mChangedEntities[K];s=this._getEntity(K);n=j?s:k||s;while(n&&w[I]){var H=k&&k.hasOwnProperty(w[I]);k=k&&k[w[I]];s=s&&s[w[I]];n=j||!H?s:k;if(n){if(n.__ref){k=this.mChangedEntities[n.__ref];s=this._getEntity(n.__ref);n=j?s:k||s;}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}I++;}}if(q.isPlainObject(k)){n=j?s:q.sap.extend(true,{},s,k);}return n;};r.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}}};r.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken;};r.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken;}return t;};r.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oServiceData.securityToken);}else{this.pSecurityToken=new Promise(function(i,j){this.refreshSecurityToken(function(){i(this.oServiceData.securityToken);}.bind(this),function(){j();},true);}.bind(this));}}return this.pSecurityToken;};r.prototype.refreshSecurityToken=function(s,E,i){var t;var j=this;var u=this._createRequestUrl("/");var T={abort:function(){this.request.abort();}};function k(D,R){if(R){t=j._getHeader("x-csrf-token",R.headers);j._setSessionContextIdHeader(j._getHeader("sap-contextid",R.headers));if(t){j.oServiceData.securityToken=t;j.pSecurityToken=Promise.resolve(t);j.oHeaders["x-csrf-token"]=t;}else{j.resetSecurityToken();j.bTokenHandling=false;}}if(s){s(D,R);}}function n(x){j.resetSecurityToken();j.bTokenHandling=false;j._handleError(x);if(E){E(x);}}function v(x){T.request=w("GET",n);}function w(R,E){var x=j._createRequest(u,R,j._getHeaders(false,true),null,null,!!i);x.headers["x-csrf-token"]="Fetch";return j._request(x,k,E,undefined,undefined,j.getServiceMetadata());}if(this.bDisableHeadRequestForToken){T.request=w("GET",n);}else{T.request=w("HEAD",v);}return T;};r.prototype._submitRequest=function(R,s,E){var t=this,H,j,k,n,u;n=new Promise(function(i,F){u=i;});function v(i,F){if(s){s(i,F);}u();}function w(i){if(t.bTokenHandling&&i.response){var T=t._getHeader("x-csrf-token",i.response.headers);if(!R.bTokenReset&&i.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){t.resetSecurityToken();R.bTokenReset=true;y();return;}}if(E){E(i);}u();}function x(R){if(t.bTokenHandling&&R.method!=="GET"){t.pReadyForRequest=t.securityTokenAvailable();}return t.pReadyForRequest;}function y(){x(R).then(function(T){if(t.bTokenHandling&&R.method!=="GET"){R.headers["x-csrf-token"]=T;}D();},function(){D();});}function z(T,R,F){var G,I=R.eventInfo.requests;if(I){q.each(I,function(i,R){if(Array.isArray(R)){R.forEach(function(R){q.each(R.parts,function(i,P){G=t._createEventInfo(R.request,P.fnError);t["fireRequest"+T](G);});});}else{if(R.parts){q.each(R.parts,function(i,P){G=t._createEventInfo(R.request,P.fnError);t["fireRequest"+T](G);});}else{G=t._createEventInfo(R.request,R.fnError);t["fireRequest"+T](G);}}});if(R.eventInfo.batch){G=t._createEventInfo(R,F,I);t["fireBatchRequest"+T](G);}}}function D(){if(t.sSessionContextId){R.headers["sap-contextid"]=t.sSessionContextId;}j=t._request(R,v,w,H,undefined,t.getServiceMetadata());if(R.eventInfo){z("Sent",R,null);delete R.eventInfo;}if(k){j.abort();}}H=t._getODataHandler(R.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){y();});this.pSequentialRequestCompleted=n;}else{y();}return{abort:function(){if(j){j.abort();}k=true;}};};r.prototype._setSessionContextIdHeader=function(s){if(s){this.sSessionContextId=s;}};r.prototype._submitSingleRequest=function(R){var t=this,j,k={},G={},E={};function n(D,u){if(D===undefined&&u.statusCode===200){s({message:"Response did not contain a valid OData result",response:u});return;}function v(D,u){for(var i=0;i<R.parts.length;i++){if(R.parts[i].request._aborted){t._processAborted(R.parts[i].request,u);}else if(R.parts[i].fnSuccess){R.parts[i].fnSuccess(D,u);}}if(R.request.requestUri.indexOf("$count")===-1){t.checkUpdate(false,false,G);if(R.bRefreshAfterChange){t._refresh(false,undefined,k,E);}}}t._processSuccess(R.request,u,v,G,k,E);t._setSessionContextIdHeader(t._getHeader("sap-contextid",u.headers));}function s(u){if(u.message=="Request aborted"){for(var i=0;i<R.parts.length;i++){t._processAborted(R.parts[i].request,u);}}else{for(var i=0;i<R.parts.length;i++){t._processError(R.parts[i].request,u,R.parts[i].fnError);}}t._processAfterUpdate();}R.request.eventInfo={requests:R.parts,batch:false};j=this._submitRequest(R.request,n,s);return j;};r.prototype._submitBatchRequest=function(k,R,s,E){var t=this,n={},G={},u={};function v(j,F,H){for(var i=0;i<j.parts.length;i++){if(H||j.parts[i].request._aborted){t._processAborted(j.parts[i].request,F);}else if(F.message){t._processError(j.parts[i].request,F,j.parts[i].fnError);}else{t._processSuccess(j.parts[i].request,F,j.parts[i].fnSuccess,G,n,u);}}}function w(F,H){if(F===undefined&&H.statusCode===200){x({message:"Response did not contain a valid OData batch result",response:H});return;}var I,J,K,L=F.__batchResponses;if(L){var i,j;for(i=0;i<L.length;i++){I=L[i];if(Array.isArray(R[i])){if(I.message){for(j=0;j<R[i].length;j++){J=R[i][j];v(J,I);J.response=I;}}else{K=I.__changeResponses;for(j=0;j<K.length;j++){var N=K[j];J=R[i][j];v(J,N);J.response=N;}}}else{J=R[i];v(J,I);J.response=I;}}t.checkUpdate(false,false,G);}t._processSuccess(k,H,s,G,n,u,true,R);t._setSessionContextIdHeader(t._getHeader("sap-contextid",H.headers));}function x(j){var F=j.message=="Request aborted";q.each(R,function(i,H){if(Array.isArray(H)){H.forEach(function(H){v(H,j,F);});}else{v(H,j,F);}});t._processAfterUpdate();if(F){t._processAborted(k,j,true);}else{t._processError(k,j,E,true,R);}}k.eventInfo={requests:R,batch:true};var y=this._submitRequest(k,w,x);function z(j){var E;for(var i=0;i<j.parts.length;i++){E=j.parts[i].fnError;if(!j.parts[i].request._aborted&&E){E(A);}}}var D={abort:function(){q.each(R,function(i,j){if(Array.isArray(j)){j.forEach(function(j){z(j);});}else{z(j);}});y.abort();}};return D;};r.prototype._createBatchRequest=function(i){var u,R,j={},P={},k=true;P.__batchRequests=i;for(var I in i){if(i[I]&&i[I].__changeRequests||i[I]&&i[I].headers&&!i[I].headers['sap-cancel-on-close']){k=false;break;}}u=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){u+="?"+this.aUrlParams.join("&");}q.extend(j,this.mCustomHeaders,this.oHeaders);j["Accept"]="multipart/mixed";delete j["Content-Type"];j['sap-cancel-on-close']=k;R={headers:j,requestUri:u,method:"POST",data:P,user:this.sUser,password:this.sPassword,async:true};R.withCredentials=this.bWithCredentials;return R;};r.prototype.abortInternalRequest=function(k,G){var R=this.mRequests;if(G in this.mDeferredGroups){R=this.mDeferredRequests;}var j=R[G];if(j&&k in j.map){var n=j.map[k];for(var i=0;i<n.parts.length;i++){n.parts[i].requestHandle.abort();}}};r.prototype._pushToRequestQueue=function(R,G,s,i,S,E,j,k){var n=R[G],t=i.key?i.key:i.method+":"+i.requestUri;if(!n){n={};n.map={};n.requests=[];R[G]=n;}if(t in n.map&&(i.key||i.method==='GET')){var u=n.map[t];var v=u.request;if(u.bRefreshAfterChange===undefined){u.bRefreshAfterChange=k;}if(!i.key){u.parts.push({request:i,fnSuccess:S,fnError:E,requestHandle:j});}if(i.method==="GET"){delete v.data;}else{v.method=i.method;v.headers=i.headers;v.data=i.data;v.requestUri=i.requestUri;if(i.method==="PUT"){delete v.headers["x-http-method"];}if(v._aborted){delete v._aborted;}}}else{var u={request:i,bRefreshAfterChange:k,parts:[{request:i,fnSuccess:S,fnError:E,requestHandle:j}]};if(i.method==="GET"){n.requests.push(u);}else{if(!n.changes){n.changes={};}var w=n.changes[s];if(!w){w=[];n.changes[s]=w;}u.changeSetId=s;w.push(u);}n.map[t]=u;}};r.prototype._collectChangedEntities=function(G,j,E){var t=this;if(G.changes){q.each(G.changes,function(s,k){for(var i=0;i<k.length;i++){if(k[i].bRefreshAfterChange){var R=k[i].request,P="/"+R.requestUri.split("?")[0],n,K;if(R.method==="POST"||R.method==="DELETE"){var u=t.oMetadata._getEntityTypeByPath(P);if(u){E[u.entityType]=true;}}else{n=t._getObject(P);if(n){K=t._getKey(n);}else if(P.lastIndexOf("/")===0){K=t._getKey(P);}if(K){j[K]=true;}}}}});}};r.prototype._processRequestQueue=function(R,G,s,E){var t=this,P,j=[];function k(n,W){for(var i=0;i<n.parts.length;i++){var u=n.parts[i];if(u.request._aborted){t._processAborted(n.request,null);n.parts.splice(i,1);i--;}else if(W){u.request._handle=W;W.iRelevantRequests++;}}}function w(){return{iRelevantRequests:0,oRequestHandle:{},abort:function(){this.iRelevantRequests--;if(this.iRelevantRequests===0&&this.oRequestHandle){this.oRequestHandle.abort();}}};}if(this.bUseBatch){q.each(R,function(i,n){if(i===G||!G){var u={},v={};t._collectChangedEntities(n,u,v);if(Object.keys(u).length||Object.keys(v).length){t.bIncludeInCurrentBatch=true;t._refresh(false,i,u,v);t.bIncludeInCurrentBatch=false;}}});q.each(R,function(n,u){if(n===G||!G){var v=[],x=[],y,z;var W=w();if(u.changes){q.each(u.changes,function(H,I){y={__changeRequests:[]};z=[];for(var i=0;i<I.length;i++){P='/'+t.getKey(I[i].request.data);t.increaseLaundering(P,I[i].request.data);k(I[i],W);if(I[i].parts.length>0){if(I[i].request.data&&I[i].request.data.__metadata){delete I[i].request.data.__metadata.created;}y.__changeRequests.push(I[i].request);z.push(I[i]);}}if(y.__changeRequests&&y.__changeRequests.length>0){v.push(y);x.push(z);}});}if(u.requests){var D=u.requests;for(var i=0;i<D.length;i++){k(D[i],W);if(D[i].parts.length>0){v.push(D[i].request);x.push(D[i]);}}}if(v.length>0){var F=t._createBatchRequest(v);W.oRequestHandle=t._submitBatchRequest(F,x,s,E);j.push(W.oRequestHandle);}delete R[n];}});}else{q.each(R,function(n,u){if(n===G||!G){if(u.changes){q.each(u.changes,function(x,y){for(var i=0;i<y.length;i++){var W=w();P='/'+t.getKey(y[i].request.data);t.increaseLaundering(P,y[i].request.data);k(y[i],W);if(y[i].parts.length>0){W.oRequestHandle=t._submitSingleRequest(y[i]);j.push(W.oRequestHandle);}}});}if(u.requests){var v=u.requests;for(var i=0;i<v.length;i++){var W=w();k(v[i],W);if(v[i].parts.length>0){W.oRequestHandle=t._submitSingleRequest(v[i]);j.push(W.oRequestHandle);}}}delete R[n];}});}this.checkDataState(this.mLaunderingState);return j.length==1?j[0]:j;};r.prototype._processRequestQueueAsync=function(R){var t=this;if(!this.pCallAsnyc){this.pCallAsnyc=new Promise(function(i,j){t.oMetadata.loaded().then(function(){i();});});this.pCallAsnyc.then(function(){t._processRequestQueue(R);t.pCallAsnyc=undefined;});}};r.prototype._processSuccess=function(R,i,s,G,j,E,k,n){var t=i.data,I,u,v,P,w,x,y,L={},z={},D=this;if(!k){u=!(i.statusCode===204||i.statusCode==='204');v=R.requestUri;P=v.replace(this.sServiceUrl,"");if(!q.sap.startsWith(P,'/')){P='/'+P;}P=this._normalizePath(P);this.decreaseLaundering(P,R.data);if(u&&t===undefined&&i){this._parseResponse(i,R);q.sap.log.fatal(this+" - No data was retrieved by service: '"+i.requestUri+"'");D.fireRequestCompleted({url:i.requestUri,type:"GET",async:i.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false;}if(t&&t.results&&!Array.isArray(t.results)){t=t.results;}if(!i._imported&&t&&(Array.isArray(t)||typeof t=='object')){I=q.sap.extend(true,{},t);D._importData(I,L,i);i._imported=true;}x=this._getEntity(R.key);if(L&&x&&x.__metadata.created&&x.__metadata.created.functionImport){var F=[];var H=x["$result"];if(H&&H.__list){q.each(L,function(K){F.push(K);});H.__list=F;}else if(H&&H.__ref){q.each(L,function(K){H.__ref=K;});}}if(!u){w=P.split("/");if(w[1]){z[w[1]]=R;var J={};J[w[1]]=R.data;this._updateChangedEntities(J);}if(R.method==="DELETE"&&w[2]!=="$links"){this._removeEntity(w[1]);}}if(u&&R.method==="POST"){y=this.oMetadata._getEntityTypeByPath(P);if(y){E[y.entityType]=true;}if(R.key){var K=this._getKey(t);var N=this.getContext("/"+R.key);N.sPath='/'+K;N.bCreated=false;this.mContexts[K]=N;this._removeEntity(R.key);x=this._getEntity(K);if(x){delete x.__metadata.created;}}}this._parseResponse(i,R,L,z);q.extend(G,L);q.extend(j,z);this._updateETag(R,i);}if(s){s(t,i);}var Q=this._createEventInfo(R,i,n);if(k){this.fireBatchRequestCompleted(Q);}else{this.fireRequestCompleted(Q);}return true;};r.prototype._processError=function(R,i,E,j,k){var P,n=this._handleError(i,R);if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);}if(E){E(n);}var s=this._createEventInfo(R,n,k);if(j){this.fireBatchRequestCompleted(s);this.fireBatchRequestFailed(s);}else{this.fireRequestCompleted(s);this.fireRequestFailed(s);}};var A={message:"Request aborted",statusCode:0,statusText:"abort",headers:{},responseText:""};r.prototype._processAborted=function(R,i,j){var P;if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);}if(i){var E=this._createEventInfo(R,A);E.success=false;if(j){this.fireBatchRequestCompleted(E);}else{this.fireRequestCompleted(E);}}};r.prototype._processAfterUpdate=function(){var j=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var i=0;i<j.length;i++){j[i]();}};r.prototype._processChange=function(k,D,u){var P,E,i,s,j,t,v,H,w,R,x,y=this;E=this.oMetadata._getEntityTypeByPath(k);if(!u){u="MERGE";}P=q.sap.extend(true,{},this._getObject('/'+k,true),D);if(D.__metadata&&D.__metadata.created){s=D.__metadata.created.method?D.__metadata.created.method:"POST";k=D.__metadata.created.key;v=true;i=D.__metadata.created;if(D.__metadata.created.functionImport){i.urlParameters=this._createFunctionImportParameters(D.__metadata.created.key,s,P);P=undefined;}}else if(u==="MERGE"){s="MERGE";x=this._getEntity(k);}else{s="PUT";}if(P&&P.__metadata){for(var n in P.__metadata){if(n!=='type'&&n!=='uri'&&n!=='etag'&&n!=='content_type'&&n!=='media_src'){delete P.__metadata[n];}}}if(P&&E){var N=this.oMetadata._getNavigationPropertyNames(E);N.forEach(function(G){delete P[G];});}if(s==="MERGE"&&E&&x){q.each(P,function(G,I){if(G!=='__metadata'){if(q.sap.equal(x[G],I)&&!y.isLaundering('/'+k+'/'+G)){delete P[G];}}});var z="/"+k,F;q.each(P,function(G,I){if(G!=='__metadata'){F=y.getProperty(z+"/"+G+"/#@sap:unit");if(F){if(P[F]===undefined){P[F]=x[F];}}}});}P=this._removeReferences(P);w=i&&i.urlParameters?a._createUrlParamsArray(i.urlParameters):undefined;H=i&&i.headers?this._getHeaders(i.headers):this._getHeaders();j=i&&i.eTag?i.eTag:this.getETag(P);t=this._createRequestUrl('/'+k,null,w,this.bUseBatch);R=this._createRequest(t,s,H,P,j);if(v){R.created=true;}if(this.bUseBatch){R.requestUri=R.requestUri.replace(this.sServiceUrl+'/','');}return R;};r.prototype._resolveGroup=function(k){var i,E,P,G,s,D;E=this.oMetadata._getEntityTypeByPath(k);D=this._getObject('/'+k);if(D){P=D.__metadata.created;if(P){return{groupId:P.groupId,changeSetId:P.changeSetId};}}if(this.mChangeGroups[E.name]){i=this.mChangeGroups[E.name];G=i.groupId;s=i.single?q.sap.uid():i.changeSetId;}else if(this.mChangeGroups['*']){i=this.mChangeGroups['*'];G=i.groupId;s=i.single?q.sap.uid():i.changeSetId;}return{groupId:G,changeSetId:s};};r.prototype._updateETag=function(R,i){var u,E,s;u=R.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u.split("?")[0]);s=this._getHeader("etag",i.headers);if(E&&E.__metadata&&s){E.__metadata.etag=s;}};r.prototype._handleError=function(E,R){var P={},t;var s="The following problem occurred: "+E.message;P.message=E.message;if(E.response){this._parseResponse(E.response,R);if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()==="required"){this.resetSecurityToken();}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;P.statusCode=E.response.statusCode;P.statusText=E.response.statusText;P.headers=E.response.headers;P.responseText=E.response.body;}q.sap.log.fatal(s);return P;};r.prototype.getData=function(P,i,I){return this.getProperty(P,i,I);};r.prototype._getODataHandler=function(u){if(u.indexOf("$batch")>-1){return p.batchHandler;}else if(u.indexOf("$count")>-1){return undefined;}else if(this.bJSON){return p.jsonHandler;}else{return p.atomHandler;}};r.prototype.getETag=function(P,i,E){if(typeof P=="object"){E=P;P="";}return this._getETag(P,i,E);};r.prototype._getETag=function(P,i,D){if(!D||!D.__metadata){D=this._getObject(P,i);}if(D&&D.__metadata){return D.__metadata.etag;}return null;};r.prototype.forceEntityUpdate=function(k){var D=this.mChangedEntities[k];if(D&&D.__metadata){D.__metadata.etag='*';}else{q.sap.log.error(this+" - Entity with key "+k+" does not exist or has no change");}};r.prototype._createRequest=function(u,s,H,D,E,i){i=i!==false;if(E&&s!=="GET"){H["If-Match"]=E;}if(!H["Content-Type"]&&s!=="DELETE"&&s!=="GET"){if(this.bJSON){H["Content-Type"]="application/json";}else{H["Content-Type"]="application/atom+xml";}}if(u.indexOf("$count")>-1){H["Accept"]="text/plain, */*;q=0.5";}if(s==="MERGE"&&!this.bUseBatch){H["x-http-method"]="MERGE";s="POST";}var R={headers:H,requestUri:u,method:s,user:this.sUser,password:this.sPassword,async:i};if(D){R.data=D;}if(this.bWithCredentials){R.withCredentials=this.bWithCredentials;}R.requestID=this._createRequestID();return R;};r.prototype._processRequest=function(P,E){var R,i,j=false,t=this;R={abort:function(){if(!j&&E){E(A);}if(i){i._aborted=true;if(i._handle){i._handle.abort();}}j=true;}};this.oMetadata.loaded().then(function(){i=P(R);t._processRequestQueueAsync(t.mRequests);if(j){R.abort();}});return R;};r.prototype.update=function(P,D,i){var s,E,R,u,j,k,n,G,t,v,H,w,x,y,z=this;if(i){G=i.groupId||i.batchGroupId;t=i.changeSetId;j=i.context;s=i.success;E=i.error;k=i.eTag;H=i.headers;v=i.urlParameters;y=i.refreshAfterChange;if(i.merge!==undefined){w=i.merge?"MERGE":"PUT";}}y=this._getRefreshAfterChange(y,G);n=a._createUrlParamsArray(v);H=this._getHeaders(H);w=w?w:this.sDefaultUpdateMethod;k=k||this._getETag(P,j,D);return this._processRequest(function(F){u=z._createRequestUrl(P,j,n,z.bUseBatch);R=z._createRequest(u,w,H,D,k);x=z.mRequests;if(G in z.mDeferredGroups){x=z.mDeferredRequests;}z._pushToRequestQueue(x,G,t,R,s,E,F,y);return R;},E);};r.prototype.create=function(P,D,i){var R,u,E,j,s,k,n,t,H,v,w,G,x,y,z,F=this;if(i){j=i.context;n=i.urlParameters;s=i.success;k=i.error;G=i.groupId||i.batchGroupId;y=i.changeSetId;w=i.eTag;H=i.headers;z=i.refreshAfterChange;}z=this._getRefreshAfterChange(z,G);v=a._createUrlParamsArray(n);H=this._getHeaders(H);x="POST";return this._processRequest(function(I){u=F._createRequestUrl(P,j,v,F.bUseBatch);R=F._createRequest(u,x,H,D,w);P=F._normalizePath(P,j);E=F.oMetadata._getEntityTypeByPath(P);R.entityTypes={};if(E){R.entityTypes[E.entityType]=true;}t=F.mRequests;if(G in F.mDeferredGroups){t=F.mDeferredRequests;}F._pushToRequestQueue(t,G,y,R,s,k,I,z);return R;},k);};r.prototype.remove=function(P,i){var j,k,s,E,R,u,G,n,t,v,w,H,x,y,z,D=this;if(i){G=i.groupId||i.batchGroupId;n=i.changeSetId;j=i.context;s=i.success;E=i.error;t=i.eTag;H=i.headers;w=i.urlParameters;v=i.refreshAfterChange;}v=this._getRefreshAfterChange(v,G);x=a._createUrlParamsArray(w);H=this._getHeaders(H);y="DELETE";t=t||this._getETag(P,j);function F(I,J){k=u.substr(u.lastIndexOf('/')+1);if(k.indexOf('?')!==-1){k=k.substr(0,k.indexOf('?'));}D._removeEntity(k);if(s){s(I,J);}}return this._processRequest(function(I){u=D._createRequestUrl(P,j,x,D.bUseBatch);R=D._createRequest(u,y,H,undefined,t);z=D.mRequests;if(G in D.mDeferredGroups){z=D.mDeferredRequests;}D._pushToRequestQueue(z,G,n,R,F,E,I,v);return R;},E);};r.prototype.callFunction=function(F,P){var R,u,i,j,k,n,s,E,t="GET",G,v,H,w,x=this,K,y,z,D,I,J,L,N={};if(P){G=P.groupId||P.batchGroupId;v=P.changeSetId;t=P.method?P.method:t;k=q.extend({},P.urlParameters);w=P.eTag;s=P.success;E=P.error;H=P.headers;L=P.refreshAfterChange;}L=this._getRefreshAfterChange(L,G);if(!q.sap.startsWith(F,"/")){q.sap.log.fatal(this+" callFunction: path '"+F+"' must be absolute!");return;}H=this._getHeaders(H);I=new Promise(function(Q,S){z=Q;D=S;});J=this._processRequest(function(Q){i=x.oMetadata._getFunctionImportMetadata(F,t);if(!i){D();return;}var S=i.entitySet||i.entitySetPath;if(S){N.$result={__list:[]};if(i.returnType&&i.returnType.indexOf("Collection")==-1){N.$result={__ref:{}};}}if(i.parameter!=null){q.each(i.parameter,function(T,V){N[V.name]=x._createPropertyValue(V.type);if(k&&k[V.name]!==undefined){N[V.name]=k[V.name];k[V.name]=a.formatValue(k[V.name],V.type);}else{q.sap.log.warning(x+" - No value for parameter '"+V.name+"' found!'");}});}K=F.substring(1)+"('"+q.sap.uid()+"')";N.__metadata={uri:x.sServiceUrl+'/'+K,created:{key:F.substring(1),success:s,error:E,headers:H,method:t,groupId:G,changeSetId:v,eTag:w,functionImport:true}};x._addEntity(N);y=x.getContext("/"+K);z(y);n=a._createUrlParamsArray(k);u=x._createRequestUrl(F,null,n,x.bUseBatch);R=x._createRequest(u,t,H,undefined,w);R.key=K;j=x.mRequests;if(G in x.mDeferredGroups){j=x.mDeferredRequests;}x._pushToRequestQueue(j,G,v,R,s,E,Q,L);return R;},E);J.contextCreated=function(){return I;};return J;};r.prototype._createFunctionImportParameters=function(F,s,P){var u=q.extend(true,{},P);delete u.__metadata;delete u["$result"];var i=this.oMetadata._getFunctionImportMetadata(F,s);if(!i){return;}if(i.parameter!=null){q.each(i.parameter,function(I,j){if(u&&u[j.name]!==undefined){u[j.name]=a.formatValue(u[j.name],j.type);}});}return u;};r.prototype.read=function(P,i){var R,u,j,k,s,E,F,S,n,t,v,N,w,H,x,G,y,z,D=this;if(i){j=i.context;k=i.urlParameters;s=i.success;E=i.error;F=i.filters;S=i.sorters;G=i.groupId||i.batchGroupId;H=i.headers;}if(this.sRefreshGroupId){G=this.sRefreshGroupId;}w=a._createUrlParamsArray(k);H=this._getHeaders(H,true);x="GET";y=this._getETag(P,j);var I={abort:function(){if(R){R._aborted=true;}}};function J(K){t=a.createSortParams(S);if(t){w.push(t);}var T=P;var L=P.indexOf("$count");if(L!==-1){T=P.substring(0,L-1);}N=D._normalizePath(T,j);v=D.oMetadata._getEntityTypeByPath(N);n=a.createFilterParams(F,D.oMetadata,v);if(n){w.push(n);}u=D._createRequestUrl(P,j,w,D.bUseBatch);R=D._createRequest(u,x,H,null,y);z=D.mRequests;if(G in D.mDeferredGroups){z=D.mDeferredRequests;}D._pushToRequestQueue(z,G,null,R,s,E,K,false);return R;}if(this.bUseBatch&&this.bIncludeInCurrentBatch){R=J(I);return I;}else{return this._processRequest(J,E);}};r.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};r.prototype.metadataLoaded=function(){var i=this.oMetadata.loaded();if(this.bLoadAnnotationsJoined){var j=function(){return i;};return this.pAnnotationsLoaded.then(j,j);}else{return i;}};r.prototype.annotationsLoaded=function(){return this.pAnnotationsLoaded;};r.prototype.isMetadataLoadingFailed=function(){return this.oMetadata.isFailed();};r.prototype.getServiceAnnotations=function(){var i=this.oAnnotations.getData();return q.isEmptyObject(i)?null:i;};r.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};r.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};r.prototype.addAnnotationUrl=function(u){var i=[].concat(u),j=[],k=[],E=[],t=this;i.forEach(function(s){var I=s.indexOf("$metadata");if(I>=0){s=t._createMetadataUrl(s);j.push(s);}else{k.push(s);}});return this.oMetadata._addUrl(j).then(function(P){return Promise.all(q.map(P,function(n){E=E.concat(n.entitySets);return t.oAnnotations.addSource({type:"xml",data:n["metadataString"]});}));}).then(function(){return t.oAnnotations.addSource(k);}).then(function(P){return{annotations:t.oAnnotations.getData(),entitySets:E};});};r.prototype.addAnnotationXML=function(x,s){return this.oAnnotations.addSource({type:"xml",data:x});};r.prototype.submitChanges=function(P){var R,G,j,s,E,k,v,n=false,t,u,w=this.bRefreshAfterChange,x,y=this;if(P){G=P.groupId||P.batchGroupId;s=P.success;E=P.error;if(P.merge!==undefined){t=P.merge?"MERGE":"PUT";}}if(G&&!this.mDeferredGroups[G]){q.sap.log.fatal(this+" submitChanges: \""+G+"\" is not a deferred group!");}u=q.sap.extend(true,{},y.mChangedEntities);this.oMetadata.loaded().then(function(){q.each(u,function(K,J){j=y._resolveGroup(K);if(j.groupId===G||!G){R=y._processChange(K,J,t||y.sDefaultUpdateMethod);R.key=K;x=J.__metadata&&J.__metadata.created?J.__metadata.created:{};var k={abort:function(){R._aborted=true;}};if(j.groupId in y.mDeferredGroups){y._pushToRequestQueue(y.mDeferredRequests,j.groupId,j.changeSetId,R,x.success,x.error,k,w);}}});var z,D,F,H,I,i;for(z in y.mDeferredRequests){F=y.mDeferredRequests[z];for(D in F.changes){H=F.changes[D];for(i=H.length-1;i>=0;i--){I=H[i];if(I.bRefreshAfterChange===undefined){I.bRefreshAfterChange=w;}}}}v=y._processRequestQueue(y.mDeferredRequests,G,s,E);if(n){k.abort();}});k={abort:function(){if(v){if(Array.isArray(v)){v.forEach(function(k){k.abort();});}else{v.abort();}}else{if(!n&&E){E(A);}n=true;}}};return k;};r.prototype._updateChangedEntities=function(i){var t=this,R;function u(j,k){q.each(k,function(K){var s=R+'/'+K;if(q.isPlainObject(k[K])&&q.isPlainObject(j[K])){u(j[K],k[K]);if(q.isEmptyObject(k[K])){delete k[K];}}else if(q.sap.equal(k[K],j[K])&&!t.isLaundering(s)){delete k[K];}});}q.each(i,function(k,D){if(k in t.mChangedEntities){var E=t._getObject('/'+k,null,true);var j=t._getObject('/'+k);q.sap.extend(true,E,D);R='/'+k;u(E,j);if(q.isEmptyObject(j)){delete t.mChangedEntities[k];t.abortInternalRequest(k,t._resolveGroup(k).groupId);}else{t.mChangedEntities[k]=j;j.__metadata={};q.extend(j.__metadata,E.__metadata);}}});};r.prototype.resetChanges=function(P){var t=this,j,E={},k,n;if(P){q.each(P,function(I,s){t.getEntityByPath(s,null,E);j=E.propertyPath.split("/");var K=E.key;k=t.mChangedEntities[K];for(var i=0;i<j.length-1;i++){if(k.hasOwnProperty(j[i])){k=k[j[i]];}else{k=undefined;}}if(k){delete k[j[j.length-1]];}if(t.mChangedEntities[K]){n=t.mChangedEntities[K].__metadata;delete t.mChangedEntities[K].__metadata;if(q.isEmptyObject(t.mChangedEntities[K])||!E.propertyPath){t.oMetadata.loaded().then(function(){t.abortInternalRequest(K,t._resolveGroup(K).groupId);});delete t.mChangedEntities[K];}else{t.mChangedEntities[K].__metadata=n;}}else{q.sap.log.warning(t+" - resetChanges: "+s+" is not changed");}});}else{q.each(this.mChangedEntities,function(K,i){t.oMetadata.loaded().then(function(){t.abortInternalRequest(K,t._resolveGroup(K).groupId);});delete t.mChangedEntities[K];});}this.checkUpdate(true);};r.prototype.setProperty=function(P,v,j,k){var n,s,R,t,u,E,w,x,K,G,y,z,D={},F={},H,I,J,L=false,N=this,Q;function S(T,V){q.each(V,function(K){if(q.isPlainObject(V[K])&&q.isPlainObject(T[K])){S(T[K],V[K]);if(q.isEmptyObject(V[K])){delete V[K];}}else if(q.sap.equal(V[K],T[K])){delete V[K];}});}w=this.resolve(P,j,true);E=this.getEntityByPath(w,null,F);if(!E){return false;}s=w.substring(w.lastIndexOf("/")+1);K=F.key;u=this._getObject('/'+K,null,true);n=this._getObject(P,j,true);if(!this.mChangedEntities[K]){z=E.__metadata;E={};E.__metadata=q.extend({},z);this.mChangedEntities[K]=E;}I=this.mChangedEntities[K];x=F.propertyPath.split("/");for(var i=0;i<x.length-1;i++){if(!I.hasOwnProperty(x[i])){I[x[i]]={};}I=I[x[i]];}L=u.__metadata.created&&u.__metadata.created.functionImport;I[s]=v;if(q.sap.equal(v,n)&&!this.isLaundering('/'+K)&&!L){z=this.mChangedEntities[K].__metadata;Q=z&&z.created;delete this.mChangedEntities[K].__metadata;if(!Q){S(u,this.mChangedEntities[K]);}if(q.isEmptyObject(this.mChangedEntities[K])){delete this.mChangedEntities[K];D[K]=true;this.checkUpdate(false,k,D);N.oMetadata.loaded().then(function(){N.abortInternalRequest(K,N._resolveGroup(K).groupId);});return true;}this.mChangedEntities[K].__metadata=z;}G=this._resolveGroup(K);R=this.mRequests;if(G.groupId in this.mDeferredGroups){R=this.mDeferredRequests;t=this._processChange(K,{__metadata:E.__metadata});}else{t=this._processChange(K,this._getObject('/'+K));}t.key=K;H=I.__metadata&&I.__metadata.created?I.__metadata.created:{};J=this._getRefreshAfterChange(undefined,G.groupId);this.oMetadata.loaded().then(function(){y={abort:function(){t._aborted=true;}};N._pushToRequestQueue(R,G.groupId,G.changeSetId,t,H.success,H.error,y,J);N._processRequestQueueAsync(N.mRequests);});D[K]=true;this.checkUpdate(false,k,D);return true;};r.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;case"sap-contextid-accept":case"sap-contextid":return!this.bDisableSoftStateHeader;default:return false;}};r.prototype.setHeaders=function(H){var i={},t=this;this.mCustomHeaders={};if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{i[s]=j;}});this.mCustomHeaders=i;}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};r.prototype._getHeaders=function(H,i){var j={},t=this;if(H){q.each(H,function(s,k){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{j[s]=k;}});}return q.extend({'sap-cancel-on-close':!!i},this.mCustomHeaders,j,this.oHeaders);};r.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders);};r.prototype._getHeader=function(H,i){var s;for(s in i){if(s.toLowerCase()===H.toLowerCase()){return i[s];}}return null;};r.prototype.hasPendingChanges=function(){return!q.isEmptyObject(this.mChangedEntities);};r.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0;};r.prototype.getPendingChanges=function(){return q.sap.extend(true,{},this.mChangedEntities);};r.prototype.updateBindings=function(F){this.checkUpdate(F);};r.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t;};r.prototype.setUseBatch=function(u){this.bUseBatch=u;};r.prototype.formatValue=function(v,t){return a.formatValue(v,t);};r.prototype.deleteCreatedEntry=function(i){var t=this,k,G;if(i){var k=i.getPath().substr(1);G=this._resolveGroup(k).groupId;t.oMetadata.loaded().then(function(){t.abortInternalRequest(k,G);});t._removeEntity(k);sap.ui.getCore().getMessageManager().removeMessages(this.getMessagesByEntity(i.getPath(),true));}};r.prototype.createEntry=function(P,j){var s,E,R,u,k,n,K,t,G,v,w,x,H,y,z,D={},F,I="POST",J=this;if(j){z=j.properties;G=j.groupId||j.batchGroupId;v=j.changeSetId;n=j.context;s=j.success;E=j.error;F=j.created;k=j.eTag;H=j.headers;x=j.urlParameters;w=j.refreshAfterChange;}w=this._getRefreshAfterChange(w,G);G=G?G:this.sDefaultChangeGroup;t=a._createUrlParamsArray(x);H=this._getHeaders(H);var L={abort:function(){if(R){R._aborted=true;}}};function N(){var Q;if(!q.sap.startsWith(P,"/")){P="/"+P;}var S=J.oMetadata._getEntityTypeByPath(P);if(!S){return undefined;}if(typeof z==="object"&&!Array.isArray(z)){D=z;}else{for(var i=0;i<S.property.length;i++){var T=S.property[i];var V=q.inArray(T.name,z)>-1;if(!z||V){D[T.name]=J._createPropertyValue(T.type);if(V){z.splice(z.indexOf(T.name),1);}}}if(z){}}var W=J.oMetadata._getEntitySetByType(S);K=W.name+"('"+q.sap.uid()+"')";D.__metadata={type:""+S.entityType,uri:J.sServiceUrl+'/'+K,created:{key:P.substring(1),success:s,error:E,headers:H,urlParameters:x,groupId:G,changeSetId:v,eTag:k}};J._addEntity(q.sap.extend(true,{},D));J.mChangedEntities[K]=D;u=J._createRequestUrl(P,n,t,J.bUseBatch);R=J._createRequest(u,I,H,D,k);Q=J.getContext("/"+K);Q.bCreated=true;R.key=K;R.created=true;y=J.mRequests;if(G in J.mDeferredGroups){y=J.mDeferredRequests;}J.oMetadata.loaded().then(function(){J._pushToRequestQueue(y,G,v,R,s,E,L,w);J._processRequestQueueAsync(J.mRequests);});return Q;}if(F){this.oMetadata.loaded().then(function(){F(N());});}else if(this.oMetadata.isLoaded()){return N();}else{q.sap.log.error("Tried to use createEntry without created-callback, before metadata is available!");}};r.prototype._isCreatedEntity=function(E){return!!(E&&E.__metadata&&E.__metadata.created);};r.prototype._createPropertyValue=function(t){var T=this.oMetadata._splitName(t);var n=T.namespace;var s=T.name;if(n.toUpperCase()!=='EDM'){var j={};var k=this.oMetadata._getObjectMetadata("complexType",s,n);for(var i=0;i<k.property.length;i++){var P=k.property[i];j[P.name]=this._createPropertyValue(P.type);}return j;}else{return this._getDefaultPropertyValue(s,n);}};r.prototype._getDefaultPropertyValue=function(t,n){return undefined;};r.prototype._normalizePath=function(P,i){if(P&&P.indexOf('?')!==-1){P=P.substr(0,P.indexOf('?'));}if(!i&&!q.sap.startsWith(P,"/")){q.sap.log.fatal(this+" path "+P+" must be absolute if no Context is set");}return this.resolve(P,i);};r.prototype.getRefreshAfterChange=function(){return this.bRefreshAfterChange;};r.prototype.setRefreshAfterChange=function(R){this.bRefreshAfterChange=R;};r.prototype.isList=function(P,i){P=this.resolve(P,i);return P&&P.substr(P.lastIndexOf("/")).indexOf("(")===-1;};r.prototype._isMetadataPath=function(P){var i=false;if(P&&P.indexOf('/#')>-1){i=true;}return i;};r.prototype.isMetaModelPath=function(P){return P.indexOf("##")==0||P.indexOf("/##")>-1;};r.prototype._request=function(R,s,E,H,i,j){var k;if(this.bDestroyed){return{abort:function(){}};}var t=this;function w(n){return function(){var I=q.inArray(k,t.aPendingRequestHandles);if(I>-1){t.aPendingRequestHandles.splice(I,1);}if(!(k&&k.bSuppressErrorHandlerCall)){n.apply(this,arguments);}};}k=p.request(R,w(s||p.defaultSuccess),w(E||p.defaultError),H,i,j);if(R.async!==false){this.aPendingRequestHandles.push(k);}return k;};r.prototype.destroy=function(){this.bDestroyed=true;M.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var R=this.aPendingRequestHandles[i];if(R&&R.abort){R.bSuppressErrorHandlerCall=true;R.abort();}}delete this.aPendingRequestHandles;}if(this.sMetadataLoadEvent){q.sap.clearDelayedCall(this.sMetadataLoadEvent);}if(this.oMetadataFailedEvent){q.sap.clearDelayedCall(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oServiceData.oMetadata;}delete this.oMetadata;delete this.pMetadataLoaded;}if(this.oMetaModel){this.oMetaModel.destroy();delete this.oMetaModel;}if(this.oAnnotations){this.oAnnotations.detachSomeLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachAllFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;delete this.pAnnotationsLoaded;}};r.prototype.setDeferredBatchGroups=function(G){this.setDeferredGroups(G);};r.prototype.setDeferredGroups=function(G){var t=this;this.mDeferredGroups={};q.each(G,function(i,s){t.mDeferredGroups[s]=s;});};r.prototype.getDeferredBatchGroups=function(){return this.getDeferredGroups();};r.prototype.getDeferredGroups=function(){return Object.keys(this.mDeferredGroups);};r.prototype.setChangeBatchGroups=function(G){q.each(G,function(E,i){i.groupId=i.batchGroupId;});this.setChangeGroups(G);};r.prototype.setChangeGroups=function(G){this.mChangeGroups=G;};r.prototype.getChangeBatchGroups=function(){return this.getChangeGroups();};r.prototype.getChangeGroups=function(){return this.mChangeGroups;};r.prototype.setMessageParser=function(P){if(!(P instanceof m)){q.sap.log.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return this;}P.setProcessor(this);this.oMessageParser=P;return this;};r.prototype._parseResponse=function(R,i,G,j){try{if(!this.oMessageParser){this.oMessageParser=new o(this.sServiceUrl,this.oMetadata);this.oMessageParser.setProcessor(this);}this.oMessageParser.parse(R,i,G,j);}catch(k){q.sap.log.error("Error parsing OData messages: "+k);}};r.prototype.callAfterUpdate=function(F){this.aCallAfterUpdate.push(F);};r.prototype.getMetaModel=function(){var t=this;if(!this.oMetaModel){this.oMetaModel=new l(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){t.bMetaModelLoaded=true;t.checkUpdate(false,false,null,true);},function(E){var s=E.message,D;if(!s&&E.xmlDoc&&E.xmlDoc.parseError){s=E.xmlDoc.parseError.reason;D=E.xmlDoc.parseError.srcText;}q.sap.log.error("error in ODataMetaModel.loaded(): "+s,D,"sap.ui.model.odata.v2.ODataModel");});}return this.oMetaModel;};r.prototype.getOriginalProperty=function(P,i){return this._getObject(P,i,true);};r.prototype.getEntityByPath=function(P,i,E){var R=M.prototype.resolve.call(this,P,i);if(!R){return null;}var j=R.split("/"),k=null,n=[];while(j.length>0){var s=j.join("/"),t=this._getObject(s);if(q.isPlainObject(t)){var K=this._getKey(t);if(K){k=t;break;}}n.unshift(j.pop());}if(k){E.propertyPath=n.join("/");E.key=K;return k;}return null;};r.prototype.resolve=function(P,i,j){var R=M.prototype.resolve.call(this,P,i);if(!this._isMetadataPath(R)&&j){var E={},k=this.getEntityByPath(P,i,E);if(k){if(E.propertyPath){return"/"+E.key+"/"+E.propertyPath;}else{return"/"+E.key;}}else{return undefined;}}return R;};r.prototype.isLaundering=function(P,i){var R=this.resolve(P,i);return(R in this.mLaunderingState)&&this.mLaunderingState[R]>0;};r.prototype.increaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n];if(q.isPlainObject(j)){this.increaseLaundering(P+"/"+n,j);}else{var t=P+"/"+n;if(!(t in this.mLaunderingState)){this.mLaunderingState[t]=0;}this.mLaunderingState[t]++;}}if(!(P in this.mLaunderingState)){this.mLaunderingState[P]=0;}this.mLaunderingState[P]++;};r.prototype.decreaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n],t=P+"/"+n;if(q.isPlainObject(j)){this.decreaseLaundering(t,j);}else{if(t in this.mLaunderingState){this.mLaunderingState[t]--;if(this.mLaunderingState[t]===0){delete this.mLaunderingState[t];}}}}this.mLaunderingState[P]--;if(this.mLaunderingState[P]===0){delete this.mLaunderingState[P];}};r.prototype._getRefreshAfterChange=function(R,G){if(R===undefined&&!(G in this.mDeferredGroups)){return this.bRefreshAfterChange;}return R;};r.prototype.getMessagesByEntity=function(E,j){var s=E,k=[],P;function n(k){var F=[];for(var i=0;i<k.length;i++){if(!j||(j&&!k[i].persistent)){F.push(k[i]);}}return F;}if(!q.sap.startsWith(s,'/')){s='/'+s;}if(this.mMessages){for(P in this.mMessages){if(q.sap.startsWith(P,s)){k=k.concat(n(this.mMessages[P]));}}return k;}return null;};return r;});
