/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./_Batch","./_Helper","./_SyncPromise","./_V2Requestor"],function(q,_,a,b,c){"use strict";var B={"Accept":"multipart/mixed"},d;function e(r,G){var f=r.mBatchQueue[G];if(f[0].length===0&&f.length===1){delete r.mBatchQueue[G];}}function g(h){var r;h=h.toLowerCase();for(r in this.headers){if(r.toLowerCase()===h){return this.headers[r];}}}function R(s,h,Q,m){this.mBatchQueue={};this.mHeaders=h||{};this.oModelInterface=m;this.sQueryParams=a.buildQuery(Q);this.mRunningChangeRequests={};this.oSecurityTokenPromise=null;this.sServiceUrl=s;}R.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8;IEEE754Compatible=true"};R.prototype.mPredefinedPartHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true"};R.prototype.mPredefinedRequestHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true","OData-MaxVersion":"4.0","OData-Version":"4.0","X-CSRF-Token":"Fetch"};R.prototype.batchRequestSent=function(G,h){if(h){if(G in this.mRunningChangeRequests){this.mRunningChangeRequests[G]+=1;}else{this.mRunningChangeRequests[G]=1;}}};R.prototype.batchResponseReceived=function(G,h){if(h){this.mRunningChangeRequests[G]-=1;if(this.mRunningChangeRequests[G]===0){delete this.mRunningChangeRequests[G];}}};R.prototype.buildQueryString=function(r,Q,D,s){return a.buildQuery(this.convertQueryOptions(r,Q,D,s));};R.prototype.cancelChanges=function(G){if(this.mRunningChangeRequests[G]){throw new Error("Cannot cancel the changes for group '"+G+"', the batch request is running");}this.cancelChangesByFilter(function(){return true;},G);};R.prototype.cancelChangesByFilter=function(f,G){var C=false,t=this;function h(s){var j=t.mBatchQueue[s],o,k,E,i;k=j[0];for(i=k.length-1;i>=0;i--){o=k[i];if(o.$cancel&&f(o)){o.$cancel();E=new Error("Request canceled: "+o.method+" "+o.url+"; group: "+s);E.canceled=true;o.$reject(E);k.splice(i,1);C=true;}}e(t,s);}if(G){if(this.mBatchQueue[G]){h(G);}}else{for(G in this.mBatchQueue){h(G);}}return C;};R.prototype.convertExpand=function(E,s){var k,r=[],t=this;if(!E||typeof E!=="object"){throw new Error("$expand must be a valid object");}k=Object.keys(E);if(s){k=k.sort();}k.forEach(function(f){var v=E[f];if(v&&typeof v==="object"){r.push(t.convertExpandOptions(f,v,s));}else{r.push(f);}});return r.join(",");};R.prototype.convertExpandOptions=function(E,v,s){var f=[];this.doConvertSystemQueryOptions(undefined,v,function(o,O){f.push(o+'='+O);},undefined,s);return f.length?E+"("+f.join(";")+")":E;};R.prototype.convertQueryOptions=function(r,Q,D,s){var C={};if(!Q){return undefined;}this.doConvertSystemQueryOptions(r,Q,function(k,v){C[k]=v;},D,s);return C;};R.prototype.doConvertSystemQueryOptions=function(r,Q,f,D,s){var t=this;Object.keys(Q).forEach(function(k){var v=Q[k];if(D&&k[0]==='$'){return;}switch(k){case"$expand":v=t.convertExpand(v,s);break;case"$select":if(Array.isArray(v)){v=s?v.sort().join(","):v.join(",");}break;default:}f(k,v);});};R.prototype.doConvertResponse=function(r){return r;};R.prototype.fetchTypeForPath=function(p,A){p="/"+p+"/";if(A){p+="$Type";}return this.oModelInterface.fnFetchMetadata(p);};R.prototype.formatPropertyAsLiteral=function(v,p){return a.formatLiteral(v,p.$Type);};R.prototype.getGroupSubmitMode=function(G){return this.oModelInterface.fnGetGroupProperty(G,"submit");};R.prototype.getKeyPredicate=function(E,o){var f,k=[],s=E.$Key.length===1,t=this;f=E.$Key.some(function(n){var v=o[n];if(v===undefined){return true;}v=encodeURIComponent(t.formatPropertyAsLiteral(v,E[n]));k.push(s?v:encodeURIComponent(n)+"="+v);});return f?undefined:"("+k.join(",")+")";};R.prototype.getServiceUrl=function(){return this.sServiceUrl;};R.prototype.hasPendingChanges=function(){var G,p;for(G in this.mBatchQueue){p=this.mBatchQueue[G][0].some(function(r){return r.$cancel;});if(p){return true;}}return Object.keys(this.mRunningChangeRequests).length>0;};R.prototype.ready=function(){return b.resolve();};R.prototype.refreshSecurityToken=function(){var t=this;if(!this.oSecurityTokenPromise){this.oSecurityTokenPromise=new Promise(function(r,f){q.ajax(t.sServiceUrl+t.sQueryParams,{method:"HEAD",headers:{"X-CSRF-Token":"Fetch"}}).then(function(D,T,j){t.mHeaders["X-CSRF-Token"]=j.getResponseHeader("X-CSRF-Token");t.oSecurityTokenPromise=null;r();},function(j,T,E){t.oSecurityTokenPromise=null;f(a.createError(j));});});}return this.oSecurityTokenPromise;};R.prototype.removePatch=function(p){var C=this.cancelChangesByFilter(function(o){return o.$promise===p;});if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.removePost=function(G,o){var C=this.cancelChangesByFilter(function(f){return f.body===o;},G);if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.request=function(m,r,G,h,p,s,C,i){var o,I=r==="$batch",P,f,j,t=this;if(G==="$cached"){throw new Error("Unexpected request: "+m+" "+r);}G=G||"$direct";if(I){o=_.serializeBatchRequest(d.cleanBatch(p));P=o.body;}else{if(this.getGroupSubmitMode(G)!=="Direct"){f=new Promise(function(k,l){var n=t.mBatchQueue[G];if(!n){n=t.mBatchQueue[G]=[[]];if(t.oModelInterface.fnOnCreateGroup){t.oModelInterface.fnOnCreateGroup(G);}}j={method:m,url:r,headers:q.extend({},t.mPredefinedPartHeaders,t.mHeaders,h,t.mFinalHeaders),body:p,$cancel:C,$reject:l,$resolve:k,$submit:s};if(m==="GET"){n.push(j);}else{n[0].push(j);}});j.$promise=f;return f;}P=JSON.stringify(d.cleanPayload(p));if(s){s();}}return new Promise(function(k,l){q.ajax(t.sServiceUrl+r+(I?t.sQueryParams:""),{data:P,headers:q.extend({},t.mPredefinedRequestHeaders,t.mHeaders,h,I?o.headers:t.mFinalHeaders),method:m}).then(function(p,T,n){t.mHeaders["X-CSRF-Token"]=n.getResponseHeader("X-CSRF-Token")||t.mHeaders["X-CSRF-Token"];if(I){k(_.deserializeBatchResponse(n.getResponseHeader("Content-Type"),p));}else{try{k(t.doConvertResponse(p));}catch(E){l(E);}}},function(n,T,E){var u=n.getResponseHeader("X-CSRF-Token");if(!i&&n.status===403&&u&&u.toLowerCase()==="required"){t.refreshSecurityToken().then(function(){k(t.request(m,r,G,h,p,undefined,undefined,true));},l);}else{l(a.createError(n));}});});};R.prototype.relocate=function(C,o,n){var r=this.mBatchQueue[C],t=this,f=r&&r[0].some(function(h,i){if(h.body===o){t.request(h.method,h.url,n,h.headers,o,h.$submit,h.$cancel).then(h.$resolve,h.$reject);r[0].splice(i,1);e(t,C);return true;}});if(!f){throw new Error("Request not found in group '"+C+"'");}};R.prototype.submitBatch=function(G){var C=[],h,p,r=this.mBatchQueue[G],t=this;function m(p,i){var j,P,s;if(p&&p.method==="PATCH"&&i.method==="PATCH"&&p.url===i.url&&q.sap.equal(p.headers,i.headers)){P=p.body;j=i.body;for(s in P){if(P[s]===null&&j[s]&&typeof j[s]==="object"){return undefined;}}return q.extend(true,P,j);}return undefined;}function v(r,i){var j;r.forEach(function(k,l){var E,n,s=i[l];if(Array.isArray(s)){v(k,s);}else if(!s){E=new Error("HTTP request was not processed because the previous request failed");E.cause=j;k.$reject(E);}else if(s.status>=400){s.getResponseHeader=g;j=a.createError(s);f(j,k);}else if(s.responseText){n=JSON.parse(s.responseText);try{k.$resolve(t.doConvertResponse(n));}catch(u){k.$reject(u);}}else{k.$resolve();}});}function o(i){if(Array.isArray(i)){i.forEach(o);}else if(i.$submit){i.$submit();}}function f(E,i){if(Array.isArray(i)){i.forEach(f.bind(null,E));}else{i.$reject(E);}}if(!r){return Promise.resolve();}delete this.mBatchQueue[G];o(r);r[0].forEach(function(i){var M=m(p,i);if(M){p.body=M;i.$resolve(p.$promise);}else{C.push(i);p=i;}});if(C.length===0){r.splice(0,1);}else if(C.length===1){r[0]=C[0];}else{r[0]=C;}h=C.length>0;this.batchRequestSent(G,h);return this.request("POST","$batch",undefined,B,r).then(function(i){t.batchResponseReceived(G,h);v(r,i);}).catch(function(E){var i=new Error("HTTP request was not processed because $batch failed");function j(r){r.forEach(function(k){if(Array.isArray(k)){j(k);}else{k.$reject(i);}});}t.batchResponseReceived(G,h);i.cause=E;j(r);throw E;});};d={cleanBatch:function(r){r.forEach(function(o){if(Array.isArray(o)){d.cleanBatch(o);}else{o.body=d.cleanPayload(o.body);}});return r;},cleanPayload:function(p){var r=p;if(r){Object.keys(r).forEach(function(k){if(k.indexOf("@$ui5.")===0){if(r===p){r=q.extend({},p);}delete r[k];}});}return r;},create:function(s,h,Q,m,o){var r=new R(s,h,Q,m);if(o==="2.0"){c(r);}return r;}};return d;},false);
