// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.rta.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.rta.ControlTreeModifier') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.ControlTreeModifier'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.changeHandler.JsControlTreeModifier'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/ControlTreeModifier",["sap/ui/fl/changeHandler/JsControlTreeModifier"], function (JsControlTreeModifier) {

	"use strict";

	/**
	 * Implementation of the RTA-specific functionality for the control tree modifier
	 *
	 * @class
	 * @extends sap.ui.fl.changehandler.jsControlTreeModifier
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @private
	 * @since 1.44
	 * @alias sap.ui.rta.ControlTreeModifier
	 * @experimental Since 1.44. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */

	/* Stack of reversals of previously executed operations, used to perform Undos
	 *   e.g. "destroy" is the reversal of "create control"
	 */
	var _aUndoStack;

	var RtaControlTreeModifier = {

		/**
		 * Start recording operations
		 */
		startRecordingUndo : function() {
			_aUndoStack = [];
		},

		/**
		 * Stop recording operations
		 * @return  {Array} stack of recorded undo operations
		 */
		stopRecordingUndo : function() {
			var aReturnUndoStack = _aUndoStack;
			_aUndoStack = undefined;
			return aReturnUndoStack;
		},

		/**
		 * Execute all recorded undo operations from stack
		 * @param  {Array} aUndoStack stack of recorded undo operations
		 */
		performUndo : function(aUndoStack) {
			while (aUndoStack.length) {
				var oOperation = aUndoStack.pop();
				this[oOperation.name].apply(this, oOperation.properties);
			}
		},

		/**
		 * Add an operation to the undo stack
		 * @param  {string} sFunctionName The name of the function
		 * @param  {any[]} aProperties   The properties related to the function
		 */
		_saveUndoOperation : function(sFunctionName, aProperties) {
			if (_aUndoStack) {
				_aUndoStack.push({
					name : sFunctionName,
					properties : aProperties
				});
			}
		},

		/**
		 * Execute the visibility change from parent and record the opposite visibility as undo operation
		 * @override
		 */
		setVisible : function (oControl, bVisible) {
			var bOldVisible = this.getVisible(oControl);

			var vReturnValue = JsControlTreeModifier.setVisible.apply(this, arguments);

			/* If the visibility changed, record the reversal as undo operation */
			if (bOldVisible !== this.getVisible(oControl)){
				this._saveUndoOperation("setVisible", [oControl, bOldVisible]);
			}

			return vReturnValue;
		},

		/**
		 * Execute the setStashed method and record the opposite value for the undo operation
		 * The control can be a StashedControl ("placeholder") or a "real" control
		 * After the setStashed operation, the placeholder can create a real control with same ID
		 * Therefore we must save the previous ID in order to perform setStashed on this new control when executing the undo
		 * Real controls have getVisible; placeholders have getStashed. For real controls, we only manipulate the visibility, since
		 * once they are created, the stashing is not relevant anymore
		 * @override
		 */
		setStashed: function (oControl, bStashed) {
			var bOldValue;
			var vControlId = oControl.getId();
			if (oControl.getVisible){
				bOldValue = !oControl.getVisible();
			} else {
				bOldValue = oControl.getStashed();
			}

			JsControlTreeModifier.setStashed.apply(this, arguments);

			var oSetControl = sap.ui.getCore().byId(vControlId);

			if (bOldValue !== bStashed) {
				this._saveUndoOperation("setStashed", [oSetControl, !bStashed]);
			}
		},

		/**
		 * Execute the bind property and record unbindProperty as undo operation if property was not previously bound + save property value
		 * If the property had a previous value, this value is restored with the undo
		 * @override
		 */
		bindProperty: function (oControl, sPropertyName, mBindingInfos) {
			var mOldBindingInfos = oControl.getBindingInfo(sPropertyName);
			var vOldValue;

			var oMetadata = oControl.getMetadata().getPropertyLikeSetting(sPropertyName);
			if (oMetadata) {
				var sPropertyGetter = oMetadata._sGetter;
				vOldValue = oControl[sPropertyGetter]();
			}

			JsControlTreeModifier.bindProperty.apply(this, arguments);

			if (mOldBindingInfos){
				this._saveUndoOperation("bindProperty", [oControl, sPropertyName, mOldBindingInfos]);
			} else {
				this._saveUndoOperation("unbindProperty", [oControl, sPropertyName]);
			}
			if (vOldValue) {
				this._saveUndoOperation("setProperty", [oControl, sPropertyName, vOldValue]);
			}
		},


		/**
		 * Unbind a property and record bindProperty as undo operation
		 * @param  {sap.ui.core.Control} oControl  The control containing the property
		 * @param  {string} sPropertyName  The property to be unbound
		 */
		unbindProperty: function (oControl, sPropertyName) {
			var mOldBindingInfos = oControl.getBindingInfo(sPropertyName);

			JsControlTreeModifier.unbindProperty.apply(this, arguments);

			if (mOldBindingInfos){
				this._saveUndoOperation("bindProperty", [oControl, sPropertyName, mOldBindingInfos]);
			}
		},

		/**
		 * Record the previous value of the property in the undo operation
		 * @override
		 */
		setProperty : function (oControl, sPropertyName, oPropertyValue) {
			var vOldValue;

			var oMetadata = oControl.getMetadata().getPropertyLikeSetting(sPropertyName);
			if (oMetadata) {
				var sPropertyGetter = oMetadata._sGetter;
				vOldValue = oControl[sPropertyGetter]();
			}

			var vReturnValue = JsControlTreeModifier.setProperty.apply(this, arguments);

			/* If the value changed, record the reversal as undo operation */
			if (vOldValue !== oPropertyValue){
				this._saveUndoOperation("setProperty", [oControl, sPropertyName, vOldValue]);
			}

			return vReturnValue;
		},

		/**
		 * Record the previous value of the property binding in the undo operation
		 * @override
		 */
		setPropertyBinding : function (oControl, sPropertyName, oPropertyBinding) {
			var oOldValue;
			var oMetadata = oControl.getMetadata().getPropertyLikeSetting(sPropertyName);

			if (oMetadata) {
				var sPropertyGetter = oMetadata._sGetter;
				oOldValue = oControl[sPropertyGetter]();
			}

			JsControlTreeModifier.setPropertyBinding.apply(this, arguments);

			/* If the value changed, record the reversal as undo operation */
			if (oOldValue !== oPropertyBinding) {
				this._saveUndoOperation("setPropertyBinding", [oControl, sPropertyName, oOldValue]);
			}
		},

		/**
		 * Record destroy as undo operation
		 * @override
		 */
		createControl: function (sClassName, oAppComponent, oView, oSelector) {
			var oExistingControl = this.bySelector(oSelector, oAppComponent);

			var vReturnValue = JsControlTreeModifier.createControl.apply(this, arguments);

			if (!oExistingControl) {
				var oCreatedControl = this.bySelector(oSelector, oAppComponent);
				this._saveUndoOperation("destroy", [oCreatedControl]);
			}

			return vReturnValue;
		},

		/**
		 * Controls are never destroyed by the user in RTA (only hidden)
		 * Therefore, there is no need to record an undo operation for destroy
		 * This function is to execute the undo operation of createControl
		 * @param  {sap.ui.core.Control} oControl The control which was created
		 */
		destroy : function(oControl) {
			if (oControl) {
				oControl.destroy();
			}
		},

		/**
		 * Adds an additional item to the aggregation or changes it in case it is not a multiple one
		 * Adds removeAggregation as the undo operation
		 * @override
		 */
		 insertAggregation: function (oParent, sName, oObject, iIndex) {
			var oOldAggregationValue = JsControlTreeModifier.getAggregation.call(this, oParent, sName);

			JsControlTreeModifier.insertAggregation.apply(this, arguments);

			if (oParent) {
				if (oParent.getMetadata) {
					var oMetadata = oParent.getMetadata();
					var oAggregations = oMetadata.getAllAggregations();
					if (oAggregations) {
						var oAggregation = oAggregations[sName];
						if (oAggregation) {
							if (oAggregation.multiple) {
								this._saveUndoOperation("removeAggregation", [oParent, sName, oObject]);
							} else {
								this._saveUndoOperation("insertAggregation", [oParent, sName, oOldAggregationValue]);
							}
						}
					}
				}
			}
		},

		/**
		 * Removes the object from the aggregation of the given control
		 * Adds insertAggregation as the undo operation
		 * The aggregationElements can be an array or a single object (e.g. ToolTip)
		 * @override
		 */
		removeAggregation: function (oParent, sName, oObject) {
			var iOldIndex;
			var oAggregationElements;
			if (oParent && oObject){
				oAggregationElements = JsControlTreeModifier.getAggregation.call(this, oParent, sName);
				if (oAggregationElements){
					oAggregationElements.some(function(oElement, iIndex) {
						if (oElement === oObject){
							iOldIndex = iIndex;
							return true;
						}
					});
				}
			}

			JsControlTreeModifier.removeAggregation.apply(this, arguments);

			if (iOldIndex || iOldIndex === 0) {
				this._saveUndoOperation("insertAggregation", [oParent, sName, oObject, iOldIndex]);
			}
		},

		/**
		 * Removes all objects from an aggregation of the given control
		 * Adds one insertAggregation per removed object as undo operations
		 * @override
		 */
		removeAllAggregation: function (oParent, sName) {
			var aOldAggregationElements = [];
			var vAggregationElements;
			if (oParent) {
				vAggregationElements = JsControlTreeModifier.getAggregation.call(this, oParent, sName);
			}

			if (vAggregationElements && vAggregationElements instanceof Array) {
				aOldAggregationElements = vAggregationElements.slice();
			} else  if (vAggregationElements && vAggregationElements instanceof Object) {
				aOldAggregationElements[0] = vAggregationElements;
			}

			JsControlTreeModifier.removeAllAggregation(oParent, sName);

			if (aOldAggregationElements){
				aOldAggregationElements.forEach(function(oElement) {
					this._saveUndoOperation("insertAggregation", [oParent, sName, oElement]);
				}, this);
			}
		}
	};

	return jQuery.sap.extend(
		true /* deep extend */,
		{} /* target object, to avoid changing of original modifier */,
		JsControlTreeModifier,
		RtaControlTreeModifier
	);
},
/* bExport= */true);

}; // end of sap/ui/rta/ControlTreeModifier.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.Utils') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.rta.Utils.
jQuery.sap.declare('sap.ui.rta.Utils'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.registry.Settings'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/Utils",[
	'jquery.sap.global',
	'sap/ui/fl/Utils',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/fl/registry/Settings'
],
function(
	jQuery,
	FlexUtils,
	OverlayUtil,
	OverlayRegistry,
	Settings
) {
	"use strict";

	/**
	 * Class for Utils.
	 *
	 * @class Utility functionality to work with controls, e.g. iterate through aggregations, find parents, etc.
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @private
	 * @static
	 * @since 1.30
	 * @alias sap.ui.rta.Utils
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality.
	 * API of this class might be changed in the future.
	 */

	var Utils = {};

	Utils.RESOLVED_PROMISE = Promise.resolve(true);

	Utils._sFocusableOverlayClass = ".sapUiDtOverlaySelectable";

	Utils._sRtaStyleClassName = null;

	/**
	 * Returns the rta specific Style Class
	 *
	 * @return {string} styleClass for RTA
	 */
	Utils.getRtaStyleClassName = function() {
		return Utils._sRtaStyleClassName;
	};

	/**
	 * Sets the rta specific Style Class to "sapContrast", except for the User layer.
	 *
	 * @param {string} sLayer the current Layer from RTA
	 */
	Utils.setRtaStyleClassName = function(sLayer) {
		if (sLayer === "USER") {
			Utils._sRtaStyleClassName = "";
		} else if (FlexUtils.getLayerIndex(sLayer) > -1) {
			Utils._sRtaStyleClassName = "sapContrast sapContrastPlus";
		}
	};

	/**
	 * Utility function to check if extensibility is enabled in the current system
	 *
	 * @param {sap.ui.core.Control} oControl - Control to be checked
	 * @returns {Promise} resolves a boolean
	 */
	Utils.isExtensibilityEnabledInSystem = function(oControl) {
		var sComponentName = FlexUtils.getComponentClassName(oControl);
		if (!sComponentName || sComponentName == "") {
			return Promise.resolve(false);
		}
		return Settings.getInstance(sComponentName).then(function(oSettings) {
			if (oSettings.isModelS) {
				return oSettings.isModelS();
			}
			return false;
		});
	};

	/**
	 * Utility function for retrieving designtime metadata from the relevant container for a specified overlay object
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay - Overlay object
	 * @returns {Object|undefined} Metadata object or false if there is no aggregation
	 */
	Utils.getRelevantContainerDesigntimeMetadata = function(oOverlay) {
		var oRelevantContainer = oOverlay.getRelevantContainer();
		if (!oRelevantContainer || !oOverlay.getParent()) {
			return undefined;
		}
		var oRelevantContainerOverlay = OverlayRegistry.getOverlay(oRelevantContainer);
		return oRelevantContainerOverlay ? oRelevantContainerOverlay.getDesignTimeMetadata() : undefined;
	};

	/**
	 * Utility function to check if the OData service is updated in the meantime
	 *
	 * @param {sap.ui.core.Control} oControl - Control to be checked
	 * @returns {Promise} resolves if service is up to date, rejects otherwise
	 */
	Utils.isServiceUpToDate = function(oControl) {
		return this.isExtensibilityEnabledInSystem(oControl).then(function(bEnabled) {
			if (bEnabled) {
				jQuery.sap.require("sap.ui.fl.fieldExt.Access");
				var oModel = oControl.getModel();
				if (oModel) {
					var bServiceOutdated = sap.ui.fl.fieldExt.Access.isServiceOutdated(oModel.sServiceUrl);
					if (bServiceOutdated) {
						sap.ui.fl.fieldExt.Access.setServiceValid(oModel.sServiceUrl);
						//needs FLP to trigger UI restart popup
						sap.ui.getCore().getEventBus().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{});
						return Promise.reject();
					}
				}
			}
		});
	};

	/**
	 * Utility function to check via backend calls if the custom field button shall be enabled or not
	 *
	 * @param {sap.ui.core.Control} oControl - Control to be checked
	 * @returns {Boolean} true if CustomFieldCreation functionality is to be enabled, false if not
	 */
	Utils.isCustomFieldAvailable = function(oControl) {
		return this.isExtensibilityEnabledInSystem(oControl).then(function(bShowCreateExtFieldButton) {
			if (!bShowCreateExtFieldButton) {
				return false;
			} else if (!oControl.getModel()) {
				return false;
			} else {
				var sServiceUrl = oControl.getModel().sServiceUrl;
				var sEntityType = this.getBoundEntityType(oControl).name;
				try {
					jQuery.sap.require("sap.ui.fl.fieldExt.Access");
					var oJQueryDeferred = sap.ui.fl.fieldExt.Access.getBusinessContexts(sServiceUrl,
							sEntityType);
					return Promise.resolve(oJQueryDeferred).then(function(oResult) {
						if (oResult) {
							if (oResult.BusinessContexts) {
								if (oResult.BusinessContexts.length > 0) {
									oResult.EntityType = sEntityType;
									return oResult;
								}
							}
						} else {
							return false;
						}
					}).catch(function(oError){
						if (oError) {
							if (jQuery.isArray(oError.errorMessages)) {
								for (var i = 0; i < oError.errorMessages.length; i++) {
									jQuery.sap.log.error(oError.errorMessages[i].text);
								}
							}
						}
						return false;
					});
				} catch (oError) {
					jQuery.sap.log
							.error("exception occured in sap.ui.fl.fieldExt.Access.getBusinessContexts", oError);
					return false;
				}
			}
		}.bind(this));
	};

	/**
	 * Opens a confirmation dialog indicating mandatory fields if necessary.
	 *
	 * @param {Object} oElement - The analyzed control
	 * @param {String} sText - Custom text for the dialog
	 * @return {Promise} The Promise which resolves when popup is closed (via Remove OR Cancel actions)
	 */
	Utils.openRemoveConfirmationDialog = function(oElement, sText) {
		var oTextResources = sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");
		var sTitle;
		return new Promise(
			function(resolve, reject) {

				sTitle = oTextResources.getText("CTX_REMOVE_TITLE");

				// create some dummy JSON data and create a Model from it
				var data = {
					messageText : sText,
					titleText : sTitle,
					icon : "sap-icon://question-mark",
					removeText : oTextResources.getText("BTN_FREP_REMOVE"),
					cancelText : oTextResources.getText("BTN_FREP_CANCEL")
				};
				var oModel = new sap.ui.model.json.JSONModel();
				oModel.setData(data);

				var oFragmentDialog;
				var fnCleanUp = function() {
					if (oFragmentDialog) {
						oFragmentDialog.close();
						oFragmentDialog.destroy();
						oFragmentDialog = null;
					}
				};

				// create a controller for the action in the Dialog
				var oFragmentController = {
					removeField : function() {
						fnCleanUp();
						resolve(true);
					},
					closeDialog : function() {
						fnCleanUp();
						resolve(false);
					}
				};

				// instantiate the Fragment if not done yet
				if (!oFragmentDialog) {
					oFragmentDialog = sap.ui.xmlfragment("sap.ui.rta.view.RemoveElementDialog", oFragmentController);
					oFragmentDialog.setModel(oModel);
				}
				oFragmentDialog.addStyleClass(Utils.getRtaStyleClassName());
				oFragmentDialog.open();
			}
		);
	};

	/**
	 * Checks if overlay is selectable in RTA (selectable also means focusable for RTA)
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - Overlay object
	 * @returns {boolean} if it's selectable
	 * @private
	 */
	Utils.isOverlaySelectable = function(oOverlay) {
		// check the real DOM visibility should be preformed while oOverlay.isVisible() can be true, but if element
		// has no geometry, overlay will not be visible in UI
		return oOverlay.isSelectable() && oOverlay.$().is(":visible");
	};

	/**
	 * Utility function for retrieving property values for a specified Element
	 *
	 * @param {sap.ui.core.Element} oElement - Any element
	 * @param {String} sPropertyName - Name of the property
	 * @returns {*} value of the property, could be any value
	 */
	Utils.getPropertyValue = function(oElement, sPropertyName) {
		var oMetadata = oElement.getMetadata().getPropertyLikeSetting(sPropertyName);
		var sPropertyGetter = oMetadata._sGetter;
		return oElement[sPropertyGetter]();
	};

	/**
	 * Returns overlay instance for an overlay's dom element
	 *
	 * @param {document.documentElement} oDomRef - DOM Element
	 * @returns {sap.ui.dt.ElementOverlay} Overlay object
	 * @private
	 */
	Utils.getOverlayInstanceForDom = function(oDomRef) {
		var sId = jQuery(oDomRef).attr("id");
		if (sId) {
			return sap.ui.getCore().byId(sId);
		}
	};

	/**
	 * Returns the focused overlay
	 *
	 * @returns {sap.ui.dt.ElementOverlay} Overlay object
	 * @private
	 */
	Utils.getFocusedOverlay = function() {
		if (document.activeElement) {
			var oElement = sap.ui.getCore().byId(document.activeElement.id);
			if (oElement instanceof sap.ui.dt.ElementOverlay) {
				return oElement;
			}
		}
	};

	/**
	 * Returns the focusable parent overlay
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - Target overlay object
	 * @returns {sap.ui.dt.ElementOverlay} Found overlay object
	 * @private
	 */
	Utils.getFocusableParentOverlay = function(oOverlay) {
		if (!oOverlay) {
			return undefined;
		}
		var oFocusableParentOverlay = oOverlay.getParentElementOverlay();

		while (oFocusableParentOverlay && !oFocusableParentOverlay.getSelectable()) {
			oFocusableParentOverlay = oFocusableParentOverlay.getParentElementOverlay();
		}
		return oFocusableParentOverlay;
	};

	/**
	 * Returns the first focusable child overlay. Loop over siblings and parents when no focusable siblings found
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - Target overlay object
	 * @returns {sap.ui.dt.ElementOverlay} Found overlay object
	 * @private
	 */
	Utils.getFirstFocusableDescendantOverlay = function(oOverlay) {
		return OverlayUtil.getFirstDescendantByCondition(oOverlay, this.isOverlaySelectable);
	};

	/**
	 * Returns the next focusable sibling overlay
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - Target overlay object
	 * @returns {sap.ui.dt.ElementOverlay} Found overlay object
	 * @private
	 */
	Utils.getNextFocusableSiblingOverlay = function(oOverlay) {
		var oNextFocusableSiblingOverlay = OverlayUtil.getNextSiblingOverlay(oOverlay);

		while (oNextFocusableSiblingOverlay && !this.isOverlaySelectable(oNextFocusableSiblingOverlay)) {
			oNextFocusableSiblingOverlay = OverlayUtil.getNextSiblingOverlay(oNextFocusableSiblingOverlay);
		}
		return oNextFocusableSiblingOverlay;
	};

	/**
	 * Returns the previous focusable sibling overlay
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - Target overlay object
	 * @returns {sap.ui.dt.ElementOverlay} Found overlay object
	 * @private
	 */
	Utils.getPreviousFocusableSiblingOverlay = function(oOverlay) {
		var oPreviousFocusableSiblingOverlay = OverlayUtil.getPreviousSiblingOverlay(oOverlay);

		while (oPreviousFocusableSiblingOverlay && !this.isOverlaySelectable(oPreviousFocusableSiblingOverlay)) {
			oPreviousFocusableSiblingOverlay = OverlayUtil
					.getPreviousSiblingOverlay(oPreviousFocusableSiblingOverlay);
		}
		return oPreviousFocusableSiblingOverlay;
	};

	/**
	 * Utility function for retrieving Element position in the specified Parent
	 *
	 * @param {sap.ui.core.Element} oParentElement - Parent Element
	 * @param {sap.ui.core.Element} oChildElement - Element which position is being looked for
	 * @param {String} sAggregationName - Aggregation name
	 * @param {Function} [fnGetIndex] - Custom handler for retreiving index
	 * @returns {Number} index of the element
	 */
	Utils.getIndex = function(oParentElement, oChildElement, sAggregationName, fnGetIndex) {
		var iIndex;
		if (fnGetIndex && typeof fnGetIndex === "function") {
			// fnGetIndex usually comes from designtime metadata, so aggregation name is clear and available in it
			iIndex = fnGetIndex.call(null, oParentElement, oChildElement);
		} else {
			var oMetadata = oParentElement.getMetadata();
			var oAggregation = oMetadata.getAggregation(sAggregationName);
			var sGetter = oAggregation._sGetter;
			var aContainers = oParentElement[sGetter]();

			if (Array.isArray(aContainers)) {
				if (oChildElement) {
					iIndex = aContainers.indexOf(oChildElement) + 1;
				} else {
					iIndex = aContainers.length;
				}
			} else {
				iIndex = 0;
			}
		}
		return iIndex;
	};

	/**
	 * Creates a unique id for a new control based on its parent control, entityType and binding path.
	 *
	 * @param {*} oParentControl - Parent control.
	 * @param {String} sEntityType - EntityType which is bound to the parent control
	 * @param {String} sBindingPath - Binding path of the control for which a new Id should be created
	 * @returns {String} New string Id
	 * @private
	 */
	Utils.createFieldLabelId = function(oParentControl, sEntityType, sBindingPath) {
		return (oParentControl.getId() + "_" + sEntityType + "_" + sBindingPath).replace("/", "_");
	};

	/**
	 * Secure extract a label from an element
	 *
	 * @param {sap.ui.core.Element} oElement - Any Object
	 * @param {Function} [fnFunction] - Custom function for retrieving label
	 * @return {String|undefined} Label string or undefined
	 */
	Utils.getLabelForElement = function(oElement, fnFunction) {
		// if there is a function, only the function is executed
		if (fnFunction) {
			return fnFunction(oElement);
		} else {
			// first try getText(), then getlabelText(), if not available try getLabel().getText(), then getTitle(), then getId()
			var sFieldLabel = oElement.getText && oElement.getText();
			if (!sFieldLabel) {
				sFieldLabel = oElement.getLabelText && oElement.getLabelText();
			}
			if (!sFieldLabel) {
				sFieldLabel = oElement.getLabel && oElement.getLabel();
				if (sFieldLabel && sFieldLabel.getText){
					sFieldLabel = sFieldLabel.getText();
				}
			}
			if (!sFieldLabel) {
				sFieldLabel = oElement.getTitle && oElement.getTitle();
			}
			if (!sFieldLabel) {
				sFieldLabel = oElement.getId && oElement.getId();
			}
			return (typeof sFieldLabel) === "string" ? sFieldLabel : undefined;
		}
	};

	/**
	 * Get the entity type based on the binding of a control
	 *
	 * @param {sap.ui.core.Element} oElement - Any Object
	 * @param {sap.ui.model.odata.ODataModel} oModel - Data model
	 * @return {Object} Entity type without namespace
	 */
	Utils.getBoundEntityType = function(oElement, oModel) {
		oModel || (oModel = oElement.getModel());

		var oBindingContext = oElement.getBindingContext();

		if (oBindingContext) {
			return Utils.getEntityTypeByPath(oModel, oBindingContext.getPath()) || {};
		}
		return {};
	};

	/**
	 * Allow window.open to be stubbed in tests
	 *
	 * @param {String} sUrl - url string
	 */
	Utils.openNewWindow = function(sUrl) {
		window.open(sUrl, "_blank");
	};

	/**
	 * Function to find the binding paths of a given UI5 Element
	 *
	 * @param {sap.ui.core.Element} oElement - Element for which the binding info should be found
	 * @returns {Object} valueProperty: the name of the property which is bound
	 * @private
	 */
	Utils.getElementBindingPaths = function(oElement) {
		var aPaths = {};
		if (oElement.mBindingInfos) {
			for ( var oInfo in oElement.mBindingInfos) {
				var sPath = oElement.mBindingInfos[oInfo].parts[0].path
						? oElement.mBindingInfos[oInfo].parts[0].path
						: "";
				sPath = sPath.split("/")[sPath.split("/").length - 1];
				aPaths[sPath] = {
						valueProperty : oInfo
				};
			}
		}
		return aPaths;
	};

	/**
	 * Function to get the Fiori2 Renderer
	 *
	 * @returns {sap.ushell.renderers.fiori2.Renderer|undefined} renderer or null if there is no one
	 */
	Utils.getFiori2Renderer = function() {
		var oContainer = Utils.getUshellContainer() || {};
		return typeof oContainer.getRenderer === "function" ? oContainer.getRenderer("fiori2") : undefined;
	};

	/**
	 * Function to get the Fiori Container
	 *
	 * @returns {Object|undefined} ushell container or null if there is no one
	 */
	Utils.getUshellContainer = function() {
		return sap.ushell && sap.ushell.Container;
	};

	/**
	 * Fetching entity metadata by specified path.
	 * @param {sap.ui.model.Model} oModel - Model
	 * @param {string} sPath Path to resolve
	 * @returns {Object|null} Plain object with entity description
	 */
	Utils.getEntityTypeByPath = function (oModel, sPath) {
		return oModel.oMetadata._getEntityTypeByPath(sPath);
	};

	/**
	 * Merging helper (pool analog of lodash.mergeWith) which allows custom function
	 * for resolving merging conflicts.
	 *
	 * TODO: replace with lodash.mergeWith when it's available
	 *
	 * @param {Object} mDestination Destination object
	 * @param {Object} mSource Source object
	 * @param {function} fnCustomizer The customizer is invoked with the following five arguments:
	 *                                  vDestinationValue: Value of the property in the destination object
	 *                                  vSourceValue: Value of the property in the source object
	 *                                  sProperty: Property being processed
	 *                                  mDestination: Destination object
	 *                                  mSourve: Source object
	 * @return {Object} - Returns <code>mDestination</code> object
	 */
	Utils.mergeWith = function (mDestination, mSource, fnCustomizer) {
		if (!(typeof fnCustomizer === "function")) {
			throw new Error('In order to use mergeWith() utility function fnCustomizer should be provided!');
		}

		for (var sSourceProperty in mSource) {
			if (mSource.hasOwnProperty(sSourceProperty)) {
				mDestination[sSourceProperty] = mDestination.hasOwnProperty(sSourceProperty)
					? fnCustomizer(
						mDestination[sSourceProperty],
						mSource[sSourceProperty],
						sSourceProperty,
						mDestination,
						mSource
					) : mSource[sSourceProperty];
			}
		}

		return mDestination;
	};

	/**
	 * Extending helper which allows custom function
	 * for extending.
	 *
	 * @param {Object} mDestination - Destionation object
	 * @param {Object} mSource - Source object
	 * @param {Function} fnCustomizer - The customizer is invoked with five arguments:
	 *                                  (vDestinationValue, vSourceValue, sProperty, mDestination, mSource).
	 */
	Utils.extendWith = function (mDestination, mSource, fnCustomizer) {
		if (!(typeof fnCustomizer === "function")) {
			throw new Error('In order to use extendWith() utility function fnCustomizer should be provided!');
		}

		for (var sSourceProperty in mSource) {
			if (mSource.hasOwnProperty(sSourceProperty)) {
				if (fnCustomizer(
						mDestination[sSourceProperty],
						mSource[sSourceProperty],
						sSourceProperty,
						mDestination,
						mSource)
				){
					mDestination[sSourceProperty] = mSource[sSourceProperty];
				}
			}
		}
	};

	/**
	 * Returns if the <code>oDomElement</code> is currently visible on the screen.
	 *
	 * @param {HTMLElement|jQuery} oDomElement Element to be evaluated
	 * @return {boolean} - Returns if <code>oDomElement</code> is currently visible on the screen.
	 */
	Utils.isElementInViewport = function(oDomElement) {
		if (oDomElement instanceof jQuery) {
			oDomElement = oDomElement.get(0);
		}

		var mRect = oDomElement.getBoundingClientRect();

		return (
			mRect.top >= 0 &&
			mRect.left >= 0 &&
			mRect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
			mRect.right <= (window.innerWidth || document.documentElement.clientWidth)
		);
	};

	return Utils;
}, /* bExport= */true);

}; // end of sap/ui/rta/Utils.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.AppVariantDialog') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.rta.appVariant.AppVariantDialog.
jQuery.sap.declare('sap.ui.rta.appVariant.AppVariantDialog'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.Dialog'); // unlisted dependency retained
jQuery.sap.require('sap.m.DialogRenderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.SimpleForm'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.ResponsiveGridLayout'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/AppVariantDialog",[
	'sap/m/Dialog',
	'sap/m/DialogRenderer',
	'sap/ui/rta/Utils',
	'sap/ui/layout/form/SimpleForm',
	'sap/ui/layout/form/ResponsiveGridLayout'
],
function(
	Dialog,
	DialogRenderer,
	RtaUtils,
	SimpleForm,
	ResponsiveGridLayout
){

	"use strict";

	var oResources = sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");
	var oDataSet,
		oTitleLabel,
		oTitleInput,
		oSubTitleLabel,
		oSubTitleInput,
		oDescriptionLabel,
		oDescriptionText,
		oIconLabel,
		oIconInput,
		oSimpleForm,
		oSelectDialog,
		oCustomTileModel,
		oSelectDialogModel;

	function _createTile() {
		oDataSet  = new sap.m.GenericTile("tile", {
			header: "{/title}",
			subheader: "{/subtitle}",
			tileContent: [
				new sap.m.TileContent({
					content: [
						new sap.m.ImageContent({
							src: "{/icon}"
						})
					]
				})
			]
		}).addStyleClass("sapUiMediumMarginBegin").addStyleClass("sapUiTinyMarginTop").addStyleClass("sapUiTinyMarginBottom");
	}

	function _handleSearch(oEvent) {
		var sValue = oEvent.getParameter("value");
		var oFilter = new sap.ui.model.Filter("name", sap.ui.model.FilterOperator.Contains, sValue);
		var oBinding = oEvent.getSource().getBinding("items");
		oBinding.filter([oFilter]);
	}

	function _handleClose(oEvent) {
		var aContexts = oEvent.getParameter("selectedContexts");

		if (aContexts && aContexts.length) {
			aContexts.some(function(oContext) {
				var newValue = oContext.getObject().name;
				oIconInput.setValue(newValue);
				oCustomTileModel.setProperty("/icon", oContext.getObject().icon);
			});
		}

		oEvent.getSource().getBinding("items").filter([]);
	}

	function _handleSelectDialog() {
		if (!oSelectDialog) {
			oSelectDialog = new sap.m.SelectDialog("selectDialog", {
				noDataText: oResources.getText("APP_VARIANT_ICON_NO_DATA"),
				title: oResources.getText("APP_VARIANT_ICON_SELECT_ICON"),
				search: function(oEvent) {
					_handleSearch(oEvent);
				},
				confirm: function(oEvent) {
					_handleClose(oEvent);
				},
				cancel: function(oEvent) {
					_handleClose(oEvent);
				}
			});
		}

		oSelectDialog.addStyleClass(RtaUtils.getRtaStyleClassName());

		oSelectDialog.bindAggregation("items",{
            path:"/icons",
            template: new sap.m.StandardListItem({
				title: "{name}",
				description: "",
				icon: "{icon}",
				iconDensityAware: false,
				iconInset: false,
				type: "Active"
            })
        });

		var aUI5Icons = sap.ui.core.IconPool.getIconNames();
		var aIcons = [];

		aUI5Icons.some(function(sName) {
			aIcons.push({
				icon: sap.ui.core.IconPool.getIconInfo(sName).uri,
				name : sName.toLowerCase()
			});
		});

		oSelectDialogModel.setProperty("/icons", aIcons);

		oSelectDialog.setModel(oSelectDialogModel);
		oSelectDialog.getBinding("items").filter([]);

		oSelectDialog.open();
	}

	function _createTileAttributes() {
		oTitleLabel = new sap.m.Label({
			required: true,
			text: oResources.getText("APP_DIALOG_TITLE_TEXT"),
			textAlign: "Left"
		});

		oTitleInput = new sap.m.Input("titleInput", {
			value: "{/title}",
			valueLiveUpdate: true,
			liveChange: function() {
				var oSaveButton = sap.ui.getCore().byId("saveButton");
				if (this.getValue() === "") {
					this.setValueState(sap.ui.core.ValueState.Error);  // if the field is empty after change, it will go red
					oSaveButton.setEnabled(false);
	            } else {
	                this.setValueState(sap.ui.core.ValueState.None); // if the field is not empty after change, the value state (if any) is removed
	                oSaveButton.setEnabled(true);
	            }
			}
		});

		oSubTitleLabel = new sap.m.Label({
			text: oResources.getText("APP_DIALOG_SUB_TITLE_TEXT"),
			textAlign: "Left"
		});

		oSubTitleInput = new sap.m.Input({
			value: "{/subtitle}",
			valueLiveUpdate: true
		});

		oDescriptionLabel = new sap.m.Label({
			text: oResources.getText("APP_DIALOG_DESCRIPTION_TEXT"),
			textAlign: "Left"
		});

		oDescriptionText = new sap.m.TextArea({
			rows: 4
		});

		oIconLabel = new sap.m.Label({
			text: oResources.getText("APP_DIALOG_ICON_TEXT"),
			textAlign: "Left"
		});

		oIconInput = new sap.m.Input("selectInput", {
			showValueHelp: true,
			liveChange: function(oEvent) {
				_handleSelectDialog(oEvent);
			},
			valueHelpRequest: function(oEvent) {
				_handleSelectDialog(oEvent);
			},
			value: "{/iconname}",
			valueLiveUpdate: true
		});
	}

	function _createSimpleForm() {
		oSimpleForm = new sap.ui.layout.form.SimpleForm({
			editable: true,
			layout: "ResponsiveGridLayout",
			labelSpanXL: 4,
			labelSpanL: 4,
			labelSpanM: 4,
			labelSpanS: 4,
			adjustLabelSpan: false,
			emptySpanXL: 0,
			emptySpanL: 0,
			emptySpanM: 0,
			emptySpanS: 0,
			columnsXL: 2,
			columnsL: 2,
			columnsM: 2,
			singleContainerFullSize: false,
			content: [
				new sap.ui.core.Title("title1", {
					text: ""
				}),
				oTitleLabel,
				oTitleInput,
				oSubTitleLabel,
				oSubTitleInput,
				oIconLabel,
				oIconInput,
				oDescriptionLabel,
				oDescriptionText,
				new sap.ui.core.Title("title2", {
					text: ""
				}),
				oDataSet
			]
		});

		return oSimpleForm;
	}

	function _createContentList() {
		var oVBox =  new sap.m.VBox({
			items: [
				_createSimpleForm()
			]
		}).addStyleClass("sapUISmallMargin");

		return oVBox;
	}

	var AppVariantDialog = Dialog.extend("sap.ui.rta.appVariant.AppVariantDialog", {
		metadata : {
			library : "sap.ui.rta",
			events : {

				/**
				 * This event will be fired when the user clicks the Create button on the dialog.
				 */
				create : {},

				/**
				 * This event will be fired when the user clicks the Cancel button on the dialog.
				 */
				cancel : {}
			}
		},
		init: function() {
			Dialog.prototype.init.apply(this);

			// initialize dialog and create member variables.
			this.setTitle(oResources.getText("CREATE_APP_VARIANT_DIALOG_TITLE"));
			this.setContentWidth("620px");
			this.setContentHeight("250px");

			oCustomTileModel = new sap.ui.model.json.JSONModel({
				title: oResources.getText("SAVE_AS_DIALOG_TITLE_TEXT"),
				subtitle: "",
				icon: "sap-icon://history",
				iconname: "history"
			});

			oSelectDialogModel = new sap.ui.model.json.JSONModel({
				icons: null
			});

			sap.ui.getCore().setModel(oCustomTileModel);

			_createTile();
			_createTileAttributes();

			this.addContent(_createContentList());

			// create, and cancel buttons.
			this._createButtons();

			this.addStyleClass(RtaUtils.getRtaStyleClassName());
		},
		onAfterRendering: function() {
			document.getElementById('title1').style.height = "0px";
			document.getElementById('title2').style.height = "0px";
			document.getElementById('tile').style.float = "left";
		},
		_onCreate: function() {
			var sTitle = oTitleInput.getValue();
			var sSubTitle = oSubTitleInput.getValue();
			var sDescription = oDescriptionText.getValue();
			var sIconValue = sap.ui.core.IconPool.getIconInfo(oIconInput.getValue()).uri;

			this.fireCreate({
				title: sTitle,
				subTitle: sSubTitle,
				description: sDescription,
				icon: sIconValue
			});

			this.close();
			this.destroy();
		},
		_createButtons: function() {
			this.addButton(new sap.m.Button("saveButton", {
				text: oResources.getText("APP_VARIANT_DIALOG_SAVE"),
				tooltip: oResources.getText("TOOLTIP_APP_VARIANT_DIALOG_SAVE"),
				press: function() {
					this._onCreate();
				}.bind(this)
			}));

			this.addButton(new sap.m.Button({
				text: oResources.getText("SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),
				tooltip: oResources.getText("TOOLTIP_SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),
				press: function() {
					this.fireCancel();
					this.close();
					this.destroy();
				}.bind(this)
			}));
		},
		destroy: function() {
			if (oCustomTileModel) {
				oCustomTileModel.destroy();
			}
			Dialog.prototype.destroy.apply(this, arguments);
		},
		renderer: DialogRenderer.render
	});

	return AppVariantDialog;

}, /* bExport= */ true);
}; // end of sap/ui/rta/appVariant/AppVariantDialog.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.AppVariantUtils') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.appVariant.AppVariantUtils'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.descriptorRelated.api.DescriptorVariantFactory'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.descriptorRelated.api.DescriptorInlineChangeFactory'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.LrepConnector'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageBox'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/AppVariantUtils",[
	"sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory",
	"sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory",
	"sap/ui/fl/LrepConnector",
	"sap/ui/fl/Utils",
	"sap/m/MessageBox",
	"sap/ui/rta/Utils"],
	function(
		DescriptorVariantFactory,
		DescriptorInlineChangeFactory,
		LrepConnector,
		FlexUtils,
		MessageBox,
		RtaUtils) {

		"use strict";
		var AppVariantUtils = {};

		// S/4 Hana expects us to pass an ID of 56 characters
		var HANA_CLOUD_ID_LENGTH = 56;

		AppVariantUtils.newAppVariantId = "";

		AppVariantUtils.getManifirstSupport = function(sRunningAppId) {
	        var sRoute = '/sap/bc/ui2/app_index/ui5_app_mani_first_supported/?id=' + sRunningAppId;
			var oLREPConnector = LrepConnector.createConnector();
			return oLREPConnector.send(sRoute, 'GET');
		};

		AppVariantUtils.isStandAloneApp = function() {
			if (sap.ushell_abap) {
				return false;
			} else {
				return true;
			}
		};

		AppVariantUtils.getNewAppVariantId = function() {
			return AppVariantUtils.newAppVariantId;
		};

		AppVariantUtils.setNewAppVariantId = function(sNewAppVariantID) {
			AppVariantUtils.newAppVariantId = sNewAppVariantID;
		};

		AppVariantUtils.trimIdIfRequired = function(sId) {
			return sId.substr(0, HANA_CLOUD_ID_LENGTH);
		};

		AppVariantUtils.getId = function(sBaseAppID) {
			var sChangedId;
			var aIdStrings = sBaseAppID.split('.');

			if (aIdStrings[0] !== "customer") {
				aIdStrings[0] = "customer." + aIdStrings[0];
			}

			var bRegFound = false;
			aIdStrings.forEach(function(sString, index, array) {
				var regex = /^id.*/i;
				if (sString.match(regex)) {
					sString = sString.replace(regex, jQuery.sap.uid().replace(/-/g, "_"));
					array[index] = sString;
					bRegFound = true;
				}
			});

			sChangedId = aIdStrings.join(".");
			if (!bRegFound) {
				sChangedId = sChangedId + "." + jQuery.sap.uid().replace(/-/g, "_");
			}

			sChangedId = this.trimIdIfRequired(sChangedId);
			this.setNewAppVariantId(sChangedId);

			return sChangedId;
		};

		AppVariantUtils.createDescriptorVariant = function(mParameters){
			mParameters.layer = FlexUtils.getCurrentLayer(false);
			return DescriptorVariantFactory.createNew(mParameters);
		};

		AppVariantUtils.getInlineChangeInput = function(sValue, sComment){
			return {
				"type": "XTIT",
				"maxLength": 50,
				"comment": sComment,
				"value": {
					"": sValue
				}
			};
		};

		AppVariantUtils.getInlinePropertyChange = function(sPropertyName, sPropertyValue){
			var sComment = "New " + sPropertyName + " entered by a key user via RTA tool";
			return this.getInlineChangeInput(sPropertyValue, sComment);
		};

		AppVariantUtils.getInlineChangeInputIcon = function(sIconValue) {
			return {
				icon: sIconValue
			};
		};

		AppVariantUtils.getInlineChangeRemoveInbounds = function(sInboundValue) {
			return {
				"inboundId": sInboundValue
			};
		};

		AppVariantUtils.getURLParsedHash = function() {
			var oURLParser = sap.ushell.Container.getService("URLParsing");
			if (oURLParser.parseShellHash && oURLParser.getHash){
				return oURLParser.parseShellHash(oURLParser.getHash(window.location.href));
			}
		};

		AppVariantUtils.getInboundInfo = function(oInbounds) {
			var oInboundInfo = {};
			var oParsedHash = this.getURLParsedHash();
			var aInbounds = Object.keys(oInbounds);
			var aInboundsFound = [];

			if (aInbounds.length) {
				aInbounds.forEach(function(sInboundId) {
					if ((oInbounds[sInboundId].action === oParsedHash.action) && (oInbounds[sInboundId].semanticObject === oParsedHash.semanticObject)) {
						aInboundsFound.push(sInboundId);
					}
				});
			}

			switch (aInboundsFound.length) {
				case 0:
					oInboundInfo.currentRunningInbound = "customer.savedAsAppVariant";
					oInboundInfo.addNewInboundRequired = true;
					break;
				case 1:
					oInboundInfo.currentRunningInbound = aInboundsFound[0];
					oInboundInfo.addNewInboundRequired = false;
					break;
				default:
					oInboundInfo = undefined;
					break;
			}

			return oInboundInfo;
		};

		AppVariantUtils.getInboundPropertiesKey = function(sAppVariantId, sCurrentRunningInboundId, sPropertyName) {
			return sAppVariantId + "_sap.app.crossNavigation.inbounds." + sCurrentRunningInboundId + "." + sPropertyName;
		};

		AppVariantUtils.getInlineChangesForInboundProperties = function(sCurrentRunningInboundId, sAppVariantId, sPropertyName, sPropertyValue) {
			var oChangeInput = {
				"inboundId": sCurrentRunningInboundId,
				"entityPropertyChange": {
					"propertyPath": sPropertyName,
					"operation": "UPSERT",
					"propertyValue": {}
				},
				"texts": {}
			};

			if (sPropertyName === "title" || sPropertyName === "subTitle") {
				var sKey = this.getInboundPropertiesKey(sAppVariantId, sCurrentRunningInboundId, sPropertyName);
				oChangeInput.entityPropertyChange.propertyValue = "{{" + sKey + "}}";
				oChangeInput.texts[sKey] = this.getInlinePropertyChange(sPropertyName, sPropertyValue);
			} else if (sPropertyName === "icon") {
				oChangeInput.entityPropertyChange.propertyValue = sPropertyValue;
			}

			return oChangeInput;
		};

		AppVariantUtils.getInlineChangeForInboundPropertySaveAs = function(sCurrentRunningInboundId) {
			return {
				"inboundId": sCurrentRunningInboundId,
				"entityPropertyChange": {
					"propertyPath": "signature/parameters/sap-appvar-id",
					"operation": "UPSERT",
					"propertyValue": {
						"required": true,
						"filter": {
							"value": this.getNewAppVariantId(),
							"format": "plain"
						},
						"launcherValue": {
							"value": this.getNewAppVariantId()
						}
					}
				}
			};
		};

		AppVariantUtils.getInlineChangeCreateInbound = function(sCurrentRunningInboundId) {
			var oParsedHash = this.getURLParsedHash();
			var oProperty = {
				"inbound": {}
			};

			oProperty.inbound[sCurrentRunningInboundId] = {
				"semanticObject": oParsedHash.semanticObject,
                "action": oParsedHash.action
			};

			return oProperty;
		};

		AppVariantUtils.createInlineChange = function(mParameters, sChange){
			var mTexts;
			if (sChange === "title"){
				return DescriptorInlineChangeFactory.create_app_setTitle(mParameters);
			} else if (sChange === "description" ){
				return DescriptorInlineChangeFactory.create_app_setDescription(mParameters);
			} else if (sChange === "subTitle" ){
				return DescriptorInlineChangeFactory.create_app_setSubTitle(mParameters);
			} else if (sChange === "icon" ){
				return DescriptorInlineChangeFactory.create_ui_setIcon(mParameters);
			} else if (sChange === "inbound" ){
				return DescriptorInlineChangeFactory.create_app_changeInbound(mParameters);
			} else if (sChange === "createInbound" ){
				return DescriptorInlineChangeFactory.create_app_addNewInbound(mParameters);
			} else if (sChange === "inboundTitle" ){
				mTexts = mParameters.texts;
				delete mParameters.texts;
				return DescriptorInlineChangeFactory.create_app_changeInbound(mParameters, mTexts);
			} else if (sChange === "inboundSubtitle" ){
				mTexts = mParameters.texts;
				delete mParameters.texts;
				return DescriptorInlineChangeFactory.create_app_changeInbound(mParameters, mTexts);
			} else if (sChange === "inboundIcon" ){
				delete mParameters.texts;
				return DescriptorInlineChangeFactory.create_app_changeInbound(mParameters);
			} else if (sChange === "removeInbound"){
				return DescriptorInlineChangeFactory.create_app_removeAllInboundsExceptOne(mParameters);
			}
		};

		AppVariantUtils.getTransportInput = function(sPackageName, sNameSpace, sName, sType) {
			return {
				getPackage : function(){
					return sPackageName;
				},
				getNamespace : function(){
					return sNameSpace;
				},
				getId : function(){
					return sName;
				},
				getDefinition : function(){
					return {
						fileType: sType
					};
				}
			};
		};

		AppVariantUtils.triggerCatalogAssignment = function(sAppVariantId, sOriginalId) {
			var sRoute = '/sap/bc/lrep/appdescr_variants/' + sAppVariantId + '?action=assignCatalogs&assignFromAppId=' + sOriginalId;
			var oLREPConnector = LrepConnector.createConnector();
			return oLREPConnector.send(sRoute, 'POST');
		};

		AppVariantUtils.showTechnicalError = function(oMessageType, sTitleKey, sMessageKey, vError) {
			var oTextResources = this.getTextResources();
			var sErrorMessage = "";
			if (vError.messages && vError.messages.length) {
				if (vError.messages.length > 1) {
					vError.messages.forEach(function(oError) {
						sErrorMessage += oError.text + "\n";
					});
				} else {
					sErrorMessage += vError.messages[0].text;
				}
			} else {
				sErrorMessage += vError.stack || vError.message || vError.status || vError;
			}

			var sTitle = oTextResources.getText(sTitleKey);
			var sMessage = oTextResources.getText(sMessageKey, sErrorMessage);

			return new Promise(function(resolve) {
				MessageBox.error(sMessage, {
					icon: oMessageType,
					title: sTitle,
					onClose: function() {
						resolve(false);
					},
					styleClass: RtaUtils.getRtaStyleClassName()
				});
			});
		};

		AppVariantUtils.isS4HanaCloud = function(oSettings) {
			return oSettings.isAtoEnabled() && oSettings.isAtoAvailable();
		};

		AppVariantUtils.copyId = function(sId) {
			var textArea = document.createElement("textarea");
			textArea.value = sId;
			document.body.appendChild(textArea);
			textArea.select();

			document.execCommand('copy');
			document.body.removeChild(textArea);
		};

		AppVariantUtils.getTextResources = function() {
			return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");
		};

		return AppVariantUtils;
}, /* bExport= */true);
}; // end of sap/ui/rta/appVariant/AppVariantUtils.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.Feature') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.appVariant.Feature'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageBox'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.BusyIndicator'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/Feature",[
  "jquery.sap.global",
  "sap/ui/rta/Utils",
  "sap/ui/fl/Utils",
  "sap/ui/rta/appVariant/AppVariantUtils",
  "sap/m/MessageBox",
  "sap/ui/core/BusyIndicator"
], function(jQuery,
	RtaUtils,
	FlexUtils,
	AppVariantUtils,
	MessageBox,
	BusyIndicator) {
  "use strict";

	var oAppVariantOverviewDialog,
		oAppVariantManager;

	sap.ui.getCore().getEventBus().subscribe("sap.ui.rta.appVariant.manageApps.controller.ManageApps", "navigate", function() {
		if (oAppVariantOverviewDialog) {
			oAppVariantOverviewDialog.destroy();
			oAppVariantOverviewDialog = null;
		}
	});

	return {
		onGetOverview: function(oRootControl) {
			return new Promise( function(resolve) {
				var fnCancel = function() {
					sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps", "navigate");
				};
				sap.ui.require(["sap/ui/rta/appVariant/ManageAppsDialog"], function(AppVariantOverviewDialog) {
					if (!oAppVariantOverviewDialog) {
						oAppVariantOverviewDialog = new AppVariantOverviewDialog("appVariantOverviewDialog", {
							rootControl: oRootControl
						});
					}
					oAppVariantOverviewDialog.attachCancel(fnCancel);
					resolve(oAppVariantOverviewDialog.open());
				});
			});
		},
		// App variant functionality is only supported in S/4 Hana Cloud Platform & S/4 Hana (On Premise)  with 'sap-ui-xx-rta-save-as=true' (feature switch) as a part of url.
		isPlatFormEnabled: function(sLayer, oRootControl) {
			var oDescriptor = FlexUtils.getAppDescriptor(oRootControl);

			if (oDescriptor["sap.app"] && oDescriptor["sap.app"].id) {
				return AppVariantUtils.getManifirstSupport(oDescriptor["sap.app"].id).then(function(oResult) {
					if (RtaUtils.getUshellContainer() && !AppVariantUtils.isStandAloneApp() && sLayer === "CUSTOMER" && oResult.response) {
						var oUriParams = jQuery.sap.getUriParameters();
						var aUriLayer = oUriParams.mParams["sap-ui-xx-rta-save-as"];

						if (aUriLayer && aUriLayer.length) {
							var oInboundInfo;
							if (oDescriptor["sap.app"].crossNavigation && oDescriptor["sap.app"].crossNavigation.inbounds) {
								oInboundInfo = AppVariantUtils.getInboundInfo(oDescriptor["sap.app"].crossNavigation.inbounds);
							}

							if (oInboundInfo) {
								return aUriLayer[0] === 'true' ? true : false;
							}
						}
					}
					return false;
				}).catch(function(oError) {
					return AppVariantUtils.showTechnicalError(MessageBox.Icon.ERROR, "HEADER_APP_VARIANT_FEATURE_FAILED", "MSG_APP_VARIANT_FEATURE_FAILED", oError);
				});
			}

			return Promise.resolve(false);
		},
		onSaveAs: function(oRootControlRunningApp, oAppVariantDescriptor) {
			var oDescriptor, oRunningAppDescriptor, oAppVariantDescriptorClosure;

			var oEvaluateSaveAsFlow = {
				closeRunningApp : false,
				copyDirtyChanges: false
			};

			if (oAppVariantDescriptor) {
				oDescriptor = oAppVariantDescriptor;
				oRunningAppDescriptor = FlexUtils.getAppDescriptor(oRootControlRunningApp);

				if (oRunningAppDescriptor["sap.app"].id === oDescriptor["sap.app"].id) {
					oEvaluateSaveAsFlow.copyDirtyChanges = true;
				}
			} else {
				oDescriptor = FlexUtils.getAppDescriptor(oRootControlRunningApp);
				oEvaluateSaveAsFlow.closeRunningApp = true;
				oEvaluateSaveAsFlow.copyDirtyChanges = true;
			}

			return new Promise( function(resolve, reject) {
				sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"], function(AppVariantManager) {
					if (!oAppVariantManager) {
						oAppVariantManager = new AppVariantManager();
					}
					// Key user gives the input e.g title, subtitle, description, icon to create a tile on FLP
					return oAppVariantManager.processSaveAsDialog(oDescriptor)
						.then(function(oAppVariantData) {
							// Based on the key user provided info, app variant descriptor is created
							return oAppVariantManager.createDescriptor(oAppVariantData);
						})
						.then(function(oAppVariantDescriptor) {
							if (oAppVariantDescriptor) {
								BusyIndicator.show();
								oAppVariantDescriptorClosure = oAppVariantDescriptor;
								// App variant descriptor is getting saved to the layered repository
								return oAppVariantManager.saveAppVariantToLREP(oAppVariantDescriptor);
							} else {
								return false;
							}
						})
						.then(function(bSuccess) {
							if (bSuccess) {
								// If there are any unsaved changes, should be taken away for the new created app variant
								return oAppVariantManager.copyUnsavedChangesToLREP(oAppVariantDescriptorClosure._id, oRootControlRunningApp, oEvaluateSaveAsFlow.copyDirtyChanges);
							} else {
								return false;
							}
						})
						.then(function(bSuccess) {
							if (bSuccess) {
								// In case of S4 Hana Cloud, trigger automatic catalog assignment
								return oAppVariantManager.triggerCatalogAssignment(oAppVariantDescriptorClosure);
							} else {
								return false;
							}
						})
						.then(function(oResult) {
							if (oResult) {
								BusyIndicator.hide();
								var oUshellContainer = RtaUtils.getUshellContainer();
								if (oUshellContainer) {
									// Tell FLP that no UI change is booked for the currently adapting app
									oUshellContainer.setDirtyFlag(false);
								}
								// Shows the success message and closes the current app (if 'Save As' triggered from RTA toolbar) or opens the app variant overview list (if 'Save As' triggered from App variant overview List)
								return oAppVariantManager.showSuccessMessageAndTriggerActionFlow(oAppVariantDescriptorClosure, oEvaluateSaveAsFlow.closeRunningApp, oRootControlRunningApp)
									.then(function() {
										if (oResult && oResult.response && oResult.response.IAMId) {
											// In case of S4 Hana Cloud, notify the key user to refresh the FLP Homepage manually
											return oAppVariantManager.notifyKeyUserWhenTileIsReady(oResult.response.IAMId, oAppVariantDescriptorClosure._id);
										} else {
											resolve();
										}
									});
							} else {
								return false;
							}
						})
						["catch"](function() {
							resolve(false);
						});
				});
			});
		}
	};

});
}; // end of sap/ui/rta/appVariant/Feature.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.S4HanaCloudBackend') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Module provides access to functionality related to an S4HANA Cloud backend
jQuery.sap.declare('sap.ui.rta.appVariant.S4HanaCloudBackend'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.odata.v2.ODataModel'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/S4HanaCloudBackend",[
	"sap/ui/base/ManagedObject",
	"sap/ui/model/odata/v2/ODataModel"
], function(ManagedObject, ODataModel) {
	"use strict";

	// Define managed object "S4HanaCloudBackend"
	var S4HanaCloudBackend = ManagedObject.extend("sap.ui.rta.appVariant.S4HanaCloudBackend", {

		constructor: function() {
			ManagedObject.apply(this, arguments);
		}

	});

	/**
	 * Notifies once FLP customzing for app is ready
	 *
	 * @param  {string}   sIamAppId             App id of identity access management
	 * @param  {function} fnIsReady             To be called once FLP customizing is ready: As a first parameter the IamAppId is given.
	 * @param  {integer}  [iCheckIntervallMsec] Check intervall
	 * @param  {integer}  [iMaxNumberOfChecks]  Maximum number of checks
	 * @return {Promise}  Either resolves with { iamAppId : sIamAppId, flpCustomizingIsReady : true | false }
	 *                    or rejects if the required ODATA service /sap/opu/odata/sap/APS_IAM_APP_SRV is not there
	 * @async
	 */
	S4HanaCloudBackend.prototype.notifyFlpCustomizingIsReady = function( sIamAppId, fnIsReady, iCheckIntervallMsec, iMaxNumberOfChecks ) {

		var that = this;
		return new Promise( function(resolve, reject) {

			// Check inputs and determine defaults
			function isNumeric(n) { return !isNaN(parseFloat(n)) && isFinite(n); }
			var iMsec = isNumeric(iCheckIntervallMsec) ? iCheckIntervallMsec : 2500;
			var iRemainingChecks = isNumeric(iMaxNumberOfChecks) ? iMaxNumberOfChecks : -1;

			// Notification check
			function checkForNotification() {

				// No further checks if max number of checks done
				if (iRemainingChecks == 0) {
					resolve( { iamAppId : sIamAppId, flpCustomizingIsReady : false } );
					return;
				} else if (iRemainingChecks > 0) {
					iRemainingChecks = iRemainingChecks - 1;
				}

				// Check if FLP customizing is ready:
				that.checkFlpCustomizingIsReady( sIamAppId ).then( function( bIsReady ) {
				// ... Resolve promise if true
					if (bIsReady) {
						resolve( { iamAppId : sIamAppId, flpCustomizingIsReady : true } );
						fnIsReady( sIamAppId );
				// ... Continue checking if false
					} else {
						setTimeout( checkForNotification.bind(that), iMsec );
					}
				// ... Reject if OData service to check FLP customizing failed
				}).catch( function() {
						reject( { iamAppId : sIamAppId } );
				});
			}

			// Schedule first notification check
			setTimeout( checkForNotification.bind(that), iMsec );

		});
	};

	S4HanaCloudBackend._evaluateAppIntegrityEstimation = function( oAppIntegrityEstimation ) {

		// Acccess error messages of APS_IAM_APP_SRV ODATA service
		var aMessages =
			( oAppIntegrityEstimation && oAppIntegrityEstimation.AppStatusTable
			&& JSON.parse( oAppIntegrityEstimation.AppStatusTable ) &&
			JSON.parse( oAppIntegrityEstimation.AppStatusTable ).ITAB );

		// Confirm an array has been retrieved
		if (!Array.isArray(aMessages)) {
			throw (
				"Error: /sap/opu/odata/sap/APS_IAM_APP_SRV/checkAppIntegrity() returned unexpected result"
				+ "for IAM app ID " + oAppIntegrityEstimation.AppID
			);
		}

		// Check if publishing is in progress (Warning CM_APS_IAM_APP/057)
		var bCatalogPublishingInProgress =
			aMessages.filter( function(oMessage) {
				return (oMessage.TYPE == 'W' && oMessage.ID == "CM_APS_IAM_APP" && oMessage.NUMBER == "057");
			}).length >= 1;

		// Check if publishing failed (Error CM_APS_IAM_APP/058)
		var bCatalogPublishingFailed =
			aMessages.filter( function(oMessage) {
				return (oMessage.TYPE == 'E' && oMessage.ID == "CM_APS_IAM_APP" && oMessage.NUMBER == "058");
			}).length >= 1;

		// Check if errors have been reported
		var bErrorsReported =
			aMessages.filter( function(oMessage) {
				return ( oMessage.TYPE == 'E' );
			}).length >= 1;

		// Raise exception if pulishing catalog failed
		if ((bErrorsReported && !bCatalogPublishingInProgress) || bCatalogPublishingFailed) {
			throw (
				"Error: Tile generation for app variant with IAM app ID "
				+ oAppIntegrityEstimation.AppID + " failed"
			);
		}

		// Customizing is "ready" if publishing is finished, there are no error messages and AppStatus is empty
		return ( !bCatalogPublishingInProgress && !bErrorsReported && !oAppIntegrityEstimation.AppStatus );

	};

	/**
	 * Tells if the FLPD customizing has been generated for the Fiori app with the given IAM app ID
	 *
	 * @async
	 * @param  {string} sIamAppId Identity Access Management ID of the Fiori app
	 * @return {Promise<bool>}    Promise delivering a bool value
	 * @async
	 *
	 * Remarks:
	 * <ul>
	 * 		<li>
	 * 		In order to check if the FLP customizing for a IAM app ID is available,
	 * 		the function import checkAppIntegrity of the OData Service APS_IAM_APP_SRV is used.
	 *
	 * 		As Sebastian Scheuermann said, this is an inoffcial SAP internal API and it's not
	 *   	documented. Everything is okay if the AppStatus is initial. Then also the AppStatusTable
	 *   	property has an empty ITAB property with an empty table.
	 *    	</li>
	 * </ul>
	 */
	S4HanaCloudBackend.prototype.checkFlpCustomizingIsReady = function( sIamAppId ) {

		return new Promise( function( resolve, reject ) {


			// Access IAM app OData service and confirm that metadat have been loaded
			// ... Remark:
			//     I do not keep the model as a reusable service as then the attached functions
			//     may accumulate with multiple notifyFlpCustomizingIsReady calls.
			var oModel = new ODataModel("/sap/opu/odata/sap/APS_IAM_APP_SRV");
			oModel.attachMetadataFailed( function( error ) {
				reject( error );
			});

			// Check integrity of IAM app
			oModel.metadataLoaded().then( function() {
				oModel.callFunction( "/checkAppIntegrity",
					{ method:"POST", urlParameters:{ AppID:sIamAppId },
					  error: reject,
					  success: resolve
					}
				);
			});
/*
			// Unfortunately, the following code is not supported:
			// Reject is not called, if the metadata cold not be retrieved.
			// From my perspective this is an error.

			try {
				new ODataModel("/sap/opu/odata/sap/APS_IAM_APP_SRV").callFunction( "/checkAppIntegrity",
					{ method:"POST", urlParameters:{ AppID:sIamAppId },
					  error: reject,
					  success: resolve }
				);
			} catch ( error ) {
				reject( error );
			}
*/
		}).then( S4HanaCloudBackend._evaluateAppIntegrityEstimation );

	};

	return S4HanaCloudBackend;
});


}; // end of sap/ui/rta/appVariant/S4HanaCloudBackend.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.Utils') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.appVariant.Utils'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.LrepConnector'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/Utils",[
	"jquery.sap.global",
	"sap/ui/fl/LrepConnector",
	"sap/ui/rta/appVariant/AppVariantUtils"],
	function(jQuery, LrepConnector, AppVariantUtils) {
		"use strict";

		var Utils = {};

		var sModulePath = jQuery.sap.getModulePath( "sap.ui.rta.appVariant.manageApps.webapp" );
		var oI18n = jQuery.sap.resources({
			url : sModulePath + "/i18n/i18n.properties"
		});

		Utils.sendRequest = function(sRoute, sOperation) {
			var oLREPConnector = LrepConnector.createConnector();
			return oLREPConnector.send(sRoute, sOperation);
		};

		Utils.getAppVariantOverviewAttributes = function(oAppVariantInfo) {
			var oAppVariantAttributes;
			var fnCheckAppType = function() {
				if (oAppVariantInfo.isOriginal && oAppVariantInfo.isAppVariant) {
					return oI18n.getText("MAA_ORIGINAL_TYPE");
				} else if (oAppVariantInfo.isAppVariant) {
					return oI18n.getText("MAA_APP_VARIANT_TYPE");
				} else if (oAppVariantInfo.isOriginal) {
					return oI18n.getText("MAA_ORIGINAL_TYPE");
				}
			};

			var fncheckNavigationSupported = function(oNavigationParams) {
				var oNavigationService = sap.ushell.Container.getService( "CrossApplicationNavigation" );
				return oNavigationService.getLinks(oNavigationParams);
			};

			var fnGetNavigationInfo = function(oAppVariantAttributes) {
				if (oAppVariantInfo.hasStartableIntent) {
					var sSemanticObject = oAppVariantInfo.startWith.semanticObject;
					var sAction = oAppVariantInfo.startWith.action;
					var oParams = oAppVariantInfo.startWith.parameters;

					var oNavigationParams = {
						semanticObject : sSemanticObject,
						action : sAction,
						params: oParams
					};

					return fncheckNavigationSupported(oNavigationParams).then(function(aResult) {
						if (aResult.length) {
							oAppVariantAttributes.adaptUIButtonVisibility = true;
						} else {
							oAppVariantAttributes.adaptUIButtonVisibility = false;
						}
						oAppVariantAttributes.semanticObject = sSemanticObject;
						oAppVariantAttributes.action = sAction;

						if (oParams) {
							Object.keys(oParams).forEach(function(sParamValue) {
								if (oParams[sParamValue].value) {
									oParams[sParamValue] = oParams[sParamValue].value;
								}
							});

							oAppVariantAttributes.params = oParams;
						}
						return Promise.resolve(oAppVariantAttributes);
					});
				} else {
					oAppVariantAttributes.adaptUIButtonVisibility = false;
					return Promise.resolve(oAppVariantAttributes);
				}
			};

			oAppVariantAttributes = {
				appId : oAppVariantInfo.appId,
				title : oAppVariantInfo.title,
				subTitle : oAppVariantInfo.subTitle,
				description : oAppVariantInfo.description,
				icon : oAppVariantInfo.iconUrl,
				originalId : oAppVariantInfo.originalId,
				isOriginal : oAppVariantInfo.isOriginal,
				typeOfApp : fnCheckAppType(),
				descriptorUrl : oAppVariantInfo.descriptorUrl
			};

			var sNewAppVariantId = AppVariantUtils.getNewAppVariantId();

			if (sNewAppVariantId === oAppVariantInfo.appId) {
				oAppVariantAttributes.rowStatus = "Information";
			}

			return fnGetNavigationInfo(oAppVariantAttributes);
		};

		Utils.getAppVariantOverview = function(sReferenceAppId) {
			var sRoute = '/sap/bc/lrep/app_variant_overview/?sap.app/id=' + sReferenceAppId;

			return this.sendRequest(sRoute, 'GET').then(function(oResult) {
				var aAppVariantOverviewInfo = [];
				var aAppVariantInfo = oResult.response.items;
				if (aAppVariantInfo.length) {
					var that = this;
					aAppVariantInfo.forEach(function(oAppVariantInfo) {
						if (!oAppVariantInfo.isDescriptorVariant) {
							aAppVariantOverviewInfo.push(that.getAppVariantOverviewAttributes(oAppVariantInfo));
						}
					});

					return Promise.all(aAppVariantOverviewInfo).then(function(aResponses) {
						return aResponses;
					});
				}
			}.bind(this));
		};

		Utils.getDescriptor = function(sDescriptorUrl) {
			return this.sendRequest(sDescriptorUrl, 'GET').then(function(oResult) {
				return oResult.response;
			});
		};

	return Utils;
}, /* bExport= */true);
}; // end of sap/ui/rta/appVariant/Utils.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.manageApps.webapp.Component') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.appVariant.manageApps.webapp.Component'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/manageApps/webapp/Component",[
	"sap/ui/core/UIComponent"
], function(UIComponent) {
	"use strict";

	var _sIdRunningApp, _oRootControlRunningApp;

	return UIComponent.extend("sap.ui.rta.appVariant.manageApps.webapp.Component", {

		metadata: {
			"manifest": "json",
			"library": "sap.ui.rta",
			"version": "0.9",
			"properties": {
				idRunningApp : {
					type: "string"
				},
				rootControlRunningApp : {
					type: "object"
				}
			}
		},

		constructor: function() {
			_sIdRunningApp = arguments[1].idRunningApp;
			_oRootControlRunningApp = arguments[1].rootControlRunningApp;
			UIComponent.prototype.constructor.apply(this, arguments);
		},

		/**
		 * Component is automatically initialized by SAPUI5 at startup of the app and calls the init method once.
		 * @public
		 * @override
		 */
		init: function() {
			this.setIdRunningApp(_sIdRunningApp);
			this.setRootControlRunningApp(_oRootControlRunningApp);
			// call the base component's init function
			UIComponent.prototype.init.apply(this, arguments);
		}
	});
});
}; // end of sap/ui/rta/appVariant/manageApps/webapp/Component.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.manageApps.webapp.model.models') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.appVariant.manageApps.webapp.model.models'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/manageApps/webapp/model/models",[
	"sap/ui/model/json/JSONModel"
], function(JSONModel) {
	"use strict";

	return {

		createModel: function(oData) {
			var oModel = new JSONModel(oData);
			oModel.setDefaultBindingMode("OneWay");
			return oModel;
		}

	};
});
}; // end of sap/ui/rta/appVariant/manageApps/webapp/model/models.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.BaseCommand') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.BaseCommand'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/BaseCommand",['sap/ui/base/ManagedObject'], function(ManagedObject) {
	"use strict";

	/**
	 * Basic implementation for the command pattern.
	 *
	 * @class
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.command.BaseCommand
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var BaseCommand = ManagedObject.extend("sap.ui.rta.command.BaseCommand", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				name : {
					type : "string"
				},
				runtimeOnly : {
					type : "boolean"
				}
			},
			associations : {
				element : {
					type : "sap.ui.core.Element"
				}
			},
			events : {}
		}
	});


	/**
	 * @override Returns element instance instead of ID.
	 */
	BaseCommand.prototype.getElement = function() {
		var sId = this.getAssociation("element");
		return sap.ui.getCore().byId(sId);
	};

	/**
	 * @public Template Method called by the command factory when all data is provided to the change.
	 * @return {boolean} Returns true if the preparation was successful
	 */
	BaseCommand.prototype.prepare = function() {
		return true;
	};

	/**
	 * @public Template method to implement execute logic. You have to ensure that the
	 * element property is available.
	 * @return {Promise} Returns a resolving Promise
	 */
	BaseCommand.prototype.execute = function() {
		return Promise.resolve();
	};

	BaseCommand.prototype.getVariantChange = function() {
		return this._oVariantChange;
	};

	/**
	 * @public Template method to implement undo logic.
	 * @return {Promise} Returns a resolving Promise
	 */
	BaseCommand.prototype.undo = function() {
		return Promise.resolve();
	};

	/**
	 * Template method to check if the command is enabled.
	 *
	 * @return {boolean} Returns enabled boolean state
	 * @public
	 */
	BaseCommand.prototype.isEnabled = function() {
		return true;
	};

	return BaseCommand;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/BaseCommand.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.CommandFactory') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.CommandFactory'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.registry.ChangeRegistry'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/CommandFactory",['sap/ui/base/ManagedObject', 'sap/ui/dt/ElementUtil', 'sap/ui/dt/OverlayRegistry', 'sap/ui/fl/registry/ChangeRegistry'],
	function(ManagedObject, ElementUtil, OverlayRegistry, ChangeRegistry) {
	"use strict";

	var fnConfigureActionCommand = function(oElement, oCommand, vAction){
		var sChangeType;
		if (typeof (vAction) === "string"){
			sChangeType = vAction;
		} else {
			sChangeType = vAction && vAction.changeType;
		}

		if (!sChangeType){
			return false;
		}

		oCommand.setChangeType(sChangeType);
		return true;
	};

	var fnConfigureCreateContainerCommand = function(oElement, mSettings, oDesignTimeMetadata){
		var oNewAddedElement = mSettings.element || sap.ui.getCore().byId(mSettings.element.id);
		var oAction = oDesignTimeMetadata.getAggregationAction("createContainer", oNewAddedElement)[0];
		return oAction;
	};

	var fnConfigureMoveCommand = function(oElement, mSettings, oDesignTimeMetadata){
		var oMovedElement = mSettings.movedElements[0].element || sap.ui.getCore().byId(mSettings.movedElements[0].id);
		var oAction = oDesignTimeMetadata.getAction("move", oMovedElement);
		// needed for Stashed Controls
		if (!oAction && oDesignTimeMetadata.getMetadata().getName() === "sap.ui.dt.ElementDesignTimeMetadata") {
			var sSourceAggregation = mSettings.source.aggregation;
			var oAggregationDesignTimeMetadata = oDesignTimeMetadata.createAggregationDesignTimeMetadata(sSourceAggregation);
			oAction = oAggregationDesignTimeMetadata.getAction("move", oMovedElement);
			oAggregationDesignTimeMetadata.destroy();
		}
		return oAction;
	};

	var fnConfigureRenameCommand = function(oElement, mSettings, oDesignTimeMetadata){
		var oRenamedElement = mSettings.renamedElement;
		var oAction = oDesignTimeMetadata.getAction("rename", oRenamedElement);
		return oAction;
	};

	var fnConfigureRemoveCommand = function(oElement, mSettings, oDesignTimeMetadata){
		var oRemovedElement = mSettings.removedElement;
		if (!oRemovedElement) {
			oRemovedElement = oElement;
		} else if (!(oRemovedElement instanceof ManagedObject)) {
			throw new Error("No valid 'removedElement' found");
		}
		var oAction = oDesignTimeMetadata.getAction("remove", oRemovedElement);
		return oAction;
	};

	var fnConfigureCombineCommand = function(oElement, mSettings, oDesignTimeMetadata){
		var oCombineElement = mSettings.source;
		var oAction = oDesignTimeMetadata.getAction("combine", oCombineElement);
		return oAction;
	};

	var fnConfigureSplitCommand = function(oElement, mSettings, oDesignTimeMetadata){
		var oSplitElement = mSettings.source;
		var oAction = oDesignTimeMetadata.getAction("split", oSplitElement);
		return oAction;
	};

	var fnConfigureAddODataPropertyCommand = function(oElement, mSettings, oDesignTimeMetadata){
		var oNewAddedElement = mSettings.element;
		var oAction = oDesignTimeMetadata.getAction("addODataProperty", oNewAddedElement);
		return oAction;
	};

	var fnConfigureRevealCommand = function(oElement, mSettings, oDesignTimeMetadata){
		var oRevealParent = mSettings.directParent;
		var oAction = oDesignTimeMetadata.getAction("reveal", oRevealParent);
		return oAction;
	};

	var mCommands = { 	// Command names camel case with first char lower case
		"composite" : {
			clazz : 'sap.ui.rta.command.CompositeCommand'
		},
		"property" : {
			clazz : 'sap.ui.rta.command.Property'
		},
		"bindProperty" : {
			clazz : 'sap.ui.rta.command.BindProperty'
		},

		/* NEW COMMANDS, ALIGNED WITH A SCALABILITY CONCEPT */
		"createContainer" : {
			clazz : 'sap.ui.rta.command.CreateContainer',
			configure : fnConfigureCreateContainerCommand
		},
		"move" : {
			clazz : 'sap.ui.rta.command.Move',
			configure : fnConfigureMoveCommand
		},
		"remove" : {
			clazz : 'sap.ui.rta.command.Remove',
			configure : fnConfigureRemoveCommand
		},
		"rename" : {
			clazz : 'sap.ui.rta.command.Rename',
			configure : fnConfigureRenameCommand
		},
		"addODataProperty" : {
			clazz : 'sap.ui.rta.command.AddODataProperty',
			configure : fnConfigureAddODataPropertyCommand
		},
		"reveal" : {
			clazz : 'sap.ui.rta.command.Reveal',
			configure : fnConfigureRevealCommand
		},
		"combine" : {
			clazz : 'sap.ui.rta.command.Combine',
			configure : fnConfigureCombineCommand
		},
		"split" : {
			clazz : 'sap.ui.rta.command.Split',
			configure : fnConfigureSplitCommand
		},
		"switch" : {
			clazz : 'sap.ui.rta.command.ControlVariantSwitch'
		},
		"duplicate" : {
			clazz : 'sap.ui.rta.command.ControlVariantDuplicate'
		},
		"setTitle" : {
			clazz : 'sap.ui.rta.command.ControlVariantSetTitle'
		},
		"settings" : {
			clazz : 'sap.ui.rta.command.Settings'
		},
		"addLibrary" : {
			clazz : 'sap.ui.rta.command.appDescriptor.AddLibrary'
		},
		"appDescriptor" : {
			clazz : 'sap.ui.rta.command.AppDescriptorCommand'
		}
	};

	var _getCommandFor = function(vElement, sCommand, mSettings, oDesignTimeMetadata, mFlexSettings, sVariantManagementReference) {
		sCommand = sCommand[0].toLowerCase() + sCommand.slice(1); // first char of command name is lower case
		var mCommand = mCommands[sCommand];

		if (!mCommand){
			throw new Error("Command '" + sCommand + "' doesn't exist, check typing");
		}

		var sClassName = mCommand.clazz;

		jQuery.sap.require(sClassName);
		var Command = jQuery.sap.getObject(sClassName);

		var bIsUiElement = vElement instanceof sap.ui.base.ManagedObject;
		mSettings = jQuery.extend(mSettings, {
			element : bIsUiElement ? vElement : undefined,
			selector : bIsUiElement ? undefined : vElement,
			name : sCommand
		});

		var oAction;
		if (mCommand.configure) {
			oAction = mCommand.configure(vElement, mSettings, oDesignTimeMetadata);
		}

		var oElementOverlay;
		if (oAction && oAction.changeOnRelevantContainer) {
			oElementOverlay = OverlayRegistry.getOverlay(vElement);
			mSettings = jQuery.extend(mSettings, {
				element : oElementOverlay.getRelevantContainer()
			});
			vElement = mSettings.element;
		}

		if (oAction && oAction.getState) {
			mSettings = jQuery.extend(mSettings, {
				fnGetState : oAction.getState
			});
		}

		if (oAction && oAction.restoreState) {
			mSettings = jQuery.extend(mSettings, {
				fnRestoreState : oAction.restoreState
			});
		}

		var oCommand = new Command(mSettings);

		var bSuccessfullConfigured = true; //configuration is optional
		if (mCommand.configure) {
			bSuccessfullConfigured = fnConfigureActionCommand(vElement, oCommand, oAction);
		}

		var bPrepareStatus = bSuccessfullConfigured && oCommand.prepare(mFlexSettings, sVariantManagementReference);
		if (bPrepareStatus) {
			return oCommand;
		} else {
			oCommand.destroy();
			return undefined;
		}
	};

	/**
	 * Factory for commands. Shall handle the control specific command configuration.
	 *
	 * @class
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.command.CommandFactory
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var CommandFactory = ManagedObject.extend("sap.ui.rta.command.CommandFactory", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				"flexSettings": {
					type: "object"
				}
			},
			associations : {},
			events : {}
		}
	});

	CommandFactory.prototype.init = function() {
		this.setProperty("flexSettings", {
			layer:"CUSTOMER",
			developerMode: true
		});
	};

	/**
	 * Setter for flexSettings
	 *
	 * @param {Object} [mFlexSettings] property bag
	 * @param {String} [mFlexSettings.layer] The Layer in which RTA should be started. Default: "CUSTOMER"
	 * @param {Boolean} [mFlexSettings.developerMode] Whether RTA is started in DeveloperMode Mode. Whether RTA is started in DeveloperMode Mode
	 * @param {String} [mFlexSettings.namespace] Namespace for changes inside LREP
	 */
	CommandFactory.prototype.setFlexSettings = function(mFlexSettings) {
		this.setProperty("flexSettings", jQuery.extend(this.getFlexSettings(), mFlexSettings));
	};

	CommandFactory.prototype.getCommandFor = function(vElement, sCommand, mSettings, oDesignTimeMetadata, sVariantManagementReference) {
		return _getCommandFor(vElement, sCommand, mSettings, oDesignTimeMetadata, this.getFlexSettings(), sVariantManagementReference);
	};

	CommandFactory.getCommandFor = function(vElement, sCommand, mSettings, oDesignTimeMetadata, mFlexSettings) {
		return _getCommandFor(vElement, sCommand, mSettings, oDesignTimeMetadata, mFlexSettings);
	};

	return CommandFactory;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/CommandFactory.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.CompositeCommand') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.CompositeCommand'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/CompositeCommand",[ 'sap/ui/rta/command/BaseCommand',
				'sap/ui/fl/Utils'
], function(BaseCommand,
			flUtils) {
	"use strict";

	/**
	 * Composite command that can work on multiple simp
	 *
	 * @class
	 * @extends sap.ui.rta.command.BaseCommand
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.command.CompositeCommand
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var CompositeCommand = BaseCommand.extend("sap.ui.rta.command.CompositeCommand", {
		metadata : {
			library : "sap.ui.rta",
			properties : {},
			aggregations : {
				commands : {
					type : "sap.ui.rta.command.BaseCommand",
					multiple : true
				}
			},
			events : {}
		}
	});

	/**
	 * Execute this composite command
	 *
	 * @returns {Promise} empty promise
	 */
	CompositeCommand.prototype.execute = function() {
		var aPromises = [];
		this._forEachCommand(function(oCommand){
			aPromises.push(oCommand.execute.bind(oCommand));
		});
		return flUtils.execPromiseQueueSequentially(aPromises);
	};

	CompositeCommand.prototype.undo = function() {
		var aPromises = [];
		this._forEachCommandInReverseOrder(function(oCommand){
			aPromises.push(oCommand.undo.bind(oCommand));
		});
		return flUtils.execPromiseQueueSequentially(aPromises);
	};

	CompositeCommand.prototype._forEachCommand = function(fnDo) {
		var aCommands = this.getCommands();
		aCommands.forEach(fnDo, this);
	};

	CompositeCommand.prototype._forEachCommandInReverseOrder = function(fnDo) {
		var aCommands = this.getCommands();
		for (var i = aCommands.length - 1; i >= 0; i--) {
			fnDo.call(this, aCommands[i]);
		}
	};
	return CompositeCommand;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/CompositeCommand.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.ControlVariantDuplicate') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.ControlVariantDuplicate'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.changeHandler.BaseTreeModifier'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/ControlVariantDuplicate",[
	'sap/ui/rta/command/BaseCommand',
	'sap/ui/fl/changeHandler/BaseTreeModifier',
	'sap/ui/fl/Utils'
], function(BaseCommand, BaseTreeModifier, flUtils) {
	"use strict";

	/**
	 * Switch control variants
	 *
	 * @class
	 * @extends sap.ui.rta.command.BaseCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.52
	 * @alias sap.ui.rta.command.ControlVariantDuplicate
	 */
	var ControlVariantDuplicate = BaseCommand.extend("sap.ui.rta.command.ControlVariantDuplicate", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				sourceVariantReference : {
					type : "string"
				},
				newVariantReference : {
					type : "string"
				}
			},
			associations : {},
			events : {}
		}
	});

	ControlVariantDuplicate.prototype.MODEL_NAME = "$FlexVariants";

	/**
	 * @override
	 */
	ControlVariantDuplicate.prototype.prepare = function(mFlexSettings, sVariantManagementReference) {
		this.sLayer = mFlexSettings.layer;
		return true;
	};

	/**
	 * @public Triggers the duplication of a variant
	 * @returns {Promise} Returns resolve after execution
	 */
	ControlVariantDuplicate.prototype.execute = function() {
		var oVariantManagementControl = this.getElement(),
		sSourceVariantReference = this.getSourceVariantReference(),
		sNewVariantReference = this.getNewVariantReference();
		this.oAppComponent = flUtils.getAppComponentForControl(oVariantManagementControl);

		if (!sNewVariantReference) {
			sNewVariantReference = flUtils.createDefaultFileName(sSourceVariantReference + "_Copy");
			this.setNewVariantReference(sNewVariantReference);
		}

		this.sVariantManagementReference = BaseTreeModifier.getSelector(oVariantManagementControl, this.oAppComponent).id;
		this.oModel = this.oAppComponent.getModel(this.MODEL_NAME);

		var mPropertyBag = {
				variantManagementControl : oVariantManagementControl,
				appComponent : this.oAppComponent,
				layer : this.sLayer,
				newVariantReference : sNewVariantReference,
				sourceVariantReference : sSourceVariantReference
		};

		return this.oModel._copyVariant(mPropertyBag)
			.then(function(oVariant){
				this._oVariantChange = oVariant;
			}.bind(this));
	};

	/**
	 * @public Undo logic for the execution
	 * @returns {Promise} Returns resolve after undo
	 */
	ControlVariantDuplicate.prototype.undo = function() {
		if (this._oVariantChange) {
			return this.oModel._removeVariant(this._oVariantChange, this.getSourceVariantReference(), this.sVariantManagementReference)
				.then(function() {
					this._oVariantChange = null;
				}.bind(this));
		}
	};

	return ControlVariantDuplicate;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/ControlVariantDuplicate.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.ControlVariantSetTitle') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.ControlVariantSetTitle'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.changeHandler.BaseTreeModifier'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/ControlVariantSetTitle",[
	'sap/ui/rta/command/BaseCommand',
	'sap/ui/fl/changeHandler/BaseTreeModifier',
	'sap/ui/fl/Utils'
], function(BaseCommand, BaseTreeModifier, flUtils) {
	"use strict";

	/**
	 * Rename control variants
	 *
	 * @class
	 * @extends sap.ui.rta.command.BaseCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.50
	 * @alias sap.ui.rta.command.ControlVariantSetTitle
	 */
	var ControlVariantSetTitle = BaseCommand.extend("sap.ui.rta.command.ControlVariantSetTitle", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				renamedElement : {
					type : "object"
				},
				oldText : {
					type : "string"
				},
				newText : {
					type : "string"
				}
			},
			associations : {},
			events : {}
		}
	});

	ControlVariantSetTitle.prototype.MODEL_NAME = "$FlexVariants";

	/**
	 * @override
	 */
	ControlVariantSetTitle.prototype.prepare = function(mFlexSettings, sVariantManagementReference) {
		this.sLayer = mFlexSettings.layer;
		return true;
	};

	/**
	 * @public Template Method to implement execute logic, with ensure precondition Element is available
	 * @returns {Promise} Returns resolve after execution
	 */
	ControlVariantSetTitle.prototype.execute = function() {
		var oVariantManagementControl = this.getRenamedElement(),
			oVariantManagementControlBinding = oVariantManagementControl.getTitle().getBinding("text");

		this.oAppComponent = flUtils.getAppComponentForControl(oVariantManagementControl);
		this.oModel = this.oAppComponent.getModel(this.MODEL_NAME);
		this.sVariantManagementReference = BaseTreeModifier.getSelector(oVariantManagementControl, this.oAppComponent).id;
		this.sCurrentVariant = this.oModel.getCurrentVariantReference(this.sVariantManagementReference);

		var sCurrentTitle = this.oModel.getVariantProperty(this.sCurrentVariant, "title");
		this.setOldText(sCurrentTitle);

		var mPropertyBag = {
			appComponent : this.oAppComponent,
			variantReference : this.sCurrentVariant,
			title : this.getNewText(),
			layer : this.sLayer
		};

		return Promise.resolve(this.oModel._setVariantProperties(this.sVariantManagementReference, mPropertyBag, true))
						.then(function(oChange) {
								this._oVariantChange = oChange;
								oVariantManagementControlBinding.checkUpdate(true); /*Force Update as binding key stays same*/
						}.bind(this));
	};

	/**
	 * @public Template Method to implement undo logic
	 * @returns {Promise} Returns resolve after undo
	 */
	ControlVariantSetTitle.prototype.undo = function() {
		var oVariantManagementControlBinding = this.getRenamedElement().getTitle().getBinding("text"),
			mPropertyBag = {
			variantReference : this.sCurrentVariant,
			title : this.getOldText(),
			change: this._oVariantChange
		};

		return Promise.resolve(this.oModel._setVariantProperties(this.sVariantManagementReference, mPropertyBag, false))
						.then( function(oChange){
								this._oVariantChange = oChange;
								oVariantManagementControlBinding.checkUpdate(true); /*Force Update as binding key stays same*/
						}.bind(this));
	};

	return ControlVariantSetTitle;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/ControlVariantSetTitle.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.ControlVariantSwitch') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.ControlVariantSwitch'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.changeHandler.BaseTreeModifier'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/ControlVariantSwitch",[
	'sap/ui/rta/command/BaseCommand',
	'sap/ui/fl/changeHandler/BaseTreeModifier',
	'sap/ui/fl/Utils'
], function(BaseCommand, BaseTreeModifier, flUtils) {
	"use strict";

	/**
	 * Switch control variants
	 *
	 * @class
	 * @extends sap.ui.rta.command.BaseCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.50
	 * @alias sap.ui.rta.command.ControlVariantSwitch
	 */
	var ControlVariantSwitch = BaseCommand.extend("sap.ui.rta.command.ControlVariantSwitch", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				targetVariantReference : {
					type : "string"
				},
				sourceVariantReference : {
					type : "string"
				}
			},
			associations : {},
			events : {}
		}
	});

	ControlVariantSwitch.prototype.MODEL_NAME = "$FlexVariants";

	ControlVariantSwitch.prototype._getAppComponent = function(oElement) {
		if (!this._oControlAppComponent) {
			this._oControlAppComponent = oElement ? flUtils.getAppComponentForControl(oElement) : this.getSelector().appComponent;
		}
		return this._oControlAppComponent;
	};

	/**
	 * @public Template Method to implement execute logic, with ensure precondition Element is available
	 * @returns {Promise} Returns resolve after execution
	 */
	ControlVariantSwitch.prototype.execute = function() {
		var oElement = this.getElement(),
			oAppComponent = this._getAppComponent(oElement),
			sNewVariantReference = this.getTargetVariantReference();

		this.oModel = oAppComponent.getModel(this.MODEL_NAME);
		this.sVariantManagementReference = BaseTreeModifier.getSelector(oElement, oAppComponent).id;
		return this._updateModelVariant(sNewVariantReference);
	};

	/**
	 * @public Template Method to implement undo logic
	 * @returns {Promise} Returns resolve after undo
	 */
	ControlVariantSwitch.prototype.undo = function() {
		var sOldVariantReference = this.getSourceVariantReference();
		return this._updateModelVariant(sOldVariantReference);
	};

	/**
	 * @private Update variant for the underlying model
	 * @returns {Promise} Returns promise resolve
	 */
	ControlVariantSwitch.prototype._updateModelVariant = function (sVariantReference) {
		if (this.getTargetVariantReference() !== this.getSourceVariantReference()) {
			return Promise.resolve(this.oModel.updateCurrentVariant(this.sVariantManagementReference, sVariantReference));
		}
		return Promise.resolve();
	};

	return ControlVariantSwitch;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/ControlVariantSwitch.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.FlexCommand') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.FlexCommand'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.FlexControllerFactory'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/FlexCommand",['sap/ui/rta/command/BaseCommand', "sap/ui/fl/FlexControllerFactory",
		"sap/ui/rta/ControlTreeModifier", "sap/ui/fl/Utils"], function(BaseCommand, FlexControllerFactory,
		RtaControlTreeModifier, Utils) {
	"use strict";

	/**
	 * Basic implementation for the flexibility commands, that use a flex change handler.
	 *
	 * @class
	 * @extends sap.ui.rta.command.BaseCommand
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.command.FlexCommand
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var FlexCommand = BaseCommand.extend("sap.ui.rta.command.FlexCommand", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				changeType : {
					type : "string"
				},
				/**
				 * getState and restoreState are used for retrieving custom undo/redo implementations from design time metadata
				 */
				fnGetState : {
					type : "any"
				},
				state : {
					type : "any"
				},
				fnRestoreState : {
					type : "any"
				},
				/**
				 * selector object containing id, appComponent and controlType to create a command for an element, which is not instantiated
				 */
				selector : {
					type : "object"
				}
			},
			associations : {},
			events : {}
		}
	});

	/**
	 * Retrives id of element or selector
	 *
	 * @returns {string} id value
	 * @public
	 */
	FlexCommand.prototype.getElementId = function() {
		var oElement = this.getElement();
		return oElement ? oElement.getId() : this.getSelector().id;
	};

	/**
	 * Retrives app component of element or selector
	 *
	 * @returns {sap.ui.core.UIComponent} component
	 * @private
	 */
	FlexCommand.prototype.getAppComponent = function() {
		if (!this._oControlAppComponent) {
			var oElement = this.getElement();
			this._oControlAppComponent = oElement ? Utils.getAppComponentForControl(oElement) : this.getSelector().appComponent;
		}
		return this._oControlAppComponent;
	};

	/**
	 * Prepares and stores change to be applied later
	 * (in some cases element of a command is unstable, so change needs to be created and stored upfront)
	 * @override
	 */
	FlexCommand.prototype.prepare = function(mFlexSettings, sVariantManagementReference) {
		if (
			!this.getSelector()
			&& this.getElement()
		) {
			var oSelector = {
				id: this.getElement().getId(),
				appComponent: this.getAppComponent(),
				controlType: Utils.getControlType(this.getElement())
			};
			this.setSelector(oSelector);
		}
		try {
			this._oPreparedChange = this._createChange(mFlexSettings, sVariantManagementReference);
		} catch (oError) {
			jQuery.sap.log.error(oError.message || oError.name);
			return false;
		}
		return true;
	};

	/**
	 * Returns a prepared change
	 * @returns {object} prepared change object
	 * @public
	 */
	FlexCommand.prototype.getPreparedChange = function() {
		if (!this._oPreparedChange) {
			this.prepare();
		}
		return this._oPreparedChange;
	};

	/**
	 * @override
	 * @returns {Promise} empty promise after finishing execution
	 */
	FlexCommand.prototype.execute = function() {
		var vChange = this.getPreparedChange();
		return this._applyChange(vChange);
	};

	/**
	 * This method converts command constructor parameters into change specific data.
	 * Default implementation of this method below is for commands, which do not have specific constructor parameters
	 * @return {object} Returns the <code>SpecificChangeInfo</code> for change handler
	 * @protected
	 */
	FlexCommand.prototype._getChangeSpecificData = function() {
		return {
			changeType : this.getChangeType(),
			selector : {
				id : this.getElementId()
			}
		};
	};

	/**
	 * Creates a change.
	 * @param {object} mFlexSettings Map containing the flexibility settings
	 * @param {string} sVariantManagementReference Reference to the variant management
	 * @returns {object} Returns the change object
	 * @private
	 */
	FlexCommand.prototype._createChange = function(mFlexSettings, sVariantManagementReference) {
		return this._createChangeFromData(this._getChangeSpecificData(), mFlexSettings, sVariantManagementReference);
	};

	/**
	 * Create a Flex change from a given Change Specific Data.
	 * (This method can be reused to retrieve an Undo Change)
	 *
	 * @param {object} mChangeSpecificData Map containing change specific data
	 * @param {object} mFlexSettings Map containing flex settings
	 * @param {string} sVariantManagementReference Reference to the variant management
	 * @returns {object} Returns the change object
	 * @private
	 */
	FlexCommand.prototype._createChangeFromData = function(mChangeSpecificData, mFlexSettings, sVariantManagementReference) {
		if (mFlexSettings) {
			jQuery.extend(mChangeSpecificData, mFlexSettings);
		}
		var oModel = this.getAppComponent().getModel("$FlexVariants");
		var sVariantReference;
		if (oModel && sVariantManagementReference) {
			sVariantReference = oModel.getCurrentVariantReference(sVariantManagementReference);
		}
		var oFlexController = FlexControllerFactory.createForControl(this.getAppComponent());
		var mVariantObj = {
			"variantManagementReference": sVariantManagementReference,
			"variantReference": sVariantReference
		};
		if (sVariantReference) {
			jQuery.extend(mChangeSpecificData, mVariantObj);
		}
		return oFlexController.createChange(mChangeSpecificData, this.getElement() || this.getSelector());
	};

	/**
	 * @override
	 */
	FlexCommand.prototype.undo = function() {
		//If the command has a "restoreState" implementation, use that to perform the undo
		if (this.getFnRestoreState()){
			this.getFnRestoreState()((this.getElement() || this.getSelector()), this.getState());
		} else if (this._aRecordedUndo) {
			RtaControlTreeModifier.performUndo(this._aRecordedUndo);
		} else {
			jQuery.sap.log.warning("Undo is not available for " + this.getElement() || this.getSelector());
		}
		return Promise.resolve();
	};

	/**
	 * @private
	 * @param {sap.ui.fl.Change|Object} vChange Change object or map containing the change object
	 * @param {boolean} [bNotMarkAsAppliedChange] Apply the change without marking them as applied changes in the custom Data
	 * @returns {Promise} Returns an empty promise
	 */
	FlexCommand.prototype._applyChange = function(vChange, bNotMarkAsAppliedChange) {
		//TODO: remove the following compatibility code when concept is implemented
		var oChange = vChange.change || vChange;

		var oAppComponent = this.getAppComponent();
		var oChangeDefinition = oChange.getDefinition();
		var oSelectorElement = RtaControlTreeModifier.bySelector(oChange.getSelector(), oAppComponent);

		// If the command has a "getState" implementation, use that instead of recording the undo
		if (this.getFnGetState()){
			this.setState.call(this, (this.getFnGetState()((this.getElement() || this.getSelector()), oChangeDefinition, {
			modifier: RtaControlTreeModifier,
			appComponent : oAppComponent
			})));
		} else {
			RtaControlTreeModifier.startRecordingUndo();
		}

		var oFlexController = FlexControllerFactory.createForControl(this.getAppComponent());

		return Promise.resolve(oFlexController.checkTargetAndApplyChange(oChange, oSelectorElement, {modifier: RtaControlTreeModifier, appComponent: oAppComponent}))

		.then(function() {
			if (bNotMarkAsAppliedChange) {
				oFlexController.removeFromAppliedChangesOnControl(oChange, oAppComponent, oSelectorElement);
			}
		})

		.then(function() {
			if (!this.getFnGetState()){
				this._aRecordedUndo = RtaControlTreeModifier.stopRecordingUndo();
			}
		}.bind(this));
	};

	return FlexCommand;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/FlexCommand.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.Move') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.Move'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/Move",['jquery.sap.global', 'sap/ui/rta/command/FlexCommand'], function(jQuery, FlexCommand) {
	"use strict";

	/**
	 * Move Element from one place to another
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.command.Move
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var Move = FlexCommand.extend("sap.ui.rta.command.Move", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				movedElements : {
					type : "any[]"
				},
				target : {
					type : "any"
				},
				source : {
					type : "any"
				}
			},
			associations : {},
			events : {}
		}
	});

	/**
	 * @param  {boolean} bIsUndo If is true, then it switches source and target
	 * @override
	 */
	Move.prototype._getChangeSpecificData = function(bIsUndo) {
		var mSource = bIsUndo ? this.getTarget() : this.getSource();
		var mTarget = bIsUndo ? this.getSource() : this.getTarget();

		// replace elements by their id, unify format and help with serialization
		if (mSource.parent) {
			mSource.id = mSource.parent.getId();
			delete mSource.parent;
		}
		if (mTarget.parent) {
			mTarget.id = mTarget.parent.getId();
			delete mTarget.parent;
		}
		var mSpecificInfo = {
			changeType : this.getChangeType(),
			source : mSource,
			target : mTarget,
			movedElements : []
		};

		this.getMovedElements().forEach(function(mMovedElement) {
			mSpecificInfo.movedElements.push({
				id : mMovedElement.id || (mMovedElement.element && mMovedElement.element.getId()),
				sourceIndex : bIsUndo ? mMovedElement.targetIndex : mMovedElement.sourceIndex,
				targetIndex : bIsUndo ? mMovedElement.sourceIndex : mMovedElement.targetIndex
			});
		});
		return mSpecificInfo;
	};

	Move.prototype.prepare = function(sLayer, bDeveloperMode) {
		var bSuccessful = FlexCommand.prototype.prepare.apply(this, arguments);

		if (bSuccessful) {
			this._oPreparedUndoChange = this._createChangeFromData(this._getChangeSpecificData(true), sLayer, bDeveloperMode);
		}
		return bSuccessful;
	};

	Move.prototype.undo = function() {
		return this._applyChange(this._oPreparedUndoChange, true);
	};

	return Move;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/Move.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.Property') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.Property'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/command/Property",[
	'sap/ui/rta/command/FlexCommand',
	"sap/ui/rta/Utils"
], function(
	FlexCommand,
	Utils
) {
	"use strict";

	/**
	 * Basic implementation for the command pattern.
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.command.BaseCommand
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var Property = FlexCommand.extend("sap.ui.rta.command.Property", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				propertyName : {
					type : "string"
				},
				newValue : {
					type : "any"
				},
				semanticMeaning : {
					type : "string"
				},
				changeType : {
					type : "string",
					defaultValue : "propertyChange"
				}
			},
			associations : {},
			events : {}
		}
	});

	Property.prototype._getChangeSpecificData = function() {
		var oElement = this.getElement();
		// general format
		return {
			changeType : this.getChangeType(),
			selector : {
				id : oElement.getId(),
				type : oElement.getMetadata().getName()
			},
			content : {
				property : this.getPropertyName(),
				newValue : this.getNewValue(),
				semantic : this.getSemanticMeaning()
			}
		};
	};

	return Property;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/Property.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.Remove') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.Remove'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/command/Remove",['sap/ui/rta/command/FlexCommand'], function(FlexCommand) {
	"use strict";

	/**
	 * Remove a control/element
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.42
	 * @alias sap.ui.rta.command.Remove
	 * @experimental Since 1.42. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var Remove = FlexCommand.extend("sap.ui.rta.command.Remove", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				removedElement : {
					type : "any"
				}
			},
			associations : {},
			events : {}
		}
	});

	Remove.prototype._getChangeSpecificData = function() {
		var oElement = this.getRemovedElement() || this.getElement();

		var mSpecificInfo = {
			changeType : this.getChangeType(),
			removedElement : {
				id : oElement.getId()
			}
		};
		return mSpecificInfo;
	};

	return Remove;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/Remove.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.Rename') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.Rename'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/Rename",['jquery.sap.global', 'sap/ui/rta/command/FlexCommand'], function(jQuery, FlexCommand) {
	"use strict";

	/**
	 * Rename Element from one place to another
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.command.Rename
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var Rename = FlexCommand.extend("sap.ui.rta.command.Rename", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				renamedElement : {
					type : "object"
				},
				newValue : {
					type : "string",
					defaultValue : "new text"
				}
			},
			associations : {},
			events : {}
		}
	});

	Rename.prototype._getChangeSpecificData = function() {

		var mSpecificInfo = {
				changeType : this.getChangeType(),
				selector : {
					id : this.getElement().getId()
				},
				renamedElement : {
					id : this.getRenamedElement().getId()
				},
				value : this.getNewValue()
		};

		return mSpecificInfo;
	};

	return Rename;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/Rename.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.Reveal') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.Reveal'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/command/Reveal",['sap/ui/rta/command/FlexCommand'], function(FlexCommand) {
	"use strict";

	/**
	 * Reveal controls by setting visible to true or unstash them
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.44
	 * @alias sap.ui.rta.command.Reveal
	 * @experimental Since 1.44. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var Reveal = FlexCommand.extend("sap.ui.rta.command.Reveal", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				revealedElementId : {
					type : "string"
				},
				directParent : "object"
			}
		}
	});

	Reveal.prototype._getChangeSpecificData = function() {
		var mSpecificChangeInfo = {
			changeType : this.getChangeType()
		};
		if (this.getRevealedElementId()) {
			mSpecificChangeInfo.revealedElementId = this.getRevealedElementId();
		}
		return mSpecificChangeInfo;
	};

	return Reveal;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/Reveal.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.Settings') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.Settings'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/command/Settings",['sap/ui/rta/command/FlexCommand'], function(FlexCommand) {
	"use strict";

	/**
	 * Basic implementation for the command pattern.
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.44
	 * @alias sap.ui.rta.command.BaseCommand
	 * @experimental Since 1.44. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var Settings = FlexCommand.extend("sap.ui.rta.command.Settings", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				content : {
					type : "any"
				}
			},
			associations : {},
			events : {}
		}
	});


	Settings.prototype._getChangeSpecificData = function(bForward) {

		var mSpecificInfo = {
				changeType : this.getChangeType(),
				content : this.getContent()
		};

		return mSpecificInfo;
	};


	/**
	 * @override
	 */
	Settings.prototype.execute = function() {
		if (this.getElement()) {
			return FlexCommand.prototype.execute.apply(this, arguments);
		} else {
			return Promise.resolve();
		}
	};

	/**
	 * @override
	 */
	Settings.prototype.undo = function() {
		if (this.getElement()) {
			return FlexCommand.prototype.undo.apply(this, arguments);
		} else {
			return Promise.resolve();
		}
	};

	return Settings;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/Settings.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.Split') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.Split'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/command/Split",[
	'sap/ui/rta/command/FlexCommand'
], function(FlexCommand) {
	"use strict";

	/**
	 * Split a control/element
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.46
	 * @alias sap.ui.rta.command.Split
	 * @experimental Since 1.46. This class is experimental and provides only limited functionality. Also the API might be
	 *							 changed in future.
	 */
	var Split = FlexCommand.extend("sap.ui.rta.command.Split", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				newElementIds : {
					type : "string[]"
				},
				source : {
					type : "any"
				},
				parentElement : {
					type : "any"
				}
			},
			associations : {},
			events : {}
		}
	});

	/**
	 * @override
	 */
	Split.prototype._getChangeSpecificData = function() {
		var mSpecificInfo = {
				newElementIds : this.getNewElementIds(),
				sourceControlId : this.getSource().getId(),
				changeType : this.getChangeType(),
				parentId : this.getParentElement().getId()
		};
		return mSpecificInfo;
	};

	return Split;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/Split.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.Stack') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.Stack'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/Stack",[
	'sap/ui/base/ManagedObject'
], function(
	ManagedObject
) {
	"use strict";

	/**
	 * Basic implementation for the command stack pattern.
	 *
	 * @class
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.command.Stack
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var Stack = ManagedObject.extend("sap.ui.rta.command.Stack", {
		metadata : {
			library : "sap.ui.rta",
			properties : {},
			aggregations : {
				commands : {
					type : "sap.ui.rta.command.BaseCommand",
					multiple : true
				}
			},
			events : {
				modified : {},
				commandExecuted : {
					parameters: {
						command : {type: "object"},
						undo: {type: "boolean"}
					}
				}

			}
		}
	});

	Stack.prototype._toBeExecuted = -1;
	Stack.prototype._oLastCommand = Promise.resolve();

	Stack.prototype._getCommandToBeExecuted = function() {
		return this.getCommands()[this._toBeExecuted];
	};

	/**
	 * Allows to push a command on the stack that has already been executed and shouldn't be executed next
	 *
	 * @param {sap.ui.rta.command.FlexCommand} oCommand command to push to the stack
	 * @public
	 */
	Stack.prototype.pushExecutedCommand = function(oCommand) {
		this.push(oCommand, true);
	};

	Stack.prototype.push = function(oCommand, bExecuted) {
		// undone commands have to be removed as a new command is added
		if (this._bUndoneCommands) {
			this._bUndoneCommands = false; // distinguish undone commands from not yet executed commands
			while (this._toBeExecuted > -1) {
				this.pop();
			}
		}
		this.insertCommand(oCommand, 0);
		if (!bExecuted) {
			this._toBeExecuted++;
		}
		this.fireModified();
	};

	Stack.prototype.top = function() {
		return this.getCommands()[0];
	};

	Stack.prototype.pop = function() {
		if (this._toBeExecuted > -1) {
			this._toBeExecuted--;
		}
		return this.removeCommand(0);
	};

	Stack.prototype.removeCommand = function(vObject, bSuppressInvalidate) {
		var oRemovedCommand = this.removeAggregation("commands", vObject, bSuppressInvalidate);
		this.fireModified();
		return oRemovedCommand;
	};

	Stack.prototype.removeAllCommands = function(bSuppressInvalidate) {
		var aCommands = this.removeAllAggregation("commands", bSuppressInvalidate);
		this._toBeExecuted = -1;
		this.fireModified();
		return aCommands;
	};

	Stack.prototype.isEmpty = function() {
		return this.getCommands().length === 0;
	};

	Stack.prototype.execute = function() {
		this._oLastCommand = this._oLastCommand.catch(function(){
			//continue also if previous command failed
		}).then(function(){
			var oCommand = this._getCommandToBeExecuted();
			if (oCommand) {
				return oCommand.execute()

				.then(function(){
					this._toBeExecuted--;
					this.fireCommandExecuted({
						command: oCommand,
						undo: false
					});
					this.fireModified();
				}.bind(this))

				.catch(function(oError) {
					this.pop(); // remove failing command
					return Promise.reject(oError);
				}.bind(this));
			}
		}.bind(this));
		return this._oLastCommand;

	};

	Stack.prototype._unExecute = function() {
		if (this.canUndo()) {
			this._bUndoneCommands = true;
			this._toBeExecuted++;
			var oCommand = this._getCommandToBeExecuted();
			if (oCommand) {
				return oCommand.undo()

				.then(function() {
					this.fireCommandExecuted({
						command: oCommand,
						undo: true
					});
					this.fireModified();
				}.bind(this));
			} else {
				return Promise.resolve();
			}
		} else {
			return Promise.resolve();
		}
	};

	Stack.prototype.canUndo = function() {
		return (this._toBeExecuted + 1) < this.getCommands().length;
	};

	Stack.prototype.undo = function() {
		return this._unExecute();
	};

	Stack.prototype.canRedo = function() {
		return !!this._getCommandToBeExecuted();
	};

	Stack.prototype.redo = function() {
		return this.execute();
	};

	Stack.prototype.pushAndExecute = function(oCommand) {
		this.push(oCommand);
		return this.execute();
	};

	/**
	 * Decomposite all executed commands from the stack
	 *
	 * @returns {object} list of all executed commands
	 * @public
	 */
	Stack.prototype.getAllExecutedCommands = function() {
		var aAllExecutedCommands = [];
		var aCommands = this.getCommands();
		for (var i = aCommands.length - 1; i > this._toBeExecuted; i--) {
			var aSubCommands = this.getSubCommands(aCommands[i]);
			aAllExecutedCommands = aAllExecutedCommands.concat(aSubCommands);
		}
		return aAllExecutedCommands;
	};

	/**
	 * Decomposite command to subcommands (composite commands will be splitted into array of regular commands)
	 *
	 * @param {sap.ui.rta.command.FlexCommand} oCommand command to push to the stack
	 * @returns {object} aCommands - list of sub commands
	 * @private
	 */
	Stack.prototype.getSubCommands = function(oCommand) {
		var aCommands = [];
		if (oCommand.getCommands) {
			oCommand.getCommands().forEach(function(oSubCommand) {
				var aSubCommands = this.getSubCommands(oSubCommand);
				aCommands = aCommands.concat(aSubCommands);
			}, this);
		} else {
			aCommands.push(oCommand);
		}

		return aCommands;
	};

	return Stack;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/Stack.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.rta.
 */
jQuery.sap.declare('sap.ui.rta.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/library",['jquery.sap.global', 'sap/ui/core/Core', 'sap/ui/core/library'],
	function(jQuery, Core, coreLibrary) {
	"use strict";

	/**
	 * SAPUI5 library with RTA controls.
	 *
	 * @namespace
	 * @name sap.ui.rta
	 * @author SAP SE
	 * @version 1.52.30
	 * @private
	 * @experimental This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */


	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.rta",
		version: "1.52.30",
		dependencies : ["sap.ui.core","sap.m", "sap.ui.fl", "sap.ui.dt"],
		types: [
		],
		interfaces: [],
		controls: [],
		elements: [
		]
	});

	return sap.ui.rta;

}, /* bExport= */ true);
}; // end of sap/ui/rta/library.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.Plugin') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.Plugin.
jQuery.sap.declare('sap.ui.rta.plugin.Plugin'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.dt.Plugin'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.registry.ChangeRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementOverlay'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/Plugin",[
	'sap/ui/dt/Plugin',
	'sap/ui/fl/Utils',
	'sap/ui/fl/registry/ChangeRegistry',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/ElementOverlay'
],
function(
	Plugin,
	FlexUtils,
	ChangeRegistry,
	OverlayRegistry,
	OverlayUtil,
	ElementOverlay
) {
	"use strict";

	/**
	 * Constructor for a new Plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The Plugin allows to handle the overlays and aggregation overlays from the DesignTime
	 * The Plugin should be overriden by the real plugin implementations, which define some actions through events attached to an overlays
	 * @extends sap.ui.dt.Plugin
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.46
	 * @alias sap.ui.rta.plugin.Plugin
	 * @experimental Since 1.46. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	/* Methods to save stable ID info on Overlay */
	ElementOverlay.prototype._bElementHasStableId = undefined;
	ElementOverlay.prototype.getElementHasStableId = function() { return this._bElementHasStableId;};
	ElementOverlay.prototype.setElementHasStableId = function(bHasStableId) { this._bElementHasStableId = bHasStableId; };
	ElementOverlay.prototype.hasElementStableId = function() { return this._bElementHasStableId ? true : false; };

	var BasePlugin = Plugin.extend("sap.ui.rta.plugin.Plugin", /** @lends sap.ui.dt.Plugin.prototype */ {
		metadata : {
			"abstract" : true,
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.rta",
			properties : {
				commandFactory : {
					type : "object",
					multiple : false
				}
			},
			events : {
				elementModified : {
					command : {
						type : "sap.ui.rta.command.BaseCommand"
					}
				}
			}
		}
	});

	/**
	 * This function needs to be overwritten in every plugin.
	 */
	BasePlugin.prototype._isEditable = function() {};

	var _onElementModified = function(oEvent) {
		var oParams = oEvent.getParameters();
		var aRelevantOverlays;
		var oOverlay = sap.ui.getCore().byId(oParams.id);
		if ((oParams.type === "propertyChanged" && oParams.name === "visible")) {
			aRelevantOverlays = this._getRelevantOverlays(oOverlay);
			this.evaluateEditable(aRelevantOverlays, {onRegistration: false});
		} else if (oParams.type === "overlayRendered") {
			this.evaluateEditable([oOverlay], {onRegistration: true});
		} else if (oParams.type === "insertAggregation" || oParams.type === "removeAggregation") {
			aRelevantOverlays = this._getRelevantOverlays(oOverlay, oParams.name);
			this.evaluateEditable(aRelevantOverlays, {onRegistration: false});
		}
	};

	BasePlugin.prototype._detachReevaluationEditable = function(oOverlay) {
		oOverlay.detachElementModified(_onElementModified, this);
	};

	BasePlugin.prototype._attachReevaluationEditable = function(oOverlay) {
		oOverlay.attachElementModified(_onElementModified, this);
	};

	BasePlugin.prototype._getRelevantOverlays = function(oOverlay, sAggregationName) {
		var aAlreadyDefinedRelevantOverlays = oOverlay.getRelevantOverlays();
		if (aAlreadyDefinedRelevantOverlays.length === 0) {
			var aRelevantOverlays = OverlayUtil.findAllOverlaysInContainer(oOverlay);

			// if an aggregation name is given, those overlays are added without checking the relevant container
			if (sAggregationName) {
				var aAggregationChildren = oOverlay.getAggregationOverlay(sAggregationName).getChildren();
				aAggregationChildren = aAggregationChildren.filter(function(oChildOverlay) {
					return aRelevantOverlays.indexOf(oChildOverlay) === -1;
				});
				aRelevantOverlays = aRelevantOverlays.concat(aAggregationChildren);
			}

			oOverlay.setRelevantOverlays(aRelevantOverlays);
			return aRelevantOverlays;
		}
		return aAlreadyDefinedRelevantOverlays;
	};

	/**
	 * Checks if the overlay has an associated element and calls the _isEditable function.
	 * If there is an associated element it also modifies the plugin list.
	 * @param {sap.ui.dt.ElementOverlay[]} aOverlays Array of overlays to be checked
	 * @param {object} mPropertyBag Map of additional information to be passed to isEditable
	 */
	BasePlugin.prototype.evaluateEditable = function(aOverlays, mPropertyBag) {
		var fnCheckBinding = function(oOverlay, sAggregationName){
			if (sAggregationName && oOverlay.getElementInstance().getBinding(sAggregationName)) {
				return false;
			}
			return oOverlay.isRoot() || fnCheckBinding(
				oOverlay.getParentElementOverlay(),
				oOverlay.getElementInstance().sParentAggregationName
			);
		};

		var vEditable;
		aOverlays.forEach(function(oOverlay) {
			//check aggregation Binding recursively
			if (oOverlay.getElementInstance() && !fnCheckBinding(oOverlay, oOverlay.getElementInstance().sParentAggregationName)) {
				vEditable = false;
			} else {
				// when a control gets destroyed it gets deregistered before it gets removed from the parent aggregation.
				// this means that getElementInstance is undefined when we get here via removeAggregation mutation
				// when an overlay is not registered yet, we should not evaluate editable. In this case getDesignTimeMetadata returns null.
				vEditable = oOverlay.getElementInstance() && oOverlay.getDesignTimeMetadata() && this._isEditable(oOverlay, mPropertyBag);
			}
			// for the createContainer and additionalElements plugin the isEditable function returns an object with 2 properties, asChild and asSibling.
			// for every other plugin isEditable should be a boolean.
			if (vEditable !== undefined && vEditable !== null) {
				if (typeof vEditable === "boolean") {
					this._modifyPluginList(oOverlay, vEditable);
				} else {
					this._modifyPluginList(oOverlay, vEditable["asChild"], false);
					this._modifyPluginList(oOverlay, vEditable["asSibling"], true);
				}
			}
		}.bind(this));
	};

	BasePlugin.prototype._modifyPluginList = function(oOverlay, bIsEditable, bOverlayIsSibling) {
		if (bIsEditable) {
			this.addToPluginsList(oOverlay, bOverlayIsSibling);
		} else {
			this.removeFromPluginsList(oOverlay, bOverlayIsSibling);
		}
	};

	BasePlugin.prototype._retrievePluginName = function(bSibling) {
		var sName = this.getMetadata().getName();
		if (bSibling !== undefined) {
			sName += bSibling ? ".asSibling" : ".asChild";
		}
		return sName;
	};

	BasePlugin.prototype._isEditableByPlugin = function(oOverlay, bSibling) {
		var sPluginName = this._retrievePluginName(bSibling);
		var aPluginList = oOverlay.getEditableByPlugins();
		return aPluginList.indexOf(sPluginName) > -1;
	};

	BasePlugin.prototype.registerElementOverlay = function(oOverlay) {
		this.evaluateEditable([oOverlay], {onRegistration: true});
		this._attachReevaluationEditable(oOverlay);
	};

	BasePlugin.prototype.deregisterElementOverlay = function(oOverlay) {
		this.removeFromPluginsList(oOverlay);
		this.removeFromPluginsList(oOverlay, true);
		this.removeFromPluginsList(oOverlay, false);
		this._detachReevaluationEditable(oOverlay);
	};

	/**
	 * Checks if the element of an overlay has a stable ID.
	 * Keeps this information on the Overlay, as stable IDs cannot be modified in runtime.
	 * @param  {sap.ui.dt.ElementOverlay}  oOverlay Overlay for the element to be checked
	 * @return {boolean} Returns true if the element has a stable ID
	 */
	BasePlugin.prototype.hasStableId = function(oOverlay) {
		if (!oOverlay) {
			return false;
		}

		// without DesignTimeMetadata the Overlay was not registered yet.
		if (!oOverlay.getDesignTimeMetadata()) {
			return false;
		}

		if (oOverlay.getElementHasStableId() === undefined){
			var bStable = false;
			var oElement = oOverlay.getElementInstance();
			var oDesignTimeMetadata = oOverlay.getDesignTimeMetadata();
			var fnGetStableElements = oDesignTimeMetadata && oDesignTimeMetadata.getData().getStableElements;
			if (fnGetStableElements){
				var aStableElements = fnGetStableElements(oElement);
				var bUnstable = aStableElements ? aStableElements.some(function(vStableElement) {
					var oControl = vStableElement.id || vStableElement;
					if (!FlexUtils.checkControlId(oControl, vStableElement.appComponent)) {
						return true;
					}
				}) : true;
				bStable = !bUnstable;
			} else {
				bStable = FlexUtils.checkControlId(oElement);
			}

			oOverlay.setElementHasStableId(bStable);
		}
		return oOverlay.hasElementStableId();
	};

	BasePlugin.prototype.getVariantManagementReference = function (oOverlay, oAction, bForceRelevantContainer, oStashedElement) {
		var oElement;
		if (!oStashedElement) {
			oElement = oOverlay.getElementInstance();
		} else {
			oElement = oStashedElement;
		}

		var oRelevantElement;
		if ((oAction.changeOnRelevantContainer || bForceRelevantContainer) && !oStashedElement) {
			oRelevantElement = oOverlay.getRelevantContainer();
		} else {
			oRelevantElement = oElement;
		}

		var sVariantManagementReference;
		if (oOverlay.getVariantManagement && this._hasVariantChangeHandler(oAction.changeType, oRelevantElement)) {
			sVariantManagementReference = oOverlay.getVariantManagement();
		}
		return sVariantManagementReference;
	};

	BasePlugin.prototype._hasVariantChangeHandler = function (sChangeType, oElement){
		var oChangeHandler = this._getChangeHandler(sChangeType, oElement);
		return (oChangeHandler && oChangeHandler.revertChange);
	};

	/**
	 * Checks the Aggregations on the Overlay for a specific Action
	 * @name sap.ui.rta.plugin.Plugin.prototype.checkAggregationsOnSelf
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay to be checked for action
	 * @param {string} sAction action to be checked
	 * @return {boolean} whether the Aggregation has a valid Action
	 * @protected
	 */
	BasePlugin.prototype.checkAggregationsOnSelf = function (oOverlay, sAction) {
		var oDesignTimeMetadata = oOverlay.getDesignTimeMetadata();
		var oElement = oOverlay.getElementInstance();
		var bIsEditable = false;

		var oAction = oDesignTimeMetadata.getAggregationAction(sAction, oOverlay.getElementInstance())[0];
		var sChangeType = oAction ? oAction.changeType : null;
		var bChangeOnRelevantContainer = oAction && oAction.changeOnRelevantContainer;
		if (bChangeOnRelevantContainer) {
			oElement = oOverlay.getRelevantContainer();
		}

		if (sChangeType && this.hasChangeHandler(sChangeType, oElement)) {
			bIsEditable = true;
		}

		return bIsEditable;
	};

	BasePlugin.prototype.removeFromPluginsList = function(oOverlay, bSibling) {
		var sName = this._retrievePluginName(bSibling);
		oOverlay.removeEditableByPlugin(sName);
		if (!oOverlay.getEditableByPlugins().length) {
			oOverlay.setEditable(false);
		}
	};

	BasePlugin.prototype.addToPluginsList = function(oOverlay, bSibling) {
		var sName = this._retrievePluginName(bSibling);
		var aPluginList = oOverlay.getEditableByPlugins();
		if (aPluginList.indexOf(sName) === -1) {
			oOverlay.addEditableByPlugin(sName);
			oOverlay.setEditable(true);
		}
	};

	BasePlugin.prototype.hasChangeHandler = function(sChangeType, oElement) {
		return !!this._getChangeHandler(sChangeType, oElement);
	};

	BasePlugin.prototype._getChangeHandler = function(sChangeType, oElement) {
		var sControlType = oElement.getMetadata().getName();
		return this._getChangeHandlerForControlType(sControlType, sChangeType);
	};

	BasePlugin.prototype._getChangeHandlerForControlType = function(sControlType, sChangeType) {
		var oResult = ChangeRegistry.getInstance().getRegistryItems({
			controlType : sControlType,
			changeTypeName : sChangeType,
			layer: this.getCommandFactory().getFlexSettings().layer
		});
		if (oResult && oResult[sControlType] && oResult[sControlType][sChangeType]) {
			var oRegItem = oResult[sControlType][sChangeType];
			return oRegItem.getChangeTypeMetadata().getChangeHandler();
		}
		return undefined;
	};

	return BasePlugin;

}, /* bExport= */ true);
}; // end of sap/ui/rta/plugin/Plugin.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.Remove') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.Remove.
jQuery.sap.declare('sap.ui.rta.plugin.Remove'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/Remove",[
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/rta/Utils',
	'sap/ui/rta/command/CompositeCommand',
	'sap/ui/dt/OverlayRegistry'
], function(
	Plugin,
	Utils,
	CompositeCommand,
	OverlayRegistry
){
	"use strict";

	/**
	 * Constructor for a new Remove Plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The Remove allows trigger remove operations on the overlay
	 * @extends sap.ui.rta.plugin.Plugin
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.plugin.Remove
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Remove = Plugin.extend("sap.ui.rta.plugin.Remove", /** @lends sap.ui.rta.plugin.Remove.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties: {},
			associations: {},
			events: {}
		}
	});

	/**
	 * Register browser event for an overlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	Remove.prototype.registerElementOverlay = function(oOverlay) {
		if (this.isEnabled(oOverlay)) {
			oOverlay.attachBrowserEvent("keydown", this._onKeyDown, this);
		}
		Plugin.prototype.registerElementOverlay.apply(this, arguments);
	};

	/**
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay
	 * @returns {boolean} editable or not
	 * @private
	 */
	Remove.prototype._isEditable = function(oOverlay) {
		var bEditable = false;
		var oElement = oOverlay.getElementInstance();

		var oParentDesignTimeMetadata = Utils.getRelevantContainerDesigntimeMetadata(oOverlay);
		if (!oParentDesignTimeMetadata) {
			return false;
		}

		var oRemoveAction = this.getAction(oOverlay);
		if (oRemoveAction && oRemoveAction.changeType) {
			if (oRemoveAction.changeOnRelevantContainer) {
				oElement = oOverlay.getRelevantContainer();
			}
			bEditable = this.hasChangeHandler(oRemoveAction.changeType, oElement);
		}

		if (bEditable) {
			return this.hasStableId(oOverlay);
		}

		return bEditable;
	};

	/**
	 * Checks if remove is enabled for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if enabled
	 * @public
	 */
	Remove.prototype.isEnabled = function(oOverlay) {
		var oAction = this.getAction(oOverlay);
		var bIsEnabled = false;
		if (!oAction) {
			return bIsEnabled;
		}

		if (typeof oAction.isEnabled !== "undefined") {
			if (typeof oAction.isEnabled === "function") {
				bIsEnabled = oAction.isEnabled(oOverlay.getElementInstance());
			} else {
				bIsEnabled = oAction.isEnabled;
			}
		} else {
			bIsEnabled = true;
		}
		return bIsEnabled && this._canBeRemovedFromAggregation(oOverlay);
	};

	/**
	 * Checks if Overlay control has a valid parent and if it is
	 * not the last visible control in the aggregation
	 *
	 * @param  {sap.ui.dt.Overlay} oOverlay Overlay for the control
	 * @return {boolean} Returns true if the control can be removed
	 * @private
	 */
	Remove.prototype._canBeRemovedFromAggregation = function(oOverlay){
		var oElement = oOverlay.getElementInstance();
		var oParent = oElement.getParent();
		if (!oParent){
			return false;
		}
		var aElements = oParent.getAggregation(oElement.sParentAggregationName);
		if (!Array.isArray(aElements)){
			return true;
		}
		if (aElements.length === 1){
			return false;
		}

		// Fallback to 1 if no overlay is selected
		var iNumberOfSelectedOverlays = this.getNumberOfSelectedOverlays() || 1;
		var aInvisibleElements = aElements.filter(function(oElement){
			var oElementOverlay = OverlayRegistry.getOverlay(oElement);
			return !(oElementOverlay && oElementOverlay.getElementVisibility());
		});
		return !(aInvisibleElements.length === (aElements.length - iNumberOfSelectedOverlays));
	};

	/**
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {String} Returns the confirmation text
	 * @private
	 */
	Remove.prototype._getConfirmationText = function(oOverlay) {
		var oAction = this.getAction(oOverlay);
		if (oAction && oAction.getConfirmationText) {
			return oAction.getConfirmationText(oOverlay.getElementInstance());
		}
	};

	/**
	 * Detaches the browser events
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	Remove.prototype.deregisterElementOverlay = function(oOverlay) {
		if (this.isEnabled(oOverlay)) {
			oOverlay.detachBrowserEvent("keydown", this._onKeyDown, this);
		}
		Plugin.prototype.deregisterElementOverlay.apply(this, arguments);
	};

	/**
	 * Handle keydown event
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	Remove.prototype._onKeyDown = function(oEvent) {
		if (oEvent.keyCode === jQuery.sap.KeyCodes.DELETE) {
			oEvent.stopPropagation();
			this.removeElement();
		}
	};

	/**
	 * The selected (not the focused) element should be hidden!
	 * @param {array} aOverlays overlay array
	 * @private
	 */
	Remove.prototype.removeElement = function(aOverlays) {
		var aSelection;
		if (aOverlays){
			aSelection = aOverlays;
		} else {
			var oDesignTime = this.getDesignTime();
			aSelection = oDesignTime.getSelection();
		}

		aSelection = aSelection.filter(this.isEnabled, this);

		if (aSelection.length > 0) {
			this.handler(aSelection);
		}
	};

	Remove.prototype._getRemoveCommand = function(oRemovedElement, oDesignTimeMetadata, sVariantManagementKey) {
		return this.getCommandFactory().getCommandFor(oRemovedElement, "Remove", {
			removedElement : oRemovedElement
		}, oDesignTimeMetadata, sVariantManagementKey);
	};

	Remove.prototype._fireElementModified = function(oCompositeCommand) {
		if (oCompositeCommand.getCommands().length) {
			this.fireElementModified({
				"command" : oCompositeCommand
			});
		}
	};

	Remove.prototype.handler = function(aSelectedOverlays) {
		var aPromises = [];
		var oCompositeCommand = new CompositeCommand();
		var fnSetFocus = function (oOverlay) {
			oOverlay.setSelected(true);
			setTimeout(function() {
				oOverlay.focus();
			}, 0);
		};

		var oNextOverlaySelection = Remove._getElementToFocus(aSelectedOverlays);

		aSelectedOverlays
			.forEach(function(oOverlay) {
				var oCommand;
				var oRemovedElement = oOverlay.getElementInstance();
				var oDesignTimeMetadata = oOverlay.getDesignTimeMetadata();
				var oRemoveAction = this.getAction(oOverlay);
				var sVariantManagementReference = this.getVariantManagementReference(oOverlay, oRemoveAction);
				var sConfirmationText = this._getConfirmationText(oOverlay);

				if (sConfirmationText) {
					aPromises.push(
						Utils.openRemoveConfirmationDialog(oRemovedElement, sConfirmationText)
						.then(function(bConfirmed) {
							if (bConfirmed) {
								oCommand = this._getRemoveCommand(oRemovedElement, oDesignTimeMetadata, sVariantManagementReference);
								oCompositeCommand.addCommand(oCommand);
							}
						}.bind(this))
					);
				} else {
					oCommand = this._getRemoveCommand(oRemovedElement, oDesignTimeMetadata, sVariantManagementReference);
					oCompositeCommand.addCommand(oCommand);
				}
		}, this);

		// since Promise.all is always asynchronous, we want to call it only if at least one promise exists
		if (aPromises.length) {
			Promise.all(aPromises).then(function() {
				this._fireElementModified(oCompositeCommand);
				fnSetFocus(oNextOverlaySelection);
			}.bind(this));
		} else {
			this._fireElementModified(oCompositeCommand);
			fnSetFocus(oNextOverlaySelection);
		}
	};

	Remove._getElementToFocus = function(aSelectedOverlays) {
		// BCP: 1780366011
		// if one element is selected then we try to get next or previous sibling
		// considering already hidden siblings, if not succeed then select relevant container
		var oNextOverlaySelection;
		if (aSelectedOverlays.length === 1) {
			var oOverlay = aSelectedOverlays[0];
			var aSiblings = oOverlay.getParent().getAggregation(oOverlay.sParentAggregationName);
			if (aSiblings.length > 1) {
				var iOverlayPosition = aSiblings.indexOf(oOverlay);
				var aCandidates = aSiblings.slice(iOverlayPosition + 1);
				if (iOverlayPosition !== 0) {
					aCandidates = aCandidates.concat(
						aSiblings.slice(0, iOverlayPosition).reverse()
					);
				}
				oNextOverlaySelection = aCandidates.filter(function (oSibling) {
					return oSibling.getElementInstance().getVisible();
				}).shift();
			}
		}
		if (!oNextOverlaySelection) {
			oNextOverlaySelection = OverlayRegistry.getOverlay(aSelectedOverlays[0].getRelevantContainer());
		}
		return oNextOverlaySelection;
	};

	/**
	 * Retrieve the context menu item for the action.
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay Overlay for which the context menu was opened
	 * @return {object[]}          Returns array containing the items with required data
	 */
	Remove.prototype.getMenuItems = function(oOverlay){
		return this._getMenuItems(oOverlay, {pluginId : "CTX_REMOVE", rank : 60});
	};

	/**
	 * Get the name of the action related to this plugin.
	 * @return {string} Returns the action name
	 */
	Remove.prototype.getActionName = function(){
		return "remove";
	};

	return Remove;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/Remove.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.RenameHandler') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.RenameHandler.
jQuery.sap.declare('sap.ui.rta.plugin.RenameHandler'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.Overlay'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.DOMUtil'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/RenameHandler",[
	'jquery.sap.global',
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/dt/Overlay',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/rta/Utils',
	'sap/ui/dt/DOMUtil'
], function(
	jQuery,
	Plugin,
	Overlay,
	ElementUtil,
	OverlayUtil,
	OverlayRegistry,
	Utils,
	DOMUtil
) {
	"use strict";

	/**
	 * Provides Rename handling functionality
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.52
	 * @alias sap.ui.rta.plugin.RenameHandler
	 * @experimental Since 1.52. This class is experimental and provides only limited functionality. Also the API might be
	 * changed in future.
	 */
	var RenameHandler = {
		/**
		 * @override
		 */
		_manageClickEvent : function (vEventOrElement) {
			var oOverlay = vEventOrElement.getSource ? vEventOrElement.getSource() : vEventOrElement;
			if (oOverlay.isSelected() && this.isRenameAvailable(oOverlay)) {
				oOverlay.attachBrowserEvent("click", RenameHandler._onClick, this);
			} else {
				oOverlay.detachBrowserEvent("click", RenameHandler._onClick, this);
			}
		},

		/**
		 * @param {sap.ui.dt.Overlay} oOverlay - target overlay
		 * @public
		 */
		startEdit : function (oOverlay, vDomRef, sPluginMethodName) {
			this._oEditedOverlay = oOverlay;

			var oElement = oOverlay.getElementInstance();

			var oDesignTimeMetadata = this._oEditedOverlay.getDesignTimeMetadata();

			var oEditableControlDomRef = oDesignTimeMetadata.getAssociatedDomRef(oElement, vDomRef);

			// if the Control is currently not visible on the screen, we have to scroll it into view
			if (!Utils.isElementInViewport(oEditableControlDomRef)) {
				oEditableControlDomRef.get(0).scrollIntoView();
			}

			this._$oEditableControlDomRef = jQuery(oEditableControlDomRef);

			var oEditableControlOverlay = sap.ui.dt.OverlayRegistry.getOverlay(oEditableControlDomRef.id) || oOverlay;

			var oWrapper = jQuery("<div class='sapUiRtaEditableField'></div>").appendTo(oEditableControlOverlay.$());
			this._$editableField = jQuery("<div contentEditable='true'></div>").appendTo(oWrapper);

			// if label is empty, set a preliminary dummy text at the control to get an overlay
			if (this._$oEditableControlDomRef.text() === "") {
				this._$oEditableControlDomRef.text("_?_");
				this._$editableField.text("");
			} else {
				this._$editableField.text(this._$oEditableControlDomRef.text());
			}

			DOMUtil.copyComputedStyle(this._$oEditableControlDomRef, this._$editableField);
			this._$editableField.children().remove();
			this._$editableField.css('visibility', 'hidden');

			// TODO : for all browsers
			this._$editableField.css({
				"-moz-user-modify": "read-write",
				"-webkit-user-modify": "read-write",
				"-ms-user-modify": "read-write",
				"user-modify": "read-write",
				"text-overflow": "clip"
			});

			Overlay.getMutationObserver().ignoreOnce({
				target: this._$oEditableControlDomRef.get(0)
			});

			this._$editableField.one("focus", RenameHandler._onEditableFieldFocus.bind(this));

			this._$editableField.on("blur", RenameHandler._onEditableFieldBlur.bind(this));
			this._$editableField.on("keydown", RenameHandler._onEditableFieldKeydown.bind(this));
			this._$editableField.on("dragstart", RenameHandler._stopPropagation.bind(this));
			this._$editableField.on("drag", RenameHandler._stopPropagation.bind(this));
			this._$editableField.on("dragend", RenameHandler._stopPropagation.bind(this));

			this._$editableField.on("click", RenameHandler._stopPropagation.bind(this));
			this._$editableField.on("mousedown", RenameHandler._stopPropagation.bind(this));

			this.setOldValue(RenameHandler._getCurrentEditableFieldText.call(this));

			// BCP: 1780352883
			setTimeout(function () {
				this._$oEditableControlDomRef.css("visibility", "hidden");
				this._$editableField.offset({left: this._$oEditableControlDomRef.offset().left});
				this._$editableField.offset({top: this._$oEditableControlDomRef.offset().top});
				this._$editableField.css('visibility', '');
				this._$editableField.focus();

				// keep Overlay selected while renaming
				oOverlay.setSelected(true);
				sap.ui.getCore().getEventBus().publish('sap.ui.rta', sPluginMethodName, {
					overlay: oOverlay,
					editableField: this._$editableField
				});
			}.bind(this), 0);
		},

		_setDesignTime : function (oDesignTime) {
			this._aSelection = [];
			var oOldDesignTime = this.getDesignTime();

			if (oOldDesignTime) {
				oOldDesignTime.detachSelectionChange(RenameHandler._onDesignTimeSelectionChange, this);
			}
			Plugin.prototype.setDesignTime.apply(this, arguments);

			if (oDesignTime) {
				oDesignTime.attachSelectionChange(RenameHandler._onDesignTimeSelectionChange, this);
				this._aSelection = oDesignTime.getSelection();
			}
		},

		/**
		 * @override
		 */
		_onDesignTimeSelectionChange : function(oEvent) {
			var aSelection = oEvent.getParameter("selection");

			// detach events from previous selection
			this._aSelection.forEach(RenameHandler._manageClickEvent, this);
			// attach events to the new selection
			aSelection.forEach(RenameHandler._manageClickEvent, this);

			this._aSelection = aSelection;
		},
		/**
		 * @param {sap.ui.base.Event} oEvent - event object
		 * @private
		 */
		_stopPropagation : function (oEvent) {
			oEvent.stopPropagation();
		},

		/**
		 * @param {sap.ui.base.Event} oEvent - event object
		 * @private
		 */
		_onEditableFieldFocus : function (oEvent) {
			this._oEditedOverlay.setSelected(false);
			var el = oEvent.target;
			var range = document.createRange();
			range.selectNodeContents(el);
			var sel = window.getSelection();
			sel.removeAllRanges();
			sel.addRange(range);
		},

		/**
		 * @param {boolean} bRestoreFocus - true if the focus should be restored on overlay after rename
		 * @private
		 */
		_stopEdit : function (bRestoreFocus, sPluginMethodName) {
			// exchange the dummy text at the label with the genuine empty text (see start_edit function)
			if (this._$oEditableControlDomRef.text() === "_?_") {
				this._$oEditableControlDomRef.text("");
			}
			//var oElement = this._oEditedOverlay.getElementInstance();
			//if (oElement.variantManagementModeChange) {
			//	oElement.fireVariantManagementModeChange({mode: ""});
			//}

			this._oEditedOverlay.$().find(".sapUiRtaEditableField").remove();
			Overlay.getMutationObserver().ignoreOnce({
				target: this._$oEditableControlDomRef.get(0)
			});
			this._$oEditableControlDomRef.css("visibility", "visible");

			if (bRestoreFocus) {
				var oOverlay = this._oEditedOverlay;

				// timeout is needed because of invalidation (test on bounded fields)
				// TODO: get rid of timeout! prevent UI5 from taking focus out of overlays
				this._iStopTimeout = setTimeout(function () {
					oOverlay.setSelected(true);
					oOverlay.focus();
					sap.ui.getCore().getEventBus().publish('sap.ui.rta', sPluginMethodName, {
						overlay: oOverlay
					});
				}, 500);
			}

			this._oEditedOverlay.setSelected(false);

			delete this._$editableField;
			delete this._$oEditableControlDomRef;
			delete this._oEditedOverlay;
		},

		/**
		 * @param {sap.ui.base.Event} oEvent - event object
		 * @private
		 */
		_onEditableFieldBlur : function (oEvent) {
			this._emitLabelChangeEvent();
			this.stopEdit(false);
		},

		/**
		 * @param {sap.ui.base.Event} oEvent - event object
		 * @private
		 */
		_onEditableFieldKeydown : function (oEvent) {
			switch (oEvent.keyCode) {
				case jQuery.sap.KeyCodes.ENTER:
					this._emitLabelChangeEvent();
					this.stopEdit(true);
					oEvent.preventDefault();
					break;
				case jQuery.sap.KeyCodes.ESCAPE:
					this.stopEdit(true);
					oEvent.preventDefault();
					break;
				case jQuery.sap.KeyCodes.DELETE:
					//Incident ID: #1680315103
					oEvent.stopPropagation();
					break;
				default:
			}
		},

		/**
		 * @returns {string} current editable field text
		 * @private
		 */
		_getCurrentEditableFieldText : function () {
			var sText = this._$editableField.text();
			// Rename to empty string should not be possible
			// to prevent issues with disappearing elements
			if (sText === "") {
				sText = '\xa0'; // = non-breaking space (&nbsp)
			}
			return sText;
		},


		/**
		 * @param {sap.ui.base.Event} oEvent - event object
		 * @private
		 */
		_onClick : function(oEvent) {
			var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
			if (this.isRenameEnabled(oOverlay) && !oEvent.metaKey && !oEvent.ctrlKey) {
				this.startEdit(oOverlay);
				oEvent.preventDefault();
			}
		},

		_exit : function() {
			if (this._$oEditableControlDomRef) {
				this.stopEdit(false);
			}

			clearTimeout(this._iStopTimeout);
		}
	};
	return RenameHandler;
}, true);
}; // end of sap/ui/rta/plugin/RenameHandler.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.Selection') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.Selection.
jQuery.sap.declare('sap.ui.rta.plugin.Selection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/Selection",[
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/rta/Utils',
	'sap/ui/fl/Utils'
],
function(
	Plugin,
	Utils,
	FlexUtils
){
	"use strict";

	/**
	 * Constructor for a new Selection plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The Selection plugin allows you to select or focus overlays with mouse or keyboard and navigate to others.
	 * @extends sap.ui.rta.plugin.Plugin
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.plugin.Selection
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Selection = Plugin.extend("sap.ui.rta.plugin.Selection", /** @lends sap.ui.dt.Plugin.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties: {
				multiSelectionRequiredPlugins : {
					type : "string[]"
				}
			},
			associations: {},
			events: {
				elementEditableChange: {
					parameters: {
						editable: {
							type: "boolean"
						}
					}
				}
			}
		}
	});

	/**
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay to be checked for developer mode
	 * @returns {boolean} true if it's in developer mode
	 * @private
	 */
	Selection.prototype._checkDeveloperMode = function(oOverlay) {
		if (oOverlay.getDesignTimeMetadata()) {
			var bDeveloperMode = this.getCommandFactory().getFlexSettings().developerMode;
			if (bDeveloperMode && this.hasStableId(oOverlay)) {
				oOverlay.setEditable(true);
				oOverlay.setSelectable(true);
				this.fireElementEditableChange({
					editable: true
				});
				return true;
			}
		}
		return false;
	};

	/**
	 * Register an overlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	Selection.prototype.registerElementOverlay = function(oOverlay) {
		if (!this._checkDeveloperMode(oOverlay)) {
			oOverlay.attachEditableChange(this._onEditableChange, this);
			this._adaptSelectable(oOverlay);
		}

		oOverlay.attachBrowserEvent("click", this._selectOverlay, this);
		oOverlay.attachBrowserEvent("keydown", this._onKeyDown, this);
		oOverlay.attachBrowserEvent("mousedown", this._onMouseDown, this);
	};

	Selection.prototype._onEditableChange = function(oEvent) {
		var oOverlay = oEvent.getSource();
		this._adaptSelectable(oOverlay);
	};

	Selection.prototype._adaptSelectable = function(oOverlay) {
		var bSelectable = oOverlay.getEditable();
		if (oOverlay.getSelectable() !== bSelectable) {
			oOverlay.setSelectable(bSelectable);
			this.fireElementEditableChange({
				editable: bSelectable
			});
		}
	};

	/**
	 * Additionally to super->deregisterOverlay this method detatches the browser events
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	Selection.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.detachBrowserEvent("click", this._selectOverlay, this);
		oOverlay.detachBrowserEvent("keydown", this._onKeyDown, this);
		oOverlay.detachBrowserEvent("mousedown", this._onMouseDown, this);

		oOverlay.detachEditableChange(this._onEditableChange, this);
	};

	Selection.prototype._setFocusOnOverlay = function(oOverlay, oEvent) {
		if (oOverlay && oOverlay.getSelectable()) {
			oOverlay.focus();
			oEvent.stopPropagation();
		}
	};

	/**
	 * Handle keydown event
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	Selection.prototype._onKeyDown = function(oEvent) {
		var oOverlay = Utils.getFocusedOverlay();
		if (oEvent.keyCode === jQuery.sap.KeyCodes.ENTER) {
			this._selectOverlay(oEvent);
		} else if (oEvent.keyCode === jQuery.sap.KeyCodes.ARROW_UP && oEvent.shiftKey === false && oEvent.altKey === false) {
			if (oOverlay) {
				var oParentOverlay = Utils.getFocusableParentOverlay(oOverlay);
				this._setFocusOnOverlay(oParentOverlay, oEvent);
				oEvent.preventDefault();
			}
		} else if (oEvent.keyCode === jQuery.sap.KeyCodes.ARROW_DOWN && oEvent.shiftKey === false && oEvent.altKey === false) {
			if (oOverlay) {
				var oFirstChildOverlay = Utils.getFirstFocusableDescendantOverlay(oOverlay);
				this._setFocusOnOverlay(oFirstChildOverlay, oEvent);
				oEvent.preventDefault();
			}
		} else if (oEvent.keyCode === jQuery.sap.KeyCodes.ARROW_LEFT && oEvent.shiftKey === false && oEvent.altKey === false) {
			if (oOverlay) {
				var oPrevSiblingOverlay = Utils.getPreviousFocusableSiblingOverlay(oOverlay);
				this._setFocusOnOverlay(oPrevSiblingOverlay, oEvent);
				oEvent.preventDefault();
			}
		} else if (oEvent.keyCode === jQuery.sap.KeyCodes.ARROW_RIGHT && oEvent.shiftKey === false && oEvent.altKey === false) {
			if (oOverlay) {
				var oNextSiblingOverlay = Utils.getNextFocusableSiblingOverlay(oOverlay);
				this._setFocusOnOverlay(oNextSiblingOverlay, oEvent);
				oEvent.preventDefault();
			}
		}
	};

	Selection.prototype._selectOverlay = function (oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		var bMultiSelection = oEvent.metaKey || oEvent.ctrlKey;
		var oTargetClasses = oEvent.target.className;

		if (oOverlay.getSelectable() && oTargetClasses.indexOf("sapUiDtOverlay") > -1) {
			if (bMultiSelection) {
				this.getDesignTime().setSelectionMode(sap.ui.dt.SelectionMode.Multi);
			}

			oOverlay.setSelected(!oOverlay.getSelected());

			if (bMultiSelection) {
				this.getDesignTime().setSelectionMode(sap.ui.dt.SelectionMode.Single);
			}

			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	/**
	 * Handle MouseDown event
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	Selection.prototype._onMouseDown = function(oEvent) {
		// set focus after clicking, needed only for internet explorer
		if (sap.ui.Device.browser.name == "ie"){
			// when the EasyAdd Button is clicked, we don't want to focus/stopPropagation.
			// but when the OverlayScrollContainer is the target, we want it to behave like a click on an overlay
			var oTarget = sap.ui.getCore().byId(oEvent.target.id);
			var bTargetIsScrollContainer = oEvent.target.className === "sapUiDtOverlayScrollContainer";
			var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
			if ((bTargetIsScrollContainer || oTarget instanceof sap.ui.dt.Overlay) && oOverlay instanceof sap.ui.dt.Overlay) {
				if (oOverlay.getSelectable()){
					oOverlay.focus();
					oEvent.stopPropagation();
				} else {
					oOverlay.getDomRef().blur();
				}
			}
		}
	};

	/**
	 * @override
	 */
	Selection.prototype.setDesignTime = function(oDesignTime) {
		//detach from listener from old DesignTime instance
		if (this.getDesignTime()) {
			this.getDesignTime().detachSelectionChange(this._onDesignTimeSelectionChange, this);
		}

		//set new DesignTime instance in parent class
		Plugin.prototype.setDesignTime.apply(this, arguments);

		//attach listener back to the new DesignTime instance
		if (this.getDesignTime()) {
			this.getDesignTime().attachSelectionChange(this._onDesignTimeSelectionChange, this);
		}
	};

	Selection.prototype._onDesignTimeSelectionChange = function(oEvent) {
		if (this.getDesignTime().getSelectionMode() === sap.ui.dt.SelectionMode.Single) {
			return;
		}

		var oCurrentSelectedOverlay = oEvent.getParameter("selection")[oEvent.getParameter("selection").length - 1];
		var aSelections = this.getDesignTime().getSelection();
		if (aSelections && aSelections.length === 1) {
			oCurrentSelectedOverlay.setSelected(true);
			return;
		}
		if (!oCurrentSelectedOverlay || this.getDesignTime().getSelectionMode() === sap.ui.dt.SelectionMode.Single) {
			return;
		}

		var bMultiSelectisValid = _hasSharedMultiSelectionPlugins(aSelections, this.getMultiSelectionRequiredPlugins())
			&& _hasSharedRelevantContainer(aSelections)
			&& (_hasSameParent(aSelections, oCurrentSelectedOverlay)
				|| _isOfSameType(aSelections, oCurrentSelectedOverlay));

		oCurrentSelectedOverlay.setSelected(bMultiSelectisValid);
	};

	function _hasSharedMultiSelectionPlugins(aSelections, aMultiSelectionRequiredPlugins){
		var aSharedMultiSelectionPlugins = aMultiSelectionRequiredPlugins;
		aSelections.forEach(function(oSelectedOverlay) {
			var aEditableByPlugins = oSelectedOverlay.getEditableByPlugins();
			aSharedMultiSelectionPlugins = aSharedMultiSelectionPlugins.reduce(function(aSharedPlugins, sPluginName){
				if (aEditableByPlugins.indexOf(sPluginName) !== -1){
					aSharedPlugins.push(sPluginName);
				}
				return aSharedPlugins;
			}, []);
		});
		return aSharedMultiSelectionPlugins.length > 0;
	}

	function _hasSharedRelevantContainer(aSelections){
		var oCurrentSelectedOverlay = aSelections[aSelections.length - 1];
		var oPreviousSelectedOverlay = aSelections[aSelections.length - 2];

		var oCurrentRelevantContainer = oCurrentSelectedOverlay.getRelevantContainer();
		var oPreviousRelevantContainer = oPreviousSelectedOverlay.getRelevantContainer();

		return oCurrentRelevantContainer === oPreviousRelevantContainer;
	}

	function _hasSameParent(aSelections, oSelectedOverlay){
		return !aSelections.some(function(oSelection){
			return oSelection.getParentElementOverlay() !== oSelectedOverlay.getParentElementOverlay();
		});
	}

	function _isOfSameType(aSelections, oSelectedOverlay){
		var sSelectedOverlayElementName = oSelectedOverlay.getElementInstance().getMetadata().getName();
		return !aSelections.some(function(oSelection){
			var sCurrentSelectionElementName = oSelection.getElementInstance().getMetadata().getName();
			return (sCurrentSelectionElementName !== sSelectedOverlayElementName);
		});
	}

	return Selection;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/Selection.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.Settings') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.Settings.
jQuery.sap.declare('sap.ui.rta.plugin.Settings'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/plugin/Settings",[
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/rta/Utils'
], function(Plugin, Utils) {
	"use strict";

	/**
	 * Constructor for a new Settings Plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The Settings allows trigger change of settings operations on the overlay
	 * @extends sap.ui.rta.plugin.Plugin
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.44
	 * @alias sap.ui.rta.plugin.Settings
	 * @experimental Since 1.44. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Settings = Plugin.extend("sap.ui.rta.plugin.Settings", /** @lends sap.ui.rta.plugin.Settings.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties: {
				commandStack : {
					type : "any"
				}
			},
			associations: {},
			events: {}
		}
	});

	/**
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay to be checked for editable
	 * @returns {boolean} true if it's editable
	 * @private
	 */
	Settings.prototype._isEditable = function(oOverlay) {
		if (!Utils.getRelevantContainerDesigntimeMetadata(oOverlay)) {
			return false;
		}

		var vSettingsAction = this.getAction(oOverlay);
		// If no additional actions are defined in settings, a handler must be present to make it available
		if (vSettingsAction) {
			if (vSettingsAction.handler) {
				return this.hasStableId(oOverlay);
			} else {
				var bHandlerFound = Object.keys(vSettingsAction).some(function(sSettingsAction) {
					return vSettingsAction[sSettingsAction].handler;
				});
				if (bHandlerFound) {
					return this.hasStableId(oOverlay);
				}
			}
		}

		return false;
	};

	/**
	 * Checks if settings is enabled for oOverlay
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay object
	 * @returns {boolean} true if it's enabled
	 * @public
	 */
	Settings.prototype.isEnabled = function(oOverlay) {
		var oAction = this.getAction(oOverlay);
		if (!oAction) {
			return false;
		}

		if (typeof oAction.isEnabled !== "undefined") {
			if (typeof oAction.isEnabled === "function") {
				return oAction.isEnabled(oOverlay.getElementInstance());
			} else {
				return oAction.isEnabled;
			}
		}
		return true;
	};

	Settings.prototype._getUnsavedChanges = function(sId, aChangeTypes) {
		var sElementId;

		var aUnsavedChanges = this.getCommandStack().getAllExecutedCommands().filter(function(oCommand) {
			sElementId = oCommand.getElementId && oCommand.getElementId() || oCommand.getElement && oCommand.getElement().getId();
			if (sElementId === sId && aChangeTypes.indexOf(oCommand.getChangeType()) >= 0) {
				return true;
			}
		}).map(function(oCommand) {
			return oCommand.getPreparedChange();
		});

		return aUnsavedChanges;
	};

	/**
	 * Retrieves the available actions from the DesignTime Metadata and creates
	 * the corresponding commands for them.
	 * @param  {sap.ui.dt.ElementOverlay[]} aSelectedOverlays Target Overlays of the action
	 * @param  {function} [fnHandler] handler function for the case of multiple settings actions
	 * @return {Promise} Returns promise resolving with the creation of the commands
	 */
	Settings.prototype.handler = function(aSelectedOverlays, mPropertyBag) {
		mPropertyBag = mPropertyBag || {};
		var oSettingsCommand, oAppDescriptorCommand, oCompositeCommand;
		var oElement = aSelectedOverlays[0].getElementInstance();
		var fnHandler = mPropertyBag.fnHandler;

		if (!fnHandler){
			fnHandler = aSelectedOverlays[0].getDesignTimeMetadata().getAction("settings").handler;
			if (!fnHandler) {
				throw new Error("Handler not found for settings action");
			}
		}
		mPropertyBag.getUnsavedChanges = this._getUnsavedChanges.bind(this);
		mPropertyBag.styleClass = Utils.getRtaStyleClassName();

		return fnHandler(oElement, mPropertyBag).then(function(aChanges) {
			if (aChanges.length > 0){
				oCompositeCommand = this.getCommandFactory().getCommandFor(oElement, "composite");
				aChanges.forEach(function(mChange) {
					var mChangeSpecificData = mChange.changeSpecificData;
					// Flex Change
					if (mChangeSpecificData.changeType){
						var sVariantManagementReference;
						var vSelectorControl = mChange.selectorControl;
						var sControlType;
						if (vSelectorControl.controlType){
							sControlType = vSelectorControl.controlType;
						} else {
							sControlType = vSelectorControl.getMetadata().getName();
						}
						var oChangeHandler = this._getChangeHandlerForControlType(sControlType, mChangeSpecificData.changeType);
						if (aSelectedOverlays[0].getVariantManagement && oChangeHandler && oChangeHandler.revertChange) {
							sVariantManagementReference = aSelectedOverlays[0].getVariantManagement();
						}
						oSettingsCommand = this.getCommandFactory().getCommandFor(
							vSelectorControl,
							"settings",
							mChangeSpecificData,
							undefined,
							sVariantManagementReference);
						oCompositeCommand.addCommand(oSettingsCommand);
					// App Descriptor Change
					} else if (mChangeSpecificData.appDescriptorChangeType){
						var oComponent = mChange.appComponent;
						var mManifest = oComponent.getManifest();
						var sReference = mManifest["sap.app"].id;
						oAppDescriptorCommand = this.getCommandFactory().getCommandFor(
							oElement,
							"appDescriptor",
							{
								reference : sReference,
								appComponent : oComponent,
								changeType : mChangeSpecificData.appDescriptorChangeType,
								parameters : mChangeSpecificData.content.parameters,
								texts : mChangeSpecificData.content.texts
							}
						);
						oCompositeCommand.addCommand(oAppDescriptorCommand);
					}
				}, this);
				if (oCompositeCommand.getCommands().length > 0){
					this.fireElementModified({
						"command" : oCompositeCommand
					});
				}
			}
		}.bind(this))['catch'](function(oError) {
			if (oError) {
				throw oError;
			}
		});
	};

	/**
	 * Retrieve the context menu item for the actions.
	 * If multiple actions are defined for Settings, it returns multiple menu items.
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay Overlay for which the context menu was opened
	 * @return {object[]}          Returns array containing the items with required data
	 */
	Settings.prototype.getMenuItems = function(oOverlay){
		var vSettingsActions = this.getAction(oOverlay);
		var iRank = 110;
		var sPluginId = "CTX_SETTINGS";

		if (vSettingsActions) {
			// Only one action: simply return settings entry as usual
			if (vSettingsActions.handler) {
				return this._getMenuItems(oOverlay, {pluginId : sPluginId, rank : iRank});
			// Multiple actions: return one menu item for each action
			} else {
				var aMenuItems = [];
				var aSettingsActions = Object.keys(vSettingsActions);
				var iActionCounter = 0;
				aSettingsActions.forEach(function(sSettingsAction){
					var oSettingsAction = vSettingsActions[sSettingsAction],
						sActionText = this.getActionText(oOverlay, oSettingsAction, oSettingsAction.name);
					if (oSettingsAction.handler){
						aMenuItems.push({
							id : sPluginId + iActionCounter,
							text : sActionText,
							enabled : oSettingsAction.isEnabled && oSettingsAction.isEnabled.bind(this, oOverlay.getElementInstance()),
							handler : function(fnHandler, aOverlays, mPropertyBag){
								mPropertyBag = mPropertyBag || {};
								mPropertyBag.fnHandler = fnHandler;
								return this.handler(aOverlays, mPropertyBag);
							}.bind(this, oSettingsAction.handler),
							rank : iRank + iActionCounter
						});
						iActionCounter++;
					} else {
						jQuery.sap.log.warning("Handler not found for settings action '" + sActionText + "'");
					}
				}.bind(this));
				return aMenuItems;
			}
		}
	};

	/**
	 * Get the name of the action related to this plugin.
	 * @return {string} Returns the action name
	 */
	Settings.prototype.getActionName = function(){
		return "settings";
	};

	return Settings;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/Settings.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.Split') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.Split.
jQuery.sap.declare('sap.ui.rta.plugin.Split'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.dt.Selection'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/Split",[
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/dt/Selection',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/rta/Utils',
	'sap/ui/fl/Utils'
], function(
	Plugin,
	Selection,
	OverlayRegistry,
	Utils,
	FlexUtils
) {
	"use strict";

	/**
	 * Constructor for a new Split Plugin.
	 *
	 * @class
	 * @extends sap.ui.rta.plugin.Plugin
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.46
	 * @alias sap.ui.rta.plugin.Split
	 * @experimental Since 1.46. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Split = Plugin.extend("sap.ui.rta.plugin.Split", /** @lends sap.ui.rta.plugin.Split.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties: {},
			associations: {},
			events: {}
		}
	});

	/**
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay to be checked for editable
	 * @returns {boolean} true if it's editable
	 * @private
	 */
	Split.prototype._isEditable = function(oOverlay) {
		if (!Utils.getRelevantContainerDesigntimeMetadata(oOverlay)) {
			return false;
		}
		var oSplitAction = this.getAction(oOverlay);
		if (oSplitAction && oSplitAction.changeType && oSplitAction.changeOnRelevantContainer) {
			return this.hasStableId(oOverlay) && this.hasChangeHandler(oSplitAction.changeType, oOverlay.getRelevantContainer());
		} else {
			return false;
		}
	};

	/**
	 * Checks if Split is available for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if available
	 * @public
	 */
	Split.prototype.isAvailable = function(oOverlay) {
		if (!this._isEditableByPlugin(oOverlay)) {
			return false;
		}

		var aSelectedOverlays = this.getDesignTime().getSelection();
		if (aSelectedOverlays.length !== 1) {
			return false;
		}

		var vSplitAction = this.getAction(oOverlay);
		var oElement = aSelectedOverlays[0].getElementInstance();
		if (vSplitAction && vSplitAction.getControlsCount(oElement) <= 1) {
			return false;
		}

		return true;
	};

	/**
	 * Checks if Split is enabled for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if enabled
	 * @public
	 */
	Split.prototype.isEnabled = function(oOverlay) {

		// check that each selected element has an enabled action
		var oAction = this.getAction(oOverlay);
		if (!oAction || !this.isAvailable(oOverlay)) {
			return false;
		}

		// actions are by default enabled
		var bActionIsEnabled = true;
		if (typeof oAction.isEnabled !== "undefined") {
			if (typeof oAction.isEnabled === "function") {
				 bActionIsEnabled = oAction.isEnabled(oOverlay.getElementInstance());
			} else {
				bActionIsEnabled = oAction.isEnabled;
			}
		}
		return bActionIsEnabled;
	};

	/**
	 * @param  {any} oSplitElement selected element
	 */
	Split.prototype.handleSplit = function(oSplitElement) {
		var oParent = oSplitElement.getParent();
		var oElementOverlay = OverlayRegistry.getOverlay(oSplitElement);
		var oDesignTimeMetadata = oElementOverlay.getDesignTimeMetadata();

		var iFieldsLength = this.getAction(oElementOverlay).getControlsCount(oSplitElement);
		var oView = FlexUtils.getViewForControl(oSplitElement);
		var aNewElementIds = [];
		// Split needs iFieldsLength controls, only one is available so far
		for (var i = 0; i < iFieldsLength - 1; i++){
			aNewElementIds.push(oView.createId(jQuery.sap.uid()));
		}

		var oSplitAction = this.getAction(oElementOverlay);
		var sVariantManagementReference = this.getVariantManagementReference(oElementOverlay, oSplitAction);

		var oSplitCommand = this.getCommandFactory().getCommandFor(oSplitElement, "split", {
			newElementIds : aNewElementIds,
			source : oSplitElement,
			parentElement : oParent
		}, oDesignTimeMetadata, sVariantManagementReference);
		this.fireElementModified({
			"command" : oSplitCommand
		});

	};

	/**
	 * Retrieve the context menu item for the action.
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay Overlay for which the context menu was opened
	 * @return {object[]}          Returns array containing the items with required data
	 */
	Split.prototype.getMenuItems = function(oOverlay){
		return this._getMenuItems(oOverlay, {pluginId : "CTX_UNGROUP_FIELDS", rank : 100});
	};

	/**
	 * Get the name of the action related to this plugin.
	 * @return {string} Returns the action name
	 */
	Split.prototype.getActionName = function(){
		return "split";
	};

	/**
	 * Trigger the plugin execution.
	 * @param  {sap.ui.dt.ElementOverlay[]} aOverlays Selected overlays; targets of the action
	 * @param  {any} oEventItem ContextMenu item which triggers the event
	 * @param  {any} oContextElement Element where the action is triggered
	 */
	Split.prototype.handler = function(aOverlays, mPropertyBag){
		//TODO: Handle "Stop Cut & Paste" depending on alignment with Dietrich!
		this.handleSplit(mPropertyBag.contextElement);
	};

	return Split;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/Split.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.additionalElements.AddElementsDialog') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.plugin.additionalElements.AddElementsDialog'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Label'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.LabelDesign'); // unlisted dependency retained
jQuery.sap.require('sap.m.Dialog'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.m.SearchField'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.Toolbar'); // unlisted dependency retained
jQuery.sap.require('sap.m.ToolbarSpacer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.FilterOperator'); // unlisted dependency retained
jQuery.sap.require('sap.m.List'); // unlisted dependency retained
jQuery.sap.require('sap.m.CustomListItem'); // unlisted dependency retained
jQuery.sap.require('sap.m.ListType'); // unlisted dependency retained
jQuery.sap.require('sap.m.ScrollContainer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Sorter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementUtil'); // unlisted dependency retained
jQuery.sap.require('sap.m.VBox'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/additionalElements/AddElementsDialog",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject',
	'sap/ui/commons/Label',
	'sap/ui/commons/LabelDesign',
	'sap/m/Dialog',
	'sap/ui/model/json/JSONModel',
	'sap/m/SearchField',
	'sap/m/Button',
	'sap/m/Toolbar',
	'sap/m/ToolbarSpacer',
	'sap/ui/model/Filter',
	'sap/ui/model/FilterOperator',
	'sap/ui/rta/command/CommandFactory',
	'sap/ui/rta/command/CompositeCommand',
	'sap/m/List',
	'sap/m/CustomListItem',
	'sap/m/ListType',
	'sap/m/ScrollContainer',
	'sap/ui/model/Sorter',
	'sap/ui/dt/ElementUtil',
	'sap/m/VBox',
	'sap/ui/rta/Utils'
], function (
	jQuery,
	ManagedObject,
	Label,
	LabelDesign,
	Dialog,
	JSONModel,
	SearchField,
	Button,
	Toolbar,
	ToolbarSpacer,
	Filter,
	FilterOperator,
	CommandFactory,
	CompositeCommand,
	List,
	ListItem,
	ListType,
	ScrollContainer,
	Sorter,
	ElementUtil,
	VBox,
	Utils
) {
	"use strict";

	/**
	 * Constructor for a new sap.ui.rta.plugin.additionalElements.AddElementsDialog control.
	 *
	 * @class Context - Dialog for available Fields in Runtime Authoring
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.44
	 * @alias sap.ui.rta.plugin.additionalElements.AddElementsDialog
	 * @experimental Since 1.44. This class is experimental and provides only limited functionality. Also the API might be
	 *			   changed in future.
	 */
	var AddElementsDialog = ManagedObject.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				"customFieldEnabled" : {
					type: "boolean",
					defaultValue: false
				},
				"title" : {
					type: "string"
				}
			},
			events : {
				"opened" : {},
				"openCustomField" : {}
			}
		}
	});

	/**
	 * Initialize the Dialog
	 *
	 * @private
	 */
	AddElementsDialog.prototype.init = function() {
		// Get messagebundle.properties for sap.ui.rta
		this._oTextResources = sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");
		this._bAscendingSortOrder = false;
		// sap.m.Dialog shouldn't have no parent or a rendered parent
		// otherwise invalidate/filter/... is not working correctly
		this._oDialog = new Dialog().addStyleClass("sapUIRtaFieldRepositoryDialog");
		this._oDialog.addStyleClass(Utils.getRtaStyleClassName());
		this._oDialog.removeStyleClass("sapUiPopupWithPadding");
		this._oDialog.setModel(new JSONModel({
			elements: []
		}));

		var aContent = this._createContent();
		var aButtons = this._createButtons();
		aContent.forEach(function(oContent) {
			this._oDialog.addContent(oContent);
		}, this);
		aButtons.forEach(function(oButton) {
			this._oDialog.addButton(oButton);
		}, this);
		this._oDialog.setInitialFocus(this._oInput);
	};

	/**
	 * Create the Content of the Dialog
	 *
	 * @returns {object} list containes inputList and oScrollContainer objects
	 * @private
	 */
	AddElementsDialog.prototype._createContent = function() {
		// SearchField
		this._oInput =  new SearchField({
			width : "100%",
			liveChange : [this._updateModelFilter, this]
		});

		// Button for sorting the List
		var oResortButton = new Button({
			text : "",
			icon : "sap-icon://sort",
			press : [this._resortList, this]
		});

		// Button for creating Custom Fields
		this._oCustomFieldButton = new Button({
			text : "",
			icon : "sap-icon://add",
			tooltip : this._oTextResources.getText("BTN_FREP_CCF"),
			enabled : this.getCustomFieldEnabled(),
			press : [this._redirectToCustomFieldCreation, this]
		});

		// Toolbar
		this._oToolbarSpacer1 = new ToolbarSpacer();
		this.oInputFields = new Toolbar({
			content: [this._oInput, oResortButton, this._oToolbarSpacer1, this._oCustomFieldButton]
		});

		// Fields of the List
		var oFieldName = new Label({
			design: LabelDesign.Bold,
			tooltip: "{tooltip}",
			text: {
				parts: [{path: "label"}, {path: "referencedComplexPropertyName"}, {path: "duplicateComplexName"}],
				formatter: function(sLabel, sReferencedComplexPropertyName, bDuplicateComplexName) {
					if (bDuplicateComplexName && sReferencedComplexPropertyName) {
						sLabel += " (" + sReferencedComplexPropertyName + ")";
					}
					return sLabel;
				}
			}
		});

		var oFieldName2 = new Label({
			text: {
				parts: [{path: "originalLabel"}],
				formatter: function(sOriginalLabel) {
					if (sOriginalLabel) {
						return this._oTextResources.getText("LBL_FREP", sOriginalLabel);
					}
					return "";
				}.bind(this)
			},
			visible: {
				parts: [{path: "originalLabel"}],
				formatter: function(sOriginalLabel) {
					if (sOriginalLabel) {
						return true;
					}
					return false;
				}
			}
		});

		var oVBox = new VBox();
		oVBox.addItem(oFieldName);
		oVBox.addItem(oFieldName2);

		// List
		var oSorter = new Sorter("label", this._bAscendingSortOrder);
		this._oList = new List(
				{
					mode : "MultiSelect",
					includeItemInSelection : true,
					growing : true,
					growingScrollToLoad : true
				}).setNoDataText(this._oTextResources.getText("MSG_NO_FIELDS", this._oTextResources.getText("MULTIPLE_CONTROL_NAME").toLowerCase()));

		var oListItem = new ListItem({
			type: ListType.Active,
			selected : "{selected}",
			content : [oVBox]
		});

		this._oList.bindItems({path:"/elements", template: oListItem, sorter : oSorter});

		// Scrollcontainer containing the List
		// Needed for scrolling the List
		var oScrollContainer = new ScrollContainer({
			content: this._oList,
			vertical: true,
			horizontal: false
		}).addStyleClass("sapUIRtaCCDialogScrollContainer");

		return [this.oInputFields,
				oScrollContainer];
	};

	/**
	 * Create the Buttons of the Dialog (OK/Cancel)
	 *
	 * @returns {object} list containes ok button and cancel button objects
	 * @private
	 */
	AddElementsDialog.prototype._createButtons = function() {
		this._oOKButton = new Button({
			text : this._oTextResources.getText("BTN_FREP_OK"),
			press : [this._submitDialog, this]
		});
		var oCancelButton = new Button({
			text : this._oTextResources.getText("BTN_FREP_CANCEL"),
			press : [this._cancelDialog, this]
		});
		return [this._oOKButton, oCancelButton];
	};

	/**
	 * Close the dialog.
	 */
	AddElementsDialog.prototype._submitDialog = function() {
		this._oDialog.close();
		this._fnResolve();
	};

	/**
	 * Close dialog and revert all change operations
	 */
	AddElementsDialog.prototype._cancelDialog = function() {
		// clear all variables
		this._oList.removeSelections();
		this._oDialog.close();
		this._fnReject();
	};

	AddElementsDialog.prototype.setElements = function(aElements) {
		this._oDialog.getModel().setProperty("/elements", aElements);
	};

	AddElementsDialog.prototype.getElements = function() {
		return this._oDialog.getModel().getProperty("/elements");
	};

	AddElementsDialog.prototype.getSelectedElements = function() {
		return this._oDialog.getModel().getObject("/elements").filter(function(oElement){
			return oElement.selected;
		});
	};

	/**
	 * Open the Field Repository Dialog
	 *
	 * @param {sap.ui.core.Control} oControl Currently selected control
	 * @returns {Promise} empty promise
	 * @public
	 */
	AddElementsDialog.prototype.open = function(oControl) {
		return new Promise(function (resolve, reject) {
			this._fnResolve = resolve;
			this._fnReject = reject;
			this._oDialog.oPopup.attachOpened(function (){
				this.fireOpened();
			}.bind(this));
			// Makes sure the modal div element does not change the size of our application (which would result in
			// recalculation of our overlays)
			this._oDialog.open();
		}.bind(this));
	};

	/**
	 * Resort the list
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	AddElementsDialog.prototype._resortList = function(oEvent) {
		this._bAscendingSortOrder = !this._bAscendingSortOrder;
		var oBinding = this._oList.getBinding("items");
		var aSorter = [];
		aSorter.push(new Sorter("label", this._bAscendingSortOrder));
		oBinding.sort(aSorter);
	};

	/**
	 * Updates the model on filter events
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	AddElementsDialog.prototype._updateModelFilter = function(oEvent) {
		var sValue = oEvent.getParameter("newValue");
		var oBinding = this._oList.getBinding("items");
		if ((typeof sValue) === "string") {
			var oFilterLabel = new Filter("label", FilterOperator.Contains, sValue);
			var oOriginalLabelFilter = new Filter("originalLabel", FilterOperator.Contains, sValue);
			var oReferencedComplexPropertyNameFilter = new Filter("referencedComplexPropertyName", FilterOperator.Contains, sValue);
			var oDuplicateComplexNameFilter = new Filter("duplicateComplexName", FilterOperator.EQ, true);
			var oComplexNameFilter = new Filter({ filters: [oReferencedComplexPropertyNameFilter, oDuplicateComplexNameFilter], and: true });
			var oFilterLabelOrInfo = new Filter({ filters: [oFilterLabel, oOriginalLabelFilter, oComplexNameFilter], and: false });
			oBinding.filter([oFilterLabelOrInfo]);
		} else {
			oBinding.filter([]);
		}
	};

	/**
	 * Fire an event to redirect to custom field creation
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	AddElementsDialog.prototype._redirectToCustomFieldCreation = function(oEvent) {
		this.fireOpenCustomField();
		this._oDialog.close();
	};

	AddElementsDialog.prototype.setTitle = function(sTitle) {
		ManagedObject.prototype.setProperty.call(this, "title", sTitle, true);
		this._oDialog.setTitle(sTitle);
	};

	/**
	 * Enables the Custom Field Creation button
	 *
	 * @param {boolean} bCustomFieldEnabled true shows the button, false not
	 * @public
	 */
	AddElementsDialog.prototype.setCustomFieldEnabled = function(bCustomFieldEnabled) {
		ManagedObject.prototype.setProperty.call(this, "customFieldEnabled", bCustomFieldEnabled, true);
		this._oCustomFieldButton.setEnabled(bCustomFieldEnabled);
	};

	return AddElementsDialog;

}, /* bExport= */ true);
}; // end of sap/ui/rta/plugin/additionalElements/AddElementsDialog.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.StashedControlSupport'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementDesignTimeMetadata'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin",[
	"jquery.sap.global",
	"sap/ui/rta/plugin/Plugin",
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/rta/Utils',
	'sap/ui/fl/Utils',
	'sap/ui/core/StashedControlSupport',
	'sap/ui/dt/ElementDesignTimeMetadata'
], function(jQuery,
	Plugin,
	ElementUtil,
	OverlayRegistry,
	Utils,
	FlUtils,
	StashedControlSupport,
	ElementDesignTimeMetadata
){
	"use strict";

	function _getParents(bSibling, oOverlay) {
		var oParentOverlay,
			oRelevantContainer = oOverlay.getRelevantContainer(!bSibling),
			oRelevantContainerOverlay = OverlayRegistry.getOverlay(oRelevantContainer);
		if (bSibling) {
			oParentOverlay = oOverlay.getParentElementOverlay();
		} else {
			oParentOverlay = oOverlay;
		}
		return {
			relevantContainerOverlay : oRelevantContainerOverlay,
			parentOverlay : oParentOverlay,
			relevantContainer : oRelevantContainer,
			parent : oParentOverlay.getElementInstance()
		};
	}

	function _defaultGetAggregationName(oParent, oChild) {
		return oChild.sParentAggregationName;
	}


	function _getInvisibleElements (oParentOverlay, sAggregationName){
		var oParentElement = oParentOverlay.getElementInstance();
		var aInvisibleElements = ElementUtil.getAggregation(oParentElement, sAggregationName).filter(function(oControl){
			var oOverlay = OverlayRegistry.getOverlay(oControl);

			if (!this.hasStableId(oOverlay)) {
				return false;
			}

			var oRelevantContainer = oParentOverlay.getRelevantContainer(true);
			var oRelevantContainerOverlay = OverlayRegistry.getOverlay(oRelevantContainer);
			var oOverlayToCheck = oParentOverlay;
			var bAnyParentInvisible = false;
			// check all the parents until the relevantContainerOverlay for invisibility.
			do {
				bAnyParentInvisible = !oOverlayToCheck.getElementVisibility();
				if (bAnyParentInvisible) {
					break;
				}
				if (oOverlayToCheck === oRelevantContainerOverlay) {
					break;
				} else {
					oOverlayToCheck = oOverlayToCheck.getParentElementOverlay();
				}
			} while (oOverlayToCheck);

			if (bAnyParentInvisible) {
				return true;
			}

			return oOverlay.getElementVisibility() === false;
		}, this);

		var aStashedControls = StashedControlSupport.getStashedControls(oParentElement.getId());
		return aInvisibleElements.concat(aStashedControls);
	}

	var SINGULAR = true, PLURAL = false;
	function _getText (sRtaTextKey, mActions, oParentElement, bSingular, sControlName) {
		var aNames = [];
		var mControlType;
		var sControlType;
		if (mActions.addODataProperty){
			var sAggregationName = mActions.aggregation;
			var oDesignTimeMetadata = mActions.addODataProperty.designTimeMetadata;
			mControlType = oDesignTimeMetadata.getAggregationDescription(sAggregationName, oParentElement);
			if (mControlType) {
				sControlType = bSingular ? mControlType.singular : mControlType.plural;
				aNames.push(sControlType);
			}
		}
		if (mActions.reveal){
			Object.keys(mActions.reveal.types).forEach(function(sType){
				var mType = mActions.reveal.types[sType];
				mControlType = mType.designTimeMetadata.getName(oParentElement);
				if (mControlType) {
					sControlType = bSingular ? mControlType.singular : mControlType.plural;
					aNames.push(sControlType);
				}
			});
		}
		var aNonDuplicateNames = aNames.reduce(function(_aNames, sName){
			if (_aNames.indexOf(sName) === -1) {
				_aNames.push(sName);
			}
			return _aNames;
		}, []);


		var oTextResources = sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");

		if (aNonDuplicateNames.length === 1) {
			sControlType = aNonDuplicateNames[0];
		} else if (sControlName) {
			sControlType = sControlName;
		} else {
			sControlType = oTextResources.getText("MULTIPLE_CONTROL_NAME");
		}
		return oTextResources.getText(sRtaTextKey, sControlType);
	}

	function _fakeStashedControlInfos() {
		return {
			designTimeMetadata : new ElementDesignTimeMetadata(
				{
					data : {
						name : {
							singular : function(){
								return sap.uxap.i18nModel.getResourceBundle().getText("SECTION_CONTROL_NAME");
							},
							plural : function(){
								return sap.uxap.i18nModel.getResourceBundle().getText("SECTION_CONTROL_NAME_PLURAL");
							}
						},
						actions : {
							reveal : {
								changeType : "unstashControl",
								getAggregationName : _defaultGetAggregationName
							}
						}
					}
				}
			),
			action : {
				changeType : "unstashControl",
				getAggregationName : _defaultGetAggregationName
			}
		};
	}

	/**
	 * Constructor for a new Additional Elements Plugin.
	 *
	 * The AdditionalElementsPlugin should handle the orchestration
	 * of the AdditionalElementsAnalyzer, the dialog and the command creation
	 *
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The plugin allows to add additional elements that exist either hidden in the UI or in the OData service
	 * @extends sap.ui.rta.plugin.Plugin
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.44
	 * @alias sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin
	 * @experimental Since 1.44. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var AdditionalElementsPlugin = Plugin.extend("sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin", {
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties: {
				analyzer: "object", //sap.ui.rta.plugin.additionalElements.AdditionalElementsAnalyzer
				dialog: "object", //sap.ui.rta.plugin.additionalElements.AddElementsDialog
				commandFactory: "object"
			},
			associations: {},
			events: {}
		},

		getContextMenuTitle: function(bOverlayIsSibling, oOverlay){
			var mParents = _getParents(bOverlayIsSibling, oOverlay);
			var mActions = this._getActions(bOverlayIsSibling, oOverlay);
			return _getText("CTX_ADD_ELEMENTS", mActions, mParents.parent, SINGULAR);
		},

		isAvailable: function(bOverlayIsSibling, oOverlay){
			return this._isEditableByPlugin(oOverlay, bOverlayIsSibling);
		},

		isEnabled: function(bOverlayIsSibling, oOverlay){
			var oParentOverlay;
			var bIsEnabled;
			if (bOverlayIsSibling) {
				oParentOverlay = oOverlay.getParentElementOverlay();
				if (oParentOverlay && this.hasStableId(oParentOverlay)) {
					bIsEnabled = true;
				} else {
					bIsEnabled = false;
				}
			} else {
				var mActions = this._getActions(bOverlayIsSibling, oOverlay);
				if (mActions.reveal && mActions.reveal.elements.length === 0 && !mActions.addODataProperty){
					bIsEnabled = false;
				} else {
					bIsEnabled = true;
				}
			}

			return bIsEnabled && this.isMultiSelectionInactive.call(this, oOverlay);
		},

		_getRevealActions: function(bSibling, oOverlay) {
			var mParents = _getParents(bSibling, oOverlay);
			var mReveal = this._getTypes(mReveal, mParents, bSibling, oOverlay);
			return mReveal;
		},

		_getTypes: function(mReveal, mParents, bSibling, oOverlay) {
			var aParents = [mParents.parentOverlay];
			var oRelevantContainer = oOverlay.getRelevantContainer(!bSibling);
			if (oRelevantContainer !== mParents.parent){
				aParents = ElementUtil.findAllSiblingsInContainer(mParents.parent, oRelevantContainer).map(function(oParent){
					return OverlayRegistry.getOverlay(oParent);
				});
			}
			var aAggregationNames;
			if (bSibling){
				aAggregationNames = [oOverlay.getParentAggregationOverlay().getAggregationName()];
			} else {
				aAggregationNames = mParents.parentOverlay.getAggregationOverlays().filter(function(oAggregationOverlay){
					return !oAggregationOverlay.getDesignTimeMetadata().isIgnored(mParents.parent);
				}).map(function(oAggregationOverlay){
					return oAggregationOverlay.getAggregationName();
				});
			}
			mReveal = aAggregationNames.reduce(this._getRevealActionFromAggregations.bind(this, aParents), {});
			return mReveal;
		},

		_getRevealActionFromAggregations: function(aParents, _mReveal, sAggregationName){
			var aInvisibleElements = aParents.reduce(function(aInvisibleChilden, oParentOverlay){
				return oParentOverlay ? aInvisibleChilden.concat(_getInvisibleElements.call(this, oParentOverlay, sAggregationName)) : aInvisibleChilden;
			}.bind(this), []);

			var fnCallback = function(mTypes, oElement){
				var sType = oElement.getMetadata().getName();
				if (!mTypes[sType]){
					//TODO Fix if we have the stashed type info
					if (sType === "sap.ui.core._StashedControl"){
						mTypes[sType] = _fakeStashedControlInfos();
					} else {
						var oOverlay = OverlayRegistry.getOverlay(oElement);
						if (oOverlay) {
							var oDesignTimeMetadata = oOverlay.getDesignTimeMetadata();
							var mRevealAction = oDesignTimeMetadata && oDesignTimeMetadata.getAction("reveal", oElement);
							if (mRevealAction && mRevealAction.changeType) {
								if (mRevealAction.changeOnRelevantContainer) {
									oElement = oOverlay.getRelevantContainer();
								}
								if (this.hasChangeHandler(mRevealAction.changeType, oElement)) {
									if (!mRevealAction.getAggregationName){
										mRevealAction.getAggregationName = _defaultGetAggregationName;
									}
									mTypes[sType] = {
										designTimeMetadata : oDesignTimeMetadata,
										action : mRevealAction
									};
								}
							}
						}
					}
				}
				return mTypes;
			};

			var mTypes = aInvisibleElements.reduce(fnCallback.bind(this), {});

			aInvisibleElements = aInvisibleElements.filter(function(oElement) {
				return !!mTypes[oElement.getMetadata().getName()];
			});

			if (aInvisibleElements.length > 0 && Object.keys(mTypes).length > 0){
				_mReveal[sAggregationName] = {
					reveal : {
						elements : aInvisibleElements,
						types : mTypes
					}
				};
			}
			return _mReveal;
		},

		_getAddODataPropertyActions: function(bSibling, oOverlay) {
			var mParents = _getParents(bSibling, oOverlay);

			var oDesignTimeMetadata = mParents.parentOverlay.getDesignTimeMetadata();
			var aActions = oDesignTimeMetadata.getAggregationAction("addODataProperty", mParents.parent);

			var oCheckElement = mParents.parent;

			var fnCallback = function(_mAddODataProperty, mAction){
				if (mAction) {
					if (mAction.changeOnRelevantContainer){
						oCheckElement = mParents.relevantContainer;
					}
					if (mAction.changeType && this.hasChangeHandler(mAction.changeType, oCheckElement)) {
						_mAddODataProperty[mAction.aggregation] = {
							addODataProperty : {
								designTimeMetadata : oDesignTimeMetadata,
								action : mAction
							}
						};
					}
					return _mAddODataProperty;
				}
			};

			if (aActions && aActions.length > 0){
				return aActions.reduce(fnCallback.bind(this), {});
			}

		},

		_getActions: function(bSibling, oOverlay) {
			var mRevealActions = this._getRevealActions(bSibling, oOverlay);
			var mAddODataPropertyActions = this._getAddODataPropertyActions(bSibling, oOverlay);

			//join and condense both action data
			var mOverall = jQuery.extend(true, mRevealActions, mAddODataPropertyActions);
			var aAggregationNames = Object.keys(mOverall);
			if (aAggregationNames.length === 0){
				return {};
			} else if (aAggregationNames.length > 1){
				jQuery.sap.log.error("reveal or addODataProperty action defined for more than 1 aggregation, that is not yet possible");
			}
			var sAggregationName = aAggregationNames[0];
			mOverall[sAggregationName].aggregation = sAggregationName;
			return mOverall[sAggregationName];
		},

		// _getRevealActions for isEditable check
		_hasRevealActionsOnChildren: function(oOverlay){
			var mRevealActions = this._getRevealActions(false, oOverlay);
			return !!mRevealActions && Object.keys(mRevealActions).length > 0;
		},

		showAvailableElements: function(bOverlayIsSibling, aOverlays, iIndex, sControlName) {
			var oOverlay = aOverlays[0];
			var mParents = _getParents(bOverlayIsSibling, oOverlay);
			var oSiblingElement = bOverlayIsSibling && oOverlay.getElementInstance();
			var aPromises = [];

			var mActions = this._getActions(bOverlayIsSibling, oOverlay);
			if (mActions.reveal) {
					aPromises.push(this.getAnalyzer().enhanceInvisibleElements(mParents.parent, mActions));
			}
			if (mActions.addODataProperty) {
				mActions.addODataProperty.relevantContainer = oOverlay.getRelevantContainer(!bOverlayIsSibling);
				aPromises.push(this.getAnalyzer().getUnboundODataProperties(mParents.parent, mActions.addODataProperty));
			}
			if (mActions.aggregation || sControlName) {
				this._setDialogTitle(mActions, mParents.parent, sControlName);
			}

			return Promise.resolve().then(function(){
				if (mActions.addODataProperty){
					return Utils.isServiceUpToDate(mParents.parent);
				}
			}).then(function() {
				if (mActions.addODataProperty){
					this.getDialog()._oCustomFieldButton.setVisible(true);
					return Utils.isCustomFieldAvailable(mParents.parent);
				} else {
					this.getDialog()._oCustomFieldButton.setVisible(false);
				}
			}.bind(this)).then(function(oCurrentFieldExtInfo) {
				if (oCurrentFieldExtInfo) {
					this._oCurrentFieldExtInfo = oCurrentFieldExtInfo;
					this.getDialog().setCustomFieldEnabled(true);
					this.getDialog().detachEvent('openCustomField', this._onOpenCustomField, this);
					this.getDialog().attachEvent('openCustomField', null, this._onOpenCustomField, this);
				}
			}.bind(this)).then(
				_getAllElements.bind(null, aPromises)
			).then(function(aAllElements){
				this.getDialog().setElements(aAllElements);

				return this.getDialog().open().then(function() {
					this._createCommands(bOverlayIsSibling, oOverlay, mParents, oSiblingElement, mActions.designTimeMetadata, mActions, iIndex);
				}.bind(this)).catch(function(oError){
					//no error means canceled dialog
					if (oError instanceof Error){
						throw oError;
					}
				});
			}.bind(this)).catch(function(oError){
				if (oError instanceof Error){
					throw oError;
				} else {
					jQuery.sap.log.info("Service not up to date, skipping add dialog", "sap.ui.rta");
				}
			});
		},

		_setDialogTitle : function(mActions, oParentElement, sControlName){
			var sDialogTitle = _getText("HEADER_ADDITIONAL_ELEMENTS", mActions, oParentElement, PLURAL, sControlName);
			this.getDialog().setTitle(sDialogTitle);
			if (sControlName) {
				this.getDialog()._oList.setNoDataText(this.getDialog()._oTextResources.getText("MSG_NO_FIELDS", sControlName.toLowerCase()));
			}
		},

		/**
		 * Function called when custom field button was pressed
		 *
		 * @param {sap.ui.base.Event}
		 *		  oEvent event object
		 */
		_onOpenCustomField : function (oEvent) {
			// open field ext ui
			var oCrossAppNav = sap.ushell && sap.ushell.Container
			&& sap.ushell.Container.getService("CrossApplicationNavigation");
			var sHrefForFieldExtensionUi = (oCrossAppNav && oCrossAppNav.hrefForExternal({
				target : {
					semanticObject : "CustomField",
					action : "develop"
				},
				params : {
					businessContexts : this._oCurrentFieldExtInfo.BusinessContexts,
					serviceName : this._oCurrentFieldExtInfo.ServiceName,
					serviceVersion : this._oCurrentFieldExtInfo.ServiceVersion,
					entityType : this._oCurrentFieldExtInfo.EntityType
				}
			}));
			Utils.openNewWindow(sHrefForFieldExtensionUi);
		},

		_createCommands : function(bSibling, oOverlay, mParents, oSiblingElement, oDesignTimeMetadata, mActions, iIndex) {

			var aSelectedElements = this.getDialog().getSelectedElements();

			if (aSelectedElements.length > 0) {
				//at least one element selected
				var oCompositeCommand = this.getCommandFactory().getCommandFor(mParents.parent, "composite");
				aSelectedElements.forEach(function(oSelectedElement){
					var oCmd;
					switch (oSelectedElement.type) {
						case "invisible":
							oCmd = this._createRevealCommandForInvisible(oSelectedElement, mActions, mParents, oSiblingElement);
							oCompositeCommand.addCommand(oCmd);

							oCmd = this._createMoveCommandForInvisible(oSelectedElement, mActions, mParents, oSiblingElement, iIndex);
							if (oCmd) {
								oCompositeCommand.addCommand(oCmd);
							} else {
								jQuery.sap.log.warning("No move action configured for " + mParents.parent.getMetadata().getName() + ", aggregation: " + mActions.aggregation , "sap.ui.rta");
							}

							break;
						case "odata":
							var oParentAggregationOverlay = mParents.parentOverlay.getAggregationOverlay(mActions.aggregation);
							var oParentAggregationDTMetadata = oParentAggregationOverlay.getDesignTimeMetadata();
							var mODataPropertyActionDTMetadata = oParentAggregationDTMetadata.getAction("addODataProperty", mParents.parent);
							var mChangeHandlerSettings = mODataPropertyActionDTMetadata.changeHandlerSettings;
							var mRequiredLibraries;
							if (mChangeHandlerSettings && mChangeHandlerSettings.content){
								mRequiredLibraries = mChangeHandlerSettings.content.requiredLibraries;
							}
							if (mRequiredLibraries){
								var oCmdDesc = this._createCommandForAddLibrary(mParents, mActions, mRequiredLibraries, oParentAggregationDTMetadata);
								oCompositeCommand.addCommand(oCmdDesc);
							}
							oCmd = this._createCommandsForOData(oSelectedElement, mActions, mParents, oSiblingElement, iIndex);
							oCompositeCommand.addCommand(oCmd);
							break;
						default:
							jQuery.sap.log.error("Can't create command for untreated element.type " + oSelectedElement.type);
					}
				}, this);
				this.fireElementModified({
					"command" : oCompositeCommand
				});
			}
		},

		_createCommandsForOData: function(oSelectedElement, mActions, mParents, oSiblingElement, iIndex) {
			var oParentAggregationOverlay = mParents.parentOverlay.getAggregationOverlay(mActions.aggregation);
			var oParentAggregationDTMetadata = oParentAggregationOverlay.getDesignTimeMetadata();
			var mODataPropertyActionDTMetadata = oParentAggregationDTMetadata.getAction("addODataProperty", mParents.parent);
			var mChangeHandlerSettings = mODataPropertyActionDTMetadata.changeHandlerSettings;
			var sODataServiceVersion;
			if (mChangeHandlerSettings && mChangeHandlerSettings.key){
				sODataServiceVersion = mChangeHandlerSettings.key.oDataServiceVersion;
			}
			var oRefControlForId = mParents.parent; //e.g. SmartForm
			if (mODataPropertyActionDTMetadata.changeOnRelevantContainer) {
				oRefControlForId = mParents.relevantContainer; //e.g. SimpleForm
			}
			var iAddTargetIndex = Utils.getIndex(mParents.parent, oSiblingElement, mActions.aggregation, oParentAggregationDTMetadata.getData().getIndex);
			var oChangeHandler = this._getChangeHandlerForControlType(mParents.parent.getMetadata().getName(), mODataPropertyActionDTMetadata.changeType);
			var sVariantManagementReference;
			if (mParents.parentOverlay.getVariantManagement && oChangeHandler && oChangeHandler.revertChange) {
				sVariantManagementReference = mParents.parentOverlay.getVariantManagement();
			}
			return this.getCommandFactory().getCommandFor(mParents.parent, "addODataProperty", {
				newControlId: Utils.createFieldLabelId(oRefControlForId, oSelectedElement.entityType, oSelectedElement.bindingPath),
				index: iIndex !== undefined ? iIndex : iAddTargetIndex,
				bindingString: oSelectedElement.bindingPath,
				entityType: oSelectedElement.entityType,
				parentId: mParents.parent.getId(),
				oDataServiceVersion: sODataServiceVersion
			}, oParentAggregationDTMetadata, sVariantManagementReference);
		},

		_createCommandForAddLibrary: function(mParents, mActions, mRequiredLibraries, oParentAggregationDTMetadata){
			var oComponent = FlUtils.getAppComponentForControl(mParents.relevantContainer);
			var mManifest = oComponent.getManifest();
			var sReference = mManifest["sap.app"].id;
			return this.getCommandFactory().getCommandFor(mParents.publicParent, "addLibrary", {
				reference : sReference,
				parameters : { libraries : mRequiredLibraries },
				appComponent: oComponent
			}, oParentAggregationDTMetadata);
		},

		_createRevealCommandForInvisible: function(oSelectedElement, mActions, mParents, oSiblingElement) {
			var oRevealedElement = oSelectedElement.element;
			var oRevealedElementOverlay = OverlayRegistry.getOverlay(oRevealedElement);
			var sType = oRevealedElement.getMetadata().getName();
			var mType = mActions.reveal.types[sType];
			var oDesignTimeMetadata = mType.designTimeMetadata;
			var oRevealAction = oDesignTimeMetadata.getAction("reveal", oRevealedElement);
			var oElementOverlay = OverlayRegistry.getOverlay(oRevealedElement);

			//Parent Overlay passed as argument as no overlay is yet available for stashed control
			if	(!oElementOverlay) {
				var oSourceParent = _getSourceParent(oRevealedElement, mParents, oRevealedElementOverlay);
				oElementOverlay = OverlayRegistry.getOverlay(oSourceParent);
			}

			var sVariantManagementReference;
			if (oElementOverlay) {
				sVariantManagementReference = this.getVariantManagementReference(oElementOverlay, oRevealAction, false, oRevealedElement);
			}

			if (oRevealAction.changeOnRelevantContainer) {
				return this.getCommandFactory().getCommandFor(oRevealedElement, "reveal", {
					revealedElementId : oRevealedElement.getId(),
					directParent : mParents.parent
				}, oDesignTimeMetadata, sVariantManagementReference);
			} else {
				return this.getCommandFactory().getCommandFor(oRevealedElement, "reveal", { }, oDesignTimeMetadata, sVariantManagementReference);
			}
		},

		_createMoveCommandForInvisible: function(oSelectedElement, mActions, mParents, oSiblingElement, iIndex) {
			var oRevealedElement = oSelectedElement.element;
			var oRevealedElementOverlay = OverlayRegistry.getOverlay(oRevealedElement);
			var sType = oRevealedElement.getMetadata().getName();
			var sParentAggregationName;
			if (oRevealedElementOverlay) {
				sParentAggregationName = oRevealedElementOverlay.getParentAggregationOverlay().getAggregationName();
			} else {
				// stashed control is not in DOM tree and therefore has no overlay
				var mType = mActions.reveal.types[sType];
				sParentAggregationName = mType.action.getAggregationName(mParents.parent, oRevealedElement);
			}
			var oSourceParent = _getSourceParent(oRevealedElement, mParents, oRevealedElementOverlay);
			var oTargetParent = mParents.parent;
			var iRevealTargetIndex = Utils.getIndex(mParents.parent, oSiblingElement, sParentAggregationName);
			var iRevealedSourceIndex = Utils.getIndex(oSourceParent, oRevealedElement, sParentAggregationName) - 1;

			iRevealTargetIndex = iIndex !== undefined ? iIndex : _adjustTargetIndex(oSourceParent, oTargetParent, iRevealedSourceIndex, iRevealTargetIndex);

			var oCmd;
			if (iRevealTargetIndex !== iRevealedSourceIndex || mParents.parent !== oRevealedElement.getParent()){
				var oSourceParentOverlay = OverlayRegistry.getOverlay(oRevealedElement) ? OverlayRegistry.getOverlay(oRevealedElement).getParentAggregationOverlay() : mParents.relevantContainerOverlay;
				var SourceParentDesignTimeMetadata = oSourceParentOverlay.getDesignTimeMetadata();
				var oMoveAction = SourceParentDesignTimeMetadata.getAction("move", oRevealedElement);
				var sVariantManagementReference;
				if (oMoveAction) {
					sVariantManagementReference = this.getVariantManagementReference(OverlayRegistry.getOverlay(oRevealedElement), oMoveAction, true);
				}
				oCmd = this.getCommandFactory().getCommandFor(mParents.relevantContainer, "move", {
					movedElements : [{
						element : oRevealedElement,
						sourceIndex : iRevealedSourceIndex,
						targetIndex : iRevealTargetIndex
					}],
					source : {
						publicParent : mParents.relevantContainer,
						parent : oSourceParent,
						aggregation : sParentAggregationName
					},
					target : {
						publicParent : mParents.relevantContainer,
						parent : oTargetParent,
						aggregation : sParentAggregationName
					}
				}, SourceParentDesignTimeMetadata, sVariantManagementReference);
			}
			return oCmd;
		},

		/**
		 * This function gets called on startup. It checks if the Overlay is editable by this plugin.
		 * @param {sap.ui.dt.Overlay} oOverlay - overlay to be checked
		 * @returns {object} Returns object with editable boolean values for "asChild" and "asSibling"
		 * @protected
		 */
		_isEditable: function(oOverlay) {
			return {
				asSibling: this._isEditableCheck.call(this, oOverlay, true),
				asChild: this._isEditableCheck.call(this, oOverlay, false)
			};
		},

		_isEditableCheck: function(oOverlay, bOverlayIsSibling) {
			var bEditable = false;

			var oRelevantContainerDesigntimeMetadata = Utils.getRelevantContainerDesigntimeMetadata(oOverlay);
			if (!oRelevantContainerDesigntimeMetadata) {
				return false;
			}

			var mActions = this._getActions(bOverlayIsSibling, oOverlay);
			var mParents = _getParents(bOverlayIsSibling, oOverlay);

			if (mActions.addODataProperty) {
				var oAddODataPropertyAction = mActions.addODataProperty.action;
				bEditable = oAddODataPropertyAction && oAddODataPropertyAction.aggregation === oOverlay.getParentAggregationOverlay().getAggregationName();
			}

			if (!bEditable && mActions.reveal) {
				bEditable = true;
			}

			if (!bEditable && !bOverlayIsSibling) {
				bEditable = this._hasRevealActionsOnChildren(oOverlay) ||
					this.checkAggregationsOnSelf(mParents.parentOverlay, "addODataProperty");
			}

			if (bEditable) {
				return this.hasStableId(oOverlay);
			} else {
				return false;
			}
		},

		/**
		 * Retrieve the context menu item for the actions.
		 * Two items are returned here: one for when the overlay is sibling and one for when it is child.
		 * @param  {sap.ui.dt.ElementOverlay} oOverlay Overlay for which the context menu was opened
		 * @return {object[]}          Returns array containing the items with required data
		 */
		getMenuItems: function(oOverlay){
			var bOverlayIsSibling = true;
			var sPluginId = "CTX_ADD_ELEMENTS_AS_SIBLING";
			var iRank = 20;
			var aMenuItems = [];
			for (var i = 0; i < 2; i++){
				if (this.isAvailable(bOverlayIsSibling, oOverlay)){
					var sMenuItemText = this.getContextMenuTitle.bind(this, bOverlayIsSibling);

					aMenuItems.push({
						id: sPluginId,
						text: sMenuItemText,
						handler: function(bOverlayIsSibling, aOverlays){
							// showAvailableElements has optional parameters, so currying is not possible here
							return this.showAvailableElements(bOverlayIsSibling, aOverlays);
						}.bind(this, bOverlayIsSibling),
						enabled: this.isEnabled.bind(this, bOverlayIsSibling),
						rank: iRank
					});
				}

				bOverlayIsSibling = false;
				sPluginId = "CTX_ADD_ELEMENTS_AS_CHILD";
				iRank = 30;
			}
			return aMenuItems;
		}
	});

	function _getAllElements (aPromises) {
		return Promise.all(aPromises).then(function(aAnalyzerValues) {
			var aAllElements = aAnalyzerValues[0] || [];
			if (aAllElements && aAnalyzerValues[1]) {
				aAllElements = aAllElements.concat(aAnalyzerValues[1]);
			}
			return aAllElements;
		});
	}

	function _getSourceParent(oRevealedElement, mParents, oRevealedElementOverlay){
		var oParent;
		if (oRevealedElementOverlay) {
			oParent = oRevealedElementOverlay.getParentElementOverlay().getElementInstance();
		}
		if (!oParent && oRevealedElement.sParentId){
			//stashed control has no parent, but remembers its parent id
			oParent = sap.ui.getCore().byId(oRevealedElement.sParentId);
		} else if (!oParent) {
			// fallback to target parent
			oParent = mParents.parent;
		}
		return oParent;
	}

	//in case an element is moved inside the same container above its current position, its own position has to be removed
	function _adjustTargetIndex (oSourceContainer, oTargetContainer, iSourceIndex, iTargetIndex) {
		if (oSourceContainer === oTargetContainer && iSourceIndex < iTargetIndex && iSourceIndex > -1) {
			return iTargetIndex - 1;
		}
		return iTargetIndex;
	}

	return AdditionalElementsPlugin;
});

}; // end of sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.toolbar.BaseRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.toolbar.BaseRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.m.ToolbarRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/toolbar/BaseRenderer",[
	'sap/ui/core/Renderer',
	'sap/m/ToolbarRenderer'
],
function(
	Renderer,
	ToolbarRenderer
) {
	"use strict";

	var BaseRenderer = Renderer.extend('sap.ui.rta.toolbar.BaseRenderer', ToolbarRenderer);

	BaseRenderer.decorateRootElement = function (oRM, oControl) {
		// base CSS classes
		oRM.addClass('sapUiRtaToolbar');
		oRM.addClass('sapContrastPlus'); // for 'sap_belize_plus' theme
		oRM.addClass("color_" + oControl.getColor());

		// setting type if exists
		oControl.type && oRM.addClass("type_" + oControl.type);

		// setting z-index if exists
		var iZIndex = oControl.getZIndex();
		iZIndex && oRM.addStyle("z-index", iZIndex);

		ToolbarRenderer.decorateRootElement(oRM, oControl);
	};


	return BaseRenderer;
});

}; // end of sap/ui/rta/toolbar/BaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.util.Animation') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.util.Animation'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/util/Animation",[
	'jquery.sap.global'
],
function(jQuery) {
	"use strict";

	var module = {};

	/**
	 * CSS Transition helper
	 * @param {jQuery} $element - jQuery element(s)
	 * @param {Function} fnCallback - The function should start animation process (e.g. by adding class to the element)
	 * @return {Promise} Returns a Promise performing the animation
	 */
	module.waitTransition = function ($element, fnCallback) {
		if (!($element instanceof jQuery)) {
			throw new Error('$element should be wrapped into jQuery object');
		}
		if (!jQuery.isFunction(fnCallback)) {
			throw new Error('fnCallback should be a function');
		}

		return new Promise(function (fnResolve) {
			$element.one('transitionend', fnResolve);

			// perform animation in the next animation frame, normally 16-17ms later.
			var iTimestampInitial;
			var fnAnimCallback = function (iTimestamp) {
				if (!iTimestampInitial) {
					iTimestampInitial = iTimestamp;
				}
				if (iTimestamp !== iTimestampInitial) {
					fnCallback();
				} else {
					window.requestAnimationFrame(fnAnimCallback);
				}
			};
			window.requestAnimationFrame(fnAnimCallback);
		});
	};

	return module;
}, true);

}; // end of sap/ui/rta/util/Animation.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.util.BindingsExtractor') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.util.BindingsExtractor'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.dt.ElementUtil'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/util/BindingsExtractor",[
	'sap/ui/dt/ElementUtil',
	'sap/ui/rta/Utils'
],
function(
	ElementUtil,
	RtaUtils
) {
	"use strict";

	/**
	 * Gets bindings for the whole hierarchy of children for a specified Element
	 * and filters out bindings which are not relevant (based on the parent model)
	 *
	 * @param {sap.ui.core.Control} oElement - Starting point of the search
	 * @param {sap.ui.model.Model} oParentDefaultModel - Model for filtering irrelevant binding paths
	 * @param {boolean} bTemplate - Whether we should consider provided element as a template
	 *
	 * @returns {Array} - returns array with all relevant bindings for all properties of the element
	 *
	 * @private
	 */
	function getBindings(oElement, oParentDefaultModel, bTemplate) {
		var aBindings = (
			bTemplate
			? getBindingsFromTemplateProperties(oElement)
			: getBindingsFromProperties(oElement, oParentDefaultModel)
		);

		// Iterate through all aggregations
		for (var sAggregationName in oElement.getMetadata().getAllAggregations()) {
			// Getting children of the current aggregation and iterating through all of them
			var oBinding = oElement.getBindingInfo(sAggregationName);
			var oTemplate = oBinding && oBinding.template;
			var aElements = oTemplate ? [oTemplate] : ElementUtil.getAggregation(oElement, sAggregationName);

			aElements.forEach(function (oChildElement) { // eslint-disable-line no-loop-func
				if (oChildElement.getMetadata) {
					// Fetching bindings from Element and all children of Element
					aBindings = aBindings.concat(
						oTemplate || bTemplate
						? getBindingsFromTemplateProperties(oChildElement)
						: getBindingsFromProperties(oChildElement, oParentDefaultModel),
						getBindings(oChildElement, oParentDefaultModel, oTemplate || bTemplate)
					);
				}
			});
		}

		return aBindings;
	}

	/**
	 * Fetches all bindings for a specified binding model
	 *
	 * @param {sap.ui.model.PropertyBinding} oBinding - Binding model to get paths from
	 * @param {sap.ui.model.odata.XX.ODataModel} oParentDefaultModel - Data model (XX = '', v2, v4...)
	 *
	 * @returns {Array} - Returns a flattened array of found bindings
	 *
	 * @private
	 */
	function flattenBindings(oBinding, oParentDefaultModel) {
		var aBindings = [];
		var sModelName = oBinding.getMetadata().getName();

		if (sModelName === "sap.ui.model.CompositeBinding") {
			oBinding.getBindings().forEach(function (oBinding) {
				aBindings = aBindings.concat(flattenBindings(oBinding, oParentDefaultModel));
			});
		} else if (
			(
				sModelName === "sap.ui.model.odata.ODataPropertyBinding"
				|| sModelName === "sap.ui.model.odata.v2.ODataPropertyBinding"
				|| sModelName === "sap.ui.model.odata.v4.ODataPropertyBinding"
				|| sModelName === "sap.ui.model.json.JSONPropertyBinding"
				|| sModelName === "sap.ui.model.json.XMLPropertyBinding"
				|| sModelName === "sap.ui.model.resource.ResourcePropertyBinding"
			)
			&& oBinding.getModel() === oParentDefaultModel
			&& oBinding.isRelative()
			&& jQuery.isFunction(oBinding.getPath)
			&& oBinding.getPath()
		) {
			aBindings.push(oBinding);
		}

		return aBindings;
	}

	/**
	 * Fetches all bindings from template
	 *
	 * @param {object} mBinding - map of bindings from Control (mBindingsInfo)
	 * @returns {Array} - Returns a flattened array of found bindings
	 * @private
	 */
	function flattenBindingsFromTemplate(mBinding) {
		var aBindings = [];
		var aParts = mBinding.parts;

		// TODO: check if we need to filter bindings by modelName, relative indicator ("/")
		aParts.forEach(function (mPart) {
			aBindings.push({
				parts: [mPart]
			});
		});

		return aBindings;
	}

	/**
	 * Retrieving all bindings from all available properties for a specified element
	 *
	 * @param {sap.ui.core.Control} oElement - element to get bindings from
	 * @param {sap.ui.model.Model} oParentDefaultModel - parent model to filter irrelevant bindings
	 *
	 * @return {Array} - returns found bindings
	 *
	 * @private
	 */
	function getBindingsFromProperties(oElement, oParentDefaultModel) {
		var aPropertiesKeys = Object.keys(oElement.getMetadata().getAllProperties());

		return aPropertiesKeys
			// filter properties which are not bound
			.filter(oElement.getBinding.bind(oElement))
			.reduce(function (aBindings, sPropertyName) {
				return aBindings.concat(
					flattenBindings(
						oElement.getBinding(sPropertyName),
						oParentDefaultModel
					)
				);
			}, []);
	}

	/**
	 * Retrieving all bindings from all available properties for a specified element of template
	 *
	 * @param {sap.ui.core.Control} oElement - element to get bindings from
	 * @return {Array} - returns found bindings
	 * @private
	 */
	function getBindingsFromTemplateProperties(oElement) {
		var aPropertiesKeys = Object.keys(oElement.getMetadata().getAllProperties());

		return aPropertiesKeys
			.filter(function (sPropertyName) {
				return sPropertyName in oElement.mBindingInfos;
			})
			.reduce(function (aBindings, sPropertyName) {
				return aBindings.concat(
					flattenBindingsFromTemplate(
						oElement.mBindingInfos[sPropertyName]
					)
				);
			}, []);
	}

	return {
		getBindings: getBindings,
		flattenBindings: flattenBindings,
		getBindingsFromProperties: getBindingsFromProperties
	};
}, true);

}; // end of sap/ui/rta/util/BindingsExtractor.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.util.PopupManager') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.util.PopupManager'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.m.Dialog'); // unlisted dependency retained
jQuery.sap.require('sap.m.Popover'); // unlisted dependency retained
jQuery.sap.require('sap.m.InstanceManager'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.Overlay'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ComponentContainer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/util/PopupManager",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject',
	'sap/m/Dialog',
	'sap/m/Popover',
	'sap/m/InstanceManager',
	'sap/ui/core/Popup',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/dt/Overlay',
	'sap/ui/fl/Utils',
	'sap/ui/core/Component',
	'sap/ui/core/ComponentContainer',
	'sap/ui/core/Element'
],
function (
	jQuery,
	ManagedObject,
	Dialog,
	Popover,
	InstanceManager,
	Popup,
	OverlayRegistry,
	Overlay,
	flUtils,
	Component,
	ComponentContainer,
	Element
) {
	"use strict";

	var FOCUS_EVENT_NAMES = {
		"add": "_activateFocusHandle",
		"remove": "_deactivateFocusHandle"
	};

	/**
	 * Constructor for a new sap.ui.rta.util.PopupManager
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.rta.util.PopupManager
	 * @experimental Since 1.48. This class is experimental and provides only limited functionality. Also the API might
	 *               be changed in future.
	 */
	var PopupManager = ManagedObject.extend("sap.ui.rta.util.PopupManager", {
		metadata : {
			properties : {
				rta:  "any"
			},
			associations : {
				/**
				 * To set the associated controls as an autoCloseArea for all sap.m.Popover/sap.m.Dialog open in RTA mode.
				 * Needs to be filled before the popup is open.
				 */
				autoCloseAreas : {type : "sap.ui.core.Control", multiple : true, singularName : "autoCloseArea"}
			},
			events : {
				open: {
					parameters : {
						oControl : {type : "sap.ui.core.Control"}
					}
				},
				close: {
					parameters : {
						oControl : {type : "sap.ui.core.Control"}
					}
				}
			},
			library : "sap.ui.rta"
		}
	});

	/**
	 * Checks if popups are open on the screen
	 * Overrides the AddDialogInstance/AddPopoverInstance and RemoveDialogInstance/RemovePopoverInstance methods for Instance Manager
	 * for dynamic overlay creation of popups.
	 *
	 * @private
	 */
	PopupManager.prototype._overrideInstanceFunctions = function() {

		//check open popups and create overlays while starting RTA
		this._applyPopupMethods(this._createPopupOverlays);

		//override InstanceManager.AddDialogInstance() and InstanceManager.AddPopoverInstance()
		this._overrideAddPopupInstance();

		//override InstanceManager.RemoveDialogInstance()  and InstanceManager.RemovePopoverInstance()
		this._overrideRemovePopupInstance();
	};

	/**
	 * Retrieve relevant open popups for dynamic overlay creation.
	 *
	 * @returns {any} Returns open popups
	 * @public
	 */
	PopupManager.prototype.getRelevantPopups = function() {
		var aOpenDialogs, aOpenPopovers;

		//check if dialogs are already open when RTA is started
		aOpenDialogs = InstanceManager.getOpenDialogs();

		//check if popovers are already open when RTA is started
		aOpenPopovers = InstanceManager.getOpenPopovers();

		var oRelevantPopups = {
			aDialogs: this._getValidatedPopups(aOpenDialogs),
			aPopovers: this._getValidatedPopups(aOpenPopovers)
		};
		return oRelevantPopups;
	};

	/**
	 * Retrieves array of validated popups after component comparison: <code>this.oRtaRootAppComponent.oContainer.getParent()</code>.
	 *
	 * @param {sap.ui.core.Popup[]} aOpenPopups Specifies open popups
	 * @returns {sap.ui.core.Popup[]|boolean} Returns relevant popups or false
	 * @private
	 */
	PopupManager.prototype._getValidatedPopups = function(aOpenPopups) {
		aOpenPopups = aOpenPopups.filter(function(oPopup) {
				return this._isPopupAdaptable(oPopup);
			}.bind(this));

		return (aOpenPopups.length > 0) ? aOpenPopups : false;
	};

	/**
	 * Check if app component is inside a popup
	 *
	 * @param {sap.ui.core.Control} oPopup popup element
	 * @returns {boolean} indicating if component is inside a popup
	 * @private
	 */
	PopupManager.prototype._isComponentInsidePopup = function(oPopup) {
		//check if root RTA component is directly inside a popupElement
		return jQuery.isArray(oPopup.getContent())
			? oPopup.getContent().some(
				function(oContent) {
					if (oContent instanceof ComponentContainer) {
						return this.oRtaRootAppComponent === this._getAppComponentForControl(sap.ui.getCore().getComponent(oContent.getComponent()));
					}
				}.bind(this))
			: false;
	};

	/**
	 * Check if the passed control is a supported popup
	 *
	 * @param {sap.ui.core.Control} oPopup popup element
	 * @returns {boolean} indicating if this type of popup element is supported
	 * @private
	 */
	PopupManager.prototype._isSupportedPopup = function(oPopup) {
		return (oPopup instanceof sap.m.Dialog || oPopup instanceof sap.m.Popover);
	};

	/**
	 * Overrides the setter function of property rta for dynamic overlay creation
	 *
	 * @param {sap.ui.rta.RuntimeAuthoring} oRta RuntimeAuthoring object
	 * @public
	 */
	PopupManager.prototype.setRta = function(oRta) {
		if (oRta && oRta._oDesignTime) {
			this.setProperty("rta", oRta);
			var oRootControl = sap.ui.getCore().byId(oRta.getRootControl());
			this.oRtaRootAppComponent = this._getAppComponentForControl(oRootControl);
			this._overrideInstanceFunctions();

			//listener for RTA mode change
			var fnModeChange = this._onModeChange.bind(this);
			oRta.attachModeChanged(fnModeChange);
		}
	};

	/**
	 * Attached to RTA mode change
	 * @param  {sap.ui.base.Event} oEvent The Event triggered by the mode change
	 */
	PopupManager.prototype._onModeChange = function(oEvent) {
		var sFocusEvent, sNewMode = oEvent.getParameters().mode;

		var fnApplyFocusEvent = function (oPopover) {
			oPopover.oPopup[sFocusEvent]();
		};

		if (sNewMode === 'navigation') {
			sFocusEvent = this._getFocusEventName("add");
			this._applyFocusEventsToOpenPopups(fnApplyFocusEvent);
		} else {
			sFocusEvent = this._getFocusEventName("remove");
			this._removeFocusEventsFromOpenPopups(fnApplyFocusEvent);
		}
	};

	/**
	 * Apply focus events to all open popups and set focus on the first.
	 * @param {function} fnFocusEvent Function to apply to open popups
	 * @private
	 */
	PopupManager.prototype._applyFocusEventsToOpenPopups = function(fnFocusEvent) {
		this._applyPopupMethods(fnFocusEvent, true);
	};

	/**
	 * Remove focus events from all open popups.
	 * @param {function} fnFocusEvent Function to apply to open popups
	 * @private
	 */
	PopupManager.prototype._removeFocusEventsFromOpenPopups = function(fnFocusEvent) {
		this._applyPopupMethods(fnFocusEvent);
	};

	/**
	 * Return the popup focus event name.
	 *
	 * @param {string} sOperation Operation name
	 * @returns {string} focus event name
	 * @private
	 */
	PopupManager.prototype._getFocusEventName = function(sOperation) {
		return FOCUS_EVENT_NAMES[sOperation];
	};

	/**
	 * Overrides the AddDialogInstance/AddPopoverInstance for Instance Manager for dynamic overlay creation.
	 *
	 * @private
	 */
	PopupManager.prototype._overrideAddPopupInstance = function() {

		//Dialog
		this._fnOriginalAddDialogInstance = InstanceManager.addDialogInstance;
		InstanceManager.addDialogInstance = this._overrideAddFunctions(this._fnOriginalAddDialogInstance);

		//Popover
		this._fnOriginalAddPopoverInstance = InstanceManager.addPopoverInstance;
		InstanceManager.addPopoverInstance = this._overrideAddFunctions(this._fnOriginalAddPopoverInstance);
	};

	/**
	 * Returns overridden function for AddDialogInstance/AddPopoverInstance of Instance Manager.
	 *
	 * @param {function} fnOriginalFunction original InstanceManager function
	 * @returns {function} overridden function
	 * @private
	 */
	PopupManager.prototype._overrideAddFunctions = function(fnOriginalFunction) {
		return function(oPopupElement) {
			var vOriginalReturn = fnOriginalFunction.apply(InstanceManager, arguments);
			if ( this._isPopupAdaptable(oPopupElement)
				&& this.getRta()._oDesignTime ) {
				oPopupElement.attachAfterOpen(this._createPopupOverlays, this);
				//PopupManager internal method
				this.fireOpen(oPopupElement);
			}
			return vOriginalReturn;
		}.bind(this);
	};

	/**
	 * Applies the passed function to the relevant open popups.
	 *
	 * @param {function} fnPopupMethod specifies function to be applied
	 * @param {boolean} bFocus Set to true if the popup is in focus
	 * @private
	 */
	PopupManager.prototype._applyPopupMethods = function(fnPopupMethod, bFocus) {
		//check if popups are open
		var oRelevantPopups = this.getRelevantPopups();

		//apply passed method to each open popup
		Object.keys(oRelevantPopups).forEach(function(sKey) {
			if (oRelevantPopups[sKey]) {
				if (bFocus) {
					jQuery.sap.focus(oRelevantPopups[sKey][0].oPopup.oContent);
				}
				oRelevantPopups[sKey].forEach(function(oPopupElement) {
					fnPopupMethod.call(this, oPopupElement);
				}.bind(this));
			}
		}.bind(this));
	};

	/**
	 * Modifies browser events for passed popup element
	 *
	 * @param {sap.ui.core.Control} oPopupElement popup element for which browser events have to be modified
	 * @private
	 */
	PopupManager.prototype._applyPopupPatch = function(oPopupElement) {
		var oPopupOverlay = OverlayRegistry.getOverlay(oPopupElement);
		var oOverlayContainer = Overlay.getOverlayContainer(oPopupOverlay);
		var oPopup = oPopupElement.oPopup;
		var aAutoCloseAreas = [
			oPopup.oContent.getDomRef(),
			oOverlayContainer
		].concat(
			this.getAutoCloseAreas()
		);

		if (this.getRta().getShowToolbars()) {
			aAutoCloseAreas.push(this.getRta().getToolbar().getDomRef());
		}
		//If clicked from toolbar or popup - autoClose is disabled
		oPopup.setAutoCloseAreas(aAutoCloseAreas);

		//cases when onAfterRendering is called after this function - app inside popup
		if (!this.fnOriginalPopupOnAfterRendering) {
			this.fnOriginalPopupOnAfterRendering = oPopup.onAfterRendering;
		}
		oPopup.onAfterRendering = function () {
			var vOriginalReturn = this.fnOriginalPopupOnAfterRendering.apply(oPopup, arguments);
			oPopup[this._getFocusEventName("remove")]();
			return vOriginalReturn;
		}.bind(this);

		//only remove focus event when in adaptation mode
		if (this.getRta().getMode() === 'adaptation') {
			oPopup[this._getFocusEventName("remove")]();
		}
	};

	/**
	 * Overrides the RemoveDialogInstance/RemovePopoverInstance methods for Instance Manager for dynamic overlay creation
	 *
	 * @private
	 */
	PopupManager.prototype._overrideRemovePopupInstance = function() {

		//Dialog
		this._fnOriginalRemoveDialogInstance = InstanceManager.removeDialogInstance;
		InstanceManager.removeDialogInstance = this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);

		//Popover
		this._fnOriginalRemovePopoverInstance = InstanceManager.removePopoverInstance;
		InstanceManager.removePopoverInstance = this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance);
	};

	/**
	 * Returns overridden function for RemoveDialogInstance/RemovePopoverInstance of Instance Manager
	 *
	 * @param {function} fnOriginalFunction original InstanceManager function
	 * @returns {function} overridden function
	 * @private
	 */
	PopupManager.prototype._overrideRemoveFunctions = function(fnOriginalFunction) {
		return function(oPopupElement) {
			var vOriginalReturn = fnOriginalFunction.apply(InstanceManager, arguments);

			if ( this._isPopupAdaptable(oPopupElement)
				&& this.getRta()._oDesignTime ) {
				this.getRta()._oDesignTime.removeRootElement(oPopupElement);
				//PopupManager internal method
				this.fireClose(oPopupElement);
			}
			return vOriginalReturn;
		}.bind(this);
	};

	/**
	 * Returns the app component of the passed control is exists
	 *
	 * @param {sap.ui.core.Control} oControl Control object
	 * @returns {object|undefined} component object if exists
	 * @private
	 */
	PopupManager.prototype._getAppComponentForControl = function(oControl) {
		var oComponent, oAppComponent;

		if (oControl instanceof Component) {
			oComponent = oControl;
		} else {
			oComponent = this._getComponentForControl(oControl);
		}

		if (oComponent) {
			oAppComponent = flUtils.getAppComponentForControl(oComponent);
		}
		return oAppComponent;
	};

	/**
	 * Returns the component of the passed control, navigating through control tree, except if parent is sap.ui.core.UIArea
	 *
	 * @param {sap.ui.core.Control} oControl Control object
	 * @returns {object|undefined} component object if exists
	 * @private
	 */
	PopupManager.prototype._getComponentForControl = function(oControl) {
		var oComponent, oRootComponent, oParentControl;
		if (oControl) {
			oComponent = Component.getOwnerComponentFor(oControl);
			if (
				!oComponent
				&& typeof oControl.getParent === "function"
				&& oControl.getParent() instanceof Element
			) {
				oParentControl = oControl.getParent();
			} else if (oComponent) {
				oParentControl = oComponent;
			}

			if (oParentControl) {
				oRootComponent = this._getComponentForControl(oParentControl);
			}
		}

		return oRootComponent ? oRootComponent : oComponent;
	};

	/**
	 * Create popup overlays
	 *
	 * @param {object} oEvent Browser Event or sap.ui.core.Control object
	 * @private
	 */
	PopupManager.prototype._createPopupOverlays = function(oEvent) {
		if (!oEvent) {
			return;
		}
		var oPopupElement = (oEvent instanceof Element) ? oEvent : oEvent.getSource();

		//when application is opened in a popup, rootElement should not be added more than once
		if (
			this.getRta()._oDesignTime.getRootElements().indexOf(oPopupElement.getId()) === -1
			&& !this._isComponentInsidePopup(oPopupElement)
		) {
			this.getRta()._oDesignTime.addRootElement(oPopupElement);
		}

		//detach for persistent popups with same id
		oPopupElement.detachAfterOpen(this._createPopupOverlays, this);

		this._applyPopupPatch(oPopupElement);
	};

	/**
	 * Restores the Instance Manager AddDialogInstance/AddPopoverInstance, RemoveDialogInstance/RemovePopoverInstance methods and default blur event for popups
	 *
	 * @private
	 */
	PopupManager.prototype._restoreInstanceFunctions = function() {
		//Dialog
		if (this._fnOriginalAddDialogInstance) {
			InstanceManager.addDialogInstance = this._fnOriginalAddDialogInstance;
		}
		if (this._fnOriginalRemoveDialogInstance) {
			InstanceManager.removeDialogInstance = this._fnOriginalRemoveDialogInstance;
		}

		//Popover
		if (this._fnOriginalAddPopoverInstance) {
			InstanceManager.addPopoverInstance = this._fnOriginalAddPopoverInstance;
		}
		if (this._fnOriginalRemovePopoverInstance) {
			InstanceManager.removePopoverInstance = this._fnOriginalRemovePopoverInstance;
		}

		this._applyFocusEventsToOpenPopups(this._removePopupPatch);
	};

	/**
	 * Restore default popup settings and give focus.
	 * @param {sap.ui.core.Control} oPopupElement Popup element to remove custom browser events and add default browser events
	 *
	 * @private
	 */
	PopupManager.prototype._removePopupPatch = function(oPopupElement) {
		var oPopup = oPopupElement.oPopup;
		oPopup[this._getFocusEventName("add")]();
		if (this.fnOriginalPopupOnAfterRendering) {
			oPopup.onAfterRendering = this.fnOriginalPopupOnAfterRendering;
		}
	};

	PopupManager.prototype._isPopupAdaptable = function(oPopupElement) {
		var oPopupAppComponent = this._getAppComponentForControl(oPopupElement);

		return (this.oRtaRootAppComponent === oPopupAppComponent || this._isComponentInsidePopup(oPopupElement))
			&& this._isSupportedPopup(oPopupElement);
	};

	/**
	 * Called after PopupManager instance is destroyed.
	 *
	 * @public
	 */
	PopupManager.prototype.exit = function() {
		this._restoreInstanceFunctions();
	};

	return PopupManager;

}, /* bExport= */ true);

}; // end of sap/ui/rta/util/PopupManager.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.util.StylesLoader') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.util.StylesLoader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/util/StylesLoader",[
		'jquery.sap.global'
	],
	function(jQuery) {
		"use strict";

		var module = {};

		/**
		 * Loads styles from the specified file
		 * @param {string} sFileName - Name of the file
		 * @return {jqXHR} - returns jqXHR object which can be thenable
		 */
		module.loadStyles = function (sFileName) {
			return jQuery.get(jQuery.sap.getModulePath('sap.ui.rta.assets.' + sFileName) + '.css')
				.then(function (sData) {
					// TODO: check if it's possible to use UI5 standard mechanism for styles adjustments
					if (sap.ui.getCore().getConfiguration().getRTL()) {
						return sData.replace(/right/g, 'left');
					}
					return sData;
				});
		};

		return module;
	}, true);

}; // end of sap/ui/rta/util/StylesLoader.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.util.UrlParser') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.util.UrlParser'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/util/UrlParser",[
],
function(jQuery) {
	"use strict";

	var module = {};

	/**
	 * Get URL Param by name
	 * @param {string} sParamName - Parameter name
	 * @return {string|undefined} - Returns value of the specified param or undefined if not found
	 */
	module.getParam = function (sParamName) {
		return module.getParams()[sParamName];
	};

	module.getParams = function () {
		return document.location.search
			.replace(/^\?/, '')
			.split('&')
			.reduce(function (mParams, sParam) {
				var aParts = sParam.split('='); //split on key/value
				var sValue = aParts[1];

				switch (sValue) {
					case 'true':
						sValue = true;
						break;
					case 'false':
						sValue = false;
						break;
				}

				mParams[aParts[0]] = sValue;
				return mParams;
			}, {});
	};

	return module;
}, true);

}; // end of sap/ui/rta/util/UrlParser.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.AppVariantManager') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.appVariant.AppVariantManager'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.MessageToast'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.FlexControllerFactory'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageBox'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.transport.TransportSelection'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.BusyIndicator'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/AppVariantManager",[
	"sap/ui/rta/appVariant/AppVariantDialog",
	"sap/ui/rta/appVariant/AppVariantUtils",
	"sap/m/MessageToast",
	"sap/ui/fl/FlexControllerFactory",
	"sap/m/MessageBox",
	"sap/ui/rta/Utils",
	"sap/ui/rta/appVariant/Feature",
	"sap/ui/fl/transport/TransportSelection",
	"sap/ui/rta/appVariant/S4HanaCloudBackend",
	"sap/ui/core/BusyIndicator"
], function(AppVariantDialog, AppVariantUtils, MessageToast, FlexControllerFactory, MessageBox, RtaUtils, RtaAppVariantFeature, TransportSelection, S4HanaCloudBackend, BusyIndicator) {
	"use strict";

	var AppVariantManager = function() {};

	AppVariantManager.prototype._openDialog = function(fnCreate, fnCancel) {
		var oDialog = new AppVariantDialog("appVariantDialog");
		oDialog.attachCreate(fnCreate);
		oDialog.attachCancel(fnCancel);

		oDialog.open();

		return oDialog;
	};

	AppVariantManager.prototype._prepareAppVariantData = function(oDescriptor, mParameters) {
		return {
			idBaseApp: oDescriptor["sap.ui5"].componentName,
			idRunningApp: oDescriptor["sap.app"].id,
			title: mParameters.title,
			subTitle: mParameters.subTitle,
			description: mParameters.description,
			icon: mParameters.icon,
			inbounds: oDescriptor["sap.app"].crossNavigation.inbounds
		};
	};

	AppVariantManager.prototype.createDescriptor = function(oAppVariantData) {
		var sAppVariantId, aBackendOperations = [], oPropertyChange;

		sAppVariantId = AppVariantUtils.getId(oAppVariantData.idBaseApp);
		var oAppVariantDescriptor = {
			id: sAppVariantId,
			reference: oAppVariantData.idRunningApp
		};

		// creates an app variant descriptor
		aBackendOperations.push(AppVariantUtils.createDescriptorVariant(oAppVariantDescriptor));

		// create a inline change using a change type 'appdescr_app_setTitle'
		oPropertyChange = AppVariantUtils.getInlinePropertyChange("title", oAppVariantData.title);
		aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "title"));

		// create a inline change using a change type 'appdescr_app_setSubTitle'
		if (oAppVariantData.subTitle) {
			oPropertyChange = AppVariantUtils.getInlinePropertyChange("subtitle", oAppVariantData.subTitle);
			aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "subTitle"));
		}

		// create a inline change using a change type 'create_app_setDescription'
		if (oAppVariantData.description) {
			oPropertyChange = AppVariantUtils.getInlinePropertyChange("description", oAppVariantData.description);
			aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "description"));
		}

		// create a inline change using a change type 'appdescr_ui_setIcon'
		oPropertyChange = AppVariantUtils.getInlineChangeInputIcon(oAppVariantData.icon);
		aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "icon"));

		/*********************************************************************************************************************************************
		***********************************************************Inbounds handling******************************************************************
		*********************************************************************************************************************************************/
		var oInboundInfo = AppVariantUtils.getInboundInfo(oAppVariantData.inbounds);
		var sCurrentRunningInboundId = oInboundInfo.currentRunningInbound;
		var bAddNewInboundRequired = oInboundInfo.addNewInboundRequired;

		if (sCurrentRunningInboundId === "customer.savedAsAppVariant" && bAddNewInboundRequired) {
			oPropertyChange = AppVariantUtils.getInlineChangeCreateInbound(sCurrentRunningInboundId);
			aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "createInbound"));
		}

		oPropertyChange = AppVariantUtils.getInlineChangeForInboundPropertySaveAs(sCurrentRunningInboundId);
		aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "inbound"));

		oPropertyChange = AppVariantUtils.getInlineChangeRemoveInbounds(sCurrentRunningInboundId);
		aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "removeInbound"));

		oPropertyChange = AppVariantUtils.getInlineChangesForInboundProperties(sCurrentRunningInboundId, sAppVariantId, "title", oAppVariantData.title);
		aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "inboundTitle"));

		if (oAppVariantData.subTitle) {
			oPropertyChange = AppVariantUtils.getInlineChangesForInboundProperties(sCurrentRunningInboundId, sAppVariantId, "subTitle", oAppVariantData.subTitle);
			aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "inboundSubtitle"));
		}

		oPropertyChange = AppVariantUtils.getInlineChangesForInboundProperties(sCurrentRunningInboundId, sAppVariantId, "icon", oAppVariantData.icon);
		aBackendOperations.push(AppVariantUtils.createInlineChange(oPropertyChange, "inboundIcon"));

		var fnOpenTransportDialog = function(oTransportInput) {
			var oTransportSelection = new TransportSelection();
			return oTransportSelection.openTransportSelection(oTransportInput, this, RtaUtils.getRtaStyleClassName());
		};

		return Promise.all(aBackendOperations).then(function(aResponses){
			oAppVariantDescriptor = aResponses.shift();
			aBackendOperations = [];

			aResponses.forEach(function(oInlineChange) {
				aBackendOperations.push(oAppVariantDescriptor.addDescriptorInlineChange(oInlineChange));
			});

			return Promise.all(aBackendOperations);
		}).then(function() {
			var sNamespace = oAppVariantDescriptor._getMap().namespace;
			var oTransportInput = AppVariantUtils.getTransportInput("",sNamespace, "manifest", "appdescr_variant");
			return fnOpenTransportDialog.call(this, oTransportInput);
		}.bind(this)).then(function(oTransportInfo) {
			return this._onTransportInDialogSelected(oAppVariantDescriptor, oTransportInfo);
		}.bind(this))["catch"](function(oError) {
			var oErrorInfo = this._buildErrorMessageText("MSG_CREATE_DESCRIPTOR_FAILED", oAppVariantDescriptor._id, oError);
			return this._showErrorMessage(oErrorInfo);
		}.bind(this));
	};

	AppVariantManager.prototype._onTransportInDialogSelected = function(oAppVariantDescriptor, oTransportInfo){
		if (oTransportInfo){

			if (oTransportInfo.transport && oTransportInfo.packageName !== "$TMP") {

				var aPromises = [];

				if (oTransportInfo.transport) {
					aPromises.push(oAppVariantDescriptor.setTransportRequest(oTransportInfo.transport));
				}

				if (aPromises.length) {
					return Promise.all(aPromises).then(function() {
						return Promise.resolve(oAppVariantDescriptor);
					});
				}
			}

			return Promise.resolve(oAppVariantDescriptor);
		}

		return Promise.resolve(false);
	};

	AppVariantManager.prototype.processSaveAsDialog = function(oDescriptor) {
		return new Promise(function(resolve, reject) {
			var fnCreate = function(oResult) {
				var mParameters = oResult.getParameters();
				var oAppVariantData = this._prepareAppVariantData(oDescriptor, mParameters);

				resolve(oAppVariantData);
			}.bind(this);

			var fnCancel = function(oResult) {
				reject(oResult);
			};
			//open app variant creation dialog
			this._openDialog(fnCreate, fnCancel);
		}.bind(this));
	};

	AppVariantManager.prototype._showErrorMessage = function(oErrorInfo, sAppVariantId) {
		var oTextResources = AppVariantUtils.getTextResources();
		var sTitle = oTextResources.getText("HEADER_SAVE_APP_VARIANT_FAILED");

		BusyIndicator.hide();

		var sCopyIdButtonText;
		var sCloseButtonText = oTextResources.getText("SAVE_APP_VARIANT_CLOSE_TEXT");

		var aActions = [];

		if (oErrorInfo.copyId) {
			sCopyIdButtonText = oTextResources.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");
			aActions.push(sCopyIdButtonText);
		}

		aActions.push(sCloseButtonText);

		return new Promise(function(resolve, reject) {
			var fnCallback = function (sAction) {
				if (sAction === sCloseButtonText) {
					reject();
				} else if (sAction === sCopyIdButtonText) {
					AppVariantUtils.copyId(sAppVariantId);
					reject();
				}
			};

			MessageBox.error(oErrorInfo.text, {
				icon: MessageBox.Icon.ERROR,
				title: sTitle,
				onClose: fnCallback,
				actions: aActions,
				styleClass: RtaUtils.getRtaStyleClassName()
			});
		});
	};

	AppVariantManager.prototype._buildErrorMessageText = function(sMessageKey, sAppVariantId, oError, bCopyId) {
		var oTextResources = AppVariantUtils.getTextResources();

		var sErrorMessage = "";
		if (oError.messages && oError.messages.length) {
			if (oError.messages.length > 1) {
				oError.messages.forEach(function(oError) {
					sErrorMessage += oError.text + "\n";
				});
			} else {
				sErrorMessage += oError.messages[0].text;
			}
		} else if (oError.iamAppId) {
			//TODO: Need to remove this check later (20.10.2017)
			sErrorMessage += "IAM App Id: " + oError.iamAppId;
		} else {
			sErrorMessage += oError.stack || oError.message || oError.status || oError;
		}

		var sMessage = oTextResources.getText(sMessageKey) + "\n\n" +
						oTextResources.getText("MSG_APP_VARIANT_ID", sAppVariantId) + "\n" +
						oTextResources.getText("MSG_TECHNICAL_ERROR", sErrorMessage);
		return {
			text: sMessage,
			copyId: bCopyId
		};
	};

	AppVariantManager.prototype.saveAppVariantToLREP = function(oAppVariantDescriptor) {
		return oAppVariantDescriptor.submit()["catch"](function(oError) {
			var oErrorInfo = this._buildErrorMessageText("MSG_SAVE_APP_VARIANT_FAILED", oAppVariantDescriptor._id, oError);
			return this._showErrorMessage(oErrorInfo);
		}.bind(this));
	};

	// Unsaved changes get copied to app variant
	AppVariantManager.prototype._copyDirtyChangesToAppVariant = function(sReferenceForChange, oRootControlRunningApp) {
		var oFlexController = FlexControllerFactory.createForControl(oRootControlRunningApp);
		return oFlexController.saveAs(sReferenceForChange);
	};

	AppVariantManager.prototype.copyUnsavedChangesToLREP = function(sAppVariantId, oRootControlRunningApp, bCopyUnsavedChanges) {
		if (bCopyUnsavedChanges) {
			return this._copyDirtyChangesToAppVariant(sAppVariantId, oRootControlRunningApp)["catch"](function(oError) {
				var oErrorInfo = this._buildErrorMessageText("MSG_COPY_UNSAVED_CHANGES_FAILED", sAppVariantId, oError);
				return this._showErrorMessage(oErrorInfo);
			}.bind(this));
		} else {
			return Promise.resolve(true);
		}
	};

	AppVariantManager.prototype.triggerCatalogAssignment = function(oAppVariantDescriptor) {
		if (AppVariantUtils.isS4HanaCloud(oAppVariantDescriptor._oSettings)) {
			return AppVariantUtils.triggerCatalogAssignment(oAppVariantDescriptor._id, oAppVariantDescriptor._reference)["catch"](function(oError) {
				var oErrorInfo = this._buildErrorMessageText("MSG_CATALOG_ASSIGNMENT_FAILED", oAppVariantDescriptor._id, oError);
				return this._showErrorMessage(oErrorInfo);
			}.bind(this));
		} else {
			return Promise.resolve(true);
		}
	};

	AppVariantManager.prototype.notifyKeyUserWhenTileIsReady = function(sIamId, sAppVariantId) {
		var oS4HanaCloudBackend = new S4HanaCloudBackend();

		return oS4HanaCloudBackend.notifyFlpCustomizingIsReady(sIamId, function(sId) {
			var oTextResources = AppVariantUtils.getTextResources();
			var sMessage = oTextResources.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");
			var sTitle = oTextResources.getText("SAVE_APP_VARIANT_NEW_TILE_AVAILABLE_TITLE");

			return new Promise(function(resolve) {
				MessageBox.show(sMessage, {
					icon: MessageBox.Icon.INFORMATION,
					title: sTitle,
					onClose: resolve,
					styleClass: RtaUtils.getRtaStyleClassName()
				});
			});
		})["catch"](function(oError) {
			var oErrorInfo = this._buildErrorMessageText("MSG_TILE_CREATION_FAILED", sAppVariantId, oError, true);
			return this._showErrorMessage(oErrorInfo, sAppVariantId);
		}.bind(this));
	};

	AppVariantManager.prototype._buildSuccessMessageText = function(oAppVariantDescriptor, bCloseRunningApp) {
		var oTextResources = AppVariantUtils.getTextResources();
		var bCopyId = false;
		var sMessage = oTextResources.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE") + "\n\n";

		if (AppVariantUtils.isS4HanaCloud(oAppVariantDescriptor._oSettings)) {
			if (bCloseRunningApp) {
				sMessage += oTextResources.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_CLOUD_MESSAGE");
			} else {
				sMessage += oTextResources.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_CLOUD_MESSAGE_OVERVIEW_LIST");
			}
		} else if (bCloseRunningApp) {
			sMessage += oTextResources.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_ON_PREMISE_MESSAGE", oAppVariantDescriptor._id);
			bCopyId = true;
		} else {
			sMessage += oTextResources.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_ON_PREMISE_MESSAGE_OVERVIEW_LIST", oAppVariantDescriptor._id);
			bCopyId = true;
		}

		return {
			text: sMessage,
			copyId : bCopyId
		};
	};

	AppVariantManager.prototype._showSaveSuccessMessage = function(oSuccessInfo, sAppVariantId) {
		var oTextResources = AppVariantUtils.getTextResources();
		var sTitle = oTextResources.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");

		var sCopyIdButtonText;
		var sOkButtonText = oTextResources.getText("SAVE_APP_VARIANT_OK_TEXT");

		var aActions = [];

		if (oSuccessInfo.copyId) {
			sCopyIdButtonText = oTextResources.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");
			aActions.push(sCopyIdButtonText);
		}

		aActions.push(sOkButtonText);

		return new Promise(function(resolve) {
			var fnCallback = function (sAction) {
				if (sAction === sOkButtonText) {
					resolve();
				} else if (sAction === sCopyIdButtonText) {
					AppVariantUtils.copyId(sAppVariantId);
					resolve();
				}
			};

			MessageBox.show(oSuccessInfo.text, {
				icon: MessageBox.Icon.INFORMATION,
				onClose : fnCallback,
				title: sTitle,
				actions: aActions,
				styleClass: RtaUtils.getRtaStyleClassName()
			});
		});
	};

	AppVariantManager.prototype._navigateToFLPHomepage = function() {
		var oApplication = sap.ushell.services.AppConfiguration.getCurrentApplication();
		var oComponentInstance = oApplication.componentHandle.getInstance();

		if (oComponentInstance) {
			var oCrossAppNav = sap.ushell.Container.getService("CrossApplicationNavigation");
			if (oCrossAppNav.toExternal){
				oCrossAppNav.toExternal({target: {shellHash: "#"}}, oComponentInstance);
				return Promise.resolve(true);
			}
		}

		return Promise.resolve(false);
	};

	AppVariantManager.prototype.showSuccessMessageAndTriggerActionFlow = function(oAppVariantDescriptor, bCloseRunningApp, oRootControlRunningApp) {
		var oSuccessInfo = this._buildSuccessMessageText(oAppVariantDescriptor, bCloseRunningApp);
		return this._showSaveSuccessMessage(oSuccessInfo, oAppVariantDescriptor._id).then(function() {
			if (bCloseRunningApp) {
				return this._navigateToFLPHomepage();
			} else {
				return RtaAppVariantFeature.onGetOverview(oRootControlRunningApp);
			}
		}.bind(this));
	};

	return AppVariantManager;
}, true);
}; // end of sap/ui/rta/appVariant/AppVariantManager.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.ManageAppsDialog') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.rta.appVariant.ManageAppsDialog.
jQuery.sap.declare('sap.ui.rta.appVariant.ManageAppsDialog'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.ComponentContainer'); // unlisted dependency retained
jQuery.sap.require('sap.m.Dialog'); // unlisted dependency retained
jQuery.sap.require('sap.m.DialogRenderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/ManageAppsDialog",[
		'sap/ui/core/ComponentContainer',
		'sap/m/Dialog',
		'sap/m/DialogRenderer',
		'sap/ui/rta/appVariant/manageApps/webapp/Component',
		"sap/ui/fl/Utils",
		"sap/ui/rta/Utils"
], function(
			ComponentContainer,
			Dialog,
			DialogRenderer,
			ManageAppsComponent,
			FlexUtils,
			RtaUtils) {

	"use strict";

	var ManageAppsDialog = Dialog.extend("sap.ui.rta.appVariant.ManageAppsDialog", {
		metadata : {
			properties: {
				rootControl: {
					name: "rootControl",
					type: "object"
				}
			},
			events : {
				cancel : {}
			}
		},
		constructor: function() {
			Dialog.prototype.constructor.apply(this, arguments);
			this._oTextResources = sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");

			var oRootControl = this.getRootControl();
			var oAdaptedAppDescriptor = FlexUtils.getAppDescriptor(oRootControl);

			// Create manage apps component
			this.oManageAppsComponent = new ManageAppsComponent("manageApps", { idRunningApp : oAdaptedAppDescriptor["sap.app"].id, rootControlRunningApp: oRootControl });

			// Place component in container and display
			this.oManageAppsComponentContainer = new ComponentContainer({
				component : this.oManageAppsComponent
			});

			this.addContent(this.oManageAppsComponentContainer);
			this._createButton();
			this.setContentWidth("1000px");
			this.setContentHeight("300px");
			this.setShowHeader(false);

			this.addStyleClass(RtaUtils.getRtaStyleClassName());
		},
		destroy: function() {
			var sNewAppVarianId = sap.ui.rta.appVariant.AppVariantUtils.getNewAppVariantId();
			if (sNewAppVarianId) {
				sap.ui.rta.appVariant.AppVariantUtils.setNewAppVariantId(null);
			}
			Dialog.prototype.destroy.apply(this, arguments);
		},
		renderer: DialogRenderer.render
	});

	ManageAppsDialog.prototype._createButton = function() {
		this.addButton(new sap.m.Button({
			text: this._oTextResources.getText("APP_VARIANT_DIALOG_CLOSE"),
			press: function() {
				this.close();
				this.fireCancel();
			}.bind(this)
		}));
	};

	return ManageAppsDialog;

}, /* bExport= */ true);

}; // end of sap/ui/rta/appVariant/ManageAppsDialog.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.AddODataProperty') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.AddODataProperty'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/command/AddODataProperty",[
	'sap/ui/rta/command/FlexCommand'
], function (FlexCommand) {
	"use strict";

	/**
	 * Add new OData property to a control
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.44
	 * @alias sap.ui.rta.command.AddODataProperty
	 * @experimental Since 1.44. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var AddODataProperty = FlexCommand.extend("sap.ui.rta.command.AddODataProperty", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				index : {
					type : "int"
				},
				newControlId : {
					type : "string"
				},
				//the name "bindingPath" conflicts with getBindingPath() method from ManagedObject
				bindingString : {
					type : "string"
				},
				entityType : {
					type : "string"
				},
				parentId : {
					type : "string"
				},
				oDataServiceVersion : {
					type : "string"
				}
			}
		}
	});

	AddODataProperty.prototype._getChangeSpecificData = function() {
		// general format
		return {
			changeType: this.getChangeType(),
			index: this.getIndex(),
			newControlId: this.getNewControlId(),
			bindingPath: this.getBindingString(),
			entityType: this.getEntityType(),
			parentId: this.getParentId(),
			oDataServiceVersion: this.getODataServiceVersion()
		};
	};

	return AddODataProperty;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/AddODataProperty.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.AppDescriptorCommand') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.AppDescriptorCommand'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.descriptorRelated.api.DescriptorInlineChangeFactory'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.descriptorRelated.api.DescriptorChangeFactory'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/AppDescriptorCommand",['sap/ui/rta/command/BaseCommand',
				'sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory',
				'sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory'],
	function(BaseCommand,
		DescriptorInlineChangeFactory,
		DescriptorChangeFactory) {
	"use strict";

	/**
	 * Implementation of a command template for App Descriptor changes
	 *
	 * @class
	 * @extends sap.ui.rta.command.BaseCommand
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.49
	 * @alias sap.ui.rta.command.AppDescriptorCommand
	 * @experimental Since 1.49. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var AppDescriptorCommand = BaseCommand.extend("sap.ui.rta.command.AppDescriptor", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				reference : {
					type : "string"
				},
				appComponent: {
					type: "object"
				},
				layer : {
					type : "string"
				},
				changeType : {
					type : "string"
				},
				parameters : {
					type : "object"
				},
				texts : {
					type : "object"
				}
			},
			events : {}
		}
	});

	/**
	 * Prepare the app descriptor change, setting the layer.
	 * @param  {object} mFlexSettings Map of flex Settings
	 * @param  {string} mFlexSettings.layer Layer where the change is applied
	 */
	AppDescriptorCommand.prototype.prepare = function(mFlexSettings){
		this.setLayer(mFlexSettings.layer);
		return true;
	};

	/**
	 * Retrieves the prepared change for e.g. undo execution.
	 * @return {sap.ui.fl.Change} Returns change after being created and stored
	 */
	AppDescriptorCommand.prototype.getPreparedChange = function() {
		return this._oPreparedChange;
	};

	/**
	 * Create the change for the app descriptor and add it to the ChangePersistence.
	 * @return {Promise} Returns Promise resolving after change has been created and stored
	 */
	AppDescriptorCommand.prototype.createAndStoreChange = function(){
		return DescriptorInlineChangeFactory.createDescriptorInlineChange(
				this.getChangeType(), this.getParameters(), this.getTexts())
			.then(function(oAppDescriptorChangeContent){
				return new DescriptorChangeFactory().createNew(this.getReference(),
					oAppDescriptorChangeContent, this.getLayer(), this.getAppComponent());
			}.bind(this))
			.then(function(oAppDescriptorChange){
				var oChange = oAppDescriptorChange.store();
				this._oPreparedChange = oChange;
			}.bind(this));
	};
	return AppDescriptorCommand;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/AppDescriptorCommand.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.BindProperty') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.BindProperty'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/command/BindProperty",[
	'sap/ui/rta/command/FlexCommand',
	"sap/ui/rta/Utils"
], function(
	FlexCommand,
	Utils
) {
	"use strict";

	/**
	 * The BindProperty command take an element and the name of a property
	 * (propertyName) together with a complex binding string (newBinding).
	 * When executed, the binding is set on the property. The binding string
	 * has to comply with the same rules that apply to bindings passed to properties
	 * in the constructor of SAPUI5 ManagedObjects.
	 *
	 * Setting the oldValue or oldBinding is optional if you are running in the
	 * designMode (see unit test page).
	 * If set these take precedence over the actual value of the control.
	 * You should not set both properties.
	 *
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.rta.command.BindProperty
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var BindProperty = FlexCommand.extend("sap.ui.rta.command.BindProperty", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				propertyName : {
					type : "string"
				},
				newBinding : {
					type : "string"
				},
				changeType : {
					type : "string",
					defaultValue : "propertyBindingChange"
				}
			},
			associations : {},
			events : {}
		}
	});

	/**
	 * @override to suppress the binding strings to be used as
	 */
	BindProperty.prototype.bindProperty = function(sName, oBindingInfo){
		if (sName === "newBinding"){
			return this.setNewBinding(oBindingInfo.bindingString);
		}
		return FlexCommand.prototype.bindProperty.apply(this, arguments);
	};

	BindProperty.prototype._getChangeSpecificData = function() {
		var oElement = this.getElement();
		// general format
		var mSpecificChangeInfo = {
			changeType : this.getChangeType(),
			selector : {
				id : oElement.getId(),
				type : oElement.getMetadata().getName()
			},
			content : {
				property : this.getPropertyName(),
				newBinding : this.getNewBinding()
			}
		};

		return mSpecificChangeInfo;
	};

	return BindProperty;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/BindProperty.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.Combine') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.Combine'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/command/Combine",[
	'sap/ui/rta/command/FlexCommand'
], function(FlexCommand) {
	"use strict";

	/**
	 * Combine fields
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.46
	 * @alias sap.ui.rta.command.Combine
	 * @experimental Since 1.46. This class is experimental and provides only limited functionality. Also the API might be
	 *							 changed in future.
	 */
	var Combine = FlexCommand.extend("sap.ui.rta.command.Combine", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				source : {
					type : "any"
				},
				combineFields : {
					type : "any[]"
				}
			},
			associations : {},
			events : {}
		}
	});

	/**
	 * @override
	 */
	Combine.prototype._getChangeSpecificData = function() {
		var aFieldIds = [];
		this.getCombineFields().forEach(function(oField) {
			aFieldIds.push(oField.getId());
		});
		var mSpecificInfo = {
				changeType : this.getChangeType(),
				sourceControlId : this.getSource().getId(),
				combineFieldIds : aFieldIds
		};
		return mSpecificInfo;
	};

	return Combine;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/Combine.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.CreateContainer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.CreateContainer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/CreateContainer",['jquery.sap.global', 'sap/ui/rta/command/FlexCommand'], function(jQuery, FlexCommand) {
	"use strict";

	/**
	 * Create new container
	 *
	 * @class
	 * @extends sap.ui.rta.command.FlexCommand
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.command.CreateContainer
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var CreateContainer = FlexCommand.extend("sap.ui.rta.command.CreateContainer", {
		metadata : {
			library : "sap.ui.rta",
			properties : {
				index : {
					type : "int"
				},
				newControlId : {
					type : "string"
				},
				label : {
					type : "string"
				}
			},
			associations : {},
			events : {}
		}
	});

	CreateContainer.prototype._getChangeSpecificData = function(bForward) {

		var mSpecificInfo = {
			changeType : this.getChangeType(),
			index : this.getIndex(),
			newControlId : this.getNewControlId(),
			newLabel : this.getLabel()
		};

		return mSpecificInfo;
	};

	return CreateContainer;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/CreateContainer.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.LREPSerializer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.LREPSerializer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.FlexControllerFactory'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/command/LREPSerializer",[
	'sap/ui/base/ManagedObject',
	'sap/ui/rta/command/Stack',
	'sap/ui/rta/command/FlexCommand',
	'sap/ui/rta/command/BaseCommand',
	'sap/ui/rta/command/AppDescriptorCommand',
	'sap/ui/fl/FlexControllerFactory',
	'sap/ui/fl/Utils',
	'sap/ui/rta/ControlTreeModifier'
], function(
	ManagedObject,
	CommandStack,
	FlexCommand,
	BaseCommand,
	AppDescriptorCommand,
	FlexControllerFactory,
	FlexUtils,
	RtaControlTreeModifier
) {
	"use strict";
	/**
	 * Basic implementation for the LREP Serializer.
	 *
	 * @class
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.42
	 * @alias sap.ui.rta.command.LREPSerializer
	 * @experimental Since 1.42. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var LREPSerializer = ManagedObject.extend("sap.ui.rta.command.LREPSerializer", {
		metadata : {
			library : "sap.ui.rta",
			associations : {
				/** The root control which is needed for the Flex Controller */
				"rootControl" : {
					type : "sap.ui.core.Control"
				}
			},
			properties : {
				"commandStack" : {
					type : "object" // has to be of type sap.ui.rta.command.Stack
				}
			},
			aggregations : {}
		}
	});

	/**
	 * Promise to ensure that the event triggered methods are executed sequentionally.
	 */
	LREPSerializer.prototype._lastPromise = Promise.resolve();

	LREPSerializer.prototype.setCommandStack = function(oCommandStack) {
		this.setProperty("commandStack", oCommandStack);
		oCommandStack.attachCommandExecuted(function(oEvent) {
			this.handleCommandExecuted(oEvent);
		}.bind(this));
	};

	LREPSerializer.prototype.handleCommandExecuted = function(oEvent) {
		(function (oEvent) {
			var oParams = oEvent.getParameters();
			this._lastPromise = this._lastPromise.catch(function() {
				// _lastPromise chain must not be interupted
			}).then(function() {
				var aCommands = this.getCommandStack().getSubCommands(oParams.command);

				var oFlexController;
				if (oParams.undo) {
					aCommands.forEach(function(oCommand) {
						// for revertable changes which don't belong to LREP (variantSwitch) or runtime only changes
						if (!(oCommand instanceof FlexCommand || oCommand instanceof AppDescriptorCommand)
							|| oCommand.getRuntimeOnly()) {
							return;
						}
						var oChange = oCommand.getPreparedChange();
						var oAppComponent = oCommand.getAppComponent();
						if (oCommand instanceof FlexCommand){
							oFlexController = FlexControllerFactory.createForControl(oAppComponent);
							var oControl = RtaControlTreeModifier.bySelector(oChange.getSelector(), oAppComponent);
							oFlexController.removeFromAppliedChangesOnControl(oChange, oAppComponent, oControl);
						} else if (oCommand instanceof AppDescriptorCommand) {
							//other flex controller!
							oFlexController = this._getAppDescriptorFlexController(oAppComponent);
						}
						oFlexController.deleteChange(oChange, oAppComponent);
					}.bind(this));
				} else {
					var aDescriptorCreateAndAdd = [];
					aCommands.forEach(function(oCommand) {
						// Runtime only changes should not be added to the persistence
						if (oCommand.getRuntimeOnly()){
							return;
						}
						if (oCommand instanceof FlexCommand){
							var oAppComponent = oCommand.getAppComponent();
							var oFlexController = FlexControllerFactory.createForControl(oAppComponent);
							oFlexController.addPreparedChange(oCommand.getPreparedChange(), oAppComponent);
						} else if (oCommand instanceof AppDescriptorCommand) {
							aDescriptorCreateAndAdd.push(oCommand.createAndStoreChange());
						}
					});

					return Promise.all(aDescriptorCreateAndAdd);
				}
			}.bind(this));
		}.bind(this))(oEvent);
	};

	/**
	 * Serializes and saves all changes to LREP
	 *
	 * @returns {Promise} return empty promise
	 * @public
	 */
	LREPSerializer.prototype.saveCommands = function() {
		this._lastPromise = this._lastPromise.catch(function() {
			// _lastPromise chain must not be interupted
		}).then(function() {
			var oRootControl = sap.ui.getCore().byId(this.getRootControl());
			if (!oRootControl) {
				throw new Error("Can't save commands without root control instance!");
			}
			var oFlexController = FlexControllerFactory.createForControl(oRootControl);
			return oFlexController.saveAll();
		}.bind(this))

		// needed because the AppDescriptorChanges are stored with a different ComponentName (without ".Component" at the end)
		// -> two different ChangePersistences
		.then(function() {
			var oRootControl = sap.ui.getCore().byId(this.getRootControl());
			var oFlexController = this._getAppDescriptorFlexController(oRootControl);
			return oFlexController.saveAll();
		}.bind(this))

		.then(function() {
			jQuery.sap.log.info("UI adaptation successfully transferred changes to layered repository");
			this.getCommandStack().removeAllCommands();
		}.bind(this));

		return this._lastPromise;
	};

	/**
	 * needed because the AppDescriptorChanges are stored with a different ComponentName (without ".Component" at the end)
	 * -> two different ChangePersistence
	 * @param {sap.ui.base.ManagedObject} oControl control or app component for which the flex controller should be instantiated
	 */
	LREPSerializer.prototype._getAppDescriptorFlexController = function(oControl) {
		var oAppComponent = FlexUtils.getAppComponentForControl(oControl);
		var sComponentName = FlexUtils.getComponentClassName(oAppComponent).replace(".Component", "");
		var sAppVersion = FlexUtils.getAppVersionFromManifest(oAppComponent.getManifest());
		return FlexControllerFactory.create(sComponentName, sAppVersion);
	};
	return LREPSerializer;
}, /* bExport= */true);

}; // end of sap/ui/rta/command/LREPSerializer.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.command.appDescriptor.AddLibrary') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.command.appDescriptor.AddLibrary'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/command/appDescriptor/AddLibrary",[
	'sap/ui/rta/command/AppDescriptorCommand'
], function(
	AppDescriptorCommand
) {
	"use strict";

	/**
	 * Implementation of a command for Add Library change on App Descriptor
	 *
	 * @class
	 * @extends sap.ui.rta.command.AppDescriptorCommand
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.49
	 * @alias sap.ui.rta.command.appDescriptor.AddLibrary
	 * @experimental Since 1.49. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var AddLibrary = AppDescriptorCommand.extend("sap.ui.rta.command.appDescriptor.AddLibrary", {
		metadata : {
			library : "sap.ui.rta",
			events : {}
		}
	});

	AddLibrary.prototype.init = function() {
		this.setChangeType("appdescr_ui5_addLibraries");
	};

	/**
	 * Execute the change (load the required libraries)
	 * @return {Promise} resolved if libraries could be loaded; rejected if not
	 */
	AddLibrary.prototype.execute = function(){
		var aPromises = [];

		if (this.getParameters().libraries){
			var aLibraries = Object.keys(this.getParameters().libraries);
			aLibraries.forEach(function(sLibrary){
				aPromises.push(sap.ui.getCore().loadLibrary(sLibrary, true));
			});
		}

		return Promise.all(aPromises);
	};

	return AddLibrary;

}, /* bExport= */true);

}; // end of sap/ui/rta/command/appDescriptor/AddLibrary.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.Combine') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.Combine.
jQuery.sap.declare('sap.ui.rta.plugin.Combine'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.dt.Selection'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/Combine",[
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/dt/Selection',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/rta/Utils'
], function(
	Plugin,
	Selection,
	OverlayRegistry,
	Utils
) {
	"use strict";

	/**
	 * Constructor for a new Combine Plugin.
	 *
	 * @class
	 * @extends sap.ui.rta.plugin.Plugin
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.46
	 * @alias sap.ui.rta.plugin.Combine
	 * @experimental Since 1.46. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Combine = Plugin.extend("sap.ui.rta.plugin.Combine", /** @lends sap.ui.rta.plugin.Combine.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties: {},
			associations: {},
			events: {}
		}
	});

	/**
	 * check if the given overlay is editable
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - overlay to be checked for editable
	 * @returns {boolean} whether it is editable or not
	 * @private
	 */
	Combine.prototype._isEditable = function(oOverlay) {
		if (!Utils.getRelevantContainerDesigntimeMetadata(oOverlay)) {
			return false;
		}
		var oCombineAction = this.getAction(oOverlay);
		if (oCombineAction && oCombineAction.changeType && oCombineAction.changeOnRelevantContainer) {
			return this.hasChangeHandler(oCombineAction.changeType, oOverlay.getRelevantContainer()) && this.hasStableId(oOverlay);
		} else {
			return false;
		}
	};

	Combine.prototype._checkForSameRelevantContainer = function(aSelectedOverlays) {
		var aRelevantContainer = [];
		for (var i = 0, n = aSelectedOverlays.length; i < n; i++) {
			aRelevantContainer[i] = aSelectedOverlays[i].getRelevantContainer();
			var oCombineAction = this.getAction(aSelectedOverlays[i]);
			if (!oCombineAction || !oCombineAction.changeType){
				return false;
			}
			if (i > 0) {
				if ((aRelevantContainer[0] !== aRelevantContainer[i])
					|| (this.getAction(aSelectedOverlays[0]).changeType !== oCombineAction.changeType)) {
					return false;
				}
			}
		}
		return true;
	};

	/**
	 * Checks if Combine is available for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if available
	 * @public
	 */
	Combine.prototype.isAvailable = function(oOverlay) {
		var aSelectedOverlays = this.getDesignTime().getSelection();

		if (aSelectedOverlays.length <= 1) {
			return false;
		}
		return (this._isEditableByPlugin(oOverlay) && this._checkForSameRelevantContainer(aSelectedOverlays));
	};

	/**
	 * Checks if Combine is enabled for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if enabled
	 * @public
	 */
	Combine.prototype.isEnabled = function(oOverlay) {
		var aSelectedOverlays = this.getDesignTime().getSelection();

		// check that at least 2 fields can be combined
		if (!this.isAvailable(oOverlay) || aSelectedOverlays.length <= 1) {
			return false;
		}

		var aSelectedControls = aSelectedOverlays.map(function (oSelectedOverlay) {
			return oSelectedOverlay.getElementInstance();
		});

		// check that each selected element has an enabled action
		var bActionCheck = aSelectedOverlays.every(function(oSelectedOverlay) {
			var oAction = this.getAction(oSelectedOverlay);
			if (!oAction) {
				return false;
			}

			// when isEnabled is not defined the default is true
			if (typeof oAction.isEnabled !== "undefined") {
				if (typeof oAction.isEnabled === "function") {
					return oAction.isEnabled(aSelectedControls);
				} else {
					return oAction.isEnabled;
				}
			}

			return true;
		}, this);

		return bActionCheck;
	};

	/**
	 * @param  {any} oCombineElement selected element
	 */
	Combine.prototype.handleCombine = function(oCombineElement) {
		var oElementOverlay = OverlayRegistry.getOverlay(oCombineElement);
		var oDesignTimeMetadata = oElementOverlay.getDesignTimeMetadata();

		var aToCombineElements = [];
		var aSelectedOverlays = this.getDesignTime().getSelection();

		for (var i = 0; i < aSelectedOverlays.length; i++) {
			var oSelectedElement = aSelectedOverlays[i].getElementInstance();
			aToCombineElements.push(oSelectedElement);
		}

		var oCombineAction = this.getAction(oElementOverlay);
		var sVariantManagementReference = this.getVariantManagementReference(oElementOverlay, oCombineAction);

		var oCombineCommand = this.getCommandFactory().getCommandFor(oCombineElement, "combine", {
			source : oCombineElement,
			combineFields : aToCombineElements
		}, oDesignTimeMetadata, sVariantManagementReference);
		this.fireElementModified({
			"command" : oCombineCommand
		});
	};

	/**
	 * Retrieve the context menu item for the action.
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay Overlay for which the context menu was opened
	 * @return {object[]}          Returns array containing the items with required data
	 */
	Combine.prototype.getMenuItems = function(oOverlay){
		return this._getMenuItems(oOverlay, {pluginId : "CTX_GROUP_FIELDS", rank : 90});
	};

	/**
	 * Get the name of the action related to this plugin.
	 * @return {string} Returns the action name
	 */
	Combine.prototype.getActionName = function(){
		return "combine";
	};

	/**
	 * Trigger the plugin execution.
	 * @param  {sap.ui.dt.ElementOverlay[]} aOverlays Selected overlays; targets of the action
	 * @param  {any} oEventItem ContextMenu item which triggers the event
	 * @param  {any} oContextElement Element where the action is triggered
	 */
	Combine.prototype.handler = function(aOverlays, mPropertyBag){
		//TODO: Handle "Stop Cut & Paste" depending on alignment with Dietrich!
		this.handleCombine(mPropertyBag.contextElement);
	};

	return Combine;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/Combine.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.ControlVariant') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.ControlVariant.
jQuery.sap.declare('sap.ui.rta.plugin.ControlVariant'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.dt.ElementOverlay'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.changeHandler.BaseTreeModifier'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.variants.VariantManagement'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/ControlVariant",[
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/rta/plugin/RenameHandler',
	'sap/ui/rta/Utils',
	'sap/ui/dt/ElementOverlay',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/fl/changeHandler/BaseTreeModifier',
	'sap/ui/fl/Utils',
	'sap/ui/fl/variants/VariantManagement',
	'sap/ui/base/ManagedObject'
], function(Plugin, RenameHandler, Utils, ElementOverlay, OverlayRegistry, OverlayUtil, BaseTreeModifier, flUtils, VariantManagement, ManagedObject) {
	"use strict";

	/**
	 * Constructor for a new ControlVariant Plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The ControlVariant allows propagation of variantManagement key
	 * @extends sap.ui.rta.plugin.Plugin
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.50
	 * @alias sap.ui.rta.plugin.ControlVariant
	 * @experimental Since 1.50. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	/* Mix-in Variant Methods */
	ElementOverlay.prototype._variantManagement = undefined;
	ElementOverlay.prototype.getVariantManagement = function() { return this._variantManagement;};
	ElementOverlay.prototype.setVariantManagement = function(sKey) { this._variantManagement = sKey; };
	ElementOverlay.prototype.hasVariantManagement = function() { return this._variantManagement ? true : false; };

	var ControlVariant = Plugin.extend("sap.ui.rta.plugin.ControlVariant", /** @lends sap.ui.rta.plugin.ControlVariant.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties : {
				oldValue : "string"
			},
			associations: {},
			events: {}
		}
	});

	ControlVariant.MODEL_NAME = "$FlexVariants";

	/**
	 * Register an overlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	ControlVariant.prototype.registerElementOverlay = function(oOverlay) {
		var oControl = oOverlay.getElementInstance();

		if (oControl.getMetadata().getName() === "sap.ui.fl.variants.VariantManagement") {
			var oControl = oOverlay.getElementInstance();
			var vAssociationElement = oControl.getAssociation("for");

			var aVariantManagementTargetElements = !jQuery.isArray(vAssociationElement) ? [vAssociationElement] : vAssociationElement;

			aVariantManagementTargetElements.forEach( function(sVariantManagementTargetElement) {
				var oVariantManagementTargetElement = sVariantManagementTargetElement instanceof ManagedObject ? sVariantManagementTargetElement : sap.ui.getCore().byId(sVariantManagementTargetElement);
				var oVariantManagementTargetOverlay = OverlayRegistry.getOverlay(oVariantManagementTargetElement);
				var sVariantManagement = BaseTreeModifier.getSelector(oControl, flUtils.getComponentForControl(oControl)).id;
				this._propagateVariantManagement(oVariantManagementTargetOverlay , sVariantManagement);
			}.bind(this));
		} else if (!oOverlay.getVariantManagement()) {
			var sVariantManagementReference = this._getVariantManagementFromParent(oOverlay);
			if (sVariantManagementReference) {
				oOverlay.setVariantManagement(sVariantManagementReference);
			}
		}
		oOverlay.attachEvent("editableChange", RenameHandler._manageClickEvent, this);
		Plugin.prototype.registerElementOverlay.apply(this, arguments);
	};

	/**
	 * Top-down approach for setting VariantManagement reference to all children overlays
	 *
	 * @param {sap.ui.dt.Overlay} oParentElementOverlay overlay object for which children overlays are computed
	 * @param {string} sVariantManagementReference VariantManagement reference to be set
	 * @returns {array} array of rendered ElementOverlays which have been set with passed VariantManagement reference
	 * @private
	 */
	ControlVariant.prototype._propagateVariantManagement = function(oParentElementOverlay, sVariantManagementReference) {
		var aElementOverlaysRendered = [];
		oParentElementOverlay.setVariantManagement(sVariantManagementReference);
		aElementOverlaysRendered = OverlayUtil.getAllChildOverlays(oParentElementOverlay);

		aElementOverlaysRendered.forEach( function(oElementOverlay) {
			aElementOverlaysRendered = aElementOverlaysRendered.concat(this._propagateVariantManagement(oElementOverlay, sVariantManagementReference));
		}.bind(this));

		return aElementOverlaysRendered;
	};

	/**
	 * Bottom-up approach for setting VariantManagement reference from parent ElementOverlays
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object for which VariantManagement reference is to be set
	 * @returns {string} VariantManagement reference
	 * @private
	 */
	ControlVariant.prototype._getVariantManagementFromParent = function(oOverlay) {
		var sVariantManagementReference = oOverlay.getVariantManagement();
		if (!sVariantManagementReference && oOverlay.getParentElementOverlay()) {
			return this._getVariantManagementFromParent(oOverlay.getParentElementOverlay());
		}
		return sVariantManagementReference;
	};

	/**
	 * Additionally to super->deregisterOverlay this method detatches the browser events
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	ControlVariant.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.detachEvent("editableChange", RenameHandler._manageClickEvent, this);
		oOverlay.detachBrowserEvent("click", RenameHandler._onClick, this);

		this.removeFromPluginsList(oOverlay);
		Plugin.prototype.deregisterElementOverlay.apply(this, arguments);
	};

	ControlVariant.prototype._getVariantModel = function(oElement) {
		var oAppComponent = flUtils.getAppComponentForControl(oElement);
		return oAppComponent.getModel(ControlVariant.MODEL_NAME);
	};

	/**
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay
	 * @returns {boolean} editable or not
	 * @private
	 */
	ControlVariant.prototype._isEditable = function(oOverlay) {
		return this._isVariantManagementControl(oOverlay);
	};

	ControlVariant.prototype._isVariantManagementControl = function(oOverlay) {
		var oElement = oOverlay.getElementInstance(),
			vAssociationElement = oElement.getAssociation("for");
		return !!(vAssociationElement && oElement instanceof VariantManagement);
	};

	/**
	 * Checks if variant switch is available for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if available
	 * @public
	 */
	ControlVariant.prototype.isVariantSwitchAvailable = function(oOverlay) {
		return this._isVariantManagementControl(oOverlay);
	};

	/**
	 * Checks if Variant Switch is enabled for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if enabled
	 * @public
	 */
	ControlVariant.prototype.isVariantSwitchEnabled = function(oOverlay) {
		var oElement = oOverlay.getElementInstance(),
			sVariantManagementReference = oOverlay.getVariantManagement ? oOverlay.getVariantManagement() : undefined;
		if (!sVariantManagementReference) {
			return false;
		}
		var oModel = this._getVariantModel(oElement),
			aVariants = oModel ? oModel.getData()[sVariantManagementReference].variants : [],
			bEnabled = aVariants.length > 1;
		return bEnabled;
	};

	/**
	 * @override
	 */
	ControlVariant.prototype.setDesignTime = function(oDesignTime) {
		RenameHandler._setDesignTime.call(this, oDesignTime);
	};

	/**
	 * Checks if variant rename is available for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if available
	 * @public
	 */
	ControlVariant.prototype.isRenameAvailable = function(oOverlay) {
		return this._isVariantManagementControl(oOverlay);
	};

	/**
	 * Checks if variant rename is enabled for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if available
	 * @public
	 */
	ControlVariant.prototype.isRenameEnabled = function(oOverlay) {
		return true;
	};

	/**
	 * Checks if variant duplicate is available for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if available
	 * @public
	 */
	ControlVariant.prototype.isVariantDuplicateAvailable = function(oOverlay) {
		return this._isVariantManagementControl(oOverlay);
	};

	/**
	 * Checks if variant duplicate is enabled for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if available
	 * @public
	 */
	ControlVariant.prototype.isVariantDuplicateEnabled = function(oOverlay) {
		var sVariantManagementReference = oOverlay.getVariantManagement ? oOverlay.getVariantManagement() : undefined;
		if (!sVariantManagementReference || !this._isVariantManagementControl(oOverlay)) {
			return false;
		}
		return true;
	};

	/**
	 * Checks if variant configure is available for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if available
	 * @public
	 */
	ControlVariant.prototype.isVariantConfigureAvailable = function(oOverlay) {
		return this._isVariantManagementControl(oOverlay);
	};

	/**
	 * Checks if variant configure is enabled for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if available
	 * @public
	 */
	ControlVariant.prototype.isVariantConfigureEnabled = function(oOverlay) {
		return false;
	};

	/**
	 * Performs a variant switch
	 *
	 * @param {object} oTargetOverlay Target variant management overlay
	 * @param {String} sNewVariantReference The new variant reference
	 * @param {String} sCurrentVariantReference The current variant reference
	 * @public
	 */
	ControlVariant.prototype.switchVariant = function(oTargetOverlay, sNewVariantReference, sCurrentVariantReference) {
		var oDesignTimeMetadata = oTargetOverlay.getDesignTimeMetadata(),
			oTargetElement = oTargetOverlay.getElementInstance();

		var oSwitchCommand = this.getCommandFactory().getCommandFor(oTargetElement, "switch", {
			targetVariantReference: sNewVariantReference,
			sourceVariantReference: sCurrentVariantReference
		}, oDesignTimeMetadata);
		this.fireElementModified({
			"command" : oSwitchCommand
		});
	};

	/**
	 * Performs a variant set title
	 *
	 * @public
	 */
	ControlVariant.prototype.renameVariant = function(aOverlays) {
		this.startEdit(aOverlays[0]);
	};

	ControlVariant.prototype.startEdit = function(oOverlay) {
		var oVariantManagementControl = oOverlay.getElementInstance(),
			vDomRef = function () {
				return oVariantManagementControl.getTitle().getDomRef("inner");
			};
		RenameHandler.startEdit.call(this, oOverlay, vDomRef, "plugin.ControlVariant.startEdit");
	};

	ControlVariant.prototype.stopEdit = function (bRestoreFocus) {
		RenameHandler._stopEdit.call(this, bRestoreFocus, "plugin.ControlVariant.stopEdit");
	};

	/**
	 * Performs a variant duplicate
	 *
	 * @param {object} oOverlay Variant management overlay
	 * @public
	 */
	ControlVariant.prototype.duplicateVariant = function(oOverlay) {
		var sVariantManagementReference = oOverlay.getVariantManagement();
		var oElement = oOverlay.getElementInstance();
		var oModel = this._getVariantModel(oElement);
		var sCurrentVariantReference = oModel.getCurrentVariantReference(sVariantManagementReference);
		var oDesignTimeMetadata = oOverlay.getDesignTimeMetadata();

		var oDuplicateCommand = this.getCommandFactory().getCommandFor(oElement, "duplicate", {
			sourceVariantReference: sCurrentVariantReference
		}, oDesignTimeMetadata, sVariantManagementReference);
		this.fireElementModified({
			"command" : oDuplicateCommand
		});
	};

	/**
	 * @private
	 */
	ControlVariant.prototype._emitLabelChangeEvent = function() {
		var sText = RenameHandler._getCurrentEditableFieldText.call(this);
		if (this.getOldValue() !== sText) { //check for real change before creating a command
			this._$oEditableControlDomRef.text(sText);
			try {
				var oSetTitleCommand;
				var oRenamedElement = this._oEditedOverlay.getElementInstance();
				var oDesignTimeMetadata = this._oEditedOverlay.getDesignTimeMetadata();
				var sVariantManagementReference = this._oEditedOverlay.getVariantManagement();

				oSetTitleCommand = this.getCommandFactory().getCommandFor(oRenamedElement, "setTitle", {
					renamedElement : oRenamedElement,
					newText : sText
				}, oDesignTimeMetadata, sVariantManagementReference);
				this.fireElementModified({
					"command" : oSetTitleCommand
				});
			} catch (oError) {
				jQuery.sap.log.error("Error during rename : ", oError);
			}
		}
	};

	/**
	 * Opens a dialog for Variant configuration
	 *
	 * @public
	 */
	ControlVariant.prototype.configureVariants = function() {
		return;
	};

	/**
	 * Retrieve the context menu item for the actions.
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay Overlay for which the context menu was opened
	 * @return {object[]}          Returns array containing the items with required data
	 */
	ControlVariant.prototype.getMenuItems = function(oOverlay){
		var VARIANT_MODEL_NAME = '$FlexVariants';
		var aMenuItems = [];

		if (this.isRenameAvailable(oOverlay)){
			aMenuItems.push({
				id: "CTX_VARIANT_SET_TITLE",
				text: sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_SET_TITLE'),
				handler: this.renameVariant.bind(this),
				enabled: this.isRenameEnabled.bind(this),
				rank: 210
			});
		}

		if (this.isVariantDuplicateAvailable(oOverlay)){
			aMenuItems.push({
				id: "CTX_VARIANT_DUPLICATE",
				text: sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_DUPLICATE'),
				handler: function(aOverlays){
					return this.duplicateVariant(aOverlays[0]);
				}.bind(this),
				enabled: this.isVariantDuplicateEnabled.bind(this),
				rank: 220
			});
		}

		if (this.isVariantConfigureAvailable(oOverlay)){
			aMenuItems.push({
				id: "CTX_VARIANT_CONFIGURE",
				text: sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_CONFIGURE'),
				handler: this.configureVariants.bind(this),
				enabled: this.isVariantConfigureEnabled.bind(this),
				startSection: true,
				rank: 230
			});
		}

		if (this.isVariantSwitchAvailable(oOverlay)){
			aMenuItems.push({
				id: "CTX_VARIANT_SWITCH_SUBMENU",
				text: sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_SWITCH'),
				handler: function(aOverlays, oItem){
					var oData = oItem.data(),
						oTargetOverlay = oData.targetOverlay,
						sNewVariantKey = oData.key,
						sCurrentVariantKey = oData.current;
					return this.switchVariant(oTargetOverlay, sNewVariantKey, sCurrentVariantKey);
				}.bind(this),
				enabled: this.isVariantSwitchEnabled.bind(this),
				submenu: {
					id: "{" + VARIANT_MODEL_NAME + ">key}",
					text: "{" + VARIANT_MODEL_NAME + ">title}",
					model: VARIANT_MODEL_NAME,
					current: function(oOverlay, oModel) {
						var sManagementReferenceId = oOverlay.getVariantManagement();
						return oModel.getData()[sManagementReferenceId].currentVariant;
					},
					items: function(oOverlay, oModel) {
						var sManagementReferenceId = oOverlay.getVariantManagement();
						return oModel.getData()[sManagementReferenceId].variants;
					}
				},
				type: "subMenuWithBinding",
				rank: 240
			});
		}

		return aMenuItems;
	};

	return ControlVariant;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/ControlVariant.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.CreateContainer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.CreateContainer.
jQuery.sap.declare('sap.ui.rta.plugin.CreateContainer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/CreateContainer",[
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/fl/Utils',
	'sap/ui/rta/Utils',
	'sap/ui/dt/OverlayRegistry'

], function(
	Plugin,
	FlexUtils,
	RtaUtils,
	OverlayRegistry
) {
	"use strict";

	/**
	 * Constructor for a new CreateContainer Plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The CreateContainer allows trigger CreateContainer operations on the overlay
	 * @extends sap.ui.rta.plugin.Plugin
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.plugin.CreateContainer
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var CreateContainer = Plugin.extend("sap.ui.rta.plugin.CreateContainer", /** @lends sap.ui.rta.plugin.CreateContainer.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties: {},
			associations: {},
			events: {}
		}
	});

	/**
	 * This function gets called on startup. It checks if the Overlay is editable by this plugin.
	 * @param {sap.ui.dt.Overlay} oOverlay - overlay to be checked
	 * @returns {object} Returns object with editable boolean values for "asChild" and "asSibling"
	 * @private
	 */
	CreateContainer.prototype._isEditable = function(oOverlay) {
		return {
			asSibling: this._isEditableCheck(oOverlay, true),
			asChild: this._isEditableCheck(oOverlay, false)
		};
	};

	CreateContainer.prototype._isEditableCheck = function (oOverlay, bOverlayIsSibling) {
		var bEditable = false;
		var	oParentOverlay = this._getParentOverlay(bOverlayIsSibling, oOverlay);

		if (!oParentOverlay || !oParentOverlay.getParentElementOverlay()){
			//root element is not editable as parent and as sibling
			return false;
		}

		bEditable = this.checkAggregationsOnSelf(oParentOverlay, "createContainer");

		if (bEditable) {
			// If ids are created within fragments or controller code,
			// the id of the parent view might not be part of the control id.
			// In these cases the control might have a stable id (this.hasStableId()), but the view doesn't.
			// As the view is needed create the id for the newly created container it
			// has to be stable, otherwise the new id will not be stable.
			var oParentView = FlexUtils.getViewForControl(oParentOverlay.getElementInstance());
			return this.hasStableId(oOverlay) && FlexUtils.checkControlId(oParentView);
		} else {
			return false;
		}
	};

	CreateContainer.prototype._getParentOverlay = function(bSibling, oOverlay) {
		var oParentOverlay;
		if (bSibling) {
			oParentOverlay = oOverlay.getParentElementOverlay();
		} else {
			oParentOverlay = oOverlay;
		}
		return oParentOverlay;
	};

	CreateContainer.prototype.getCreateAction = function(bSibling, oOverlay) {
		var oParentOverlay = this._getParentOverlay(bSibling, oOverlay);
		var oDesignTimeMetadata = oParentOverlay.getDesignTimeMetadata();
		var aActions = oDesignTimeMetadata.getAggregationAction("createContainer", oOverlay.getElementInstance());
		return aActions[0];
	};

	CreateContainer.prototype.isAvailable = function(bSibling, oOverlay) {
		return this._isEditableByPlugin(oOverlay, bSibling);
	};

	CreateContainer.prototype.isEnabled = function(bSibling, oOverlay) {
		var vAction = this.getCreateAction(bSibling, oOverlay);
		if (!vAction) {
			return false;
		}

		if (vAction.isEnabled && typeof vAction.isEnabled === "function") {
			var fnIsEnabled = vAction.isEnabled;
			var oParentOverlay = this._getParentOverlay(bSibling, oOverlay);
			return fnIsEnabled.call(null, oParentOverlay.getElementInstance());
		} else {
			return true;
		}
	};

	/**
	 * Returns the overlay of a newly created container using the function
	 * defined in the control designtime metadata to retrieve the correct id
	 * @param  {object} vAction       create container action from designtime metadata
	 * @param  {string} sNewControlID id of the new control
	 * @return {sap.ui.dt.Overlay}    overlay for the new container
	 */
	CreateContainer.prototype.getCreatedContainerOverlay = function(vAction, sNewControlID) {
		var sId = sNewControlID;
		if (vAction.getCreatedContainerId && typeof vAction.getCreatedContainerId === "function") {
			var fnMapToRelevantControlID = vAction.getCreatedContainerId;
			sId = fnMapToRelevantControlID.call(null, sNewControlID);

		}
		return OverlayRegistry.getOverlay(sId);
	};

	CreateContainer.prototype._determineIndex = function(oParentElement, oSiblingElement, sAggregationName, fnGetIndex) {
		return RtaUtils.getIndex(oParentElement, oSiblingElement, sAggregationName, fnGetIndex);
	};

	CreateContainer.prototype._getText = function(vAction, oElement, oDesignTimeMetadata, sText) {
		if (!vAction) {
			return sText;
		}
		var sContainerTitle = oDesignTimeMetadata.getAggregationDescription(vAction.aggregation, oElement).singular;
		var oTextResources = sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");
		return oTextResources.getText(sText, sContainerTitle);
	};

	CreateContainer.prototype.getCreateContainerText = function(bSibling, oOverlay) {
		var vAction = this.getCreateAction(bSibling, oOverlay);
		var oParentOverlay = this._getParentOverlay(bSibling, oOverlay);
		var oDesignTimeMetadata = oParentOverlay.getDesignTimeMetadata();
		var oElement = oParentOverlay.getElementInstance();
		var sText = "CTX_CREATE_CONTAINER";
		return this._getText(vAction, oElement, oDesignTimeMetadata, sText);
	};

	CreateContainer.prototype._getContainerTitle = function(vAction, oElement, oDesignTimeMetadata) {
		var sText = "TITLE_CREATE_CONTAINER";
		return this._getText(vAction, oElement, oDesignTimeMetadata, sText);
	};

	CreateContainer.prototype.handleCreate = function(bSibling, oOverlay) {
		var vAction = this.getCreateAction(bSibling, oOverlay);
		var oParentOverlay = this._getParentOverlay(bSibling, oOverlay);
		var oDesignTimeMetadata = oParentOverlay.getDesignTimeMetadata();
		var oTargetElement = oParentOverlay.getElementInstance();
		var oView = FlexUtils.getViewForControl(oTargetElement);

		var oSiblingElement;
		if (bSibling) {
			oSiblingElement = oOverlay.getElementInstance();
		}

		var sNewControlID = oView.createId(jQuery.sap.uid());

		var fnGetIndex = oDesignTimeMetadata.getAggregation(vAction.aggregation).getIndex;
		var iIndex = this._determineIndex(oTargetElement, oSiblingElement, vAction.aggregation, fnGetIndex);

		var sVariantManagementReference = this.getVariantManagementReference(oParentOverlay, vAction);

		var oCommand = this.getCommandFactory().getCommandFor(oTargetElement, "createContainer", {
			newControlId : sNewControlID,
			label : this._getContainerTitle(vAction, oTargetElement, oDesignTimeMetadata),
			index : iIndex
		}, oDesignTimeMetadata, sVariantManagementReference);

		this.fireElementModified({
			"command" : oCommand,
			"action" : vAction,
			"newControlId" : sNewControlID
		});
	};

	/**
	 * Retrieve the context menu item for the actions.
	 * Two items are returned here: one for when the overlay is sibling and one for when it is child.
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay Overlay for which the context menu was opened
	 * @return {object[]}          Returns array containing the items with required data
	 */
	CreateContainer.prototype.getMenuItems = function(oOverlay){
		var bOverlayIsSibling = true;
		var sPluginId = "CTX_CREATE_SIBLING_CONTAINER";
		var iRank = 40;
		var aMenuItems = [];
		for (var i = 0; i < 2; i++){
			if (this.isAvailable(bOverlayIsSibling, oOverlay)){
				var sMenuItemText = this.getCreateContainerText.bind(this, bOverlayIsSibling);

				aMenuItems.push({
					id: sPluginId,
					text: sMenuItemText,
					handler: this.handler.bind(this, bOverlayIsSibling),
					enabled: this.isEnabled.bind(this, bOverlayIsSibling),
					rank: iRank
				});
			}
			bOverlayIsSibling = false;
			sPluginId = "CTX_CREATE_CHILD_CONTAINER";
			iRank = 50;
		}
		return aMenuItems;
	};

	/**
	 * Get the name of the action related to this plugin.
	 * @return {string} Returns the action name
	 */
	CreateContainer.prototype.getActionName = function(){
		return "createContainer";
	};

	/**
	 * Trigger the plugin execution.
	 * @param  {boolean} bOverlayIsSibling True if the overlay is sibling
	 * @param  {sap.ui.dt.ElementOverlay[]} aOverlays Selected overlays; targets of the action
	 */
	CreateContainer.prototype.handler = function(bOverlayIsSibling, aOverlays){
		//TODO: Handle "Stop Cut & Paste" depending on alignment with Dietrich!
		this.handleCreate(bOverlayIsSibling, aOverlays[0]);
	};

	return CreateContainer;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/CreateContainer.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.EasyAdd') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.EasyAdd.
jQuery.sap.declare('sap.ui.rta.plugin.EasyAdd'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/EasyAdd",[
	'sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin',
	'sap/ui/dt/OverlayRegistry'
], function(AdditionalElementsPlugin, OverlayRegistry) {
	"use strict";

	/**
	 * Constructor for a new EasyAdd Plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The EasyAdd Plugin adds an Icon to an Overlay, which allows to trigger add operations directly
	 * @extends sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.rta.plugin.EasyAdd
	 * @experimental Since 1.48. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var EasyAdd = AdditionalElementsPlugin.extend("sap.ui.rta.plugin.EasyAdd", /** @lends sap.ui.rta.plugin.EasyAdd.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties: {},
			associations: {},
			events: {}
		}
	});

	/**
	 * Register browser event for an overlay
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay object
	 * @override
	 */
	EasyAdd.prototype.registerElementOverlay = function(oOverlay) {
		this._oDelegate = {
			"onAfterRendering" : function() {
				var onAddPressed = function(bOverlayIsSibling, oOverlay, iIndex) {
					var sControlName;
					if (bOverlayIsSibling) {
						sControlName = oOverlay.getDesignTimeMetadata().getName().plural;
					} else {
						sControlName = oOverlay.getDesignTimeMetadata().getAggregation("sections").childNames.plural();
					}
					this.showAvailableElements(bOverlayIsSibling, [oOverlay], iIndex, sControlName);
				}.bind(this);

				var fnAddButton = function(oOverlay, oOverlayDom, bSibling, vControlName, iIndex) {
					var fnCallback = function(oEvent) {
						var oOverlay = sap.ui.getCore().byId(oEvent.getSource().getId().replace("-AddButton", ""));
						onAddPressed(bSibling, oOverlay, iIndex);
						oEvent.cancelBubble();
					};
					var sControlName = typeof vControlName === "function" ? vControlName() : vControlName;
					this._addButton(oOverlay, fnCallback, oOverlayDom, sControlName, bSibling);
				}.bind(this);

				if (oOverlay.$().hasClass("sapUiRtaPersAdd")) {
					var bAddButton = oOverlay.$().hasClass("sapUiRtaPersAdd") && oOverlay.$().children(".sapUiRtaPersAddIconOuter").length <= 0;
					var oParentControl = oOverlay.getElementInstance().getParent();
					var oParentOverlay = OverlayRegistry.getOverlay(oParentControl);
					if (oParentControl.getMetadata().getName() === "sap.uxap.ObjectPageLayout") {
						if (oParentOverlay.$().hasClass("sapUiRtaPersAddTop") && oParentOverlay.getAggregationOverlay("sections").$().children(".sapUiRtaPersAddIconOuter").length > -1) {
							oParentControl.$("sectionsContainer").addClass("sapUiRtaPaddingTop");
						}
					}
					if (bAddButton) {
						fnAddButton(oOverlay, oOverlay.$(), true, oOverlay.getDesignTimeMetadata().getName().singular);
					}
				} else if (oOverlay.$().hasClass("sapUiRtaPersAddTop")) {
					if (oOverlay.getAggregationOverlay("sections").$().children(".sapUiRtaPersAddIconOuter").length <= 0) {
						var $sectionsOverlay = oOverlay.getAggregationOverlay("sections").$();
						fnAddButton(oOverlay, $sectionsOverlay, false, oOverlay.getDesignTimeMetadata().getAggregation("sections").childNames.singular, 0);
					}
				}

				oOverlay.removeEventDelegate(this._oDelegate, this);
			}
		};

		var oControl = oOverlay.getElementInstance();
		if (oControl.getMetadata().getName() === "sap.uxap.ObjectPageSection" && this.hasStableId(oOverlay)) {
			oOverlay.addStyleClass("sapUiRtaPersAdd");
			oControl.addStyleClass("sapUiRtaMarginBottom");
		} else if (oControl.getMetadata().getName() === "sap.uxap.ObjectPageLayout" && this.hasStableId(oOverlay)) {
			oOverlay.addStyleClass("sapUiRtaPersAddTop");
			oControl.$("sectionsContainer").addClass("sapUiRtaPaddingTop");
		}

		oOverlay.addEventDelegate(this._oDelegate, this);
		AdditionalElementsPlugin.prototype.registerElementOverlay.apply(this, arguments);
	};

	/**
	 * Deregister browser event for an overlay
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay object
	 * @override
	 */
	EasyAdd.prototype.deregisterElementOverlay = function(oOverlay) {
		var oControl = oOverlay.getElementInstance();
		if (oOverlay._oAddButton) {
			oOverlay._oAddButton.destroy();
		}
		if (oControl.getMetadata().getName() === "sap.uxap.ObjectPageSection") {
			oOverlay.removeStyleClass("sapUiRtaPersAdd");
			oControl.removeStyleClass("sapUiRtaMarginBottom");
			oOverlay.removeEventDelegate(this._oDelegate, this);
		} else if (oControl.getMetadata().getName() === "sap.uxap.ObjectPageLayout") {
			oOverlay.removeStyleClass("sapUiRtaPersAddTop");
			oControl.$("sectionsContainer").removeClass("sapUiRtaPaddingTop");
		}
	};

	/**
	 * On Editable Change the enablement of the Button has to be adapted
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	EasyAdd.prototype._isEditable = function(oOverlay) {
		var bIsEditable = AdditionalElementsPlugin.prototype._isEditable.apply(this, arguments);
		if (oOverlay._oAddButton) {
			var sOverlayIsSibling = oOverlay.hasStyleClass("sapUiRtaPersAddTop") ? "asChild" : "asSibling";
			oOverlay._oAddButton.setEnabled(bIsEditable[sOverlayIsSibling]);
		}
		return bIsEditable;
	};

	/**
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - overlay object
	 * @param {function} fnCallback - callback function will be passed to the new button as on press event function
	 * @param {object} oOverlayDom - dom object of the overlay
	 * @param {string} sControlName - name of the control. This name will be displayed on the Add-Button
	 * @private
	 */
	EasyAdd.prototype._addButton = function(oOverlay, fnCallback, oOverlayDom, sControlName, bOverlayIsSibling) {
		var bIsEditable = oOverlay.getEditableByPlugins().indexOf(this._retrievePluginName(bOverlayIsSibling)) > -1;
		var oTextResources = sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");

		var sId = oOverlay.getId() + "-AddButton";
		var oHtmlButtonOuter = jQuery("<div class='sapUiRtaPersAddIconOuter' draggable='true'> </div>");
		oOverlay._oAddButton = new sap.m.Button(sId, {
			text: oTextResources.getText("CTX_ADD_ELEMENTS", sControlName),
			icon: "sap-icon://add",
			press: fnCallback,
			enabled: bIsEditable
		}).placeAt(oHtmlButtonOuter.get(0));
		oOverlayDom.append(oHtmlButtonOuter);

		oHtmlButtonOuter[0].addEventListener("mouseover", function(oEvent) {
			oEvent.stopPropagation();
			var oOverlay = oEvent.fromElement ? sap.ui.getCore().byId(oEvent.fromElement.id) : null;
			if (oOverlay && oOverlay.getMetadata().getName() === "sap.ui.dt.ElementOverlay") {
				var oParentContainer = oOverlay.getParentElementOverlay();
				oParentContainer.$().removeClass("sapUiRtaOverlayHover");
			}
		});

		oHtmlButtonOuter[0].addEventListener("mouseleave", function(oEvent) {
			oEvent.stopPropagation();
			var oOverlay = oEvent.toElement ? sap.ui.getCore().byId(oEvent.toElement.id) : null;
			if (oOverlay && oOverlay.getMetadata().getName() === "sap.ui.dt.ElementOverlay") {
				var oParentContainer = oOverlay.getParentElementOverlay();
				if (oParentContainer.getMovable()) {
					oParentContainer.$().addClass("sapUiRtaOverlayHover");
				}
			}
		});

		oHtmlButtonOuter[0].addEventListener("dragstart", function(oEvent) {
			oEvent.stopPropagation();
			oEvent.preventDefault();
		});
	};

	return EasyAdd;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/EasyAdd.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.EasyRemove') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.EasyRemove.
jQuery.sap.declare('sap.ui.rta.plugin.EasyRemove'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/EasyRemove",[
	'sap/ui/rta/plugin/Remove',
	'sap/m/Button'
], function(Remove, Button) {
	"use strict";

	/**
	 * Constructor for a new EasyRemove Plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The EasyRemove Plugin adds an Icon to an Overlay, which allows to trigger remove operations directly
	 * @extends sap.ui.rta.plugin.Remove
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.rta.plugin.EasyRemove
	 * @experimental Since 1.48. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var EasyRemove = Remove.extend("sap.ui.rta.plugin.EasyRemove", /** @lends sap.ui.rta.plugin.EasyRemove.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.rta",
			properties: {},
			associations: {},
			events: {}
		}
	});

	/**
	 * Register browser event for an overlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	EasyRemove.prototype.registerElementOverlay = function(oOverlay) {
		this._oDelegate = {
			"onAfterRendering" : function() {
				if (oOverlay.$().hasClass("sapUiRtaPersDelete") && oOverlay.$().children(".sapUiRtaPersDeleteClick").length <= 0) {
					var onDeletePressed = function(oOverlay) {
						this.handler([oOverlay]);
					}.bind(this);

					var oDeleteButton = this._addButton(oOverlay);
					oDeleteButton.attachBrowserEvent("contextmenu", function(oEvent) {
						oEvent.stopPropagation();
						oEvent.preventDefault();
					});
					oDeleteButton.attachPress(function(oEvent) {
						var oOverlay = sap.ui.getCore().byId(oEvent.getSource().getId().replace("-DeleteIcon", ""));
						onDeletePressed(oOverlay);
						oEvent.cancelBubble();
					});

				}

				oOverlay.removeEventDelegate(this._oDelegate, this);
			}
		};

		var oControl = oOverlay.getElementInstance();
		if (oControl.getMetadata().getName() === "sap.uxap.ObjectPageSection" && this.hasStableId(oOverlay)) {
			oOverlay.addStyleClass("sapUiRtaPersDelete");
		}

		oOverlay.addEventDelegate(this._oDelegate, this);
		Remove.prototype.registerElementOverlay.apply(this, arguments);
	};

	/**
	 * On Editable Change the enablement of the Button has to be adapted
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	EasyRemove.prototype._isEditable = function(oOverlay) {
		if (oOverlay._oDeleteButton) {
			oOverlay._oDeleteButton.setEnabled(this.isEnabled(oOverlay));
		}
		return Remove.prototype._isEditable.apply(this, arguments);
	};

	EasyRemove.prototype._addButton = function(oOverlay) {
		var bEnabled = this.isEnabled(oOverlay);
		var sId = oOverlay.getId() + "-DeleteIcon";
		var oHtmlIconWrapper = jQuery("<div class='sapUiRtaPersDeleteClick' draggable='true'> </div>");
		var oHtmlIconOuter = jQuery("<div class='sapUiRtaPersDeleteIconOuter'> </div>");

		oOverlay._oDeleteButton = new Button(sId, {
			icon : "sap-icon://decline",
			tooltip: sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_REMOVE"),
			enabled: bEnabled,
			noTabStop: true
		}).placeAt(oHtmlIconOuter.get(0));
		oHtmlIconWrapper.append(oHtmlIconOuter);
		oOverlay.$().append(oHtmlIconWrapper);

		oHtmlIconWrapper[0].addEventListener("dragstart", function(oEvent) {
			oEvent.stopPropagation();
			oEvent.preventDefault();
		});
		return oOverlay._oDeleteButton;
	};

	/**
	 * Deregister browser event for an overlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	EasyRemove.prototype.deregisterElementOverlay = function(oOverlay) {
		var oControl = oOverlay.getElementInstance();
		if (oControl.getMetadata().getName() === "sap.uxap.ObjectPageSection") {
			oOverlay.removeStyleClass("sapUiRtaPersDelete");
			oOverlay.removeEventDelegate(this._oDelegate, this);
			if (oOverlay._oDeleteButton) {
				oOverlay._oDeleteButton.destroy();
			}
		}
	};

	return EasyRemove;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/EasyRemove.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.RTAElementMover') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.RTAElementMover.
jQuery.sap.declare('sap.ui.rta.plugin.RTAElementMover'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.dt.plugin.ElementMover'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/RTAElementMover",[
  'sap/ui/dt/plugin/ElementMover',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/ElementUtil',
	'sap/ui/fl/Utils',
	'sap/ui/rta/Utils',
	'sap/ui/rta/command/CommandFactory',
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/rta/util/BindingsExtractor'
],
function(
	ElementMover,
	OverlayUtil,
	ElementUtil,
	FlexUtils,
	Utils,
	CommandFactory,
	Plugin,
	OverlayRegistry,
	BindingsExtractor
) {
	"use strict";

	/**
	 * Constructor for a new RTAElementMover.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The RTAElementMover is responsible for the RTA specific adaptation of element movements.
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.rta.plugin.RTAElementMover
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var RTAElementMover = ElementMover.extend("sap.ui.rta.plugin.RTAElementMover", /** @lends sap.ui.rta.plugin.RTAElementMover.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.rta",
			properties : {
				commandFactory : {
					type : "any",
					defaultValue : CommandFactory
				},
				movableTypes : {
					type : "string[]",
					defaultValue : ["sap.ui.core.Element"]
				}
			},
			associations : {
			},
			events : {
			}
		}
	});

	RTAElementMover.prototype.init = function() {
		this.oBasePlugin = new Plugin({
			commandFactory : this.getCommandFactory()
		});
	};

	RTAElementMover.prototype.exit = function() {
		this.oBasePlugin.destroy();
	};

	RTAElementMover.prototype.setCommandFactory = function(oCommandFactory) {
		this.setProperty("commandFactory", oCommandFactory);
		this.oBasePlugin.setCommandFactory(oCommandFactory);
	};

	RTAElementMover.prototype.isEditable = function(oOverlay, bOnRegistration) {
		var oElement = oOverlay.getElementInstance();
		var bMovable = false;
		if (this.isMovableType(oElement) && this.checkMovable(oOverlay, bOnRegistration)) {
			bMovable = true;
		}
		oOverlay.setMovable(bMovable);
		return bMovable;
	};

	/**
	 * Check if the element is editable for the move
	 * @param  {sap.ui.dt.Overlay}  oOverlay The overlay being moved or the aggregation overlay
	 * @param  {boolean} bOnRegistration if embedded, false if not
	 * @return {boolean} true if editable
	 */
	function fnIsValidForMove(oOverlay, bOnRegistration) {
		var bValid = false,
			oDesignTimeMetadata = oOverlay.getDesignTimeMetadata(),
			oParentElementOverlay = oOverlay.getParentElementOverlay();

		if (!oDesignTimeMetadata || !oParentElementOverlay) {
			return false;
		}

		var oRelevantContainer = oOverlay.getRelevantContainer();
		var oRelevantContainerOverlay = sap.ui.dt.OverlayRegistry.getOverlay(oRelevantContainer);
		if (!Utils.getRelevantContainerDesigntimeMetadata(oOverlay)) {
			return false;
		}

		bValid = this._isMoveAvailableOnRelevantContainer(oOverlay);

		if (bValid) {
			bValid = this.oBasePlugin.hasStableId(oOverlay) &&
			this.oBasePlugin.hasStableId(oParentElementOverlay) &&
			this.oBasePlugin.hasStableId(oRelevantContainerOverlay);
		}

		// element is only valid for move if it can be moved to somewhere else
		if (bValid) {
			var aOverlays = OverlayUtil.findAllUniqueAggregationOverlaysInContainer(oOverlay, oRelevantContainerOverlay);

			var aValidAggregationOverlays = aOverlays.filter(function(oAggregationOverlay) {
				return this.checkTargetZone(oAggregationOverlay, oOverlay, bOnRegistration);
			}.bind(this));

			if (aValidAggregationOverlays.length < 1) {
				bValid = false;
			} else if (aValidAggregationOverlays.length === 1) {
				var aVisibleOverlays = aValidAggregationOverlays[0].getChildren().filter(function(oChildOverlay) {
					var oChildElement = oChildOverlay.getElementInstance();
					// At least one sibling has to be visible and still attached to the parent
					// In some edge cases, the child element is not available anymore (element already got destroyed)
					return (oChildElement && oChildElement.getVisible() && oChildElement.getParent());
				});
				bValid = aVisibleOverlays.length > 1;
			}
		}

		return bValid;
	}

	function fnHasMoveAction(oAggregationOverlay, oElement, oRelevantContainer) {
		var oAggregationDTMetadata = oAggregationOverlay.getDesignTimeMetadata();
		var oMoveAction = oAggregationDTMetadata.getAction("move", oElement);
		if (!oMoveAction) {
			return false;
		}
		// moveChangeHandler information is always located on the relevant container
		return this.oBasePlugin.hasChangeHandler(oMoveAction.changeType, oRelevantContainer);
	}

	/**
	 * @param	{sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {sap.ui.dt.DesignTimeMetadata} oDesignTimeMetadata
	 * @private
	 */
	ElementMover.prototype._getMoveAction = function(oOverlay) {
		var oParentAggregationDtMetadata,
			oParentAggregationOverlay = oOverlay.getParentAggregationOverlay();
		if (oParentAggregationOverlay) {
			oParentAggregationDtMetadata = oParentAggregationOverlay.getDesignTimeMetadata();
		}
		return oParentAggregationDtMetadata ? oParentAggregationDtMetadata.getAction("move", oOverlay.getElementInstance()) : undefined;
	};

	/**
	 * Predicate to compute movability of a type
	 * @param {any} oElement given element
	 * @public
	 * @return {boolean} true if type is movable, false otherwise
	 */
	ElementMover.prototype.isMovableType = function(oElement) {
		//real check is part of checkMovable which has the overlay
		return true;
	};

	/**
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if embedded, false if not
	 * @override
	 */
	RTAElementMover.prototype.checkMovable = function(oOverlay, bOnRegistration) {
		return fnIsValidForMove.call(this, oOverlay, bOnRegistration);
	};

	/**
	 * Checks drop ability for aggregation overlays
	 * @param  {sap.ui.dt.Overlay} oAggregationOverlay aggregation overlay object
	 * @return {boolean} true if aggregation overlay is droppable, false if not
	 * @override
	 */
	RTAElementMover.prototype.checkTargetZone = function(oAggregationOverlay, oOverlay, bOverlayNotInDom) {
		var oMovedOverlay = oOverlay ? oOverlay : this.getMovedOverlay();

		var bTargetZone = ElementMover.prototype.checkTargetZone.call(this, oAggregationOverlay, oMovedOverlay, bOverlayNotInDom);
		if (!bTargetZone) {
			return false;
		}

		var oMovedElement = oMovedOverlay.getElementInstance();
		var oTargetOverlay = oAggregationOverlay.getParent();
		var oMovedRelevantContainer = oMovedOverlay.getRelevantContainer();
		var oTargetElement = oTargetOverlay.getElementInstance();

		// determine target relevantContainer
		var vTargetRelevantContainerAfterMove = oAggregationOverlay.getDesignTimeMetadata().getRelevantContainerForPropagation(oMovedElement);
		vTargetRelevantContainerAfterMove = vTargetRelevantContainerAfterMove ? vTargetRelevantContainerAfterMove : oTargetElement;

		// check for same relevantContainer
		if (
			!oMovedRelevantContainer
			|| !vTargetRelevantContainerAfterMove
			|| !Plugin.prototype.hasStableId(oTargetOverlay)
			|| oMovedRelevantContainer !== vTargetRelevantContainerAfterMove
		) {
			return false;
		}

		// Binding context is not relevant if the element is being moved inside its parent
		if (oMovedOverlay.getParent().getElementInstance() !== oTargetElement) {
			// check if binding context is the same
			var aBindings = BindingsExtractor.getBindings(oMovedElement, oMovedElement.getModel());
			if (Object.keys(aBindings).length > 0 && oMovedElement.getBindingContext() && oTargetElement.getBindingContext()) {
				var sMovedElementBindingContext = Utils.getEntityTypeByPath(
					oMovedElement.getModel(),
					oMovedElement.getBindingContext().getPath()
				);
				var sTargetElementBindingContext = Utils.getEntityTypeByPath(
					oTargetElement.getModel(),
					oTargetElement.getBindingContext().getPath()
				);
				if (!(sMovedElementBindingContext === sTargetElementBindingContext)) {
					return false;
				}
			}
		}

		// check if movedOverlay is movable into the target aggregation
		return fnHasMoveAction.call(this, oAggregationOverlay, oMovedElement, vTargetRelevantContainerAfterMove);
	};

	/**
	 * Checks if move is available on relevantcontainer
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @return {boolean} true if move available on relevantContainer
	 */
	RTAElementMover.prototype._isMoveAvailableOnRelevantContainer = function(oOverlay) {
		var oChangeHandlerRelevantElement,
			oMoveAction = this._getMoveAction(oOverlay);

		if (oMoveAction && oMoveAction.changeType) {
			// moveChangeHandler information is always located on the relevant container
			oChangeHandlerRelevantElement = oOverlay.getRelevantContainer();
			return this.oBasePlugin.hasChangeHandler(oMoveAction.changeType, oChangeHandlerRelevantElement);
		}
		return false;
	};

	/**
	 * Builds the Move command
	 * @return {any} Move command object
	 */
	RTAElementMover.prototype.buildMoveCommand = function() {

		var oMovedOverlay = this.getMovedOverlay();
		var oParentAggregationOverlay = oMovedOverlay.getParentAggregationOverlay();
		var oMovedElement = oMovedOverlay.getElementInstance();
		var oSource = this._getSource();
		var oRelevantContainer = oMovedOverlay.getRelevantContainer();
		var oTarget = OverlayUtil.getParentInformation(oMovedOverlay);
		var iSourceIndex = oSource.index;
		var iTargetIndex = oTarget.index;

		var bSourceAndTargetAreSame = this._compareSourceAndTarget(oSource, oTarget);

		if (bSourceAndTargetAreSame) {
			return undefined;
		}
		delete oSource.index;
		delete oTarget.index;

		var oMoveAction = this._getMoveAction(oMovedOverlay);
		var sVariantManagementReference = this.oBasePlugin.getVariantManagementReference(oMovedOverlay, oMoveAction, true);

		var oMove = this.getCommandFactory().getCommandFor(oRelevantContainer, "Move", {
			movedElements : [{
				element : oMovedElement,
				sourceIndex : iSourceIndex,
				targetIndex : iTargetIndex
			}],
			source : oSource,
			target : oTarget
		}, oParentAggregationOverlay.getDesignTimeMetadata(), sVariantManagementReference);

		return oMove;

	};

	return RTAElementMover;
}, /* bExport= */ true);

}; // end of sap/ui/rta/plugin/RTAElementMover.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.Rename') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.Rename.
jQuery.sap.declare('sap.ui.rta.plugin.Rename'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.Overlay'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/Rename",[
	'jquery.sap.global',
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/rta/plugin/RenameHandler',
	'sap/ui/dt/Overlay',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/rta/Utils'
], function(
	jQuery,
	Plugin,
	RenameHandler,
	Overlay,
	ElementUtil,
	OverlayUtil,
	OverlayRegistry,
	Utils
) {
	"use strict";

	/**
	 * Constructor for a new Rename.
	 *
	 * @param {string}
	 *          [sId] id for the new object, generated automatically if no id is given
	 * @param {object}
	 *          [mSettings] initial settings for the new object
	 *
	 * @class The Rename allows to create a set of Overlays above the root elements and their public children and manage
	 *        their events.
	 * @extends sap.ui.rta.plugin.Plugin
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.rta.plugin.Rename
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var Rename = Plugin.extend("sap.ui.rta.plugin.Rename", /** @lends sap.ui.rta.plugin.Rename.prototype */
	{
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.rta",
			properties : {
				oldValue : "string"
			},
			associations : {},
			events : {
				/** Fired when renaming is possible */
				"editable" : {},

				/** Fired when renaming is switched off */
				"nonEditable" : {}
			}
		}
	});

	/**
	 * @override
	 */
	Rename.prototype.exit = function() {
		Plugin.prototype.exit.apply(this, arguments);

		RenameHandler._exit.call(this);
	};

	/**
	 * @override
	 */
	Rename.prototype.setDesignTime = function(oDesignTime) {
		RenameHandler._setDesignTime.call(this, oDesignTime);
	};

	Rename.prototype.startEdit = function (oOverlay) {
		var oElement = oOverlay.getElementInstance(),
			oDesignTimeMetadata = oOverlay.getDesignTimeMetadata(),
			vDomRef = oDesignTimeMetadata.getAction("rename", oElement).domRef;
		RenameHandler.startEdit.call(this, oOverlay, vDomRef, "plugin.Rename.startEdit");
	};

	Rename.prototype.stopEdit = function (bRestoreFocus) {
		RenameHandler._stopEdit.call(this, bRestoreFocus, "plugin.Rename.stopEdit");
	};

	Rename.prototype.handler = function (aOverlays) {
		this.startEdit(aOverlays[0]);
	};

	/**
	 * Checks if rename is available for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @returns {boolean} true if it's editable
	 * @public
	 */
	Rename.prototype.isRenameAvailable = function(oOverlay) {
		return this._isEditableByPlugin(oOverlay);
	};

	Rename.prototype.isRenameEnabled = function (oOverlay) {
		return this.isEnabled(oOverlay);
	};

	/**
	 * Checks if rename is enabled for oOverlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @returns {boolean} true if it's enabled
	 * @public
	 */
	Rename.prototype.isEnabled = function(oOverlay) {
		var bIsEnabled = true;
		var oAction = this.getAction(oOverlay);
		if (!oAction) {
			bIsEnabled = false;
		}

		if (bIsEnabled && typeof oAction.isEnabled !== "undefined") {
			if (typeof oAction.isEnabled === "function") {
				bIsEnabled = oAction.isEnabled(oOverlay.getElementInstance());
			} else {
				bIsEnabled = oAction.isEnabled;
			}
		}

		if (bIsEnabled) {
			var oDesignTimeMetadata = oOverlay.getDesignTimeMetadata();
			if (!oDesignTimeMetadata.getAssociatedDomRef(oOverlay.getElementInstance(), oAction.domRef)) {
				bIsEnabled = false;
			}
		}

		return bIsEnabled && this.isMultiSelectionInactive.call(this, oOverlay);
	};

	/**
	 * @override
	 */
	Rename.prototype.registerElementOverlay = function(oOverlay) {
		oOverlay.attachEvent("editableChange", RenameHandler._manageClickEvent, this);

		Plugin.prototype.registerElementOverlay.apply(this, arguments);
	};

	/**
	 * @param {sap.ui.dt.ElementOverlay} oOverlay overlay to be checked for editable
	 * @returns {boolean} true if it's editable
	 * @private
	 */
	Rename.prototype._isEditable = function(oOverlay) {
		var bEditable = false;
		var oElement = oOverlay.getElementInstance();

		if (!Utils.getRelevantContainerDesigntimeMetadata(oOverlay)) {
			return false;
		}

		var oRenameAction = this.getAction(oOverlay);
		if (oRenameAction && oRenameAction.changeType) {
			if (oRenameAction.changeOnRelevantContainer) {
				oElement = oOverlay.getRelevantContainer();
			}
			bEditable = this.hasChangeHandler(oRenameAction.changeType, oElement);
		}

		if (bEditable) {
			return this.hasStableId(oOverlay);
		}

		return bEditable;
	};

	/**
	 * @override
	 */
	Rename.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.detachEvent("editableChange", RenameHandler._manageClickEvent, this);
		oOverlay.detachBrowserEvent("click", RenameHandler._onClick, this);

		this.removeFromPluginsList(oOverlay);
	};

	/**
	 * @private
	 */
	Rename.prototype._emitLabelChangeEvent = function() {
		var sText = RenameHandler._getCurrentEditableFieldText.call(this);
		if (this.getOldValue() !== sText) { //check for real change before creating a command
			this._$oEditableControlDomRef.text(sText);
			try {
				var oRenameCommand;
				var oRenamedElement = this._oEditedOverlay.getElementInstance();
				var oDesignTimeMetadata = this._oEditedOverlay.getDesignTimeMetadata();
				var oRenameAction = this.getAction(this._oEditedOverlay);
				var sVariantManagementReference = this.getVariantManagementReference(this._oEditedOverlay, oRenameAction);

				oRenameCommand = this.getCommandFactory().getCommandFor(oRenamedElement, "rename", {
					renamedElement : oRenamedElement,
					newValue : sText
				}, oDesignTimeMetadata, sVariantManagementReference);
				this.fireElementModified({
					"command" : oRenameCommand
				});
			} catch (oError) {
				jQuery.sap.log.error("Error during rename : ", oError);
			}
		}
	};

	/**
	 * Retrieve the context menu item for the action.
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay Overlay for which the context menu was opened
	 * @return {object[]}          Returns array containing the items with required data
	 */
	Rename.prototype.getMenuItems = function(oOverlay){
		return this._getMenuItems(oOverlay, {pluginId : "CTX_RENAME", rank : 10});
	};

	/**
	 * Get the name of the action related to this plugin.
	 * @return {string} Returns the action name
	 */
	Rename.prototype.getActionName = function(){
		return "rename";
	};

	return Rename;
}, /* bExport= */true);

}; // end of sap/ui/rta/plugin/Rename.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.additionalElements.AdditionalElementsAnalyzer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

 jQuery.sap.declare('sap.ui.rta.plugin.additionalElements.AdditionalElementsAnalyzer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.StashedControlSupport'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementUtil'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer",[
	'jquery.sap.global',
	'sap/ui/core/StashedControlSupport',
	'sap/ui/dt/ElementUtil',
	'sap/ui/rta/Utils',
	'sap/ui/rta/util/BindingsExtractor'
	],
	function (
		jQuery,
		StashedControlSupport,
		ElementUtil,
		RtaUtils,
		BindingsExtractor
	) {
	"use strict";

	function _enrichProperty(mProperty, mEntity){
		var mProp = jQuery.extend({},mProperty);
		mProp.entityName = mEntity.name;

		var mLabelAnnotation = mProperty["com.sap.vocabularies.Common.v1.Label"];
		mProp.fieldLabel = mLabelAnnotation && mLabelAnnotation.String;

		var mQuickInfoAnnotation = mProperty["com.sap.vocabularies.Common.v1.QuickInfo"];
		mProp.quickInfo = mQuickInfoAnnotation && mQuickInfoAnnotation.String;

		//CDS UI.Hidden new way also for sap:visible = false
		var mHiddenAnnotation = mProperty["com.sap.vocabularies.UI.v1.Hidden"];
		mProp.hidden = mHiddenAnnotation && mHiddenAnnotation.Bool === "true";

		if (!mProp.hidden){
			// Old hidden annotation
			var mFieldControlAnnotation = mProperty["com.sap.vocabularies.Common.v1.FieldControl"];
			if (mFieldControlAnnotation){
				mProp.hidden = mFieldControlAnnotation.EnumMember === "com.sap.vocabularies.Common.v1.FieldControlType/Hidden";
			}
		}
		return mProp;
	}

	/**
	 * Is field using a complex type
	 *
	 * @param {Object} mProperty - property from entityType
	 * @returns {Boolean} - Returns true if property is using a complex type
	 */
	function _isComplexType (mProperty) {
		if (mProperty && mProperty.type) {
			if (mProperty.type.toLowerCase().indexOf("edm") !== 0) {
				return true;
			}
		}
		return false;
	}

	function _expandComplexProperties(aODataProperties, oMetaModel, mEntity){
		return aODataProperties.reduce(function(aExpandedProperties, mProperty){
			var vProps = _enrichProperty(mProperty, mEntity);
			if (_isComplexType(vProps)) {
				var mComplexType = oMetaModel.getODataComplexType(vProps.type);
				vProps = mComplexType.property.map(function(oComplexProperty){
					oComplexProperty = _enrichProperty(oComplexProperty, mEntity);
					oComplexProperty.bindingPath = vProps.name + "/" + oComplexProperty.name;
					oComplexProperty.referencedComplexPropertyName = vProps.fieldLabel || vProps.name;
					return oComplexProperty;
				});
			} else {
				//harmonize structure
				vProps.bindingPath = mProperty.name;
			}
			return aExpandedProperties.concat(vProps);
		}, []);
	}

	function _filterInvisibleProperties(aODataProperties, oElement) {
		return aODataProperties.filter(function(mProperty){
			//see _enrichProperty
			return !mProperty.hidden;
		}).filter(function(mProperty){
			//@runtime hidden by field control value = 0
			var mFieldControlAnnotation = mProperty["com.sap.vocabularies.Common.v1.FieldControl"];
			var sFieldControlPath = mFieldControlAnnotation && mFieldControlAnnotation.Path;
			if (sFieldControlPath){
				var iFieldControlValue = oElement.getBindingContext().getProperty(sFieldControlPath);
				return iFieldControlValue !== 0;
			}
			return true;
		});
	}

	/**
	 * Fetching all available properties of the Element's Model
	 * @param {sap.ui.core.Control} oElement - Control instance
	 * @return {Promise} - Returns Promise with results
	 * @private
	 */
	function _getODataPropertiesOfModel(oElement) {
		var oModel = oElement.getModel();
		var mData = {
			property: [],
			navigationProperty: [],
			navigationEntityNames: []
		};

		if (oModel) {
			var sModelName = oModel.getMetadata().getName();
			if (sModelName === "sap.ui.model.odata.ODataModel" || sModelName === "sap.ui.model.odata.v2.ODataModel") {
				var oMetaModel = oModel.getMetaModel();
				return oMetaModel.loaded().then(function(){
					var oBindingContext = oElement.getBindingContext();
					if (oBindingContext){
						var sBindingContextPath = oBindingContext.getPath();
						var oMetaModelContext = oMetaModel.getMetaContext(sBindingContextPath);
						var mODataEntity = oMetaModelContext.getObject();
						var oDefaultAggregation = oElement.getMetadata().getAggregation();

						if (oDefaultAggregation) {
							var oBinding = oElement.getBindingInfo(oDefaultAggregation.name);
							var oTemplate = oBinding && oBinding.template;

							if (oTemplate) {
								var sPath = oElement.getBindingPath(oDefaultAggregation.name);
								if (sPath) {
									var sFullyQualifiedEntityName = (
										oMetaModel.getODataAssociationEnd(mODataEntity, sPath)
										&& oMetaModel.getODataAssociationEnd(mODataEntity, sPath).type
									);
									var oEntityType = oMetaModel.getODataEntityType(sFullyQualifiedEntityName);
									mODataEntity = oEntityType;
								}
							}
						}

						mData.property = mODataEntity.property || [];
						mData.property = _expandComplexProperties(mData.property, oMetaModel, mODataEntity);
						mData.property = _filterInvisibleProperties(mData.property, oElement);

						if (mODataEntity.navigationProperty){
							mData.navigationProperty = mODataEntity.navigationProperty;
							mODataEntity.navigationProperty.forEach(function(oNavProp){
								var sFullyQualifiedEntityName = (
									oMetaModel.getODataAssociationEnd(mODataEntity, oNavProp.name)
									&& oMetaModel.getODataAssociationEnd(mODataEntity, oNavProp.name).type
								);
								var oEntityType = oMetaModel.getODataEntityType(sFullyQualifiedEntityName);
								if (oEntityType && oEntityType.name){
									if (mData.navigationEntityNames.indexOf(oEntityType.name) === -1){
										mData.navigationEntityNames.push(oEntityType.name);
									}
								}
							});
						}
					}
					return mData;
				});
			}
		}

		return Promise.resolve(mData);
	}

	function _oDataPropertyToAdditionalElementInfo (oODataProperty){
		return {
			selected : false,
			label : oODataProperty.fieldLabel || oODataProperty.name,
			referencedComplexPropertyName: oODataProperty.referencedComplexPropertyName ? oODataProperty.referencedComplexPropertyName : "",
			duplicateComplexName: oODataProperty.duplicateComplexName ? oODataProperty.duplicateComplexName : false,
			tooltip :  oODataProperty.quickInfo || oODataProperty.fieldLabel,
			originalLabel: "",
			//command relevant data
			type : "odata",
			entityType : oODataProperty.entityName,
			name : oODataProperty.name,
			bindingPath : oODataProperty.bindingPath
		};
	}

	function _elementToAdditionalElementInfo (mData){
		var oElement = mData.element;
		var mAction = mData.action;
		return {
			selected : false,
			label : RtaUtils.getLabelForElement(oElement, mAction.getLabel),
			tooltip : RtaUtils.getLabelForElement(oElement, mAction.getLabel),
			referencedComplexPropertyName: oElement.referencedComplexPropertyName ? oElement.referencedComplexPropertyName : "",
			duplicateComplexName: oElement.duplicateComplexName ? oElement.duplicateComplexName : false,
			bindingPaths: oElement.bindingPaths,
			originalLabel: oElement.renamedLabel && oElement.fieldLabel !== oElement.labelFromOData ? oElement.labelFromOData : "",
			//command relevant data
			type : "invisible",
			element : oElement
		};
	}

	/**
	 * Retrieving sibling elements from its parent container which are bound to the same Model (important!)
	 *
	 * @param {sap.ui.core.Control} oElement - element for which we're looking for siblings
	 * @param {sap.ui.core.Control} oRelevantContainer - "parent" container of the oElement
	 *
	 * @return {Array.<sap.ui.core.Control>} - returns an array with found siblings elements
	 *
	 * @private
	 */
	function _getRelevantElements(oElement, oRelevantContainer){
		if (oRelevantContainer && oRelevantContainer !== oElement) {
			var sEntityName = RtaUtils.getEntityTypeByPath(
				oElement.getModel(),
				oElement.getBindingContext().getPath()
			);

			return ElementUtil
				.findAllSiblingsInContainer(oElement, oRelevantContainer)
				// We accept only siblings that are bound on the same model
				.filter(function (oSiblingElement) {
					return RtaUtils.getEntityTypeByPath(
						oSiblingElement.getModel(),
						oSiblingElement.getBindingContext().getPath()
					) === sEntityName;
				});
		} else {
			return [oElement];
		}
	}

	function _checkForComplexDuplicates(aODataProperties) {
		aODataProperties.forEach(function(oODataProperty, index, aODataProperties) {
			if (oODataProperty["duplicateComplexName"] !== true) {
				for (var j = index + 1; j < aODataProperties.length - 1; j++) {
					if (oODataProperty.fieldLabel === aODataProperties[j].fieldLabel) {
						oODataProperty["duplicateComplexName"] = true;
						aODataProperties[j]["duplicateComplexName"] = true;
					}
				}
			}
		});
		return aODataProperties;
	}

	//check for duplicate labels to later add the referenced complexTypeName if available
	function _checkForDuplicateLabels(oInvisibleElement, aODataProperties) {
		return aODataProperties.some(function(oDataProperty) {
			return oDataProperty.fieldLabel === oInvisibleElement.fieldLabel;
		});
	}

	// Get all relevant bindings for the element (from all properties)
	function _collectBindingPaths(oInvisibleElement, oModel){
		oInvisibleElement.bindingPaths = [];
		oInvisibleElement.bindingContextPaths = [];
		var sAggregationName = oInvisibleElement.sParentAggregationName;
		var oParent = oInvisibleElement.getParent();
		var aBindings = BindingsExtractor.getBindings(oInvisibleElement, oModel);

		if (oParent) {
			var oDefaultAggregation = oParent.getMetadata().getAggregation();

			if (oDefaultAggregation) {
				var iPositionOfInvisibleElement = ElementUtil.getAggregation(oParent, sAggregationName).indexOf(oInvisibleElement);
				var sParentDefaultAggregationName = oDefaultAggregation.name;
				var oBinding = oParent.getBindingInfo(sParentDefaultAggregationName);
				var oTemplate = oBinding && oBinding.template;

				if (oTemplate) {
					var oTemplateDefaultAggregation = oTemplate.getMetadata().getAggregation();

					if (oTemplateDefaultAggregation) {
						var sTemplateDefaultAggregationName = oTemplateDefaultAggregation.name;
						var oTemplateElement = ElementUtil.getAggregation(oTemplate, sTemplateDefaultAggregationName)[iPositionOfInvisibleElement];
						aBindings = aBindings.concat(BindingsExtractor.getBindings(oTemplateElement, null, true));
					}
				}
			}
		}

		for (var i = 0, l = aBindings.length; i < l; i++) {
			if (aBindings[i].getPath && aBindings[i].getPath()){
				if (oInvisibleElement.bindingPaths.indexOf(aBindings[i].getPath()) === -1){
					oInvisibleElement.bindingPaths.push(aBindings[i].getPath());
				}
			}
			if (aBindings[i].getContext && aBindings[i].getContext()){
				if (oInvisibleElement.bindingContextPaths.indexOf(aBindings[i].getContext().getPath()) === -1){
					oInvisibleElement.bindingContextPaths.push(aBindings[i].getContext().getPath());
				}
			}
			if (jQuery.isPlainObject(aBindings[i])){
				if (oInvisibleElement.bindingPaths.indexOf(aBindings[i].parts[0].path) === -1){
					oInvisibleElement.bindingPaths.push(aBindings[i].parts[0].path);
				}
			}
		}
		return oInvisibleElement;
	}

	/**
	 * Checks if array of paths is not empty
	 * @param {Array.<String>} aBindingPaths - Array of collected binding paths
	 * @return {Boolean} - true if it has binding(s)
	 * @private
	 */
	function _hasBindings(aBindingPaths) {
		return Array.isArray(aBindingPaths) && aBindingPaths.length > 0;
	}

	/**
	 * Checks if array of paths contains bindings through navigation
	 *
	 * @param {Array.<String>} aBindingPaths - Array of collected binding paths
	 * @param {Array.<Object>} aNavigationProperties - Array of Navigation Properties
	 * @param {Array.<String>} aNavigationEntityNames - Array of Navigation Entity Names
	 * @param {Array.<String>} aBindingContextPaths - Array of Binding Context Paths
	 *
	 * @return {Boolean} - true if it has at least one navigational binding
	 */
	function _hasNavigationBindings(aBindingPaths, aNavigationProperties, aNavigationEntityNames, aBindingContextPaths) {
		var bNavigationInBindingPath = _hasBindings(aBindingPaths)
			&& aBindingPaths.some(function (sPath) {
				var aParts = sPath.trim().replace(/^\//gi, '').split('/');
				if (aParts.length > 1) {
					return aNavigationProperties.indexOf(aParts.shift()) !== -1;
				}
			});

		// BindingContextPath : "/SEPMRA_C_PD_Supplier('100000001')"
		// NavigationEntityName : "SEPMRA_C_PD_Supplier"
		var bNavigationInEntity = aBindingContextPaths.some(function(sContextPath){
			sContextPath = sContextPath.match(/^\/?([A-Za-z0-9_]+)/)[0];
			return (aNavigationEntityNames.indexOf(sContextPath) >= 0);
		});

		return bNavigationInBindingPath || bNavigationInEntity;
	}

	/**
	 * Looks for a ODataProperty for a set of bindings paths
	 *
	 * @param {Array.<String>} aBindingPaths - Array of collected binding paths
	 * @param {Array.<Object>} aODataProperties - Array of Fields
	 *
	 * @return {Object|undefined} - returns first found Object with Field (Property) description, undefined if not found
	 *
	 * @private
	 */
	function _findODataProperty(aBindingPaths, aODataProperties) {
		return aODataProperties.filter(function (oDataProperty) {
			return aBindingPaths.indexOf(oDataProperty.bindingPath) !== -1;
		}).pop();
	}

	/**
	 * Enhance Invisible Element with extra data from OData property
	 *
	 * @param {sap.ui.core.Control} oInvisibleElement - Invisible Element
	 * @param {Object} mODataProperty - ODataProperty as a source of data enhancement process
	 *
	 * @private
	 */
	function _enhanceInvisibleElement(oInvisibleElement, mODataProperty) {
		oInvisibleElement.labelFromOData = mODataProperty.fieldLabel;
		if (oInvisibleElement.fieldLabel !== oInvisibleElement.labelFromOData) {
			oInvisibleElement.renamedLabel = true;
		}
		if (mODataProperty.referencedComplexPropertyName) {
			oInvisibleElement.referencedComplexPropertyName = mODataProperty.referencedComplexPropertyName;
		}
	}

	/**
	 * Checks if this InvisibleProperty should be included in resulting list and adds information
	 * from oDataProperty to the InvisibleProperty if available
	 *
	 * @param {sap.ui.core.Control} oInvisibleElement - Invisible Element
	 * @param {Array.<Object>} aODataProperties - Array of Fields
	 * @param {Array.<Object>} aNavigationProperties - Array of Navigation Properties
	 * @param {Array.<Object>} aNavigationEntityNames - Array of Navigation Entity names
	 *
	 * @return {Boolean} - whether this field is
	 *
	 * @private
	 */
	function _checkAndEnhanceODataProperty(oInvisibleElement, aODataProperties, aNavigationProperties, aNavigationEntityNames) {
		var aBindingPaths = oInvisibleElement.bindingPaths,
			aBindingContextPaths = oInvisibleElement.bindingContextPaths,
			mODataProperty;

		return (
			// include it if the field has no bindings (bindings can be added in runtime)
			!_hasBindings(aBindingPaths)
			// include it if some properties got binding through valid navigations of the current Model
			|| _hasNavigationBindings(aBindingPaths, aNavigationProperties, aNavigationEntityNames, aBindingContextPaths)
			// looking for a corresponding OData property, if it exists oInvisibleElement is being enhanced
			// with extra data from it
			|| (
				(mODataProperty = _findODataProperty(aBindingPaths, aODataProperties))
				&&  (_enhanceInvisibleElement(oInvisibleElement, mODataProperty) || true)
			)
		);
	}

	// API: depending on the available actions for the aggregation call one or both of these methods
	var oAnalyzer = {
		/**
		 * Filters available invisible elements whether they could be shown or not
		 *
		 * @param {sap.ui.core.Control} oParent - Container Element where to start search for a invisible
		 * @param {Object} mActions - Container with actions
		 *
		 * @return {Promise} - returns a Promise which resolves with a list of hidden controls are available to display
		 */
		enhanceInvisibleElements : function(oParent, mActions){
			var oModel = oParent.getModel();
			var mRevealData = mActions.reveal;
			var mAddODataProperty = mActions.addODataProperty;

			return Promise.resolve()
				.then(function () {
					return _getODataPropertiesOfModel(oParent);
				})
				.then(function(mData) {
					var aODataProperties = mData.property;
					var aODataNavigationProperties = mData.navigationProperty.map(function (mNavigation) {
						return mNavigation.name;
					});
					var aODataNavigationEntityNames = mData.navigationEntityNames;

					aODataProperties = _checkForComplexDuplicates(aODataProperties);

					var aAllElementData = [];
					var aInvisibleElements = mRevealData.elements || [];

					aInvisibleElements.forEach(function(oInvisibleElement) {
						var sType = oInvisibleElement.getMetadata().getName();
						var mAction = mRevealData.types[sType].action;
						var bIncludeElement = true;

						if (oParent.getBindingContext() === oInvisibleElement.getBindingContext()) {
							//TODO fix with stashed type support
							oInvisibleElement = _collectBindingPaths(oInvisibleElement, oModel);
							oInvisibleElement.fieldLabel = RtaUtils.getLabelForElement(oInvisibleElement, mAction.getLabel);
							oInvisibleElement.duplicateComplexName = _checkForDuplicateLabels(oInvisibleElement, aODataProperties);

							//Add information from the oDataProperty to the InvisibleProperty if available;
							//if oData is available and the element is not present in it, do not include it
							//Example use case: custom field which was hidden and then removed from system
							//should not be available for adding after the removal
							if (mAddODataProperty && aODataProperties.length > 0){
								bIncludeElement = _checkAndEnhanceODataProperty(oInvisibleElement, aODataProperties, aODataNavigationProperties, aODataNavigationEntityNames);
							}
						} else if (
							oInvisibleElement.getParent()
							&& oInvisibleElement.getBindingContext() === oInvisibleElement.getParent().getBindingContext()
							&& BindingsExtractor.getBindings(oInvisibleElement, oModel).length > 0
						) {
							bIncludeElement = false;
						}

						if (bIncludeElement) {
							aAllElementData.push({
								element : oInvisibleElement,
								action : mAction
							});
						}
					});
					return aAllElementData;
				})
				.then(function(aAllElementData) {
					return aAllElementData.map(_elementToAdditionalElementInfo);
				});
		},

		/**
		 * Retrieves available OData properties from the metadata
		 *
		 * @param {sap.ui.core.Control} oElement - Source element of which Model we're looking for additional properties
		 * @param {Object} mAction - Action descriptor
		 *
		 * @return {Promise} - returns a Promise which resolves with a list of available to display OData properties
		 */
		getUnboundODataProperties: function (oElement, mAction) {
			var oModel = oElement.getModel();

			return Promise.resolve()
				.then(function () {
					return _getODataPropertiesOfModel(oElement);
				})
				.then(function(mData) {
					var aODataProperties = mData.property;
					var aRelevantElements = _getRelevantElements(oElement, mAction.relevantContainer);
					var aBindings = [];

					aRelevantElements.forEach(function(oElement){
						aBindings = aBindings.concat(BindingsExtractor.getBindings(oElement, oModel));
					});

					var fnFilter = mAction.action.filter ? mAction.action.filter : function() {return true;};

					aODataProperties = aODataProperties.filter(function(oDataProperty) {
						var bHasBindingPath = false;
						if (aBindings){
							bHasBindingPath = aBindings.some(function(vBinding) {
								return (
									jQuery.isPlainObject(vBinding)
									? vBinding.parts[0].path
									: !!vBinding.getPath && vBinding.getPath()
								) === oDataProperty.bindingPath;
							});
						}
						return !bHasBindingPath && fnFilter(mAction.relevantContainer, oDataProperty);
					});

					aODataProperties = _checkForComplexDuplicates(aODataProperties);

					return aODataProperties;
				})
				.then(function(aUnboundODataProperties) {
					return aUnboundODataProperties.map(_oDataPropertyToAdditionalElementInfo);
				});
		}
	};
	return oAnalyzer;
});

}; // end of sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.toolbar.Base') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.toolbar.Base'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('sap.m.Toolbar'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.BusyIndicator'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/toolbar/Base",[
	'jquery.sap.global',
	'sap/ui/rta/library',
	'sap/ui/core/Popup',
	'sap/m/Toolbar',
	'sap/ui/core/BusyIndicator',
	'sap/ui/rta/util/Animation'
],
function(
	jQuery,
	library,
	Popup,
	Toolbar,
	BusyIndicator,
	Animation
) {
	"use strict";

	/**
	 * Constructor for a new sap.ui.rta.toolbar.Base control
	 *
	 * @class
	 * Base class for Toolbar control
	 * @extends sap.m.Toolbar
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.rta.toolbar.Base
	 * @experimental Since 1.48. This class is experimental. The API might be changed in future.
	 */

	var Base = Toolbar.extend("sap.ui.rta.toolbar.Base", {
		metadata: {
			library: "sap.ui.rta",
			properties: {
				/** Color in the toolbar */
				"color": {
					type: "string",
					defaultValue: "default"
				},

				/** z-index of the toolbar on the page. Please consider of using bringToFront() function */
				"zIndex": {
					type: "int"
				},

				/** i18n bundle */
				"textResources": "object"
			}
		},
		constructor: function() {
			// call parent constructor
			Toolbar.apply(this, arguments);

			this.setVisible(false);
			this.placeToContainer();
			this.buildContent();
		},

		/**
		 * Defines type of the Toolbar. E.g. fiori, standalone, etc.
		 * @type {string}
		 */
		type: null,

		/**
		 * Defines whether animation is enabled. If true, the CSS class 'is_visible' will be
		 * added/removed during show/hide calls.
		 * @type {boolean}
		 */
		animation: false
	});

	/**
	 * @override
	 */
	Base.prototype.init = function() {
		Toolbar.prototype.init.apply(this, arguments);
	};

	/**
	 * Event handler for onBeforeRendering
	 * @protected
	 */
	Base.prototype.onBeforeRendering = function () {
		Toolbar.prototype.onBeforeRendering.apply(this, arguments);
	};

	/**
	 * Event handler for onAfterRendering
	 * @protected
	 */
	Base.prototype.onAfterRendering = function () {
		Toolbar.prototype.onAfterRendering.apply(this, arguments);
	};

	/**
	 * Event handlers factory
	 * @param {string} sEventName - Name of the event
	 * @param {sap.ui.base.Event} oEvent - Event object
	 */
	Base.prototype.eventHandler = function (sEventName, oEvent) {
		this['fire' + sEventName](oEvent.getParameters());
	};

	/**
	 * Function provides controls which should be rendered into the Toolbar. Controls are going to be rendered
	 * in the same order as provided in returned array.
	 * @return {Array.<sap.ui.core.Control>} - returns an array of controls
	 * @protected
	 */
	Base.prototype.buildControls = function () {
		return [];
	};

	/**
	 * Function renders the Toolbar into the page
	 * @protected
	 */
	Base.prototype.placeToContainer = function () {
		// Render toolbar
		this.placeAt(jQuery('#sap-ui-static').get(0));
	};

	/**
	 * Adds content into the Toolbar
	 * @protected
	 */
	Base.prototype.buildContent = function () {
		this.buildControls().forEach(this.addContent, this);
	};

	/**
	 * Makes the Toolbar visible
	 * @return {Promise} - returns Promise which resolves after animation has been completed
	 * @public
	 */
	Base.prototype.show = function() {
		// 1) create Promise and wait until DomRef is available
		return new Promise(function (fnResolve) {
			var oDelegate = {
				onAfterRendering: function () {
					this.removeEventDelegate(oDelegate);
					fnResolve();
				}
			};
			this.addEventDelegate(oDelegate, this);
			this.bringToFront();
			this.setVisible(true); // show DomRef
		}.bind(this))
		// 2) animate DomRef
		.then(function () {
			return this.animation
				? Animation.waitTransition(this.$(), this.addStyleClass.bind(this, 'is_visible'))
				: Promise.resolve();
		}.bind(this))
		// 3) focus on Toolbar
		.then(function () {
			this.focus();
		}.bind(this));
	};

	/**
	 * Makes the Toolbar invisible
	 * @return {Promise} - returns Promise which resolves after animation has been completed
	 * @public
	 */
	Base.prototype.hide = function() {
		// 1) animate DomRef
		return (
			this.animation
			? Animation.waitTransition(this.$(), this.removeStyleClass.bind(this, 'is_visible'))
			: Promise.resolve()
		)
		// 2) hide DomRef
		.then(function () {
			this.setVisible(false);
		}.bind(this));
	};

	/**
	 * Getter for inner controls
	 * @param {string} sName - Name of the control
	 * @return {sap.ui.core.Control|undefined} - returns control or undefined if there is no control with provided name
	 * @public
	 */
	Base.prototype.getControl = function(sName) {
		return this
			.getAggregation('content')
			.filter(function (oControl) {
				return oControl.data('name') === sName;
			})
			.pop();
	};

	/**
	 * Place the Toolbar above everything on the page
	 * @public
	 */
	Base.prototype.bringToFront = function () {
		var iNextZIndex;
		var oBusyIndicatorPopup = BusyIndicator.oPopup;

		if (oBusyIndicatorPopup && oBusyIndicatorPopup.isOpen() && oBusyIndicatorPopup.getModal()) {
			// '-3' because overlay is on the '-2' level, see implementation of the sap.ui.core.Popup
			iNextZIndex = oBusyIndicatorPopup._iZIndex - 3;
		} else {
			iNextZIndex = Popup.getNextZIndex();
		}

		this.setZIndex(iNextZIndex);
	};

	/**
	 * Backwards compatibility
	 */
	Base.prototype.setUndoRedoEnabled = function () {};
	Base.prototype.setPublishEnabled = function () {};
	Base.prototype.setRestoreEnabled = function () {};

	return Base;

}, true);

}; // end of sap/ui/rta/toolbar/Base.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.toolbar.Personalization') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.toolbar.Personalization'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.ToolbarSpacer'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/toolbar/Personalization",[
	'./Base',
	'sap/m/ToolbarSpacer'
],
function(
	Base,
	ToolbarSpacer
) {
	"use strict";

	/**
	 * Constructor for a new sap.ui.rta.toolbar.Personalization control
	 *
	 * @class
	 * Contains implementation of personalization specific toolbar
	 * @extends sap.ui.rta.toolbar.Base
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.rta.toolbar.Personalization
	 * @experimental Since 1.48. This class is experimental. API might be changed in future.
	 */
	var Personalization = Base.extend("sap.ui.rta.toolbar.Personalization", {
		renderer: 'sap.ui.rta.toolbar.BaseRenderer',
		type: 'personalization',
		metadata: {
			events: {
				/**
				 * Events are fired when the Toolbar - Buttons are pressed
				 */
				"exit": {},
				"restore": {}
			}
		}
	});

	Personalization.prototype.buildControls = function() {
		var aControls = [
			new ToolbarSpacer(),
			new sap.m.Button({
				type: "Transparent",
				text: this.getTextResources().getText("BTN_RESTORE"),
				tooltip: this.getTextResources().getText("BTN_RESTORE"),
				visible: true,
				press: this.eventHandler.bind(this, 'Restore')
			}).data('name', 'restore'),
			new sap.m.Button({
				type:"Emphasized",
				text: this.getTextResources().getText("BTN_DONE"),
				tooltip: this.getTextResources().getText("BTN_DONE_TOOLTIP"),
				press: this.eventHandler.bind(this, 'Exit')
			}).data('name', 'exit')
		];

		return aControls;
	};

	Personalization.prototype.setUndoRedoEnabled = function() {
	};

	Personalization.prototype.setPublishEnabled = function() {
	};

	Personalization.prototype.setRestoreEnabled = function (bEnabled) {
		this.getControl('restore').setEnabled(bEnabled);
	};

	return Personalization;

}, true);

}; // end of sap/ui/rta/toolbar/Personalization.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.CutPaste') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.CutPaste.
jQuery.sap.declare('sap.ui.rta.plugin.CutPaste'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.plugin.CutPaste'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayUtil'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/CutPaste",[
	'jquery.sap.global',
	'sap/ui/dt/plugin/CutPaste',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/rta/plugin/RTAElementMover',
	'sap/ui/rta/Utils'
],
function(
	jQuery,
	ControlCutPaste,
	OverlayUtil,
	Plugin,
	RTAElementMover,
	Utils
) {
	"use strict";

	/**
	 * Constructor for a new CutPaste plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The CutPaste plugin adds functionality/styling required for RTA.
	 * @extends sap.ui.dt.plugin.CutPaste
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.rta.plugin.CutPaste
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var CutPaste = ControlCutPaste.extend("sap.ui.rta.plugin.CutPaste", /** @lends sap.ui.rta.plugin.CutPaste.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.rta",
			properties : {
				commandFactory : {
					type : "object",
					multiple : false
				}
			},
			events : {
				dragStarted : {},

				elementModified : {
					command : {
						type : "sap.ui.rta.command.BaseCommand"
					}
				}
			}
		}
	});

	// Extends the CutPaste Plugin with all the functions from our rta base plugin
	Utils.extendWith(CutPaste.prototype, Plugin.prototype, function(vDestinationValue, vSourceValue, sProperty, mDestination, mSource) {
		return sProperty !== "getMetadata";
	});

	/**
	 * @override
	 */
	CutPaste.prototype.init = function() {
		ControlCutPaste.prototype.init.apply(this, arguments);
		this.setElementMover(new RTAElementMover({commandFactory: this.getCommandFactory()}));
	};

	/**
	 * @override
	 */
	CutPaste.prototype._isEditable = function(oOverlay, mPropertyBag) {
		return this.getElementMover().isEditable(oOverlay, mPropertyBag.onRegistration) || this._isPasteEditable(oOverlay);
	};

	CutPaste.prototype._isPasteEditable = function (oOverlay) {
		var	oDesignTimeMetadata = oOverlay.getDesignTimeMetadata();

		return this.hasStableId(oOverlay) &&
			this.getElementMover()._isMoveAvailableOnRelevantContainer(oOverlay) &&
			oDesignTimeMetadata.isActionAvailableOnAggregations("move");
	};

	/**
	 * @override
	 * @param  {sap.ui.dt.Overlay}  oOverlay Selected overlay
	 * @return {boolean}        Returns true if the plugin is available
	 */
	CutPaste.prototype.isAvailable = function(oOverlay) {
		return oOverlay.getMovable();
	};

	/**
	 * Register an overlay
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	CutPaste.prototype.registerElementOverlay = function(oOverlay) {
		ControlCutPaste.prototype.registerElementOverlay.apply(this, arguments);
		Plugin.prototype.registerElementOverlay.apply(this, arguments);
	};

	/**
	 * Additionally to super->deregisterOverlay this method detatches the browser events
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	CutPaste.prototype.deregisterElementOverlay = function(oOverlay) {
		ControlCutPaste.prototype.deregisterElementOverlay.apply(this, arguments);
		Plugin.prototype.removeFromPluginsList.apply(this, arguments);
	};

	/**
	 * @override
	 */
	CutPaste.prototype.paste = function(oTargetOverlay) {

		this._executePaste(oTargetOverlay);

		this.fireElementModified({
			"command" : this.getElementMover().buildMoveCommand()
		});

		this.stopCutAndPaste();
	};

	/**
	 * Retrieve the context menu item for the actions.
	 * Two items are returned here: one for "cut" and one for "paste".
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay Overlay for which the context menu was opened
	 * @return {object[]}          Returns array containing the items with required data
	 */
	CutPaste.prototype.getMenuItems = function(oOverlay){
		var aMenuItems = [],
			oCutMenuItem = {
				id: 'CTX_CUT',
				text: sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_CUT'),
				handler: function(aOverlays){
					return this.cut(aOverlays[0]);
				}.bind(this),
				enabled: function (){
					return this.getDesignTime().getSelection().length === 1;
				}.bind(this),
				rank: 70
			},
			oPasteMenuItem = {
				id: 'CTX_PASTE',
				text: sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_PASTE'),
				handler: function(aOverlays){
					return this.paste(aOverlays[0]);
				}.bind(this),
				enabled: function(oOverlay) {
					return this.isElementPasteable(oOverlay);
				}.bind(this),
				rank: 80
			};

		if (this.isAvailable(oOverlay)){
			aMenuItems.push(oCutMenuItem, oPasteMenuItem);
		} else if (this._isPasteEditable(oOverlay)) {
			aMenuItems.push(oPasteMenuItem);
		}

		return aMenuItems;
	};

	return CutPaste;
}, /* bExport= */ true);

}; // end of sap/ui/rta/plugin/CutPaste.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.plugin.DragDrop') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.DragDrop.
jQuery.sap.declare('sap.ui.rta.plugin.DragDrop'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.plugin.ControlDragDrop'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/plugin/DragDrop",[
	'jquery.sap.global',
	'sap/ui/dt/plugin/ControlDragDrop',
	'sap/ui/rta/plugin/RTAElementMover',
	'sap/ui/rta/plugin/Plugin',
	'sap/ui/rta/Utils'
],
function(
	jQuery,
	ControlDragDrop,
	RTAElementMover,
	Plugin,
	Utils
) {
	"use strict";

	/**
	 * Constructor for a new DragDrop plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The DragDrop plugin adds functionality/styling required for RTA.
	 * @extends sap.ui.dt.plugin.ControlDragDrop
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.rta.plugin.DragDrop
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var DragDrop = ControlDragDrop.extend("sap.ui.rta.plugin.DragDrop", /** @lends sap.ui.rta.plugin.DragDrop.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.rta",
			properties : {
				commandFactory : {
					type : "object",
					multiple : false
				}
			},
			events : {
				dragStarted : {},

				elementModified : {
					command : {
						type : "sap.ui.rta.command.BaseCommand"
					}
				}
			}
		}
	});

	// Extends the DragDrop Plugin with all the functions from our rta base plugin
	Utils.extendWith(DragDrop.prototype, Plugin.prototype, function(vDestinationValue, vSourceValue, sProperty, mDestination, mSource) {
		return sProperty !== "getMetadata";
	});

	/**
	 * @override
	 */
	DragDrop.prototype.init = function() {
		ControlDragDrop.prototype.init.apply(this, arguments);
		this.setElementMover(new RTAElementMover({commandFactory: this.getCommandFactory()}));
	};

	DragDrop.prototype.setCommandFactory = function(oCommandFactory) {
		this.setProperty("commandFactory", oCommandFactory);
		this.getElementMover().setCommandFactory(oCommandFactory);
	};

	/**
	 * @override
	 */
	DragDrop.prototype._isEditable = function(oOverlay, mPropertyBag) {
		var bMovable = this.getElementMover().isEditable(oOverlay, mPropertyBag.onRegistration);
		if (bMovable) {
			this._attachMovableBrowserEvents(oOverlay);
		}
		return bMovable;
	};

	/**
	 * Register an overlay
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	DragDrop.prototype.registerElementOverlay = function(oOverlay) {
		ControlDragDrop.prototype.registerElementOverlay.apply(this, arguments);
		Plugin.prototype.registerElementOverlay.apply(this, arguments);
	};

	/**
	 * Additionally to super->deregisterOverlay this method detatches the browser events
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	DragDrop.prototype.deregisterElementOverlay = function(oOverlay) {
		ControlDragDrop.prototype.deregisterElementOverlay.apply(this, arguments);
		Plugin.prototype.removeFromPluginsList.apply(this, arguments);
		this._detachMovableBrowserEvents(oOverlay);
	};

	/**
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @private
	 */
	DragDrop.prototype._attachMovableBrowserEvents = function(oOverlay) {
		oOverlay.attachBrowserEvent("mouseover", this._onMouseOver, this);
		oOverlay.attachBrowserEvent("mouseleave", this._onMouseLeave, this);
	};

	/**
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @private
	 */
	DragDrop.prototype._detachMovableBrowserEvents = function(oOverlay) {
		oOverlay.detachBrowserEvent("mouseover", this._onMouseOver, this);
		oOverlay.detachBrowserEvent("mouseleave", this._onMouseLeave, this);
	};


	/**
	 * Additionally to super->onDragStart this method stores the parent's id in an instance variable
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	DragDrop.prototype.onDragStart = function(oOverlay) {
		this.fireDragStarted();

		ControlDragDrop.prototype.onDragStart.apply(this, arguments);

		this.getDesignTime().getSelection().forEach(function(oOverlay) {
			oOverlay.setSelected(false);
		});

		oOverlay.$().addClass("sapUiRtaOverlayPlaceholder");
	};

	/**
	 * Additionally to super->onDragEnd this method takes care about moving the element
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	DragDrop.prototype.onDragEnd = function(oOverlay) {
		this.fireElementModified({
			"command" : this.getElementMover().buildMoveCommand()
		});

		oOverlay.$().removeClass("sapUiRtaOverlayPlaceholder");
		oOverlay.setSelected(true);
		oOverlay.focus();

		ControlDragDrop.prototype.onDragEnd.apply(this, arguments);
	};

	/**
	 * If overlay is draggable attach browser events o overlay. If not remove them.
	 * @param  {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	DragDrop.prototype.onMovableChange = function(oOverlay) {
		ControlDragDrop.prototype.onMovableChange.apply(this, arguments);
		if (oOverlay.isMovable()) {
			this._attachMovableBrowserEvents(oOverlay);
		} else {
			this._detachMovableBrowserEvents(oOverlay);
		}
	};
	/**
	 * Handle mouse over event
	 * @param  {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	DragDrop.prototype._onMouseOver = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		if (oOverlay !== this._oPreviousHoverTarget) {
			if (this._oPreviousHoverTarget) {
				this._oPreviousHoverTarget.$().removeClass("sapUiRtaOverlayHover");
			}
			this._oPreviousHoverTarget = oOverlay;
			oOverlay.$().addClass("sapUiRtaOverlayHover");
		}
		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	/**
	 * Handle mouse leave event
	 * @param  {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	DragDrop.prototype._onMouseLeave = function(oEvent) {
		if (this._oPreviousHoverTarget) {
			this._oPreviousHoverTarget.$().removeClass("sapUiRtaOverlayHover");
		}
		delete this._oPreviousHoverTarget;
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	return DragDrop;
}, /* bExport= */ true);

}; // end of sap/ui/rta/plugin/DragDrop.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.toolbar.Adaptation') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.toolbar.Adaptation'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.ToolbarSpacer'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.SegmentedButton'); // unlisted dependency retained
jQuery.sap.require('sap.m.SegmentedButtonItem'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/toolbar/Adaptation",[
	'sap/m/ToolbarSpacer',
	'sap/m/Button',
	'sap/m/SegmentedButton',
	'sap/m/SegmentedButtonItem',
	'./Base'
],
function(
	ToolbarSpacer,
	Button,
	SegmentedButton,
	SegmentedButtonItem,
	Base
) {
	"use strict";

	/**
	 * Constructor for a new sap.ui.rta.toolbar.Adaptation control
	 *
	 * @class
	 * Contains implementation of Adaptation toolbar
	 * @extends sap.ui.rta.toolbar.Base
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.rta.toolbar.Adaptation
	 * @experimental Since 1.48. This class is experimental. API might be changed in future.
	 */
	var Adaptation = Base.extend("sap.ui.rta.toolbar.Adaptation", {
		renderer: 'sap.ui.rta.toolbar.BaseRenderer',
		animation: true,
		metadata: {
			events: {
				/**
				 * Events are fired when the Toolbar Buttons are pressed
				 */
				"undo": {},
				"redo": {},
				"exit": {},
				"restore": {},
				"transport": {},
				"modeChange": {},
				"manageApps": {},
				"saveAs": {}
			},
			properties: {
				/** Determines whether publish button is visible */
				"publishVisible": {
					"type": "boolean",
					"defaultValue": false
				},

				/** Defines value of the switcher SegmentedButton */
				"modeSwitcher": {
					type: "string",
					defaultValue: "adaptation"
				},

				/** Determines whether Message information icon button and 'Save As' button are visible */
				"appVariantFeaturesSupported": {
					"type": "boolean",
					"defaultValue": false
				}
			}
		}
	});

	Adaptation.prototype.onAfterRendering = function () {
		var iSign = -1;
		var bIgnore = false;
		var iWidth = this.getAggregation('content').reduce(function (iResult, oControl) {
			switch (oControl.data('name')) {
				case 'spacerLeft':
					iSign = 1;
					bIgnore = true;
					break;
				case 'spacerRight':
					bIgnore = false;
					break;
			}
			return !(oControl instanceof ToolbarSpacer) && !bIgnore
				? iResult + iSign * oControl.$().outerWidth(true)
				: iResult;
		}, 0);

		if (iWidth > 0) {
			this.getControl('spacerBalancer').setWidth(iWidth + 'px');
		}

		Base.prototype.onAfterRendering.apply(this, arguments);
	};

	Adaptation.prototype.buildControls = function () {
		return [
			new ToolbarSpacer().data('name', 'spacerBalancer'),
			new ToolbarSpacer().data('name', 'spacerLeft'),
			new SegmentedButton({
				width: "auto",
				selectedKey: this.getModeSwitcher(),
				items: [
					new SegmentedButtonItem({
						text: this.getTextResources().getText("BTN_ADAPTATION"),
						tooltip: this.getTextResources().getText("BTN_ADAPTATION"),
						width: "auto",
						key: "adaptation"
					}),
					new SegmentedButtonItem({
						text: this.getTextResources().getText("BTN_NAVIGATION"),
						tooltip: this.getTextResources().getText("BTN_NAVIGATION"),
						width: "auto",
						key: "navigation"
					})
				],
				select: this.eventHandler.bind(this, 'ModeChange')
			}).data('name', 'modeSwitcher'),
			new ToolbarSpacer().data('name', 'spacerRight'),
			new Button({
				type: "Transparent",
				icon: "sap-icon://undo",
				enabled: false,
				tooltip: this.getTextResources().getText("BTN_UNDO"),
				press: this.eventHandler.bind(this, 'Undo')
			}).data('name', 'undo'),
			new Button({
				type:"Transparent",
				icon: "sap-icon://redo",
				iconFirst: false,
				enabled: false,
				tooltip: this.getTextResources().getText("BTN_REDO"),
				press: this.eventHandler.bind(this, 'Redo')
			}).data('name', 'redo'),
			new Button({
				type:"Transparent",
				icon: "sap-icon://message-information",
				visible: this.getAppVariantFeaturesSupported(),
				tooltip: this.getTextResources().getText("BTN_MANAGE_APPS"),
				press: this.eventHandler.bind(this, 'ManageApps')
			}).data('name', 'manageApps'),
			new Button({
				type: "Transparent",
				text: this.getTextResources().getText("BTN_RESTORE"),
				visible: true,
				enabled: false,
				tooltip: this.getTextResources().getText("BTN_RESTORE"),
				press: this.eventHandler.bind(this, 'Restore')
			}).data('name', 'restore'),
			new sap.m.Button({
				type: "Transparent",
				enabled: false,
				visible: this.getPublishVisible(),
				text: this.getTextResources().getText("BTN_PUBLISH"),
				tooltip: this.getTextResources().getText("BTN_PUBLISH"),
				press: this.eventHandler.bind(this, 'Transport') // Fixme: rename event
			}).data('name', 'publish'),
			new Button({
				type: "Transparent",
				text: this.getTextResources().getText("BTN_SAVE_AS"),
				visible: this.getAppVariantFeaturesSupported(),
				tooltip: this.getTextResources().getText("TOOLTIP_SAVE_AS"),
				press: this.eventHandler.bind(this, 'SaveAs')
			}).data('name', 'saveAs'),
			new Button({
				type:"Transparent",
				text: this.getTextResources().getText("BTN_EXIT"),
				tooltip: this.getTextResources().getText("BTN_EXIT"),
				press: this.eventHandler.bind(this, 'Exit')
			}).data('name', 'exit')
		];
	};

	Adaptation.prototype.setUndoRedoEnabled = function (bCanUndo, bCanRedo) {
		this.getControl('undo').setEnabled(bCanUndo);
		this.getControl('redo').setEnabled(bCanRedo);
	};

	Adaptation.prototype.setPublishEnabled = function (bEnabled) {
		this.getControl('publish').setEnabled(bEnabled);
	};

	Adaptation.prototype.setRestoreEnabled = function (bEnabled) {
		this.getControl('restore').setEnabled(bEnabled);
	};

	/* Methods propagation */
	Adaptation.prototype.show = function () { return Base.prototype.show.apply(this, arguments); };
	Adaptation.prototype.hide = function () { return Base.prototype.hide.apply(this, arguments); };


	return Adaptation;

}, true);

}; // end of sap/ui/rta/toolbar/Adaptation.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.toolbar.Fiori') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.toolbar.Fiori'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.Image'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/toolbar/Fiori",[
	'sap/m/Image',
	'./Adaptation',
	'../Utils'
],
function(
	Image,
	Adaptation,
	Utils
) {
	"use strict";

	/**
	 * This class is being assigned to the original Fiori Header Toolbar when RTA Toolbar shows
	 * @type {string}
	 */
	var FIORI_HIDDEN_CLASS = 'sapUiRtaFioriHeaderInvisible';

	/**
	 * Constructor for a new sap.ui.rta.toolbar.Fiori control
	 *
	 * @class
	 * Contains implementation of Fiori specific toolbar
	 * @extends sap.ui.rta.toolbar.Adaptation
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.rta.toolbar.Fiori
	 * @experimental Since 1.48. This class is experimental. API might be changed in future.
	 */
	var Fiori = Adaptation.extend("sap.ui.rta.toolbar.Fiori", {
		renderer: 'sap.ui.rta.toolbar.BaseRenderer',
		type: 'fiori'
	});

	Fiori.prototype.init = function () {
		Adaptation.prototype.init.apply(this, arguments);

		this._oRenderer = Utils.getFiori2Renderer();
		this._oFioriHeader = this._oRenderer.getRootControl().getOUnifiedShell().getHeader();
	};

	Fiori.prototype.show = function () {
		this._oFioriHeader.addStyleClass(FIORI_HIDDEN_CLASS);

		return Adaptation.prototype.show.apply(this, arguments);
	};

	Fiori.prototype.buildControls = function () {
		var aControls = Adaptation.prototype.buildControls.apply(this, arguments);
		var sLogoPath = this._oFioriHeader.getLogo();

		if (this._oFioriHeader.getShowLogo() && sLogoPath) {
			// Unstable: if FLP changes ID of <img/> element, logo could be not found
			var $logo = this._oFioriHeader.$().find('#shell-header-icon');
			var iWidth, iHeight;

			if ($logo.length) {
				var iNaturalWidth = $logo.get(0).naturalWidth;
				var iNaturalHeight = $logo.get(0).naturalHeight;
				iWidth = $logo.width();
				iHeight = $logo.height();

				if (iWidth !== iNaturalWidth || iHeight !== iNaturalHeight) {
					jQuery.sap.log.error([
						"sap.ui.rta: please check Fiori Launchpad logo, expected size is",
						iWidth + "x" + iHeight + ",",
						"but actual is " + iNaturalWidth + "x" + iNaturalHeight
					].join(' '));
				}
			}

			aControls.unshift(
				new Image({
					src: sLogoPath,
					width: iWidth ? iWidth + 'px' : iWidth,
					height: iHeight ? iHeight + 'px' : iHeight
				}).data('name', 'logo')
			);
		}

		return aControls;
	};

	Fiori.prototype.hide = function () {
		return Adaptation.prototype
			.hide.apply(this, arguments)
			.then(function () {
				this._oFioriHeader.removeStyleClass(FIORI_HIDDEN_CLASS);
			}.bind(this));
	};

	return Fiori;

}, true);

}; // end of sap/ui/rta/toolbar/Fiori.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.toolbar.Standalone') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.rta.toolbar.Standalone'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/rta/toolbar/Standalone",[
	'./Adaptation'
],
function(
	Adaptation
) {
	"use strict";

	/**
	 * Constructor for a new sap.ui.rta.toolbar.Standalone control
	 *
	 * @class
	 * Contains implementation of Standalone toolbar
	 * @extends sap.ui.rta.toolbar.Adaptation
	 *
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.rta.toolbar.Standalone
	 * @experimental Since 1.48. This class is experimental. API might be changed in future.
	 */
	var Standalone = Adaptation.extend("sap.ui.rta.toolbar.Standalone", {
		renderer: 'sap.ui.rta.toolbar.BaseRenderer',
		type: 'standalone'
	});

	return Standalone;

}, true);

}; // end of sap/ui/rta/toolbar/Standalone.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.RuntimeAuthoring') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.Main.
jQuery.sap.declare('sap.ui.rta.RuntimeAuthoring'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.ElementUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.DesignTime'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.OverlayRegistry'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.Overlay'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.plugin.ContextMenu'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.plugin.TabHandling'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.FlexControllerFactory'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.transport.Transports'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.transport.TransportSelection'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.registry.Settings'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageBox'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageToast'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.BusyIndicator'); // unlisted dependency retained
jQuery.sap.require('sap.ui.dt.DOMUtil'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/RuntimeAuthoring",[
		"jquery.sap.global",
		"sap/ui/base/ManagedObject",
		"sap/ui/rta/toolbar/Fiori",
		"sap/ui/rta/toolbar/Standalone",
		"sap/ui/rta/toolbar/Personalization",
		"sap/ui/dt/ElementUtil",
		"sap/ui/dt/DesignTime",
		"sap/ui/dt/OverlayRegistry",
		"sap/ui/dt/Overlay",
		"sap/ui/rta/command/Stack",
		"sap/ui/rta/command/CommandFactory",
		"sap/ui/rta/command/LREPSerializer",
		"sap/ui/rta/plugin/Rename",
		"sap/ui/rta/plugin/DragDrop",
		"sap/ui/rta/plugin/RTAElementMover",
		"sap/ui/rta/plugin/CutPaste",
		"sap/ui/rta/plugin/Remove",
		"sap/ui/rta/plugin/CreateContainer",
		"sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin",
		"sap/ui/rta/plugin/additionalElements/AddElementsDialog",
		"sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer",
		"sap/ui/rta/plugin/Combine",
		"sap/ui/rta/plugin/Split",
		"sap/ui/rta/plugin/Selection",
		"sap/ui/rta/plugin/Settings",
		"sap/ui/dt/plugin/ContextMenu",
		"sap/ui/dt/plugin/TabHandling",
		"sap/ui/fl/FlexControllerFactory",
		"sap/ui/rta/Utils",
		"sap/ui/fl/transport/Transports",
		"sap/ui/fl/transport/TransportSelection",
		"sap/ui/fl/Utils",
		"sap/ui/fl/registry/Settings",
		"sap/m/MessageBox",
		"sap/m/MessageToast",
		"sap/ui/rta/util/PopupManager",
		"sap/ui/core/BusyIndicator",
		"sap/ui/dt/DOMUtil",
		"sap/ui/rta/util/StylesLoader",
		"sap/ui/rta/appVariant/Feature",
		"sap/ui/Device"
	],
	function(
		jQuery,
		ManagedObject,
		FioriToolbar,
		StandaloneToolbar,
		PersonalizationToolbar,
		ElementUtil,
		DesignTime,
		OverlayRegistry,
		Overlay,
		CommandStack,
		CommandFactory,
		LREPSerializer,
		RTARenamePlugin,
		RTADragDropPlugin,
		RTAElementMover,
		CutPastePlugin,
		RemovePlugin,
		CreateContainerPlugin,
		AdditionalElementsPlugin,
		AdditionalElementsDialog,
		AdditionalElementsAnalyzer,
		CombinePlugin,
		SplitPlugin,
		SelectionPlugin,
		SettingsPlugin,
		ContextMenuPlugin,
		TabHandlingPlugin,
		FlexControllerFactory,
		Utils,
		Transports,
		TransportSelection,
		FlexUtils,
		FlexSettings,
		MessageBox,
		MessageToast,
		PopupManager,
		BusyIndicator,
		DOMUtil,
		StylesLoader,
		RtaAppVariantFeature,
		Device
	) {
	"use strict";

	var FL_MAX_LAYER_PARAM = "sap-ui-fl-max-layer";

	/**
	 * Constructor for a new sap.ui.rta.RuntimeAuthoring class.
	 *
	 * @class The runtime authoring allows to adapt the fields of a running application.
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP SE
	 * @version 1.52.30
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.rta.RuntimeAuthoring
	 * @experimental This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var RuntimeAuthoring = ManagedObject.extend("sap.ui.rta.RuntimeAuthoring", /** @lends sap.ui.rta.RuntimeAuthoring.prototype */
	{
		metadata : {
			// ---- control specific ----
			library : "sap.ui.rta",
			associations : {
				/** The root control which the runtime authoring should handle */
				"rootControl" : {
					type : "sap.ui.core.Control"
				}
			},
			properties : {
				/** The URL which is called when the custom field dialog is opened */
				"customFieldUrl" : "string",

				/** Whether the create custom field button should be shown */
				"showCreateCustomField" : "boolean",

				/** Whether the create custom field button should be shown */
				"showToolbars" : {
					type : "boolean",
					defaultValue : true
				},

				/** Whether rta is triggered from a dialog button */
				"triggeredFromDialog" : {
					type : "boolean",
					defaultValue : false
				},

				/** Whether the window unload dialog should be shown */
				"showWindowUnloadDialog" : {
					type : "boolean",
					defaultValue : true
				},

				/** sap.ui.rta.command.Stack */
				"commandStack" : {
					type : "any"
				},

				/** Map indicating plugins in to be loaded or in use by RuntimeAuthoring and DesignTime */
				"plugins" : {
					type : "any",
					defaultValue : {}
				},


				/**
				 * Map with flex-related settings
				 * @experimental
				 */
				"flexSettings": {
					type: "object",
					defaultValue: {
						layer: "CUSTOMER",
						developerMode: true
					}
				},

				/** Defines view state of the RTA. Possible values: adaptation, navigation */
				"mode" : {
					type: "string",
					defaultValue: "adaptation"
				}
			},
			events : {
				/** Fired when the runtime authoring is started */
				"start" : {
					parameters: {
						editablePluginsCount: {
							type: "int"
						}
					}
				},

				/** Fired when the runtime authoring is stopped */
				"stop" : {},

				/** Fired when the runtime authoring failed to start */
				"failed" : {},

				/**
				 * Event fired when a DesignTime selection is changed
				 */
				"selectionChange" : {
					parameters : {
						selection : { type : "sap.ui.dt.Overlay[]" }
					}
				},
				/**Event fired when the runtime authoring mode is changed */
				"modeChanged" : {},

				/**
				 * Fired when the undo/redo stack has changed, undo/redo buttons can be updated
				 */
				"undoRedoStackModified" : {}
			}
		},
		_sAppTitle : null,
		_dependents: null,
		constructor: function() {
			// call parent constructor
			ManagedObject.apply(this, arguments);

			this._dependents = {};
			this.iEditableOverlaysCount = 0;

			this.addDependent(new PopupManager(), 'popupManager');

			if (this.getShowToolbars()) {
				this.getPopupManager().attachOpen(this.onPopupOpen, this);
				this.getPopupManager().attachClose(this.onPopupClose, this);
			}
		}
	});

	/**
	 * Returns (and creates) the default plugins of RuntimeAuthoring
	 *
	 * These are AdditionalElements, ContextMenu, CreateContainer, CutPaste,
	 * DragDrop, Remove, Rename, Selection, Settings, TabHandling
	 *
	 * Method uses a local cache to hold the default plugins: Then on multiple access
	 * always the same instances get returned.
	 *
	 * @public
	 * @return {map} Map with plugins
	 */
	RuntimeAuthoring.prototype.getDefaultPlugins = function() {
		if (!this._mDefaultPlugins) {
			var oCommandFactory = new CommandFactory({
				flexSettings: this.getFlexSettings()
			});

			// Initialize local cache
			this._mDefaultPlugins = {};

			// Selection
			this._mDefaultPlugins["selection"] = new SelectionPlugin({
				commandFactory: oCommandFactory,
				multiSelectionRequiredPlugins: [
					CombinePlugin.getMetadata().getName(),
					RemovePlugin.getMetadata().getName()
				],
				elementEditableChange: this._onElementEditableChange.bind(this)
			});

			// Drag drop plugin
			var oRTAElementMover = new RTAElementMover({
				commandFactory: oCommandFactory
			});

			this._mDefaultPlugins["dragDrop"] = new RTADragDropPlugin({
				elementMover: oRTAElementMover,
				commandFactory: oCommandFactory,
				dragStarted: this._handleStopCutPaste.bind(this)
			});

			// Rename
			this._mDefaultPlugins["rename"] = new RTARenamePlugin({
				commandFactory: oCommandFactory,
				editable: this._handleStopCutPaste.bind(this)
			});

			// Additional elements
			this._mDefaultPlugins["additionalElements"] = new AdditionalElementsPlugin({
				commandFactory: oCommandFactory,
				analyzer: AdditionalElementsAnalyzer,
				dialog: new AdditionalElementsDialog()
			});

			// Create container
			this._mDefaultPlugins["createContainer"] = new CreateContainerPlugin({
				commandFactory: oCommandFactory
			});

			// Remove
			this._mDefaultPlugins["remove"] = new RemovePlugin({
				commandFactory: oCommandFactory
			});

			// Cut paste
			this._mDefaultPlugins["cutPaste"] = new CutPastePlugin({
				elementMover: oRTAElementMover,
				commandFactory: oCommandFactory
			});

			// Settings
			this._mDefaultPlugins["settings"] = new SettingsPlugin({
				commandFactory: oCommandFactory
			});

			// Combine
			this._mDefaultPlugins["combine"] = new CombinePlugin({
				commandFactory: oCommandFactory
			});

			// Split
			this._mDefaultPlugins["split"] = new SplitPlugin({
				commandFactory: oCommandFactory
			});

			// Context Menu
			this._mDefaultPlugins["contextMenu"] = new ContextMenuPlugin({
				styleClass: Utils.getRtaStyleClassName()
			});

			// Tab Handling
			this._mDefaultPlugins["tabHandling"] = new TabHandlingPlugin();
		}

		return jQuery.extend({}, this._mDefaultPlugins);
	};


	RuntimeAuthoring.prototype.addDependent = function (oObject, sName) {
		if (!(sName in this._dependents)) {
			if (sName) {
				this['get' + jQuery.sap.charToUpperCase(sName, 0)] = this.getDependent.bind(this, sName);
			}
			this._dependents[sName || oObject.getId()] = oObject;
		}
	};

	RuntimeAuthoring.prototype.getDependent = function(sName) {
		return this._dependents[sName];
	};

	RuntimeAuthoring.prototype.getDependents = function() {
		return this._dependents;
	};

	/**
	 * In order to clear the cache and to destroy the default plugins on exit use
	 * _destroyDefaultPlugins()
	 *
	 * In order to destroy default plugins not used, because replaced or removed,
	 * pass the list of active plugins: _destroyDefaultPlugins( mPluginsToKeep ).
	 *
	 * @param {map} mPluginsToKeep - list of active plugins to keep in _mDefaultPlugins
	 * @private
	 */
	RuntimeAuthoring.prototype._destroyDefaultPlugins = function (mPluginsToKeep) {
		// Destroy default plugins and clear cache
		// ... but keep those in mPluginsToKeep
		for (var sDefaultPluginName in this._mDefaultPlugins) {
			var oDefaultPlugin = this._mDefaultPlugins[sDefaultPluginName];

			if (oDefaultPlugin && !oDefaultPlugin.bIsDestroyed) {
				if (!mPluginsToKeep || mPluginsToKeep[sDefaultPluginName] !== oDefaultPlugin) {
					oDefaultPlugin.destroy();
				}
			}
		}
		if (!mPluginsToKeep) {
			this._mDefaultPlugins = null;
		}
	};

	RuntimeAuthoring.prototype.onPopupOpen = function(oEvent) {
		if (
			oEvent.getParameters() instanceof sap.m.Dialog
			&& this.getToolbar() instanceof FioriToolbar
		) {
			this.getToolbar().setColor("contrast");
		}
		this.getToolbar().bringToFront();
	};

	RuntimeAuthoring.prototype.onPopupClose = function(oEvent) {
		if (oEvent.getParameters() instanceof sap.m.Dialog) {
			this.getToolbar().setColor();
		}
	};

	RuntimeAuthoring.prototype.setPlugins = function(mPlugins) {
		if (this._oDesignTime) {
			throw new Error('Cannot replace plugins: runtime authoring already started');
		}
		this.setProperty("plugins", mPlugins);
	};

	/**
	 * Setter for flexSettings
	 *
	 * @param {Object} [mFlexSettings] property bag
	 * @param {String} [mFlexSettings.layer] The Layer in which RTA should be started. Default: "CUSTOMER"
	 * @param {Boolean} [mFlexSettings.developerMode] Whether RTA is started in DeveloperMode Mode. Whether RTA is started in DeveloperMode Mode
	 * @param {String} [mFlexSettings.namespace] Namespace for changes inside LREP
	 */
	RuntimeAuthoring.prototype.setFlexSettings = function(mFlexSettings) {
		// Check URI-parameters for sap-ui-layer
		var oUriParams = jQuery.sap.getUriParameters();
		var aUriLayer = oUriParams.mParams["sap-ui-layer"];

		mFlexSettings = jQuery.extend({}, this.getFlexSettings(), mFlexSettings);

		if (aUriLayer && aUriLayer.length > 0) {
			mFlexSettings.layer = aUriLayer[0];
		}

		Utils.setRtaStyleClassName(mFlexSettings.layer);
		this.setProperty("flexSettings", mFlexSettings);
	};

	/**
	 * Checks the uri parameters for "sap-ui-layer" and returns either the current layer or the layer from the uri parameter, if there is one
	 *
	 * @param {String} sLayer the current layer
	 * @returns {String} the layer after checking the uri parameters
	 * @private
	 */
	RuntimeAuthoring.prototype.getLayer = function(sLayer) {
		return this.getFlexSettings().layer;
	};

	RuntimeAuthoring.prototype._getFlexController = function() {
		var oRootControl = this._oRootControl || sap.ui.getCore().byId(this.getRootControl());
		return FlexControllerFactory.createForControl(oRootControl);
	};

	RuntimeAuthoring.prototype._getTextResources = function() {
		return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");
	};

	/**
	 * Start UI adaptation at runtime (RTA).
	 * @return {Promise} Returns a Promise with the initialization of RTA
	 * @public
	 */
	RuntimeAuthoring.prototype.start = function() {
		// Create DesignTime
		if (!this._oDesignTime) {
			this._oRootControl = sap.ui.getCore().byId(this.getRootControl());
			//Check if the application has personalized changes and reload without them
			return this._handlePersonalizationChangesOnStart()
			.then(function(bReloadTriggered){
				if (bReloadTriggered) {
					return Promise.reject(false);
				}

				// Take default plugins if no plugins handed over
				if (!this.getPlugins() || !Object.keys(this.getPlugins()).length) {
					this.setPlugins(this.getDefaultPlugins());
				}

				// Destroy default plugins instantiated but not in use
				this._destroyDefaultPlugins(this.getPlugins());

				Object.keys(this.getPlugins()).forEach(function(sPluginName) {
					if (this.getPlugins()[sPluginName].attachElementModified) {
						this.getPlugins()[sPluginName].attachElementModified(this._handleElementModified, this);
					}
				}.bind(this));

				// Hand over currrent command stack to settings plugin
				if (this.getPlugins()["settings"]) {
					this.getPlugins()["settings"].setCommandStack(this.getCommandStack());
				}

				this._oSerializer = new LREPSerializer({commandStack : this.getCommandStack(), rootControl : this.getRootControl()});

				// Create design time
				var aKeys = Object.keys(this.getPlugins());
				var aPlugins = aKeys.map(function(sKey) {
					return this.getPlugins()[sKey];
				}, this);

				jQuery.sap.measure.start("rta.dt.startup","Measurement of RTA: DesignTime start up");
				this._oDesignTime = new DesignTime({
					rootElements : [this._oRootControl],
					plugins : aPlugins
				});

				jQuery(Overlay.getOverlayContainer()).addClass("sapUiRta");
				if (this.getLayer() === "USER") {
					jQuery(Overlay.getOverlayContainer()).addClass("sapUiRtaPersonalize");
				}

				this._oRootControl.addStyleClass("sapUiRtaRoot");

				this._oDesignTime.attachSelectionChange(function(oEvent) {
					this.fireSelectionChange({selection: oEvent.getParameter("selection")});
				}, this);

				this._oDesignTime.attachEventOnce("synced", function() {
					this.fireStart({
						editablePluginsCount: this.iEditableOverlaysCount
					});
					jQuery.sap.measure.end("rta.dt.startup","Measurement of RTA: DesignTime start up");
				}, this);

				this._oDesignTime.attachEventOnce("syncFailed", function() {
					this.fireFailed();
				}, this);

				// Register function for checking unsaved before leaving RTA
				this._oldUnloadHandler = window.onbeforeunload;
				window.onbeforeunload = this._onUnload.bind(this);
			}.bind(this))
			.then(function () {
				if (this.getShowToolbars()) {
					// Create ToolsMenu
					return this._getPublishAndAppVariantSupportVisibility()
						.then(function (aButtonsSupport) {
							var bShowPublish = aButtonsSupport[0];
							var bIsAppVariantSupported = aButtonsSupport[1];
							this._createToolsMenu(bShowPublish, bIsAppVariantSupported);
							return this.getToolbar().show();
						}.bind(this));
				}
			}.bind(this))
			.then(function () {
				this.fnKeyDown = this._onKeyDown.bind(this);
				jQuery(document).on("keydown", this.fnKeyDown);
			}.bind(this))
			.then(function() {
				this.getPopupManager().setRta(this);
				var oRelevantPopups = this.getPopupManager().getRelevantPopups();
				if (oRelevantPopups.aDialogs || oRelevantPopups.aPopovers) {
					return this.getShowToolbars() && this.getToolbar().bringToFront();
				}
			}.bind(this))
			.then(function () {
				// non-blocking style loading
				StylesLoader
					.loadStyles('InPageStyles')
					.then(function (sData) {
						var sStyles = sData.replace(/%scrollWidth%/g, DOMUtil.getScrollbarWidth() + 'px');
						DOMUtil.insertStyles(sStyles);
					});
			})
			.catch(function(vError) {
				if (vError) {
					return Promise.reject(vError);
				}
			});
		}
	};

	RuntimeAuthoring.prototype._getPublishAndAppVariantSupportVisibility = function() {
		return FlexSettings.getInstance().then(function(oSettings) {
			return RtaAppVariantFeature.isPlatFormEnabled(this.getLayer(), this._oRootControl).then(function(bIsAppVariantSupported) {
				return [!oSettings.isProductiveSystem() && !oSettings.hasMergeErrorOccured(), bIsAppVariantSupported];
			});
		}.bind(this))
		.catch(function(oError) {
			return false;
		});
	};

	var fnShowTechnicalError = function(vError) {
		var sErrorMessage = vError.stack || vError.message || vError.status || vError;
		var oTextResources = sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");
		jQuery.sap.log.error("Failed to transfer runtime adaptation changes to layered repository", sErrorMessage);
		var sMsg = oTextResources.getText("MSG_LREP_TRANSFER_ERROR") + "\n"
				+ oTextResources.getText("MSG_ERROR_REASON", sErrorMessage);
		MessageBox.error(sMsg, {
			styleClass: Utils.getRtaStyleClassName()
		});
	};

	/**
	 * @override
	 */
	RuntimeAuthoring.prototype.setCommandStack = function(oCommandStack) {
		var  oOldCommandStack = this.getProperty("commandStack");
		if (oOldCommandStack) {
			oOldCommandStack.detachModified(this._onStackModified, this);
		}

		if (this._oInternalCommandStack) {
			this._oInternalCommandStack.destroy();
			delete this._oInternalCommandStack;
		}

		var oResult = this.setProperty("commandStack", oCommandStack);

		if (oCommandStack) {
			oCommandStack.attachModified(this._onStackModified, this);
		}

		if (this.getPlugins() && this.getPlugins()["settings"]) {
			this.getPlugins()["settings"].setCommandStack(oCommandStack);
		}

		return oResult;
	};

	/**
	 *
	 * @override
	 */
	RuntimeAuthoring.prototype.getCommandStack = function() {
		var oCommandStack = this.getProperty("commandStack");
		if (!oCommandStack) {
			oCommandStack = new CommandStack();
			this._oInternalCommandStack = oCommandStack;
			this.setCommandStack(oCommandStack);
		}

		return oCommandStack;
	};

	/**
	 * adapt the enablement of undo/redo/reset/transport button
	 * @private
	 */
	RuntimeAuthoring.prototype._onStackModified = function() {
		var oCommandStack = this.getCommandStack();
		var bCanUndo = oCommandStack.canUndo();
		var bCanRedo = oCommandStack.canRedo();
		var oUshellContainer = Utils.getUshellContainer();

		if (this.getShowToolbars()) {
			this.getToolbar().setUndoRedoEnabled(bCanUndo, bCanRedo);
			this.getToolbar().setPublishEnabled(this._bChangesExist || bCanUndo);
			this.getToolbar().setRestoreEnabled(this._bChangesExist || bCanUndo);
		}
		this.fireUndoRedoStackModified();

		if (oUshellContainer) {
			if (bCanUndo) {
				oUshellContainer.setDirtyFlag(true);
			} else {
				oUshellContainer.setDirtyFlag(false);
			}
		}
	};

	RuntimeAuthoring.prototype._closeToolbar = function() {
		if (this.getShowToolbars() && this.getToolbar) {
			return this.getToolbar().hide();
		}
	};

	/**
	 * Returns a selection from the DesignTime
	 * @return {sap.ui.dt.Overlay[]} selected overlays
	 * @public
	 */
	RuntimeAuthoring.prototype.getSelection = function() {
		if (this._oDesignTime) {
			return this._oDesignTime.getSelection();
		} else {
			return [];
		}
	};

	/**
	 * stop Runtime Authoring
	 *
	 * @public
	 * @param {boolean} bDontSaveChanges - stop RTA with or w/o saving changes
	 * @param {boolean} bSkipCheckPersChanges - stop RTA with or w/o checking for personalized changes
	 * @returns {Promise} promise with no parameters
	 */
	RuntimeAuthoring.prototype.stop = function(bDontSaveChanges, bSkipCheckPersChanges) {
		return ((bDontSaveChanges) ? Promise.resolve() : this._serializeToLrep())
			.then(this._closeToolbar.bind(this))
			.then(bSkipCheckPersChanges ? Promise.resolve() : this._handlePersonalizationChangesOnExit.bind(this))
			.then(function(){
				this.fireStop();
			}.bind(this))['catch'](fnShowTechnicalError);
	};

	RuntimeAuthoring.prototype.restore = function() {
		this._onRestore();
	};

	RuntimeAuthoring.prototype.transport = function() {
		this._onTransport();
	};

	// ---- backward compatibility API
	RuntimeAuthoring.prototype.undo = function() {
		return this._onUndo();
	};

	RuntimeAuthoring.prototype.redo = function() {
		return this._onRedo();
	};

	RuntimeAuthoring.prototype.canUndo = function() {
		return this.getCommandStack().canUndo();
	};

	RuntimeAuthoring.prototype.canRedo = function() {
		return this.getCommandStack().canRedo();
	};
	// ---- backward compatibility API

	RuntimeAuthoring.prototype._onKeyDown = function(oEvent) {
		// if for example the addField Dialog/transport/reset Popup is open, we don't want the user to be able to undo/redo
		var bMacintosh = Device.os.macintosh;
		var bFocusInsideOverlayContainer = Overlay.getOverlayContainer().contains(document.activeElement);
		var bFocusInsideRtaToolbar = this.getShowToolbars() && this.getToolbar().getDomRef().contains(document.activeElement);
		var bFocusOnBody = document.body === document.activeElement;
		var bFocusInsideRenameField = jQuery(document.activeElement).parents('.sapUiRtaEditableField').length > 0;

		if ((bFocusInsideOverlayContainer || bFocusInsideRtaToolbar || bFocusOnBody) && !bFocusInsideRenameField) {
			// OSX: replace CTRL with CMD
			var bCtrlKey = bMacintosh ? oEvent.metaKey : oEvent.ctrlKey;
			if (
				oEvent.keyCode === jQuery.sap.KeyCodes.Z
				&& oEvent.shiftKey === false
				&& oEvent.altKey === false
				&& bCtrlKey === true
			) {
				this._onUndo().then(oEvent.stopPropagation.bind(oEvent));
			} else if (
				(( // OSX: CMD+SHIFT+Z
					bMacintosh
					&& oEvent.keyCode === jQuery.sap.KeyCodes.Z
					&& oEvent.shiftKey === true
				) || ( // Others: CTRL+Y
					!bMacintosh
					&& oEvent.keyCode === jQuery.sap.KeyCodes.Y
					&& oEvent.shiftKey === false
				))
				&& oEvent.altKey === false
				&& bCtrlKey === true
			) {
				this._onRedo().then(oEvent.stopPropagation.bind(oEvent));
			}
		}
	};

	/**
	 * Check for unsaved changes before leaving UI adaptation at runtime
	 * @return {string} Returns the message to be displayed in the unsaved changes dialog
	 *
	 * @private
	 */
	RuntimeAuthoring.prototype._onUnload = function() {
		var oCommandStack = this.getCommandStack();
		var bUnsaved = oCommandStack.canUndo() || oCommandStack.canRedo();
		if (bUnsaved && this.getShowWindowUnloadDialog()) {
			var sMessage = this._getTextResources().getText("MSG_UNSAVED_CHANGES");
			return sMessage;
		} else {
			window.onbeforeunload = this._oldUnloadHandler;
		}
	};

	RuntimeAuthoring.prototype._serializeToLrep = function() {
		return this._oSerializer.saveCommands();
	};

	RuntimeAuthoring.prototype._onUndo = function() {
		this._handleStopCutPaste();
		return this.getCommandStack().undo();
	};

	RuntimeAuthoring.prototype._onRedo = function() {
		this._handleStopCutPaste();
		return this.getCommandStack().redo();
	};

	RuntimeAuthoring.prototype._createToolsMenu = function(bPublishAvailable, bIsAppVariantSupported) {
		if (!this.getDependent('toolbar')) {
			var fnConstructor;

			if (this.getLayer() === "USER") {
				fnConstructor = PersonalizationToolbar;
			} else if (Utils.getFiori2Renderer()) {
				fnConstructor = FioriToolbar;
			} else {
				fnConstructor = StandaloneToolbar;
			}

			if (this.getLayer() === "USER") {
				this.addDependent(new fnConstructor({
					textResources: this._getTextResources(),
					//events
					exit: this.stop.bind(this, false, false),
					restore: this._onRestore.bind(this)
				}), 'toolbar');
			} else {
				this.addDependent(new fnConstructor({
					modeSwitcher: this.getMode(),
					publishVisible: bPublishAvailable,
					textResources: this._getTextResources(),
					appVariantFeaturesSupported: bIsAppVariantSupported,
					//events
					exit: this.stop.bind(this, false, false),
					transport: this._onTransport.bind(this),
					restore: this._onRestore.bind(this),
					undo: this._onUndo.bind(this),
					redo: this._onRedo.bind(this),
					modeChange: this._onModeChange.bind(this),
					manageApps: RtaAppVariantFeature.onGetOverview.bind(null, this._oRootControl),
					saveAs: RtaAppVariantFeature.onSaveAs.bind(null, this._oRootControl, null)
				}), 'toolbar');
			}

			this._checkChangesExist().then(function(bResult){
				this._bChangesExist = bResult;
				this.getToolbar().setPublishEnabled(bResult);
				this.getToolbar().setRestoreEnabled(bResult);
			}.bind(this));
		}
	};

	/**
	 * Exit Runtime Authoring - destroy all controls and plugins
	 *
	 * @protected
	 */
	RuntimeAuthoring.prototype.exit = function() {
		jQuery.map(this._dependents, function (oDependent) {
			//Destroy should be called with supress invalidate = true here to prevent static UI Area invalidation
			oDependent.destroy(true);
		});

		if (this._oDesignTime) {
			jQuery(Overlay.getOverlayContainer()).removeClass("sapUiRta");
			this._oDesignTime.destroy();
			this._oDesignTime = null;

			// detach browser events
			jQuery(document).off("keydown", this.fnKeyDown);
			// Destroy default plugins
			this._destroyDefaultPlugins();
			// plugins have been destroyed as _oDesignTime.destroy()
			// plugins are set to defaultValue if parameter is null
			this.setPlugins(null);
		}

		if (this._oRootControl) {
			this._oRootControl.removeStyleClass("sapUiRtaRoot");
		}

		this.setCommandStack(null);

		var oUshellContainer = Utils.getUshellContainer();
		if (oUshellContainer) {
			oUshellContainer.setDirtyFlag(false);
		}

		window.onbeforeunload = this._oldUnloadHandler;
	};

	/**
	 * Function to handle ABAP transport of the changes
	 * @return {Promise} Returns a Promise processing the transport of changes
	 *
	 * @private
	 */
	RuntimeAuthoring.prototype._onTransport = function() {
		var fnHandleAllErrors = function (oError) {
			BusyIndicator.hide();
			if (oError.message !== 'createAndApply failed') {
				FlexUtils.log.error("transport error" + oError);
				return this._showMessage(MessageBox.Icon.ERROR, "HEADER_TRANSPORT_ERROR", "MSG_TRANSPORT_ERROR", oError);
			}
		}.bind(this);

		this._handleStopCutPaste();

		return this._openSelection()
			.then(this._checkTransportInfo)
			.then(function(oTransportInfo) {
				if (oTransportInfo) {
					return this._serializeToLrep().then(function () {
						return this._getFlexController().getComponentChanges({currentLayer: this.getLayer()}).then(function (aAllLocalChanges) {
							if (aAllLocalChanges.length > 0) {
								BusyIndicator.show(0);
								return this._createAndApplyChanges(aAllLocalChanges)
									.then(this._transportAllLocalChanges.bind(this, oTransportInfo))
										['catch'](fnHandleAllErrors);
							}
						}.bind(this));
					}.bind(this))['catch'](fnShowTechnicalError);
				}
			}.bind(this)
		);
	};

	RuntimeAuthoring.prototype._checkTransportInfo = function(oTransportInfo) {
		if (oTransportInfo && oTransportInfo.transport && oTransportInfo.packageName !== "$TMP") {
			return oTransportInfo;
		} else {
			return false;
		}
	};

	RuntimeAuthoring.prototype._openSelection = function () {
	   return new TransportSelection().openTransportSelection(null, this._oRootControl, Utils.getRtaStyleClassName());
	};

	/**
	 * Create and apply changes
	 *
	 * Function is copied from FormP13nHandler. We need all changes for various controls.
	 * The function is used in the transport handling.
	 *
	 * @private
	 * @param {array} aChangeSpecificData - array of objects with change specific data
	 * @returns {Promise} promise that resolves with no parameters
	 */
	RuntimeAuthoring.prototype._createAndApplyChanges = function(aChangeSpecificData) {
		var aPromises = [];
		return Promise.resolve()

		.then(function() {
			function fnValidChanges(oChangeSpecificData) {
				return oChangeSpecificData && oChangeSpecificData.selector && oChangeSpecificData.selector.id;
			}
			aChangeSpecificData.filter(fnValidChanges).forEach(function(oChangeSpecificData) {
				var oControl = sap.ui.getCore().byId(oChangeSpecificData.selector.id);
				var oFlexController = this._getFlexController();
				aPromises.push(oFlexController.createAndApplyChange.bind(oFlexController, oChangeSpecificData, oControl));
			}.bind(this));
			return FlexUtils.execPromiseQueueSequentially(aPromises);
		}.bind(this))

		.catch(function(oError) {
			FlexUtils.log.error("Create and apply error: " + oError);
			return oError;
		})

		.then(function(oError) {
			return this._getFlexController().saveAll().then(function() {
				if (oError) {
					throw oError;
				}
			});
		}.bind(this))

		.catch(function(oError) {
			FlexUtils.log.error("Create and apply and/or save error: " + oError);
			return this._showMessage(MessageBox.Icon.ERROR, "HEADER_TRANSPORT_APPLYSAVE_ERROR", "MSG_TRANSPORT_APPLYSAVE_ERROR", oError);
		}.bind(this));
	};

	/**
	 * Delete all changes for current layer and root control's component
	 *
	 * @private
	 */
	RuntimeAuthoring.prototype._deleteChanges = function() {
		var oTransportSelection = new TransportSelection();
		var sCurrentLayer = this.getLayer();

		// all new changes from commands that are only in our stack and not yet in the LREP, filtered by them having a change
		var aUnsavedChanges = this.getCommandStack().getAllExecutedCommands().reduce(function(aChanges, oCommand) {
			if (oCommand.getPreparedChange) {
				aChanges.push(oCommand.getPreparedChange());
			} else if (oCommand.getVariantChange && oCommand.getVariantChange()) {
				aChanges.push(oCommand.getVariantChange());
			}
			return aChanges;
		}, []);

		this._getFlexController().getComponentChanges({currentLayer: sCurrentLayer}).then(function(aChanges) {
			return FlexSettings.getInstance(FlexUtils.getComponentClassName(this._oRootControl)).then(function(oSettings) {
				if (!oSettings.isProductiveSystem() && !oSettings.hasMergeErrorOccured()) {
					return oTransportSelection.setTransports(aChanges, this._oRootControl);
				}
			}.bind(this)).then(function() {
				BusyIndicator.show(0);
				aChanges = aChanges.concat(aUnsavedChanges);
				return this._getFlexController().discardChanges(aChanges, sCurrentLayer === "USER");
			}.bind(this)).then(function() {
				BusyIndicator.hide();
				this._reloadPage();
			}.bind(this));
		}.bind(this))["catch"](function(oError) {
			BusyIndicator.hide();
			return this._showMessage(MessageBox.Icon.ERROR, "HEADER_RESTORE_FAILED", "MSG_RESTORE_FAILED", oError);
		}.bind(this));
	};

	/**
	 * Reloads the page.
	 * @private
	 */
	RuntimeAuthoring.prototype._reloadPage = function(){
		window.location.reload();
	};

	/**
	 * Shows a message box.
	 * @param  {sap.m.MessageBox.Icon} oMessageType The type of the message box (icon to be displayed)
	 * @param  {string} sTitleKey The text key for the title of the message box
	 * @param  {string} sMessageKey The text key for the message of the message box
	 * @param  {any} oError Optional - If an error is passed on, the message box text is derived from it
	 * @return {Promise} Promise displaying the message box; resolves when it is closed
	 * @private
	 */
	RuntimeAuthoring.prototype._showMessage = function(oMessageType, sTitleKey, sMessageKey, oError) {
		var sMessage = this._getTextResources().getText(sMessageKey, oError ? [oError.message || oError] : undefined);
		var sTitle = this._getTextResources().getText(sTitleKey);

		return new Promise(function(resolve) {
			MessageBox.show(sMessage, {
				icon: oMessageType,
				title: sTitle,
				onClose: resolve,
				styleClass: Utils.getRtaStyleClassName()
			});
		});
	};

	/**
	 * Shows a message toast.
	 * @param  {string} sMessageKey The text key for the message
	 * @private
	 */
	RuntimeAuthoring.prototype._showMessageToast = function(sMessageKey) {
		var sMessage = this._getTextResources().getText(sMessageKey);

		MessageToast.show(sMessage);
	};

	/**
	 * The RTA FLP plugin checks whether RTA needs to be restarted and restarts it if needed.
	 *
	 * @public
	 * @static
	 * @param {string} sLayer The active layer
	 * @returns {boolean} Returns true if restart is needed
	 */
	RuntimeAuthoring.needsRestart = function(sLayer) {

		var bRestart = !!window.localStorage.getItem("sap.ui.rta.restart." + sLayer);
		return bRestart;
	};

	/**
	 * Enable restart of RTA
	 * the RTA FLP plugin handles the restart
	 *
	 * @public
	 * @static
	 * @param {string} sLayer The active layer
	 */
	RuntimeAuthoring.enableRestart = function(sLayer) {
		window.localStorage.setItem("sap.ui.rta.restart." + sLayer, true);
	};

	/**
	 * Disable restart of RTA
	 *
	 * @public
	 * @static
	 * @param {string} sLayer The active layer
	 */
	RuntimeAuthoring.disableRestart = function(sLayer) {
		window.localStorage.removeItem("sap.ui.rta.restart." + sLayer);
	};

	/**
	 * Discard all LREP changes and restores the default app state,
	 * opens a MessageBox where the user can confirm
	 * the restoring to the default app state
	 *
	 * @private
	 */
	RuntimeAuthoring.prototype._onRestore = function() {
		var sMessage = this.getLayer() === "USER"
			? this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION")
			: this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");
		var sTitle = this.getLayer() === "USER"
			? this._getTextResources().getText("BTN_RESTORE")
			: this._getTextResources().getText("FORM_PERS_RESET_TITLE");

		var fnConfirmDiscardAllChanges = function (sAction) {
			if (sAction === "OK") {
				RuntimeAuthoring.enableRestart(this.getLayer());
				this._deleteChanges();
				this.getCommandStack().removeAllCommands();
			}
		}.bind(this);

		this._handleStopCutPaste();

		MessageBox.confirm(sMessage, {
			icon: MessageBox.Icon.WARNING,
			title : sTitle,
			onClose : fnConfirmDiscardAllChanges,
			styleClass: Utils.getRtaStyleClassName()
		});
	};

	/**
	 * Prepare all changes and assign them to an existing transport.
	 *
	 * @private
	 * @param {Object} mTransportInfo - Map containing the package name and the transport
	 * @param {string} mTransportInfo.packageName - Name of the package
 	 * @param {string} mTransportInfo.transport - ID of the transport
	 * @returns {Promise} Returns a Promise which resolves without parameters
	 */
	RuntimeAuthoring.prototype._transportAllLocalChanges = function(mTransportInfo) {
		return this._getFlexController().getComponentChanges({currentLayer: this.getLayer()}).then(function(aAllLocalChanges) {

			// Pass list of changes to be transported with transport request to backend
			var oTransports = new Transports();
			var aTransportData = oTransports._convertToChangeTransportData(aAllLocalChanges);
			var oTransportParams = {};
			//packageName is '' in CUSTOMER layer (no package input field in transport dialog)
			oTransportParams.package = mTransportInfo.packageName;
			oTransportParams.transportId = mTransportInfo.transport;
			oTransportParams.changeIds = aTransportData;

			return oTransports.makeChangesTransportable(oTransportParams).then(function() {

				// remove the $TMP package from all changes; has been done on the server as well,
				// but is not reflected in the client cache until the application is reloaded
				aAllLocalChanges.forEach(function(oChange) {

					if (oChange.getPackage() === '$TMP') {
						var oDefinition = oChange.getDefinition();
						oDefinition.packageName = mTransportInfo.packageName;
						oChange.setResponse(oDefinition);
					}
				});
			}).then(function() {
				BusyIndicator.hide();
				this._showMessageToast("MSG_TRANSPORT_SUCCESS");
			}.bind(this));
		}.bind(this));
	};

	/**
	 * Checks whether the two parent information maps are equal.
	 *
	 * @param {Object}
	 *          oInfo1 First map of information
	 * @param {Object}
	 *          oInfo2 Second map of information
	 * @return {boolean} Returns true if they are equal, false otherwise
	 * @private
	 */
	RuntimeAuthoring.prototype._isEqualParentInfo = function(oInfo1, oInfo2) {
		var oResult = !!oInfo1 && !!oInfo2;
		if (oResult && (oInfo1.parent && oInfo2.parent)) {
			oResult = oInfo1.parent.getId() === oInfo2.parent.getId();
		}
		if (oResult && (oInfo1.index || oInfo2.index)) {
			oResult = oInfo1.index === oInfo2.index;
		}
		if (oResult && (oInfo1.aggregation || oInfo2.aggregation)) {
			oResult = oInfo1.aggregation === oInfo2.aggregation;
		}
		return oResult;
	};

	/**
	 * Function to automatically start the rename plugin on a container when it gets created
	 * @param {object} vAction       The create action from designtime metadata
	 * @param {string} sNewControlID The id of the newly created container
	 */
	RuntimeAuthoring.prototype._setRenameOnCreatedContainer = function(vAction, sNewControlID) {
		var oNewContainerOverlay = this.getPlugins()["createContainer"].getCreatedContainerOverlay(vAction, sNewControlID);
		if (oNewContainerOverlay) {
			oNewContainerOverlay.setSelected(true);

			if (this.getPlugins()["rename"]) {
				var oDelegate = {
					"onAfterRendering" : function() {
						// TODO : remove timeout
						setTimeout(function() {
							this.getPlugins()["rename"].startEdit(oNewContainerOverlay);
						}.bind(this), 0);
						oNewContainerOverlay.removeEventDelegate(oDelegate);
					}.bind(this)
				};

				oNewContainerOverlay.addEventDelegate(oDelegate);
			}
		}
	};

	/**
	 * Function to handle modification of an element
	 *
	 * @param {sap.ui.base.Event} oEvent Event object
	 * @returns {Promise} Returns promise that resolves after command was executed sucessfully
	 * @private
	 */
	RuntimeAuthoring.prototype._handleElementModified = function(oEvent) {
		this._handleStopCutPaste();

		var vAction = oEvent.getParameter("action");
		var sNewControlID = oEvent.getParameter("newControlId");

		var oCommand = oEvent.getParameter("command");
		if (oCommand instanceof sap.ui.rta.command.BaseCommand) {
			return this.getCommandStack().pushAndExecute(oCommand).then(function(){
				if (vAction && sNewControlID){
					this._setRenameOnCreatedContainer(vAction, sNewControlID);
				}
			}.bind(this));
		}
		return Promise.resolve();
	};

	/**
	 * Increases or decreases the current number of editable Overlays.
	 * @param  {sap.ui.base.Event} oEvent Event triggered by the 'editable' property change
	 * @private
	 */
	RuntimeAuthoring.prototype._onElementEditableChange = function(oEvent) {
		var bEditable = oEvent.getParameter("editable");
		if (bEditable) {
			this.iEditableOverlaysCount += 1;
		} else {
			this.iEditableOverlaysCount -= 1;
		}
	};

	/**
	 * Handler function to stop cut and paste, because some other operation has started.
	 *
	 * @private
	 */
	RuntimeAuthoring.prototype._handleStopCutPaste = function() {
		if (this.getPlugins()["cutPaste"]){
			this.getPlugins()["cutPaste"].stopCutAndPaste();
		}
	};

	/**
	 * Get the Title of the Application from the manifest.json
	 *
	 * @private
	 * @returns {String} the application title or empty string
	 */
	RuntimeAuthoring.prototype._getApplicationTitle = function() {

		var sTitle = "";
		var oComponent = sap.ui.core.Component.getOwnerComponentFor(this._oRootControl);
		if (oComponent) {
			sTitle = oComponent.getMetadata().getManifestEntry("sap.app").title;
		}
		return sTitle;
	};

	/**
	 * Check if Changes exist
	 * @private
	 * @returns {Promise} Resolving to false means that no change check is required
	 */
	RuntimeAuthoring.prototype._checkChangesExist = function() {
		if (this._getFlexController().getComponentName().length > 0) {
			return this._getFlexController().getComponentChanges({currentLayer: this.getLayer()}).then(function(aAllLocalChanges) {
				return aAllLocalChanges.length > 0;
			});
		} else {
			return Promise.resolve(false);
		}
	};

	/**
	 * Returns the URL parsed hash from UShell
	 * @return {map} Parsed shell hash map
	 */
	RuntimeAuthoring.prototype._getURLParsedHash = function(){
		var oURLParser = sap.ushell.Container.getService("URLParsing");
		if (oURLParser.parseShellHash && oURLParser.getHash){
			return oURLParser.parseShellHash(oURLParser.getHash(window.location.href));
		}
	};

	/**
	 * Build the navigation arguments object required to trigger the navigation
	 * using the CrossApplicationNavigation ushell service.
	 * @param  {Object} mParsedHash Parsed URL hash
	 * @return {Object}             Returns argument map ("oArg" parameter of the "toExternal" function)
	 */
	RuntimeAuthoring.prototype._buildNavigationArguments = function(mParsedHash){
		return {
			target: {
				semanticObject : mParsedHash.semanticObject,
				action : mParsedHash.action,
				context : mParsedHash.contextRaw
			},
			params: mParsedHash.params,
			appSpecificRoute : mParsedHash.appSpecificRoute,
			writeHistory : false
		};
	};

	/**
	 * Returns true if the ui layer parameter is set to customer (skips personalization changes)
	 * @param  {map} mParsedHash The parsed URL hash
	 * @return {boolean} True if the parameter is in the hash
	 */
	RuntimeAuthoring.prototype._hasCustomerLayerParameter = function(mParsedHash){
		return mParsedHash.params &&
			mParsedHash.params[FL_MAX_LAYER_PARAM] &&
			mParsedHash.params[FL_MAX_LAYER_PARAM][0] === "CUSTOMER";
	};

	/**
	 * Reload the app inside FLP adding the parameter to skip personalization changes
	 * @param  {map} mParsedHash URL parsed hash
	 * @param  {sap.ushell.services.CrossApplicationNavigation} oCrossAppNav ushell service
	 * @return {Promise} resolving to true if reload was triggered
	 */
	RuntimeAuthoring.prototype._reloadWithoutPersonalizationChanges = function(mParsedHash, oCrossAppNav){
		if (!this._hasCustomerLayerParameter(mParsedHash)){
			if (!mParsedHash.params) {
				mParsedHash.params = {};
			}
			mParsedHash.params[FL_MAX_LAYER_PARAM] = ["CUSTOMER"];
			RuntimeAuthoring.enableRestart("CUSTOMER");
			// triggers the navigation without leaving FLP
			oCrossAppNav.toExternal(this._buildNavigationArguments(mParsedHash));
			return Promise.resolve(true);
		}
	};

	/**
	 * Reload the app inside FLP removing the parameter to skip personalization changes
	 * @param  {map} mParsedHash URL parsed hash
	 * @param  {sap.ushell.services.CrossApplicationNavigation} oCrossAppNav ushell service
	 * @return {Promise} resolving to true if reload was triggered
	 */
	RuntimeAuthoring.prototype._reloadWithPersonalizationChanges = function(mParsedHash, oCrossAppNav){
		if (this._hasCustomerLayerParameter(mParsedHash)) {
			delete mParsedHash.params[FL_MAX_LAYER_PARAM];
			// triggers the navigation without leaving FLP
			oCrossAppNav.toExternal(this._buildNavigationArguments(mParsedHash));
			return Promise.resolve(true);
		}
	};

	/**
	 * Handler for the message box warning the user that personalization changes exist
	 * and the app will be reloaded
	 * @return {Promise} Resolving when the user clicks on OK
	 */
	RuntimeAuthoring.prototype._handlePersonalizationMessageBoxOnStart = function() {
		return this._showMessage(
			MessageBox.Icon.INFORMATION,
			"HEADER_PERSONALIZATION_EXISTS",
			"MSG_PERSONALIZATION_EXISTS");
	};

	/**
	 * Check if there are personalization changes and restart the application without them
	 * Warn the user that the application will be restarted without personalization
	 * This is only valid when a UShell is present
	 * @return {Promise} Resolving to false means that reload is not necessary
	 */
	RuntimeAuthoring.prototype._handlePersonalizationChangesOnStart = function() {
		var oUshellContainer = Utils.getUshellContainer();
		if (oUshellContainer && this.getLayer() !== "USER") {
			var mParsedHash = this._getURLParsedHash();
			return this._getFlexController().isPersonalized({ignoreMaxLayerParameter : false})
			.then(function(bIsPersonalized){
				if (bIsPersonalized) {
					return this._handlePersonalizationMessageBoxOnStart().then(function() {
						var oCrossAppNav = sap.ushell.Container.getService("CrossApplicationNavigation");
						if (oCrossAppNav.toExternal && mParsedHash){
							return this._reloadWithoutPersonalizationChanges(mParsedHash, oCrossAppNav);
						}
					}.bind(this));
				}
			}.bind(this));
		} else {
			return Promise.resolve(false);
		}
	};

	/**
	 * Handler for the message box asking the user if the personalization changes
	 * should be restored after exiting RTA
	 * @return {Promise} Resolves to true if the user wants to restore personalization
	 */
	RuntimeAuthoring.prototype._handlePersonalizationMessageBoxOnExit = function() {
		return new Promise(function(resolve){
			var sMessage = this._getTextResources()
				.getText("MSG_LOAD_PERSONALIZATION_CHANGES");
			var sTitle = this._getTextResources()
				.getText("HEADER_LOAD_PERSONALIZATION_CHANGES");
			var sConfirmButtonText = this._getTextResources()
				.getText("MSG_PERSONALIZATION_CONFIRM_BUTTON_TEXT");
			var sCancelButtonText = this._getTextResources()
				.getText("MSG_PERSONALIZATION_CANCEL_BUTTON_TEXT");
			var fnCallback = function (sAction) {
				if (sAction === sConfirmButtonText) {
					return resolve(true);
				} else if (sAction === sCancelButtonText) {
					return resolve(false);
				}
			};

			MessageBox.confirm(sMessage, {
				icon: MessageBox.Icon.QUESTION,
				title : sTitle,
				actions : [sConfirmButtonText, sCancelButtonText],
				onClose : fnCallback,
				styleClass: Utils.getRtaStyleClassName()
			});
		}.bind(this));
	};

	/**
	 * When exiting RTA and personalization changes exist, the user can choose to
	 * reload the app with personalization or stay in the app without the personalization
	 * @return {Promise} Resolving to false means that the reload is not necessary
	 */
	RuntimeAuthoring.prototype._handlePersonalizationChangesOnExit = function() {
		var oUshellContainer = Utils.getUshellContainer();
		if (oUshellContainer && this.getLayer() !== "USER") {
			// When working with RTA, the MaxLayer parameter will be present in the URL and must
			// be ignored in the decision to bring up the pop-up (ignoreMaxLayerParameter = true)
			return this._getFlexController().isPersonalized({ignoreMaxLayerParameter : true})
				.then(function(bIsPersonalized){
				if (bIsPersonalized) {
					return this._handlePersonalizationMessageBoxOnExit().then(function(bReloadWithPersonalization){
						if (bReloadWithPersonalization) {
							var oCrossAppNav = sap.ushell.Container.getService("CrossApplicationNavigation");
							var mParsedHash = this._getURLParsedHash();
							if (oCrossAppNav.toExternal && mParsedHash){
								return this._reloadWithPersonalizationChanges(mParsedHash, oCrossAppNav);
							}
						}
					}.bind(this));
				}
			}.bind(this));
		} else {
			return Promise.resolve(false);
		}
	};

	RuntimeAuthoring.prototype._onModeChange = function(oEvent) {
		this.setMode(oEvent.getParameter('key'));
	};

	/**
	 * Setter for property 'mode'.
	 * @param {string} sNewMode The new value for the 'mode' property
	 */
	RuntimeAuthoring.prototype.setMode = function (sNewMode) {
		if (this.getProperty('mode') !== sNewMode) {
			var oModeSwitcher = this.getShowToolbars() && this.getToolbar().getControl('modeSwitcher');
			var bOverlaysEnabled = sNewMode === 'adaptation';

			if (oModeSwitcher) {
				// no event loop because setSelectedButton() doesn't trigger 'select' event on SegmentedButton
				oModeSwitcher.setSelectedButton(
					oModeSwitcher
						.getItems()
						.filter(function (oControl) {
							return oControl.getKey() === sNewMode;
						})
						.pop()
						.getId()
				);
			}
			this._oDesignTime.setEnabled(bOverlaysEnabled);
			this.getPlugins()['tabHandling'][bOverlaysEnabled ? 'removeTabIndex' : 'restoreTabIndex']();
			this.setProperty('mode', sNewMode);
			this.fireModeChanged({mode: sNewMode});
		}
	};

	return RuntimeAuthoring;

}, /* bExport= */true);

}; // end of sap/ui/rta/RuntimeAuthoring.js
if ( !jQuery.sap.isDeclared('sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageBox'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.BusyIndicator'); // unlisted dependency retained
sap.ui.define("sap/ui/rta/appVariant/manageApps/webapp/controller/ManageApps.controller",[
	"jquery.sap.global",
	"sap/ui/core/mvc/Controller",
	"sap/ui/rta/appVariant/manageApps/webapp/model/models",
	"sap/ui/rta/appVariant/Utils",
	"sap/m/MessageBox",
	"sap/ui/rta/Utils",
	"sap/ui/rta/appVariant/Feature",
	"sap/ui/rta/RuntimeAuthoring",
	"sap/ui/core/BusyIndicator",
	"sap/ui/rta/appVariant/AppVariantUtils"
], function(jQuery, Controller, Model, AppVariantOverviewUtils, MessageBox, RtaUtils, RtaAppVariantFeature, RuntimeAuthoring, BusyIndicator, AppVariantUtils) {
	"use strict";

	var _sIdRunningApp, _oRootControlRunningApp, sModulePath, oI18n;
	return Controller.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps", {
		onInit: function() {
			_sIdRunningApp = this.getOwnerComponent().getIdRunningApp();
			_oRootControlRunningApp = this.getOwnerComponent().getRootControlRunningApp();

			sModulePath = jQuery.sap.getModulePath( "sap.ui.rta.appVariant.manageApps.webapp" );
			oI18n = jQuery.sap.resources({
				url : sModulePath + "/i18n/i18n.properties"
			});

			BusyIndicator.show();
			return AppVariantOverviewUtils.getAppVariantOverview(_sIdRunningApp).then(function(aAppVariantOverviewAttributes) {
				BusyIndicator.hide();
				return this._arrangeOverviewDataAndBindToModel(aAppVariantOverviewAttributes).then(function(aAppVariantOverviewAttributes) {
					return this._highlightNewCreatedAppVariant(aAppVariantOverviewAttributes);
				}.bind(this));
			}.bind(this))["catch"](function(oError) {
				BusyIndicator.hide();
				return AppVariantUtils.showTechnicalError(MessageBox.Icon.ERROR, "HEADER_MANAGE_APPS_FAILED", "MSG_MANAGE_APPS_FAILED", oError);
			});
		},
		_highlightNewCreatedAppVariant: function(aAppVariantOverviewAttributes) {
			var oTable = this.getView().byId("Table1");
			jQuery('.maaCurrentStatus,.maaSubTitle').css("font-size", '12px');

			aAppVariantOverviewAttributes.forEach(function(oAppVariantDescriptor, index) {
				if (oAppVariantDescriptor.rowStatus === "Information") {
					oTable.setFirstVisibleRow(index);
				}
			});

			return Promise.resolve();
		},
		_arrangeOverviewDataAndBindToModel: function(aAppVariantOverviewAttributes) {
			var aAdaptingAppAttributes = aAppVariantOverviewAttributes.filter(function(oAppVariantProperty){
				return oAppVariantProperty.appId === _sIdRunningApp;
			});

			var oAdaptingAppAttributes = aAdaptingAppAttributes[0];
			if (oAdaptingAppAttributes) {
				oAdaptingAppAttributes.currentStatus = oI18n.getText("MAA_CURRENTLY_ADAPTING");
				oAdaptingAppAttributes.rowStatus = "Success";
			}

			aAppVariantOverviewAttributes = aAppVariantOverviewAttributes.filter(function(oAppVariantProperty) {
				return oAppVariantProperty.appId !== _sIdRunningApp;
			});

			aAppVariantOverviewAttributes.unshift(oAdaptingAppAttributes);

			var aReferenceAppAttributes = aAppVariantOverviewAttributes.filter(function(oAppVariantProperty){
				return oAppVariantProperty.isOriginal;
			});

			var oReferenceAppAttributes = aReferenceAppAttributes[0];

			aAppVariantOverviewAttributes = aAppVariantOverviewAttributes.filter(function(oAppVariantProperty) {
				return !oAppVariantProperty.isOriginal;
			});

			aAppVariantOverviewAttributes.unshift(oReferenceAppAttributes);

			// Bind the app variant overview to JSON model

			var oModelData = {
				appVariants: aAppVariantOverviewAttributes
			};
			var oModel = Model.createModel(oModelData);
			this.getView().setModel(oModel);

			return Promise.resolve(aAppVariantOverviewAttributes);
		},
		getModelProperty : function(sModelPropName, sBindingContext) {
			return this.getView().getModel().getProperty(sModelPropName, sBindingContext);
		},
		handleUiAdaptation: function(oEvent) {
			var oNavigationService = sap.ushell.Container.getService( "CrossApplicationNavigation" );

			var sSemanticObject = this.getModelProperty("semanticObject", oEvent.getSource().getBindingContext());
			var sAction = this.getModelProperty("action", oEvent.getSource().getBindingContext());
			var oParams = this.getModelProperty("params", oEvent.getSource().getBindingContext());

			var oNavigationParams;
			if (sSemanticObject && sAction && oParams) {
				oNavigationParams = {
					target: {
		                semanticObject : sSemanticObject,
		                action : sAction
					},
					params: oParams
				};

				RuntimeAuthoring.enableRestart( "CUSTOMER" );

				oNavigationService.toExternal(oNavigationParams);

				sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps", "navigate");
			} else {
				return false;
			}
		},
		saveAsAppVariant: function(oEvent) {
			sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps", "navigate");

			var sDescriptorUrl = this.getModelProperty("descriptorUrl", oEvent.getSource().getBindingContext());

			BusyIndicator.show();
			return AppVariantOverviewUtils.getDescriptor(sDescriptorUrl).then(function(oAppVariantDescriptor) {
				BusyIndicator.hide();
				return RtaAppVariantFeature.onSaveAs(_oRootControlRunningApp, oAppVariantDescriptor);
			})["catch"](function(oError) {
				BusyIndicator.hide();
				return AppVariantUtils.showTechnicalError(MessageBox.Icon.ERROR, "HEADER_MANAGE_APPS_FAILED", "MSG_MANAGE_APPS_FAILED", oError);
			});
		},
		copyId: function(oEvent) {
			var sCopiedId = this.getModelProperty("appId", oEvent.getSource().getBindingContext());
			AppVariantUtils.copyId(sCopiedId);
		}
	});
});
}; // end of sap/ui/rta/appVariant/manageApps/webapp/controller/ManageApps.controller.js
