/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','sap/m/Dialog','sap/m/Popover','sap/m/InstanceManager','sap/ui/core/Popup','sap/ui/dt/OverlayRegistry','sap/ui/dt/Overlay','sap/ui/fl/Utils','sap/ui/core/Component','sap/ui/core/ComponentContainer','sap/ui/core/Element'],function(q,M,D,P,I,a,O,b,f,C,c,E){"use strict";var F={"add":"_activateFocusHandle","remove":"_deactivateFocusHandle"};var d=M.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});d.prototype._overrideInstanceFunctions=function(){this._applyPopupMethods(this._createPopupOverlays);this._overrideAddPopupInstance();this._overrideRemovePopupInstance();};d.prototype.getRelevantPopups=function(){var o,e;o=I.getOpenDialogs();e=I.getOpenPopovers();var r={aDialogs:this._getValidatedPopups(o),aPopovers:this._getValidatedPopups(e)};return r;};d.prototype._getValidatedPopups=function(o){o=o.filter(function(p){return this._isPopupAdaptable(p);}.bind(this));return(o.length>0)?o:false;};d.prototype._isComponentInsidePopup=function(p){return q.isArray(p.getContent())?p.getContent().some(function(o){if(o instanceof c){return this.oRtaRootAppComponent===this._getAppComponentForControl(sap.ui.getCore().getComponent(o.getComponent()));}}.bind(this)):false;};d.prototype._isSupportedPopup=function(p){return(p instanceof sap.m.Dialog||p instanceof sap.m.Popover);};d.prototype.setRta=function(r){if(r&&r._oDesignTime){this.setProperty("rta",r);var R=sap.ui.getCore().byId(r.getRootControl());this.oRtaRootAppComponent=this._getAppComponentForControl(R);this._overrideInstanceFunctions();var m=this._onModeChange.bind(this);r.attachModeChanged(m);}};d.prototype._onModeChange=function(e){var s,n=e.getParameters().mode;var A=function(p){p.oPopup[s]();};if(n==='navigation'){s=this._getFocusEventName("add");this._applyFocusEventsToOpenPopups(A);}else{s=this._getFocusEventName("remove");this._removeFocusEventsFromOpenPopups(A);}};d.prototype._applyFocusEventsToOpenPopups=function(e){this._applyPopupMethods(e,true);};d.prototype._removeFocusEventsFromOpenPopups=function(e){this._applyPopupMethods(e);};d.prototype._getFocusEventName=function(o){return F[o];};d.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=I.addDialogInstance;I.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=I.addPopoverInstance;I.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance);};d.prototype._overrideAddFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){p.attachAfterOpen(this._createPopupOverlays,this);this.fireOpen(p);}return v;}.bind(this);};d.prototype._applyPopupMethods=function(p,e){var r=this.getRelevantPopups();Object.keys(r).forEach(function(k){if(r[k]){if(e){q.sap.focus(r[k][0].oPopup.oContent);}r[k].forEach(function(o){p.call(this,o);}.bind(this));}}.bind(this));};d.prototype._applyPopupPatch=function(p){var o=O.getOverlay(p);var e=b.getOverlayContainer(o);var g=p.oPopup;var A=[g.oContent.getDomRef(),e].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){A.push(this.getRta().getToolbar().getDomRef());}g.setAutoCloseAreas(A);if(!this.fnOriginalPopupOnAfterRendering){this.fnOriginalPopupOnAfterRendering=g.onAfterRendering;}g.onAfterRendering=function(){var v=this.fnOriginalPopupOnAfterRendering.apply(g,arguments);g[this._getFocusEventName("remove")]();return v;}.bind(this);if(this.getRta().getMode()==='adaptation'){g[this._getFocusEventName("remove")]();}};d.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=I.removeDialogInstance;I.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=I.removePopoverInstance;I.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance);};d.prototype._overrideRemoveFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(p);this.fireClose(p);}return v;}.bind(this);};d.prototype._getAppComponentForControl=function(o){var e,A;if(o instanceof C){e=o;}else{e=this._getComponentForControl(o);}if(e){A=f.getAppComponentForControl(e);}return A;};d.prototype._getComponentForControl=function(o){var e,r,p;if(o){e=C.getOwnerComponentFor(o);if(!e&&typeof o.getParent==="function"&&o.getParent()instanceof E){p=o.getParent();}else if(e){p=e;}if(p){r=this._getComponentForControl(p);}}return r?r:e;};d.prototype._createPopupOverlays=function(e){if(!e){return;}var p=(e instanceof E)?e:e.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(p.getId())===-1&&!this._isComponentInsidePopup(p)){this.getRta()._oDesignTime.addRootElement(p);}p.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(p);};d.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){I.addDialogInstance=this._fnOriginalAddDialogInstance;}if(this._fnOriginalRemoveDialogInstance){I.removeDialogInstance=this._fnOriginalRemoveDialogInstance;}if(this._fnOriginalAddPopoverInstance){I.addPopoverInstance=this._fnOriginalAddPopoverInstance;}if(this._fnOriginalRemovePopoverInstance){I.removePopoverInstance=this._fnOriginalRemovePopoverInstance;}this._applyFocusEventsToOpenPopups(this._removePopupPatch);};d.prototype._removePopupPatch=function(p){var o=p.oPopup;o[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){o.onAfterRendering=this.fnOriginalPopupOnAfterRendering;}};d.prototype._isPopupAdaptable=function(p){var o=this._getAppComponentForControl(p);return(this.oRtaRootAppComponent===o||this._isComponentInsidePopup(p))&&this._isSupportedPopup(p);};d.prototype.exit=function(){this._restoreInstanceFunctions();};return d;},true);
