// This file has been generated by the SAPUI5 'AllInOne' Builder
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

window.sapUiSupportReport = window.sapUiSupportReport || {};
window.sapUiSupportReport.collapseExpand = (function() {
	'use strict';

	function collapseExpandClickHandler(event) {
		var toExpandElementId = this.getAttribute('data-expandableElement');
		var expandableElement = document.getElementById(toExpandElementId);
		var toExpand = expandableElement.classList.contains('collapsed');

		if (toExpand) {
			expandableElement.classList.remove('collapsed');
			expandableElement.classList.add('expanded');
			this.classList.remove('collapsed-content');
			this.classList.add('expanded-content');
		} else {
			expandableElement.classList.remove('expanded');
			expandableElement.classList.add('collapsed');
			this.classList.remove('expanded-content');
			this.classList.add('collapsed-content');
		}
	}

	function init() {
		try {
			var expandableElements = document.getElementsByClassName('expandable-control');
			if (!expandableElements) {
				return;
			}

			for (var i = 0; i < expandableElements.length; i++) {
				expandableElements[i].addEventListener('click', collapseExpandClickHandler);

				// Set the default collapsed/expanded state of the expandable content.
				var elementToExpandId = expandableElements[i].getAttribute('data-expandableElement');
				var elementToExpand = document.getElementById(elementToExpandId);
				if (expandableElements[i].classList.contains('collapsed-content')) {
					elementToExpand.classList.add('collapsed');
				} else {
					elementToExpand.classList.add('expanded');
				}

				expandableElements[i].setAttribute('style', 'cursor: pointer;');
			}
		} catch (ex) {
			/* eslint-disable no-console */
			console.log('There was a problem initializing collapse/expand functionality.');
			/* eslint-enable no-console */
		}
	}

	return {
		init: init
	};
}());
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

window.sapUiSupportReport = window.sapUiSupportReport || {};
window.sapUiSupportReport.filter = (function () {
	'use strict';

	// Used to update the groups counters and hide/show group headers if all
	// of the elements are filtered.
	function updateIssuesGroups() {
		// Get all groups.
		var groupHeaderElements = document.querySelectorAll('[data-groupName]');

		for (var i = 0; i < groupHeaderElements.length; i++) {
			var groupHeader = groupHeaderElements[i];
			var issuesGroupId = groupHeader.getAttribute('data-expandableElement');
			var groupName = groupHeader.getAttribute('data-groupName');
			var groupNumber = groupHeader.getAttribute('data-groupNumber');
			// Get all rules for the current group.
			var rules = document.querySelectorAll('#' + issuesGroupId + ' > tr');
			var numberOfUnfilteredIssues = 0;
			var numberOfUnfilteredRules = 0;

			// Hide the rule section if no issues. Otherwise update count.
			for (var k = 0; k < rules.length; k++) {
				var rule = rules[k];
				var unfilteredIssuesForRule = rule.querySelectorAll('tr.filterable:not(.filtered)');
				var numberOfUnfilteredIssuesForRule = unfilteredIssuesForRule.length;
				if (numberOfUnfilteredIssuesForRule === 0) {
					rule.classList.add('filtered');
				} else {
					numberOfUnfilteredRules++;
					numberOfUnfilteredIssues += numberOfUnfilteredIssuesForRule;
					rule.querySelector('span.rule-issue-number').innerText = '(' + numberOfUnfilteredIssuesForRule + ' issues)';
				}
			}

			// Hide the group section if no issues. Otherwise update count.
			if (numberOfUnfilteredRules === 0) {
				groupHeader.classList.add('filtered');
			} else {
				groupHeader.classList.remove('filtered');
				groupHeader.querySelector('span').innerText = ' ' + groupNumber + '. ' + groupName + ' (' + numberOfUnfilteredRules + ' rules, ' + numberOfUnfilteredIssues + ' issues)';
			}
		}
	}
	function selectFilter(filter) {
		if (filter.classList.contains('filter-active')) {
			return;
		}

		var activeFilters = document.getElementsByClassName('filter-active');
		for (var k = 0; k < activeFilters.length; k++) {
			activeFilters[k].classList.remove('filter-active');
		}
		filter.classList.add('filter-active');
	}
	function resetFilters() {
		var filteredElements = document.querySelectorAll('.filtered');
		for (var i = 0; i < filteredElements.length; i++) {
			filteredElements[i].classList.remove('filtered');
		}
	}
	function filterBy(severity) {
		resetFilters();
		if (severity === 'Total') {
			return;
		}

		var elements = document.querySelectorAll('.filterable:not([data-severity="' + severity + '"])');
		for (var i = 0; i < elements.length; i++) {
			elements[i].classList.add('filtered');
		}
	}
	function filterClickHandler(event) {
		selectFilter(this);
		var severity = this.getAttribute('data-severity');
		filterBy(severity);
		updateIssuesGroups();
	}

	function init() {
		try {
			var filters = document.getElementsByClassName('filter');

			if (!filters) {
				return;
			}

			for (var i = 0; i < filters.length; i++) {
				if (filters[i].classList.contains('filter-initialized')) {
					continue;
				}

				filters[i].addEventListener('click', filterClickHandler);
				filters[i].classList.add('filter-initialized');
			}
		} catch (ex) {
			/* eslint-disable no-console */
			console.log('There was a problem initializing filters.');
			/* eslint-enable no-console */
		}
	}

	return {
		init: init
	};
}());
jQuery.sap.declare('sap.ui.support.library-all');
jQuery.sap.declare('sap.ui.support.supportRules.report.resources.collapseExpand'); // raw module, declared by SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.support.supportRules.report.resources.filter'); // raw module, declared by SAPUI5 'AllInOne' Builder
if ( !jQuery.sap.isDeclared('sap.ui.support.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.support.
 */
jQuery.sap.declare('sap.ui.support.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
sap.ui.define("sap/ui/support/library",["sap/ui/core/library"],
	function (library1) {
	"use strict";

	/**
	 * UI5 library: sap.ui.support.
	 * A library for the Support Assistant tool.
	 * <h3>Overview</h3>
The library provides the Support Assistant tool. It enables application developers to check whether their applications are built according to the best practices for building SAPUI5 apps. The tool uses a set of pre-defined rules to check all aspects of an application.
	 *
	 * @namespace
	 * @name sap.ui.support
	 * @author SAP SE
	 * @version 1.52.30
	 *
	 * @public
	 */

	// library dependencies

	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.support",
		// Loading sap.ui.codeeditor is moved to overlay.html to make sure it is loaded from the correct origin.
		dependencies : ["sap.ui.core", "sap.ui.fl", "sap.m", "sap.ui.layout"],
		types: [
			"sap.ui.support.Severity"
		],
		interfaces: [],
		controls: [],
		elements: [],
		noLibraryCSS: false,
		version: "1.52.30"
	});

	/**
	 * Defines severity types.
	 * @enum {string}
	 * @since 1.52.30
	 * @public
	 */
	sap.ui.support.Severity = {
		/**
		 * Medium issue severity.
		 * @public
		 */
		Medium: "Medium",
		/**
		 * High issue severity.
		 * @public
		 */
		High: "High",
		/**
		 * Low issue severity.
		 * @public
		 */
		Low: "Low"
	};

	/**
	 * Defines the Audiences.
	 * @enum {string}
	 * @since 1.52.30
	 * @public
	 */
	sap.ui.support.Audiences = {
		/**
		 * Audience just on Control level.
		 * @public
		 */
		Control: "Control",
		/**
		 * Audience just on Internal level.
		 * @public
		 */
		Internal: "Internal",
		/**
		 * Audience just on Application level.
		 * @public
		 */
		Application: "Application"
	};

	/**
	 * Issue Categories.
	 * @enum {string}
	 * @since 1.52.30
	 * @public
	 */
	sap.ui.support.Categories = {
		/**
		 * Accessibility issue category.
		 * @public
		 */
		Accessibility: "Accessibility",
		/**
		 * Performance issue category.
		 * @public
		 */
		Performance: "Performance",
		/**
		 * Memory issue category.
		 * @public
		 */
		Memory: "Memory",
		/**
		 * Binding issue category.
		 * @public
		 */
		Bindings: "Bindings",
		/**
		 * Consistency issue category.
		 * @public
		 */
		Consistency: "Consistency",
		/**
		 * Functionality issue category.
		 * @public
		 */
		Functionality : "Functionality",
		/**
		 * Usability issue category.
		 * @public
		 */
		Usability : "Usability",
		/**
		 * DataModel issue category.
		 * @public
		 */
		DataModel: "DataModel",
		/**
		 * Usage issue category.
		 * @public
		 */
		Usage: "Usage",
		/**
		 * Accessibility issue category.
		 * @public
		 */
		Other: "Other"
	};

	return sap.ui.support;
});

}; // end of sap/ui/support/library.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.Constants') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.support.supportRules.Constants'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/Constants",[],
	function() {
		"use strict";

		/**
		 * Constants used in the Support Assistant
		 * @enum {string}
		 * @private
		 * @author SAP SE
		 * @namespace
		 * @name sap.ui.support.Constants
		 * @alias sap.ui.support.AssistantConstants
		 * @returns {Object} Object that contains all the constants.
		 */
		return {
			/**
			 * @readonly
			 * The following constants are used to store rules and user data in the local storage.
			 */

			/**
			 * Stores temporary rules.
			 */
			TEMP_RULESETS_NAME: "temporary",

			/**
			 * Name of the SupportAssistant.
			 */
			SUPPORT_ASSISTANT_NAME: "Support Assistant",

			/**
			 * Key for storing temporary rules in the local storage.
			 */
			LOCAL_STORAGE_TEMP_RULES_KEY: "support-assistant-temprules",

			/**
			 * Key for storing selected rules in the local storage.
			 */
			LOCAL_STORAGE_SELECTED_RULES_KEY: "support-assistant-selected-rules",

			/**
			 * Key for storing selected context in the local storage.
			 */
			LOCAL_STORAGE_SELECTED_CONTEXT_KEY: "support-assistant-settings-selected-context",

			/**
			 * Stores temporary rules in the local storage.
			 */
			LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY: "support-assistant-settings-selected-context-components",

			/**
			 * The name of the persistence cookie.
			 */
			COOKIE_NAME: "persistence-cookie",

			/**
			 * Color used for severity high issues
			 */
			SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR: "#bb0000",

			/**
			 * Color used for severity medium issues
			 */
			SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR: "#e78c07",

			/**
			 * Color used for severity high issues
			 */
			SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR: "#5e696e",

			/**
			 * Low severity of produced issue by Support Assistant
			 */
			SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW: "Low",

			/**
			 * Medium severity of produced issue by Support Assistant
			 */
			SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM: "Medium",

			/**
			 * High severity of produced issue by Support Assistant
			 */
			SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH: "High"

		};


	}, /* bExport= */ true);

}; // end of sap/ui/support/supportRules/Constants.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.CoreFacade') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*!
 * An interface to the core to be used by rules
 */
jQuery.sap.declare('sap.ui.support.supportRules.CoreFacade'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/CoreFacade",[],
	function () {
		"use strict";

		var coreInstance = null;

		/**
		 * @classdesc
		 * <h3>Overview</h3>
		 * The CoreFacade interface gives access to the Metadata, Models, UI areas and Components of the Core object.
		 * <h3>Usage</h3>
		 * The CoreFacade is passed to all rule check functions as an object. This helps rule developers to access the core state.
		 * @name sap.ui.support.CoreFacade
		 * @param {object} oCore Core object as available in core plugins
		 * @returns {object} Instance of the <code>CoreFacade</code>
		 * @public
		 */
		function CoreFacade(oCore) {
			coreInstance = oCore;

			return {
				/**
				 * Gets the Metadata from the Core object.
				 * @public
				 * @name sap.ui.support.CoreFacade.getMetadata
				 */
				getMetadata: function () {
					return coreInstance.getMetadata();
				},
				/**
				 * Gets the UI areas from the Core object.
				 * @public
				 * @name sap.ui.support.CoreFacade.getUIAreas
				 */
				getUIAreas: function () {
					return coreInstance.mUIAreas;
				},
				/**
				 * Gets the Components from the Core object.
				 * @public
				 */
				getComponents: function () {
					return coreInstance.mObjects.component;
				},
				/**
				 * Gets the Models from the Core object.
				 * @public
				 */
				getModels: function () {
					return coreInstance.oModels;
				}
			};
		}

		return CoreFacade;

	}, true);

}; // end of sap/ui/support/supportRules/CoreFacade.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ExecutionScope') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

 /**
	 * @classdesc
	 * <h3>Overview</h3>
	 * ExecutionScope provides access to internal UI5 objects available for inspection
	 * <h3>Usage</h3>
	 * Each rule is passed three parameters when executed: check: oIssueManager, oCoreFacade, oScope
	 * An ExecutionScope instance is passed to every call of a rule's check method. Available objects
	 * are collected depending on the settings passed to Support Assistant's entry point - the analyze
	 * method
	 * @public
	 * @class sap.ui.support.ExecutionScope
	 */
jQuery.sap.declare('sap.ui.support.supportRules.ExecutionScope'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ExecutionScope",["jquery.sap.global"],
	function(jQuery) {
		"use strict";

		var coreInstance = null,
			_context = null,
			elements = [];

		var globalContext = {
			setScope: function () {
				for (var i in coreInstance.mElements) {
					elements.push(coreInstance.mElements[i]);
				}
			}
		};

		var subtreeContext = {
			setScope: function () {
				var parent = sap.ui.getCore().byId(_context.parentId);
				//TODO: Handle parent not found
				elements = parent.findAggregatedObjects(true);
			}
		};

		var componentsContext = {
			setScope: function () {
				var set = {};
				_context.components.forEach(function (componentId) {
					var component = coreInstance.mObjects.component[componentId],
						aggregations = component.findAggregatedObjects(true);

					aggregations.forEach(function (agg) {
						set[agg.getId()] = agg;
					});
				});

				for (var i in set) {
					if (set.hasOwnProperty(i)){
						elements.push(set[i]);
					}
				}
			}
		};

		var contextTypes = {
			global: globalContext,
			subtree: subtreeContext,
			components: componentsContext
		};

		function isInPublicAggregation(oChild) {
			// Try getting a child via its parent
			var oChildAsAggregation = oChild.getParent().getMetadata().getAggregation(oChild.sParentAggregationName);
			return !!oChildAsAggregation;
		}

		function getPublicElementsInside(oControlRoot) {
			var oRoot;

			if (oControlRoot.getRootControl) {
				oRoot = oControlRoot.getRootControl();
				if (oRoot) {
					//TODO also exclude clones of binding templates, but include the binding template
					//TODO also exclude customData etc.?
					return oRoot.findAggregatedObjects(true, isInPublicAggregation);
				}
			}

			return [];
		}

		function ExecutionScope(core, context) {
			coreInstance = core;
			elements = [];
			_context = context;

			contextTypes[_context.type].setScope();

			return {
				getElements: function () {
					return elements;
				},
				getPublicElements: function () {
					var aPublicElements = [];
					var mComponents = core.mObjects.component;
					var mUIAreas = core.mUIAreas;

					for (var i in mComponents) {
						aPublicElements = aPublicElements.concat(getPublicElementsInside(mComponents[i]));
					}

					for (var key in mUIAreas) {
						aPublicElements = aPublicElements.concat(getPublicElementsInside(mUIAreas[key]));
					}

					return aPublicElements;
				},
				/**
				 * Gets elements by their type
				 * @public
				 * @function
				 * @param {string|function} classNameSelector
				 * @alias sap.ui.support.ExecutionScope.getElementsByClassName
				 */
				getElementsByClassName: function (classNameSelector) {
					if (typeof classNameSelector === "string") {
						return elements.filter(function (element) {
							return element.getMetadata().getName() === classNameSelector;
						});
					}

					if (typeof classNameSelector === "function") {
						return elements.filter(function (element) {
							return element instanceof classNameSelector;
						});
					}
				},
				/**
				 * Gets the logged objects by object type
				 * @public
				 * @function
				 * @param {any} type Type of logged objects
				 * @alias sap.ui.support.ExecutionScope.getLoggedObjects
				 */
				getLoggedObjects: function (type) {
					var log = jQuery.sap.log.getLog(),
						loggedObjects = [];

					// Add logEntries that have support info object,
					// and that have the same type as the type provided
					log.forEach(function (logEntry) {
						if (!logEntry.supportInfo) {
							return;
						}

						var elemIds = elements.map(function (element) {
							return element.getId();
						});

						var hasElemId = !!logEntry.supportInfo.elementId,
							typeMatch = logEntry.supportInfo.type === type || type === undefined,
							scopeMatch = !hasElemId || (jQuery.inArray(logEntry.supportInfo.elementId, elemIds) > -1);

						/**
						 * Give the developer the ability to pass filtering function
						 */
						if (typeof type === "function" && type(logEntry) && scopeMatch) {
							loggedObjects.push(logEntry);
							return;
						}

						if (typeMatch && scopeMatch) {
							loggedObjects.push(logEntry);
						}
					});

					return loggedObjects;
				},
				_getType: function () {
					return _context.type;
				},
				_getContext: function () {
					return _context;
				}
			};
		}

		ExecutionScope.possibleScopes = Object.getOwnPropertyNames(contextTypes);

		return ExecutionScope;
	}, true);
}; // end of sap/ui/support/supportRules/ExecutionScope.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.IssueManager') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * The IssueManager interface stores, groups and converts issues from the Core Object to a usable model by the Support Assistant.
 * Issues can be added only through the IssueManager using <code>addIssue</code> method.
 */
jQuery.sap.declare('sap.ui.support.supportRules.IssueManager'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.Object'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/IssueManager",["jquery.sap.global", "sap/ui/base/Object", "sap/ui/support/supportRules/Constants"],
	function (jQuery, BaseObject, constants) {
		"use strict";
		/**
		 * @type {object[]} _aIssues Issues stored in the IssueManager
		 * @private
		 */
		var _aIssues = [];

		/**
		 * @type {object[]} _aHistory Array of history objects which contain issues key that has an array of issues.
		 * @private
		 */
		var _aHistory = [];

		/**
		 * Converts Issue Object to a ViewModel that can be used by the IssueManager.
		 * @param {object} oIssue Issue Object that is to be converted
		 * @returns {object} Converted Issue Object
		 */
		var _convertIssueToViewModel = function (oIssue) {
			var element = sap.ui.getCore().byId(oIssue.context.id),
				className = "";

			if (oIssue.context.id === "WEBPAGE") {
				className = "sap.ui.core";
			} else if (element) {
				className = element.getMetadata().getName();
			}

			return {
				severity: oIssue.severity,
				name: oIssue.rule.title,
				description: oIssue.rule.description,
				resolution: oIssue.rule.resolution,
				resolutionUrls: oIssue.rule.resolutionurls,
				audiences: oIssue.rule.audiences,
				categories: oIssue.rule.categories,
				details: oIssue.details,
				ruleLibName: oIssue.rule.libName,
				ruleId: oIssue.rule.id,
				async: oIssue.rule.async === true, // Ensure async is either true or false
				minVersion: oIssue.rule.minversion,
				context: {
					className: className,
					id: oIssue.context.id
				}
			};
		};

		/**
		 * @class
		 * The IssueManager is used to store and export issues to the Support Assistant.
		 * <h3>Overview</h3>
		 * The IssueManager is used to store and export issues found by the Support Assistant.
		 * <h3>Usage</h3>
		 * The IssueManager can be used as a static class and add issues using the <code>addIssue</code> method of both the IssueManager or the IssueManagerFacade.
		 * @public
		 * @name sap.ui.support.IssueManager
		 * @alias IssueManager
		 *
		 * @lends IssueManager
		 */
		var IssueManager = {


			/**
			 * Adds an issue to the list of issues found.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.addIssue
			 * @param {object} oIssue The issue to be added in the IssueManager
			 */
			addIssue: function (oIssue) {
				_aIssues.push(oIssue);
			},
			/**
			 * Cycles through issues stored in the IssueManager and executes the given callback function.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.walkIssues
			 * @param {function} fnCallback Callback function to be used in the same fashion as Array.prototype.forEach
			 */
			walkIssues: function (fnCallback) {
				_aIssues.forEach(fnCallback);
			},

			/**
			 * Clears all issues in the IssueManager.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.clearIssues
			 * @returns {void}
			 */
			clearIssues: function () {
				_aIssues = [];
			},

			/**
			 * Saves a new history object with the current issues.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.saveHistory
			 * @returns {void}
			 */
			saveHistory: function () {
				_aHistory.push({
					issues: _aIssues.slice()
				});
			},

			/**
			 * Gets history objects with current issues. Each history object has an issues key that contains an array of issues.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.getHistory
			 * @returns {object[]} Current history in the IssueManager.
			 */
			getHistory: function () {
				// Copy and return history
				return _aHistory.slice();
			},

			/**
			 * Gets grouped history containing <code>ViewModel</code>. Each history object has an issues key that contains the issues grouped by library and rule in ViewModel format.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.getConvertedHistory
			 * @returns {object[]} convertedHistory Grouped issue history object containing converted issues to ViewModel format.
			 */
			getConvertedHistory: function () {
				var that = this,
					issueHistory = that.getHistory(),
					convertedHistory = [],
					issues = null;

				issueHistory.forEach(function (run) {
					issues = that.groupIssues(
						that.convertToViewModel(run.issues)
					);
					convertedHistory.push({ issues: issues });
				});

				return convertedHistory;
			},

			/**
			 * Converts the issues inside the IssueManager.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.getIssuesModel
			 * @returns {object[]} viewModel Issues in ViewModel format
			 */
			getIssuesModel: function () {
				var aViewModel = [];

				this.walkIssues(function (issue) {
					aViewModel.push(_convertIssueToViewModel(issue));
				});

				return aViewModel;
			},

			/**
			 * Gets rules and issues, and converts each rule to a ruleViewModel - parameters should be converted as specified beforehand.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.getRulesViewModel
			 * @param {object} rules All the rules from _mRulesets
			 * @param {array} selectedRulesIDs The rule ID's of the selected rules.
			 * @param {array} issues The issues to map to the rulesViewModel
			 * The issues passes should be grouped and in ViewModel format.
			 * @returns {object} rulesViewModel All the rules with issues, selected flag and issueCount properties
			 * The issues are in ViewModel format.
			 */
			getRulesViewModel: function (rules, selectedRulesIDs, issues) {
				var rulesViewModel = {},
					issueCount = 0,
					group = {},
					library = {},
					rule = {},
					rulesCopy = jQuery.extend(true, {}, rules),
					issuesCopy = jQuery.extend(true, {}, issues);

				for (group in rulesCopy) {
					rulesViewModel[group] = jQuery.extend(true, {}, rulesCopy[group].ruleset._mRules);
					library = rulesViewModel[group];

					// Create non-enumerable properties
					Object.defineProperty(library, 'selected', {
						enumerable: false,
						configurable: true,
						writable: true,
						value: false
					});
					Object.defineProperty(library, 'issueCount', {
						enumerable: false,
						configurable: true,
						writable: true,
						value: 0
					});

					for (rule in rulesCopy[group].ruleset._mRules) {
						library[rule] = jQuery.extend(true, [], library[rule]);

						// Create non-enumerable properties
						Object.defineProperty(library[rule], 'selected', {
							enumerable: false,
							configurable: true,
							writable: true,
							value: false
						});
						Object.defineProperty(library[rule], 'issueCount', {
							enumerable: false,
							configurable: true,
							writable: true,
							value: 0
						});

						// Add selected flag to library and rule level.
						if (selectedRulesIDs[rule]) {
							library[rule].selected = true;
							library.selected = true;
						}

						// Add issue count to library and rule level.
						if (issuesCopy[group] && issuesCopy[group][rule]) {
							// Not creating a new array to keep the properties.
							library[rule].push.apply(library[rule], issuesCopy[group][rule]);
							issueCount = issuesCopy[group][rule].length;
							library[rule].issueCount = issueCount;
							library.issueCount += issueCount;
						}
					}
				}

				return rulesViewModel;
			},

			/**
			 * Gets rules and converts them into treeTable format.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.getTreeTableViewModel
			 * @param {object} oRules Deserialized rules found within the current state
			 * @returns {object} TreeTableModel Rules in treeTable usable format
			 * The rules are in a TreeTable format.
			 */
			getTreeTableViewModel: function(oRules) {
				var index = 0,
					innerIndex = 0,
					treeTableModel = {},
					rulesViewModel;

				rulesViewModel = this.getRulesViewModel(oRules, [], []);
				for (var libraryName in rulesViewModel) {
					treeTableModel[index] = {
						name: libraryName,
						type: "lib",
						rules: []
					};

					for (var ruleName in rulesViewModel[libraryName]) {
						treeTableModel[index][innerIndex] = {
							name: rulesViewModel[libraryName][ruleName].title,
							description: rulesViewModel[libraryName][ruleName].description,
							id: rulesViewModel[libraryName][ruleName].id,
							audiences: rulesViewModel[libraryName][ruleName].audiences,
							categories: rulesViewModel[libraryName][ruleName].categories,
							minversion: rulesViewModel[libraryName][ruleName].minversion,
							resolution: rulesViewModel[libraryName][ruleName].resolution,
							title:  rulesViewModel[libraryName][ruleName].title,
							libName: libraryName
						};
						innerIndex++;
					}
					index++;
				}
				return treeTableModel;
			},

			/**
			 * Gets issues in TreeTable format.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.getIssuesViewModel
			 * @param {object} issuesModel All the issues after they have been grouped with <code>groupIssues</code>
			 * @returns {object} All the issues in TreeTable usable model
			 */
			getIssuesViewModel: function(issuesModel) {

				var treeTableModel = {},
					index = 0,
					innerIndex = 0,
					issueCount = 0,
					oSortedSeverityCount,
					iHighSeverityCount = 0,
					iMediumSeverityCount = 0,
					iLowSeverityCount = 0;

				for (var libName in issuesModel) {
					treeTableModel[index] = {
						name: libName,
						showAudiences: false,
						showCategories: false,
						type: "lib"
					};

					for (var rule in issuesModel[libName]) {

						oSortedSeverityCount = this._sortSeverityIssuesByPriority(issuesModel[libName][rule]);
						treeTableModel[index][innerIndex] = {
							formatedName: issuesModel[libName][rule][0].name + " (<span style=\"color:" + constants.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR +  ";\"> " +  oSortedSeverityCount.high + " H, </span> " + "<span style=\"color:" + constants.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR +  ";\"> " +  oSortedSeverityCount.medium + " M, </span> " + "<span style=\"color:" + constants.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR +  ";\"> " +  oSortedSeverityCount.low + " L) </span>",
							name: issuesModel[libName][rule][0].name,
							showAudiences: true,
							showCategories: true,
							categories: issuesModel[libName][rule][0].categories.join(", "),
							audiences: issuesModel[libName][rule][0].audiences.join(", "),
							issueCount: issuesModel[libName][rule].length,
							description: issuesModel[libName][rule][0].description,
							resolution: issuesModel[libName][rule][0].resolution,
							type: "rule",
							ruleLibName: issuesModel[libName][rule][0].ruleLibName,
							ruleId: issuesModel[libName][rule][0].ruleId,
							selected: issuesModel[libName][rule][0].selected,
							details: issuesModel[libName][rule][0].details,
							severity: issuesModel[libName][rule][0].severity
						};


						issueCount += issuesModel[libName][rule].length;
						innerIndex++;
						iHighSeverityCount  += oSortedSeverityCount.high;
						iMediumSeverityCount += oSortedSeverityCount.medium;
						iLowSeverityCount += oSortedSeverityCount.low;
					}


					treeTableModel[index].formatedName = treeTableModel[index].name + " (" + "<span style=\"color: " + constants.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR +  "; \"> " +  iHighSeverityCount + " High, </span> " + "<span style=\"color:  " + constants.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR +  ";\"> " +  iMediumSeverityCount + " Medium, </span> " + "<span style=\"color " + constants.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR +  ";\"> " +  iLowSeverityCount + " Low </span>)";
					treeTableModel[index].name += " (" + issueCount + " issues)";
					treeTableModel[index].issueCount = issueCount;
					issueCount = 0;
					innerIndex = 0;
					index++;
					iHighSeverityCount = 0;
					iMediumSeverityCount = 0;
					iLowSeverityCount = 0;
				}

				return treeTableModel;
			},

			/**
			 * Sorts number of severity issues e.g. 1 High, 0 Medium, 0 Low.
			 * @private
			 * @param {array} aIssues
			 * @name sap.ui.support.IssueManager._sortSeverityIssuesByPriority
			 * @returns {object} Object containing the number of issues sorted by severity.
			 */
			_sortSeverityIssuesByPriority: function(aIssues) {
				var iHighIssues = 0,
					iMediumIssues = 0,
					iLowIssues = 0;
				aIssues.forEach(function(element) {
					switch (element.severity) {
						case constants.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:
							iLowIssues++;
							break;
						case constants.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:
							iMediumIssues++;
							break;
						case constants.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:
							iHighIssues++;
							break;
					}
				});

				return {high: iHighIssues, medium: iMediumIssues, low: iLowIssues};
			},

			/**
			 * Clears the history object within the IssueManager.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.clearHistory
			 * @returns {void}
			 */
			clearHistory: function () {
				_aHistory = [];
			},

			/**
			 * Converts issues to view model format.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.convertToViewModel
			 * @param {array} oIssues The issues to convert
			 * @returns {array} viewModel Issues in ViewModel format
			 */
			convertToViewModel: function (oIssues) {
				var viewModel = [];
				for (var i = 0; i < oIssues.length; i++) {
					viewModel.push(_convertIssueToViewModel(oIssues[i]));
				}
				return viewModel;
			},

			/**
			 * Groups all issues by library and rule ID.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.groupIssues
			 * @param {array} oIssues The issues to group. Must be in a ViewModel format
			 * @returns {array} groupedIssues Grouped issues by library and rule id
			 */
			groupIssues: function (oIssues) {
				var groupedIssues = {},
					issue = {};

				for (var i = 0; i < oIssues.length; i++) {
					issue = oIssues[i];

					if (!groupedIssues[issue.ruleLibName]) {
						groupedIssues[issue.ruleLibName] = {};
					}

					if (!groupedIssues[issue.ruleLibName][issue.ruleId]) {
						groupedIssues[issue.ruleLibName][issue.ruleId] = [];
					}

					groupedIssues[issue.ruleLibName][issue.ruleId].push(issue);
				}

				return groupedIssues;
			},

			/**
			 * Creates an instance of the IssueManagerFacade.
			 * @public
			 * @method
			 * @name sap.ui.support.IssueManager.createIssueManagerFacade
			 * @param {object} oRule Given rule
			 * @returns {object} New IssueManagerFacade
			 */
			createIssueManagerFacade: function (oRule) {
				return new IssueManagerFacade(oRule);
			}
		};

		/**
		 * Creates an IssueManagerFacade.
		 * @constructor
		 * @private
		 * @method
		 * @namespace
		 * @name sap.ui.support.IssueManagerFacade
		 * @param {object} oRule Rule for the IssueManagerFacade
		 * @returns {void}
		 */
		var IssueManagerFacade = function (oRule) {
			this.oRule = oRule;
		};

		/**
		 * Adds issue to the IssueManager via the IssueManagerFacade.
		 * @public
		 * @method
		 * @memberof IssueManagerFacade
		 * @param {object} oIssue Issue object to be added in the IssueManager
		 * @returns {void}
		 */
		IssueManagerFacade.prototype.addIssue = function (oIssue) {
			oIssue.rule = this.oRule;

			if (!sap.ui.support.Severity[oIssue.severity]) {
				throw "The issue from rule " + this.oRule.title + " does not have proper severity defined. Allowed values can be found" +
						"in sap.ui.support.Severity";
			}

			if (!oIssue.context || !oIssue.context.id) {
				throw "The issue from rule '" + this.oRule.title + "' should provide a context id.";
			}

			if (!oIssue.details) {
				throw "The issue from rule '" + this.oRule.title + "' should provide details for the generated issue.";
			}

			IssueManager.addIssue(oIssue);
		};

		return IssueManager;

	}, true);

}; // end of sap/ui/support/supportRules/IssueManager.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.RuleSerializer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.RuleSerializer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/RuleSerializer",[],
	function () {
		"use strict";

		return {
			serialize: function serializeRule(rule) {
				var replacer = function (key, value) {
					if (typeof value === "function") {
						return value.toString();
					} else {
						return value;
					}
				};

				var result = JSON.stringify(rule, replacer);
				return result;
			},
			deserialize: function (serializedRule, stringifyCheck) {
				var rule;

				if (typeof serializedRule === 'string') {
					rule = JSON.parse(serializedRule);
				} else {
					rule = serializedRule;
				}

				/* eslint-disable no-eval */
				if (!stringifyCheck && rule.check !== undefined) {
					eval("rule.check = " + rule.check);
				}
				/* eslint-enable no-eval */

				return rule;
			}
		};
	}, true);

}; // end of sap/ui/support/supportRules/RuleSerializer.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.Storage') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* global localStorage */

jQuery.sap.declare('sap.ui.support.supportRules.Storage'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/Storage",[
	"sap/ui/support/supportRules/RuleSerializer",
	"sap/ui/support/supportRules/Constants"
],

/**
 * @class
 * The Storage is used to store and recieve data in/from the LocalStorage in the browser.
 * <h3>Overview</h3>
 * The Storage class is used to persist user settings.
 * <h3>Usage</h3>
 * This class must be used with {@link sap.ui.support.RuleSerializer} and {@link sap.ui.support.Constants} in order to store user data in the LocalStorage.
 *
 * @name sap.ui.support.Storage
 * @alias sap.ui.support.Storage
 * @author SAP SE.
 * @version 1.52.30
 *
 * @private
 *
 * @param {object} RuleSerializer Instance of the {@link sap.ui.support.RuleSerializer}
 * @param {object} constants Constants written in the {@link sap.ui.support.Constants}
 *
 * @returns {object} Methods that enable the user to work with the LocalStorage.
 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
 */
function (RuleSerializer, constants) {
	"use strict";

	/**
	 * Encodes rules written by the user.
	 * @private
	 * @function
	 * @name Encode
	 * @param {string} sData Stringified object containing rule properties.
	 * @returns {string} base-64 encoded string.
	 */
	function encode(sData) {
		return window.btoa(unescape(encodeURIComponent(sData)));
	}

	/**
	 * Decodes the already encoded data by the user.
	 * @private
	 * @function
	 * @name Decode
	 * @param {string} sData Stringified base-64 object containing rule properties.
	 * @returns {string} Stringified object containing rule properties.
	 */
	function decode(sData) {
		return decodeURIComponent(escape(window.atob(sData)));
	}

	return {

		/**
		 * Returns all previously created temporary rules.
		 * @private
		 * @name sap.ui.support.Storage.getRules
		 * @method
		 * @returns {object[]} An array containing all the temporary rules.
		 */
		getRules: function () {
			var rawLSData = localStorage.getItem(constants.LOCAL_STORAGE_TEMP_RULES_KEY);

			if (!rawLSData) {
				return null;
			}

			var tempRules = JSON.parse(decode(rawLSData));

			tempRules = tempRules.map(function (tempRule) {
				return RuleSerializer.deserialize(tempRule);
			});

			return tempRules;
		},

		/**
		 * Saves the temporary rules into the LocalStorage persistence layer.
		 * @private
		 * @name sap.ui.support.Storage.setRules
		 * @method
		 * @param {object[]} rules The temporary rules from the shared model.
		 */
		setRules: function (rules) {
			var stringifyRules = encode(JSON.stringify(rules));
			localStorage.setItem(constants.LOCAL_STORAGE_TEMP_RULES_KEY, stringifyRules);
		},

		/**
		 * Retrieves the selected rules which are stored in the LocalStorage persistence layer.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.getSelectedRules
		 * @returns {object[]} All selected rules that are stored in the LocalStorage persistence layer.
		 */
		getSelectedRules: function () {
			var rawLSData = localStorage.getItem(constants.LOCAL_STORAGE_SELECTED_RULES_KEY);

			if (!rawLSData) {
				return null;
			}

			return JSON.parse(rawLSData);
		},

		/**
		 * Stores which rules are selected to be run by the analyzer on the next check.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.setSelectedRules
		 * @param {object[]} aSelectedRules The data for the libraries and their rules.
		 */
		setSelectedRules: function (aSelectedRules) {
			localStorage.setItem(constants.LOCAL_STORAGE_SELECTED_RULES_KEY, JSON.stringify(aSelectedRules));
		},

		/**
		 * Sets the context for the execution scope in the LocalStorage persistence layer.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.setSelectedContext
		 * @param {object} selectedContext Object containing the <code>analyzeContext</code> and <code>subtreeExecutionContextId</code>.
		 */
		setSelectedContext: function(selectedContext) {
			localStorage.setItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_KEY, JSON.stringify(selectedContext));
		},

		/**
		 * Retrieves the selected context from the LocalStorage persistence layer.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.getSelectedContext
		 * @returns {string} Parsed value of the <code>selectedContext</code> key in the LocalStorage persistence layer.
		 */
		getSelectedContext: function() {
			return JSON.parse(localStorage.getItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_KEY));
		},

		/**
		 * Sets the scope components that are selected.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.setSelectedScopeComponents
		 * @param {object} contextComponent Component that's stored in the LocalStorage.
		 */
		setSelectedScopeComponents: function(contextComponent)  {
			localStorage.setItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY, JSON.stringify(contextComponent));
		},

		/**
		 * Gets the scope components that are selected.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.getSelectedScopeComponents
		 * @returns {string} componentContext The selected components within a given scope.
		 */
		getSelectedScopeComponents: function() {
			var componentContext = localStorage.getItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);
			return JSON.parse(componentContext);
		},

		/**
		 * Overwrites the temporary rules into the local storage persistence layer.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.removeSelectedRules
		 * @param {object[]} aSelectedRules The temporary rules from the shared model.
		 */
		removeSelectedRules: function(aSelectedRules) {
			this.setRules(aSelectedRules);
		},

		/**
		 * Removes all data from LocalStorage persistence layer.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.removeAllData
		 */
		removeAllData: function() {
			localStorage.removeItem(constants.LOCAL_STORAGE_TEMP_RULES_KEY);
			localStorage.removeItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_KEY);
			localStorage.removeItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);
		},

		/**
		 * Creates a cookie with encoded information in the LocalStorage persistence layer.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.createPersistenceCookie
		 * @param {string} sCookieName Name of the cookie.
		 * @param {boolean} sCookieValue Contents of the cookie.
		 * @returns {void}
		 */
		createPersistenceCookie: function(sCookieName, sCookieValue) {
			document.cookie = sCookieName + "=" + sCookieValue;
		},

		/**
		 * Retrieves the persistence options of the user in the LocalStorage layer.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.readPersistenceCookie
		 * @alias readPersistenceCookie
		 * @param {string} sCookieName Name of the cookie.
		 * @returns {string} sOutput The persistence options of the user.
		 */
		readPersistenceCookie: function(sCookieName) {

			var name = sCookieName + "=",
				decodedCookie = decodeURIComponent(document.cookie),
				ca = decodedCookie.split(';'),
				sOutput = "";
			for (var i = 0; i < ca.length; i++) {
				var c = ca[i];
				while (c.charAt(0) == ' ') {
					c = c.substring(1);
				}
				if (c.indexOf(name) == 0) {
					sOutput = c.substring(name.length, c.length);
					return sOutput;
				}
			}

			return sOutput;

		},

		/**
		 * Removes the cookie with persistence information in the LocalStorage.
		 * @private
		 * @method
		 * @name sap.ui.support.Storage.deletePersistenceCookie
		 * @param {string} sCookieName Name of the cookie
		 * @returns {void}
		 */
		deletePersistenceCookie: function(sCookieName) {
			document.cookie = sCookieName + '=;expires=Thu, 01 Jan 1970 00:00:01 GMT;';
		}

	};
}, true);

}; // end of sap/ui/support/supportRules/Storage.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.WCBChannels') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.WCBChannels'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/WCBChannels",[
],
function () {
	"use strict";

	/**
	 * <h3>Overview</h3>
	 * These channels enable the user to hook to the {@link sap.ui.support.WindowCommunicationBus }
	 * <h3>Usage</h3>
	 * These channels are used for communication with Main.
	 * @name sap.ui.support.WCBChannels
	 * @alias CommunicationBusChannels
	 * @readonly
	 * @protected
	 * @returns {Object} Returns the channel constants which are used to subscribe to sap.ui.support.WindowCommunicationBus
	 */
	return {
		/**
		 * @enum
		 * @readonly
		 * The following channels can subscribe to the WindowCommunicationBus
		 */

		/**
		 * State change in the core.
		 * @type {string}
		 * @const
		 */
		ON_CORE_STATE_CHANGE:       "ON_CORE_STATE_CHANGE",

		/**
		 * Shows a report.
		 * @type {string}
		 * @const
		 */
		ON_SHOW_REPORT_REQUEST:     "ON_SHOW_REPORT_REQUEST",

		/**
		 * Downloads a report.
		 * @type {string}
		 * @const
		 */
		ON_DOWNLOAD_REPORT_REQUEST: "ON_DOWNLOAD_REPORT_REQUEST",

		/**
		 * Starts an analysis.
		 * @type {string}
		 * @const
		 */
		ON_ANALYZE_REQUEST:         "ON_ANALYZE_REQUEST",

		/**
		 * Notifies when the rulesets have to be loaded.
		 * @type {string}
		 * @const
		 */
		ON_INIT_ANALYSIS_CTRL:      "ON_INIT_ANALYSIS_CTRL",

		/**
		 * Provides the current progress status of the analysis.
		 * @type {string}
		 * @const
		 */
		ON_PROGRESS_UPDATE:         "ON_PROGRESS_UPDATE",

		/**
		 * Notifies after the analysis has finished.
		 * @type {string}
		 * @const
		 */
		ON_ANALYZE_FINISH:          "ON_ANALYZE_FINISH",

		/**
		 * Posts information about the UI and it's iframe.
		 * @type {string}
		 * @const
		 */
		POST_UI_INFORMATION:  "POST_UI_INFORMATION",

		/**
		 * Verifies rule creation.
		 * @type {string}
		 * @const
		 */
		VERIFY_CREATE_RULE:         "VERIFY_CREATE_RULE",

		/**
		 * Verifies rule creation after its finished.
		 * @type {string}
		 * @const
		 */
		VERIFY_RULE_CREATE_RESULT:  "VERIFY_RULE_CREATE_RESULT",

		/**
		 * Verifies rule update.
		 * @type {string}
		 * @const
		 */
		VERIFY_UPDATE_RULE:         "VERIFY_UPDATE_RULE",

		/**
		 * Verifies rule update after its finished.
		 * @type {string}
		 * @const
		 */
		VERIFY_RULE_UPDATE_RESULT:  "VERIFY_RULE_UPDATE_RESULT",

		/**
		 * Posts available libraries.
		 * @type {string}
		 * @const
		 */
		POST_AVAILABLE_LIBRARIES:    "POST_AVAILABLE_LIBRARIES",

		/**
		 * Loads all rule sets.
		 * @type {string}
		 * @const
		 */
		LOAD_RULESETS:               "LOAD_RULESETS",

		/**
		 * Gets components.
		 * @type {string}
		 * @const
		 */
		GET_AVAILABLE_COMPONENTS:   "GET_AVAILABLE_COMPONENTS",

		/**
		 * Posts components.
		 * @type {string}
		 * @const
		 */
		POST_AVAILABLE_COMPONENTS:  "POST_AVAILABLE_COMPONENTS",

		/**
		 * Highlight element in TreeTable.
		 * @type {string}
		 * @const
		 */
		HIGHLIGHT_ELEMENT:          "HIGHLIGHT_ELEMENT",

		/**
		 * Open given URL.
		 * @type {string}
		 * @const
		 */
		OPEN_URL:                   "OPEN_URL",

		/**
		 * Notifies onmouseenter event on the TreeTable.
		 * @type {string}
		 * @const
		 */
		TREE_ELEMENT_MOUSE_ENTER:   "TREE_ELEMENT_MOUSE_ENTER",

		/**
		 * Notifies onmouseout event on the TreeTable.
		 * @type {string}
		 * @const
		 */
		TREE_ELEMENT_MOUSE_OUT:     "TREE_ELEMENT_MOUSE_OUT",

		/**
		 * Updates support rules in IssueManager.
		 * @type {string}
		 * @const
		 */
		UPDATE_SUPPORT_RULES:       "UPDATE_SUPPORT_RULES",

		/**
		 * Upload external modules.
		 * @type {string}
		 * @const
		 */
		EXTERNAL_MODULE_UPLOADED:   "EXTERNAL_MODULE_UPLOADED",

		/**
		 * Hides SupportAssistant iframe.
		 * @type {string}
		 * @const
		 */
		TOGGLE_FRAME_HIDDEN:        "TOGGLE_FRAME_HIDDEN",

		/**
		 * Ensure SupportAssistant iframe is open.
		 * @type {string}
		 * @const
		 */
		ENSURE_FRAME_OPENED:        "ENSURE_FRAME_OPENED",

		/**
		 * Resize SupportAssistant iframe.
		 * @type {string}
		 * @const
		 */
		RESIZE_FRAME:               "RESIZE_FRAME",

		/**
		 * Request rules model.
		 * @type {string}
		 * @const
		 */
		REQUEST_RULES_MODEL:        "REQUEST_RULES_MODEL",

		/**
		 * Get rules model.
		 * @type {string}
		 * @const
		 */
		GET_RULES_MODEL:            "GET_RULES_MODEL",

		/**
		 * Request issues.
		 * @type {string}
		 * @const
		 */
		REQUEST_ISSUES:             "REQUEST_ISSUES",

		/**
		 * Gets the issues.
		 * @type {string}
		 * @const
		 */
		GET_ISSUES:                 "GET_ISSUES"
	};
}, true);

}; // end of sap/ui/support/supportRules/WCBChannels.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.WindowCommunicationBus') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * @typedef {object} EventListener
 */
jQuery.sap.declare('sap.ui.support.supportRules.WindowCommunicationBus'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/WindowCommunicationBus",[
	"jquery.sap.global"
],
function (jQuery) {
	"use strict";

	/**
	 * <h3>Overview</h3>
	 * The CommunicationBus is responsible for core communication between the SupportAssistant the views and SupportAssistant in iFrame mode.
	 * @class
	 * @constructor
	 * @name sap.ui.support.WindowCommunicationBus
	 * @memberof sap.ui.support
	 * @author SAP SE
	 * @version 1.52.30
	 * @private
	 */
	var CommunicationBus = {
		channels: {},
		onMessageChecks: []
	};

	/**
	 * Indicates the origin of the SupportAssistant.
	 */
	var originParameter = jQuery.sap.getUriParameters().get("sap-ui-xx-support-origin");
	var origin = originParameter;
	var frameIdentifier = jQuery.sap.getUriParameters().get("sap-ui-xx-frame-identifier") || '_unnamed_frame_-_use_message_origin_';

	if (!origin) {
		// When loading from CDN, module path needs to be relative to that origin
		var modulePathURI = new window.URI(jQuery.sap.getModulePath("sap.ui.support"));
		var protocol = modulePathURI.protocol() === "" ?
			window.location.protocol.replace(":", "") : modulePathURI.protocol();

		var host = modulePathURI.host() === "" ?
			window.location.host : modulePathURI.host();

		origin = protocol + "://" + host;
	}

	CommunicationBus.origin = origin;

	/**
	 * Subscribes to a channel with callback and given context
	 * @private
	 * @static
	 * @method
	 * @name sap.ui.support.WindowCommunicationBus.subscribe
	 * @memberof sap.ui.support.WindowCommunicationBus
	 * @param {string} sChannelName Name of the channel to subscribe
	 * @param {function} fnCallback Callback for the SupportAssistant
	 * @param {object} oContext Context for the subscribed channel
	 */
	CommunicationBus.subscribe = function (sChannelName, fnCallback, oContext) {
		if (!this.channels[sChannelName]) {
			this.channels[sChannelName] = [{
				callback: fnCallback,
				context: oContext
			}];
			return;
		}

		this.channels[sChannelName].push({
			callback: fnCallback,
			context: oContext
		});
	};

	/**
	 * Publishes given channel by name and settings
	 * @private
	 * @static
	 * @method
	 * @name sap.ui.support.WindowCommunicationBus.publish
	 * @memberof sap.ui.support.WindowCommunicationBus
	 * @param {string} sChannelName Name of the channel to publish
	 * @param {string} aParams Settings passed to the SupportAssistant
	 */
	CommunicationBus.publish = function (sChannelName, aParams) {
		var receivingWindow = this._getReceivingWindow(),
			dataObject = {
				channelName: sChannelName,
				params: aParams,
				_frameIdentifier: frameIdentifier,
				_origin: window.location.href
			};

		// TODO: we need to find a way to make sure we're executing on the
		// correct window. Issue happen in cases where we're too fast to
		// post messages to the iframe but it is not there yet
		receivingWindow.postMessage(dataObject, this.origin);
	};

	/**
	 * Clears all subscribed channels from the CommunicationBus
	 * @private
	 * @static
	 * @method
	 * @name sap.ui.support.WindowCommunicationBus.destroyChanels
	 * @memberof sap.ui.support.WindowCommunicationBus
	 */
	CommunicationBus.destroyChanels = function () {
		CommunicationBus.channels = {};
	};

	/**
	 * Retrieves the window hosting the SupportAssistant
	 * @private
	 * @static
	 * @method
	 * @name sap.ui.support.WindowCommunicationBus._getReceivingWindow
	 * @memberof sap.ui.support.WindowCommunicationBus
	 * @returns {object} Window containing the SupportAssistant
	 */
	CommunicationBus._getReceivingWindow = function () {

		if (window.communicationWindows && window.communicationWindows.hasOwnProperty("supportTool")) {
			return window.communicationWindows.supportTool;
		}

		// If opener is not null, tool's UI is in an IFRAME (parent is used),
		// else it's a POPUP WINDOW (opener is used)
		return window.opener || window.parent;
	};

	/**
	 * This is the message handler used for communication between the CommunicationBus and {@link sap.ui.support.WCBChannels}
	 * @private
	 * @static
	 * @method
	 * @name sap.ui.support.WindowCommunicationBus._onmessage
	 * @memberof sap.ui.support.WindowCommunicationBus
	 * @param {EventListener} evt Event fired by the channels attached to the CommunicationBus
	 */
	CommunicationBus._onmessage = function (eMessage) {
		// Validate received message
		var checkResults = CommunicationBus.onMessageChecks.every(function (fnMsgCheck) {
			return fnMsgCheck.call(null, eMessage);
		});

		if (!checkResults) {
			jQuery.sap.log.error("Message was received but failed validation");
			return;
		}

		var channelName = eMessage.data.channelName,
			params = eMessage.data.params,
			callbackObjects = CommunicationBus.channels[channelName];

		if (!callbackObjects) {
			return;
		}

		callbackObjects.forEach(function (cbObj) {
			cbObj.callback.apply(cbObj.context, [params]);
		});
	};

	if (window.addEventListener) {
		window.addEventListener("message", CommunicationBus._onmessage, false);
	} else {
		window.attachEvent("onmessage", CommunicationBus._onmessage);
	}

	// Dependent frames notify parent
	if (originParameter) {
		CommunicationBus.publish("COMM_BUS_INTERNAL", "READY");
	}

	return CommunicationBus;
}, true);

}; // end of sap/ui/support/supportRules/WindowCommunicationBus.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.AnalysisHistoryFormatter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Formats the analysis history in a single string.
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.AnalysisHistoryFormatter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/report/AnalysisHistoryFormatter",[], function() {
	"use strict";

    // Create a line with 196 "-"
    var _horizontalSeparator = Array(196).join("-"),
        _verticalSeparator = "|";

    function formatString(text, columnSize) {
        var formatted = "",
            text = text || "";

        // Set default.
        if (!columnSize) {
            columnSize = 50;
        }

        // Clear new line characters and double quotes to avoid bad formatting.
        formatted = text.replace(/(\r\n|\n|\r)/gm, " ").replace(/(\")/gm, "");

        if (formatted.length > columnSize) {
            formatted = formatted.substring(0, columnSize - 3) + "...";
        } else {
            while (formatted.length < columnSize) {
                formatted += " ";
            }
        }

        return formatted;
    }

    function formatRule(rule) {
        var text = _horizontalSeparator + "\n";
        // Use the first issue to get the rule properties.
        text += _verticalSeparator + formatString("rule id: " + rule[0].ruleId, 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("name: " + rule[0].name, 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("library: " + rule[0].ruleLibName, 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("categories: " + rule[0].categories.join(", "), 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("audiences: " + rule[0].audiences.join(", "), 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("description: " + rule[0].description, 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("resolution: " + rule[0].resolution, 193) + _verticalSeparator + "\n";
        text += _horizontalSeparator + "\n";
        text += _verticalSeparator + formatString("id", 50);
        text += _verticalSeparator + formatString("class name", 30);
        text += _verticalSeparator + formatString("status", 10);
        text += _verticalSeparator + formatString("details", 100);
        text += _verticalSeparator + "\n";
        text += _horizontalSeparator + "\n";

        for (var i = 0; i < rule.length; i++) {
            text += _verticalSeparator + formatString(rule[i].context.id, 50);
            text += _verticalSeparator + formatString(rule[i].context.className, 30);
            text += _verticalSeparator + formatString(rule[i].severity, 10);
            text += _verticalSeparator + formatString(rule[i].details, 100);
            text += _verticalSeparator + "\n";
        }

        text += _horizontalSeparator + "\n";

        return text;
    }

    function formatSingleRun(libraries) {
        var text = "";

        if (!libraries) {
            return text;
        }

        for (var lib in libraries) {
            for (var rule in libraries[lib]) {
                text += formatRule(libraries[lib][rule]);
            }

            text += "\n";
        }

        text += "\n";

        return text;
    }

    function format(analysisHistory) {
        var text = "";

        if (!analysisHistory) {
            return text;
        }

        for (var i = 0; i < analysisHistory.length; i++) {
            text += "\n";
            text += "Run " + (i + 1) + "\n";
            text += formatSingleRun(analysisHistory[i].issues);
            text += "\n";
        }

        return text;
    }

    return {
		format: format
	};
}, true);
}; // end of sap/ui/support/supportRules/report/AnalysisHistoryFormatter.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.Archiver') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Creates a zip file
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.Archiver'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.jszip'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.util.File'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/report/Archiver",['jquery.sap.global', 'sap/ui/thirdparty/jszip', 'sap/ui/core/util/File'],
	function (jQuery, JSZip, File) {
	"use strict";

	/**
	 * The Archiver collects files for zip download
	 */
	var Archiver = function() {
		this._mData = {};
	};

	/**
	 * Adds vData with the name to the data collection. sType json and has will use JSON.stringify
	 */
	Archiver.prototype.add = function(sName, vData, sType) {
		if (!sName) {
			jQuery.sap.log.error("Archiver: No name was given.");
			return false;
		}
		if (!vData) {
			jQuery.sap.log.error("Archiver: No data was given.");
			return false;
		}
		if (typeof vData === "string") {
			this._mData[sName] = vData;
			return true;
		} else if (sType) {
			if ((sType === "json" || sType === "har") && (jQuery.isPlainObject(vData) || jQuery.isArray(vData))) {
				try {
					this._mData[sName] = JSON.stringify(vData);
					return true;
				} catch (ex) {
					jQuery.sap.log.error("Archiver: JSON data could not be serialized for " + sName);
				}
			} else {
				jQuery.sap.log.error("Archiver: JSON data could not be serialized for " + sType + ". Either the type is unknown or the data has a wrong format.");
			}
		} else {
			jQuery.sap.log.error("Archiver: Data could not be serialized for " + sName + ". Data is is not a string or has a an invalid type.");
			return false;
		}
		return false;
	};

	/**
	 * Downloads a zip file
	 * @public
	 * @param {string} fileName the name of the zip file
	 */
	Archiver.prototype.download = function(fileName) {
		var oZip = new JSZip();

		if (oZip) {
			for (var n in this._mData) {
				oZip.file(n, this._mData[n]);
			}

			var oContent = oZip.generate({
				type : "blob"
			});

			File.save(oContent, fileName, "zip", "application/zip");
		}
	};

	Archiver.prototype.clear = function() {
		this._mData = {};
		return true;
	};

	Archiver.prototype.hasData = function(sName) {
		if (sName !== undefined) {
			return this._mData.hasOwnProperty(sName);
		}
		return Object.keys(this._mData).length > 0;
	};

	return Archiver;
}, true);

}; // end of sap/ui/support/supportRules/report/Archiver.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.DataCollector') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Provides methods for information retrieval from the core.
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.DataCollector'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.support.ToolsAPI'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.URI'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/report/DataCollector",['jquery.sap.global', 'sap/ui/core/support/ToolsAPI', 'sap/ui/thirdparty/URI'],
	function (jQuery, ToolsAPI, URI) {
	"use strict";

	/**
	 * The DataCollector collects information.
	 */
	var DataCollector = function(oCore) {
		this._oCore = oCore;

		// Set default
		this._oSupportAssistantInfo = {
			location: "",
			version: {},
			versionAsString: ""
		};
	};

	/**
	 * Setter for Support Assistant location
	 *
	 * @public
	 * @param {string} sLocation the location the Support Assistant is loaded from
	 */
	DataCollector.prototype.setSupportAssistantLocation = function (sLocation) {
		this._oSupportAssistantInfo.location = sLocation;
	};

	/**
	 * Setter for Support Assistant version
	 *
	 * @public
	 * @param {Object} oVersion version of the Support Assistant
	 */
	DataCollector.prototype.setSupportAssistantVersion = function (oVersion) {
		this._oSupportAssistantInfo.version = oVersion;
		this._oSupportAssistantInfo.versionAsString = "not available";

		if (oVersion) {
			this._oSupportAssistantInfo.versionAsString = jQuery.sap.escapeHTML(oVersion.version || "");
			this._oSupportAssistantInfo.versionAsString += " (built at " + jQuery.sap.escapeHTML(oVersion.buildTimestamp || "");
			this._oSupportAssistantInfo.versionAsString += ", last change " + jQuery.sap.escapeHTML(oVersion.scmRevision || "") + ")";
		}
	};

	/**
	 * Getter for Support Assistant information
	 *
	 * @public
	 * @returns {Object} Information about the Support Assistant
	 */
	DataCollector.prototype.getSupportAssistantInfo = function() {
		return this._oSupportAssistantInfo;
	};

	/**
	 * @returns {Array} All loaded manifest.json files.
	 */
	DataCollector.prototype.getAppInfo = function() {
		var appInfos = [];
		for (var componentName in this._oCore.mObjects.component) {
			var component = this._oCore.mObjects.component[componentName];
			var sapApp = component.getMetadata().getManifestEntry('sap.app');
			appInfos.push(sapApp);
		}
		return appInfos;
	};

	/**
	 * Retrieves all technical information. Reused from diagnostics tools.
	 * @returns {Object}
	 */
	DataCollector.prototype.getTechInfoJSON = function() {
		var oCfg = ToolsAPI.getFrameworkInformation();
		var oTechData = {
			sapUi5Version: null,
			version: oCfg.commonInformation.version,
			build: oCfg.commonInformation.buildTime,
			change: oCfg.commonInformation.lastChange,
			jquery: oCfg.commonInformation.jquery,
			useragent: oCfg.commonInformation.userAgent,
			docmode: oCfg.commonInformation.documentMode,
			debug: oCfg.commonInformation.debugMode,
			bootconfig: oCfg.configurationBootstrap,
			config:  oCfg.configurationComputed,
			libraries: oCfg.libraries,
			loadedLibraries: oCfg.loadedLibraries,
			modules: oCfg.loadedModules,
			uriparams: oCfg.URLParameters,
			appurl: oCfg.commonInformation.applicationHREF,
			title: oCfg.commonInformation.documentTitle,
			statistics: oCfg.commonInformation.statistics,
			resourcePaths: [],
			themePaths : [],
			locationsearch: document.location.search,
			locationhash: document.location.hash,
			supportAssistant: this._oSupportAssistantInfo
		};

		//add absolute paths for resources
		var aModules = jQuery.sap.getAllDeclaredModules();
		var aResults = [];
		for (var i = 0; i < aModules.length; i++) {
			aResults.push({
				moduleName : aModules[i],
				relativePath: jQuery.sap.getResourcePath(aModules[i]),
				absolutePath: URI(jQuery.sap.getResourcePath(aModules[i])).absoluteTo(document.location.origin + document.location.pathname).toString()
			});
		}
		oTechData.resourcePaths = aResults;

		//add theme paths
		var mLibraries = this._oCore.getLoadedLibraries();
		aResults = [];
		for (var n in mLibraries) {
			var sPath = this._oCore._getThemePath(n, this._oCore.oConfiguration.theme);
			aResults.push({
				theme : this._oCore.oConfiguration.theme,
				library: n,
				relativePath: sPath,
				absolutePath: URI(sPath).absoluteTo(document.location.origin + document.location.pathname).toString()
			});
		}
		oTechData.themePaths = aResults;

		//add SAPUI5 version object
		try {
			oTechData.sapUi5Version = {
				version: sap.ui.getVersionInfo(),
				path: sap.ui.resource("", "sap-ui-version.json")
			};
		} catch (ex) {
			oTechData.sapUi5Version = null;
		}

		return oTechData;
	};

	return DataCollector;
}, true);

}; // end of sap/ui/support/supportRules/report/DataCollector.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.IssueRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Renders issues
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.IssueRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/report/IssueRenderer",['jquery.sap.global'], function(jQuery) {
	'use strict';

	var _OPARenderingInitialized = false;

	function getEscapedString(value) {
		if (value) {
			if (jQuery.isArray(value)) {
				return jQuery.sap.escapeHTML(value.join(', '));
			} else {
				return jQuery.sap.escapeHTML(value);
			}
		} else {
			return '';
		}
	}

	function renderGroup(groupName, ruleGroup, groupId, groupNumber) {
		var content = '';
		var container = '';
		var ruleNumber = 1;
		var totalIssues = 0;

		for (var group in ruleGroup) {
			var issues = ruleGroup[group];
			totalIssues += issues.length;
			var issue = issues[0]; // Get the first issue from this rule group and add all common information.
			container += '<tr id="' + groupId + '_rule_' + ruleNumber + '" >';
			container += '<td>';
			container += '<div class="expandable-control collapsed-content" data-expandableElement="' + groupId + '_rule_' + ruleNumber + '_content">';
			container += '<div class="expandable-title"> ' + ruleNumber + '. ' + getEscapedString(issue.name) + ' <span class="rule-issue-number">(' + issues.length + ' issues)</span></div></div>';
			container += '<div id="' + groupId + '_rule_' + ruleNumber + '_content">';
			container += '<div><span class="sapUiSupportLabel">Description: </span>' + getEscapedString(issue.description) + '</div>';
			container += '<div><span class="sapUiSupportLabel">Min version: </span>' + getEscapedString(issue.minVersion) + '</div>';
			container += '<div><span class="sapUiSupportLabel">Async: </span>' + getEscapedString(issue.async.toString()) + '</div>';
			container += '<div><span class="sapUiSupportLabel">Resolution: </span>' + getEscapedString(issue.resolution) + '</div>';
			container += '<div>';
			if (issue.resolutionUrls) {
				for (var k = 0; k < issue.resolutionUrls.length; k++) {
					container += '<div><a href="' + getEscapedString(issue.resolutionUrls[k].href) + '" target="_blank">' + getEscapedString(issue.resolutionUrls[k].text) + '</a></div>';
				}
			}
			container += '</div>';
			container += '<table class="sapUiTable"><tr><th></th><th>Element Id</th><th>Class</th><th>Status</th><th>Details</th></tr>';
			for (var i = 0; i < issues.length; i++) {
				container += '<tr class="filterable" data-severity="' + getEscapedString(issues[i].severity) + '"><td>' + (i + 1) + '</td><td>' + getEscapedString(issues[i].context.id) + '</td>';
				container += '<td>' + getEscapedString(issues[i].context.className) + '</td>';
				container += '<td class="' + getEscapedString(issues[i].severity) + '">' + getEscapedString(issues[i].severity) + '</td>';
				container += '<td>' + getEscapedString(issues[i].details) + '</td></tr>';
			}
			container += '</table>';
			container += '</div></td>';
			container += '<td>' + getEscapedString(issue.categories) + '</td>';
			container += '<td>' + getEscapedString(issue.audiences) + '</td>';
			container += '</tr>';

			ruleNumber++;
		}

		// Make the first group expanded.
		var expandedClass = 'collapsed-content';
		if (groupNumber === 1) {
			expandedClass = 'expanded-content';
		}

		content += '<tr>';
		content += '<td colspan="100" class="expandable-control ' + expandedClass + '" data-expandableElement="' + groupId + '" data-groupName="' + groupName + '" data-groupNumber="' + groupNumber + '">';
		content += '<span class="sapUiSupportLabel expandable-title"> ' + groupNumber + '. ' + groupName + ' (' + (ruleNumber - 1) + ' rules, ' + totalIssues + ' issues)</span>';
		content += '</td></tr><tbody id="' + groupId + '">';
		content += container;
		content += '</tbody>';

		return content;
	}

	function getIssues(groups) {
		var content = '';
		var groupNumber = 1;

		if (!groups) {
			return content;
		}

		try {
			content += '<table class="sapUiTable"><tr><th>Title</th><th>Categories</th><th>Audiences</th></tr>';

			for (var group in groups) {
				content += renderGroup(group, groups[group], 'group' + groupNumber, groupNumber);
				groupNumber++;
			}

			content += '</table>';
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting issues info.');
			content = '';
		}

		return content;
	}

	function getSeverityFilter(severity, count, isActive) {
		if (!count) {
			return '';
		}

		var activeClass = isActive ? 'filter-active' : '';
		return '<div data-severity="' + severity + '" class="filter ' + activeClass + ' ' + severity + '">' + severity + '(' + count + ')</div>' + ' | ';
	}

	function getSeverityFilters(groups) {
		var content = '',
			severities = {},
			severityProperty,
			i,
			total = 0,
			issues = [],
			rules = {},
			rule = {},
			group = {};

		if (!groups) {
			return content;
		}

		try {
			for (group in groups) {
				rules = groups[group];
				for (rule in rules) {
					issues = rules[rule];
					for (i = 0; i < issues.length; i++) {
						severityProperty = issues[i].severity;
						if (severities[severityProperty]) {
							severities[severityProperty]++;
						} else {
							severities[severityProperty] = 1;
						}
						total++;
					}
				}
			}
			content += getSeverityFilter('Total', total, true);
			content += getSeverityFilter('High', severities['High'], false);
			content += getSeverityFilter('Medium', severities['Medium'], false);
			content += getSeverityFilter('Low', severities['Low'], false);
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem creating severity filters.');
			content = '';
		}

		return content;
	}

	// Public functions

	/**
	 * Creates an html string containing the issues.
	 * @param {Object} issues - the issues in viewmodel format
	 * @param {Boolean} enableFiltering - if true renders the severity filters
	 * @returns {String}
	 */
	function render(issues, enableFiltering) {
		var content = '';

		if (enableFiltering) {
			content += '<div class="filters">' + getSeverityFilters(issues) + '<div>\n';
		}

		content += '<div>' + getIssues(issues) + '</div>';

		return '<div>' + content + '</div>';
	}

	/* eslint-disable no-undef */
	/**
	 * Creates an html string containing the issues and appends it to the OPA html page
	 * @param {Object} issues - the issues in viewmodel format
	 * @returns {String}
	 */
	function renderIssuesForOPA(issues) {
		if (!jQuery("#qunit") || !issues) {
			return;
		}

		// TODO: Add rendered issues to a buffer and render all of them at the same time at the end of the OPA test.
		var element = jQuery(this.render(issues));
		jQuery("#qunit").append(element);

		if (!_OPARenderingInitialized) {
			var styles = [
				jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/styles.css'),
				jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/collapseExpand.css'),
				jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/filter.css')
			];
			var collapseExpandUrl = jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/collapseExpand.js');
			var filterUrl = jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/filter.js');

			jQuery.each(styles, function (index, value) {
				jQuery('<link>').appendTo('head').attr({ type: 'text/css', rel: 'stylesheet', href: value });
			});
			jQuery.getScript(collapseExpandUrl, function () {
				window.sapUiSupportReport.collapseExpand.init();
			});
			jQuery.getScript(filterUrl, function () {
				window.sapUiSupportReport.filter.init();
			});
			_OPARenderingInitialized = true;
		} else {
			window.sapUiSupportReport.collapseExpand.init();
			window.sapUiSupportReport.filter.init();
		}
	}
	/* eslint-enable no-undef */

	return {
		render: render,
		renderIssuesForOPA: renderIssuesForOPA
	};
}, true);
}; // end of sap/ui/support/supportRules/report/IssueRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.ReportProvider') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Creates a report from data.
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.ReportProvider'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.handlebars'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/report/ReportProvider",['jquery.sap.global', 'sap/ui/thirdparty/handlebars', 'sap/ui/support/supportRules/report/Archiver',
	'sap/ui/support/supportRules/report/IssueRenderer'], function(jQuery, Handlebars, Archiver, IssueRenderer) {
	'use strict';

	// Private fields
	var resourcesBaseUrl = jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources');
	var resources = [
		{ url: resourcesBaseUrl + '/ReportTemplate.html', type: 'template' },
		{ url: resourcesBaseUrl + '/styles.css', type: 'css' },
		{ url: resourcesBaseUrl + '/filter.css', type: 'css' },
		{ url: resourcesBaseUrl + '/collapseExpand.css', type: 'css' },
		{ url: resourcesBaseUrl + '/filter.js', type: 'js' },
		{ url: resourcesBaseUrl + '/collapseExpand.js', type: 'js' }
	];

	/*
	 * Functions taken from core.support.plugins.TechInfo.js
	 */
	var techInfoRenderer = {
		line: function (buffer, right, border, label, content) {
			buffer.push("<tr><td ", right ? "align='right' " : "", "valign='top'>", "<label class='sapUiSupportLabel'>", jQuery.sap.escapeHTML(label || ""), "</label></td><td",
					border ? " class='sapUiSupportTechInfoBorder'" : "", ">");
			var ctnt = content;
			if (jQuery.isFunction(content)) {
				ctnt = content(buffer);
			}
			buffer.push(jQuery.sap.escapeHTML(ctnt || ""));
			buffer.push("</td></tr>");
		},
		multiline: function (buffer, right, border, label, content){
			var that = this;
			that.line(buffer, right, border, label, function(buffer){
				buffer.push("<table border='0' cellspacing='0' cellpadding='3'>");
				jQuery.each(content, function(i,v){
					var val = "";
					if (v) {
						if (typeof (v) === "string" || typeof (v) === "string" || typeof (v) === "boolean") {
							val = v;
						} else if ((jQuery.isArray(v) || jQuery.isPlainObject(v)) && window.JSON) {
							val = window.JSON.stringify(v);
						}
					}
					that.line(buffer, false, false, i, "" + val);
				});
				buffer.push("</table>");
			});
		},
		subheader: function (buffer, title) {
			buffer.push("<tr class='sapUiSupportTitle'><td valign='top' colspan='2'>", "<label class='sapUiSupportLabel'>",
				jQuery.sap.escapeHTML(title || ""), "</label></td></tr>");
		}
	};

	function getResource(resource) {
		return jQuery.ajax({
			type: 'GET',
			url: resource.url,
			dataType: 'text'
		}).then(function (text) {
			return { content: text, type: resource.type };
		});
	}

	function getResources() {
		var deferreds = [];
		for (var i = 0; i < resources.length; i++) {
			deferreds.push(getResource(resources[i]));
		}
		return jQuery.when.apply(jQuery, deferreds);
	}

	/*
	 * Modified version of the function onsapUiSupportTechInfoData from core.support.plugins.TechInfo.js
	 */
	function getTechnicalInformation(technicalInfo) {
		var content = '';

		if (!technicalInfo) {
			return new Handlebars.SafeString(content);
		}

		try {
			technicalInfo.modules.sort();
			var html = ["<div class='sapUiSupportToolbar'>",
						"<div><div class='sapUiSupportTechInfoCntnt'>",
						"<table border='0' cellpadding='3'>"];
			techInfoRenderer.subheader(html, "Support Assistant Information");
			techInfoRenderer.line(html, true, true, "Location", technicalInfo.supportAssistant.location);
			techInfoRenderer.line(html, true, true, "Version", technicalInfo.supportAssistant.versionAsString);
			techInfoRenderer.subheader(html, "Application Information");
			techInfoRenderer.line(html, true, true, "SAPUI5 Version", function(buffer){
				var sapUI5Version = technicalInfo.sapUi5Version;
				if (sapUI5Version && sapUI5Version.version) {
					var oVersionInfo = sapUI5Version.version;
					var sVersion = jQuery.sap.escapeHTML(oVersionInfo.version || "");
					buffer.push(sVersion, " (built at ", jQuery.sap.escapeHTML(oVersionInfo.buildTimestamp || ""), ", last change ", jQuery.sap.escapeHTML(oVersionInfo.scmRevision || ""), ")");
				} else {
					buffer.push("not available");
				}
			});
			techInfoRenderer.line(html, true, true, "Core Version", function(buffer){
				return technicalInfo.version + " (built at " + technicalInfo.build + ", last change " + technicalInfo.change + ")";
			});
			techInfoRenderer.line(html, true, true, "Loaded jQuery Version", function(buffer){
				return technicalInfo.jquery;
			});
			techInfoRenderer.line(html, true, true, "User Agent", function(buffer){
				return technicalInfo.useragent + (technicalInfo.docmode ? ", Document Mode '" + technicalInfo.docmode + "'" : "");
			});
			techInfoRenderer.line(html, true, true, "Application", technicalInfo.appurl);
			techInfoRenderer.multiline(html, true, true, "Configuration (bootstrap)", technicalInfo.bootconfig);
			techInfoRenderer.multiline(html, true, true, "Configuration (computed)", technicalInfo.config);
			if (!jQuery.isEmptyObject(technicalInfo.libraries)) {
				techInfoRenderer.multiline(html, true, true, "Libraries", technicalInfo.libraries);
			}
			techInfoRenderer.multiline(html, true, true, "Loaded Libraries", technicalInfo.loadedLibraries);
			techInfoRenderer.line(html, true, true, "Loaded Modules", function(buffer){
				jQuery.each(technicalInfo.modules, function(i,v){
					if (v.indexOf("sap.ui.core.support") < 0) {
						buffer.push("<span>", jQuery.sap.escapeHTML(v || ""), "</span>");
						if (i < technicalInfo.modules.length - 1) {
							buffer.push(", ");
						}
					}
				});
			});
			techInfoRenderer.multiline(html, true, true, "URI Parameters", technicalInfo.uriparams);

			html.push("</table></div>");
			content = html.join('');
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting technical info.');
		}

		return new Handlebars.SafeString(content);
	}

	function getComponentPart(value) {
		var result = '<td>';
		if (value) {
			result += jQuery.sap.escapeHTML(value);
		}
		result += '</td>';
		return result;
	}

	function getAppInfo(appInfo) {
		var content = '';

		if (!appInfo) {
			return new Handlebars.SafeString(content);
		}

		content += '<table class="sapUiTable"><tr><th>Component ID</th><th>Type</th><th>Title</th><th>Subtitle</th><th>Application version</th><th>Description</th><th>BCP Component</th></tr>';

		try {
			for (var i = 0; i < appInfo.length; i++) {
				var component = appInfo[i];
				content += '<tr>';
				content += getComponentPart(component.id);
				content += getComponentPart(component.type);
				content += getComponentPart(component.title);
				content += getComponentPart(component.subTitle);
				if (component.applicationVersion) {
					content += getComponentPart(component.applicationVersion.version);
				} else {
					content += '<td></td>';
				}
				content += getComponentPart(component.description);
				content += getComponentPart(component.ach);
				content += '</tr>';
			}

			content += '</table>';
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting app info.');
			content = '';
		}

		return new Handlebars.SafeString(content);
	}

	function getGlobalScope(displaySettings) {
		var content = '';
		content += '<div><span class="sapUiSupportLabel">' + displaySettings.displayName + '</span>';
		content += '<span> (' + displaySettings.description + ')</span></div>';
		return content;
	}

	function getSubtreeScope(parentId, displaySettings) {
		var content = '';
		content += '<div><span class="sapUiSupportLabel">' + displaySettings.displayName + ' with id:</span> ' + parentId;
		content += '<span> (' + displaySettings.description + ')</span></div>';
		return content;
	}

	function getComponentsScope(components, displaySettings) {
		var content = '';
		// Make components collapsable if they are too many.
		if (components.length > 5) {
			content += '<div class="expandable-control collapsed-content" data-expandableElement="execution-scope-components">';
			content += '<span class="expandable-title"><span class="sapUiSupportLabel">' + displaySettings.displayName + '</span>';
			content += '<span> (' + displaySettings.description + ')</span></span></div>';
		} else {
			content += '<div><span class="sapUiSupportLabel">' + displaySettings.displayName + '</span>';
			content += '<span> (' + displaySettings.description + ')</span></div>';
		}

		content += '<ol id="execution-scope-components" class="top-margin-xsmall">';
		for (var i = 0; i < components.length; i++) {
			content += '<li>' + components[i] + '</li>';
		}
		content += '</ol>';

		return content;
	}

	function getScope(scope) {
		var content = '';

		try {
			var scopeType = scope.executionScope._getType();
			var scopeDisplaySettings = scope.scopeDisplaySettings.executionScopes[scopeType];
			var scopeDisplayTitle = scope.scopeDisplaySettings.executionScopeTitle;
			content += '<div class="sapUiSupportLabel">' + scopeDisplayTitle + ': </div>';

			switch (scopeType) {
				case 'global':
					content += getGlobalScope(scopeDisplaySettings);
					break;
				case 'subtree':
					content += getSubtreeScope(scope.executionScope._getContext().parentId, scopeDisplaySettings);
					break;
				case 'components':
					content += getComponentsScope(scope.executionScope._getContext().components, scopeDisplaySettings);
					break;
			}
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting scope info.');
			content = '';
		}

		return new Handlebars.SafeString(content);
	}

	function getRules(groups) {
		var content = '';

		if (!groups) {
			return new Handlebars.SafeString(content);
		}

		try {
			var groupNumber = 1;

			content += '<table class="sapUiTable"><tbody><tr><th>Name</th><th>Description</th></tr></tbody>';

			for (var group in groups) {
				var rules = groups[group];

				// Make the first group expanded.
				var expandedClass = 'collapsed-content';
				if (groupNumber === 1) {
					expandedClass = 'expanded-content';
				}

				var groupIssueCountElement = groups[group].selected ? ' (' + groups[group].issueCount + ' issues)' : '';
				var checkedGroup = '<span class="checked" style="' + (groups[group].selected ? '' : 'visibility: hidden;') + '"> &#10004; </span>';
				content += '<tbody><tr><td colspan="100" ';
				content += 'class="expandable-control ' + expandedClass + '" data-expandableElement="section-selected-rules-group' + groupNumber + '">' + checkedGroup;
				content += '<span class="sapUiSupportLabel expandable-title"> ' + group + groupIssueCountElement + '</span>';
				content += '</td></tr></tbody>';
				var rulesTable = '';

				for (var rule in rules) {
					var issueCountElement = rules[rule].selected ? ' (' + rules[rule].issueCount + ' issues)' : '';
					var checked = '<span class="checked" style="' + (rules[rule].selected ? '' : 'visibility: hidden;') + '"> &#10004; </span>';
					rulesTable += '<tr><td>' + checked + rules[rule].title + issueCountElement + '</td><td>' + rules[rule].description + '</td></tr>';
				}

				content += '<tbody id="section-selected-rules-group' + groupNumber + '">' + rulesTable + '</tbody>';
				groupNumber++;
			}

			content += '</table>';
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting selected rules info.');
			content = '';
		}

		return new Handlebars.SafeString(content);
	}

	function getResourcesHtml(resources, type) {
		var content = '';

		if (type !== 'script' && type !== 'style') {
			return content;
		}

		for (var i = 0; i < resources.length; i++) {
			switch (type) {
				case 'script': content += '<script>' + resources[i] + '</script>\n'; break;
				case 'style': content += '<style type="text/css">' + resources[i] + '</style>\n'; break;
			}
		}

		return new Handlebars.SafeString(content);
	}

	Handlebars.registerHelper('getTechnicalInformation', function (technicalInfo) {
		return getTechnicalInformation(technicalInfo);
	});
	Handlebars.registerHelper('getRules', function (rules) {
		return getRules(rules);
	});
	Handlebars.registerHelper('getIssues', function (issues) {
		return new Handlebars.SafeString(IssueRenderer.render(issues, true));
	});
	Handlebars.registerHelper('getAppInfo', function (appInfo) {
		return getAppInfo(appInfo);
	});
	Handlebars.registerHelper('getScope', function (scope) {
		return getScope(scope);
	});
	Handlebars.registerHelper('getScripts', function (scripts) {
		return getResourcesHtml(scripts, 'script');
	});
	Handlebars.registerHelper('getStyles', function (styles) {
		return getResourcesHtml(styles, 'style');
	});

	// Public functions

	/**
	 * Creates an html string containing the whole report.
	 * @param {Object} oData - the data required to create a report
	 * @returns {String}
	 */
	function getReportHtml(oData) {
		return getResources().then(function () {
			var styles = [],
				scripts = [],
				html = '',
				i,
				template = {},
				reportContext = {};

			for (i = 0; i < arguments.length; i++) {
				switch (arguments[i].type) {
					case 'template': html = arguments[i].content; break;
					case 'css': styles.push(arguments[i].content); break;
					case 'js': scripts.push(arguments[i].content); break;
				}
			}

			template = Handlebars.compile(html);

			reportContext = {
				technicalInfo: oData.technical,
				issues: oData.issues,
				appInfo: oData.application,
				rules: oData.rules,
				metadata: {
					title: oData.name + ' Analysis Results',
					title_TechnicalInfo: 'Technical Information',
					title_Issues: 'Issues',
					title_AppInfo: 'Application Information',
					title_SelectedRules: 'Available and (<span class="checked">&#10004;</span>) Executed Rules',
					timestamp: new Date(),
					scope: oData.scope,
					analysisDuration: oData.analysisDuration,
					analysisDurationTitle: oData.analysisDurationTitle,
					styles: styles,
					scripts: scripts
				}
			};

			return template(reportContext);
		});
	}

	/**
	 * Creates a zip file containing the report.html, appInfo.json, technicalInfo.json, issues.json.
	 * @param {Object} oData - the data required to create a report
	 */
	function downloadReportZip(oData) {
		this.getReportHtml(oData).done(function (html) {
			var report = '<!DOCTYPE HTML><html><head><title>Report</title></head><body><div id="sap-report-content">' + html + '</div></body></html>';
			var issues = { 'issues': oData.issues };
			var appInfos = { 'appInfos': oData.application };
			var technicalInfo = { 'technicalInfo': oData.technical };
			var archiver = new Archiver();
			archiver.add('technicalInfo.json', technicalInfo, 'json');
			archiver.add('issues.json', issues, 'json');
			archiver.add('appInfos.json', appInfos, 'json');
			archiver.add('report.html', report);
			archiver.download("SupportAssistantReport");
			archiver.clear();
		});
	}

	/**
	 * Opens a report in a new window.
	 * @param {Object} oData - the data required to create a report
	 */
	function openReport(oData) {
		// Create a hidden anchor. Open window outside of the promise otherwise browsers blocks the window.open.
		var content = '';
		var a = jQuery('<a style="display: none;"/>');
		a.on('click', function () {
			var reportWindow = window.open('', '_blank');
			jQuery(reportWindow.document).ready(function () {
				// Sometimes document.write overwrites the document html and sometimes it appends to it so we need a wrapper div.
				if (reportWindow.document.getElementById('sap-report-content')) {
					reportWindow.document.getElementById('sap-report-content').innerHtml = content;
				} else {
					reportWindow.document.write('<div id="sap-report-content">' + content + '</div>');
				}
				reportWindow.document.title = 'Report';
			});
		});
		jQuery('body').append(a);

		this.getReportHtml(oData).then(function (html) {
			content = html;
			a[0].click();
			a.remove();
		});
	}

	return {
		getReportHtml: getReportHtml,
		downloadReportZip: downloadReportZip,
		openReport: openReport
	};
}, true);

}; // end of sap/ui/support/supportRules/report/ReportProvider.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.IFrameController') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.IFrameController'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/IFrameController",[
	"jquery.sap.global",
	"sap/ui/base/ManagedObject",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/WCBChannels",
	"sap/ui/support/supportRules/Constants"
],
function (jQuery, ManagedObject, CommunicationBus, channelNames, constants) {
	"use strict";

	var oIFrameController = null;

	var sFrameOrigin;

	var sFrameIdentifier;

	var sFrameUrl;

	function computeFrameOrigin(sUrl) {
		var frameURI = new window.URI(sUrl);
		var sOrigin = ( frameURI.protocol() || window.location.protocol.replace(':', '') ) +
						'://' +
						( frameURI.host() || window.location.host );

		return sOrigin;
	}

	function generateIdentifier() {
		return '' + +new Date();
	}

	function openFrame(sUrl) {
		var toolFrame = document.createElement("IFRAME");
		var style = toolFrame.style;

		toolFrame.id = "sap-ui-supportToolsFrame";
		toolFrame.src = sUrl;

		style.width = "100%";
		style.height = "28px";
		style.position = "absolute";
		style.left = "0";
		style.bottom = "0";
		style.border = "none";
		style.zIndex = "1001";
		// style.transition = "width 300ms ease-in-out, height 300ms ease-in-out";
		style.boxShadow = "1px -10px 42px -4px #888";

		document.body.appendChild(toolFrame);

		// This interval is needed because sometimes an app is placed at
		// the body element which involves moving everything already there
		// into a new, hidden DIV element
		setInterval(function () {
			if (toolFrame.parentNode.nodeName !== "BODY") {
				document.body.appendChild(toolFrame);
				window.communicationWindows.supportTool = toolFrame.contentWindow;
			}
		}, 1000);

		window.communicationWindows.supportTool = toolFrame.contentWindow;
	}

	function openWindow(sUrl) {
		window.communicationWindows.supportTool = window.open(
			sUrl,
			"sapUiSupportTool",
			"width=1024,height=400,status=no,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,scrollbars=no"
		);

		window.communicationWindows.supportTool.window.onload = function () {
			window.communicationWindows.supportTool.document.title = constants.SUPPORT_ASSISTANT_NAME;
		};
	}

	var IFrameController = ManagedObject.extend("sap.ui.support.IFrameController", {
		constructor: function () {
			if (!oIFrameController) {
				ManagedObject.apply(this, arguments);
			} else {
				jQuery.sap.log.warning("Only one support tool allowed");
				return oIFrameController;
			}
		}
	});

	IFrameController.prototype._setCommunicationSubscriptions = function () {
		CommunicationBus.subscribe(channelNames.ENSURE_FRAME_OPENED, function () {
			if (document.getElementById("sap-ui-supportToolsFrame").style.height === "28px") {
				this.resizeFrame(true);
				this.toggleHide();
			}
		}, this);

		CommunicationBus.subscribe(channelNames.RESIZE_FRAME, function (aParams) {
			oIFrameController.resizeFrame(aParams.bigger);
		});
	};

	IFrameController.prototype.injectFrame = function (supportModeConfig) {
		sFrameIdentifier = generateIdentifier();

		sFrameUrl = jQuery.sap.getModulePath("sap.ui.support.supportRules.ui",
			"/overlay.html?sap-ui-xx-formfactor=compact&sap-ui-xx-support-origin=" +
			window.location.protocol + "//" + window.location.host + "&" +
			"sap-ui-xx-frame-identifier=" + sFrameIdentifier);

		sFrameOrigin = computeFrameOrigin(sFrameUrl);

		window.communicationWindows = window.communicationWindows || {};

		if (supportModeConfig.indexOf("window") > -1) {
			openWindow(sFrameUrl);
		} else {
			openFrame(sFrameUrl);
			this._setCommunicationSubscriptions();
		}
	};

	IFrameController.prototype.resizeFrame = function (bigger) {
		var toolFrameStyle = document.getElementById("sap-ui-supportToolsFrame").style;

		if (bigger) {
			if (toolFrameStyle.height === "50%") {
				toolFrameStyle.height = "100%";
			} else if (toolFrameStyle.height === "28px") {
				toolFrameStyle.height = "50%";
			}
		} else {
			if (toolFrameStyle.height === "100%") {
				toolFrameStyle.height = "50%";
			} else if (toolFrameStyle.height === "50%") {
				toolFrameStyle.height = "28px";
			}
		}
	};

	/**
	 * Toggles frame state between hidden and shown
	 * Default is shown
	 *
	 * @param {boolean} hidden should the frame hide or not
	 */
	IFrameController.prototype.toggleHide = function (hidden) {
		var toolFrameStyle = document.getElementById("sap-ui-supportToolsFrame").style;

		if (hidden) {
			this._originalSize = {
				width: toolFrameStyle.width,
				height: toolFrameStyle.height
			};

			toolFrameStyle.width = "170px";
			toolFrameStyle.height = "28px";
		} else {
			if (this._originalSize) {
				toolFrameStyle.width = this._originalSize.width;
				toolFrameStyle.height = this._originalSize.height;
				this._originalSize = null;
			}
		}
	};

	IFrameController.prototype._stop = function () {
		this._oCssLink.parentNode.removeChild(this._oCssLink);
		this._oDomRef.parentNode.removeChild(this._oCssLink);
		this._oCore = null;
	};

	IFrameController.prototype.getFrameOrigin = function () {
		return sFrameOrigin;
	};

	IFrameController.prototype.getFrameIdentifier = function () {
		return sFrameIdentifier;
	};

	IFrameController.prototype.getFrameUrl = function () {
		return sFrameUrl;
	};

	oIFrameController = new IFrameController();

	return oIFrameController;

}, true);

}; // end of sap/ui/support/supportRules/ui/IFrameController.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.external.ElementTree') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.external.ElementTree'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/external/ElementTree",["jquery.sap.global", "sap/ui/base/ManagedObject"],
	function (jQuery, ManagedObject) {
		"use strict";

		function _isObject(data) {
			return (typeof data === "object" && !Array.isArray(data) && data !== null);
		}

		/**
		 * @param {ElementTreeRenderingOptions} options
		 * @returns {string}
		 * @private
		 */
		function _startElementTreeList(options) {

			return "<ul " + options.attributes.join(" ") + ">";
		}

		/**
		 * @returns {string}
		 * @private
		 */
		function _endElementTreeList() {
			return "</ul>";
		}

		/**
		 * @param {ElementTreeRenderingOptions.controls} options
		 * @returns {string}
		 * @private
		 */
		function _startElementTreeListItem(options, hasIssue) {
			var html = "<li data-id=\"" + options.id + "\" ";
			if (hasIssue) {
				html += "issue";
			}
			html += ">";
			return html;
		}

		/**
		 * @returns {string}
		 * @private
		 */
		function _endElementTreeListItem() {
			return "</li>";
		}

		/**
		 * Create HTML for the left part of the ElementTree list item.
		 * @param {ElementTreeOptions.controls} controls
		 * @param {number} paddingLeft
		 * @returns {string}
		 * @private
		 */
		function _getElementTreeLeftColumnOfListItem(controls, paddingLeft) {
			var html = "<offset style=\"padding-left:" + paddingLeft + "px\" >";

			if (controls.content.length > 0) {
				html += "<arrow down=\"true\"></arrow>";
			} else {
				html += "<place-holder></place-holder>";
			}

			html += "</offset>";

			return html;
		}

		/**
		 * Create HTML for the right part of the ElementTree list item.
		 * @param {Object} control - JSON object form {ElementTreeOptions.controls}
		 * @returns {string}
		 * @private
		 */
		function _getElementTreeRightColumnOfListItem(control, numberOfIssues) {
			var splitControlName = control.name.split(".");
			var name = splitControlName[splitControlName.length - 1];
			var nameSpace = control.name.replace(name, "");
			var hideShowClass = (numberOfIssues > 0) ? "showNumbOfIssues" : "hideNumbOfIssues";

			return "<tag data-search=\"" + control.name + control.id + "\">" +
				"&#60;" +
				"<namespace>" + nameSpace + "</namespace>" +
				name +
				"<attribute>&#32;id=\"<attribute-value>" + control.id + "</attribute-value>\"</attribute>" +
				"&#62;" +
				"</tag>" + "<span class = " + hideShowClass  + ">[" + numberOfIssues + "  issue(s)] </span>";
		}

		/**
		 * Search for the nearest parent Node.
		 * @param {element} element - HTML DOM element that will be the root of the search
		 * @param {string} parentNodeName - The desired HTML parent element nodeName
		 * @returns {Object} HTML DOM element
		 * @private
		 */
		function _findNearestDOMParent(element, parentNodeName) {
			while (element.nodeName !== parentNodeName) {
				if (element.nodeName === "CONTROL-TREE") {
					break;
				}
				element = element.parentNode;
			}

			return element;
		}

		/**
		 * ElementTree constructor.
		 * @param {string} id - The id of the DOM container
		 * @param {ElementTree} instantiationOptions
		 * @constructor
		 */
		function ElementTree(id, instantiationOptions) {
			var areInstantiationOptionsAnObject = _isObject(instantiationOptions);
			var options;

			/**
			 * Make sure that the options parameter is Object and
			 * that the ElementTree can be instantiate without initial options.
			 */
			if (areInstantiationOptionsAnObject) {
				options = instantiationOptions;
			} else {
				options = {};
			}

			// Save DOM reference
			this._ElementTreeContainer = document.getElementById(id);

			/**
			 * Method fired when the number of issues against an element is clicked
			 */
			this.onIssueCountClicked = options.onIssueCountClicked ? options.onIssueCountClicked : function () {};

			/**
			 * Method fired when the selected element in the ElementTree is changed.
			 * @param {string} selectedElementId - The selected element id
			 */
			this.onSelectionChanged = options.onSelectionChanged ? options.onSelectionChanged : function (selectedElementId) {};

			/**
			 * Method fired when the hovered element in the ElementTree is changed.
			 * @param {string} hoveredElementId - The hovered element id
			 */
			this.onHoverChanged = options.onHoverChanged ? options.onHoverChanged : function (hoveredElementId) {};

			/**
			 * Method fired when the mouse is out of the ElementTree.
			 */
			this.onMouseOut = options.onMouseOut ? options.onMouseOut : function () {};

			/**
			 * Method fired when the initial ElementTree rendering is done.
			 */
			this.onInitialRendering = options.onInitialRendering ? options.onInitialRendering : function () {};

			// Object with the tree model that will be visualized
			this.setData(options.data);
		}

		/**
		 * Initialize Tree.
		 */
		ElementTree.prototype.init = function () {
			if (!this._ElementTreeContainer) {
				return;
			}

			this._createHTML();
			this._createHandlers();

			// Fire event to notify that the ElementTree is initialized
			this.onInitialRendering();
		};

		/**
		 * Get the data model used for the tree.
		 * @returns {ElementTreeOptions} the data that is used for the tree
		 */
		ElementTree.prototype.getData = function () {
			return this._data;
		};

		/**
		 * Set the data model used for the tree.
		 * @param {ElementTreeOptions} data
		 * @returns {ElementTree}
		 */
		ElementTree.prototype.setData = function (data) {
			var oldData = this.getData();
			var isDataAnObject = _isObject(data);

			if (isDataAnObject === false) {
				jQuery.sap.log.warning("The parameter should be an Object");
				return;
			}

			// Make sure that the new data is different from the old one
			if (JSON.stringify(oldData) === JSON.stringify(data)) {
				return;
			}

			this._data = data;

			// Initialize ElementTree on first rendering
			// If it is a second rendering, render only the tree elements
			if (this._isFirstRendering === undefined) {
				this.init();
				this._isFirstRendering = true;
			} else {
				this._createTree();
			}

			return this;
		};

		ElementTree.prototype.setContainerId = function (id) {
			this._ElementTreeContainer = document.getElementById(id);
			this.init();
		};

		/**
		 * Returns the selected <li> element of the tree.
		 * @returns {Element} HTML DOM element
		 */
		ElementTree.prototype.getSelectedElement = function () {
			return this._selectedElement;
		};

		/**
		 * Set the selected <li> element of the tree.
		 * @param {string} elementID - HTML DOM element id
		 * @returns {ElementTree}
		 */
		ElementTree.prototype.setSelectedElement = function (elementID, bNotify) {
			var selectedElement;

			if (typeof elementID !== "string") {
				jQuery.sap.log.warning("Please use a valid string parameter");
				return;
			}

			selectedElement = this._ElementTreeContainer.querySelector("[data-id=" + elementID + "]");

			if (selectedElement === null) {
				jQuery.sap.log.warning("The selected element is not a child of the ElementTree");
				return;
			}

			this._selectedElement = selectedElement;
			this._selectTreeElement(selectedElement, bNotify);

			return this;
		};

		ElementTree.prototype.clearSelection = function () {
			var selectedList = this._ElementTreeContainer.querySelector("[selected]");

			if (selectedList) {
				selectedList.removeAttribute("selected");
			}
		};

		/**
		 * Create and places the ElementTree HTML.
		 * @private
		 */
		ElementTree.prototype._createHTML = function () {
			var html;

			html = this._createFilter();
			html += this._createTreeContainer();

			this._ElementTreeContainer.innerHTML = html;
			// Save reverences for future use
			this._setReferences();

			if (this.getData() !== undefined) {
				this._createTree();
			}
		};

		/**
		 * Create the HTML needed for filtering.
		 * @returns {string}
		 * @private
		 */
		ElementTree.prototype._createFilter = function () {
			return "<filter>" +
				"<end>" +
				"<label><input type=\"checkbox\" issues checked/>Issues</label>" +
				"<label><input type=\"checkbox\" namespaces checked/>Namespaces</label>" +
				"<label><input type=\"checkbox\" attributes/>Attributes</label>" +
				"</end>" +
				"</filter>";
		};

		/**
		 * Create the HTML container for the tree.
		 * @returns {string}
		 * @private
		 */
		ElementTree.prototype._createTreeContainer = function () {
			return "<tree show-namespaces show-problematic-elements></tree>";
		};

		/**
		 * Create ElementTree HTML.
		 */
		ElementTree.prototype._createTree = function () {
			var controls = this.getData().controls;

			this._treeContainer.innerHTML = this._createTreeHTML(controls);
		};

		/**
		 * Create HTML tree from JSON.
		 * @param {ElementTreeOptions.controls} controls
		 * @param {number} level - nested level
		 * @returns {string} HTML ElementTree in form of a string
		 * @private
		 */
		ElementTree.prototype._createTreeHTML = function (controls, level) {
			if (controls === undefined || controls.length === 0) {
				return "";
			}

			var html = "";
			var nestedLevel = level || 0;
			var paddingLeft = ++nestedLevel * 10;
			var that = this;
			var issuesIds = this.getData().issuesIds;

			controls.forEach(function (control) {
				html += _startElementTreeList({
					attributes: ["expanded=\"true\""]
				});

				var hasIssue = issuesIds[control.id] !== undefined ? true : false;
				var numberOfIssues = 0;
				var numberOfIssues = hasIssue ? issuesIds[control.id].length : 0;
					html += _startElementTreeListItem({
					id: control.id
				}, hasIssue);

				html += _getElementTreeLeftColumnOfListItem(control, paddingLeft);

				html += _getElementTreeRightColumnOfListItem(control, numberOfIssues);

				html += _endElementTreeListItem();

				html += that._createTreeHTML(control.content, nestedLevel);

				html += _endElementTreeList();
			});

			return html;
		};

		/**
		 * Hide/Show nested "<ul>" in "<li>" elements.
		 * @param {Element} target - DOM element
		 * @private
		 */
		ElementTree.prototype._toggleCollapse = function (target) {
			var targetParent = _findNearestDOMParent(target.parentNode, "UL");

			if (target.getAttribute("right") === "true") {
				target.removeAttribute("right");
				target.setAttribute("down", "true");

				targetParent.setAttribute("expanded", "true");
			} else if (target.getAttribute("down") === "true") {
				target.removeAttribute("down");

				targetParent.removeAttribute("expanded");
				target.setAttribute("right", "true");
			}
		};

		/**
		 * Add visual selection to clicked "<li>" elements.
		 * @param {Element} targetElement - DOM element
		 * @private
		 */
		ElementTree.prototype._selectTreeElement = function (targetElement, bNotify) {
			var target = _findNearestDOMParent(targetElement, "LI");
			var dataId = target.attributes["data-id"];

			if (!dataId) {
				return;
			}

			var id = dataId.value;
			// Prevent tree element selection for allowing proper multiple tree element selection for copy/paste
			if (id === this._ElementTreeContainer.id) {
				return;
			}

			this._scrollToElement(target, window);

			if (bNotify) {
				this.onSelectionChanged(id);
			}

				this.clearSelection();

				target.setAttribute("selected", "true");

				if (bNotify) {
					this.onIssueCountClicked(id);
				}
		};

		/**
		 * Scroll to element in the ElementTree.
		 * @param {Element} target DOM element to which need to be scrolled
		 * @param {document.window} window The window element. Passed as a parameter to enable parameter mockup and function testing
		 */
		ElementTree.prototype._scrollToElement = function (target, window) {
			var desiredViewBottomPosition = this._treeContainer.offsetHeight - this._treeContainer.offsetTop + this._treeContainer.scrollTop;

			if (target.offsetTop > desiredViewBottomPosition || target.offsetTop < this._treeContainer.scrollTop) {
				this._treeContainer.scrollTop = target.offsetTop - window.innerHeight / 6;
			}
		};

		/**
		 * Search tree elements that match given criteria.
		 * @param {string} userInput - Search criteria
		 * @private
		 */
		ElementTree.prototype._searchInTree = function (userInput) {
			var searchableElements = this._ElementTreeContainer.querySelectorAll("[data-search]");
			var searchInput = userInput.toLocaleLowerCase();
			var elementInformation;

			for (var i = 0; i < searchableElements.length; i++) {
				elementInformation = searchableElements[i].getAttribute("data-search").toLocaleLowerCase();

				if (elementInformation.indexOf(searchInput) !== -1) {
					searchableElements[i].parentNode.setAttribute("matching", true);
				} else {
					searchableElements[i].parentNode.removeAttribute("matching");
				}
			}
		};

		/**
		 * Remove  "matching" attribute from the search.
		 * @private
		 */
		ElementTree.prototype._removeAttributesFromSearch = function () {
			var elements = this._treeContainer.querySelectorAll("[matching]");

			for (var i = 0; i < elements.length; i++) {
				elements[i].removeAttribute("matching");
			}
		};

		/**
		 * Visualize the number of elements which satisfy the search.
		 * @private
		 */
		ElementTree.prototype._setSearchResultCount = function (count) {
			this._filterContainer.querySelector("results").innerHTML = "(" + count + ")";
		};

		/**
		 * Event handler for mouse click on a tree element arrow.
		 * @param {Object} event - click event
		 * @private
		 */
		ElementTree.prototype._onArrowClick = function (event) {
			var target = event.target;

			if (target.nodeName === "ARROW") {
				this._toggleCollapse(target);
			} else {
				this._selectTreeElement(target, true);
			}
		};

		/**
		 * Event handler for user input in "search" input.
		 * @param {Object} event - keyup event
		 * @private
		 */
		ElementTree.prototype._onSearchInput = function (event) {
			var target = event.target;
			var searchResultCount;

			if (target.getAttribute("search") !== null) {

				if (target.value.length !== 0) {
					this._searchInTree(target.value);
				} else {
					this._removeAttributesFromSearch("matching");
				}

				searchResultCount = this._treeContainer.querySelectorAll("[matching]").length;
				this._setSearchResultCount(searchResultCount);
			}
		};

		/**
		 * Event handler for onsearch event.
		 * @param {Object} event - onsearch event
		 * @private
		 */
		ElementTree.prototype._onSearchEvent = function (event) {
			var searchResultCount;

			if (event.target.value.length === 0) {
				this._removeAttributesFromSearch("matching");

				searchResultCount = this._treeContainer.querySelectorAll("[matching]").length;
				this._setSearchResultCount(searchResultCount);
			}

		};

		/**
		 * Event handler for ElementTree options change.
		 * @param {Object} event - click event
		 * @private
		 */
		ElementTree.prototype._onOptionsChange = function (event) {
			var target = event.target;

			if (target.getAttribute("filter") !== null) {
				if (target.checked) {
					this._treeContainer.setAttribute("show-filtered-elements", true);
				} else {
					this._treeContainer.removeAttribute("show-filtered-elements");
				}
			}

			if (target.getAttribute("issues") !== null) {
				if (target.checked) {
					this._treeContainer.setAttribute("show-problematic-elements", true);
				} else {
					this._treeContainer.removeAttribute("show-problematic-elements");
				}
			}

			if (target.getAttribute("namespaces") !== null) {
				if (target.checked) {
					this._treeContainer.setAttribute("show-namespaces", true);
				} else {
					this._treeContainer.removeAttribute("show-namespaces");
				}
			}

			if (target.getAttribute("attributes") !== null) {
				if (target.checked) {
					this._treeContainer.setAttribute("show-attributes", true);
				} else {
					this._treeContainer.removeAttribute("show-attributes");
				}
			}

		};

		/**
		 * Event handler for mouse hover on tree element.
		 * @param {Object} event - mouse event
		 * @private
		 */
		ElementTree.prototype._onTreeElementMouseHover = function (event) {
			var target = _findNearestDOMParent(event.target, "LI");

			var hoverList = this._ElementTreeContainer.querySelector("[hover]");

			if (hoverList) {
				hoverList.removeAttribute("hover");
			}

			target.setAttribute("hover", "true");

			var dataId = target.attributes["data-id"];
			this.onHoverChanged(dataId && dataId.value);
		};

		/**
		 * Event handler for mouse out of the tree element.
		 * @param {Object} event - mouse event
		 * @private
		 */
		ElementTree.prototype._onTreeElementMouseOut = function (event) {
			this.onMouseOut();
		};

		/**
		 * Create all event handlers for the ElementTree.
		 * @private
		 */
		ElementTree.prototype._createHandlers = function () {
			this._treeContainer.onclick = this._onArrowClick.bind(this);
			this._filterContainer.onkeyup = this._onSearchInput.bind(this);
			this._filterContainer.onsearch = this._onSearchEvent.bind(this);
			this._filterContainer.onchange = this._onOptionsChange.bind(this);
			this._ElementTreeContainer.onmouseover = this._onTreeElementMouseHover.bind(this);
			this._ElementTreeContainer.onmouseout = this._onTreeElementMouseOut.bind(this);
		};

		/**
		 * Save references to ElementTree different sections.
		 * @private
		 */
		ElementTree.prototype._setReferences = function () {
			this._filterContainer = this._ElementTreeContainer.querySelector("filter");
			this._treeContainer = this._ElementTreeContainer.querySelector("tree");
		};

		return ElementTree;
	});

}; // end of sap/ui/support/supportRules/ui/external/ElementTree.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.external.Highlighter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.external.Highlighter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/ui/external/Highlighter",[],
	function () {
		"use strict";

		// Reference for the highlighter DOM element
		var _highLighter = null;

		/**
		 * Hide the highlighter.
		 * @private
		 */
		function _hideHighLighter() {
			_highLighter.style.display = "none";
		}

		/**
		 * Show the highlighter.
		 * @private
		 */
		function _showHighLighter() {
			_highLighter.style.display = "block";
		}

		/**
		 * Create DOM element for visual highlighting.
		 * @private
		 */
		function _createHighLighter() {
			var highLighter = document.createElement("div");

			highLighter.style.cssText = "box-sizing: border-box;border:1px solid blue;background: rgba(20, 20, 200, 0.4);position: absolute";

			var highLighterWrapper = document.createElement("div");

			highLighterWrapper.id = "ui5-highlighter";
			highLighterWrapper.style.cssText = "position: fixed;top:0;right:0;bottom:0;left:0;z-index: 1000;overflow: hidden;";
			highLighterWrapper.appendChild(highLighter);

			document.body.appendChild(highLighterWrapper);

			// Save reference for later usage
			_highLighter = document.getElementById("ui5-highlighter");

			// Add event handler
			_highLighter.onmouseover = _hideHighLighter;
		}

		/**
		 * Highlight controls.
		 * @type {{setDimensions: Function}}
		 */
		return {
			/**
			 * Set the position of the visual highlighter.
			 * @param {string} elementId - The id of the DOM element that need to be highlighted
			 * @returns {exports}
			 */
			highlight: function (elementId) {
				var highlighter;
				var targetDomElement;
				var targetRect;

				if (_highLighter === null && !document.getElementById("ui5-highlighter")) {
					_createHighLighter();
				} else {
					_showHighLighter();
				}

				highlighter = _highLighter.firstElementChild;
				targetDomElement = document.getElementById(elementId);

				if (targetDomElement) {
					targetRect = targetDomElement.getBoundingClientRect();

					highlighter.style.top = targetRect.top + "px";
					highlighter.style.left = targetRect.left + "px";
					highlighter.style.height = targetRect.height + "px";
					highlighter.style.width = targetRect.width + "px";
				}

				return this;
			},
			/**
			 * Hides the visual highlighter.
			 */
			hideHighLighter: _hideHighLighter
		};
	});

}; // end of sap/ui/support/supportRules/ui/external/Highlighter.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.models.SharedModel') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.models.SharedModel'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/models/SharedModel",[
	"sap/ui/model/json/JSONModel"
], function (JSONModel) {
	"use strict";

	var executionScopes = {
			global: {
				key: "global",
				displayName: "Global",
				description: "The Rules will be / are executed on the complete application with all loaded elements and components, including all previously loaded pages"
			},
			subtree: {
				key: "subtree",
				displayName: "Sub-tree",
				description: "The Rules will be / are executed on the specified sub-tree root element, including all child elements (aggregated sub-elements)"
			},
			components: {
				key: "components",
				displayName: "Component(s)",
				description: "The Rules will be / are executed on the selected components from the list of currently loaded components (or fragments)"
			}
		};

	var model = new JSONModel({
		selectedRule: null,
		libraries: null,
		selectedIssue: null,
		issues: [],
		progress: 0.1,
		showProgressIndicator: false,
		coreStateChanged: true,
		analyzePressed: false,
		selectedRulePreviewKey: "ruleProperties",
		selectedRuleCreateKey: "ruleProperties",
		selectedRuleEditKey: "ruleProperties",
		selectedSetPreviewKey: "availableRules",
		newRule: {},
		newRuleStringified: "",
		updateRuleStringified: "",
		subtreeExecutionContextId: "",
		availableComponents: [],
		audiences: sap.ui.support.Audiences,
		categories: sap.ui.support.Categories,
		severities: sap.ui.support.Severity,
		audiencesFilter : ["All"].concat(Object.keys(sap.ui.support.Audiences)),
		categoriesFilter : ["All"].concat(Object.keys(sap.ui.support.Categories)),
		severitiesFilter : ["All"].concat(Object.keys(sap.ui.support.Severity)),
		newEmptyRule: {
			libName: "",
			id: "",
			categories: [sap.ui.support.Categories.Other],
			audiences: [sap.ui.support.Audiences.Internal],
			title: "",
			description: "",
			resolution: "",
			resolutionurls: [],
			check: "function (oIssueManager, oCoreFacade, oScope) {\n\t/* \n\t oIssueManager - allows you to add new issues with the addIssue() method \n\t oCoreFacade - gives you access to state of the core: getMetadata(), getUIAreas(), getComponents(), getModels() \n\t oScope - retrieves elements in the scope with these methods: getElements(), getElementsByClassName(className), getLoggedObjects(type) \n\t fnResolve - optional, passed when the rule property async is set to true \n\t*/ \n}",
			selected: true,
			async: false
		},
		editRule: null,
		tempLink: {
			href: "",
			text: ""
		},
		resolveDescription: "Make sure to resolve your async rule by using the passed fnResolve function",
		selectedRuleStringify: "",
		analyzeContext: executionScopes.global,
		executionScopes: executionScopes,
		executionScopeTitle: "Execution scope",
		lastAnalysisElapsedTime: "",
		analysisDurationTitle: "Last analysis duration",
		costants: "",
		executionScopeComponents: [],
		persistingSettings: false,
		loadingAdditionalRuleSets: false,
		analyzedFinish: false,
		selectedRules: true,
		filteredIssues: null,
		issuesCount: 0,
		visibleRowCountMode:"Auto",
		visibleRowCount: 10,
		heightDetailsArea: "inherit",
		supportAssistantOrigin: "",
		supportAssistantVersion: ""
	});

	return model;
});

}; // end of sap/ui/support/supportRules/ui/models/SharedModel.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.models.formatter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.models.formatter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/ui/models/formatter",[], function () {
	"use strict";

	return {
		resolutionUrl: function (aUrls, oUrl) {
			var sSeparator = aUrls.indexOf(oUrl) === aUrls.length - 1 ? "" : ", \u00a0";
			return oUrl.text + sSeparator;
		}
	};
});
}; // end of sap/ui/support/supportRules/ui/models/formatter.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.util.StringAnalyzer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Contains String analyzing functionality such as calculating the levenshtein distance between 2 strings
 */
jQuery.sap.declare('sap.ui.support.supportRules.util.StringAnalyzer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/util/StringAnalyzer",[],
	function () {
	"use strict";

	var StringAnalyzer = {
		/**
		 *
		 * @param {string} sWordA
		 * @param {string} sWordB
		 * @returns levenshtein distance number
		 */
		calculateLevenshteinDistance: function(sWordA, sWordB) {

			var iLengthA = sWordA.length;
			var iLengthB = sWordB.length;

			if (iLengthA === 0) {
				return iLengthB;
			}
			if (iLengthB === 0) {
				return iLengthA;
			}

			// fill the x axis of the matrix
			var aMatrix = new Array(iLengthB + 1);
			var iIndexFirstRowX;
			for (iIndexFirstRowX = 0; iIndexFirstRowX <= iLengthB; iIndexFirstRowX++) {
				aMatrix[iIndexFirstRowX] = new Array(iLengthA + 1);
				aMatrix[iIndexFirstRowX][0] = iIndexFirstRowX;
			}

			// fill the y axis of the matrix
			var iIndexFirstRowY;
			for (iIndexFirstRowY = 0; iIndexFirstRowY <= iLengthA; iIndexFirstRowY++) {
				aMatrix[0][iIndexFirstRowY] = iIndexFirstRowY;
			}

			// calculate the levenshtein distance row by row
			var iLevenshteinDistance = 0;
			var iIndexRowsX;
			var iIndexRowY;
			for (iIndexRowsX = 1; iIndexRowsX <= iLengthB; iIndexRowsX++) {
				for (iIndexRowY = 1; iIndexRowY <= iLengthA; iIndexRowY++) {
					var iDeletionCost = aMatrix[iIndexRowsX - 1][iIndexRowY] + 1;
					var iInsertionCost = aMatrix[iIndexRowsX][iIndexRowY - 1] + 1;
					var iSubstitutionCost = aMatrix[iIndexRowsX - 1][iIndexRowY - 1];
					if (sWordA[iIndexRowY] !== sWordB[iIndexRowsX]) {
						iSubstitutionCost += 1;
					}
					iLevenshteinDistance = Math.min(iDeletionCost, iInsertionCost, iSubstitutionCost);
					aMatrix[iIndexRowsX][iIndexRowY] = iLevenshteinDistance;
				}
			}
			//the last calculated distance is the shortest distance
			return iLevenshteinDistance;
		}
	};

	return StringAnalyzer;
}, false);

}; // end of sap/ui/support/supportRules/util/StringAnalyzer.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.Analyzer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global performance */

/**
 * Creates an Analyzer that asynchronously runs tasks added by addTask function. Analysis can be started, stopped, restarted, paused and continued.
 * runs tasks added by addTask function. Analysis can be started, stopped, restarted, paused and continued.
 * The analyzer can be used to update the UI with the current progress of a task while it's running.
 */
jQuery.sap.declare('sap.ui.support.supportRules.Analyzer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/Analyzer",["jquery.sap.global", "sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/Constants"],
	function (jQuery, IssueManager, Constants) {
		"use strict";

		/**
		 * @classdesc
		 * <h3>Overview</h3>
		 * Analyzer class that runs tasks. A Task runs a function for every entry in its object array.
		 * The Analyzer counts the task objects and calculates the percentages.
		 * <h3>Usage</h3>
		 * With the start, restart, stop and pause methods the analyzer can be controlled.
		 * While running it asynchronously, it selects objects from the list of each task and completes them.
		 * @private
		 * @class sap.ui.support.Analyzer
		 */
		var Analyzer = function () {
			this.dStartedAt = null;
			this.dFinishedAt = null;
			this.iElapsedTime = 0;
			this._iAllowedTimeout = 10000; //ms
			this.reset();
		};

		/**
		 * Resets the analyzer and clears all tasks.
		 *
		 * @private
		 * @returns {void}
		 */
		Analyzer.prototype.reset = function () {
			this._iTotalProgress = 0;
			this._iCompletedRules = 0;
			this._iTotalRules = 0;
			this._bRunning = false;
			this._aRulePromices = [];
		};

		/**
		 * Returns whether the Analyzer is currently running.
		 *
		 * @public
		 * @returns {boolean} Check if the Analyzer is still running
		 */
		Analyzer.prototype.running = function () {
			return this._bRunning;
		};

		/**
		 * Starts the analyzer to run all rules.
		 *
		 * @public
		 * @param {array} aRules Selected rules for execution
		 * @param {object} oCoreFacade Metadata, Models, UI areas and Components of the Core object
		 * @param {object} oExecutionScope selected execution scope from user in UI
		 * @returns {Promise} When all rules are analyzed
		 */
		Analyzer.prototype.start = function (aRules, oCoreFacade, oExecutionScope) {
			var oIssueManagerFacade,
				that = this;

			this.dStartedAt = new Date();
			this._iTotalRules = aRules.length;
			this._bRunning = true;

			aRules.forEach(function (oRule) {
				that._aRulePromices.push(new Promise(function (fnResolve) {
					try {
						oIssueManagerFacade = IssueManager.createIssueManagerFacade(oRule);
						if (oRule.async) {
							that._runAsyncRule(oIssueManagerFacade, oCoreFacade, oExecutionScope, oRule, fnResolve);
						} else {
							oRule.check(oIssueManagerFacade, oCoreFacade, oExecutionScope);
							fnResolve();
							that._updateProgress();
						}

					} catch (eRuleExecException) {
						that._handleException(eRuleExecException, oRule.id, fnResolve);
					}
				}));
			});

			return Promise.all(this._aRulePromices).then(function () {
				that.reset();
				that.dFinishedAt = new Date();
				that.iElapsedTime = that.dFinishedAt.getTime() - that.dStartedAt.getTime(); // In milliseconds
			});
		};

		/**
		 * Handles exceptions in async/sync rule executions.
		 *
		 * @private
		 * @param {(object|string)} eRuleException The exception object
		 * @param {string} sRuleId The ID of the rule
		 * @param {function} fnResolve the resolve function of the promise
		 */
		Analyzer.prototype._handleException = function (eRuleException, sRuleId, fnResolve) {
			var sText = eRuleException.message || eRuleException;
			var sMessage = "[" + Constants.SUPPORT_ASSISTANT_NAME + "] Error while execution rule \"" + sRuleId +
				"\": " + sText;
			jQuery.sap.log.error(sMessage);
			fnResolve();
			this._updateProgress();
		};

		/**
		 * Updates ProgressBar in Main panel of Support Assistant.
		 *
		 * @private
		 */
		Analyzer.prototype._updateProgress = function () {
			this._iCompletedRules++;
			this._iTotalProgress = Math.ceil( this._iCompletedRules / this._iTotalRules * 100 );

			if (this.onNotifyProgress) {
				this.onNotifyProgress(this._iTotalProgress);
			}
		};

		/**
		 * Analyzes async rules.
		 *
		 * @param {object} oIssueManagerFacade instance of the IssueManagerFacade
		 * @param {object} oCoreFacade Metadata, Models, UI areas and Components of the Core object
		 * @param {object} oExecutionScope selected execution scope from user in UI
		 * @param {object} oRule support rule to be analyzed
		 * @param {object} fnResolve inner resolve for async rules
		 * @private
		 */
		Analyzer.prototype._runAsyncRule = function (oIssueManagerFacade, oCoreFacade, oExecutionScope, oRule, fnResolve) {
			var that = this,
				bTimedOut = false;

			var iTimeout = setTimeout(function () {
				bTimedOut = true;
				that._handleException("Check function timed out", oRule.id, fnResolve);
			}, this._iAllowedTimeout);

			new Promise(function (fnRuleResolve) {
				oRule.check(oIssueManagerFacade, oCoreFacade, oExecutionScope, fnRuleResolve);
			}).then(function () {
				if (!bTimedOut) {
					clearTimeout(iTimeout);
					fnResolve();
					that._updateProgress();
				}
			}).catch(function (eRuleExecException) {
				if (!bTimedOut) {
					clearTimeout(iTimeout);
					that._handleException(eRuleExecException, oRule.id, fnResolve);
				}
			});
		};

		/**
		 * Get the elapsed time in the form of a string.
		 *
		 * @public
		 * @returns {string} Returns the total elapsed time since the Analyzer has started
		 */
		Analyzer.prototype.getElapsedTimeString = function () {
			if (!this.iElapsedTime) {
				return "";
			}

			var oDate = new Date(null);
			oDate.setHours(0, 0, 0, 0);
			oDate.setMilliseconds(this.iElapsedTime);
			var aBuffer = [
				(oDate.getHours() < 10 ? "0" : "") + oDate.getHours(),
				(oDate.getMinutes() < 10 ? "0" : "") + oDate.getMinutes(),
				(oDate.getSeconds() < 10 ? "0" : "") + oDate.getSeconds(),
				oDate.getMilliseconds()
			];

			return aBuffer.join(":");
		};

		return Analyzer;
	}, false);

}; // end of sap/ui/support/supportRules/Analyzer.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.RuleSet') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * The RuleSet is an interface used to create, update and delete ruleset containing rules.
 */
jQuery.sap.declare('sap.ui.support.supportRules.RuleSet'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/RuleSet",[
	"jquery.sap.global",
	"sap/ui/support/supportRules/Storage",
	"sap/ui/support/supportRules/Constants"
],
function (jQuery, storage, constants) {
	"use strict";

	/**
	 * Contains all rulesets inside the RuleSet.
	 *
	 * @readonly
	 * @name sap.ui.support.RuleSet.mRuleSets
	 * @memberof sap.ui.support
	 */
	var mRuleSets = {};

	/**
	 * Creates a RuleSet.
	 * The RuleSet can store multiple rules concerning namespaces.
	 * <h3>Usage</h3>
	 * The RuleSet is an interface used to create, update and delete rulesets.
	 *
	 * @class
	 * @public
	 * @constructor
	 * @namespace
	 * @name sap.ui.support.RuleSet
	 * @memberof sap.ui.support
	 * @author SAP SE
	 * @version 1.52.30
	 * @param {object} oSettings Name of the initiated
	 * @returns {void}
	 */
	var RuleSet = function (oSettings) {
		oSettings = oSettings || {};

		if (!oSettings.name) {
			jQuery.sap.log.error("Please provide a name for the RuleSet.");
		}

		if (mRuleSets[oSettings.name]) {
			return mRuleSets[oSettings.name];
		}

		this._oSettings = oSettings;
		this._mRules = {};
		mRuleSets[oSettings.name] = this;
	};

	/**
	 * Clears all rulesets inside the RuleSet.
	 * @public
	 * @static
	 * @method
	 * @name sap.ui.support.RuleSet.clearAllRuleSets
	 * @memberof sap.ui.support.RuleSet
	 * @returns {void}
	 */
	RuleSet.clearAllRuleSets = function () {
		mRuleSets = {};
	};

	/**
	 * Gets all rules from the RuleSet.
	 * @public
	 * @method
	 * @name sap.ui.support.RuleSet.getRules
	 * @memberof sap.ui.support.RuleSet
	 * @returns {object} All rules within the current RuleSet
	 */
	RuleSet.prototype.getRules = function () {
		return this._mRules;
	};

	/**
	 * Updates rules from the RuleSet.
	 * @public
	 * @method
	 * @name sap.ui.support.RuleSet.updateRule
	 * @memberof sap.ui.support.RuleSet
	 * @param {string} sRuleId Rule ID
	 * @param {object} ORuleSettings Rule settings
	 * @returns {string} sRuleVerification Rule Verification status
	 */
	RuleSet.prototype.updateRule = function (sRuleId, ORuleSettings) {
		var sRuleVerification = this._verifySettingsObject(ORuleSettings, true);

		if (sRuleVerification === "success") {
			delete this._mRules[sRuleId];
			this._mRules[ORuleSettings.id] = ORuleSettings;
		}

		return sRuleVerification;
	};

	/**
	 * Verifies the settings object of the current RuleSet.
	 * @private
	 * @method
	 * @name sap.ui.support.RuleSet._verifySettingsObject
	 * @memberof sap.ui.support.RuleSet
	 * @param {object} oSettings Settings object to be verified
	 * @param {boolean} bUpdate Triggers update of passed settings object
	 * @returns {string} Rule Verification status
	 */
	RuleSet.prototype._verifySettingsObject = function (oSettings, bUpdate) {

		if (!oSettings.id) {
			jQuery.sap.log.error("Support rule needs an id.");
			return "Support rule needs an unique id.";
		}

		if (!bUpdate && this._mRules[oSettings.id]) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " already exists.");
			return "Support rule with the id " + oSettings.id + " already exists.";
		}

		if (!oSettings.check) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " needs a check function.");
			return "Support rule with the id " + oSettings.id + " needs a check function.";
		}

		if (!oSettings.title) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " needs a title.");
			return "Support rule with the id " + oSettings.id + " needs a title.";
		}

		if (!oSettings.description) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " needs a description.");
			return "Support rule with the id " + oSettings.id + " needs a description.";
		}

		if (!oSettings.resolution && (!oSettings.resolutionurls || !oSettings.resolutionurls.length > 0)) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " needs either a resolution or resolutionurls or should have a ticket handler function");
			return "Support rule with the id " + oSettings.id + " needs either a resolution or resolutionurls or should have a ticket handler function";
		}

		if (!oSettings.audiences || oSettings.audiences.length === 0) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " should have an audience. Applying audience ['Control']");
			oSettings.audiences = [sap.ui.support.Audiences.Control];
		}

		if (oSettings.audiences && oSettings.audiences.forEach) {
			var bIsWrongAudience = false,
				sAudienceName = "";
			oSettings.audiences.forEach(function (aud) {
				if (!sap.ui.support.Audiences[aud]) {
					bIsWrongAudience = true;
					sAudienceName = aud;
				}
			});

			if (bIsWrongAudience) {
				jQuery.sap.log.error("Audience " + sAudienceName + " does not exist. Please use the audiences from sap.ui.support.Audiences");
				return "Audience " + sAudienceName + " does not exist. Please use the audiences from sap.ui.support.Audiences";
			}
		}

		if (!oSettings.categories || oSettings.categories.length === 0) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " should have a category. Applying category ['Performance']");
			oSettings.categories = ["Performance"];
		}

		if (oSettings.categories && oSettings.categories.forEach) {
			var bIsWrongCategory = false,
				sCategoryName = "";
			oSettings.categories.forEach(function (cat) {
				if (!sap.ui.support.Categories[cat]) {
					bIsWrongCategory = true;
					sCategoryName = cat;
				}
			});

			if (bIsWrongCategory) {
				jQuery.sap.log.error("Category " + sCategoryName + " does not exist. Please use the categories from sap.ui.support.Categories");
				return "Category " + sCategoryName + " does not exist. Please use the categories from sap.ui.support.Categories";
			}
		}

		return "success";
	};

	/**
	 * Adds rules to RuleSet.
	 * @public
	 * @method
	 * @name sap.ui.support.RuleSet.addRule
	 * @memberof sap.ui.support.RuleSet
	 * @param {object} oSettings Settings object with rule information
	 * @returns {string} sRuleVerificationStatus Verification status
	 */
	RuleSet.prototype.addRule = function (oSettings) {

		var sCurrentVersion = RuleSet.versionInfo ? RuleSet.versionInfo.version : '';

		var sRuleVersion = oSettings.minversion ? oSettings.minversion : '';

		// Some rules use '-' instead of ''
		if (sRuleVersion === '-') {
			sRuleVersion = '';
		}

		// Do not add a rule that is for higher version of UI5
		// because APIs might not be in place
		if (sRuleVersion && jQuery.sap.Version(sCurrentVersion).compareTo(sRuleVersion) < 0) {
			return "Rule " + oSettings.id + " should be used with a version >= " + oSettings.minversion;
		}

		var sRuleVerificationStatus = this._verifySettingsObject(oSettings);

		if (sRuleVerificationStatus === "success") {
			this._mRules[oSettings.id] = oSettings;
			oSettings.libName = this._oSettings.name;
		}

		return sRuleVerificationStatus;
	};

	/**
	 * Adds all previously created temporary rules to the current library rules.
	 * @public
	 * @static
	 * @method
	 * @name sap.ui.support.RuleSet.addToTempRules
	 * @memberof sap.ui.support.RuleSet
	 * @param {object} oLibraries The loaded libraries and their rules
	 * @param {string[]} aTempRules The temporary rules previously created by the user
	 */
	RuleSet.addToTempRules = function (oLibraries, aTempRules) {
		if (aTempRules) {
			aTempRules.forEach(function (tempRule) {
				var ruleName = tempRule.id;
				oLibraries[constants.TEMP_RULESETS_NAME].RuleSet._mRules[ruleName] = tempRule;
			});
		}
	};

	/**
	 * Stores which rules are selected to be run by the analyzer on the next check
	 * @public
	 * @static
	 * @method
	 * @name sap.ui.support.RuleSet.storeSelectionOfRules
	 * @memberof sap.ui.support.RuleSet
	 * @param {Object[]} aLibraries The data for the libraries and their rules
	 */
	RuleSet.storeSelectionOfRules = function (aLibraries) {
		var selectedRules = RuleSet._extractRulesSettingsToSave(aLibraries);
		storage.setSelectedRules(selectedRules);
	};

	/**
	 * Loads the previous selection of the user - which rules are selected to be run by the Rule Analyzer.
	 * The method applies the settings to the currently loaded rules.
	 * @public
	 * @static
	 * @method
	 * @name sap.ui.support.RuleSet.loadSelectionOfRules
	 * @memberof sap.ui.support.RuleSet
	 * @param {Object[]} aLibraries The current loaded libraries and their rules
	 */
	RuleSet.loadSelectionOfRules = function (aLibraries) {
		var savedPreferences = storage.getSelectedRules();

		if (!savedPreferences) {
			return;
		}

		for (var index = 0; index < aLibraries.length; index += 1) {
			var libraryRules = aLibraries[index].rules;
			var libraryName = aLibraries[index].title;

			for (var rulesIndex = 0; rulesIndex < libraryRules.length; rulesIndex += 1) {
				//If there is a saved preference for the loaded rule apply it over the default
				if (savedPreferences[libraryName] && savedPreferences[libraryName].hasOwnProperty(libraryRules[rulesIndex].id)) {
					libraryRules[rulesIndex].selected = savedPreferences[libraryName][libraryRules[rulesIndex].id].selected;
				}
			}
		}
	};

	/**
	 * Extracts all the settings needed to be saved from the libraries rules.
	 * @private
	 * @method
	 * @static
	 * @name sap.ui.support.RuleSet._extractRulesSettingsToSave
	 * @memberof sap.ui.support.RuleSet
	 * @param {Object[]} aLibraries The libraries and rules loaded from the model
	 */
	RuleSet._extractRulesSettingsToSave = function (aLibraries) {
		var oLibrarySettings = {};
		var libraryRules;
		var librariesCount = aLibraries.length;
		var rulesCount;
		var libraryName;
		var ruleSettings;

		for (var libraryIndex = 0; libraryIndex < librariesCount; libraryIndex += 1) {
			libraryName = aLibraries[libraryIndex].title;
			oLibrarySettings[libraryName] = {};
			libraryRules = aLibraries[libraryIndex].rules;

			rulesCount = libraryRules.length;
			for (var rulesIndex = 0; rulesIndex < rulesCount; rulesIndex += 1) {
				ruleSettings = {};
				ruleSettings.id = libraryRules[rulesIndex].id;
				ruleSettings.selected = libraryRules[rulesIndex].selected;
				oLibrarySettings[libraryName][ruleSettings.id] = ruleSettings;
			}
		}

		return oLibrarySettings;
	};

	return RuleSet;
}, true);

}; // end of sap/ui/support/supportRules/RuleSet.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.controllers.Analysis.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.controllers.Analysis.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.m.Panel'); // unlisted dependency retained
jQuery.sap.require('sap.m.List'); // unlisted dependency retained
jQuery.sap.require('sap.m.ListItemBase'); // unlisted dependency retained
jQuery.sap.require('sap.m.StandardListItem'); // unlisted dependency retained
jQuery.sap.require('sap.m.InputListItem'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.Toolbar'); // unlisted dependency retained
jQuery.sap.require('sap.m.ToolbarSpacer'); // unlisted dependency retained
jQuery.sap.require('sap.m.Label'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageToast'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/controllers/Analysis.controller",[
	"jquery.sap.global",
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel",
	"sap/m/Panel",
	"sap/m/List",
	"sap/m/ListItemBase",
	"sap/m/StandardListItem",
	"sap/m/InputListItem",
	"sap/m/Button",
	"sap/m/Toolbar",
	"sap/m/ToolbarSpacer",
	"sap/m/Label",
	"sap/m/MessageToast",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/WCBChannels",
	"sap/ui/support/supportRules/ui/models/SharedModel",
	"sap/ui/support/supportRules/RuleSerializer",
	"sap/ui/support/supportRules/Constants",
	"sap/ui/support/supportRules/RuleSet",
	"sap/ui/support/supportRules/Storage"
], function ($, Controller, JSONModel, Panel, List, ListItemBase, StandardListItem, InputListItem, Button, Toolbar, ToolbarSpacer,
		Label, MessageToast, CommunicationBus, channelNames, SharedModel, RuleSerializer, constants, Ruleset, storage) {
	"use strict";


	return Controller.extend("sap.ui.support.supportRules.ui.controllers.Analysis", {
		onInit: function () {
			this.model = SharedModel;
			this.setCommunicationSubscriptions();
			this.initSettingsPopover();

			CommunicationBus.publish(channelNames.ON_INIT_ANALYSIS_CTRL);
			this.tempRulesLoaded = false;

			this.getView().setModel(this.model);
			this.treeTable = this.getView().byId("ruleList");
			this.cookie = storage.readPersistenceCookie(constants.COOKIE_NAME);
		},

		onAsyncSwitch: function (oEvent) {
			var oSource = oEvent.getSource();

			if (oEvent.getParameter("selected")) {
				var bAsync = oSource.getCustomData()[0].getValue() === "true";
				var sRule = oSource.getProperty("groupName") === "asyncContext" ? "/newRule" : "/editRule";
				this.model.setProperty(sRule + "/async", bAsync);
				this._updateCheckFunction(sRule, bAsync);
			}
		},

		/**
		 * Add fnResolve to the check function when async is set to true otherwise removes it.
		 * @private
		 * @param {string} sRule the model path to edit or new rule
		 * @param {bAsync} bAsync the async property of the rule
		 */
		_updateCheckFunction: function (sRule, bAsync) {
			var sCheckFunction = this.model.getProperty(sRule + "/check");

			if (!sCheckFunction) {
				return;
			}

			// Check if a function is found
			var oMatch = sCheckFunction.match(/function[^(]*\(([^)]*)\)/);

			if (!oMatch) {
				return;
			}

			// Get the parameters of the function found and trim, then split by word.
			var aParams = oMatch[1].trim().split(/\W+/);
			// Add missing parameters to ensure the resolve function is passed on the correct position.
			aParams[0] = aParams[0] || "oIssueManager";
			aParams[1] = aParams[1] || "oCoreFacade";
			aParams[2] = aParams[2] || "oScope";

			// If async add a fnResolve to the template else remove it.
			if (bAsync) {
				aParams[3] = aParams[3] || "fnResolve";
			} else {
				aParams = aParams.slice(0, 3);
			}

			// Replace the current parameters with the new ones.
			var sNewCheckFunction = sCheckFunction.replace(/function[^(]*\(([^)]*)\)/, "function (" + aParams.join(", ") + ")");

			this.model.setProperty(sRule + "/check", sNewCheckFunction);
		},

		getTemporaryLib: function () {
			var libs = this.model.getProperty("/libraries");

			for (var i = 0; i < libs.length; i++) {
				if (libs[i].title == constants.TEMP_RULESETS_NAME) {
					return libs[i];
				}
			}
		},
		setCommunicationSubscriptions: function () {
			CommunicationBus.subscribe(channelNames.UPDATE_SUPPORT_RULES, this.updatesupportRules, this);

			CommunicationBus.subscribe(channelNames.VERIFY_RULE_CREATE_RESULT, function (data) {
				var result = data.result,
					newRule = RuleSerializer.deserialize(data.newRule, true),
					tempLib = this.getTemporaryLib(),
					treeTable = this.model.getProperty('/treeViewModel');

				if (result == "success") {
					tempLib.rules.push(newRule);
					this._syncTreeTableVieModelTempRulesLib(tempLib, treeTable);

					if (this.model.getProperty("/persistingSettings")) {
						storage.setRules(tempLib.rules);
						if (this.showRuleCreatedToast) {
							MessageToast.show('Your temporary rule "' + newRule.id + '" was persisted in the local storage');
							this.showRuleCreatedToast = false;
						}
					}

					var emptyRule = this.model.getProperty("/newEmptyRule");
					this.model.setProperty("/newRule", jQuery.extend(true, {}, emptyRule));
					this.goToRuleProperties();
					this.model.setProperty("/selectedRule", newRule);
				} else {
					MessageToast.show("Add rule failed because: " + result);
				}
			}, this);

			CommunicationBus.subscribe(channelNames.VERIFY_RULE_UPDATE_RESULT, function (data) {
				var result = data.result,
					updateRule = RuleSerializer.deserialize(data.updateRule, true),
					that = this;

				if (result === "success") {
					var ruleSource = this.model.getProperty("/editRuleSource"),
					treeTable = this.model.getProperty('/treeViewModel');
					var libraries = this.model.getProperty('/libraries');
					libraries.forEach(function(lib, libIndex){
						if (lib.title === constants.TEMP_RULESETS_NAME) {
							lib.rules.forEach(function(rule, ruleIndex){
								if (rule.id === ruleSource.id) {
									lib.rules[ruleIndex] = updateRule;

									if (that.model.getProperty("/persistingSettings")) {
										storage.setRules(lib.rules);
									}
								}
							});
							that._syncTreeTableVieModelTempRule(updateRule,treeTable);
						}
					});

					this.model.checkUpdate(true);
					this.model.setProperty('/selectedRule', updateRule);

					this.goToRuleProperties();
				} else {
					MessageToast.show("Update rule failed because: " + result);
				}
			}, this);

			CommunicationBus.subscribe(channelNames.POST_AVAILABLE_LIBRARIES, function (data) {
				this.model.setProperty("/availableLibrariesSet", data.libNames);

				if (this.loadingFromLoadButton) {
					MessageToast.show("Libraries ruleset loaded");
					this.loadingFromLoadButton = false;
				}
			}, this);

			CommunicationBus.subscribe(channelNames.POST_AVAILABLE_COMPONENTS, function (data) {
				var executionScopeComponents = [],
					modelScopeComponents = this.model.getProperty("/executionScopeComponents"),
					savedComponents = storage.getSelectedScopeComponents(),
					index;

				for (var componentIndex = 0; componentIndex < data.length; componentIndex += 1) {
					executionScopeComponents.push({text: data[componentIndex]});
				}
				if (modelScopeComponents && modelScopeComponents.length > 0) {
					for (index = 0; index < executionScopeComponents.length; index++) {
						executionScopeComponents[index].selected = this.checkIfComponentIsSelected(executionScopeComponents[index], modelScopeComponents);
					}
				} else if (savedComponents && savedComponents.length > 0) {
					for (index = 0; index < executionScopeComponents.length; index++) {
						executionScopeComponents[index].selected = this.checkIfComponentIsSelected(executionScopeComponents[index], savedComponents);
					}
				}

				this.model.setProperty("/executionScopeComponents", executionScopeComponents);
			}, this);

			CommunicationBus.subscribe(channelNames.GET_RULES_MODEL, function (treeViewModelRules) {
				this.model.setProperty("/treeViewModel", treeViewModelRules);
			}, this);
		},
		/**
		 * Checks if given execution scope component is selected comparing against an array of settings
		 * @param {Object} component The current component object to be checked
		 * @param {Array} savedComponents The local storage settings for the checked execution scope components
		 * @returns {boolean} If the component is checked or not
		 */
		checkIfComponentIsSelected: function (component, savedComponents) {
			for (var index = 0; index < savedComponents.length; index += 1) {
				if (savedComponents[index].text == component.text && savedComponents[index].selected) {
					return true;
				}
			}
			return false;
		},

		onAnalyze: function () {
			var selectedRules = this._getSelectedRules(),
				executionContext = this._getExecutionContext();
			if (selectedRules.length > 0) {
				CommunicationBus.publish(channelNames.ON_ANALYZE_REQUEST, {
					selectedRules: selectedRules,
					executionContext: executionContext
				});
				this.model.setProperty("/showProgressIndicator", true);
			} else {
				MessageToast.show("Select some rules to be analyzed.");
			}
		},

		initSettingsPopover: function () {
			this._settingsPopover = sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.AnalyzeSettings", this);
			this._settingsPopover.setModel(SharedModel);
			this.getView().addDependent(this._oPopover);
		},

		_getExecutionContext: function () {
			var ctx = {
				type: this.model.getProperty("/analyzeContext/key")
			};

			// TODO: these "if"s can be consistently turned into switch with constants
			if (ctx.type === "subtree") {
				ctx.parentId = this.model.getProperty("/subtreeExecutionContextId");
			}

			if (ctx.type === "components") {
				var selectionContainer = sap.ui.getCore().byId("componentsSelectionContainer"),
					cbs = selectionContainer.getContent();

				ctx.components = [];
				cbs.forEach(function (checkBox) {
					if (checkBox.getSelected()) {
						ctx.components.push(checkBox.getText());
					}
				});
			}

			return ctx;
		},
		_getSelectedRules: function () {
			var	selectedRules = [],
			selectedIndices = this.treeTable.getSelectedIndices(),
			that = this;

			selectedIndices.forEach(function(index){
				if (that.treeTable.getContextByIndex(index).getObject().id) {
					selectedRules.push({
						libName: that.treeTable.getContextByIndex(index).getObject().libName,
						ruleId: that.treeTable.getContextByIndex(index).getObject().id
					});
				}
			});

			return selectedRules;
		},
		/**
		 * Keeps in sync the TreeViewModel for temporary library that we use for visualisation of sap.m.TreeTable and the model that we use in the Suppport Assistant
		 * @param {Object} tempLib  temporary library model from Support Assistant
		 * @param {Object} treeTable Model for sap.m.TreeTable visualization
		 */
		_syncTreeTableVieModelTempRulesLib: function (tempLib, treeTable) {
			var innerIndex = 0;
				for (var ruleIndex in tempLib.rules) {
					for (var i in treeTable) {
						if (treeTable[i].name === constants.TEMP_RULESETS_NAME) {
							treeTable[i][innerIndex] = {
								name: tempLib.rules[ruleIndex].title,
								description: tempLib.rules[ruleIndex].description,
								id: tempLib.rules[ruleIndex].id,
								audiences: tempLib.rules[ruleIndex].audiences,
								categories: tempLib.rules[ruleIndex].categories,
								minversion: tempLib.rules[ruleIndex].minversion,
								resolution: tempLib.rules[ruleIndex].resolution,
								title: tempLib.rules[ruleIndex].title,
								libName: treeTable[i].name,
								check: tempLib.rules[ruleIndex].check
							};

						}
					}
					innerIndex++;
				}
		},
		/**
		 * Keeps in sync the TreeViewModel for temporary rules that we use for visualisation of sap.m.TreeTable and the model that we use in the SuppportAssistant
		 * @param {Object} tempRule Temporary rule
		 * @param {Object} treeTable Model for sap.m.TreeTable visualization
		 */
		_syncTreeTableVieModelTempRule: function (tempRule, treeTable) {
				var ruleSource = this.model.getProperty("/editRuleSource");
				for (var i in treeTable) {
					if (treeTable[i].name === constants.TEMP_RULESETS_NAME) {
						for (var innerIndex in treeTable[i]) {
							if (treeTable[i][innerIndex].id === ruleSource.id) {
								treeTable[i][innerIndex] = {
									name: tempRule.title,
									description: tempRule.description,
									id: tempRule.id,
									audiences: tempRule.audiences,
									categories: tempRule.categories,
									minversion: tempRule.minversion,
									resolution: tempRule.resolution,
									title: tempRule.title,
									libName: treeTable[i].name,
									check: tempRule.check
								};
							}
						}
					}
				}
		},
		onAnalyzeSettings: function (oEvent) {
			CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);
			this._settingsPopover.openBy(oEvent.getSource());
		},
		onContextSelect: function (oEvent) {
			if (oEvent.getParameter("selected")) {
				var source = oEvent.getSource(),
					radioKey = source.getCustomData()[0].getValue(),
					execScope = this.model.getProperty("/executionScopes")[radioKey];
				this.model.setProperty("/analyzeContext", execScope);
			}

			if (this.cookie) {
				this.persistExecutionScope();
			}
		},

		onExecutionContextChange: function (event) {
			var value = event.getSource().getValue();

			if (value) {
				this.model.setProperty("/subtreeExecutionContextId", value);
			}

			if (this.cookie) {
				this.persistExecutionScope();
			}
		},

		persistExecutionScope: function () {
			var setting = {
				analyzeContext: this.model.getProperty("/analyzeContext"),
				subtreeExecutionContextId: this.model.getProperty("/subtreeExecutionContextId")
			};

			storage.setSelectedContext(setting);
		},

		onScopeComponentSelect: function (event) {
			var scopeComponents = this.model.getProperty("/executionScopeComponents");

			if (this.cookie) {
				storage.setSelectedScopeComponents(scopeComponents);
			}
		},
		onBeforePopoverOpen: function () {
			if (this.model.getProperty("/executionScopeComponents").length === 0) {
				CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);
			}
		},

		createNewRulePress: function (oEvent) {
			var emptyRule = this.model.getProperty("/newEmptyRule");
			this.model.setProperty("/selectedSetPreviewKey", "availableRules");
			this.model.setProperty("/newRule", jQuery.extend(true, {}, emptyRule));
			this.model.setProperty("/tempLink", { href: "", text: "" });
			this.goToCreateRule();
		},
		goToRuleProperties: function () {
			var navCont = this.getView().byId("rulesNavContainer");
			navCont.to(this.getView().byId("rulesDisplayPage"), "show");
		},
		createRuleString: function (rule) {
			// FIXME
			// Need to return empty string when rule is undefined
			// it happens when tool is injected from outside
			if (!rule) {
				return '';
			}

			var str = "{\n",
				count = 0,
				keysLength = Object.keys(rule).length;

			for (var key in rule) {
				var value = rule[key];
				count++;
				str += "\t";
				str += key + ": ";
				if (key === "check") {
					str += value.split("\n").join("\n\t");
				} else {
					str += JSON.stringify(value);
				}

				//Don't add comma after last value
				if (count < keysLength) {
					str += ",";
				}

				str += "\n";
			}
			str += "}";
			return str;
		},
		updateRule: function () {
			var oldId = this.model.getProperty("/editRuleSource/id"),
				updateObj = this.model.getProperty("/editRule");

			if (this.checkFunctionString(updateObj.check)) {
				CommunicationBus.publish(channelNames.VERIFY_UPDATE_RULE, {
					oldId: oldId,
					updateObj: RuleSerializer.serialize(updateObj)
				});
			}
		},
		updatesupportRules: function (data) {
			data = RuleSerializer.deserialize(data);

			CommunicationBus.publish(channelNames.REQUEST_RULES_MODEL, data);

			var libraries = [],
				that = this,
				persistingSettings = this.model.getProperty("/persistingSettings");

			for (var i in data) {
				var rules = [],
					ruleSets = data[i].ruleset._mRules;

				for (var j in ruleSets) {
					var rule = ruleSets[j];
					rule.libName = i;
					rule.selected = true;
					rules.push(rule);

				}

				libraries.push({
					title: i,
					type: "library",
					rules: rules
				});
			}

			// Set first rule from first library if there is no temporary rules
			var firstSelectedRule;
			if (libraries[0].rules[0] ){
				firstSelectedRule = libraries[0].rules[0];
			} else {
				firstSelectedRule = libraries[1].rules[0];
			}

			that.placeTemporaryRulesetAtStart(libraries);
			that.model.setProperty("/selectedRuleStringify", "");
			that.model.setProperty("/selectedRule", firstSelectedRule);
			that.model.setProperty("/selectedRuleStringify", that.createRuleString(firstSelectedRule));
			that.model.setProperty("/libraries",  libraries);

			var tempRules = storage.getRules(),
				loadingFromAddiotnalRuleSets = that.model.getProperty("/loadingAdditionalRuleSets");
			if (tempRules && !loadingFromAddiotnalRuleSets && !this.tempRulesLoaded) {
				this.tempRulesLoaded = true;
				tempRules.forEach(function (tempRule) {
					CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE, RuleSerializer.serialize(tempRule));
				});
			}
			//*This property is needed when we are loading additional rulesets and to not retriger ".VERIFY_CREATE_RULE"*/
			that.model.setProperty("/loadingAdditionalRuleSets", false);
			if (persistingSettings) {
				var selectedRules = storage.getSelectedRules();
				selectedRules.forEach(function(selectedIndex){
					that.treeTable.setSelectedIndex(selectedIndex);
				});

			} else {
				this.treeTable.selectAll();
			}


		},
		placeTemporaryRulesetAtStart: function (libraries) {
			for (var i = 0; i < libraries.length; i++) {
				var ruleSet = libraries[i];

				if (ruleSet.title === constants.TEMP_RULESETS_NAME) {
					var temp = ruleSet;
					libraries.splice(i, 1);
					libraries.unshift(temp);
					return;
				}
			}
		},
		addLinkToRule: function (event) {
			var tempLink = this.model.getProperty("/tempLink"),
				copy = jQuery.extend(true, {}, tempLink),
				action = event.getSource().getProperty("text"),
				rule = action === 'Add' ? "/newRule" : "/editRule",
				urlProperty = this.model.getProperty(rule + "/resolutionurls");

			if (urlProperty) {
				urlProperty.push(copy);
			} else {
				this.model.setProperty(rule + "/resolutionurls", "");
				urlProperty.push(copy);
			}

			this.model.setProperty("/tempLink", { href: "", text: "" });

			this.model.checkUpdate(true, true);
		},
		goToCreateRule: function () {
			var navCont = this.getView().byId("rulesNavContainer");
			navCont.to(this.getView().byId("rulesCreatePage"), "show");
		},
		checkFunctionString: function (functionString) {
			try {
				/* eslint-disable no-eval */
				eval("var testAsignedVar = " + functionString);
				/* eslint-enable no-eval */
			} catch (err) {
				MessageToast.show("Your check function contains errors, and can't be evaluated:" + err);
				return false;
			}
			return true;
		},
		addNewRule: function () {
			var newRule = this.model.getProperty("/newRule");
			if (this.checkFunctionString(newRule.check)) {
				this.showRuleCreatedToast = true;
				CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE, RuleSerializer.serialize(newRule));
			}
		},
		rulesToolbarITHSelect: function (oEvent) {
			if (oEvent.getParameter("key") === "jsonOutput") {
				var newRule = this.model.getProperty("/newRule"),
					stringifiedJson = this.createRuleString(newRule);
				this.model.setProperty("/newRuleStringified", stringifiedJson);
			}
		},
		rulesToolbarEditITHSelect: function (oEvent) {
			if (oEvent.getParameter("key") === "jsonOutput") {
				var newRule = this.model.getProperty("/editRule"),
					stringifiedJson = this.createRuleString(newRule);
				this.model.setProperty("/updateRuleStringified", stringifiedJson);
			}
		},
		loadMarkedSupportLibraries: function () {
			var list = this.getView().byId("availableLibrariesSet"),
				libNames = list.getSelectedItems().map(function (item) {
					return item.getTitle();
				});

			list.getItems().forEach(function (item) {
				item.setSelected(false);

			});

			if (libNames.length > 0) {
				this.loadingFromLoadButton = true;
				CommunicationBus.publish(channelNames.LOAD_RULESETS, {
					libNames: libNames
				});
				this.model.setProperty("/loadingAdditionalRuleSets", true);
			}
		},
		onCellClick: function(event){
			if (event.getParameter("rowBindingContext")) {
				var selection = event.getParameter("rowBindingContext").getObject(),
					selectedRule;

				if (selection.id) {
					selectedRule = this.getMainModelFromTreeViewModel(selection);
					var stringifiedJson = this.createRuleString(selectedRule);
					this.model.setProperty("/selectedRuleStringify", stringifiedJson);
				}
				this.model.setProperty("/selectedRule", selectedRule);
			}

		},
	getMainModelFromTreeViewModel: function(selectedRule) {

		var structeredRulesModel =  this.model.getProperty("/libraries"),
			mainModelRule = null;

		structeredRulesModel.forEach(function(lib, index){
				structeredRulesModel[index].rules.forEach(function(element){
					if (selectedRule.id === element.id) {
						mainModelRule = element;
					}
				});
		});

		return mainModelRule;
	},

	duplicateRule: function(event){
		var path =  event.getSource().getBindingContext().getPath(),
			sourceObject = this.getView().getModel().getProperty(path),
			selectedRule = this.getMainModelFromTreeViewModel(sourceObject),
			selectedRuleCopy = jQuery.extend(true, {}, selectedRule);

		this.model.setProperty("/newRule", selectedRuleCopy);
		this.model.checkUpdate(true, false);
		this.goToCreateRule();
	},

	editRule: function(event) {
		var path =  event.getSource().getBindingContext().getPath(),
			sourceObject = this.getView().getModel().getProperty(path),
			selectedRule = this.getMainModelFromTreeViewModel(sourceObject);

		this.model.setProperty("/editRuleSource", selectedRule);
		this.model.setProperty("/editRule", jQuery.extend(true, {}, selectedRule));
		this.model.checkUpdate(true, true);
		var navCont = this.getView().byId("rulesNavContainer");
		navCont.to(this.getView().byId("ruleUpdatePage"), "show");
	},
	deleteTemporaryRule: function(event) {
		var sourceObject = this.getObjectOnTreeRow(event),
			treeViewModel = this.model.getProperty("/treeViewModel"),
			mainModel = this.model.getProperty("/libraries"),
			rulesNotToBeDeleted = [];


		mainModel.forEach(function (lib, libIndex) {
			if (lib.title === constants.TEMP_RULESETS_NAME) {
				lib.rules.forEach(function (rule, ruleIndex) {
					if (rule.id === sourceObject.id) {
						lib.rules.splice(ruleIndex, 1);
						return;
					} else {
						rulesNotToBeDeleted.push(rule);
					}
				});
			}
		});

		for (var i in treeViewModel) {
			if (treeViewModel[i].name === constants.TEMP_RULESETS_NAME) {
				for (var innerIndex in treeViewModel[i]) {
					if (treeViewModel[i][innerIndex].id === sourceObject.id) {
						delete treeViewModel[i][innerIndex];
					}
				}
			}
		}
		this.model.setProperty("/treeViewModel", treeViewModel);
		storage.removeSelectedRules(rulesNotToBeDeleted);
	},
	/**
	* Gets rule from selected row
	* @param {Object} Event
	* @returns {Object} ISelected rule from row
	***/
	getObjectOnTreeRow: function(event) {
		var path =  event.getSource().getBindingContext().getPath(),
		 sourceObject = this.getView().getModel().getProperty(path),
		 libs = this.model.getProperty("/libraries");

		libs.forEach(function (lib, libIndex) {
			lib.rules.forEach(function (rule) {
				if (rule.id === sourceObject.id) {
					sourceObject.check = rule.check;
				}
			});
		});
		return sourceObject;
	}
	});
});

}; // end of sap/ui/support/supportRules/ui/controllers/Analysis.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.controllers.Issues.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.controllers.Issues.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/controllers/Issues.controller",[
	"jquery.sap.global",
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/ui/models/SharedModel",
	"sap/ui/support/supportRules/ui/external/ElementTree",
	"sap/ui/support/supportRules/IssueManager",
	"sap/ui/support/supportRules/WCBChannels",
	"sap/ui/support/supportRules/ui/models/formatter",
	"sap/ui/support/supportRules/Constants"
], function ($, Controller, JSONModel, CommunicationBus, SharedModel, ElementTree, IssueManager, channelNames, formatter, constants) {
	"use strict";

	var mIssueSettings = {
		severityIcons: {
			High: "sap-icon://message-error",
			Medium: "sap-icon://message-warning",
			Low: "sap-icon://message-information",
			All: "sap-icon://multiselect-all"
		}
	};

	return Controller.extend("sap.ui.support.supportRules.ui.controllers.Issues", {
		ISSUES_LIMIT : 1000,
		formatter: formatter,
		onInit: function () {

			this.model = SharedModel;
			this.setCommunicationSubscriptions();
			this.getView().setModel(this.model);
			this.clearFilters();
			this._initElementTree();
			this.treeTable = this.getView().byId("issuesList");
			this.issueTable = this.getView().byId("issueTable");
		},
		setCommunicationSubscriptions: function () {

			CommunicationBus.subscribe(channelNames.ON_ANALYZE_FINISH, function (data) {
				var that = this;

				var problematicControlsIds = {};

				// Contains a list of all issues found during analisys.
				// The list is used later when filters are modified.
				that.data = data;

				data.issues.forEach(function (issue) {
					if (!issue.context || !issue.context.id) {
						return;
					}

					if (!problematicControlsIds[issue.context.id]) {
						problematicControlsIds[issue.context.id] = [issue.name];
					} else {
						problematicControlsIds[issue.context.id].push(issue.name);
					}

				});
				this.model.setSizeLimit(this.ISSUES_LIMIT);
				this.model.setProperty("/issues", data.issues);
				this.model.setProperty('/analyzePressed', true);
				this.model.setProperty("/issuesCount", this.data.issues.length);
				this.model.setProperty("/selectedIssue", "");
				this.elementTree.setData({
					controls: data.elementTree,
					issuesIds: problematicControlsIds
				});

				this.clearFilters();
			}, this);
			CommunicationBus.subscribe(channelNames.GET_ISSUES, function (data) {
				this.structuredIssuesModel = data.groupedIssues;
				this.model.setProperty("/issues", data.issuesModel);
				if (data.issuesModel[0]) {
					this._setSelectedRule(data.issuesModel[0][0]);
					this.treeTable.setSelectedIndex(1);
					this.issueTable.setSelectedIndex(0);
				}
			}, this);
		},
		_initElementTree: function () {
			var that = this;

			this.elementTree = new ElementTree(null, {
				onIssueCountClicked: function (selectedElementId) {
					that.clearFilters();
					that.model.setProperty("/elementFilter", selectedElementId);
					that.updateIssuesVisibility();
				},
				onHoverChanged: function (hoveredElementId) {
					CommunicationBus.publish(channelNames.TREE_ELEMENT_MOUSE_ENTER, hoveredElementId);
				},
				onMouseOut: function () {
					CommunicationBus.publish(channelNames.TREE_ELEMENT_MOUSE_OUT);
				}
			});
		},
		onAfterRendering: function () {
			this.elementTree.setContainerId(this.getView().byId("elementTreeContainer").getId());
		},
		clearFilters: function () {
			this.model.setProperty("/severityFilter", "All");
			this.model.setProperty("/categoryFilter", "All");
			this.model.setProperty("/elementFilter", "All");
			this.model.setProperty("/audienceFilter", "All");

			if (this.data) {
				this.model.setProperty("/issues", this.data.issues);
				this.setToolbarHeight();
			}

			this.updateIssuesVisibility();
		},
		clearFiltersAndElementSelection: function () {
			this.clearFilters();
			this.elementTree.clearSelection();
		},
		onIssuePressed: function (event) {
			var selectedIssue = this.model.getProperty("/selectedIssue");
			this.elementTree.setSelectedElement(selectedIssue.context.id, false);
		},
		onRowSelectionChanged: function (event) {
			if (event.getParameter("rowContext")) {
				var selection = event.getParameter("rowContext").getObject();
				if (selection.type === "rule") {
					this._setSelectedRule(selection);
				} else {
					this.model.setProperty("/selectedIssue", "");
				}
				if (selection.issueCount < 4 ) {
					this._setPropertiesOfResponsiveDetailsAndTable("Fixed", "inherit");
					this.model.setProperty("/visibleRowCount", 4);

				} else {
					this._setPropertiesOfResponsiveDetailsAndTable("Auto", "5rem");
				}
			}

		},
		openDocumentation: function (oEvent) {
			var link = sap.ui.getCore().byId(oEvent.mParameters.id),
				url = link.getBindingContext().getProperty("href");
			CommunicationBus.publish(channelNames.OPEN_URL, url);
		},
		updateIssuesVisibility: function () {
			if (this.data) {
				var filteredIssues = this.data.issues.filter(this.filterIssueListItems, this);
				CommunicationBus.publish(channelNames.REQUEST_ISSUES, filteredIssues);
				this.model.setProperty("/visibleIssuesCount", filteredIssues.length);
			}

			this.setToolbarHeight();
		},
		filterIssueListItems: function (issue) {
			var sevFilter = this.model.getProperty("/severityFilter"),
				sevFilterApplied = issue.severity === sevFilter || sevFilter === 'All',
				catFilter = this.model.getProperty("/categoryFilter"),
				catFilterApplied = $.inArray( catFilter, issue.categories ) > -1 || catFilter === 'All',
				elementFilter = this.model.getProperty("/elementFilter"),
				elementFilterApplied =  elementFilter ===  issue.context.id || elementFilter === 'All',
				audFilter = this.model.getProperty("/audienceFilter"),
				audienseFilterApplied =  $.inArray( audFilter, issue.audiences ) > -1 || audFilter === 'All';

			return sevFilterApplied && catFilterApplied && elementFilterApplied && audienseFilterApplied;
		},
		setToolbarHeight: function() {
				this.model.setProperty("/filterBarHeight", "4rem");
		},
		onReportPress: function(oEvent) {
				var oItem = oEvent.getParameter("item"),
					actionToTake = oItem.getText(),
					data = this._getReportData();
				if (actionToTake === 'View') {
					CommunicationBus.publish(channelNames.ON_SHOW_REPORT_REQUEST, data);
				} else {
					CommunicationBus.publish(channelNames.ON_DOWNLOAD_REPORT_REQUEST, data);
				}
		},
		_getReportData: function () {
			return {
				executionScopes: this.model.getProperty("/executionScopes"),
				executionScopeTitle: this.model.getProperty("/executionScopeTitle"),
				analysisDurationTitle: this.model.getProperty("/analysisDurationTitle")
			};
		},
		onRowSelection: function(event) {
			if (event.getParameter("rowContext")) {
				var selection = event.getParameter("rowContext").getObject();
				this.elementTree.setSelectedElement(selection.context.id, false);
				this.model.setProperty("/selectedIssue/details", selection.details);
			}
		},
		_setSelectedRule: function(selection){
			var selectedIssues,
				selectionCopy;
			if (this.model.getProperty("/visibleIssuesCount") > 0) {
				selectedIssues = this.structuredIssuesModel[selection.ruleLibName][selection.ruleId];
				selectionCopy = jQuery.extend(true, {}, selection); // clone the model so that the TreeTable will not be affected
				selectionCopy.issues = selectedIssues;
				selectionCopy.resolutionUrls = selectedIssues[0].resolutionUrls;
				this.issueTable.setSelectedIndex(0);
				this.model.setProperty("/selectedIssue/details", selectionCopy.details);
				this.model.setProperty("/selectedIssue", selectionCopy);
				this._setIconAndColorToIssue(selectionCopy.issues);
			} else {
			this.model.setProperty("/selectedIssue", "");
			}
		},

		/**
		 * Set to model icon and color depending on severity.
		 * @private
		 * @param {array} aIssues
		 * @returns {void}
		 */
		_setIconAndColorToIssue: function(aIssues) {
			aIssues.forEach(function(element){
				switch (element.severity) {
					case constants.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:
						element.severityIcon = mIssueSettings.severityIcons.Low;
						element.severityColor = constants.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR;
						break;
					case constants.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:
						element.severityIcon = mIssueSettings.severityIcons.Medium;
						element.severityColor = constants.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR;
						break;
					case constants.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:
						element.severityIcon = mIssueSettings.severityIcons.High;
						element.severityColor = constants.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR;
						break;
				}
			});
		},

		_setPropertiesOfResponsiveDetailsAndTable: function(visibleRowCountMode, heightDetailsArea){
			this.model.setProperty("/visibleRowCountMode", visibleRowCountMode);
			this.model.setProperty("/heightDetailsArea", heightDetailsArea);
		}
	});
});

}; // end of sap/ui/support/supportRules/ui/controllers/Issues.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.controllers.Main.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.controllers.Main.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.URI'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/controllers/Main.controller",[
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/ui/models/SharedModel",
	"sap/ui/support/supportRules/WCBChannels",
	"sap/ui/support/supportRules/Constants",
	"sap/ui/support/supportRules/Storage",
	"sap/ui/thirdparty/URI"
], function (Controller, JSONModel, CommunicationBus, SharedModel, channelNames, constants, storage, URI) {
	"use strict";

	return Controller.extend("sap.ui.support.supportRules.ui.controllers.Main", {
		onInit: function () {
			this.model = SharedModel;
			this.getView().setModel(this.model);
			this.resizeDown();
			this.setCommunicationSubscriptions();
			this.initSettingsPopover();
			this.hidden = false;
			this.model.setProperty("/hasNoOpener", window.opener ? false : true);
			this.model.setProperty("/constants", constants);
			this.updateShowButton();
			this._setContextSettings();

		},

		onAfterRendering: function () {
			CommunicationBus.publish(channelNames.POST_UI_INFORMATION, {
				version: sap.ui.getVersionInfo(),
				location: new URI(jQuery.sap.getModulePath("sap.ui.support"), window.location.origin + window.location.pathname).toString()
			});
		},

		initSettingsPopover: function () {
			var supportAssistantOrigin = new URI(sap.ui.resource('sap.ui.support', ''), window.location.origin + window.location.pathname)._string,
				supportAssistantVersion = sap.ui.version;

			this.model.setProperty("/supportAssistantOrigin", supportAssistantOrigin);
			this.model.setProperty("/supportAssistantVersion", supportAssistantVersion);
			this._settingsPopover = sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.StorageSettings", this);
			this._settingsPopover.setModel(SharedModel);
			this.getView().addDependent(this._oPopover);
		},

		copySupportAssistantOriginToClipboard: function(oEvent) {
			var supportAssistantOrigin = this.model.getProperty("/supportAssistantOrigin"),
				copyToClipboardEventHandler = function(oEvent) {
					if (oEvent.clipboardData) {
						oEvent.clipboardData.setData('text/plain', supportAssistantOrigin);
					} else {
						oEvent.originalEvent.clipboardData.setData('text/plain', supportAssistantOrigin);
					}
					oEvent.preventDefault();
				};

			if (window.clipboardData) {
				window.clipboardData.setData("text", supportAssistantOrigin);
			} else {
				document.addEventListener('copy', copyToClipboardEventHandler);
				document.execCommand('copy');
				document.removeEventListener('copy', copyToClipboardEventHandler);
			}
		},

		setCommunicationSubscriptions: function () {
			CommunicationBus.subscribe(channelNames.ON_ANALYZE_FINISH, function (data) {
				this._clearProcessIndicator();
				this.ensureOpened();
				this.model.setProperty("/showProgressIndicator", false);
				this.model.setProperty("/coreStateChanged", false);
				this.model.setProperty("/lastAnalysisElapsedTime", data.elapsedTime);
				this.goToIssues();
				this.model.setProperty("/analyzedFinish", true);
			}, this);

			CommunicationBus.subscribe(channelNames.ON_PROGRESS_UPDATE, function (data) {
				var currentProgress = data.currentProgress,
					pi = this.getView().byId("progressIndicator");

				pi.setDisplayValue(currentProgress + "/" + 100);
				this.model.setProperty("/progress", currentProgress);
			}, this);

			CommunicationBus.subscribe(channelNames.ON_CORE_STATE_CHANGE, function () {
				this.model.setProperty("/coreStateChanged", true);
			}, this);
		},

		resizeUp: function () {
			CommunicationBus.publish(channelNames.RESIZE_FRAME, {bigger: true});
		},

		ensureOpened: function () {
			CommunicationBus.publish(channelNames.ENSURE_FRAME_OPENED);
		},

		resizeDown: function () {
			CommunicationBus.publish(channelNames.RESIZE_FRAME, {bigger: false});
		},

		onPersistedSettingSelect: function() {
			if (this.model.getProperty("/persistingSettings")) {
				storage.createPersistenceCookie(constants.COOKIE_NAME, true);

				this.model.getProperty("/libraries").forEach(function (lib) {
					if (lib.title == constants.TEMP_RULESETS_NAME) {
							storage.setRules(lib.rules);
						}
				});
				this.persistExecutionScope();

			} else {
				storage.deletePersistenceCookie(constants.COOKIE_NAME);
				this.deletePersistedData();
			}
		},
		onSettings: function (oEvent) {
			CommunicationBus.publish(channelNames.ENSURE_FRAME_OPENED);

			var that = this,
				source = oEvent.getSource();
			setTimeout(function() {
				that._settingsPopover.openBy(source);
			}, 0);
		},
		goToAnalysis: function (evt) {
			var navCon = this.getView().byId("navCon");
			navCon.to(this.getView().byId("analysis"), "show");
			this.ensureOpened();
		},
		goToIssues: function () {
			var navCon = this.getView().byId("navCon");
			navCon.to(this.getView().byId("issues"), "show");
			this.ensureOpened();
		},

		goToWiki: function () {
			var url,
				version = "",
				fullVersion = sap.ui.getVersionInfo().version,
				majorVersion = jQuery.sap.Version(fullVersion).getMajor(),
				minorVersion = jQuery.sap.Version(fullVersion).getMinor();

			if (minorVersion % 2 !== 0) {
				minorVersion--;
			}

			version += String(majorVersion) + String(minorVersion);
			// TODO: add right path to supprot assitan section when documentation is publicly released (1.48).
			url = "https://help.sap.com/viewer/DRAFT/OpenUI5_" + version + "/615d9e4aaa34447fbd4aa5f19dfde9b8.html";
			window.open(url, '_blank');
		},

		setRulesLabel: function (libs) {
			var selectedCounter = 0;
			if (libs === null) {
				return "Rules (" + selectedCounter + ")";
			} else {
				libs.forEach(function (lib, libIndex) {
					selectedCounter += lib.rules.length;
				});
				return "Rules (" + selectedCounter + ")";
			}
		},

		updateShowButton: function () {
			// When hidden is true - the frame is minimized and we show the "show" button
			this.getView().byId("sapSTShowButtonBar").setVisible(this.hidden);
		},

		toggleHide: function () {
			this.hidden = !this.hidden;
			this.updateShowButton();

			CommunicationBus.publish(channelNames.TOGGLE_FRAME_HIDDEN, this.hidden);
		},

		persistExecutionScope: function() {
			var setting = {
				analyzeContext: this.model.getProperty("/analyzeContext"),
				subtreeExecutionContextId: this.model.getProperty("/subtreeExecutionContextId")
			},
			scopeComponent = this.model.getProperty("/executionScopeComponents");

			storage.setSelectedScopeComponents(scopeComponent);
			storage.setSelectedContext(setting);
		},

		deletePersistedData: function() {
			storage.deletePersistenceCookie(constants.COOKIE_NAME);
			this.model.setProperty("/persistingSettings", false);
			storage.removeAllData();
		},

		_clearProcessIndicator: function() {
			var pi = this.getView().byId("progressIndicator");
			pi.setDisplayValue("None");
			this.model.setProperty("/progress", 0.1);
		},

		_setContextSettings:function() {
			var cookie = storage.readPersistenceCookie(constants.COOKIE_NAME);
			if (cookie) {
				this.model.setProperty("/persistingSettings", true);
				var contextSettings = storage.getSelectedContext();

				if (contextSettings) {
					this.model.setProperty("/analyzeContext", contextSettings.analyzeContext);
					this.model.setProperty("/subtreeExecutionContextId", contextSettings.subtreeExecutionContextId);
				}else {
					this.model.setProperty("/analyzeContext", this.model.getProperty("/analyzeContext"));
					this.model.setProperty("/subtreeExecutionContextId", "");
				}
			}
		}
	});
});

}; // end of sap/ui/support/supportRules/ui/controllers/Main.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.Main') ) {
/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
/**
* @typedef {object} Event Certain event that's fired by the user action in the browser
*/
jQuery.sap.declare('sap.ui.support.supportRules.Main'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/Main",[
	"jquery.sap.global",
	"sap/ui/base/ManagedObject",
	"sap/ui/model/json/JSONModel",
	"sap/ui/support/supportRules/Analyzer",
	"sap/ui/support/supportRules/CoreFacade",
	"sap/ui/support/supportRules/ExecutionScope",
	"sap/ui/support/supportRules/ui/external/Highlighter",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/RuleSerializer",
	"sap/ui/support/supportRules/RuleSet",
	"sap/ui/support/supportRules/IssueManager",
	"sap/ui/support/supportRules/report/DataCollector",
	"sap/ui/support/supportRules/WCBChannels",
	"sap/ui/support/supportRules/Constants"
],
function (jQuery, ManagedObject, JSONModel, Analyzer, CoreFacade,
		  ExecutionScope, Highlighter, CommunicationBus, RuleSerializer,
		  RuleSet, IssueManager, DataCollector, channelNames, constants) {
	"use strict";

	var IFrameController = null;
	var oMain = null;
	var customSuffix = 'sprt';

	var Main = ManagedObject.extend("sap.ui.support.Main", {

		/**
		 * @classdesc
		 * <h3>Overview</h3>
		 * Controller for the support tools.
		 * Provides integration with respective data services.
		 * @class sap.ui.support.Main
		 */
		constructor: function () {
			if (!oMain) {
				var that = this;
				this._oCore = null;
				this._rulesCreated = false;
				this._mRuleSets = {};
				this._oAnalyzer = new Analyzer();
				this._oAnalyzer.onNotifyProgress = function (iCurrentProgress) {
					CommunicationBus.publish(channelNames.ON_PROGRESS_UPDATE, {
						currentProgress: iCurrentProgress
					});
				};

				that._initTempRulesLib();

				ManagedObject.apply(this, arguments);

				jQuery.sap.support = {

					/**
					 * Analyzes all rules in the given execution scope.
					 *
					 * @memberof sap.ui.support
					 * @public
					 * @param {Object} oExecutionScope The execution scope of the analysis with the type of the scope
					 * @param {Object[]} aRuleDescriptors An array with rules against which the analysis will be run
					 * @returns {Promise} Notifies the finished state by starting the Analyzer
					 */
					analyze: function (oExecutionScope, aRuleDescriptors) {
						if (oMain._rulesCreated) {
							return oMain.analyze(oExecutionScope, aRuleDescriptors);
						}

						return oMain._oMainPromise.then(function () {
							return oMain.analyze(oExecutionScope, aRuleDescriptors);
						});
					},
					/**
					 * Gets last analysis history.
					 * @memberof sap.ui.support
					 * @public
					 * @returns {Object} Last analysis history.
					 */
					getLastAnalysisHistory: function () {
						var aHistory = this.getAnalysisHistory();

						if (jQuery.isArray(aHistory) && aHistory.length > 0) {
							return aHistory[aHistory.length - 1];
						} else {
							return null;
						}
					},
					/**
					 * Gets history.
					 *
					 * @memberof sap.ui.support
					 * @public
					 * @returns {Object[]} Current history.
					 */
					getAnalysisHistory: function () {
						if (that._oAnalyzer.running()) {
							return null;
						}

						return IssueManager.getHistory();
					},
					/**
					 * Gets formatted history.
					 *
					 * @memberof sap.ui.support
					 * @public
					 * @method
					 * @name sap.ui.support.Main.getFormattedAnalysisHistory
					 * @memberof sap.ui.support.Main
					 * @returns {Promise} Analyzed and formatted history as string
					 */
					getFormattedAnalysisHistory: function () {
						if (that._oAnalyzer.running()) {
							return;
						}

						// Lazily, asynchronously load the IssueFormatter
						return new Promise(
							function (resolve, reject) {
								sap.ui.require(["sap/ui/support/supportRules/report/AnalysisHistoryFormatter"], function (AnalysisHistoryFormatter) {
									resolve(AnalysisHistoryFormatter.format(IssueManager.getConvertedHistory()));
								});
							}
						);
					}
				};

				var evt = document.createEvent("CustomEvent");
				evt.initCustomEvent("supportToolLoaded", true, true, {});
			} else {
				jQuery.sap.log.warning("Only one support tool allowed");

				return oMain;
			}
		}
	});

	/**
	 * Checks if the current page is inside an iFrame.
	 *
	 * @private
	 * @return {boolean}
	 */
	Main.prototype._isInIframe = function () {
		try {
			return window.self !== window.top;
		} catch (e) {
			// Access to window.top might be blocked if so the page is inside an iframe.
			return true;
		}
	};

	/**
	 * This controller is started by the core as a plugin.
	 *
	 * @private
	 * @param {Object[]} aSupportModeConfig Configuration for the SupportAssistant when it's launched.
	 */
	Main.prototype.startPlugin = function (aSupportModeConfig) {
		if (this._pluginStarted) {
			return;
		}

		this._pluginStarted = true;

		var that = this;

		sap.ui.getCore().registerPlugin({
			startPlugin: function (oCore) {
				that._supportModeConfig = aSupportModeConfig = aSupportModeConfig || oCore.getConfiguration().getSupportMode();
				that._setCommunicationSubscriptions();

				// If the current page is inside of an iframe don't start the Support tool.
				// Otherwise if there are any iframes inside a page, all of them
				// will have the Support tool started along with the parent page.
				var bForceUIInFrame = that._isInIframe() && aSupportModeConfig.indexOf("frame-force-ui") !== -1;

				that._oCore = oCore;
				that._oDataCollector = new DataCollector(oCore);
				that._oCoreFacade = CoreFacade(oCore);
				that._oExecutionScope = null;
				that._createCoreSpies();
				oCore.attachLibraryChanged(that._onLibraryChanged, that);

				// Make sure that we load UI frame, when no parameter supplied
				// but tools is required to load, or when parameter is there
				// but is not equal to 'silent'
				if (!aSupportModeConfig ||
					aSupportModeConfig.indexOf("silent") === -1 ||
					bForceUIInFrame) {
					// Lazily, asynchronously load the frame controller
					sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"], function (IFrameCtrl) {
						IFrameController = IFrameCtrl;

						IFrameController.injectFrame(aSupportModeConfig);

						// Validate messages
						CommunicationBus.onMessageChecks.push(function (msg) {
							return msg.origin === IFrameController.getFrameOrigin();
						});

						CommunicationBus.onMessageChecks.push(function (msg) {
							return msg.data._frameIdentifier === IFrameController.getFrameIdentifier();
						});

						CommunicationBus.onMessageChecks.push(function (msg) {
							var frameUrl = IFrameController.getFrameUrl();
							// remove relative path information
							frameUrl = frameUrl.replace(/\.\.\//g, '');
							return msg.data._origin.indexOf(frameUrl) > -1;
						});
					});
				} else {
					that._oMainPromise = that._fetchSupportRuleSets();
				}
			},
			stopPlugin: function () {
				IFrameController._stop();
				that._pluginStarted = false;
				that._oCore = null;
				that._oCoreFacade = null;
				that._oDataCollector = null;
				that._oExecutionScope = null;
				that._rulesCreated = false;
				that._mRuleSets = null;
			}
		});
	};

	/**
	 * Event handler used to catch when new rules are added to a library.
	 * @private
	 * @param {Event} oEvent Contains information about the library and newly created rules
	 */
	Main.prototype._onLibraryChanged = function (oEvent) {
		if (oEvent.getParameter("stereotype") === "library" && this._rulesCreated) {
			var that = this;

			that._oMainPromise = this._fetchSupportRuleSets();

			that._oMainPromise.then(function() {
				that._fetchNonLoadedRuleSets();
			});
		}
	};

	/**
	 * Creates event listeners for new elements that are published to the Core object by the CommunicationBus.
	 *
	 * @private
	 */
	Main.prototype._createCoreSpies = function () {
		var that = this,
			iNotifyDirtyStateInterval = 500;

		this._fnDirtyTimeoutHandle = null;

		var spyFunction = function (fnName) {

			var oldFunction = that._oCore[fnName];

			that._oCore[fnName] = function () {
				oldFunction.apply(that._oCore, arguments);

				/**
				 * If we have 50 new elements in the core, don't send 50 new messages for
				 * dirty state instead wait 500ms and send one message.
				 */
				clearTimeout(that._fnDirtyTimeoutHandle);

				that._fnDirtyTimeoutHandle = setTimeout(function () {
					CommunicationBus.publish(channelNames.ON_CORE_STATE_CHANGE);
				}, iNotifyDirtyStateInterval);
			};
		};

		spyFunction("registerElement");
		spyFunction("deregisterElement");
	};

	/**
	 * Sets subscriptions to the CommunicationBus for temporary rules.
	 *
	 * @private
	 */
	Main.prototype._setCommunicationSubscriptions = function () {
		// If configuration contains 'silent' there must be no subscription
		// for temporary rules
		if (this._supportModeConfig.indexOf("silent") < 0) {

			CommunicationBus.subscribe(channelNames.VERIFY_CREATE_RULE, function (tempRuleSerialized) {

				var tempRule = RuleSerializer.deserialize(tempRuleSerialized),
					tempRuleSet = this._mRuleSets[constants.TEMP_RULESETS_NAME].ruleset,
					result = tempRuleSet.addRule(tempRule);

				CommunicationBus.publish(channelNames.VERIFY_RULE_CREATE_RESULT, {
					result: result,
					newRule: RuleSerializer.serialize(tempRule)
				});

			}, this);

			CommunicationBus.subscribe(channelNames.VERIFY_UPDATE_RULE, function (data) {

				var tempRule = RuleSerializer.deserialize(data.updateObj),
					tempRuleSet = this._mRuleSets[constants.TEMP_RULESETS_NAME].ruleset,
					result = tempRuleSet.updateRule(data.oldId, tempRule);

				CommunicationBus.publish(channelNames.VERIFY_RULE_UPDATE_RESULT, {
					result: result,
					updateRule: RuleSerializer.serialize(tempRule)
				});

			}, this);

			CommunicationBus.subscribe(channelNames.OPEN_URL, function (url) {
				var win = window.open(url, "_blank");
				win.focus();
			}, this);

			CommunicationBus.subscribe(channelNames.ON_DOWNLOAD_REPORT_REQUEST, function (reportConstants) {
				var data = this._getReportData(reportConstants);
				sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"], function (ReportProvider) {
					ReportProvider.downloadReportZip(data);
				});
			}, this);

			CommunicationBus.subscribe(channelNames.HIGHLIGHT_ELEMENT, function (id) {
				var $domElem = sap.ui.getCore().byId(id).$();
				$domElem.css("background-color", "red");
			}, this);

			CommunicationBus.subscribe(channelNames.TREE_ELEMENT_MOUSE_ENTER, function (elementId) {
				Highlighter.highlight(elementId);
			}, this);

			CommunicationBus.subscribe(channelNames.TREE_ELEMENT_MOUSE_OUT, function () {
				Highlighter.hideHighLighter();
			}, this);

			CommunicationBus.subscribe(channelNames.TOGGLE_FRAME_HIDDEN, function (hidden) {
				IFrameController.toggleHide(hidden);
			}, this);
		}

		CommunicationBus.subscribe(channelNames.POST_UI_INFORMATION, function (data) {
			this._oDataCollector.setSupportAssistantLocation(data.location);
			this._oDataCollector.setSupportAssistantVersion(data.version);
		}, this);

		CommunicationBus.subscribe(channelNames.GET_AVAILABLE_COMPONENTS, function () {
			CommunicationBus.publish(channelNames.POST_AVAILABLE_COMPONENTS, Object.keys(this._oCore.mObjects.component));
		}, this);

		CommunicationBus.subscribe(channelNames.ON_ANALYZE_REQUEST, function (data) {
			this.analyze(data.executionContext, data.selectedRules);
		}, this);

		CommunicationBus.subscribe(channelNames.ON_INIT_ANALYSIS_CTRL, function () {
			var that = this;

			this._oMainPromise = this._fetchSupportRuleSets();

			this._oMainPromise.then(function () {
				that._fetchNonLoadedRuleSets();
			});
		}, this);

		CommunicationBus.subscribe(channelNames.ON_SHOW_REPORT_REQUEST, function (reportConstants) {
			var data = this._getReportData(reportConstants);
			sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"], function (ReportProvider) {
				ReportProvider.openReport(data);
			});
		}, this);

		CommunicationBus.subscribe(channelNames.LOAD_RULESETS, function (data) {
			var that = this;

			this._oMainPromise = this._fetchSupportRuleSets(data.libNames);

			this._oMainPromise.then(function () {
				that._fetchNonLoadedRuleSets();
			});
		}, this);

		CommunicationBus.subscribe(channelNames.REQUEST_RULES_MODEL, function (deserializedRules) {
			if (deserializedRules) {
				CommunicationBus.publish(channelNames.GET_RULES_MODEL, IssueManager.getTreeTableViewModel(deserializedRules));
			}
		}, this);

		CommunicationBus.subscribe(channelNames.REQUEST_ISSUES, function (issues) {
			if (issues) {
				var groupedIssues = IssueManager.groupIssues(issues),
					issuesModel = IssueManager.getIssuesViewModel(groupedIssues);

				CommunicationBus.publish(channelNames.GET_ISSUES, {
					groupedIssues: groupedIssues,
					issuesModel: issuesModel
				});
			}
		}, this);
	};

	/**
	 * Gets the load origin of the SupportAssistant.
	 *
	 * @private
	 * @returns {boolean} bLoadFromSupportOrigin Ensures that the SupportAssistant hasn't been fired from a different origin
	 */
	Main.prototype._getLoadFromSupportOrigin = function () {
		var bLoadFromSupportOrigin = false;

		var coreUri = new window.URI(jQuery.sap.getModulePath("sap.ui.core"));
		var supportUri = new window.URI(jQuery.sap.getModulePath("sap.ui.support"));

		// If loading support tool from different origin,
		// i.e. protocol or host (host name + port) different
		if (coreUri.protocol() !== supportUri.protocol() || coreUri.host() !== supportUri.host()) {
			bLoadFromSupportOrigin = true;
		}

		return bLoadFromSupportOrigin;
	};

	/**
	 * Gets all libraries along with internal and external rules in them.
	 *
	 * @private
	 * @param {string[]} aLibNames Contains all library names for the given state
	 * @param {function} fnProcessFile Callback that publishes all rules within each library in the SupportAssistant
	 * @returns {Promise[]} aAjaxPromises Promises for each library in the SupportAssistant
	 */
	Main.prototype._fetchLibraryFiles = function (libNames, fnProcessFile) {
		var aAjaxPromises = [],
			that = this;

		var supportModulePath = jQuery.sap.getModulePath("sap.ui.support");
		var supportModulesRoot = supportModulePath.replace("sap/ui/support", "");

		libNames.forEach(function (libName) {
			var libPath = libName.replace(/\./g, "/");

			var customizableLibName = libName;
			var loadFromSupportOrigin = that._getLoadFromSupportOrigin();

			// Prepare modules root string
			if (loadFromSupportOrigin) {
				// In order to avoid module name collision
				// we need to generate an internal library name
				customizableLibName += '.' + customSuffix;

				jQuery.sap.registerModulePath(customizableLibName, supportModulesRoot + libName.replace(/\./g, "/"));
			}

			var internalLibName = customizableLibName + '.internal';
			var libraryInternalResourceRoot = supportModulesRoot.replace('resources/', '') + 'test-resources/' + libPath + '/internal';

			jQuery.sap.registerModulePath(internalLibName, libraryInternalResourceRoot);

			if (that._mRuleSets[libName]) {
				return;
			}

			// CHECK FOR INTERNAL RULES
			aAjaxPromises.push(new Promise(function (resolve) {
				try {
					sap.ui.require([(internalLibName).replace(/\./g, "/") + "/library.support"], function () {
						fnProcessFile(internalLibName);
						resolve();
					});
				} catch (ex) {
					resolve();
				}
			}));

			// CHECK FOR PUBLIC RULES
			aAjaxPromises.push(new Promise(function (resolve) {
				try {
					sap.ui.require([customizableLibName.replace(/\./g, "/") + "/library.support"], function () {
						fnProcessFile(customizableLibName);
						resolve();
					});
				} catch (ex) {
					resolve();
				}
			}));
		});

		return aAjaxPromises;
	};

	/**
	 * Factory function for creating a RuleSet. Helps reducing API complexity.
	 *
	 * @private
	 * @param {object} librarySupport Object to be used for RuleSet creation
	 * @returns {object} ruleset RuleSet added to _mRuleSets
	 */
	Main.prototype._createRuleSet = function (oLibrarySupport) {
		var oLib = {
			name: oLibrarySupport.name,
			niceName: oLibrarySupport.niceName
		};
		var oRuleSet = new RuleSet(oLib);

		for (var i = 0; i < oLibrarySupport.ruleset.length; i++) {
			var ruleset = oLibrarySupport.ruleset[i];

			// If the ruleset contains arrays of rules make sure we add them.
			if (jQuery.isArray(ruleset)) {
				for (var k = 0; k < ruleset.length; k++) {
					oRuleSet.addRule(ruleset[k]);
				}
			} else {
				oRuleSet.addRule(ruleset);
			}
		}

		return {
			lib: oLib,
			ruleset: oRuleSet
		};
	};

	/**
	 * Gets all rulesets from the SupportAssistant
	 *
	 * @private
	 * @param {string} aLibNames Contains all library names in the SupportAssistant
	 * @returns {Promise<CommunicationBus>} mainPromise Has promises for all libraries regarding rulesets in the SupportAssistant
	 */
	Main.prototype._fetchSupportRuleSets = function (aLibNames) {
		aLibNames = aLibNames || [];
		aLibNames = aLibNames.concat(Object.keys(sap.ui.getCore().getLoadedLibraries()));

		var that = this;

		var mainPromise = new Promise(function (resolve) {
			sap.ui.getVersionInfo({async: true}).then(function (versionInfo) {
				// VersionInfo cache
				that._versionInfo = versionInfo;
				RuleSet.versionInfo = versionInfo;

				var libFetchPromises = that._fetchLibraryFiles(aLibNames, function (libName) {
					var normalizedLibName = libName.replace("." + customSuffix, "").replace(".internal", ""),
						libSupport = jQuery.sap.getObject(libName).library.support,
						library = that._mRuleSets[normalizedLibName],
						tmpRuleset;

					if (libSupport.ruleset instanceof RuleSet) {
						if (library) {
							library.ruleset._mRules = jQuery.extend(library.ruleset._mRules, libSupport.ruleset._mRules);
						} else {
							library = libSupport;
						}
					} else {
						if (library) {
							tmpRuleset = that._createRuleSet(libSupport);
							library.ruleset._mRules = jQuery.extend(library.ruleset._mRules, tmpRuleset.ruleset._mRules);
						} else {
							library = that._createRuleSet(libSupport);
						}
					}

					that._mRuleSets[normalizedLibName] = library;
				});

				Promise.all(libFetchPromises).then(function () {
					//if (!that._rulesCreated) {
					that._rulesCreated = true;

					CommunicationBus.publish(channelNames.UPDATE_SUPPORT_RULES, RuleSerializer.serialize(that._mRuleSets));
					//}

					resolve();
				});
			});
		});

		return mainPromise;
	};

	/**
	 * Gets all non loaded libraries in the SupportAssistant which aren't loaded by the user.
	 *
	 * @private
	 */
	Main.prototype._fetchNonLoadedRuleSets = function () {
		var aLibraries = this._versionInfo.libraries,
			data = [];

		var aLibNames = aLibraries.map(function (lib) {
			return lib.name;
		});

		var libFetchPromises = this._fetchLibraryFiles(aLibNames, function (sLibraryName) {
			sLibraryName = sLibraryName.replace("." + customSuffix, "").replace(".internal", "");

			if (data.indexOf(sLibraryName) < 0) {
				data.push(sLibraryName);
			}
		});

		Promise.all(libFetchPromises).then(function () {
			CommunicationBus.publish(channelNames.POST_AVAILABLE_LIBRARIES,{
				libNames: data
			});
		});
	};

	/**
	 * Creates a library for the temporary rules.
	 * @private
	 */
	Main.prototype._initTempRulesLib = function () {
		if (this._mRuleSets[constants.TEMP_RULESETS_NAME]) {
			return;
		}

		this._mRuleSets[constants.TEMP_RULESETS_NAME] = {
			lib: {
				name: constants.TEMP_RULESETS_NAME
			},
			ruleset: new RuleSet({
				name: constants.TEMP_RULESETS_NAME
			})
		};

	};

	/**
	 * Analyzes all rules in the given execution scope.
	 *
	 * @private
	 * @param {object} oExecutionScope The scope of the analysis
	 * @param {object[]|object} aRuleDescriptors An array with rules against which the analysis will be run
	 * @returns {Promise} Notifies the finished state by starting the Analyzer
	 */
	Main.prototype.analyze = function (oExecutionScope, aRuleDescriptors) {
		var that = this;

		if (this._oAnalyzer && this._oAnalyzer.running()) {
			return;
		}

		// Validations
		if (oExecutionScope && ExecutionScope.possibleScopes.indexOf(oExecutionScope.type) === -1) {
			jQuery.sap.log.error("Invalid execution scope type. Type must be one of the following: "
				+ ExecutionScope.possibleScopes.join(", "));
			return;
		}

		// When analyze is called as an API function there is a selectors property
		// which is used to reduce complexity of the API function
		// selectors is mapped to parentId and components.
		if (oExecutionScope && oExecutionScope.selectors) {
			this._mapExecutionScope(oExecutionScope);
		}

		// Set default scope
		oExecutionScope = oExecutionScope || {type: "global"};

		this._oAnalyzer.reset();

		this.setExecutionScope(oExecutionScope);

		IssueManager.clearIssues();

		this._setSelectedRules(aRuleDescriptors);

		return this._oAnalyzer.start(this._aSelectedRules, this._oCoreFacade, this._oExecutionScope).then(function() {
			that._done();
		});

	};

	/**
	 * Sets execution scope.
	 *
	 * @private
	 * @param {object} oSettings Contains the type of execution scope
	 */
	Main.prototype.setExecutionScope = function (oSettings) {
		this._oExecutionScope = ExecutionScope(this._oCore, oSettings);
	};

	/**
	 * Sets selected rules from rules descriptors.
	 *
	 * @private
	 * @param {(array|object)} aRuleDescriptors Contains ruleDescriptors of selected rules.
	 * If no ruleDescriptors are provided all rules will be selected.
	 */
	Main.prototype._setSelectedRules = function (aRuleDescriptors) {
		this._aSelectedRules = [];
		this._oSelectedRulesIds = {};

		var that = this;

		if (aRuleDescriptors
			&& typeof aRuleDescriptors === "object"
			&& aRuleDescriptors.ruleId
			&& aRuleDescriptors.libName) {
			that._aSelectedRules.push(aRuleDescriptors);
			that._oSelectedRulesIds[aRuleDescriptors.ruleId] = true;
		} else if (Array.isArray(aRuleDescriptors)) {
			aRuleDescriptors.forEach(function (oRuleDescriptor) {
				var oLibWithRules = that._mRuleSets[oRuleDescriptor.libName],
					oSelectedRule = oLibWithRules.ruleset.getRules()[oRuleDescriptor.ruleId];
				that._aSelectedRules.push(oSelectedRule);
				that._oSelectedRulesIds[oRuleDescriptor.ruleId] = true;
			});
		} else {
			Object.keys(that._mRuleSets).map(function (sLibName) {
				var oRulesetRules = that._mRuleSets[sLibName].ruleset.getRules();

				Object.keys(oRulesetRules).map(function (sRuleId) {
					that._aSelectedRules.push(oRulesetRules[sRuleId]);
					that._oSelectedRulesIds[sRuleId] = true;
				});
			});
		}
	};

	/**
	 * Maps the execution scope <code>selectors</code> property to <code>parentId</code> and components.
	 *
	 * @private
	 * @param {object} oExecutionScope The execution scope of the analysis with the type of the scope
	 */
	Main.prototype._mapExecutionScope = function (oExecutionScope) {
		if (oExecutionScope.type === "subtree") {

			if (typeof oExecutionScope.selectors === "string") {

				oExecutionScope.parentId = oExecutionScope.selectors;

			} else if (Array.isArray(oExecutionScope.selectors)) {

				oExecutionScope.parentId = oExecutionScope.selectors[0];

			}

		} else if (oExecutionScope.type === "components") {

			if (typeof oExecutionScope.selectors === "string") {

				oExecutionScope.components = [oExecutionScope.selectors];

			} else if (Array.isArray(oExecutionScope.selectors)) {

				oExecutionScope.components = oExecutionScope.selectors;

			}

		}

		delete oExecutionScope.selectors;
	};

	/**
	 * Called after the analyzer finished and reports whether there are issues or not.
	 *
	 * @private
	 */
	Main.prototype._done = function () {
		var aIssues = IssueManager.getIssuesModel(),
			aElementTree = this._createElementTree();

		CommunicationBus.publish(channelNames.ON_ANALYZE_FINISH, {
			issues: aIssues,
			elementTree: aElementTree,
			elapsedTime: this._oAnalyzer.getElapsedTimeString()
		});

		IssueManager.saveHistory();
	};

	/**
	 * Creates element tree for the TreeTable in the Issues view.
	 *
	 * @private
	 * @returns {object} The element tree for the current view displayed in the Issues view
	 */
	Main.prototype._createElementTree = function () {
		var contextElements = this._copyElementsStructure(),
			elementTree = [];

		this._setContextElementReferences(contextElements);

		for (var i in contextElements) {
			if (contextElements[i].skip) {
				continue;
			}
			elementTree.push(contextElements[i]);
		}

		return [{
			content: elementTree,
			id: "WEBPAGE",
			name: "WEBPAGE"
		}];
	};

	/**
	 * Sets the references in the elements from the element tree.
	 *
	 * @private
	 * @param {object} oContextElements Contains all context elements from the element tree
	 */
	Main.prototype._setContextElementReferences = function (oContextElements) {
		var coreElements = this._oCore.mElements;

		for (var elementId in oContextElements) {
			var element = oContextElements[elementId],
				parent = coreElements[elementId] == undefined ? undefined : coreElements[elementId].getParent();

			if (coreElements[elementId] instanceof sap.ui.core.ComponentContainer) {
				var componentContainer = coreElements[elementId],
					componentId = componentContainer.getComponent();

				if (componentId) {
					element.content.push(oContextElements[componentId]);
					oContextElements[componentId].skip = true;
				}
			}

			if (parent) {
				var parentId = parent.getId();

				if (!oContextElements[parentId]) {
					continue;
				}

				oContextElements[parentId].content.push(oContextElements[elementId]);
				oContextElements[elementId].skip = true;
			}
		}
	};

	/**
	 * Copies element structure from the execution scope.
	 *
	 * @private
	 * @returns {object} copy Contains copied elements structure
	 */
	// TODO: the element crushing needs to be encapsulated on its own
	Main.prototype._copyElementsStructure = function () {
		var copy = {},
			that = this;

		var copyElementsFromCoreObject = function (coreObject, elemNames) {
			for (var i in coreObject) {
				if (coreObject.hasOwnProperty(i)) {
					var element = coreObject[i];
					var elementCopy = {
						content: [],
						id: element.getId(),
						name: (elemNames == undefined) ? element.getMetadata().getName() : elemNames
					};
					copy[element.getId()] = elementCopy;
				}
			}
		};

		copyElementsFromCoreObject(this._oExecutionScope.getElements());

		this._oExecutionScope.getElements().forEach(function (element) {
			if (element instanceof sap.ui.core.ComponentContainer) {
				var componentId = element.getComponent(),
					component = that._oCore.mObjects.component[componentId];
				if (component) {
					copyElementsFromCoreObject([component], "sap-ui-component");
				}
			}
		});

		// TODO: we need to make those "case"s using constants
		switch (this._oExecutionScope._getType()) {
			case "global":
				copyElementsFromCoreObject(this._oCoreFacade.getUIAreas(), "sap-ui-area");
				copyElementsFromCoreObject(this._oCoreFacade.getComponents(), "sap-ui-component");
				break;

			case "subtree":
				var parentId = this._oExecutionScope._getContext().parentId;
				copyElementsFromCoreObject([this._oCore.mElements[parentId]]);
				break;

			case "components":
				var components = this._oExecutionScope._getContext().components;
				components.forEach(function (componentId) {
					copyElementsFromCoreObject([that._oCore.mObjects.component[componentId]], "sap-ui-component");
				});
				break;
		}

		return copy;
	};

	/**
	 * Used to create a data object for the report.
	 *
	 * @private
	 * @param {object} oReportConstants Contains execution scopes and string constants used in the report and in the Support Tools UI.
	 * @returns {object} Contains all the information required to create a report
	 */
	Main.prototype._getReportData = function (oReportConstants) {
		var mIssues = IssueManager.groupIssues(IssueManager.getIssuesModel()),
			mRules = this._mRuleSets,
			mSelectedRules = this._oSelectedRulesIds;

		return {
			issues: mIssues,
			technical: this._oDataCollector.getTechInfoJSON(),
			application: this._oDataCollector.getAppInfo(),
			rules: IssueManager.getRulesViewModel(mRules, mSelectedRules, mIssues),
			scope: {
				executionScope: this._oExecutionScope,
				scopeDisplaySettings: {
					executionScopes: oReportConstants.executionScopes,
					executionScopeTitle: oReportConstants.executionScopeTitle
				}
			},
			analysisDuration: this._oAnalyzer.getElapsedTimeString(),
			analysisDurationTitle: oReportConstants.analysisDurationTitle,
			name: constants.SUPPORT_ASSISTANT_NAME
		};
	};

	var oMain = new Main();

	return oMain;

}, true);

}; // end of sap/ui/support/supportRules/Main.js
if ( !jQuery.sap.isDeclared('sap.ui.support.Bootstrap') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.support.Bootstrap.
jQuery.sap.declare('sap.ui.support.Bootstrap'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/Bootstrap",["jquery.sap.global", "./library", "sap/ui/support/supportRules/Main"],
	function (jQuery, library, Main) {
		"use strict";

	var Bootstrap = {
		initSupportRules: function (settings) {
			if (settings[0].toLowerCase() === "true" || settings[0].toLowerCase() === "silent") {
				Main.startPlugin(settings);
				/**
				 * Enables the additional logging capabilites of the logger,
				 * allowing the developers to pass custom data, that is later going to be added
				 * to the executionScope of the rules
				 */
				if ('logSupportInfo' in jQuery.sap.log) {
					jQuery.sap.log.logSupportInfo(true);
				}
			}
		}
	};

	return Bootstrap;
});

}; // end of sap/ui/support/Bootstrap.js
