/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','./TableDragAndDropExtension','jquery.sap.dom','jquery.sap.trace','jquery.sap.events'],function(q,D,C,E,I,b,F,S,c,B,d,R,e,T,f,g,h,j,k,m){"use strict";var G=e.GroupEventType,N=e.NavigationMode,n=e.SelectionMode,o=e.SelectionBehavior,p=e.SortOrder,V=e.VisibleRowCountMode;var r=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:n.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:o.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},dragDropConfig:{name:"dragDropConfig",type:"sap.ui.core.dnd.DragDropBase",multiple:true,singularName:"dragDropConfig"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});I.insertFontFaceStyle();r.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bRowAggregationInvalid=true;this._mTimeouts={};this._bHideStandardTooltips=false;this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;this._aRowHeights=[];this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];var t=this;this._performUpdateRows=function(s){if(!t.bIsDestroyed){t._lastCalledUpdateRows=Date.now();t._updateBindingContexts();if(!t._bInvalid){t._updateTableContent();t._getAccExtension().updateAccForCurrentCell(false);t._updateSelection();t._collectTableSizes();t._aRowHeights=t._collectRowHeights(false);t._updateRowHeights(t._collectRowHeights(true),true);t._updateRowHeights(t._aRowHeights,false);if(T.isVariableRowHeightEnabled(t)){t._getScrollExtension().updateInnerVerticalScrollRangeCache(t._aRowHeights);t._iRenderedFirstVisibleRow=this.getFirstVisibleRow();}t._getScrollExtension().updateVerticalScrollbarVisibility();if(T.isVariableRowHeightEnabled(t)){t._getScrollExtension().updateInnerVerticalScrollPosition(t._aRowHeights);}}t._mTimeouts.bindingTimer=undefined;t._fireRowsUpdated(s);}};this._initSelectionModel(S.MULTI_SELECTION);this._aTableHeaders=[];this._aIdxCols2Cells=[];this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;};r.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}f.enrich(this,j);f.enrich(this,k);f.enrich(this,h);f.enrich(this,g);f.enrich(this,m);this._bExtensionsInitialized=true;};r.prototype.exit=function(){this._bExitCalled=true;this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();if(this._oSelection){this._oSelection.destroy();}delete this._aTableHeaders;};r.prototype._detachExtensions=function(){f.cleanup(this);};r.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};r.prototype.onlocalizationChanged=function(a){var i=a.changes||{};var l=i.hasOwnProperty("rtl");var L=i.hasOwnProperty("language");if(l||L){this._adaptLocalization(l,L);this.invalidate();}};r.prototype._adaptLocalization=function(a,l){if(a){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){var s=this.getRows();var i;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");var t;for(i=0;i<s.length;i++){t=s[i].getAggregation("_rowAction");if(t){t._oResBundle=this._oResBundle;}}var u;for(i=0;i<s.length;i++){u=s[i].getAggregation("_settings");if(u){u._oResBundle=this._oResBundle;}}T.Menu.cleanupDataCellContextMenu(this);this._invalidateColumnMenus(true);}};r.prototype._collectRowHeights=function(H){var a=this.getDomRef();if(!a){return[];}if(H&&this.getColumnHeaderHeight()){return[];}var l=this._getDefaultRowHeight();var s=H?".sapUiTableColHdrTr":".sapUiTableTr";var t=a.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+s);var u=a.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+s);var v=this.getRows().length;var w=[];var x=D.browser.chrome&&window.devicePixelRatio!=1;for(var i=0;i<v;i++){var y=t[i]==null?0:t[i].getBoundingClientRect().height;var z=u[i]==null?0:u[i].getBoundingClientRect().height;var A=Math.max(y,z);if(x){var J=l-A;if(J>0&&J<1){w.push(Math.max(A,l-1));continue;}}w.push(Math.max(A,l));}return w;};r.prototype._resetRowHeights=function(){var a=this.getRowHeight();var s="";if(a){s=a+"px";}var l=this.getDomRef();if(l){var t=l.querySelectorAll(".sapUiTableTr");for(var i=0;i<t.length;i++){t[i].style.height=s;}}};r.prototype._resetColumnHeaderHeights=function(){if(this.getColumnHeaderHeight()){return;}var a=this.getDomRef();if(a){var l=a.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<l.length;i++){l[i].style.height=null;}}};r.prototype._determineAvailableSpace=function(){var a=this.getDomRef();if(a&&a.parentNode){var i=a.querySelector(".sapUiTableCCnt");if(i){var u=a.scrollHeight-i.clientHeight;var t=0;if(a.parentNode.firstChild!==a){var P=parseFloat(window.getComputedStyle(a.parentNode).paddingTop);if(isNaN(P)){P=0;}t=a.offsetTop-P;}u+=18;if(this._iLastAvailableSpace==null){this._iLastAvailableSpace=0;}var l=Math.floor(q(a.parentNode).height()-u-t);var A=Math.abs(l-this._iLastAvailableSpace);if(A>=5){this._iLastAvailableSpace=l;}return this._iLastAvailableSpace;}}return 0;};r.prototype._collectTableSizes=function(){var s={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var a=this.getDomRef();if(!a){return s;}var l=a.querySelector(".sapUiTableCnt");if(l){s.tableCntHeight=l.clientHeight;s.tableCntWidth=l.clientWidth;}var t=a.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(t){s.tableCtrlScrollWidth=t.clientWidth;}var u=a.querySelector(".sapUiTableRowHdrScr");if(u){s.tableRowHdrScrWidth=u.clientWidth;}var v=a.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(v){s.tableCtrlScrWidth=v.clientWidth;}var H=this._getScrollExtension().getHorizontalScrollbar();if(H){s.tableHSbScrollLeft=H.scrollLeft;}var w=a.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(w){s.tableCtrlFixedWidth=w.clientWidth;}var x=this.getProperty("fixedColumnCount");var y=0;if(x){var z=this.getColumns();var A=a.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<A.length;i++){var J=parseInt(A[i].getAttribute("data-sap-ui-headcolindex"),10);if(!isNaN(J)&&(J<x)){var K=z[J];var W;if(K._iFixWidth!=null){W=K._iFixWidth;}else{W=A[i].getBoundingClientRect().width;}y+=W;}}}if(y>0){var U=s.tableRowHdrScrWidth;var L=this.getDomRef("vsb");if(L){U+=L.offsetWidth;}if(T.hasRowActions(this)){var M=this.getDomRef("sapUiTableRowActionScr");if(M){U+=M.offsetWidth;}}U+=T.Column.getMinColumnWidth();var O=s.tableCntWidth-U;var P=O>y;var Q=!P;if(this._bIgnoreFixedColumnCount!==Q){this._bIgnoreFixedColumnCount=Q;this.invalidate();}}return s;};r.prototype.getAggregationDomRef=function(a){if(a=="rows"){return this.getDomRef("tableCCnt");}};r.prototype._updateRowHeights=function(i,H){var l=this.getDomRef();if(!l){return;}if(H&&this.getColumnHeaderHeight()){return;}function u(y,z){var A=i[z];if(A){y.style.height=A+"px";}}var s=H?".sapUiTableColHdrTr":".sapUiTableTr";var t=H?[]:l.querySelectorAll(".sapUiTableRowHdr");var v=H?[]:l.querySelectorAll(".sapUiTableRowAction");var w=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+s);var x=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+s);var a=[];a.forEach.call(t,u);a.forEach.call(v,u);a.forEach.call(w,u);a.forEach.call(x,u);};r.prototype.onBeforeRendering=function(a){if(a&&a.isMarked("renderRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var v=this.getVisibleRowCountMode();var i=this.getRows();if(v==V.Interactive||v==V.Fixed||(v==V.Auto&&this._iTableRowContentHeight&&i.length==0)){this.getBinding("rows");this._updateRows(this._calculateRowsToDisplay(),T.RowsUpdateReason.Render);}else if(this._bRowAggregationInvalid&&i.length>0){this._updateRows(i.length,T.RowsUpdateReason.Render);}this._aTableHeaders=[];};r.prototype.onAfterRendering=function(a){var s=a&&a.isMarked("renderRows");if(s){var t=this._getScrollExtension();t.updateVerticalScrollbarHeight();t.updateVerticalScrollHeight();}this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var u=this.getColumns();for(var i=0,l=u.length;i<l;i++){if(u[i].getVisible()){u[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection&&!s){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();this._updateTableContent();this.getDomRef().classList.remove("sapUiTableRActFlexible");if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,T.RowsUpdateReason.Render,true));}else{this._updateTableSizes(T.RowsUpdateReason.Render,null,s,s&&T.isVariableRowHeightEnabled(this));}if(!s){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");if(this.getBinding("rows")){this._fireRowsUpdated(T.RowsUpdateReason.Render);}}};r.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var v=C.prototype.invalidate.call(this);T.Column.invalidateColumnUtils(this);}return v;};r.prototype._initRowDomRefs=function(){var a=this.getRows();for(var i=0;i<a.length;i++){a[i].initDomRefs();}};r.prototype._updateTableSizes=function(s,a,l,t){var u=this.getDomRef();var v=this;if(this._bInvalid||!u){return;}if(u.offsetWidth===0){T.deregisterResizeHandler(this,"");P();return;}this._resetRowHeights();this._resetColumnHeaderHeights();this._aRowHeights=this._collectRowHeights(false);var w=this._collectRowHeights(true);if(T.isVariableRowHeightEnabled(this)){this._getScrollExtension().updateInnerVerticalScrollRangeCache(this._aRowHeights);}var x=null;if(!l&&this.getVisibleRowCountMode()==V.Auto){x=this._determineAvailableSpace();if(this._handleRowCountModeAuto(x,s)&&!a){return;}}T.deregisterResizeHandler(this,"");function y(Q){var U=Q.getDomRef();var W=T.Column.getMinColumnWidth();var X=[];var Y=Q.getColumnHeaderVisible();function Z(b1,c1){if(b1<=c1){return Math.max(b1,c1-5,W)+"px";}return-1;}function _(c1){var d1=Math.max(c1._minWidth||0,W,c1.getMinWidth());var e1=c1.getWidth();var f1;var g1;var h1;if(T.isVariableWidth(e1)&&!T.isFixedColumn(Q,c1.getIndex())){f1=U.querySelectorAll('th[data-sap-ui-colid="'+c1.getId()+'"]');g1=f1[Y?0:1];h1=g1?g1.offsetWidth:null;if(h1!==null){if(h1<=d1){return{headers:f1,newWidth:Z(h1,d1)};}else if(g1&&g1.style.width!=e1){X.push({col:c1,header:g1,minWidth:d1,headers:f1});return{headers:f1,newWidth:e1};}X.push({col:c1,header:g1,minWidth:d1,headers:f1});}}return null;}function a1(c1){if(c1){Array.prototype.forEach.call(c1.headers,function(d1){d1.style.width=c1.newWidth;});}}Q._getVisibleColumns().map(_).forEach(a1);if(X.length){var b1;for(var i=0;i<X.length;i++){b1=X[i].header&&X[i].header.offsetWidth;X[i].newWidth=Z(b1,X[i].minWidth);if(parseInt(X[i].newWidth,10)>=0){a1(X[i]);}}}}y(this);var z=this._collectTableSizes();if(z.tableCntHeight==0&&z.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(w,true);this._determineVisibleCols(z);if(!l||t){this._setRowContentHeight(x);}if(this.getVisibleRowCountMode()==V.Auto){var A=this._calculateRowsToDisplay(x!=null?x:this._determineAvailableSpace());if(A==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}}var H=this._getScrollExtension();H.updateHorizontalScrollbar(z);H.updateVerticalScrollbarPosition();H.updateVerticalScrollbarVisibility();var $=this.$();if(T.hasRowActions(this)){var J=$.hasClass("sapUiTableRActFlexible");var K=this.getDomRef("dummycolhdr");var L=K?K.clientWidth:0;if(!J&&L>0){var M=z.tableCtrlScrWidth+z.tableRowHdrScrWidth+z.tableCtrlFixedWidth-L;var O={width:"auto"};O[this._bRtlMode?"right":"left"]=M;this.$("sapUiTableRowActionScr").css(O);this.$("rowacthdr").css(O);$.toggleClass("sapUiTableRActFlexible",true);}else if(J&&L<=0){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");function P(){T.registerResizeHandler(v,"",v._onTableResize.bind(v),true);}if($.closest(".sapUiLoSplitter").length){P();}else{Promise.resolve().then(P);}};r.prototype.setShowOverlay=function(s){s=!!s;this.setProperty("showOverlay",s,true);if(this.getDomRef()){var a=document.activeElement;this.$().toggleClass("sapUiTableOverlay",s);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);}return this;};r.prototype._updateFixedBottomRows=function(){var i=this.getFixedBottomRowCount();var a=this.getDomRef();if(a&&i>0){var $=q(a).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var l=q(a).find(".sapUiTableFixedFirstBottomRow");l.removeClass("sapUiTableFixedFirstBottomRow");var s=T.getFirstFixedButtomRowIndex(this);var t=this.getRows();var u;if(s>=0&&s<t.length){u=t[s].getDomRefs(true);u.row.addClass("sapUiTableFixedFirstBottomRow",true);}if(s>=1&&s<t.length){u=t[s-1].getDomRefs(true);u.row.addClass("sapUiTableFixedPreBottomRow",true);}}};r.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};r.prototype.applyFocusInfo=function(a){if(a&&a.customId){q.sap.byId(a.customId,this.getDomRef()).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};r.prototype.setTitle=function(t){var a=t;if(typeof(t)==="string"||t instanceof String){a=e.TableHelper.createTextView({text:t,width:"100%"});a.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",a);return this;};r.prototype.setFooter=function(v){var a=v;if(typeof(v)==="string"||v instanceof String){a=e.TableHelper.createTextView({text:v,width:"100%"});}this.setAggregation("footer",a);return this;};r.prototype.setSelectionMode=function(s){this.clearSelection();if(s===n.Single){this._oSelection.setSelectionMode(S.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(S.MULTI_SELECTION);}s=T.sanitizeSelectionMode(this,s);this.setProperty("selectionMode",s);return this;};r.prototype.setFirstVisibleRow=function(i,O,s){if(parseInt(i,10)<0){q.sap.log.error("The index of the first visible row must be greater than or equal to 0."+" The value has been set to 0.",this);i=0;}if(this._getTotalRowCount()>0){var M=this._getMaxRowIndex();if(T.isVariableRowHeightEnabled(this)){M++;}if(M<i){q.sap.log.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+M+".",this);i=M;}}var a=this.getFirstVisibleRow()!=i;if(a){this.setProperty("firstVisibleRow",i,true);if(this.getBinding("rows")){var l=O===true?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(l);if(!O){this._getScrollExtension().updateVerticalScrollPosition();}}if(!s){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}return this;};r.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;r.prototype.bindAggregation=function(s){if(s==="rows"){return this.bindRows.apply(this,[].slice.call(arguments,1));}return C.prototype.bindAggregation.apply(this,arguments);};r.prototype.bindRows=function(a){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._iPendingRequests=0;this._bPendingRequest=false;return C.prototype.bindAggregation.call(this,"rows",r._getSanitizedBindingInfo(arguments));};r.prototype._bindAggregation=function(s,a){if(s==="rows"){r._addBindingListener(a,"change",this._onBindingChange.bind(this));r._addBindingListener(a,"dataRequested",this._onBindingDataRequested.bind(this));r._addBindingListener(a,"dataReceived",this._onBindingDataReceived.bind(this));}E.prototype._bindAggregation.call(this,s,a);var i=this.getBinding("rows");if(s==="rows"&&i!=null){var M=i.getModel();if(M!=null&&M.getDefaultBindingMode()===B.OneTime){q.sap.log.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}this._initSelectionModel(S.MULTI_SELECTION);};r._getSanitizedBindingInfo=function(a){var i;if(a==null||a[0]==null){i=null;}else if(typeof a[0]==="string"){var P=a[0];var t=a[1];var s=a[2];var l=a[3];if(t instanceof c||q.isArray(s)&&s[0]instanceof F){l=s;s=t;t=undefined;}i={path:P,sorter:s,filters:l,template:t};}else{i=a[0];}return i;};r._addBindingListener=function(a,s,H){if(a.events==null){a.events={};}if(a.events[s]==null){a.events[s]=H;}else{var O=a.events[s];a.events[s]=function(){H.apply(this,arguments);O.apply(this,arguments);};}};r.prototype._initSelectionModel=function(s){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new S(s);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};r.prototype._onBindingChange=function(a){var s=typeof(a)==="object"?a.getParameter("reason"):a;if(s==="sort"||s==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};r.prototype.unbindAggregation=function(s,a){var i=this.getBinding("rows");if(s==="rows"&&this.isBound("rows")){a=true;}var v=E.prototype.unbindAggregation.apply(this,[s,a]);if(s==="rows"&&i){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateTotalRowCount(true);this.updateRows(T.RowsUpdateReason.Unbind);}return v;};r.prototype.setVisibleRowCount=function(v){if(v!=null&&!isFinite(v)){return this;}var s=this.getVisibleRowCountMode();if(s==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var i=this.getFixedRowCount()+this.getFixedBottomRowCount();if(v<=i&&i>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+v+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}v=this.validateProperty("visibleRowCount",v);if(this.getBinding("rows")!=null&&this._getTotalRowCount()<=v){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",v);this._setRowContentHeight(v*this._getDefaultRowHeight());return this;};r.prototype.setRowHeight=function(i){this.setProperty("rowHeight",i);this._iTableRowContentHeight=undefined;return this;};r.prototype.setTooltip=function(t){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",t,true);};r.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};r.prototype._getFixedBottomRowContexts=function(i,a){var l=this.getBinding("rows");var s=[];if(!l){return s;}i=i||this.getFixedBottomRowCount();a=a||this._getTotalRowCount();var v=this.getVisibleRowCount();if(i>0&&(v-i)<a){s=this._getContexts(a-i,i,1);}return s;};r.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};r.prototype._getContexts=function(s,l,t){var a=this.getBinding("rows");if(a){return a.getContexts(s,l,t);}else{return[];}};r.prototype._getRowContexts=function(v,s,a){var l=this.getBinding("rows");var t=v==null?this.getRows().length:v;if(!l||t<=0){return[];}s=s===true;a=a===true;var u=this.getFirstVisibleRow();var w=this.getFixedRowCount();var x=this.getFixedBottomRowCount();var y=0;var z;var A=[];var H;var L=t-x;var M=0;var J=L;var K=this.getThreshold();K=K?Math.max(t,K):0;var O=u;var P=function(W,X,O){for(var i=0;i<X.length;i++){W[O+i]=X[i];}};if(w>0&&u>0){O=u+w;L-=w;M=w;H=this._getFixedRowContexts(w);y+=H.length;A=A.concat(H);}H=this._getContexts(O,L,K);var Q=this._updateTotalRowCount(!s);z=H.length<Math.min(L,Q-x);y+=H.length;P(A,H,M);J=Math.min(J,Math.max(Q-x,0));if(x>0){H=this._getFixedBottomRowContexts(x,Q);y+=H.length;P(A,H,J);}if(z&&!a){if(Q>0){var U=this._getMaxRowIndex();if(U<u){u=U;this.setProperty("firstVisibleRow",u,true);A=this._getRowContexts(t,s,true);y=A.length;}}}return A;};r.prototype._updateTotalRowCount=function(u){if(this._iBindingLength===null){this._iBindingLength=0;}var a=this.getBinding("rows");var i=this._getTotalRowCount();var l=a==null?0:a.getLength();if(i!==l){if(u!==false){var s=this._getScrollExtension();this._iBindingLength=l;this._updateFixedBottomRows();s.updateVerticalScrollbarVisibility();s.updateVerticalScrollHeight();if(!a||!T.hasPendingRequests(this)){this._updateNoData();}}}return l;};r.prototype.refreshRows=function(v){var a=this.getBinding("rows");if(!a){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var t=this;var s=typeof(v)==="object"?v.getParameter("reason"):v;var i=this.getVisibleRowCountMode();if((this.bOutput&&i===V.Auto)||i!==V.Auto){if(this.bOutput){a.attachEventOnce("dataRequested",function(){if(t._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(t._mTimeouts.refreshRowsAdjustRows);}t._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){t._updateRows(t._calculateRowsToDisplay(),s,false);},0);});}if(s===b.Filter||s===b.Sort){this.setFirstVisibleRow(0);}var l=s!=null;this._updateBindingContexts(this._calculateRowsToDisplay(),l);}};r.prototype.updateRows=function(s){if(this._bExitCalled){return;}var v=this.getVisibleRowCountMode();if((this.getRows().length<=0||this._bRowAggregationInvalid)&&((v==V.Auto&&this.bOutput)||v!=V.Auto)){if(this._iTableRowContentHeight){this._updateRows(this._calculateRowsToDisplay(),s);}}if(!this.bIsDestroyed){var i=(s===b.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||s===T.RowsUpdateReason.Unbind?0:this._iBindingTimerDelay);var t=this;if(i===0&&s){Promise.resolve().then(function(){t._performUpdateRows(s);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){t._performUpdateRows(s);},i);}}};r.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};r.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};r.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};r.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};r.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};r.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};r.prototype._attachEvents=function(){var $=this.$();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(a){if(q(a.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}f.attachEvents(this);};r.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);f.detachEvents(this);};r.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){window.clearTimeout(this._mTimeouts[K]);delete this._mTimeouts[K];}}};r.prototype._updateBindingContexts=function(i,s){var a=this.getBinding("rows");var l;s=s===true;if(a!=null){l=this._getRowContexts(i,s);}if(!s){this._resetRowHeights();var t=this.getRows(),u=this.mBindingInfos["rows"],M=u&&u.model;for(var v=t.length-1;v>=0;v--){var w=l?l[v]:undefined;var x=t[v];if(x){x.setRowBindingContext(w,M,a);}}}};r.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var a=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);};r.prototype._determineVisibleCols=function(t){var a=[];this.getColumns().forEach(function(l,i){if(l.shouldRender()){a.push(i);}});};r.prototype.removeColumn=function(a,s){var i=this.removeAggregation('columns',a,s);if(typeof a==="number"&&a>-1){a=this.getColumns()[a];}var l=q.inArray(a,this._aSortedColumns);if(!this._bReorderInProcess&&l>=0){this._aSortedColumns.splice(l,1);}this.invalidateRowsAggregation();return i;};r.prototype.removeAllColumns=function(){var a=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};r.prototype.destroyColumns=function(){var a=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};r.prototype.addColumn=function(a,s){this.addAggregation('columns',a,s);this.invalidateRowsAggregation();return this;};r.prototype.insertColumn=function(a,i,s){this.insertAggregation('columns',a,i,s);this.invalidateRowsAggregation();return this;};r.prototype._getTotalRowCount=function(){if(this._iBindingLength===null){var a=this.getBinding("rows");return a==null?0:a.getLength();}else{return this._iBindingLength;}};r.prototype._getSelectableRowCount=function(){return this._getTotalRowCount();};r.prototype._getScrollableRowCount=function(){return Math.max(1,this.getVisibleRowCount()-this.getFixedRowCount()-this.getFixedBottomRowCount());};r.prototype._getMaxRowIndex=function(){var M=this._getTotalRowCount()-this.getVisibleRowCount();if(T.isVariableRowHeightEnabled(this)){M-=1;}return Math.max(0,M);};r.prototype._getVisibleColumns=function(){var a=[];var s=this.getColumns();for(var i=0,l=s.length;i<l;i++){if(s[i].shouldRender()){a.push(s[i]);}}return a;};r.prototype._getColumnsWidth=function(s,a){var t=this.getColumns();var u=0;if(s!==0&&!s){s=0;}if(a!==0&&!a){a=t.length;}for(var i=s,l=a;i<l;i++){if(t[i]&&t[i].shouldRender()){u+=this._CSSSizeToPixel(t[i].getWidth());}}return u;};r.prototype._CSSSizeToPixel=function(s,a){var P=T.Column.getMinColumnWidth();if(s){if(q.sap.endsWith(s,"px")){P=parseInt(s,10);}else if(q.sap.endsWith(s,"em")||q.sap.endsWith(s,"rem")){P=Math.ceil(parseFloat(s)*this._getBaseFontSize());}}if(a){return P+"px";}else{return parseInt(P,10);}};r.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};r.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};r.prototype._handleRowCountModeAuto=function(t,s){t=t||this._determineAvailableSpace();var a=this.getBinding("rows");var i=this._calculateRowsToDisplay(t);if(a&&this.getRows().length>0){return this._updateRows(i,s);}else{var l=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var u=this.getBusyIndicatorDelay();var v=this.getEnableBusyIndicator();var w=this;if(a&&v){this.setBusyIndicatorDelay(0);this.setBusy(true);}if(t){this._setRowContentHeight(t);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!w._updateRows(i,s)){w._updateTableSizes(s,false,true);}delete w._mTimeouts.handleRowCountModeAutoAdjustRows;if(a&&v){w.setBusyIndicatorDelay(u);w.setBusy(false);}},0);return l;}};r.prototype._disableTextSelection=function(a){q(a||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(i){i.preventDefault();return false;});};r.prototype._enableTextSelection=function(a){q(a||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};r.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(a){}}};r.prototype._findAndfireCellEvent=function(a,i,l){var $=q(i.target);var s=$.closest("td.sapUiTableTd");var t=s.attr("id");var M=/.*-row(\d*)-col(\d*)/i.exec(t);var u=false;if(M){var v=M[1];var w=M[2];var x=this.getRows()[v];var y=x&&x.getCells()[w];var z=x&&x.getIndex();var A=y.data("sap-ui-colid");var H;if(this.getBindingInfo("rows")){H=x.getBindingContext(this.getBindingInfo("rows").model);}var P={rowIndex:z,columnIndex:w,columnId:A,cellControl:y,rowBindingContext:H,cellDomRef:s.get(0)};u=!a.call(this,P);if(!u&&typeof l==="function"){P.cellDomRef=s[0];u=l.call(this,P);}}return u;};r.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var a=T.getFocusedItemInfo(this);if(a!==null){return a.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};r.prototype._isRowSelectable=function(i){return i>=0&&i<this._getTotalRowCount();};r.prototype.pushSortedColumn=function(a,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(a);};r.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};r.prototype.sort=function(a,s,A){if(!a){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var l=this.getBinding("rows");if(l){l.sort();}this._aSortedColumns=[];}if(q.inArray(a,this.getColumns())>=0){a.sort(s===p.Descending,A);}};r.prototype.filter=function(a,v){if(q.inArray(a,this.getColumns())>=0){a.filter(v);}};r.prototype._updateSelection=function(){var s=this.getSelectionMode();if(s===n.None){return;}var t=this._getAccExtension().getAriaTextsForSelectionMode(true);var a=T.isRowSelectionAllowed(this);var l=this.getRows();for(var i=0;i<l.length;i++){var u=l[i];u._updateSelection(this,t,a);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);if(T.hasSelectAll(this)){var $=this.$("selall");var A=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!A);this._getAccExtension().setSelectAllState(A);if(this._getShowStandardTooltips()){var v=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";$.attr('title',this._oResBundle.getText(v));}}};r.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};r.prototype._onSelectionChanged=function(a){var i=a.getParameter("rowIndices");var s=a.getParameter("selectAll");var l=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();this.fireRowSelectionChange({rowIndex:l,rowContext:this.getContextByIndex(l),rowIndices:i,selectAll:s,userInteraction:this._iSourceRowIndex!==undefined});};r.prototype.getContextByIndex=function(i){var a=this.getBinding("rows");return i>=0&&a?a.getContexts(i,1)[0]:null;};r.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};r.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};r.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};r.prototype.selectAll=function(){if(!T.hasSelectAll(this)){return this;}var a=this.getBinding("rows");if(a){this._oSelection.selectAll(this._getTotalRowCount()-1);}return this;};r.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};r.prototype.addSelectionInterval=function(i,a){if(this.getSelectionMode()===e.SelectionMode.None){return this;}this._oSelection.addSelectionInterval(i,a);return this;};r.prototype.setSelectionInterval=function(i,a){if(this.getSelectionMode()===e.SelectionMode.None){return this;}this._oSelection.setSelectionInterval(i,a);return this;};r.prototype.removeSelectionInterval=function(i,a){this._oSelection.removeSelectionInterval(i,a);return this;};r.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};r.prototype.setGroupBy=function(v){var a=v;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof a==="string"){a=sap.ui.getCore().byId(a);}var i=false;if(a!=null&&a instanceof d&&a!==O){if(q.inArray(a,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var l=this.fireGroup({column:a,groupedColumns:[a.getId()],type:G.group});if(O!=null){O.setGrouped(false);i=true;}if(l&&this.getEnableGrouping()){a.setGrouped(true);}}if(a==null||i){if(O!=null){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",a);};r.prototype.getBinding=function(s){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[s||"rows"]);};r.prototype.setEnableGrouping=function(a){var i=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",a);if(i!=null){i.setGrouped(a);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};r.prototype.setEnableCustomFilter=function(a){this.setProperty("enableCustomFilter",a);this._invalidateColumnMenus();return this;};r.prototype.setEnableColumnFreeze=function(a){this.setProperty("enableColumnFreeze",a);this._invalidateColumnMenus();return this;};r.prototype.setShowColumnVisibilityMenu=function(s){this.setProperty("showColumnVisibilityMenu",s);this._invalidateColumnMenus();return this;};r.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};r.prototype.setFixedColumnCount=function(a,s){var l=this.getColumns();var t,i;for(i=a-1;i>=0;i--){t=l[i];if(t&&t.getVisible()){a=Math.max(a,t.getIndex()+T.Column.getHeaderSpan(t));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=a-1;i>=0;i--){t=l[i];if(t&&T.isVariableWidth(t.getWidth())){t._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+t.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",a,s);this._collectTableSizes();this._invalidateColumnMenus();return this;};r.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};r.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};r.prototype.setThreshold=function(t){this.setProperty("threshold",t,true);};r.prototype._invalidateColumnMenus=function(u){var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){a[i].invalidateMenu(u);}};r.prototype._isTouchEvent=function(a){return a!=null&&a.originalEvent!=null&&a.originalEvent.touches!=null;};r.prototype._getRowClone=function(a){var s=new R(this.getId()+"-rows"+"-row"+a);var t=this.getColumns();for(var i=0,l=t.length;i<l;i++){if(t[i].getVisible()){var u=t[i].getTemplateClone(i);if(u){s.addCell(u);}}}if(T.hasRowActions(this)){var v=this.getRowActionTemplate().clone();v._setFixedLayout(true);v._setCount(this.getRowActionCount());v._setIconLabel(this.getId()+"-rowacthdr");s.setAggregation("_rowAction",v,true);}var w=this.getRowSettingsTemplate();if(w){var x=w.clone();s.setAggregation("_settings",x,true);}return s;};r.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};r.prototype._updateRows=function(a,s,u){if(isNaN(a)){return false;}if(u==null){u=true;}if(T.isVariableRowHeightEnabled(this)){a=a+1;}var i;var l=this.getRows();if(this._bRowAggregationInvalid&&l.length>0){this.destroyAggregation("rows",true);l=[];}if(a==l.length){return false;}for(i=l.length-1;i>=a;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",a-1,true);}else{this.setProperty("visibleRowCount",a,true);}this._ignoreInvalidateOfChildControls=true;var t;var v;var M;var w=this.getBinding("rows");if(u){v=this.getBindingInfo("rows");M=v&&v.model;t=this._getRowContexts(a);for(i=0;i<l.length;i++){l[i].setRowBindingContext(t[i],M,w);}}if(l.length<a){for(i=l.length;i<a;i++){var x=this._getRowClone(i);if(u){x.setRowBindingContext(t[i],M,w);}this.addAggregation("rows",x,true);this._bRowAggregationInvalid=false;if(u){x._updateTableCells(t[i]);}}}this._ignoreInvalidateOfChildControls=false;var y=u&&t.length>0;return this._renderRows(s,y);};r.prototype._renderRows=function(s,a){var i=false;a=a===true;if(!this._bInvalid){var t=this.getDomRef("tableCCnt");if(this.getRows().length===0||!t){return false;}this._detachEvents();if(this.getVisibleRowCountMode()===V.Auto){var l=this.getDomRef();if(l){l.style.height="0px";}}var u=q.Event("BeforeRendering");u.setMarked("renderRows");u.srcControl=this;this._handleEvent(u);var v=new sap.ui.getCore().createRenderManager(),w=this.getRenderer();w.renderTableCCnt(v,this);v.flush(t,false,false);v.destroy();u=q.Event("AfterRendering");u.setMarked("renderRows");u.srcControl=this;this._handleEvent(u);i=true;}if(a&&!this._bInvalid&&this.getBinding("rows")){var x=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){x._fireRowsUpdated(s);},0);}return i;};r.prototype._getDefaultRowHeight=function(){var i=this.getRowHeight();if(i>0){return i;}else{var s=T.getContentDensity(this);return T.DEFAULT_ROW_HEIGHT[s];}};r.prototype._setRowContentHeight=function(H){H=H||0;var v=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var a=this._getDefaultRowHeight();var M=this.getMinAutoRowCount();var l;if(v==V.Interactive||v==V.Fixed){if(this._iTableRowContentHeight&&v==V.Interactive){l=M*a;if(!H){H=this._iTableRowContentHeight;}}else{l=i*a;H=l;}}else if(v==V.Auto){l=M*a;}var s=Math.max(H,l);if((v==V.Fixed&&this.getRows().length==0)||v!=V.Fixed){this._iTableRowContentHeight=Math.floor(s/a)*a;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",a*this.getVisibleRowCount()+"px");}else{if((v==V.Fixed||v==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}};r.prototype._determineMinAutoRowCount=function(){var v=this.getVisibleRowCount();var M=this.getMinAutoRowCount();var i=M||v||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){i=v||M||5;}return i;};r.prototype._calculateRowsToDisplay=function(t){this._iRowsToDisplayHeight=t||this._iRowsToDisplayHeight||this._iTableRowContentHeight;t=this._iRowsToDisplayHeight;var v=this.getVisibleRowCountMode();var i=0;if(v==V.Fixed){i=this.getVisibleRowCount()||0;}else if(v==V.Interactive||v==V.Auto){var M=this._determineMinAutoRowCount();var a=this._getDefaultRowHeight();if(!a||!t){i=M;}else{var A=Math.min(t,50000);var l=Math.floor(A/a);i=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(M,l));}}return Math.max(i,0);};r.prototype.setShowNoData=function(s){this.setProperty('showNoData',s,true);this._updateNoData();return this;};r.prototype.exportData=function(s){var a=sap.ui.requireSync("sap/ui/core/util/Export");s=s||{};if(!s.rows){var t=this.getBinding("rows"),u=this.getBindingInfo("rows");var v=t.aFilters.concat(t.aApplicationFilters);s.rows={path:u.path,model:u.model,sorter:t.aSorters,filters:v,parameters:u.parameters};}if(!s.exportType){var w=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");s.exportType=new w();}var M=s.rows.model;if(!M){var P=s.rows.path;var x=P.indexOf(">");if(x>0){M=P.substr(0,x);}}if(!s.columns){s.columns=[];var y=this.getColumns();for(var i=0,l=y.length;i<l;i++){var z=y[i];if(z.getSortProperty()){s.columns.push({name:z.getLabel().getText(),template:{content:{path:z.getSortProperty(),model:M}}});}}}var A=new a(s);this.addDependent(A);return A;};r.prototype._onPersoApplied=function(){var a=this.getColumns();var s=[];for(var i=0,l=a.length;i<l;i++){var t=a[i];if(t.getSorted()){s.push(new c(t.getSortProperty(),t.getSortOrder()===p.Descending));}}var u=this.getBinding("rows");if(u){if(s.length>0){u.sort(s);}this.refreshRows();}};r.prototype._toggleSelectAll=function(){if(!T.hasData(this)){return;}if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}this._iSourceRowIndex=undefined;};r.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var a=this.getColumns();q.each(a,function(i,l){l._restoreAppDefaults();});};r.prototype.setBusy=function(a,s){var i=this.getBusy()!=a;s="sapUiTableCnt";var v=C.prototype.setBusy.call(this,a,s);if(i){this.fireBusyStateChanged({busy:a});}return v;};r.prototype.setEnableBusyIndicator=function(v){this.setProperty("enableBusyIndicator",v,true);if(!v){this.setBusy(false);}};r.prototype._onBindingDataRequested=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var i=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(i&&this._iPendingRequests===1||!i)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};r.prototype._onBindingDataReceived=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;this._updateTotalRowCount(true);if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;});}};r.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};r.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};r.prototype._updateTableContent=function(){T.Grouping.updateGroups(this);};r.prototype.setRowActionTemplate=function(t){this.setAggregation("rowActionTemplate",t);t=this.getRowActionTemplate();if(t){t._setCount(this.getRowActionCount());}this.invalidateRowsAggregation();return this;};r.prototype.setRowActionCount=function(a){this.setProperty("rowActionCount",a);a=this.getRowActionCount();var l=this.getRowActionTemplate();if(l){l._setCount(a);}var s=this.getRows();for(var i=0;i<s.length;i++){l=s[i].getAggregation("_rowAction");if(l){l._setCount(a);}}return this;};r.prototype.setRowSettingsTemplate=function(t){this.setAggregation("rowSettingsTemplate",t);this.invalidateRowsAggregation();return this;};r.prototype._validateRow=function(a){return a&&a instanceof R&&a.getParent()===this;};r.prototype.getRowForCell=function(a){if(a){var i=a.getParent();if(this._validateRow(i)){return i;}}return null;};r.prototype.getColumnForCell=function(a){if(this.getRowForCell(a)){var i=a.data("sap-ui-colindex");var l=this.getColumns();if(i>=0&&i<l.length){return l[i];}}return null;};r.prototype.getCellControl=function(i,a,v){var l=T.getRowColCell(this,i,a,!v);return l.cell;};r.prototype._fireRowsUpdated=function(s){if(s==null){s=T.RowsUpdateReason.Unknown;}this.fireEvent("_rowsUpdated",{reason:s});};return r;});
