/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./TableExtension","./TableUtils","sap/ui/Device","./library","jquery.sap.trace","jquery.sap.events"],function(q,T,c,D,l){"use strict";var S=l.SharedDomRef;var M=1000000;var H={onScroll:function(o){var s=this._getScrollExtension();q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(o);if(this._bOnAfterRendering){return;}var n=o.target.scrollLeft;var O=o.target._scrollLeft;if(n!==O){var a=H.getScrollAreas(this);o.target._scrollLeft=n;for(var i=0;i<a.length;i++){var b=a[i];if(b!==o.target&&b.scrollLeft!==n){b.scrollLeft=n;b._scrollLeft=n;}}s._iHorizontalScrollPosition=n;this._determineVisibleCols(this._collectTableSizes());}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var h=s.getHorizontalScrollbar();if(h!==null&&s._iHorizontalScrollPosition!==null){var a=H.getScrollAreas(t);for(var i=0;i<a.length;i++){var o=a[i];delete o._scrollLeft;}if(h.scrollLeft!==s._iHorizontalScrollPosition){h.scrollLeft=s._iHorizontalScrollPosition;}else{var b=q.Event("scroll");b.target=h;H.onScroll.call(t,b);}}},addEventListeners:function(t){var s=t._getScrollExtension();var a=H.getScrollAreas(t);if(s._onHorizontalScrollEventHandler==null){s._onHorizontalScrollEventHandler=H.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var a=H.getScrollAreas(t);if(s._onHorizontalScrollEventHandler!=null){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete a[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}},getScrollAreas:function(t){var s=[t._getScrollExtension().getHorizontalScrollbar(),t.getDomRef("sapUiTableColHdrScr"),t.getDomRef("sapUiTableCtrlScr")];return s.filter(function(o){return o!=null;});}};var V={onScroll:function(o){var s=this._getScrollExtension();q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(o);if(s._bIsScrolledVerticallyByKeyboard){return;}this._getKeyboardExtension().setActionMode(false);function u(t){var v=t._getScrollExtension().getVerticalScrollbar();if(!v){return;}var i=v.scrollTop;s._iVerticalScrollPosition=i;if(s._bSkipUpdateFirstVisibleRow){s._bSkipUpdateFirstVisibleRow=false;return;}var n=s.getRowIndexAtScrollPosition(i);var O=t.getFirstVisibleRow();var f=n!==O;if(f){t.setFirstVisibleRow(n,true);if(c.isVariableRowHeightEnabled(t)){t.attachEventOnce("_rowsUpdated",function(){s.updateInnerVerticalScrollPosition(this._aRowHeights);});}}else if(c.isVariableRowHeightEnabled(t)){s.updateInnerVerticalScrollPosition(t._aRowHeights);}}if(this._bLargeDataScrolling&&!s._bIsScrolledVerticallyByWheel){q.sap.clearDelayedCall(this._mTimeouts.scrollUpdateTimerId);this._mTimeouts.scrollUpdateTimerId=q.sap.delayedCall(300,this,function(){u(this);delete this._mTimeouts.scrollUpdateTimerId;}.bind(this));}else{u(this);}s._bIsScrolledVerticallyByWheel=false;},onScrollbarMouseDown:function(o){var s=this._getScrollExtension();s._bIsScrolledVerticallyByWheel=false;s._bIsScrolledVerticallyByKeyboard=false;},restoreScrollPosition:function(t){var s=t._getScrollExtension();if(s._iVerticalScrollPosition!==null){s.updateVerticalScrollPosition(s._iVerticalScrollPosition);}else{s.updateVerticalScrollPosition();}},addEventListeners:function(t){var s=t._getScrollExtension();var a=V.getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler==null){s._onVerticalScrollEventHandler=V.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v!==null){if(s._onVerticalScrollbarMouseDownEventHandler==null){s._onVerticalScrollbarMouseDownEventHandler=V.onScrollbarMouseDown.bind(t);}v.addEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var a=V.getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler!=null){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v!==null&&s._onVerticalScrollbarMouseDownEventHandler!=null){v.removeEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);delete s._onVerticalScrollbarMouseDownEventHandler;}},getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(o){return o!=null;});}};var d={onMouseWheelScrolling:function(o){var s=this._getScrollExtension();var v=Math.abs(o.deltaY)>Math.abs(o.deltaX);var i=v?o.deltaY:o.deltaX;var h=v&&o.shiftKey||!v;var b=i>0;var a=false;if(i===0){return;}if(h){var f=s.getHorizontalScrollbar();if(o.deltaMode>0){var m=c.Column.getMinColumnWidth();i=b?m:-m;}if(b){a=f.scrollLeft===f.scrollWidth-f.offsetWidth;}else{a=f.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!a){f.scrollLeft=f.scrollLeft+i;}o.preventDefault();o.stopPropagation();}else{var g=s.getVerticalScrollbar();if(o.deltaMode===1){i*=s.getVerticalScrollRangeRowFraction();}else if(o.deltaMode===2){i*=s.getVerticalScrollRangeRowFraction()*this.getVisibleRowCount();}if(b){a=g.scrollTop===g.scrollHeight-g.offsetWidth;}else{a=g.scrollTop===0;}if(s.isVerticalScrollbarVisible()&&!a){o.preventDefault();o.stopPropagation();var r=i/(o.deltaMode===0?this._getDefaultRowHeight():s.getVerticalScrollRangeRowFraction());if(r>1){r=Math.floor(r);}s._bIsScrolledVerticallyByWheel=true;s._bIsScrolledVerticallyByKeyboard=false;g.scrollTop+=r*s.getVerticalScrollRangeRowFraction();}}},onTouchStart:function(o){if(o.type==="touchstart"||o.pointerType==="touch"){var s=this._getScrollExtension();var h=s.getHorizontalScrollbar();var v=s.getVerticalScrollbar();var t=o.touches?o.touches[0]:o;s._mTouchSessionData={initialPageX:t.pageX,initialPageY:t.pageY,initialScrollTop:v==null?0:v.scrollTop,initialScrollLeft:h==null?0:h.scrollLeft,initialScrolledToEnd:null,touchMoveDirection:null};}},onTouchMoveScrolling:function(o){if(o.type==="touchmove"||o.pointerType==="touch"){var s=this._getScrollExtension();var t=s._mTouchSessionData;if(t==null){return;}var a=o.touches?o.touches[0]:o;var i=(a.pageX-t.initialPageX);var b=(a.pageY-t.initialPageY);var f=false;var g=false;if(t.touchMoveDirection===null){if(i===0&&b===0){return;}t.touchMoveDirection=Math.abs(i)>Math.abs(b)?"horizontal":"vertical";}switch(t.touchMoveDirection){case"horizontal":var h=s.getHorizontalScrollbar();if(h!=null){if(i<0){f=h.scrollLeft===h.scrollWidth-h.offsetWidth;}else{f=h.scrollLeft===0;}if(t.initialScrolledToEnd===null){t.initialScrolledToEnd=f;}if(!f&&!t.initialScrolledToEnd){h.scrollLeft=t.initialScrollLeft-i;g=true;}}break;case"vertical":var v=s.getVerticalScrollbar();if(v!=null){if(b<0){f=v.scrollTop===v.scrollHeight-v.offsetHeight;}else{f=v.scrollTop===0;}if(t.initialScrolledToEnd===null){t.initialScrolledToEnd=f;}if(!f&&!t.initialScrolledToEnd){v.scrollTop=t.initialScrollTop-b;g=true;}}break;default:}if(g){o.preventDefault();}}},addEventListeners:function(t){var s=t._getScrollExtension();var a=d.getEventListenerTargets(t);if(s._onMouseWheelEventHandler==null){s._onMouseWheelEventHandler=d.onMouseWheelScrolling.bind(t);}if(s._onTouchStartEventHandler==null){s._onTouchStartEventHandler=d.onTouchStart.bind(t);}if(s._onTouchMoveEventHandler==null){s._onTouchMoveEventHandler=d.onTouchMoveScrolling.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("wheel",s._onMouseWheelEventHandler);if(D.support.pointer&&D.system.desktop){a[i].addEventListener("pointerdown",s._onTouchStartEventHandler);a[i].addEventListener("pointermove",s._onTouchMoveEventHandler,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].addEventListener("touchstart",s._onTouchStartEventHandler);a[i].addEventListener("touchmove",s._onTouchMoveEventHandler);}}},removeEventListeners:function(t){var s=t._getScrollExtension();var a=d.getEventListenerTargets(t);for(var i=0;i<a.length;i++){if(s._onMouseWheelEventHandler!=null){a[i].removeEventListener("wheel",s._onMouseWheelEventHandler);}if(s._onTouchStartEventHandler!=null&&s._onTouchMoveEventHandler!=null){if(D.support.pointer&&D.system.desktop){a[i].removeEventListener("pointerdown",s._onTouchStartEventHandler);a[i].removeEventListener("pointermove",s._onTouchMoveEventHandler,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].removeEventListener("touchstart",s._onTouchStartEventHandler);a[i].removeEventListener("touchmove",s._onTouchMoveEventHandler);}}}delete s._onMouseWheelEventHandler;delete s._onTouchStartEventHandler;delete s._onTouchMoveEventHandler;},getEventListenerTargets:function(t){var a=[t.getDomRef("tableCCnt")];return a.filter(function(o){return o!=null;});}};var E={onBeforeRendering:function(o){this._getScrollExtension()._clearCache();},onAfterRendering:function(o){V.restoreScrollPosition(this);H.restoreScrollPosition(this);},onfocusin:function(o){var r;var C=c.getCellInfo(o.target);if(C.isOfType(c.CELLTYPE.DATACELL)){r=this.getDomRef("sapUiTableCtrlScr");}else if(C.isOfType(c.CELLTYPE.COLUMNHEADER)){r=this.getDomRef("sapUiTableColHdrScr");}if(r!=null&&C.columnIndex>=this.getFixedColumnCount()){var a=C.cell[0];var s=r.scrollLeft;var R=r.clientWidth;var i=a.offsetLeft;var b=i+a.offsetWidth;var O=i-s;var f=b-R-s;var h=this._getScrollExtension().getHorizontalScrollbar();if(O<0&&f<0){h.scrollLeft=s+O;}else if(f>0&&O>0){h.scrollLeft=s+f;}}var p=c.getParentCell(this,o.target);if(p!=null){Promise.resolve().then(function(){var I=p.find(".sapUiTableCell");if(I.length>0){if(this._bRtlMode){I.scrollLeftRTL(I[0].scrollWidth-I[0].clientWidth);}else{I[0].scrollLeft=0;}I[0].scrollTop=0;}}.bind(this));}}};var e=T.extend("sap.ui.table.TableScrollExtension",{_init:function(t,s,m){this._delegate=E;this._oVerticalScrollbar=null;this._oHorizontalScrollbar=null;this._iHorizontalScrollPosition=null;this._iVerticalScrollPosition=null;this._iInnerVerticalScrollRange=0;this._bIsScrolledVerticallyByWheel=false;this._bIsScrolledVerticallyByKeyboard=false;this._bSkipUpdateFirstVisibleRow=false;this._mTouchSessionData=null;t.addEventDelegate(this._delegate,t);return"ScrollExtension";},_attachEvents:function(){var t=this.getTable();H.addEventListeners(t);V.addEventListeners(t);d.addEventListeners(t);},_detachEvents:function(){var t=this.getTable();H.removeEventListeners(t);V.removeEventListeners(t);d.removeEventListeners(t);},_debug:function(){this._ScrollingHelper=d;this._ExtensionDelegate=E;this._HorizontalScrollingHelper=H;this._VerticalScrollingHelper=V;},destroy:function(){var t=this.getTable();if(t!=null){t.removeEventDelegate(this._delegate);}this._delegate=null;this._clearCache();T.prototype.destroy.apply(this,arguments);}});e.prototype.scrollVertically=function(b,p,i,a,B){var t=this.getTable();if(t==null){return false;}b=b===true;p=p===true;i=i===true;a=a===true;var s=false;var r=t._getTotalRowCount();var v=t.getVisibleRowCount();var f=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var F=t.getFirstVisibleRow();var g=p?f:1;if(b){if(F+v<r){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.min(F+g,r-v));},0);}else{t.setFirstVisibleRow(Math.min(F+g,r-v));}s=true;}}else if(F>0){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.max(F-g,0));},0);}else{t.setFirstVisibleRow(Math.max(F-g,0));}s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};e.prototype.scrollVerticallyMax=function(b,i){var t=this.getTable();if(t==null){return false;}if(b==null){b=false;}if(i==null){i=false;}var s=false;var f=t.getFirstVisibleRow();if(b){var F=t._getTotalRowCount()-c.getNonEmptyVisibleRowCount(t);if(f<F){t.setFirstVisibleRow(F);s=true;}}else if(f>0){t.setFirstVisibleRow(0);s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};e.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(t!=null&&this._oHorizontalScrollbar===null){this._oHorizontalScrollbar=t.getDomRef(S.HorizontalScrollBar);}return this._oHorizontalScrollbar;};e.prototype.getVerticalScrollbar=function(){var t=this.getTable();if(t!=null&&this._oVerticalScrollbar===null){this._oVerticalScrollbar=t.getDomRef(S.VerticalScrollBar);}return this._oVerticalScrollbar;};e.prototype.isHorizontalScrollbarVisible=function(){var t=this.getTable();var o=t==null?null:t.getDomRef();if(o==null){return false;}return o.classList.contains("sapUiTableHScr");};e.prototype.isVerticalScrollbarVisible=function(){var t=this.getTable();var o=t==null?null:t.getDomRef();if(o==null){return false;}return o.classList.contains("sapUiTableVScr");};e.prototype.updateHorizontalScrollbar=function(t){var o=this.getTable();var h=this.getHorizontalScrollbar();if(o==null||h==null||t==null){return;}var $=o.$();var C=t.tableCtrlScrollWidth;if(D.browser.safari){C=Math.max(C,o._getColumnsWidth(o.getFixedColumnCount()));}var b=C>t.tableCtrlScrWidth;if(b){if(!this.isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");if(D.browser.safari){var a=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");a.outerWidth(C);}}var s=t.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){s+=t.tableRowHdrScrWidth;}if(o.getRows().length>0){if(o._bRtlMode){h.style.marginRight=s+"px";h.style.marginLeft="";}else{h.style.marginLeft=s+"px";h.style.marginRight="";}}var f=o.getDomRef("hsb-content");if(f){f.style.width=C+"px";}}if(!b&&this.isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");if(D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}};e.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(t==null||v==null){return;}v.style.maxHeight=this.getVerticalScrollbarHeight()+"px";};e.prototype.getVerticalScrollbarHeight=function(){var t=this.getTable();if(t==null){return 0;}return t._getScrollableRowCount()*t._getDefaultRowHeight();};e.prototype.updateVerticalScrollbarPosition=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(t==null||v==null){return;}var o=t.getDomRef("tableCCnt");if(o){var i=o.offsetTop;var a=t.getDomRef("vsb-bg");a.style.top=i+"px";var f=t.getFixedRowCount();if(f>0){i+=t._iVsbTop;}v.style.top=i+"px";}};e.prototype.updateVerticalScrollPosition=function(s){var t=this.getTable();var v=this.getVerticalScrollbar();if(t==null||v==null||!this.isVerticalScrollbarRequired()){return;}if(s==null){s=Math.ceil(t.getFirstVisibleRow()*this.getVerticalScrollRangeRowFraction());this._bSkipUpdateFirstVisibleRow=true;}this._iVerticalScrollPosition=null;window.requestAnimationFrame(function(){var o=v.scrollTop;v.scrollTop=s;if(v.scrollTop===o){this._bSkipUpdateFirstVisibleRow=false;}}.bind(this));};e.prototype.updateVerticalScrollHeight=function(){var t=this.getTable();var v=t==null?null:t.getDomRef("vsb-content");if(v==null){return;}v.style.height=this.getVerticalScrollHeight()+"px";};e.prototype.getVerticalScrollHeight=function(){var t=this.getTable();if(t==null){return 0;}var v=t.getVisibleRowCount();if(c.isVariableRowHeightEnabled(t)){v++;}var r=Math.max(t._getTotalRowCount(),v);var s=t._getDefaultRowHeight()*r;return Math.min(M,s);};e.prototype.updateVerticalScrollbarVisibility=function(){var t=this.getTable();var o=t==null?null:t.getDomRef();var v=this.getVerticalScrollbar();if(o==null||v==null){return;}var b=this.isVerticalScrollbarRequired();if(b&&!this.isVerticalScrollbarVisible()){o.classList.add("sapUiTableVScr");this.updateVerticalScrollPosition(0);}if(!b&&this.isVerticalScrollbarVisible()){o.classList.remove("sapUiTableVScr");}};e.prototype.isVerticalScrollbarRequired=function(){var t=this.getTable();if(t==null){return false;}return this._iInnerVerticalScrollRange>0||(t._getTotalRowCount()>t.getVisibleRowCount());};e.prototype.getRowIndexAtScrollPosition=function(s){var t=this.getTable();if(t==null){return-1;}var m=t._getMaxRowIndex();if(m===0){return 0;}else{var r=Math.floor(s/this.getVerticalScrollRangeRowFraction());var n=this.getVerticalScrollRange()-s;var b=n<1;return b?m:Math.min(m,r);}};e.prototype.getVerticalScrollRange=function(){var t=this.getTable();if(t==null){return 0;}var v=this.getVerticalScrollHeight()-this.getVerticalScrollbarHeight();if(c.isVariableRowHeightEnabled(t)){v=v-this._iInnerVerticalScrollRange;}return Math.max(1,v);};e.prototype.getVerticalScrollRangeRowFraction=function(){var t=this.getTable();if(t==null){return 0;}return Math.max(1,this.getVerticalScrollRange())/Math.max(1,t._getMaxRowIndex());};e.prototype.getVerticalScrollRangeDelta=function(){var t=this.getTable();if(t==null){return 0;}var v=this.getVerticalScrollHeight()-this.getVerticalScrollbarHeight();if(t._getTotalRowCount()>t.getVisibleRowCount()){v-=this.getVerticalScrollRange();}return Math.max(0,v);};e.prototype.updateInnerVerticalScrollPosition=function(r){var t=this.getTable();if(t==null){return;}var s=this._iVerticalScrollPosition==null?0:this._iVerticalScrollPosition;var b=s<this.getVerticalScrollRange();var v=t._getTotalRowCount()>t.getVisibleRowCount();if(b&&t.getFirstVisibleRow()!=t._iRenderedFirstVisibleRow){return;}var i=null;if(b&&v){var f=r[0];var a=this.getVerticalScrollRangeRowFraction();var p=s-(t.getFirstVisibleRow()*a);var P=p/a;i=Math.ceil(P*f);if(i>f){i=null;}}else if(this._iInnerVerticalScrollRange>=0){var g=v?s-this.getVerticalScrollRange():s;i=(this._iInnerVerticalScrollRange/this.getVerticalScrollRangeDelta())*g;}if(i!=null&&i>-1){t.$().find(".sapUiTableCCnt").scrollTop(i);}};e.prototype.updateInnerVerticalScrollRangeCache=function(r){var t=this.getTable();if(t==null){this._iInnerVerticalScrollRange=0;return;}var i=t._getDefaultRowHeight()*t.getVisibleRowCount();if(t.getVisibleRowCount()>=t._getTotalRowCount()){r=r.slice(0,t._getTotalRowCount());}var n=r.reduce(function(a,b){return a+b;},0)-i;if(n>0){n=Math.ceil(n);}this._iInnerVerticalScrollRange=Math.max(0,n);};e.prototype._clearCache=function(){this._oVerticalScrollbar=null;this._oHorizontalScrollbar=null;};return e;});
