/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/table/AnalyticalColumn',['jquery.sap.global','./Column','./library','sap/ui/core/Element','sap/ui/model/type/Boolean','sap/ui/model/type/DateTime','sap/ui/model/type/Float','sap/ui/model/type/Integer','sap/ui/model/type/Time','./TableUtils','./AnalyticalColumnMenu'],function(q,C,l,E,B,D,F,I,T,a,A){"use strict";
function i(c){return a.isInstanceOf(c,"sap/ui/table/AnalyticalTable");}
var b=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});
b.prototype.init=function(){C.prototype.init.apply(this,arguments);};
b._DEFAULT_FILTERTYPES={"Time":new T({UTC:true}),"DateTime":new D({UTC:true}),"Float":new F(),"Integer":new I(),"Boolean":new B()};
b.prototype._createMenu=function(){return new A(this.getId()+"-menu");};
b.prototype.setGrouped=function(g,s){var p=this.getParent();if(i(p)){if(g){p._addGroupedColumn(this.getId());}else{p._removeGroupedColumn(this.getId());}}var r=this.setProperty("grouped",g,s);this._updateColumns();return r;};
b.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r;};
b.prototype.setVisible=function(v){C.prototype.setVisible.call(this,v);this._updateColumns();return this;};
b.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){this._oBindingLabel=l.TableHelper.createLabel();var m=o.getModel();if(m.oMetadata&&m.oMetadata.isLoaded()){this._oBindingLabel.setText(o.getPropertyLabel(this.getLeadingProperty()));}else{var t=this;m.attachMetadataLoaded(function(){t._oBindingLabel.setText(o.getPropertyLabel(t.getLeadingProperty()));});}}}}L=this._oBindingLabel;}return L;};
b.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding("rows");var L=this.getLeadingProperty();if(o&&q.inArray(L,o.getFilterablePropertyNames())>-1){p=L;}}}return p;};
b.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding("rows");var L=this.getLeadingProperty();if(o&&q.inArray(L,o.getSortablePropertyNames())>-1){p=L;}}}return p;};
b.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");var L=this.getLeadingProperty(),P=o&&o.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=b._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=b._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=b._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=b._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=b._DEFAULT_FILTERTYPES["Boolean"];break;}}}}return f;};
b.prototype._updateColumns=function(s,f){var p=this.getParent();if(i(p)){p._updateColumns(s,f);}};
b.prototype._updateTableAnalyticalInfo=function(s){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p.updateAnalyticalInfo(s);}};
b.prototype._updateTableColumnDetails=function(){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p._updateTableColumnDetails();}};
b.prototype.shouldRender=function(){if(!this.getVisible()||this.getTemplate()==null){return false;}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped);};
b.prototype.getTooltip_AsString=function(){var t=E.prototype.getTooltip_AsString.apply(this);var p=this.getParent();if(!t&&i(p)){var o=p.getBinding("rows");if(o&&this.getLeadingProperty()){t=o.getPropertyQuickInfo(this.getLeadingProperty());}}return t;};
b.prototype._menuHasItems=function(){var m=function(){var t=this.getParent();var o=t.getBinding("rows");var r=o&&o.getAnalyticalQueryResult();return(t&&r&&r.findMeasureByPropertyName(this.getLeadingProperty()));}.bind(this);return C.prototype._menuHasItems.apply(this)||m();};
b.prototype.isFilterableByMenu=function(){var f=this.getFilterProperty();if(!f||!this.getShowFilterMenuEntry()){return false;}var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){if(q.inArray(f,o.getFilterablePropertyNames())>-1&&o.getProperty(f)){return true;}}}return false;};
b.prototype.isGroupableByMenu=function(){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){var r=o.getAnalyticalQueryResult();if(r&&r.findDimensionByPropertyName(this.getLeadingProperty())&&q.inArray(this.getLeadingProperty(),o.getSortablePropertyNames())>-1&&q.inArray(this.getLeadingProperty(),o.getFilterablePropertyNames())>-1){return true;}}}return false;};
return b;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenu',['jquery.sap.global','./ColumnMenu','./library'],function(q,C,l){"use strict";var G=l.GroupEventType;
var A=C.extend("sap.ui.table.AnalyticalColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.table.ColumnMenuRenderer"
});
A.prototype._addMenuItems=function(){C.prototype._addMenuItems.apply(this);if(this._oColumn){this._addSumMenuItem();}};
A.prototype._addGroupMenuItem=function(){var c=this._oColumn,t=this._oTable;if(c.isGroupableByMenu()){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",c.getGrouped()?"accept":null,function(e){var m=e.getSource();var g=c.getGrouped();var s=g?G.group:G.ungroup;c.setGrouped(!g);t.fireGroup({column:c,groupedColumns:t._aGroupedColumns,type:s});m.setIcon(!g?"sap-icon://accept":null);});this.addItem(this._oGroupIcon);}};
A.prototype._addSumMenuItem=function(){var c=this._oColumn,t=this._oTable,b=t.getBinding("rows"),r=b&&b.getAnalyticalQueryResult();if(t&&r&&r.findMeasureByPropertyName(c.getLeadingProperty())){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",c.getSummed()?"accept":null,q.proxy(function(e){var m=e.getSource(),s=c.getSummed();c.setSummed(!s);m.setIcon(!s?"sap-icon://accept":null);},this));this.addItem(this._oSumItem);}};
A.prototype.open=function(){C.prototype.open.apply(this,arguments);var c=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(c.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(c.getGrouped()?"sap-icon://accept":null);};
return A;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenuRenderer',['sap/ui/table/AnalyticalColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/AnalyticalTable.designtime',[],function(){"use strict";return{aggregations:{columns:{domRef:".sapUiTableCHA"},hScroll:{ignore:false,domRef:function(e){return e.$("hsb").get(0);}},vScroll:{ignore:false,domRef:function(e){return e.$("vsb").get(0);}}}};},false);
sap.ui.predefine('sap/ui/table/AnalyticalTable',['jquery.sap.global','./AnalyticalColumn','./Table','./TreeTable','./library','sap/ui/model/analytics/ODataModelAdapter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/unified/Menu','sap/ui/unified/MenuItem','./TableUtils'],function(q,A,T,a,b,O,S,c,M,d,e){"use strict";var G=b.GroupEventType,f=b.SelectionMode,g=b.SortOrder,h=b.TreeAutoExpandMode;
var k=T.extend("sap.ui.table.AnalyticalTable",{
metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0,deprecated:true},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled",deprecated:true},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}},designTime:true},
renderer:"sap.ui.table.TableRenderer"
});
k.prototype._getFixedBottomRowContexts=function(){var B=this.getBinding("rows");if(B){return[B.getGrandTotalNode()];}};
k.prototype._getContexts=a.prototype._getContexts;
k.prototype.init=function(){T.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.attachBrowserEvent("contextmenu",this._onContextMenu);this.setSelectionMode(f.MultiToggle);this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;e.Grouping.setGroupMode(this);};
k.prototype.exit=function(){this._cleanupGroupHeaderMenu();T.prototype.exit.apply(this,arguments);};
k.prototype._adaptLocalization=function(r,l){T.prototype._adaptLocalization.apply(this,arguments);if(l){this._cleanupGroupHeaderMenu();}};
k.prototype.setFixedRowCount=function(){q.sap.log.error("The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!");return this;};
k.prototype.setFixedBottomRowCount=function(){q.sap.log.error("The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!");return this;};
k.prototype.setDirty=function(D){q.sap.log.error("The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.");this.setProperty("dirty",D,true);this.setShowOverlay(this.getDirty());return this;};
k.prototype.setEnableGrouping=function(){q.sap.log.error("The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control");return this;};
k.prototype.setGroupBy=function(){q.sap.log.warning("The groupBy association is not supported by the sap.ui.table.AnalyticalTable control");return this;};
k.prototype.getModel=function(n){var m=T.prototype.getModel.apply(this,arguments);var r=this.getBindingInfo("rows");if(m&&r&&r.model==n){O.apply(m);}return m;};
k.prototype._onBindingChange=function(E){T.prototype._onBindingChange.apply(this,arguments);var r=typeof(E)==="object"?E.getParameter("reason"):E;if(r!=="sort"){this._invalidateColumnMenus();}};
k.prototype._bindAggregation=function(n,B){if(n==="rows"){this.setProperty("firstVisibleRow",0,true);this._applyAnalyticalBindingInfo(B);this._updateTotalRow(true);this._applyODataModelAnalyticalAdapter(B.model);T._addBindingListener(B,"selectionChanged",this._onSelectionChanged.bind(this));}T.prototype._bindAggregation.call(this,n,B);};
k.prototype._initSelectionModel=function(s){this._oSelection=new S(s);return this;};
k.prototype.setSelectionMode=a.prototype.setSelectionMode;
k.prototype._applyAnalyticalBindingInfo=function(B){var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getSorted()){B.sorter=B.sorter||[];B.sorter.push(new c(C[i].getSortProperty()||C[i].getLeadingProperty(),C[i].getSortOrder()===g.Descending));}}B.parameters=B.parameters||{};B.parameters.analyticalInfo=this._getColumnInformation();if(!B.parameters.hasOwnProperty("sumOnTop")){B.parameters.sumOnTop=this.getSumOnTop();}if(!B.parameters.hasOwnProperty("numberOfExpandedLevels")){B.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels();}if(B.parameters.numberOfExpandedLevels>this._aGroupedColumns.length){B.parameters.numberOfExpandedLevels=0;}if(!B.parameters.hasOwnProperty("autoExpandMode")){var E=this.getAutoExpandMode();if(E!=h.Bundled&&E!=h.Sequential){E=h.Bundled;}B.parameters.autoExpandMode=E;}};
k.prototype._applyODataModelAnalyticalAdapter=function(m){if(m!=null){O.apply(m);}};
k.prototype._getColumnInformation=function(){var C=[],t=this.getColumns();for(var i=0;i<this._aGroupedColumns.length;i++){var o=sap.ui.getCore().byId(this._aGroupedColumns[i]);if(!o){continue;}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}for(var i=0;i<t.length;i++){var o=t[i];if(q.inArray(o.getId(),this._aGroupedColumns)>-1){continue;}if(!o instanceof A){q.sap.log.error("You have to use AnalyticalColumns for the Analytical table");}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}return C;};
k.prototype._updateTableContent=function(){var B=this.getBinding("rows"),F=this.getFirstVisibleRow(),j=this.getFixedBottomRowCount(),C=this.getVisibleRowCount(),m=this.getColumns();var r=this.getRows();if(!B){for(var i=0;i<r.length;i++){e.Grouping.cleanupTableRowForGrouping(this,r[i]);}return;}var o=this.getBindingInfo("rows");for(var R=0,l=Math.min(C,r.length);R<l;R++){var I=R>(C-j-1)&&this._getTotalRowCount()>C,n=I?(this._getTotalRowCount()-1-(C-1-R)):F+R,p=r[R],$=p.$(),s=this.$().find("div[data-sap-ui-rowindex="+$.attr("data-sap-ui-rowindex")+"]");var t;if(I&&B.bProvideGrandTotals){t=B.getGrandTotalContextInfo();}else{t=this.getContextInfoByIndex(n);}var L=t?t.level:0;if(!t||!t.context){e.Grouping.cleanupTableRowForGrouping(this,p);if(t&&!t.context){$.addClass("sapUiAnalyticalTableDummy");s.addClass("sapUiAnalyticalTableDummy");}continue;}if(B.nodeHasChildren&&B.nodeHasChildren(t)){e.Grouping.updateTableRowForGrouping(this,p,true,t.nodeState.expanded,t.nodeState.expanded&&!o.parameters.sumOnTop,false,L,B.getGroupName(t.context,t.level));}else{e.Grouping.updateTableRowForGrouping(this,p,false,false,false,t.nodeState.sum,L,t.nodeState.sum&&t.level>0?B.getGroupName(t.context,t.level):null);}var u=p.getCells();for(var i=0,v=u.length;i<v;i++){var w=u[i].data("sap-ui-colindex");var x=m[w];var y=q(u[i].$().closest("td"));if(B.isMeasure(x.getLeadingProperty())){y.addClass("sapUiTableMeasureCell");y.toggleClass("sapUiTableCellHidden",t.nodeState.sum&&!x.getSummed());}else{y.removeClass("sapUiTableMeasureCell");}}}};
k.prototype._onContextMenu=function(E){if(q(E.target).closest('tr').hasClass('sapUiTableGroupHeader')||q(E.target).closest('.sapUiTableRowHdr.sapUiTableGroupHeader').length>0){this._iGroupedLevel=q(E.target).closest('[data-sap-ui-level]').data('sap-ui-level');var m=this._getGroupHeaderMenu();m.openAsContextMenu(E,e.getCell(this,E.target)||E.target);E.preventDefault();E.stopPropagation();return;}return true;};
k.prototype._getGroupHeaderMenu=function(){var t=this;function j(){var i=t._iGroupedLevel-1;if(t._aGroupedColumns[i]){var l=t.getColumns().filter(function(C){return t._aGroupedColumns[i]===C.getId();})[0];return{column:l,index:i};}else{return undefined;}}if(!this._oGroupHeaderMenu){this._oGroupHeaderMenu=new M();this._oGroupHeaderMenuVisibilityItem=new d({text:this._oResBundle.getText("TBL_SHOW_COLUMN"),select:function(){var o=j();if(o){var C=o.column,s=C.getShowIfGrouped();C.setShowIfGrouped(!s);t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:(!s?G.showGroupedColumn:G.hideGroupedColumn)});}}});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText("TBL_UNGROUP"),select:function(){var o=j();if(o!=null&&o.column!=null){var u=o.column;u.setGrouped(false);t.fireGroup({column:u,groupedColumns:t._aGroupedColumns,type:G.ungroup});}}}));this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText("TBL_UNGROUP_ALL"),select:function(){var l=t.getColumns();t.suspendUpdateAnalyticalInfo();for(var i=0;i<l.length;i++){l[i].setGrouped(false);}t.resumeUpdateAnalyticalInfo();t.fireGroup({column:undefined,groupedColumns:[],type:G.ungroupAll});}}));this._oGroupHeaderMoveUpItem=new d({text:this._oResBundle.getText("TBL_MOVE_UP"),select:function(){var o=j();if(o){var C=o.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i>0){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i-1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveUp});}}},icon:"sap-icon://arrow-top"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);this._oGroupHeaderMoveDownItem=new d({text:this._oResBundle.getText("TBL_MOVE_DOWN"),select:function(){var o=j();if(o){var C=o.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i<t._aGroupedColumns.length){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i+1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveDown});}}},icon:"sap-icon://arrow-bottom"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText("TBL_SORT_ASC"),select:function(){var o=j();if(o){var C=o.column;C.sort(false);}},icon:"sap-icon://up"}));this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText("TBL_SORT_DESC"),select:function(){var o=j();if(o){var C=o.column;C.sort(true);}},icon:"sap-icon://down"}));this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding("rows").collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t.clearSelection();}}));this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding("rows").collapseToLevel(0);t.setFirstVisibleRow(0);t.clearSelection();}}));}var o=j();if(o){var C=o.column;if(C.getShowIfGrouped()){this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_HIDE_COLUMN"));}else{this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_SHOW_COLUMN"));}this._oGroupHeaderMoveUpItem.setEnabled(o.index>0);this._oGroupHeaderMoveDownItem.setEnabled(o.index<this._aGroupedColumns.length-1);}else{this._oGroupHeaderMoveUpItem.setEnabled(true);this._oGroupHeaderMoveDownItem.setEnabled(true);}return this._oGroupHeaderMenu;};
k.prototype._cleanupGroupHeaderMenu=function(){if(this._oGroupHeaderMenu){this._oGroupHeaderMenu.destroy();this._oGroupHeaderMenu=null;this._oGroupHeaderMenuVisibilityItem=null;this._oGroupHeaderMoveUpItem=null;this._oGroupHeaderMoveDownItem=null;}};
k.prototype.expand=function(r){var B=this.getBinding("rows");if(B){B.expand(r);}};
k.prototype.collapse=function(r){var B=this.getBinding("rows");if(B){B.collapse(r);}};
k.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};
k.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};
k.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContextByIndex(i):null;};
k.prototype.getContextInfoByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getNodeByIndex(i):null;};
k.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true;};
k.prototype.resumeUpdateAnalyticalInfo=function(s,F){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(s,F);};
k.prototype.addColumn=function(C,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.addColumn.call(this,o,s);this._updateColumns(s);return this;};
k.prototype.insertColumn=function(C,i,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.insertColumn.call(this,o,i,s);this._updateColumns(s);return this;};
k.prototype.removeColumn=function(C,s){var r=T.prototype.removeColumn.apply(this,arguments);if(!this._bReorderInProcess){this._aGroupedColumns=q.grep(this._aGroupedColumns,function(v){if(C.getId){return v!=C.getId();}else{return v==C;}});}this.updateAnalyticalInfo(s);return r;};
k.prototype.removeAllColumns=function(s){this._aGroupedColumns=[];var r=T.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(s);return r;};
k.prototype._getColumn=function(C){if(typeof C==="string"){var o=new A({leadingProperty:C,template:C,managed:true});return o;}else if(C instanceof A){return C;}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");}};
k.prototype._updateColumns=function(s,F){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(s,F);}};
k.prototype.updateAnalyticalInfo=function(s,F){if(this._bSuspendUpdateAnalyticalInfo){return;}var B=this.getBinding("rows");if(B){var C=this._getColumnInformation();var n=B.getNumberOfExpandedLevels()||0;if(n>this._aGroupedColumns.length){B.setNumberOfExpandedLevels(0);}B.updateAnalyticalInfo(C,F);this._updateTotalRow(s);if(!s){this._getRowContexts();}}};
k.prototype.refreshRows=function(){T.prototype.refreshRows.apply(this,arguments);this._updateTotalRow();};
k.prototype._updateTotalRow=function(s){var B=this.getBinding("rows");var F=this.getFixedBottomRowCount();if(B&&(B.providesGrandTotal()&&B.hasTotaledMeasures())){if(F!==1){this.setProperty("fixedBottomRowCount",1,s);}}else{if(F!==0){this.setProperty("fixedBottomRowCount",0,s);}}};
k.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return;}var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult();if(r){var C=this.getColumns(),l=[],u=[],D=[],m={},n,p;for(var i=0;i<C.length;i++){n=C[i];n._isLastGroupableLeft=false;n._bLastGroupAndGrouped=false;n._bDependendGrouped=false;if(!n.getVisible()){continue;}var L=n.getLeadingProperty();p=r.findDimensionByPropertyName(L);if(p){var t=p.getName();if(!m[t]){m[t]={dimension:p,columns:[n]};}else{m[t].columns.push(n);}if(n.getGrouped()&&q.inArray(t,l)==-1){l.push(t);}if(q.inArray(t,D)==-1){D.push(t);}}}u=q.grep(D,function(s){return(q.inArray(s,l)==-1);});if(l.length>0){q.each(l,function(i,s){q.each(m[s].columns,function(j,o){if(!o.getGrouped()){o._bDependendGrouped=true;}});});if(l.length==D.length){p=r.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var v=m[p.getName()].columns;q.each(v,function(i,o){o._bLastGroupAndGrouped=true;});}}if(u.length==1){q.each(m[u[0]].columns,function(j,o){o._isLastGroupableLeft=true;});}}};
k.prototype._getFirstMeasureColumnIndex=function(){var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult(),C=this._getVisibleColumns();if(!r){return-1;}for(var i=0;i<C.length;i++){var o=C[i],l=o.getLeadingProperty();if(r.findMeasureByName(l)||r.findMeasureByPropertyName(l)){return i;}}};
k.prototype.getTotalSize=function(){var B=this.getBinding("rows");if(B){return B.getTotalSize();}return 0;};
k.prototype._onPersoApplied=function(){T.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getGrouped()){this._addGroupedColumn(C[i].getId());}}this._updateColumns();};
k.prototype._addGroupedColumn=function(C){if(this._aGroupedColumns.indexOf(C)===-1){this._aGroupedColumns.push(C);}};
k.prototype._removeGroupedColumn=function(C){var i=this._aGroupedColumns.indexOf(C);if(i>=0){this._aGroupedColumns.splice(i,1);}};
k.prototype.getGroupedColumns=function(){return this._aGroupedColumns;};
k.prototype.setCollapseRecursive=function(C){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(C);}}this.setProperty("collapseRecursive",!!C,true);return this;};
k.prototype._getSelectableRowCount=function(){var B=this.getBinding("rows");if(B==null){return 0;}var r=B.getGrandTotalContextInfo();return r==null?0:r.totalNumberOfLeafs;};
k.prototype.isIndexSelected=a.prototype.isIndexSelected;k.prototype.setSelectedIndex=a.prototype.setSelectedIndex;k.prototype.getSelectedIndices=a.prototype.getSelectedIndices;k.prototype.setSelectionInterval=a.prototype.setSelectionInterval;k.prototype.addSelectionInterval=a.prototype.addSelectionInterval;k.prototype.removeSelectionInterval=a.prototype.removeSelectionInterval;k.prototype.selectAll=a.prototype.selectAll;k.prototype.getSelectedIndex=a.prototype.getSelectedIndex;k.prototype.clearSelection=a.prototype.clearSelection;
k.prototype._isRowSelectable=function(r){var B=this.getBinding("rows");if(B){return B.isIndexSelectable(r);}else{return false;}};
k.prototype._getSelectedIndicesCount=a.prototype._getSelectedIndicesCount;
k.prototype.getAnalyticalInfoOfRow=function(r){if(!this._validateRow(r)){return null;}var B=this.getBindingInfo("rows");var o=this.getBinding("rows");if(!B||!o){return null;}var C=r.getBindingContext(B.model);if(!C){return null;}var I=C===o.getGrandTotalContext();var j=null;var l=-1;if(I){j=o.getGrandTotalContextInfo();l=0;}else{j=this.getContextInfoByIndex(r.getIndex());if(j){l=j.level;}}var m=j&&o.nodeHasChildren&&o.nodeHasChildren(j);var n=!m&&!I&&j&&j.nodeState&&j.nodeState.sum;var p=[];if(n||m){var s=this.getGroupedColumns();if(s.length>0&&l>0&&l<=s.length){for(var i=0;i<l;i++){p.push(s[i]);}}}return{grandTotal:I,group:m,groupTotal:n,level:l,context:C,groupedColumns:p};};
return k;});
sap.ui.predefine('sap/ui/table/AnalyticalTableRenderer',['sap/ui/table/AnalyticalTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/Column',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/library','sap/ui/core/Popup','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/Type','sap/ui/model/type/String','./TableUtils','./library','./ColumnMenu'],function(q,E,c,P,F,a,b,S,T,d,f,g,C){"use strict";var H=c.HorizontalAlign,h=g.SortOrder,V=c.ValueState;
var j=E.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"int",group:"Dimension",defaultValue:0},flexible:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:H.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false},sortOrder:{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:h.Ascending},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},menu:{type:"sap.ui.unified.Menu",multiple:false}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});
j._DEFAULT_FILTER_TYPE=new d();
j.prototype.init=function(){this._oSorter=null;this.mSkipPropagation={template:true};this._aTemplateClones=[];};
j.prototype.exit=function(){this._destroyTemplateClones();C._destroyColumnVisibilityMenuItem();};
j.prototype.setParent=function(p,A,s){var r=E.prototype.setParent.apply(this,arguments);var m=this.getAggregation("menu");if(m&&typeof m._updateReferences==="function"){m._updateReferences(this);}C._destroyColumnVisibilityMenuItem();return r;};
j.prototype.invalidate=function(o){if(o!==this.getTemplate()&&!f.isInstanceOf(o,"sap/ui/table/ColumnMenu")){E.prototype.invalidate.apply(this,arguments);}};
j.prototype.setLabel=function(l){var L=l;if(typeof(l)==="string"){L=g.TableHelper.createLabel({text:l});}this.setAggregation("label",L);return this;};
j.prototype.setTemplate=function(t){var o=t;if(typeof(t)==="string"){o=g.TableHelper.createTextView().bindProperty("text",t);}this.setAggregation("template",o);this.invalidate();this._destroyTemplateClones();var e=this.getParent();if(e&&e.invalidateRowsAggregation&&this.getVisible()==true){e.invalidateRowsAggregation();}return this;};
j.prototype.getMenu=function(){var m=this.getAggregation("menu");if(!m){m=this._createMenu();this.setMenu(m);}return m;};
j.prototype.invalidateMenu=function(u){var m=this.getAggregation("menu");if(this._bMenuIsColumnMenu){if(u){m._updateResourceBundle();}else{m._invalidate();}}};
j.prototype._menuHasItems=function(){var m=this.getAggregation("menu");var t=this.getParent();var M=function(){return(this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupableByMenu()||(t&&t.getEnableColumnFreeze())||(t&&t.getShowColumnVisibilityMenu()));}.bind(this);return!!((m&&m.getItems().length>0)||M());};
j.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry());};
j.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry());};
j.prototype.isGroupableByMenu=function(){var t=this.getParent();return!!(t&&t.getEnableGrouping&&t.getEnableGrouping()&&this.getSortProperty());};
j.prototype.setMenu=function(m){this.setAggregation("menu",m,true);this._bMenuIsColumnMenu=f.isInstanceOf(m,"sap/ui/table/ColumnMenu");return this;};
j.prototype._createMenu=function(){if(!this._defaultMenu){this._defaultMenu=new C(this.getId()+"-menu",{ariaLabelledBy:this});}return this._defaultMenu;};
j.prototype._setAppDefault=function(p,v){if(!this._appDefaults){this._appDefaults={};}if(p=="sorted"){this._appDefaults.sorted=v;}else if(p=="sortOrder"){this._appDefaults.sortOrder=v;}else if(p=="filtered"){this._appDefaults.filtered=v;}else if(p=="filterValue"){this._appDefaults.filterValue=v;}else if(p=="filterOperator"){this._appDefaults.filterOperator=v;}};
j.prototype._restoreAppDefaults=function(){if(this._appDefaults){this.setProperty("sorted",this._appDefaults.sorted,true);this.setProperty("sortOrder",this._appDefaults.sortOrder,true);this.setProperty("filtered",this._appDefaults.filtered,true);this.setProperty("filterValue",this._appDefaults.filterValue,true);this.setProperty("filterOperator",this._appDefaults.filterOperator,true);this._updateIcons();}};
j.prototype.setSortProperty=function(v){this.setProperty("sortProperty",v);this.invalidateMenu();return this;};
j.prototype.setSorted=function(e){this.setProperty("sorted",e,true);this._setAppDefault("sorted",e);this._updateIcons();return this;};
j.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._setAppDefault("sortOrder",t);this._updateIcons();return this;};
j.prototype.setFilterProperty=function(v){this.invalidateMenu();return this.setProperty("filterProperty",v);};
j.prototype.setFiltered=function(e){this.setProperty("filtered",e,true);this._setAppDefault("filtered",e);this._updateIcons();return this;};
j.prototype.setFilterValue=function(v){this.setProperty("filterValue",v,true);this._setAppDefault("filterValue",v);var m=this.getMenu();if(this._bMenuIsColumnMenu){m._setFilterValue(v);}return this;};
j.prototype.setFilterOperator=function(v){this._setAppDefault("filterOperator",v);return this.setProperty("filterOperator",v,true);};
j.prototype._openMenu=function(D,w){var m=this.getMenu();var e=this.fireColumnMenuOpen({menu:m});if(e){var i=P.Dock;var o=D;if(!D){D=this.getDomRef();o=this.getFocusDomRef();}m.open(!!w,o,i.BeginTop,i.BeginBottom,D,"none none");}};
j.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===h.Ascending);};
j.prototype.sort=function(D,A){var t=this.getParent();if(t){t.pushSortedColumn(this,A);var n=D?h.Descending:h.Ascending;var e=t.fireSort({column:this,sortOrder:n,columnAdded:A});if(e){var s=t.getSortedColumns();var k=t.getColumns();for(var i=0,l=k.length;i<l;i++){if(q.inArray(k[i],s)<0){k[i].setProperty("sorted",false,true);k[i].setProperty("sortOrder",h.Ascending,true);k[i]._updateIcons();delete k[i]._oSorter;}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",n,true);this._oSorter=new S(this.getSortProperty(),this.getSortOrder()===h.Descending);var m=[];for(var i=0,l=s.length;i<l;i++){s[i]._updateIcons();m.push(s[i]._oSorter);}var B=t.getBinding("rows");if(B){if(this._updateTableAnalyticalInfo){this._updateTableAnalyticalInfo(true);}B.sort(m);}else{q.sap.log.warning("Sorting not performed because no binding present",this);}}}return this;};
j.prototype._updateIcons=function(){var t=this.getParent(),s=this.getSorted(),e=this.getFiltered();if(!t||!t.getDomRef()){return;}this.$().parents(".sapUiTableCHT").find('td[data-sap-ui-colindex="'+this.getIndex()+'"]').filter(":not([colspan]):visible").first().find(".sapUiTableColCell").toggleClass("sapUiTableColSF",s||e).toggleClass("sapUiTableColFiltered",e).toggleClass("sapUiTableColSorted",s).toggleClass("sapUiTableColSortedD",s&&this.getSortOrder()===h.Descending);t._getAccExtension().updateAriaStateOfColumn(this);};
j.prototype._renderSortIcon=function(){this._updateIcons();};
j.prototype._getFilter=function(){var o,p=this.getFilterProperty(),v=this.getFilterValue(),O=this.getFilterOperator(),s,e,t=this.getFilterType()||j._DEFAULT_FILTER_TYPE,i=t instanceof d,B;if(v){if(!O){B=v.match(/(.*)\s*\.\.\s*(.*)/);if(v.indexOf("=")==0){O=a.EQ;s=v.substr(1);}else if(v.indexOf("!=")==0){O=a.NE;s=v.substr(2);}else if(v.indexOf("<=")==0){O=a.LE;s=v.substr(2);}else if(v.indexOf("<")==0){O=a.LT;s=v.substr(1);}else if(v.indexOf(">=")==0){O=a.GE;s=v.substr(2);}else if(v.indexOf(">")==0){O=a.GT;s=v.substr(1);}else if(B){if(B[1]&&B[2]){O=a.BT;s=B[1];e=B[2];}else if(B[1]&&!B[2]){O=a.GE;s=B[1];}else{O=a.LE;s=B[2];}}else if(i&&v.indexOf("*")==0&&v.lastIndexOf("*")==v.length-1){O=a.Contains;s=v.substr(1,v.length-2);}else if(i&&v.indexOf("*")==0){O=a.EndsWith;s=v.substr(1);}else if(i&&v.lastIndexOf("*")==v.length-1){O=a.StartsWith;s=v.substr(0,v.length-1);}else{if(this.getDefaultFilterOperator()){O=this.getDefaultFilterOperator();}else{if(i){O=a.Contains;}else{O=a.EQ;}}s=v.substr(0);}if(!e){o=new F(p,O,this._parseFilterValue(s));}else{o=new F(p,O,this._parseFilterValue(s),this._parseFilterValue(e));}}else{o=new F(p,O,this._parseFilterValue(v));}}return o;};
j.prototype.filter=function(v){var t=this.getParent();if(t&&t.isBound("rows")){var k=t.fireFilter({column:this,value:v});if(k){this.setProperty("filtered",!!v,true);this.setProperty("filterValue",v,true);var m=this.getMenu();if(this._bMenuIsColumnMenu){m._setFilterValue(v);}var n=[];var o=t.getColumns();for(var i=0,l=o.length;i<l;i++){var p=o[i],r;m=p.getMenu();try{r=p._getFilter();if(p._bMenuIsColumnMenu){m._setFilterState(V.None);}}catch(e){if(p._bMenuIsColumnMenu){m._setFilterState(V.Error);}continue;}if(r){n.push(r);}}t.getBinding("rows").filter(n,b.Control);this._updateIcons();}}return this;};
j.prototype._parseFilterValue=function(v){var o=this.getFilterType();if(o){if(q.isFunction(o)){v=o(v);}else{v=o.parseValue(v,"string");}}return v;};
j.prototype._restoreIcons=function(){this._updateIcons();};
j.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped()&&this.getTemplate()!=null;};
j.PROPERTIES_FOR_ROW_INVALIDATION={visible:true,flexible:true,headerSpan:true};
j.prototype.setProperty=function(n,v){var t=this.getParent();if(t&&t.invalidateRowsAggregation&&this.getProperty(n)!=v&&j.PROPERTIES_FOR_ROW_INVALIDATION[n]&&(this.getVisible()||n=="visible")){t.invalidateRowsAggregation();}return E.prototype.setProperty.apply(this,arguments);};
j.prototype.setFilterType=function(t){var o=t;if(typeof(t)==="string"){try{var m=q.sap.parseJS(t);if(typeof(m.type)==="string"){var e=q.sap.getObject(m.type);o=e&&new e(m.formatOptions,m.constraints);}}catch(i){var e=q.sap.getObject(t);o=e&&new e();}if(!(o instanceof T)){q.sap.log.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");o=undefined;}}this.setProperty("filterType",o,true);return this;};
j.prototype.getIndex=function(){var t=this.getParent();if(t){return t.indexOfColumn(this);}else{return-1;}};
j.prototype._getFreeTemplateClone=function(){var o=null;for(var i=0;i<this._aTemplateClones.length;i++){if(this._aTemplateClones[i]==null||this._aTemplateClones[i].bIsDestroyed){this._aTemplateClones.splice(i,1);i--;}else if(o===null&&this._aTemplateClones[i].getParent()==null){o=this._aTemplateClones[i];}}return o;};
j.prototype.getTemplateClone=function(i){if(i==null){return null;}var o=this._getFreeTemplateClone();if(o===null){var t=this.getTemplate();if(t){o=t.clone();this._aTemplateClones.push(o);}}if(o!=null){o.data("sap-ui-colindex",i);o.data("sap-ui-colid",this.getId());var e=this.getParent();if(e!=null){e._getAccExtension().addColumnHeaderLabel(this,o);}}return o;};
j.prototype._destroyTemplateClones=function(){for(var i=0;i<this._aTemplateClones.length;i++){if(this._aTemplateClones[i]!=null&&!this._aTemplateClones[i].bIsDestroyed){this._aTemplateClones[i].destroy();}}this._aTemplateClones=[];};
j.prototype._closeMenu=function(){var m=this.getAggregation("menu");if(m){m.close();}};
j.prototype.setVisible=function(v){this.setProperty("visible",v);C._updateVisibilityIcon(this.getIndex(),v);return this;};
return j;});
sap.ui.predefine('sap/ui/table/ColumnMenu',['jquery.sap.global','./library','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/unified/MenuTextFieldItem','sap/ui/Device','./TableUtils'],function(q,a,M,b,c,D,T){"use strict";
var C=M.extend("sap.ui.table.ColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.unified.MenuRenderer"
});
C.prototype.init=function(){if(M.prototype.init){M.prototype.init.apply(this,arguments);}this.addStyleClass("sapUiTableColumnMenu");this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bInvalidated=true;this._iPopupClosedTimeoutId=null;this._oColumn=null;this._oTable=null;this._attachPopupClosed();};
C.prototype.exit=function(){if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}window.clearTimeout(this._iPopupClosedTimeoutId);this._oColumn=this._oTable=null;};
C.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate();}};
C.prototype.setParent=function(p){this._invalidate();this._updateReferences(p);return M.prototype.setParent.apply(this,arguments);};
C.prototype._updateReferences=function(p){this._oColumn=p;if(p){this._oTable=this._oColumn.getParent();if(this._oTable){}}};
C._destroyColumnVisibilityMenuItem=function(){if(C._oColumnVisibilityMenuItem){C._oColumnVisibilityMenuItem.destroy();C._oColumnVisibilityMenuItem=null;}};
C.prototype._removeColumnVisibilityFromAggregation=function(){if(!C._oColumnVisibilityMenuItem){return;}this.removeAggregation("items",C._oColumnVisibilityMenuItem,true);};
C.prototype._invalidate=function(){this._bInvalidated=true;};
C.prototype._updateResourceBundle=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._invalidate();};
C.prototype._attachPopupClosed=function(){var t=this;if(!D.support.touch){this.getPopup().attachClosed(function(){t._iPopupClosedTimeoutId=window.setTimeout(function(){if(t._oColumn){if(t._lastFocusedDomRef){t._lastFocusedDomRef.focus();}else{t._oColumn.focus();}}},0);});}};
C.prototype.open=function(){if(this._bInvalidated){this._bInvalidated=false;this._removeColumnVisibilityFromAggregation();this.destroyItems();this._addMenuItems();}else if(this._oColumn){this._addColumnVisibilityMenuItem();}if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];M.prototype.open.apply(this,arguments);}};
C.prototype._addMenuItems=function(){if(this._oColumn){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem();}};
C.prototype._addSortMenuItem=function(d){var o=this._oColumn;if(o.isSortableByMenu()){var s=d?"desc":"asc";var i=d?"sort-descending":"sort-ascending";this.addItem(this._createMenuItem(s,"TBL_SORT_"+s.toUpperCase(),i,function(e){o.sort(d,e.getParameter("ctrlKey")===true);}));}};
C.prototype._addFilterMenuItem=function(){var o=this._oColumn;if(o.isFilterableByMenu()){var t=o.getParent();var d=t&&t.getEnableCustomFilter();if(d){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){t.fireCustomFilter({column:o});}));}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",o.getFilterValue(),function(){o.filter(this.getValue());}));}}};
C.prototype._addGroupMenuItem=function(){var o=this._oColumn;if(o.isGroupableByMenu()){var t=this._oTable;this.addItem(this._createMenuItem("group","TBL_GROUP",null,function(){t.setGroupBy(o);}));}};
C.prototype._addFreezeMenuItem=function(){var o=this._oColumn;var t=this._oTable;var d=t&&t.getEnableColumnFreeze();if(d){var i=o.getIndex();var I=i+T.Column.getHeaderSpan(o)==t.getFixedColumnCount();this.addItem(this._createMenuItem("freeze",I?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){var e=t.fireColumnFreeze({column:o});if(e){if(I){t.setFixedColumnCount(0);}else{t.setFixedColumnCount(i+1);}}}));}};
C.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){if(C._oColumnVisibilityMenuItem&&!C._oColumnVisibilityMenuItem.bIsDestroyed){this.addItem(C._oColumnVisibilityMenuItem);return;}C._oColumnVisibilityMenuItem=this._createMenuItem("column-visibilty","TBL_COLUMNS");var o=new M(C._oColumnVisibilityMenuItem.getId()+"-menu");C._oColumnVisibilityMenuItem.setSubmenu(o);var d=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){var s=t.getColumnVisibilityMenuSorter();if(typeof s==="function"){d=d.sort(s);}}var B=t.getBinding();var A=T.isInstanceOf(B,"sap/ui/model/analytics/AnalyticalBinding");var v=t._getVisibleColumns();for(var i=0,l=d.length;i<l;i++){var e=d[i];if(A&&T.isInstanceOf(e,"sap/ui/table/AnalyticalColumn")){var Q=B.getAnalyticalQueryResult();var E=Q.getEntityType();var m=B.getModel().getProperty("/#"+E.getTypeDescription().name+"/"+e.getLeadingProperty()+"/sap:visible");if(m&&(m.value==="false"||m.value===false)){continue;}}var f=this._createColumnVisibilityMenuItem(o.getId()+"-item-"+i,e);o.addItem(f);if(v.length==1&&v[0]===e){f.setEnabled(false);}}this.addItem(C._oColumnVisibilityMenuItem);}};
C.prototype._createColumnVisibilityMenuItem=function(i,o){function g(l){return l&&l.getText&&l.getText();}var t=o.getName()||g(o.getLabel());if(!t){o.getMultiLabels().forEach(function(l,d){if(T.Column.getHeaderSpan(o,d)===1){t=g(l)||t;}});}return new b(i,{text:t,icon:o.getVisible()?"sap-icon://accept":null,select:q.proxy(function(e){var v=!o.getVisible();if(v||T.getVisibleColumnCount(this._oTable)>1){var d=o.getParent();var E=true;if(d&&T.isInstanceOf(d,"sap/ui/table/Table")){E=d.fireColumnVisibility({column:o,newVisible:v});}if(E){o.setVisible(v);}}},this)});};
C.prototype._createMenuItem=function(i,t,I,h){return new b(this.getId()+"-"+i,{text:this._oResBundle.getText(t),icon:I?"sap-icon://"+I:null,select:h||function(){}});};
C.prototype._createMenuTextFieldItem=function(i,t,I,v,h){h=h||function(){};return new c(this.getId()+"-"+i,{label:this._oResBundle.getText(t),icon:I?"sap-icon://"+I:null,value:v,select:h||function(){}});};
C.prototype._setFilterValue=function(v){var o=this.getParent();var t=(o?o.getParent():undefined);var f=sap.ui.getCore().byId(this.getId()+"-filter");if(f&&(t&&!t.getEnableCustomFilter())){f.setValue(v);}return this;};
C.prototype._setFilterState=function(f){var o=this.getParent();var t=(o?o.getParent():undefined);var F=sap.ui.getCore().byId(this.getId()+"-filter");if(F&&(t&&!t.getEnableCustomFilter())){F.setValueState(f);}return this;};
C._updateVisibilityIcon=function(i,v){if(C._oColumnVisibilityMenuItem){var I=v?"sap-icon://accept":"";var s=C._oColumnVisibilityMenuItem.getSubmenu();if(!s){return;}var d=s.getItems();var o=d.find(function(e){return e.getId().endsWith("-item-"+i);});if(!o){return;}o.setProperty("icon",I);}};
return C;});
sap.ui.predefine('sap/ui/table/ColumnMenuRenderer',['sap/ui/table/ColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/Row',['jquery.sap.global','sap/ui/core/Element','sap/ui/model/Context','./TableUtils'],function(q,E,C,T){"use strict";
var R=E.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},_rowAction:{type:"sap.ui.table.RowAction",multiple:false,visibility:"hidden"},_settings:{type:"sap.ui.table.RowSettings",multiple:false,visibility:"hidden"}}}});
R.prototype.init=function(){this.initDomRefs();};
R.prototype.exit=function(){this.initDomRefs();};
R.prototype.getFocusInfo=function(){var t=this.getParent();return t?t.getFocusInfo():E.prototype.getFocusInfo.apply(this,arguments);};
R.prototype.applyFocusInfo=function(f){var t=this.getParent();if(t){t.applyFocusInfo(f);}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};
R.prototype.addStyleClass=function(s){q(this.getDomRefs(false,true)).addClass(s);};
R.prototype.removeStyleClass=function(s){q(this.getDomRefs(false,true)).removeClass(s);};
R.prototype.initDomRefs=function(){this._mDomRefs={};};
R.prototype.getIndex=function(){var t=this.getParent();if(t){var r=t.indexOfRow(this);var n=t.getFixedRowCount();if(n>0&&r<n){return r;}var N=t.getFixedBottomRowCount();var v=t.getVisibleRowCount();if(N>0&&r>=v-N){var i=t._getTotalRowCount();if(i>=v){return i-(v-r);}else{return r;}}var f=t.getFirstVisibleRow();return f+r;}return-1;};
R.prototype.getDomRefs=function(j,c){var k=(j===true)?"jQuery":"dom",a=(j===true)?q.sap.byId:q.sap.domById,d=this._mDomRefs;if(!d[k]){d[k]={};var t=this.getParent();if(t){var r=t.indexOfRow(this);d[k].rowSelector=a(t.getId()+"-rowsel"+r);d[k].rowAction=a(t.getId()+"-rowact"+r);}d[k].rowScrollPart=a(this.getId());d[k].rowFixedPart=a(this.getId()+"-fixed");d[k].rowSelectorText=a(this.getId()+"-rowselecttext");if(j===true){d[k].row=d[k].rowScrollPart;if(d[k].rowFixedPart.length>0){d[k].row=d[k].row.add(d[k].rowFixedPart);}else{d[k].rowFixedPart=undefined;}if(d[k].rowSelector&&d[k].rowSelector.length>0){d[k].row=d[k].row.add(d[k].rowSelector);}else{d[k].rowSelector=undefined;}if(d[k].rowAction&&d[k].rowAction.length>0){d[k].row=d[k].row.add(d[k].rowAction);}else{d[k].rowAction=undefined;}}}var K=d[k];if(c){return Object.keys(K).map(function(k){return K[k];}).filter(Boolean);}return K;};
R.prototype._updateSelection=function(t,m,s){var i=t.isIndexSelected(this.getIndex());var d=this.getDomRefs(true);var S="rowSelect";if(i){S="rowDeselect";}if(d.rowSelector){d.rowSelector.attr("title",!this._bHidden?m.mouse[S]:"");}if(d.rowSelectorText){var a="";if(!this._bHidden&&!T.Grouping.isInSumRow(d.rowSelector)&&!T.Grouping.isInGroupingRow(d.rowSelector)){a=m.keyboard[S];}d.rowSelectorText.text(a);}var r=d.rowScrollPart;if(d.rowFixedPart){r=r.add(d.rowFixedPart);}if(s&&!this._bHidden){r.attr("title",m.mouse[S]);}else{r.removeAttr("title");}if(d.row){d.row.toggleClass("sapUiTableRowSel",i);t._getAccExtension().updateAriaStateOfRow(this,d,i);}};
R.prototype.setRowBindingContext=function(c,m,b){var n;if(c&&!(c instanceof C)){n=c;c=c.context;}var $=this.getDomRefs(true).row;this._bHidden=!c;$.toggleClass("sapUiTableRowHidden",this._bHidden);this._collectRenderingInformation(c,n,b);this.setBindingContext(c,m);};
R.prototype.setBindingContext=function(c,m){var r=E.prototype.setBindingContext.call(this,c||null,m);this._updateTableCells(c);return r;};
R.prototype._updateTableCells=function(c){var t=this.getParent();if(!t){return;}var a=this.getCells(),A=this.getIndex(),h=!!t._updateTableCell,o,$,H;for(var i=0;i<a.length;i++){o=a[i];H=!!o._updateTableCell;$=H||h?o.$().closest("td"):null;if(H){o._updateTableCell(o,c,$,A);}if(h){t._updateTableCell(o,c,$,A);}}};
R.prototype._collectRenderingInformation=function(c,n,b){this._oNodeState=undefined;this._iLevel=0;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="";if(n){this._oNodeState=n.nodeState;this._iLevel=n.level;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="sapUiTableTreeIconLeaf";this._sGroupIconClass="";if(b){if(b.getLevel){this._bIsExpanded=b.isExpanded(this.getIndex());}else if(b.findNode){this._bIsExpanded=this&&this._oNodeState?this._oNodeState.expanded:false;}if(b.nodeHasChildren){if(this._oNodeState){this._bHasChildren=b.nodeHasChildren(n);}}else if(b.hasChildren){this._bHasChildren=b.hasChildren(c);}if(this._bHasChildren){this._sTreeIconClass=this._bIsExpanded?"sapUiTableTreeIconNodeOpen":"sapUiTableTreeIconNodeClosed";this._sGroupIconClass=this._bIsExpanded?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";}}}};
R.prototype.destroy=function(){this.removeAllCells();return E.prototype.destroy.apply(this,arguments);};
R.prototype.getDragGhost=function(){var t=this.getParent();var o=t.getDomRef();var r=this.getDomRefs();var g;var G;var a;var s=t._getSelectedIndicesCount();function b(e){e.removeAttribute("id");e.removeAttribute("data-sap-ui");e.removeAttribute("data-sap-ui-related");var f=e.children.length;for(var i=0;i<f;i++){b(e.children[i]);}}function c(o,e){var f=o.cloneNode();var h=o.querySelector("thead").cloneNode(true);var i=o.querySelector("tbody").cloneNode();var j=e.cloneNode(true);i.appendChild(j);f.appendChild(h);f.appendChild(i);return f;}g=o.cloneNode();g.classList.add("sapUiTableRowGhost");g.classList.remove("sapUiTableVScr");g.classList.remove("sapUiTableHScr");g.style.width=o.getBoundingClientRect().width+"px";if(r.rowSelector!=null){G=t.getDomRef("sapUiTableRowHdrScr").cloneNode();a=r.rowSelector.cloneNode(true);G.appendChild(a);g.appendChild(G);}if(r.rowFixedPart!=null){G=t.getDomRef("sapUiTableCtrlScrFixed").cloneNode();a=c(t.getDomRef("table-fixed"),r.rowFixedPart);G.appendChild(a);g.appendChild(G);}if(r.rowScrollPart!=null){var S=t.getDomRef("sapUiTableCtrlScr");G=S.cloneNode();a=c(t.getDomRef("table"),r.rowScrollPart);G.appendChild(t.getDomRef("tableCtrlCnt").cloneNode());G.firstChild.appendChild(a);g.appendChild(G);}if(r.rowAction!=null){G=t.getDomRef("sapUiTableRowActionScr").cloneNode();a=r.rowAction.cloneNode(true);G.appendChild(a);g.appendChild(G);}if(s>1){G=document.createElement("div");G.classList.add("sapUiTableRowGhostCount");var d=document.createElement("div");d.textContent=s;G.appendChild(d);g.appendChild(G);}b(g);return g;};
return R;});
sap.ui.predefine('sap/ui/table/RowAction',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/core/Icon','sap/ui/unified/Menu','sap/ui/core/Popup','jquery.sap.keycodes'],function(q,C,l,I,M,P){"use strict";
var R=C.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}}});
R.prototype.init=function(){var s=function(T){this.setAggregation("tooltip",T,true);this.setSrc(this.getSrc());return this;};var o=function(e){this._bKeyboard=e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER;I.prototype.onkeyup.apply(this,arguments);};var t=this;var i=new I(this.getId()+"-icon0",{decorative:false,press:function(e){t._handlePress(e,true);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);i=new I(this.getId()+"-icon1",{decorative:false,press:function(e){t._handlePress(e,false);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._iLen=0;this._iCount=2;this._aActions=["",""];this._iLastCloseTime=0;};
R.prototype.onAfterRendering=function(){this._updateIcons();};
R.prototype.setVisible=function(v){this.setProperty("visible",v,true);this.$().toggleClass("sapUiTableActionHidden",!v);return this;};
R.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);var T=this.getTooltip_AsString();if(!T){this.$().removeAttr("title");}else{this.$().attr("title",T);}return this;};
R.prototype.insertItem=function(i,a){this.insertAggregation("items",i,a,true);this._updateIcons(true);return this;};
R.prototype.addItem=function(i){this.addAggregation("items",i,true);this._updateIcons(true);return this;};
R.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true);this._updateIcons(true);return r;};
R.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",true);this._updateIcons(true);return r;};
R.prototype.destroyItems=function(){this.destroyAggregation("items",true);this._updateIcons(true);return this;};
R.prototype.getAccessibilityInfo=function(){var p=this.$().parent();var a=this.getVisible()&&this._iLen>0&&this._iCount>0&&!p.hasClass("sapUiTableRowHidden")&&!p.hasClass("sapUiTableGroupHeader")&&!p.hasClass("sapUiAnalyticalTableSum");var t;if(a){t=this._oResBundle.getText(this._iLen==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[this._iLen]);}else{t=this._oResBundle.getText("TBL_ROW_ACTION_NO_ACTION");}return{focusable:a,enabled:a,description:t};};
R.prototype._getVisibleItems=function(f){if(!this._aVisibleItems||f){this._aVisibleItems=[];this._iLen=0;var a=this.getItems();for(var i=0;i<a.length;i++){if(a[i].getVisible()){this._aVisibleItems.push(a[i]);this._iLen++;}}}return this._aVisibleItems;};
R.prototype._getRow=function(){return this.getParent();};
R.prototype._getCount=function(){return this._iCount;};
R.prototype._setCount=function(c){if(c<0){this._iCount=0;}else if(c>=0){this._iCount=Math.min(c,2);}this._updateIcons();};
R.prototype._setFixedLayout=function(f){this._bFixedLayout=!!f;this._updateIcons();};
R.prototype._setIconLabel=function(L){var a=this.getAggregation("_icons");for(var i=0;i<a.length;i++){a[i].removeAllAriaLabelledBy();if(L){a[i].addAriaLabelledBy(L);}}};
R.prototype._handlePress=function(e,f){var a=f?0:1;var o=this.getAggregation("_icons")[a];var A=this._aActions[a];var k=o._bKeyboard;o._bKeyboard=false;if(A=="action"){this._getVisibleItems()[a]._doFirePress();}else if(A=="action_fixed"){this._getVisibleItems()[0]._doFirePress();}else if(A=="menu"){var m=this.getAggregation("_menu");if(!m){m=new M();this.setAggregation("_menu",m,true);m.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now();},this);}m.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return;}var b=this.getItems();for(var i=f?0:1;i<b.length;i++){m.addItem(b[i]._getMenuItem());}m.open(!!k,o,P.Dock.EndTop,P.Dock.EndBottom,o);}};
R.prototype._updateIcons=function(f){var i=this._getVisibleItems(f);var a=this.getAggregation("_icons");var $=this.$().children();function s(b){a[0].$()[b==0?"attr":"removeAttr"]("aria-haspopup",b==0?"true":undefined);a[1].$()[b==1?"attr":"removeAttr"]("aria-haspopup",b==1?"true":undefined);}if(this._bFixedLayout&&this._iLen==1&&this._iCount==2){var A=this.getItems();if(A.length>1&&i[0]===A[1]){i[0]._syncIcon(a[1]);q($.get(0)).toggleClass("sapUiTableActionHidden",true);q($.get(1)).toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["","action_fixed"];return;}}if(this._iLen==0||this._iCount==0){$.toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["",""];}else if(this._iLen==1&&this._iCount>0){i[0]._syncIcon(a[0]);q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["action",""];}else if(this._iLen==2&&this._iCount==2){i[0]._syncIcon(a[0]);i[1]._syncIcon(a[1]);$.toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["action","action"];}else if(this._iLen>2&&this._iCount==2){i[0]._syncIcon(a[0]);a[1].setSrc("sap-icon://overflow");a[1].setTooltip(this._oResBundle.getText("TBL_ROW_ACTION_MORE"));$.toggleClass("sapUiTableActionHidden",false);s(1);this._aActions=["action","menu"];}else{a[0].setSrc("sap-icon://overflow");a[0].setTooltip(this._oResBundle.getText("TBL_ROW_ACTION_MORE"));q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(0);this._aActions=["menu",""];}};
return R;});
sap.ui.predefine('sap/ui/table/RowActionItem',['sap/ui/core/Element','./library','sap/ui/unified/MenuItem'],function(E,l,M){"use strict";var R=l.RowActionType;
var I=E.extend("sap.ui.table.RowActionItem",{metadata:{library:"sap.ui.table",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Misc",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.ui.table.RowActionType",group:"Behavior",defaultValue:R.Custom}},events:{press:{item:{type:"sap.ui.table.RowActionItem"},row:{type:"sap.ui.table.Row"}}}}});
I.prototype.exit=function(){if(this._menuItem){this._menuItem.destroy();this._menuItem=null;}};
I.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._updateRowAction();return this;};
I.prototype.setText=function(t){this.setProperty("text",t,true);this._updateRowAction();return this;};
I.prototype.setType=function(t){this.setProperty("type",t,true);this._updateRowAction();return this;};
I.prototype.setVisible=function(v){this.setProperty("visible",v,true);this._updateRowAction(true);return this;};
I.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);this._updateRowAction();return this;};
I.prototype._doFirePress=function(){var p=this.getParent();this.firePress({item:this,row:p&&p._getRow?p._getRow():null});};
I.prototype._getMenuItem=function(){if(!this._menuItem){var t=this;this._menuItem=new M({select:function(e){t._doFirePress();}});}this._menuItem.setIcon(this._getIcon());this._menuItem.setVisible(this.getVisible());this._menuItem.setText(this._getText(false));return this._menuItem;};
I.prototype._getIcon=function(){var i=this.getIcon();if(i){return i;}if(this.getType()==R.Navigation){return"sap-icon://navigation-right-arrow";}if(this.getType()==R.Delete){return"sap-icon://sys-cancel";}return null;};
I.prototype._getText=function(p){var t=p?(this.getTooltip_AsString()||this.getText()):(this.getText()||this.getTooltip_AsString());if(t){return t;}if(this.getType()==R.Navigation){return this.getParent()._oResBundle.getText("TBL_ROW_ACTION_NAVIGATE");}if(this.getType()==R.Delete){return this.getParent()._oResBundle.getText("TBL_ROW_ACTION_DELETE");}return null;};
I.prototype._syncIcon=function(i){i.setSrc(this._getIcon());i.setTooltip(this._getText(true));};
I.prototype._updateRowAction=function(f){var p=this.getParent();if(p&&p._updateIcons){p._updateIcons(f);}};
return I;});
sap.ui.predefine('sap/ui/table/RowActionRenderer',['sap/ui/table/Row'],function(R){"use strict";var a={};
a.render=function(r,A){r.write("<div");r.writeControlData(A);r.addClass("sapUiTableAction");if(!(A.getParent()instanceof R)){r.addStyle("display","none");}if(!A.getVisible()){r.addClass("sapUiTableActionHidden");}r.writeClasses();r.writeStyles();var t=A.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");var i=A.getAggregation("_icons");r.write("<div>");r.renderControl(i[0]);r.write("</div>");r.write("<div>");r.renderControl(i[1]);r.write("</div>");r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/table/RowSettings',['sap/ui/core/Element','./TableUtils','./library','sap/ui/core/library'],function(E,T,l,c){"use strict";var M=c.MessageType;
var R=E.extend("sap.ui.table.RowSettings",{metadata:{library:"sap.ui.table",properties:{highlight:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:"None"}}}});
R.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");};
R.prototype.setHighlight=function(h){var r;var H;this.setProperty("highlight",h,true);r=this._getRow();if(r==null){return this;}H=r.getDomRef("highlight");if(H==null){return this;}for(var m in M){H.classList.remove("sapUiTableRowHighlight"+m);}H.classList.add(this._getHighlightCSSClassName());var t=r.getParent();var a=t!=null?t._getAccExtension():null;if(a!=null){a.updateAriaStateOfRowHighlight(this);}return this;};
R.prototype._getHighlightCSSClassName=function(){var h=this.getHighlight();if(h==null){h=M.None;}return"sapUiTableRowHighlight"+h;};
R.prototype._getHighlightText=function(){var h=this.getHighlight();if(h==null||h===M.None){return"";}return this._oResBundle.getText("TBL_ROW_STATE_"+h.toUpperCase());};
R.prototype._getRow=function(){var r=this.getParent();if(T.isInstanceOf(r,"sap/ui/table/Row")){return r;}else{return null;}};
return R;});
sap.ui.predefine('sap/ui/table/Table.designtime',[],function(){"use strict";return{aggregations:{columns:{domRef:".sapUiTableCHA"},hScroll:{ignore:false,domRef:function(e){return e.$("hsb").get(0);}},vScroll:{ignore:false,domRef:function(e){return e.$("vsb").get(0);}}}};},false);
sap.ui.predefine('sap/ui/table/Table',['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','./TableDragAndDropExtension','jquery.sap.dom','jquery.sap.trace','jquery.sap.events'],function(q,D,C,E,I,b,F,S,c,B,d,R,e,T,f,g,h,j,k,m){"use strict";var G=e.GroupEventType,N=e.NavigationMode,n=e.SelectionMode,o=e.SelectionBehavior,p=e.SortOrder,V=e.VisibleRowCountMode;
var r=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:n.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:o.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},dragDropConfig:{name:"dragDropConfig",type:"sap.ui.core.dnd.DragDropBase",multiple:true,singularName:"dragDropConfig"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});
I.insertFontFaceStyle();
r.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bRowAggregationInvalid=true;this._mTimeouts={};this._bHideStandardTooltips=false;this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;this._aRowHeights=[];this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];var t=this;this._performUpdateRows=function(s){if(!t.bIsDestroyed){t._lastCalledUpdateRows=Date.now();t._updateBindingContexts();if(!t._bInvalid){t._updateTableContent();t._getAccExtension().updateAccForCurrentCell(false);t._updateSelection();t._collectTableSizes();t._aRowHeights=t._collectRowHeights(false);t._updateRowHeights(t._collectRowHeights(true),true);t._updateRowHeights(t._aRowHeights,false);if(T.isVariableRowHeightEnabled(t)){t._getScrollExtension().updateInnerVerticalScrollRangeCache(t._aRowHeights);t._iRenderedFirstVisibleRow=this.getFirstVisibleRow();}t._getScrollExtension().updateVerticalScrollbarVisibility();if(T.isVariableRowHeightEnabled(t)){t._getScrollExtension().updateInnerVerticalScrollPosition(t._aRowHeights);}}t._mTimeouts.bindingTimer=undefined;t._fireRowsUpdated(s);}};this._initSelectionModel(S.MULTI_SELECTION);this._aTableHeaders=[];this._aIdxCols2Cells=[];this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;};
r.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}f.enrich(this,j);f.enrich(this,k);f.enrich(this,h);f.enrich(this,g);f.enrich(this,m);this._bExtensionsInitialized=true;};
r.prototype.exit=function(){this._bExitCalled=true;this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();if(this._oSelection){this._oSelection.destroy();}delete this._aTableHeaders;};
r.prototype._detachExtensions=function(){f.cleanup(this);};
r.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};
r.prototype.onlocalizationChanged=function(a){var i=a.changes||{};var l=i.hasOwnProperty("rtl");var L=i.hasOwnProperty("language");if(l||L){this._adaptLocalization(l,L);this.invalidate();}};
r.prototype._adaptLocalization=function(a,l){if(a){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){var s=this.getRows();var i;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");var t;for(i=0;i<s.length;i++){t=s[i].getAggregation("_rowAction");if(t){t._oResBundle=this._oResBundle;}}var u;for(i=0;i<s.length;i++){u=s[i].getAggregation("_settings");if(u){u._oResBundle=this._oResBundle;}}T.Menu.cleanupDataCellContextMenu(this);this._invalidateColumnMenus(true);}};
r.prototype._collectRowHeights=function(H){var a=this.getDomRef();if(!a){return[];}if(H&&this.getColumnHeaderHeight()){return[];}var l=this._getDefaultRowHeight();var s=H?".sapUiTableColHdrTr":".sapUiTableTr";var t=a.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+s);var u=a.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+s);var v=this.getRows().length;var w=[];var x=D.browser.chrome&&window.devicePixelRatio!=1;for(var i=0;i<v;i++){var y=t[i]==null?0:t[i].getBoundingClientRect().height;var z=u[i]==null?0:u[i].getBoundingClientRect().height;var A=Math.max(y,z);if(x){var J=l-A;if(J>0&&J<1){w.push(Math.max(A,l-1));continue;}}w.push(Math.max(A,l));}return w;};
r.prototype._resetRowHeights=function(){var a=this.getRowHeight();var s="";if(a){s=a+"px";}var l=this.getDomRef();if(l){var t=l.querySelectorAll(".sapUiTableTr");for(var i=0;i<t.length;i++){t[i].style.height=s;}}};
r.prototype._resetColumnHeaderHeights=function(){if(this.getColumnHeaderHeight()){return;}var a=this.getDomRef();if(a){var l=a.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<l.length;i++){l[i].style.height=null;}}};
r.prototype._determineAvailableSpace=function(){var a=this.getDomRef();if(a&&a.parentNode){var i=a.querySelector(".sapUiTableCCnt");if(i){var u=a.scrollHeight-i.clientHeight;var t=0;if(a.parentNode.firstChild!==a){var P=parseFloat(window.getComputedStyle(a.parentNode).paddingTop);if(isNaN(P)){P=0;}t=a.offsetTop-P;}u+=18;if(this._iLastAvailableSpace==null){this._iLastAvailableSpace=0;}var l=Math.floor(q(a.parentNode).height()-u-t);var A=Math.abs(l-this._iLastAvailableSpace);if(A>=5){this._iLastAvailableSpace=l;}return this._iLastAvailableSpace;}}return 0;};
r.prototype._collectTableSizes=function(){var s={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var a=this.getDomRef();if(!a){return s;}var l=a.querySelector(".sapUiTableCnt");if(l){s.tableCntHeight=l.clientHeight;s.tableCntWidth=l.clientWidth;}var t=a.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(t){s.tableCtrlScrollWidth=t.clientWidth;}var u=a.querySelector(".sapUiTableRowHdrScr");if(u){s.tableRowHdrScrWidth=u.clientWidth;}var v=a.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(v){s.tableCtrlScrWidth=v.clientWidth;}var H=this._getScrollExtension().getHorizontalScrollbar();if(H){s.tableHSbScrollLeft=H.scrollLeft;}var w=a.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(w){s.tableCtrlFixedWidth=w.clientWidth;}var x=this.getProperty("fixedColumnCount");var y=0;if(x){var z=this.getColumns();var A=a.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<A.length;i++){var J=parseInt(A[i].getAttribute("data-sap-ui-headcolindex"),10);if(!isNaN(J)&&(J<x)){var K=z[J];var W;if(K._iFixWidth!=null){W=K._iFixWidth;}else{W=A[i].getBoundingClientRect().width;}y+=W;}}}if(y>0){var U=s.tableRowHdrScrWidth;var L=this.getDomRef("vsb");if(L){U+=L.offsetWidth;}if(T.hasRowActions(this)){var M=this.getDomRef("sapUiTableRowActionScr");if(M){U+=M.offsetWidth;}}U+=T.Column.getMinColumnWidth();var O=s.tableCntWidth-U;var P=O>y;var Q=!P;if(this._bIgnoreFixedColumnCount!==Q){this._bIgnoreFixedColumnCount=Q;this.invalidate();}}return s;};
r.prototype.getAggregationDomRef=function(a){if(a=="rows"){return this.getDomRef("tableCCnt");}};
r.prototype._updateRowHeights=function(i,H){var l=this.getDomRef();if(!l){return;}if(H&&this.getColumnHeaderHeight()){return;}function u(y,z){var A=i[z];if(A){y.style.height=A+"px";}}var s=H?".sapUiTableColHdrTr":".sapUiTableTr";var t=H?[]:l.querySelectorAll(".sapUiTableRowHdr");var v=H?[]:l.querySelectorAll(".sapUiTableRowAction");var w=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+s);var x=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+s);var a=[];a.forEach.call(t,u);a.forEach.call(v,u);a.forEach.call(w,u);a.forEach.call(x,u);};
r.prototype.onBeforeRendering=function(a){if(a&&a.isMarked("renderRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var v=this.getVisibleRowCountMode();var i=this.getRows();if(v==V.Interactive||v==V.Fixed||(v==V.Auto&&this._iTableRowContentHeight&&i.length==0)){this.getBinding("rows");this._updateRows(this._calculateRowsToDisplay(),T.RowsUpdateReason.Render);}else if(this._bRowAggregationInvalid&&i.length>0){this._updateRows(i.length,T.RowsUpdateReason.Render);}this._aTableHeaders=[];};
r.prototype.onAfterRendering=function(a){var s=a&&a.isMarked("renderRows");if(s){var t=this._getScrollExtension();t.updateVerticalScrollbarHeight();t.updateVerticalScrollHeight();}this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var u=this.getColumns();for(var i=0,l=u.length;i<l;i++){if(u[i].getVisible()){u[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection&&!s){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();this._updateTableContent();this.getDomRef().classList.remove("sapUiTableRActFlexible");if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,T.RowsUpdateReason.Render,true));}else{this._updateTableSizes(T.RowsUpdateReason.Render,null,s,s&&T.isVariableRowHeightEnabled(this));}if(!s){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");if(this.getBinding("rows")){this._fireRowsUpdated(T.RowsUpdateReason.Render);}}};
r.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var v=C.prototype.invalidate.call(this);T.Column.invalidateColumnUtils(this);}return v;};
r.prototype._initRowDomRefs=function(){var a=this.getRows();for(var i=0;i<a.length;i++){a[i].initDomRefs();}};
r.prototype._updateTableSizes=function(s,a,l,t){var u=this.getDomRef();var v=this;if(this._bInvalid||!u){return;}if(u.offsetWidth===0){T.deregisterResizeHandler(this,"");P();return;}this._resetRowHeights();this._resetColumnHeaderHeights();this._aRowHeights=this._collectRowHeights(false);var w=this._collectRowHeights(true);if(T.isVariableRowHeightEnabled(this)){this._getScrollExtension().updateInnerVerticalScrollRangeCache(this._aRowHeights);}var x=null;if(!l&&this.getVisibleRowCountMode()==V.Auto){x=this._determineAvailableSpace();if(this._handleRowCountModeAuto(x,s)&&!a){return;}}T.deregisterResizeHandler(this,"");function y(Q){var U=Q.getDomRef();var W=T.Column.getMinColumnWidth();var X=[];var Y=Q.getColumnHeaderVisible();function Z(b1,c1){if(b1<=c1){return Math.max(b1,c1-5,W)+"px";}return-1;}function _(c1){var d1=Math.max(c1._minWidth||0,W,c1.getMinWidth());var e1=c1.getWidth();var f1;var g1;var h1;if(T.isVariableWidth(e1)&&!T.isFixedColumn(Q,c1.getIndex())){f1=U.querySelectorAll('th[data-sap-ui-colid="'+c1.getId()+'"]');g1=f1[Y?0:1];h1=g1?g1.offsetWidth:null;if(h1!==null){if(h1<=d1){return{headers:f1,newWidth:Z(h1,d1)};}else if(g1&&g1.style.width!=e1){X.push({col:c1,header:g1,minWidth:d1,headers:f1});return{headers:f1,newWidth:e1};}X.push({col:c1,header:g1,minWidth:d1,headers:f1});}}return null;}function a1(c1){if(c1){Array.prototype.forEach.call(c1.headers,function(d1){d1.style.width=c1.newWidth;});}}Q._getVisibleColumns().map(_).forEach(a1);if(X.length){var b1;for(var i=0;i<X.length;i++){b1=X[i].header&&X[i].header.offsetWidth;X[i].newWidth=Z(b1,X[i].minWidth);if(parseInt(X[i].newWidth,10)>=0){a1(X[i]);}}}}y(this);var z=this._collectTableSizes();if(z.tableCntHeight==0&&z.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(w,true);this._determineVisibleCols(z);if(!l||t){this._setRowContentHeight(x);}if(this.getVisibleRowCountMode()==V.Auto){var A=this._calculateRowsToDisplay(x!=null?x:this._determineAvailableSpace());if(A==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}}var H=this._getScrollExtension();H.updateHorizontalScrollbar(z);H.updateVerticalScrollbarPosition();H.updateVerticalScrollbarVisibility();var $=this.$();if(T.hasRowActions(this)){var J=$.hasClass("sapUiTableRActFlexible");var K=this.getDomRef("dummycolhdr");var L=K?K.clientWidth:0;if(!J&&L>0){var M=z.tableCtrlScrWidth+z.tableRowHdrScrWidth+z.tableCtrlFixedWidth-L;var O={width:"auto"};O[this._bRtlMode?"right":"left"]=M;this.$("sapUiTableRowActionScr").css(O);this.$("rowacthdr").css(O);$.toggleClass("sapUiTableRActFlexible",true);}else if(J&&L<=0){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");function P(){T.registerResizeHandler(v,"",v._onTableResize.bind(v),true);}if($.closest(".sapUiLoSplitter").length){P();}else{Promise.resolve().then(P);}};
r.prototype.setShowOverlay=function(s){s=!!s;this.setProperty("showOverlay",s,true);if(this.getDomRef()){var a=document.activeElement;this.$().toggleClass("sapUiTableOverlay",s);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);}return this;};
r.prototype._updateFixedBottomRows=function(){var i=this.getFixedBottomRowCount();var a=this.getDomRef();if(a&&i>0){var $=q(a).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var l=q(a).find(".sapUiTableFixedFirstBottomRow");l.removeClass("sapUiTableFixedFirstBottomRow");var s=T.getFirstFixedButtomRowIndex(this);var t=this.getRows();var u;if(s>=0&&s<t.length){u=t[s].getDomRefs(true);u.row.addClass("sapUiTableFixedFirstBottomRow",true);}if(s>=1&&s<t.length){u=t[s-1].getDomRefs(true);u.row.addClass("sapUiTableFixedPreBottomRow",true);}}};
r.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};
r.prototype.applyFocusInfo=function(a){if(a&&a.customId){q.sap.byId(a.customId,this.getDomRef()).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};
r.prototype.setTitle=function(t){var a=t;if(typeof(t)==="string"||t instanceof String){a=e.TableHelper.createTextView({text:t,width:"100%"});a.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",a);return this;};
r.prototype.setFooter=function(v){var a=v;if(typeof(v)==="string"||v instanceof String){a=e.TableHelper.createTextView({text:v,width:"100%"});}this.setAggregation("footer",a);return this;};
r.prototype.setSelectionMode=function(s){this.clearSelection();if(s===n.Single){this._oSelection.setSelectionMode(S.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(S.MULTI_SELECTION);}s=T.sanitizeSelectionMode(this,s);this.setProperty("selectionMode",s);return this;};
r.prototype.setFirstVisibleRow=function(i,O,s){if(parseInt(i,10)<0){q.sap.log.error("The index of the first visible row must be greater than or equal to 0."+" The value has been set to 0.",this);i=0;}if(this._getTotalRowCount()>0){var M=this._getMaxRowIndex();if(T.isVariableRowHeightEnabled(this)){M++;}if(M<i){q.sap.log.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+M+".",this);i=M;}}var a=this.getFirstVisibleRow()!=i;if(a){this.setProperty("firstVisibleRow",i,true);if(this.getBinding("rows")){var l=O===true?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(l);if(!O){this._getScrollExtension().updateVerticalScrollPosition();}}if(!s){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}return this;};
r.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
r.prototype.bindAggregation=function(s){if(s==="rows"){return this.bindRows.apply(this,[].slice.call(arguments,1));}return C.prototype.bindAggregation.apply(this,arguments);};
r.prototype.bindRows=function(a){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._iPendingRequests=0;this._bPendingRequest=false;return C.prototype.bindAggregation.call(this,"rows",r._getSanitizedBindingInfo(arguments));};
r.prototype._bindAggregation=function(s,a){if(s==="rows"){r._addBindingListener(a,"change",this._onBindingChange.bind(this));r._addBindingListener(a,"dataRequested",this._onBindingDataRequested.bind(this));r._addBindingListener(a,"dataReceived",this._onBindingDataReceived.bind(this));}E.prototype._bindAggregation.call(this,s,a);var i=this.getBinding("rows");if(s==="rows"&&i!=null){var M=i.getModel();if(M!=null&&M.getDefaultBindingMode()===B.OneTime){q.sap.log.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}this._initSelectionModel(S.MULTI_SELECTION);};
r._getSanitizedBindingInfo=function(a){var i;if(a==null||a[0]==null){i=null;}else if(typeof a[0]==="string"){var P=a[0];var t=a[1];var s=a[2];var l=a[3];if(t instanceof c||q.isArray(s)&&s[0]instanceof F){l=s;s=t;t=undefined;}i={path:P,sorter:s,filters:l,template:t};}else{i=a[0];}return i;};
r._addBindingListener=function(a,s,H){if(a.events==null){a.events={};}if(a.events[s]==null){a.events[s]=H;}else{var O=a.events[s];a.events[s]=function(){H.apply(this,arguments);O.apply(this,arguments);};}};
r.prototype._initSelectionModel=function(s){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new S(s);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};
r.prototype._onBindingChange=function(a){var s=typeof(a)==="object"?a.getParameter("reason"):a;if(s==="sort"||s==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};
r.prototype.unbindAggregation=function(s,a){var i=this.getBinding("rows");if(s==="rows"&&this.isBound("rows")){a=true;}var v=E.prototype.unbindAggregation.apply(this,[s,a]);if(s==="rows"&&i){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateTotalRowCount(true);this.updateRows(T.RowsUpdateReason.Unbind);}return v;};
r.prototype.setVisibleRowCount=function(v){if(v!=null&&!isFinite(v)){return this;}var s=this.getVisibleRowCountMode();if(s==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var i=this.getFixedRowCount()+this.getFixedBottomRowCount();if(v<=i&&i>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+v+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}v=this.validateProperty("visibleRowCount",v);if(this.getBinding("rows")!=null&&this._getTotalRowCount()<=v){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",v);this._setRowContentHeight(v*this._getDefaultRowHeight());return this;};
r.prototype.setRowHeight=function(i){this.setProperty("rowHeight",i);this._iTableRowContentHeight=undefined;return this;};
r.prototype.setTooltip=function(t){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",t,true);};
r.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};
r.prototype._getFixedBottomRowContexts=function(i,a){var l=this.getBinding("rows");var s=[];if(!l){return s;}i=i||this.getFixedBottomRowCount();a=a||this._getTotalRowCount();var v=this.getVisibleRowCount();if(i>0&&(v-i)<a){s=this._getContexts(a-i,i,1);}return s;};
r.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};
r.prototype._getContexts=function(s,l,t){var a=this.getBinding("rows");if(a){return a.getContexts(s,l,t);}else{return[];}};
r.prototype._getRowContexts=function(v,s,a){var l=this.getBinding("rows");var t=v==null?this.getRows().length:v;if(!l||t<=0){return[];}s=s===true;a=a===true;var u=this.getFirstVisibleRow();var w=this.getFixedRowCount();var x=this.getFixedBottomRowCount();var y=0;var z;var A=[];var H;var L=t-x;var M=0;var J=L;var K=this.getThreshold();K=K?Math.max(t,K):0;var O=u;var P=function(W,X,O){for(var i=0;i<X.length;i++){W[O+i]=X[i];}};if(w>0&&u>0){O=u+w;L-=w;M=w;H=this._getFixedRowContexts(w);y+=H.length;A=A.concat(H);}H=this._getContexts(O,L,K);var Q=this._updateTotalRowCount(!s);z=H.length<Math.min(L,Q-x);y+=H.length;P(A,H,M);J=Math.min(J,Math.max(Q-x,0));if(x>0){H=this._getFixedBottomRowContexts(x,Q);y+=H.length;P(A,H,J);}if(z&&!a){if(Q>0){var U=this._getMaxRowIndex();if(U<u){u=U;this.setProperty("firstVisibleRow",u,true);A=this._getRowContexts(t,s,true);y=A.length;}}}return A;};
r.prototype._updateTotalRowCount=function(u){if(this._iBindingLength===null){this._iBindingLength=0;}var a=this.getBinding("rows");var i=this._getTotalRowCount();var l=a==null?0:a.getLength();if(i!==l){if(u!==false){var s=this._getScrollExtension();this._iBindingLength=l;this._updateFixedBottomRows();s.updateVerticalScrollbarVisibility();s.updateVerticalScrollHeight();if(!a||!T.hasPendingRequests(this)){this._updateNoData();}}}return l;};
r.prototype.refreshRows=function(v){var a=this.getBinding("rows");if(!a){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var t=this;var s=typeof(v)==="object"?v.getParameter("reason"):v;var i=this.getVisibleRowCountMode();if((this.bOutput&&i===V.Auto)||i!==V.Auto){if(this.bOutput){a.attachEventOnce("dataRequested",function(){if(t._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(t._mTimeouts.refreshRowsAdjustRows);}t._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){t._updateRows(t._calculateRowsToDisplay(),s,false);},0);});}if(s===b.Filter||s===b.Sort){this.setFirstVisibleRow(0);}var l=s!=null;this._updateBindingContexts(this._calculateRowsToDisplay(),l);}};
r.prototype.updateRows=function(s){if(this._bExitCalled){return;}var v=this.getVisibleRowCountMode();if((this.getRows().length<=0||this._bRowAggregationInvalid)&&((v==V.Auto&&this.bOutput)||v!=V.Auto)){if(this._iTableRowContentHeight){this._updateRows(this._calculateRowsToDisplay(),s);}}if(!this.bIsDestroyed){var i=(s===b.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||s===T.RowsUpdateReason.Unbind?0:this._iBindingTimerDelay);var t=this;if(i===0&&s){Promise.resolve().then(function(){t._performUpdateRows(s);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){t._performUpdateRows(s);},i);}}};
r.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};
r.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};
r.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};
r.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};
r.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};
r.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};
r.prototype._attachEvents=function(){var $=this.$();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(a){if(q(a.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}f.attachEvents(this);};
r.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);f.detachEvents(this);};
r.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){window.clearTimeout(this._mTimeouts[K]);delete this._mTimeouts[K];}}};
r.prototype._updateBindingContexts=function(i,s){var a=this.getBinding("rows");var l;s=s===true;if(a!=null){l=this._getRowContexts(i,s);}if(!s){this._resetRowHeights();var t=this.getRows(),u=this.mBindingInfos["rows"],M=u&&u.model;for(var v=t.length-1;v>=0;v--){var w=l?l[v]:undefined;var x=t[v];if(x){x.setRowBindingContext(w,M,a);}}}};
r.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var a=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);};
r.prototype._determineVisibleCols=function(t){var a=[];this.getColumns().forEach(function(l,i){if(l.shouldRender()){a.push(i);}});};
r.prototype.removeColumn=function(a,s){var i=this.removeAggregation('columns',a,s);if(typeof a==="number"&&a>-1){a=this.getColumns()[a];}var l=q.inArray(a,this._aSortedColumns);if(!this._bReorderInProcess&&l>=0){this._aSortedColumns.splice(l,1);}this.invalidateRowsAggregation();return i;};
r.prototype.removeAllColumns=function(){var a=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};
r.prototype.destroyColumns=function(){var a=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};
r.prototype.addColumn=function(a,s){this.addAggregation('columns',a,s);this.invalidateRowsAggregation();return this;};
r.prototype.insertColumn=function(a,i,s){this.insertAggregation('columns',a,i,s);this.invalidateRowsAggregation();return this;};
r.prototype._getTotalRowCount=function(){if(this._iBindingLength===null){var a=this.getBinding("rows");return a==null?0:a.getLength();}else{return this._iBindingLength;}};
r.prototype._getSelectableRowCount=function(){return this._getTotalRowCount();};
r.prototype._getScrollableRowCount=function(){return Math.max(1,this.getVisibleRowCount()-this.getFixedRowCount()-this.getFixedBottomRowCount());};
r.prototype._getMaxRowIndex=function(){var M=this._getTotalRowCount()-this.getVisibleRowCount();if(T.isVariableRowHeightEnabled(this)){M-=1;}return Math.max(0,M);};
r.prototype._getVisibleColumns=function(){var a=[];var s=this.getColumns();for(var i=0,l=s.length;i<l;i++){if(s[i].shouldRender()){a.push(s[i]);}}return a;};
r.prototype._getColumnsWidth=function(s,a){var t=this.getColumns();var u=0;if(s!==0&&!s){s=0;}if(a!==0&&!a){a=t.length;}for(var i=s,l=a;i<l;i++){if(t[i]&&t[i].shouldRender()){u+=this._CSSSizeToPixel(t[i].getWidth());}}return u;};
r.prototype._CSSSizeToPixel=function(s,a){var P=T.Column.getMinColumnWidth();if(s){if(q.sap.endsWith(s,"px")){P=parseInt(s,10);}else if(q.sap.endsWith(s,"em")||q.sap.endsWith(s,"rem")){P=Math.ceil(parseFloat(s)*this._getBaseFontSize());}}if(a){return P+"px";}else{return parseInt(P,10);}};
r.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};
r.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};
r.prototype._handleRowCountModeAuto=function(t,s){t=t||this._determineAvailableSpace();var a=this.getBinding("rows");var i=this._calculateRowsToDisplay(t);if(a&&this.getRows().length>0){return this._updateRows(i,s);}else{var l=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var u=this.getBusyIndicatorDelay();var v=this.getEnableBusyIndicator();var w=this;if(a&&v){this.setBusyIndicatorDelay(0);this.setBusy(true);}if(t){this._setRowContentHeight(t);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!w._updateRows(i,s)){w._updateTableSizes(s,false,true);}delete w._mTimeouts.handleRowCountModeAutoAdjustRows;if(a&&v){w.setBusyIndicatorDelay(u);w.setBusy(false);}},0);return l;}};
r.prototype._disableTextSelection=function(a){q(a||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(i){i.preventDefault();return false;});};
r.prototype._enableTextSelection=function(a){q(a||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};
r.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(a){}}};
r.prototype._findAndfireCellEvent=function(a,i,l){var $=q(i.target);var s=$.closest("td.sapUiTableTd");var t=s.attr("id");var M=/.*-row(\d*)-col(\d*)/i.exec(t);var u=false;if(M){var v=M[1];var w=M[2];var x=this.getRows()[v];var y=x&&x.getCells()[w];var z=x&&x.getIndex();var A=y.data("sap-ui-colid");var H;if(this.getBindingInfo("rows")){H=x.getBindingContext(this.getBindingInfo("rows").model);}var P={rowIndex:z,columnIndex:w,columnId:A,cellControl:y,rowBindingContext:H,cellDomRef:s.get(0)};u=!a.call(this,P);if(!u&&typeof l==="function"){P.cellDomRef=s[0];u=l.call(this,P);}}return u;};
r.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var a=T.getFocusedItemInfo(this);if(a!==null){return a.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};
r.prototype._isRowSelectable=function(i){return i>=0&&i<this._getTotalRowCount();};
r.prototype.pushSortedColumn=function(a,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(a);};
r.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};
r.prototype.sort=function(a,s,A){if(!a){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var l=this.getBinding("rows");if(l){l.sort();}this._aSortedColumns=[];}if(q.inArray(a,this.getColumns())>=0){a.sort(s===p.Descending,A);}};
r.prototype.filter=function(a,v){if(q.inArray(a,this.getColumns())>=0){a.filter(v);}};
r.prototype._updateSelection=function(){var s=this.getSelectionMode();if(s===n.None){return;}var t=this._getAccExtension().getAriaTextsForSelectionMode(true);var a=T.isRowSelectionAllowed(this);var l=this.getRows();for(var i=0;i<l.length;i++){var u=l[i];u._updateSelection(this,t,a);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);if(T.hasSelectAll(this)){var $=this.$("selall");var A=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!A);this._getAccExtension().setSelectAllState(A);if(this._getShowStandardTooltips()){var v=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";$.attr('title',this._oResBundle.getText(v));}}};
r.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};
r.prototype._onSelectionChanged=function(a){var i=a.getParameter("rowIndices");var s=a.getParameter("selectAll");var l=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();this.fireRowSelectionChange({rowIndex:l,rowContext:this.getContextByIndex(l),rowIndices:i,selectAll:s,userInteraction:this._iSourceRowIndex!==undefined});};
r.prototype.getContextByIndex=function(i){var a=this.getBinding("rows");return i>=0&&a?a.getContexts(i,1)[0]:null;};
r.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};
r.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};
r.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};
r.prototype.selectAll=function(){if(!T.hasSelectAll(this)){return this;}var a=this.getBinding("rows");if(a){this._oSelection.selectAll(this._getTotalRowCount()-1);}return this;};
r.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};
r.prototype.addSelectionInterval=function(i,a){if(this.getSelectionMode()===e.SelectionMode.None){return this;}this._oSelection.addSelectionInterval(i,a);return this;};
r.prototype.setSelectionInterval=function(i,a){if(this.getSelectionMode()===e.SelectionMode.None){return this;}this._oSelection.setSelectionInterval(i,a);return this;};
r.prototype.removeSelectionInterval=function(i,a){this._oSelection.removeSelectionInterval(i,a);return this;};
r.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};
r.prototype.setGroupBy=function(v){var a=v;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof a==="string"){a=sap.ui.getCore().byId(a);}var i=false;if(a!=null&&a instanceof d&&a!==O){if(q.inArray(a,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var l=this.fireGroup({column:a,groupedColumns:[a.getId()],type:G.group});if(O!=null){O.setGrouped(false);i=true;}if(l&&this.getEnableGrouping()){a.setGrouped(true);}}if(a==null||i){if(O!=null){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",a);};
r.prototype.getBinding=function(s){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[s||"rows"]);};
r.prototype.setEnableGrouping=function(a){var i=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",a);if(i!=null){i.setGrouped(a);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};
r.prototype.setEnableCustomFilter=function(a){this.setProperty("enableCustomFilter",a);this._invalidateColumnMenus();return this;};
r.prototype.setEnableColumnFreeze=function(a){this.setProperty("enableColumnFreeze",a);this._invalidateColumnMenus();return this;};
r.prototype.setShowColumnVisibilityMenu=function(s){this.setProperty("showColumnVisibilityMenu",s);this._invalidateColumnMenus();return this;};
r.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};
r.prototype.setFixedColumnCount=function(a,s){var l=this.getColumns();var t,i;for(i=a-1;i>=0;i--){t=l[i];if(t&&t.getVisible()){a=Math.max(a,t.getIndex()+T.Column.getHeaderSpan(t));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=a-1;i>=0;i--){t=l[i];if(t&&T.isVariableWidth(t.getWidth())){t._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+t.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",a,s);this._collectTableSizes();this._invalidateColumnMenus();return this;};
r.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};
r.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};
r.prototype.setThreshold=function(t){this.setProperty("threshold",t,true);};
r.prototype._invalidateColumnMenus=function(u){var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){a[i].invalidateMenu(u);}};
r.prototype._isTouchEvent=function(a){return a!=null&&a.originalEvent!=null&&a.originalEvent.touches!=null;};
r.prototype._getRowClone=function(a){var s=new R(this.getId()+"-rows"+"-row"+a);var t=this.getColumns();for(var i=0,l=t.length;i<l;i++){if(t[i].getVisible()){var u=t[i].getTemplateClone(i);if(u){s.addCell(u);}}}if(T.hasRowActions(this)){var v=this.getRowActionTemplate().clone();v._setFixedLayout(true);v._setCount(this.getRowActionCount());v._setIconLabel(this.getId()+"-rowacthdr");s.setAggregation("_rowAction",v,true);}var w=this.getRowSettingsTemplate();if(w){var x=w.clone();s.setAggregation("_settings",x,true);}return s;};
r.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};
r.prototype._updateRows=function(a,s,u){if(isNaN(a)){return false;}if(u==null){u=true;}if(T.isVariableRowHeightEnabled(this)){a=a+1;}var i;var l=this.getRows();if(this._bRowAggregationInvalid&&l.length>0){this.destroyAggregation("rows",true);l=[];}if(a==l.length){return false;}for(i=l.length-1;i>=a;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",a-1,true);}else{this.setProperty("visibleRowCount",a,true);}this._ignoreInvalidateOfChildControls=true;var t;var v;var M;var w=this.getBinding("rows");if(u){v=this.getBindingInfo("rows");M=v&&v.model;t=this._getRowContexts(a);for(i=0;i<l.length;i++){l[i].setRowBindingContext(t[i],M,w);}}if(l.length<a){for(i=l.length;i<a;i++){var x=this._getRowClone(i);if(u){x.setRowBindingContext(t[i],M,w);}this.addAggregation("rows",x,true);this._bRowAggregationInvalid=false;if(u){x._updateTableCells(t[i]);}}}this._ignoreInvalidateOfChildControls=false;var y=u&&t.length>0;return this._renderRows(s,y);};
r.prototype._renderRows=function(s,a){var i=false;a=a===true;if(!this._bInvalid){var t=this.getDomRef("tableCCnt");if(this.getRows().length===0||!t){return false;}this._detachEvents();if(this.getVisibleRowCountMode()===V.Auto){var l=this.getDomRef();if(l){l.style.height="0px";}}var u=q.Event("BeforeRendering");u.setMarked("renderRows");u.srcControl=this;this._handleEvent(u);var v=new sap.ui.getCore().createRenderManager(),w=this.getRenderer();w.renderTableCCnt(v,this);v.flush(t,false,false);v.destroy();u=q.Event("AfterRendering");u.setMarked("renderRows");u.srcControl=this;this._handleEvent(u);i=true;}if(a&&!this._bInvalid&&this.getBinding("rows")){var x=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){x._fireRowsUpdated(s);},0);}return i;};
r.prototype._getDefaultRowHeight=function(){var i=this.getRowHeight();if(i>0){return i;}else{var s=T.getContentDensity(this);return T.DEFAULT_ROW_HEIGHT[s];}};
r.prototype._setRowContentHeight=function(H){H=H||0;var v=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var a=this._getDefaultRowHeight();var M=this.getMinAutoRowCount();var l;if(v==V.Interactive||v==V.Fixed){if(this._iTableRowContentHeight&&v==V.Interactive){l=M*a;if(!H){H=this._iTableRowContentHeight;}}else{l=i*a;H=l;}}else if(v==V.Auto){l=M*a;}var s=Math.max(H,l);if((v==V.Fixed&&this.getRows().length==0)||v!=V.Fixed){this._iTableRowContentHeight=Math.floor(s/a)*a;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",a*this.getVisibleRowCount()+"px");}else{if((v==V.Fixed||v==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}};
r.prototype._determineMinAutoRowCount=function(){var v=this.getVisibleRowCount();var M=this.getMinAutoRowCount();var i=M||v||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){i=v||M||5;}return i;};
r.prototype._calculateRowsToDisplay=function(t){this._iRowsToDisplayHeight=t||this._iRowsToDisplayHeight||this._iTableRowContentHeight;t=this._iRowsToDisplayHeight;var v=this.getVisibleRowCountMode();var i=0;if(v==V.Fixed){i=this.getVisibleRowCount()||0;}else if(v==V.Interactive||v==V.Auto){var M=this._determineMinAutoRowCount();var a=this._getDefaultRowHeight();if(!a||!t){i=M;}else{var A=Math.min(t,50000);var l=Math.floor(A/a);i=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(M,l));}}return Math.max(i,0);};
r.prototype.setShowNoData=function(s){this.setProperty('showNoData',s,true);this._updateNoData();return this;};
r.prototype.exportData=function(s){var a=sap.ui.requireSync("sap/ui/core/util/Export");s=s||{};if(!s.rows){var t=this.getBinding("rows"),u=this.getBindingInfo("rows");var v=t.aFilters.concat(t.aApplicationFilters);s.rows={path:u.path,model:u.model,sorter:t.aSorters,filters:v,parameters:u.parameters};}if(!s.exportType){var w=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");s.exportType=new w();}var M=s.rows.model;if(!M){var P=s.rows.path;var x=P.indexOf(">");if(x>0){M=P.substr(0,x);}}if(!s.columns){s.columns=[];var y=this.getColumns();for(var i=0,l=y.length;i<l;i++){var z=y[i];if(z.getSortProperty()){s.columns.push({name:z.getLabel().getText(),template:{content:{path:z.getSortProperty(),model:M}}});}}}var A=new a(s);this.addDependent(A);return A;};
r.prototype._onPersoApplied=function(){var a=this.getColumns();var s=[];for(var i=0,l=a.length;i<l;i++){var t=a[i];if(t.getSorted()){s.push(new c(t.getSortProperty(),t.getSortOrder()===p.Descending));}}var u=this.getBinding("rows");if(u){if(s.length>0){u.sort(s);}this.refreshRows();}};
r.prototype._toggleSelectAll=function(){if(!T.hasData(this)){return;}if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}this._iSourceRowIndex=undefined;};
r.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var a=this.getColumns();q.each(a,function(i,l){l._restoreAppDefaults();});};
r.prototype.setBusy=function(a,s){var i=this.getBusy()!=a;s="sapUiTableCnt";var v=C.prototype.setBusy.call(this,a,s);if(i){this.fireBusyStateChanged({busy:a});}return v;};
r.prototype.setEnableBusyIndicator=function(v){this.setProperty("enableBusyIndicator",v,true);if(!v){this.setBusy(false);}};
r.prototype._onBindingDataRequested=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var i=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(i&&this._iPendingRequests===1||!i)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};
r.prototype._onBindingDataReceived=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;this._updateTotalRowCount(true);if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;});}};
r.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};
r.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};
r.prototype._updateTableContent=function(){T.Grouping.updateGroups(this);};
r.prototype.setRowActionTemplate=function(t){this.setAggregation("rowActionTemplate",t);t=this.getRowActionTemplate();if(t){t._setCount(this.getRowActionCount());}this.invalidateRowsAggregation();return this;};
r.prototype.setRowActionCount=function(a){this.setProperty("rowActionCount",a);a=this.getRowActionCount();var l=this.getRowActionTemplate();if(l){l._setCount(a);}var s=this.getRows();for(var i=0;i<s.length;i++){l=s[i].getAggregation("_rowAction");if(l){l._setCount(a);}}return this;};
r.prototype.setRowSettingsTemplate=function(t){this.setAggregation("rowSettingsTemplate",t);this.invalidateRowsAggregation();return this;};
r.prototype._validateRow=function(a){return a&&a instanceof R&&a.getParent()===this;};
r.prototype.getRowForCell=function(a){if(a){var i=a.getParent();if(this._validateRow(i)){return i;}}return null;};
r.prototype.getColumnForCell=function(a){if(this.getRowForCell(a)){var i=a.data("sap-ui-colindex");var l=this.getColumns();if(i>=0&&i<l.length){return l[i];}}return null;};
r.prototype.getCellControl=function(i,a,v){var l=T.getRowColCell(this,i,a,!v);return l.cell;};
r.prototype._fireRowsUpdated=function(s){if(s==null){s=T.RowsUpdateReason.Unknown;}this.fireEvent("_rowsUpdated",{reason:s});};
return r;});
sap.ui.predefine('sap/ui/table/TableAccExtension',["jquery.sap.global","sap/ui/core/Control","./library","./TableExtension","./TableAccRenderExtension","./TableUtils","sap/ui/Device"],function(q,C,l,T,a,b,D){"use strict";var S=l.SelectionMode;var c=b.CELLTYPE;var A={getAccInfoOfControl:function(o,B){if(o&&typeof o.getAccessibilityInfo==="function"){if(typeof o.getVisible==="function"&&!o.getVisible()){return A._normalize({});}var s=o.getAccessibilityInfo();if(s){var t={};A._flatten(s,t,B);return t;}}return null;},_normalize:function(i){if(!i){return null;}if(i._normalized){return i;}i.role=i.role||"";i.type=i.type||"";i.description=i.description||"";i.focusable=!!i.focusable;i.enabled=(i.enabled===true||i.enabled===false)?i.enabled:null;i.editable=(i.editable===true||i.editable===false)?i.editable:null;i.children=i.children||[];i._normalized=true;return i;},_flatten:function(s,t,B,L){L=L?L:0;A._normalize(s);if(L==0){A._normalize(t);t._descriptions=[];}t.focusable=t.focusable||s.focusable;t._descriptions.push(A._getFullDescription(s,B));s.children.forEach(function(o){if(!o.getAccessibilityInfo||(o.getVisible&&!o.getVisible())){return;}var e=o.getAccessibilityInfo();if(e){A._flatten(e,t,B,L+1);}});if(L==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined;}},_getFullDescription:function(i,B){var s=i.type+" "+i.description;if(i.enabled!=null&&!i.enabled){s=s+" "+B.getText("TBL_CTRL_STATE_DISABLED");}else if(i.editable!=null&&!i.editable){s=s+" "+B.getText("TBL_CTRL_STATE_READONLY");}return s.trim();}};var E={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();var i=b.getFocusedItemInfo(t);return i.cellInRow-(b.hasRowHeader(t)?1:0);},getInfoOfFocusedCell:function(e){var t=e.getTable();var i=t._getItemNavigation();var o=t.getDomRef();if(!e.getAccMode()||!o||!i){return null;}var f=i.getFocusedDomRef();if(!f||f!==document.activeElement){return null;}return b.getCellInfo(f);},getRelevantColumnHeaders:function(t,o){if(!t||!o){return[];}var h=b.getHeaderRowCount(t),s=o.getId(),L=[s];if(h>1){for(var i=1;i<h;i++){L.push(s+"_"+i);}var e=b.Column.getParentSpannedColumns(t,s);if(e&&e.length){for(var i=0;i<e.length;i++){var f=e[i].level;var p=e[i].column.getId();L[f]=f===0?p:(p+"_"+f);}}}return L;},isHiddenCell:function($,o){var g=b.Grouping.isInGroupingRow($);var s=b.Grouping.isInSumRow($);var e=!!o&&!!o.hasStyleClass;var i=$.parent().hasClass("sapUiTableRowHidden");var I=$.hasClass("sapUiTableCellHidden");var n=g&&$.hasClass("sapUiTableTdFirst")&&!$.hasClass("sapUiTableMeasureCell");var G=g&&e&&o.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");var f=s&&e&&o.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return i||I||n||G||f;},isTreeColumnCell:function(e,$){return b.Grouping.isTreeMode(e.getTable())&&$.hasClass("sapUiTableTdFirst");},getColumnTooltip:function(o){if(!o){return null;}var t=o.getTooltip_AsString();if(t){return t;}var L=o.getLabel();if(L instanceof C){t=L.getTooltip_AsString();}if(t){return t;}return null;},updateRowColCount:function(e){var t=e.getTable(),i=t._getItemNavigation(),I=false,f=false,g=false;if(i){var h=E.getColumnIndexOfFocusedCell(e)+1;var r=b.getRowIndexOfFocusedCell(t)+t.getFirstVisibleRow()+1;var j=b.getVisibleColumnCount(t)+(b.hasRowActions(t)?1:0);var R=b.isNoDataVisible(t)?0:b.getTotalRowCount(t,true);I=e._iLastRowNumber!=r||(e._iLastRowNumber==r&&e._iLastColumnNumber==h);f=e._iLastColumnNumber!=h;g=!e._iLastRowNumber&&!e._iLastColumnNumber;t.$("rownumberofrows").text(I?t._oResBundle.getText("TBL_ROW_ROWCOUNT",[r,R]):" ");t.$("colnumberofcols").text(f?t._oResBundle.getText("TBL_COL_COLCOUNT",[h,j]):" ");t.$("ariacount").text(g?t._oResBundle.getText("TBL_DATA_ROWS_COLS",[R,j]):" ");e._iLastRowNumber=r;e._iLastColumnNumber=h;}return{rowChange:I,colChange:f,initial:g};},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null;}},storeDefaultsBeforeCellModifications:function(e,$,f,g){e._cleanupInfo={cell:$,attr:{"aria-labelledby":f&&f.length?f.join(" "):null,"aria-describedby":g&&g.length?g.join(" "):null}};},performCellModifications:function(e,$,f,g,L,h,t,i){E.storeDefaultsBeforeCellModifications(e,$,f,g);var o=E.updateRowColCount(e);e.getTable().$("cellacc").text(t||" ");if(i){i(L,h,o.rowChange,o.colChange,o.initial);}var s="";if(o.initial){var j=e.getTable();s=j.getAriaLabelledBy().join(" ")+" "+j.getId()+"-ariadesc "+j.getId()+"-ariacount";if(j.getSelectionMode()!==S.None){s=s+" "+j.getId()+"-ariaselection";}}if(L&&L.length){s=s+" "+L.join(" ");}$.attr({"aria-labelledby":s?s:null,"aria-describedby":h&&h.length?h.join(" "):null});},modifyAccOfDATACELL:function($,o){var t=this.getTable(),s=t.getId(),i=t._getItemNavigation();if(!i){return;}var r=b.getRowIndexOfFocusedCell(t),e=E.getColumnIndexOfFocusedCell(this),f=b.getRowColCell(t,r,e,false),I=null,h=E.isHiddenCell($,f.cell),g=E.isTreeColumnCell(this,$),j=b.Grouping.isInGroupingRow($),k=b.Grouping.isInSumRow($),m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.DATACELL,{index:e,column:f.column,fixed:b.isFixedColumn(t,e)})["aria-labelledby"]||[],n=[],L=[s+"-rownumberofrows",s+"-colnumberofcols"];if(j){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(k){var p=$.parent().data("sap-ui-level");if(p==0){L.push(s+"-ariagrandtotallabel");}else if(p>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}if(b.hasRowHighlights(t)&&!j&&!k){L.push(f.row.getId()+"-highlighttext");}L=L.concat(m);if(!h){I=A.getAccInfoOfControl(f.cell,t._oResBundle);L.push(I?(s+"-cellacc"):f.cell.getId());if(((!I||I.focusable)&&!this._readonly)||(g&&f.row&&f.row._bHasChildren)){n.push(s+"-toggleedit");}if(b.Grouping.isTreeMode(t)&&!!$.parent().attr("aria-selected")){L.push(s+"-ariarowselected");}}var u=I?I.description:" ";if(g&&!h){var v=E.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:f.row});if(v&&v["aria-label"]){u=v["aria-label"]+" "+u;}}E.performCellModifications(this,$,m,null,L,n,u,function(L,n,R,w,x){if(!h&&b.isRowSelectionAllowed(t)&&R){n.push(f.row.getId()+"-rowselecttext");}});},modifyAccOfROWHEADER:function($,o){var t=this.getTable(),s=t.getId(),i=b.Grouping.isInGroupingRow($),I=b.Grouping.isInSumRow($),r=t.getRows()[$.attr("data-sap-ui-rowindex")],e=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[],L=e.concat([s+"-rownumberofrows"]);if(!I&&!i){if(!$.hasClass("sapUiTableRowHidden")){L.push(r.getId()+"-rowselecttext");if(b.hasRowHighlights(t)){L.push(r.getId()+"-highlighttext");}}}if(i){L.push(s+"-ariarowgrouplabel");}if(I){var f=$.data("sap-ui-level");if(f==0){L.push(s+"-ariagrandtotallabel");}else if(f>0){L.push(s+"-ariagrouptotallabel");}}E.performCellModifications(this,$,e,null,L,null,null);},modifyAccOfCOLUMNHEADER:function($,o){var t=this.getTable(),e=sap.ui.getCore().byId($.attr("data-sap-ui-colid")),m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:$.attr("id"),column:e,index:$.attr("data-sap-ui-colindex")}),s=E.getColumnTooltip(e),L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]),f=b.getCellInfo($),i=f.columnSpan;if(i>1){L.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(t._oResBundle.getText("TBL_COL_DESC_SPAN",[""+i]));}if(s){L.push(t.getId()+"-cellacc");}if(i<=1&&e&&e.getSorted()){L.push(t.getId()+(e.getSortOrder()==="Ascending"?"-ariacolsortedasc":"-ariacolsorteddes"));}if(i<=1&&e&&e.getFiltered()){L.push(t.getId()+"-ariacolfiltered");}if(i<=1&&$.attr("aria-haspopup")==="true"){L.push(t.getId()+"-ariacolmenu");}E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],s);},modifyAccOfCOLUMNROWHEADER:function($,o){var t=this.getTable(),e=$.hasClass("sapUiTableSelAllEnabled");t.$("sapUiTableGridCnt").removeAttr("role");var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNROWHEADER,{enabled:e,checked:e&&!t.$().hasClass("sapUiTableSelAll")});E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],m["aria-labelledby"],m["aria-describedby"],null);},modifyAccOfROWACTION:function($,o){var t=this.getTable(),s=t.getId(),i=b.Grouping.isInGroupingRow($),I=b.Grouping.isInSumRow($),r=$.attr("data-sap-ui-rowindex"),R=t.getRows()[r],h=E.isHiddenCell($),e=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWACTION)["aria-labelledby"]||[],L=[s+"-rownumberofrows",s+"-colnumberofcols"].concat(e),f=[];if(i){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(I){var g=$.data("sap-ui-level");if(g==0){L.push(s+"-ariagrandtotallabel");}else if(g>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}if(!I&&!i&&$.attr("aria-selected")=="true"){L.push(s+"-ariarowselected");}if(b.hasRowHighlights(t)&&!i&&!I){L.push(R.getId()+"-highlighttext");}var j="";if(!h){var k=R.getAggregation("_rowAction");if(k){var m=k.getAccessibilityInfo();if(m){L.push(s+"-cellacc");j=m.description;if(m.focusable){f.push(s+"-toggleedit");}}}}E.performCellModifications(this,$,e,[],L,f,j);},getAriaAttributesFor:function(e,t,p){var m={},o=e.getTable(),s=o.getId();function f(o,v,O,w){var M="";if(O&&w){M="overlay,nodata";}else if(O&&!w){M="overlay";}else if(!O&&w){M="nodata";}var x=false;if(O&&o.getShowOverlay()||w&&b.isNoDataVisible(o)){x=true;}if(x){m["aria-hidden"]="true";}if(M){m["data-sap-ui-table-acc-covered"]=M;}}switch(t){case d.ELEMENTTYPES.COLUMNROWHEADER:m["aria-labelledby"]=[s+"-ariacolrowheaderlabel"];var g=false;m["role"]=["button"];if(p&&p.enabled){m["aria-pressed"]=p.checked?"true":"false";}else{g=true;m["aria-disabled"]="true";m["aria-pressed"]="false";}if(g||!o._getShowStandardTooltips()){m["aria-labelledby"].push(s+"-ariaselectall");}break;case d.ELEMENTTYPES.ROWHEADER:m["aria-labelledby"]=[s+"-ariarowheaderlabel"];if(!b.Grouping.isTreeMode(o)){m["role"]=["rowheader"];}if(o.getSelectionMode()!==S.None&&(!p||!p.rowHidden)){var h=p&&p.rowSelected;m["aria-selected"]=""+h;var j=e.getAriaTextsForSelectionMode(true);m["title"]=j.mouse[h?"rowDeselect":"rowSelect"];}break;case d.ELEMENTTYPES.ROWACTION:m["role"]=["gridcell"];m["aria-labelledby"]=[s+"-rowacthdr"];if(o.getSelectionMode()!==S.None&&(!p||!p.rowHidden)){var h=p&&p.rowSelected;m["aria-selected"]=""+h;}break;case d.ELEMENTTYPES.COLUMNHEADER:var k=p&&p.column;var H=p&&p.colspan;m["role"]="columnheader";var L=[];if(p&&p.headerId){var n=E.getRelevantColumnHeaders(o,k);var I=q.inArray(p.headerId,n);L=I>0?n.slice(0,I+1):[p.headerId];}for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}m["aria-labelledby"]=L;if(p&&(p.index<o.getFixedColumnCount())){m["aria-labelledby"].push(s+"-ariafixedcolumn");}if(!H&&k&&k.getSorted()){m["aria-sort"]=k.getSortOrder()==="Ascending"?"ascending":"descending";}if(!H&&k&&k._menuHasItems()){m["aria-haspopup"]="true";}break;case d.ELEMENTTYPES.DATACELL:m["role"]="gridcell";var L=[],k=p&&p.column?p.column:null;if(k){L=E.getRelevantColumnHeaders(o,k);m["headers"]=L.join(" ");for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}if(p&&p.fixed){L.push(s+"-ariafixedcolumn");}}m["aria-labelledby"]=L;if(b.Grouping.isTreeMode(o)&&p&&p.firstCol&&p.row){var B=o.mBindingInfos["rows"];if(p.row.getBindingContext(B&&B.model)){m["aria-level"]=p.row._iLevel+1;m["aria-expanded"]=""+p.row._bIsExpanded;}}break;case d.ELEMENTTYPES.ROOT:break;case d.ELEMENTTYPES.TABLE:m["role"]="presentation";f(o,m,true,true);break;case d.ELEMENTTYPES.CONTENT:m["role"]=b.Grouping.isGroupMode(o)||b.Grouping.isTreeMode(o)?"treegrid":"grid";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}if(o.getSelectionMode()===S.Multi||o.getSelectionMode()===S.MultiToggle){m["aria-multiselectable"]="true";}break;case d.ELEMENTTYPES.TABLEHEADER:m["role"]="heading";f(o,m,true,false);break;case d.ELEMENTTYPES.COLUMNHEADER_TBL:m["role"]="presentation";break;case d.ELEMENTTYPES.COLUMNHEADER_ROW:m["role"]="row";f(o,m,true,false);break;case d.ELEMENTTYPES.ROWHEADER_COL:f(o,m,true,true);break;case d.ELEMENTTYPES.TH:var r=o.getFixedColumnCount()>0;if(!r){m["role"]="presentation";}m["scope"]="col";if(r){if(p&&p.column){m["aria-owns"]=p.column.getId();m["aria-labelledby"]=[p.column.getId()];}}else{m["aria-hidden"]="true";}break;case d.ELEMENTTYPES.ROWHEADER_TD:m["role"]="rowheader";m["aria-labelledby"]=[s+"-ariarowheaderlabel"];m["headers"]=s+"-colsel";if(p&&typeof p.index==="number"){m["aria-owns"]=s+"-rowsel"+p.index;}if(o.getSelectionMode()!==S.None){var h=p&&p.rowSelected;m["aria-selected"]=""+h;}break;case d.ELEMENTTYPES.TR:m["role"]="row";var h=false;if(p&&typeof p.index==="number"&&o.getSelectionMode()!==S.None&&o.isIndexSelected(p.index)){m["aria-selected"]="true";h=true;}if(b.isRowSelectionAllowed(o)&&o.getContextByIndex(p.index)){var j=e.getAriaTextsForSelectionMode(true);m["title"]=j.mouse[h?"rowDeselect":"rowSelect"];}break;case d.ELEMENTTYPES.TREEICON:if(b.Grouping.isTreeMode(o)){m={"aria-label":"","title":"","role":""};if(o.getBinding("rows")){m["role"]="button";if(p&&p.row){if(p.row._bHasChildren){var u=o._oResBundle.getText(p.row._bIsExpanded?"TBL_COLLAPSE":"TBL_EXPAND");if(o._getShowStandardTooltips()){m["title"]=u;}else{m["aria-label"]=u;}m["aria-expanded"]=""+(!!p.row._bIsExpanded);}else{m["aria-label"]=o._oResBundle.getText("TBL_LEAF");}}}}break;case d.ELEMENTTYPES.NODATA:m["role"]="gridcell";var N=o.getNoData();m["aria-labelledby"]=[N instanceof C?N.getId():(s+"-noDataMsg")];f(o,m,true,false);break;case d.ELEMENTTYPES.OVERLAY:m["role"]="region";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}m["aria-labelledby"].push(s+"-ariainvalid");break;case d.ELEMENTTYPES.TABLEFOOTER:case d.ELEMENTTYPES.TABLESUBHEADER:f(o,m,true,false);break;case d.ELEMENTTYPES.ROWACTIONHEADER:m["aria-hidden"]="true";break;case"PRESENTATION":m["role"]="presentation";break;}return m;}};
var d=T.extend("sap.ui.table.TableAccExtension",{
_init:function(t,s,m){this._accMode=sap.ui.getCore().getConfiguration().getAccessibility();this._readonly=s===T.TABLETYPES.ANALYTICAL;this._busyCells=[];t.addEventDelegate(this);T.enrich(t,a);return"AccExtension";},
_debug:function(){this._ExtensionHelper=E;this._ACCInfoHelper=A;},
destroy:function(){this.getTable().removeEventDelegate(this);this._readonly=false;this._busyCells=[];T.prototype.destroy.apply(this,arguments);},
getAriaAttributesFor:function(t,p){return E.getAriaAttributesFor(this,t,p);},
onfocusin:function(e){var t=this.getTable();if(!t||b.getCellInfo(e.target).cell==null){return;}if(t._mTimeouts._cleanupACCExtension){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null;}this.updateAccForCurrentCell(true);},
onfocusout:function(e){var t=this.getTable();if(!t){return;}t.$("sapUiTableGridCnt").attr("role",E.getAriaAttributesFor(this,"CONTENT",{}).role);t._mTimeouts._cleanupACCExtension=q.sap.delayedCall(100,this,function(){var t=this.getTable();if(!t){return;}this._iLastRowNumber=null;this._iLastColumnNumber=null;E.cleanupCellModifications(this);t._mTimeouts._cleanupACCExtension=null;});}
});
d.ELEMENTTYPES={DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",ROWACTION:"ROWACTION",COLUMNROWHEADER:"COLUMNROWHEADER",ROOT:"ROOT",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_TBL:"COLUMNHEADER_TABLE",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",ROWHEADER_TD:"ROWHEADER_TD",TR:"TR",TREEICON:"TREEICON",ROWACTIONHEADER:"ROWACTIONHEADER",NODATA:"NODATA",OVERLAY:"OVERLAY"};
d.prototype.getAccMode=function(){return this._accMode;};
d.prototype.updateAccForCurrentCell=function(o){if(!this._accMode||!this.getTable()._getItemNavigation()){return;}var t=this.getTable();if(o){E.cleanupCellModifications(this);}var I=E.getInfoOfFocusedCell(this);var s;if(!I||!I.cell){return;}if(I.isOfType(c.DATACELL)){s=d.ELEMENTTYPES.DATACELL;}else if(I.isOfType(c.COLUMNHEADER)){s=d.ELEMENTTYPES.COLUMNHEADER;}else if(I.isOfType(c.ROWHEADER)){s=d.ELEMENTTYPES.ROWHEADER;}else if(I.isOfType(c.ROWACTION)){s=d.ELEMENTTYPES.ROWACTION;}else if(I.isOfType(c.COLUMNROWHEADER)){s=d.ELEMENTTYPES.COLUMNROWHEADER;}if(!E["modifyAccOf"+s]){return;}if(!o){if(I.isOfType(c.DATACELL|c.ROWHEADER)){if(t._mTimeouts._cleanupACCCellBusy){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCCellBusy);t._mTimeouts._cleanupACCCellBusy=null;}t._mTimeouts._cleanupACCCellBusy=q.sap.delayedCall(100,this,function(){for(var i=0;i<this._busyCells.length;i++){this._busyCells[i].removeAttr("aria-hidden");this._busyCells[i].removeAttr("aria-busy");}t._mTimeouts._cleanupACCCellBusy=null;this._busyCells=[];});if(D.browser.chrome){I.cell.attr("aria-hidden","true");}I.cell.attr("aria-busy","true");this._busyCells.push(I.cell);}else{return;}}E["modifyAccOf"+s].apply(this,[I.cell,o]);};
d.prototype.updateAriaStateOfColumn=function(o){if(!this._accMode){return;}var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:o.getId(),column:o,index:this.getTable().indexOfColumn(o)});var h=E.getRelevantColumnHeaders(this.getTable(),o);for(var i=0;i<h.length;i++){var H=q.sap.byId(h[i]);if(!H.attr("colspan")){H.attr({"aria-sort":m["aria-sort"]||null});}}};
d.prototype.updateAriaStateOfRow=function(r,R,i){if(!this._accMode){return;}if(!R){R=r.getDomRefs(true);}if(R.row){R.row.children("td").add(R.row).attr("aria-selected",i?"true":null);if(i&&R.rowSelectorText){var t=R.rowSelectorText.text();if(t){t=this.getTable()._oResBundle.getText("TBL_ROW_DESC_SELECTED")+" "+t;}R.rowSelectorText.text(t);}}};
d.prototype.updateAriaExpandAndLevelState=function(r,s,R,f,$,g,e,L,t){if(!this._accMode){return;}var h=null,o=this.getTable(),j=[s,s.children(),R,f,f?f.children():null,$],k=!!t,B=o.getBinding("rows");if(!g&&R&&!k){var I=R.attr("data-sap-ui-rowindex");var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER,{rowSelected:!r._bHidden&&o.isIndexSelected(I)});h=m["title"]||null;}if(R&&!k){R.attr({"aria-haspopup":g?"true":null,"title":h});}if(B&&B.hasTotaledMeasures&&L>0&&(!B.bProvideGrandTotals||!B.hasTotaledMeasures())){L=L-1;}for(var i=0;i<j.length;i++){if(j[i]){j[i].attr({"aria-expanded":g?e+"":null,"aria-level":L<0?null:(L+1)});}}if(k){t.attr(E.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:r}));}};
d.prototype.updateAriaStateOfRowHighlight=function(r){if(!this._accMode||r==null){return;}var R=r._getRow();if(R!=null){var h=R.getDomRef("highlighttext");h.innerText=r._getHighlightText();}};
d.prototype.updateAriaStateForOverlayAndNoData=function(){var t=this.getTable();if(!t||!t.getDomRef()||!this._accMode){return;}if(t.getShowOverlay()){t.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(b.isNoDataVisible(t)){t.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden");}}};
d.prototype.getAriaTextsForSelectionMode=function(e,s){var t=this.getTable();if(!s){s=t.getSelectionMode();}var r=t._oResBundle;var f=t._getShowStandardTooltips();var m={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var i=t._getSelectedIndicesCount();if(s===S.Single){m.mouse.rowSelect=f?r.getText("TBL_ROW_SELECT"):"";m.mouse.rowDeselect=f?r.getText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(s===S.MultiToggle){m.mouse.rowSelect=f?r.getText("TBL_ROW_SELECT_MULTI_TOGGLE"):"";m.mouse.rowDeselect=f?r.getText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");if(e===true&&i===0){m.mouse.rowSelect=f?r.getText("TBL_ROW_SELECT"):"";m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}return m;};
d.prototype.setSelectAllState=function(s){var t=this.getTable();if(t){t.$("selall").attr("aria-pressed",s?"true":"false");}};
d.prototype.addColumnHeaderLabel=function(o,e){var t=this.getTable();if(!this._accMode||!e.getAriaLabelledBy||!t){return;}var L=t.getColumnHeaderVisible()?o.getId():null;if(!L){var f=o.getAggregation("label");if(f){L=f.getId();}}var g=e.getAriaLabelledBy();if(L&&q.inArray(L,g)<0){e.addAriaLabelledBy(L);}};
return d;});
sap.ui.predefine('sap/ui/table/TableAccRenderExtension',["jquery.sap.global","./TableExtension","./library"],function(q,T,l){"use strict";var S=l.SelectionMode;var _=function(r,p,i,t,c){c=c||[];c.push("sapUiInvisibleText");r.write("<span");r.writeAttribute("id",p+"-"+i);r.writeAttribute("class",c.join(" "));r.writeAttribute("aria-hidden","true");r.write(">");if(t){r.writeEscaped(t);}r.write("</span>");};
var A=T.extend("sap.ui.table.TableAccRenderExtension",{
_init:function(t,s,m){return"AccRenderExtension";},
writeHiddenAccTexts:function(r,t){if(!t._getAccExtension().getAccMode()){return;}var b=t._oResBundle,s=t.getId();r.write("<div class='sapUiTableHiddenTexts' style='display:none;' aria-hidden='true'>");var d=t.getTitle()&&t.getTitle().getText&&t.getTitle().getText()!=""?t.getTitle().getText():"";_(r,s,"ariadesc",d);_(r,s,"ariacount");_(r,s,"toggleedit",b.getText("TBL_TOGGLE_EDIT_KEY"));_(r,s,"ariaselectall",b.getText("TBL_SELECT_ALL"));_(r,s,"ariarowheaderlabel",b.getText("TBL_ROW_HEADER_LABEL"));_(r,s,"ariarowgrouplabel",b.getText("TBL_ROW_GROUP_LABEL"));_(r,s,"ariagrandtotallabel",b.getText("TBL_GRAND_TOTAL_ROW"));_(r,s,"ariagrouptotallabel",b.getText("TBL_GROUP_TOTAL_ROW"));_(r,s,"ariacolrowheaderlabel",b.getText("TBL_ROW_COL_HEADER_LABEL"));_(r,s,"rownumberofrows");_(r,s,"colnumberofcols");_(r,s,"cellacc");_(r,s,"ariarowselected",b.getText("TBL_ROW_DESC_SELECTED"));_(r,s,"ariacolmenu",b.getText("TBL_COL_DESC_MENU"));_(r,s,"ariacolspan");_(r,s,"ariacolfiltered",b.getText("TBL_COL_DESC_FILTERED"));_(r,s,"ariacolsortedasc",b.getText("TBL_COL_DESC_SORTED_ASC"));_(r,s,"ariacolsorteddes",b.getText("TBL_COL_DESC_SORTED_DES"));_(r,s,"ariainvalid",b.getText("TBL_TABLE_INVALID"));var o=t.getSelectionMode();if(o!==S.None){_(r,s,"ariaselection",b.getText(o==S.MultiToggle?"TBL_TABLE_SELECTION_MULTI":"TBL_TABLE_SELECTION_SINGLE"));}if(t.getFixedColumnCount()>0){_(r,s,"ariafixedcolumn",b.getText("TBL_FIXED_COLUMN"));}r.write("</div>");},
writeAriaAttributesFor:function(r,t,s,p){var e=t._getAccExtension();if(!e.getAccMode()){return;}var a=e.getAriaAttributesFor(s,p);var v,k;for(k in a){v=a[k];if(q.isArray(v)){v=v.join(" ");}if(v){r.writeAttributeEscaped(k,v);}}},
writeAccRowSelectorText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var I=t.isIndexSelected(i);var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var s=m.keyboard[I?"rowDeselect":"rowSelect"];_(r,R.getId(),"rowselecttext",R._bHidden?"":s,["sapUiTableAriaRowSel"]);},
writeAccRowHighlightText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var o=R.getAggregation("_settings");var h=o._getHighlightText();_(r,R.getId(),"highlighttext",h);}
});
return A;});
sap.ui.predefine('sap/ui/table/TableColumnUtils',['jquery.sap.global','sap/ui/Device','./library'],function(q,D,l){"use strict";var T={TableUtils:null,initColumnUtils:function(t){if(!t._oColumnInfo){T.updateColumnInfo(t,T.collectColumnInfo(t));}},invalidateColumnUtils:function(t){t._oColumnInfo=null;},updateColumnInfo:function(t,c){t._oColumnInfo=c;},collectColumnInfo:function(t){return{columnCount:t.getColumns().length,visibleColumnCount:T.TableUtils.getVisibleColumnCount(t),columnMap:T._getColumnMap(t)};},_getColumnMap:function(t){var i;var c;var C={};var o={};var a=t.getColumns();var m=T.TableUtils.getHeaderRowCount(t);var p={};for(var b=0;b<a.length;b++){c=a[b];C={};C.id=c.getId();C.column=c;C.levelInfo=[];C.parents=[];for(var L=0;L<m;L++){C.levelInfo[L]={};C.levelInfo[L].spannedColumns=[];var h=T.getHeaderSpan(c,L);for(i=1;i<h;i++){var s=a[b+i];if(s){var P=s.getId();C.levelInfo[L].spannedColumns.push(a[b+i]);if(!p[P]){p[P]=[];}p[P].push({column:c,level:L});}}}o[C.id]=C;}var d=Object.keys(p);for(i=0;i<d.length;i++){var e=d[i];o[e].parents=p[e];}return o;},_getColumnMapItem:function(t,c){T.initColumnUtils(t);var s=t._oColumnInfo.columnMap[c];if(!s){q.sap.log.error("Column with ID '"+c+"' not found",t);}else{return s;}},getParentSpannedColumns:function(t,c,L){var C=T._getColumnMapItem(t,c);if(!C){return undefined;}var p=[];for(var i=0;i<C.parents.length;i++){var P=C.parents[i];if(L===undefined||P.level===L){p.push(P);}}return p;},getChildrenSpannedColumns:function(t,c,L){var C=T._getColumnMapItem(t,c);if(!C){return undefined;}var a=[];var e;if(L===undefined){e=C.levelInfo.length;}else{e=L+1;}for(var i=L||0;i<e;i++){var o=C.levelInfo[i];for(var j=0;j<o.spannedColumns.length;j++){a.push({column:o.spannedColumns[j],level:i});}}return a;},getHeaderSpan:function(c,L){var h=c.getHeaderSpan();var H;if(!h){return 1;}if(!Array.isArray(h)){h=(h+"").split(",");}function g(s){var r=parseInt(s,10);return isNaN(r)?1:r;}if(isNaN(L)){H=Math.max.apply(null,h.map(g));}else{H=g(h[L]);}return Math.max(H,1);},getMaxHeaderSpan:function(c){return T.getHeaderSpan(c);},hasHeaderSpan:function(c){return T.getHeaderSpan(c)>1;},getColumnBoundaries:function(t,c){var C=T._getColumnMapItem(t,c);if(!C){return undefined;}var m={};if(c){m[c]=C.column;}var f=function(m,n){var o;var i;var g=[];n=n||[];for(i=0;i<n.length;i++){o=m[n[i]];g=g.concat(T.getParentSpannedColumns(t,o.getId()));g=g.concat(T.getChildrenSpannedColumns(t,o.getId()));}n=[];for(i=0;i<g.length;i++){o=g[i].column;var c=o.getId();if(!m[c]){n.push(c);m[c]=o;}}if(n.length>0){return f(m,n);}else{return m;}};m=f(m,[c]);var a=t.indexOfColumn(C.column);var b={startColumn:C.column,startIndex:a,endColumn:C.column,endIndex:-1};var d=t.getColumns();var k=Object.getOwnPropertyNames(m);for(var i=0;i<k.length;i++){var o=m[k[i]];a=t.indexOfColumn(o);var h=T.getMaxHeaderSpan(o);if(a<b.startIndex){b.startIndex=a;b.startColumn=o;}var e=a+h-1;if(e>b.endIndex){b.endIndex=e;b.endColumn=d[e];}}return b;},isColumnMovable:function(c){var t=c.getParent();if(!t||!t.getEnableColumnReordering()){return false;}var C=t.indexOfColumn(c);if(C<t.getFixedColumnCount()||C<t._iFirstReorderableIndex){return false;}if(T.hasHeaderSpan(c)||T.getParentSpannedColumns(t,c.getId()).length!=0){return false;}return true;},_normalizeColumnMoveTargetIndex:function(c,n){var t=c.getParent(),C=t.indexOfColumn(c),a=t.getColumns();if(n>C){n--;}if(n<0){n=0;}else if(n>a.length){n=a.length;}return n;},isColumnMovableTo:function(c,n){var t=c.getParent();if(!t||n===undefined||!T.isColumnMovable(c)){return false;}n=T._normalizeColumnMoveTargetIndex(c,n);if(n<t.getFixedColumnCount()||n<t._iFirstReorderableIndex){return false;}var C=t.indexOfColumn(c),a=t.getColumns();if(n>C){var b=a[n>=a.length?a.length-1:n];var o=T.getColumnBoundaries(t,b.getId());if(T.hasHeaderSpan(b)||o.endIndex>n){return false;}}else{var A=a[n];if(T.getParentSpannedColumns(t,A.getId()).length!=0){return false;}}return true;},moveColumnTo:function(c,n){if(!T.isColumnMovableTo(c,n)){return false;}var t=c.getParent(),C=t.indexOfColumn(c);if(n===C){return false;}n=T._normalizeColumnMoveTargetIndex(c,n);var e=t.fireColumnMove({column:c,newPos:n});if(!e){return false;}t._bReorderInProcess=true;t.removeColumn(c);t.insertColumn(c,n);t._bReorderInProcess=false;return true;},getMinColumnWidth:function(){if(this._iColMinWidth){return this._iColMinWidth;}this._iColMinWidth=48;if(!D.system.desktop){this._iColMinWidth=88;}return this._iColMinWidth;},resizeColumn:function(t,c,w,f,C){if(t==null||c==null||c<0||w==null||w<=0){return false;}if(C==null||C<=0){C=1;}if(f==null){f=true;}var a=t.getColumns();if(c>=a.length||!a[c].getVisible()){return false;}var v=[];for(var i=c;i<a.length;i++){var o=a[i];if(o.getVisible()){v.push(o);if(v.length===C){break;}}}var r=[];for(var i=0;i<v.length;i++){var V=v[i];if(V.getResizable()){r.push(V);}}if(r.length===0){return false;}var s=0;for(var i=0;i<v.length;i++){var V=v[i];s+=T.getColumnWidth(t,V.getIndex());}var p=w-s;var S=Math.round(p/r.length);var R=false;var b=t.getDomRef();if(!T.TableUtils.isFixedColumn(t,c)){t._getVisibleColumns().forEach(function(k){var m=k.getWidth(),u;if(b&&r.indexOf(k)<0&&T.TableUtils.isVariableWidth(m)){u=b.querySelector('th[data-sap-ui-colid="'+k.getId()+'"]');if(u){k._minWidth=Math.max(u.offsetWidth,T.getMinColumnWidth());}}});}for(var i=0;i<r.length;i++){var d=r[i];var e=T.getColumnWidth(t,d.getIndex());var n=e+S;var g=T.getMinColumnWidth();if(n<g){n=g;}var W=n-e;if(Math.abs(W)<Math.abs(S)){var h=r.length-(i+1);p-=W;S=Math.round(p/h);}if(W!==0){var E=true;var j=n+"px";if(f){E=t.fireColumnResize({column:d,width:j});}if(E){d.setWidth(j);R=true;}}}return R;},getColumnWidth:function(t,c){if(t==null||c==null||c<0){return null;}var C=t.getColumns();if(c>=C.length){return null;}var o=C[c];var s=o.getWidth();if(s===""||s==="auto"||s.match(/%$/)){if(o.getVisible()){var a=o.getDomRef();return a!=null?a.offsetWidth:0;}else{return 0;}}else{return t._CSSSizeToPixel(s);}},getFixedColumnCount:function(t,c){var f=t.getFixedColumnCount();if(!c){return f;}if(f<=0||t._bIgnoreFixedColumnCount){return 0;}var C=t.getColumns();var v=0;f=Math.min(f,C.length);for(var i=0;i<f;i++){if(C[i].shouldRender()){v++;}}return v;}};return T;},true);
sap.ui.predefine('sap/ui/table/TableDragAndDropExtension',["./TableExtension","sap/ui/table/TableUtils"],function(T,a){"use strict";var S="sap.ui.table";var E={getSessionData:function(d,k){return d.getComplexData(S+(k==null?"":"-"+k));},setSessionData:function(d,s,k){d.setComplexData(S+(k==null?"":"-"+k),s);},getInstanceSessionData:function(d,t){return this.getSessionData(d,t.getId());},setInstanceSessionData:function(d,t,s){this.setSessionData(d,s,t.getId());}};var b={ondragstart:function(e){var d=e.dragSession;if(d==null||d.draggedControl==null){return;}var D=d.draggedControl;var s={};if(a.isInstanceOf(D,"sap/ui/table/Row")){var o=this.getContextByIndex(D.getIndex());var f=D.getDomRef();if(o==null||f.classList.contains("sapUiTableGroupHeader")||f.classList.contains("sapUiAnalyticalTableSum")){e.preventDefault();return;}else{s.draggedRowContext=o;}}if(a.isInstanceOf(D,"sap/ui/table/Column")){e.preventDefault();return;}E.setInstanceSessionData(d,this,s);},ondragenter:function(e){var d=e.dragSession;if(d==null||d.dropControl==null){return;}var s=E.getInstanceSessionData(d,this);var D=d.draggedControl;var o=d.dropControl;if(s==null){s={};}if(a.isInstanceOf(o,"sap/ui/table/Row")){var f=s.draggedRowContext;var g=this.getContextByIndex(o.getIndex());var h=o.getDomRef();var A=this._getTotalRowCount()===0;if((g==null&&!A)||(f!=null&&f===g)||h.classList.contains("sapUiTableGroupHeader")||h.classList.contains("sapUiAnalyticalTableSum")){e.preventDefault();}else{var v=this._getScrollExtension().isVerticalScrollbarVisible();var t=this.getDomRef("sapUiTableCnt").getBoundingClientRect();s.indicatorSize={width:t.width-(v?16:0),left:t.left+(this._bRtlMode&&v?16:0)};}}else if(a.isInstanceOf(o,"sap/ui/table/Column")){e.preventDefault();}else if(D===o){e.preventDefault();}else{delete s.indicatorSize;}if(s.verticalScrollEdge==null){var p=window.pageYOffset;var V=this.getDomRef("table").getBoundingClientRect();s.verticalScrollEdge={bottom:V.bottom+p,top:V.top+p};}var P=window.pageXOffset;var H=this.getDomRef("sapUiTableCtrlScr").getBoundingClientRect();s.horizontalScrollEdge={left:H.left+P,right:H.right+P};E.setInstanceSessionData(d,this,s);},ondragover:function(e){var d=e.dragSession;if(d==null){return;}var s=E.getInstanceSessionData(d,this);if(s==null){return;}var i=32;var t=50;var D=d.dropControl;var I=jQuery(d.getIndicator());var o=this._getScrollExtension();var v=o.getVerticalScrollbar();var h=o.getHorizontalScrollbar();var V=s.verticalScrollEdge;var H=s.horizontalScrollEdge;var f=s.indicatorSize;if(V!=null&&v!=null&&D!==this){var p=e.pageY;if(p>=V.top-t&&p<=V.top+t){v.scrollTop-=i;}else if(p<=V.bottom+t&&p>=V.bottom-t){v.scrollTop+=i;}}if(H!=null&&h!=null&&D!==this){var P=e.pageX;if(P>=H.left-t&&P<=H.left+t){h.scrollLeft-=i;}else if(P<=H.right+t&&P>=H.right-t){h.scrollLeft+=i;}}if(I!=null&&f!=null&&D!=null){I.css(f);}},onlongdragover:function(e){var d=e.dragSession;if(d==null){return;}var C=a.getCell(this,e.target);var r=a.getCellInfo(C).rowIndex;var R=r==null?null:this.getRows()[r];var D=d.dropControl;if(R!=null&&(D==R||D==null)){a.Grouping.toggleGroupHeader(this,R.getIndex(),true);}}};
var c=T.extend("sap.ui.table.TableDragAndDropExtension",{
_init:function(t,s,m){this._oDelegate=b;t.addEventDelegate(this._oDelegate,t);return"DragAndDropExtension";},
_debug:function(){this._ExtensionDelegate=b;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._oDelegate);}this._oDelegate=null;T.prototype.destroy.apply(this,arguments);}
});
return c;});
sap.ui.predefine('sap/ui/table/TableExtension',["sap/ui/base/Object","./TableUtils"],function(B,T){"use strict";
var a=B.extend("sap.ui.table.TableExtension",{
_table:null,
_type:null,
_settings:null,
constructor:function(t,s){B.call(this);this._table=t;this._settings=s||{};this._type=a.TABLETYPES.STANDARD;if(T.isInstanceOf(t,"sap/ui/table/TreeTable")){this._type=a.TABLETYPES.TREE;}else if(T.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){this._type=a.TABLETYPES.ANALYTICAL;}var e=this._init(this._table,this._type,this._settings);if(e){var b=this;t["_get"+e]=function(){return b;};}},
destroy:function(){this._table=null;this._type=null;this.bIsDestroyed=true;B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
a.TABLETYPES={TREE:"TREE",ANALYTICAL:"ANALYTICAL",STANDARD:"STANDARD"};
a.prototype.getTable=function(){return this._table;};
a.prototype._init=function(t,s,S){return null;};
a.prototype._attachEvents=function(){};
a.prototype._detachEvents=function(){};
a.attachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._attachEvents();}};
a.detachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._detachEvents();}};
a.enrich=function(t,E,s){if(!E||!(E.prototype instanceof a)){return null;}var e=new E(t,s);if(!t._aExtensions){t._aExtensions=[];}t._aExtensions.push(e);return e;};
a.cleanup=function(t){if(!t._bExtensionsInitialized||!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i].destroy();}delete t._aExtensions;delete t._bExtensionsInitialized;};
return a;});
sap.ui.predefine('sap/ui/table/TableGrouping',['jquery.sap.global','sap/ui/core/Element','sap/ui/model/Sorter','sap/ui/Device','./library'],function(q,E,S,D,l){"use strict";var T={TableUtils:null,clearMode:function(t){t._mode=null;},setGroupMode:function(t){t._mode="Group";},isGroupMode:function(t){return t._mode=="Group";},setTreeMode:function(t){t._mode="Tree";},isTreeMode:function(t){return t._mode=="Tree";},getModeCssClass:function(t){if(t._mode){return"sapUiTable"+t._mode+"Mode";}return null;},showGroupMenuButton:function(t){if(t._bShowGroupMenuButton===true||t._bShowGroupMenuButton===false){return t._bShowGroupMenuButton;}if(!D.system.desktop&&T.TableUtils.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){t._bShowGroupMenuButton=true;}else{t._bShowGroupMenuButton=false;}return t._bShowGroupMenuButton;},toggleGroupHeader:function(t,r,e){var b=t.getBinding("rows");if(b&&b.expand){var i=b.isExpanded(r);var I=true;if(b.nodeHasChildren!=null){if(b.getNodeByIndex!=null){I=!b.nodeHasChildren(b.getNodeByIndex(r));}else{I=false;}}if(I){return null;}else if(e===true&&!i){b.expand(r);}else if(e===false&&i){b.collapse(r);}else if(e!==true&&e!==false){b.toggleIndex(r);}else{return null;}return!i;}return null;},toggleGroupHeaderByRef:function(t,r,e){var R=q(r);var g;if(R.hasClass("sapUiTableTreeIcon")||(T.isTreeMode(t)&&R.hasClass("sapUiTableTdFirst"))){g=R.closest("tr",t.getDomRef());}else{g=R.closest(".sapUiTableGroupHeader",t.getDomRef());}var b=t.getBinding("rows");if(g.length>0&&b){var G=g.data("sap-ui-rowindex");var o=t.getRows()[G];if(o!=null){var a=o.getIndex();var i=T.toggleGroupHeader(t,a,e);var c=i===true||i===false;if(c&&t._onGroupHeaderChanged){t._onGroupHeaderChanged(a,i);}return c;}}return false;},isInGroupingRow:function(c){var i=T.TableUtils.getCellInfo(c);if(i.isOfType(T.TableUtils.CELLTYPE.DATACELL)){return i.cell.parent().hasClass("sapUiTableGroupHeader");}else if(i.isOfType(T.TableUtils.CELLTYPE.ROWHEADER|T.TableUtils.CELLTYPE.ROWACTION)){return i.cell.hasClass("sapUiTableGroupHeader");}return false;},isGroupingRow:function(r){if(!r){return false;}return q(r).hasClass("sapUiTableGroupHeader");},isInSumRow:function(c){var i=T.TableUtils.getCellInfo(c);if(i.isOfType(T.TableUtils.CELLTYPE.DATACELL)){return i.cell.parent().hasClass("sapUiAnalyticalTableSum");}else if(i.isOfType(T.TableUtils.CELLTYPE.ROWHEADER|T.TableUtils.CELLTYPE.ROWACTION)){return i.cell.hasClass("sapUiAnalyticalTableSum");}return false;},_calcGroupIndent:function(t,L,c,s){if(T.TableUtils.isInstanceOf(t,"sap/ui/table/TreeTable")){var I=0;for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}else if(T.TableUtils.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){var I=0;L=L-1;L=!c&&!s?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){if(I==0){I=12;}I=I+(i<2?12:8);}return I;}else{var I=0;L=!c?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}},_setIndent:function(t,r,R,i){var b=t._bRtlMode,f=r.find("td.sapUiTableTdFirst > .sapUiTableCell"),s=R.find(".sapUiTableGroupShield");if(i<=0){R.css(b?"right":"left","");s.css("width","").css(b?"margin-right":"margin-left","");f.css(b?"padding-right":"padding-left","");}else{R.css(b?"right":"left",i+"px");s.css("width",i+"px").css(b?"margin-right":"margin-left",((-1)*i)+"px");f.css(b?"padding-right":"padding-left",(i+8)+"px");}},updateTableRowForGrouping:function(t,r,c,e,h,s,L,g){var d=r.getDomRefs(true),R=d.row,$=d.rowScrollPart,f=d.rowFixedPart,a=d.rowSelector,b=d.rowAction;R.attr({"data-sap-ui-level":L});R.data("sap-ui-level",L);if(T.isGroupMode(t)){R.toggleClass("sapUiAnalyticalTableSum",!c&&s).toggleClass("sapUiAnalyticalTableDummy",false).toggleClass("sapUiTableGroupHeader",c).toggleClass("sapUiTableRowHidden",c&&h||r._bHidden);q.sap.byId(r.getId()+"-groupHeader").toggleClass("sapUiTableGroupIconOpen",c&&e).toggleClass("sapUiTableGroupIconClosed",c&&!e).attr("title",t._getShowStandardTooltips()&&g?g:null).text(g||"");T._setIndent(t,R,a,T._calcGroupIndent(t,L,c,s));}var i=null;if(T.isTreeMode(t)){i=R.find(".sapUiTableTreeIcon");i.css(t._bRtlMode?"margin-right":"margin-left",(L*17)+"px").toggleClass("sapUiTableTreeIconLeaf",!c).toggleClass("sapUiTableTreeIconNodeOpen",c&&e).toggleClass("sapUiTableTreeIconNodeClosed",c&&!e);}if(T.showGroupMenuButton(t)){var j=0;var k=t.$();if(k.hasClass("sapUiTableVScr")){j+=k.find('.sapUiTableVSb').width();}var G=a.find(".sapUiTableGroupMenuButton");if(t._bRtlMode){G.css("right",(k.width()-G.width()+a.position().left-j-5)+"px");}else{G.css("left",(k.width()-G.width()-a.position().left-j-5)+"px");}}t._getAccExtension().updateAriaExpandAndLevelState(r,$,a,f,b,c,e,L,i);},cleanupTableRowForGrouping:function(t,r){var d=r.getDomRefs(true);d.row.removeAttr("data-sap-ui-level");d.row.removeData("sap-ui-level");if(T.isGroupMode(t)){d.row.removeClass("sapUiTableGroupHeader sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");T._setIndent(t,d.row,d.rowSelector,0);}var $=null;if(T.isTreeMode(t)){$=d.row.find(".sapUiTableTreeIcon");$.removeClass("sapUiTableTreeIconLeaf").removeClass("sapUiTableTreeIconNodeOpen").removeClass("sapUiTableTreeIconNodeClosed").css(this._bRtlMode?"margin-right":"margin-left","");}t._getAccExtension().updateAriaExpandAndLevelState(r,d.rowScrollPart,d.rowSelector,d.rowFixedPart,d.rowAction,false,false,-1,$);},updateGroups:function(t){if(T.isGroupMode(t)||T.isTreeMode(t)){var b=t.getBinding("rows"),r=t.getBindingInfo("rows"),R=t.getRows(),c=R.length;if(b){var o;for(var i=0;i<c;i++){o=T._getRowGroupInfo(t,R[i],b,r);T.updateTableRowForGrouping(t,R[i],o.isHeader,o.expanded,o.hidden,false,o.level,o.title);}}else{for(var i=0;i<c;i++){T.cleanupTableRowForGrouping(t,R[i]);}}}},_getRowGroupInfo:function(t,r,R,o){var a={isHeader:false,expanded:false,hidden:false,title:"",level:0};if(t.getGroupHeaderProperty){a.isHeader=r._bHasChildren;a.expanded=r._bIsExpanded;a.hidden=a.isHeader;a.level=r._iLevel;var h=t.getGroupHeaderProperty();if(T.isGroupMode(t)&&h){var m=o&&o.model;a.title=t.getModel(m).getProperty(h,r.getBindingContext(m));}}else{var i=r.getIndex();a.isHeader=!!R.isGroupHeader(i);a.level=a.isHeader?0:1;if(a.isHeader){a.expanded=!!R.isExpanded(i);a.hidden=true;a.title=R.getTitle(i);}}return a;},setupExperimentalGrouping:function(t){if(!t.getEnableGrouping()){return;}var b=E.prototype.getBinding.call(t,"rows");var g=sap.ui.getCore().byId(t.getGroupBy());var I=g&&g.getGrouped()&&b&&T.TableUtils.isInstanceOf(b,"sap/ui/model/ClientListBinding");if(!I||b._modified){return;}b._modified=true;T.setGroupMode(t);var p=g.getSortProperty();b.sort(new S(p));var L=t._getTotalRowCount(),c=b.getContexts(0,L);var k;var C=0;for(var i=L-1;i>=0;i--){var n=c[i].getProperty(p);if(!k){k=n;}if(k!==n){var G=c[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);G.__groupInfo={oContext:c[i+1],name:k,count:C,groupHeader:true,expanded:true};c.splice(i+1,0,G);k=n;C=0;}C++;}var G=c[0].getModel().getContext("/sap.ui.table.GroupInfo");G.__groupInfo={oContext:c[0],name:k,count:C,groupHeader:true,expanded:true};c.splice(0,0,G);q.extend(b,{getLength:function(){return c.length;},getContexts:function(s,L){return c.slice(s,s+L);},isGroupHeader:function(a){var o=c[a];return(o&&o.__groupInfo&&o.__groupInfo.groupHeader)===true;},getTitle:function(a){var o=c[a];return o&&o.__groupInfo&&o.__groupInfo.name+" - "+o.__groupInfo.count;},isExpanded:function(a){var o=c[a];return this.isGroupHeader(a)&&o.__groupInfo&&o.__groupInfo.expanded;},expand:function(a){if(this.isGroupHeader(a)&&!c[a].__groupInfo.expanded){for(var i=0;i<c[a].__childs.length;i++){c.splice(a+1+i,0,c[a].__childs[i]);}delete c[a].__childs;c[a].__groupInfo.expanded=true;this._fireChange();}},collapse:function(a){if(this.isGroupHeader(a)&&c[a].__groupInfo.expanded){c[a].__childs=c.splice(a+1,c[a].__groupInfo.count);c[a].__groupInfo.expanded=false;this._fireChange();}},toggleIndex:function(a){if(this.isExpanded(a)){this.collapse(a);}else{this.expand(a);}},nodeHasChildren:function(o){if(o==null||o.__groupInfo==null){return false;}else{return o.__groupInfo.groupHeader===true;}},getNodeByIndex:function(a){return c[a];}});t._mTimeouts.groupingFireBindingChange=t._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){b._fireChange();},0);},resetExperimentalGrouping:function(t){var b=t.getBinding("rows");if(b&&b._modified){T.clearMode(t);var B=t.getBindingInfo("rows");t.unbindRows();t.bindRows(B);}}};return T;},true);
sap.ui.predefine('sap/ui/table/TableKeyboardDelegate2',["jquery.sap.global","sap/ui/base/Object","sap/ui/Device","./library","./TableUtils","jquery.sap.keycodes"],function(q,B,D,l,T){"use strict";var C=T.CELLTYPE;var S=l.SelectionMode;var M={CTRL:1,SHIFT:2,ALT:4};var N={LEFT:"Left",RIGHT:"Right",UP:"Up",DOWN:"Down"};var I=":sapTabbable, input:sapFocusable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)";var H=5;var a="1em";
function p(E,P){E.setMarked("sapUiTableSkipItemNavigation",P!==false);}
var b=B.extend("sap.ui.table.TableKeyboardDelegate2",{
constructor:function(t){B.call(this);},
destroy:function(){B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
b._restoreFocusOnLastFocusedDataCell=function(t,E){var o=T.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();T.focusItem(t,o.cellInRow+(o.columnCount*L.row),E);};
b._setFocusOnColumnHeaderOfLastFocusedDataCell=function(t,E){var o=T.getFocusedItemInfo(t);T.focusItem(t,o.cellInRow,E);};
b._forwardFocusToTabDummy=function(t,f){t._getKeyboardExtension()._setSilentFocus(t.$().find("."+f));};
b._isKeyCombination=function(E,k,m){if(m==null){m=0;}var f=typeof k==="string"?String.fromCharCode(E.charCode):E.keyCode;var g=0;g|=(D.os.macintosh?E.metaKey:E.ctrlKey)&&k!==q.sap.KeyCodes.CONTROL?M.CTRL:0;g|=E.shiftKey&&k!==q.sap.KeyCodes.SHIFT?M.SHIFT:0;g|=E.altKey&&k!==q.sap.KeyCodes.ALT?M.ALT:0;var v=k==null||f===k;var V=m===g;return v&&V;};
b._handleSpaceAndEnter=function(t,E){var o=T.getCellInfo(E.target);if(o.isOfType(C.COLUMNROWHEADER)){t._toggleSelectAll();}else if(b._isElementGroupToggler(t,E.target)){T.Grouping.toggleGroupHeaderByRef(t,E.target);}else if(o.isOfType(C.ROWHEADER)){T.toggleRowSelection(t,E.target);}else if(o.isOfType(C.DATACELL|C.ROWACTION)){var f=!t.hasListeners("cellClick");if(!t._findAndfireCellEvent(t.fireCellClick,E)){if(T.isRowSelectionAllowed(t)){T.toggleRowSelection(t,E.target);f=false;}}if(f){var i=b._getInteractiveElements(E.target);if(i!==null){t._getKeyboardExtension().setActionMode(true);}}}};
b._moveColumn=function(o,n){var t=o.getParent();var v=t._getVisibleColumns();var i=v.indexOf(o);var f;if(n&&i<v.length-1){f=t.indexOfColumn(v[i+1])+1;}else if(!n&&i>0){f=t.indexOfColumn(v[i-1]);}if(f!=null){T.Column.moveColumnTo(o,f);}};
b._getVisibleAndGroupedColumns=function(t){return t.getColumns().filter(function(o){return o.getVisible()||o.getGrouped();});};
b._getColumnIndexInVisibleAndGroupedColumns=function(t,o){var v=b._getVisibleAndGroupedColumns(t);for(var i=0;i<v.length;i++){var V=v[i];if(V===o){return i;}}return-1;};
b._focusElement=function(t,E,f,g){if(t==null||E==null){return;}if(f==null){f=false;}if(g==null){g=false;}function h(E){return E instanceof window.HTMLInputElement&&/^(text|password|search|tel|url)$/.test(E.type);}if(h(document.activeElement)){document.activeElement.setSelectionRange(0,0);}if(g){t._getKeyboardExtension()._setSilentFocus(E);}else{E.focus();}if(f&&h(E)){E.select();}};
b._focusCell=function(t,i,r,f,F,A){if(!t||i==null||r==null||r<0||r>=t.getRows().length){return;}var R=t.getRows()[r];var o;if(i===C.ROWHEADER){t._getKeyboardExtension()._setFocus(t.getDomRef("rowsel"+r));return;}else if(i===C.ROWACTION){o=t.getDomRef("rowact"+r);}else if(i===C.DATACELL&&(f!=null&&f>=0)){var g=t.getColumns()[f];var h=b._getColumnIndexInVisibleAndGroupedColumns(t,g);if(h>=0&&h<T.getVisibleColumnCount(t)){o=R.getDomRef("col"+h);}}if(!o){return;}if(F){var $=b._getInteractiveElements(o);if($){b._focusElement(t,$[0],true);return;}}if(A){t._getKeyboardExtension()._bStayInActionMode=true;}o.focus();};
b._navigate=function(t,E,f){if(E.isMarked()){return;}var k=t._getKeyboardExtension();var A=k.isInActionMode();var o=T.getCellInfo(T.getCell(t,E.target));var g=false;if((f===N.UP||f===N.DOWN)&&o.isOfType(C.ANYCONTENTCELL)){var h=b._isKeyCombination(E,null,M.CTRL);var i=h||A;var P=T.getParentCell(t,E.target);var j=A&&o.isOfType(C.DATACELL);if(!h&&(E.target instanceof window.HTMLInputElement||E.target instanceof window.HTMLTextAreaElement)){return;}if(!i&&P!=null){P.focus();return;}p(E);if(f===N.UP){if(T.isFirstScrollableRow(t,o.cell)){g=t._getScrollExtension().scrollVertically(false,false,true,j,function(){if(j){document.activeElement.blur();}});}}else if(T.isLastScrollableRow(t,o.cell)){g=t._getScrollExtension().scrollVertically(true,false,true,j,function(){if(j){document.activeElement.blur();}});}if(g){E.preventDefault();if(i){t.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){b._focusCell(t,o.type,o.rowIndex,o.columnIndex,true);},0);});}}else if(f===N.UP&&o.rowIndex===0){p(E,o.isOfType(C.ROWACTION)||i);if(!A&&P!=null){P.focus();}else{k.setActionMode(false);}}else if(f===N.DOWN&&o.rowIndex===t.getVisibleRowCount()-1){if(!A&&P!=null){P.focus();}else{k.setActionMode(false);}}else{var m=f===N.DOWN?1:-1;b._focusCell(t,o.type,o.rowIndex+m,o.columnIndex,i);E.preventDefault();}}else if(f===N.DOWN&&o.isOfType(C.ANYCOLUMNHEADER)){var n=T.getHeaderRowCount(t);if(T.isNoDataVisible(t)){var F=T.getFocusedItemInfo(t);if(F.row-n<=1){p(E);}}else if(o.isOfType(C.COLUMNROWHEADER)&&n>1){p(E);T.focusItem(t,n*(T.getVisibleColumnCount(t)+1),E);}}else if(f===N.LEFT&&!A){var r=sap.ui.getCore().getConfiguration().getRTL();if(o.isOfType(C.COLUMNHEADER)&&r){var u=T.getFocusedItemInfo(t);var v=u.cellInRow-(T.hasRowHeader(t)?1:0);var w=T.getVisibleColumnCount(t);if(T.hasRowActions(t)&&v===w-1){p(E);}}}};
b._isElementGroupToggler=function(t,E){return T.Grouping.isInGroupingRow(E)||(T.Grouping.isTreeMode(t)&&E.classList.contains("sapUiTableTdFirst")&&(E.querySelector(".sapUiTableTreeIconNodeOpen")!=null||E.querySelector(".sapUiTableTreeIconNodeClosed")!=null))||E.classList.contains("sapUiTableTreeIconNodeOpen")||E.classList.contains("sapUiTableTreeIconNodeClosed");};
b._isElementInteractive=function(E){if(E==null){return false;}return q(E).is(I);};
b._getInteractiveElements=function(o){if(o==null){return null;}var $=q(o);var f=T.getCellInfo($);if(f.isOfType(C.DATACELL|C.ROWACTION)){var i=$.find(I);if(i.length>0){return i;}}return null;};
b._getFirstInteractiveElement=function(r){if(r==null){return null;}var t=r.getParent();var f=r.getCells();var $;var g;if(T.hasRowActions(t)){f.push(r.getAggregation("_rowAction"));}for(var i=0;i<f.length;i++){$=T.getParentCell(t,f[i].getDomRef());g=this._getInteractiveElements($);if(g!==null){return g.first();}}return null;};
b._getLastInteractiveElement=function(r){if(r==null){return null;}var t=r.getParent();var f=r.getCells();var $;var g;if(T.hasRowActions(t)){f.push(r.getAggregation("_rowAction"));}for(var i=f.length-1;i>=0;i--){$=T.getParentCell(t,f[i].getDomRef());g=this._getInteractiveElements($);if(g!==null){return g.last();}}return null;};
b._getPreviousInteractiveElement=function(t,E){if(t==null||E==null){return null;}var $=q(E);if(!this._isElementInteractive($)){return null;}var f=T.getParentCell(t,E);var g;var o;var h;var j;var k;var m;var n;g=this._getInteractiveElements(f);if(g[0]!==$[0]){return g.eq(g.index(E)-1);}o=T.getCellInfo(f);j=t.getRows()[o.rowIndex].getCells();if(o.isOfType(C.ROWACTION)){n=j.length-1;}else{k=t.getColumns()[o.columnIndex];m=b._getColumnIndexInVisibleAndGroupedColumns(t,k);n=m-1;}for(var i=n;i>=0;i--){h=j[i].getDomRef();f=T.getParentCell(t,h);g=this._getInteractiveElements(f);if(g!==null){return g.last();}}return null;};
b._getNextInteractiveElement=function(t,E){if(t==null||E==null){return null;}var $=q(E);if(!this._isElementInteractive($)){return null;}var f=T.getParentCell(t,E);var g;var o;var h;var j;var k;var r;var m;g=this._getInteractiveElements(f);if(g.get(-1)!==$[0]){return g.eq(g.index(E)+1);}o=T.getCellInfo(f);if(o.isOfType(C.ROWACTION)){return null;}r=t.getRows()[o.rowIndex];j=r.getCells();k=t.getColumns()[o.columnIndex];m=b._getColumnIndexInVisibleAndGroupedColumns(t,k);for(var i=m+1;i<j.length;i++){h=j[i].getDomRef();f=T.getParentCell(t,h);g=this._getInteractiveElements(f);if(g!==null){return g.first();}}if(T.hasRowActions(t)){f=T.getParentCell(t,r.getAggregation("_rowAction").getDomRef());g=this._getInteractiveElements(f);if(g.get(-1)!==$[0]){return g.eq(g.index(E)+1);}}return null;};
b.prototype.enterActionMode=function(){var k=this._getKeyboardExtension();var A=document.activeElement;var i=b._getInteractiveElements(A);var $=T.getParentCell(this,A);if(i!==null){k._suspendItemNavigation();A.tabIndex=-1;b._focusElement(this,i[0],true,true);return true;}else if($!==null){this._getKeyboardExtension()._suspendItemNavigation();return true;}return false;};
b.prototype.leaveActionMode=function(A){A=A==null?true:A;var k=this._getKeyboardExtension();var o=document.activeElement;var $=T.getParentCell(this,o);k._resumeItemNavigation();if(A){if($!==null){b._focusElement(this,$[0],false,true);}else{k._setSilentFocus(o);}}};
b.prototype.onfocusin=function(E){if(E.isMarked("sapUiTableIgnoreFocusIn")){return;}var t=q(E.target);if(t.hasClass("sapUiTableOuterBefore")||t.hasClass("sapUiTableOuterAfter")||(E.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this.$("overlay").focus();}else if(t.hasClass("sapUiTableCtrlBefore")){var n=T.isNoDataVisible(this);if(!n||n&&this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,E);}else{this._getKeyboardExtension()._setSilentFocus(this.$("noDataCnt"));}}else if(t.hasClass("sapUiTableCtrlAfter")){if(!T.isNoDataVisible(this)){b._restoreFocusOnLastFocusedDataCell(this,E);}}var o=T.getCellInfo(E.target);var i=o.isOfType(C.ROWHEADER)&&T.Grouping.isInGroupingRow(E.target);var f=o.isOfType(C.ROWHEADER)&&!i&&T.isRowSelectorSelectionAllowed(this);var g=o.isOfType(C.DATACELL)&&this._getKeyboardExtension()._bStayInActionMode;var P=T.getCellInfo(T.getParentCell(this,E.target)).isOfType(C.ANYCONTENTCELL);var h=b._isElementInteractive(E.target);var j=this._getKeyboardExtension().isInActionMode();var k=(j&&(i||f||g)||(h&&P));if(g){this._getKeyboardExtension()._bStayInActionMode=false;}this._getKeyboardExtension().setActionMode(k,false);};
b.prototype.onkeydown=function(E){var k=this._getKeyboardExtension();if(b._isKeyCombination(E,q.sap.KeyCodes.F2)){var i=k.isInActionMode();var P=T.getParentCell(this,E.target);if(!i&&P!=null){P.focus();}else{k.setActionMode(!i);}return;}else if(b._isKeyCombination(E,q.sap.KeyCodes.F4)&&b._isElementGroupToggler(this,E.target)){T.Grouping.toggleGroupHeaderByRef(this,E.target);return;}if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,q.sap.KeyCodes.SPACE)&&T.getCellInfo(E.target).type){E.preventDefault();}var t=q(E.target);var o=T.getCellInfo(t);var f=this.getSelectionMode();if(b._isKeyCombination(E,q.sap.KeyCodes.SHIFT)&&f===S.MultiToggle&&(o.isOfType(C.ROWHEADER)&&T.isRowSelectorSelectionAllowed(this)||(o.isOfType(C.DATACELL|C.ROWACTION))&&T.isRowSelectionAllowed(this))){var F=T.getRowIndexOfFocusedCell(this);var g=this.getRows()[F].getIndex();this._oRangeSelection={startIndex:g,selected:this.isIndexSelected(g)};}else if(b._isKeyCombination(E,q.sap.KeyCodes.A,M.CTRL)){E.preventDefault();if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)&&f===S.MultiToggle){this._toggleSelectAll();}}else if(b._isKeyCombination(E,q.sap.KeyCodes.A,M.CTRL+M.SHIFT)){if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)){this.clearSelection();}}else if(b._isKeyCombination(E,q.sap.KeyCodes.F4)){if(o.isOfType(C.DATACELL)){k.setActionMode(true);}}else if(b._isKeyCombination(E,q.sap.KeyCodes.F10,M.SHIFT)){E.preventDefault();T.Menu.openContextMenu(this,E.target,true);}};
b.prototype.onkeypress=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,"+")){if(b._isElementGroupToggler(this,E.target)){T.Grouping.toggleGroupHeaderByRef(this,E.target,true);}else if(o.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}else if(b._isKeyCombination(E,"-")){if(b._isElementGroupToggler(this,E.target)){T.Grouping.toggleGroupHeaderByRef(this,E.target,false);}else if(o.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}};
b.prototype.oncontextmenu=function(E){if(E.isMarked("handledByPointerExtension")){return;}E.preventDefault();var $=T.getCell(this,E.target);var o=T.getCellInfo($);if(o.isOfType(C.COLUMNHEADER|C.DATACELL)){T.Menu.openContextMenu(this,E.target,true);}};
b.prototype.onkeyup=function(E){var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,q.sap.KeyCodes.SHIFT)){delete this._oRangeSelection;}if(b._isKeyCombination(E,q.sap.KeyCodes.SPACE)){if(o.isOfType(C.COLUMNHEADER)){T.Menu.openContextMenu(this,E.target,true);}else{b._handleSpaceAndEnter(this,E);}}if(b._isKeyCombination(E,q.sap.KeyCodes.ENTER)){if(o.isOfType(C.COLUMNHEADER)){T.Menu.openContextMenu(this,E.target,true);}}};
b.prototype.onsaptabnext=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);var $;if(k.isInActionMode()){var f;$=T.getCell(this,E.target);o=T.getCellInfo($);if(!o.isOfType(C.ANYCONTENTCELL)){return;}var r=this.getRows()[o.rowIndex];var L=b._getLastInteractiveElement(r);var g=L===null||L[0]===E.target;if(g){var A=r.getIndex();var h=T.isLastScrollableRow(this,$);var j=this._getTotalRowCount()-1===A;var t=T.isRowSelectorSelectionAllowed(this);E.preventDefault();if(j){k.setActionMode(false);}else if(h){s(this,o,t,o.rowIndex,r);}else{var R=o.rowIndex;if(t){b._focusCell(this,C.ROWHEADER,R+1);}else{var v=this.getVisibleRowCount();var m=false;for(var i=o.rowIndex+1;i<v;i++){R=i;r=this.getRows()[R];f=b._getFirstInteractiveElement(r);m=T.Grouping.isGroupingRow(r.getDomRef());if(f||m){break;}}if(f){b._focusElement(this,f[0],true);}else if(m){b._focusCell(this,C.ROWHEADER,R);}else{s(this,o,t,R,r);}}}}else if(o.isOfType(C.ROWHEADER)){E.preventDefault();f=b._getFirstInteractiveElement(r);b._focusElement(this,f[0],true);}else{E.preventDefault();f=b._getNextInteractiveElement(this,E.target);b._focusElement(this,f[0],true);}}else if(o.isOfType(C.ANYCOLUMNHEADER)){if(T.isNoDataVisible(this)){this.$("noDataCnt").focus();}else{b._restoreFocusOnLastFocusedDataCell(this,E);}E.preventDefault();}else if(o.isOfType(C.ANYCONTENTCELL)){b._forwardFocusToTabDummy(this,"sapUiTableCtrlAfter");}else if(E.target===this.getDomRef("overlay")){k._setSilentFocus(this.$().find(".sapUiTableOuterAfter"));}else if(!o.isOfType(C.ANY)){$=T.getParentCell(this,E.target);if($){E.preventDefault();$.focus();}}};
function s(t,o,f,r,R){var A=o.isOfType(C.DATACELL);var k=t._getKeyboardExtension();var g=t._getScrollExtension().scrollVertically(true,false,true,A,function(){if(A){document.activeElement.blur();}});if(g){t.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var j=T.Grouping.isGroupingRow(R.getDomRef());c(t,R,r,f,j);},0);});}else if(R.getIndex()!==t._getTotalRowCount()-1){var n=o.rowIndex+1;var h=t.getRows()[n];var i=T.Grouping.isGroupingRow(h.getDomRef());c(t,h,n,f,i);}else{k.setActionMode(false);}}
function c(t,r,R,f,i){var k=t._getKeyboardExtension();if(f||i){b._focusCell(t,C.ROWHEADER,R);}else{var $=b._getFirstInteractiveElement(r);if($){b._focusElement(t,$[0],true);}else{b._focusCell(t,C.DATACELL,R,0,false,true);if(r.getIndex()===t._getTotalRowCount()-1){k.setActionMode(false);}}}}
b.prototype.onsaptabprevious=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);var $;if(k.isInActionMode()){var f;$=T.getCell(this,E.target);o=T.getCellInfo($);if(!o.isOfType(C.ANYCONTENTCELL)){return;}var r=this.getRows()[o.rowIndex];var A=r.getIndex();var F=b._getFirstInteractiveElement(r);var g=F!==null&&F[0]===E.target;var t=T.isRowSelectorSelectionAllowed(this);var R=T.Grouping.isGroupingRow(r);var h=t||R;if(g&&h){E.preventDefault();b._focusCell(this,C.ROWHEADER,o.rowIndex);}else if((g&&!h)||o.isOfType(C.ROWHEADER)||F===null){var j=T.isFirstScrollableRow(this,$);var m=A===0;E.preventDefault();if(m){k.setActionMode(false);}else if(j){d(this,o,h,o.rowIndex,r);}else{var n=o.rowIndex;var R=false;for(var i=o.rowIndex-1;i>=0;i--){n=i;r=this.getRows()[n];f=b._getLastInteractiveElement(r);R=T.Grouping.isGroupingRow(r.getDomRef());if(f||h||R){break;}}if(f){b._focusElement(this,f[0],true);}else if(R||h){b._focusCell(this,C.ROWHEADER,n);}else{d(this,o,h,n,r);}}}else{E.preventDefault();f=b._getPreviousInteractiveElement(this,E.target);b._focusElement(this,f[0],true);}}else if(o.isOfType(C.ANYCONTENTCELL)||E.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()&&!o.isOfType(C.ROWACTION)){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,E);E.preventDefault();}else{b._forwardFocusToTabDummy(this,"sapUiTableCtrlBefore");}}else if(E.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus(this.$().find(".sapUiTableOuterBefore"));}else if(!o.isOfType(C.ANY)){$=T.getParentCell(this,E.target);if($){E.preventDefault();$.focus();}}};
function d(t,o,r,R,f){var A=o.isOfType(C.DATACELL);var k=t._getKeyboardExtension();var g=t._getScrollExtension().scrollVertically(false,false,true,A,function(){if(A){document.activeElement.blur();}});if(g){t.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var j=T.Grouping.isGroupingRow(f.getDomRef());e(t,f,R,r,j);},0);});}else if(f.getIndex()!==0){var P=o.rowIndex-1;var h=t.getRows()[P];var i=T.Grouping.isGroupingRow(h.getDomRef());e(t,h,P,r,i);}else{k.setActionMode(false);}}
function e(t,r,R,f,i){var k=t._getKeyboardExtension();var $=b._getLastInteractiveElement(r);if($){b._focusElement(t,$[0],true);}else if(f||i){b._focusCell(t,C.ROWHEADER,R);}else{b._focusCell(t,C.DATACELL,R,0,false,true);if(r.getIndex()===0){k.setActionMode(false);}}}
b.prototype.onsapdown=function(E){b._navigate(this,E,N.DOWN);};
b.prototype.onsapdownmodifiers=function(E){if(b._isKeyCombination(E,null,M.CTRL)){b._navigate(this,E,N.DOWN);return;}var k=this._getKeyboardExtension();if(b._isKeyCombination(E,null,M.ALT)&&b._isElementGroupToggler(this,E.target)){p(E);T.Grouping.toggleGroupHeaderByRef(this,E.target,true);return;}if(k.isInActionMode()){return;}var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(E);return;}var f=T.getRowIndexOfFocusedCell(this);var i=this.getRows()[f].getIndex();if(i===this._getTotalRowCount()-1){return;}if(T.isLastScrollableRow(this,E.target)){var g=this._getScrollExtension().scrollVertically(true,false,true);if(g){p(E);}}if(this._oRangeSelection.startIndex<=i){i++;if(this._oRangeSelection.selected){T.toggleRowSelection(this,i,true);}else{T.toggleRowSelection(this,i,false);}}else{T.toggleRowSelection(this,i,false);}}else{p(E);}}if(b._isKeyCombination(E,null,M.ALT)){if(o.isOfType(C.DATACELL)){k.setActionMode(true);}p(E);}};
b.prototype.onsapup=function(E){b._navigate(this,E,N.UP);};
b.prototype.onsapupmodifiers=function(E){var k=this._getKeyboardExtension();if(b._isKeyCombination(E,null,M.CTRL)){b._navigate(this,E,N.UP);return;}if(b._isKeyCombination(E,null,M.ALT)&&b._isElementGroupToggler(this,E.target)){p(E);T.Grouping.toggleGroupHeaderByRef(this,E.target,false);return;}if(k.isInActionMode()){return;}var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(E);return;}var f=T.getRowIndexOfFocusedCell(this);var i=this.getRows()[f].getIndex();if(i===0){p(E);return;}if(T.isFirstScrollableRow(this,E.target)){var g=this._getScrollExtension().scrollVertically(false,false,true);if(g){p(E);}}if(this._oRangeSelection.startIndex>=i){i--;if(this._oRangeSelection.selected){T.toggleRowSelection(this,i,true);}else{T.toggleRowSelection(this,i,false);}}else{T.toggleRowSelection(this,i,false);}}else{p(E);}}if(b._isKeyCombination(E,null,M.ALT)){if(o.isOfType(C.DATACELL)){k.setActionMode(true);}p(E);}};
b.prototype.onsapleft=function(E){b._navigate(this,E,N.LEFT);};
b.prototype.onsapleftmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}var o=T.getCellInfo(E.target);var f=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(E);return;}var F=T.getFocusedItemInfo(this);var g=T.hasRowHeader(this)&&F.cellInRow===1;if(g&&!T.isRowSelectorSelectionAllowed(this)){p(E);}}else if(o.isOfType(C.ROWACTION)){if(!this._oRangeSelection){p(E);}}else if(o.isOfType(C.ROWHEADER)&&f){if(!T.isRowSelectionAllowed(this)){p(E);}}else if(o.isOfType(C.COLUMNROWHEADER)&&f){p(E);}else if(o.isOfType(C.COLUMNHEADER)){var r=-this._CSSSizeToPixel(a);var h=0;if(f){r=r*-1;}for(var i=o.columnIndex;i<o.columnIndex+o.columnSpan;i++){h+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,o.columnIndex,h+r,true,o.columnSpan);p(E);}}else if(b._isKeyCombination(E,null,M.CTRL)){if(o.isOfType(C.COLUMNHEADER)){E.preventDefault();E.stopImmediatePropagation();var j=this.getColumns()[o.columnIndex];b._moveColumn(j,f);}}};
b.prototype.onsaprightmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}var o=T.getCellInfo(E.target);var f=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(E);}}else if(o.isOfType(C.ROWHEADER)){if(!T.isRowSelectionAllowed(this)){p(E);}}else if(o.isOfType(C.ROWACTION)&&f){if(!this._oRangeSelection){p(E);}}else if(o.isOfType(C.COLUMNHEADER)){var r=this._CSSSizeToPixel(a);var g=0;if(f){r=r*-1;}for(var i=o.columnIndex;i<o.columnIndex+o.columnSpan;i++){g+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,o.columnIndex,g+r,true,o.columnSpan);p(E);}else if(o.isOfType(C.COLUMNROWHEADER)){p(E);}}else if(b._isKeyCombination(E,null,M.CTRL)){if(o.isOfType(C.COLUMNHEADER)){E.preventDefault();E.stopImmediatePropagation();var h=this.getColumns()[o.columnIndex];b._moveColumn(h,!f);}}};
b.prototype.onsaphome=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupingRow(E.target)){p(E);E.preventDefault();return;}var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){E.preventDefault();}if(o.isOfType(C.DATACELL|C.ROWACTION|C.COLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var g=this.getFixedColumnCount();var h=T.hasRowHeader(this);var r=h?1:0;if(T.hasFixedColumns(this)&&i>g+r){p(E);T.focusItem(this,F-i+g+r,null);}else if(h&&i>1){p(E);T.focusItem(this,F-i+r,null);}}};
b.prototype.onsapend=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupingRow(E.target)){E.preventDefault();p(E);return;}var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){E.preventDefault();var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.columnCount;var g=this.getFixedColumnCount();var h=f.cellInRow;var j=T.hasRowHeader(this);var r=j?1:0;var k=false;if(o.isOfType(C.COLUMNHEADER)&&T.hasFixedColumns(this)){var m=parseInt(o.cell.attr("colspan")||1,10);if(m>1&&h+m-r===g){k=true;}}if(j&&h===0){p(E);T.focusItem(this,F+1,null);}else if(T.hasFixedColumns(this)&&h<g-1+r&&!k){p(E);T.focusItem(this,F+g-h,null);}else if(T.hasRowActions(this)&&o.isOfType(C.DATACELL)&&h<i-2){p(E);T.focusItem(this,F-h+i-2,null);}}};
b.prototype.onsaphomemodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.CTRL)){E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){p(E);var f=T.getFocusedItemInfo(this);var F=f.row;if(F>0){var i=f.cell;var g=f.columnCount;var h=T.getHeaderRowCount(this);var j=this.getFixedRowCount();var k=this.getFixedBottomRowCount();if(F<h+j){if(o.isOfType(C.ROWACTION)){T.focusItem(this,i-g*(F-h),E);}else{T.focusItem(this,i-g*F,E);}}else if(F>=h+j&&F<h+T.getNonEmptyVisibleRowCount(this)-k){this._getScrollExtension().scrollVerticallyMax(false,true);if(j>0||o.isOfType(C.ROWACTION)){T.focusItem(this,i-g*(F-h),E);}else{T.focusItem(this,i-g*F,E);}}else{this._getScrollExtension().scrollVerticallyMax(false,true);T.focusItem(this,i-g*(F-h-j),E);}}}}};
b.prototype.onsapendmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.CTRL)){E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var i=this.getFixedRowCount();var g=this.getFixedBottomRowCount();p(E);if(g===0||F<h+n-1||(T.isNoDataVisible(this)&&F<h-1)){var j=f.cell;var k=f.columnCount;if(T.isNoDataVisible(this)){T.focusItem(this,j+k*(h-F-1),E);}else if(F<h){if(i>0){T.focusItem(this,j+k*(h+i-F-1),E);}else{this._getScrollExtension().scrollVerticallyMax(true,true);T.focusItem(this,j+k*(h+n-g-F-1),E);}}else if(F>=h&&F<h+i){this._getScrollExtension().scrollVerticallyMax(true,true);T.focusItem(this,j+k*(h+n-g-F-1),E);}else if(F>=h+i&&F<h+n-g){this._getScrollExtension().scrollVerticallyMax(true,true);T.focusItem(this,j+k*(h+n-F-1),E);}else{T.focusItem(this,j+k*(h+n-F-1),E);}}}}};
b.prototype.onsappageup=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var i=this.getFixedRowCount();var g=this.getFixedBottomRowCount();if(i===0&&F>=h||i>0&&F>h){p(E);var j=f.cell;var k=f.columnCount;if(F<h+i){T.focusItem(this,j-k*(F-h),E);}else if(F===h+i){var P=T.getNonEmptyVisibleRowCount(this)-i-g;var r=this.getFirstVisibleRow();this._getScrollExtension().scrollVertically(false,true,true);if(r<P){if(i>0||o.isOfType(C.ROWACTION)){T.focusItem(this,j-k*(F-h),E);}else{T.focusItem(this,j-k*h,E);}}}else if(F>h+i&&F<h+T.getNonEmptyVisibleRowCount(this)){T.focusItem(this,j-k*(F-h-i),E);}else{T.focusItem(this,j-k*(F-h-T.getNonEmptyVisibleRowCount(this)+1),E);}}if(o.isOfType(C.ROWACTION)&&F===h&&i>0){p(E);}}};
b.prototype.onsappagedown=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var i=this.getFixedRowCount();var g=this.getFixedBottomRowCount();p(E);if((T.isNoDataVisible(this)&&F<h-1)||g===0||F<h+n-1){var j=f.cell;var k=f.columnCount;if(F<h-1&&!o.isOfType(C.COLUMNROWHEADER)){T.focusItem(this,j+k*(h-F-1),E);}else if(F<h){if(!T.isNoDataVisible(this)){T.focusItem(this,j+k*(h-F),E);}}else if(F>=h&&F<h+n-g-1){T.focusItem(this,j+k*(h+n-g-F-1),E);}else if(F===h+n-g-1){var P=T.getNonEmptyVisibleRowCount(this)-i-g;var r=this._getTotalRowCount()-g-this.getFirstVisibleRow()-P*2;this._getScrollExtension().scrollVertically(true,true,true);if(r<P&&g>0){T.focusItem(this,j+k*(h+n-F-1),E);}}else{T.focusItem(this,j+k*(h+n-F-1),E);}}}};
b.prototype.onsappageupmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.ALT)){var o=T.getCellInfo(E.target);var f=T.getFocusedItemInfo(this);if(o.isOfType(C.DATACELL|C.COLUMNHEADER)){var F=f.cell;var i=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var P=H;p(E);if(h&&(T.Grouping.isInGroupingRow(E.target)||i===1)){T.focusItem(this,F-i,null);}else if(i-r<P){T.focusItem(this,F-i+r,null);}else{T.focusItem(this,F-P,null);}}else if(o.isOfType(C.ROWACTION)){T.focusItem(this,f.cell-1,null);}}};
b.prototype.onsappagedownmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.ALT)){var o=T.getCellInfo(E.target);if(o.isOfType(C.DATACELL|C.ROWHEADER|C.ANYCOLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var v=T.getVisibleColumnCount(this);var i=parseInt(o.cell.attr("colspan")||1,10);p(E);if(F+i-r<v){var g=f.cell;var P=H;if(h&&F===0){T.focusItem(this,g+1,null);}else if(i>P){T.focusItem(this,g+i,null);}else if(F+i-r+P>v){T.focusItem(this,g+v-F-1+r,null);}else if(!T.Grouping.isInGroupingRow(E.target)){T.focusItem(this,g+P,null);}}else if(o.isOfType(C.DATACELL)&&T.hasRowActions(this)&&F===f.columnCount-2){T.focusItem(this,f.cell+1,null);}}}};
b.prototype.onsapenter=function(E){b._handleSpaceAndEnter(this,E);};
return b;});
sap.ui.predefine('sap/ui/table/TableKeyboardExtension',["jquery.sap.global","./TableExtension","sap/ui/core/delegate/ItemNavigation","./TableUtils","./TableKeyboardDelegate2","sap/ui/Device"],function(q,T,I,a,b,D){"use strict";var c=false;
function d(o){if(D.browser.msie){if(!c){q("head").append("<style type=\"text/css\">"+"/* Avoid focus outline problems in tables */\n"+".sapUiTableStatic[data-sap-ui-table-focus]{}"+"</style>");c=true;}var C=a.getCellInfo(o)||{};if(C.cell){C.cell.attr("data-sap-ui-table-focus",Date.now());}}}
var e={_forward:function(t,o){var i=t._getItemNavigation();if(i!=null&&!t._getKeyboardExtension()._isItemNavigationSuspended()&&!o.isMarked("sapUiTableSkipItemNavigation")&&!a.isBusyIndicatorVisible(t)){i["on"+o.type](o);}},onfocusin:function(o){e._forward(this,o);d(o.target);},onsapfocusleave:function(o){e._forward(this,o);},onmousedown:function(o){e._forward(this,o);},onsapnext:function(o){e._forward(this,o);},onsapnextmodifiers:function(o){e._forward(this,o);},onsapprevious:function(o){e._forward(this,o);},onsappreviousmodifiers:function(o){e._forward(this,o);},onsappageup:function(o){e._forward(this,o);},onsappagedown:function(o){e._forward(this,o);},onsaphome:function(o){e._forward(this,o);},onsaphomemodifiers:function(o){e._forward(this,o);},onsapend:function(o){e._forward(this,o);},onsapendmodifiers:function(o){e._forward(this,o);},onsapkeyup:function(o){e._forward(this,o);}};var E={onfocusin:function(o){var h=this._getKeyboardExtension();if(!h._bIgnoreFocusIn){h.initItemNavigation();if(f.isItemNavigationInvalid(this)){o.setMarked("sapUiTableInitItemNavigation");}}else{o.setMarked("sapUiTableIgnoreFocusIn");}if(o.target&&o.target.id===this.getId()+"-rsz"){o.preventDefault();o.setMarked("sapUiTableSkipItemNavigation");}}};var f={_initItemNavigation:function(o){var t=o.getTable();if(a.isBusyIndicatorVisible(t)){return;}var $=t.$();var C=a.getVisibleColumnCount(t);var h=C;var H=a.hasRowHeader(t);var j=a.hasRowActions(t);var k=a.hasFixedColumns(t);var l=[],r,R,m,n,p;if(k){m=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");n=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");p=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");}var s=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");var u=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");var v=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");if(H){r=$.find(".sapUiTableRowHdr").get();h++;}if(j){R=$.find(".sapUiTableRowAction").get();h++;}for(var i=0;i<t.getVisibleRowCount();i++){if(H){l.push(r[i]);}if(k){l=l.concat(m.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}l=l.concat(s.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(k){l=l.concat(n.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}l=l.concat(u.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(k){l=l.concat(p.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}l=l.concat(v.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(j){l.push(R[i]);}}if(t.getColumnHeaderVisible()){var w=[];var F=$.find(".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr");var S=$.find(".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr");for(var i=0;i<a.getHeaderRowCount(t);i++){if(H){w.push(t.getDomRef("selall"));}if(F.length){w=w.concat(q(F.get(i)).find(".sapUiTableCol").get());}if(S.length){w=w.concat(q(S.get(i)).find(".sapUiTableCol").get());}if(j){w.push($.find(".sapUiTableRowActionHeader").children().get(0));}}l=w.concat(l);}if(!o._itemNavigation){o._itemNavigation=new I();o._itemNavigation.setTableMode(true);o._itemNavigation.attachEvent(I.Events.AfterFocus,function(x){var y=a.getFocusedItemInfo(t);y.header=a.getHeaderRowCount(t);y.domRef=null;if(y.row>=y.header){o._oLastFocusedCellInfo=y;}},t);}o._itemNavigation.setColumns(h);o._itemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));o._itemNavigation.setItemDomRefs(l);o._itemNavigation.setFocusedIndex(f.getInitialItemNavigationIndex(o));o._itemNavigationInvalidated=false;},getInitialItemNavigationIndex:function(o){return a.hasRowHeader(o.getTable())?1:0;},isItemNavigationInvalid:function(o){return!o._itemNavigation||o._itemNavigationInvalidated;}};
var g=T.extend("sap.ui.table.TableKeyboardExtension",{
_init:function(t,s,S){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._delegate=new b(s);this._actionMode=false;t.addEventDelegate(E,t);t.addEventDelegate(this._delegate,t);t.addEventDelegate(e,t);t._getItemNavigation=function(){return this._itemNavigation;}.bind(this);return"KeyboardExtension";},
_debug:function(){this._ExtensionHelper=f;this._ItemNavigationDelegate=e;this._ExtensionDelegate=E;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(E);t.removeEventDelegate(this._delegate);t.removeEventDelegate(e);}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}if(this._delegate){this._delegate.destroy();this._delegate=null;}T.prototype.destroy.apply(this,arguments);}
});
g.prototype.initItemNavigation=function(){if(f.isItemNavigationInvalid(this)){f._initItemNavigation(this);}};
g.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true;};
g.prototype.setActionMode=function(h){if(h===true&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=this._delegate.enterActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1))===true;}else if(h===false&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1));}};
g.prototype.isInActionMode=function(){return this._actionMode;};
g.prototype.updateNoDataAndOverlayFocus=function(p){var t=this.getTable();if(!t||!t.getDomRef()){return;}if(t.getShowOverlay()){if(q.sap.containsOrEquals(t.getDomRef(),p)){t.$("overlay").focus();}}else if(a.isNoDataVisible(t)){if(q.sap.containsOrEquals(t.getDomRef("sapUiTableCnt"),p)){t.$("noDataCnt").focus();}}else if(q.sap.containsOrEquals(t.getDomRef("noDataCnt"),p)||q.sap.containsOrEquals(t.getDomRef("overlay"),p)){a.focusItem(t,f.getInitialItemNavigationIndex(this));}};
g.prototype._suspendItemNavigation=function(){this._itemNavigationSuspended=true;};
g.prototype._resumeItemNavigation=function(){this._itemNavigationSuspended=false;};
g.prototype._isItemNavigationSuspended=function(){return this._itemNavigationSuspended;};
g.prototype._getLastFocusedCellInfo=function(){var h=a.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=h){var i=a.getFocusedItemInfo(this.getTable());var j=f.getInitialItemNavigationIndex(this);return{cellInRow:j,row:h,header:h,cellCount:i.cellCount,columnCount:i.columnCount,cell:i.columnCount*h+j};}return this._oLastFocusedCellInfo;};
g.prototype._setSilentFocus=function(o){this._bIgnoreFocusIn=true;this._setFocus(o);this._bIgnoreFocusIn=false;};
g.prototype._setFocus=function(o){if(!o){return;}var t=this.getTable();var C=a.getCellInfo(o);if(C.cell&&t){var $=q(o);if($.attr("tabindex")!="0"){var h=t._getItemNavigation();if(h&&h.aItemDomRefs){for(var i=0;i<h.aItemDomRefs.length;i++){if(h.aItemDomRefs[i]){h.aItemDomRefs[i].setAttribute("tabindex","-1");}}}$.attr("tabindex","0");}}o.focus();};
g.prototype._getTableType=function(){return this._type;};
return g;});
sap.ui.predefine('sap/ui/table/TableMenuUtils',['jquery.sap.global','sap/ui/Device','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/core/Popup'],function(q,D,M,a,P){"use strict";P.setInitialZIndex(10);var b={TableUtils:null,openContextMenu:function(t,e,h,f){if(t==null||e==null){return;}if(f==null){f=true;}var T=q(e);var $=b.TableUtils.getCell(t,T);if($===null){return;}var c=b.TableUtils.getCellInfo($);var C=c.columnIndex;var r=c.rowIndex;var E;if(c.isOfType(b.TableUtils.CELLTYPE.COLUMNHEADER)){var d=$.find(".sapUiTableColDropDown").length>0;if(D.system.desktop||d){b.removeColumnHeaderCellMenu(t,C);E=true;if(f){E=t.fireColumnSelect({column:t.getColumns()[C]});}if(E){b.openColumnContextMenu(t,C,h,$);}}else{b.applyColumnHeaderCellMenu(t,C,$);}}else if(c.isOfType(b.TableUtils.CELLTYPE.DATACELL)){E=true;if(f){var R=b.TableUtils.getRowColCell(t,r,C,true);var o=R.row;var g;var i=t.getBindingInfo("rows");if(i!=null){g=o.getBindingContext(i.model);}var p={rowIndex:o.getIndex(),columnIndex:C,columnId:R.column.getId(),cellControl:R.cell,rowBindingContext:g,cellDomRef:$[0]};E=t.fireCellContextmenu(p);}if(E){b.openDataCellContextMenu(t,c,h);}}},openColumnContextMenu:function(t,c,h,C){if(t==null||c==null||c<0){return;}if(h==null){h=false;}var o=t.getColumns();if(c>=o.length){return;}var d=o[c];if(!d.getVisible()){return;}for(var i=0;i<o.length;i++){if(o[i]!==d){b.closeColumnContextMenu(t,i);}}b.closeDataCellContextMenu(t);var e=C&&C.attr("colspan");if(e&&e!=="1"){return;}d._openMenu(C&&C[0]||d.getDomRef(),h);},closeColumnContextMenu:function(t,c){if(t==null||c==null||c<0){return;}var C=t.getColumns();if(c>=C.length){return;}var o=C[c];o._closeMenu();},openDataCellContextMenu:function(t,c,h){if(t==null||!c||c.rowIndex>=b.TableUtils.getNonEmptyVisibleRowCount(t)){return;}var C=c.columnIndex;var r=c.rowIndex;if(h==null){h=false;}var o=t.getColumns();if(C>=o.length){return;}var d=o[C];if(!d||!d.getVisible()){return;}if(t.getEnableCellFilter()&&d.isFilterableByMenu()){var R=t.getRows()[r];if(t._oCellContextMenu==null){t._oCellContextMenu=new M(t.getId()+"-cellcontextmenu");var e=new a({text:t._oResBundle.getText("TBL_FILTER")});e._onSelect=function(d,r){var j=this.getContextByIndex(r);var F=d.getFilterProperty();var s=j.getProperty(F);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:d,value:s});}else{this.filter(d,s);}};e.attachSelect(e._onSelect.bind(t,d,R.getIndex()));t._oCellContextMenu.addItem(e);t.addDependent(t._oCellContextMenu);}else{var m=t._oCellContextMenu.getItems()[0];m.mEventRegistry.select[0].fFunction=m._onSelect.bind(t,d,R.getIndex());}if(!b.TableUtils.Grouping.isInGroupingRow(c.cell)){var f=c.cell[0];var g=t._oCellContextMenu.bOpen&&t._oCellContextMenu.oOpenerRef!==f;if(g){b.closeDataCellContextMenu(t);}for(var i=0;i<o.length;i++){b.closeColumnContextMenu(t,i);}t._oCellContextMenu.open(h,f,P.Dock.BeginTop,P.Dock.BeginBottom,f,"none none");}}},closeDataCellContextMenu:function(t){if(t==null){return;}var m=t._oCellContextMenu;var c=m!=null&&m.bOpen;if(c){m.close();}},cleanupDataCellContextMenu:function(t){if(!t||!t._oCellContextMenu){return;}t._oCellContextMenu.destroy();t._oCellContextMenu=null;},applyColumnHeaderCellMenu:function(t,c,T){if(t==null||c==null||c<0){return;}var C=t.getColumns();if(c>=C.length){return;}var d=T&&T.attr("colspan");if(d&&d!=="1"){return;}var o=C[c];if(o.getVisible()&&(o.getResizable()||o._menuHasItems())){var $=T||o.$();var e=$.find(".sapUiTableColCell");var f=$.find(".sapUiTableColCellMenu").length>0;if(!f){e.hide();var s="";if(o._menuHasItems()){s="<div class='sapUiTableColDropDown'></div>";}var g="";if(o.getResizable()){g="<div class='sapUiTableColResizer''></div>";}var h=q("<div class='sapUiTableColCellMenu'>"+s+g+"</div>");$.append(h);$.on("focusout",function(t,c){b.removeColumnHeaderCellMenu(t);this.off("focusout");}.bind($,t,c));}}},removeColumnHeaderCellMenu:function(t){var c=t&&t.$().find(".sapUiTableCHT .sapUiTableColCellMenu");if(c.length){c.parent().find(".sapUiTableColCell").show();c.remove();}}};return b;},true);
sap.ui.predefine('sap/ui/table/TablePersoController',['jquery.sap.global','sap/ui/base/ManagedObject'],function(q,M){"use strict";
var T=M.extend("sap.ui.table.TablePersoController",{
constructor:function(i,s){M.apply(this,arguments);},
metadata:{properties:{"autoSave":{type:"boolean",defaultValue:true},"persoService":{type:"any"},"customDataKey":{type:"string",defaultValue:"persoKey"}},associations:{"table":{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}
});
T.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue");}};
T.prototype.exit=function(){var t=this._getTable();if(t){this._manageTableEventHandlers(t,false);}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;delete this._oDialog;};
T.prototype.setPersoService=function(s){s=this.validateProperty("persoService",s);if(s&&(!q.isFunction(s.getPersData)||!q.isFunction(s.setPersData)||!q.isFunction(s.delPersData))){throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods "+"\"getPersData\", \"setPersData\" and \"delPersData\".");}var o=this.getPersoService();this.setProperty("persoService",s,true);var n=this.getPersoService();if(n&&n!==o&&this._getTable()&&(this.getAutoSave()||!o)){this.refresh();}return this;};
T.prototype.setAutoSave=function(a){var o=this.getAutoSave();this.setProperty("autoSave",a,true);var n=this.getAutoSave();if(n&&!o){this.savePersonalizations();}return this;};
T.prototype.setTable=function(t){var o=this._getTable();if(o){o._oPersoController=undefined;}this.setAssociation("table",t,true);var n=this._getTable();if(n){n._oPersoController=this;}if(o){this._manageTableEventHandlers(o,false);}if(n&&n!==o){this._oInitialPersoData=this._getCurrentTablePersoData(true);this._manageTableEventHandlers(n,true);if(this.getPersoService()&&(this.getAutoSave()||!o)){this.refresh();}}else if(!n){this._oInitialPersoData=null;}return this;};
T.prototype.setCustomDataKey=function(c){var o=this.getCustomDataKey();this.setProperty("customDataKey",c,true);var n=this.getCustomDataKey();if(o!==n&&this.getAutoSave()){this.savePersonalizations();}return this;};
T.prototype._manageTableEventHandlers=function(t,a){for(var i=0,l=this._aTableEvents.length;i<l;i++){var f=t[(a?"attachEvent":"detachEvent")];f.apply(t,[this._aTableEvents[i],this._tableEventHandler,this]);}};
T.prototype.refresh=function(){var t=this;var s=this.getPersoService();if(s){return s.getPersData().done(function(S){var D=(S&&q.isArray(S.aColumns))?S:t._oInitialPersoData;t._adjustTable(D);}).fail(function(){q.sap.log.error("Problem reading persisted personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var d=q.Deferred();d.reject();return d.promise();}};
T.prototype.savePersonalizations=function(){var s=this.getPersoService();if(s){var d=this._getCurrentTablePersoData();d[this._schemaProperty]=this._schemaVersion;return s.setPersData(d).fail(function(){q.sap.log.error("Problem persisting personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var D=q.Deferred();D.reject();return D.promise();}};
T.prototype._adjustTable=function(d){var t=this._getTable();if(!t||!d||!q.isArray(d.aColumns)){return;}var c={},C=t.getColumns();for(var i=0,l=C.length;i<l;i++){c[this._getColumnPersoKey(C[i])]=C[i];}var a=d.aColumns;for(var i=0,l=a.length;i<l;i++){var o=a[i];var b=c[o.id];if(b){if(t.indexOfColumn(b)!==o.order){t.removeColumn(b);t.insertColumn(b,o.order);}var m=b.getMetadata();for(var j=0,e=this._aColumnProperties.length;j<e;j++){var p=this._aColumnProperties[j];if(o[p]!==undefined){try{if(m.hasProperty(p)&&b.getProperty(p)!=o[p]){b.setProperty(p,o[p]);}}catch(f){q.sap.log.error("sap.ui.table.TablePersoController: failed to apply the value \""+b[p]+"\" for the property + \""+p+"\".");}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied();}};
T.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations();t._iTriggerSaveTimeout=null;},0);}};
T.prototype._getCurrentTablePersoData=function(f){var t=this._getTable(),c=t.getColumns();var d={aColumns:[]};for(var i=0,l=c.length;i<l;i++){var C=c[i];var p=this._getColumnPersoKey(C);var o={id:p,order:i};var m=C.getMetadata();for(var j=0,a=this._aColumnProperties.length;j<a;j++){var P=this._aColumnProperties[j];if(m.hasProperty(P)){o[P]=C.getProperty(P);}}if(f){o.text=C.getLabel()&&C.getLabel().getText()||p;}d.aColumns.push(o);}return d;};
T.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable());};
T.prototype._getColumnPersoKey=function(c){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(c);};
T.prototype._getPersoKey=function(c){var p=c.data(this.getCustomDataKey());if(!p){p=c.getId();if(p.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())===0){q.sap.log.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \""+c.getId()+"\")");}}return p;};
T.prototype.openDialog=function(s){sap.ui.getCore().loadLibrary("sap.m");var a=sap.ui.requireSync("sap/m/TablePersoDialog");if(!this._oDialog){var t=this;this._oDialog=new a({persoService:this.getPersoService(),showSelectAll:true,showResetAll:true,grouping:false,contentWidth:s&&s.contentWidth,contentHeight:s&&s.contentHeight||"20rem",initialColumnState:this._oInitialPersoData.aColumns,columnInfoCallback:function(o,p,P){return t._getCurrentTablePersoData(true).aColumns;},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations();}}});this._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding");q.sap.syncStyleClass("sapUiSizeCompact",this._getTable(),this._oDialog._oDialog);}this._oDialog.open();};
return T;});
sap.ui.predefine('sap/ui/table/TablePointerExtension',["./library","jquery.sap.global","./TableExtension","./TableUtils","sap/ui/Device","sap/ui/core/Popup"],function(l,q,T,a,D,P){"use strict";var S=l.SelectionMode;var K=["sapMBtnBase","sapMInputBase","sapMLnk","sapMSlt","sapMCb","sapMRI","sapMSegBBtn","sapUiIconPointer","sapMBtnIcon"];var E={_getEventPosition:function(e,t){var p;function g(o){if(!t._isTouchEvent(o)){return null;}var f=["touches","targetTouches","changedTouches"];for(var i=0;i<f.length;i++){var s=f[i];if(e[s]&&e[s][0]){return e[s][0];}if(e.originalEvent[s]&&e.originalEvent[s][0]){return e.originalEvent[s][0];}}return null;}p=g(e)||e;return{x:p.pageX,y:p.pageY};},_skipClick:function(e,t,o){if(!o.isOfType(a.CELLTYPE.DATACELL|a.CELLTYPE.ROWACTION)){return false;}if(e.isMarked()){return true;}var f=t.control(0);if(f){var $=f.$();if($.length){for(var i=0;i<K.length;i++){if($.hasClass(K[i])){return typeof f.getEnabled==="function"?f.getEnabled():true;}}}}var h=false;if(window.getSelection){var s=window.getSelection();h=s.rangeCount?!s.getRangeAt(0).collapsed:false;}if(h){q.sap.log.debug("DOM Selection detected -> Click event on table skipped, Target: "+e.target);return true;}return false;},_handleClickSelection:function(e,$,t){a.toggleRowSelection(t,$,null,function(r){if((D.browser.msie||D.browser.edge)&&e.shiftKey){t._clearTextSelection();}var s=t.getSelectionMode();if(s===S.Single){if(!t.isIndexSelected(r)){t.setSelectedIndex(r);}else{t.clearSelection();}}else{var f=!!(e.metaKey||e.ctrlKey);if(s===S.MultiToggle){f=true;}if(e.shiftKey){var i=t.getSelectedIndex();if(i>=0){t.addSelectionInterval(i,r);}else{t.setSelectedIndex(r);}}else{if(!t.isIndexSelected(r)){if(f){t.addSelectionInterval(r,r);}else{t.setSelectedIndex(r);}}else{if(f){t.removeSelectionInterval(r,r);}else{if(t._getSelectedIndicesCount()===1){t.clearSelection();}else{t.setSelectedIndex(r);}}}}}return true;});}};var C={initColumnResizing:function(t,e){if(t._bIsColumnResizerMoving){return;}t._bIsColumnResizerMoving=true;t.$().toggleClass("sapUiTableResizing",true);var $=q(document),f=t._isTouchEvent(e);t._$colResize=t.$("rsz");t._iColumnResizeStart=E._getEventPosition(e,t).x;$.bind((f?"touchend":"mouseup")+".sapUiTableColumnResize",C.exitColumnResizing.bind(t));$.bind((f?"touchmove":"mousemove")+".sapUiTableColumnResize",C.onMouseMoveWhileColumnResizing.bind(t));t._disableTextSelection();},exitColumnResizing:function(e){C._resizeColumn(this,this._iLastHoveredColumnIndex);},onMouseMoveWhileColumnResizing:function(e){var L=E._getEventPosition(e,this).x;if(this._iColumnResizeStart&&L<this._iColumnResizeStart+3&&L>this._iColumnResizeStart-3){return;}if(this._isTouchEvent(e)){e.stopPropagation();e.preventDefault();}this._$colResize.toggleClass("sapUiTableColRszActive",true);var o=this._getVisibleColumns()[this._iLastHoveredColumnIndex];var i=L-this._iColumnResizeStart;var f=this.$().find("th[data-sap-ui-colid=\""+o.getId()+"\"]").width();var w=Math.max(f+i*(this._bRtlMode?-1:1),a.Column.getMinColumnWidth());var r=this.$().find(".sapUiTableCnt").offset().left;var g=Math.floor((L-r)-(this._$colResize.width()/2));this._$colResize.css("left",g+"px");o._iNewWidth=w;},_cleanupColumResizing:function(t){if(t._$colResize){t._$colResize.toggleClass("sapUiTableColRszActive",false);t._$colResize=null;}t._iColumnResizeStart=null;t._bIsColumnResizerMoving=false;t.$().toggleClass("sapUiTableResizing",false);t._enableTextSelection();var $=q(document);$.unbind("touchmove.sapUiTableColumnResize");$.unbind("touchend.sapUiTableColumnResize");$.unbind("mousemove.sapUiTableColumnResize");$.unbind("mouseup.sapUiTableColumnResize");},_resizeColumn:function(t,i){var v=t._getVisibleColumns(),o,r=false;if(i>=0&&i<v.length){o=v[i];if(o._iNewWidth){a.Column.resizeColumn(t,t.indexOfColumn(o),o._iNewWidth);delete o._iNewWidth;r=true;}}C._cleanupColumResizing(t);o.focus();if(r){t.invalidate();}},doAutoResizeColumn:function(t,i){var v=t._getVisibleColumns(),o;if(i>=0&&i<v.length){o=v[i];if(!o.getAutoResizable()||!o.getResizable()){return;}var n=C._calculateAutomaticColumnWidth.apply(t,[o,i]);if(n){o._iNewWidth=n;C._resizeColumn(t,i);}}},_calculateAutomaticColumnWidth:function(o,i){o=o||this.getColumns()[i];var $=this.$();var e=q("<div>").addClass("sapUiTableHiddenSizeDetector");$.append(e);var f=$.find("td[data-sap-ui-colid = \""+o.getId()+"\"]:not([colspan])").filter(function(g,h){return h.style.display!="none";}).children().clone();f.find("[id]").removeAttr("id");var w=e.append(f).width()+4;w=Math.min(w,$.find(".sapUiTableCnt").width());w=Math.max(w+4,a.Column.getMinColumnWidth());e.remove();return w;},initColumnTracking:function(t){t.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").mousemove(function(e){var o=this.getDomRef();if(!o||this._bIsColumnResizerMoving){return;}var p=e.clientX,f=o.getBoundingClientRect(),L=0,r=this._bRtlMode?10000:-10000;for(var i=0;i<this._aTableHeaders.length;i++){var g=this._aTableHeaders[i].getBoundingClientRect();if(this._bRtlMode){if((p<g.right-5)&&(p>=g.left)){L=i;r=g.left-f.left;break;}}else{if((p>g.left+5)&&(p<=g.right)){L=i;r=g.right-f.left;break;}}}var h=this._getVisibleColumns()[L];if(h&&h.getResizable()){this.$("rsz").css("left",r+"px");this._iLastHoveredColumnIndex=L;}}.bind(t));}};var I={initInteractiveResizing:function(t,e){var B=q(document.body),s=t.$("sb"),$=q(document),o=s.offset(),h=s.height(),w=s.width(),f=t._isTouchEvent(e);B.bind("selectstart",I.onSelectStartWhileInteractiveResizing);B.append("<div id=\""+t.getId()+"-ghost\" class=\"sapUiTableInteractiveResizerGhost\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px\" ></div>");s.append("<div id=\""+t.getId()+"-rzoverlay\" style =\"left: 0px; right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");$.bind((f?"touchend":"mouseup")+".sapUiTableInteractiveResize",I.exitInteractiveResizing.bind(t));$.bind((f?"touchmove":"mousemove")+".sapUiTableInteractiveResize",I.onMouseMoveWhileInteractiveResizing.bind(t));t._disableTextSelection();},exitInteractiveResizing:function(e){var B=q(document.body),$=q(document),t=this.$(),g=this.$("ghost"),L=E._getEventPosition(e,this).y;var n=L-t.find(".sapUiTableCCnt").offset().top-g.height()-t.find(".sapUiTableFtr").height();this._setRowContentHeight(n);this._updateRows(this._calculateRowsToDisplay(n),a.RowsUpdateReason.Resize);g.remove();this.$("rzoverlay").remove();B.unbind("selectstart",I.onSelectStartWhileInteractiveResizing);$.unbind("touchend.sapUiTableInteractiveResize");$.unbind("touchmove.sapUiTableInteractiveResize");$.unbind("mouseup.sapUiTableInteractiveResize");$.unbind("mousemove.sapUiTableInteractiveResize");this._enableTextSelection();},onSelectStartWhileInteractiveResizing:function(e){e.preventDefault();e.stopPropagation();return false;},onMouseMoveWhileInteractiveResizing:function(e){var L=E._getEventPosition(e,this).y;var m=this.$().offset().top;if(L>m){this.$("ghost").css("top",L+"px");}}};var R={initReordering:function(t,i,e){var o=t.getColumns()[i],$=o.$(),f=t.$();t._disableTextSelection();f.addClass("sapUiTableDragDrop");var g=$.clone();g.find("*").addBack(g).removeAttr("id").removeAttr("data-sap-ui").removeAttr("tabindex");g.attr("id",t.getId()+"-roghost").addClass("sapUiTableColReorderGhost").css({"left":-10000,"top":-10000,"z-index":P.getNextZIndex()});g.toggleClass(a.getContentDensity(t),true);g.appendTo(document.body);t._$ReorderGhost=t.getDomRef("roghost");f.find("td[data-sap-ui-colid='"+o.getId()+"']").toggleClass("sapUiTableColReorderFade",true);var h=q("<div id='"+t.getId()+"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>");h.appendTo(t.getDomRef("sapUiTableCnt"));t._$ReorderIndicator=t.getDomRef("roind");t._iDnDColIndex=i;var j=q(document),k=t._isTouchEvent(e);j.bind((k?"touchend":"mouseup")+".sapUiColumnMove",R.exitReordering.bind(t));j.bind((k?"touchmove":"mousemove")+".sapUiColumnMove",R.onMouseMoveWhileReordering.bind(t));},onMouseMoveWhileReordering:function(e){var o=E._getEventPosition(e,this),L=o.x,i=o.y,O=this._iNewColPos;this._iNewColPos=this._iDnDColIndex;e.preventDefault();var p=R.findColumnForPosition(this,L);if(!p||!p.id){this._iNewColPos=O;return;}var s=40,f=this.getDomRef("sapUiTableCtrlScr"),$=q(f),g=f.getBoundingClientRect(),h=$.outerWidth(),j=this._bRtlMode?$.scrollLeftRTL():$.scrollLeft();this._bReorderScroll=false;if(L>g.left+h-s&&j+h<f.scrollWidth){this._bReorderScroll=true;R.doScroll(this,!this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}else if(L<g.left+s&&j>0){this._bReorderScroll=true;R.doScroll(this,this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}q(this._$ReorderGhost).css({"left":L+5,"top":i+5});if(this._bReorderScroll||!p){return;}if(p.before||(p.after&&p.index==this._iDnDColIndex)){this._iNewColPos=p.index;}else if(p.after&&p.index!=this._iDnDColIndex){this._iNewColPos=p.index+1;}if(!a.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)){this._iNewColPos=O;}else{R.adaptReorderMarkerPosition(this,p,true);}},exitReordering:function(e){var o=this._iDnDColIndex;var n=this._iNewColPos;var $=q(document);$.unbind("touchmove.sapUiColumnMove");$.unbind("touchend.sapUiColumnMove");$.unbind("mousemove.sapUiColumnMove");$.unbind("mouseup.sapUiColumnMove");this._bReorderScroll=false;this.$().removeClass("sapUiTableDragDrop");delete this._iDnDColIndex;delete this._iNewColPos;q(this._$ReorderGhost).remove();delete this._$ReorderGhost;q(this._$ReorderIndicator).remove();delete this._$ReorderIndicator;this.$().find(".sapUiTableColReorderFade").removeClass("sapUiTableColReorderFade");this._enableTextSelection();a.Column.moveColumnTo(this.getColumns()[o],n);if(this._mTimeouts.reApplyFocusTimerId){window.clearTimeout(this._mTimeouts.reApplyFocusTimerId);}var t=this;this._mTimeouts.reApplyFocusTimerId=window.setTimeout(function(){var O=a.getFocusedItemInfo(t).cell;a.focusItem(t,0,e);a.focusItem(t,O,e);},0);if(this.updateAnalyticalInfo){this.updateAnalyticalInfo(true,true);}},findColumnForPosition:function(t,L){var h,H,r,w,p,B,A;for(var i=0;i<t._aTableHeaders.length;i++){h=t._aTableHeaders[i];H=q(h);r=h.getBoundingClientRect();w=H.outerWidth();p={left:r.left,center:r.left+w/2,right:r.left+w,width:w,index:parseInt(H.attr("data-sap-ui-headcolindex"),10),id:H.attr("data-sap-ui-colid")};B=L>=p.left&&L<=p.center;A=L>=p.center&&L<=p.right;if(B||A){p.before=t._bRtlMode?A:B;p.after=t._bRtlMode?B:A;return p;}}return null;},doScroll:function(t,f){if(t._mTimeouts.horizontalReorderScrollTimerId){window.clearTimeout(t._mTimeouts.horizontalReorderScrollTimerId);t._mTimeouts.horizontalReorderScrollTimerId=null;}if(t._bReorderScroll){var s=f?30:-30;if(t._bRtlMode){s=(-1)*s;}t._mTimeouts.horizontalReorderScrollTimerId=q.sap.delayedCall(60,t,R.doScroll,[t,f]);var $=t.$("sapUiTableCtrlScr");var e=t._bRtlMode?"scrollLeftRTL":"scrollLeft";$[e]($[e]()+s);}},adaptReorderMarkerPosition:function(t,p,s){if(!p||!t._$ReorderIndicator){return;}var L=p.left-t.getDomRef().getBoundingClientRect().left;if(t._bRtlMode&&p.before||!t._bRtlMode&&p.after){L=L+p.width;}q(t._$ReorderIndicator).css({"left":L+"px"}).toggleClass("sapUiTableColReorderIndicatorActive",s);}};var b={ROWAREAS:[".sapUiTableRowHdr",".sapUiTableRowAction",".sapUiTableCtrlFixed > tbody > .sapUiTableTr",".sapUiTableCtrlScroll > tbody > .sapUiTableTr"],initRowHovering:function(t){var $=t.$();for(var i=0;i<b.ROWAREAS.length;i++){b._initRowHoveringForArea($,b.ROWAREAS[i]);}},_initRowHoveringForArea:function(t,A){t.find(A).hover(function(){b._onHover(this,t,A);},function(){b._onUnhover(this,t);});},_onHover:function(e,t,A){var f=t.find(A).index(e);for(var i=0;i<b.ROWAREAS.length;i++){t.find(b.ROWAREAS[i]).filter(":eq("+(f)+")").addClass("sapUiTableRowHvr");}},_onUnhover:function(e,t){for(var i=0;i<b.ROWAREAS.length;i++){t.find(b.ROWAREAS[i]).removeClass("sapUiTableRowHvr");}}};var c={onmousedown:function(e){var p=this._getPointerExtension();var $=a.getCell(this,e.target);var o=a.getCellInfo($);var t=q(e.target);var f;var m;var M;this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("sb")){I.initInteractiveResizing(this,e);}else if(e.target===this.getDomRef("rsz")){C.initColumnResizing(this,e);}else if(t.hasClass("sapUiTableColResizer")){var i=t.closest(".sapUiTableCol").attr("data-sap-ui-colindex");this._iLastHoveredColumnIndex=parseInt(i,10);C.initColumnResizing(this,e);}else if(o.isOfType(a.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;this._mTimeouts.delayedMenuTimerId=q.sap.delayedCall(200,this,function(){delete p._bShowMenu;});}if(this.getEnableColumnReordering()&&!(this._isTouchEvent(e)&&t.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(o.columnIndex,e);}}if((D.browser.firefox&&!!(e.metaKey||e.ctrlKey))||t.closest(".sapUiTableHSb",this.getDomRef()).length===1||t.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault();}}if(e.button===2){if(E._skipClick(e,t,o)){p._bShowDefaultMenu=true;return;}if(o.isOfType(a.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;}else{p._bHideMenu=true;}}else if(o.isOfType(a.CELLTYPE.DATACELL)){M=this._oCellContextMenu&&this._oCellContextMenu.bOpen;var g=M&&this._oCellContextMenu.oOpenerRef!==$[0];if(!M||g){p._bShowMenu=true;}else{p._bHideMenu=true;}}else{p._bShowDefaultMenu=true;}}},onmouseup:function(e){q.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimerId);},ondblclick:function(e){if(D.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();C.doAutoResizeColumn(this,this._iLastHoveredColumnIndex);}},onclick:function(e){q.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimerId);if(e.isMarked()){return;}var t=q(e.target);if(t.hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupMenuButton")){this._onContextMenu(e);e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupIcon")||t.hasClass("sapUiTableTreeIcon")){if(a.Grouping.toggleGroupHeaderByRef(this,e.target)){return;}}var $=a.getCell(this,e.target);var o=a.getCellInfo($);if(o.isOfType(a.CELLTYPE.COLUMNHEADER)){var p=this._getPointerExtension();if(p._bShowMenu){a.Menu.openContextMenu(this,e.target,false);delete p._bShowMenu;}}else{if(E._skipClick(e,t,o)){return;}if(!this._findAndfireCellEvent(this.fireCellClick,e)){if(o.isOfType(a.CELLTYPE.COLUMNROWHEADER)){this._toggleSelectAll();}else{E._handleClickSelection(e,$,this);}}else{e.preventDefault();}}},oncontextmenu:function(e){var p=this._getPointerExtension();if(p._bShowDefaultMenu){e.setMarked("handledByPointerExtension");delete p._bShowDefaultMenu;}else if(p._bShowMenu){e.setMarked("handledByPointerExtension");e.preventDefault();a.Menu.openContextMenu(this,e.target,false);delete p._bShowMenu;}else if(p._bHideMenu){e.setMarked("handledByPointerExtension");e.preventDefault();delete p._bHideMenu;}}};
var d=T.extend("sap.ui.table.TablePointerExtension",{
_init:function(t,s,m){this._delegate=c;t.addEventDelegate(this._delegate,t);t._iLastHoveredColumnIndex=0;t._bIsColumnResizerMoving=false;t._iFirstReorderableIndex=s==T.TABLETYPES.TREE?1:0;return"PointerExtension";},
_attachEvents:function(){var t=this.getTable();if(t){C.initColumnTracking(t);b.initRowHovering(t);}},
_detachEvents:function(){var t=this.getTable();if(t){var $=t.$();$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();}},
_debug:function(){this._ExtensionHelper=E;this._ColumnResizeHelper=C;this._InteractiveResizeHelper=I;this._ReorderHelper=R;this._ExtensionDelegate=c;this._RowHoverHandler=b;this._KNOWNCLICKABLECONTROLS=K;},
doAutoResizeColumn:function(i){var t=this.getTable();if(t){C.doAutoResizeColumn(t,i);}},
doReorderColumn:function(i,e){var t=this.getTable();if(t&&a.Column.isColumnMovable(t.getColumns()[i])){t._mTimeouts.delayedColumnReorderTimerId=q.sap.delayedCall(200,t,function(){R.initReordering(this,i,e);});}},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;T.prototype.destroy.apply(this,arguments);}
});
return d;});
sap.ui.predefine('sap/ui/table/TableRenderer',['sap/ui/core/Control','sap/ui/core/theming/Parameters','sap/ui/Device','./library','./TableUtils','sap/ui/core/Renderer','sap/ui/core/IconPool'],function(C,P,D,a,T,R,I){"use strict";var S=a.SelectionMode,V=a.VisibleRowCountMode;var b={};
b.render=function(r,t){delete t._iHeaderRowCount;r.write("<div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.writeControlData(t);r.addClass("sapUiTable");if('ontouchstart'in document){r.addClass("sapUiTableTouch");}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.addClass("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.addClass("sapUiTableRowSelectors");}if(T.hasRowHighlights(t)){r.addClass("sapUiTableRowHighlights");}var s=a.TableHelper.addTableClass();if(s){r.addClass(s);}if(t._getScrollExtension().isVerticalScrollbarRequired()){r.addClass("sapUiTableVScr");}if(t.getEditable()){r.addClass("sapUiTableEdt");}if(T.hasRowActions(t)){var i=T.getRowActionCount(t);r.addClass(i==1?"sapUiTableRActS":"sapUiTableRAct");}if(T.isNoDataVisible(t)&&!T.hasPendingRequests(t)){r.addClass("sapUiTableEmpty");}if(t.getShowOverlay()){r.addClass("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.addClass(m);}if(t.getWidth()){r.addStyle("width",t.getWidth());}if(t.getVisibleRowCountMode()==V.Auto){r.addStyle("height","0px");if(t._bFirstRendering){r.addClass("sapUiTableNoOpacity");}}r.writeClasses();r.writeStyles();r.write(">");this.renderTabElement(r,"sapUiTableOuterBefore");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCnt");r.addClass("sapUiTableCnt");r.writeClasses();r.writeAttribute("data-sap-ui-fastnavgroup","true");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableGridCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.write(">");this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);r.write("</div>");t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.write("<div");r.addClass("sapUiTableOverlayArea");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-overlay");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.write("></div>");r.write("</div>");if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderTabElement(r,"sapUiTableOuterAfter");r.write("</div>");};
b.renderHeader=function(r,t,o){r.write("<div");r.addClass("sapUiTableHdr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.write(">");r.renderControl(o);r.write("</div>");};
b.renderToolbar=function(r,t,o){r.write("<div");r.addClass("sapUiTableTbr");if(typeof o.getStandalone!=="function"){r.addClass("sapUiTableMTbr");}r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}if(T.isInstanceOf(o,"sap/m/Toolbar")){o.setDesign(P.get("_sap_ui_table_Table_ToolbarDesign"),true);}r.renderControl(o);r.write("</div>");};
b.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};
b.renderExtension=function(r,t,e){r.write("<div");r.addClass("sapUiTableExt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(e);r.write("</div>");};
b.renderTable=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCCnt");r.addClass("sapUiTableCCnt");r.writeClasses();r.write(">");this.renderTableCCnt(r,t);r.write("</div>");this.renderTabElement(r,"sapUiTableCtrlAfter");this.renderVSb(r,t);this.renderHSb(r,t);};
b.renderTableCCnt=function(r,t){this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderRowActions(r,t);r.write("<div");r.addClass("sapUiTableCtrlEmpty");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-noDataCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.write(">");if(t.getNoData()instanceof C){r.renderControl(t.getNoData());}else{r.write("<span");r.writeAttribute("id",t.getId()+"-noDataMsg");r.addClass("sapUiTableCtrlEmptyMsg");r.writeClasses();r.write(">");r.writeEscaped(T.getNoDataText(t));r.write("</span>");}r.write("</div>");};
b.renderFooter=function(r,t,f){r.write("<div");r.addClass("sapUiTableFtr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.write(">");r.renderControl(f);r.write("</div>");};
b.renderVariableHeight=function(r,t){r.write('<div id="'+t.getId()+'-sb" tabIndex="-1"');r.addClass("sapUiTableHeightResizer");r.addStyle("height","5px");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");};
b.renderColHdr=function(r,t){var n=T.getHeaderRowCount(t);var c=t.getColumns();var f=t.getFixedColumnCount();r.write("<div");r.addClass("sapUiTableColHdrCnt");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",(t.getColumnHeaderHeight()*n)+"px");}r.writeStyles();r.write(">");this.renderColRowHdr(r,t);if(f>0){r.write("<div");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScrFixed");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");this.renderTableControlCnt(r,t,true,0,f,true,false,0,n,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableColHdrScr");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScr");if(c.length==0){r.addClass("sapUiTableHasNoColumns");}r.writeClasses();if(f>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");this.renderTableControlCnt(r,t,false,f,c.length,false,false,0,n,true);r.write("</div>");if(T.hasRowActions(t)){r.write("<div class='sapUiTableRowActionHeader' id='"+t.getId()+"-rowacthdr'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWACTIONHEADER");r.write("><span>");r.writeEscaped(t._oResBundle.getText("TBL_ROW_ACTION_COLUMN_LABEL"));r.write("</span></div>");}r.write("</div>");};
b.renderColRowHdr=function(r,t){var e=false;var s=false;r.write("<div");r.writeAttribute("id",t.getId()+"-selall");if(T.hasSelectAll(t)){var A=T.areAllRowsSelected(t);if(t._getShowStandardTooltips()){var c=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";r.writeAttributeEscaped("title",t._oResBundle.getText(c));}if(!A){r.addClass("sapUiTableSelAll");}else{s=true;}r.addClass("sapUiTableSelAllEnabled");e=true;}else{r.addClass("sapUiTableSelAllDisabled");}r.addClass("sapUiTableColRowHdr");r.writeClasses();r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:e,checked:s});r.write(">");if(t.getSelectionMode()!==S.Single){r.write("<div");r.addClass("sapUiTableColRowHdrIco");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}r.write(">");r.write("</div>");}r.write("</div>");};
b.renderCol=function(r,t,c,h,n,l){var L,i=!n,d=c.getIndex(),e=c.getMultiLabels();if(e.length>0){L=e[h];}else if(h==0){L=c.getLabel();}r.write("<td");var H=c.getId();if(h===0){r.writeElementData(c);}else{H=H+"_"+h;r.writeAttribute('id',H);}r.writeAttribute('data-sap-ui-colid',c.getId());r.writeAttribute("data-sap-ui-colindex",d);r.writeAttribute("tabindex","-1");var A={column:c,headerId:H,index:d};if(n>1){r.writeAttribute("colspan",n);A.colspan=true;}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",A);r.addClass("sapUiTableCol");if(l){r.addClass("sapUiTableColLastFixed");}r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}if(i){r.addStyle("display","none");}r.writeStyles();var s=c.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write("><div");r.addClass("sapUiTableColCell");r.writeAttribute("id",H+"-inner");r.writeClasses();var f=R.getTextAlign(c.getHAlign(),L&&L.getTextDirection&&L.getTextDirection());if(f){r.addStyle("text-align",f);}r.writeStyles();r.write(">");if(L){r.renderControl(L);}r.write("</div></td>");};
b.renderColRsz=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-rsz");r.addClass("sapUiTableColRsz");r.writeClasses();r.write("></div>");};
b.renderRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowHdrScr");r.addClass("sapUiTableRowHdrScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.write(">");for(var c=0,d=t.getRows().length;c<d;c++){this.renderRowAddon(r,t,t.getRows()[c],c,true);}r.write("</div>");};
b.renderRowActions=function(r,t){if(!T.hasRowActions(t)){return;}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowActionScr");r.addClass("sapUiTableRowActionScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");for(var c=0,d=t.getRows().length;c<d;c++){this.renderRowAddon(r,t,t.getRows()[c],c,false);}r.write("</div>");};
b._addFixedRowCSSClasses=function(r,t,i){var f=t.getFixedRowCount();var F=T.getFirstFixedButtomRowIndex(t);if(f>0){if(i<f){r.addClass("sapUiTableFixedTopRow");}if(i==f-1){r.addClass("sapUiTableFixedLastTopRow");}}if(F>=0&&F===i){r.addClass("sapUiTableFixedFirstBottomRow");}else if(F>=1&&F-1===i){r.addClass("sapUiTableFixedPreBottomRow");}};
b.renderRowAddon=function(r,t,o,i,h){r.write("<div");r.writeAttribute("id",t.getId()+(h?"-rowsel":"-rowact")+i);r.writeAttribute("data-sap-ui-related",o.getId());r.writeAttribute("data-sap-ui-rowindex",i);r.addClass(h?"sapUiTableRowHdr":"sapUiTableRowAction");if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.addClass("sapUiTableRowAlternate");}this._addFixedRowCSSClasses(r,t,i);var c=false;var d=false;if(o._bHidden){r.addClass("sapUiTableRowHidden");d=true;}else{if(t.isIndexSelected(o.getIndex())){r.addClass("sapUiTableRowSel");c=true;}}r.writeClasses();if(t.getRowHeight()>0){r.addStyle("height",t.getRowHeight()+"px");}r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"ROWHEADER":"ROWACTION",{rowSelected:c,rowHidden:d});r.writeStyles();r.write(">");if(h){this.writeRowHighlightContent(r,t,o,i);this.writeRowSelectorContent(r,t,o,i);}else{var A=o.getAggregation("_rowAction");if(A){r.renderControl(A);}}r.write("</div>");};
b.renderTableCtrl=function(r,t){if(t.getFixedColumnCount()>0){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScrFixed");r.addClass("sapUiTableCtrlScrFixed");r.writeClasses();r.write(">");this.renderTableControl(r,t,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScr");r.addClass("sapUiTableCtrlScr");r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCtrlCnt");r.addClass("sapUiTableCtrlCnt");r.writeClasses();var v=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(v==V.Fixed||v==V.Interactive)){var s="height";if(t.getVisibleRowCountMode()==V.Fixed){s="min-height";}r.addStyle(s,t._iTableRowContentHeight+"px");r.writeStyles();}r.write(">");this.renderTableControl(r,t,false);r.write("</div></div>");};
b.renderTableControl=function(r,t,f){var s,e;if(f){s=0;e=t.getFixedColumnCount();}else{s=t.getFixedColumnCount();e=t.getColumns().length;}var F=t.getFixedRowCount();var i=t.getFixedBottomRowCount();var c=t.getRows();if(F>0){this.renderTableControlCnt(r,t,f,s,e,true,false,0,F);}this.renderTableControlCnt(r,t,f,s,e,false,false,F,c.length-i);if(i>0&&c.length>0){this.renderTableControlCnt(r,t,f,s,e,false,true,c.length-i,c.length);}};
b.renderTableControlCnt=function(r,t,f,s,e,F,c,i,E,h){r.write("<table");var d=h?"-header":"-table";var g=t.getId()+d;if(f){g+="-fixed";r.addClass("sapUiTableCtrlFixed");}else{r.addClass("sapUiTableCtrlScroll");}if(F){g+="-fixrow";r.addClass("sapUiTableCtrlRowFixed");}else if(c){g+="-fixrow-bottom";r.addClass("sapUiTableCtrlRowFixedBottom");}else{r.addClass("sapUiTableCtrlRowScroll");}r.writeAttribute("id",g);t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"COLUMNHEADER_TABLE":"TABLE");r.addClass("sapUiTableCtrl");if(h){r.addClass("sapUiTableCHT");}r.writeClasses();r.addStyle(f?"width":"min-width",t._getColumnsWidth(s,e)+"px");r.writeStyles();r.write(">");r.write("<thead>");r.write("<tr");r.addClass("sapUiTableCtrlCol");if(i==0){r.addClass("sapUiTableCtrlFirstCol");}if(h){r.addClass("sapUiTableCHTHR");}r.writeClasses();r.write(">");var j=t.getColumns();var k=new Array(e);var l;var o;var H=false;var m=!f&&e>s;for(l=s;l<e;l++){o=j[l];var n={shouldRender:!!(o&&o.shouldRender())};if(n.shouldRender){var w=o.getWidth();if(T.isVariableWidth(w)){m=false;if(f){o._iFixWidth=o._iFixWidth||160;w=o._iFixWidth+"px";}else if(w&&w.indexOf("%")>0){H=true;}}else if(f){delete o._iFixWidth;}n.width=w;}k[l]=n;}if(T.hasRowHeader(t)&&!h){r.write("<th");if(H){r.addStyle("width","0%");}else{r.addStyle("width","0px");}r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH");if(!h){r.writeAttribute("id",t.getId()+"-colsel");}r.addClass("sapUiTableColSel");r.writeClasses();}r.write("></th>");}else{if(j.length===0){r.write("<th></th>");}}for(l=s;l<e;l++){d=h?"_hdr":"_col";o=j[l];n=k[l];if(n.shouldRender){r.write("<th");if(n.width){r.addStyle("width",n.width);r.writeStyles();}if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:o});r.writeAttribute("id",t.getId()+d+l);}r.writeAttribute("data-sap-ui-headcolindex",l);r.writeAttribute("data-sap-ui-colid",o.getId());r.write(">");if(i==0&&T.getHeaderRowCount(t)==0&&!h){if(o.getMultiLabels().length>0){r.renderControl(o.getMultiLabels()[0]);}else{r.renderControl(o.getLabel());}}r.write("</th>");}}if(m){r.write("<th");if(h){r.writeAttribute("id",t.getId()+"-dummycolhdr");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write("></th>");}r.write("</tr>");r.write("</thead>");r.write("<tbody>");var v=t._getVisibleColumns();var p=t.getRows();var q;var u;if(h){for(q=i,u=E;q<u;q++){this.renderColumnHeaderRow(r,t,q,f,s,e,m);}}else{var x=t._getAccExtension().getAriaTextsForSelectionMode(true);var y=T.isRowSelectionAllowed(t);var z=t.getDragDropConfig().some(function(A){return A.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&A.getSourceAggregation()==="rows";});for(q=i,u=E;q<u;q++){this.renderTableRow(r,t,p[q],q,f,s,e,false,v,m,x,y,z);}}r.write("</tbody>");r.write("</table>");};
b.addTrClasses=function(r,t,o,i){return;};
b.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isGroupMode(t)){r.write("<div");r.writeAttribute("class","sapUiTableGroupShield");r.write("></div>");r.write("<div");r.writeAttribute("id",o.getId()+"-groupHeader");r.writeAttribute("class","sapUiTableGroupIcon");r.write("></div>");if(T.Grouping.showGroupMenuButton(t)){var c=I.getIconInfo("sap-icon://drop-down-list");r.write("<div class='sapUiTableGroupMenuButton'>");r.writeEscaped(c.content);r.write("</div>");}}};
b.writeRowHighlightContent=function(r,t,o,i){if(!T.hasRowHighlights(t)){return;}var c=o.getAggregation("_settings");var h=c._getHighlightCSSClassName();r.write("<div");r.writeAttribute("id",o.getId()+"-highlight");r.addClass("sapUiTableRowHighlight");r.addClass(h);r.writeClasses();r.write(">");t._getAccRenderExtension().writeAccRowHighlightText(r,t,o,i);r.write("</div>");};
b.renderColumnHeaderRow=function(r,t,i,f,s,e,h){r.write("<tr");r.addClass("sapUiTableColHdrTr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.write(">");var c,n=0,l=-1;c=t.getColumns().slice(s,e).filter(function(o){return!!o&&o.shouldRender();});function d(o,j,k){var m=T.Column.getHeaderSpan(o,i),p;if(n<1){if(m>1){p=o.getIndex();m=k.slice(j+1,j+m).reduce(function(q,u){return u.getIndex()-p<m?q+1:q;},1);}o._nSpan=n=m;l=j;}else{o._nSpan=0;}n--;}c.forEach(d);function g(o,j){this.renderCol(r,t,o,i,o._nSpan,f&&(j==l));o._nSpan=undefined;}c.forEach(g.bind(this));if(!f&&h&&c.length>0){r.write('<td class="sapUiTableTDDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};
b.renderTableRow=function(r,t,o,i,f,s,e,F,v,h,m,c,d){if(!o){return;}r.write("<tr");if(o._bDummyRow){r.addStyle("opacity","0");}r.addClass("sapUiTableTr");if(f){r.writeAttribute("id",o.getId()+"-fixed");r.writeAttribute("data-sap-ui-related",o.getId());}else{r.writeElementData(o);}if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(d&&f){r.writeAttribute("draggable",true);}if(t.isIndexSelected(o.getIndex())){r.addClass("sapUiTableRowSel");}this.addTrClasses(r,t,o,i);}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.addClass("sapUiTableRowAlternate");}var g=t.getRows();var j=g.length;if(j>0&&g[j-1]===o){r.addClass("sapUiTableLastRow");}else if(j>0&&g[0]===o){r.addClass("sapUiTableFirstRow");}this._addFixedRowCSSClasses(r,t,i);r.writeClasses();r.writeAttribute("data-sap-ui-rowindex",i);var k=t.getRowHeight();if(k>0){r.addStyle("height",k+"px");}r.writeStyles();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i});r.write(">");var l=o.getCells();if(T.hasRowHeader(t)||l.length===0){r.write("<td");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_TD",{rowSelected:!o._bHidden&&t.isIndexSelected(o.getIndex()),index:i});r.write("></td>");}for(var n=0,p=l.length;n<p;n++){this.renderTableCell(r,t,o,l[n],n,f,s,e,v);}if(!f&&h&&l.length>0){r.write('<td class="sapUiTableTDDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};
b.renderTableCell=function(r,t,o,c,i,f,s,e,v){var d=c.data("sap-ui-colindex");var g=t.getColumns()[d];if(g.shouldRender()&&s<=d&&e>d){r.write("<td");var h=o.getId()+"-col"+i;r.writeAttribute("id",h);r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-ui-colid",g.getId());var n=v.length;var j=n>0&&v[0]===g;var k=n>0&&v[n-1]===g;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:d,column:g,row:o,fixed:f,firstCol:j});var H=R.getTextAlign(g.getHAlign(),c&&c.getTextDirection&&c.getTextDirection());if(H){r.addStyle("text-align",H);}r.writeStyles();r.addClass("sapUiTableTd");if(j){r.addClass("sapUiTableTdFirst");}if(k){r.addClass("sapUiTableTdLast");}if(g.getGrouped()){r.addClass("sapUiTableTdGroup");}var B=t.getBinding("rows");if(B&&g.getLeadingProperty&&B.isMeasure(g.getLeadingProperty())){r.addClass("sapUiTableMeasureCell");}r.writeClasses();r.write("><div");r.addClass("sapUiTableCell");if(j&&T.Grouping.isTreeMode(t)){r.addClass("sapUiTableCellFlex");}r.writeClasses();if(t.getRowHeight()&&t.getVisibleRowCountMode()==V.Auto){r.addStyle("max-height",t.getRowHeight()+"px");}r.writeStyles();r.write(">");this.renderTableCellControl(r,t,c,j);r.write("</div></td>");}};
b.renderTableCellControl=function(r,t,c,i){if(i&&T.Grouping.isTreeMode(t)&&!t._bFlatMode){var o=c.getParent();r.write("<span class='sapUiTableTreeIcon' tabindex='-1' id='"+o.getId()+"-treeicon'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:o});r.write("></span>");}r.renderControl(c);};
b.renderVSb=function(r,t){var s=t._getScrollExtension();r.write("<div");r.addClass("sapUiTableVSbBg");r.writeAttribute("id",t.getId()+"-vsb-bg");r.writeClasses();r.write("></div>");r.write("<div");r.addClass("sapUiTableVSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-vsb");r.writeAttribute("tabindex","-1");r.addStyle("max-height",s.getVerticalScrollbarHeight()+"px");if(t.getFixedRowCount()>0){t._iVsbTop=(t.getFixedRowCount()*t._getDefaultRowHeight())-1;r.addStyle("top",t._iVsbTop+'px');}r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-vsb-content");r.addClass("sapUiTableVSbContent");r.writeClasses();r.addStyle("height",s.getVerticalScrollHeight()+"px");r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");};
b.renderHSb=function(r,t){r.write("<div");r.addClass("sapUiTableHSbBg");r.writeAttribute("id",t.getId()+"-hsb-bg");r.writeClasses();r.write("></div>");r.write("<div");r.addClass("sapUiTableHSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-hsb");r.writeAttribute("tabindex","-1");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-hsb-content");r.addClass("sapUiTableHSbContent");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");};
b.renderTabElement=function(r,c){r.write("<div");if(c){r.addClass(c);r.writeClasses();}r.writeAttribute("tabindex","0");r.write("></div>");};
return b;},true);
sap.ui.predefine('sap/ui/table/TableRendererUtils',['jquery.sap.global','sap/ui/core/Control'],function(q,C){"use strict";var T=null;var a={addClass:function(r,c,s){if(c&&(!!s||arguments.length==2)){r.addClass(c);if(T){T.writeClasses=true;}}return a;},addStyle:function(r,n,v,s){if(n&&v&&(!!s||arguments.length==3)){r.addStyle(n,v);if(T){T.writeStyles=true;}}return a;},startElement:function(r,t,c){c=c||{};r.write("<",c.tag||"div");T=c;if(c.furtherSettings){c.furtherSettings(r,t);}if(q.isArray(c.classname)&&c.classname.length){for(var i=0;i<c.classname.length;i++){a.addClass(r,c.classname[i]);}}else if(c.classname){a.addClass(r,c.classname);}if(c.id){r.writeAttribute("id",(c.element||t).getId()+"-"+c.id);}else if(c.element){if(c.element instanceof C){r.writeControlData(c.element);}else{r.writeElementData(c.element);}}if(c.attributes){for(var n in c.attributes){if(c.attributes.hasOwnProperty(n)){r.writeAttribute(n,c.attributes[n]);}}}if(typeof c.tabindex==="number"){r.writeAttribute("tabindex",""+c.tabindex);}if(c.aria){t._getAccRenderExtension().writeAriaAttributesFor(r,t,c.aria,c.ariaconfig);}if(T.writeClasses){r.writeClasses();}if(T.writeStyles){r.writeStyles();}T=null;r.write(">");return a;},endElement:function(r,t){r.write("</",t||"div",">");return a;},renderElement:function(r,t,c){a.startElement(r,t,c);a.endElement(r,c?c.tag:null);return a;}};return a;},true);
sap.ui.predefine('sap/ui/table/TableScrollExtension',["jquery.sap.global","./TableExtension","./TableUtils","sap/ui/Device","./library","jquery.sap.trace","jquery.sap.events"],function(q,T,c,D,l){"use strict";var S=l.SharedDomRef;var M=1000000;var H={onScroll:function(o){var s=this._getScrollExtension();q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(o);if(this._bOnAfterRendering){return;}var n=o.target.scrollLeft;var O=o.target._scrollLeft;if(n!==O){var a=H.getScrollAreas(this);o.target._scrollLeft=n;for(var i=0;i<a.length;i++){var b=a[i];if(b!==o.target&&b.scrollLeft!==n){b.scrollLeft=n;b._scrollLeft=n;}}s._iHorizontalScrollPosition=n;this._determineVisibleCols(this._collectTableSizes());}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var h=s.getHorizontalScrollbar();if(h!==null&&s._iHorizontalScrollPosition!==null){var a=H.getScrollAreas(t);for(var i=0;i<a.length;i++){var o=a[i];delete o._scrollLeft;}if(h.scrollLeft!==s._iHorizontalScrollPosition){h.scrollLeft=s._iHorizontalScrollPosition;}else{var b=q.Event("scroll");b.target=h;H.onScroll.call(t,b);}}},addEventListeners:function(t){var s=t._getScrollExtension();var a=H.getScrollAreas(t);if(s._onHorizontalScrollEventHandler==null){s._onHorizontalScrollEventHandler=H.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var a=H.getScrollAreas(t);if(s._onHorizontalScrollEventHandler!=null){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete a[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}},getScrollAreas:function(t){var s=[t._getScrollExtension().getHorizontalScrollbar(),t.getDomRef("sapUiTableColHdrScr"),t.getDomRef("sapUiTableCtrlScr")];return s.filter(function(o){return o!=null;});}};var V={onScroll:function(o){var s=this._getScrollExtension();q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(o);if(s._bIsScrolledVerticallyByKeyboard){return;}this._getKeyboardExtension().setActionMode(false);function u(t){var v=t._getScrollExtension().getVerticalScrollbar();if(!v){return;}var i=v.scrollTop;s._iVerticalScrollPosition=i;if(s._bSkipUpdateFirstVisibleRow){s._bSkipUpdateFirstVisibleRow=false;return;}var n=s.getRowIndexAtScrollPosition(i);var O=t.getFirstVisibleRow();var f=n!==O;if(f){t.setFirstVisibleRow(n,true);if(c.isVariableRowHeightEnabled(t)){t.attachEventOnce("_rowsUpdated",function(){s.updateInnerVerticalScrollPosition(this._aRowHeights);});}}else if(c.isVariableRowHeightEnabled(t)){s.updateInnerVerticalScrollPosition(t._aRowHeights);}}if(this._bLargeDataScrolling&&!s._bIsScrolledVerticallyByWheel){q.sap.clearDelayedCall(this._mTimeouts.scrollUpdateTimerId);this._mTimeouts.scrollUpdateTimerId=q.sap.delayedCall(300,this,function(){u(this);delete this._mTimeouts.scrollUpdateTimerId;}.bind(this));}else{u(this);}s._bIsScrolledVerticallyByWheel=false;},onScrollbarMouseDown:function(o){var s=this._getScrollExtension();s._bIsScrolledVerticallyByWheel=false;s._bIsScrolledVerticallyByKeyboard=false;},restoreScrollPosition:function(t){var s=t._getScrollExtension();if(s._iVerticalScrollPosition!==null){s.updateVerticalScrollPosition(s._iVerticalScrollPosition);}else{s.updateVerticalScrollPosition();}},addEventListeners:function(t){var s=t._getScrollExtension();var a=V.getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler==null){s._onVerticalScrollEventHandler=V.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v!==null){if(s._onVerticalScrollbarMouseDownEventHandler==null){s._onVerticalScrollbarMouseDownEventHandler=V.onScrollbarMouseDown.bind(t);}v.addEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var a=V.getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler!=null){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v!==null&&s._onVerticalScrollbarMouseDownEventHandler!=null){v.removeEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);delete s._onVerticalScrollbarMouseDownEventHandler;}},getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(o){return o!=null;});}};var d={onMouseWheelScrolling:function(o){var s=this._getScrollExtension();var v=Math.abs(o.deltaY)>Math.abs(o.deltaX);var i=v?o.deltaY:o.deltaX;var h=v&&o.shiftKey||!v;var b=i>0;var a=false;if(i===0){return;}if(h){var f=s.getHorizontalScrollbar();if(o.deltaMode>0){var m=c.Column.getMinColumnWidth();i=b?m:-m;}if(b){a=f.scrollLeft===f.scrollWidth-f.offsetWidth;}else{a=f.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!a){f.scrollLeft=f.scrollLeft+i;}o.preventDefault();o.stopPropagation();}else{var g=s.getVerticalScrollbar();if(o.deltaMode===1){i*=s.getVerticalScrollRangeRowFraction();}else if(o.deltaMode===2){i*=s.getVerticalScrollRangeRowFraction()*this.getVisibleRowCount();}if(b){a=g.scrollTop===g.scrollHeight-g.offsetWidth;}else{a=g.scrollTop===0;}if(s.isVerticalScrollbarVisible()&&!a){o.preventDefault();o.stopPropagation();var r=i/(o.deltaMode===0?this._getDefaultRowHeight():s.getVerticalScrollRangeRowFraction());if(r>1){r=Math.floor(r);}s._bIsScrolledVerticallyByWheel=true;s._bIsScrolledVerticallyByKeyboard=false;g.scrollTop+=r*s.getVerticalScrollRangeRowFraction();}}},onTouchStart:function(o){if(o.type==="touchstart"||o.pointerType==="touch"){var s=this._getScrollExtension();var h=s.getHorizontalScrollbar();var v=s.getVerticalScrollbar();var t=o.touches?o.touches[0]:o;s._mTouchSessionData={initialPageX:t.pageX,initialPageY:t.pageY,initialScrollTop:v==null?0:v.scrollTop,initialScrollLeft:h==null?0:h.scrollLeft,initialScrolledToEnd:null,touchMoveDirection:null};}},onTouchMoveScrolling:function(o){if(o.type==="touchmove"||o.pointerType==="touch"){var s=this._getScrollExtension();var t=s._mTouchSessionData;if(t==null){return;}var a=o.touches?o.touches[0]:o;var i=(a.pageX-t.initialPageX);var b=(a.pageY-t.initialPageY);var f=false;var g=false;if(t.touchMoveDirection===null){if(i===0&&b===0){return;}t.touchMoveDirection=Math.abs(i)>Math.abs(b)?"horizontal":"vertical";}switch(t.touchMoveDirection){case"horizontal":var h=s.getHorizontalScrollbar();if(h!=null){if(i<0){f=h.scrollLeft===h.scrollWidth-h.offsetWidth;}else{f=h.scrollLeft===0;}if(t.initialScrolledToEnd===null){t.initialScrolledToEnd=f;}if(!f&&!t.initialScrolledToEnd){h.scrollLeft=t.initialScrollLeft-i;g=true;}}break;case"vertical":var v=s.getVerticalScrollbar();if(v!=null){if(b<0){f=v.scrollTop===v.scrollHeight-v.offsetHeight;}else{f=v.scrollTop===0;}if(t.initialScrolledToEnd===null){t.initialScrolledToEnd=f;}if(!f&&!t.initialScrolledToEnd){v.scrollTop=t.initialScrollTop-b;g=true;}}break;default:}if(g){o.preventDefault();}}},addEventListeners:function(t){var s=t._getScrollExtension();var a=d.getEventListenerTargets(t);if(s._onMouseWheelEventHandler==null){s._onMouseWheelEventHandler=d.onMouseWheelScrolling.bind(t);}if(s._onTouchStartEventHandler==null){s._onTouchStartEventHandler=d.onTouchStart.bind(t);}if(s._onTouchMoveEventHandler==null){s._onTouchMoveEventHandler=d.onTouchMoveScrolling.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("wheel",s._onMouseWheelEventHandler);if(D.support.pointer&&D.system.desktop){a[i].addEventListener("pointerdown",s._onTouchStartEventHandler);a[i].addEventListener("pointermove",s._onTouchMoveEventHandler,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].addEventListener("touchstart",s._onTouchStartEventHandler);a[i].addEventListener("touchmove",s._onTouchMoveEventHandler);}}},removeEventListeners:function(t){var s=t._getScrollExtension();var a=d.getEventListenerTargets(t);for(var i=0;i<a.length;i++){if(s._onMouseWheelEventHandler!=null){a[i].removeEventListener("wheel",s._onMouseWheelEventHandler);}if(s._onTouchStartEventHandler!=null&&s._onTouchMoveEventHandler!=null){if(D.support.pointer&&D.system.desktop){a[i].removeEventListener("pointerdown",s._onTouchStartEventHandler);a[i].removeEventListener("pointermove",s._onTouchMoveEventHandler,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].removeEventListener("touchstart",s._onTouchStartEventHandler);a[i].removeEventListener("touchmove",s._onTouchMoveEventHandler);}}}delete s._onMouseWheelEventHandler;delete s._onTouchStartEventHandler;delete s._onTouchMoveEventHandler;},getEventListenerTargets:function(t){var a=[t.getDomRef("tableCCnt")];return a.filter(function(o){return o!=null;});}};var E={onBeforeRendering:function(o){this._getScrollExtension()._clearCache();},onAfterRendering:function(o){V.restoreScrollPosition(this);H.restoreScrollPosition(this);},onfocusin:function(o){var r;var C=c.getCellInfo(o.target);if(C.isOfType(c.CELLTYPE.DATACELL)){r=this.getDomRef("sapUiTableCtrlScr");}else if(C.isOfType(c.CELLTYPE.COLUMNHEADER)){r=this.getDomRef("sapUiTableColHdrScr");}if(r!=null&&C.columnIndex>=this.getFixedColumnCount()){var a=C.cell[0];var s=r.scrollLeft;var R=r.clientWidth;var i=a.offsetLeft;var b=i+a.offsetWidth;var O=i-s;var f=b-R-s;var h=this._getScrollExtension().getHorizontalScrollbar();if(O<0&&f<0){h.scrollLeft=s+O;}else if(f>0&&O>0){h.scrollLeft=s+f;}}var p=c.getParentCell(this,o.target);if(p!=null){Promise.resolve().then(function(){var I=p.find(".sapUiTableCell");if(I.length>0){if(this._bRtlMode){I.scrollLeftRTL(I[0].scrollWidth-I[0].clientWidth);}else{I[0].scrollLeft=0;}I[0].scrollTop=0;}}.bind(this));}}};
var e=T.extend("sap.ui.table.TableScrollExtension",{
_init:function(t,s,m){this._delegate=E;this._oVerticalScrollbar=null;this._oHorizontalScrollbar=null;this._iHorizontalScrollPosition=null;this._iVerticalScrollPosition=null;this._iInnerVerticalScrollRange=0;this._bIsScrolledVerticallyByWheel=false;this._bIsScrolledVerticallyByKeyboard=false;this._bSkipUpdateFirstVisibleRow=false;this._mTouchSessionData=null;t.addEventDelegate(this._delegate,t);return"ScrollExtension";},
_attachEvents:function(){var t=this.getTable();H.addEventListeners(t);V.addEventListeners(t);d.addEventListeners(t);},
_detachEvents:function(){var t=this.getTable();H.removeEventListeners(t);V.removeEventListeners(t);d.removeEventListeners(t);},
_debug:function(){this._ScrollingHelper=d;this._ExtensionDelegate=E;this._HorizontalScrollingHelper=H;this._VerticalScrollingHelper=V;},
destroy:function(){var t=this.getTable();if(t!=null){t.removeEventDelegate(this._delegate);}this._delegate=null;this._clearCache();T.prototype.destroy.apply(this,arguments);}
});
e.prototype.scrollVertically=function(b,p,i,a,B){var t=this.getTable();if(t==null){return false;}b=b===true;p=p===true;i=i===true;a=a===true;var s=false;var r=t._getTotalRowCount();var v=t.getVisibleRowCount();var f=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var F=t.getFirstVisibleRow();var g=p?f:1;if(b){if(F+v<r){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.min(F+g,r-v));},0);}else{t.setFirstVisibleRow(Math.min(F+g,r-v));}s=true;}}else if(F>0){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.max(F-g,0));},0);}else{t.setFirstVisibleRow(Math.max(F-g,0));}s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};
e.prototype.scrollVerticallyMax=function(b,i){var t=this.getTable();if(t==null){return false;}if(b==null){b=false;}if(i==null){i=false;}var s=false;var f=t.getFirstVisibleRow();if(b){var F=t._getTotalRowCount()-c.getNonEmptyVisibleRowCount(t);if(f<F){t.setFirstVisibleRow(F);s=true;}}else if(f>0){t.setFirstVisibleRow(0);s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};
e.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(t!=null&&this._oHorizontalScrollbar===null){this._oHorizontalScrollbar=t.getDomRef(S.HorizontalScrollBar);}return this._oHorizontalScrollbar;};
e.prototype.getVerticalScrollbar=function(){var t=this.getTable();if(t!=null&&this._oVerticalScrollbar===null){this._oVerticalScrollbar=t.getDomRef(S.VerticalScrollBar);}return this._oVerticalScrollbar;};
e.prototype.isHorizontalScrollbarVisible=function(){var t=this.getTable();var o=t==null?null:t.getDomRef();if(o==null){return false;}return o.classList.contains("sapUiTableHScr");};
e.prototype.isVerticalScrollbarVisible=function(){var t=this.getTable();var o=t==null?null:t.getDomRef();if(o==null){return false;}return o.classList.contains("sapUiTableVScr");};
e.prototype.updateHorizontalScrollbar=function(t){var o=this.getTable();var h=this.getHorizontalScrollbar();if(o==null||h==null||t==null){return;}var $=o.$();var C=t.tableCtrlScrollWidth;if(D.browser.safari){C=Math.max(C,o._getColumnsWidth(o.getFixedColumnCount()));}var b=C>t.tableCtrlScrWidth;if(b){if(!this.isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");if(D.browser.safari){var a=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");a.outerWidth(C);}}var s=t.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){s+=t.tableRowHdrScrWidth;}if(o.getRows().length>0){if(o._bRtlMode){h.style.marginRight=s+"px";h.style.marginLeft="";}else{h.style.marginLeft=s+"px";h.style.marginRight="";}}var f=o.getDomRef("hsb-content");if(f){f.style.width=C+"px";}}if(!b&&this.isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");if(D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}};
e.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(t==null||v==null){return;}v.style.maxHeight=this.getVerticalScrollbarHeight()+"px";};
e.prototype.getVerticalScrollbarHeight=function(){var t=this.getTable();if(t==null){return 0;}return t._getScrollableRowCount()*t._getDefaultRowHeight();};
e.prototype.updateVerticalScrollbarPosition=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(t==null||v==null){return;}var o=t.getDomRef("tableCCnt");if(o){var i=o.offsetTop;var a=t.getDomRef("vsb-bg");a.style.top=i+"px";var f=t.getFixedRowCount();if(f>0){i+=t._iVsbTop;}v.style.top=i+"px";}};
e.prototype.updateVerticalScrollPosition=function(s){var t=this.getTable();var v=this.getVerticalScrollbar();if(t==null||v==null||!this.isVerticalScrollbarRequired()){return;}if(s==null){s=Math.ceil(t.getFirstVisibleRow()*this.getVerticalScrollRangeRowFraction());this._bSkipUpdateFirstVisibleRow=true;}this._iVerticalScrollPosition=null;window.requestAnimationFrame(function(){var o=v.scrollTop;v.scrollTop=s;if(v.scrollTop===o){this._bSkipUpdateFirstVisibleRow=false;}}.bind(this));};
e.prototype.updateVerticalScrollHeight=function(){var t=this.getTable();var v=t==null?null:t.getDomRef("vsb-content");if(v==null){return;}v.style.height=this.getVerticalScrollHeight()+"px";};
e.prototype.getVerticalScrollHeight=function(){var t=this.getTable();if(t==null){return 0;}var v=t.getVisibleRowCount();if(c.isVariableRowHeightEnabled(t)){v++;}var r=Math.max(t._getTotalRowCount(),v);var s=t._getDefaultRowHeight()*r;return Math.min(M,s);};
e.prototype.updateVerticalScrollbarVisibility=function(){var t=this.getTable();var o=t==null?null:t.getDomRef();var v=this.getVerticalScrollbar();if(o==null||v==null){return;}var b=this.isVerticalScrollbarRequired();if(b&&!this.isVerticalScrollbarVisible()){o.classList.add("sapUiTableVScr");this.updateVerticalScrollPosition(0);}if(!b&&this.isVerticalScrollbarVisible()){o.classList.remove("sapUiTableVScr");}};
e.prototype.isVerticalScrollbarRequired=function(){var t=this.getTable();if(t==null){return false;}return this._iInnerVerticalScrollRange>0||(t._getTotalRowCount()>t.getVisibleRowCount());};
e.prototype.getRowIndexAtScrollPosition=function(s){var t=this.getTable();if(t==null){return-1;}var m=t._getMaxRowIndex();if(m===0){return 0;}else{var r=Math.floor(s/this.getVerticalScrollRangeRowFraction());var n=this.getVerticalScrollRange()-s;var b=n<1;return b?m:Math.min(m,r);}};
e.prototype.getVerticalScrollRange=function(){var t=this.getTable();if(t==null){return 0;}var v=this.getVerticalScrollHeight()-this.getVerticalScrollbarHeight();if(c.isVariableRowHeightEnabled(t)){v=v-this._iInnerVerticalScrollRange;}return Math.max(1,v);};
e.prototype.getVerticalScrollRangeRowFraction=function(){var t=this.getTable();if(t==null){return 0;}return Math.max(1,this.getVerticalScrollRange())/Math.max(1,t._getMaxRowIndex());};
e.prototype.getVerticalScrollRangeDelta=function(){var t=this.getTable();if(t==null){return 0;}var v=this.getVerticalScrollHeight()-this.getVerticalScrollbarHeight();if(t._getTotalRowCount()>t.getVisibleRowCount()){v-=this.getVerticalScrollRange();}return Math.max(0,v);};
e.prototype.updateInnerVerticalScrollPosition=function(r){var t=this.getTable();if(t==null){return;}var s=this._iVerticalScrollPosition==null?0:this._iVerticalScrollPosition;var b=s<this.getVerticalScrollRange();var v=t._getTotalRowCount()>t.getVisibleRowCount();if(b&&t.getFirstVisibleRow()!=t._iRenderedFirstVisibleRow){return;}var i=null;if(b&&v){var f=r[0];var a=this.getVerticalScrollRangeRowFraction();var p=s-(t.getFirstVisibleRow()*a);var P=p/a;i=Math.ceil(P*f);if(i>f){i=null;}}else if(this._iInnerVerticalScrollRange>=0){var g=v?s-this.getVerticalScrollRange():s;i=(this._iInnerVerticalScrollRange/this.getVerticalScrollRangeDelta())*g;}if(i!=null&&i>-1){t.$().find(".sapUiTableCCnt").scrollTop(i);}};
e.prototype.updateInnerVerticalScrollRangeCache=function(r){var t=this.getTable();if(t==null){this._iInnerVerticalScrollRange=0;return;}var i=t._getDefaultRowHeight()*t.getVisibleRowCount();if(t.getVisibleRowCount()>=t._getTotalRowCount()){r=r.slice(0,t._getTotalRowCount());}var n=r.reduce(function(a,b){return a+b;},0)-i;if(n>0){n=Math.ceil(n);}this._iInnerVerticalScrollRange=Math.max(0,n);};
e.prototype._clearCache=function(){this._oVerticalScrollbar=null;this._oHorizontalScrollbar=null;};
return e;});
sap.ui.predefine('sap/ui/table/TableUtils',["jquery.sap.global","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/ui/model/ChangeReason","./TableGrouping","./TableColumnUtils","./TableMenuUtils","./library"],function(q,C,R,c,a,T,b,d,l){"use strict";var S=l.SelectionBehavior;var e=l.SelectionMode;var M=c.MessageType;var f=1;var g={DATACELL:1,COLUMNHEADER:2,ROWHEADER:4,ROWACTION:8,COLUMNROWHEADER:16};g.ANYCONTENTCELL=g.ROWHEADER|g.DATACELL|g.ROWACTION;g.ANYCOLUMNHEADER=g.COLUMNHEADER|g.COLUMNROWHEADER;g.ANYROWHEADER=g.ROWHEADER|g.COLUMNROWHEADER;g.ANY=g.ANYCONTENTCELL|g.ANYCOLUMNHEADER;var h={Grouping:T,Column:b,Menu:d,CELLTYPE:g,DEFAULT_ROW_HEIGHT:{sapUiSizeCondensed:24+f,sapUiSizeCompact:32+f,sapUiSizeCozy:48+f,undefined:32+f},RowsUpdateReason:(function(){var u={};for(var p in a){u[p]=a[p];}u.Render="Render";u.VerticalScroll="VerticalScroll";u.FirstVisibleRowChange="FirstVisibleRowChange";u.Unbind="Unbind";u.Animation="Animation";u.Resize="Resize";u.Unknown="Unknown";return u;})(),hasRowHeader:function(t){return(t.getSelectionMode()!==e.None&&t.getSelectionBehavior()!==S.RowOnly)||T.isGroupMode(t);},hasSelectAll:function(t){var s=t!=null?t.getSelectionMode():e.None;return(s===e.Multi||s===e.MultiToggle)&&t.getEnableSelectAll();},hasRowHighlights:function(t){if(t==null){return false;}var r=t.getRowSettingsTemplate();if(r==null){return false;}var H=r.getHighlight();return r.isBound("highlight")||(H!=null&&H!==M.None);},getRowActionCount:function(t){var o=t.getRowActionTemplate();return o?o._getCount():0;},hasRowActions:function(t){var r=t.getRowActionTemplate();return r!=null&&(r.isBound("visible")||r.getVisible())&&h.getRowActionCount(t)>0;},isRowSelectionAllowed:function(t){return t.getSelectionMode()!==e.None&&(t.getSelectionBehavior()===S.Row||t.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(t){return t.getSelectionMode()!==e.None&&h.hasRowHeader(t);},areAllRowsSelected:function(t){if(t==null){return false;}var s=t._getSelectableRowCount();return s>0&&s===t._getSelectedIndicesCount();},isNoDataVisible:function(t){if(!t.getShowNoData()){return false;}return!h.hasData(t);},hasData:function(t){var B=t.getBinding("rows"),i=t._getTotalRowCount(),H=B?!!i:false;if(B&&B.providesGrandTotal){var j=B.providesGrandTotal()&&B.hasTotaledMeasures();H=(j&&i<2)||(!j&&i===0)?false:true;}return H;},isBusyIndicatorVisible:function(t){if(t==null||t.getDomRef()==null){return false;}return t.getDomRef().querySelector(".sapUiTableCnt > .sapUiLocalBusyIndicator")!=null;},hasPendingRequests:function(t){if(t==null){return false;}if(h.canUsePendingRequestsCounter(t)){return t._iPendingRequests>0;}else{return t._bPendingRequest;}},canUsePendingRequestsCounter:function(t){var B=t!=null?t.getBinding("rows"):null;if(h.isInstanceOf(B,"sap/ui/model/analytics/AnalyticalBinding")){return B.bUseBatchRequests;}else if(h.isInstanceOf(B,"sap/ui/model/TreeBinding")){return false;}return true;},isInstanceOf:function(o,t){if(!o||!t){return false;}var i=sap.ui.require(t);return!!(i&&(o instanceof i));},toggleRowSelection:function(t,r,s,D){if(t==null||t.getBinding("rows")==null||t.getSelectionMode()===e.None||r==null){return false;}function i(A){if(!t._isRowSelectable(A)){return false;}t._iSourceRowIndex=A;var j=true;if(D){j=D(A,s);}else{if(t.isIndexSelected(A)){if(s!=null&&s){return false;}t.removeSelectionInterval(A,A);}else{if(s!=null&&!s){return false;}t.addSelectionInterval(A,A);}}delete t._iSourceRowIndex;return j;}if(typeof r==="number"){if(r<0||r>=t._getTotalRowCount()){return false;}return i(r);}else{var $=q(r);var o=h.getCellInfo($[0]);var I=h.isRowSelectionAllowed(t);if(!h.Grouping.isInGroupingRow($[0])&&((o.isOfType(h.CELLTYPE.DATACELL|h.CELLTYPE.ROWACTION)&&I)||(o.isOfType(h.CELLTYPE.ROWHEADER)&&h.isRowSelectorSelectionAllowed(t)))){var A;if(o.isOfType(h.CELLTYPE.DATACELL)){A=t.getRows()[parseInt($.closest("tr",t.getDomRef()).attr("data-sap-ui-rowindex"),10)].getIndex();}else{A=t.getRows()[parseInt($.attr("data-sap-ui-rowindex"),10)].getIndex();}return i(A);}return false;}},getNoDataText:function(t){var n=t.getNoData();if(n instanceof C){return null;}else if(typeof n==="string"||t.getNoData()instanceof String){return n;}else{return t._oResBundle.getText("TBL_NO_DATA");}},getVisibleColumnCount:function(t){return t._getVisibleColumns().length;},getHeaderRowCount:function(t){if(t._iHeaderRowCount===undefined){if(!t.getColumnHeaderVisible()){t._iHeaderRowCount=0;}else{var H=1;var j=t.getColumns();for(var i=0;i<j.length;i++){if(j[i].shouldRender()){H=Math.max(H,j[i].getMultiLabels().length);}}t._iHeaderRowCount=H;}}return t._iHeaderRowCount;},isVariableRowHeightEnabled:function(t){return t._bVariableRowHeightEnabled&&t.getFixedRowCount()<=0&&t.getFixedBottomRowCount()<=0;},getTotalRowCount:function(t,i){var r=t._getTotalRowCount();if(i){r=Math.max(r,t.getVisibleRowCount());}return r;},getNonEmptyVisibleRowCount:function(t){return Math.min(t.getVisibleRowCount(),t._getTotalRowCount());},getFocusedItemInfo:function(t){var i=t._getItemNavigation();if(!i){return null;}return{cell:i.getFocusedIndex(),columnCount:i.iColumns,cellInRow:i.getFocusedIndex()%i.iColumns,row:Math.floor(i.getFocusedIndex()/i.iColumns),cellCount:i.getItemDomRefs().length,domRef:i.getFocusedDomRef()};},getRowIndexOfFocusedCell:function(t){var i=h.getFocusedItemInfo(t);return i.row-h.getHeaderRowCount(t);},isFixedColumn:function(t,i){return i<t.getFixedColumnCount();},hasFixedColumns:function(t){return t.getFixedColumnCount()>0;},focusItem:function(t,i,E){var I=t._getItemNavigation();if(I){I.focusItem(i,E);}},getCellInfo:function(o){var i;var $=q(o);var s;var j;var r;var k;var m;i={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null};if($.hasClass("sapUiTableTd")){s=$.data("sap-ui-colid");j=sap.ui.getCore().byId(s);i.type=h.CELLTYPE.DATACELL;i.rowIndex=parseInt($.parent().data("sap-ui-rowindex"),10);i.columnIndex=j.getIndex();i.columnSpan=1;}else if($.hasClass("sapUiTableCol")){r=/_([\d]+)/;s=$.attr("id");k=r.exec(s);m=k==null||k[1]==null?0:parseInt(k[1],10);i.type=h.CELLTYPE.COLUMNHEADER;i.rowIndex=m;i.columnIndex=parseInt($.data("sap-ui-colindex"),10);i.columnSpan=parseInt($.attr("colspan")||1,10);}else if($.hasClass("sapUiTableRowHdr")){i.type=h.CELLTYPE.ROWHEADER;i.rowIndex=parseInt($.data("sap-ui-rowindex"),10);i.columnIndex=-1;i.columnSpan=1;}else if($.hasClass("sapUiTableRowAction")){i.type=h.CELLTYPE.ROWACTION;i.rowIndex=parseInt($.data("sap-ui-rowindex"),10);i.columnIndex=-2;i.columnSpan=1;}else if($.hasClass("sapUiTableColRowHdr")){i.type=h.CELLTYPE.COLUMNROWHEADER;i.columnIndex=-1;i.columnSpan=1;}if(i.type!==0){i.cell=$;}i.isOfType=function(n){if(n==null){return false;}return(this.type&n)>0;};return i;},getRowColCell:function(t,r,j,I){var o=r>=0&&r<t.getRows().length?t.getRows()[r]:null;var k=I?t.getColumns():t._getVisibleColumns();var m=j>=0&&j<k.length?k[j]:null;var n=null;if(o&&m){if(I){if(m.shouldRender()){var v=t._getVisibleColumns();for(var i=0;i<v.length;i++){if(v[i]===m){n=o.getCells()[i];break;}}}}else{n=o.getCells()[j];}if(n&&n.data("sap-ui-colid")!=m.getId()){var p=o.getCells();for(var i=0;i<p.length;i++){if(p[i].data("sap-ui-colid")===m.getId()){n=p[i];break;}}}}return{row:o,column:m,cell:n};},getCell:function(t,E){if(t==null||E==null){return null;}var $=q(E);var j;var o=t.getDomRef();var k=[".sapUiTableTd",".sapUiTableCol",".sapUiTableRowHdr",".sapUiTableRowAction",".sapUiTableColRowHdr"];var s;for(var i=0;i<k.length;i++){s=k[i];j=$.closest(s,o);if(j.length>0){return j;}}return null;},getParentCell:function(t,E){var $=q(E);var i=h.getCell(t,E);if(i===null||i[0]===$[0]){return null;}else{return i;}},registerResizeHandler:function(t,i,H,r){var D;if(typeof i=="string"){D=t.getDomRef(i);}else{q.sap.log.error("sIdSuffix must be a string",t);return;}if(typeof H!=="function"){q.sap.log.error("fnHandler must be a function",t);return;}h.deregisterResizeHandler(t,i);if(!t._mResizeHandlerIds){t._mResizeHandlerIds={};}if(r&&D){D=D.parentNode;}if(D){t._mResizeHandlerIds[i]=R.register(D,H);}return t._mResizeHandlerIds[i];},deregisterResizeHandler:function(t,I){var j;if(!t._mResizeHandlerIds){return;}if(typeof I=="string"){j=[I];}else if(I===undefined){j=[];for(var k in t._mResizeHandlerIds){if(typeof k=="string"&&t._mResizeHandlerIds.hasOwnProperty(k)){j.push(k);}}}else if(q.isArray(I)){j=I;}for(var i=0;i<j.length;i++){var s=j[i];if(t._mResizeHandlerIds[s]){R.deregister(t._mResizeHandlerIds[s]);t._mResizeHandlerIds[s]=undefined;}}},isFirstScrollableRow:function(t,r){if(isNaN(r)){var $=q(r);r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"),10);}var F=t.getFixedRowCount()||0;return r==F;},isLastScrollableRow:function(t,r){if(isNaN(r)){var $=q(r);r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"),10);}var F=t.getFixedBottomRowCount()||0;return r==t.getVisibleRowCount()-F-1;},getContentDensity:function(o){var s;var j=["sapUiSizeCompact","sapUiSizeCondensed","sapUiSizeCozy"];var G=function(F,O){if(!O[F]){return;}for(var i=0;i<j.length;i++){if(O[F](j[i])){return j[i];}}};var D=o.$();if(D.length>0){s=G("hasClass",D);}else{s=G("hasStyleClass",o);}if(s){return s;}var p=null;var P=o.getParent();if(P){do{s=G("hasStyleClass",P);if(s){return s;}if(P.getDomRef){p=P.getDomRef();}else if(P.getRootNode){p=P.getRootNode();}if(!p&&P.getParent){P=P.getParent();}else{P=null;}}while(P&&!p);}D=q(p||document.body);s=G("hasClass",D.closest("."+j.join(",.")));return s;},sanitizeSelectionMode:function(t,s){if(s===e.Multi){s=e.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}return s;},isVariableWidth:function(w){return!w||w=="auto"||w.toString().match(/%$/);},getFirstFixedButtomRowIndex:function(t){var F=t.getFixedBottomRowCount();var B=t.getBinding("rows");var i=-1;if(B&&F>0){var v=t.getVisibleRowCount();var j=t.getFirstVisibleRow();var k=t._getTotalRowCount();if(k>=v){i=v-F;}else{var I=k-F-j;if(I>=0&&(j+I)<k){i=I;}}}return i;}};T.TableUtils=h;b.TableUtils=h;d.TableUtils=h;return h;},true);
sap.ui.predefine('sap/ui/table/TreeTable',['jquery.sap.global','./Table','sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./library','sap/ui/core/Element','./TableUtils'],function(q,T,C,a,l,E,b){"use strict";
var c=T.extend("sap.ui.table.TreeTable",{
metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false,deprecated:true},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},rootLevel:{type:"int",group:"Data",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},
renderer:"sap.ui.table.TableRenderer"
});
c.prototype.init=function(){T.prototype.init.apply(this,arguments);b.Grouping.setTreeMode(this);};
c.prototype.bindRows=function(B){B=T._getSanitizedBindingInfo(arguments);if(B!=null){if(B.parameters==null){B.parameters={};}B.parameters.rootLevel=this.getRootLevel();B.parameters.collapseRecursive=this.getCollapseRecursive();B.parameters.numberOfExpandedLevels=B.parameters.numberOfExpandedLevels||(this.getExpandFirstLevel()?1:0);}return T.prototype.bindRows.call(this,B);};
c.prototype._bindAggregation=function(n,B){T.prototype._bindAggregation.call(this,n,B);var o=this.getBinding("rows");if(n==="rows"&&o!=null){o.attachEvents({selectionChanged:this._onSelectionChanged.bind(this)});}};
c.prototype.setSelectionMode=function(s){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();s=b.sanitizeSelectionMode(this,s);this.setProperty("selectionMode",s);}else{T.prototype.setSelectionMode.call(this,s);}return this;};
c.prototype.setFixedRowCount=function(r){q.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");return this;};
c.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return true;}return E.prototype.isTreeBinding.apply(this,arguments);};
c.prototype.getBinding=function(n){n=n||"rows";var B=E.prototype.getBinding.call(this,n);if(B&&n==="rows"&&!B.getLength){if(b.isInstanceOf(B,"sap/ui/model/odata/ODataTreeBinding")){a(B,this);}else if(b.isInstanceOf(B,"sap/ui/model/odata/v2/ODataTreeBinding")){B.applyAdapterInterface();}else if(b.isInstanceOf(B,"sap/ui/model/ClientTreeBinding")){C.apply(B);}else{q.sap.log.error("Binding not supported by sap.ui.table.TreeTable");}}return B;};
c.prototype._getContexts=function(s,L,t){var B=this.getBinding("rows");if(B){return B.getNodes(s,L,t);}else{return[];}};
c.prototype._onGroupHeaderChanged=function(r,e){this.fireToggleOpenState({rowIndex:r,rowContext:this.getContextByIndex(r),expanded:e});};
c.prototype.expand=function(r){var B=this.getBinding("rows");if(B&&r>=0){B.expand(r);}return this;};
c.prototype.collapse=function(r){var B=this.getBinding("rows");if(B&&r>=0){B.collapse(r);}return this;};
c.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};
c.prototype.expandToLevel=function(L){var B=this.getBinding("rows");if(B&&B.expandToLevel){B.expandToLevel(L);}return this;};
c.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};
c.prototype.isIndexSelected=function(r){var B=this.getBinding("rows");if(B&&B.isIndexSelected){return B.isIndexSelected(r);}else{return T.prototype.isIndexSelected.call(this,r);}};
c.prototype.setSelectedIndex=function(r){if(r===-1){this.clearSelection();}var B=this.getBinding("rows");if(B&&B.findNode&&B.setNodeSelection){B.setSelectedIndex(r);}else{T.prototype.setSelectedIndex.call(this,r);}return this;};
c.prototype.getSelectedIndices=function(){var B=this.getBinding("rows");if(B&&B.findNode&&B.getSelectedIndices){return B.getSelectedIndices();}else{return T.prototype.getSelectedIndices.call(this);}};
c.prototype.setSelectionInterval=function(f,t){var s=this.getSelectionMode();if(s===l.SelectionMode.None){return this;}var B=this.getBinding("rows");if(B&&B.findNode&&B.setSelectionInterval){if(s===l.SelectionMode.Single){B.setSelectionInterval(f,f);}else{B.setSelectionInterval(f,t);}}else{T.prototype.setSelectionInterval.call(this,f,t);}return this;};
c.prototype.addSelectionInterval=function(f,t){var s=this.getSelectionMode();if(s===l.SelectionMode.None){return this;}var B=this.getBinding("rows");if(B&&B.findNode&&B.addSelectionInterval){if(s===l.SelectionMode.Single){B.setSelectionInterval(f,f);}else{B.addSelectionInterval(f,t);}}else{T.prototype.addSelectionInterval.call(this,f,t);}return this;};
c.prototype.removeSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.removeSelectionInterval){B.removeSelectionInterval(f,t);}else{T.prototype.removeSelectionInterval.call(this,f,t);}return this;};
c.prototype.selectAll=function(){if(!b.hasSelectAll(this)){return this;}var B=this.getBinding("rows");if(B&&B.selectAll){B.selectAll();}else{T.prototype.selectAll.call(this);}return this;};
c.prototype.getSelectedIndex=function(){var B=this.getBinding("rows");if(B&&B.findNode){return B.getSelectedIndex();}else{return T.prototype.getSelectedIndex.call(this);}};
c.prototype.clearSelection=function(){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}else{T.prototype.clearSelection.call(this);}return this;};
c.prototype.getContextByIndex=function(r){var B=this.getBinding("rows");if(B){return B.getContextByIndex(r);}};
c.prototype.setRootLevel=function(r){this.setFirstVisibleRow(0);var B=this.getBinding("rows");if(B){if(B.setRootLevel){B.setRootLevel(r);}}this.setProperty("rootLevel",r,true);return this;};
c.prototype.setCollapseRecursive=function(d){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(d);}}this.setProperty("collapseRecursive",!!d,true);return this;};
c.prototype._getSelectedIndicesCount=function(){var s;var B=this.getBinding("rows");if(B&&B.getSelectedNodesCount){return B.getSelectedNodesCount();}else{return T.prototype.getSelectedIndices.call(this);}return s;};
c.prototype.setUseGroupMode=function(g){this.setProperty("useGroupMode",!!g);if(!!g){b.Grouping.setGroupMode(this);}else{b.Grouping.setTreeMode(this);}return this;};
c.prototype.setEnableGrouping=function(){q.sap.log.warning("The property enableGrouping is not supported by the sap.ui.table.TreeTable control");return this;};
c.prototype.setGroupBy=function(){q.sap.log.warning("The groupBy association is not supported by the sap.ui.table.TreeTable control");return this;};
c.prototype.setUseFlatMode=function(f){f=!!f;if(f!=this._bFlatMode){this._bFlatMode=f;if(this.getDomRef()&&b.Grouping.isTreeMode(this)){this.invalidate();}}return this;};
return c;});
sap.ui.predefine('sap/ui/table/TreeTableRenderer',['sap/ui/table/TreeTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/library',['sap/ui/core/Core','sap/ui/model/TreeAutoExpandMode','sap/ui/core/library','sap/ui/unified/library'],function(C,T){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.table",version:"1.52.30",dependencies:["sap.ui.core","sap.ui.unified"],types:["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.SharedDomRef","sap.ui.table.TreeAutoExpandMode"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings"],extensions:{flChangeHandlers:{"sap.ui.table.Column":{"propertyChange":"default"},"sap.ui.table.Table":{"moveElements":"default"},"sap.ui.table.AnalyticalTable":{"moveElements":"default"}}}});var t=sap.ui.table;t.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};t.RowActionType={Custom:"Custom",Navigation:"Navigation",Delete:"Delete"};t.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};t.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};t.SortOrder={Ascending:"Ascending",Descending:"Descending"};t.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};t.SharedDomRef={HorizontalScrollBar:"hsb",VerticalScrollBar:"vsb"};t.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};t.ColumnHeader=t.Column;t.TreeAutoExpandMode=T;if(!t.TableHelper){t.TableHelper={addTableClass:function(){return"";},createLabel:function(c){throw new Error("no Label control available!");},createTextView:function(c){throw new Error("no TextView control available!");},bFinal:false};}return t;});
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/table/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/table/manifest.json":'{\n  "_version": "1.9.0",\n  "sap.app": {\n    "id": "sap.ui.table",\n    "type": "library",\n    "embeds": [],\n    "applicationVersion": {\n      "version": "1.52.30"\n    },\n    "title": "Table-like controls, mainly for desktop scenarios.",\n    "description": "Table-like controls, mainly for desktop scenarios.",\n    "ach": "CA-UI5-TBL",\n    "resources": "resources.json",\n    "offline": true\n  },\n  "sap.ui": {\n    "technology": "UI5",\n    "supportedThemes": [\n      "base",\n      "sap_hcb"\n    ]\n  },\n  "sap.ui5": {\n    "dependencies": {\n      "minUI5Version": "1.52",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.52.30"\n        },\n        "sap.ui.unified": {\n          "minVersion": "1.52.30"\n        }\n      }\n    },\n    "library": {\n      "i18n": "messagebundle.properties",\n      "content": {\n        "controls": [\n          "sap.ui.table.AnalyticalColumnMenu",\n          "sap.ui.table.AnalyticalTable",\n          "sap.ui.table.ColumnMenu",\n          "sap.ui.table.Table",\n          "sap.ui.table.TreeTable",\n          "sap.ui.table.RowAction"\n        ],\n        "elements": [\n          "sap.ui.table.AnalyticalColumn",\n          "sap.ui.table.Column",\n          "sap.ui.table.Row",\n          "sap.ui.table.RowActionItem",\n          "sap.ui.table.RowSettings"\n        ],\n        "types": [\n          "sap.ui.table.NavigationMode",\n          "sap.ui.table.RowActionType",\n          "sap.ui.table.SelectionBehavior",\n          "sap.ui.table.SelectionMode",\n          "sap.ui.table.SortOrder",\n          "sap.ui.table.VisibleRowCountMode",\n          "sap.ui.table.SharedDomRef",\n          "sap.ui.table.TreeAutoExpandMode"\n        ],\n        "interfaces": []\n      }\n    }\n  }\n}'
}});
//# sourceMappingURL=library-preload.js.map