/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale'],function(q,C,D,L,a,U,l,I,b,R,c){"use strict";var d=l.CalendarDayType;var e=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var f=l.CalendarIntervalType;var g=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:f.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:e.Standard}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"},_nonWorkingDates:{type:"sap.ui.unified.DateRange",multiple:true,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});g.PCROW_FOREIGN_KEY_NAME="relatedToPCRowDateRange";g.AGGR_NONWORKING_DATES_NAME="_nonWorkingDates";g.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");if(!g._oStaticAppointmentText){g._oStaticAppointmentText=new I({text:this._oRb.getText("APPOINTMENT")});g._oStaticAppointmentText.toStatic();g._oStaticTentativeText=new I({text:this._oRb.getText("APPOINTMENT_TENTATIVE")});g._oStaticTentativeText.toStatic();}if(!g._oStaticSelectedText){g._oStaticSelectedText=new I({text:this._oRb.getText("APPOINTMENT_SELECTED")});g._oStaticSelectedText.toStatic();}this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);};g.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};g.prototype.onBeforeRendering=function(){m.call(this);p.call(this);u.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};g.prototype.onAfterRendering=function(){v.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};g.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};g.prototype.invalidate=function(O){if(O&&O instanceof sap.ui.unified.CalendarAppointment){var F=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==O){F=true;break;}}if(F){this._aVisibleAppointments=[];}}C.prototype.invalidate.apply(this,arguments);};g.prototype.setStartDate=function(S){if(!S){S=new Date();}a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};g.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};g.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};g.prototype.setGroupAppointmentsMode=function(i){this.setProperty("groupAppointmentsMode",i);this._aVisibleAppointments=[];return this;};g.prototype.setAppointmentsReducedHeight=function(i){this.setProperty("appointmentsReducedHeight",i);this._aVisibleAppointments=[];return this;};g.prototype._getAppointmentReducedHeight=function(i){var j=false;if(!D.system.phone&&this.getAppointmentsReducedHeight()&&!i.getText()){j=true;}return j;};g.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){z.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var F=false;var k;for(var i=0;i<V.length;i++){k=V[i].appointment;if(q.sap.containsOrEquals(k.getDomRef(),j.target)){F=true;k.focus();break;}}if(!F){k=this.getFocusedAppointment();if(k){k.focus();}}}};g.prototype.applyFocusInfo=function(F){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};g.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){A.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};g.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){A.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};g.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};g.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};g.prototype.onsaphome=function(i){B.call(this,i);i.preventDefault();i.stopPropagation();};g.prototype.onsapend=function(i){B.call(this,i);i.preventDefault();i.stopPropagation();};g.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(q.sap.containsOrEquals(k.getDomRef(),j.target)){w.call(this,k,!j.ctrlKey);break;}}j.stopPropagation();j.preventDefault();};g.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var F=false;for(k=0;k<j.length;k++){var H=j[k];if(!this._isOneMonthIntervalOnSmallSizes()&&q.sap.containsOrEquals(H,i.target)){F=true;break;}}if(F){E.call(this,k,i.target);}else{this.onsapselect(i);}};g.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};g.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");v.call(this);return this;};g.prototype.updateCurrentTimeVisualization=function(){var N=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var S=this._getStartDate();var F=S.getTime();var H=this._oUTCEndDate;var J=H.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=J&&i.getTime()>=F){var K=s.call(this,k,j,S,H,F,i);var T=0;if(this._bRTL){N.css("right",K+"%");}else{N.css("left",K+"%");}N.css("display","");if(this.getUpdateCurrentTime()){switch(k){case f.Hour:T=60000;break;case f.Day:case f.Week:case f.OneMonth:T=1800000;break;default:T=-1;break;}if(T>0){this._sUpdateCurrentTime=q.sap.delayedCall(T,this,this.updateCurrentTimeVisualization);}}}else{N.css("display","none");}return this;};g.prototype.getFocusedAppointment=function(){var j=x.call(this);var k=this.getAggregation("groupAppointments",[]);var F;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){F=k[i];break;}}if(!F){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){F=j[i];break;}}}return F;};g.prototype.focusAppointment=function(i){if(!i||!(i instanceof sap.ui.unified.CalendarAppointment)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){z.call(this,j);}else{i.focus();}return this;};g.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=x.call(this);var N;var P;var F;for(var i=0;i<k.length;i++){N=k[i];if(N.getStartDate()>j){if(i>0){P=k[i-1];}else{P=N;}break;}}if(N){if(P&&Math.abs(N.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){F=P;}else{F=N;}this.focusAppointment(F);}return this;};g.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};g.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};g.prototype._getNonWorkingDays=function(){var N=this.getNonWorkingDays();if(!N){var j=h.call(this);var W=j.getWeekendStart();var k=j.getWeekendEnd();N=[];for(var i=0;i<=6;i++){if((W<=k&&i>=W&&i<=k)||(W>k&&(i>=W||i<=k))){N.push(i);}}}else if(!q.isArray(N)){N=[];}return N;};g.prototype._isOneMonthIntervalOnSmallSizes=function(){return this.getIntervalType()===f.OneMonth&&this.getIntervals()===1;};function _(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}function h(){if(!this._oLocaleData){var i=_.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}function m(){var S=this.getStartDate();var i;var j=this.getIntervals();var k=this.getIntervalType();this._oUTCStartDate=n.call(this,S);switch(k){case f.Hour:i=new U(this._oUTCStartDate.getTime());i.setUTCHours(i.getUTCHours()+j);this._iMinDelta=this._iHoursMinDelta;break;case f.Day:case f.Week:case f.OneMonth:i=new U(this._oUTCStartDate.getTime());i.setUTCDate(i.getUTCDate()+j);this._iMinDelta=this._iDaysMinDelta;break;case f.Month:i=new U(this._oUTCStartDate.getTime());i.setUTCMonth(i.getUTCMonth()+j);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}i.setUTCMilliseconds(-1);this._iRowSize=i.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/j);this._oUTCEndDate=i;}function n(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case f.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case f.Day:case f.Week:case f.OneMonth:k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case f.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}function o(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}function p(){var O=this._aVisibleAppointments||[];var F=x.call(this);var H;var J;var K;var M=this.getIntervals();var N=this.getIntervalType();var S=this._getStartDate();var P=S.getTime();var Q=this._oUTCEndDate;var T=Q.getTime();var V=[];var W=false;var i=0;var j=0;var X=o.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<F.length;i++){H=F[i];var Y=a._createUniversalUTCDate(H.getStartDate(),undefined,true);Y.setUTCSeconds(0);Y.setUTCMilliseconds(0);var Z=H.getEndDate()?a._createUniversalUTCDate(H.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);Z.setUTCSeconds(0);Z.setUTCMilliseconds(0);var $=false;if(Y.getTime()<P&&Z.getTime()>=P){Y=new U(P);$=true;}if(Z.getTime()>T&&Y.getTime()<=T){Z=new U(T);$=true;}var a1=Y.getUTCHours()*60+Y.getUTCMinutes();Y.setUTCMinutes(Y.getUTCMinutes()-(a1%this._iMinDelta));var b1=(Z.getTime()-Y.getTime())/60000;if($&&b1==0){continue;}var c1=0;var d1=0;var e1=-1;J=undefined;K=undefined;if(Y&&Y.getTime()<=T&&Z&&Z.getTime()>=P){if(X&&(N==f.Month)&&((Z.getTime()-Y.getTime())<604800000)){J=r.call(this,Y,H,N,M,S,Q,P,V);var f1=a._createUniversalUTCDate(J.getEndDate(),undefined,true);if(Z.getTime()>f1.getTime()){K=r.call(this,Z,H,N,M,S,Q,P,V);}}c1=s.call(this,N,M,S,Q,P,Y);d1=t.call(this,N,M,S,Q,P,Z);for(j=0;j<O.length;j++){var g1=O[j];if(H==g1.appointment){e1=g1.level;}}if(J){J._iBegin=c1;J._iEnd=d1;J._iLevel=e1;if(K){K._iBegin=c1;K._iEnd=d1;K._iLevel=e1;}continue;}V.push({appointment:H,begin:c1,end:d1,calculatedEnd:d1,level:e1});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==H.getId()){W=true;}}}var h1=this.getAggregation("groupAppointments",[]);if(h1.length>0){for(i=0;i<V.length;i++){H=V[i];if(H.appointment._aAppointments&&H.appointment._aAppointments.length<=1){J=H.appointment;var i1=false;if(J._aAppointments.length==0){i1=true;}else{for(j=0;j<V.length;j++){if(V[j].appointment==J._aAppointments[0]){i1=true;break;}}}if(!i1){for(j=0;j<h1.length;j++){K=h1[j];if(J!=K){for(var k=0;k<K._aAppointments.length;k++){if(J._aAppointments[0]==K._aAppointments[k]){K._aAppointments.splice(k,1);if(K._aAppointments.length==1){this.removeAggregation("groupAppointments",K);K.destroy();h1=this.getAggregation("groupAppointments",[]);}else{K.setProperty("title",K._aAppointments.length,true);}break;}}}}H.begin=J._iBegin;H.end=J._iEnd;H.calculatedEnd=J._iEnd;H.level=J._iLevel;H.appointment=J._aAppointments[0];}else{V.splice(i,1);i--;}this.removeAggregation("groupAppointments",J);J.destroy();h1=this.getAggregation("groupAppointments",[]);}}}if(!W){if(V.length>0){this._sFocusedAppointmentId=V[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=V;return this._aVisibleAppointments;}function r(i,k,F,H,S,J,K,V){var M=this.getAggregation("groupAppointments",[]);var N;var O=h.call(this);var P=O.getFirstDayOfWeek();var Q=i.getUTCDay();var T=new U(i.getTime());T.setUTCHours(0);T.setUTCMinutes(0);T.setUTCSeconds(0);T.setUTCMilliseconds(0);if(P<=Q){T.setDate(T.getDate()-(Q-P));}else{T.setDate(T.getDate()-(7-Q-P));}for(var j=0;j<M.length;j++){N=M[j];var W=a._createUniversalUTCDate(N.getStartDate(),undefined,true);if(W.getTime()==T.getTime()){break;}N=undefined;}if(!N){var X=new U(T.getTime());X.setDate(X.getDate()+7);X.setMilliseconds(-1);N=new sap.ui.unified.CalendarAppointment(this.getId()+"-Group"+M.length,{type:k.getType(),startDate:a._createLocalDate(new Date(T.getTime()),true),endDate:a._createLocalDate(new Date(X.getTime()),true)});N._aAppointments=[];this.addAggregation("groupAppointments",N,true);var Y=s.call(this,F,H,S,J,K,T);var Z=t.call(this,F,H,S,J,K,X);V.push({appointment:N,begin:Y,end:Z,calculatedEnd:Z,level:-1});}N._aAppointments.push(k);if(N.getType()!=d.None&&N.getType()!=k.getType()){N.setType(d.None);}N.setProperty("title",N._aAppointments.length,true);return N;}function s(i,j,S,k,F,H){var J=0;if(i!=f.Month){J=100*(H.getTime()-F)/this._iRowSize;}else{var M=new U(H.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var K=new U(M.getTime());K.setUTCMonth(K.getUTCMonth()+1);K.setMilliseconds(-1);var N=K.getTime()-M.getTime();var O=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();J=(100*O/j)+(100*(H.getTime()-M.getTime())/N)/j;}if(J<0){J=0;}J=Math.round(J*100000)/100000;return J;}function t(i,j,S,k,F,H){var J=0;if(i!=f.Month){J=100-(100*(H.getTime()-F)/this._iRowSize);}else{var M=new U(H.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var K=new U(M.getTime());K.setUTCMonth(K.getUTCMonth()+1);K.setMilliseconds(-1);var N=K.getTime()-M.getTime();var O=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();J=100-((100*O/j)+(100*(H.getTime()-M.getTime())/N)/j);}if(J<0){J=0;}J=Math.round(J*100000)/100000;return J;}function u(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var F;var H=this.getIntervals();var J=this.getIntervalType();var S=this._getStartDate();var K=S.getTime();var M=this._oUTCEndDate;var N=M.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){F=k[i];var O=a._createUniversalUTCDate(F.getStartDate(),undefined,true);O.setUTCSeconds(0);O.setUTCMilliseconds(0);var P=F.getEndDate()?a._createUniversalUTCDate(F.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);P.setUTCSeconds(0);P.setUTCMilliseconds(0);if(O&&O.getTime()<=N&&P&&P.getTime()>=K){var Q=new U(S.getTime());var T=new U(S.getTime());T.setUTCMinutes(T.getUTCMinutes()-1);var W=-1;var X=-1;for(j=0;j<H;j++){switch(J){case f.Hour:T.setUTCHours(T.getUTCHours()+1);if(j>0){Q.setUTCHours(Q.getUTCHours()+1);}break;case f.Day:case f.Week:case f.OneMonth:T.setUTCDate(T.getUTCDate()+1);if(j>0){Q.setUTCDate(Q.getUTCDate()+1);}break;case f.Month:T.setUTCDate(1);T.setUTCMonth(T.getUTCMonth()+2);T.setUTCDate(0);if(j>0){Q.setUTCMonth(Q.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+J+"; "+this);}if(O&&O.getTime()<=Q.getTime()&&P&&P.getTime()>=T.getTime()){if(W<0){W=j;}X=j;}}if(W>=0){V.push({interval:W,appointment:F,last:X});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}function v(){if(this._isOneMonthIntervalOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var F=this.$("DummyApp");var H=F.outerHeight(true);if(H<=0){return;}var M=F.outerWidth();var J=M/k*100;var K=Math.ceil(1000*J)/1000;var N;var O;var S=0;var P=0;var i=0;var Q=!D.system.phone&&this.getAppointmentsReducedHeight();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){S=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){N=this._aVisibleAppointments[i];O=N.appointment.$();var T=Math.floor(1000*(100-N.calculatedEnd-N.begin))/1000;var V=false;if(T<K){N.end=100-N.begin-J;if(N.end<0){N.end=0;}N.level=-1;V=true;O.addClass("sapUiCalendarAppSmall");}else if(O.hasClass("sapUiCalendarAppSmall")){N.end=N.calculatedEnd;V=true;O.removeClass("sapUiCalendarAppSmall");}if(V){if(this._bRTL){O.css("left",N.end+"%");}else{O.css("right",N.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){N=this._aVisibleAppointments[i];O=N.appointment.$();var W={};var X=Q&&!this._getAppointmentReducedHeight(N.appointment);if(N.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var Y=this._aVisibleAppointments[j];if(N!=Y&&N.begin<(Math.floor(1000*(100-Y.end))/1000)&&(Math.floor(1000*(100-N.end))/1000)>Y.begin&&Y.level>=0){if(W[Y.level]){W[Y.level]++;}else{W[Y.level]=1;}if(Q&&!this._getAppointmentReducedHeight(Y.appointment)){if(W[Y.level+1]){W[Y.level+1]++;}else{W[Y.level+1]=1;}}}}N.level=0;while(W[N.level]||(X&&W[N.level+1])){N.level++;}O.attr("data-sap-level",N.level);}O.css("top",(H*N.level+S)+"px");var Z=N.level;if(X){Z++;}if(P<Z){P=Z;}}P++;H=H*P+S;if(!this.getHeight()){$.outerHeight(H);}else{var a1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<a1.length;i++){var b1=q(a1[i]);b1.outerHeight(H);}}F.css("display","none");}function w(j,k){var i=0;var O;var F;var H;var J;var S=g._oStaticSelectedText.getId();if(k){var K=this.getAppointments();var M=this.getAggregation("groupAppointments",[]);q.merge(K,M);for(i=0;i<K.length;i++){O=K[i];if(O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");F=O.$().attr("aria-labelledby");H=F?F.replace(S,""):"";O.$().attr("aria-labelledby",H);}}}j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");J=j.$().attr("aria-labelledby")+" "+S;j.$().attr("aria-labelledby",J);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){O=j._aAppointments[i];O.setProperty("selected",true,true);J=O.$().attr("aria-labelledby")+" "+S;O.$().attr("aria-labelledby",J);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}function x(){var i=this.getAppointments();i.sort(function(j,k){var F=j.getStartDate()-k.getStartDate();if(F==0){F=k.getEndDate()-j.getEndDate();}return F;});return i;}function y(k){var F=this.getAggregation("groupAppointments",[]);var H;var J=false;for(var i=0;i<F.length;i++){var K=F[i]._aAppointments;for(var j=0;j<K.length;j++){if(K[j].getId()==k){H=F[i];J=true;break;}}if(J){break;}}return H;}function z(j){if(this._sFocusedAppointmentId!=j){var k=x.call(this);var V=this._aVisibleAppointments;var F;var i=0;F=y.call(this,j);if(F){j=F.getId();F=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){F=V[i].appointment;break;}}if(F){var O=this.getFocusedAppointment().$();var $=F.$();this._sFocusedAppointmentId=F.getId();O.attr("tabindex","-1");$.attr("tabindex","0");$.focus();}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){F=k[i];break;}}if(F){this._sFocusedAppointmentId=F.getId();var H=n.call(this,F.getStartDate());this.setStartDate(a._createLocalDate(H,true));if(!q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){q.sap.delayedCall(0,this,function(){this.getFocusedAppointment().focus();});}this.fireStartDateChange();}}}}function A(F,S){var j=this._sFocusedAppointmentId;var k=x.call(this);var H=this.getAggregation("groupAppointments",[]);var J;var K=0;var i=0;for(i=0;i<H.length;i++){if(H[i].getId()==j){var M=H[i]._aAppointments;if(F){j=M[M.length-1].getId();}else{j=M[0].getId();}break;}}for(i=0;i<k.length;i++){if(k[i].getId()==j){K=i;break;}}if(F){K=K+S;}else{K=K-S;}if(K<0){K=0;}else if(K>=k.length){K=k.length-1;}J=k[K];z.call(this,J.getId());}function B(j){var k=x.call(this);var F;var S=new U(this._getStartDate());var H=new U(this._oUTCEndDate);var J=this.getIntervalType();var K;var M;S.setUTCHours(0);H.setUTCHours(0);H.setUTCMinutes(0);H.setUTCSeconds(0);switch(J){case f.Hour:H.setUTCDate(H.getUTCDate()+1);H.setUTCMilliseconds(-1);break;case f.Day:case f.Week:case f.OneMonth:S.setUTCDate(1);H.setUTCMonth(H.getUTCMonth()+1);H.setUTCDate(1);H.setUTCMilliseconds(-1);break;case f.Month:S.setUTCMonth(0);S.setUTCDate(1);H.setUTCFullYear(H.getUTCFullYear()+1);H.setUTCMonth(1);H.setUTCDate(1);H.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+J+"; "+this);}var N=a._createLocalDate(S,true);var O=a._createLocalDate(H,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=N&&k[i].getStartDate()<=O){F=k[i];K=F.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>O){break;}}M=y.call(this,K);if(M){F=M;K=F.getId();}if(K&&K!=this._sFocusedAppointmentId){z.call(this,K);}else if(j._bPlanningCalendar&&F){F.focus();}else{this.fireLeaveRow({type:j.type});}}function E(i,j){var k=this.getIntervalType();var S=this._getStartDate();var F=new U(S.getTime());var H;var J=false;var K=0;var M=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){J=true;var N=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");M=N.length;for(K=0;K<M;K++){var O=N[K];if(O==j){break;}}}switch(k){case f.Hour:F.setUTCHours(F.getUTCHours()+i);if(J){F.setUTCMinutes(F.getUTCMinutes()+K*60/M);H=new U(F.getTime());H.setUTCMinutes(H.getUTCMinutes()+60/M);}else{H=new U(F.getTime());H.setUTCHours(H.getUTCHours()+1);}break;case f.Day:case f.Week:case f.OneMonth:F.setUTCDate(F.getUTCDate()+i);if(J){F.setUTCHours(F.getUTCHours()+K*24/M);H=new U(F.getTime());H.setUTCHours(H.getUTCHours()+24/M);}else{H=new U(F.getTime());H.setUTCDate(H.getUTCDate()+1);}break;case f.Month:F.setUTCMonth(F.getUTCMonth()+i);if(J){F.setUTCDate(F.getUTCDate()+K);H=new U(F.getTime());H.setUTCDate(H.getUTCDate()+1);}else{H=new U(F.getTime());H.setUTCMonth(H.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}H.setUTCMilliseconds(H.getUTCMilliseconds()-1);F=a._createLocalDate(F,true);H=a._createLocalDate(H,true);this.fireIntervalSelect({startDate:F,endDate:H,subInterval:J});}return g;});
