/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale'],function(q,C,L,I,a,U,l,D,c,b){"use strict";var d=c.CalendarType;var T=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});T.prototype.init=function(){this._oFormatYyyyMMddHHmm=D.getInstance({pattern:"yyyyMMddHHmm",calendarType:d.Gregorian});this._oFormatLong=D.getDateTimeInstance({style:"long/short"});this._oFormatDate=D.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};T.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateTimes){q.sap.clearDelayedCall(this._sInvalidateTimes);}};T.prototype.onAfterRendering=function(){_.call(this);};T.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){v.call(this,true);o.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;s.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}}};T.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateTimes){if(this._bInvalidateSync){t.call(this);}else{this._sInvalidateTimes=q.sap.delayedCall(0,this,t);}}};T.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};T.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};T.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};T.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};T.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};T.prototype.setDate=function(i){j.call(this,i,false);return this;};T.prototype._setDate=function(i){var w=a._createLocalDate(i,true);this.setProperty("date",w,true);this._oUTCDate=i;};T.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};T.prototype.setStartDate=function(S){a._checkJSDateObject(S);var y=S.getFullYear();a._checkYearInValidRange(y);var i=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S,true);this._oUTCStartDate=this._getIntervalStart(i);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};T.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};T.prototype.displayDate=function(i){j.call(this,i,true);return this;};T.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};T.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var w=new b(i);this._oLocaleData=L.getInstance(w);}return this._oLocaleData;};T.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var w=new b(i);this._oFormatLong=D.getInstance({style:"long/short"},w);}return this._oFormatLong;};T.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var w=new b(i);var x=this.getIntervalMinutes();var y=this._getLocaleData();var P;this._oFormatTimeAmPm=undefined;if(x%60==0){P=y.getPreferredHourSymbol();if(y.getTimePattern("short").search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},w);}}else{P=y.getTimePattern("short");P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},w);P=P.replace("a","").trim();}}this._oFormatTime=D.getTimeInstance({pattern:P},w);}return this._oFormatTime;};T.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var w=new b(i);this._oFormatDate=D.getDateInstance({style:"medium"},w);}return this._oFormatDate;};T.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};T.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};T.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};T.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};T.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};T.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};T.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};T.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};T.prototype._checkDateSelected=function(w){if(!(w instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var x=this.getSelectedDates();var M=new U(w.getTime());M=this._getIntervalStart(M);var y=M.getTime();for(var i=0;i<x.length;i++){var R=x[i];var z=R.getStartDate();var A=0;if(z){z=a._createUniversalUTCDate(z,undefined,true);z=this._getIntervalStart(z);A=z.getTime();}var E=R.getEndDate();var B=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);B=E.getTime();}if(y==A&&!E){S=1;break;}else if(y==A&&E){S=2;if(E&&y==B){S=5;}break;}else if(E&&y==B){S=3;break;}else if(E&&y>A&&y<B){S=4;break;}if(this.getSingleSelection()){break;}}return S;};T.prototype._getDateType=function(w){if(!(w instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var x;var S=this.getSpecialDates();var M=new U(w.getTime());M=this._getIntervalStart(M);var y=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var z=R.getStartDate();var A=0;if(z){z=a._createUniversalUTCDate(z,undefined,true);z=this._getIntervalStart(z);A=z.getTime();}var E=R.getEndDate();var B=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);E.setUTCMinutes(E.getUTCMinutes()+this.getIntervalMinutes()-1);B=E.getTime();}else if(z.getUTCHours()==0&&z.getUTCMinutes()==0&&z.getUTCSeconds()==0&&z.getUTCMilliseconds()==0){E=new U(z.getTime());E.setUTCDate(E.getUTCDate()+1);B=E.getTime();}if((y==A&&!E)||(y>=A&&y<=B)){x={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return x;};T.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var w=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(w<P._oMinDate.getTime()||w>P._oMaxDate.getTime()){return false;}}return true;};T.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){v.call(this,true);}var $=q(E.target);if($.hasClass("sapUiCalItemText")){$=$.parent();}if($.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._setDate(F);o.call(this,F,true);this._bMoveChange=true;}}};T.prototype.onmouseup=function(E){if(this._bMouseMove){v.call(this,true);var F=this._getDate();var w=this._oItemNavigation.getItemDomRefs();for(var i=0;i<w.length;i++){var $=q(w[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var x=q(E.target);if(x.hasClass("sapUiCalItemText")){x=x.parent();}if(x.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(x.attr("data-sap-time"),true).getTime());}o.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;s.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}};T.prototype.onsapselect=function(E){var S=o.call(this,this._getDate());if(S){s.call(this);}E.stopPropagation();E.preventDefault();};T.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};T.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};T.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};T.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var w=a._createUniversalUTCDate(i,undefined,true);if(w.getTime()>=S.getTime()&&w.getTime()<E.getTime()){return true;}else{return false;}};T.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};T.prototype._getIntervalStart=function(i){var w=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=w){S.setUTCMinutes(S.getUTCMinutes()+M);}var x=new U(S.getTime());x.setUTCMinutes(x.getUTCMinutes()-M);return x;};function _(){var w=this._getDate();var y=this._oFormatYyyyMMddHHmm.format(w.getJSDate(),true);var x=0;var R=this.$("times").get(0);var z=this.$("times").children(".sapUiCalItem");for(var i=0;i<z.length;i++){var $=q(z[i]);if($.attr("data-sap-time")===y){x=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,e,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,f,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,g,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(z);this._oItemNavigation.setFocusedIndex(x);this._oItemNavigation.setPageSize(z.length);}function e(i){var w=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var x=this._oItemNavigation.getItemDomRefs();var $=q(x[w]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._setDate(F);this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){h.call(this,E,F,w);}}function f(i){var w=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();h.call(this,E,F,w);}}function g(i){var E=i.getParameter("event");var w=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*w);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*w);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}function h(E,F,i){if(E.button){return;}var S=o.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){v.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){u.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}function j(i,N){a._checkJSDateObject(i);var y=i.getFullYear();a._checkYearInValidRange(y);var F=true;if(!q.sap.equal(this.getDate(),i)){var w=a._createUniversalUTCDate(i,undefined,true);w=this._getIntervalStart(w);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i,true);this._oUTCDate=w;}if(this.getDomRef()){if(F){k.call(this,this._oUTCDate,N);}else{m.call(this,N);}}}function k(w,N){var y=this._oFormatYyyyMMddHHmm.format(w.getJSDate(),true);var x=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<x.length;i++){$=q(x[i]);if($.attr("data-sap-time")==y){if(document.activeElement!=x[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}function m(N){var i=this._getStartDate();var $=this.$("times");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderTimes(R,this,i);R.flush($[0]);R.destroy();}n.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}function n(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var i=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,i,S);R.flush($[0]);R.destroy();}}}function o(w,M){if(!this._checkTimeEnabled(w)){return false;}var S=this.getSelectedDates();var x;var y=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var A=this;var z;if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){x=S[0];z=x.getStartDate();if(z){z=a._createUniversalUTCDate(z,undefined,true);z=this._getIntervalStart(z);}}else{x=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",x,true);}if(this.getIntervalSelection()&&(!x.getEndDate()||M)&&z){var E;if(w.getTime()<z.getTime()){E=z;z=w;if(!M){x.setProperty("startDate",a._createLocalDate(new Date(z.getTime()),true),true);x.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true),true);}}else if(w.getTime()>=z.getTime()){E=w;if(!M){x.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true),true);}}p.call(this,z,E);}else{p.call(this,w);x.setProperty("startDate",a._createLocalDate(new Date(w.getTime()),true),true);x.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var B=this._checkDateSelected(w);if(B>0){for(i=0;i<S.length;i++){z=S[i].getStartDate();if(z){z=a._createUniversalUTCDate(z,undefined,true);z=this._getIntervalStart(z);if(w.getTime()==z.getTime()){A.removeAggregation("selectedDates",i,true);break;}}}}else{x=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(w.getTime()),true)});A.addAggregation("selectedDates",x,true);}Y=this._oFormatYyyyMMddHHmm.format(w.getJSDate(),true);for(i=0;i<y.length;i++){$=q(y[i]);if($.attr("data-sap-time")==Y){if(B>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}function p(S,E){var w=this._oItemNavigation.getItemDomRefs();var $;var i=0;var x=false;var y=false;if(!E){var Y=this._oFormatYyyyMMddHHmm.format(S.getJSDate(),true);for(i=0;i<w.length;i++){$=q(w[i]);x=false;y=false;if($.attr("data-sap-time")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");x=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}r.call(this,$,x,y);}}else{var z;for(i=0;i<w.length;i++){$=q(w[i]);x=false;y=false;z=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(z.getTime()==S.getTime()){$.addClass("sapUiCalItemSelStart");x=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&z.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");y=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&z.getTime()>S.getTime()&&z.getTime()<E.getTime()){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&z.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");y=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}r.call(this,$,x,y);}}}function r($,S,E){if(!this.getIntervalSelection()){return;}var w="";var x=[];var y=this.getId();var z=false;w=$.attr("aria-describedby");if(w){x=w.split(" ");}var A=-1;var B=-1;for(var i=0;i<x.length;i++){var F=x[i];if(F==(y+"-Start")){A=i;}if(F==(y+"-End")){B=i;}}if(A>=0&&!S){x.splice(A,1);z=true;if(B>A){B--;}}if(B>=0&&!E){x.splice(B,1);z=true;}if(A<0&&S){x.push(y+"-Start");z=true;}if(B<0&&E){x.push(y+"-End");z=true;}if(z){w=x.join(" ");$.attr("aria-describedby",w);}}function s(){if(this._bMouseMove){v.call(this,true);}this.fireSelect();}function t(){this._sInvalidateTimes=undefined;m.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}function u(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}function v(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}return T;});
