/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','jquery.sap.keycodes'],function(q,C,D,I,a,b,U,l,c,d){"use strict";var e=d.CalendarType;var Y=C.extend("sap.ui.unified.calendar.YearPicker",{metadata:{library:"sap.ui.unified",properties:{year:{type:"int",group:"Data",defaultValue:2000},years:{type:"int",group:"Appearance",defaultValue:20},columns:{type:"int",group:"Appearance",defaultValue:4},date:{type:"object",group:"Data"},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},events:{select:{},pageChange:{}}}});Y.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._oYearFormat=c.getDateInstance({format:"y",calendarType:s});this._oFormatYyyymmdd=c.getInstance({pattern:"yyyyMMdd",calendarType:e.Gregorian});this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());};Y.prototype.onAfterRendering=function(){_.call(this);};Y.prototype.setYear=function(y){this.setProperty("year",y,true);y=this.getProperty("year");var o=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());o.setDate(1);o.setMonth(0);o.setYear(y);this.setDate(o.toLocalJSDate());return this;};Y.prototype.setDate=function(o){var i,y,p,F;o&&a._checkJSDateObject(o);y=o.getFullYear();a._checkYearInValidRange(y);i=b.fromLocalJSDate(o,this.getPrimaryCalendarType());i.setMonth(0);i.setDate(1);this.setProperty("date",o,true);this.setProperty("year",i.getYear(),true);this._oDate=i;if(this.getDomRef()){p=this.getYears();F=new b(this._oDate,this.getPrimaryCalendarType());F.setYear(F.getYear()-Math.floor(p/2));n.call(this,F,Math.floor(p/2));}return this;};Y.prototype._getDate=function(){if(!this._oDate){var y=this.getYear();this._oDate=new b(y,0,1,this.getPrimaryCalendarType());}return this._oDate;};Y.prototype.setPrimaryCalendarType=function(s){this.setProperty("primaryCalendarType",s);this._oYearFormat=c.getDateInstance({format:"y",calendarType:s});if(this._oDate){this._oDate=new b(this._oDate,s);this._oDate.setMonth(0);this._oDate.setDate(1);}this._oMinDate=new b(this._oMinDate,s);this._oMaxDate=new b(this._oMaxDate,s);return this;};Y.prototype.nextPage=function(){m.call(this,true,this._oItemNavigation.getFocusedIndex());return this;};Y.prototype.previousPage=function(){m.call(this,false,this._oItemNavigation.getFocusedIndex());return this;};Y.prototype.onsapspace=function(E){E.preventDefault();};Y.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var s=k.call(this,i);if(s){this.fireSelect();}};Y.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};Y.prototype.onmouseup=function(E){if(this._bMousedownChange){this._bMousedownChange=false;this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){var i=this._oItemNavigation.getFocusedIndex();k.call(this,i);this.fireSelect();}};Y.prototype.getFirstRenderedDate=function(){var F;if(this.getDomRef()){var i=this._oItemNavigation.getItemDomRefs();F=this._oFormatYyyymmdd.parse(q(i[0]).attr("data-sap-year-start"),true);}return F;};Y.prototype._isValueInThreshold=function(r,v,t){var L=r-t,u=r+t;return v>=L&&v<=u;};Y.prototype._checkFirstDate=function(o){var y=this.getYears();var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(o.isAfter(M)&&o.getYear()!=M.getYear()){o=new b(M,this.getPrimaryCalendarType());o.setMonth(0);o.setDate(1);}else if(o.isBefore(this._oMinDate)&&o.getYear()!=this._oMinDate.getYear()){o=new b(this._oMinDate,this.getPrimaryCalendarType());o.setMonth(0);o.setDate(1);}return o;};Y.prototype._checkDateEnabled=function(o){var E=true;if((o.isAfter(this._oMaxDate)&&o.getYear()!=this._oMaxDate.getYear())||(o.isBefore(this._oMinDate)&&o.getYear()!=this._oMinDate.getYear())){E=false;}return E;};function _(){var y=this.getYears();var i=this._getDate().getYear();var M=this._oMinDate.getYear();var o=this._oMaxDate.getYear();var r=this.getDomRef();var p=this.$().find(".sapUiCalItem");var s=Math.floor(y/2);if(i>o-Math.floor(y/2)){s=s+i-o+Math.floor(y/2);}else if(i<=M+Math.floor(y/2)){s=i-M;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,f,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,g,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,j,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(p);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this.getColumns(),true);this._oItemNavigation.setFocusedIndex(s);this._oItemNavigation.setPageSize(p.length);}function f(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){h.call(this,E,i);}}function g(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){h.call(this,E,i);}}function h(E,i){if(E.button||D.support.touch){return;}var s=k.call(this,i);if(s){this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");}function j(o){var E=o.getParameter("event");if(E.type){var y=this.getYears();var i=this.getColumns();if(i==0){i=y;}switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_DOWN&&i<y){m.call(this,true,this._oItemNavigation.getFocusedIndex()-y+i,true);}else{m.call(this,true,0,true);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_UP&&i<y){m.call(this,false,y-i+this._oItemNavigation.getFocusedIndex(),true);}else{m.call(this,false,y-1,true);}break;case"sappagedown":m.call(this,true,this._oItemNavigation.getFocusedIndex(),true);break;case"sappageup":m.call(this,false,this._oItemNavigation.getFocusedIndex(),true);break;default:break;}}}function k(o){var p=this._oItemNavigation.getItemDomRefs();var $=q(p[o]);if($.hasClass("sapUiCalItemDsbl")){return false;}var y=$.attr("data-sap-year-start");var r=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y));var s=this.getId()+"-y"+y;for(var i=0;i<p.length;i++){$=q(p[i]);if($.attr("id")==s){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}}this.setProperty("date",r.toLocalJSDate(),true);this.setProperty("year",r.getYear(),true);return true;}function m(F,s,i){var o=this._oItemNavigation.getItemDomRefs();var p=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(o[0]).attr("data-sap-year-start")),this.getPrimaryCalendarType());var y=this.getYears();if(F){var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(p.isBefore(M)){p.setYear(p.getYear()+y);if(p.isAfter(M)){s=s+(p.getYear()-M.getYear());if(s>y-1){s=y-1;}p=this._oMaxDate;p.setMonth(0);p.setDate(1);}}else{return;}}else{if(p.isAfter(this._oMinDate)){p.setYear(p.getYear()-y);if(p.isBefore(this._oMinDate)){s=s-(this._oMinDate.getYear()-p.getYear());if(s<0){s=0;}p=new b(this._oMinDate,this.getPrimaryCalendarType());}}else{return;}}n.call(this,p,s);if(i){this.firePageChange();}}function n(F,s){var o=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var E=false;var p=this._checkFirstDate(F);var S;if(!p.isSame(F)){S=new b(F,this.getPrimaryCalendarType());S.setYear(S.getYear()+s);F=p;E=true;}var r=this._oItemNavigation.getItemDomRefs();var t=new b(F,this.getPrimaryCalendarType());for(var i=0;i<r.length;i++){var y=this._oFormatYyyymmdd.format(t.toUTCJSDate(),true);var $=q(r[i]);$.attr("id",this.getId()+"-y"+y);$.text(this._oYearFormat.format(U.getInstance(t.toUTCJSDate(),t.getCalendarType()),true));$.attr("data-sap-year-start",y);if($.hasClass("sapUiCalItemSel")&&y!=o){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else if(!$.hasClass("sapUiCalItemSel")&&y==o){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}var u=true;if(E){u=this._checkDateEnabled(t);if(t.isSame(S)){s=i;}}if(u){$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}else{$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}t.setYear(t.getYear()+1);}this._oItemNavigation.focusItem(s);}return Y;});
