/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library"],function(q,C,I,a,D,B,O,R,b,A,c,d,l,m){"use strict";var e=l.Importance;var f=m.ButtonType;var P=m.PlacementType;var g=l.ObjectPageHeaderDesign;var h=l.ObjectPageHeaderPictureShape;function j(i){return typeof i==="function";}var k=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.uxap.ObjectPageHeaderPictureShape",defaultValue:h.Square},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:g.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designTime:true}});k.prototype._iAvailablePercentageForActions=0.3;k.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this);};k.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};k.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};k.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};k.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};k._internalAggregationFactory={"_objectImage":c.createObjectImage,"_placeholder":c.createPlaceholder,"_overflowActionSheet":function(){return new A({placement:P.Bottom});},"_lockIconCont":function(i){return this._getButton(i,"sap-icon://private","lock-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(i){return new B({links:i.getAggregation("breadCrumbLinks")});},"_lockIcon":function(i){return this._getButton(i,"sap-icon://private","lock",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(i){return this._getButton(i,"sap-icon://arrow-down","titleArrow-cont",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(i){return this._getButton(i,"sap-icon://arrow-down","titleArrow",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(i){return this._getIcon(i,"favorite",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(i){return this._getIcon(i,"flag",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(i){return this._getButton(i,"sap-icon://overflow","overflow",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"));},"_expandButton":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","expand",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(i){return this._getButton(i,"sap-icon://user-edit","changes-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(i){return this._getButton(i,"sap-icon://user-edit","changes",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(i,t,T){return I.createControlByURI({id:this._getParentAugmentedId(i,t),tooltip:T,src:I.getIconURI(t),visible:false});},_getButton:function(i,t,u,T){return new b({id:this._getParentAugmentedId(i,u),tooltip:T,icon:t,type:f.Transparent});},_getParentAugmentedId:function(i,t){return i.getId()+"-"+t;}};k.prototype._lazyLoadInternalAggregation=function(i,S){if(!this.getAggregation(i)){this.setAggregation(i,k._internalAggregationFactory[i](this),S);}return this.getAggregation(i);};k.prototype._applyActionProperty=function(i,t){var u=t[0];if(this.getProperty(i)!==u){t.unshift(i);this.setProperty.apply(this,t);if(!this._bFirstRendering){this._notifyParentOfChanges();}}return this;};k.prototype._applyObjectImageProperty=function(i,t){var u=t[0];if(this.getProperty(i)!==u){t.unshift(i);this.setProperty.apply(this,t);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true);}}return this;};k.prototype._proxyMethodToBreadCrumbControl=function(F,i){var t=this._lazyLoadInternalAggregation("_breadCrumbs"),v=t[F].apply(t,i);this.invalidate();return v;};k.prototype.setHeaderDesign=function(H){this.setProperty("headerDesign",H);if(this.getParent()){this.getParent().invalidate();}return this;};k.prototype.setObjectTitle=function(N){var i=this.getParent(),t=this.getProperty("objectTitle"),u=t!==N;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));i&&j(i._updateRootAriaLabel)&&i._updateRootAriaLabel();if(u&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":t,"newValue":N});}return this;};var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],o=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape"];var G=function(i){var t="set"+i.charAt(0).toUpperCase()+i.slice(1);k.prototype[t]=function(){var u=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,i,u);};};var n=function(i){var t="set"+i.charAt(0).toUpperCase()+i.slice(1);k.prototype[t]=function(){var u=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,i,u);};};var r=function(i,S,t){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);S[u]=function(){var v=Array.prototype.slice.call(arguments);v.unshift(i);t.setProperty.apply(t,v);return this.setProperty.apply(this,v);};};p.forEach(G);o.forEach(n);k.prototype.getBreadCrumbsLinks=function(){return this._lazyLoadInternalAggregation("_breadCrumbs").getLinks();};k.prototype.addBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("addLink",arguments);};k.prototype.indexOfBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("indexOfLink",arguments);};k.prototype.insertBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("insertLink",arguments);};k.prototype.removeBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("removeLink",arguments);};k.prototype.removeAllBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("removeAllLinks",arguments);};k.prototype.destroyBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("destroyLinks",arguments);};k.prototype._destroyObjectImage=function(){var i="_objectImage",t=this.getAggregation(i);if(t){t.destroy();this.setAggregation(i,null);}};k.prototype.onBeforeRendering=function(){var S=this.getSideContentButton();if(S&&!S.getTooltip()){S.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var i=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._oActionSheetButtonMap={};if(i.length>1||this._hasOneButtonShowText(i)){i.forEach(function(t){if(t instanceof b&&!(t instanceof O)){t._bInternalVisible=t.getVisible();t._getInternalVisible=function(){return this._bInternalVisible;};t._setInternalVisible=function(v,w){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(w){this.invalidate();}}};t.setVisible=function(v){t._setInternalVisible(v,true);b.prototype.setVisible.call(this,v);t.getParent()._adaptOverflow();};t.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};}if(t instanceof b&&(t.getType()==="Default"||t.getType()==="Unstyled")){t.setProperty("type",f.Transparent,false);}if(t instanceof b&&t.getVisible()){var u=this._createActionSheetButton(t);this._oActionSheetButtonMap[t.getId()]=u;this._oOverflowActionSheet.addButton(u);r("text",t,u);r("icon",t,u);r("enabled",t,u);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._bFirstRendering=false;};k.prototype._createActionSheetButton=function(i){return new b({press:q.proxy(this._onSeeMoreContentSelect,this),enabled:i.getEnabled(),text:i.getText(),icon:i.getIcon(),tooltip:i.getTooltip(),customData:new a({key:"originalId",value:i.getId()})});};k.prototype._handleImageNotFoundError=function(){var i=this._lazyLoadInternalAggregation("_objectImage"),t=this.getParent(),$=t?t.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{i.addStyleClass("sapMNoImg");}};k.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error");};k.prototype.onAfterRendering=function(){var $=this._lazyLoadInternalAggregation("_objectImage").$();this._adaptLayout();this._clearImageNotFoundHandler();$.error(this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._attachDetachActionButtonsHandler(true);};k.prototype._onHeaderResize=function(){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._adjustHeaderHeights==="function"){this.getParent()._adjustHeaderHeights();}};k.prototype._attachDetachActionButtonsHandler=function(i){var t=this.getActions()||[];if(t.length<1){return;}t.forEach(function(u){if(u instanceof b){var v=this._oActionSheetButtonMap[u.getId()];if(i){u.attachEvent("_change",this._adaptLayout,this);if(v){v.attachEvent("_change",this._adaptOverflow,this);}}else{u.detachEvent("_change",this._adaptLayout,this);if(v){v.detachEvent("_change",this._adaptOverflow,this);}}}},this);};k.prototype._onSeeMoreContentSelect=function(E){var i=E.getSource(),t=sap.ui.getCore().byId(i.data("originalId"));if(t.firePress){t.firePress({overflowButtonId:this._oOverflowButton.getId()});}this._oOverflowActionSheet.close();};k._actionImportanceMap={"Low":3,"Medium":2,"High":1};k._sortActionsByImportance=function(i,t){var u=(i instanceof O)?i.getImportance():e.High,v=(t instanceof O)?t.getImportance():e.High,w=k._actionImportanceMap[u]-k._actionImportanceMap[v];if(w===0){return i.position-t.position;}return w;};k.prototype._hasOneButtonShowText=function(i){var t=false;if(i.length!==1){return t;}if(i[0]instanceof O){t=(!i[0].getHideText()&&i[0].getText()!="");}else if(i[0]instanceof b){t=(i[0].getText()!="");}return t;};k.prototype._adaptLayout=function(E){this._adaptLayoutForDomElement(null,E);};k.prototype._adaptLayoutForDomElement=function($,E){var i=$?$:this.getDomRef();if(s(i)){return;}var t=this._findById($,"identifierLine"),u=t.width(),v=this._getActionsWidth(),w=v/u,x=this._iAvailablePercentageForActions*u,y=this._oOverflowButton.$(),z=this._findById($,"actions"),F=z.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(w>this._iAvailablePercentageForActions){this._adaptActions(x);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(D.system.phone){F.css("visibility","visible");}if(F.filter(":visible").length===F.length){y.hide();}this._adaptObjectPageHeaderIndentifierLine($);};k.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){q.sap.clearDelayedCall(this._adaptLayoutTimeout);}this._adaptLayoutTimeout=q.sap.delayedCall(0,this,function(){this._adaptLayoutTimeout=null;this._adaptLayout();});};k.prototype._adaptObjectPageHeaderIndentifierLine=function($){var i=this._findById($,"identifierLine"),t=i.width(),u=this._findById($,"subtitle"),v=this._findById($,"innerTitle"),w=this._findById($,"identifierLineContainer"),S,T,x=this._findById($,"actions"),y=$?$.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),z=x.width()+y.width(),E=this.$().parents().hasClass('sapUiSizeCompact')?7:3;if(u.length){if(u.hasClass("sapOPHSubtitleBlock")){u.removeClass("sapOPHSubtitleBlock");}S=u.outerHeight()+u.position().top;T=v.outerHeight()+v.position().top;if(Math.abs(S-T)>E){u.addClass("sapOPHSubtitleBlock");}}w.width((0.95-(z/t))*100+"%");};k.prototype._adaptActions=function(t){var M=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||D.system.phone,$=this._oOverflowButton.$(),v=$.show().width(),u=this.getActions(),w=u.length,x;for(var i=0;i<w;i++){u[i].position=i;}u.sort(k._sortActionsByImportance);u.forEach(function(y){x=this._oActionSheetButtonMap[y.getId()];if(x){v+=y.$().width();if(t>v&&!M){this._setActionButtonVisibility(y,true);$.hide();}else{this._setActionButtonVisibility(y,false);$.show();}}},this);};k.prototype._adaptOverflow=function(){var i=this._oOverflowActionSheet.getButtons();var H=i.some(function(t){return t.getVisible();});this._oOverflowButton.$().toggle(H);};k.prototype._setActionButtonVisibility=function(i,v){var t=this._oActionSheetButtonMap[i.getId()];if(t){if(i.getVisible()){i._setInternalVisible(v);t.setVisible(!v);}else{t.setVisible(false);}}};k.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(i){if(i instanceof b){i.$().show();if(D.system.phone){i.$().css("visibility","hidden");}w+=i.$().outerWidth(true);}});return w;};k.prototype._findById=function($,i){if(!i){return null;}if($){i=this.getId()+'-'+i;return q.sap.byId(i,$);}return this.$(i);};k.prototype._getBreadcrumbsAggregation=function(){var i=this.getBreadcrumbs(),t=this._lazyLoadInternalAggregation('_breadCrumbs',true);return i||((t&&t.getLinks().length)?t:null);};k.prototype._notifyParentOfChanges=function(i){var t=this.getParent();if(t&&typeof t._headerTitleChangeHandler==="function"){t._headerTitleChangeHandler(i);}};k.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}};k.prototype.setNavigationBar=function(i){this.setAggregation("navigationBar",i);if(i&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":i});}return this;};k.prototype._getAdaptableContent=function(){return this.getNavigationBar();};k.prototype.isDynamic=function(){return false;};k.prototype.getCompatibleHeaderContentClass=function(){return d;};k.prototype.supportsTitleInHeaderContent=function(){return true;};k.prototype.supportsAdaptLayoutForDomElement=function(){return true;};k.prototype.getTitleText=function(){return this.getObjectTitle();};k.prototype.snap=function(){this._adaptLayout();};k.prototype.unSnap=function(){this._adaptLayout();};k.prototype._toggleExpandButton=function(t){};k.prototype._setShowExpandButton=function(v){};k.prototype._focusExpandButton=function(){};function s($){return $&&!$.offsetWidth&&!$.offsetHeight;}return k;});
