/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/ui/core/ScrollBar","sap/ui/core/library","./library","jquery.sap.keycodes"],function(q,R,C,D,S,O,a,b,c,L,A,T,d,e,l){"use strict";var f=e.TitleLevel;var g=l.ObjectPageSubSectionLayout;var h=C.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:g.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:f.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"}}}},designTime:true}});h.HEADER_CALC_DELAY=350;h.DOM_CALC_DELAY=200;h.FOOTER_ANIMATION_DURATION=350;h.MAX_SNAP_POSITION_OFFSET=20;h.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;h.TITLE_LEVEL_AS_ARRAY=Object.keys(f);h.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};h.BREAK_POINTS={TABLET:1024,PHONE:600};h.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};h._getNextTitleLevelEntry=function(t){var j=h.TITLE_LEVEL_AS_ARRAY.indexOf(t),k=j!==-1,H=k&&(j!==h.TITLE_LEVEL_AS_ARRAY.length-1);if(!k){return f.Auto;}return h.TITLE_LEVEL_AS_ARRAY[H?j+1:j];};h._getLibraryResourceBundle=function(){return l.i18nModel.getResourceBundle();};h.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._iStoredScrollPosition=0;this._bInternalAnchorBarVisible=true;this._$opWrapper=[];this._$anchorBar=[];this._$headerTitle=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iTotalHeaderSize=0;this._iREMSize=parseInt(q("body").css("font-size"),10);this._iOffset=parseInt(0.25*this._iREMSize,10);this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);};h.prototype.onBeforeRendering=function(){var H,p;this._oLazyLoading=new L(this);if(!this.getVisible()){return;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._initializeScroller();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();this._getCustomScrollBar().setScrollPosition(0);if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){p=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(p);if(p){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);};h.prototype.setToggleHeaderOnTitleClick=function(t){var r=this.setProperty("toggleHeaderOnTitleClick",t,true);this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",t);this._updateToggleHeaderVisualIndicators();return r;};h.prototype._attachTitlePressHandler=function(){var t=this.getHeaderTitle();if(i(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(h.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};h.prototype._toggleHeaderVisibility=function(s){var H=this._getHeaderContent();if(i(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!s);}};h.prototype._snapHeader=function(j){if(this._bPinned){q.sap.log.debug("ObjectPage :: aborted snapping, header is pinned",this);return;}var I;this._toggleHeaderTitle(false);this._moveAnchorBarToTitleArea();if(j){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._toggleHeaderVisibility(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};h.prototype._expandHeader=function(j){this._toggleHeaderTitle(true);this._toggleHeaderVisibility(true);if(j){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();};h.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()){return;}var E=!this._bHeaderExpanded,I,j,k;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));j=this._shouldPreserveHeaderInTitleArea()||!I;this._expandHeader(j);}else{k=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(k);}};h.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(i(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(h.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};h.prototype._handleExpandButtonPressEventLifeCycle=function(j){var H=this.getHeaderTitle(),E;if(H){E=H.getAggregation("_expandButton");if(E){E[j?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};h.prototype._adjustSelectedSectionByUXRules=function(){var s=this.oCore.byId(this.getSelectedSection()),v=s&&this._sectionCanBeRenderedByUXRules(s);if(!v){if(this._oFirstVisibleSection){s=this._oFirstVisibleSection;this.setAssociation("selectedSection",s.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}var o=this.oCore.byId(this._sStoredScrolledSubSectionId),V=o&&this._sectionCanBeRenderedByUXRules(o)&&(s.indexOfSubSection(o)>=0);if(!V){this._sStoredScrolledSubSectionId=null;}};h.prototype._sectionCanBeRenderedByUXRules=function(s){if(!s||!s.getVisible()||!s._getInternalVisible()){return false;}var j=this._aSectionBases.map(function(o){return o.getId();});return(j.indexOf(s.getId())>-1);};h.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var s=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&s){return[s];}else{return this.getSections();}};h.prototype._preloadSectionsOnBeforeFirstRendering=function(){var t;if(!this.getEnableLazyLoading()){t=this._getSectionsToRender();}else{var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;t=this._oLazyLoading.getSubsectionsToPreload(s);}this._connectModelsForSections(t);};h.prototype._grepCurrentTabSectionBases=function(){var F=[],s;this._adjustSelectedSectionByUXRules();s=this.oCore.byId(this.getSelectedSection());if(s){var j=s.getId();this._aSectionBases.forEach(function(o){if(o.getParent().getId()===j){F.push(o);}});}return F;};h.prototype.onAfterRendering=function(){this._ensureCorrectParentHeight();this._cacheDomElements();this._$opWrapper.on("scroll",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=q.sap.delayedCall(h.HEADER_CALC_DELAY,this,this._onAfterRenderingDomReady);}this._handleExpandButtonPressEventLifeCycle(true);};h.prototype._onAfterRenderingDomReady=function(){var s,o,j;if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(s){if(this.getUseIconTabBar()){this._setSelectedSectionId(s);this._setCurrentTabSection(o);}else{this.scrollToSection(s,0);}}if(D.system.desktop){this._$opWrapper.on("scroll",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){j=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(j);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);if(this._hasDynamicTitle()){this._updateMedia(this._getWidth(this));}this._updateToggleHeaderVisualIndicators();this.fireEvent("onAfterRenderingDOMReady");};h.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),s=this._calculateShiftOffset();$.css(s.sStyleAttribute,s.iMarginalsOffset+"px");};h.prototype._calculateShiftOffset=function(){var H=0,s=this.oCore.getConfiguration().getRTL()?"left":"right",j=this._hasVerticalScrollBar(),k=this._iOffset,m;if(D.system.desktop){m=q.sap.scrollbarSize().width;H=m;if(!j){H=0;k+=m;}}return{"sStyleAttribute":s,"iActionsOffset":k,"iMarginalsOffset":H};};h.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._iResizeId){R.deregister(this._iResizeId);}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};h.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new d(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this)});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};h.prototype.onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(s);}};h.prototype.onCustomScrollerScroll=function(E){var s=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(s);};h.prototype.setShowOnlyHighImportance=function(v){var o=this.getShowOnlyHighImportance();if(o!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(s){s._updateImportance();});}return this;};h.prototype.setIsHeaderContentAlwaysExpanded=function(v){var o=this.getAlwaysShowContentHeader();var s=(D.system.phone||D.system.tablet);if(o!==v){this.setProperty("alwaysShowContentHeader",v,s);}return this;};h.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};h.prototype.setSelectedSection=function(I){var v,s;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._requestAdjustLayoutAndUxRules(true);return this;}this.scrollToSection(I);v=a._getClosestSection(I);s=(v instanceof a)?v.getId():v;return this.setAssociation("selectedSection",s,true);};h.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};h.prototype._cacheDomElements=function(){this._$headerTitle=q.sap.byId(this.getId()+"-headerTitle");this._$anchorBar=q.sap.byId(this.getId()+"-anchorBar");this._$stickyAnchorBar=q.sap.byId(this.getId()+"-stickyAnchorBar");this._$opWrapper=q.sap.byId(this.getId()+"-opwrapper");this._$spacer=q.sap.byId(this.getId()+"-spacer");this._$headerContent=q.sap.byId(this.getId()+"-headerContent");this._$stickyHeaderContent=q.sap.byId(this.getId()+"-stickyHeaderContent");this._$contentContainer=q.sap.byId(this.getId()+"-scroll");this._$sectionsContainer=q.sap.byId(this.getId()+"-sectionsContainer");this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};h.prototype._handleExpandButtonPress=function(E){if(this._bStickyAnchorBar){this._moveHeaderToTitleArea();this._toggleHeaderTitle(true);}};h.prototype._toggleHeaderTitle=function(E){var H=this.getHeaderTitle();this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",!E);if(E){H&&H.unSnap();}else{H&&H.snap();}};h.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};h.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};h.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};h.prototype._applyUxRules=function(I){var s,j,v,V,k,m,n,F,o;s=this.getSections()||[];V=0;m=this.getShowAnchorBar();n=this.getUseIconTabBar();F=null;this._cleanMemory();s.forEach(function(p){if(!p.getVisible()){return true;}this._registerSectionBaseInfo(p);j=p.getSubSections()||[];v=0;o=null;j.forEach(function(r){if(!r.getVisible()){return true;}this._registerSectionBaseInfo(r);k=r.getVisibleBlocksCount();if(k===0){r._setInternalVisible(false,I);q.sap.log.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+r.getTitle()+" forced to hidden");}else{r._setInternalVisible(true,I);r._setInternalTitleVisible(true,I);v++;if(!o){o=r;}if(this._shouldApplySectionTitleLevel(r)){r._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(r));}}},this);if(v==0){p._setInternalVisible(false,I);q.sap.log.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+p.getTitle()+" forced to hidden");}else{p._setInternalVisible(true,I);p._setInternalTitleVisible(true,I);if(!F){F=p;}if(this.getSubSectionLayout()===g.TitleOnTop&&v===1&&o.getTitle().trim()!==""){q.sap.log.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+p.getTitle()+" is taking its single subsection title "+o.getTitle());p._setInternalTitle(o.getTitle(),I);o._setInternalTitleVisible(false,I);}else{p._setInternalTitle("",I);}if(this._shouldApplySectionTitleLevel(p)){p._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(p));}V++;}if(n){p._setInternalTitleVisible(false,I);}},this);if(V<=1){m=false;q.sap.log.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");}else if(F&&m){F._setInternalTitleVisible(false,I);q.sap.log.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+F.getTitle()+" title forced to hidden");}if(m){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(m,I);this._oFirstVisibleSection=F;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(F);};h.prototype.setUseIconTabBar=function(v){var o=this.getUseIconTabBar();if(v!=o){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};h.prototype._setCurrentTabSection=function(s,I){if(!s){return;}var o;if(s instanceof sap.uxap.ObjectPageSubSection){o=s;s=s.getParent();}else{o=this._getFirstVisibleSubSection(s);}if(this._oCurrentTabSection!==s){this._renderSection(s);this._oCurrentTabSection=s;}this._oCurrentTabSubSection=o;};h.prototype._renderSection=function(s){var $=this.$().find(".sapUxAPObjectPageContainer"),r;if(s&&$.length){r=this.oCore.createRenderManager();this.getSections().forEach(function(o){if((o.getId()===s.getId())){r.renderControl(s);}else{r.cleanupControlWithoutRendering(o);}});r.flush($[0]);r.destroy();}};h.prototype.setShowAnchorBarPopover=function(v,s){var o=this.getProperty("showAnchorBarPopover"),v=this.validateProperty("showAnchorBarPopover",v);if(v===o){return;}this._oABHelper._buildAnchorBar();this._oABHelper._getAnchorBar().setShowPopover(v);return this.setProperty("showAnchorBarPopover",v,true);};h.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};h.prototype._setInternalAnchorBarVisible=function(v,I){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(I===true){this.invalidate();}}};h.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};h.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,h.DOM_CALC_DELAY,this);}if(!I){q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+h.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(r){});};h.prototype._requestAdjustLayoutAndUxRules=function(I){if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,h.DOM_CALC_DELAY,this);}if(!I){q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+h.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(r){});};h.prototype._adjustLayoutAndUxRules=function(){var s,o;q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);if(o){this._setSelectedSectionId(s);if(this.getUseIconTabBar()){this._setCurrentTabSection(o);}this._requestAdjustLayout(true).then(function(j){if(j){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();if(!this._isClosestScrolledSection(s)){this.scrollToSection(s);}}.bind(this));}};h.prototype._isClosestScrolledSection=function(s){var j=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,p=this.iScreenHeight,k=this._getClosestScrolledSectionId(j,p);return k&&(s===k);};h.prototype._setSelectedSectionId=function(s){var o=this.getAggregation("_anchorBar"),j=s&&this._oSectionInfo[s];if(!j){return;}if(o&&j.buttonId){o.setSelectedButton(j.buttonId);this.setAssociation("selectedSection",s,true);}};h.prototype.isFirstRendering=function(){return this._bFirstRendering;};h.prototype._cleanMemory=function(){var o=this.getAggregation("_anchorBar");if(o){o._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};h.prototype._registerSectionBaseInfo=function(s){this._oSectionInfo[s.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(s instanceof a),sectionReference:s};this._aSectionBases.push(s);};h.prototype._triggerVisibleSubSectionsEvents=function(){if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};h.prototype.scrollToSection=function(I,j,o,k){var s=this.oCore.byId(I);if(!this.getDomRef()){q.sap.log.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!s){q.sap.log.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]){q.sap.log.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){q.sap.log.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var t=a._getClosestSection(s);if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}t._allowPropagationToLoadedViews(true);this._setCurrentTabSection(s);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[t.getId()].buttonId);this.setAssociation("selectedSection",t.getId(),true);}if(k){this.fireNavigate({section:a._getClosestSection(s)});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}o=o||0;s._expandSection();this._requestAdjustLayout(true);j=this._computeScrollDuration(j,s);var m=this._computeScrollPosition(s);if(this._sCurrentScrollId!=I){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=q.sap.delayedCall(j,this,function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;});}this._preloadSectionsOnScroll(s);this.getHeaderTitle()&&this._shiftHeaderTitle();this._scrollTo(m+o,j);}};h.prototype._computeScrollDuration=function(j,t){var k=parseInt(j,10);k=k>=0?k:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((t instanceof a)||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){k=0;}return k;};h.prototype._computeScrollPosition=function(t){var F=t&&(t instanceof a),I=t.getId(),s=this._bMobileScenario||F?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(t)){s=0;}return s;};h.prototype._preloadSectionsOnScroll=function(t){var I=t.getId(),j;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){j=(t instanceof a)?t:t.getParent();this._connectModelsForSections([j]);}if(this.getEnableLazyLoading()){var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;j=this._oLazyLoading.getSubsectionsToPreload(s,I);if(D.system.desktop){q.sap.delayedCall(50,this,function(){this._connectModelsForSections(j);});}else{this._connectModelsForSections(j);}j.forEach(function(k){this.fireEvent("subSectionEnteredViewPort",{subSection:k});},this);}};h.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};h.prototype.setDirectScrollingToSection=function(s){this.sDirectSectionId=s;};h.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};h.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};h.prototype._scrollTo=function(y,t){if(this._oScroller&&this._bDomReady){q.sap.log.debug("ObjectPageLayout :: scrolling to "+y);if((t===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}this._oScroller.scrollTo(0,y,t);}return this;};h.prototype._updateMedia=function(w){var u=function(M){Object.keys(h.DYNAMIC_HEADERS_MEDIA).forEach(function(s){var j=h.DYNAMIC_HEADERS_MEDIA[s],E=M===j;this.toggleStyleClass(j,E);},this);}.bind(this),m=h.DYNAMIC_HEADERS_MEDIA,B=h.BREAK_POINTS;if(w<=B.PHONE){u(m.PHONE);}else if(w<=B.TABLET){u(m.TABLET);}else{u(m.DESKTOP);}};h.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var j,o,s,p,P,k,m=!this._bHeaderExpanded,$=this.getDomRef();if(!$||!this._bDomReady){return false;}q.sap.log.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=$.parentElement?$.getBoundingClientRect().height:0;if(this.iScreenHeight===0){return;}var n=0;this._aSectionBases.forEach(function(r){var I=this._oSectionInfo[r.getId()],t=r.$(),u,v=false;if(!I||!t.length){return;}if(!I.isSection){n++;}I.$dom=t;var w=t.position().top;I.positionTop=Math.ceil(w);if(I.isSection){u=r.$("header");}else{u=r.$("headerTitle");}v=u.length===0;if(!v){I.positionTopMobile=Math.ceil(u.position().top)+u.outerHeight();}else{I.positionTopMobile=I.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){I.positionTopMobile-=this.iAnchorBarHeight;I.positionTop-=this.iAnchorBarHeight;}I.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",v);if(this._bMobileScenario){var x=this.oCore.byId(r.getId()).getParent();if(x instanceof a&&x._getIsHidden()){return;}if(P){this._oSectionInfo[P].positionBottom=I.positionTop;}P=r.getId();o=r;}else{if(I.isSection){if(P){this._oSectionInfo[P].positionBottom=I.positionTop;if(p){this._oSectionInfo[p].positionBottom=I.positionTop;}}P=r.getId();p=null;}else{if(p){this._oSectionInfo[p].positionBottom=I.positionTop;}p=r.getId();o=r;}}},this);if(o){j=this._computeLastVisibleHeight(o);if(this._bMobileScenario&&P){this._oSectionInfo[P].positionBottom=this._oSectionInfo[P].positionTop+j;}else{if(p){this._oSectionInfo[p].positionBottom=this._oSectionInfo[p].positionTop+j;}if(P&&p){this._oSectionInfo[P].positionBottom=this._oSectionInfo[p].positionTop+j;}}k=this._bStickyAnchorBar||(n>1)||this._checkContentBottomRequiresSnap(o);if(k&&!this._shouldPreserveHeaderInTitleArea()){m=true;}s=this._computeSpacerHeight(o,j,k,m);this._$spacer.height(s+"px");q.sap.log.debug("ObjectPageLayout :: bottom spacer is now "+s+"px");}this._updateCustomScrollerHeight(m);return true;};h.prototype._updateCustomScrollerHeight=function(r){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var s=this._computeScrollableContentSize(r);s+=this._getStickyAreaHeight(r);this._getCustomScrollBar().setContentSize(s+"px");var j=(s>Math.ceil(this.iScreenHeight)),v=(j!==this._getCustomScrollBar().getVisible());if(v){this._getCustomScrollBar().setVisible(j);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};h.prototype._computeScrollableContentSize=function(s){var j=0;if(this._$contentContainer&&this._$contentContainer.length){j=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&s){j-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!s){j+=this.iAnchorBarHeight;}return j;};h.prototype._computeLastVisibleHeight=function(o){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var j=this._getSectionPositionTop(o,I);return this._$spacer.position().top-j;};h.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};h.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};h.prototype._getSectionPositionTop=function(s,j){var p=s.$().position().top;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&j){p-=this.iAnchorBarHeight;}return p;};h.prototype._getSectionPositionBottom=function(s,j){var p=this._oSectionInfo[s.getId()].positionBottom;if(!j){p+=this.iAnchorBarHeight;}return p;};h.prototype._determineSectionBaseInternalTitleLevel=function(s){var j=this.getSectionTitleLevel(),I=s instanceof a;if(j===f.Auto){return I?f.H3:f.H4;}return I?j:h._getNextTitleLevelEntry(j);};h.prototype._shouldApplySectionTitleLevel=function(s){return s.getTitleLevel()===f.Auto;};h.prototype._checkContentBottomRequiresSnap=function(s){var j=false;return this._getSectionPositionBottom(s,j)>=(this._getScrollableViewportHeight(j)+this._getSnapPosition());};h.prototype._computeSpacerHeight=function(o,j,k,s){var m,n,F;if(this.getFooter()&&this.getShowFooter()){F=this.$("footerWrapper").outerHeight();}n=this._getScrollableViewportHeight(s);if(!k){j=this._getSectionPositionBottom(o,false);}if(j<n){m=n-j;if(this._bMobileScenario){m+=(this._oSectionInfo[o.getId()].positionTopMobile-this._oSectionInfo[o.getId()].positionTop);}}else{m=0;}if(F>m){m+=F;}return m;};h.prototype._isFirstVisibleSectionBase=function(s){var j,o,F,k=this.getSelectedSection(),u=this.getUseIconTabBar();if(!s||!s.getParent()){return;}j=s.getId();if(u&&(j===k)){return true;}if(u&&(s.getParent().getId()===k)){o=sap.ui.getCore().byId(k);F=this._getFirstVisibleSubSection(o);return F&&(F.getId()===j);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return j===this._oFirstVisibleSection.getId()||j===this._oFirstVisibleSubSection.getId();}return false;};h.prototype._getFirstVisibleSubSection=function(s){if(!s){return;}var F;this._aSectionBases.every(function(o){if(o.getParent()&&(o.getParent().getId()===s.getId())){F=o;return false;}return true;});return F;};h.prototype._initAnchorBarScroll=function(){var s=this.oCore.byId(this.getSelectedSection()),j;this._requestAdjustLayout(true);j=s?this._computeScrollPosition(s):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:j}});};h.prototype._setAsCurrentSection=function(s){var o,j,k;if(this._sScrolledSectionId===s){return;}q.sap.log.debug("ObjectPageLayout :: current section is "+s);this._sScrolledSectionId=s;o=this.getAggregation("_anchorBar");if(o&&this._getInternalAnchorBarVisible()){j=this.oCore.byId(s);k=j&&j instanceof b&&(j.getTitle().trim()===""||!j._getInternalTitleVisible()||j.getParent()._getIsHidden());if(k){s=j.getParent().getId();q.sap.log.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+s);}if(j&&this._oSectionInfo[s]){o.setSelectedButton(this._oSectionInfo[s].buttonId);this.setAssociation("selectedSection",a._getClosestSection(s).getId(),true);this._setSectionsFocusValues(s);}}};h.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};h.prototype._onUpdateContentSize=function(E){var s,p,j,k;if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}this._adjustHeaderHeights();this._requestAdjustLayout().then(function(){s=this._$opWrapper.scrollTop();p=this.iScreenHeight;if(p===0){return;}j=this._getClosestScrolledSectionId(s,p);k=this.getSelectedSection();if(j&&k!==j){this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[j].buttonId);}}.bind(this));};h.prototype._onUpdateScreenSize=function(E){var t=this.getHeaderTitle(),j=E.size.width,k=E.size.height,o=E.oldSize.height,H=(k!==o),s;if(E.size.height===0||E.size.width===0){q.sap.log.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){q.sap.log.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();q.sap.delayedCall(h.HEADER_CALC_DELAY,this,function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader()){this.invalidate();}if(t&&t.isDynamic()){t._onResize(j);this._updateMedia(j);}this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}s=this.getSelectedSection();if((o===0)&&H&&!this._isClosestScrolledSection(s)){this.scrollToSection(s,0);return;}this._scrollTo(this._$opWrapper.scrollTop(),0);});};h.prototype._shouldSnapHeaderOnScroll=function(s){return(s>0)&&(s>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};h.prototype._onScroll=function(E){var s=Math.max(Math.ceil(E.target.scrollTop),0),p,H=this.getHeaderTitle(),j=this._shouldSnapHeaderOnScroll(s),k=this._shouldPreserveHeaderInTitleArea(),m,n,o=false;if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}p=this.iScreenHeight;if(p===0){return;}if(j&&!k){p-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!k){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!k&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(j);}if(!k){this._adjustHeaderTitleBackgroundPosition(s);}q.sap.log.debug("ObjectPageLayout :: lazy loading : Scrolling at "+s,"----------------------------------------");m=this._getClosestScrolledSectionId(s,p);n=this._getClosestScrolledSectionId(s,p,true);if(m){var r=this.getDirectScrollingToSection();if(m!==this._sScrolledSectionId){q.sap.log.debug("ObjectPageLayout :: closest id "+m,"----------------------------------------");var r=this.getDirectScrollingToSection();if(r&&r!==m){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(m);}else if(m===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(n!==this._sScrolledSubSectionId){this._sScrolledSubSectionId=n;this.fireEvent("_sectionChange",{section:this.oCore.byId(m),subsection:this.oCore.byId(n)});}}if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(s,E.timeStamp,p);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(s===0){q.sap.byId(this.getId()+"-scroll").css("z-index","1000");o=false;}else if(!o){o=true;q.sap.byId(this.getId()+"-scroll").css("z-index","0");}}};h.prototype._getSnapPosition=function(){var s=this.iHeaderContentHeight,t=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;if(t<h.MAX_SNAP_POSITION_OFFSET){s-=t;}return s;};h.prototype._getClosestScrolledSectionId=function(s,p,j){j=!!j;if(this.getUseIconTabBar()&&this._oCurrentTabSection){return this._oCurrentTabSection.getId();}var k=s+p,m,t=j||this._bMobileScenario;q.each(this._oSectionInfo,function(I,o){var n,r,u,v;n=this.oCore.byId(I);if(!n){return;}r=n.getParent();u=r instanceof a&&r._getIsHidden();if(o.isSection||(t&&!u)){if(!m&&(o.sectionReference._getInternalVisible()===true)){v=this._getFirstVisibleSubSection(o.sectionReference);if(o.isSection&&j&&v){m=v.getId();}else{m=I;}}if(o.isSection&&j){return true;}if(o.positionTop<=k&&s<=o.positionBottom){if(o.positionTop<=s&&o.positionBottom>s){m=I;return false;}}}}.bind(this));return m;};h.prototype._toggleHeader=function(s){var H;if(s===this._bStickyAnchorBar){return;}H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!s);}if(!this._bStickyAnchorBar&&s){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!s){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}};h.prototype._restoreFocusAfter=function(m){var o=this.oCore.byId(this.oCore.getCurrentFocusedControlId());m.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){o&&o.$().focus();}}return this;};h.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};h.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var s=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(s);this._toggleHeaderStyleRules(false);}return this;};h.prototype._toggleHeaderStyleRules=function(s){s=!!s;var v=s?"hidden":"inherit";this._bStickyAnchorBar=s;this._$headerContent.css("overflow",v);this._$headerContent.toggleClass("sapContrastPlus",!s);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",s);this._$anchorBar.css("visibility",v);this.fireToggleAnchorBar({fixed:s});};h.prototype.getScrollDelegate=function(){return this._oScroller;};h.prototype.setHeaderTitle=function(H,s){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)});}this.setAggregation("headerTitle",H,s);if(H){this._createHeaderContent();}return this;};h.prototype.invalidate=function(o){if(this.getUseIconTabBar()&&o&&(o instanceof a)&&!o.isActive()){return;}C.prototype.invalidate.apply(this,arguments);};h.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),o=this.getAggregation("_headerContent"),n;var j=H?H.getCompatibleHeaderContentClass():c;if(!(o instanceof j)){var n=j.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable());this.setAggregation("_headerContent",n,true);}};h.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};h.prototype._adjustHeaderTitleBackgroundPosition=function(s){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-s)+"px");}}}};h.prototype._adjustHeaderHeights=function(){var t=this.getHeaderTitle(),p=true;if(t&&!t.supportsAdaptLayoutForDomElement()){p=false;}if(this._$headerTitle.length>0){this.iHeaderContentHeight=this._$headerContent[0].parentElement?Math.ceil(this._$headerContent[0].getBoundingClientRect().height):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.height():this._$anchorBar.height();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$headerTitle.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(p);}else{this.iHeaderTitleHeight=this._$headerTitle.is(":visible")?this._$headerTitle.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(p);}this._adjustHeaderBackgroundSize();q.sap.log.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{q.sap.log.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};h.prototype._appendTitleCloneToDOM=function(E){var $=this._$headerTitle.clone();$.css({position:"absolute"});$.css({left:"-10000px",top:"-10000px",width:this._$headerTitle.width()+"px"});$.toggleClass("sapUxAPObjectPageHeaderStickied",E);$.appendTo(this._$headerTitle.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptLayoutForDomElement($);}return $;};h.prototype._obtainSnappedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(v){this._$opWrapper.css("overflow-y","hidden");$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();this._$opWrapper.css("overflow-y","auto");}else if(t&&t.snap){t.snap();H=t.$().outerHeight();t.unSnap();}return H;};h.prototype._obtainExpandedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(v){this._$opWrapper.css("overflow-y","hidden");$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();this._$opWrapper.css("overflow-y","auto");}else if(t&&t.unSnap){t.unSnap();H=t.$().outerHeight();t.snap();}return H;};h.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),s=l.ObjectPageHeaderDesign.Light;if(H!=null){s=H.getHeaderDesign();}return s;};h.prototype._getVisibleSections=function(){return this.getSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};h.prototype._setSectionsFocusValues=function(s){var j=this._getVisibleSections()||[],$,F='0',n='-1',t="tabIndex",o,k=j[0];j.forEach(function(m){$=m.$();if(s===m.sId){$.attr(t,F);o=m;m._setSubSectionsFocusValues();}else{$.attr(t,n);m._disableSubSectionsFocus();}});if(!o&&j.length>0){k.$().attr(t,F);k._setSubSectionsFocusValues();o=k;}return o;};h.prototype.setShowHeaderContent=function(s){var o=this.getShowHeaderContent(),H;if(o!==s){if(o&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",s);H=this._getHeaderContent();if(H){H.setProperty("visible",s);}}return this;};h.prototype._headerTitleChangeHandler=function(I){var r;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}r=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(r,this);this._getHeaderContent().invalidate();r.destroy();};h.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};h.prototype.insertHeaderContent=function(o,I,s){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",o,I,s);}return this._getHeaderContent().insertAggregation("content",o,I,s);};h.prototype.addHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.addAggregation("headerContent",o,s);}return this._getHeaderContent().addAggregation("content",o,s);};h.prototype.removeAllHeaderContent=function(s){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",s);}return this._getHeaderContent().removeAllAggregation("content",s);};h.prototype.removeHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",o,s);}return this._getHeaderContent().removeAggregation("content",o,s);};h.prototype.destroyHeaderContent=function(s){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",s);}return this._getHeaderContent().destroyAggregation("content",s);};h.prototype.indexOfHeaderContent=function(o){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",o);}return this._getHeaderContent().indexOfAggregation("content",o);};h.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};h.prototype._checkAlwaysShowContentHeader=function(){var H=this._getHeaderContent();return H&&H.supportsAlwaysExpanded()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};h.prototype._connectModelsForSections=function(s){s=s||[];s.forEach(function(o){o.connectToModels();});};h.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};h.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};h.prototype._shiftHeaderTitle=function(){var s=this._calculateShiftOffset(),j=s.sStyleAttribute,p=s.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+j,p+"px");};h.prototype._isFirstSection=function(s){var j=this._getVisibleSections();if(s===j[0]){return true;}return false;};h.prototype._isPositionWithinSection=function(s,o){if(!o||!this._bDomReady||!this._oSectionInfo[o.getId()]){return;}var j=this._computeScrollPosition(o),k=q(o.getDomRef()).height(),m=j+k;return((s>=j)&&(s<m));};h.prototype._restoreScrollPosition=function(){var s=this.oCore.byId(this._sStoredScrolledSubSectionId);if(!s){return;}if(this._isPositionWithinSection(this._iStoredScrollPosition,s)){this._scrollTo(this._iStoredScrollPosition,0);}else{this.scrollToSection(s.getId(),0);}};h.prototype._storeScrollLocation=function(){if(!this._bDomReady){return;}this._iStoredScrollPosition=this._oScroller.getScrollTop();this._sStoredScrolledSubSectionId=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true);this._oCurrentTabSection=null;};h.prototype.onkeyup=function(E){var F,o;if(E.which===q.sap.KeyCodes.TAB){F=this.oCore.getCurrentFocusedControlId();o=F&&this.oCore.byId(F);if(o&&this._isFirstSection(o)){this._scrollTo(0,0);}}};h.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};h.prototype._toggleFooter=function(s){var u=this.oCore.getConfiguration().getAnimation(),F=this.getFooter();if(!i(F)){return;}F.toggleStyleClass("sapUxAPObjectPageFloatingFooterShow",s);F.toggleStyleClass("sapUxAPObjectPageFloatingFooterHide",!s);if(this._iFooterWrapperHideTimeout){q.sap.clearDelayedCall(this._iFooterWrapperHideTimeout);}if(u){if(!s){this._iFooterWrapperHideTimeout=q.sap.delayedCall(h.FOOTER_ANIMATION_DURATION,this,function(){this.$("footerWrapper").toggleClass("sapUiHidden",!s);});}else{this.$("footerWrapper").toggleClass("sapUiHidden",!s);this._iFooterWrapperHideTimeout=null;}q.sap.delayedCall(h.FOOTER_ANIMATION_DURATION,this,function(){F.removeStyleClass("sapUxAPObjectPageFloatingFooterShow");});}this._requestAdjustLayout();};h.prototype.clone=function(){var o,H;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);o=C.prototype.clone.apply(this,arguments);H=this._getHeaderContent();o.setAggregation("_headerContent",H.clone(),true);return o;};h.prototype._cloneProxiedAggregations=function(s){var o=this.mAggregations[s];if(Array.isArray(o)&&o.length===0){o=this["get"+s.charAt(0).toUpperCase()+s.slice(1)]();}this.mAggregations[s]=o;};h.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};h.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};h.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};h.prototype._headerBiggerThanAllowedToBeFixed=function(){var j=this._getOwnHeight();return this._getEntireHeaderHeight()>h.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*j;};h.prototype._getOwnHeight=function(){return this._getHeight(this);};h.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};h.prototype._getEntireHeaderHeight=function(){var t=0,H=0,o=this.getHeaderTitle(),j=this._getHeaderContent();if(i(o)){t=o.$().outerHeight();}if(i(j)){H=j.$().outerHeight();}return t+H;};h.prototype._onPinUnpinButtonPress=function(E){if(this._bPinned){this._unPin(E);}else{this._pin(E);}};h.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(i($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}};h.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(i($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};h.prototype._togglePinButtonARIAState=function(p){var H=this._getHeaderContent();if(i(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(p);}};h.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};h.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};h.prototype._hasDynamicTitle=function(){var t=this.getHeaderTitle();return t&&t.isDynamic();};h.prototype._attachVisualIndicatorsPressHandlers=function(p,o){var t=this.getHeaderTitle(),H=this._getHeaderContent();if(i(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(h.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){p.call(o);this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(i(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(h.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){p.call(o);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};h.prototype._updateToggleHeaderVisualIndicators=function(){var H,j,E;if(!this.getToggleHeaderOnTitleClick()||this._bPinned){j=false;E=false;}else{H=this._bHeaderExpanded;j=H;E=!H;}this._toggleCollapseVisualIndicator(j);this._toggleExpandVisualIndicator(E);};h.prototype._focusCollapseVisualIndicator=function(){var o=this._getHeaderContent();if(i(o)){o._focusCollapseButton();}};h.prototype._focusExpandVisualIndicator=function(){var o=this.getHeaderTitle();if(i(o)){o._focusExpandButton();}};h.prototype._toggleExpandVisualIndicator=function(t){var o=this.getHeaderTitle();if(i(o)){o._toggleExpandButton(t);}};h.prototype._toggleCollapseVisualIndicator=function(t){var o=this._getHeaderContent();if(i(o)){o._toggleCollapseButton(t);}};h.prototype._attachVisualIndicatorMouseOverHandlers=function(o,j,k){var H=this._getHeaderContent();if(i(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(h.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,o,k);H.attachEvent(h.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,j,k);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};h.prototype._attachTitleMouseOverHandlers=function(o,j,k){var t=this.getHeaderTitle();if(i(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(h.EVENTS.TITLE_MOUSE_OVER,o,k);t.attachEvent(h.EVENTS.TITLE_MOUSE_OUT,j,k);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};h.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};h.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};h.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};h.prototype._getWidth=function(o){return!(o instanceof C)?0:o.$().outerWidth()||0;};h.prototype._getRootAriaLabelText=function(){var H=this.getHeaderTitle(),t=H?H.getTitleText():null,s;if(H&&t){s=h._getLibraryResourceBundle().getText("ROOT_ARIA_LABEL_WITH_TITLE")+" "+t;}else{s=h._getLibraryResourceBundle().getText("ROOT_ARIA_LABEL_WITHOUT_TITLE");}return s;};h.prototype._updateRootAriaLabel=function(){var n=this._getRootAriaLabelText(),s=this.$().attr("aria-label");if(n!==s){this.$().attr("aria-label",n);}};function i(o){if(arguments.length===1){return Array.isArray(o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(j){return i(j);});}return h;});
