/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/ScrollBar","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/f/DynamicPageTitle","./DynamicPageRenderer"],function(q,l,C,S,R,a,D,b,c){"use strict";var d=C.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},_scrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/DynamicPage.designtime"}});function e(o){if(arguments.length===1){return o&&("length"in o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(O){return e(O);});}function h(E){var o;if(!E){return false;}o=E.getBoundingClientRect();return!!(o.width&&o.height);}var u=sap.ui.getCore().getConfiguration().getAnimation();d.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;d.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;d.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE=0.3;d.FOOTER_ANIMATION_DURATION=350;d.BREAK_POINTS={TABLET:1024,PHONE:600};d.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};d.MEDIA={INVISIBLE:"sapUiHidden",PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};d.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};d.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._bSuppressToggleHeaderOnce=false;this._headerBiggerThanAllowedHeight=false;this._bMSBrowser=D.browser.internet_explorer||D.browser.edge||false;this._oScrollHelper=new a(this,this.getId()+"-content",{horizontal:false,vertical:true});};d.prototype.onBeforeRendering=function(){var o=this.getTitle();if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler();}if(e(o)){o._toggleFocusableState(this.getToggleHeaderOnTitleClick());}this._attachTitlePressHandler();this._attachVisualIndicatorsPressHandlers();this._attachVisualIndicatorMouseOverHandlers();this._attachTitleMouseOverHandlers();this._detachScrollHandler();};d.prototype.onAfterRendering=function(){var s;if(this._preserveHeaderStateOnScroll()){q.sap.delayedCall(0,this,this._overridePreserveHeaderStateOnScroll);}this._bPinned=false;this._cacheDomElements();this._detachResizeHandlers();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();this._resetPinButtonState();if(!this.getHeaderExpanded()){this._snapHeader(false);s=this.getHeader()&&!this.getPreserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();if(s){this._setScrollPosition(this._getSnappingHeight());}else{this._toggleHeaderVisibility(false);this._moveHeaderToTitleArea();}}this._updateToggleHeaderVisualIndicators();};d.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy();}};d.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};d.prototype.setHeaderExpanded=function(H){if(this._bPinned){return this;}if(this.getHeaderExpanded()===H){return this;}if(this.getDomRef()){this._titleExpandCollapseWhenAllowed();}this.setProperty("headerExpanded",H,true);return this;};d.prototype.setToggleHeaderOnTitleClick=function(t){var o=this.getTitle(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);t=this.getProperty("toggleHeaderOnTitleClick");this.$().toggleClass("sapFDynamicPageTitleClickEnabled",t);this._updateToggleHeaderVisualIndicators();if(e(o)){o._toggleFocusableState(t);}return r;};d.prototype.setFitContent=function(f){var r=this.setProperty("fitContent",f,true);if(e(this.$())){this._updateFitContainer();}return r;};d.prototype.getScrollDelegate=function(){return this._oScrollHelper;};d.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._headerBiggerThanAllowedHeight=false;return;}this._headerBiggerThanAllowedHeight=true;if(this.getHeaderExpanded()){this._moveHeaderToContentArea(true);}else{this._adjustSnap();}this._updateScrollBar();};d.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed()&&this._preserveHeaderStateOnScroll();};d.prototype._toggleFooter=function(s){var f=this.getFooter();if(!e(this.$())){return;}if(!e(f)){return;}f.toggleStyleClass("sapFDynamicPageActualFooterControlShow",s);f.toggleStyleClass("sapFDynamicPageActualFooterControlHide",!s);this._toggleFooterSpacer(s);if(u){if(!s){q.sap.delayedCall(d.FOOTER_ANIMATION_DURATION,this,function(){this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());});}else{this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());}q.sap.delayedCall(d.FOOTER_ANIMATION_DURATION,this,function(){f.removeStyleClass("sapFDynamicPageActualFooterControlShow");});}this._updateScrollBar();};d.prototype._toggleFooterSpacer=function(t){var $=this.$("spacer");if(e($)){$.toggleClass("sapFDynamicPageContentWrapperSpacer",t);}if(e(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",t);}};d.prototype._toggleHeaderInTabChain=function(t){var o=this.getTitle(),f=this.getHeader();if(!e(o)||!e(f)){return;}f.$().css("visibility",t?"visible":"hidden");};d.prototype._snapHeader=function(A,U){var o=this.getTitle();if(this._bPinned){q.sap.log.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}q.sap.log.debug("DynamicPage :: snapped header",this);if(e(o)){o._toggleState(false,U);if(A&&this._bHeaderInTitleArea){this._moveHeaderToContentArea(true);}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.addClass("sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();}this._toggleHeaderInTabChain(false);};d.prototype._expandHeader=function(A,U){var o=this.getTitle();q.sap.log.debug("DynamicPage :: expand header",this);if(e(o)){o._toggleState(true,U);if(A){this._moveHeaderToTitleArea(true);}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.removeClass("sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();}this._toggleHeaderInTabChain(true);};d.prototype._toggleHeaderVisibility=function(s){var E=this.getHeaderExpanded(),o=this.getTitle(),f=this.getHeader();if(this._bPinned){q.sap.log.debug("DynamicPage :: header toggle aborted, header is pinned",this);return;}if(e(o)){o._toggleState(E);}if(e(f)){f.$().toggleClass("sapFDynamicPageHeaderHidden",!s);this._updateScrollBar();}this._toggleHeaderInTabChain(s);};d.prototype._moveHeaderToContentArea=function(o){var f=this.getHeader();if(e(f)){f.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;if(o){this._offsetContentOnMoveHeader();}}};d.prototype._moveHeaderToTitleArea=function(o){var f=this.getHeader();if(e(f)){f.$().appendTo(this.$titleArea);this._bHeaderInTitleArea=true;if(o){this._offsetContentOnMoveHeader();}}};d.prototype._offsetContentOnMoveHeader=function(){var o=Math.ceil(this._getHeaderHeight()),i=this._getScrollPosition(),n;if(!o){return;}n=this._bHeaderInTitleArea?i-o:i+o;n=Math.max(n,0);this._setScrollPosition(n,true);};d.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;if(!this._bHeaderInTitleArea){this._moveHeaderToTitleArea(true);this._updateScrollBar();}this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(e($)){$.addClass("sapFDynamicPageHeaderPinned");}};d.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(e($)){$.removeClass("sapFDynamicPageHeaderPinned");}};d.prototype._togglePinButtonVisibility=function(t){var o=this.getHeader();if(e(o)){o._setShowPinBtn(t);}};d.prototype._togglePinButtonPressedState=function(p){var o=this.getHeader();if(e(o)){o._togglePinButton(p);}};d.prototype._togglePinButtonARIAState=function(p){var o=this.getHeader();if(e(o)){o._updateARIAPinButtonState(p);}};d.prototype._resetPinButtonState=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false);}else{this._togglePinButtonPressedState(false);this._togglePinButtonARIAState(false);}};d.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};d.prototype._getScrollPosition=function(){return e(this.$wrapper)?Math.ceil(this.$wrapper.scrollTop()):0;};d.prototype._setScrollPosition=function(n,s){if(!e(this.$wrapper)){return;}if(this._getScrollPosition()===n){return;}if(s){this._bSuppressToggleHeaderOnce=true;}if(!this.getScrollDelegate()._$Container){this.getScrollDelegate()._$Container=this.$wrapper;}this.getScrollDelegate().scrollTo(0,n);};d.prototype._shouldSnap=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>=this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};d.prototype._shouldExpand=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned;};d.prototype._headerScrolledOut=function(){return this._getScrollPosition()>=this._getSnappingHeight();};d.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned;};d.prototype._canSnapHeaderOnScroll=function(){var m=this._getMaxScrollPosition(),t=this._bMSBrowser?1:0;if(this._bHeaderInTitleArea){m+=this._getHeaderHeight();m-=t;}return m>this._getSnappingHeight();};d.prototype._getSnappingHeight=function(){return Math.ceil(this._getHeaderHeight()||this._getTitleHeight());};d.prototype._getMaxScrollPosition=function(){var $;if(e(this.$wrapper)){$=this.$wrapper[0];return $.scrollHeight-$.clientHeight;}return 0;};d.prototype._needsVerticalScrollBar=function(){var t=this._bMSBrowser?1:0;return this._getMaxScrollPosition()>t;};d.prototype._getOwnHeight=function(){return this._getHeight(this);};d.prototype._getEntireHeaderHeight=function(){var t=0,H=0,o=this.getTitle(),f=this.getHeader();if(e(o)){t=o.$().outerHeight();}if(e(f)){H=f.$().outerHeight();}return t+H;};d.prototype._headerBiggerThanAllowedToPin=function(i){if(!(typeof i==="number"&&!isNaN(parseInt(i,10)))){i=this._getOwnHeight();}return this._getEntireHeaderHeight()>d.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*i;};d.prototype._headerBiggerThanAllowedToBeFixed=function(){var i=this._getOwnHeight();return this._getEntireHeaderHeight()>d.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*i;};d.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){var E=this._getEntireHeaderHeight(),i=this._getOwnHeight();return D.system.phone?E>=d.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE*i:E>=i;};d.prototype._measureScrollBarOffsetHeight=function(){var H=0,s=!this.getHeaderExpanded(),f=this._bHeaderInTitleArea;if(this._preserveHeaderStateOnScroll()||this._bPinned||(!s&&this._bHeaderInTitleArea)){H=this._getTitleAreaHeight();q.sap.log.debug("DynamicPage :: preserveHeaderState is enabled or header pinned :: title area height"+H,this);return H;}if(s||!e(this.getTitle())||!this._canSnapHeaderOnScroll()){H=this._getTitleHeight();q.sap.log.debug("DynamicPage :: header snapped :: title height "+H,this);return H;}this._snapHeader(true);H=this._getTitleHeight();if(!s){this._expandHeader(f);}q.sap.log.debug("DynamicPage :: snapped mode :: title height "+H,this);return H;};d.prototype._updateScrollBar=function(){var s,f,n;if(!D.system.desktop||!e(this.$wrapper)){return;}s=this._getScrollBar();s.setContentSize(this._measureScrollBarOffsetHeight()+this.$wrapper[0].scrollHeight+"px");f=this._needsVerticalScrollBar();n=this.bHasScrollbar!==f;if(n){s.toggleStyleClass("sapUiHidden",!f);this.toggleStyleClass("sapFDynamicPageWithScroll",f);this.bHasScrollbar=f;}q.sap.delayedCall(0,this,this._updateFitContainer);q.sap.delayedCall(0,this,this._updateScrollBarOffset);};d.prototype._updateFitContainer=function(n){var N=typeof n!=='undefined'?!n:!this._needsVerticalScrollBar(),f=this.getFitContent(),t=f||N;this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t);};d.prototype._updateScrollBarOffset=function(){var s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",o=this._needsVerticalScrollBar()?q.sap.scrollbarSize().width+"px":0,f=this.getFooter();this.$titleArea.css("padding-"+s,o);if(e(f)){f.$().css(s,o);}};d.prototype._updateHeaderARIAState=function(E){var o=this.getHeader();if(e(o)){o._updateARIAState(E);}};d.prototype._updateMedia=function(w){if(w===0){this._updateMediaStyle(d.MEDIA.INVISIBLE);}else if(w<=d.BREAK_POINTS.PHONE){this._updateMediaStyle(d.MEDIA.PHONE);}else if(w<=d.BREAK_POINTS.TABLET){this._updateMediaStyle(d.MEDIA.TABLET);}else{this._updateMediaStyle(d.MEDIA.DESKTOP);}};d.prototype._updateMediaStyle=function(s){Object.keys(d.MEDIA).forEach(function(m){var E=s===d.MEDIA[m];this.toggleStyleClass(d.MEDIA[m],E);},this);};d.prototype._toggleExpandVisualIndicator=function(t){var o=this.getTitle();if(e(o)){o._toggleExpandButton(t);}};d.prototype._focusExpandVisualIndicator=function(){var o=this.getTitle();if(e(o)){o._focusExpandButton();}};d.prototype._toggleCollapseVisualIndicator=function(t){var o=this.getHeader();if(e(o)){o._toggleCollapseButton(t);}};d.prototype._focusCollapseVisualIndicator=function(){var o=this.getHeader();if(e(o)){o._focusCollapseButton();}};d.prototype._updateToggleHeaderVisualIndicators=function(){var H,f,E,g=this._hasVisibleTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||this._bPinned||!g){f=false;E=false;}else{H=this.getHeaderExpanded();f=H;E=!H;}this._toggleCollapseVisualIndicator(f);this._toggleExpandVisualIndicator(E);};d.prototype._hasVisibleTitleAndHeader=function(){var t=this.getTitle(),H=this.getHeader();return e(t)&&t.getVisible()&&e(H)&&H.getVisible();};d.prototype._getHeight=function(o){var $;if(!(o instanceof C)){return 0;}$=o.getDomRef();return $?$.getBoundingClientRect().height:0;};d.prototype._getWidth=function(o){return!(o instanceof C)?0:o.$().outerWidth()||0;};d.prototype._getTitleAreaHeight=function(){return e(this.$titleArea)?this.$titleArea.outerHeight()||0:0;};d.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};d.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};d.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight;};d.prototype._getScrollBar=function(){if(!e(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};d.prototype._cacheDomElements=function(){var f=this.getFooter();if(e(f)){this.$footer=f.$();this.$footerWrapper=this.$("footerWrapper");}this.$wrapper=this.$("contentWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this._cacheTitleDom();};d.prototype._cacheTitleDom=function(){var t=this.getTitle();if(e(t)){this.$title=t.$();}};d.prototype._adjustSnap=function(){var o,i,f,I,$=this.$();if(!e($)){return;}if(!h($[0])){return;}o=this.getHeader();i=!this.getHeaderExpanded();if(!o||!i){return;}f=!this._preserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();I=i&&o.$().hasClass("sapFDynamicPageHeaderHidden");if(f&&I){this._toggleHeaderVisibility(true);this._moveHeaderToContentArea(true);}else if(!f&&!I){this._moveHeaderToTitleArea(true);this._toggleHeaderVisibility(false);}};d.prototype.ontouchmove=function(E){E.setMarked();};d.prototype._onChildControlAfterRendering=function(E){if(E.srcControl instanceof b){this._cacheTitleDom();this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(d.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this));}q.sap.delayedCall(0,this,this._updateScrollBar);};d.prototype._onChildControlsHeightChange=function(){var n=this._needsVerticalScrollBar();if(n){this._updateFitContainer(n);}this._adjustSnap();if(!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;};d.prototype._onResize=function(E){var o=this.getTitle(),f=this.getHeader(),i=E.size.width;if(!this._preserveHeaderStateOnScroll()&&f){if(this._headerBiggerThanAllowedToPin(E.size.height)||D.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false);}else{this._togglePinButtonVisibility(true);}}if(e(o)){o._onResize(i);}this._adjustSnap();this._updateScrollBar();this._updateMedia(i);};d.prototype._onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(D.system.desktop){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(s);this.toggleStyleClass("sapFDynamicPageWithScroll",this._needsVerticalScrollBar());}};d.prototype._toggleHeaderOnScroll=function(){if(this._bSuppressToggleHeaderOnce){this._bSuppressToggleHeaderOnce=false;return;}if(D.system.desktop&&this._bExpandingWithAClick){return;}if(this._preserveHeaderStateOnScroll()){return;}if(this._shouldSnap()){this._snapHeader(true,true);this._updateHeaderARIAState(false);}else if(this._shouldExpand()){this._expandHeader(false,true);this._toggleHeaderVisibility(true);this._updateHeaderARIAState(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){var f=(this._getScrollPosition()>=this._getSnappingHeight());this._moveHeaderToContentArea(f);}};d.prototype._onScrollBarScroll=function(){if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this._setScrollPosition(this._getScrollBar().getScrollPosition());};d.prototype._onTitlePress=function(){if(this.getToggleHeaderOnTitleClick()){this._titleExpandCollapseWhenAllowed(true);}};d.prototype._onExpandHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusCollapseVisualIndicator();};d.prototype._onCollapseHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusExpandVisualIndicator();};d.prototype._onVisualIndicatorMouseOver=function(){var $=this.$();if(e($)){$.addClass("sapFDynamicPageTitleForceHovered");}};d.prototype._onVisualIndicatorMouseOut=function(){var $=this.$();if(e($)){$.removeClass("sapFDynamicPageTitleForceHovered");}};d.prototype._onTitleMouseOver=d.prototype._onVisualIndicatorMouseOver;d.prototype._onTitleMouseOut=d.prototype._onVisualIndicatorMouseOut;d.prototype._titleExpandCollapseWhenAllowed=function(U){if(this._bPinned){return this;}var A;this._detachScrollHandler();if(this._preserveHeaderStateOnScroll()||!this._canSnapHeaderOnScroll()||!this.getHeader()){if(!this.getHeaderExpanded()){this._expandHeader(false,U);this._toggleHeaderVisibility(true);}else{this._snapHeader(false,U);this._toggleHeaderVisibility(false);}}else if(!this.getHeaderExpanded()){A=!this._headerBiggerThanAllowedToBeExpandedInTitleArea();this._bExpandingWithAClick=true;this._expandHeader(A,U);if(!A){this._setScrollPosition(0);}this._bExpandingWithAClick=false;}else{var m=this._bHeaderInTitleArea;this._snapHeader(m,U);if(!m){this._setScrollPosition(this._getSnappingHeight());}}q.sap.delayedCall(0,this,this._attachScrollHandler);};d.prototype._onPinUnpinButtonPress=function(E){if(this._bPinned){this._unPin(E);}else{this._pin(E);this._restorePinButtonFocus();}};d.prototype._attachResizeHandlers=function(){var f=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(d.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(e(this.$title)){this._registerResizeHandler(d.RESIZE_HANDLER_ID.TITLE,this.$title[0],f);}if(e(this.$contentFitContainer)){this._registerResizeHandler(d.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],f);}};d.prototype._registerResizeHandler=function(H,o,f){if(!this[H]){this[H]=R.register(o,f);}};d.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.CONTENT);};d.prototype._deRegisterResizeHandler=function(H){if(this[H]){R.deregister(this[H]);this[H]=null;}};d.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),H=this.getHeader(),o=this.getContent(),p={onAfterRendering:this._onChildControlAfterRendering.bind(this)};if(e(t)){t.addEventDelegate(p);}if(e(o)){o.addEventDelegate(p);}if(e(H)){H.addEventDelegate(p);}};d.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(d.EVENTS.TITLE_PRESS,this._onTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};d.prototype._attachPinPressHandler=function(){var H=this.getHeader();if(e(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(d.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};d.prototype._attachVisualIndicatorsPressHandlers=function(){var t=this.getTitle(),H=this.getHeader();if(e(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(d.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,this._onExpandHeaderVisualIndicatorPress,this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(e(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(d.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress,this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};d.prototype._attachVisualIndicatorMouseOverHandlers=function(){var H=this.getHeader();if(e(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(d.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver,this);H.attachEvent(d.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut,this);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};d.prototype._attachTitleMouseOverHandlers=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(d.EVENTS.TITLE_MOUSE_OVER,this._onTitleMouseOver,this);t.attachEvent(d.EVENTS.TITLE_MOUSE_OUT,this._onTitleMouseOut,this);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};d.prototype._attachScrollHandler=function(){this._onWrapperScrollReference=this._onWrapperScroll.bind(this);this._toggleHeaderOnScrollReference=this._toggleHeaderOnScroll.bind(this);this.$wrapper.on("scroll",this._onWrapperScrollReference);this.$wrapper.on("scroll",this._toggleHeaderOnScrollReference);};d.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.off("scroll",this._onWrapperScrollReference);this.$wrapper.off("scroll",this._toggleHeaderOnScrollReference);}};return d;});
