/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/m/library","sap/m/Button","sap/m/NavContainer","./FlexibleColumnLayoutRenderer","jquery.sap.events"],function(q,l,D,R,C,m,B,N,F){"use strict";var L=l.LayoutType;var a=C.extend("sap.f.FlexibleColumnLayout",{metadata:{properties:{layout:{type:"sap.f.LayoutType",defaultValue:L.OneColumn},defaultTransitionNameBeginColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMidColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameEndColumn:{type:"string",group:"Appearance",defaultValue:"slide"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:m.BackgroundDesign.Transparent}},aggregations:{beginColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getBeginColumn",aggregation:"pages"}},midColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getMidColumn",aggregation:"pages"}},endColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getEndColumn",aggregation:"pages"}},_beginColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_midColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_endColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_beginColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_endColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{initialBeginColumnPage:{type:"sap.ui.core.Control",multiple:false},initialMidColumnPage:{type:"sap.ui.core.Control",multiple:false},initialEndColumnPage:{type:"sap.ui.core.Control",multiple:false}},events:{stateChange:{parameters:{layout:{type:"sap.f.LayoutType"},maxColumnsCount:{type:"int"},isNavigationArrow:{type:"boolean"},isResize:{type:"boolean"}}},beginColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterBeginColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},midColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMidColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},endColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterEndColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});a.prototype.init=function(){this._initNavContainers();this._initButtons();this._oLayoutHistory=new b();};a.prototype._createNavContainer=function(c){var s=c.charAt(0).toUpperCase()+c.slice(1);return new N(this.getId()+"-"+c+"ColumnNav",{navigate:function(e){this._handleNavigationEvent(e,false,c);}.bind(this),afterNavigate:function(e){this._handleNavigationEvent(e,true,c);}.bind(this),defaultTransitionName:this["getDefaultTransitionName"+s+"Column"]()});};a.prototype._handleNavigationEvent=function(e,A,c){var E,d;if(A){E="after"+(c.charAt(0).toUpperCase()+c.slice(1))+"ColumnNavigate";}else{E=c+"ColumnNavigate";}d=this.fireEvent(E,e.mParameters,true);if(!d){e.preventDefault();}};a.prototype._getBeginColumn=function(){return this.getAggregation("_beginColumnNav");};a.prototype._getMidColumn=function(){return this.getAggregation("_midColumnNav");};a.prototype._getEndColumn=function(){return this.getAggregation("_endColumnNav");};a.prototype._flushColumnContent=function(c){var o=this.getAggregation("_"+c+"ColumnNav"),r=sap.ui.getCore().createRenderManager();r.renderControl(o);r.flush(this._$columns[c].find(".sapFFCLColumnContent")[0],undefined,true);r.destroy();};a.prototype.setLayout=function(n){n=this.validateProperty("layout",n);var c=this.getLayout();if(c===n){return this;}var r=this.setProperty("layout",n,true);this._oLayoutHistory.addEntry(n);this._resizeColumns();this._hideShowArrows();return r;};a.prototype.setBackgroundDesign=function(n){n=this.validateProperty("backgroundDesign",n);var c=this.getBackgroundDesign();if(c===n){return this;}var r=this.setProperty("backgroundDesign",n,true);if(c!==m.BackgroundDesign.Transparent){this.$().removeClass("sapFFCLBackgroundDesign"+c);}if(n!==m.BackgroundDesign.Transparent){this.$().addClass("sapFFCLBackgroundDesign"+n);}return r;};a.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();};a.prototype.onAfterRendering=function(){this._registerResizeHandler();this._cacheDOMElements();this._hideShowArrows();this._resizeColumns();this._flushColumnContent("begin");this._flushColumnContent("mid");this._flushColumnContent("end");this._fireStateChange(false,false);};a.prototype._getControlWidth=function(){return this.$().width();};a.prototype.exit=function(){this._deregisterResizeHandler();this._handleEvent(q.Event("Destroy"));};a.prototype._registerResizeHandler=function(){this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};a.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};a.prototype._initNavContainers=function(){this.setAggregation("_beginColumnNav",this._createNavContainer("begin"),true);this.setAggregation("_midColumnNav",this._createNavContainer("mid"),true);this.setAggregation("_endColumnNav",this._createNavContainer("end"),true);};a.prototype._initButtons=function(){var o=new B(this.getId()+"-beginBack",{icon:"sap-icon://slim-arrow-left",tooltip:a._getResourceBundle().getText("FCL_BEGIN_COLUMN_BACK_ARROW"),press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_beginColumnBackArrow",o,true);var M=new B(this.getId()+"-midForward",{icon:"sap-icon://slim-arrow-right",tooltip:a._getResourceBundle().getText("FCL_MID_COLUMN_FORWARD_ARROW"),press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_midColumnForwardArrow",M,true);var c=new B(this.getId()+"-midBack",{icon:"sap-icon://slim-arrow-left",tooltip:a._getResourceBundle().getText("FCL_MID_COLUMN_BACK_ARROW"),press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_midColumnBackArrow",c,true);var e=new B(this.getId()+"-endForward",{icon:"sap-icon://slim-arrow-right",tooltip:a._getResourceBundle().getText("FCL_END_COLUMN_FORWARD_ARROW"),press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_endColumnForwardArrow",e,true);};a.prototype._cacheDOMElements=function(){this._cacheColumns();if(!D.system.phone){this._cacheArrows();}};a.prototype._cacheColumns=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")};};a.prototype._cacheArrows=function(){this._$columnButtons={beginBack:this.$("beginBack"),midForward:this.$("midForward"),midBack:this.$("midBack"),endForward:this.$("endForward")};};a.prototype._getVisibleColumnsCount=function(){return["begin","mid","end"].filter(function(c){return this._getColumnSize(c)>0;},this).length;};a.prototype._resizeColumns=function(){var p,n,s,t,A,c=false,d=["begin","mid","end"],r=sap.ui.getCore().getConfiguration().getRTL(),e,v;if(!this.isActive()){return;}v=this._getVisibleColumnsCount();if(v===0){return;}t=(v-1)*a.COLUMN_MARGIN;A=this._getControlWidth()-t;d.forEach(function(f){p=this._getColumnSize(f);this._$columns[f].toggleClass("sapFFCLColumnMargin",c&&p>0);this._$columns[f].toggleClass("sapFFCLColumnActive",p>0);this._$columns[f].removeClass("sapFFCLColumnOnlyActive");this._$columns[f].removeClass("sapFFCLColumnLastActive");this._$columns[f].removeClass("sapFFCLColumnFirstActive");n=Math.round(A*(p/100));if([100,0].indexOf(p)!==-1){s=p+"%";}else{s=n+"px";}this._$columns[f].width(s);if(!D.system.phone){this._updateColumnContextualSettings(f,n);this._updateColumnCSSClasses(f,n);}if(p>0){c=true;}},this);e=d.filter(function(f){return this._getColumnSize(f)>0;},this);if(r){d.reverse();}if(e.length===1){this._$columns[e[0]].addClass("sapFFCLColumnOnlyActive");}if(e.length>1){this._$columns[e[0]].addClass("sapFFCLColumnFirstActive");this._$columns[e[e.length-1]].addClass("sapFFCLColumnLastActive");}};a.prototype._propagateContextualSettings=function(){};a.prototype._updateColumnContextualSettings=function(c,w){var o,d;o=this.getAggregation("_"+c+"ColumnNav");if(!o){return;}d=o._getContextualSettings();if(!d||d.contextualWidth!==w){o._applyContextualSettings({contextualWidth:w});}};a.prototype._updateColumnCSSClasses=function(c,w){var n="";this._$columns[c].removeClass("sapUiContainer-Narrow sapUiContainer-Medium sapUiContainer-Wide sapUiContainer-ExtraWide");if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0]){n="Narrow";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1]){n="Medium";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2]){n="Wide";}else{n="ExtraWide";}this._$columns[c].addClass("sapUiContainer-"+n);};a.prototype._getColumnSize=function(c){var s=this.getLayout(),d=this._getColumnWidthDistributionForLayout(s),S=d.split("/"),M={begin:0,mid:1,end:2},e=S[M[c]];return parseInt(e,10);};a.prototype.getMaxColumnsCount=function(){return this._getMaxColumnsCountForWidth(this._getControlWidth());};a.prototype._getMaxColumnsCountForWidth=function(w){if(w>=a.DESKTOP_BREAKPOINT){return 3;}if(w>=a.TABLET_BREAKPOINT&&w<a.DESKTOP_BREAKPOINT){return 2;}if(w>0){return 1;}return 0;};a.prototype._onResize=function(e){var o=e.oldSize.width,n=e.size.width,O,M;if(n===0){return;}O=this._getMaxColumnsCountForWidth(o);M=this._getMaxColumnsCountForWidth(n);this._resizeColumns();if(M!==O){this._hideShowArrows();this._fireStateChange(false,true);}};a.prototype._onArrowClick=function(s){var c=this.getLayout(),i=typeof a.SHIFT_TARGETS[c]!=="undefined"&&typeof a.SHIFT_TARGETS[c][s]!=="undefined",n;n=i?a.SHIFT_TARGETS[c][s]:L.OneColumn;this.setLayout(n);if(a.ARROWS_NAMES[n][s]!==a.ARROWS_NAMES[c][s]&&i){var o=s==='right'?'left':'right';this._$columnButtons[a.ARROWS_NAMES[n][o]].focus();}this._fireStateChange(true,false);};a.prototype._hideShowArrows=function(){var s=this.getLayout(),M={},n=[],i;if(!this.isActive()||D.system.phone){return;}i=this.getMaxColumnsCount();if(i>1){M[L.TwoColumnsBeginExpanded]=["beginBack"];M[L.TwoColumnsMidExpanded]=["midForward"];M[L.ThreeColumnsMidExpanded]=["midForward","midBack"];M[L.ThreeColumnsEndExpanded]=["endForward"];M[L.ThreeColumnsMidExpandedEndHidden]=["midForward","midBack"];M[L.ThreeColumnsBeginExpandedEndHidden]=["beginBack"];if(typeof M[s]==="object"){n=M[s];}}this._toggleButton("beginBack",n.indexOf("beginBack")!==-1);this._toggleButton("midForward",n.indexOf("midForward")!==-1);this._toggleButton("midBack",n.indexOf("midBack")!==-1);this._toggleButton("endForward",n.indexOf("endForward")!==-1);};a.prototype._toggleButton=function(s,S){this._$columnButtons[s].toggle(S);};a.prototype._fireStateChange=function(i,I){if(this._getControlWidth()===0){return;}this.fireStateChange({isNavigationArrow:i,isResize:I,layout:this.getLayout(),maxColumnsCount:this.getMaxColumnsCount()});};a.prototype.setInitialBeginColumnPage=function(p){this._getBeginColumn().setInitialPage(p);this.setAssociation('initialBeginColumnPage',p,true);return this;};a.prototype.setInitialMidColumnPage=function(p){this._getMidColumn().setInitialPage(p);this.setAssociation('initialMidColumnPage',p,true);return this;};a.prototype.setInitialEndColumnPage=function(p){this._getEndColumn().setInitialPage(p);this.setAssociation('initialEndColumnPage',p,true);return this;};a.prototype.to=function(p,t,d,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().to(p,t,d,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().to(p,t,d,T);}else{this._getEndColumn().to(p,t,d,T);}return this;};a.prototype.backToPage=function(p,o,t){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().backToPage(p,o,t);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().backToPage(p,o,t);}else{this._getEndColumn().backToPage(p,o,t);}return this;};a.prototype._safeBackToPage=function(p,t,c,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn()._safeBackToPage(p,t,c,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn()._safeBackToPage(p,t,c,T);}else{this._getEndColumn()._safeBackToPage(p,t,c,T);}};a.prototype.toBeginColumnPage=function(p,t,d,T){this._getBeginColumn().to(p,t,d,T);return this;};a.prototype.toMidColumnPage=function(p,t,d,T){this._getMidColumn().to(p,t,d,T);return this;};a.prototype.toEndColumnPage=function(p,t,d,T){this._getEndColumn().to(p,t,d,T);return this;};a.prototype.backBeginColumn=function(c,t){return this._getBeginColumn().back(c,t);};a.prototype.backMidColumn=function(c,t){return this._getMidColumn().back(c,t);};a.prototype.backEndColumn=function(c,t){return this._getEndColumn().back(c,t);};a.prototype.backBeginColumnToPage=function(p,c,t){return this._getBeginColumn().backToPage(p,c,t);};a.prototype.backMidColumnToPage=function(p,c,t){return this._getMidColumn().backToPage(p,c,t);};a.prototype.backEndColumnToPage=function(p,c,t){return this._getEndColumn().backToPage(p,c,t);};a.prototype.backToTopBeginColumn=function(o,t){this._getBeginColumn().backToTop(o,t);return this;};a.prototype.backToTopMidColumn=function(o,t){this._getMidColumn().backToTop(o,t);return this;};a.prototype.backToTopEndColumn=function(o,t){this._getEndColumn().backToTop(o,t);return this;};a.prototype.getCurrentBeginColumnPage=function(){return this._getBeginColumn().getCurrentPage();};a.prototype.getCurrentMidColumnPage=function(){return this._getMidColumn().getCurrentPage();};a.prototype.getCurrentEndColumnPage=function(){return this._getEndColumn().getCurrentPage();};a.prototype.setDefaultTransitionNameBeginColumn=function(t){this.setProperty("defaultTransitionNameBeginColumn",t,true);this._getBeginColumn().setDefaultTransitionName(t);return this;};a.prototype.setDefaultTransitionNameMidColumn=function(t){this.setProperty("defaultTransitionNameMidColumn",t,true);this._getMidColumn().setDefaultTransitionName(t);return this;};a.prototype.setDefaultTransitionNameEndColumn=function(t){this.setProperty("defaultTransitionNameEndColumn",t,true);this._getEndColumn().setDefaultTransitionName(t);return this;};a.prototype._getLayoutHistory=function(){return this._oLayoutHistory;};a.prototype._getColumnWidthDistributionForLayout=function(s,A){var M=this.getMaxColumnsCount(),o={},r;if(M===0){r="0/0/0";}else{o[L.OneColumn]="100/0/0";o[L.MidColumnFullScreen]="0/100/0";o[L.EndColumnFullScreen]="0/0/100";if(M===1){o[L.TwoColumnsBeginExpanded]="0/100/0";o[L.TwoColumnsMidExpanded]="0/100/0";o[L.ThreeColumnsMidExpanded]="0/0/100";o[L.ThreeColumnsEndExpanded]="0/0/100";o[L.ThreeColumnsMidExpandedEndHidden]="0/0/100";o[L.ThreeColumnsBeginExpandedEndHidden]="0/0/100";}else{o[L.TwoColumnsBeginExpanded]="67/33/0";o[L.TwoColumnsMidExpanded]="33/67/0";o[L.ThreeColumnsMidExpanded]=M===2?"0/67/33":"25/50/25";o[L.ThreeColumnsEndExpanded]=M===2?"0/33/67":"25/25/50";o[L.ThreeColumnsMidExpandedEndHidden]="33/67/0";o[L.ThreeColumnsBeginExpandedEndHidden]="67/33/0";}r=o[s];}if(A){r=r.split("/").map(function(c){return parseInt(c,10);});}return r;};a.COLUMN_MARGIN=8;a.DESKTOP_BREAKPOINT=1280;a.TABLET_BREAKPOINT=960;a.ARROWS_NAMES={TwoColumnsBeginExpanded:{"left":"beginBack"},TwoColumnsMidExpanded:{"right":"midForward"},ThreeColumnsMidExpanded:{"left":"midBack","right":"midForward"},ThreeColumnsEndExpanded:{"right":"endForward"},ThreeColumnsMidExpandedEndHidden:{"left":"midBack","right":"midForward"},ThreeColumnsBeginExpandedEndHidden:{"left":"beginBack"}};a._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};a.SHIFT_TARGETS={TwoColumnsBeginExpanded:{"left":L.TwoColumnsMidExpanded},TwoColumnsMidExpanded:{"right":L.TwoColumnsBeginExpanded},ThreeColumnsMidExpanded:{"left":L.ThreeColumnsEndExpanded,"right":L.ThreeColumnsMidExpandedEndHidden},ThreeColumnsEndExpanded:{"right":L.ThreeColumnsMidExpanded},ThreeColumnsMidExpandedEndHidden:{"left":L.ThreeColumnsMidExpanded,"right":L.ThreeColumnsBeginExpandedEndHidden},ThreeColumnsBeginExpandedEndHidden:{"left":L.ThreeColumnsMidExpandedEndHidden}};function b(){this._aLayoutHistory=[];}b.prototype.addEntry=function(s){if(typeof s!=="undefined"){this._aLayoutHistory.push(s);}};b.prototype.getClosestEntryThatMatches=function(c){var i;for(i=this._aLayoutHistory.length-1;i>=0;i--){if(c.indexOf(this._aLayoutHistory[i])!==-1){return this._aLayoutHistory[i];}}};return a;});
