/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/dnd/DragDropInfo','./IconTabBarDragAndDropUtil','./IconTabBarSelectListRenderer'],function(q,l,C,I,D,a,b){"use strict";var c=C.extend("sap.m.IconTabBarSelectList",{metadata:{library:"sap.m",aggregations:{items:{type:"sap.m.IconTabFilter",multiple:true,singularName:"item"},dragDropConfig:{name:"dragDropConfig",type:"sap.ui.core.dnd.DragDropInfo",multiple:true}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.m.IconTabFilter"}}}}}});c.prototype.init=function(){this._itemNavigation=new I();this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);this._itemNavigation.setPageSize(10);};c.prototype.exit=function(){if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}};c.prototype.onAfterRendering=function(){this._initItemNavigation();};c.prototype.onBeforeRendering=function(){if(!this._iconTabHeader){return;}if(!this._iconTabHeader.getEnableTabReordering()&&this.getDragDropConfig().length){this.destroyDragDropConfig();}else if(this._iconTabHeader.getEnableTabReordering()&&!this.getDragDropConfig().length){var d=new D({sourceAggregation:"items",targetAggregation:"items",dropPosition:"Between",dragEnter:this._visualizeIndicator.bind(this),drop:this._handleDragAndDrop.bind(this)});this.addAggregation("dragDropConfig",d,true);}};c.prototype._initItemNavigation=function(){var d,e=this.getItems(),f=[];for(var i=0;i<e.length;i++){d=e[i];f.push(d.getDomRef());}this._itemNavigation.setRootDomRef(this.getDomRef());this._itemNavigation.setItemDomRefs(f);};c.prototype.getVisibleItems=function(){var d=this.getItems(),v=[],e;for(var i=0;i<d.length;i++){e=d[i];if(e.getVisible()){v.push(e);}}return v;};c.prototype.setSelectedItem=function(i){if(this._selectedItem){this._deselectItem(this._selectedItem);}if(i){this._selectItem(i);}this._selectedItem=i;};c.prototype.getSelectedItem=function(){return this._selectedItem;};c.prototype._deselectItem=function(i){var $=i.$();if($){$.removeClass('sapMITBSelectItemSelected');$.removeAttr('aria-selected');}};c.prototype._selectItem=function(i){var $=i.$();if($){$.addClass('sapMITBSelectItemSelected');$.attr('aria-selected',true);}};c.prototype.ontap=function(e){var $=q(e.target);if(!$.hasClass('sapMITBSelectItem')){$=$.parent(".sapMITBSelectItem");}var s=sap.ui.getCore().byId($[0].id);if(s&&s.getEnabled()){e.preventDefault();if(s!=this.getSelectedItem()){this._selectItem(s);this.fireSelectionChange({selectedItem:s});}}if(this._iconTabHeader){this._iconTabHeader._closeOverflow();}};c.prototype.onsapenter=c.prototype.ontap;c.prototype.onsapspace=c.prototype.ontap;c.prototype.checkIconOnly=function(d){var e,f=d.length;for(var i=0;i<f;i++){e=d[i];if(e.getText()||e.getCount()){return false;}}return true;};c.prototype._handleDragAndDrop=function(e){var d=e.getParameter("dropPosition"),o=e.getParameter("draggedControl"),f=e.getParameter("droppedControl");a.handleDrop.call(this._iconTabHeader,d,o._tabFilter,f._tabFilter);this._iconTabHeader._initItemNavigation();a.handleDrop.call(this,d,o,f);this._initItemNavigation();o.$().focus();};c.prototype._visualizeIndicator=function(e){var i=e.getParameter("dragSession").getIndicator();if(i){i.style.zIndex=100;}};c.prototype.ondragrearranging=function(e){if(!this._iconTabHeader.getEnableTabReordering()){return;}var t=sap.ui.getCore().byId(e.target.id),k=e.keyCode;a.moveItem.call(this,t,k);this._initItemNavigation();t.$().focus();this._iconTabHeader._moveTab(t._tabFilter,k);};c.prototype.onsaphomemodifiers=c.prototype.ondragrearranging;c.prototype.onsapendmodifiers=c.prototype.ondragrearranging;c.prototype.onsapincreasemodifiers=c.prototype.ondragrearranging;c.prototype.onsapdecreasemodifiers=c.prototype.ondragrearranging;return c;});
