/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./GroupHeaderListItem','./ListItemBase','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/core/LabelEnablement','sap/ui/Device','sap/m/GrowingEnablement','./ListBaseRenderer','jquery.sap.keycodes'],function(q,G,L,l,C,I,a,b,D,c,d){"use strict";var f=l.ListType;var g=l.ListKeyboardMode;var h=l.ListGrowingDirection;var S=l.SwipeDirection;var j=l.ListSeparators;var k=l.ListMode;var m=l.ListHeaderDesign;var n=C.extend("sap.m.ListBase",{metadata:{library:"sap.m",properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:m.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:k.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:j.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:S.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},growingDirection:{type:"sap.m.ListGrowingDirection",group:"Behavior",defaultValue:h.Downwards},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:g.Navigation}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable"},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},dragDropConfig:{name:"dragDropConfig",type:"sap.ui.core.dnd.DragDropBase",multiple:true,singularName:"dragDropConfig"},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},"delete":{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}}},designtime:"sap/m/designtime/ListBase.designtime"}});n.prototype.bAnnounceDetails=true;n.getInvisibleText=function(){return this.oInvisibleText||(this.oInvisibleText=new a().toStatic());};n.prototype.sNavItemClass="sapMLIB";n.prototype.init=function(){this._aNavSections=[];this._aSelectedPaths=[];this._iItemNeedsHighlight=0;this.data("sap-ui-fastnavgroup","true",true);};n.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent();};n.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();if(D.system.desktop){this._bItemNavigationInvalidated=true;}};n.prototype.exit=function(){this._oSelectedItem=null;this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation();};n.prototype.refreshItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(r);}else{if(!this._bReceivingData){this._updateStarted(r);this._bReceivingData=true;}this.refreshAggregation("items");}};n.prototype.updateItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(r);}else{if(this._bReceivingData){this._bReceivingData=false;}else{this._updateStarted(r);}this.updateAggregation("items");this._updateFinished();}};n.prototype.setBindingContext=function(){this._resetItemsBinding();return C.prototype.setBindingContext.apply(this,arguments);};n.prototype._bindAggregation=function(N,B){function e(B,E,H){B.events=B.events||{};if(!B.events[E]){B.events[E]=H;}else{var o=B.events[E];B.events[E]=function(){H.apply(this,arguments);o.apply(this,arguments);};}}if(N==="items"){this._resetItemsBinding();e(B,"dataRequested",this._onBindingDataRequestedListener.bind(this));e(B,"dataReceived",this._onBindingDataReceivedListener.bind(this));}C.prototype._bindAggregation.call(this,N,B);};n.prototype._onBindingDataRequestedListener=function(e){this._showBusyIndicator();if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};n.prototype._onBindingDataReceivedListener=function(e){if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){this._hideBusyIndicator();delete this._dataReceivedHandlerId;});};n.prototype.destroyItems=function(s){if(!this.getItems(true).length){return this;}this._oSelectedItem=null;this.destroyAggregation("items","KeepDom");if(!s){this.invalidate();}return this;};n.prototype.removeAllItems=function(A){this._oSelectedItem=null;return this.removeAllAggregation("items");};n.prototype.removeItem=function(i){var o=this.removeAggregation("items",i);if(o&&o===this._oSelectedItem){this._oSelectedItem=null;}return o;};n.prototype.getItems=function(r){if(r){return this.mAggregations["items"]||[];}return this.getAggregation("items",[]);};n.prototype.getId=function(s){var i=this.sId;return s?i+"-"+s:i;};n.prototype.setGrowing=function(e){e=!!e;if(this.getGrowing()!=e){this.setProperty("growing",e,!e);if(e){this._oGrowingDelegate=new c(this);}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}}return this;};n.prototype.setGrowingThreshold=function(t){return this.setProperty("growingThreshold",t,true);};n.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(!this.getEnableBusyIndicator()){this._hideBusyIndicator();}return this;};n.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);this.$("nodata-text").text(this.getNoDataText());return this;};n.prototype.getNoDataText=function(e){if(e&&this._bBusy){return"";}var N=this.getProperty("noDataText");N=N||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_NO_DATA");return N;};n.prototype.getSelectedItem=function(){var e=this.getItems(true);for(var i=0;i<e.length;i++){if(e[i].getSelected()){return e[i];}}return null;};n.prototype.setSelectedItem=function(o,s,F){if(this.indexOfItem(o)<0){q.sap.log.warning("setSelectedItem is called without valid ListItem parameter on "+this);return;}if(this._bSelectionMode){o.setSelected((s===undefined)?true:!!s);F&&this._fireSelectionChangeEvent([o]);}};n.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(i){return i.getSelected();});};n.prototype.setSelectedItemById=function(i,s){var o=sap.ui.getCore().byId(i);return this.setSelectedItem(o,s);};n.prototype.getSelectedContexts=function(A){var B=this.getBindingInfo("items"),M=(B||{}).model,o=this.getModel(M);if(!B||!o){return[];}if(A&&this.getRememberSelections()){return this._aSelectedPaths.map(function(p){return o.getContext(p);});}return this.getSelectedItems().map(function(i){return i.getBindingContext(M);});};n.prototype.removeSelections=function(A,F,e){var i=[];this._oSelectedItem=null;A&&(this._aSelectedPaths=[]);this.getItems(true).forEach(function(o){if(!o.getSelected()){return;}if(e&&o.isSelectedBoundTwoWay()){return;}o.setSelected(false,true);i.push(o);!A&&this._updateSelectedPaths(o);},this);if(F&&i.length){this._fireSelectionChangeEvent(i);}return this;};n.prototype.selectAll=function(F){if(this.getMode()!="MultiSelect"){return this;}var e=[];this.getItems(true).forEach(function(i){if(!i.getSelected()){i.setSelected(true,true);e.push(i);this._updateSelectedPaths(i);}},this);if(F&&e.length){this._fireSelectionChangeEvent(e,F);}return this;};n.prototype.getLastMode=function(M){return this._sLastMode;};n.prototype.setMode=function(M){M=this.validateProperty("mode",M);var o=this.getMode();if(o==M){return this;}this._bSelectionMode=M.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true);}else{var s=this.getSelectedItems();if(s.length>1){this.removeSelections(true);}else if(o===k.MultiSelect){this._oSelectedItem=s[0];}}return this.setProperty("mode",M);};n.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null;};n.prototype.setRememberSelections=function(r){this.setProperty("rememberSelections",r,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this;};n.prototype.setSelectedContextPaths=function(s){this._aSelectedPaths=s||[];};n.prototype.getSelectedContextPaths=function(A){if(!A||(A&&this.getRememberSelections())){return this._aSelectedPaths.slice(0);}return this.getSelectedItems().map(function(i){return i.getBindingContextPath();});};n.prototype.isAllSelectableSelected=function(){if(this.getMode()!=k.MultiSelect){return false;}var i=this.getItems(true),s=this.getSelectedItems().length,e=i.filter(function(o){return o.isSelectable();}).length;return(i.length>0)&&(s==e);};n.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(i){return i.getVisible();});};n.prototype.getActiveItem=function(){return this._bActiveItem;};n.prototype.onItemDOMUpdate=function(o){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true);}};n.prototype.onItemActiveChange=function(o,A){this._bActiveItem=A;};n.prototype.onItemHighlightChange=function(i,N){this._iItemNeedsHighlight+=(N?1:-1);if(this._iItemNeedsHighlight==1&&N){this.$("listUl").addClass("sapMListHighlight");}else if(this._iItemNeedsHighlight==0){this.$("listUl").removeClass("sapMListHighlight");}};n.prototype.onItemSelectedChange=function(o,s){if(this.getMode()==k.MultiSelect){this._updateSelectedPaths(o,s);return;}if(s){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=o;}else if(this._oSelectedItem===o){this._oSelectedItem=null;}this._updateSelectedPaths(o,s);};n.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl");};n.prototype.checkGrowingFromScratch=function(){};n.prototype.onBeforePageLoaded=function(o,s){this._fireUpdateStarted(s,o);this.fireGrowingStarted(o);};n.prototype.onAfterPageLoaded=function(o,s){this._fireUpdateFinished(o);this.fireGrowingFinished(o);};n.prototype.addNavSection=function(i){this._aNavSections.push(i);return i;};n.prototype.getMaxItemsCount=function(){var B=this.getBinding("items");if(B&&B.getLength){return B.getLength()||0;}return this.getItems(true).length;};n.prototype.shouldRenderItems=function(){return true;};n.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation){this._oItemNavigation.iFocusedIndex=-1;}}};n.prototype._updateStarted=function(r){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(r);}};n.prototype._fireUpdateStarted=function(r,i){this._sUpdateReason=q.sap.charToUpperCase(r||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});};n.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false;}};n.prototype._fireUpdateFinished=function(i){this._hideBusyIndicator();q.sap.delayedCall(0,this,function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});});};n.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this._sBusyTimer=q.sap.delayedCall(this.getBusyIndicatorDelay(),this,function(){this.$("nodata-text").text("");});this.setBusy(true,"listUl");}};n.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;this.setBusy(false,"listUl");q.sap.clearDelayedCall(this._sBusyTimer);if(!this.getItems(true).length){this.$("nodata-text").text(this.getNoDataText());}}};n.prototype.onItemBindingContextSet=function(i){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return;}if(i.isSelectedBoundTwoWay()){return;}var p=i.getBindingContextPath();if(p){var s=(this._aSelectedPaths.indexOf(p)>-1);i.setSelected(s);}};n.prototype.onItemInserted=function(i,s){if(s){this.onItemSelectedChange(i,true);}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||i.isSelectedBoundTwoWay()||i.getSelected()){return;}var p=i.getBindingContextPath();if(p&&this._aSelectedPaths.indexOf(p)>-1){i.setSelected(true);}};n.prototype.onItemSelect=function(o,s){if(this.getMode()==k.MultiSelect){this._fireSelectionChangeEvent([o]);}else if(this._bSelectionMode&&s){this._fireSelectionChangeEvent([o]);}};n.prototype._fireSelectionChangeEvent=function(e,s){var o=e&&e[0];if(!o){return;}this.fireSelectionChange({listItem:o,listItems:e,selected:o.getSelected(),selectAll:!!s});this.fireSelect({listItem:o});};n.prototype.onItemDelete=function(o){this.fireDelete({listItem:o});};n.prototype.onItemPress=function(o,s){if(o.getType()==f.Inactive){return;}q.sap.delayedCall(0,this,function(){this.fireItemPress({listItem:o,srcControl:s});});};n.prototype._updateSelectedPaths=function(i,s){if(!this.getRememberSelections()||!this.isBound("items")){return;}var p=i.getBindingContextPath();if(!p){return;}s=(s===undefined)?i.getSelected():s;var e=this._aSelectedPaths.indexOf(p);if(s){e<0&&this._aSelectedPaths.push(p);}else{e>-1&&this._aSelectedPaths.splice(e,1);}};n.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}};n.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};n.prototype._getTouchBlocker=function(){return this.$().children();};n.prototype._getSwipeContainer=function(){return this._$swipeContainer||(q.sap.require("sap.m.InstanceManager"),this._$swipeContainer=q("<div>",{"id":this.getId("swp"),"class":"sapMListSwp"}));};n.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top);}};n.prototype._renderSwipeContent=function(){var $=this._swipedItem.$(),e=this._getSwipeContainer();this.$().prepend(e.css({top:$.position().top,height:$.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var r=sap.ui.getCore().createRenderManager();r.render(this.getSwipeContent(),e.empty()[0]);r.destroy();}return this;};n.prototype._swipeIn=function(){var t=this,$=t._getTouchBlocker(),i=t._getSwipeContainer();t._isSwipeActive=true;t._renderSwipeContent();sap.m.InstanceManager.addDialogInstance(t);window.document.activeElement.blur();q(window).on("resize.swp",function(){t._setSwipePosition();});$.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!i[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation();}});i.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");i.css("opacity",1).focus();$.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(e){if(!i[0].firstChild.contains(e.target)){t.swipeOut();}});}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim");};n.prototype._onSwipeOut=function(e){this._getSwipeContainer().css("opacity",0).remove();q(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof e=="function"){e.call(this,this._swipedItem,this.getSwipeContent());}this._isSwipeActive=false;sap.m.InstanceManager.removeDialogInstance(this);};n.prototype.swipeOut=function(e){if(!this._isSwipeActive){return this;}var t=this,$=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");$.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._onSwipeOut(e);}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this;};n.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut();}};n.prototype.close=n.prototype._removeSwipeContent;n.prototype._onSwipe=function(e){var o=this.getSwipeContent(),s=e.srcControl;if(o&&s&&!this._isSwipeActive&&this!==s&&!this._eventHandledByControl&&D.support.touch){for(var i=s;i&&!(i instanceof L);i=i.oParent);if(i instanceof L){this._swipedItem=i;this.fireSwipe({listItem:this._swipedItem,swipeContent:o,srcControl:s},true)&&this._swipeIn();}}};n.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();};n.prototype.onswipeleft=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"RightToLeft":"LeftToRight";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};n.prototype.onswiperight=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"LeftToRight":"RightToLeft";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};n.prototype.setSwipeDirection=function(s){return this.setProperty("swipeDirection",s,true);};n.prototype.getSwipedItem=function(){return(this._isSwipeActive?this._swipedItem:null);};n.prototype.setSwipeContent=function(o){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!o);return this.setAggregation("swipeContent",o,!this._isSwipeActive);};n.prototype.invalidate=function(o){if(o&&o===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return this;}return C.prototype.invalidate.apply(this,arguments);};n.prototype.addItemGroup=function(o,H,s){H=H||new G({title:o.text||o.key});H._bGroupHeader=true;this.addAggregation("items",H,s);return H;};n.prototype.removeGroupHeaders=function(s){this.getItems(true).forEach(function(i){if(i.isGroupHeader()){i.destroy(s);}});};n.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LIST");};n.prototype.getAccessibilityStates=function(){if(!this.getItems(true).length){return"";}var s="",M=k,e=this.getMode(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(b.isRequired(this)){s+=B.getText("LIST_REQUIRED")+" ";}if(e==M.MultiSelect){s+=B.getText("LIST_MULTISELECTABLE")+" ";}else if(e==M.Delete){s+=B.getText("LIST_DELETABLE")+" ";}else if(e!=M.None){s+=B.getText("LIST_SELECTABLE")+" ";}if(this.isGrouped()){s+=B.getText("LIST_GROUPED")+" ";}return s;};n.prototype.getAccessibilityDescription=function(){var s=this.getAriaLabelledBy().map(function(A){var o=sap.ui.getCore().byId(A);return L.getAccessibilityText(o);}).join(" ");var H=this.getHeaderToolbar();if(H){var t=H.getTitleControl();if(t){s+=t.getText()+" ";}}else{s+=this.getHeaderText()+" ";}s+=this.getAccessibilityStates()+" ";return s;};n.prototype.getAccessibilityInfo=function(){return{description:this.getAccessibilityDescription().trim(),focusable:true};};n.prototype.getAccessbilityPosition=function(i){var s=0,e=this.getVisibleItems(),p=e.indexOf(i)+1,B=this.getBinding("items");if(this.getGrowing()&&this.getGrowingScrollToLoad()&&B&&B.isLengthFinal()){s=B.getLength();if(B.isGrouped()){s+=e.filter(function(i){return i.isGroupHeader()&&i.getVisible();}).length;}}else{s=e.length;}return{setSize:s,posInset:p};};n.prototype.onItemFocusIn=function(i){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}var o=i.getDomRef(),p=this.getAccessbilityPosition(i);if(!i.getContentAnnouncement){this.getNavigationRoot().setAttribute("aria-activedescendant",o.id);o.setAttribute("aria-posinset",p.posInset);o.setAttribute("aria-setsize",p.setSize);}else{var A=i.getAccessibilityInfo(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=A.type+" ";s+=B.getText("LIST_ITEM_POSITION",[p.posInset,p.setSize])+" ";s+=A.description;this.updateInvisibleText(s,o);return s;}};n.prototype.updateInvisibleText=function(t,i,p){var o=n.getInvisibleText(),F=q(i||document.activeElement);if(this.bAnnounceDetails){this.bAnnounceDetails=false;t=this.getAccessibilityInfo().description+" "+t;}o.setText(t.trim());F.addAriaLabelledBy(o.getId(),p);window.setTimeout(function(){F.removeAriaLabelledBy(o.getId());},0);};n.prototype.getNavigationRoot=function(){return this.getDomRef("listUl");};n.prototype.getFocusDomRef=function(){return this.getNavigationRoot();};n.prototype._startItemNavigation=function(i){if(!D.system.desktop){return;}var K=this.getKeyboardMode(),e=g;if(K==e.Edit&&!this.getItems(true).length){return;}if(i&&!this.getNavigationRoot().contains(document.activeElement)){this._bItemNavigationInvalidated=true;return;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);var t=(K==e.Edit)?-1:0;this._setItemNavigationTabIndex(t);this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}this._oItemNavigation.setPageSize(this.getGrowingThreshold());var N=this.getNavigationRoot();this._oItemNavigation.setRootDomRef(N);this.setNavigationItems(this._oItemNavigation,N);this._bItemNavigationInvalidated=false;};n.prototype.setNavigationItems=function(i,N){var e=q(N).children(".sapMLIB").get();i.setItemDomRefs(e);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==h.Upwards){i.setFocusedIndex(e.length-1);}else{i.setFocusedIndex(0);}}};n.prototype.getItemNavigation=function(){return this._oItemNavigation;};n.prototype._setItemNavigationTabIndex=function(t){if(this._oItemNavigation){this._oItemNavigation.iActiveTabIndex=t;this._oItemNavigation.iTabIndex=t;}};n.prototype.setKeyboardMode=function(K){this.setProperty("keyboardMode",K,true);if(this.isActive()){var t=(K==g.Edit)?-1:0;this.$("nodata").prop("tabIndex",~t);this.$("listUl").prop("tabIndex",t);this.$("after").prop("tabIndex",t);this._setItemNavigationTabIndex(t);}return this;};n.prototype.setItemFocusable=function(o){if(!this._oItemNavigation){return;}var i=this._oItemNavigation.getItemDomRefs();var e=i.indexOf(o.getDomRef());if(e>=0){this._oItemNavigation.setFocusedIndex(e);}};n.prototype.forwardTab=function(F){this._bIgnoreFocusIn=true;this.$(F?"after":"before").focus();};n.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==g.Edit){return;}if(e.target.id==this.getId("nodata")){this.forwardTab(true);e.setMarked();}};n.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==g.Edit){return;}var t=e.target.id;if(t==this.getId("nodata")){this.forwardTab(false);}else if(t==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};n.prototype._navToSection=function(F){var t;var i=0;var s=F?1:-1;var e=this._aNavSections.length;this._aNavSections.some(function(p,r){var u=q.sap.domById(p);if(u&&u.contains(document.activeElement)){i=r;return true;}});var o=this.getItemsContainerDomRef();var $=q.sap.byId(this._aNavSections[i]);if($[0]===o&&this._oItemNavigation){$.data("redirect",this._oItemNavigation.getFocusedIndex());}this._aNavSections.some(function(){i=(i+s+e)%e;t=q.sap.byId(this._aNavSections[i]);if(t[0]===o&&this._oItemNavigation){var r=t.data("redirect");var p=this._oItemNavigation.getItemDomRefs();var T=p[r]||o.children[0];t=q(T);}if(t.is(":focusable")){t.focus();return true;}},this);return t;};n.prototype.onsapshow=function(e){if(e.isMarked()||e.which==q.sap.KeyCodes.F4||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(true)){e.preventDefault();e.setMarked();}};n.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(false)){e.preventDefault();e.setMarked();}};n.prototype.onkeydown=function(e){var i=(e.which==q.sap.KeyCodes.A)&&(e.metaKey||e.ctrlKey);if(e.isMarked()||!i||!q(e.target).hasClass(this.sNavItemClass)){return;}e.preventDefault();if(this.getMode()!==k.MultiSelect){return;}if(this.isAllSelectableSelected()){this.removeSelections(false,true);}else{this.selectAll(true);}e.setMarked();};n.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation();}};n.prototype.focusPrevious=function(){if(!this._oItemNavigation){return;}var N=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(N[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");var F=t.eq(-1).add($).eq(-1);this.bAnnounceDetails=true;F.focus();};n.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return;}if(this._bItemNavigationInvalidated){this._startItemNavigation();}var t=e.target;if(t.id==this.getId("nodata")){this.updateInvisibleText(this.getNoDataText(),t);}if(e.isMarked()||!this._oItemNavigation||this.getKeyboardMode()==g.Edit||t.id!=this.getId("after")){return;}this.focusPrevious();e.setMarked();};n.prototype.onsapfocusleave=function(e){if(this._oItemNavigation&&!this.bAnnounceDetails&&!this.getNavigationRoot().contains(document.activeElement)){this.bAnnounceDetails=true;}};n.prototype.onItemArrowUpDown=function(o,e){var i=this.getItems(true),p=i.indexOf(o)+(e.type=="sapup"?-1:1),r=i[p];if(r&&r.isGroupHeader()){r=i[p+(e.type=="sapup"?-1:1)];}if(!r){return;}var t=r.getTabbables(),F=o.getTabbables().index(e.target),E=t.eq(t[F]?F:-1);E[0]?E.focus():r.focus();e.preventDefault();e.setMarked();};n.prototype.getAggregationDomRef=function(A){if(A=="items"){return this.getItemsContainerDomRef();}};n.prototype.onItemContextMenu=function(o,e){var i=this.getContextMenu();if(!i){return;}var E=this.fireBeforeOpenContextMenu({listItem:o,column:sap.ui.getCore().byId(q(e.target).closest(".sapMListTblCell",this.getNavigationRoot()).attr("data-sap-ui-column"))});if(E){e.setMarked();e.preventDefault();var B,p=this.getBindingInfo("items");if(p){B=o.getBindingContext(p.model);i.setBindingContext(B);}i.openAsContextMenu(e,o);}};n.prototype.isGrouped=function(){var B=this.getBinding("items");return B&&B.isGrouped();};n.prototype.setContextMenu=function(o){this.setAggregation("contextMenu",o,true);};n.prototype.destroyContextMenu=function(){this.destroyAggregation("contextMenu",true);};return n;});
