/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','./NotificationListBase','sap/ui/core/InvisibleText','./ListItemBase','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/m/Button','./NotificationListGroupRenderer','jquery.sap.keycodes'],function(q,l,N,I,L,a,c,D,B,b){'use strict';var P=c.Priority;var d=l.ButtonType;var e=N.extend('sap.m.NotificationListGroup',{metadata:{library:'sap.m',properties:{collapsed:{type:'boolean',group:'Behavior',defaultValue:false},autoPriority:{type:'boolean',group:'Behavior',defaultValue:true},showEmptyGroup:{type:'boolean',group:'Behavior',defaultValue:false},enableCollapseButtonWhenEmpty:{type:'boolean',group:'Behavior',defaultValue:false}},defaultAggregation:'items',aggregations:{items:{type:'sap.m.NotificationListItem',multiple:true,singularName:'item'},_ariaDetailsText:{type:'sap.ui.core.InvisibleText',multiple:false,visibility:'hidden'}},events:{onCollapse:{parameters:{collapsed:{type:'boolean'}}}}}});e.prototype.init=function(){N.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');var _=new B(this.getId()+'-closeButton',{type:d.Transparent,icon:a.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',_,true);var g=new B({type:d.Transparent,press:function(){this.setCollapsed(!this.getCollapsed());}.bind(this)});this.setAggregation('_collapseButton',g,true);this._maxNumberReached=false;this._ariaLabbeledByIds='';this.setAggregation('_ariaDetailsText',new I());this._resourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');};e.prototype.setCollapsed=function(g){this._toggleCollapsed();this.setProperty('collapsed',g,true);this.fireOnCollapse({collapsed:g});return this;};e.prototype.getPriority=function(){if(!this.getAutoPriority()){return this.getProperty('priority');}var n=this.getAggregation('items');var p=P.None;if(n){n.forEach(function(i){p=f(p,i.getPriority());});}else{p=this.getProperty('priority');}return p;};e.prototype.getUnread=function(){var n=this.getItems();if(n.length){return n.some(function(i){return i.getUnread();});}return this.getProperty('unread');};e.prototype.onBeforeRendering=function(){var n=this.getItems();var g=n.length;var h=this.getAggregation('_collapseButton');this._maxNumberOfNotifications=D.system.desktop?400:100;h.setEnabled(this._getCollapseButtonEnabled(),true);this._maxNumberReached=g>this._maxNumberOfNotifications;n.forEach(function(i){i.addEventDelegate({onfocusin:this._notificationFocusHandler},this);i.addEventDelegate({onkeydown:this._notificationNavigationHandler},this);}.bind(this));this._updateAccessibilityInfo();this._updateCollapseButtonText(this.getCollapsed());this._maxNumberOfNotificationsTitle=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_TITLE',g-this._maxNumberOfNotifications);this._maxNumberOfNotificationsBody=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_BODY');};e.prototype.clone=function(){return N.prototype.clone.apply(this,arguments);};e.prototype._getHeaderTitle=function(){var t=N.prototype._getHeaderTitle.call(this);t.addStyleClass('sapMNLG-Title');if(this.getUnread()){t.addStyleClass('sapMNLGTitleUnread');}return t;};e.prototype._getDateTimeText=function(){var g=N.prototype._getDateTimeText.call(this);g.setTextAlign('End');return g;};e.prototype._toggleCollapsed=function(){var n=!this.getCollapsed();this._updateCollapseButtonText(n);this.$().toggleClass('sapMNLG-Collapsed',n);this.$().toggleClass('sapMNLG-NoNotifications',this._getVisibleItemsCount()<=0);};e.prototype._getVisibleItemsCount=function(){var i=this.getItems();var r=0;i.forEach(function(g){if(g.getVisible()){r+=1;}});return r;};e.prototype._getCollapseButtonEnabled=function(){if(this._getVisibleItemsCount()>0){return true;}return this.getEnableCollapseButtonWhenEmpty();};e.prototype._notificationFocusHandler=function(g){L.prototype.onfocusin.call(this,g);var t=g.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var h=n.indexOfItem(t);var i=t.getDomRef();i.setAttribute('aria-posinset',h+1);i.setAttribute('aria-setsize',n.getItems().length);};e.prototype._notificationNavigationHandler=function(g){L.prototype.onkeydown.call(this,g);var t=g.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var h=n.indexOfItem(t);switch(g.which){case q.sap.KeyCodes.ARROW_UP:if(h==0){return;}var p=h-1;n.getItems()[p].focus();break;case q.sap.KeyCodes.ARROW_DOWN:var i=h+1;if(i==n.getItems().length){return;}n.getItems()[i].focus();break;default:return;}};e.prototype._updateAccessibilityInfo=function(){var g=this.getAuthorName();var i=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);var u=this.getUnread()?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_UNREAD'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_READ');var h='';var j=this.getAggregation('_ariaDetailsText');if(g){h+=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_CREATED_BY')+' '+g+' ';}h+=i+' '+u;j.setText(h);this._ariaLabbeledByIds=this._getHeaderTitle().getId()+' '+j.getId();};e.prototype._updateCollapseButtonText=function(g){var h=g?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_EXPAND'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_COLLAPSE');this.getAggregation('_collapseButton').setText(h,true);};function f(g,s){if(g==s){return g;}if((g=='None')){return s;}if((g=='Low')&&(s!='None')){return s;}if((g=='Medium')&&(s!='None'&&s!='Low')){return s;}return g;}return e;});
