/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','./PlanningCalendarRow','./library','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/DateRange','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarWeekInterval','sap/ui/unified/CalendarOneMonthInterval','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/m/Select','sap/m/Button','sap/m/Toolbar','sap/m/Table','sap/m/Column','./PlanningCalendarRenderer','jquery.sap.events'],function(q,C,M,P,l,u,a,b,D,c,d,e,f,R,I,S,B,T,g,h,k){"use strict";var m=u.CalendarDayType;var L=l.ListMode;var n=l.ToolbarDesign;var o=l.ButtonType;var p=l.PlanningCalendarBuiltInView;var r=l.ScreenSize;var s=u.CalendarAppointmentVisualization;var G=u.GroupAppointmentsMode;var t=u.CalendarIntervalType;var v=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:t.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:s.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent"},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{row:{type:"sap.m.PlanningCalendarRow"}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var w=["_oTimeInterval","_oDateInterval","_oMonthInterval","_oWeekInterval","_oOneMonthInterval"],x={};x[t.Day]={sInstanceName:"_oDateInterval",sIdSuffix:"-DateInt",oClass:c};x[t.Week]={sInstanceName:"_oWeekInterval",sIdSuffix:"-WeekInt",oClass:d};x[t.OneMonth]={sInstanceName:"_oOneMonthInterval",sIdSuffix:"-OneMonthInt",oClass:e};var A=r.Desktop;var K=[p.Hour,p.Day,p.Month,p.Week,p.OneMonth];var y=C.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addClass("sapMPlanCalHead");i.writeClasses();i.write(">");var c1=j.getToolbar();if(c1){i.renderControl(c1);}var d1=j.getAllCheckBox();if(d1){i.renderControl(d1);}i.write("</div>");}});v.prototype.init=function(){this._iBreakPointTablet=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(f.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if(f.system.tablet||q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=new S(i+"-IntType",{maxWidth:"15rem",ariaLabelledBy:i+"-SelDescr"});this._oIntervalTypeSelect.attachEvent("change",_,this);this._oTodayButton=new B(i+"-Today",{text:this._oRB.getText("PLANNINGCALENDAR_TODAY"),type:o.Transparent});this._oTodayButton.attachEvent("press",this._handleTodayPress,this);this._oHeaderToolbar=new T(i+"-HeaderToolbar",{design:n.Transparent,content:[this._oIntervalTypeSelect,this._oTodayButton]});this._oCalendarHeader=new y(i+"-CalHead",{toolbar:this._oHeaderToolbar});this._oInfoToolbar=new T(i+"-InfoToolbar",{height:"auto",design:n.Transparent,content:[this._oCalendarHeader,this._oTimeInterval]});var j=new g(i+"-Table",{infoToolbar:this._oInfoToolbar,mode:L.SingleSelectMaster,columns:[new h({styleClass:"sapMPlanCalRowHead"}),new h({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:A,demandPopin:true})],ariaLabelledBy:i+"-Descr"});j.attachEvent("selectionChange",N,this);j.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=j.$().find(".sapMPlanCalRowHead > div.sapMLIB").click(function(c1){var d1=q(c1.currentTarget).control(0),e1=sap.ui.getCore().byId(d1.getAssociation("parentRow"));this.fireRowHeaderClick({row:e1});}.bind(this));}},false,this);this.setAggregation("table",j,true);this.setStartDate(new Date());this._resizeProxy=q.proxy(H,this);this._fnCustomSortedAppointments=undefined;};v.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}f.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();w.forEach(function(c1){if(this[c1]){this[c1]._oPlanningCalendar=undefined;this[c1].destroy();this[c1]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this.getToolbarContent().length==0&&this._oToolbar){this._oToolbar.destroy();this._oToolbar=undefined;}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};v.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimeInterval&&!this._oDateInterval&&!this._oMonthInterval&&!this._oWeekInterval&&!this._oOneMonthInterval)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}V.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updateTodayButtonState();f.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;};v.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};v.prototype._dateMatchesVisibleRange=function(i,j){var c1=this._getView(j,!this._bBeforeRendering);if(!c1){return false;}var d1=c1.getIntervalType(),e1=x[d1],f1=e1?this[e1.sInstanceName]:null,g1=false;if(f1&&f1._dateMatchesVisibleRange){g1=f1._dateMatchesVisibleRange(i);}return g1;};v.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};H.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}if(f.system.phone&&this.getStickyHeader()){f.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);};v.prototype.setStartDate=function(i){var j,c1;if(!i){i=new Date();}else{a._checkJSDateObject(i);}if(this.getViewKey()===p.Week){j=a.getFirstDateOfWeek(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(j,true).getTime());}if(this.getViewKey()===p.OneMonth){c1=a.getFirstDateOfMonth(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(c1,true).getTime());}if(q.sap.equal(i,this.getStartDate())){this._updateTodayButtonState();return this;}var d1=i.getFullYear();a._checkYearInValidRange(d1);var e1=this.getMinDate();if(e1&&e1.getTime()>i.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);i=new Date(e1.getTime());}else{var f1=this.getMaxDate();if(f1&&f1.getTime()<i.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(e1){i=new Date(e1.getTime());}else{i=new Date(1,0,1);i.setFullYear(1);}}}this.setProperty("startDate",i,true);w.forEach(function(g1){if(this[g1]){this[g1].setStartDate(new Date(i.getTime()));}},this);this._setRowsStartDate(new Date(i.getTime()));if(this.getViewKey()===p.Week||this.getViewKey()===p.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);}return this;};v.prototype.setMinDate=function(i){if(q.sap.equal(i,this.getMinDate())){return this;}var j=this.getMaxDate();if(i){a._checkJSDateObject(i);var c1=i.getFullYear();a._checkYearInValidRange(c1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;w.forEach(function(f1){if(this[f1]){this[f1].setMinDate(new Date(i.getTime()));}},this);if(j&&j.getTime()<i.getTime()){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var d1=this.getStartDate();if(d1&&d1.getTime()<i.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);d1=new Date(i.getTime());this.setStartDate(d1);}}else{this.setProperty("minDate",undefined,true);w.forEach(function(f1){if(this[f1]){this[f1].setMinDate();}},this);}var e1=new Date();if(i&&e1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||e1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};v.prototype.setMaxDate=function(i){if(q.sap.equal(i,this.getMaxDate())){return this;}var j=this.getMinDate();if(i){a._checkJSDateObject(i);var c1=i.getFullYear();a._checkYearInValidRange(c1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;w.forEach(function(f1){if(this[f1]){this[f1].setMaxDate(new Date(i.getTime()));}},this);if(j&&j.getTime()>i.getTime()){q.sap.log.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var d1=this.getStartDate();if(d1&&d1.getTime()>i.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){d1=new Date(j.getTime());}else{d1=new Date(1,0,1);d1.setFullYear(1);}this.setStartDate(d1);}}else{this.setProperty("maxDate",undefined,true);w.forEach(function(f1){if(this[f1]){this[f1].setMaxDate();}},this);}var e1=new Date();if(i&&e1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||e1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};v.prototype.setViewKey=function(j){var c1,d1,e1,f1=this.getViewKey(),g1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);if(this._oInfoToolbar.getContent().length>1){this._oInfoToolbar.removeContent(1);}if(j===p.Week||j===p.OneMonth){d1=this.getStartDate();this.setStartDate(new Date(d1.getTime()));if(d1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}var h1=this.getStartDate();var i1=this.getMinDate();var j1=this.getMaxDate();var k1=this._getView(j,!this._bBeforeRendering);if(!k1){this._bCheckView=true;this.invalidate();}else{var l1=k1.getIntervalType();var m1=this._getIntervals(k1);this._bCheckView=false;switch(l1){case t.Hour:if(!this._oTimeInterval){this._oTimeInterval=new sap.ui.unified.CalendarTimeInterval(this.getId()+"-TimeInt",{startDate:new Date(h1.getTime()),items:m1,pickerPopup:true,legend:this.getLegend()});this._oTimeInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oTimeInterval.attachEvent("select",this._handleCalendarSelect,this);this._oTimeInterval._oPlanningCalendar=this;this._oTimeInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(i1){this._oTimeInterval.setMinDate(new Date(i1.getTime()));}if(j1){this._oTimeInterval.setMaxDate(new Date(j1.getTime()));}}else if(this._oTimeInterval.getItems()!=m1){this._oTimeInterval.setItems(m1);}this._oInfoToolbar.addContent(this._oTimeInterval);break;case t.Day:case t.Week:case t.OneMonth:e1=x[l1];c1=this[e1.sInstanceName];if(!c1){c1=new e1.oClass(this.getId()+e1.sIdSuffix,{startDate:new Date(h1.getTime()),days:m1,showDayNamesLine:this.getShowDayNamesLine(),pickerPopup:true,legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});c1.attachEvent("startDateChange",this._handleStartDateChange,this);c1.attachEvent("select",this._handleCalendarSelect,this);if(j===p.OneMonth){c1._setRowsStartDate=this._setRowsStartDate.bind(this);}c1._oPlanningCalendar=this;c1.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(i1){c1.setMinDate(new Date(i1.getTime()));}if(j1){c1.setMaxDate(new Date(j1.getTime()));}}else if(c1.getDays()!==m1){c1.setDays(m1);}this._oInfoToolbar.addContent(c1);this[e1.sInstanceName]=c1;break;case t.Month:if(!this._oMonthInterval){this._oMonthInterval=new sap.ui.unified.CalendarMonthInterval(this.getId()+"-MonthInt",{startDate:new Date(h1.getTime()),months:m1,pickerPopup:true,legend:this.getLegend()});this._oMonthInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oMonthInterval.attachEvent("select",this._handleCalendarSelect,this);this._oMonthInterval._oPlanningCalendar=this;this._oMonthInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(i1){this._oMonthInterval.setMinDate(new Date(i1.getTime()));}if(j1){this._oMonthInterval.setMaxDate(new Date(j1.getTime()));}}else if(this._oMonthInterval.setMonths()!=m1){this._oMonthInterval.setMonths(m1);}this._oInfoToolbar.addContent(this._oMonthInterval);break;default:throw new Error("Unknown IntervalType: "+l1+"; "+this);}var n1=this.getRows();for(var i=0;i<n1.length;i++){var o1=n1[i];var p1=o1.getCalendarRow();p1.setIntervalType(l1);p1.setIntervals(m1);p1.setShowSubIntervals(k1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);E.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));F.call(this,this.getShowDayNamesLine(),!!c1);}}if(this._oOneMonthInterval&&j===p.OneMonth){this._oOneMonthInterval._setDisplayMode(this._iSize);this._oOneMonthInterval._adjustSelectedDate(b.fromLocalJSDate(d1));if(this._iSize<2){this._setRowsStartDate(d1);}}else if(this._oOneMonthInterval&&f1===p.OneMonth&&this._oOneMonthInterval.getSelectedDates().length){g1=this._oOneMonthInterval.getSelectedDates()[0].getStartDate();if(g1){this.setStartDate(g1);}}this._updateTodayButtonState();return this;};v.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),c1=x[j];return!!c1&&!!c1.oClass.prototype.setShowWeekNumbers;};v.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),c1=x[j];return!!c1&&!!c1.oClass.prototype.setShowDayNamesLine;};v.prototype._getIntervalInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),c1=x[j],d1;if(c1){d1=this[c1.sInstanceName];}return d1;};v.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var c1=j.getKey(),d1=this._viewAllowsWeekNumbers(c1),e1=this._getIntervalInstanceByViewKey(c1);if(e1&&d1){this._getIntervalInstanceByViewKey(c1).setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===c1){E.call(this,i,d1);}},this);return this;};v.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var c1=this.getRows();for(var i=0;i<c1.length;i++){var d1=c1[i];d1.getCalendarRow().setShowIntervalHeaders(j);}return this;};v.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var c1=this.getRows();for(var i=0;i<c1.length;i++){var d1=c1[i];d1.getCalendarRow().setShowEmptyIntervalHeaders(j);}return this;};v.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var c1=this.getRows();for(var i=0;i<c1.length;i++){var d1=c1[i];d1.getCalendarRow().setGroupAppointmentsMode(j);}return this;};v.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var c1=this.getRows();for(var i=0;i<c1.length;i++){var d1=c1[i];d1.getCalendarRow().setAppointmentsReducedHeight(j);}return this;};v.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var c1=this.getRows();for(var i=0;i<c1.length;i++){var d1=c1[i];d1.getCalendarRow().setAppointmentsVisualization(j);}return this;};v.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);Z.call(this);a1.call(this);return this;};v.prototype.setShowDayNamesLine=function(i){var j,c1,d1,e1=!!this.getDomRef(),f1=this.getViewKey();for(j in x){c1=x[j].sInstanceName;if(this[c1]){d1=this[c1];d1.setShowDayNamesLine(i);if(e1&&j===f1){F.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};v.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(f.system.phone){if(i){f.orientation.attachHandler(this._updateStickyHeader,this);}else{f.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};v.prototype._updateStickyHeader=function(){var i=this.getStickyHeader(),j=this.getViewKey()===p.OneMonth&&this._iSize<2,c1=i&&!f.system.phone&&!j,d1=i&&!(f.system.phone&&f.orientation.landscape)&&!j;if(this._oToolbar){this._oToolbar.toggleStyleClass("sapMPlanCalStickyHeader",c1);}if(this._oInfoToolbar){this._oInfoToolbar.toggleStyleClass("sapMPlanCalStickyHeader",d1);}};v.prototype.addRow=function(i){this.addAggregation("rows",i,true);i.attachEvent("_change",$,this);var j=this.getAggregation("table");j.addItem(i.getColumnListItem());var c1=i.getCalendarRow();c1.setStartDate(this.getStartDate());c1.setShowIntervalHeaders(this.getShowIntervalHeaders());c1.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());c1.setGroupAppointmentsMode(this.getGroupAppointmentsMode());c1.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());c1.setLegend(this.getLegend());c1.setAppointmentsVisualization(this.getAppointmentsVisualization());c1.attachEvent("select",J,this);c1.attachEvent("startDateChange",this._handleStartDateChange,this);c1.attachEvent("leaveRow",X,this);c1.attachEvent("intervalSelect",z,this);Y.call(this);if(b1.call(this)){var d1=this.getViewKey();var e1=this._getView(d1);var f1=e1.getIntervalType();var g1=this._getIntervals(e1);c1.setIntervalType(f1);c1.setIntervals(g1);c1.setShowSubIntervals(e1.getShowSubIntervals());}a1.call(this);if(this._fnCustomSortedAppointments){c1._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}return this;};v.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);i.attachEvent("_change",$,this);var c1=this.getAggregation("table");c1.insertItem(i.getColumnListItem(),j,true);var d1=i.getCalendarRow();d1.setStartDate(this.getStartDate());d1.setShowIntervalHeaders(this.getShowIntervalHeaders());d1.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());d1.setGroupAppointmentsMode(this.getGroupAppointmentsMode());d1.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());d1.setLegend(this.getLegend());d1.setAppointmentsVisualization(this.getAppointmentsVisualization());d1.attachEvent("select",J,this);d1.attachEvent("startDateChange",this._handleStartDateChange,this);d1.attachEvent("leaveRow",X,this);d1.attachEvent("intervalSelect",z,this);if(this._fnCustomSortedAppointments){d1._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}Y.call(this);if(b1.call(this)){var e1=this.getViewKey();var f1=this._getView(e1);var g1=f1.getIntervalType();var h1=this._getIntervals(f1);d1.setIntervalType(g1);d1.setIntervals(h1);d1.setShowSubIntervals(f1.getShowSubIntervals());}a1.call(this);return this;};v.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true);j.detachEvent("_change",$,this);var c1=this.getAggregation("table");c1.removeItem(j.getColumnListItem(),true);var d1=j.getCalendarRow();d1.detachEvent("select",J,this);d1.detachEvent("startDateChange",this._handleStartDateChange,this);d1.detachEvent("leaveRow",X,this);d1.detachEvent("intervalSelect",z,this);if(this._fnCustomSortedAppointments){d1._fnCustomSortedAppointments=undefined;}Y.call(this);a1.call(this);return j;};v.prototype.removeAllRows=function(){var j=this.removeAllAggregation("rows",true);var c1=this.getAggregation("table");c1.removeAllItems(true);for(var i=0;i<j.length;i++){var d1=j[i];d1.detachEvent("_change",$,this);var e1=d1.getCalendarRow();e1.detachEvent("select",J,this);e1.detachEvent("startDateChange",this._handleStartDateChange,this);e1.detachEvent("leaveRow",X,this);e1.detachEvent("intervalSelect",z,this);if(this._fnCustomSortedAppointments){e1._fnCustomSortedAppointments=undefined;}}Y.call(this);a1.call(this);return j;};v.prototype.destroyRows=function(){var i=this.destroyAggregation("rows",true);var j=this.getAggregation("table");j.destroyItems(true);Y.call(this);a1.call(this);return i;};v.prototype.addToolbarContent=function(i){this.addAggregation("toolbarContent",i,true);O.call(this);return this;};v.prototype.insertToolbarContent=function(i,j){this.insertAggregation("toolbarContent",i,j);O.call(this);return this;};v.prototype.removeToolbarContent=function(i){var j=this.removeAggregation("toolbarContent",i,true);O.call(this);return j;};v.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent",true);O.call(this);return i;};v.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent",true);O.call(this);return i;};v.prototype.indexOfContent=function(i){return this.indexOfToolbarContent(i);};v.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);Z.call(this);a1.call(this);if(i){this.selectAllRows(false);}else{Y.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};v.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};v.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var c1=this.getRows(),d1=this.getLegend()&&sap.ui.getCore().byId(this.getLegend()),e1;for(var i=0;i<c1.length;i++){var f1=c1[i];f1.getCalendarRow().setLegend(j);}w.forEach(function(g1){if(this[g1]){this[g1].setLegend(j);}},this);if(d1){e1=new M(function(g1){this.invalidate();}.bind(this));e1.observe(d1,{destroy:true});}return this;};v.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};v.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};v.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};v.prototype.invalidate=function(i){var j=i&&i instanceof D;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var c1=this.getViewKey();var d1=this._getView(c1);var e1=d1.getIntervalType();switch(e1){case t.Hour:if(this._oTimeInterval){this._oTimeInterval.invalidate(arguments);}break;case t.Day:if(this._oDateInterval){this._oDateInterval.invalidate(arguments);}break;case t.Month:if(this._oMonthInterval){this._oMonthInterval.invalidate(arguments);}break;case t.OneMonth:if(this._oOneMonthInterval){this._oOneMonthInterval.invalidate(arguments);}break;case t.Week:if(this._oWeekInterval){this._oWeekInterval.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+e1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};v.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;if(i.getType()===m.NonWorking){this.getAggregation("rows").forEach(function(j){j.addAggregation("_nonWorkingDates",this._buildPCRowDateRange(i));},this);}return C.prototype.addAggregation.call(this,"specialDates",i);};v.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;if(i.getType()===m.NonWorking){this.getAggregation("rows").forEach(function(c1){c1.insertAggregation("_nonWorkingDates",this._buildPCRowDateRange(i),j);},this);}return C.prototype.insertAggregation.call(this,"specialDates",i,j);};v.prototype.removeSpecialDate=function(i){var j;if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this._bDateRangeChanged=true;if(i&&i.getType()===m.NonWorking){this.getAggregation("rows").forEach(function(c1){if(c1.getAggregation("_nonWorkingDates")){j=c1.getAggregation("_nonWorkingDates").filter(function(d1){return d1.data(P.PC_FOREIGN_KEY_NAME)===i.getId();});if(j.length){c1.removeAggregation("_nonWorkingDates",j[0]);}}});}return C.prototype.removeAggregation.call(this,"specialDates",i);};v.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;if(this.getAggregation("rows")){this.getAggregation("rows").forEach(function(i){i.removeAllAggregation("_nonWorkingDates");});}return this.removeAllAggregation("specialDates");};v.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;this.getAggregation("rows").forEach(function(i){i.destroyAggregation("_nonWorkingDates");});return this.destroyAggregation("specialDates");};v.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(K[0]);}return i;};v.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(K[0]);}return i;};v.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};v.prototype.selectAllRows=function(j){var c1=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<c1.length;i++){var d1=c1[i];d1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};v.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var c1=j[0];var d1=new q.Event("saphome");d1._bPlanningCalendar=true;c1.getCalendarRow().onsaphome(d1);i.preventDefault();i.stopPropagation();}};v.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var c1=j[j.length-1];var d1=new q.Event("sapend");d1._bPlanningCalendar=true;c1.getCalendarRow().onsapend(d1);i.preventDefault();i.stopPropagation();}};v.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};v.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};v.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};v.prototype._getView=function(j,c1){var d1=this._getViews();var e1;for(var i=0;i<d1.length;i++){e1=d1[i];if(e1.getKey()!=j){e1=undefined;}else{break;}}if(!e1&&!c1){throw new Error("PlanningCalendarView with key "+j+"not assigned "+this);}return e1;};v.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this.fireStartDateChange();};v.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var c1=this.getRows();for(var i=0;i<c1.length;i++){var d1=c1[i];d1.getCalendarRow().updateCurrentTimeVisualization();}}var e1=new Date();var f1=this.getStartDate();var g1=this.getViewKey();var h1=this._getView(g1);var i1=h1.getIntervalType();var j1=this._getIntervals(h1);var k1=0;var l1=0;var m1=0;switch(i1){case t.Hour:k1=60000;l1=f1.getTime()-3600000;m1=f1.getTime()+j1*3600000;break;case t.Day:case t.Week:case t.OneMonth:k1=1800000;l1=f1.getTime()-3600000;m1=f1.getTime()+j1*86400000;break;default:k1=-1;break;}if(e1.getTime()<=m1&&e1.getTime()>=l1&&k1>0){this._sUpdateCurrentTime=q.sap.delayedCall(k1,this,'_updateCurrentTimeVisualization',[true]);}};function _(i){this.setViewKey(i.getParameter("selectedItem").getKey());this.fireViewChange();}v.prototype._handleTodayPress=function(i){var j=new Date(),c1,d1=this.getViewKey();if(d1===p.OneMonth){c1=a.getFirstDateOfMonth(a._createUniversalUTCDate(j,undefined,true));this._oOneMonthInterval._adjustSelectedDate(b.fromLocalJSDate(j),false);j=a._createLocalDate(c1,true);}if(d1===p.Week){c1=this.getStartDate();j.setHours(c1.getHours());j.setMinutes(c1.getMinutes());j.setSeconds(c1.getSeconds());}this.setStartDate(j);this.fireStartDateChange();};v.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();this._changeStartDate(j);};v.prototype._handleCalendarSelect=function(i){var j=i.oSource.getSelectedDates();var c1=new Date(j[0].getStartDate());var d1=a._createUniversalUTCDate(c1,undefined,true);var e1=this.getViewKey();var f1=this._getView(e1);var g1=f1.getIntervalType();if(g1!==t.OneMonth||this._iSize>1){j[0].setStartDate();}switch(g1){case t.Hour:d1.setUTCHours(d1.getUTCHours()+1);break;case t.Day:case t.Week:d1.setUTCDate(d1.getUTCDate()+1);break;case t.OneMonth:if(this._iSize<2){var h1=new Date(c1.getTime());if(a.monthsDiffer(this.getStartDate(),c1)){this.setStartDate(c1);}this._setRowsStartDate(h1);this._oOneMonthInterval.getAggregation('month')[0]._focusDate(b.fromLocalJSDate(h1),true);}else if(a._isNextMonth(c1,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}d1.setUTCDate(d1.getUTCDate()+1);break;case t.Month:d1.setUTCMonth(d1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+g1+"; "+this);}d1.setUTCMilliseconds(d1.getUTCMilliseconds()-1);d1=a._createLocalDate(d1,true);this.fireIntervalSelect({startDate:c1,endDate:d1,subInterval:false,row:undefined});};v.prototype._buildPCRowDateRange=function(i){var j=new D();if(i.getStartDate()){j.setStartDate(new Date(i.getStartDate().getTime()));}if(i.getEndDate()){j.setEndDate(new Date(i.getEndDate().getTime()));}j.data(P.PC_FOREIGN_KEY_NAME,i.getId());return j;};function z(i){var j=i.getParameter("startDate");var c1=this.getViewKey();var d1=this._getView(c1);var e1=d1.getIntervalType();if(e1===t.OneMonth&&a._isNextMonth(j,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}var f1=i.getParameter("endDate");var g1=i.getParameter("subInterval");var h1=i.oSource._oPlanningCalendarRow;this.fireIntervalSelect({startDate:j,endDate:f1,subInterval:g1,row:h1});}v.prototype._applyContextualSettings=function(){return C.prototype._applyContextualSettings.call(this,{contextualWidth:this.$().width()});};function E(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function F(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function H(j,c1){this._applyContextualSettings();if(j.size.width<=0){return;}var d1=this.getRows();var e1;var i=0;var f1=this._iSize;Q.call(this,j.size.width);if(f1!=this._iSize){U.call(this,this._iSize);var g1=this.getViewKey();var h1=this._getView(g1);var i1=h1.getIntervalType();var j1=this._getIntervals(h1);for(i=0;i<d1.length;i++){e1=d1[i];var k1=e1.getCalendarRow();if(j1!=k1.getIntervals()){k1.setIntervals(j1);}else{k1.handleResize();}}switch(i1){case t.Hour:if(this._oTimeInterval&&this._oTimeInterval.getItems()!=j1){this._oTimeInterval.setItems(j1);}break;case t.Day:if(this._oDateInterval&&this._oDateInterval.getDays()!=j1){this._oDateInterval.setDays(j1);}break;case t.Month:if(this._oMonthInterval&&this._oMonthInterval.getMonths()!=j1){this._oMonthInterval.setMonths(j1);}break;case t.Week:if(this._oWeekInterval&&this._oWeekInterval.getDays()!=j1){this._oWeekInterval.setDays(j1);}break;case t.OneMonth:if(this._oOneMonthInterval&&this._oOneMonthInterval.getDays()!=j1){this._oOneMonthInterval.setDays(j1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+i1+"; "+this);}Z.call(this);}else if(!c1){for(i=0;i<d1.length;i++){e1=d1[i];e1.getCalendarRow().handleResize();}}if(this._oOneMonthInterval){this._oOneMonthInterval._setDisplayMode(this._iSize);}if(this.getStickyHeader()){this._updateStickyHeader();}}function J(c1){var d1=c1.getParameter("appointment"),e1=c1.getParameter("multiSelect"),f1=c1.getParameter("appointments"),g1=c1.getParameter("domRefId"),h1,i1,j1,k1,l1,m1,i,j;if(!e1){i1=this.getRows();for(i=0;i<i1.length;i++){j1=i1[i];k1=j1.getCalendarRow();if(c1.oSource!=k1){l1=j1.getAppointments();for(j=0;j<l1.length;j++){m1=l1[j];m1.setSelected(false);}}}}h1={appointment:d1,appointments:f1,multiSelect:e1,domRefId:g1};this.fireAppointmentSelect(h1);}v.prototype._setRowsStartDate=function(j){var c1=this.getRows(),d1,i;for(i=0;i<c1.length;i++){d1=c1[i];d1.getCalendarRow().setStartDate(j);}};v.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),c1=j.getColumns()[1];c1.setDemandPopin(i);c1.setMinScreenWidth(i?A:"");};v.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),c1,d1=[],e1=p,f1=t;if(!this._oViews){this._oViews={};}if(j.length){d1=j;}else{d1=i.length?[]:K;}c1=d1.map(function(h1){switch(h1){case e1.Hour:return this._oViews[e1.Hour]||(this._oViews[e1.Hour]=new sap.m.PlanningCalendarView(this.getId()+"-HourView",{key:e1.Hour,intervalType:f1.Hour,description:this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case e1.Day:return this._oViews[e1.Day]||(this._oViews[e1.Day]=new sap.m.PlanningCalendarView(this.getId()+"-DayView",{key:e1.Day,intervalType:f1.Day,description:this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case e1.Month:return this._oViews[e1.Month]||(this._oViews[e1.Month]=new sap.m.PlanningCalendarView(this.getId()+"-MonthView",{key:e1.Month,intervalType:f1.Month,description:this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case e1.Week:return this._oViews[e1.Week]||(this._oViews[e1.Week]=new sap.m.PlanningCalendarView(this.getId()+"-WeekView",{key:e1.Week,intervalType:f1.Week,description:this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case e1.OneMonth:return this._oViews[e1.OneMonth]||(this._oViews[e1.OneMonth]=new sap.m.PlanningCalendarView(this.getId()+"-OneMonthView",{key:e1.OneMonth,intervalType:f1.OneMonth,description:this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:q.sap.log.error("Cannot get PlanningCalendar views. Invalid view key "+h1);break;}},this);for(var g1 in this._oViews){if(d1.indexOf(g1)<0){this._oViews[g1].destroy();delete this._oViews[g1];}}if(i.length){c1=c1.concat(i);}return c1;};v.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,j.getCalendarRow().aSelectedAppointments);});return i;};v.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"){this.getRows().forEach(function(j){var c1=j.getCalendarRow();c1._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}return this;};v.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};v.prototype._onRowDeselectAppointment=function(){var c1=this.getRows();for(var i=0;i<c1.length;i++){var d1=c1[i].getCalendarRow().aSelectedAppointments;for(var j=0;j<d1.length;j++){var e1=sap.ui.getCore().byId(d1[j]);if(e1){e1.setProperty("selected",false,true);e1.$().removeClass("sapUiCalendarAppSel");}}c1[i].getCalendarRow().aSelectedAppointments=[];}};function N(j){var c1=[];var d1=this.getRows();for(var i=0;i<d1.length;i++){var e1=d1[i];var f1=e1.getColumnListItem();var g1=f1.getSelected();if(e1.getSelected()!=g1){e1.setProperty("selected",g1,true);c1.push(e1);}}if(!this.getSingleSelection()){Y.call(this);}if(c1.length>0){this.fireRowSelectionChange({rows:c1});}}function O(){var i=this.getAggregation("table");if(this.getToolbarContent().length>0){if(!this._oToolbar){this._oToolbar=new sap.m.OverflowToolbar(this.getId()+"-Toolbar",{design:n.Transpaent});this._oToolbar._oPlanningCalendar=this;this._oToolbar.getContent=function(){return this._oPlanningCalendar.getToolbarContent();};}if(!i.getHeaderToolbar()){i.setHeaderToolbar(this._oToolbar);}}else if(i.getHeaderToolbar()){i.setHeaderToolbar();}this._oToolbar.invalidate();}function Q(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(q('html').hasClass("sapUiMedia-Std-Phone")){this._iSizeScreen=0;}else if(q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function U(j){var c1='sapMSize'+j,d1=this.$(),i,e1;if(d1){for(i=0;i<3;i++){e1='sapMSize'+i;if(e1===c1){d1.addClass(e1);}else{d1.removeClass(e1);}}}}function V(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var c1;for(i=0;i<j.length;i++){var d1=j[i];c1=new I(this.getId()+"-"+i,{key:d1.getKey(),text:d1.getDescription(),tooltip:d1.getTooltip()});this._oIntervalTypeSelect.addItem(c1);}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function W(i){var j=i.getParameter("selected");var c1=this.getRows();if(j){c1=this.getRows().filter(function(d1){return!d1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:c1});}function X(j){var c1=j.oSource;var d1=j.getParameter("type");var e1=this.getRows();var f1;var g1;var h1;var i1;var i=0;var j1=0;var k1;for(i=0;i<e1.length;i++){f1=e1[i];if(f1.getCalendarRow()==c1){j1=i;break;}}switch(d1){case"sapup":h1=c1.getFocusedAppointment();i1=h1.getStartDate();if(j1>0){j1--;}g1=e1[j1];g1.getCalendarRow().focusNearestAppointment(i1);break;case"sapdown":h1=c1.getFocusedAppointment();i1=h1.getStartDate();if(j1<e1.length-1){j1++;}g1=e1[j1];g1.getCalendarRow().focusNearestAppointment(i1);break;case"saphome":if(j1>0){g1=e1[0];k1=new q.Event(d1);k1._bPlanningCalendar=true;g1.getCalendarRow().onsaphome(k1);}break;case"sapend":if(j1<e1.length-1){g1=e1[e1.length-1];k1=new q.Event(d1);k1._bPlanningCalendar=true;g1.getCalendarRow().onsapend(k1);}break;default:break;}}function Y(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function Z(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new sap.m.CheckBox(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",W,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function $(i){if(i.getParameter("name")=="selected"){Y.call(this);}}function a1(){var i=this.getAggregation("table");var j=i.getMode();var c1;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){c1=L.None;}else{c1=L.SingleSelectMaster;}}else{c1=L.MultiSelect;}if(j!=c1){i.setMode(c1);}}function b1(){return this._oTimeInterval||this._oDateInterval||this._oMonthInterval||this._oWeekInterval||this._oOneMonthInterval;}return v;});
