/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/IconPool','./SegmentedButtonRenderer'],function(l,C,E,I,R,a,c,S){"use strict";var d=C.extend("sap.m.SegmentedButton",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/SegmentedButton.designtime",publicMethods:["createButton"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"}},defaultAggregation:"buttons",aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},items:{type:"sap.m.SegmentedButtonItem",multiple:true,singularName:"item",bindable:"bindable"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},associations:{selectedButton:{deprecated:true,type:"sap.m.Button",multiple:false},selectedItem:{type:"sap.m.SegmentedButtonItem",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{button:{type:"sap.m.Button"},id:{type:"string"},key:{type:"string"}}},selectionChange:{parameters:{item:{type:"sap.m.SegmentedButtonItem"}}}}}});E.call(d.prototype);d.prototype.init=function(){this._aWidths=[];this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});this.addDelegate(this._oItemNavigation);this.removeButton=function(b){var r=d.prototype.removeButton.call(this,b);this.setSelectedButton(this.getButtons()[0]);this._fireChangeEvent();return r;};};d.prototype.onBeforeRendering=function(){var b=this._getVisibleButtons();this._bCustomButtonWidth=b.some(function(B){return B.getWidth();});if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.setSelectedKey(this.getProperty("selectedKey"));if(!this.getSelectedButton()){this._selectDefaultButton();}};d.prototype.onAfterRendering=function(){var b=this._getVisibleButtons(),p;if(!this._sResizeListenerId){p=this.getDomRef().parentNode;if(p){this._sResizeListenerId=R.register(p,this._handleContainerResize.bind(this));}}this._setItemNavigation();this._aWidths=this._getRenderedButtonWidths(b);this._updateWidth();};d.prototype._handleContainerResize=function(){var b=this._getVisibleButtons();this._clearAutoWidthAppliedToControl();this._aWidths=this._getRenderedButtonWidths(b);this._updateWidth();};d.prototype._clearAutoWidthAppliedToControl=function(){var b=this._getVisibleButtons(),B=b.length,o,i=0;if(!this.getWidth()){this.$().css("width","");}while(i<B){o=b[i];if(!o.getWidth()){o.$().css("width","");}i++;}};d.prototype._getRenderedButtonWidths=function(b){return b.map(function(B){return B.$().outerWidth();});};d.prototype._getButtonWidth=function(b){var B=b.length,w,n=0,s=0,e=0,p,P,i=0;if(this._bCustomButtonWidth){while(i<B){w=b[i].getWidth();if(w){if(w.indexOf("%")!==-1){s+=parseInt(w.slice(0,-1),10);}else{e+=parseInt(w.slice(0,-2),10);}}else{n++;}i++;}if(n===0){return false;}p=(100-s)/n;P=(e/n);if(p<0){p=0;}if(P<0){P=0;}if(P>0){return"calc("+p+"% - "+P+"px)";}else{return p+"%";}}else{return(100/B)+"%";}};d.prototype._updateWidth=function(){if(this.$().length===0||this.hasStyleClass("sapMSegmentedButtonNoAutoWidth")){return;}var s=this.getWidth(),b=this._getVisibleButtons(),B=b.length,m=(this._aWidths.length>0)?Math.max.apply(Math,this._aWidths):0,e=(100/B),p=this.$().parent().innerWidth(),w=this._getButtonWidth(b),o,i;if(!s){if((m*B)>p){this.$().css("width","100%");}else if(m>0){this.$().width((m*B)+1);}i=0;while(i<B){o=b[i];o.$().css("width",o.getWidth()?o.getWidth():w);i++;}}else if(s&&!this._bCustomButtonWidth){i=0;while(i<B){b[i].$().css("width",e+"%");i++;}}};d.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}this._bCustomButtonWidth=null;this._aWidths=null;};d.prototype._setItemNavigation=function(){var b,D=this.getDomRef();if(D){this._oItemNavigation.setRootDomRef(D);b=this.$().find(".sapMSegBBtn:not(.sapMSegBBtnDis)");this._oItemNavigation.setItemDomRefs(b);this._focusSelectedButton();}};d.prototype.createButton=function(t,u,e,T){var b=new sap.m.Button();if(t!==null){b.setText(t);}if(u!==null){b.setIcon(u);}if(e||e===undefined){b.setEnabled(true);}else{b.setEnabled(false);}if(T){b.setTextDirection(T);}this.addButton(b);return b;};(function(){d.prototype.addButton=function(b){if(b){p(b,this);this.addAggregation('buttons',b);this._syncSelect();this._fireChangeEvent();return this;}};d.prototype.insertButton=function(b,i){if(b){p(b,this);this.insertAggregation('buttons',b,i);this._syncSelect();this._fireChangeEvent();return this;}};function p(b,P){b.attachPress(function(e){P._buttonPressed(e);});b.attachEvent("_change",P._syncSelect,P);b.attachEvent("_change",P._fireChangeEvent,P);var o=sap.m.Button.prototype.setEnabled;b.setEnabled=function(e){b.$().toggleClass("sapMSegBBtnDis",!e).toggleClass("sapMFocusable",e);o.apply(b,arguments);};b.setVisible=function(v){sap.m.Button.prototype.setVisible.apply(this,arguments);P.invalidate();};}})();d.prototype.getSelectedKey=function(){var b=this.getButtons(),e=this.getItems(),s=this.getSelectedButton(),i=0;if(e.length>0){for(;i<b.length;i++){if(b[i]&&b[i].getId()===s){this.setProperty("selectedKey",e[i].getKey(),true);return e[i].getKey();}}}return"";};d.prototype.setSelectedKey=function(k){var b=this.getButtons(),e=this.getItems(),i=0;if(!k){this.setProperty("selectedKey",k,true);return this;}if(e.length>0&&b.length>0){for(;i<e.length;i++){if(e[i]&&e[i].getKey()===k){this.setSelectedItem(e[i]);break;}}}this.setProperty("selectedKey",k,true);return this;};d.prototype.removeButton=function(b){var r=this.removeAggregation("buttons",b);if(r){delete r.setEnabled;r.detachEvent("_change",this._syncSelect,this);r.detachEvent("_change",this._fireChangeEvent,this);this._syncSelect();}return r;};d.prototype.removeAllButtons=function(){var b=this.getButtons();if(b){for(var i=0;i<b.length;i++){var B=b[i];if(B){delete B.setEnabled;this.removeAggregation("buttons",B);B.detachEvent("_change",this._syncSelect,this);B.detachEvent("_change",this._fireChangeEvent,this);}}this._syncSelect();}return b;};d.prototype.addItem=function(i){this.addAggregation("items",i);this.addButton(i.oButton);return this;};d.prototype.removeItem=function(i){var r;if(i!==null&&i!==undefined){r=this.removeAggregation("items",i);this.removeButton(i.oButton);}if(i&&i instanceof sap.m.SegmentedButtonItem&&this.getSelectedButton()===i.oButton.getId()){this.setSelectedKey("");this.setSelectedButton("");this.setSelectedItem("");}this.setSelectedItem(this.getItems()[0]);return r;};d.prototype.insertItem=function(i,b){this.insertAggregation("items",i,b);this.insertButton(i.oButton,b);return this;};d.prototype.removeAllItems=function(s){var r=this.removeAllAggregation("items",s);this.removeAllButtons();this.setSelectedKey("");this.setSelectedButton("");this.setSelectedItem("");return r;};d.prototype._buttonPressed=function(e){var b=e.getSource(),i;if(this.getSelectedButton()!==b.getId()){this.getButtons().forEach(function(B){B.$().removeClass("sapMSegBBtnSel");B.$().attr("aria-checked",false);});i=this.getItems().filter(function(o){return o.oButton===b;})[0];b.$().addClass("sapMSegBBtnSel");b.$().attr("aria-checked",true);this.setAssociation('selectedButton',b,true);this.setProperty("selectedKey",this.getSelectedKey(),true);this.setAssociation('selectedItem',i,true);this.fireSelectionChange({item:i});this.fireSelect({button:b,id:b.getId(),key:this.getSelectedKey()});}};d.prototype._selectDefaultButton=function(){var b=this._getVisibleButtons();if(b.length>0){this.setAssociation('selectedButton',b[0],true);if(this.getItems().length>0){this.setAssociation('selectedItem',this.getItems()[0],true);}}};d.prototype.setSelectedButton=function(b){var s=this.getSelectedButton(),o,B=this.getButtons();this.setAssociation("selectedButton",b,true);if(s!==this.getSelectedButton()){if(this.$().length){if(!this.getSelectedButton()&&B.length>1){this._selectDefaultButton();}o=sap.ui.getCore().byId(this.getSelectedButton());B.forEach(function(e){e.$().removeClass("sapMSegBBtnSel");e.$().attr("aria-checked",false);});if(o){o.$().addClass("sapMSegBBtnSel");o.$().attr("aria-checked",true);}this._focusSelectedButton();}}this._syncSelect();return this;};d.prototype.setSelectedItem=function(i){var o=typeof i==="string"&&i!==""?sap.ui.getCore().byId(i):i,b=o instanceof sap.m.SegmentedButtonItem,B=b?o.oButton:i;this.setAssociation("selectedItem",i,true);this.setSelectedButton(B);return this;};d.prototype._focusSelectedButton=function(){var b=this.getButtons(),s=this.getSelectedButton(),i=0;for(;i<b.length;i++){if(b[i]&&b[i].getId()===s){this._oItemNavigation&&this._oItemNavigation.setFocusedIndex(i);break;}}};d.prototype.onsappagedown=function(e){this._oItemNavigation.onsapend(e);};d.prototype.onsappageup=function(e){this._oItemNavigation.onsaphome(e);};d.prototype._lazyLoadSelectForm=function(){var s=this.getAggregation("_select");if(!s){s=new sap.m.Select(this.getId()+"-select");s.attachChange(this._selectChangeHandler,this);s.addStyleClass("sapMSegBSelectWrapper");this.setAggregation("_select",s,true);}};d.prototype._selectChangeHandler=function(e){var s=e.getParameter("selectedItem"),n=parseInt(s.getKey(),10),b=this.getButtons()[n],B=b.getId();b.firePress();this.setSelectedButton(B);};d.prototype._fireChangeEvent=function(){this.fireEvent("_change");};d.prototype._syncSelect=function(){var k=0,s=0,b,o=this.getAggregation("_select");if(!o){return;}o.destroyItems();this._getVisibleButtons().forEach(function(B){b=B.getText();o.addItem(new a({key:k.toString(),text:b?b:B.getTooltip_AsString(),enabled:B.getEnabled()}));if(B.getId()===this.getSelectedButton()){s=k;}k++;},this);o.setSelectedKey(s.toString());};d.prototype._toSelectMode=function(){this._bInOverflow=true;this.addStyleClass("sapMSegBSelectWrapper");this._lazyLoadSelectForm();this._syncSelect();};d.prototype._toNormalMode=function(){delete this._bInOverflow;this.removeStyleClass("sapMSegBSelectWrapper");this.getAggregation("_select").removeAllItems();this.destroyAggregation("_select");};d.prototype._overwriteImageOnload=function(i){var t=this;if(i.onload===sap.m.Image.prototype.onload){i.onload=function(){if(sap.m.Image.prototype.onload){sap.m.Image.prototype.onload.apply(this,arguments);}window.setTimeout(function(){t._updateWidth();},20);};}};d.prototype._getIconAriaLabel=function(i){var o=c.getIconInfo(i.getSrc()),r="";if(o&&o.name){r=o.name;}return r;};d.prototype._getVisibleButtons=function(){return this.getButtons().filter(function(b){return b.getVisible();});};d.prototype.clone=function(){var s=this.getSelectedButton(),B=this.removeAllAggregation("buttons"),o=C.prototype.clone.apply(this,arguments),e=B.map(function(b){return b.getId();}).indexOf(s),i;if(e>-1){o.setSelectedButton(o.getButtons()[e]);}for(i=0;i<B.length;i++){this.addAggregation("buttons",B[i]);}return o;};return d;});
