/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./SliderUtilities'],function(S){"use strict";var a={};a.CSS_CLASS="sapMSlider";a.render=function(r,s){var e=s.getEnabled(),t=s.getTooltip_AsString(),C=a.CSS_CLASS;r.write("<div");this.addClass(r,s);if(!e){r.addClass(C+"Disabled");}r.addStyle("width",s.getWidth());r.writeClasses();r.writeStyles();r.writeControlData(s);if(t&&s.getShowHandleTooltip()){r.writeAttributeEscaped("title",t);}r.write(">");r.write('<div');r.writeAttribute("id",s.getId()+"-inner");this.addInnerClass(r,s);if(!e){r.addClass(C+"InnerDisabled");}r.writeClasses();r.writeStyles();r.write(">");if(s.getProgress()){this.renderProgressIndicator(r,s);}this.renderHandles(r,s);r.write("</div>");if(s.getEnableTickmarks()){this.renderTickmarks(r,s);}else{this.renderLabels(r,s);}if(s.getName()){this.renderInput(r,s);}r.write("</div>");};a.renderProgressIndicator=function(r,s){r.write("<div");r.writeAttribute("id",s.getId()+"-progress");this.addProgressIndicatorClass(r,s);r.addStyle("width",s._sProgressValue);r.writeClasses();r.writeStyles();r.write(' aria-hidden="true"></div>');};a.renderHandles=function(r,s){this.renderHandle(r,s,{id:s.getId()+"-handle"});};a.renderHandle=function(r,s,o){var e=s.getEnabled();r.write("<span");if(o&&(o.id!==undefined)){r.writeAttributeEscaped("id",o.id);}r.writeAttribute("aria-labelledby",s.getAggregation("_handlesLabels")[0].getId());if(s.getShowHandleTooltip()&&!s.getShowAdvancedTooltip()){this.writeHandleTooltip(r,s);}if(s.getInputsAsTooltips()){r.writeAttribute("aria-controls",s.getAggregation("_tooltips")[0].getId());}this.addHandleClass(r,s);r.addStyle(sap.ui.getCore().getConfiguration().getRTL()?"right":"left",s._sProgressValue);this.writeAccessibilityState(r,s);r.writeClasses();r.writeStyles();if(e){r.writeAttribute("tabindex","0");}r.write("></span>");};a.writeHandleTooltip=function(r,s){r.writeAttribute("title",s.toFixed(s.getValue()));};a.renderInput=function(r,s){r.write('<input type="text"');r.writeAttribute("id",s.getId()+"-input");r.addClass(a.CSS_CLASS+"Input");if(!s.getEnabled()){r.write("disabled");}r.writeClasses();r.writeAttributeEscaped("name",s.getName());r.writeAttribute("value",s.toFixed(s.getValue()));r.write("/>");};a.writeAccessibilityState=function(r,s){r.writeAccessibilityState(s,{role:"slider",orientation:"horizontal",valuemin:s.toFixed(s.getMin()),valuemax:s.toFixed(s.getMax()),valuenow:s.toFixed(s.getValue())});};a.renderTickmarks=function(r,s){var i,t,T,l,f,b,c,o=s.getAggregation("scale");if(!s.getEnableTickmarks()||!o){return;}b=Math.abs(s.getMin()-s.getMax());c=s.getStep();l=o.getTickmarksBetweenLabels();t=o.calcNumTickmarks(b,c,S.CONSTANTS.TICKMARKS.MAX_POSSIBLE);T=s._getPercentOfValue(o.calcTickmarksDistance(t,s.getMin(),s.getMax(),c));r.write("<ul class=\""+a.CSS_CLASS+"Tickmarks\">");this.renderTickmarksLabel(r,s,s.getMin());for(i=0;i<t;i++){if(l&&i>0&&(i%l===0)){f=i*T;this.renderTickmarksLabel(r,s,s._getValueOfPercent(f));}r.write("<li class=\""+a.CSS_CLASS+"Tick\" style=\"width: "+T+"%;\"></li>");}r.write("<li class=\""+a.CSS_CLASS+"Tick\" style=\"width: 0%;\"></li>");this.renderTickmarksLabel(r,s,s.getMax());r.write("</ul>");};a.renderTickmarksLabel=function(r,s,v){var o=s._getPercentOfValue(v);var l=sap.ui.getCore().getConfiguration().getRTL()?"right":"left";v=s.toFixed(v,s.getDecimalPrecisionOfNumber(s.getStep()));r.write("<li class=\""+a.CSS_CLASS+"TickLabel\"");r.addStyle(l,(o+"%"));r.writeStyles();r.write(">");r.write("<div class=\""+a.CSS_CLASS+"Label\">");r.writeEscaped(""+v);r.write("</div>");r.write("</li>");};a.addClass=function(r,s){r.addClass(a.CSS_CLASS);};a.addInnerClass=function(r,s){r.addClass(a.CSS_CLASS+"Inner");};a.addProgressIndicatorClass=function(r,s){r.addClass(a.CSS_CLASS+"Progress");};a.addHandleClass=function(r,s){r.addClass(a.CSS_CLASS+"Handle");};a.renderLabels=function(r,s){s.getAggregation("_handlesLabels").forEach(r.renderControl);};return a;},true);
