/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ListBase','./TreeItemBase','./library','sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','sap/ui/model/odata/ODataTreeBinding','sap/ui/model/odata/v2/ODataTreeBinding','sap/ui/model/ClientTreeBinding','./TreeRenderer'],function(q,L,T,l,C,a,O,V,b,c){"use strict";var d=L.extend("sap.m.Tree",{metadata:{library:"sap.m",events:{toggleOpenState:{parameters:{itemIndex:{type:"int"},itemContext:{type:"object"},expanded:{type:"boolean"}}}}}});d.prototype.isTreeBinding=function(n){return(n=="items");};d.prototype.getBinding=function(n){n=n||"items";var B=L.prototype.getBinding.call(this,n);if(B&&n==="items"&&!B.getLength){if(O&&B instanceof O){a(B,this);}else if(V&&B instanceof V){B.applyAdapterInterface();}else if(b&&B instanceof b){C.apply(B);}else{q.sap.log.error("TreeBinding is not supported for the control "+this);}}return B;};d.prototype.updateAggregation=function(n){if(n!="items"){return L.prototype.updateAggregation.apply(this,arguments);}var B=this.getBindingInfo("items"),o=this.getBinding("items"),f=B.factory,e;function u(g,e){var h=g.getItems()||[],j,k;if(h.length>e.length){for(var i=e.length;i<h.length;i++){g.removeItem(h[i]);h[i].destroy("KeepDom");}}for(var i=0;i<e.length;i++){j=e[i];k=h[i];if(k){k.setBindingContext(j,B.model);}else{k=f(g.getId()+"-"+i,j);k.setBindingContext(j,B.model);g.addItem(k);}}}e=o.getContexts(0);if(!B.template){this.destroyItems();}u(this,e);};d.prototype.validateAggregation=function(A,o,m){var r=L.prototype.validateAggregation.apply(this,arguments);if(A==="items"&&!(o instanceof T)){throw new Error(o+" is not a valid items aggregation of "+this+". Items aggregation in Tree control only supports TreeItemBase-based objects, e.g. StandardTreeItem.");}return r;};d.prototype.onItemExpanderPressed=function(i,e){var I=this.indexOfItem(i);var B=this.getBindingInfo("items");var o=i&&i.getBindingContext(B.model);if(B&&o){var E=i.getExpanded();var f;if(e==undefined){this.getBinding("items").toggleIndex(I);}else if(e){this.getBinding("items").expand(I);}else{this.getBinding("items").collapse(I);}f=i.getExpanded();if(f&&(i.getLevel()+1>this.getDeepestLevel())){this._iDeepestLevel=i.getLevel()+1;}if(E!==f&&!i.isLeaf()){this.fireToggleOpenState({itemIndex:I,itemContext:o,expanded:f});}}};d.prototype.setGrowing=function(){q.sap.log.error("Growing feature of "+this+" is not supported!");return this;};d.prototype.setGrowingThreshold=function(){q.sap.log.error("GrowingThreshold of "+this+" is not supported!");return this;};d.prototype.setGrowingTriggerText=function(){q.sap.log.error("GrowingTriggerText of "+this+" is not supported!");return this;};d.prototype.setGrowingScrollToLoad=function(){q.sap.log.error("GrowingScrollToLoad of "+this+" is not supported!");return this;};d.prototype.setGrowingDirection=function(){q.sap.log.error("GrowingDirection of "+this+" is not supported!");return this;};d.prototype.expandToLevel=function(i){var B=this.getBinding("items");if(B&&B.expandToLevel&&B.getNumberOfExpandedLevels){if(B.getNumberOfExpandedLevels()>i){B.collapseToLevel(0);}B.expandToLevel(i);}return this;};d.prototype.getNumberOfExpandedLevel=function(){return this.getBinding("items").getNumberOfExpandedLevels();};d.prototype.getDeepestLevel=function(){if(this._iDeepestLevel===undefined){this._iDeepestLevel=this.getNumberOfExpandedLevel();}return this._iDeepestLevel;};d.prototype.collapseAll=function(){var B=this.getBinding("items");if(B){B.collapseToLevel(0);}return this;};d.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TREE");};d.prototype.getAccessbilityPosition=function(i){var s,p,n=i.getItemNodeContext();if(n.parent){s=n.parent.children.length;}if(n.positionInParent){p=n.positionInParent+1;}return{setSize:s,posInset:p};};d.prototype.onItemLongDragOver=function(i){var I=this.indexOfItem(i);this.getBinding("items").expand(I);};d.prototype.isGrouped=function(){return false;};return d;});
